;; ----------------------------------------------------------------------------
;; combat-maps.scm - terrain combat maps
;;
;; Pre: terrain.scm, palette.scm
;; ----------------------------------------------------------------------------

(kern-mk-map 
 'm_forest_combat ;; tag
 19               ;; width
 19               ;; height;
 pal_expanded     ;; palette
 (list
		".. .. .. .. tb || || || || tt || || || || td .. .. .. .. "
		".. .. .. .. bb || || || tc t& ta || || || bb .. .. .. .. "
		".. .. tC tb || || || tc t# .. t% ta || || || td tA .. .. "
		".. .. t7 bb || || tt tB .. .. .. tD tt || || bb t7 .. .. "
		"t7 bb || || || || || t5 tA .. tC t3 || || || || || bb t7 "
		"|| || || || || || || || tt tt tt || || || || || || || || "
		"|| || || tt || || || || || || || || || || || tt || || || "
		"|| || tc t& ta || || || bb tt tt || || || tc t& ta || || "
		"|| tc t# .. t% tt || tt tt tt tt bb || tt t# .. t% ta || "
		"tt tB .. .. .. tt || tt tt tt tt tt || tt .. .. .. tD tt "
		"|| t5 tA .. tC tt || bb tt tt tt tt || tt tA .. tC t3 || "
		"|| || t5 tE t3 || || || tt tt bb || || || t5 tE t3 || || "
		"|| || || tt || || || || || || || || || || || tt || || || "
		"|| || || || || || || || tt tt tt || || || || || || || || "
		"te bb || || || || || tc t# .. t% ta || || || || || bb te "
		".. .. te bb || || tt tB .. .. .. tD tt || || bb te .. .. "
		".. .. t% tb || || || t5 tA .. tC t3 || || || td t# .. .. "
		".. .. .. .. bb || || || t5 tE t3 || || || bb .. .. .. .. "
		".. .. .. .. tb || || || || tt || || || || td .. .. .. .. "  ))

(mk-combat-map
 'm_tree_combat
		"|# || || || || || tt t5 tA .. .. tb tt tt tt || || || |% "
		"|| || || || || || || tt t5 tA .. t% ta tt tt || || || || "
		"|| || || tt tt || || tt tt t5 .. .. t% ta tt tt || || || "
		"|| || tt tt tt tt tt tt tt tc .. .. .. t% tt tt tt || || "
		"tt tt tt tt tc t# .. t% te t# .. .. .. .. ta tt tt || || "
		"tt tt tc t# .. .. .. .. .. .. .. .. .. .. t% tt || || || "
		"tt tc t# .. .. .. .. .. .. tC t3 t5 .. .. .. tt || || tt "
		"te t# .. .. .. .. t3 t5 tE t3 tt tc .. .. tC tt tt tt tc "
		".. .. .. .. .. .. ta tt tt tt tt tB .. .. tb tt tt tc t# "
		".. tC t3 t5 tA .. t% ta tt tt tt t5 tA .. t% ta tc t# .. "
		"tC t3 tt tt td .. .. tD tt tt tt tt t5 .. .. .. .. .. .. "
		"t3 tt tt tt t# .. .. t3 tt tc t& ta tc .. .. .. .. tC t7 "
		"tt || || tt .. .. .. ta tc t# .. .. .. .. .. .. tC t3 tt "
		"|| || || tt tA .. .. .. .. .. .. .. .. .. .. tC t3 tt tt "
		"|| || tt tt t5 .. .. .. .. tC t7 tA .. tC t3 tt tt tt tt "
		"|| || tt tt tt tA .. .. .. t3 tt tt tt tt tt tt tt || || "
		"|| || || tt tt t5 tA .. .. ta tt tt || || tt tt || || || "
		"|| || || || tt tt t5 tA .. t% ta tt || || || || || || || "
		"|A || || || tt tt tt td .. .. t% ta tt || || || || || |C "
)

(mk-combat-map 
 'm_grass_combat2
		"t3 tt tt tt tt td .. .. .. .. .. .. .. .. .. tb tt tt t5 "
		"tt tt tt tc tB .. .. .. .. .. .. t3 tt t5 tA t% tt tt tt "
		"tt tt tt bb t3 tt tt td .. .. .. ta tt tt t5 bb tt tt tt "
		"tt tt tt tt tc t# .. .. .. .. .. .. t% ta tt tt tt tt tt "
		"tt t# bb tt t# tC tf tA .. .. tC tf tA t% tt tt bb t% te "
		"tt .. tC tt .. tf bb tf .. .. tf bb tf .. tt tt tA .. .. "
		"te .. t3 tc .. t% tf t# .. .. t% tf t# .. ta tt tt t5 .. "
		".. .. te t# .. .. .. .. .. .. .. .. .. .. t% ta tt tc .. "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. tC tf tA .. .. .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. tf bb tf .. .. tC tf tA .. .. .. .. .. "
		".. .. tb td tA .. t% tf t# .. .. tf bb tf .. t3 t5 tA .. "
		".. .. .. bb t7 tA .. .. .. .. .. t% tf tB tC tt tt tt t5 "
		"t7 tA tC t3 tt t5 tA .. .. .. .. .. tD t3 tt tt tt tt tt "
		"tt tt tt tt tt tt t5 tA .. .. .. tC t3 tt tt tt tt tt tt "
		"tt tt tt tt tt tt tt t5 .. .. .. t3 tc bb tt tt bb tt tt "
		"tt tt tt tt tt bb t% te .. .. .. tt t# .. tt tt tt tt tt "
		"tt tt tt tt tt tA .. .. .. .. .. te .. tC tt tt tt tt tt "
		"ta tt tt tt tt tt td .. .. .. .. .. .. tb tt tt tt tt tc "
 )

(kern-mk-map 
 'm_hill_combat   ;; tag
 19               ;; width
 19               ;; height;
 pal_expanded     ;; palette
 (list
		"^^ ^^ ^^ ^^ ^^ {{ {{ {2 .. .. .. {4 {{ {{ ^^ ^^ ^^ ^^ ^^ "
		"^^ ^^ ^^ ^^ ^^ {{ {3 .. .. .. .. .. {5 {{ ^^ ^^ ^^ ^^ ^^ "
		"^^ ^^ ^^ ^^ {{ {{ {a .. .. .. .. .. {c {{ {{ ^^ ^^ ^^ ^^ "
		"^^ ^^ ^^ {{ {{ {{ {{ {a .. .. .. {c {{ {{ {{ {{ ^^ ^^ ^^ "
		"^^ ^^ {{ {{ ^^ ^^ {{ {{ {a .. {c {{ {{ ^^ ^^ {{ {{ ^^ ^^ "
		"{{ {{ {{ {{ ^^ ^^ ^^ {{ {{ {6 {{ {{ ^^ ^^ ^^ {{ {{ {{ {{ "
		"{{ {3 {5 {{ {{ ^^ ^^ {{ {3 {8 {5 {{ ^^ ^^ {{ {{ {3 {5 {{ "
		"{1 .. .. {5 {{ {{ {{ {3 {c {{ {a {5 {{ {{ {{ {3 .. .. {1 "
		".. .. .. .. {5 {{ {3 {c {{ {{ {{ {a {5 {{ {3 .. .. .. .. "
		".. .. .. .. .. {9 {4 {{ {{ ^^ {{ {{ {2 {9 .. .. .. .. .. "
		".. .. .. .. {c {{ {a {d {{ {{ {{ {3 {c {{ {a .. .. .. .. "
		"{8 .. .. {c {{ {{ {{ {{ {7 {{ {3 {c {{ {{ {{ {a .. .. {8 "
		"{{ {a {c {{ {{ ^^ ^^ {{ {a {1 {c {{ ^^ ^^ {{ {{ {a {c {{ "
		"{{ {{ {{ {{ ^^ ^^ ^^ {{ {{ {6 {{ {{ ^^ ^^ ^^ {{ {{ {{ {{ "
		"^^ ^^ {{ {{ ^^ ^^ {{ {{ {3 .. {5 {{ {{ ^^ ^^ {{ {{ ^^ ^^ "
		"^^ ^^ ^^ {{ {{ {{ {{ {3 .. .. .. {5 {{ {{ {{ ^^ ^^ ^^ ^^ "
		"^^ ^^ ^^ ^^ {{ {{ {3 .. .. .. .. .. {5 {{ {{ ^^ ^^ ^^ ^^ "
		"^^ ^^ ^^ ^^ ^^ {{ {a .. .. .. .. .. {c {{ ^^ ^^ ^^ ^^ ^^ "
		"^^ ^^ ^^ ^^ ^^ {{ {{ {2 .. .. .. {4 {{ {{ ^^ ^^ ^^ ^^ ^^ "
  ))

(kern-mk-map 
 'm_trail_0_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. .. .. .. .. .. tf .. .. .. .. .. "
		".. .. tC tf tA .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tC t7 bb tf .. .. tf .. .. .. .. .. .. .. .. .. .. .. "
		".. t3 tt t5 t# .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. te bb te .. .. .. .. .. .. .. .. .. .. .. .. .. tC t7 "
		".. t% tf t# .. .. .. .. .. .. .. tf .. .. .. .. .. tb tt "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. t% te "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tf .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f "
		".. .. .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f "
		".. .. .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. tf .. /f /f /f .. .. .. .. .. bb .. .. "
		".. t3 t5 .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. ta tc .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tf "
    ))

(kern-mk-map 
 'm_trail_1_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. .. .. .. .. .. tf .. .. .. .. .. "
		".. .. tC tf tA .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tC t7 bb tf .. .. tf .. .. .. .. .. .. .. .. .. .. .. "
		".. t3 tt t5 t# .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. te bb te .. .. .. .. .. .. .. .. .. .. .. .. .. tC t7 "
		".. t% tf t# .. .. .. .. .. .. .. tf .. .. .. .. .. tb tt "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. t% te "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. tf .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. tf .. /f /f /f .. .. .. .. .. bb .. .. "
		".. t3 t5 .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. ta tc .. .. .. .. .. /f /f /f tf .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tf "
    ))

(kern-mk-map 
 'm_trail_2_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. .. .. .. .. .. tf .. .. .. .. .. "
		".. .. tC tf tA .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tC t7 bb tf .. .. tf .. .. .. .. .. .. .. .. .. .. .. "
		".. t3 tt t5 t# .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. te bb te .. .. .. .. .. .. .. .. .. .. .. .. .. tC t7 "
		".. t% tf t# .. .. .. .. .. .. .. tf .. .. .. .. .. tb tt "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. t% te "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. .. "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. tf .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. tf .. /f /f /f .. .. .. .. .. bb .. .. "
		".. t3 t5 .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. ta tc .. .. .. .. .. /f /f /f tf .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tf "
    ))

(kern-mk-map 
 'm_trail_3_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. .. .. .. .. .. tf .. .. .. .. .. "
		".. .. .. tf .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tf "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. tf .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. tf .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. tf .. /f /f /f .. .. .. .. .. bb .. .. "
		".. t3 t5 .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. ta tc .. .. .. .. .. /f /f /f tf .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. t7 "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. te "
    ))

(kern-mk-map 
 'm_trail_4_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. tf .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. tf .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f "
		".. .. .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f "
		".. .. .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. tf .. /f /f /f .. .. .. .. .. bb .. .. "
		".. t3 t5 .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. ta tc .. .. .. .. .. /f /f /f tf .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tf "
    ))

(kern-mk-map 
 'm_trail_5_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. tf .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. tf .. /f /f /f .. .. .. .. .. bb .. .. "
		".. t3 t5 .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. ta tc .. .. .. .. .. /f /f /f tf .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tf "
    ))

(kern-mk-map 
 'm_trail_6_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. tf .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. tf .. /f /f /f .. .. .. .. .. bb .. .. "
		".. t3 t5 .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. ta tc .. .. .. .. .. /f /f /f tf .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tf "
    ))

(kern-mk-map 
 'm_trail_7_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. tf .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. tf .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. tf .. /f /f /f .. .. .. .. .. bb .. .. "
		".. t3 t5 .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. ta tc .. .. .. .. .. /f /f /f tf .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tf "
    ))

(kern-mk-map 
 'm_trail_8_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. tf .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. tf .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f "
		".. .. .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f "
		".. .. .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f "
		".. .. .. .. .. .. .. .. .. .. .. .. .. tf .. .. .. .. .. "
		".. .. tC tf tA .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tC t7 bb tf .. .. tf .. .. .. .. .. .. .. .. .. .. .. "
		".. t3 tt t5 t# .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. te bb te .. .. .. .. .. .. .. .. .. .. .. .. .. tC t7 "
		".. t% tf t# .. .. .. .. .. .. .. tf .. .. .. .. .. tb tt "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. t% te "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
    ))

(kern-mk-map 
 'm_trail_9_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. tf .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		".. .. .. .. .. .. .. .. .. .. .. .. .. tf .. .. .. .. .. "
		".. .. tC tf tA .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tC t7 bb tf .. .. tf .. .. .. .. .. .. .. .. .. .. .. "
		".. t3 tt t5 t# .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. te bb te .. .. .. .. .. .. .. .. .. .. .. .. .. tC t7 "
		".. t% tf t# .. .. .. .. .. .. .. tf .. .. .. .. .. tb tt "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. t% te "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
    ))

(kern-mk-map 
 'm_trail_a_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. tf .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. .. .. .. .. .. tf .. .. .. .. .. "
		".. .. tC tf tA .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tC t7 bb tf .. .. tf .. .. .. .. .. .. .. .. .. .. .. "
		".. t3 tt t5 t# .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. te bb te .. .. .. .. .. .. .. .. .. .. .. .. .. tC t7 "
		".. t% tf t# .. .. .. .. .. .. .. tf .. .. .. .. .. tb tt "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. t% te "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
    ))

(kern-mk-map 
 'm_trail_b_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. tf .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"tf .. .. .. .. .. .. .. /f /f /f .. .. .. .. tf .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. tf .. /f /f /f .. .. .. .. .. bb .. .. "
		".. t3 t5 .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. ta tc .. .. .. .. .. /f /f /f tf .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tf "
		".. .. .. .. .. .. .. .. .. .. .. .. .. tf .. .. .. .. .. "
		".. .. .. tf .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tf "
    ))

(kern-mk-map 
 'm_trail_c_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. .. .. .. .. .. tf .. .. .. .. .. "
		".. .. tC tf tA .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tC t7 bb tf .. .. tf .. .. .. .. .. .. .. .. .. .. .. "
		".. t3 tt t5 t# .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. te bb te .. .. .. .. .. .. .. .. .. .. .. .. .. tC t7 "
		".. t% tf t# .. .. .. .. .. .. .. tf .. .. .. .. .. tb tt "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. t% te "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. .. .. /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		".. .. .. /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		".. .. .. /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		".. tC t7 tA .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tb tt td .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. t% te t# .. .. .. .. .. .. .. .. .. .. .. .. .. .. tf "
		".. .. .. .. .. .. .. tC t7 tA .. .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. tb tt td .. .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. t% te t# .. .. .. .. .. .. .. tC t7 "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. t3 tt "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ta tc "
    ))

(kern-mk-map 
 'm_trail_d_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. tC t7 tA .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tb tt td .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. t% te t# .. .. .. .. .. .. .. .. .. .. .. .. .. .. tf "
		".. .. .. .. .. .. .. tC t7 tA .. .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. tb tt td .. .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. t% te t# .. .. .. .. .. .. .. tC t7 "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. t3 tt "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ta tc "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		".. .. .. .. .. .. .. .. .. .. .. .. .. tf .. .. .. .. .. "
		".. .. tC tf tA .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tC t7 bb tf .. .. tf .. .. .. .. .. .. .. .. .. .. .. "
		".. t3 tt t5 t# .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. te bb te .. .. .. .. .. .. .. .. .. .. .. .. .. tC t7 "
		".. t% tf t# .. .. .. .. .. .. .. tf .. .. .. .. .. tb tt "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. t% te "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
    ))

(kern-mk-map 
 'm_trail_e_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. tC t7 tA .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tb tt td .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. t% te t# .. .. .. .. .. .. .. .. .. .. .. .. .. .. tf "
		".. .. .. .. .. .. .. tC t7 tA .. .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. tb tt td .. .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. t% te t# .. .. .. .. .. .. .. tC t7 "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. t3 tt "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ta tc "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f .. .. .. "
		".. .. .. .. .. .. .. .. .. .. .. .. .. tf .. .. .. .. .. "
		".. .. tC tf tA .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tC t7 bb tf .. .. tf .. .. .. .. .. .. .. .. .. .. .. "
		".. t3 tt t5 t# .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. te bb te .. .. .. .. .. .. .. .. .. .. .. .. .. tC t7 "
		".. t% tf t# .. .. .. .. .. .. .. tf .. .. .. .. .. tb tt "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. t% te "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
    ))
    
(kern-mk-map 
 'm_trail_combat_base  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. .. .. .. .. .. tf .. .. .. .. .. "
		".. .. tC tf tA .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tC t7 bb tf .. .. .. t3 t5 .. .. .. .. .. .. bb .. .. "
		".. t3 tt t5 t# .. .. .. ta tc .. .. .. t3 t5 .. .. .. .. "
		".. te tt te .. .. .. .. .. .. .. .. .. ta tc .. .. t3 t5 "
		".. t% te t# .. .. .. .. .. .. .. tf .. .. .. .. .. tt tt "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ta tc "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. tf .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. t3 t5 .. .. .. "
		".. .. .. tb t5 tA .. .. /f /f /f .. .. .. ta tc .. .. .. "
		"tf .. .. t% tt t5 .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. .. .. .. ta tc .. .. .. .. .. .. .. .. .. .. .. .. .. "
		".. .. bb .. .. .. .. .. .. .. bb .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. .. .. .. .. .. t7 t7 tA .. .. .. "
		".. .. .. .. .. .. tf .. t3 t5 .. .. .. t7 t7 t7 .. .. .. "
		".. t3 t5 tA .. .. .. .. ta tc .. .. .. t7 bb t7 .. .. .. "
		".. ta tt td .. .. .. .. .. .. .. .. .. t% t7 t7 .. .. .. "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tf "
    ))  
    
(kern-mk-map 
 'm_trail_combat_base2  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. tb tt t5 tA .. .. .. .. tb t5 tA .. .. t3 td .. .. "
		".. .. t% ta tt td .. .. .. .. t% tt td .. tC tt t# .. .. "
		"tC t7 tA t% te t# .. bb tC t7 tE te t# tC t3 tt tA .. tf "
		"t3 tt t5 tA .. .. .. tC t3 tt td t# .. tb tt tt t5 tA .. "
		"ta tt tt td .. .. .. tb tt tc t# .. .. t% ta tt tt t5 tA "
		".. t% te tB .. .. .. .. .. .. .. .. tf .. .. t% ta tt t5 "
		".. .. t% tb t5 .. .. .. .. bb .. .. .. .. .. .. t% ta tc "
		".. .. .. t% tt tA .. .. .. .. .. .. .. .. t7 tA .. .. .. "
		".. .. bb .. ta t5 .. .. /f /f /f .. .. .. ta t5 tA .. .. "
		"t7 .. t7 tA t% te .. .. /f /f /f .. .. .. t% ta t5 tE t7 "
		"tt tE tt td .. .. .. .. /f /f /f .. .. .. .. bb tt tt tt "
		"ta tt tc t# bb .. .. .. .. .. .. .. .. tb t5 .. ta tt tc "
		"t% te t# .. .. .. .. .. .. .. .. .. .. t% te .. tD tt t# "
		".. .. .. .. .. .. .. t3 t5 tA .. tC tf .. .. .. t3 tt .. "
		".. .. .. tC t7 .. .. tt tt t5 tE tf t# .. .. bb tt tt tA "
		"t7 tA bb t3 tt tA .. ta tt tt t5 tB .. tf tE t3 tt tt t5 "
		"ta tt tt tt tt t5 tA .. t% ta tt t5 .. t% tb tt t& ta tc "
		"t% ta tt tc t& ta t5 tA .. .. bb te .. .. t% tt .. .. .. "
		".. t% te t# .. t% ta td .. .. .. .. .. .. .. te .. .. .. "
    ))  
 
(kern-mk-map 
 'm_trail_combat_road  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. /f /f /f .. .. tf .. .. .. .. .. "
		".. .. tC tf tA .. bb .. /f /f /f .. .. .. .. .. .. .. .. "
		".. tC t7 bb tf .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. t3 tt t5 t# .. .. .. /f /f /f .. bb t3 t5 .. .. .. .. "
		".. te tt te .. .. .. .. /f /f /f .. .. ta tc .. .. t3 t5 "
		".. t% te t# .. .. .. .. /f /f /f tf .. .. .. .. .. tt tt "
		".. .. bb .. .. .. bb .. /f /f /f .. .. bb .. .. bb ta tc "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		"/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f "
		".. bb .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. bb .. /f /f /f .. .. .. .. .. bb .. .. "
		".. .. bb .. .. .. .. .. /f /f /f .. bb .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. t7 t7 tA .. .. .. "
		".. .. .. .. .. .. tf .. /f /f /f .. .. t7 t7 t7 .. .. .. "
		".. t3 t5 tA .. .. .. .. /f /f /f .. .. t7 bb t7 .. .. .. "
		".. ta tt td .. .. bb .. /f /f /f .. bb t% t7 t7 .. .. .. "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tf "
    ))    
    
(kern-mk-map 
 'm_trail_combat_roadend  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		".. .. .. .. .. .. .. .. .. .. .. .. .. tf .. .. .. .. .. "
		".. .. tC tf tA .. .. .. .. /f .. .. .. .. .. .. .. .. .. "
		".. tC t7 bb tf .. .. .. /f .. /f .. .. .. .. .. bb .. .. "
		".. t3 tt t5 t# .. .. .. .. /f /f .. .. t3 t5 .. .. .. .. "
		".. te tt te .. .. .. .. .. /f .. .. .. ta tc .. .. t3 t5 "
		".. t% te t# .. .. .. .. /f .. .. .. .. .. .. .. .. tt tt "
		".. .. .. .. .. .. .. .. .. /f /f .. .. .. .. .. .. ta tc "
		".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. .. "
		".. .. .. .. /f .. /f /f /f /f /f /f .. .. /f .. .. .. .. "
		".. /f .. /f .. /f .. /f /f /f /f .. /f /f .. /f .. /f .. "
		".. .. /f .. .. .. /f .. /f /f /f /f /f .. /f .. /f .. .. "
		".. .. .. .. .. .. .. .. /f .. /f .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. /f /f .. .. .. .. .. .. .. .. .. "
		".. .. bb .. .. .. .. .. .. /f .. .. .. .. .. .. .. .. .. "
		".. .. .. .. .. .. .. .. .. .. /f .. .. t7 t7 tA .. .. .. "
		".. .. .. .. .. .. tf .. .. /f .. .. .. t7 t7 t7 .. .. .. "
		".. t3 t5 tA .. .. .. .. .. /f .. .. .. t7 bb t7 .. .. .. "
		".. ta tt td .. .. .. .. .. .. /f .. .. t% t7 t7 .. .. .. "
		".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tf "
    ))     
    

(kern-mk-map 
 'm_bridge_WE_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
		"tt tt tt t5 ~~ -- __ __ __ __ __ __ __ __ __ -- ~~ t3 tt "
		"tt tt tt tL ~~ -- __ __ __ __ __ __ __ __ -- -- ~c tt tt "
		"tt tt tt ~3 ~~ -- __ __ __ __ __ __ __ __ -- ~~ tG tt tt "
		"tt tt tt ~2 -- __ -- -- -- -- -- -- -- __ -- ~4 tt tt tt "
		"ta tt tc ~2 -- -- -- ~~ ~~ ~8 ~~ ~~ -- -- -- ~4 ta tt tc "
		".. .. .. ~2 -- -- ~~ ~c ~# .. ~% ~a ~~ -- -- ~4 .. .. .. "
		".. .. .. ~2 -- ~~ ~~ ~# t3 tt t5 ~% ~~ ~~ ~~ ~4 .. .. .. "
		".. oo .. ~2 ~~ oo ~~ .. te oo te .. ~~ oo ~~ ~4 .. oo .. "
		"/f ee ee ee ee ee ee ee ee ee ee ee ee ee ee ee ee ee /f "
		"/f ee ee ee ee ee ee ee ee ee ee ee ee ee ee ee ee ee /f "
		"/f ee ee ee ee ee ee ee ee ee ee ee ee ee ee ee ee ee /f "
		".. oo .. ~2 ~~ oo ~~ .. t7 oo t7 .. ~~ oo ~~ ~4 .. oo .. "
		".. .. .. ~2 ~~ ~~ ~~ ~A ta tt tc ~C ~~ ~~ ~~ ~4 .. .. .. "
		".. .. .. ~2 -- -- ~~ ~5 ~A .. ~C ~3 ~~ -- -- ~4 .. .. .. "
		"t3 tt t5 ~2 -- -- -- ~~ ~~ ~1 ~~ ~~ -- -- -- ~4 .. .. .. "
		"tt tt tt ~2 -- __ -- -- -- -- -- -- -- __ -- ~4 t3 tt t5 "
		"tt tt tt ~a ~~ -- __ __ __ __ __ __ __ __ -- ~~ tJ tt tt "
		"tt tt tt tH ~~ -- __ __ __ __ __ __ __ __ -- -- ~5 tt tt "
		"tt tt tt tc ~~ -- __ __ __ __ __ __ __ __ __ -- ~~ ta tt "
    ))

(mk-combat-map
 'm_bridge_NS_combat
		"tt tt tt tt tt td .. .. /f /f /f .. .. tb tt tt tt tt tt "
		"ta tt tt tt tc t# .. oo ee ee ee oo .. t% ta tt tt tt tc "
		".. .. .. .. .. .. .. .. ee ee ee .. .. .. .. .. .. .. .. "
		"~1 ~1 ~1 ~1 ~1 ~1 ~1 ~~ ee ee ee ~~ ~1 ~1 ~1 ~1 ~1 ~1 ~1 "
		"-- -- -- -- -- -- -- -- ee ee ee -- -- -- -- -- -- -- -- "
		"__ __ __ __ -- -- -- oo ee ee ee oo -- -- -- __ __ __ __ "
		"__ __ __ -- -- ~~ ~~ ~~ ee ee ee ~~ ~~ ~~ -- -- __ __ __ "
		"__ __ __ -- ~~ ~c ~# .. ee ee ee .. ~% ~a ~~ -- __ __ __ "
		"__ __ __ -- ~~ ~# t3 td ee ee ee tb t5 ~% ~~ -- __ __ __ "
		"__ __ __ -- ~4 .. tt oo ee ee ee oo tt .. ~2 -- __ __ __ "
		"__ __ __ -- ~~ ~A ta td ee ee ee tb tc ~C ~~ -- __ __ __ "
		"__ __ __ -- ~~ ~5 ~A .. ee ee ee .. ~C ~3 ~~ -- __ __ __ "
		"__ __ __ -- -- ~~ ~~ ~~ ee ee ee ~~ ~~ ~~ -- -- __ __ __ "
		"__ __ __ __ -- -- -- oo ee ee ee oo -- -- -- __ __ __ __ "
		"-- -- -- -- -- -- -- -- ee ee ee -- -- -- -- -- -- -- -- "
		"~8 ~8 ~8 ~8 ~8 ~8 ~8 ~~ ee ee ee ~~ ~8 ~8 ~8 ~8 ~8 ~8 ~8 "
		".. .. .. .. .. .. .. .. ee ee ee .. .. .. .. .. .. .. .. "
		"t3 tt tt tt t5 tA .. oo ee ee ee oo .. tC t3 tt tt tt t5 "
		"tt tt tt tt tt td .. .. /f /f /f .. .. tb tt tt tt tt tt "
)

(mk-combat-map
 'm_lava_bridge_NS_combat
		"^^ ^^ ^^ ^^ ^^ ^^ {{ {{ /f /f /f {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ "
		"^^ ^^ ^^ ^^ ^^ {{ {{ pp ,, ,, ,, pp {{ {{ ^^ ^^ ^^ ^^ ^^ "
		"{{ {{ {{ {{ {{ {{ {{ {D ,, ,, ,, {B {{ {{ {{ {{ {{ {{ {{ "
		"!! !! !! !! !! !! !! !! ,, ,, ,, !! !! !! !! !! !! !! !! "
		"!! !! !! !! !! !! !! !! ,, ,, ,, !! !! !! !! !! !! !! !! "
		"!_ !_ !_ !_ !! !! !! pp ,, ,, ,, pp !! !! !! !_ !_ !_ !_ "
		"!_ !_ !_ !! !! !! !! !! ,, ,, ,, !! !! !! !! !! !_ !_ !_ "
		"!_ !_ !_ !! !! !c {# {% ,, ,, ,, {# {% !a !! !! !_ !_ !_ "
		"!_ !_ !_ !! !! {# {{ ^^ ,, ,, ,, ^^ {{ {% !! !! !_ !_ !_ "
		"!_ !_ !_ !! !! {{ ^^ pp ,, ,, ,, pp ^^ {{ !! !! !_ !_ !_ "
		"!_ !_ !_ !! !! {A {{ ^^ ,, ,, ,, ^^ {{ {C !! !! !_ !_ !_ "
		"!_ !_ !_ !! !! !5 {A {C ,, ,, ,, {A {C !3 !! !! !_ !_ !_ "
		"!_ !_ !_ !! !! !! !! !! ,, ,, ,, !! !! !! !! !! !_ !_ !_ "
		"!_ !_ !_ !_ !! !! !! pp ,, ,, ,, pp !! !! !! !_ !_ !_ !_ "
		"!! !! !! !! !! !! !! !! ,, ,, ,, !! !! !! !! !! !! !! !! "
		"!! !! !! !! !! !! !! !! ,, ,, ,, !! !! !! !! !! !! !! !! "
		"{{ {{ {{ {{ {{ {{ {{ {D ,, ,, ,, {B {{ {{ {{ {{ {{ {{ {{ "
		"^^ ^^ ^^ ^^ ^^ {{ {{ pp ,, ,, ,, pp {{ {{ ^^ ^^ ^^ ^^ ^^ "
		"^^ ^^ ^^ ^^ ^^ ^^ {{ {{ /f /f /f {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ "
)

(mk-combat-map
 'm_bog_combat
		"t3 tt tt t5 .. %b %% %% ~b ~1 ~d %% %% %d .. t3 tt tt t5 "
		"tt tt tt tt tA .. %% %% %% ~e %% %% %% .. tC tt tt tt tt "
		"tt tt tt tt t5 .. %a %% %% %% %% %% %c .. t3 tt tt tt tt "
		"ta tt tt tt tt tA .. %% %% %% %% %% .. tC tt tt tt tt tc "
		".. t% ta tt tt t5 .. %% %% %% %% %% .. t3 tt tt tc t# .. "
		"%7 .. .. t% ta tc .. %% ~3 ~9 ~5 %% .. ta tc t# .. .. %7 "
		"%% %% %5 .. .. .. .. %% ~6 %% ~a ~5 .. .. .. .. %3 %% %% "
		"%% %% %% %% %% %% ~3 ~9 ~c %% %% ~6 %% %% %% %% %% %% %% "
		"~7 %% %% %% %% ~3 ~c %% %% %% %% ~a ~9 ~5 %% %% %% %% ~7 "
		"~2 ~d %% %% %% ~6 %% %% %% %% %% %% %% ~6 %% %% %% ~b ~4 "
		"~e %% %% %% %% ~a ~9 ~5 %% %% %% %% ~3 ~c %% %% %% %% ~e "
		"%% %% %% %% %% %% %% ~6 %% %% ~3 ~9 ~c %% %% %% %% %% %% "
		"%% %% %c .. .. .. .. ~a ~5 %% ~6 %% .. .. .. .. %a %% %% "
		"%e .. .. tC t3 t5 .. %% ~a ~9 ~c %% .. t3 t5 tA .. .. %e "
		".. tC t3 tt tt tc .. %% %% %% %% %% .. ta tt tt t5 tA .. "
		"t3 tt tt tt tt t# .. %% %% %% %% %% .. t% tt tt tt tt t5 "
		"tt tt tt tt tc .. %3 %% %% %% %% %% %5 .. ta tt tt tt tt "
		"tt tt tt tt t# .. %% %% %% ~7 %% %% %% .. t% tt tt tt tt "
		"ta tt tt tc .. %b %% %% ~b ~8 ~d %% %% %d .. ta tt tt tc "
 )

(mk-combat-map
 'm_mountain_combat
 "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
 "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
 "^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ ^^ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
 "^^ ^^ ^^ ^^ ^^ ^^ {{ {{ ^^ ^^ ^^ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ "
 "^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ "
 "^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {{ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ "
 "^^ ^^ ^^ {{ {{ {{ {{ {{ {{ ^^ {{ {{ {{ {{ {{ {{ ^^ ^^ ^^ "
 "^^ ^^ {{ {{ {{ {{ {{ {{ ^^ ^^ ^^ {{ {{ {{ {{ {{ {{ ^^ ^^ "
 "^^ {{ {{ ^^ {{ {{ {{ ^^ {{ ^^ {{ ^^ {{ {{ {{ ^^ {{ {{ ^^ "
 "^^ {{ ^^ ^^ ^^ {{ ^^ ^^ ^^ {{ ^^ ^^ ^^ {{ ^^ ^^ ^^ {{ ^^ "
 "^^ {{ {{ ^^ {{ {{ {{ ^^ {{ ^^ {{ ^^ {{ {{ {{ ^^ {{ {{ ^^ "
 "^^ ^^ {{ {{ {{ {{ {{ {{ ^^ ^^ ^^ {{ {{ {{ {{ {{ {{ ^^ ^^ "
 "^^ ^^ ^^ {{ {{ {{ {{ {{ {{ ^^ {{ {{ {{ {{ {{ {{ ^^ ^^ ^^ "
 "^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ {{ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ "
 "^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ "
 "^^ ^^ ^^ ^^ ^^ ^^ {{ {{ ^^ ^^ ^^ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ "
 "^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ ^^ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
 "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
 "^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ ^^ "
)

(mk-combat-map
 'm_shore_combat
  "-- -- -- -- -- -- ~~ ~~ ~~ -- -- -- -- -- ~~ ~~ -- -- -- "
  "~~ ~~ -- -- -- -- -- -- -- -- -- -- ~~ ~~ ~~ ~~ -- -- ~~ "
  "~~ ~~ ~~ ~~ -- -- -- -- -- -- ~~ ~~ ~~ ~~ ~~ -- -- ~~ ~~ "
  "~~ ~~ ~~ ~~ ~~ ~~ -- -- -- -- ~~ ~~ ~~ ~~ -- -- -- ~~ ~~ "
  "~~ ~~ ~~ ~~ ~~ ~~ ~~ -- -- -- -- -- -- -- -- -- ~~ ~~ ~~ "
  "~~ ~~ -- -- -- ~~ ~~ -- -- -- -- -- -- -- -- -- -- -- ~~ "
  "~~ -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- ~~ "
  "-- ~~ -- -- -- -- -- ~~ -- -- ~~ ~~ ~~ -- ~~ ~~ ~~ ~~ -- "
  "-- -- -- -- -- -- -- -- ~~ -- ~~ ~~ ~~ ~~ ~~ ~~ ~~ -- -- "
  "-- -- -- ~~ -- ~~ -- -- -- -- ~~ -- -- ~~ ~~ -- -- ~~ ~~ "
  "-- -- ~~ ~~ ~~ ~~ ~~ -- -- -- -- -- -- -- -- -- -- ~~ ~~ "
  "-- -- ~~ ~~ ~~ ~~ ~~ ~~ -- -- -- -- -- -- -- ~~ ~~ ~~ ~~ "
  "-- -- -- -- ~~ ~~ ~~ ~~ ~~ -- -- -- -- -- -- -- -- -- ~~ "
  "-- ~~ -- -- -- -- ~~ ~~ ~~ ~~ ~~ ~~ ~~ ~~ ~~ -- -- -- -- "
  "~~ ~~ -- -- -- -- -- ~~ ~~ ~~ ~~ ~~ ~~ ~~ ~~ ~~ ~~ ~~ -- "
  "-- ~~ ~~ ~~ ~~ ~~ ~~ ~~ ~~ -- -- -- -- ~~ ~~ ~~ ~~ ~~ -- "
  "-- ~~ -- -- -- ~~ ~~ ~~ ~~ -- -- -- ~~ ~~ ~~ ~~ -- -- -- "
  "-- ~~ -- -- -- -- -- -- -- -- -- -- ~~ -- ~~ -- -- -- -- "
  "-- -- -- -- -- -- -- ~~ ~~ ~~ ~~ -- -- -- -- -- -- -- -- "
)

(mk-combat-map
 'm_water_combat
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
  "-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "
)

(mk-combat-map
 'm_void_combat
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "
  "*. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. *. "

)

(mk-combat-map
 'm_lava_combat
	".. .. .. {8 .. !3 !5 .. .. .. .. {8 {4 {{ {{ {2 {4 {{ {2 "
	"!3 !5 {4 {{ {2 !! !! .. .. !f {4 {{ {2 {5 {C !3 !! !! !5 "
	"!! !! .. bb !! !! !! !! !5 .. .. bb !! !! !! !_ !_ !! !! "
	"!a !! !! !! !! !! !! !! !! !! !! !! !! !_ !_ !! !! !! !c "
	"{# {% !a !! !_ !! {4 {% !a !! !! !! !! !! !! !! .. .. .. "
	"{{ {{ {2 !! !_ !! !5 {1 {4 {{ {{ {a !a !! !! !! .. .. {8 "
	"{5 {{ {2 !! !_ !! !c .. {4 {{ ^^ {{ {2 {8 !! !! .. {4 {{ "
	".. {9 !3 !! !_ !! .. {8 {4 {{ {{ {{ {6 {{ !a !! !5 .. {1 "
	"{4 {C !! !_ !! !c {4 {{ {2 {1 {1 {1 {4 {{ {2 !a !! bb .. "
	".. !3 !! !_ !! {# {2 {1 .. .. {8 .. .. {1 .. .. !! .. .. "
	"!3 !! !! !! !! {1 .. bb {8 {4 {{ {a !b !5 .. {8 !! !5 .. "
	"!a !c {& !a !! !5 {4 {{ {{ !f {{ {{ {2 !e {4 {{ !! !! !5 "
	".. .. {1 .. !a !! .. {5 {{ {2 {1 {1 .. .. .. {1 !! !_ !! "
	".. !7 .. .. {8 !a !5 .. {1 .. .. .. .. !3 !! !! !! !! !c "
	".. !a bb {4 {{ {a !a !5 .. !3 !! !! !! !! !! !! !! !c .. "
	"{4 {{ {2 .. {5 {{ {2 !! !! !! !! !c {# {2 .. !! !! .. .. "
	"!3 !! !! !5 {4 {{ {2 !! !! !! !c .. {1 .. {8 !a !! !! !5 "
	"!a !! !! !! !5 {1 .. !! !c {# {2 .. !f {4 {{ {{ {2 !a !c "
	".. {4 {{ {2 !a !! !! !c .. {1 .. .. .. .. {5 {{ {6 {{ {2 "
)

(define (combat-off-to-dst off)
	(if (< off 0)
		0
		off)
	)
	
(define (combat-off-to-src off)
	(if (< off 0)
		(- off)
		0
		)
	)
	
(define (combat-off-to-src-max total off)
	(if (< off 0)
		total
		(- total off)
		)
	)
	
(define (combat-off-to-len total off)
	(if (< off 0)
		(+ total off)
		(- total off)
		)
	)
	
(define (combat-off-dst-pos total off pos)
	(let ((opos (+ off pos)))
		(cond ((> opos total) total)
				((< opos 0) 0)
				(else opos))
	))
	

(define (combat-map-basic place map-tag off-x off-y)
	(let* ((wid (kern-place-get-width place))
			(hgt (kern-place-get-height place)))
		(kern-blit-map (kern-place-get-terrain-map place)
			(combat-off-to-dst off-x) (combat-off-to-dst off-y)
			(eval map-tag)
			(combat-off-to-src off-x) (combat-off-to-src off-y)
			(combat-off-to-len wid off-x) (combat-off-to-len hgt off-y))	
	))

(define (combat-map-basic-handler map-tag)
	(lambda (place our_terrain other_terrain off_x off_y map_x map_y)
		(combat-map-basic place map-tag off_x off_y)
		))			
		
(define combat-map-road-handler
	(lambda (place our_terrain other_terrain off_x off_y map_x map_y)
		(let* ((wid (kern-place-get-width place))
				(hgt (kern-place-get-height place))
				(min-y (combat-off-to-src off_y))
				(min-x (combat-off-to-src off_x))
				(max-y (combat-off-to-src-max hgt off_y))
				(max-x (combat-off-to-src-max wid off_x))
				(dstmap (kern-place-get-terrain-map place))
				)
			
			(define (combat-blit-road-part targ-list srcmap x1 x2 y1 y2)
				(if (and (in-list? our_terrain targ-list)
						(>= y2 min-y)
						(>= x2 min-x)
						(<= y1 max-y)
						(<= x1 max-x))
						(begin
					(kern-blit-map dstmap
						(combat-off-dst-pos wid off_x x1) (combat-off-dst-pos hgt off_y y1)
						srcmap
						(max x1 min-x) (max y1 min-y)
						(- (min x2 max-x) (max x1 min-x))
						(- (min y2 max-y) (max y1 min-y))
						))
				))
				
			(kern-blit-map dstmap 
				(combat-off-to-dst off_x) (combat-off-to-dst off_y)
				m_trail_combat_base
				min-x min-y 
				(combat-off-to-len wid off_x) (combat-off-to-len hgt off_y))
			;;north part
			(combat-blit-road-part
				(list t_trail_4 t_trail_5 t_trail_6 t_trail_7 t_trail_8 t_trail_9 t_trail_a t_trail_b)
				m_trail_combat_road
				6 13 0 8)
			;;west part
			(combat-blit-road-part
				(list t_trail_1 t_trail_2 t_trail_5 t_trail_6 t_trail_9 t_trail_a t_trail_d t_trail_e)
				m_trail_combat_road
				0 8 6 13)
			;;south part
			(combat-blit-road-part
				(list t_trail_0 t_trail_1 t_trail_2 t_trail_3 t_trail_4 t_trail_5 t_trail_6 t_trail_7)
				m_trail_combat_road
				6 13 11 20)
			;;east part
			(combat-blit-road-part
				(list t_trail_0 t_trail_1 t_trail_4 t_trail_5 t_trail_8 t_trail_9 t_trail_c t_trail_d)
				m_trail_combat_road
				11 20 6 13)
			;;north end
			(combat-blit-road-part
				(list t_trail_3)
				m_trail_combat_roadend
				6 13 0 8)
			;;west end
			(combat-blit-road-part
				(list t_trail_c)
				m_trail_combat_roadend
				0 8 6 13)
			;;south end
			(combat-blit-road-part
				(list t_trail_b)
				m_trail_combat_roadend
				6 13 11 20)
			;;east end
			(combat-blit-road-part
				(list t_trail_e)
				m_trail_combat_roadend
				11 20 6 13)
	))
	)
	
(map (lambda (kter)
	(kern-terrain-set-combat-handler kter combat-map-road-handler))
	(list t_trail_0 t_trail_1 t_trail_2 t_trail_3
	t_trail_4 t_trail_5 t_trail_6 t_trail_7
	t_trail_8 t_trail_9 t_trail_a t_trail_b
	t_trail_c t_trail_d t_trail_e t_trail_f)
)
	

(kern-terrain-set-combat-handler t_bridge_WE  (combat-map-basic-handler 'm_bridge_WE_combat))
(kern-terrain-set-combat-handler t_bridge_NS  (combat-map-basic-handler 'm_bridge_NS_combat))
(kern-terrain-set-combat-handler t_lava_bridge_NS (combat-map-basic-handler 'm_lava_bridge_NS_combat))

(define (combat-map-list target-map terrains)
	(let ((handler (combat-map-basic-handler target-map)))
	(map (lambda (kter)
		(kern-terrain-set-combat-handler kter handler))
		terrains
	)))
	
(combat-map-list 'm_grass_combat2
	(list 
	t_grass
	t_grassw_ne t_grassw_nw t_grassw_es t_grassw_ws
	t_grassw_nwe t_grassw_nes t_grassw_nws t_grassw_wes
	t_grassw_c
	t_hilledge_n t_hilledge_w t_hilledge_nw t_hilledge_e
	t_hilledge_ne t_hilledge_we t_hilledge_nwe t_hilledge_s
	t_hilledge_ns t_hilledge_ws t_hilledge_nws t_hilledge_es
	t_hilledge_nes t_hilledge_wes t_hilledge_c
	t_grassv_ne t_grassv_nw t_grassv_es t_grassv_ws
	t_grassv_nwe t_grassv_nes t_grassv_nws t_grassv_wes
	t_grasst_nw t_grasst_ne t_grasst_nwe t_grasst_ws
	t_grasst_nws t_grasst_es t_grasst_nes t_grasst_wes
	t_grasst_c
	)) 

(combat-map-list 'm_water_combat
	(list 
	t_wshore_n t_wshore_w t_wshore_nw t_wshore_e
	t_wshore_ne t_wshore_we t_wshore_nwe t_wshore_s
	t_wshore_ns t_wshore_ws t_wshore_nws t_wshore_es
	t_wshore_nes t_wshore_wes t_wshore_c
	t_dshore_n t_dshore_w t_dshore_nw t_dshore_e
	t_dshore_ne t_dshore_we t_dshore_nwe t_dshore_s
	t_dshore_ns t_dshore_ws t_dshore_nws t_dshore_es
	t_dshore_nes t_dshore_wes t_dshore_c
	))	

(combat-map-list 'm_tree_combat
	(list
	t_trees
	t_treew_ne t_treew_nw t_treew_es t_treew_ws
	t_treew_nwe t_treew_nes t_treew_nws t_treew_wes
	t_treew_c
	t_trees_nw t_trees_ne t_trees_nwe t_trees_ws
	t_trees_nws t_trees_es t_trees_nes t_trees_wes
	t_trees_c
	))	  

(combat-map-list 'm_hill_combat
	(list
	t_hills
	t_hillw_ne t_hillw_nw t_hillw_es t_hillw_ws 
	t_hillw_nwe  t_hillw_nes t_hillw_nws t_hillw_wes 
	t_hillw_c  
	t_hilli_ne t_hilli_nw t_hilli_es t_hilli_ws 
	t_hilli_nwe t_hilli_nes t_hilli_nws t_hilli_wes 
	t_hilli_c 
	t_hillv_ne t_hillv_nw t_hillv_es t_hillv_ws 
	t_hillv_nwe t_hillv_nes t_hillv_nws t_hillv_wes
	))	 

(combat-map-list 'm_mountain_combat
	(list 
	t_mountains
	t_mountw_ne t_mountw_nw t_mountw_es t_mountw_ws 
	t_mountw_nwe t_mountw_nes t_mountw_nws t_mountw_wes 
	t_mountw_c 
	t_mountg_ne t_mountg_nw t_mountg_es t_mountg_ws 
	t_mountg_nwe t_mountg_nes t_mountg_nws t_mountg_wes 
	t_mountg_c 
	t_mountv_ne t_mountv_nw t_mountv_es t_mountv_ws  
	t_mountv_nwe t_mountv_nes t_mountv_nws t_mountv_wes
	))

(combat-map-list 'm_bog_combat
	(list
	t_bog
	t_bog_nw t_bog_ne t_bog_nwe t_bog_ws 
	t_bog_nws t_bog_es t_bog_nes t_bog_wes 
	t_bog_c 
	))	

(combat-map-list 'm_forest_combat
	(list
	t_forest t_forest_d t_forest_l
	t_forestg_ne t_forestg_nw t_forestg_es t_forestg_ws
	t_forestg_nwe t_forestg_nes t_forestg_nws t_forestg_wes
	))

(combat-map-list 'm_void_combat
	(list
	t_voids_n t_voids_w t_voids_nw t_voids_e 
	t_voids_ne t_voids_we t_voids_nwe t_voids_s 
	t_voids_ns t_voids_ws t_voids_nws t_voids_es 
	t_voids_nes t_voids_wes t_voids_c 
	t_void t_stars t_chasm
	))

(combat-map-list 'm_lava_combat
	(list
	t_lava_n t_lava_w t_lava_nw t_lava_e 
	t_lava_ne t_lava_we t_lava_nwe t_lava_s 
	t_lava_ns t_lava_ws t_lava_nws t_lava_es 
	t_lava_nes t_lava_wes t_lava_c
	t_lava
	))
	
(combat-map-list 'm_shore_combat
	(list
	t_shore_n t_shore_w t_shore_nw t_shore_e
	t_shore_ne t_shore_we t_shore_nwe t_shore_s
	t_shore_ns t_shore_ws t_shore_nws t_shore_es
	t_shore_nes t_shore_wes t_shore_c
	t_shoals
	))
