/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzy;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;

public final class AdView
extends ViewGroup {
    private final zzy zznP;

    public AdView(Context context) {
        super(context);
        this.zznP = new zzy(this);
    }

    public AdView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.zznP = new zzy(this, attrs, false);
    }

    public AdView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.zznP = new zzy(this, attrs, false);
    }

    public void destroy() {
        this.zznP.destroy();
    }

    public AdListener getAdListener() {
        return this.zznP.getAdListener();
    }

    public AdSize getAdSize() {
        return this.zznP.getAdSize();
    }

    public String getAdUnitId() {
        return this.zznP.getAdUnitId();
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zznP.getInAppPurchaseListener();
    }

    public void loadAd(AdRequest adRequest) {
        this.zznP.zza(adRequest.zzaF());
    }

    public void pause() {
        this.zznP.pause();
    }

    public void resume() {
        this.zznP.resume();
    }

    public void setAdListener(AdListener adListener) {
        this.zznP.setAdListener(adListener);
        if (adListener != null && adListener instanceof zza) {
            this.zznP.zza((zza)((Object)adListener));
        } else if (adListener == null) {
            this.zznP.zza((zza)null);
        }
    }

    public void setAdSize(AdSize adSize) {
        this.zznP.setAdSizes(adSize);
    }

    public void setAdUnitId(String adUnitId) {
        this.zznP.setAdUnitId(adUnitId);
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        this.zznP.setInAppPurchaseListener(inAppPurchaseListener);
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        this.zznP.setPlayStorePurchaseParams(playStorePurchaseListener, publicKey);
    }

    public String getMediationAdapterClassName() {
        return this.zznP.getMediationAdapterClassName();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n = view.getMeasuredWidth();
            int n2 = view.getMeasuredHeight();
            int n3 = (right - left - n) / 2;
            int n4 = (bottom - top - n2) / 2;
            view.layout(n3, n4, n3 + n, n4 + n2);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n = 0;
        int n2 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
            n = view.getMeasuredWidth();
            n2 = view.getMeasuredHeight();
        } else {
            AdSize adSize = this.getAdSize();
            if (adSize != null) {
                Context context = this.getContext();
                n = adSize.getWidthInPixels(context);
                n2 = adSize.getHeightInPixels(context);
            }
        }
        n = Math.max(n, this.getSuggestedMinimumWidth());
        n2 = Math.max(n2, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n, (int)widthMeasureSpec), View.resolveSize((int)n2, (int)heightMeasureSpec));
    }
}

