/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;

public final class LeaderboardScoreRef
extends zzc
implements LeaderboardScore {
    private final PlayerRef zzatP;

    LeaderboardScoreRef(DataHolder holder, int dataRow) {
        super(holder, dataRow);
        this.zzatP = new PlayerRef(holder, dataRow);
    }

    @Override
    public long getRank() {
        return this.getLong("rank");
    }

    @Override
    public String getDisplayRank() {
        return this.getString("display_rank");
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        this.zza("display_rank", dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.getString("display_score");
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        this.zza("display_score", dataOut);
    }

    @Override
    public long getRawScore() {
        return this.getLong("raw_score");
    }

    @Override
    public long getTimestampMillis() {
        return this.getLong("achieved_timestamp");
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzbX("external_player_id")) {
            return this.getString("default_display_name");
        }
        return this.zzatP.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.zzbX("external_player_id")) {
            this.zza("default_display_name", dataOut);
            return;
        }
        this.zzatP.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzbX("external_player_id")) {
            return this.zzbW("default_display_image_uri");
        }
        return this.zzatP.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzbX("external_player_id")) {
            return this.getString("default_display_image_url");
        }
        return this.zzatP.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzbX("external_player_id")) {
            return null;
        }
        return this.zzatP.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzbX("external_player_id")) {
            return null;
        }
        return this.zzatP.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        if (this.zzbX("external_player_id")) {
            return null;
        }
        return this.zzatP;
    }

    @Override
    public String getScoreTag() {
        return this.getString("score_tag");
    }

    public LeaderboardScore zztG() {
        return new LeaderboardScoreEntity(this);
    }

    @Override
    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    @Override
    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.zza(this, obj);
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.zztG();
    }
}

