/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.v4.content.ContextCompat;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.zza;
import java.io.File;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;

public class zzd {
    SharedPreferences zzaxq;
    Context zzpH;

    public zzd(Context context) {
        this(context, "com.google.android.gms.appid");
    }

    public zzd(Context context, String string2) {
        this.zzpH = context;
        this.zzaxq = context.getSharedPreferences(string2, 4);
        this.zzde(string2 + "-no-backup");
    }

    private void zzde(String string2) {
        block4: {
            File file = new ContextCompat().getNoBackupFilesDir(this.zzpH);
            File file2 = new File(file, string2);
            if (file2.exists()) {
                return;
            }
            try {
                if (file2.createNewFile() && !this.isEmpty()) {
                    Log.i((String)"InstanceID/Store", (String)"App restored, clearing state");
                    InstanceIDListenerService.zza(this.zzpH, this);
                }
            }
            catch (IOException iOException) {
                if (!Log.isLoggable((String)"InstanceID/Store", (int)3)) break block4;
                Log.d((String)"InstanceID/Store", (String)("Error creating file in no backup dir: " + iOException.getMessage()));
            }
        }
    }

    boolean isEmpty() {
        return this.zzaxq.getAll().isEmpty();
    }

    private String zzf(String string2, String string3, String string4) {
        return string2 + "|T|" + string3 + "|" + string4;
    }

    synchronized String get(String subtype, String key) {
        return this.zzaxq.getString(subtype + "|S|" + key, null);
    }

    synchronized String get(String key) {
        return this.zzaxq.getString(key, null);
    }

    public synchronized void zzdf(String string2) {
        SharedPreferences.Editor editor = this.zzaxq.edit();
        Map map = this.zzaxq.getAll();
        for (String string3 : map.keySet()) {
            if (!string3.startsWith(string2)) continue;
            editor.remove(string3);
        }
        editor.commit();
    }

    public synchronized void zzul() {
        this.zzaxq.edit().clear().commit();
    }

    public synchronized String zzg(String string2, String string3, String string4) {
        String string5 = this.zzf(string2, string3, string4);
        String string6 = this.zzaxq.getString(string5, null);
        return string6;
    }

    public synchronized void zza(String string2, String string3, String string4, String string5, String string6) {
        String string7 = this.zzf(string2, string3, string4);
        SharedPreferences.Editor editor = this.zzaxq.edit();
        editor.putString(string7, string5);
        editor.putString("appVersion", string6);
        editor.putString("lastToken", Long.toString(System.currentTimeMillis() / 1000L));
        editor.commit();
    }

    public synchronized void zzh(String string2, String string3, String string4) {
        String string5 = this.zzf(string2, string3, string4);
        SharedPreferences.Editor editor = this.zzaxq.edit();
        editor.remove(string5);
        editor.commit();
    }

    public KeyPair zzdg(String string2) {
        return this.zzdj(string2);
    }

    synchronized KeyPair zze(String string2, long l) {
        KeyPair keyPair = zza.zzud();
        this.zzaxq.edit().putString(string2 + "|P|", InstanceID.zzm(keyPair.getPublic().getEncoded())).putString(string2 + "|K|", InstanceID.zzm(keyPair.getPrivate().getEncoded())).putString(string2 + "|S|" + "cre", Long.toString(l)).commit();
        return keyPair;
    }

    void zzdh(String string2) {
        this.zzdf(string2 + "|");
    }

    public void zzdi(String string2) {
        this.zzdf(string2 + "|T|");
    }

    KeyPair zzdj(String string2) {
        String string3 = this.get(string2, "|P|");
        String string4 = this.get(string2, "|K|");
        if (string4 == null) {
            return null;
        }
        try {
            byte[] byArray = Base64.decode((String)string3, (int)8);
            byte[] byArray2 = Base64.decode((String)string4, (int)8);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            Log.w((String)"InstanceID/Store", (String)("Invalid key stored " + generalSecurityException));
            InstanceIDListenerService.zza(this.zzpH, this);
            return null;
        }
    }
}

