/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzeu;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzid;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@zzgd
public class zzep
extends zzeu {
    static final Set<String> zzyu = new HashSet<String>(Arrays.asList("top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"));
    private String zzyv = "top-right";
    private boolean zzyw = true;
    private int zzyx = 0;
    private int zzyy = 0;
    private int zznN = -1;
    private int zzyz = 0;
    private int zzyA = 0;
    private int zznM = -1;
    private final Object zzqt = new Object();
    private final zzid zzoA;
    private final Activity zzyB;
    private AdSizeParcel zzxT;
    private ImageView zzyC;
    private LinearLayout zzyD;
    private zzev zzyE;
    private PopupWindow zzyF;
    private RelativeLayout zzyG;
    private ViewGroup zzyH;

    public zzep(zzid zzid2, zzev zzev2) {
        super(zzid2, "resize");
        this.zzoA = zzid2;
        this.zzyB = zzid2.zzgB();
        this.zzyE = zzev2;
    }

    private void zzg(Map<String, String> map) {
        String string2;
        if (!TextUtils.isEmpty((CharSequence)map.get("width"))) {
            this.zznM = zzo.zzbv().zzau(map.get("width"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("height"))) {
            this.zznN = zzo.zzbv().zzau(map.get("height"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetX"))) {
            this.zzyz = zzo.zzbv().zzau(map.get("offsetX"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetY"))) {
            this.zzyA = zzo.zzbv().zzau(map.get("offsetY"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("allowOffscreen"))) {
            this.zzyw = Boolean.parseBoolean(map.get("allowOffscreen"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = map.get("customClosePosition")))) {
            this.zzyv = string2;
        }
    }

    boolean zzec() {
        return this.zznM > -1 && this.zznN > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzh(Map<String, String> map) {
        Object object = this.zzqt;
        synchronized (object) {
            Bitmap bitmap;
            if (this.zzyB == null) {
                this.zzae("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzoA.zzaN() == null) {
                this.zzae("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzoA.zzaN().zzsn) {
                this.zzae("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzoA.zzgJ()) {
                this.zzae("Cannot resize an expanded banner.");
                return;
            }
            this.zzg(map);
            if (!this.zzec()) {
                this.zzae("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzyB.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzae("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzed();
            if (nArray == null) {
                this.zzae("Resize location out of screen or close button is not visible.");
                return;
            }
            int n = zzk.zzcA().zzb((Context)this.zzyB, this.zznM);
            int n2 = zzk.zzcA().zzb((Context)this.zzyB, this.zznN);
            ViewParent viewParent = this.zzoA.getWebView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView((View)this.zzoA.getWebView());
                if (this.zzyF == null) {
                    this.zzyH = (ViewGroup)viewParent;
                    bitmap = zzo.zzbv().zzj((View)this.zzoA.getWebView());
                    this.zzyC = new ImageView((Context)this.zzyB);
                    this.zzyC.setImageBitmap(bitmap);
                    this.zzxT = this.zzoA.zzaN();
                    this.zzyH.addView((View)this.zzyC);
                } else {
                    this.zzyF.dismiss();
                }
            } else {
                this.zzae("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzyG = new RelativeLayout((Context)this.zzyB);
            this.zzyG.setBackgroundColor(0);
            this.zzyG.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            this.zzyF = zzo.zzbv().zza((View)this.zzyG, n, n2, false);
            this.zzyF.setOutsideTouchable(true);
            this.zzyF.setTouchable(true);
            this.zzyF.setClippingEnabled(!this.zzyw);
            this.zzyG.addView((View)this.zzoA.getWebView(), -1, -1);
            this.zzyD = new LinearLayout((Context)this.zzyB);
            bitmap = new RelativeLayout.LayoutParams(zzk.zzcA().zzb((Context)this.zzyB, 50), zzk.zzcA().zzb((Context)this.zzyB, 50));
            switch (this.zzyv) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzyD.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    zzep.this.zzn(true);
                }
            });
            this.zzyD.setContentDescription((CharSequence)"Close button");
            this.zzyG.addView((View)this.zzyD, (ViewGroup.LayoutParams)bitmap);
            try {
                this.zzyF.showAtLocation(window.getDecorView(), 0, zzk.zzcA().zzb((Context)this.zzyB, nArray[0]), zzk.zzcA().zzb((Context)this.zzyB, nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                this.zzae("Cannot show popup window: " + runtimeException.getMessage());
                this.zzyG.removeView((View)this.zzoA.getWebView());
                if (this.zzyH != null) {
                    this.zzyH.removeView((View)this.zzyC);
                    this.zzyH.addView((View)this.zzoA.getWebView());
                    this.zzoA.zza(this.zzxT);
                }
                return;
            }
            this.zzb(nArray[0], nArray[1]);
            this.zzoA.zza(new AdSizeParcel((Context)this.zzyB, new AdSize(this.zznM, this.zznN)));
            this.zzc(nArray[0], nArray[1]);
            this.zzag("resized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzn(boolean bl) {
        Object object = this.zzqt;
        synchronized (object) {
            if (this.zzyF != null) {
                this.zzyF.dismiss();
                this.zzyG.removeView((View)this.zzoA.getWebView());
                if (this.zzyH != null) {
                    this.zzyH.removeView((View)this.zzyC);
                    this.zzyH.addView((View)this.zzoA.getWebView());
                    this.zzoA.zza(this.zzxT);
                }
                if (bl) {
                    this.zzag("default");
                    if (this.zzyE != null) {
                        this.zzyE.zzbc();
                    }
                }
                this.zzyF = null;
                this.zzyG = null;
                this.zzyH = null;
                this.zzyD = null;
            }
        }
    }

    private int[] zzed() {
        if (!this.zzef()) {
            return null;
        }
        if (this.zzyw) {
            return new int[]{this.zzyx + this.zzyz, this.zzyy + this.zzyA};
        }
        int[] nArray = zzo.zzbv().zzh(this.zzyB);
        int[] nArray2 = zzo.zzbv().zzj(this.zzyB);
        int n = nArray[0];
        int n2 = this.zzyx + this.zzyz;
        int n3 = this.zzyy + this.zzyA;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + this.zznM > n) {
            n2 = n - this.zznM;
        }
        if (n3 < nArray2[0]) {
            n3 = nArray2[0];
        } else if (n3 + this.zznN > nArray2[1]) {
            n3 = nArray2[1] - this.zznN;
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(int n, int n2, boolean bl) {
        Object object = this.zzqt;
        synchronized (object) {
            this.zzyx = n;
            this.zzyy = n2;
            if (this.zzyF != null && bl) {
                int[] nArray = this.zzed();
                if (nArray != null) {
                    this.zzyF.update(zzk.zzcA().zzb((Context)this.zzyB, nArray[0]), zzk.zzcA().zzb((Context)this.zzyB, nArray[1]), this.zzyF.getWidth(), this.zzyF.getHeight());
                    this.zzc(nArray[0], nArray[1]);
                } else {
                    this.zzn(true);
                }
            }
        }
    }

    void zzb(int n, int n2) {
        if (this.zzyE != null) {
            this.zzyE.zza(n, n2, this.zznM, this.zznN);
        }
    }

    void zzc(int n, int n2) {
        int n3 = zzo.zzbv().zzj(this.zzyB)[0];
        this.zzb(n, n2 - n3, this.zznM, this.zznN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzee() {
        Object object = this.zzqt;
        synchronized (object) {
            return this.zzyF != null;
        }
    }

    public void zzd(int n, int n2) {
        this.zzyx = n;
        this.zzyy = n2;
    }

    boolean zzef() {
        int[] nArray = zzo.zzbv().zzh(this.zzyB);
        int[] nArray2 = zzo.zzbv().zzj(this.zzyB);
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.zznM < 50 || this.zznM > n) {
            zzb.zzaC("Width is too small or too large.");
            return false;
        }
        if (this.zznN < 50 || this.zznN > n2) {
            zzb.zzaC("Height is too small or too large.");
            return false;
        }
        if (this.zznN == n2 && this.zznM == n) {
            zzb.zzaC("Cannot resize to a full-screen ad.");
            return false;
        }
        if (this.zzyw) {
            int n3 = -1;
            int n4 = -2;
            switch (this.zzyv) {
                case "top-left": {
                    n3 = this.zzyx + this.zzyz;
                    n4 = this.zzyy + this.zzyA;
                    break;
                }
                case "top-center": {
                    n3 = this.zzyx + this.zzyz + this.zznM / 2 - 25;
                    n4 = this.zzyy + this.zzyA;
                    break;
                }
                case "center": {
                    n3 = this.zzyx + this.zzyz + this.zznM / 2 - 25;
                    n4 = this.zzyy + this.zzyA + this.zznN / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n3 = this.zzyx + this.zzyz;
                    n4 = this.zzyy + this.zzyA + this.zznN - 50;
                    break;
                }
                case "bottom-center": {
                    n3 = this.zzyx + this.zzyz + this.zznM / 2 - 25;
                    n4 = this.zzyy + this.zzyA + this.zznN - 50;
                    break;
                }
                case "bottom-right": {
                    n3 = this.zzyx + this.zzyz + this.zznM - 50;
                    n4 = this.zzyy + this.zzyA + this.zznN - 50;
                    break;
                }
                default: {
                    n3 = this.zzyx + this.zzyz + this.zznM - 50;
                    n4 = this.zzyy + this.zzyA;
                }
            }
            if (n3 < 0 || n3 + 50 > n || n4 < nArray2[0] || n4 + 50 > nArray2[1]) {
                return false;
            }
        }
        return true;
    }
}

