/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.location.Location;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.internal.ILocationSourceDelegate;
import com.google.android.gms.maps.internal.IProjectionDelegate;
import com.google.android.gms.maps.internal.IUiSettingsDelegate;
import com.google.android.gms.maps.internal.zzb;
import com.google.android.gms.maps.internal.zzd;
import com.google.android.gms.maps.internal.zze;
import com.google.android.gms.maps.internal.zzf;
import com.google.android.gms.maps.internal.zzg;
import com.google.android.gms.maps.internal.zzh;
import com.google.android.gms.maps.internal.zzj;
import com.google.android.gms.maps.internal.zzk;
import com.google.android.gms.maps.internal.zzl;
import com.google.android.gms.maps.internal.zzm;
import com.google.android.gms.maps.internal.zzn;
import com.google.android.gms.maps.internal.zzo;
import com.google.android.gms.maps.internal.zzp;
import com.google.android.gms.maps.internal.zzq;
import com.google.android.gms.maps.internal.zzw;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.internal.CameraUpdateParcelable;
import com.google.android.gms.maps.model.internal.GroundOverlayOptionsParcelable;
import com.google.android.gms.maps.model.internal.IPolylineDelegate;
import com.google.android.gms.maps.model.internal.MarkerOptionsParcelable;
import com.google.android.gms.maps.model.internal.zze;
import com.google.android.gms.maps.model.internal.zzf;
import com.google.android.gms.maps.model.internal.zzg;
import com.google.android.gms.maps.model.internal.zzi;
import com.google.android.gms.maps.model.internal.zzj;
import com.google.android.gms.maps.model.internal.zzk;

public interface IGoogleMapDelegate
extends IInterface {
    public CameraPosition getCameraPosition() throws RemoteException;

    public float getMaxZoomLevel() throws RemoteException;

    public float getMinZoomLevel() throws RemoteException;

    public void moveCamera(com.google.android.gms.dynamic.zzd var1) throws RemoteException;

    public void animateCamera(com.google.android.gms.dynamic.zzd var1) throws RemoteException;

    public void animateCameraWithCallback(com.google.android.gms.dynamic.zzd var1, zzb var2) throws RemoteException;

    public void animateCameraWithDurationAndCallback(com.google.android.gms.dynamic.zzd var1, int var2, zzb var3) throws RemoteException;

    public void stopAnimation() throws RemoteException;

    public IPolylineDelegate addPolyline(PolylineOptions var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.zzj addPolygon(PolygonOptions var1) throws RemoteException;

    public zzi addMarker(MarkerOptions var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.zzf addGroundOverlay(GroundOverlayOptions var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.zzk addTileOverlay(TileOverlayOptions var1) throws RemoteException;

    public void clear() throws RemoteException;

    public int getMapType() throws RemoteException;

    public void setMapType(int var1) throws RemoteException;

    public boolean isTrafficEnabled() throws RemoteException;

    public void setTrafficEnabled(boolean var1) throws RemoteException;

    public boolean isIndoorEnabled() throws RemoteException;

    public boolean setIndoorEnabled(boolean var1) throws RemoteException;

    public boolean isMyLocationEnabled() throws RemoteException;

    public void setMyLocationEnabled(boolean var1) throws RemoteException;

    public Location getMyLocation() throws RemoteException;

    public void setLocationSource(ILocationSourceDelegate var1) throws RemoteException;

    public IUiSettingsDelegate getUiSettings() throws RemoteException;

    public IProjectionDelegate getProjection() throws RemoteException;

    public void setOnCameraChangeListener(zzf var1) throws RemoteException;

    public void setOnMapClickListener(zzj var1) throws RemoteException;

    public void setOnMapLongClickListener(zzl var1) throws RemoteException;

    public void setOnMarkerClickListener(zzn var1) throws RemoteException;

    public void setOnMarkerDragListener(zzo var1) throws RemoteException;

    public void setOnInfoWindowClickListener(zzh var1) throws RemoteException;

    public void setInfoWindowAdapter(zzd var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.zze addCircle(CircleOptions var1) throws RemoteException;

    public void setOnMyLocationChangeListener(zzq var1) throws RemoteException;

    public void setOnMyLocationButtonClickListener(zzp var1) throws RemoteException;

    public void snapshot(zzw var1, com.google.android.gms.dynamic.zzd var2) throws RemoteException;

    public void setPadding(int var1, int var2, int var3, int var4) throws RemoteException;

    public boolean isBuildingsEnabled() throws RemoteException;

    public void setBuildingsEnabled(boolean var1) throws RemoteException;

    public void setOnMapLoadedCallback(zzk var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.zzg getFocusedBuilding() throws RemoteException;

    public void setOnIndoorStateChangeListener(zzg var1) throws RemoteException;

    public void getMapAsync(zzm var1) throws RemoteException;

    public void onCreate(Bundle var1) throws RemoteException;

    public void onResume() throws RemoteException;

    public void onPause() throws RemoteException;

    public void onDestroy() throws RemoteException;

    public void onLowMemory() throws RemoteException;

    public boolean useViewLifecycleWhenInFragment() throws RemoteException;

    public void onSaveInstanceState(Bundle var1) throws RemoteException;

    public void setContentDescription(String var1) throws RemoteException;

    public void moveCamera2(CameraUpdateParcelable var1) throws RemoteException;

    public void animateCamera2(CameraUpdateParcelable var1) throws RemoteException;

    public void animateCameraWithCallback2(CameraUpdateParcelable var1, zzb var2) throws RemoteException;

    public void animateCameraWithDurationAndCallback2(CameraUpdateParcelable var1, int var2, zzb var3) throws RemoteException;

    public zzi addMarker2(MarkerOptions var1, MarkerOptionsParcelable var2) throws RemoteException;

    public void setInfoWindowRenderer(zze var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.zzf addGroundOverlay2(GroundOverlayOptions var1, GroundOverlayOptionsParcelable var2) throws RemoteException;

    public static abstract class com.google.android.gms.maps.internal.IGoogleMapDelegate$zza
    extends Binder
    implements IGoogleMapDelegate {
        public static IGoogleMapDelegate zzch(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
            if (iInterface != null && iInterface instanceof IGoogleMapDelegate) {
                return (IGoogleMapDelegate)iInterface;
            }
            return new zza(iBinder);
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    return true;
                }
                case 1: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    CameraPosition cameraPosition = this.getCameraPosition();
                    reply.writeNoException();
                    if (cameraPosition != null) {
                        reply.writeInt(1);
                        cameraPosition.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    float f = this.getMaxZoomLevel();
                    reply.writeNoException();
                    reply.writeFloat(f);
                    return true;
                }
                case 3: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    float f = this.getMinZoomLevel();
                    reply.writeNoException();
                    reply.writeFloat(f);
                    return true;
                }
                case 4: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.zzd zzd2 = zzd.zza.zzbg(data.readStrongBinder());
                    this.moveCamera(zzd2);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.zzd zzd3 = zzd.zza.zzbg(data.readStrongBinder());
                    this.animateCamera(zzd3);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.zzd zzd4 = zzd.zza.zzbg(data.readStrongBinder());
                    zzb zzb2 = zzb.zza.zzcf(data.readStrongBinder());
                    this.animateCameraWithCallback(zzd4, zzb2);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.zzd zzd5 = zzd.zza.zzbg(data.readStrongBinder());
                    int n = data.readInt();
                    zzb zzb3 = zzb.zza.zzcf(data.readStrongBinder());
                    this.animateCameraWithDurationAndCallback(zzd5, n, zzb3);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.stopAnimation();
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    PolylineOptions polylineOptions = 0 != data.readInt() ? PolylineOptions.CREATOR.zzeS(data) : null;
                    IPolylineDelegate iPolylineDelegate = this.addPolyline(polylineOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(iPolylineDelegate != null ? iPolylineDelegate.asBinder() : null);
                    return true;
                }
                case 10: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    PolygonOptions polygonOptions = 0 != data.readInt() ? PolygonOptions.CREATOR.zzeR(data) : null;
                    com.google.android.gms.maps.model.internal.zzj zzj2 = this.addPolygon(polygonOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzj2 != null ? zzj2.asBinder() : null);
                    return true;
                }
                case 11: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    MarkerOptions markerOptions = 0 != data.readInt() ? MarkerOptions.CREATOR.zzeQ(data) : null;
                    zzi zzi2 = this.addMarker(markerOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzi2 != null ? zzi2.asBinder() : null);
                    return true;
                }
                case 12: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    GroundOverlayOptions groundOverlayOptions = 0 != data.readInt() ? GroundOverlayOptions.CREATOR.zzeN(data) : null;
                    com.google.android.gms.maps.model.internal.zzf zzf2 = this.addGroundOverlay(groundOverlayOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzf2 != null ? zzf2.asBinder() : null);
                    return true;
                }
                case 13: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    TileOverlayOptions tileOverlayOptions = 0 != data.readInt() ? TileOverlayOptions.CREATOR.zzeY(data) : null;
                    com.google.android.gms.maps.model.internal.zzk zzk2 = this.addTileOverlay(tileOverlayOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzk2 != null ? zzk2.asBinder() : null);
                    return true;
                }
                case 14: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.clear();
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    int n = this.getMapType();
                    reply.writeNoException();
                    reply.writeInt(n);
                    return true;
                }
                case 16: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    int n = data.readInt();
                    this.setMapType(n);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.isTrafficEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 18: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = 0 != data.readInt();
                    this.setTrafficEnabled(bl);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.isIndoorEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 20: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = 0 != data.readInt();
                    boolean bl2 = this.setIndoorEnabled(bl);
                    reply.writeNoException();
                    reply.writeInt(bl2 ? 1 : 0);
                    return true;
                }
                case 21: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.isMyLocationEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 22: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = 0 != data.readInt();
                    this.setMyLocationEnabled(bl);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    Location location = this.getMyLocation();
                    reply.writeNoException();
                    if (location != null) {
                        reply.writeInt(1);
                        location.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 24: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    ILocationSourceDelegate iLocationSourceDelegate = ILocationSourceDelegate.zza.zzck(data.readStrongBinder());
                    this.setLocationSource(iLocationSourceDelegate);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    IUiSettingsDelegate iUiSettingsDelegate = this.getUiSettings();
                    reply.writeNoException();
                    reply.writeStrongBinder(iUiSettingsDelegate != null ? iUiSettingsDelegate.asBinder() : null);
                    return true;
                }
                case 26: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    IProjectionDelegate iProjectionDelegate = this.getProjection();
                    reply.writeNoException();
                    reply.writeStrongBinder(iProjectionDelegate != null ? iProjectionDelegate.asBinder() : null);
                    return true;
                }
                case 27: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzf zzf3 = zzf.zza.zzcn(data.readStrongBinder());
                    this.setOnCameraChangeListener(zzf3);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzj zzj3 = zzj.zza.zzcr(data.readStrongBinder());
                    this.setOnMapClickListener(zzj3);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzl zzl2 = zzl.zza.zzct(data.readStrongBinder());
                    this.setOnMapLongClickListener(zzl2);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzn zzn2 = zzn.zza.zzcv(data.readStrongBinder());
                    this.setOnMarkerClickListener(zzn2);
                    reply.writeNoException();
                    return true;
                }
                case 31: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzo zzo2 = zzo.zza.zzcw(data.readStrongBinder());
                    this.setOnMarkerDragListener(zzo2);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzh zzh2 = zzh.zza.zzcp(data.readStrongBinder());
                    this.setOnInfoWindowClickListener(zzh2);
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzd zzd6 = zzd.zza.zzci(data.readStrongBinder());
                    this.setInfoWindowAdapter(zzd6);
                    reply.writeNoException();
                    return true;
                }
                case 35: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    CircleOptions circleOptions = 0 != data.readInt() ? CircleOptions.CREATOR.zzeM(data) : null;
                    com.google.android.gms.maps.model.internal.zze zze2 = this.addCircle(circleOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(zze2 != null ? zze2.asBinder() : null);
                    return true;
                }
                case 36: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzq zzq2 = zzq.zza.zzcy(data.readStrongBinder());
                    this.setOnMyLocationChangeListener(zzq2);
                    reply.writeNoException();
                    return true;
                }
                case 37: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzp zzp2 = zzp.zza.zzcx(data.readStrongBinder());
                    this.setOnMyLocationButtonClickListener(zzp2);
                    reply.writeNoException();
                    return true;
                }
                case 38: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzw zzw2 = zzw.zza.zzcF(data.readStrongBinder());
                    com.google.android.gms.dynamic.zzd zzd7 = zzd.zza.zzbg(data.readStrongBinder());
                    this.snapshot(zzw2, zzd7);
                    reply.writeNoException();
                    return true;
                }
                case 39: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    int n = data.readInt();
                    int n2 = data.readInt();
                    int n3 = data.readInt();
                    int n4 = data.readInt();
                    this.setPadding(n, n2, n3, n4);
                    reply.writeNoException();
                    return true;
                }
                case 40: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.isBuildingsEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 41: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = 0 != data.readInt();
                    this.setBuildingsEnabled(bl);
                    reply.writeNoException();
                    return true;
                }
                case 42: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzk zzk3 = zzk.zza.zzcs(data.readStrongBinder());
                    this.setOnMapLoadedCallback(zzk3);
                    reply.writeNoException();
                    return true;
                }
                case 44: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.maps.model.internal.zzg zzg2 = this.getFocusedBuilding();
                    reply.writeNoException();
                    reply.writeStrongBinder(zzg2 != null ? zzg2.asBinder() : null);
                    return true;
                }
                case 45: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzg zzg3 = zzg.zza.zzco(data.readStrongBinder());
                    this.setOnIndoorStateChangeListener(zzg3);
                    reply.writeNoException();
                    return true;
                }
                case 53: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zzm zzm2 = zzm.zza.zzcu(data.readStrongBinder());
                    this.getMapAsync(zzm2);
                    reply.writeNoException();
                    return true;
                }
                case 54: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    Bundle bundle = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.onCreate(bundle);
                    reply.writeNoException();
                    return true;
                }
                case 55: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.onResume();
                    reply.writeNoException();
                    return true;
                }
                case 56: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.onPause();
                    reply.writeNoException();
                    return true;
                }
                case 57: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.onDestroy();
                    reply.writeNoException();
                    return true;
                }
                case 58: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.onLowMemory();
                    reply.writeNoException();
                    return true;
                }
                case 59: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.useViewLifecycleWhenInFragment();
                    reply.writeNoException();
                    reply.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 60: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    Bundle bundle = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.onSaveInstanceState(bundle);
                    reply.writeNoException();
                    if (bundle != null) {
                        reply.writeInt(1);
                        bundle.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 61: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    String string2 = data.readString();
                    this.setContentDescription(string2);
                    reply.writeNoException();
                    return true;
                }
                case 64: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    CameraUpdateParcelable cameraUpdateParcelable = 0 != data.readInt() ? CameraUpdateParcelable.CREATOR.zzfb(data) : null;
                    this.moveCamera2(cameraUpdateParcelable);
                    reply.writeNoException();
                    return true;
                }
                case 65: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    CameraUpdateParcelable cameraUpdateParcelable = 0 != data.readInt() ? CameraUpdateParcelable.CREATOR.zzfb(data) : null;
                    this.animateCamera2(cameraUpdateParcelable);
                    reply.writeNoException();
                    return true;
                }
                case 66: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    CameraUpdateParcelable cameraUpdateParcelable = 0 != data.readInt() ? CameraUpdateParcelable.CREATOR.zzfb(data) : null;
                    zzb zzb4 = zzb.zza.zzcf(data.readStrongBinder());
                    this.animateCameraWithCallback2(cameraUpdateParcelable, zzb4);
                    reply.writeNoException();
                    return true;
                }
                case 67: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    CameraUpdateParcelable cameraUpdateParcelable = 0 != data.readInt() ? CameraUpdateParcelable.CREATOR.zzfb(data) : null;
                    int n = data.readInt();
                    zzb zzb5 = zzb.zza.zzcf(data.readStrongBinder());
                    this.animateCameraWithDurationAndCallback2(cameraUpdateParcelable, n, zzb5);
                    reply.writeNoException();
                    return true;
                }
                case 68: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    MarkerOptions markerOptions = 0 != data.readInt() ? MarkerOptions.CREATOR.zzeQ(data) : null;
                    MarkerOptionsParcelable markerOptionsParcelable = 0 != data.readInt() ? MarkerOptionsParcelable.CREATOR.zzfd(data) : null;
                    zzi zzi3 = this.addMarker2(markerOptions, markerOptionsParcelable);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzi3 != null ? zzi3.asBinder() : null);
                    return true;
                }
                case 69: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    zze zze3 = zze.zza.zzcj(data.readStrongBinder());
                    this.setInfoWindowRenderer(zze3);
                    reply.writeNoException();
                    return true;
                }
                case 70: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    GroundOverlayOptions groundOverlayOptions = 0 != data.readInt() ? GroundOverlayOptions.CREATOR.zzeN(data) : null;
                    GroundOverlayOptionsParcelable groundOverlayOptionsParcelable = 0 != data.readInt() ? GroundOverlayOptionsParcelable.CREATOR.zzfc(data) : null;
                    com.google.android.gms.maps.model.internal.zzf zzf4 = this.addGroundOverlay2(groundOverlayOptions, groundOverlayOptionsParcelable);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzf4 != null ? zzf4.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class zza
        implements IGoogleMapDelegate {
            private IBinder zznF;

            zza(IBinder iBinder) {
                this.zznF = iBinder;
            }

            public IBinder asBinder() {
                return this.zznF;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraPosition getCameraPosition() throws RemoteException {
                CameraPosition cameraPosition;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    cameraPosition = 0 != parcel2.readInt() ? CameraPosition.CREATOR.zzeL(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return cameraPosition;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getMaxZoomLevel() throws RemoteException {
                float f;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    f = parcel2.readFloat();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return f;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getMinZoomLevel() throws RemoteException {
                float f;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    f = parcel2.readFloat();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return f;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveCamera(com.google.android.gms.dynamic.zzd update) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    this.zznF.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCamera(com.google.android.gms.dynamic.zzd update) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    this.zznF.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCameraWithCallback(com.google.android.gms.dynamic.zzd update, zzb callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.zznF.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCameraWithDurationAndCallback(com.google.android.gms.dynamic.zzd update, int durationMs, zzb callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    parcel.writeInt(durationMs);
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.zznF.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopAnimation() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IPolylineDelegate addPolyline(PolylineOptions options) throws RemoteException {
                IPolylineDelegate iPolylineDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zznF.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    iPolylineDelegate = IPolylineDelegate.zza.zzcR(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iPolylineDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.zzj addPolygon(PolygonOptions options) throws RemoteException {
                com.google.android.gms.maps.model.internal.zzj zzj2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zznF.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    zzj2 = zzj.zza.zzcQ(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzj2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzi addMarker(MarkerOptions options) throws RemoteException {
                zzi zzi2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zznF.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    zzi2 = zzi.zza.zzcP(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzi2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.zzf addGroundOverlay(GroundOverlayOptions options) throws RemoteException {
                com.google.android.gms.maps.model.internal.zzf zzf2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zznF.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    zzf2 = zzf.zza.zzcM(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzf2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.zzk addTileOverlay(TileOverlayOptions options) throws RemoteException {
                com.google.android.gms.maps.model.internal.zzk zzk2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zznF.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    zzk2 = zzk.zza.zzcS(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzk2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clear() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMapType() throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    n = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMapType(int type) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(type);
                    this.zznF.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTrafficEnabled() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTrafficEnabled(boolean enabled) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.zznF.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isIndoorEnabled() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setIndoorEnabled(boolean enabled) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.zznF.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMyLocationEnabled() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMyLocationEnabled(boolean enabled) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.zznF.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Location getMyLocation() throws RemoteException {
                Location location;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    location = 0 != parcel2.readInt() ? (Location)Location.CREATOR.createFromParcel(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return location;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLocationSource(ILocationSourceDelegate source) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(source != null ? source.asBinder() : null);
                    this.zznF.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IUiSettingsDelegate getUiSettings() throws RemoteException {
                IUiSettingsDelegate iUiSettingsDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    iUiSettingsDelegate = IUiSettingsDelegate.zza.zzcJ(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iUiSettingsDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IProjectionDelegate getProjection() throws RemoteException {
                IProjectionDelegate iProjectionDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    iProjectionDelegate = IProjectionDelegate.zza.zzcE(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iProjectionDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnCameraChangeListener(zzf listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.zznF.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMapClickListener(zzj listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.zznF.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMapLongClickListener(zzl listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.zznF.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMarkerClickListener(zzn listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.zznF.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMarkerDragListener(zzo listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.zznF.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnInfoWindowClickListener(zzh listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.zznF.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInfoWindowAdapter(zzd adapter) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(adapter != null ? adapter.asBinder() : null);
                    this.zznF.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.zze addCircle(CircleOptions options) throws RemoteException {
                com.google.android.gms.maps.model.internal.zze zze2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zznF.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    zze2 = zze.zza.zzcL(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zze2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMyLocationChangeListener(zzq listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.zznF.transact(36, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMyLocationButtonClickListener(zzp listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.zznF.transact(37, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void snapshot(zzw callback, com.google.android.gms.dynamic.zzd bitmap) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    parcel.writeStrongBinder(bitmap != null ? bitmap.asBinder() : null);
                    this.zznF.transact(38, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPadding(int left, int top, int right, int bottom) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(left);
                    parcel.writeInt(top);
                    parcel.writeInt(right);
                    parcel.writeInt(bottom);
                    this.zznF.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBuildingsEnabled() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBuildingsEnabled(boolean enabled) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.zznF.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMapLoadedCallback(zzk callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.zznF.transact(42, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.zzg getFocusedBuilding() throws RemoteException {
                com.google.android.gms.maps.model.internal.zzg zzg2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(44, parcel, parcel2, 0);
                    parcel2.readException();
                    zzg2 = zzg.zza.zzcN(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzg2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnIndoorStateChangeListener(zzg listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.zznF.transact(45, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getMapAsync(zzm callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.zznF.transact(53, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCreate(Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zznF.transact(54, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResume() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(55, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPause() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(56, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDestroy() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(57, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLowMemory() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(58, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean useViewLifecycleWhenInFragment() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.zznF.transact(59, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSaveInstanceState(Bundle outState) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (outState != null) {
                        parcel.writeInt(1);
                        outState.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zznF.transact(60, parcel, parcel2, 0);
                    parcel2.readException();
                    if (0 != parcel2.readInt()) {
                        outState.readFromParcel(parcel2);
                    }
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setContentDescription(String description) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeString(description);
                    this.zznF.transact(61, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveCamera2(CameraUpdateParcelable update) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (update != null) {
                        parcel.writeInt(1);
                        update.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zznF.transact(64, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCamera2(CameraUpdateParcelable update) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (update != null) {
                        parcel.writeInt(1);
                        update.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zznF.transact(65, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCameraWithCallback2(CameraUpdateParcelable update, zzb callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (update != null) {
                        parcel.writeInt(1);
                        update.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.zznF.transact(66, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCameraWithDurationAndCallback2(CameraUpdateParcelable update, int durationMs, zzb callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (update != null) {
                        parcel.writeInt(1);
                        update.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(durationMs);
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.zznF.transact(67, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzi addMarker2(MarkerOptions options, MarkerOptionsParcelable parcelableOptions) throws RemoteException {
                zzi zzi2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (parcelableOptions != null) {
                        parcel.writeInt(1);
                        parcelableOptions.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zznF.transact(68, parcel, parcel2, 0);
                    parcel2.readException();
                    zzi2 = zzi.zza.zzcP(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzi2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInfoWindowRenderer(zze infoWindowRenderer) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(infoWindowRenderer != null ? infoWindowRenderer.asBinder() : null);
                    this.zznF.transact(69, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.zzf addGroundOverlay2(GroundOverlayOptions options, GroundOverlayOptionsParcelable parcelableOptions) throws RemoteException {
                com.google.android.gms.maps.model.internal.zzf zzf2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (parcelableOptions != null) {
                        parcel.writeInt(1);
                        parcelableOptions.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zznF.transact(70, parcel, parcel2, 0);
                    parcel2.readException();
                    zzf2 = zzf.zza.zzcM(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzf2;
            }
        }
    }
}

