/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.analytics.internal.Command;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzac;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.stats.zzb;
import java.util.Collections;
import java.util.List;

public class zzi
extends zzd {
    private final zza zzJW;
    private zzac zzJX;
    private final zzt zzJY;
    private zzaj zzJZ;

    protected zzi(zzf zzf2) {
        super(zzf2);
        this.zzJZ = new zzaj(zzf2.zzhP());
        this.zzJW = new zza();
        this.zzJY = new zzt(zzf2){

            @Override
            public void run() {
                zzi.this.zzio();
            }
        };
    }

    @Override
    protected void zzhn() {
    }

    public boolean isConnected() {
        this.zzhO();
        this.zzia();
        return this.zzJX != null;
    }

    public boolean zzb(zzab zzab2) {
        zzu.zzu(zzab2);
        this.zzhO();
        this.zzia();
        zzac zzac2 = this.zzJX;
        if (zzac2 == null) {
            return false;
        }
        String string2 = zzab2.zzjY() ? this.zzhR().zzjk() : this.zzhR().zzjl();
        List<Command> list = Collections.emptyList();
        try {
            zzac2.zza(zzab2.zzn(), zzab2.zzjW(), string2, list);
            this.zzin();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzaT("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public boolean zzim() {
        this.zzhO();
        this.zzia();
        zzac zzac2 = this.zzJX;
        if (zzac2 == null) {
            return false;
        }
        try {
            zzac2.zzhG();
            this.zzin();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzaT("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private void zzin() {
        this.zzJZ.start();
        this.zzJY.zzt(this.zzhR().zzjr());
    }

    public boolean connect() {
        this.zzhO();
        this.zzia();
        if (this.zzJX != null) {
            return true;
        }
        zzac zzac2 = this.zzJW.zzip();
        if (zzac2 != null) {
            this.zzJX = zzac2;
            this.zzin();
            return true;
        }
        return false;
    }

    private void zza(zzac zzac2) {
        this.zzhO();
        this.zzJX = zzac2;
        this.zzin();
        this.zzhl().onServiceConnected();
    }

    public void disconnect() {
        this.zzhO();
        this.zzia();
        try {
            zzb zzb2 = zzb.zzoO();
            zzb2.zza(this.getContext(), this.zzJW);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.zzJX != null) {
            this.zzJX = null;
            this.onDisconnect();
        }
    }

    private void onServiceDisconnected(ComponentName name) {
        this.zzhO();
        if (this.zzJX != null) {
            this.zzJX = null;
            this.zza("Disconnected from device AnalyticsService", name);
            this.onDisconnect();
        }
    }

    private void zzio() {
        this.zzhO();
        if (!this.isConnected()) {
            return;
        }
        this.zzaT("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    private void onDisconnect() {
        this.zzhl().zzhJ();
    }

    protected class zza
    implements ServiceConnection {
        private volatile zzac zzKb;
        private volatile boolean zzKc;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public zzac zzip() {
            zzi.this.zzhO();
            Intent intent = new Intent("com.google.android.gms.analytics.service.START");
            intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.analytics.service.AnalyticsService"));
            Context context = zzi.this.getContext();
            intent.putExtra("app_package_name", context.getPackageName());
            zzb zzb2 = zzb.zzoO();
            zza zza2 = this;
            synchronized (zza2) {
                this.zzKb = null;
                this.zzKc = true;
                boolean bl = zzb2.zza(context, intent, zzi.this.zzJW, 129);
                zzi.this.zza("Bind to service requested", bl);
                if (!bl) {
                    this.zzKc = false;
                    return null;
                }
                try {
                    long l = zzi.this.zzhR().zzjs();
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    zzi.this.zzaW("Wait for service connect was interrupted");
                }
                this.zzKc = false;
                zzac zzac2 = this.zzKb;
                this.zzKb = null;
                if (zzac2 == null) {
                    zzi.this.zzaX("Successfully bound to service but never got onServiceConnected callback");
                }
                return zzac2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder binder) {
            zzu.zzbY("AnalyticsServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    Object object;
                    if (binder == null) {
                        zzi.this.zzaX("Service connected with null binder");
                        return;
                    }
                    zzac zzac2 = null;
                    try {
                        object = binder.getInterfaceDescriptor();
                        if ("com.google.android.gms.analytics.internal.IAnalyticsService".equals(object)) {
                            zzac2 = zzac.zza.zzac(binder);
                            zzi.this.zzaT("Bound to IAnalyticsService interface");
                        } else {
                            zzi.this.zze("Got binder with a wrong descriptor", object);
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzi.this.zzaX("Service connect failed to get IAnalyticsService");
                    }
                    if (zzac2 == null) {
                        try {
                            zzb.zzoO().zza(zzi.this.getContext(), zzi.this.zzJW);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    } else if (!this.zzKc) {
                        zzi.this.zzaW("onServiceConnected received after the timeout limit");
                        object = zzac2;
                        zzi.this.zzhS().zze(new Runnable((zzac)object){
                            final /* synthetic */ zzac zzKd;
                            {
                                this.zzKd = zzac2;
                            }

                            @Override
                            public void run() {
                                if (!zzi.this.isConnected()) {
                                    zzi.this.zzaU("Connected to service after a timeout");
                                    zzi.this.zza(this.zzKd);
                                }
                            }
                        });
                    } else {
                        this.zzKb = zzac2;
                    }
                }
                finally {
                    this.notifyAll();
                }
            }
        }

        public void onServiceDisconnected(final ComponentName name) {
            zzu.zzbY("AnalyticsServiceConnection.onServiceDisconnected");
            zzi.this.zzhS().zze(new Runnable(){

                @Override
                public void run() {
                    zzi.this.onServiceDisconnected(name);
                }
            });
        }
    }
}

