/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appstate;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.appstate.AppStateBuffer;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzjb;

@Deprecated
public final class AppStateManager {
    static final Api.ClientKey<zzjb> zzNX = new Api.ClientKey();
    private static final Api.zza<zzjb, Api.ApiOptions.NoOptions> zzNY = new Api.zza<zzjb, Api.ApiOptions.NoOptions>(){

        public zzjb zzc(Context context, Looper looper, com.google.android.gms.common.internal.zze zze2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzjb(context, looper, zze2, connectionCallbacks, onConnectionFailedListener);
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public /* synthetic */ Api.Client zza(Context context, Looper looper, com.google.android.gms.common.internal.zze zze2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzc(context, looper, zze2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Scope SCOPE_APP_STATE = new Scope("https://www.googleapis.com/auth/appstate");
    public static final Api<Api.ApiOptions.NoOptions> API = new Api<Api.ApiOptions.NoOptions>("AppStateManager.API", zzNY, zzNX, SCOPE_APP_STATE);

    private AppStateManager() {
    }

    public static zzjb zza(GoogleApiClient googleApiClient) {
        zzu.zzb(googleApiClient != null, (Object)"GoogleApiClient parameter is required.");
        zzu.zza(googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        zzu.zza(googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the AppState API. Pass AppStateManager.API into GoogleApiClient.Builder#addApi() to use this feature.");
        return googleApiClient.zza(zzNX);
    }

    public static int getMaxStateSize(GoogleApiClient googleApiClient) {
        return AppStateManager.zza(googleApiClient).zzkV();
    }

    public static int getMaxNumKeys(GoogleApiClient googleApiClient) {
        return AppStateManager.zza(googleApiClient).zzkW();
    }

    private static StateResult zzd(final Status status) {
        return new StateResult(){

            @Override
            public Status getStatus() {
                return status;
            }

            @Override
            public StateLoadedResult getLoadedResult() {
                return null;
            }

            @Override
            public StateConflictResult getConflictResult() {
                return null;
            }

            @Override
            public void release() {
            }
        };
    }

    public static void update(GoogleApiClient googleApiClient, final int stateKey, final byte[] data) {
        googleApiClient.zzb(new zze(googleApiClient){

            @Override
            protected void zza(zzjb zzjb2) throws RemoteException {
                zzjb2.zza(null, stateKey, data);
            }
        });
    }

    public static PendingResult<StateResult> updateImmediate(GoogleApiClient googleApiClient, final int stateKey, final byte[] data) {
        return googleApiClient.zzb(new zze(googleApiClient){

            @Override
            protected void zza(zzjb zzjb2) throws RemoteException {
                zzjb2.zza(this, stateKey, data);
            }
        });
    }

    public static PendingResult<StateDeletedResult> delete(GoogleApiClient googleApiClient, final int stateKey) {
        return googleApiClient.zzb(new zzb(googleApiClient){

            @Override
            protected void zza(zzjb zzjb2) throws RemoteException {
                zzjb2.zza(this, stateKey);
            }

            public StateDeletedResult zzf(final Status status) {
                return new StateDeletedResult(){

                    @Override
                    public Status getStatus() {
                        return status;
                    }

                    @Override
                    public int getStateKey() {
                        return stateKey;
                    }
                };
            }

            @Override
            public /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzf(x0);
            }
        });
    }

    public static PendingResult<StateResult> load(GoogleApiClient googleApiClient, final int stateKey) {
        return googleApiClient.zza(new zze(googleApiClient){

            @Override
            protected void zza(zzjb zzjb2) throws RemoteException {
                zzjb2.zzb(this, stateKey);
            }
        });
    }

    public static PendingResult<StateListResult> list(GoogleApiClient googleApiClient) {
        return googleApiClient.zza(new zzc(googleApiClient){

            @Override
            protected void zza(zzjb zzjb2) throws RemoteException {
                zzjb2.zza(this);
            }
        });
    }

    public static PendingResult<StateResult> resolve(GoogleApiClient googleApiClient, final int stateKey, final String resolvedVersion, final byte[] resolvedData) {
        return googleApiClient.zzb(new zze(googleApiClient){

            @Override
            protected void zza(zzjb zzjb2) throws RemoteException {
                zzjb2.zza(this, stateKey, resolvedVersion, resolvedData);
            }
        });
    }

    public static PendingResult<Status> signOut(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb(new zzd(googleApiClient){

            @Override
            protected void zza(zzjb zzjb2) throws RemoteException {
                zzjb2.zzb(this);
            }
        });
    }

    private static abstract class zzd
    extends zza<Status> {
        public zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzb(x0);
        }
    }

    private static abstract class zzc
    extends zza<StateListResult> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public StateListResult zzg(final Status status) {
            return new StateListResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public AppStateBuffer getStateBuffer() {
                    return new AppStateBuffer(null);
                }
            };
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzg(x0);
        }
    }

    public static interface StateListResult
    extends Result {
        public AppStateBuffer getStateBuffer();
    }

    private static abstract class zzb
    extends zza<StateDeletedResult> {
        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }
    }

    public static interface StateDeletedResult
    extends Result {
        public int getStateKey();
    }

    private static abstract class zze
    extends zza<StateResult> {
        public zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public StateResult zzh(Status status) {
            return AppStateManager.zzd(status);
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzh(x0);
        }
    }

    public static interface StateConflictResult
    extends Releasable,
    Result {
        public int getStateKey();

        public String getResolvedVersion();

        public byte[] getLocalData();

        public byte[] getServerData();
    }

    public static interface StateLoadedResult
    extends Releasable,
    Result {
        public int getStateKey();

        public byte[] getLocalData();
    }

    public static interface StateResult
    extends Releasable,
    Result {
        public StateLoadedResult getLoadedResult();

        public StateConflictResult getConflictResult();
    }

    public static abstract class zza<R extends Result>
    extends zza.zza<R, zzjb> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzNX, googleApiClient);
        }
    }
}

