/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzi;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import java.util.List;

public final class TurnBasedMultiplayerImpl
implements TurnBasedMultiplayer {
    @Override
    public Intent getInboxIntent(GoogleApiClient apiClient) {
        return Games.zzd(apiClient).zzsB();
    }

    @Override
    public void registerMatchUpdateListener(GoogleApiClient apiClient, OnTurnBasedMatchUpdateReceivedListener listener) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            zzi<OnTurnBasedMatchUpdateReceivedListener> zzi2 = apiClient.zzo(listener);
            gamesClientImpl.zzb(zzi2);
        }
    }

    @Override
    public void unregisterMatchUpdateListener(GoogleApiClient apiClient) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzsE();
        }
    }

    @Override
    public Intent getSelectOpponentsIntent(GoogleApiClient apiClient, int minPlayers, int maxPlayers) {
        return Games.zzd(apiClient).zzb(minPlayers, maxPlayers, true);
    }

    @Override
    public Intent getSelectOpponentsIntent(GoogleApiClient apiClient, int minPlayers, int maxPlayers, boolean allowAutomatch) {
        return Games.zzd(apiClient).zzb(minPlayers, maxPlayers, allowAutomatch);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.InitiateMatchResult> createMatch(GoogleApiClient apiClient, final TurnBasedMatchConfig config) {
        return apiClient.zzb(new InitiateMatchImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza(this, config);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.InitiateMatchResult> rematch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.zzb(new InitiateMatchImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzc(this, matchId);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.InitiateMatchResult> acceptInvitation(GoogleApiClient apiClient, final String invitationId) {
        return apiClient.zzb(new InitiateMatchImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzd(this, invitationId);
            }
        });
    }

    @Override
    public void declineInvitation(GoogleApiClient apiClient, String invitationId) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzr(invitationId, 1);
        }
    }

    @Override
    public void dismissInvitation(GoogleApiClient apiClient, String invitationId) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzq(invitationId, 1);
        }
    }

    @Override
    public int getMaxMatchDataSize(GoogleApiClient apiClient) {
        return Games.zzd(apiClient).zzsL();
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> takeTurn(GoogleApiClient apiClient, String matchId, byte[] matchData, String pendingParticipantId) {
        return this.takeTurn(apiClient, matchId, matchData, pendingParticipantId, (ParticipantResult[])null);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> takeTurn(GoogleApiClient apiClient, final String matchId, final byte[] matchData, final String pendingParticipantId, final ParticipantResult ... results) {
        return apiClient.zzb(new UpdateMatchImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza(this, matchId, matchData, pendingParticipantId, results);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> takeTurn(GoogleApiClient apiClient, String matchId, byte[] matchData, String pendingParticipantId, List<ParticipantResult> results) {
        ParticipantResult[] participantResultArray = results == null ? null : results.toArray(new ParticipantResult[results.size()]);
        return this.takeTurn(apiClient, matchId, matchData, pendingParticipantId, participantResultArray);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> finishMatch(GoogleApiClient apiClient, String matchId) {
        return this.finishMatch(apiClient, matchId, null, (ParticipantResult[])null);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> finishMatch(GoogleApiClient apiClient, final String matchId, final byte[] matchData, final ParticipantResult ... results) {
        return apiClient.zzb(new UpdateMatchImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza(this, matchId, matchData, results);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> finishMatch(GoogleApiClient apiClient, String matchId, byte[] matchData, List<ParticipantResult> results) {
        ParticipantResult[] participantResultArray = results == null ? null : results.toArray(new ParticipantResult[results.size()]);
        return this.finishMatch(apiClient, matchId, matchData, participantResultArray);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LeaveMatchResult> leaveMatch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.zzb(new LeaveMatchImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zze(this, matchId);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LeaveMatchResult> leaveMatchDuringTurn(GoogleApiClient apiClient, final String matchId, final String pendingParticipantId) {
        return apiClient.zzb(new LeaveMatchImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza(this, matchId, pendingParticipantId);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.CancelMatchResult> cancelMatch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.zzb(new CancelMatchImpl(matchId, apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzf(this, matchId);
            }
        });
    }

    @Override
    public void dismissMatch(GoogleApiClient apiClient, String matchId) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzcN(matchId);
        }
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LoadMatchesResult> loadMatchesByStatus(GoogleApiClient apiClient, int[] matchTurnStatuses) {
        return this.loadMatchesByStatus(apiClient, 0, matchTurnStatuses);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LoadMatchesResult> loadMatchesByStatus(GoogleApiClient apiClient, final int invitationSortOrder, final int[] matchTurnStatuses) {
        return apiClient.zza(new LoadMatchesImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza(this, invitationSortOrder, matchTurnStatuses);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LoadMatchResult> loadMatch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.zza(new LoadMatchImpl(apiClient){

            @Override
            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzg(this, matchId);
            }
        });
    }

    private static abstract class LoadMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.LoadMatchResult> {
        private LoadMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.LoadMatchResult zzaB(final Status status) {
            return new TurnBasedMultiplayer.LoadMatchResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzaB(x0);
        }
    }

    private static abstract class LoadMatchesImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.LoadMatchesResult> {
        private LoadMatchesImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.LoadMatchesResult zzaC(final Status status) {
            return new TurnBasedMultiplayer.LoadMatchesResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public void release() {
                }

                @Override
                public LoadMatchesResponse getMatches() {
                    return new LoadMatchesResponse(new Bundle());
                }
            };
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzaC(x0);
        }
    }

    private static abstract class CancelMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.CancelMatchResult> {
        private final String zzKI;

        public CancelMatchImpl(String id, GoogleApiClient googleApiClient) {
            super(googleApiClient);
            this.zzKI = id;
        }

        public TurnBasedMultiplayer.CancelMatchResult zzay(final Status status) {
            return new TurnBasedMultiplayer.CancelMatchResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public String getMatchId() {
                    return CancelMatchImpl.this.zzKI;
                }
            };
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzay(x0);
        }
    }

    private static abstract class LeaveMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.LeaveMatchResult> {
        private LeaveMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.LeaveMatchResult zzaA(final Status status) {
            return new TurnBasedMultiplayer.LeaveMatchResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzaA(x0);
        }
    }

    private static abstract class UpdateMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.UpdateMatchResult> {
        private UpdateMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.UpdateMatchResult zzaD(final Status status) {
            return new TurnBasedMultiplayer.UpdateMatchResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzaD(x0);
        }
    }

    private static abstract class InitiateMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.InitiateMatchResult> {
        private InitiateMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.InitiateMatchResult zzaz(final Status status) {
            return new TurnBasedMultiplayer.InitiateMatchResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzaz(x0);
        }
    }
}

