/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntity;
import java.util.ArrayList;
import java.util.List;

public final class GameRequestRef
extends zzc
implements GameRequest {
    private final int zzaoG;

    public GameRequestRef(DataHolder holder, int dataRow, int numChildren) {
        super(holder, dataRow);
        this.zzaoG = numChildren;
    }

    @Override
    public String getRequestId() {
        return this.getString("external_request_id");
    }

    @Override
    public Game getGame() {
        return new GameRef(this.zzWu, this.zzYs);
    }

    @Override
    public Player getSender() {
        return new PlayerRef(this.zzWu, this.zzne(), "sender_");
    }

    @Override
    public List<Player> getRecipients() {
        ArrayList<Player> arrayList = new ArrayList<Player>(this.zzaoG);
        for (int i = 0; i < this.zzaoG; ++i) {
            arrayList.add(new PlayerRef(this.zzWu, this.zzYs + i, "recipient_"));
        }
        return arrayList;
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.getByteArray("data");
    }

    @Override
    public int getType() {
        return this.getInteger("type");
    }

    @Override
    public long getCreationTimestamp() {
        return this.getLong("creation_timestamp");
    }

    @Override
    public long getExpirationTimestamp() {
        return this.getLong("expiration_timestamp");
    }

    @Override
    public int getRecipientStatus(String playerId) {
        for (int i = this.zzYs; i < this.zzYs + this.zzaoG; ++i) {
            int n = this.zzWu.zzbh(i);
            String string2 = this.zzWu.zzd("recipient_external_player_id", i, n);
            if (!string2.equals(playerId)) continue;
            return this.zzWu.zzc("recipient_status", i, n);
        }
        return -1;
    }

    @Override
    public int getStatus() {
        return this.getInteger("status");
    }

    @Override
    public GameRequest freeze() {
        return new GameRequestEntity(this);
    }

    @Override
    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    @Override
    public boolean equals(Object obj) {
        return GameRequestEntity.zza(this, obj);
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntity gameRequestEntity = (GameRequestEntity)this.freeze();
        gameRequestEntity.writeToParcel(dest, flags);
    }
}

