/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.text.TextUtils;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.images.WebImage;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzjz {
    private static final zzl zzQW = new zzl("MetadataUtils");
    private static final String[] zzVs = new String[]{"Z", "+hh", "+hhmm", "+hh:mm"};
    private static final String zzVt = "yyyyMMdd'T'HHmmss" + zzVs[0];

    public static void zza(List<WebImage> list, JSONObject jSONObject) {
        try {
            list.clear();
            JSONArray jSONArray = jSONObject.getJSONArray("images");
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                try {
                    list.add(new WebImage(jSONObject2));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static void zza(JSONObject jSONObject, List<WebImage> list) {
        if (list != null && !list.isEmpty()) {
            JSONArray jSONArray = new JSONArray();
            for (WebImage webImage : list) {
                jSONArray.put((Object)webImage.toJson());
            }
            try {
                jSONObject.put("images", (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public static String zza(Calendar calendar) {
        if (calendar == null) {
            zzQW.zzb("Calendar object cannot be null", new Object[0]);
            return null;
        }
        String string2 = zzVt;
        if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) {
            string2 = "yyyyMMdd";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        String string3 = simpleDateFormat.format(calendar.getTime());
        if (string3.endsWith("+0000")) {
            string3 = string3.replace("+0000", zzVs[0]);
        }
        return string3;
    }

    public static Calendar zzbK(String string2) {
        Date date;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzQW.zzb("Input string is empty or null", new Object[0]);
            return null;
        }
        String string3 = zzjz.zzbL(string2);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            zzQW.zzb("Invalid date format", new Object[0]);
            return null;
        }
        String string4 = zzjz.zzbM(string2);
        String string5 = "yyyyMMdd";
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            string3 = string3 + "T" + string4;
            string5 = string4.length() == "HHmmss".length() ? "yyyyMMdd'T'HHmmss" : zzVt;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        try {
            date = new SimpleDateFormat(string5).parse(string3);
        }
        catch (ParseException parseException) {
            zzQW.zzb("Error parsing string: %s", parseException.getMessage());
            return null;
        }
        calendar.setTime(date);
        return calendar;
    }

    private static String zzbL(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzQW.zzb("Input string is empty or null", new Object[0]);
            return null;
        }
        try {
            return string2.substring(0, "yyyyMMdd".length());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzQW.zze("Error extracting the date: %s", indexOutOfBoundsException.getMessage());
            return null;
        }
    }

    private static String zzbM(String string2) {
        String string3;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzQW.zzb("string is empty or null", new Object[0]);
            return null;
        }
        int n = string2.indexOf(84);
        if (n++ != "yyyyMMdd".length()) {
            zzQW.zzb("T delimeter is not found", new Object[0]);
            return null;
        }
        try {
            string3 = string2.substring(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzQW.zzb("Error extracting the time substring: %s", indexOutOfBoundsException.getMessage());
            return null;
        }
        if (string3.length() == "HHmmss".length()) {
            return string3;
        }
        char c = string3.charAt("HHmmss".length());
        switch (c) {
            case 'Z': {
                if (string3.length() == "HHmmss".length() + zzVs[0].length()) {
                    return string3.substring(0, string3.length() - 1) + "+0000";
                }
                return null;
            }
            case '+': 
            case '-': {
                if (!zzjz.zzbN(string3)) break;
                return string3.replaceAll("([\\+\\-]\\d\\d):(\\d\\d)", "$1$2");
            }
        }
        return null;
    }

    private static boolean zzbN(String string2) {
        int n;
        int n2 = string2.length();
        return n2 == (n = "HHmmss".length()) + zzVs[1].length() || n2 == n + zzVs[2].length() || n2 == n + zzVs[3].length();
    }
}

