/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.zzm;
import java.util.Locale;

public class ParcelableGeofence
implements SafeParcelable,
Geofence {
    private final int zzCY;
    private final String zzDK;
    private final long zzazj;
    private final short zzaxA;
    private final double zzaxB;
    private final double zzaxC;
    private final float zzaxD;
    private final int zzaxy;
    private final int zzaxE;
    private final int zzaxF;
    public static final zzm CREATOR = new zzm();

    public ParcelableGeofence(int version, String requestId, int transitionTypes, short type, double latitude, double longitude, float radius, long expireAt, int notificationResponsiveness, int loiteringDelayMillis) {
        ParcelableGeofence.zzdn(requestId);
        ParcelableGeofence.zze(radius);
        ParcelableGeofence.zza(latitude, longitude);
        transitionTypes = ParcelableGeofence.zzgG(transitionTypes);
        this.zzCY = version;
        this.zzaxA = type;
        this.zzDK = requestId;
        this.zzaxB = latitude;
        this.zzaxC = longitude;
        this.zzaxD = radius;
        this.zzazj = expireAt;
        this.zzaxy = transitionTypes;
        this.zzaxE = notificationResponsiveness;
        this.zzaxF = loiteringDelayMillis;
    }

    public ParcelableGeofence(String requestId, int transitionTypes, short type, double latitude, double longitude, float radius, long expireAt, int notificationResponsiveness, int loiteringDelayMillis) {
        this(1, requestId, transitionTypes, type, latitude, longitude, radius, expireAt, notificationResponsiveness, loiteringDelayMillis);
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    public short zzuA() {
        return this.zzaxA;
    }

    public double getLatitude() {
        return this.zzaxB;
    }

    public double getLongitude() {
        return this.zzaxC;
    }

    public float zzuB() {
        return this.zzaxD;
    }

    @Override
    public String getRequestId() {
        return this.zzDK;
    }

    public long getExpirationTime() {
        return this.zzazj;
    }

    public int zzuC() {
        return this.zzaxy;
    }

    public int getNotificationResponsiveness() {
        return this.zzaxE;
    }

    public int zzuD() {
        return this.zzaxF;
    }

    private static void zzdn(String string2) {
        if (string2 == null || string2.length() > 100) {
            throw new IllegalArgumentException("requestId is null or too long: " + string2);
        }
    }

    private static void zze(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("invalid radius: " + f);
        }
    }

    private static void zza(double d, double d2) {
        if (d > 90.0 || d < -90.0) {
            throw new IllegalArgumentException("invalid latitude: " + d);
        }
        if (d2 > 180.0 || d2 < -180.0) {
            throw new IllegalArgumentException("invalid longitude: " + d2);
        }
    }

    private static int zzgG(int n) {
        int n2 = n & 7;
        if (n2 == 0) {
            throw new IllegalArgumentException("No supported transition specified: " + n);
        }
        return n2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzm.zza(this, parcel, flags);
    }

    private static String zzgH(int n) {
        switch (n) {
            case 1: {
                return "CIRCLE";
            }
        }
        return null;
    }

    public static ParcelableGeofence zzn(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        ParcelableGeofence parcelableGeofence = CREATOR.zzem(parcel);
        parcel.recycle();
        return parcelableGeofence;
    }

    public String toString() {
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", ParcelableGeofence.zzgH(this.zzaxA), this.zzDK, this.zzaxy, this.zzaxB, this.zzaxC, Float.valueOf(this.zzaxD), this.zzaxE / 1000, this.zzaxF, this.zzazj);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.zzaxB);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzaxC);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        n2 = 31 * n2 + Float.floatToIntBits(this.zzaxD);
        n2 = 31 * n2 + this.zzaxA;
        n2 = 31 * n2 + this.zzaxy;
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParcelableGeofence)) {
            return false;
        }
        ParcelableGeofence parcelableGeofence = (ParcelableGeofence)obj;
        if (this.zzaxD != parcelableGeofence.zzaxD) {
            return false;
        }
        if (this.zzaxB != parcelableGeofence.zzaxB) {
            return false;
        }
        if (this.zzaxC != parcelableGeofence.zzaxC) {
            return false;
        }
        return this.zzaxA == parcelableGeofence.zzaxA;
    }
}

