/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.maps.model.IndoorLevel;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.internal.zzg;
import com.google.android.gms.maps.model.internal.zzh;
import java.util.ArrayList;
import java.util.List;

public final class IndoorBuilding {
    private final zzg zzaDl;

    public IndoorBuilding(zzg delegate) {
        this.zzaDl = zzu.zzu(delegate);
    }

    public int getDefaultLevelIndex() {
        try {
            return this.zzaDl.getActiveLevelIndex();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public int getActiveLevelIndex() {
        try {
            return this.zzaDl.getActiveLevelIndex();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public List<IndoorLevel> getLevels() {
        try {
            List<IBinder> list = this.zzaDl.getLevels();
            ArrayList<IndoorLevel> arrayList = new ArrayList<IndoorLevel>(list.size());
            for (IBinder iBinder : list) {
                arrayList.add(new IndoorLevel(zzh.zza.zzcO(iBinder)));
            }
            return arrayList;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public boolean isUnderground() {
        try {
            return this.zzaDl.isUnderground();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof IndoorBuilding)) {
            return false;
        }
        try {
            return this.zzaDl.zzb(((IndoorBuilding)other).zzaDl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public int hashCode() {
        try {
            return this.zzaDl.hashCodeRemote();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }
}

