/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.internal.zzad;
import com.google.android.gms.internal.zzae;
import com.google.android.gms.internal.zzag;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzdc;
import com.google.android.gms.tagmanager.zzdd;
import com.google.android.gms.tagmanager.zzdf;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class zzdg
extends zzdd {
    private static final String ID = zzad.zzcB.toString();
    private static final String zzaOC = zzae.zzdi.toString();
    private static final String zzaOD = zzae.zzds.toString();
    private static final String zzaOE = zzae.zzeN.toString();
    private static final String zzaOF = zzae.zzeH.toString();
    private static final String zzaOG = zzae.zzeG.toString();
    private static final String zzaOH = zzae.zzdr.toString();
    private static final String zzaOI = zzae.zzhk.toString();
    private static final String zzaOJ = zzae.zzhn.toString();
    private static final String zzaOK = zzae.zzhp.toString();
    private static final List<String> zzaOL = Arrays.asList("detail", "checkout", "checkout_option", "click", "add", "remove", "purchase", "refund");
    private static final Pattern zzaOM = Pattern.compile("dimension(\\d+)");
    private static final Pattern zzaON = Pattern.compile("metric(\\d+)");
    private static Map<String, String> zzaOO;
    private static Map<String, String> zzaOP;
    private final Set<String> zzaOQ;
    private final zzdc zzaOR;
    private final DataLayer zzaKz;

    public zzdg(Context context, DataLayer dataLayer) {
        this(context, dataLayer, new zzdc(context));
    }

    zzdg(Context context, DataLayer dataLayer, zzdc zzdc2) {
        super(ID, new String[0]);
        this.zzaKz = dataLayer;
        this.zzaOR = zzdc2;
        this.zzaOQ = new HashSet<String>();
        this.zzaOQ.add("");
        this.zzaOQ.add("0");
        this.zzaOQ.add("false");
    }

    private boolean zzi(Map<String, zzag.zza> map, String string2) {
        zzag.zza zza2 = map.get(string2);
        return zza2 == null ? false : zzdf.zzk(zza2);
    }

    @Override
    public void zzG(Map<String, zzag.zza> map) {
        Tracker tracker = this.zzaOR.zzeG("_GTM_DEFAULT_TRACKER_");
        tracker.enableAdvertisingIdCollection(this.zzi(map, "collect_adid"));
        if (this.zzi(map, zzaOE)) {
            this.zzb(tracker, map);
        } else if (this.zzi(map, zzaOD)) {
            tracker.send(this.zzm(map.get(zzaOH)));
        } else if (this.zzi(map, zzaOI)) {
            this.zza(tracker, map);
        } else {
            zzbg.zzaC("Ignoring unknown tag.");
        }
    }

    private String zzeO(String string2) {
        Object object = this.zzaKz.get(string2);
        return object == null ? null : object.toString();
    }

    private List<Map<String, String>> zzeP(String string2) {
        Object object = this.zzaKz.get(string2);
        if (object == null) {
            return null;
        }
        if (!(object instanceof List)) {
            throw new IllegalArgumentException("transactionProducts should be of type List.");
        }
        List list = (List)object;
        for (Object e : list) {
            if (e instanceof Map) continue;
            throw new IllegalArgumentException("Each element of transactionProducts should be of type Map.");
        }
        List list2 = (List)object;
        return list2;
    }

    private void zzd(Map<String, String> map, String string2, String string3) {
        if (string3 != null) {
            map.put(string2, string3);
        }
    }

    private void zza(Tracker tracker, Map<String, zzag.zza> map) {
        String string2 = this.zzeO("transactionId");
        if (string2 == null) {
            zzbg.zzaz("Cannot find transactionId in data layer.");
            return;
        }
        LinkedList<Map<String, String>> linkedList = new LinkedList<Map<String, String>>();
        try {
            Map<String, String> map2 = this.zzm(map.get(zzaOH));
            map2.put("&t", "transaction");
            Map<String, String> map3 = this.zzQ(map);
            for (Map.Entry<String, String> iterator : map3.entrySet()) {
                this.zzd(map2, iterator.getValue(), this.zzeO(iterator.getKey()));
            }
            linkedList.add(map2);
            List<Map<String, String>> list = this.zzeP("transactionProducts");
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Map map4 = (Map)iterator.next();
                    if (map4.get("name") == null) {
                        zzbg.zzaz("Unable to send transaction item hit due to missing 'name' field.");
                        return;
                    }
                    Map<String, String> map5 = this.zzm(map.get(zzaOH));
                    map5.put("&t", "item");
                    map5.put("&ti", string2);
                    Map<String, String> map6 = this.zzR(map);
                    for (Map.Entry<String, String> entry : map6.entrySet()) {
                        this.zzd(map5, entry.getValue(), (String)map4.get(entry.getKey()));
                    }
                    linkedList.add(map5);
                }
            }
            for (Map map7 : linkedList) {
                tracker.send(map7);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            zzbg.zzb("Unable to send transaction", illegalArgumentException);
            return;
        }
    }

    private void zzb(Tracker tracker, Map<String, zzag.zza> map) {
        Object object;
        HitBuilders.ScreenViewBuilder screenViewBuilder = new HitBuilders.ScreenViewBuilder();
        Map<String, String> map2 = this.zzm(map.get(zzaOH));
        screenViewBuilder.setAll(map2);
        Map map3 = null;
        if (this.zzi(map, zzaOF)) {
            object = this.zzaKz.get("ecommerce");
            if (object instanceof Map) {
                map3 = (Map)object;
            }
        } else {
            object = zzdf.zzl(map.get(zzaOG));
            if (object instanceof Map) {
                map3 = (Map)object;
            }
        }
        if (map3 != null) {
            Object object2;
            Object object3;
            List list;
            Object v;
            object = map2.get("&cu");
            if (object == null) {
                object = (String)map3.get("currencyCode");
            }
            if (object != null) {
                screenViewBuilder.set("&cu", (String)object);
            }
            if ((v = map3.get("impressions")) instanceof List) {
                list = (List)v;
                for (Iterator<String> iterator : list) {
                    try {
                        Product runtimeException = this.zzP((Map<String, Object>)((Object)iterator));
                        screenViewBuilder.addImpression(runtimeException, (String)iterator.get("list"));
                    }
                    catch (RuntimeException runtimeException) {
                        zzbg.zzaz("Failed to extract a product from DataLayer. " + runtimeException.getMessage());
                    }
                }
            }
            list = null;
            if (map3.containsKey("promoClick")) {
                object3 = (Map)map3.get("promoClick");
                list = (List)object3.get("promotions");
            } else if (map3.containsKey("promoView")) {
                object3 = (Map)map3.get("promoView");
                list = (List)object3.get("promotions");
            }
            boolean bl = true;
            if (list != null) {
                for (Map map4 : list) {
                    try {
                        object2 = this.zzO(map4);
                        screenViewBuilder.addPromotion((Promotion)object2);
                    }
                    catch (RuntimeException runtimeException) {
                        zzbg.zzaz("Failed to extract a promotion from DataLayer. " + runtimeException.getMessage());
                    }
                }
                if (map3.containsKey("promoClick")) {
                    screenViewBuilder.set("&promoa", "click");
                    bl = false;
                } else {
                    screenViewBuilder.set("&promoa", "view");
                }
            }
            if (bl) {
                for (String string2 : zzaOL) {
                    if (!map3.containsKey(string2)) continue;
                    object2 = (Map)map3.get(string2);
                    List list2 = (List)object2.get("products");
                    if (list2 != null) {
                        for (Map map5 : list2) {
                            try {
                                Product product = this.zzP(map5);
                                screenViewBuilder.addProduct(product);
                            }
                            catch (RuntimeException runtimeException) {
                                zzbg.zzaz("Failed to extract a product from DataLayer. " + runtimeException.getMessage());
                            }
                        }
                    }
                    try {
                        Object object4;
                        if (object2.containsKey("actionField")) {
                            Map map5;
                            map5 = (Map)object2.get("actionField");
                            object4 = this.zze(string2, map5);
                        } else {
                            object4 = new ProductAction(string2);
                        }
                        screenViewBuilder.setProductAction((ProductAction)object4);
                    }
                    catch (RuntimeException runtimeException) {
                        zzbg.zzaz("Failed to extract a product action from DataLayer. " + runtimeException.getMessage());
                    }
                    break;
                }
            }
        }
        tracker.send(screenViewBuilder.build());
    }

    private ProductAction zze(String string2, Map<String, Object> map) {
        ProductAction productAction = new ProductAction(string2);
        Object object = map.get("id");
        if (object != null) {
            productAction.setTransactionId(String.valueOf(object));
        }
        if ((object = map.get("affiliation")) != null) {
            productAction.setTransactionAffiliation(String.valueOf(object));
        }
        if ((object = map.get("coupon")) != null) {
            productAction.setTransactionCouponCode(String.valueOf(object));
        }
        if ((object = map.get("list")) != null) {
            productAction.setProductActionList(String.valueOf(object));
        }
        if ((object = map.get("option")) != null) {
            productAction.setCheckoutOptions(String.valueOf(object));
        }
        if ((object = map.get("revenue")) != null) {
            productAction.setTransactionRevenue(this.zzM(object));
        }
        if ((object = map.get("tax")) != null) {
            productAction.setTransactionTax(this.zzM(object));
        }
        if ((object = map.get("shipping")) != null) {
            productAction.setTransactionShipping(this.zzM(object));
        }
        if ((object = map.get("step")) != null) {
            productAction.setCheckoutStep(this.zzN(object));
        }
        return productAction;
    }

    private Promotion zzO(Map<String, String> map) {
        Promotion promotion = new Promotion();
        String string2 = map.get("id");
        if (string2 != null) {
            promotion.setId(String.valueOf(string2));
        }
        if ((string2 = map.get("name")) != null) {
            promotion.setName(String.valueOf(string2));
        }
        if ((string2 = map.get("creative")) != null) {
            promotion.setCreative(String.valueOf(string2));
        }
        if ((string2 = map.get("position")) != null) {
            promotion.setPosition(String.valueOf(string2));
        }
        return promotion;
    }

    private Product zzP(Map<String, Object> map) {
        Product product = new Product();
        Object object = map.get("id");
        if (object != null) {
            product.setId(String.valueOf(object));
        }
        if ((object = map.get("name")) != null) {
            product.setName(String.valueOf(object));
        }
        if ((object = map.get("brand")) != null) {
            product.setBrand(String.valueOf(object));
        }
        if ((object = map.get("category")) != null) {
            product.setCategory(String.valueOf(object));
        }
        if ((object = map.get("variant")) != null) {
            product.setVariant(String.valueOf(object));
        }
        if ((object = map.get("coupon")) != null) {
            product.setCouponCode(String.valueOf(object));
        }
        if ((object = map.get("position")) != null) {
            product.setPosition(this.zzN(object));
        }
        if ((object = map.get("price")) != null) {
            product.setPrice(this.zzM(object));
        }
        if ((object = map.get("quantity")) != null) {
            product.setQuantity(this.zzN(object));
        }
        for (String string2 : map.keySet()) {
            Matcher matcher = zzaOM.matcher(string2);
            if (matcher.matches()) {
                int n = 0;
                try {
                    n = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    zzbg.zzaC("illegal number in custom dimension value: " + string2);
                    continue;
                }
                product.setCustomDimension(n, String.valueOf(map.get(string2)));
                continue;
            }
            Matcher matcher2 = zzaON.matcher(string2);
            if (!matcher2.matches()) continue;
            int n = 0;
            try {
                n = Integer.parseInt(matcher2.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                zzbg.zzaC("illegal number in custom metric value: " + string2);
                continue;
            }
            product.setCustomMetric(n, this.zzN(map.get(string2)));
        }
        return product;
    }

    private Map<String, String> zzc(zzag.zza zza2) {
        Object object = zzdf.zzl(zza2);
        if (!(object instanceof Map)) {
            return null;
        }
        Map map = (Map)object;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            linkedHashMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return linkedHashMap;
    }

    private Map<String, String> zzm(zzag.zza zza2) {
        if (zza2 == null) {
            return new HashMap<String, String>();
        }
        Map<String, String> map = this.zzc(zza2);
        if (map == null) {
            return new HashMap<String, String>();
        }
        String string2 = map.get("&aip");
        if (string2 != null && this.zzaOQ.contains(string2.toLowerCase())) {
            map.remove("&aip");
        }
        return map;
    }

    private Map<String, String> zzQ(Map<String, zzag.zza> map) {
        zzag.zza zza2 = map.get(zzaOJ);
        if (zza2 != null) {
            return this.zzc(zza2);
        }
        if (zzaOO == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("transactionId", "&ti");
            hashMap.put("transactionAffiliation", "&ta");
            hashMap.put("transactionTax", "&tt");
            hashMap.put("transactionShipping", "&ts");
            hashMap.put("transactionTotal", "&tr");
            hashMap.put("transactionCurrency", "&cu");
            zzaOO = hashMap;
        }
        return zzaOO;
    }

    private Map<String, String> zzR(Map<String, zzag.zza> map) {
        zzag.zza zza2 = map.get(zzaOK);
        if (zza2 != null) {
            return this.zzc(zza2);
        }
        if (zzaOP == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "&in");
            hashMap.put("sku", "&ic");
            hashMap.put("category", "&iv");
            hashMap.put("price", "&ip");
            hashMap.put("quantity", "&iq");
            hashMap.put("currency", "&cu");
            zzaOP = hashMap;
        }
        return zzaOP;
    }

    private Double zzM(Object object) {
        if (object instanceof String) {
            try {
                return Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Cannot convert the object to Double: " + numberFormatException.getMessage());
            }
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n.doubleValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        throw new RuntimeException("Cannot convert the object to Double: " + object.toString());
    }

    private Integer zzN(Object object) {
        if (object instanceof String) {
            try {
                return Integer.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Cannot convert the object to Integer: " + numberFormatException.getMessage());
            }
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return d.intValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new RuntimeException("Cannot convert the object to Integer: " + object.toString());
    }
}

