/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzu;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzn
extends zzd {
    private volatile String zzJd;
    private Future<String> zzKG;

    protected zzn(zzf zzf2) {
        super(zzf2);
    }

    @Override
    protected void zzhn() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zziP() {
        this.zzia();
        zzn zzn2 = this;
        synchronized (zzn2) {
            if (this.zzJd == null) {
                this.zzKG = this.zzhS().zzb(new Callable<String>(){

                    public String zziU() throws Exception {
                        return zzn.this.zziR();
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.zziU();
                    }
                });
            }
            if (this.zzKG != null) {
                try {
                    this.zzJd = this.zzKG.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzJd = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzJd = "0";
                }
                if (this.zzJd == null) {
                    this.zzJd = "0";
                }
                this.zza("Loaded clientId", this.zzJd);
                this.zzKG = null;
            }
            return this.zzJd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String zziQ() {
        zzn zzn2 = this;
        synchronized (zzn2) {
            this.zzJd = null;
            this.zzKG = this.zzhS().zzb(new Callable<String>(){

                public String zziU() throws Exception {
                    return zzn.this.zziS();
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.zziU();
                }
            });
        }
        return this.zziP();
    }

    String zziR() {
        String string2 = this.zzX(this.zzhS().getContext());
        if (string2 == null) {
            string2 = this.zziS();
        }
        return string2;
    }

    private String zziS() {
        String string2 = this.zziT();
        try {
            if (!this.zzg(this.zzhS().getContext(), string2)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string2;
    }

    protected String zziT() {
        return UUID.randomUUID().toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String zzX(Context context) {
        zzu.zzbZ("ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, byArray.length);
            if (fileInputStream.available() > 0) {
                this.zzaW("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                String string2 = null;
                return string2;
            }
            if (n < 14) {
                this.zzaW("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                String string3 = null;
                return string3;
            }
            fileInputStream.close();
            String string4 = new String(byArray, 0, n);
            this.zza("Read client id from disk", string4);
            String string5 = string4;
            return string5;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string6 = null;
            return string6;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            String string7 = null;
            return string7;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzg(Context context, String string2) {
        zzu.zzcj(string2);
        zzu.zzbZ("ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string2);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string2.getBytes());
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }
}

