/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appdatasearch;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.appdatasearch.DocumentContents;
import com.google.android.gms.appdatasearch.DocumentId;
import com.google.android.gms.appdatasearch.DocumentSection;
import com.google.android.gms.appdatasearch.RegisterSectionInfo;
import com.google.android.gms.appdatasearch.zzj;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zznj;
import com.google.android.gms.internal.zzrn;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.CRC32;

public class UsageInfo
implements SafeParcelable {
    public static final zzj CREATOR = new zzj();
    final int zzCY;
    final DocumentId zzNH;
    final long zzNI;
    int zzNJ;
    public final String zztt;
    final DocumentContents zzNK;
    final boolean zzNL;
    int zzNM;
    int zzNN;

    private UsageInfo(DocumentId documentId, long timestampMs, int usageType, String query, DocumentContents document, boolean isDeviceOnly, int taskPosition, int eventStatus) {
        this(1, documentId, timestampMs, usageType, query, document, isDeviceOnly, taskPosition, eventStatus);
    }

    public UsageInfo(String packageName, Intent viewIntent, String title, Uri webUrl, String schemaOrgType, List<AppIndexApi.AppIndexingLink> outLinks, int eventStatus) {
        this(1, UsageInfo.zza(packageName, viewIntent), System.currentTimeMillis(), 0, null, UsageInfo.zza(viewIntent, title, webUrl, schemaOrgType, outLinks).zzkJ(), false, -1, eventStatus);
    }

    UsageInfo(int versionCode, DocumentId documentId, long timestamp, int usageType, String query, DocumentContents document, boolean isDeviceOnly, int taskPosition, int eventStatus) {
        this.zzCY = versionCode;
        this.zzNH = documentId;
        this.zzNI = timestamp;
        this.zzNJ = usageType;
        this.zztt = query;
        this.zzNK = document;
        this.zzNL = isDeviceOnly;
        this.zzNM = taskPosition;
        this.zzNN = eventStatus;
    }

    public static DocumentId zza(String string2, Intent intent) {
        return UsageInfo.zzo(string2, UsageInfo.zzg(intent));
    }

    private static DocumentId zzo(String string2, String string3) {
        return new DocumentId(string2, "", string3);
    }

    private static DocumentSection zzbt(String string2) {
        return new DocumentSection(string2, new RegisterSectionInfo.zza("title").zzaj(1).zzK(true).zzbs("name").zzkM(), "text1");
    }

    private static DocumentSection zzh(Uri uri) {
        return new DocumentSection(uri.toString(), new RegisterSectionInfo.zza("web_url").zzaj(4).zzJ(true).zzbs("url").zzkM());
    }

    private static DocumentSection zzp(String string2, String string3) {
        return new DocumentSection(string3, new RegisterSectionInfo.zza(string2).zzJ(true).zzkM(), string2);
    }

    private static String zzg(Intent intent) {
        String string2 = intent.toUri(1);
        CRC32 cRC32 = new CRC32();
        try {
            cRC32.update(string2.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        return Long.toHexString(cRC32.getValue());
    }

    private static DocumentSection zzh(List<AppIndexApi.AppIndexingLink> list) {
        zznj.zza zza2 = new zznj.zza();
        zznj.zza.zza[] zzaArray = new zznj.zza.zza[list.size()];
        for (int i = 0; i < zzaArray.length; ++i) {
            zzaArray[i] = new zznj.zza.zza();
            AppIndexApi.AppIndexingLink appIndexingLink = list.get(i);
            zzaArray[i].zzawm = appIndexingLink.appIndexingUrl.toString();
            zzaArray[i].viewId = appIndexingLink.viewId;
            if (appIndexingLink.webUrl == null) continue;
            zzaArray[i].zzawn = appIndexingLink.webUrl.toString();
        }
        zza2.zzawk = zzaArray;
        return new DocumentSection(zzrn.zzf(zza2), new RegisterSectionInfo.zza("outlinks").zzJ(true).zzbs(".private:outLinks").zzbr("blob").zzkM());
    }

    public static DocumentContents.zza zza(Intent intent, String string2, Uri uri, String string3, List<AppIndexApi.AppIndexingLink> list) {
        String string4;
        Bundle bundle;
        ComponentName componentName;
        String string5;
        String string6;
        DocumentContents.zza zza2 = new DocumentContents.zza();
        zza2.zza(UsageInfo.zzbt(string2));
        if (uri != null) {
            zza2.zza(UsageInfo.zzh(uri));
        }
        if (list != null) {
            zza2.zza(UsageInfo.zzh(list));
        }
        if ((string6 = intent.getAction()) != null) {
            zza2.zza(UsageInfo.zzp("intent_action", string6));
        }
        if ((string5 = intent.getDataString()) != null) {
            zza2.zza(UsageInfo.zzp("intent_data", string5));
        }
        if ((componentName = intent.getComponent()) != null) {
            zza2.zza(UsageInfo.zzp("intent_activity", componentName.getClassName()));
        }
        if ((bundle = intent.getExtras()) != null && (string4 = bundle.getString("intent_extra_data_key")) != null) {
            zza2.zza(UsageInfo.zzp("intent_extra_data", string4));
        }
        return zza2.zzbp(string3).zzI(true);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzj.zza(this, dest, flags);
    }

    public String toString() {
        return String.format("UsageInfo[documentId=%s, timestamp=%d, usageType=%d, status=%d]", this.zzNH, this.zzNI, this.zzNJ, this.zzNN);
    }

    public static final class zza {
        private DocumentId zzNH;
        private long zzNI = -1L;
        private int zzNJ = -1;
        private String zzHZ;
        private DocumentContents zzNK;
        private boolean zzNL = false;
        private int zzNM = -1;
        private int zzNN = 0;

        public zza zza(DocumentId documentId) {
            this.zzNH = documentId;
            return this;
        }

        public zza zzw(long l) {
            this.zzNI = l;
            return this;
        }

        public zza zzal(int n) {
            this.zzNJ = n;
            return this;
        }

        public zza zza(DocumentContents documentContents) {
            this.zzNK = documentContents;
            return this;
        }

        public zza zzL(boolean bl) {
            this.zzNL = bl;
            return this;
        }

        public zza zzam(int n) {
            this.zzNN = n;
            return this;
        }

        public UsageInfo zzkN() {
            return new UsageInfo(this.zzNH, this.zzNI, this.zzNJ, this.zzHZ, this.zzNK, this.zzNL, this.zzNM, this.zzNN);
        }
    }
}

