/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzf;
import com.google.android.gms.common.api.zzh;
import com.google.android.gms.common.api.zzi;
import com.google.android.gms.common.api.zzl;
import com.google.android.gms.common.api.zzm;
import com.google.android.gms.common.api.zzn;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.internal.zzkl;
import com.google.android.gms.internal.zzps;
import com.google.android.gms.internal.zzpt;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class zzg
implements GoogleApiClient {
    private final Lock zzWL = new ReentrantLock();
    private final Condition zzXm;
    final zzj zzXn;
    private final int zzWB;
    private final int zzWC;
    private final Context mContext;
    private final Looper zzWt;
    final Queue<zze<?>> zzXo = new LinkedList();
    private volatile boolean zzXp;
    private long zzXq = 120000L;
    private long zzXr = 5000L;
    final zza zzXs;
    BroadcastReceiver zzXt;
    final Map<Api.ClientKey<?>, Api.Client> zzXu = new HashMap();
    final Map<Api.ClientKey<?>, ConnectionResult> zzXv = new HashMap();
    Set<Scope> zzXw = new HashSet<Scope>();
    final com.google.android.gms.common.internal.zze zzXa;
    final Map<Api<?>, Integer> zzXb;
    final Api.zza<? extends zzps, zzpt> zzWE;
    private volatile zzh zzXx;
    private ConnectionResult zzXy = null;
    private final Set<zzi<?>> zzXz = Collections.newSetFromMap(new WeakHashMap());
    final Set<zze<?>> zzXA = Collections.newSetFromMap(new ConcurrentHashMap(16, 0.75f, 2));
    private final zzc zzXB = new zzc(){

        @Override
        public void zzc(zze<?> zze2) {
            zzg.this.zzXA.remove(zze2);
        }
    };
    private final GoogleApiClient.ConnectionCallbacks zzXC = new zzd(){

        @Override
        public void onConnected(Bundle connectionHint) {
            zzg.this.zzXx.onConnected(connectionHint);
        }
    };
    private final zzj.zza zzXD = new zzj.zza(){

        @Override
        public boolean isConnected() {
            return zzg.this.isConnected();
        }

        @Override
        public Bundle zzlM() {
            return null;
        }
    };

    private final GoogleApiClient.OnConnectionFailedListener zza(final Api<?> api, final int n) {
        return new GoogleApiClient.OnConnectionFailedListener(){

            @Override
            public void onConnectionFailed(ConnectionResult result) {
                zzg.this.zzXx.zza(result, api, n);
            }
        };
    }

    public zzg(Context context, Looper looper, com.google.android.gms.common.internal.zze zze2, Api.zza<? extends zzps, zzpt> zza2, Map<Api<?>, Api.ApiOptions> map, Set<GoogleApiClient.ConnectionCallbacks> set, Set<GoogleApiClient.OnConnectionFailedListener> set2, int n, int n2) {
        this.mContext = context;
        this.zzXn = new zzj(looper, this.zzXD);
        this.zzWt = looper;
        this.zzXs = new zza(looper);
        this.zzWB = n;
        this.zzWC = n2;
        this.zzXb = new HashMap();
        this.zzXm = this.zzWL.newCondition();
        this.zzXx = new zzf(this);
        for (GoogleApiClient.ConnectionCallbacks iterator : set) {
            this.zzXn.registerConnectionCallbacks(iterator);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : set2) {
            this.zzXn.registerConnectionFailedListener(onConnectionFailedListener);
        }
        Map<Api<?>, zze.zza> map2 = zze2.zznx();
        for (Api<?> api : map.keySet()) {
            Api.ApiOptions apiOptions = map.get(api);
            int n3 = 0;
            if (map2.get(api) != null) {
                n3 = ((zze.zza)map2.get(api)).zzZW ? 1 : 2;
            }
            this.zzXb.put(api, n3);
            zzz<Object> zzz2 = api.zzmt() ? zzg.zza(api.zzmq(), (Object)apiOptions, context, looper, zze2, this.zzXC, this.zza(api, n3)) : zzg.zza(api.zzmp(), (Object)apiOptions, context, looper, zze2, this.zzXC, this.zza(api, n3));
            this.zzXu.put(api.zzms(), zzz2);
        }
        this.zzXa = zze2;
        this.zzWE = zza2;
    }

    private static <C extends Api.Client, O> C zza(Api.zza<C, O> zza2, Object object, Context context, Looper looper, com.google.android.gms.common.internal.zze zze2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return zza2.zza(context, looper, zze2, object, connectionCallbacks, onConnectionFailedListener);
    }

    private static <C extends Api.zzb, O> zzz zza(Api.zzc<C, O> zzc2, Object object, Context context, Looper looper, com.google.android.gms.common.internal.zze zze2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return new zzz(context, looper, zzc2.zzmu(), connectionCallbacks, onConnectionFailedListener, zze2, (Api.zzb)zzc2.zzl(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.Client, R extends Result, T extends zza.zza<R, A>> T zza(T t) {
        zzu.zzb(t.zzms() != null, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        zzu.zzb(this.zzXu.containsKey(t.zzms()), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        this.zzWL.lock();
        try {
            T t2 = this.zzXx.zza(t);
            return t2;
        }
        finally {
            this.zzWL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.Client, T extends zza.zza<? extends Result, A>> T zzb(T t) {
        zzu.zzb(t.zzms() != null, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        this.zzWL.lock();
        try {
            if (this.zzmO()) {
                Object object;
                this.zzXo.add(t);
                while (!this.zzXo.isEmpty()) {
                    object = this.zzXo.remove();
                    this.zzb((zze<A>)object);
                    object.zzr(Status.zzXR);
                }
                object = t;
                return (T)object;
            }
            T t2 = this.zzXx.zzb(t);
            return t2;
        }
        finally {
            this.zzWL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> zzi<L> zzo(L l) {
        zzu.zzb(l, (Object)"Listener must not be null");
        this.zzWL.lock();
        try {
            zzi<L> zzi2 = new zzi<L>(this.zzWt, l);
            this.zzXz.add(zzi2);
            zzi<L> zzi3 = zzi2;
            return zzi3;
        }
        finally {
            this.zzWL.unlock();
        }
    }

    @Override
    public <C extends Api.Client> C zza(Api.ClientKey<C> clientKey) {
        Api.Client client = this.zzXu.get(clientKey);
        zzu.zzb(client, (Object)"Appropriate Api was not requested.");
        return (C)client;
    }

    @Override
    public boolean zza(Api<?> api) {
        return this.zzXu.containsKey(api.zzms());
    }

    @Override
    public boolean hasConnectedApi(Api<?> api) {
        Api.Client client = this.zzXu.get(api.zzms());
        return client == null ? false : client.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult getConnectionResult(Api<?> api) {
        Api.ClientKey<?> clientKey = api.zzms();
        this.zzWL.lock();
        try {
            if (!this.isConnected() && !this.zzmO()) {
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            if (this.zzXu.containsKey(clientKey)) {
                if (this.zzXu.get(clientKey).isConnected()) {
                    ConnectionResult connectionResult = ConnectionResult.zzVG;
                    return connectionResult;
                }
                if (this.zzXv.containsKey(clientKey)) {
                    ConnectionResult connectionResult = this.zzXv.get(clientKey);
                    return connectionResult;
                }
                Log.wtf((String)"GoogleApiClientImpl", (String)(api.getName() + " requested in getConnectionResult" + " is not connected but is not present in the failed connections map"));
                ConnectionResult connectionResult = new ConnectionResult(8, null);
                return connectionResult;
            }
        }
        finally {
            this.zzWL.unlock();
        }
        throw new IllegalArgumentException(api.getName() + " was never registered with GoogleApiClient");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zza(Scope scope) {
        this.zzWL.lock();
        try {
            boolean bl = this.isConnected() && this.zzXw.contains(scope);
            return bl;
        }
        finally {
            this.zzWL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.zzWL.lock();
        try {
            this.zzXx.connect();
        }
        finally {
            this.zzWL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect() {
        zzu.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.zzWL.lock();
        try {
            this.connect();
            while (this.isConnecting()) {
                try {
                    this.zzXm.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    this.zzWL.unlock();
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.zzVG;
                return connectionResult;
            }
            if (this.zzXy != null) {
                ConnectionResult connectionResult = this.zzXy;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.zzWL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        zzu.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.zzWL.lock();
        try {
            this.connect();
            long l = unit.toNanos(timeout);
            while (this.isConnecting()) {
                try {
                    l = this.zzXm.awaitNanos(l);
                    if (l > 0L) continue;
                    ConnectionResult connectionResult = new ConnectionResult(14, null);
                    return connectionResult;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.zzVG;
                return connectionResult;
            }
            if (this.zzXy != null) {
                ConnectionResult connectionResult = this.zzXy;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.zzWL.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.zzmR();
        this.zzaY(-1);
    }

    void zzmK() {
        for (zze<?> object : this.zzXA) {
            object.zza(null);
            object.cancel();
        }
        this.zzXA.clear();
        for (zzi zzi2 : this.zzXz) {
            zzi2.clear();
        }
        this.zzXz.clear();
        this.zzXw.clear();
    }

    void zzmL() {
        for (Api.Client client : this.zzXu.values()) {
            client.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzaY(int n) {
        this.zzWL.lock();
        try {
            this.zzXx.zzaV(n);
        }
        finally {
            this.zzWL.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzmM() {
        this.zzWL.lock();
        try {
            this.zzXx = new com.google.android.gms.common.api.zze(this, this.zzXa, this.zzXb, this.zzWE, this.zzWL, this.mContext);
            this.zzXx.begin();
            this.zzXm.signalAll();
        }
        finally {
            this.zzWL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzmN() {
        this.zzWL.lock();
        try {
            this.zzmR();
            this.zzXx = new com.google.android.gms.common.api.zzd(this);
            this.zzXx.begin();
            this.zzXm.signalAll();
        }
        finally {
            this.zzWL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zze(ConnectionResult connectionResult) {
        this.zzWL.lock();
        try {
            this.zzXy = connectionResult;
            this.zzXx = new zzf(this);
            this.zzXx.begin();
            this.zzXm.signalAll();
        }
        finally {
            this.zzWL.unlock();
        }
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzu.zza(this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        final zzl zzl2 = new zzl(this.zzWt);
        if (this.zzXu.containsKey(zzkl.zzNX)) {
            this.zza(this, zzl2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle connectionHint) {
                    zzg.this.zza((GoogleApiClient)atomicReference.get(), zzl2, true);
                }

                @Override
                public void onConnectionSuspended(int cause) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

                @Override
                public void onConnectionFailed(ConnectionResult result) {
                    zzl2.setResult(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzkl.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.zzXs).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzl2;
    }

    private void zza(final GoogleApiClient googleApiClient, final zzl zzl2, final boolean bl) {
        zzkl.zzabj.zzc(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void zzm(Status status) {
                if (status.isSuccess() && zzg.this.isConnected()) {
                    zzg.this.reconnect();
                }
                zzl2.setResult(status);
                if (bl) {
                    googleApiClient.disconnect();
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.zzm((Status)x0);
            }
        });
    }

    @Override
    public void stopAutoManage(FragmentActivity lifecycleActivity) {
        if (this.zzWB >= 0) {
            zzm.zza(lifecycleActivity).zzbb(this.zzWB);
        } else if (this.zzWC >= 0) {
            zzn.zzb(lifecycleActivity).zzbb(this.zzWC);
        } else {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
    }

    @Override
    public boolean isConnected() {
        return this.zzXx instanceof com.google.android.gms.common.api.zzd;
    }

    @Override
    public boolean isConnecting() {
        return this.zzXx instanceof com.google.android.gms.common.api.zze;
    }

    boolean zzmO() {
        return this.zzXp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        this.zzWL.lock();
        try {
            if (this.zzmO()) {
                this.connect();
            }
        }
        finally {
            this.zzWL.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzmP() {
        this.zzWL.lock();
        try {
            boolean bl = this.zzmR();
            if (bl) {
                this.connect();
            }
        }
        finally {
            this.zzWL.unlock();
        }
    }

    void zzmQ() {
        if (this.zzmO()) {
            return;
        }
        this.zzXp = true;
        if (this.zzXt == null) {
            this.zzXt = new zzb(this);
            IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
            intentFilter.addDataScheme("package");
            this.mContext.getApplicationContext().registerReceiver(this.zzXt, intentFilter);
        }
        this.zzXs.sendMessageDelayed(this.zzXs.obtainMessage(1), this.zzXq);
        this.zzXs.sendMessageDelayed(this.zzXs.obtainMessage(2), this.zzXr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzmR() {
        this.zzWL.lock();
        try {
            if (!this.zzmO()) {
                boolean bl = false;
                return bl;
            }
            this.zzXp = false;
            this.zzXs.removeMessages(2);
            this.zzXs.removeMessages(1);
            if (this.zzXt != null) {
                this.mContext.getApplicationContext().unregisterReceiver(this.zzXt);
                this.zzXt = null;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.zzWL.unlock();
        }
    }

    <A extends Api.Client> void zzb(zze<A> zze2) {
        this.zzXA.add(zze2);
        zze2.zza(this.zzXB);
    }

    @Override
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zzXn.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        return this.zzXn.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zzXn.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzXn.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        return this.zzXn.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzXn.unregisterConnectionFailedListener(listener);
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Looper getLooper() {
        return this.zzWt;
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.append(prefix).append("mState=").append(this.zzXx.getName());
        writer.append(" mResuming=").print(this.zzXp);
        writer.append(" mWorkQueue.size()=").print(this.zzXo.size());
        writer.append(" mUnconsumedRunners.size()=").println(this.zzXA.size());
        String string2 = prefix + "  ";
        for (Api<?> api : this.zzXb.keySet()) {
            writer.append(prefix).append(api.getName()).println(":");
            Api.Client client = this.zzXu.get(api.zzms());
            client.dump(string2, fd, writer, args);
        }
    }

    @Override
    public int getSessionId() {
        return System.identityHashCode(this);
    }

    final class zza
    extends Handler {
        zza(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    zzg.this.zzmP();
                    break;
                }
                case 2: {
                    zzg.this.resume();
                    break;
                }
                default: {
                    Log.w((String)"GoogleApiClientImpl", (String)("Unknown message id: " + msg.what));
                }
            }
        }
    }

    private static class zzb
    extends BroadcastReceiver {
        private WeakReference<zzg> zzXK;

        zzb(zzg zzg2) {
            this.zzXK = new WeakReference<zzg>(zzg2);
        }

        public void onReceive(Context context, Intent intent) {
            Uri uri = intent.getData();
            String string2 = null;
            if (uri != null) {
                string2 = uri.getSchemeSpecificPart();
            }
            if (string2 == null || !string2.equals("com.google.android.gms")) {
                return;
            }
            zzg zzg2 = (zzg)this.zzXK.get();
            if (zzg2 == null) {
                return;
            }
            zzg2.resume();
        }
    }

    public abstract class zzd
    implements GoogleApiClient.ConnectionCallbacks {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionSuspended(int cause) {
            zzg.this.zzWL.lock();
            try {
                zzg.this.zzXx.onConnectionSuspended(cause);
            }
            finally {
                zzg.this.zzWL.unlock();
            }
        }
    }

    static interface zze<A extends Api.Client> {
        public void cancel();

        public Api.ClientKey<A> zzms();

        public void zzb(A var1) throws DeadObjectException;

        public void forceFailureUnlessReady(Status var1);

        public void zzr(Status var1);

        public void zza(zzc var1);

        public int zzmv();
    }

    static interface zzc {
        public void zzc(zze<?> var1);
    }
}

