/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzb;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.zze;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzlh;
import com.google.android.gms.internal.zzli;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SafeParcelResponse
extends FastJsonResponse
implements SafeParcelable {
    private final int zzCY;
    private final Parcel zzabV;
    private final int zzabW;
    private final FieldMappingDictionary zzabO;
    private final String mClassName;
    private int zzabX;
    private int zzabY;
    public static final zze CREATOR = new zze();

    private SafeParcelResponse(SafeParcelable safeParcelable, FieldMappingDictionary dictionary, String className) {
        this.zzCY = 1;
        this.zzabV = Parcel.obtain();
        safeParcelable.writeToParcel(this.zzabV, 0);
        this.zzabW = 1;
        this.zzabO = zzu.zzu(dictionary);
        this.mClassName = zzu.zzu(className);
        this.zzabX = 2;
    }

    public static <T extends FastJsonResponse> SafeParcelResponse zza(T t) {
        String string2 = t.getClass().getCanonicalName();
        FieldMappingDictionary fieldMappingDictionary = SafeParcelResponse.zzb(t);
        return new SafeParcelResponse((SafeParcelable)((Object)t), fieldMappingDictionary, string2);
    }

    private static FieldMappingDictionary zzb(FastJsonResponse fastJsonResponse) {
        FieldMappingDictionary fieldMappingDictionary = new FieldMappingDictionary(fastJsonResponse.getClass());
        SafeParcelResponse.zza(fieldMappingDictionary, fastJsonResponse);
        fieldMappingDictionary.zzoA();
        fieldMappingDictionary.zzoz();
        return fieldMappingDictionary;
    }

    private static void zza(FieldMappingDictionary fieldMappingDictionary, FastJsonResponse fastJsonResponse) {
        Class<?> clazz = fastJsonResponse.getClass();
        if (!fieldMappingDictionary.zzb(clazz)) {
            Map<String, FastJsonResponse.Field<?, ?>> map = fastJsonResponse.zzom();
            fieldMappingDictionary.zza(clazz, map);
            for (String string2 : map.keySet()) {
                FastJsonResponse.Field<?, ?> field = map.get(string2);
                Class<FastJsonResponse> clazz2 = field.zzou();
                if (clazz2 == null) continue;
                try {
                    FastJsonResponse fastJsonResponse2 = clazz2.newInstance();
                    SafeParcelResponse.zza(fieldMappingDictionary, fastJsonResponse2);
                }
                catch (InstantiationException instantiationException) {
                    throw new IllegalStateException("Could not instantiate an object of type " + field.zzou().getCanonicalName(), instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException("Could not access object of type " + field.zzou().getCanonicalName(), illegalAccessException);
                }
            }
        }
    }

    SafeParcelResponse(int versionCode, Parcel parcel, FieldMappingDictionary fieldMappingDictionary) {
        this.zzCY = versionCode;
        this.zzabV = zzu.zzu(parcel);
        this.zzabW = 2;
        this.zzabO = fieldMappingDictionary;
        this.mClassName = this.zzabO == null ? null : this.zzabO.zzoC();
        this.zzabX = 2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zze.zza(this, out, flags);
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    public Parcel zzoE() {
        switch (this.zzabX) {
            case 0: {
                this.zzabY = zzb.zzac(this.zzabV);
                zzb.zzH(this.zzabV, this.zzabY);
                this.zzabX = 2;
                break;
            }
            case 1: {
                zzb.zzH(this.zzabV, this.zzabY);
                this.zzabX = 2;
                break;
            }
        }
        return this.zzabV;
    }

    FieldMappingDictionary zzoF() {
        switch (this.zzabW) {
            case 0: {
                return null;
            }
            case 1: {
                return this.zzabO;
            }
            case 2: {
                return this.zzabO;
            }
        }
        throw new IllegalStateException("Invalid creation type: " + this.zzabW);
    }

    @Override
    public Map<String, FastJsonResponse.Field<?, ?>> zzom() {
        if (this.zzabO == null) {
            return null;
        }
        return this.zzabO.zzco(this.mClassName);
    }

    @Override
    protected Object zzck(String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    @Override
    protected boolean zzcl(String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    @Override
    public String toString() {
        zzu.zzb(this.zzabO, (Object)"Cannot convert to JSON on client side.");
        Parcel parcel = this.zzoE();
        parcel.setDataPosition(0);
        StringBuilder stringBuilder = new StringBuilder(100);
        this.zza(stringBuilder, this.zzabO.zzco(this.mClassName), parcel);
        return stringBuilder.toString();
    }

    private void zza(StringBuilder stringBuilder, Map<String, FastJsonResponse.Field<?, ?>> map, Parcel parcel) {
        HashMap<Integer, Map.Entry<String, FastJsonResponse.Field<?, ?>>> hashMap = SafeParcelResponse.zzC(map);
        stringBuilder.append('{');
        int n = zza.zzab(parcel);
        boolean bl = false;
        while (parcel.dataPosition() < n) {
            int n2 = zza.zzaa(parcel);
            int n3 = zza.zzbA(n2);
            Map.Entry<String, FastJsonResponse.Field<?, ?>> entry = hashMap.get(n3);
            if (entry == null) continue;
            if (bl) {
                stringBuilder.append(",");
            }
            this.zza(stringBuilder, entry.getKey(), entry.getValue(), parcel, n2);
            bl = true;
        }
        if (parcel.dataPosition() != n) {
            throw new zza.zza("Overread allowed size end=" + n, parcel);
        }
        stringBuilder.append('}');
    }

    private static HashMap<Integer, Map.Entry<String, FastJsonResponse.Field<?, ?>>> zzC(Map<String, FastJsonResponse.Field<?, ?>> map) {
        HashMap hashMap = new HashMap();
        for (Map.Entry<String, FastJsonResponse.Field<?, ?>> entry : map.entrySet()) {
            hashMap.put(entry.getValue().zzot(), entry);
        }
        return hashMap;
    }

    private void zza(StringBuilder stringBuilder, String string2, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        stringBuilder.append("\"").append(string2).append("\":");
        if (field.zzow()) {
            this.zza(stringBuilder, field, parcel, n);
        } else {
            this.zzb(stringBuilder, field, parcel, n);
        }
    }

    private void zza(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        switch (field.zzol()) {
            case 0: {
                int n2 = zza.zzg(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, n2));
                break;
            }
            case 1: {
                BigInteger bigInteger = zza.zzk(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bigInteger));
                break;
            }
            case 2: {
                long l = zza.zzi(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, l));
                break;
            }
            case 3: {
                float f = zza.zzl(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, Float.valueOf(f)));
                break;
            }
            case 4: {
                double d = zza.zzm(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, d));
                break;
            }
            case 5: {
                BigDecimal bigDecimal = zza.zzn(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bigDecimal));
                break;
            }
            case 6: {
                boolean bl = zza.zzc(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bl));
                break;
            }
            case 7: {
                String string2 = zza.zzo(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, string2));
                break;
            }
            case 8: 
            case 9: {
                byte[] byArray = zza.zzr(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, byArray));
                break;
            }
            case 10: {
                Bundle bundle = zza.zzq(parcel, n);
                HashMap<String, String> hashMap = SafeParcelResponse.zzh(bundle);
                this.zzb(stringBuilder, field, this.zza(field, hashMap));
                break;
            }
            case 11: {
                throw new IllegalArgumentException("Method does not accept concrete type.");
            }
            default: {
                throw new IllegalArgumentException("Unknown field out type = " + field.zzol());
            }
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        if (field.zzor()) {
            stringBuilder.append("[");
            switch (field.zzol()) {
                case 0: {
                    int[] nArray = zza.zzu(parcel, n);
                    zzkx.zza(stringBuilder, nArray);
                    break;
                }
                case 1: {
                    BigInteger[] bigIntegerArray = zza.zzw(parcel, n);
                    zzkx.zza(stringBuilder, bigIntegerArray);
                    break;
                }
                case 2: {
                    long[] lArray = zza.zzv(parcel, n);
                    zzkx.zza(stringBuilder, lArray);
                    break;
                }
                case 3: {
                    float[] fArray = zza.zzx(parcel, n);
                    zzkx.zza(stringBuilder, fArray);
                    break;
                }
                case 4: {
                    double[] dArray = zza.zzy(parcel, n);
                    zzkx.zza(stringBuilder, dArray);
                    break;
                }
                case 5: {
                    BigDecimal[] bigDecimalArray = zza.zzz(parcel, n);
                    zzkx.zza(stringBuilder, bigDecimalArray);
                    break;
                }
                case 6: {
                    boolean[] blArray = zza.zzt(parcel, n);
                    zzkx.zza(stringBuilder, blArray);
                    break;
                }
                case 7: {
                    String[] stringArray = zza.zzA(parcel, n);
                    zzkx.zza(stringBuilder, stringArray);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    throw new UnsupportedOperationException("List of type BASE64, BASE64_URL_SAFE, or STRING_MAP is not supported");
                }
                case 11: {
                    Parcel[] parcelArray = zza.zzE(parcel, n);
                    int n2 = parcelArray.length;
                    for (int i = 0; i < n2; ++i) {
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        parcelArray[i].setDataPosition(0);
                        this.zza(stringBuilder, field.zzoy(), parcelArray[i]);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown field type out.");
                }
            }
            stringBuilder.append("]");
        } else {
            switch (field.zzol()) {
                case 0: {
                    int n3 = zza.zzg(parcel, n);
                    stringBuilder.append(n3);
                    break;
                }
                case 1: {
                    BigInteger bigInteger = zza.zzk(parcel, n);
                    stringBuilder.append(bigInteger);
                    break;
                }
                case 2: {
                    long l = zza.zzi(parcel, n);
                    stringBuilder.append(l);
                    break;
                }
                case 3: {
                    float f = zza.zzl(parcel, n);
                    stringBuilder.append(f);
                    break;
                }
                case 4: {
                    double d = zza.zzm(parcel, n);
                    stringBuilder.append(d);
                    break;
                }
                case 5: {
                    BigDecimal bigDecimal = zza.zzn(parcel, n);
                    stringBuilder.append(bigDecimal);
                    break;
                }
                case 6: {
                    boolean bl = zza.zzc(parcel, n);
                    stringBuilder.append(bl);
                    break;
                }
                case 7: {
                    String string2 = zza.zzo(parcel, n);
                    stringBuilder.append("\"").append(zzlh.zzcr(string2)).append("\"");
                    break;
                }
                case 8: {
                    byte[] byArray = zza.zzr(parcel, n);
                    stringBuilder.append("\"").append(zzky.zzi(byArray)).append("\"");
                    break;
                }
                case 9: {
                    byte[] byArray = zza.zzr(parcel, n);
                    stringBuilder.append("\"").append(zzky.zzj(byArray));
                    stringBuilder.append("\"");
                    break;
                }
                case 10: {
                    Bundle bundle = zza.zzq(parcel, n);
                    Set set = bundle.keySet();
                    int n4 = set.size();
                    stringBuilder.append("{");
                    boolean bl = true;
                    for (String string3 : set) {
                        if (!bl) {
                            stringBuilder.append(",");
                        }
                        bl = false;
                        stringBuilder.append("\"").append(string3).append("\"");
                        stringBuilder.append(":");
                        stringBuilder.append("\"").append(zzlh.zzcr(bundle.getString(string3))).append("\"");
                    }
                    stringBuilder.append("}");
                    break;
                }
                case 11: {
                    Parcel parcel2 = zza.zzD(parcel, n);
                    parcel2.setDataPosition(0);
                    this.zza(stringBuilder, field.zzoy(), parcel2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown field type out");
                }
            }
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Object object) {
        if (field.zzoq()) {
            this.zzb(stringBuilder, field, (ArrayList)object);
        } else {
            this.zza(stringBuilder, field.zzok(), object);
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, ArrayList<?> arrayList) {
        stringBuilder.append("[");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            this.zza(stringBuilder, field.zzok(), arrayList.get(i));
        }
        stringBuilder.append("]");
    }

    private void zza(StringBuilder stringBuilder, int n, Object object) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                stringBuilder.append(object);
                break;
            }
            case 7: {
                stringBuilder.append("\"").append(zzlh.zzcr(object.toString())).append("\"");
                break;
            }
            case 8: {
                stringBuilder.append("\"").append(zzky.zzi((byte[])object)).append("\"");
                break;
            }
            case 9: {
                stringBuilder.append("\"").append(zzky.zzj((byte[])object));
                stringBuilder.append("\"");
                break;
            }
            case 10: {
                zzli.zza(stringBuilder, (HashMap)object);
                break;
            }
            case 11: {
                throw new IllegalArgumentException("Method does not accept concrete type.");
            }
            default: {
                throw new IllegalArgumentException("Unknown type = " + n);
            }
        }
    }

    public static HashMap<String, String> zzh(Bundle bundle) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : bundle.keySet()) {
            hashMap.put(string2, bundle.getString(string2));
        }
        return hashMap;
    }
}

