/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.zzh;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzmy;

public final class Device
implements SafeParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    private final int zzCY;
    private final String zzakr;
    private final String zzaks;
    private final String zzTQ;
    private final String zzakt;
    private final int zzSq;
    private final int zzaku;
    public static final Parcelable.Creator<Device> CREATOR = new zzh();

    public static Device getLocalDevice(Context context) {
        int n = zzlv.zzap(context);
        String string2 = Device.zzal(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string2, n, 2);
    }

    private static String zzal(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public Device(String manufacturer, String model, String uid, int type) {
        this(manufacturer, model, "", uid, type, 0);
    }

    public Device(String manufacturer, String model, String version, String uid, int type, int platformType) {
        this(1, manufacturer, model, "", uid, type, platformType);
    }

    Device(int versionCode, String manufacturer, String model, String version, String uid, int type, int platformType) {
        this.zzCY = versionCode;
        this.zzakr = zzu.zzu(manufacturer);
        this.zzaks = zzu.zzu(model);
        this.zzTQ = "";
        this.zzakt = zzu.zzu(uid);
        this.zzSq = type;
        this.zzaku = platformType;
    }

    public String getManufacturer() {
        return this.zzakr;
    }

    public String getModel() {
        return this.zzaks;
    }

    public String getVersion() {
        return this.zzTQ;
    }

    public String getUid() {
        return this.zzakt;
    }

    public int getType() {
        return this.zzSq;
    }

    public int zzqE() {
        return this.zzaku;
    }

    private boolean zzqF() {
        return this.zzqE() == 1;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.zzakr, this.zzaks, this.zzakt);
    }

    public String zzqG() {
        return this.zzqF() ? this.zzakt : zzmy.zzcL(this.zzakt);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.zzTQ, this.zzSq, this.zzaku);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Device && this.zza((Device)that);
    }

    private boolean zza(Device device) {
        return zzt.equal(this.zzakr, device.zzakr) && zzt.equal(this.zzaks, device.zzaks) && zzt.equal(this.zzTQ, device.zzTQ) && zzt.equal(this.zzakt, device.zzakt) && this.zzSq == device.zzSq && this.zzaku == device.zzaku;
    }

    public int hashCode() {
        return zzt.hashCode(this.zzakr, this.zzaks, this.zzTQ, this.zzakt, this.zzSq);
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzh.zza(this, parcel, flags);
    }
}

