/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzajG;
    private final DataType zzajF;
    private final long zzakP;
    private final long zzamv;
    private final long zzamu;
    private final int zzakQ;
    private final LocationRequest zzamz;
    private final long zzamA;

    private SensorRequest(Builder builder) {
        this.zzajG = builder.zzajG;
        this.zzajF = builder.zzajF;
        this.zzakP = builder.zzakP;
        this.zzamv = builder.zzamv;
        this.zzamu = builder.zzamu;
        this.zzakQ = builder.zzakQ;
        this.zzamz = null;
        this.zzamA = builder.zzamA;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.zzamz = locationRequest;
        this.zzakP = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzamv = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzamu = this.zzakP;
        this.zzajF = dataSource.getDataType();
        this.zzakQ = SensorRequest.zza(locationRequest);
        this.zzajG = dataSource;
        long l = locationRequest.getExpirationTime();
        this.zzamA = l == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int zza(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.zzajG;
    }

    public DataType getDataType() {
        return this.zzajF;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzakP, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzamv, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzamu, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzakQ;
    }

    public long zzrm() {
        return this.zzamA;
    }

    public String toString() {
        return zzt.zzt(this).zzg("dataSource", this.zzajG).zzg("dataType", this.zzajF).zzg("samplingRateMicros", this.zzakP).zzg("deliveryLatencyMicros", this.zzamu).zzg("timeOutMicros", this.zzamA).toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRequest && this.zza((SensorRequest)that);
    }

    private boolean zza(SensorRequest sensorRequest) {
        return zzt.equal(this.zzajG, sensorRequest.zzajG) && zzt.equal(this.zzajF, sensorRequest.zzajF) && this.zzakP == sensorRequest.zzakP && this.zzamv == sensorRequest.zzamv && this.zzamu == sensorRequest.zzamu && this.zzakQ == sensorRequest.zzakQ && zzt.equal(this.zzamz, sensorRequest.zzamz) && this.zzamA == sensorRequest.zzamA;
    }

    public int hashCode() {
        return zzt.hashCode(this.zzajG, this.zzajF, this.zzakP, this.zzamv, this.zzamu, this.zzakQ, this.zzamz, this.zzamA);
    }

    public static int zzeM(int n) {
        switch (n) {
            case 1: 
            case 3: {
                return n;
            }
        }
        return 2;
    }

    public static class Builder {
        private DataSource zzajG;
        private DataType zzajF;
        private long zzakP = -1L;
        private long zzamv = 0L;
        private long zzamu = 0L;
        private boolean zzamB = false;
        private int zzakQ = 2;
        private long zzamA = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.zzajG = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzajF = dataType;
            return this;
        }

        public Builder setSamplingRate(long interval, TimeUnit unit) {
            zzu.zzb(interval >= 0L, (Object)"Cannot use a negative sampling interval");
            this.zzakP = unit.toMicros(interval);
            if (!this.zzamB) {
                this.zzamv = this.zzakP / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int fastestInterval, TimeUnit unit) {
            zzu.zzb(fastestInterval >= 0, (Object)"Cannot use a negative interval");
            this.zzamB = true;
            this.zzamv = unit.toMicros(fastestInterval);
            return this;
        }

        public Builder setMaxDeliveryLatency(int interval, TimeUnit unit) {
            zzu.zzb(interval >= 0, (Object)"Cannot use a negative delivery interval");
            this.zzamu = unit.toMicros(interval);
            return this;
        }

        public Builder setAccuracyMode(int accuracyMode) {
            this.zzakQ = SensorRequest.zzeM(accuracyMode);
            return this;
        }

        public Builder setTimeout(long timeout, TimeUnit timeUnit) {
            zzu.zzb(timeout > 0L, "Invalid time out value specified: %d", timeout);
            zzu.zzb(timeUnit != null, (Object)"Invalid time unit specified");
            this.zzamA = timeUnit.toMicros(timeout);
            return this;
        }

        public SensorRequest build() {
            zzu.zza(this.zzajG != null || this.zzajF != null, (Object)"Must call setDataSource() or setDataType()");
            zzu.zza(this.zzajF == null || this.zzajG == null || this.zzajF.equals(this.zzajG.getDataType()), (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

