/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.zzlc;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int zzCY;
    private final String zzQv;
    private final String zzadI;
    private final String zzanc;
    private final String zzand;
    private final String zzakM;
    private final String zzane;
    private final Uri zzanf;
    private final Uri zzang;
    private final Uri zzanh;
    private final boolean zzani;
    private final boolean zzanj;
    private final String zzank;
    private final int zzanl;
    private final int zzanm;
    private final int zzann;
    private final boolean zzano;
    private final boolean zzanp;
    private final String zzanq;
    private final String zzanr;
    private final String zzans;
    private final boolean zzAg;
    private final boolean zzant;
    private final boolean zzanu;
    private final String zzanv;
    private final boolean zzanw;

    public GameEntity(Game game) {
        this.zzCY = 7;
        this.zzQv = game.getApplicationId();
        this.zzanc = game.getPrimaryCategory();
        this.zzand = game.getSecondaryCategory();
        this.zzakM = game.getDescription();
        this.zzane = game.getDeveloperName();
        this.zzadI = game.getDisplayName();
        this.zzanf = game.getIconImageUri();
        this.zzanq = game.getIconImageUrl();
        this.zzang = game.getHiResImageUri();
        this.zzanr = game.getHiResImageUrl();
        this.zzanh = game.getFeaturedImageUri();
        this.zzans = game.getFeaturedImageUrl();
        this.zzani = game.zzrC();
        this.zzanj = game.zzrE();
        this.zzank = game.zzrF();
        this.zzanl = game.zzrG();
        this.zzanm = game.getAchievementTotalCount();
        this.zzann = game.getLeaderboardCount();
        this.zzano = game.isRealTimeMultiplayerEnabled();
        this.zzanp = game.isTurnBasedMultiplayerEnabled();
        this.zzAg = game.isMuted();
        this.zzant = game.zzrD();
        this.zzanu = game.areSnapshotsEnabled();
        this.zzanv = game.getThemeColor();
        this.zzanw = game.hasGamepadSupport();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed, boolean snapshotsEnabled, String themeColor, boolean hasGamepadSupport) {
        this.zzCY = versionCode;
        this.zzQv = applicationId;
        this.zzadI = displayName;
        this.zzanc = primaryCategory;
        this.zzand = secondaryCategory;
        this.zzakM = description;
        this.zzane = developerName;
        this.zzanf = iconImageUri;
        this.zzanq = iconImageUrl;
        this.zzang = hiResImageUri;
        this.zzanr = hiResImageUrl;
        this.zzanh = featuredImageUri;
        this.zzans = featuredImageUrl;
        this.zzani = playEnabledGame;
        this.zzanj = instanceInstalled;
        this.zzank = instancePackageName;
        this.zzanl = gameplayAclStatus;
        this.zzanm = achievementTotalCount;
        this.zzann = leaderboardCount;
        this.zzano = realTimeEnabled;
        this.zzanp = turnBasedEnabled;
        this.zzAg = muted;
        this.zzant = identitySharingConfirmed;
        this.zzanu = snapshotsEnabled;
        this.zzanv = themeColor;
        this.zzanw = hasGamepadSupport;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public String getApplicationId() {
        return this.zzQv;
    }

    @Override
    public String getDisplayName() {
        return this.zzadI;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzlc.zzb(this.zzadI, dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.zzanc;
    }

    @Override
    public String getSecondaryCategory() {
        return this.zzand;
    }

    @Override
    public String getDescription() {
        return this.zzakM;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlc.zzb(this.zzakM, dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.zzane;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        zzlc.zzb(this.zzane, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzanf;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzanq;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzang;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzanr;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.zzanh;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.zzans;
    }

    @Override
    public boolean isMuted() {
        return this.zzAg;
    }

    @Override
    public boolean zzrD() {
        return this.zzant;
    }

    @Override
    public boolean zzrC() {
        return this.zzani;
    }

    @Override
    public boolean zzrE() {
        return this.zzanj;
    }

    @Override
    public String zzrF() {
        return this.zzank;
    }

    @Override
    public int zzrG() {
        return this.zzanl;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.zzanm;
    }

    @Override
    public int getLeaderboardCount() {
        return this.zzann;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.zzano;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.zzanp;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.zzanu;
    }

    @Override
    public String getThemeColor() {
        return this.zzanv;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.zzanw;
    }

    @Override
    public Game freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzt.hashCode(game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzrC(), game.zzrE(), game.zzrF(), game.zzrG(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzrD(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport());
    }

    public boolean equals(Object obj) {
        return GameEntity.zza(this, obj);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzt.equal(game2.getApplicationId(), game.getApplicationId()) && zzt.equal(game2.getDisplayName(), game.getDisplayName()) && zzt.equal(game2.getPrimaryCategory(), game.getPrimaryCategory()) && zzt.equal(game2.getSecondaryCategory(), game.getSecondaryCategory()) && zzt.equal(game2.getDescription(), game.getDescription()) && zzt.equal(game2.getDeveloperName(), game.getDeveloperName()) && zzt.equal(game2.getIconImageUri(), game.getIconImageUri()) && zzt.equal(game2.getHiResImageUri(), game.getHiResImageUri()) && zzt.equal(game2.getFeaturedImageUri(), game.getFeaturedImageUri()) && zzt.equal(game2.zzrC(), game.zzrC()) && zzt.equal(game2.zzrE(), game.zzrE()) && zzt.equal(game2.zzrF(), game.zzrF()) && zzt.equal(game2.zzrG(), game.zzrG()) && zzt.equal(game2.getAchievementTotalCount(), game.getAchievementTotalCount()) && zzt.equal(game2.getLeaderboardCount(), game.getLeaderboardCount()) && zzt.equal(game2.isRealTimeMultiplayerEnabled(), game.isRealTimeMultiplayerEnabled()) && zzt.equal(game2.isTurnBasedMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled() && zzt.equal(game2.isMuted(), game.isMuted()) && zzt.equal(game2.zzrD(), game.zzrD())) && zzt.equal(game2.areSnapshotsEnabled(), game.areSnapshotsEnabled()) && zzt.equal(game2.getThemeColor(), game.getThemeColor()) && zzt.equal(game2.hasGamepadSupport(), game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzt.zzt(game).zzg("ApplicationId", game.getApplicationId()).zzg("DisplayName", game.getDisplayName()).zzg("PrimaryCategory", game.getPrimaryCategory()).zzg("SecondaryCategory", game.getSecondaryCategory()).zzg("Description", game.getDescription()).zzg("DeveloperName", game.getDeveloperName()).zzg("IconImageUri", game.getIconImageUri()).zzg("IconImageUrl", game.getIconImageUrl()).zzg("HiResImageUri", game.getHiResImageUri()).zzg("HiResImageUrl", game.getHiResImageUrl()).zzg("FeaturedImageUri", game.getFeaturedImageUri()).zzg("FeaturedImageUrl", game.getFeaturedImageUrl()).zzg("PlayEnabledGame", game.zzrC()).zzg("InstanceInstalled", game.zzrE()).zzg("InstancePackageName", game.zzrF()).zzg("AchievementTotalCount", game.getAchievementTotalCount()).zzg("LeaderboardCount", game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", game.areSnapshotsEnabled()).zzg("ThemeColor", game.getThemeColor()).zzg("HasGamepadSupport", game.hasGamepadSupport()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zznF()) {
            GameEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzQv);
            dest.writeString(this.zzadI);
            dest.writeString(this.zzanc);
            dest.writeString(this.zzand);
            dest.writeString(this.zzakM);
            dest.writeString(this.zzane);
            dest.writeString(this.zzanf == null ? null : this.zzanf.toString());
            dest.writeString(this.zzang == null ? null : this.zzang.toString());
            dest.writeString(this.zzanh == null ? null : this.zzanh.toString());
            dest.writeInt(this.zzani ? 1 : 0);
            dest.writeInt(this.zzanj ? 1 : 0);
            dest.writeString(this.zzank);
            dest.writeInt(this.zzanl);
            dest.writeInt(this.zzanm);
            dest.writeInt(this.zzann);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzdr(Parcel parcel) {
            boolean bl = GameEntity.zzd(GameEntity.zznE());
            if (bl || GameEntity.zzca(GameEntity.class.getCanonicalName())) {
                return super.zzdr(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            String string8 = parcel.readString();
            Uri uri = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri2 = string9 == null ? null : Uri.parse((String)string9);
            String string10 = parcel.readString();
            Uri uri3 = string10 == null ? null : Uri.parse((String)string10);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string11 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl4 = false;
            boolean bl5 = false;
            String string12 = null;
            String string13 = null;
            String string14 = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            String string15 = null;
            boolean bl9 = false;
            return new GameEntity(7, string2, string3, string4, string5, string6, string7, uri, uri2, uri3, bl2, bl3, string11, n, n2, n3, bl4, bl5, string12, string13, string14, bl6, bl7, bl8, string15, bl9);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdr(x0);
        }
    }
}

