/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.internal.zzlc;

public final class EventEntity
implements SafeParcelable,
Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int zzCY;
    private final String zzaoK;
    private final String mName;
    private final String zzakM;
    private final Uri zzanf;
    private final String zzanq;
    private final PlayerEntity zzaog;
    private final long zzaoL;
    private final String zzaoM;
    private final boolean zzaoN;

    public EventEntity(Event event) {
        this.zzCY = 1;
        this.zzaoK = event.getEventId();
        this.mName = event.getName();
        this.zzakM = event.getDescription();
        this.zzanf = event.getIconImageUri();
        this.zzanq = event.getIconImageUrl();
        this.zzaog = (PlayerEntity)event.getPlayer().freeze();
        this.zzaoL = event.getValue();
        this.zzaoM = event.getFormattedValue();
        this.zzaoN = event.isVisible();
    }

    EventEntity(int versionCode, String eventId, String name, String description, Uri iconImageUri, String iconImageUrl, Player player, long value, String formattedValue, boolean isVisible) {
        this.zzCY = versionCode;
        this.zzaoK = eventId;
        this.mName = name;
        this.zzakM = description;
        this.zzanf = iconImageUri;
        this.zzanq = iconImageUrl;
        this.zzaog = new PlayerEntity(player);
        this.zzaoL = value;
        this.zzaoM = formattedValue;
        this.zzaoN = isVisible;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public String getEventId() {
        return this.zzaoK;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzlc.zzb(this.mName, dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzakM;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlc.zzb(this.zzakM, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzanf;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzanq;
    }

    @Override
    public Player getPlayer() {
        return this.zzaog;
    }

    @Override
    public long getValue() {
        return this.zzaoL;
    }

    @Override
    public String getFormattedValue() {
        return this.zzaoM;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer dataOut) {
        zzlc.zzb(this.zzaoM, dataOut);
    }

    @Override
    public boolean isVisible() {
        return this.zzaoN;
    }

    @Override
    public Event freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzt.hashCode(event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible());
    }

    public boolean equals(Object obj) {
        return EventEntity.zza(this, obj);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzt.equal(event2.getEventId(), event.getEventId()) && zzt.equal(event2.getName(), event.getName()) && zzt.equal(event2.getDescription(), event.getDescription()) && zzt.equal(event2.getIconImageUri(), event.getIconImageUri()) && zzt.equal(event2.getIconImageUrl(), event.getIconImageUrl()) && zzt.equal(event2.getPlayer(), event.getPlayer()) && zzt.equal(event2.getValue(), event.getValue()) && zzt.equal(event2.getFormattedValue(), event.getFormattedValue()) && zzt.equal(event2.isVisible(), event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzt.zzt(event).zzg("Id", event.getEventId()).zzg("Name", event.getName()).zzg("Description", event.getDescription()).zzg("IconImageUri", event.getIconImageUri()).zzg("IconImageUrl", event.getIconImageUrl()).zzg("Player", event.getPlayer()).zzg("Value", event.getValue()).zzg("FormattedValue", event.getFormattedValue()).zzg("isVisible", event.isVisible()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        EventEntityCreator.zza(this, out, flags);
    }
}

