/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.MessengerCompat;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class zzc {
    static String zzaxd = null;
    static int zzaxe = 0;
    static int zzaxf = 0;
    static int zzaxg = 0;
    Context zzpH;
    Map<String, Object> zzaxh = new HashMap<String, Object>();
    Messenger zzavX;
    Messenger zzaxi;
    MessengerCompat zzaxj;
    PendingIntent zzavT;
    long zzaxk;
    long zzaxl;
    int zzaxm;
    int zzaxn;
    long zzaxo;

    public zzc(Context context) {
        this.zzpH = context;
    }

    public static String zzaw(Context context) {
        if (zzaxd != null) {
            return zzaxd;
        }
        zzaxe = Process.myUid();
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentServices(new Intent("com.google.android.c2dm.intent.REGISTER"), 0);
        for (ResolveInfo resolveInfo : list) {
            if (0 == packageManager.checkPermission("com.google.android.c2dm.permission.RECEIVE", resolveInfo.serviceInfo.packageName)) {
                try {
                    ApplicationInfo applicationInfo = packageManager.getApplicationInfo(resolveInfo.serviceInfo.packageName, 0);
                    Log.w((String)"InstanceID/Rpc", (String)("Found " + applicationInfo.uid));
                    zzaxf = applicationInfo.uid;
                    zzaxd = resolveInfo.serviceInfo.packageName;
                    return zzaxd;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    continue;
                }
            }
            Log.w((String)"InstanceID/Rpc", (String)("Possible malicious package " + resolveInfo.serviceInfo.packageName + " declares " + "com.google.android.c2dm.intent.REGISTER" + " without permission"));
        }
        Log.w((String)"InstanceID/Rpc", (String)"Failed to resolve REGISTER intent, falling back");
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo("com.google.android.gms", 0);
            zzaxd = applicationInfo.packageName;
            zzaxf = applicationInfo.uid;
            return zzaxd;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            try {
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo("com.google.android.gsf", 0);
                zzaxd = applicationInfo.packageName;
                zzaxf = applicationInfo.uid;
                return zzaxd;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException2) {
                Log.w((String)"InstanceID/Rpc", (String)"Both Google Play Services and legacy GSF package are missing");
                return null;
            }
        }
    }

    static String zza(KeyPair keyPair, String ... stringArray) {
        byte[] byArray;
        try {
            byArray = TextUtils.join((CharSequence)"\n", (Object[])stringArray).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to encode string", (Throwable)unsupportedEncodingException);
            return null;
        }
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            String string2 = privateKey instanceof RSAPrivateKey ? "SHA256withRSA" : "SHA256withECDSA";
            Signature signature = Signature.getInstance(string2);
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            return InstanceID.zzm(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to sign registration request", (Throwable)generalSecurityException);
            return null;
        }
    }

    void zzuj() {
        if (this.zzavX != null) {
            return;
        }
        zzc.zzaw(this.zzpH);
        this.zzavX = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                zzc.this.zze(msg);
            }
        });
    }

    public void zze(Message message) {
        if (message == null) {
            return;
        }
        if (message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof MessengerCompat) {
                    this.zzaxj = (MessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzaxi = (Messenger)parcelable;
                }
            }
            this.zzr((Intent)message.obj);
        } else {
            Log.w((String)"InstanceID/Rpc", (String)"Dropping invalid message");
        }
    }

    synchronized void zzo(Intent intent) {
        if (this.zzavT == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzavT = PendingIntent.getBroadcast((Context)this.zzpH, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzavT);
    }

    void zza(Bundle bundle, KeyPair keyPair, String string2) throws IOException {
        long l = SystemClock.elapsedRealtime();
        if (this.zzaxo != 0L && l <= this.zzaxo) {
            Log.w((String)"InstanceID/Rpc", (String)("Backoff mode, next request attempt: " + (this.zzaxo - l) + " interval: " + this.zzaxn));
            throw new IOException("RETRY_LATER");
        }
        this.zzuj();
        if (zzaxd == null) {
            throw new IOException("MISSING_INSTANCEID_SERVICE");
        }
        this.zzaxk = SystemClock.elapsedRealtime();
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(zzaxd);
        int n = GoogleCloudMessaging.zzat(this.zzpH);
        bundle.putString("gmsv", Integer.toString(n));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", Integer.toString(InstanceID.zzau(this.zzpH)));
        bundle.putString("cliv", "1");
        bundle.putString("appid", InstanceID.zza(keyPair));
        String string3 = InstanceID.zzm(keyPair.getPublic().getEncoded());
        bundle.putString("pub2", string3);
        bundle.putString("sig", zzc.zza(keyPair, this.zzpH.getPackageName(), string3));
        intent.putExtras(bundle);
        this.zzo(intent);
        this.zzb(intent, string2);
    }

    protected void zzb(Intent intent, String string2) {
        Intent intent2;
        boolean bl;
        block10: {
            this.zzaxk = SystemClock.elapsedRealtime();
            intent.putExtra("kid", "|ID|" + string2 + "|");
            intent.putExtra("X-kid", "|ID|" + string2 + "|");
            bl = "com.google.android.gsf".equals(zzaxd);
            String string3 = intent.getStringExtra("useGsf");
            if (string3 != null) {
                bl = "1".equals(string3);
            }
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)("Sending " + intent.getExtras()));
            }
            if (this.zzaxi != null) {
                intent.putExtra("google.messenger", (Parcelable)this.zzavX);
                intent2 = Message.obtain();
                intent2.obj = intent;
                try {
                    this.zzaxi.send((Message)intent2);
                    return;
                }
                catch (RemoteException remoteException) {
                    if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block10;
                    Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                }
            }
        }
        if (bl) {
            intent2 = new Intent("com.google.android.gms.iid.InstanceID");
            intent2.setPackage(this.zzpH.getPackageName());
            intent2.putExtra("GSF", (Parcelable)intent);
            this.zzpH.startService(intent2);
        } else {
            block11: {
                intent.putExtra("google.messenger", (Parcelable)this.zzavX);
                intent.putExtra("messenger2", "1");
                if (this.zzaxj != null) {
                    intent2 = Message.obtain();
                    intent2.obj = intent;
                    try {
                        this.zzaxj.send((Message)intent2);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block11;
                        Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                    }
                }
            }
            this.zzpH.startService(intent);
        }
    }

    String zzp(Intent intent) throws IOException {
        boolean bl;
        if (intent == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string2 = intent.getStringExtra("registration_id");
        if (string2 == null) {
            string2 = intent.getStringExtra("unregistered");
        }
        long l = intent.getLongExtra("Retry-After", 0L);
        boolean bl2 = bl = string2 != null;
        if (string2 == null) {
            string2 = intent.getStringExtra("error");
            if (string2 != null) {
                throw new IOException(string2);
            }
            Log.w((String)"InstanceID/Rpc", (String)("Unexpected response from GCM " + intent.getExtras()), (Throwable)new Throwable());
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        return string2;
    }

    void zzq(Intent intent) {
        String string2 = intent.getStringExtra("error");
        if (string2 == null) {
            Log.w((String)"InstanceID/Rpc", (String)("Unexpected response, no error or registration id " + intent.getExtras()));
            return;
        }
        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
            Log.d((String)"InstanceID/Rpc", (String)("Received InstanceID error " + string2));
        }
        String string3 = null;
        if (string2.startsWith("|")) {
            String[] stringArray = string2.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                Log.w((String)"InstanceID/Rpc", (String)("Unexpected structured response " + string2));
            }
            if (stringArray.length > 2) {
                string3 = stringArray[2];
                string2 = stringArray[3];
                if (string2.startsWith(":")) {
                    string2 = string2.substring(1);
                }
            } else {
                string2 = "UNKNOWN";
            }
            intent.putExtra("error", string2);
        }
        if (null == string3) {
            this.zzx(string2);
        } else {
            this.zzi(string3, string2);
        }
        long l = intent.getLongExtra("Retry-After", 0L);
        if (l > 0L) {
            this.zzaxl = SystemClock.elapsedRealtime();
            this.zzaxn = (int)l * 1000;
            this.zzaxo = SystemClock.elapsedRealtime() + (long)this.zzaxn;
            Log.w((String)"InstanceID/Rpc", (String)("Explicit request from server to backoff: " + this.zzaxn));
        } else if ("SERVICE_NOT_AVAILABLE".equals(string2) || "AUTHENTICATION_FAILED".equals(string2)) {
            this.zzdd(string2);
        }
    }

    private void zzdd(String string2) {
        if (!"com.google.android.gsf".equals(zzaxd)) {
            return;
        }
        ++this.zzaxm;
        if (this.zzaxm < 3) {
            return;
        }
        if (this.zzaxm == 3) {
            this.zzaxn = 1000 + new Random().nextInt(1000);
        }
        this.zzaxn *= 2;
        this.zzaxo = SystemClock.elapsedRealtime() + (long)this.zzaxn;
        Log.w((String)"InstanceID/Rpc", (String)("Backoff due to " + string2 + " for " + this.zzaxn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzx(Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            for (String string2 : this.zzaxh.keySet()) {
                Object object2 = this.zzaxh.get(string2);
                this.zzaxh.put(string2, object);
                this.zze(object2, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzi(String string2, Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Object object2 = this.zzaxh.get(string2);
            this.zzaxh.put(string2, object);
            this.zze(object2, object);
        }
    }

    private void zze(Object object, Object object2) {
        if (object instanceof ConditionVariable) {
            ((ConditionVariable)object).open();
        }
        if (object instanceof Messenger) {
            Messenger messenger = (Messenger)object;
            Message message = Message.obtain();
            message.obj = object2;
            try {
                messenger.send(message);
            }
            catch (RemoteException remoteException) {
                Log.w((String)"InstanceID/Rpc", (String)("Failed to send response " + (Object)((Object)remoteException)));
            }
        }
    }

    void zzr(Intent intent) {
        if (intent == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Unexpected response: null");
            }
            return;
        }
        String string2 = intent.getAction();
        if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string2) && !"com.google.android.gms.iid.InstanceID".equals(string2)) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)("Unexpected response " + intent.getAction()));
            }
            return;
        }
        String string3 = intent.getStringExtra("registration_id");
        if (string3 == null) {
            string3 = intent.getStringExtra("unregistered");
        }
        if (string3 == null) {
            this.zzq(intent);
            return;
        }
        this.zzaxk = SystemClock.elapsedRealtime();
        this.zzaxo = 0L;
        this.zzaxm = 0;
        this.zzaxn = 0;
        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
            Log.d((String)"InstanceID/Rpc", (String)("AppIDResponse: " + string3 + " " + intent.getExtras()));
        }
        String string4 = null;
        if (string3.startsWith("|")) {
            String[] stringArray = string3.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                Log.w((String)"InstanceID/Rpc", (String)("Unexpected structured response " + string3));
            }
            string4 = stringArray[2];
            if (stringArray.length > 4) {
                if ("SYNC".equals(stringArray[3])) {
                    InstanceIDListenerService.zzav(this.zzpH);
                } else if ("RST".equals(stringArray[3])) {
                    InstanceIDListenerService.zza(this.zzpH, InstanceID.getInstance(this.zzpH).zzug());
                    intent.removeExtra("registration_id");
                    this.zzi(string4, intent);
                    return;
                }
            }
            if ((string3 = stringArray[stringArray.length - 1]).startsWith(":")) {
                string3 = string3.substring(1);
            }
            intent.putExtra("registration_id", string3);
        }
        if (null == string4) {
            this.zzx(intent);
        } else {
            this.zzi(string4, intent);
        }
    }

    Intent zza(Bundle bundle, KeyPair keyPair) throws IOException {
        Intent intent = this.zzb(bundle, keyPair);
        if (intent != null && intent.hasExtra("google.messenger")) {
            intent = this.zzb(bundle, keyPair);
        }
        return intent;
    }

    public static synchronized String zzuk() {
        return Integer.toString(zzaxg++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Intent zzb(Bundle bundle, KeyPair keyPair) throws IOException {
        ConditionVariable conditionVariable = new ConditionVariable();
        String string2 = zzc.zzuk();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.zzaxh.put(string2, conditionVariable);
        }
        this.zza(bundle, keyPair, string2);
        conditionVariable.block(30000L);
        clazz = this.getClass();
        synchronized (clazz) {
            Object object = this.zzaxh.remove(string2);
            if (object instanceof Intent) {
                return (Intent)object;
            }
            if (object instanceof String) {
                throw new IOException((String)object);
            }
            Log.w((String)"InstanceID/Rpc", (String)("No response " + object));
            throw new IOException("TIMEOUT");
        }
    }
}

