/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzce;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class zzcb {
    private BlockingQueue<zzce> zzuF;
    private ExecutorService zzuG;
    private int zzuz;
    private int zzuA;
    private int zzuB;
    private int zzuC;
    private LinkedHashMap<String, String> zzuH = new LinkedHashMap();
    private String zzuD;
    private final Context mContext;
    private final String zzqr;
    private AtomicBoolean zzuI;
    private File zzuJ;

    public zzcb(Context context, String string2, String string3, int n, int n2, int n3, int n4, Map<String, String> map, int n5) {
        Object object;
        this.mContext = context;
        this.zzqr = string2;
        this.zzuD = string3;
        this.zzuA = n;
        this.zzuB = n2;
        this.zzuC = n3;
        this.zzq(n4);
        this.zzuI = new AtomicBoolean(false);
        this.zzuI.set(zzbz.zzub.get());
        if (this.zzuI.get() && (object = Environment.getExternalStorageDirectory()) != null) {
            this.zzuJ = new File((File)object, "sdk_csi_data.txt");
        }
        for (Map.Entry entry : map.entrySet()) {
            this.zzd((String)entry.getKey(), (String)entry.getValue());
        }
        if (n5 == 1) {
            this.zzdj();
        }
        if (n5 == 2) {
            this.zzdk();
        }
        this.init();
    }

    private void zzdj() {
        this.zzb(zzbz.zzdb());
    }

    private void zzdk() {
        this.zzb(zzbz.zzx(this.mContext));
    }

    private void zzb(List<String> list) {
        if (list != null && !list.isEmpty()) {
            this.zzd("eid", TextUtils.join((CharSequence)",", list));
        }
    }

    private void init() {
        this.zzuF = new ArrayBlockingQueue<zzce>(this.zzuA);
        this.zzuG = Executors.newSingleThreadExecutor();
        this.zzuG.execute(new Runnable(){

            @Override
            public void run() {
                zzcb.this.zzdl();
            }
        });
    }

    public boolean zza(zzce zzce2) {
        return this.zzuF.offer(zzce2);
    }

    /*
     * Unable to fully structure code
     */
    private void zzdl() {
        block2: while (true) {
            var1_1 = null;
            try {
                var1_1 = this.zzp(this.zzuz);
            }
            catch (InterruptedException var2_3) {
                zzb.zzd("CsiReporter:reporter interrupted", var2_3);
                break;
            }
            if (var1_1 == null) continue;
            var2_2 = this.zzc(var1_1);
            var3_4 = var2_2.values().iterator();
            while (true) {
                if (var3_4.hasNext()) ** break;
                continue block2;
                var4_5 = var3_4.next();
                this.zzc(var4_5);
            }
            break;
        }
    }

    private boolean zzc(Map<String, String> map) {
        boolean bl = false;
        for (int i = 0; !bl && i < this.zzuB; ++i) {
            try {
                Thread.sleep(this.zzuC);
                String string2 = this.zza(this.zzuD, map);
                if (this.zzuI.get()) {
                    this.zza(this.zzuJ, string2);
                } else {
                    zzo.zzbv().zzc(this.mContext, this.zzqr, string2);
                }
                bl = true;
                continue;
            }
            catch (InterruptedException interruptedException) {
                zzb.zzd("CsiReporter: interrupted in sendReport()", interruptedException);
                Thread.currentThread().interrupt();
            }
        }
        return bl;
    }

    private List<zzce> zzp(int n) throws InterruptedException {
        ArrayList<zzce> arrayList = new ArrayList<zzce>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.zzuF.take());
        }
        return arrayList;
    }

    Map<String, Map<String, String>> zzc(List<zzce> list) {
        List list2;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (zzce object : list) {
            String string2 = object.zzdr();
            if (linkedHashMap.containsKey(string2)) {
                ((List)linkedHashMap.get(string2)).add(object);
                continue;
            }
            list2 = new ArrayList<zzce>();
            list2.add(object);
            linkedHashMap.put(string2, list2);
        }
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            list2 = (List)entry.getValue();
            LinkedHashMap<String, String> linkedHashMap3 = new LinkedHashMap<String, String>(this.zzuH);
            Map<String, String> map = null;
            try {
                map = zzce.zza(list2.toArray(new zzce[list2.size()]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzb.zzd("CsiReporter:failed to merge tickers:" + list2, illegalArgumentException);
                continue;
            }
            linkedHashMap3.putAll(map);
            linkedHashMap2.put(entry.getKey(), linkedHashMap3);
        }
        return linkedHashMap2;
    }

    String zza(String string2, Map<String, String> map) {
        Uri.Builder builder = Uri.parse((String)string2).buildUpon();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        return builder.build().toString();
    }

    void zzd(String string2, String string3) {
        this.zzuH.put(string2, string3);
    }

    private void zzq(int n) {
        int n2 = n;
        if (n2 < 1) {
            zzb.zzaC("CsiReporter - too small batch size :" + n2 + ", changed to 1");
            n2 = 1;
        }
        if (n2 > this.zzuA) {
            zzb.zzaC("CsiReporter - batch size :" + n2 + " bigger than buffer size, " + "change to buffer limit");
            n2 = this.zzuA;
        }
        this.zzuz = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(File file, String string2) {
        if (file != null) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file, true);
                fileOutputStream.write(string2.getBytes());
                fileOutputStream.write(10);
            }
            catch (IOException iOException) {
                zzb.zzd("CsiReporter: Cannot write to file: sdk_csi_data.txt.", iOException);
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    zzb.zzd("CsiReporter: Cannot close file: sdk_csi_data.txt.", iOException);
                }
            }
        } else {
            zzb.zzaC("CsiReporter: File doesn't exists. Cannot write CSI data to file.");
        }
    }
}

