/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zznn;
import com.google.android.gms.internal.zzno;
import com.google.android.gms.internal.zznr;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zznu;
import com.google.android.gms.internal.zznx;
import com.google.android.gms.internal.zznz;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzns {
    private static volatile zzns zzaEh;
    private final Context mContext;
    private final List<zznt> zzaEi;
    private final zznn zzaEj;
    private final zza zzaEk;
    private volatile zznx zzKm;
    private Thread.UncaughtExceptionHandler zzaEl;

    zzns(Context context) {
        Context context2 = context.getApplicationContext();
        zzu.zzu(context2);
        this.mContext = context2;
        this.zzaEk = new zza();
        this.zzaEi = new CopyOnWriteArrayList<zznt>();
        this.zzaEj = new zznn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzns zzaB(Context context) {
        zzu.zzu(context);
        if (zzaEh != null) return zzaEh;
        Class<zzns> clazz = zzns.class;
        synchronized (zzns.class) {
            if (zzaEh != null) return zzaEh;
            zzaEh = new zzns(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaEh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zznx zzwc() {
        if (this.zzKm == null) {
            zzns zzns2 = this;
            synchronized (zzns2) {
                if (this.zzKm == null) {
                    zznx zznx2 = new zznx();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string2 = this.mContext.getPackageName();
                    zznx2.setAppId(string2);
                    zznx2.setAppInstallerId(packageManager.getInstallerPackageName(string2));
                    String string3 = string2;
                    String string4 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string3 = charSequence.toString();
                            }
                            string4 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.e((String)"GAv4", (String)("Error retrieving package info: appName set to " + string3));
                    }
                    zznx2.setAppName(string3);
                    zznx2.setAppVersion(string4);
                    this.zzKm = zznx2;
                }
            }
        }
        return this.zzKm;
    }

    public zznz zzwd() {
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zznz zznz2 = new zznz();
        zznz2.setLanguage(zzam.zza(Locale.getDefault()));
        zznz2.zzhG(displayMetrics.widthPixels);
        zznz2.zzhH(displayMetrics.heightPixels);
        return zznz2;
    }

    void zze(zzno zzno2) {
        if (zzno2.zzvY()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zzno2.zzvU()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        final zzno zzno3 = zzno2.zzvP();
        zzno3.zzvV();
        this.zzaEk.execute(new Runnable(){

            @Override
            public void run() {
                zznr zznr2 = zzno3.zzvW();
                zznr2.zza(zzno3);
                for (zznt zznt2 : zzns.this.zzaEi) {
                    zznt2.zza(zzno3);
                }
                zzns.this.zzb(zzno3);
            }
        });
    }

    public Context getContext() {
        return this.mContext;
    }

    public static void zzhO() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzaEl = uncaughtExceptionHandler;
    }

    public <V> Future<V> zzb(Callable<V> callable) {
        zzu.zzu(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzaEk.submit(callable);
    }

    public void zze(Runnable runnable) {
        zzu.zzu(runnable);
        this.zzaEk.submit(runnable);
    }

    private void zzb(zzno zzno2) {
        zzu.zzbZ("deliver should be called from worker thread");
        zzu.zzb(zzno2.zzvU(), (Object)"Measurement must be submitted");
        List<zznu> list = zzno2.zzvR();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zznu zznu2 : list) {
            Uri uri = zznu2.zzhe();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zznu2.zzb(zzno2);
        }
    }

    private static class zzb
    implements ThreadFactory {
        private static final AtomicInteger zzaEp = new AtomicInteger();

        private zzb() {
        }

        @Override
        public Thread newThread(Runnable target) {
            String string2 = "measurement-" + zzaEp.incrementAndGet();
            return new zzc(target, string2);
        }
    }

    private static class zzc
    extends Thread {
        zzc(Runnable runnable, String string2) {
            super(runnable, string2);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    private class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb());
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            return new FutureTask<T>(runnable, value){

                @Override
                protected void setException(Throwable error) {
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = zzns.this.zzaEl;
                    if (uncaughtExceptionHandler != null) {
                        uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), error);
                    } else if (Log.isLoggable((String)"GAv4", (int)6)) {
                        Log.e((String)"GAv4", (String)("MeasurementExecutor: job failed with " + error));
                    }
                    super.setException(error);
                }
            };
        }
    }
}

