/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.internal.ChannelImpl;
import com.google.android.gms.wearable.internal.zzk;

public final class ChannelEventParcelable
implements SafeParcelable {
    public static final Parcelable.Creator<ChannelEventParcelable> CREATOR = new zzk();
    final int zzCY;
    final ChannelImpl zzaTP;
    final int type;
    final int zzaTN;
    final int zzaTO;

    ChannelEventParcelable(int versionCode, ChannelImpl channel, int type, int closeReason, int appErrorCode) {
        this.zzCY = versionCode;
        this.zzaTP = channel;
        this.type = type;
        this.zzaTN = closeReason;
        this.zzaTO = appErrorCode;
    }

    public void zza(ChannelApi.ChannelListener channelListener) {
        switch (this.type) {
            case 1: {
                channelListener.onChannelOpened(this.zzaTP);
                break;
            }
            case 2: {
                channelListener.onChannelClosed(this.zzaTP, this.zzaTN, this.zzaTO);
                break;
            }
            case 3: {
                channelListener.onInputClosed(this.zzaTP, this.zzaTN, this.zzaTO);
                break;
            }
            case 4: {
                channelListener.onOutputClosed(this.zzaTP, this.zzaTN, this.zzaTO);
                break;
            }
            default: {
                Log.w((String)"ChannelEventParcelable", (String)("Unknown type: " + this.type));
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzk.zza(this, dest, flags);
    }

    public String toString() {
        return "ChannelEventParcelable[versionCode=" + this.zzCY + ", channel=" + this.zzaTP + ", type=" + ChannelEventParcelable.zzjT(this.type) + ", closeReason=" + ChannelEventParcelable.zzjU(this.zzaTN) + ", appErrorCode=" + this.zzaTO + "]";
    }

    private static String zzjT(int n) {
        switch (n) {
            case 1: {
                return "CHANNEL_OPENED";
            }
            case 2: {
                return "CHANNEL_CLOSED";
            }
            case 4: {
                return "OUTPUT_CLOSED";
            }
            case 3: {
                return "INPUT_CLOSED";
            }
        }
        return Integer.toString(n);
    }

    private static String zzjU(int n) {
        switch (n) {
            case 1: {
                return "CLOSE_REASON_DISCONNECTED";
            }
            case 2: {
                return "CLOSE_REASON_REMOTE_CLOSE";
            }
            case 3: {
                return "CLOSE_REASON_LOCAL_CLOSE";
            }
            case 0: {
                return "CLOSE_REASON_NORMAL";
            }
        }
        return Integer.toString(n);
    }
}

