/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.text.TextUtils;
import com.google.android.gms.analytics.internal.zzc;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzp;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

abstract class zzq<T extends zzp>
extends zzc {
    zza<T> zzKN;

    public zzq(zzf zzf2, zza<T> zza2) {
        super(zzf2);
        this.zzKN = zza2;
    }

    public T zzab(int n) {
        try {
            return this.zza(this.zzhM().zzic().getResources().getXml(n));
        }
        catch (Resources.NotFoundException notFoundException) {
            this.zzd("inflate() called with unknown resourceId", (Object)notFoundException);
            return null;
        }
    }

    private T zza(XmlResourceParser xmlResourceParser) {
        try {
            xmlResourceParser.next();
            int n = xmlResourceParser.getEventType();
            while (n != 1) {
                if (xmlResourceParser.getEventType() == 2) {
                    String string2;
                    String string3;
                    String string4 = xmlResourceParser.getName().toLowerCase();
                    if (string4.equals("screenname")) {
                        string3 = xmlResourceParser.getAttributeValue(null, "name");
                        string2 = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string2)) {
                            this.zzKN.zzk(string3, string2);
                        }
                    } else if (string4.equals("string")) {
                        string3 = xmlResourceParser.getAttributeValue(null, "name");
                        string2 = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string3) && string2 != null) {
                            this.zzKN.zzl(string3, string2);
                        }
                    } else if (string4.equals("bool")) {
                        string3 = xmlResourceParser.getAttributeValue(null, "name");
                        string2 = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string2)) {
                            try {
                                boolean bl = Boolean.parseBoolean(string2);
                                this.zzKN.zzc(string3, bl);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.zzc("Error parsing bool configuration value", string2, numberFormatException);
                            }
                        }
                    } else if (string4.equals("integer")) {
                        string3 = xmlResourceParser.getAttributeValue(null, "name");
                        string2 = xmlResourceParser.nextText().trim();
                        if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string2)) {
                            try {
                                int n2 = Integer.parseInt(string2);
                                this.zzKN.zzd(string3, n2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.zzc("Error parsing int configuration value", string2, numberFormatException);
                            }
                        }
                    }
                }
                n = xmlResourceParser.next();
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            this.zze("Error parsing tracker configuration file", (Object)xmlPullParserException);
        }
        catch (IOException iOException) {
            this.zze("Error parsing tracker configuration file", iOException);
        }
        return this.zzKN.zziV();
    }

    public static interface zza<U extends zzp> {
        public void zzk(String var1, String var2);

        public void zzl(String var1, String var2);

        public void zzc(String var1, boolean var2);

        public void zzd(String var1, int var2);

        public U zziV();
    }
}

