/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.ChangesAvailableEvent;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.internal.OnEventResponse;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzx;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class DriveEventService
extends Service
implements ChangeListener,
CompletionListener,
zzc {
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String mName;
    private CountDownLatch zzaeb;
    zza zzaec;
    boolean zzaed = false;
    int zzZN = -1;

    protected DriveEventService(String name) {
        this.mName = name;
    }

    protected DriveEventService() {
        this("DriveEventService");
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.zzaec == null && !this.zzaed) {
                this.zzaed = true;
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                this.zzaeb = new CountDownLatch(1);
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Looper.prepare();
                            DriveEventService.this.zzaec = new zza();
                            DriveEventService.this.zzaed = false;
                            countDownLatch.countDown();
                            zzx.zzt("DriveEventService", "Bound and starting loop");
                            Looper.loop();
                            zzx.zzt("DriveEventService", "Finished loop");
                        }
                        finally {
                            if (DriveEventService.this.zzaeb != null) {
                                DriveEventService.this.zzaeb.countDown();
                            }
                        }
                    }
                }.start();
                try {
                    boolean bl = countDownLatch.await(5000L, TimeUnit.MILLISECONDS);
                    if (!bl) {
                        zzx.zzv("DriveEventService", "Failed to synchronously initialize event handler.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new zzb().asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        zzx.zzt("DriveEventService", "onDestroy");
        if (this.zzaec != null) {
            Message message = this.zzaec.zzpw();
            this.zzaec.sendMessage(message);
            this.zzaec = null;
            try {
                boolean bl = this.zzaeb.await(5000L, TimeUnit.MILLISECONDS);
                if (!bl) {
                    zzx.zzu("DriveEventService", "Failed to synchronously quit event handler. Will quit itself");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.zzaeb = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent event) {
        zzx.zzu(this.mName, "Unhandled change event: " + event);
    }

    @Override
    public void zza(ChangesAvailableEvent changesAvailableEvent) {
        zzx.zzu(this.mName, "Unhandled changes available event: " + changesAvailableEvent);
    }

    @Override
    public void onCompletion(CompletionEvent event) {
        zzx.zzu(this.mName, "Unhandled completion event: " + event);
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private void zza(OnEventResponse onEventResponse) {
        DriveEvent driveEvent = onEventResponse.zzpO();
        zzx.zzt("DriveEventService", "handleEventMessage: " + driveEvent);
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    break;
                }
                case 2: {
                    this.onCompletion((CompletionEvent)driveEvent);
                    break;
                }
                case 4: {
                    this.zza((ChangesAvailableEvent)driveEvent);
                    break;
                }
                default: {
                    zzx.zzu(this.mName, "Unhandled event: " + driveEvent);
                    break;
                }
            }
        }
        catch (Exception exception) {
            zzx.zza(this.mName, exception, "Error handling event: " + driveEvent);
        }
    }

    private void zzpv() throws SecurityException {
        int n = this.getCallingUid();
        if (n == this.zzZN) {
            return;
        }
        if (GooglePlayServicesUtil.zzd((Context)this, n)) {
            this.zzZN = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    final class zzb
    extends zzam.zza {
        zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzc(OnEventResponse onEventResponse) throws RemoteException {
            DriveEventService driveEventService = DriveEventService.this;
            synchronized (driveEventService) {
                zzx.zzt("DriveEventService", "onEvent: " + onEventResponse);
                DriveEventService.this.zzpv();
                if (DriveEventService.this.zzaec != null) {
                    Message message = DriveEventService.this.zzaec.zzb(onEventResponse);
                    DriveEventService.this.zzaec.sendMessage(message);
                } else {
                    zzx.zzv("DriveEventService", "Receiving event before initialize is completed.");
                }
            }
        }
    }

    final class zza
    extends Handler {
        zza() {
        }

        private Message zzb(OnEventResponse onEventResponse) {
            return this.obtainMessage(1, onEventResponse);
        }

        private Message zzpw() {
            return this.obtainMessage(2);
        }

        public void handleMessage(Message msg) {
            zzx.zzt("DriveEventService", "handleMessage message type:" + msg.what);
            switch (msg.what) {
                case 1: {
                    DriveEventService.this.zza((OnEventResponse)msg.obj);
                    break;
                }
                case 2: {
                    this.getLooper().quit();
                    break;
                }
                default: {
                    zzx.zzu("DriveEventService", "Unexpected message type:" + msg.what);
                }
            }
        }
    }
}

