/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfoCreator;

public final class PlayerLevelInfo
implements SafeParcelable {
    public static final Parcelable.Creator<PlayerLevelInfo> CREATOR = new PlayerLevelInfoCreator();
    private final int zzCY;
    private final long zzanT;
    private final long zzanU;
    private final PlayerLevel zzanV;
    private final PlayerLevel zzanW;

    public PlayerLevelInfo(long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        this(1, currentXpTotal, lastLevelUpTimestamp, currentLevel, nextLevel);
    }

    PlayerLevelInfo(int versionCode, long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        zzu.zzU(currentXpTotal != -1L);
        zzu.zzu(currentLevel);
        zzu.zzu(nextLevel);
        this.zzCY = versionCode;
        this.zzanT = currentXpTotal;
        this.zzanU = lastLevelUpTimestamp;
        this.zzanV = currentLevel;
        this.zzanW = nextLevel;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    public long getCurrentXpTotal() {
        return this.zzanT;
    }

    public long getLastLevelUpTimestamp() {
        return this.zzanU;
    }

    public PlayerLevel getCurrentLevel() {
        return this.zzanV;
    }

    public PlayerLevel getNextLevel() {
        return this.zzanW;
    }

    public boolean isMaxLevel() {
        return this.zzanV.equals(this.zzanW);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevelInfo)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PlayerLevelInfo playerLevelInfo = (PlayerLevelInfo)obj;
        return zzt.equal(this.zzanT, playerLevelInfo.zzanT) && zzt.equal(this.zzanU, playerLevelInfo.zzanU) && zzt.equal(this.zzanV, playerLevelInfo.zzanV) && zzt.equal(this.zzanW, playerLevelInfo.zzanW);
    }

    public int hashCode() {
        return zzt.hashCode(this.zzanT, this.zzanU, this.zzanV, this.zzanW);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelInfoCreator.zza(this, out, flags);
    }
}

