/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.util.client.zza;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzlb;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

@zzgd
public class zzdr {
    private static final Set<String> zzwF = Collections.synchronizedSet(new HashSet());
    private static final DecimalFormat zzwG = new DecimalFormat("#,###");
    private zzid zzoA;
    private File zzwH;
    private boolean zzwI;

    public zzdr(zzid zzid2) {
        this.zzoA = zzid2;
        Context context = zzid2.getContext();
        File file = context.getCacheDir();
        if (file == null) {
            zzb.zzaC("Context.getCacheDir() returned null");
            return;
        }
        this.zzwH = new File(file, "admobVideoStreams");
        if (!this.zzwH.isDirectory() && !this.zzwH.mkdirs()) {
            zzb.zzaC("Could not create preload cache directory at " + this.zzwH.getAbsolutePath());
            this.zzwH = null;
            return;
        }
        if (!this.zzwH.setReadable(true, false) || !this.zzwH.setExecutable(true, false)) {
            zzb.zzaC("Could not set cache file permissions at " + this.zzwH.getAbsolutePath());
            this.zzwH = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzW(String string2) {
        if (this.zzwH == null) {
            this.zza(string2, null);
            return false;
        }
        while (this.zzdQ() > zzbz.zztO.get()) {
            if (this.zzdR()) continue;
            zzb.zzaC("Unable to expire stream cache");
            this.zza(string2, null);
            return false;
        }
        String string3 = this.zzX(string2);
        File file = new File(this.zzwH, string3);
        File file2 = this.zza(file);
        if (file.isFile() && file2.isFile()) {
            int n = (int)file.length();
            zzb.zzay("Stream cache hit at " + string2);
            this.zza(string2, file, n);
            return true;
        }
        String string4 = this.zzwH.getAbsolutePath() + string2;
        Object object = zzwF;
        synchronized (object) {
            if (zzwF.contains(string4)) {
                zzb.zzaC("Stream cache already in progress at " + string2);
                this.zza(string2, file);
                return false;
            }
            zzwF.add(string4);
        }
        object = null;
        try {
            int n;
            int n2;
            URLConnection uRLConnection = new URL(string2).openConnection();
            int n3 = zzbz.zztS.get();
            uRLConnection.setConnectTimeout(n3);
            uRLConnection.setReadTimeout(n3);
            if (uRLConnection instanceof HttpURLConnection && (n2 = ((HttpURLConnection)uRLConnection).getResponseCode()) >= 400) {
                throw new IOException("HTTP status code " + n2 + " at " + string2);
            }
            n2 = uRLConnection.getContentLength();
            if (n2 < 0) {
                zzb.zzaC("Stream cache aborted, missing content-length header at " + string2);
                this.zza(string2, file);
                zzwF.remove(string4);
                return false;
            }
            String string5 = zzwG.format(n2);
            int n4 = zzbz.zztP.get();
            if (n2 > n4) {
                zzb.zzaC("Content length " + string5 + " exceeds limit at " + string2);
                this.zza(string2, file);
                zzwF.remove(string4);
                return false;
            }
            zzb.zzay("Caching " + string5 + " bytes from " + string2);
            InputStream inputStream = uRLConnection.getInputStream();
            ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
            object = new FileOutputStream(file);
            FileChannel fileChannel = ((FileOutputStream)object).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            zzlb zzlb2 = zzo.zzbz();
            int n5 = 0;
            long l = zzlb2.currentTimeMillis();
            long l2 = zzbz.zztR.get();
            zzhq zzhq2 = new zzhq(l2);
            long l3 = zzbz.zztQ.get();
            while ((n = readableByteChannel.read(byteBuffer)) >= 0) {
                if ((n5 += n) > n4) {
                    throw new IOException("stream cache file size limit exceeded");
                }
                byteBuffer.flip();
                while (fileChannel.write(byteBuffer) > 0) {
                }
                byteBuffer.clear();
                long l4 = zzlb2.currentTimeMillis();
                if (l4 - l > l3 * 1000L) {
                    throw new IOException("stream cache time limit exceeded");
                }
                if (this.zzwI) {
                    throw new IOException("abort requested");
                }
                if (!zzhq2.tryAcquire()) continue;
                this.zza(string2, file, n5, n2);
            }
            ((FileOutputStream)object).close();
            if (zzb.zzL(3)) {
                String string6 = zzwG.format(n5);
                zzb.zzay("Preloaded " + string6 + " bytes from " + string2);
            }
            file.setReadable(true, false);
            zzdr.zzb(file2);
            this.zza(string2, file, n5);
            zzwF.remove(string4);
            return true;
        }
        catch (IOException iOException) {
            try {
                ((FileOutputStream)object).close();
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
            if (this.zzwI) {
                zzb.zzaA("Preload aborted for URL \"" + string2 + "\"");
            } else {
                zzb.zzd("Preload failed for URL \"" + string2 + "\"", iOException);
            }
            if (file.exists() && !file.delete()) {
                zzb.zzaC("Could not delete partial cache file at " + file.getAbsolutePath());
            }
            this.zza(string2, file);
            zzwF.remove(string4);
            return false;
        }
    }

    public void abort() {
        this.zzwI = true;
    }

    public int zzdQ() {
        if (this.zzwH == null) {
            return 0;
        }
        int n = 0;
        for (File file : this.zzwH.listFiles()) {
            if (file.getName().endsWith(".done")) continue;
            ++n;
        }
        return n;
    }

    public boolean zzdR() {
        if (this.zzwH == null) {
            return false;
        }
        File file = null;
        long l = Long.MAX_VALUE;
        for (File file2 : this.zzwH.listFiles()) {
            long l2;
            if (file2.getName().endsWith(".done") || (l2 = file2.lastModified()) >= l) continue;
            file = file2;
            l = l2;
        }
        boolean bl = false;
        if (file != null) {
            bl = file.delete();
            File file3 = this.zza(file);
            if (file3.isFile()) {
                bl &= file3.delete();
            }
        }
        return bl;
    }

    private void zza(final String string2, final File file, final int n, final int n2) {
        zza.zzGF.post(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("event", "precacheProgress");
                hashMap.put("src", string2);
                hashMap.put("cachedSrc", file.getAbsolutePath());
                hashMap.put("bytesLoaded", Integer.toString(n));
                hashMap.put("totalBytes", Integer.toString(n2));
                zzdr.this.zzoA.zzc("onPrecacheEvent", hashMap);
            }
        });
    }

    private void zza(final String string2, final File file, final int n) {
        zza.zzGF.post(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("event", "precacheComplete");
                hashMap.put("src", string2);
                hashMap.put("cachedSrc", file.getAbsolutePath());
                hashMap.put("totalBytes", Integer.toString(n));
                zzdr.this.zzoA.zzc("onPrecacheEvent", hashMap);
            }
        });
    }

    private void zza(final String string2, final File file) {
        zza.zzGF.post(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("event", "precacheCanceled");
                hashMap.put("src", string2);
                if (file != null) {
                    hashMap.put("cachedSrc", file.getAbsolutePath());
                }
                zzdr.this.zzoA.zzc("onPrecacheEvent", hashMap);
            }
        });
    }

    private String zzX(String string2) {
        return zzk.zzcA().zzax(string2);
    }

    private File zza(File file) {
        return new File(this.zzwH, file.getName() + ".done");
    }

    private static void zzb(File file) {
        if (file.isFile()) {
            file.setLastModified(System.currentTimeMillis());
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

