/*
 *  Copyright (C) 2011-2016  OpenDungeons Team
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GOALPROTECTCREATURE_H
#define GOALPROTECTCREATURE_H

#include "goals/Goal.h"

class GoalProtectCreature: public Goal
{
public:
    GoalProtectCreature(const std::string& nName, const std::string& nArguments);
    virtual ~GoalProtectCreature()
    {}

    // Inherited functions
    bool isMet(const Seat&, const GameMap&);
    std::string getDescription(const Seat&);
    std::string getSuccessMessage(const Seat&);
    std::string getFailedMessage(const Seat&);

private:
    std::string mCreatureName;
};

#endif // GOALPROTECTCREATURE_H
