/*
 * Copyright (c) 2013, 2018, Red Hat, Inc. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 *
 */

#include "precompiled.hpp"

#include "gc_implementation/shenandoah/shenandoahHeap.inline.hpp"
#include "gc_implementation/shenandoah/shenandoahVMOperations.hpp"
#include "gc_implementation/shenandoah/shenandoahUtils.hpp"

bool VM_ShenandoahReferenceOperation::doit_prologue() {
  if (Thread::current()->is_Java_thread()) {
    InstanceRefKlass::acquire_pending_list_lock(&_pending_list_basic_lock);
  } else {
    ShenandoahHeap *sh = (ShenandoahHeap*) Universe::heap();
    sh->acquire_pending_refs_lock();
  }
  return true;
}

void VM_ShenandoahReferenceOperation::doit_epilogue() {
  if (Thread::current()->is_Java_thread()) {
    InstanceRefKlass::release_and_notify_pending_list_lock(&_pending_list_basic_lock);
  } else {
    ShenandoahHeap *sh = ShenandoahHeap::heap();
    sh->release_pending_refs_lock();
  }
}

void VM_ShenandoahInitMark::doit() {
  ShenandoahGCPauseMark mark(SvcGCMarker::OTHER);
  ShenandoahHeap::heap()->entry_init_mark();
}

void VM_ShenandoahFinalMarkStartEvac::doit() {
  ShenandoahGCPauseMark mark(SvcGCMarker::OTHER);
  ShenandoahHeap::heap()->entry_final_mark();
}

void VM_ShenandoahFinalEvac::doit() {
  ShenandoahGCPauseMark mark(SvcGCMarker::OTHER);
  ShenandoahHeap::heap()->entry_final_evac();
}

void VM_ShenandoahFullGC::doit() {
  ShenandoahGCPauseMark mark(SvcGCMarker::FULL);
  ShenandoahHeap::heap()->entry_full(_gc_cause);
}

void VM_ShenandoahInitUpdateRefs::doit() {
  ShenandoahGCPauseMark mark(SvcGCMarker::OTHER);
  ShenandoahHeap::heap()->entry_init_updaterefs();
}

void VM_ShenandoahFinalUpdateRefs::doit() {
  ShenandoahGCPauseMark mark(SvcGCMarker::OTHER);
  ShenandoahHeap::heap()->entry_final_updaterefs();
}

void VM_ShenandoahDegeneratedGC::doit() {
  ShenandoahGCPauseMark mark(SvcGCMarker::OTHER);
  ShenandoahHeap::heap()->entry_degenerated(_point);
}
