/*
 * This file is part of OpenTTD.
 * OpenTTD is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 * OpenTTD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with OpenTTD. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file landscape_sprite.h Offsets of sprites to replace for non-temperate landscapes. */

static const SpriteID END = 0xFFFF;

static const SpriteID _landscape_spriteindexes_arctic[] = {
	 0xF67,  0xF9F,
	 0xAAD,  0xAB0,
	 0x83A,  0x845,
	 0xFA0,  0xFC9,
	 0x43F,  0x45E,
	 0x566,  0x56D,
	 0x945,  0x94C,
	 0x3ED,  0x40C,
	 0x515,  0x51C,
	 0x55A,  0x561,
	 0x534,  0x546,
	 0x93D,  0x944,
	 0x955,  0x95C,
	 0xFDD,  0xFEC,
	 0x87D,  0x883,
	 0xA2B,  0xA39,
	 0x497,  0x4B0,
	 0x572,  0x575,
	 0x94D,  0x954,
	 0x818,  0x81D,
	 0x3DE,  0x3EB,
	0x1212, 0x1212,
	END
};

static const SpriteID _landscape_spriteindexes_tropic[] = {
	 0xF67,  0xF9F,
	 0xAAD,  0xAB0,
	 0xFA0,  0xFC9,
	 0x43F,  0x45E,
	 0x566,  0x56D,
	 0x945,  0x94C,
	 0x3ED,  0x40C,
	 0x515,  0x51C,
	 0x55A,  0x561,
	 0x547,  0x559,
	 0x93D,  0x944,
	 0x955,  0x95C,
	 0xFDD,  0xFEC,
	 0x87D,  0x883,
	 0xA2B,  0xA39,
	 0x497,  0x4B0,
	 0x572,  0x575,
	 0x94D,  0x954,
	 0x5AE,  0x5AF,
	0x118D, 0x11D8,
	 0x534,  0x546,
	 0x40D,  0x426,
	 0x45F,  0x478,
	 0x4B1,  0x4CA,
	 0x95D,  0x97C,
	 0x3DE,  0x3EB,
	 0x562,  0x565,
	 0x56E,  0x571,
	 0x57A,  0x57D,
	 0x83A,  0x845,
	 0xFF5,  0xFF5,
	 0xFF8,  0xFF8,
	0x1212, 0x1212,
	END
};

static const SpriteID _landscape_spriteindexes_toyland[] = {
	 0xF54,  0xF9F,
	 0xFDD,  0xFE5,
	 0xFEC,  0xFEC,
	 0xFA0,  0xFC9,
	 0x818,  0x81D,
	 0x521,  0x546,
	 0x57E,  0x57F,
	 0x3ED,  0x40C,
	 0x43F,  0x45E,
	 0x491,  0x4B0,
	 0xA48,  0xA48,
	 0x4FB,  0x50A,
	 0x55A,  0x561,
	 0x566,  0x56D,
	 0x572,  0x579,
	 0x427,  0x42C,
	 0x479,  0x47E,
	 0x4CB,  0x4D0,
	 0x4EF,  0x4FA,
	 0xE9D,  0xECC,
	 0xF3D,  0xF40,
	 0xB59,  0xB60,
	 0xE5D,  0xE6C,
	 0xA49,  0xA59,
	 0xA63,  0xA68,
	 0xA5A,  0xA62,
	 0xA78,  0xA83,
	 0xA69,  0xA77,
	 0xA84,  0xAA3,
	 0xAA7,  0xAAC,
	 0xA2B,  0xA47,
	 0x3DE,  0x3EB,
	 0x47F,  0x488,
	 0x4D1,  0x4DA,
	 0x42D,  0x436,
	 0x515,  0x51C,
	 0x580,  0x585,
	 0xC14,  0xCB3,
	 0xAAD,  0xAB0,
	 0xAB5,  0xB00,
	 0xB69,  0xB70,
	 0xB61,  0xB68,
	 0xBC9,  0xBD0,
	 0xBD9,  0xBE0,
	 0xBA9,  0xBB0,
	 0xBC1,  0xBC4,
	 0x2D0,  0x2D0,
	 0xAA5,  0xAA6,
	 0x50F,  0x50F,
	 0x2EA,  0x2EA,
	 0x2ED,  0x2EE,
	 0x512,  0x513,
	 0x4EB,  0x4EE,
	 0x4E7,  0x4EA,
	 0x985,  0xA28,
	0x10E4, 0x1133,
	 0x93D,  0x95C,
	 0x97D,  0x984,
	 0x7DA,  0x7DA,
	 0x2E6,  0x2E6,
	   0x1,    0x1,
	 0xE54,  0xE54,
	 0x51F,  0x520,
	 0x514,  0x514,
	 0x511,  0x511,
	 0x322,  0x322,
	END
};
