/*
 * Potamus: an audio player
 * Copyright (C) 2004, 2005, 2006, 2007 Adam Sampson <ats@offog.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include <string.h>
#include <stdlib.h>
#include "buffer.h"

buffer *buffer_new(void) {
	buffer *b = malloc(sizeof *b);
	if (b == NULL)
		return NULL;

	b->data = NULL;
	b->capacity = 0;
	b->used = 0;

	return b;
}

void buffer_free(buffer *b) {
	free(b->data);
	free(b);
}

unsigned char *buffer_reserve(buffer *b, size_t size) {
	// Allow 0-size buffers to be allocated (since realloc would return
	// NULL if we asked it to allocate 0 bytes).
	if (size == 0)
		size = 1;

	size_t want_size = b->used + size;
	if (b->capacity < want_size) {
		unsigned char *new_data = realloc(b->data, want_size);
		if (new_data == NULL)
			return NULL;
		b->data = new_data;
		b->capacity = want_size;
	}
	return b->data + b->used;
}

void buffer_remove(buffer *b, size_t size) {
	memmove(b->data, b->data + size, b->used - size);
	b->used -= size;
}
