/*
 * Potamus: an audio player
 * Copyright (C) 2004, 2005, 2006, 2007, 2012 Adam Sampson <ats@offog.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <glib.h>
#include "buffer.h"
#include "format.h"
#include "output.h"
#ifdef ENABLE_OUTPUT_AO
#include "output-ao.h"
#endif
#ifdef ENABLE_OUTPUT_JACK
#include "output-jack.h"
#endif

output *output_alloc(void) {
	output *o = malloc(sizeof *o);
	if (o == NULL)
		g_error("out of memory");

	return o;
}

output_constructor outputs[] = {
#ifdef ENABLE_OUTPUT_JACK
	output_new_jack,
#endif
#ifdef ENABLE_OUTPUT_AO
	output_new_ao,
#endif
	NULL
};

output *get_output(sample_format **force_fmt) {
	output_constructor *p = &outputs[0];
	while (*p != NULL) {
		output *o = (*p++)(force_fmt);
		if (o != NULL)
			return o;
	}
	return NULL;
}

