/***************************************************************************
  topol.cpp
  TOPOLogy checker
  -------------------
         begin                : May 2009
         copyright            : (C) 2009 by Vita Cizek
         email                : weetya (at) gmail.com

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// QGIS Specific includes
#include "qgsmaplayer.h"
#include "qgsapplication.h"
#include "qgisinterface.h"
#include "qgsguiutils.h"

// Qt Related Includes
#include <QAction>
#include <QToolBar>
#include <QFile>
#include <QMessageBox>

#include "topol.h"
#include "checkDock.h"

static const QString sName = QObject::tr( "Topology Checker" );
static const QString sDescription = QObject::tr( "A Plugin for finding topological errors in vector layers" );
static const QString sCategory = QObject::tr( "Vector" );
static const QString sPluginVersion = QObject::tr( "Version 0.1" );
static const QgisPlugin::PluginType sPluginType = QgisPlugin::UI;
static const QString sPluginIcon = QStringLiteral( ":/topology/mActionTopologyChecker.svg" );

//////////////////////////////////////////////////////////////////////
//
// THE FOLLOWING METHODS ARE MANDATORY FOR ALL PLUGINS
//
//////////////////////////////////////////////////////////////////////

/**
 * Constructor for the plugin. The plugin is passed a pointer
 * an interface object that provides access to exposed functions in QGIS.
 * @param theQGisInterface - Pointer to the QGIS interface object
 */
Topol::Topol( QgisInterface *qgisInterface )
  : QgisPlugin( sName, sDescription, sCategory, sPluginVersion, sPluginType )
  , mQGisIface( qgisInterface )
{
  mDock = nullptr;
}

/*
 * Initialize the GUI interface for the plugin - this is only called once when the plugin is
 * added to the plugin registry in the QGIS application.
 */
void Topol::initGui()
{
  delete mQActionPointer;

  mQActionPointer = new QAction( QIcon( sPluginIcon ), sName, this );
  mQActionPointer->setObjectName( QStringLiteral( "mQActionPointer" ) );
  //mQActionPointer = new QAction( QIcon(), tr( "Topology Checker" ), this );
  mQActionPointer->setCheckable( true );


  // Create the action for tool
  //mQActionPointer = new QAction(QIcon(":/topol_c/topol.png"),tr("Topology Checker"), this);
  // Set the what's this text
  mQActionPointer->setWhatsThis( tr( "Topology Checker for vector layer" ) );
  // Connect the action to the run
  connect( mQActionPointer, &QAction::triggered, this, &Topol::showOrHide );
  // Add the icon to the toolbar
  mQGisIface->addVectorToolBarIcon( mQActionPointer );
  mQGisIface->addPluginToVectorMenu( tr( "&Topology Checker" ), mQActionPointer );
  //run();
}
//method defined in interface
void Topol::help()
{
  //implement me!
}

void Topol::showOrHide()
{
  if ( !mDock )
    run();
  else if ( mQActionPointer->isChecked() )
    mDock->show();
  else
    mDock->hide();
}

// Slot called when the menu item is triggered
// If you created more menu items / toolbar buttons in initiGui, you should
// create a separate handler for each action - this single run() method will
// not be enough
void Topol::run()
{
  mDock = new checkDock( mQGisIface );
  mQGisIface->addDockWidget( Qt::RightDockWidgetArea, mDock );
  connect( mDock, &QDockWidget::visibilityChanged, mQActionPointer, &QAction::setChecked );
  //mDock->show();
}

// Unload the plugin by cleaning up the GUI
void Topol::unload()
{
  // remove the GUI
  mQGisIface->removePluginVectorMenu( tr( "&Topology Checker" ), mQActionPointer );
  mQGisIface->removeVectorToolBarIcon( mQActionPointer );
  delete mQActionPointer;
}

//////////////////////////////////////////////////////////////////////////
//
//
//  THE FOLLOWING CODE IS AUTOGENERATED BY THE PLUGIN BUILDER SCRIPT
//    YOU WOULD NORMALLY NOT NEED TO MODIFY THIS, AND YOUR PLUGIN
//      MAY NOT WORK PROPERLY IF YOU MODIFY THIS INCORRECTLY
//
//
//////////////////////////////////////////////////////////////////////////


/**
 * Required extern functions needed  for every plugin
 * These functions can be called prior to creating an instance
 * of the plugin class
 */
// Class factory to return a new instance of the plugin class
QGISEXTERN QgisPlugin *classFactory( QgisInterface *qgisInterfacePointer )
{
  return new Topol( qgisInterfacePointer );
}
// Return the name of the plugin - note that we do not user class members as
// the class may not yet be insantiated when this method is called.
QGISEXTERN QString name()
{
  return sName;
}

// Return the description
QGISEXTERN QString description()
{
  return sDescription;
}

// Return the type (either UI or MapLayer plugin)
QGISEXTERN int type()
{
  return sPluginType;
}

// Return the category
QGISEXTERN QString category()
{
  return sCategory;
}

// Return the version number for the plugin
QGISEXTERN QString version()
{
  return sPluginVersion;
}

QGISEXTERN QString icon()
{
  return sPluginIcon;
}

// Delete ourself
QGISEXTERN void unload( QgisPlugin *pluginPointer )
{
  delete pluginPointer;
}
