/*
 * RetroShare Android QML App
 * Copyright (C) 2017  Gioacchino Mazzurco <gio@eigenlab.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.7
import QtQuick.Controls 2.0

Item
{
	id: nodeDetailsRoot

	property string pgpName
	property alias pgpId: pgpIdTxt.text

	property string nodeCert

	property var locations

	Column
	{
		id: pgpColumn

		anchors.top: parent.top

		Text { text: nodeDetailsRoot.pgpName.replace(" (Generated by RetroShare) <>", "") }
		Text { id: pgpIdTxt }
	}

	JSONListModel
	{
		id: jsonModel
		json: JSON.stringify(nodeDetailsRoot.locations)
	}

	ListView
	{
		width: parent.width
		anchors.top: pgpColumn.bottom
		anchors.bottom: buttonsRow.top
		model: jsonModel.model
		delegate: Column
		{
			height: 60
			width: parent.width
			leftPadding: 4
			spacing: 4

			Row
			{
				height: 30
				spacing: 10

				Image
				{
					id: statusImage
					source: model.is_online ?
								"icons/state-ok.png" :
								"icons/state-offline.png"

					height: parent.height - 4
					fillMode: Image.PreserveAspectFit
					anchors.verticalCenter: parent.verticalCenter
				}
				Text
				{
					id: locNameText
					text: model.location
					anchors.verticalCenter: parent.verticalCenter
				}
			}

			Text { text: model.peer_id }
		}
	}

	Row
	{
		id: buttonsRow

		anchors.bottom: parent.bottom
		anchors.horizontalCenter: parent.horizontalCenter
		spacing: 6

		Button
		{
			text: qsTr("Revoke")
			onClicked:
				rsApi.request(
					"/peers/"+nodeDetailsRoot.pgpId+"/delete", "",
					function()
					{ stackView.push("qrc:/TrustedNodesView.qml") })
		}

		Button
		{
			text: qsTr("Entrust")

			visible: nodeDetailsRoot.nodeCert.length > 0
			onClicked:
			{
				var jsonData =
				{
					cert_string: nodeCert,
					flags:
					{
						allow_direct_download: true,
						allow_push: false,
						require_whitelist: false,
					}
				}
				rsApi.request(
							"PUT /peers", JSON.stringify(jsonData),
							function()
							{ stackView.push("qrc:/TrustedNodesView.qml") })
			}
		}
	}
}
