#ifndef __ROCCAT_KOVA2016_PROFILE_BUTTON_H__
#define __ROCCAT_KOVA2016_PROFILE_BUTTON_H__

/*
 * This file is part of roccat-tools.
 *
 * roccat-tools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * roccat-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with roccat-tools. If not, see <http://www.gnu.org/licenses/>.
 */

#include "roccat_button.h"

G_BEGIN_DECLS

typedef enum {
	KOVA2016_BUTTON_TYPE_DISABLED = 0x00,
	KOVA2016_BUTTON_TYPE_CLICK = 0x01,
	KOVA2016_BUTTON_TYPE_MENU = 0x02,
	KOVA2016_BUTTON_TYPE_UNIVERSAL_SCROLLING = 0x03,
	KOVA2016_BUTTON_TYPE_DOUBLE_CLICK = 0x04, /* missing in Windows */
	KOVA2016_BUTTON_TYPE_SHORTCUT = 0x05,

	KOVA2016_BUTTON_TYPE_BROWSER_FORWARD = 0x07,
	KOVA2016_BUTTON_TYPE_BROWSER_BACKWARD = 0x08,
	KOVA2016_BUTTON_TYPE_TILT_LEFT = 0x09,
	KOVA2016_BUTTON_TYPE_TILT_RIGHT = 0x0a,

	KOVA2016_BUTTON_TYPE_SCROLL_UP = 0x0d,
	KOVA2016_BUTTON_TYPE_SCROLL_DOWN = 0x0e,
	KOVA2016_BUTTON_TYPE_OPEN_APPLICATION = 0x0f,
	KOVA2016_BUTTON_TYPE_PROFILE_CYCLE = 0x10,
	KOVA2016_BUTTON_TYPE_PROFILE_UP = 0x11,
	KOVA2016_BUTTON_TYPE_PROFILE_DOWN = 0x12,

	KOVA2016_BUTTON_TYPE_CPI_CYCLE = 0x14,
	KOVA2016_BUTTON_TYPE_CPI_UP = 0x15,
	KOVA2016_BUTTON_TYPE_CPI_DOWN = 0x16,

	KOVA2016_BUTTON_TYPE_OPEN_DRIVER = 0x1b,

	KOVA2016_BUTTON_TYPE_PREV_TRACK = 0x21,
	KOVA2016_BUTTON_TYPE_NEXT_TRACK = 0x22,
	KOVA2016_BUTTON_TYPE_PLAY_PAUSE = 0x23,
	KOVA2016_BUTTON_TYPE_STOP = 0x24,
	KOVA2016_BUTTON_TYPE_MUTE_MASTER = 0x25,
	KOVA2016_BUTTON_TYPE_VOLUME_DOWN = 0x26,
	KOVA2016_BUTTON_TYPE_VOLUME_UP = 0x27,

	KOVA2016_BUTTON_TYPE_MACRO = 0x30,
	KOVA2016_BUTTON_TYPE_TIMER = 0x31,
	KOVA2016_BUTTON_TYPE_TIMER_STOP = 0x32,
	KOVA2016_BUTTON_TYPE_EASYAIM_1 = 0x33,
	KOVA2016_BUTTON_TYPE_EASYAIM_2 = 0x34,
	KOVA2016_BUTTON_TYPE_EASYAIM_3 = 0x35,
	KOVA2016_BUTTON_TYPE_EASYAIM_4 = 0x36,
	KOVA2016_BUTTON_TYPE_EASYAIM_5 = 0x37,

	KOVA2016_BUTTON_TYPE_EASYSHIFT_SELF = 0x41,

	KOVA2016_BUTTON_TYPE_EASYWHEEL_PROFILE = 0x43,
	KOVA2016_BUTTON_TYPE_EASYWHEEL_CPI = 0x44,
	KOVA2016_BUTTON_TYPE_EASYWHEEL_VOLUME = 0x45,
	KOVA2016_BUTTON_TYPE_EASYWHEEL_ALT_TAB = 0x46,
	KOVA2016_BUTTON_TYPE_EASYWHEEL_AERO_FLIP_3D = 0x47,

	KOVA2016_BUTTON_TYPE_EASYSHIFT_OTHER = 0x51,
	KOVA2016_BUTTON_TYPE_EASYSHIFT_LOCK_OTHER = 0x52,
	KOVA2016_BUTTON_TYPE_EASYSHIFT_ALL = 0x53,

	KOVA2016_BUTTON_TYPE_HOME = 0x62,
	KOVA2016_BUTTON_TYPE_END = 0x63,
	KOVA2016_BUTTON_TYPE_PAGE_UP = 0x64,
	KOVA2016_BUTTON_TYPE_PAGE_DOWN = 0x65,
	KOVA2016_BUTTON_TYPE_LEFT_CTRL = 0x66,
	KOVA2016_BUTTON_TYPE_LEFT_SHIFT = 0x67,
	KOVA2016_BUTTON_TYPE_LEFT_ALT = 0x68,
	
	KOVA2016_BUTTON_TYPE_EASYAIM_CUSTOM = 0x7c, /* cpi in modifier */

	KOVA2016_BUTTON_TYPE_OPEN_FOLDER_COMPUTER = 0x86, /* missing in Windows */
	KOVA2016_BUTTON_TYPE_OPEN_APPLICATION_CALCULATOR = 0x87, /* missing in Windows */
	KOVA2016_BUTTON_TYPE_OPEN_APPLICATION_EMAIL = 0x88, /* missing in Windows */
	KOVA2016_BUTTON_TYPE_OPEN_DOCUMENT = 0x89, /* missing in Windows */
	KOVA2016_BUTTON_TYPE_OPEN_FOLDER = 0x8a, /* missing in Windows */
	KOVA2016_BUTTON_TYPE_OPEN_WEBSITE = 0x8b, /* missing in Windows */

	KOVA2016_BUTTON_TYPE_PROFILE_1 = 0xbf,
	KOVA2016_BUTTON_TYPE_PROFILE_2 = 0xc0,
	KOVA2016_BUTTON_TYPE_PROFILE_3 = 0xc1,
	KOVA2016_BUTTON_TYPE_PROFILE_4 = 0xc2,
	KOVA2016_BUTTON_TYPE_PROFILE_5 = 0xc3,

	KOVA2016_BUTTON_TYPE_EASYAIM_200 = 0xd0,
} Kova2016ButtonType;

G_END_DECLS

#endif
