/* Copyright (c) 2018, 2019, 2020 Evan Nemerson <evan@nemerson.com>
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#define SIMDE_TESTS_CURRENT_ISAX avx512bw
#include <simde/x86/avx512bw.h>
#include <test/x86/test-avx512.h>

static int
test_simde_mm512_mask_set1_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask64 k;
    int8_t a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  80), INT8_C(  13), INT8_C( -86), INT8_C( 103),
                           INT8_C(  30), INT8_C(  88), INT8_C( -63), INT8_C( -16),
                           INT8_C( -68), INT8_C( -20), INT8_C(  48), INT8_C( -36),
                           INT8_C( -97), INT8_C(-103), INT8_C(-104), INT8_C( -61),
                           INT8_C(-122), INT8_C( -83), INT8_C(  -3), INT8_C(-115),
                           INT8_C(  29), INT8_C(-112), INT8_C( 118), INT8_C(  53),
                           INT8_C(-107), INT8_C(-126), INT8_C(  41), INT8_C(-117),
                           INT8_C(  -4), INT8_C( -72), INT8_C(  -9), INT8_C(   2),
                           INT8_C(  10), INT8_C( -61), INT8_C( 116), INT8_C(   1),
                           INT8_C(  35), INT8_C( -78), INT8_C(  17), INT8_C( -82),
                           INT8_C( -14), INT8_C( 120), INT8_C( 120), INT8_C(  33),
                           INT8_C(  97), INT8_C(   4), INT8_C(-104), INT8_C(  67),
                           INT8_C( -86), INT8_C( -90), INT8_C( -95), INT8_C(  51),
                           INT8_C( -83), INT8_C(-120), INT8_C( 123), INT8_C(  -4),
                           INT8_C(  51), INT8_C( -66), INT8_C( -91), INT8_C(  51),
                           INT8_C(  -1), INT8_C(  32), INT8_C(  30), INT8_C(  92)),
      UINT64_C(12701675613368776088),
      INT8_C( -94),
      simde_mm512_set_epi8(INT8_C( -94), INT8_C(  13), INT8_C( -94), INT8_C( -94),
                           INT8_C(  30), INT8_C(  88), INT8_C( -63), INT8_C( -16),
                           INT8_C( -68), INT8_C( -94), INT8_C(  48), INT8_C( -36),
                           INT8_C( -97), INT8_C( -94), INT8_C(-104), INT8_C( -94),
                           INT8_C(-122), INT8_C( -94), INT8_C( -94), INT8_C(-115),
                           INT8_C( -94), INT8_C(-112), INT8_C( -94), INT8_C(  53),
                           INT8_C( -94), INT8_C(-126), INT8_C( -94), INT8_C(-117),
                           INT8_C( -94), INT8_C( -94), INT8_C(  -9), INT8_C(   2),
                           INT8_C( -94), INT8_C( -61), INT8_C( 116), INT8_C(   1),
                           INT8_C( -94), INT8_C( -78), INT8_C( -94), INT8_C( -94),
                           INT8_C( -14), INT8_C( 120), INT8_C( 120), INT8_C( -94),
                           INT8_C(  97), INT8_C( -94), INT8_C( -94), INT8_C(  67),
                           INT8_C( -86), INT8_C( -94), INT8_C( -94), INT8_C( -94),
                           INT8_C( -83), INT8_C( -94), INT8_C( 123), INT8_C( -94),
                           INT8_C( -94), INT8_C( -66), INT8_C( -91), INT8_C( -94),
                           INT8_C( -94), INT8_C(  32), INT8_C(  30), INT8_C(  92)) },
    { simde_mm512_set_epi8(INT8_C( -64), INT8_C( -80), INT8_C(  33), INT8_C(  -9),
                           INT8_C(   3), INT8_C(  93), INT8_C(  13), INT8_C( -28),
                           INT8_C(  79), INT8_C(  10), INT8_C( -42), INT8_C(-127),
                           INT8_C( 114), INT8_C(  78), INT8_C(  61), INT8_C(  67),
                           INT8_C(  95), INT8_C(  14), INT8_C(  28), INT8_C(  56),
                           INT8_C(  43), INT8_C( -20), INT8_C( -77), INT8_C(  83),
                           INT8_C( -68), INT8_C(  87), INT8_C( -96), INT8_C(  13),
                           INT8_C(  40), INT8_C( 107), INT8_C( -63), INT8_C(  -1),
                           INT8_C(  77), INT8_C(  21), INT8_C( -46), INT8_C( -12),
                           INT8_C(  42), INT8_C(  69), INT8_C(  51), INT8_C(  11),
                           INT8_C(-120), INT8_C(  65), INT8_C( -70), INT8_C( -19),
                           INT8_C( -95), INT8_C(  43), INT8_C(  -2), INT8_C( -62),
                           INT8_C( -16), INT8_C(  28), INT8_C(  29), INT8_C( -11),
                           INT8_C(  17), INT8_C( -18), INT8_C( 105), INT8_C(-119),
                           INT8_C(  60), INT8_C( 120), INT8_C(  38), INT8_C( -41),
                           INT8_C(  20), INT8_C( -30), INT8_C(  15), INT8_C( 112)),
      UINT64_C(15052494645983188959),
      INT8_C( -73),
      simde_mm512_set_epi8(INT8_C( -73), INT8_C( -73), INT8_C(  33), INT8_C( -73),
                           INT8_C(   3), INT8_C(  93), INT8_C(  13), INT8_C( -28),
                           INT8_C( -73), INT8_C( -73), INT8_C( -73), INT8_C(-127),
                           INT8_C( 114), INT8_C( -73), INT8_C(  61), INT8_C( -73),
                           INT8_C(  95), INT8_C(  14), INT8_C( -73), INT8_C( -73),
                           INT8_C(  43), INT8_C( -73), INT8_C( -77), INT8_C(  83),
                           INT8_C( -68), INT8_C(  87), INT8_C( -73), INT8_C(  13),
                           INT8_C(  40), INT8_C( 107), INT8_C( -63), INT8_C( -73),
                           INT8_C(  77), INT8_C(  21), INT8_C( -46), INT8_C( -12),
                           INT8_C(  42), INT8_C( -73), INT8_C(  51), INT8_C( -73),
                           INT8_C(-120), INT8_C( -73), INT8_C( -70), INT8_C( -19),
                           INT8_C( -73), INT8_C( -73), INT8_C(  -2), INT8_C( -62),
                           INT8_C( -16), INT8_C(  28), INT8_C(  29), INT8_C( -73),
                           INT8_C(  17), INT8_C( -73), INT8_C( -73), INT8_C( -73),
                           INT8_C( -73), INT8_C( -73), INT8_C(  38), INT8_C( -73),
                           INT8_C( -73), INT8_C( -73), INT8_C( -73), INT8_C( -73)) },
    { simde_mm512_set_epi8(INT8_C( 107), INT8_C( 126), INT8_C( -33), INT8_C(  83),
                           INT8_C(  46), INT8_C(  62), INT8_C( -81), INT8_C(  33),
                           INT8_C( -68), INT8_C(-126), INT8_C( -41), INT8_C( 125),
                           INT8_C( -96), INT8_C( -20), INT8_C(  62), INT8_C( -19),
                           INT8_C(  29), INT8_C( -96), INT8_C(  68), INT8_C( 119),
                           INT8_C( -36), INT8_C( -62), INT8_C( -27), INT8_C(-112),
                           INT8_C(-123), INT8_C(  55), INT8_C(-119), INT8_C(  -4),
                           INT8_C(  58), INT8_C(  28), INT8_C( -84), INT8_C( -38),
                           INT8_C(   1), INT8_C( -25), INT8_C( 107), INT8_C( -63),
                           INT8_C( -86), INT8_C(  88), INT8_C(  36), INT8_C(  53),
                           INT8_C( 109), INT8_C( -36), INT8_C( -70), INT8_C(-125),
                           INT8_C(  -3), INT8_C(-109), INT8_C( 121), INT8_C( -63),
                           INT8_C( 113), INT8_C( -92), INT8_C(  -4), INT8_C(-105),
                           INT8_C( -65), INT8_C(  26), INT8_C( -36), INT8_C(  87),
                           INT8_C(-101), INT8_C( -70), INT8_C(  -3), INT8_C(  26),
                           INT8_C( -88), INT8_C( -51), INT8_C(-123), INT8_C(  93)),
      UINT64_C( 2985661334514035835),
      INT8_C( 111),
      simde_mm512_set_epi8(INT8_C( 107), INT8_C( 126), INT8_C( 111), INT8_C(  83),
                           INT8_C( 111), INT8_C(  62), INT8_C( -81), INT8_C( 111),
                           INT8_C( -68), INT8_C( 111), INT8_C( 111), INT8_C( 125),
                           INT8_C( 111), INT8_C( 111), INT8_C( 111), INT8_C( 111),
                           INT8_C(  29), INT8_C( -96), INT8_C( 111), INT8_C( 111),
                           INT8_C( -36), INT8_C( -62), INT8_C( 111), INT8_C( 111),
                           INT8_C(-123), INT8_C(  55), INT8_C( 111), INT8_C(  -4),
                           INT8_C( 111), INT8_C(  28), INT8_C( 111), INT8_C( -38),
                           INT8_C(   1), INT8_C( -25), INT8_C( 111), INT8_C( 111),
                           INT8_C( 111), INT8_C( 111), INT8_C( 111), INT8_C( 111),
                           INT8_C( 109), INT8_C( 111), INT8_C( -70), INT8_C( 111),
                           INT8_C(  -3), INT8_C(-109), INT8_C( 111), INT8_C( 111),
                           INT8_C( 111), INT8_C( 111), INT8_C( 111), INT8_C(-105),
                           INT8_C( 111), INT8_C( 111), INT8_C( -36), INT8_C(  87),
                           INT8_C(-101), INT8_C( 111), INT8_C( 111), INT8_C( 111),
                           INT8_C( 111), INT8_C( -51), INT8_C( 111), INT8_C( 111)) },
    { simde_mm512_set_epi8(INT8_C( -63), INT8_C(  92), INT8_C( -41), INT8_C( -80),
                           INT8_C(-101), INT8_C(  86), INT8_C(  45), INT8_C(  45),
                           INT8_C( -41), INT8_C(-113), INT8_C( -17), INT8_C(-101),
                           INT8_C(-113), INT8_C( -69), INT8_C(  73), INT8_C(-124),
                           INT8_C(  90), INT8_C(-118), INT8_C(  31), INT8_C(-124),
                           INT8_C( -88), INT8_C(-116), INT8_C(   8), INT8_C( -37),
                           INT8_C( -41), INT8_C(  93), INT8_C( -86), INT8_C(  61),
                           INT8_C( -70), INT8_C( -88), INT8_C(  44), INT8_C( -34),
                           INT8_C( -21), INT8_C(-121), INT8_C(-124), INT8_C(-114),
                           INT8_C(  73), INT8_C(  92), INT8_C( -92), INT8_C(-115),
                           INT8_C(   6), INT8_C(-120), INT8_C(  89), INT8_C(-102),
                           INT8_C( -43), INT8_C(  33), INT8_C(  15), INT8_C(  -6),
                           INT8_C(-105), INT8_C(  66), INT8_C( -60), INT8_C(  54),
                           INT8_C( -95), INT8_C(  49), INT8_C(   1), INT8_C( 118),
                           INT8_C( -33), INT8_C( -35), INT8_C( -34), INT8_C( -10),
                           INT8_C( -70), INT8_C(  74), INT8_C( -10), INT8_C(  97)),
      UINT64_C(12556192675989742329),
      INT8_C(-120),
      simde_mm512_set_epi8(INT8_C(-120), INT8_C(  92), INT8_C(-120), INT8_C( -80),
                           INT8_C(-120), INT8_C(-120), INT8_C(-120), INT8_C(  45),
                           INT8_C( -41), INT8_C(-120), INT8_C( -17), INT8_C(-101),
                           INT8_C(-113), INT8_C( -69), INT8_C(  73), INT8_C(-124),
                           INT8_C(-120), INT8_C(-118), INT8_C(  31), INT8_C(-124),
                           INT8_C(-120), INT8_C(-120), INT8_C(-120), INT8_C( -37),
                           INT8_C(-120), INT8_C(  93), INT8_C(-120), INT8_C(-120),
                           INT8_C( -70), INT8_C(-120), INT8_C(-120), INT8_C( -34),
                           INT8_C(-120), INT8_C(-121), INT8_C(-124), INT8_C(-120),
                           INT8_C(  73), INT8_C(-120), INT8_C(-120), INT8_C(-120),
                           INT8_C(-120), INT8_C(-120), INT8_C(-120), INT8_C(-120),
                           INT8_C(-120), INT8_C(  33), INT8_C(-120), INT8_C(  -6),
                           INT8_C(-120), INT8_C(-120), INT8_C(-120), INT8_C(  54),
                           INT8_C( -95), INT8_C(  49), INT8_C(-120), INT8_C( 118),
                           INT8_C(-120), INT8_C(-120), INT8_C(-120), INT8_C(-120),
                           INT8_C(-120), INT8_C(  74), INT8_C( -10), INT8_C(-120)) },
    { simde_mm512_set_epi8(INT8_C(  21), INT8_C(  17), INT8_C(  22), INT8_C(-115),
                           INT8_C( 101), INT8_C(  -2), INT8_C( -32), INT8_C( -27),
                           INT8_C( -14), INT8_C(  47), INT8_C( 110), INT8_C( -88),
                           INT8_C(  23), INT8_C( -87), INT8_C( -20), INT8_C( 115),
                           INT8_C( 108), INT8_C( -54), INT8_C(-105), INT8_C( -94),
                           INT8_C(  96), INT8_C(-110), INT8_C( -87), INT8_C( 119),
                           INT8_C( 110), INT8_C( -13), INT8_C(  53), INT8_C( -27),
                           INT8_C( -59), INT8_C(  57), INT8_C( -46), INT8_C( -24),
                           INT8_C(  35), INT8_C(  26), INT8_C( 124), INT8_C( -28),
                           INT8_C( -68), INT8_C( -57), INT8_C(  75), INT8_C( -25),
                           INT8_C(-112), INT8_C( 112), INT8_C( 123), INT8_C(-108),
                           INT8_C( 115), INT8_C(  -6), INT8_C(  43), INT8_C(  52),
                           INT8_C( -91), INT8_C( -17), INT8_C(  93), INT8_C(  -2),
                           INT8_C( 116), INT8_C( -51), INT8_C(  70), INT8_C(  98),
                           INT8_C( 104), INT8_C( -69), INT8_C(-102), INT8_C(  77),
                           INT8_C(  82), INT8_C( 125), INT8_C(  42), INT8_C(  83)),
      UINT64_C(12090133344763257330),
      INT8_C(  55),
      simde_mm512_set_epi8(INT8_C(  55), INT8_C(  17), INT8_C(  55), INT8_C(-115),
                           INT8_C( 101), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C( 110), INT8_C( -88),
                           INT8_C(  55), INT8_C( -87), INT8_C( -20), INT8_C( 115),
                           INT8_C(  55), INT8_C(  55), INT8_C(-105), INT8_C( -94),
                           INT8_C(  55), INT8_C(-110), INT8_C( -87), INT8_C( 119),
                           INT8_C( 110), INT8_C( -13), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  57), INT8_C( -46), INT8_C( -24),
                           INT8_C(  55), INT8_C(  26), INT8_C( 124), INT8_C( -28),
                           INT8_C( -68), INT8_C(  55), INT8_C(  75), INT8_C(  55),
                           INT8_C(  55), INT8_C( 112), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  -6), INT8_C(  43), INT8_C(  52),
                           INT8_C( -91), INT8_C( -17), INT8_C(  55), INT8_C(  -2),
                           INT8_C( 116), INT8_C( -51), INT8_C(  70), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  82), INT8_C( 125), INT8_C(  55), INT8_C(  83)) },
    { simde_mm512_set_epi8(INT8_C(-124), INT8_C( -37), INT8_C( -61), INT8_C( -35),
                           INT8_C( -22), INT8_C( -85), INT8_C(-117), INT8_C(-105),
                           INT8_C(  99), INT8_C( -62), INT8_C( 102), INT8_C( -31),
                           INT8_C(  82), INT8_C(  39), INT8_C(  49), INT8_C(  43),
                           INT8_C(  21), INT8_C(  16), INT8_C(  12), INT8_C(-125),
                           INT8_C(   2), INT8_C(-106), INT8_C(  -4), INT8_C( 100),
                           INT8_C( -12), INT8_C(  30), INT8_C( -39), INT8_C( -37),
                           INT8_C(  92), INT8_C( -43), INT8_C(  33), INT8_C(-124),
                           INT8_C(  48), INT8_C(   4), INT8_C(  31), INT8_C(  78),
                           INT8_C(-113), INT8_C( 115), INT8_C( 116), INT8_C( -62),
                           INT8_C(-109), INT8_C( -66), INT8_C(  43), INT8_C(-118),
                           INT8_C(-105), INT8_C( -11), INT8_C( 100), INT8_C(  41),
                           INT8_C(-104), INT8_C(-114), INT8_C(-105), INT8_C(  88),
                           INT8_C( -33), INT8_C(  -8), INT8_C(  41), INT8_C(  16),
                           INT8_C(   4), INT8_C(  89), INT8_C(  66), INT8_C(  27),
                           INT8_C( -63), INT8_C(  30), INT8_C( -95), INT8_C(  33)),
      UINT64_C(13436704833767296949),
      INT8_C(  18),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C( -37), INT8_C(  18), INT8_C(  18),
                           INT8_C(  18), INT8_C( -85), INT8_C(  18), INT8_C(-105),
                           INT8_C(  99), INT8_C(  18), INT8_C(  18), INT8_C(  18),
                           INT8_C(  18), INT8_C(  39), INT8_C(  49), INT8_C(  43),
                           INT8_C(  18), INT8_C(  18), INT8_C(  12), INT8_C(-125),
                           INT8_C(   2), INT8_C(-106), INT8_C(  18), INT8_C(  18),
                           INT8_C(  18), INT8_C(  18), INT8_C( -39), INT8_C(  18),
                           INT8_C(  18), INT8_C( -43), INT8_C(  18), INT8_C(  18),
                           INT8_C(  48), INT8_C(   4), INT8_C(  31), INT8_C(  78),
                           INT8_C(  18), INT8_C( 115), INT8_C( 116), INT8_C( -62),
                           INT8_C(-109), INT8_C(  18), INT8_C(  18), INT8_C(  18),
                           INT8_C(  18), INT8_C( -11), INT8_C( 100), INT8_C(  18),
                           INT8_C(-104), INT8_C(  18), INT8_C(-105), INT8_C(  88),
                           INT8_C(  18), INT8_C(  18), INT8_C(  18), INT8_C(  18),
                           INT8_C(  18), INT8_C(  89), INT8_C(  18), INT8_C(  18),
                           INT8_C( -63), INT8_C(  18), INT8_C( -95), INT8_C(  18)) },
    { simde_mm512_set_epi8(INT8_C( -30), INT8_C( 101), INT8_C(  64), INT8_C( 107),
                           INT8_C( -34), INT8_C( -67), INT8_C( -96), INT8_C(  35),
                           INT8_C( 117), INT8_C(  76), INT8_C( 106), INT8_C( -82),
                           INT8_C( -48), INT8_C(  63), INT8_C(  11), INT8_C(  22),
                           INT8_C(  41), INT8_C(  95), INT8_C(-123), INT8_C( -90),
                           INT8_C(  67), INT8_C( -76), INT8_C(-105), INT8_C(  -7),
                           INT8_C( 115), INT8_C( 121), INT8_C( -52), INT8_C( -95),
                           INT8_C(-101), INT8_C(  64), INT8_C( -67), INT8_C( 107),
                           INT8_C(-104), INT8_C(  56), INT8_C(  89), INT8_C( -95),
                           INT8_C(  21), INT8_C( -42), INT8_C( -75), INT8_C(  45),
                           INT8_C( -86), INT8_C(  32), INT8_C(  27), INT8_C(-119),
                           INT8_C( -68), INT8_C(   5), INT8_C( -78), INT8_C( -36),
                           INT8_C( 125), INT8_C( 117), INT8_C( -63), INT8_C( -68),
                           INT8_C( -45), INT8_C( -77), INT8_C(   6), INT8_C(  68),
                           INT8_C(  79), INT8_C( -92), INT8_C(  67), INT8_C(  61),
                           INT8_C(  42), INT8_C(  26), INT8_C(-117), INT8_C( -55)),
      UINT64_C(14020412538477965079),
      INT8_C( -46),
      simde_mm512_set_epi8(INT8_C( -46), INT8_C( -46), INT8_C(  64), INT8_C( 107),
                           INT8_C( -34), INT8_C( -67), INT8_C( -46), INT8_C(  35),
                           INT8_C( -46), INT8_C(  76), INT8_C( 106), INT8_C( -46),
                           INT8_C( -48), INT8_C(  63), INT8_C( -46), INT8_C(  22),
                           INT8_C( -46), INT8_C(  95), INT8_C(-123), INT8_C( -90),
                           INT8_C(  67), INT8_C( -76), INT8_C( -46), INT8_C(  -7),
                           INT8_C( -46), INT8_C( -46), INT8_C( -46), INT8_C( -95),
                           INT8_C( -46), INT8_C(  64), INT8_C( -46), INT8_C( -46),
                           INT8_C( -46), INT8_C(  56), INT8_C( -46), INT8_C( -95),
                           INT8_C(  21), INT8_C( -42), INT8_C( -75), INT8_C(  45),
                           INT8_C( -86), INT8_C( -46), INT8_C( -46), INT8_C(-119),
                           INT8_C( -46), INT8_C(   5), INT8_C( -78), INT8_C( -46),
                           INT8_C( 125), INT8_C( -46), INT8_C( -46), INT8_C( -68),
                           INT8_C( -46), INT8_C( -46), INT8_C( -46), INT8_C( -46),
                           INT8_C(  79), INT8_C( -92), INT8_C(  67), INT8_C( -46),
                           INT8_C(  42), INT8_C( -46), INT8_C( -46), INT8_C( -46)) },
    { simde_mm512_set_epi8(INT8_C( -83), INT8_C( -73), INT8_C( -22), INT8_C(  98),
                           INT8_C( 126), INT8_C(  41), INT8_C( -28), INT8_C( 126),
                           INT8_C( -75), INT8_C(  91), INT8_C( -33), INT8_C( 103),
                           INT8_C( -63), INT8_C(  62), INT8_C(  83), INT8_C(   4),
                           INT8_C(  65), INT8_C( -22), INT8_C( 107), INT8_C(   8),
                           INT8_C(  31), INT8_C(-111), INT8_C(-114), INT8_C(-118),
                           INT8_C(   2), INT8_C(  76), INT8_C(  19), INT8_C( 127),
                           INT8_C( -37), INT8_C( -41), INT8_C(  91), INT8_C( -64),
                           INT8_C(-105), INT8_C( 127), INT8_C(-121), INT8_C(  84),
                           INT8_C( 124), INT8_C(  50), INT8_C( -86), INT8_C(-101),
                           INT8_C( -82), INT8_C( 121), INT8_C(  18), INT8_C( -17),
                           INT8_C( -55), INT8_C(-102), INT8_C( -81), INT8_C( -54),
                           INT8_C( -56), INT8_C(  -2), INT8_C( -68), INT8_C( 105),
                           INT8_C( -48), INT8_C( -90), INT8_C( -46), INT8_C(  63),
                           INT8_C( 126), INT8_C( -93), INT8_C(  46), INT8_C(-114),
                           INT8_C(  58), INT8_C( 110), INT8_C( 102), INT8_C( -93)),
      UINT64_C(14839809536761107867),
      INT8_C( 106),
      simde_mm512_set_epi8(INT8_C( 106), INT8_C( 106), INT8_C( -22), INT8_C(  98),
                           INT8_C( 106), INT8_C( 106), INT8_C( -28), INT8_C( 106),
                           INT8_C( 106), INT8_C( 106), INT8_C( 106), INT8_C( 106),
                           INT8_C( -63), INT8_C(  62), INT8_C(  83), INT8_C( 106),
                           INT8_C( 106), INT8_C( -22), INT8_C( 107), INT8_C( 106),
                           INT8_C( 106), INT8_C(-111), INT8_C(-114), INT8_C(-118),
                           INT8_C(   2), INT8_C(  76), INT8_C( 106), INT8_C( 127),
                           INT8_C( -37), INT8_C( 106), INT8_C( 106), INT8_C( -64),
                           INT8_C(-105), INT8_C( 127), INT8_C( 106), INT8_C(  84),
                           INT8_C( 124), INT8_C( 106), INT8_C( -86), INT8_C( 106),
                           INT8_C( -82), INT8_C( 121), INT8_C(  18), INT8_C( 106),
                           INT8_C( 106), INT8_C(-102), INT8_C( -81), INT8_C( 106),
                           INT8_C( 106), INT8_C(  -2), INT8_C( -68), INT8_C( 106),
                           INT8_C( -48), INT8_C( 106), INT8_C( -46), INT8_C( 106),
                           INT8_C( 106), INT8_C( -93), INT8_C(  46), INT8_C( 106),
                           INT8_C( 106), INT8_C( 110), INT8_C( 106), INT8_C( 106)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_set1_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_maskz_set1_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask64 k;
    int8_t a;
    simde__m512i r;
  } test_vec[8] = {
   { UINT64_C( 2901368310709582274),
      INT8_C( -37),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C( -37), INT8_C(   0),
                           INT8_C( -37), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -37), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -37), INT8_C( -37),
                           INT8_C( -37), INT8_C(   0), INT8_C( -37), INT8_C( -37),
                           INT8_C( -37), INT8_C(   0), INT8_C( -37), INT8_C( -37),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -37),
                           INT8_C( -37), INT8_C(   0), INT8_C( -37), INT8_C( -37),
                           INT8_C(   0), INT8_C( -37), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -37), INT8_C(   0),
                           INT8_C(   0), INT8_C( -37), INT8_C( -37), INT8_C(   0),
                           INT8_C( -37), INT8_C(   0), INT8_C( -37), INT8_C( -37),
                           INT8_C(   0), INT8_C( -37), INT8_C( -37), INT8_C( -37),
                           INT8_C( -37), INT8_C(   0), INT8_C(   0), INT8_C( -37),
                           INT8_C( -37), INT8_C( -37), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -37), INT8_C(   0)) },
    { UINT64_C(15800639674747260058),
      INT8_C(  63),
      simde_mm512_set_epi8(INT8_C(  63), INT8_C(  63), INT8_C(   0), INT8_C(  63),
                           INT8_C(  63), INT8_C(   0), INT8_C(  63), INT8_C(  63),
                           INT8_C(   0), INT8_C(  63), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  63), INT8_C(  63), INT8_C(  63),
                           INT8_C(   0), INT8_C(   0), INT8_C(  63), INT8_C(   0),
                           INT8_C(   0), INT8_C(  63), INT8_C(  63), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  63),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  63),
                           INT8_C(  63), INT8_C(   0), INT8_C(   0), INT8_C(  63),
                           INT8_C(  63), INT8_C(  63), INT8_C(   0), INT8_C(  63),
                           INT8_C(   0), INT8_C(  63), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  63),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  63), INT8_C(  63), INT8_C(   0), INT8_C(   0),
                           INT8_C(  63), INT8_C(   0), INT8_C(   0), INT8_C(  63),
                           INT8_C(  63), INT8_C(   0), INT8_C(  63), INT8_C(   0)) },
    { UINT64_C(12860739080443979541),
      INT8_C(  53),
      simde_mm512_set_epi8(INT8_C(  53), INT8_C(   0), INT8_C(  53), INT8_C(  53),
                           INT8_C(   0), INT8_C(   0), INT8_C(  53), INT8_C(   0),
                           INT8_C(   0), INT8_C(  53), INT8_C(  53), INT8_C(  53),
                           INT8_C(  53), INT8_C(   0), INT8_C(  53), INT8_C(   0),
                           INT8_C(  53), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  53), INT8_C(  53), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  53), INT8_C(  53), INT8_C(   0), INT8_C(  53),
                           INT8_C(  53), INT8_C(  53), INT8_C(  53), INT8_C(  53),
                           INT8_C(   0), INT8_C(  53), INT8_C(  53), INT8_C(   0),
                           INT8_C(  53), INT8_C(  53), INT8_C(   0), INT8_C(  53),
                           INT8_C(  53), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  53), INT8_C(  53), INT8_C(  53), INT8_C(   0),
                           INT8_C(   0), INT8_C(  53), INT8_C(  53), INT8_C(  53),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  53),
                           INT8_C(   0), INT8_C(  53), INT8_C(   0), INT8_C(  53)) },
    { UINT64_C( 2595884503750725802),
      INT8_C(  78),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(  78), INT8_C(   0),
                           INT8_C(   0), INT8_C(  78), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  78), INT8_C(  78), INT8_C(   0),
                           INT8_C(   0), INT8_C(  78), INT8_C(  78), INT8_C(   0),
                           INT8_C(  78), INT8_C(  78), INT8_C(  78), INT8_C(  78),
                           INT8_C(   0), INT8_C(   0), INT8_C(  78), INT8_C(  78),
                           INT8_C(   0), INT8_C(   0), INT8_C(  78), INT8_C(  78),
                           INT8_C(  78), INT8_C(  78), INT8_C(   0), INT8_C(  78),
                           INT8_C(  78), INT8_C(  78), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  78), INT8_C(  78), INT8_C(   0), INT8_C(  78),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  78), INT8_C(   0), INT8_C(  78), INT8_C(   0),
                           INT8_C(  78), INT8_C(   0), INT8_C(  78), INT8_C(   0)) },
    { UINT64_C(13286373173549182748),
      INT8_C( -67),
      simde_mm512_set_epi8(INT8_C( -67), INT8_C(   0), INT8_C( -67), INT8_C( -67),
                           INT8_C( -67), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -67), INT8_C( -67), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -67), INT8_C(   0),
                           INT8_C( -67), INT8_C(   0), INT8_C( -67), INT8_C(   0),
                           INT8_C( -67), INT8_C( -67), INT8_C( -67), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -67),
                           INT8_C( -67), INT8_C( -67), INT8_C(   0), INT8_C( -67),
                           INT8_C(   0), INT8_C(   0), INT8_C( -67), INT8_C(   0),
                           INT8_C( -67), INT8_C(   0), INT8_C( -67), INT8_C(   0),
                           INT8_C( -67), INT8_C( -67), INT8_C(   0), INT8_C( -67),
                           INT8_C( -67), INT8_C(   0), INT8_C( -67), INT8_C(   0),
                           INT8_C( -67), INT8_C( -67), INT8_C( -67), INT8_C( -67),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -67),
                           INT8_C( -67), INT8_C( -67), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(16804997844821669286),
      INT8_C( -98),
      simde_mm512_set_epi8(INT8_C( -98), INT8_C( -98), INT8_C( -98), INT8_C(   0),
                           INT8_C( -98), INT8_C(   0), INT8_C(   0), INT8_C( -98),
                           INT8_C(   0), INT8_C(   0), INT8_C( -98), INT8_C( -98),
                           INT8_C(   0), INT8_C( -98), INT8_C( -98), INT8_C( -98),
                           INT8_C(   0), INT8_C( -98), INT8_C(   0), INT8_C( -98),
                           INT8_C( -98), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -98), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -98), INT8_C( -98), INT8_C(   0), INT8_C(   0),
                           INT8_C( -98), INT8_C( -98), INT8_C( -98), INT8_C( -98),
                           INT8_C( -98), INT8_C( -98), INT8_C(   0), INT8_C(   0),
                           INT8_C( -98), INT8_C( -98), INT8_C(   0), INT8_C(   0),
                           INT8_C( -98), INT8_C( -98), INT8_C( -98), INT8_C( -98),
                           INT8_C(   0), INT8_C( -98), INT8_C(   0), INT8_C( -98),
                           INT8_C( -98), INT8_C(   0), INT8_C( -98), INT8_C(   0),
                           INT8_C(   0), INT8_C( -98), INT8_C( -98), INT8_C(   0)) },
    { UINT64_C(14388383136321922859),
      INT8_C( -31),
      simde_mm512_set_epi8(INT8_C( -31), INT8_C( -31), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -31), INT8_C( -31), INT8_C( -31),
                           INT8_C( -31), INT8_C(   0), INT8_C( -31), INT8_C(   0),
                           INT8_C( -31), INT8_C( -31), INT8_C(   0), INT8_C( -31),
                           INT8_C( -31), INT8_C( -31), INT8_C(   0), INT8_C(   0),
                           INT8_C( -31), INT8_C( -31), INT8_C( -31), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -31), INT8_C( -31),
                           INT8_C( -31), INT8_C(   0), INT8_C( -31), INT8_C(   0),
                           INT8_C( -31), INT8_C( -31), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -31), INT8_C(   0), INT8_C(   0),
                           INT8_C( -31), INT8_C(   0), INT8_C( -31), INT8_C( -31),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -31), INT8_C( -31), INT8_C(   0),
                           INT8_C(   0), INT8_C( -31), INT8_C( -31), INT8_C( -31),
                           INT8_C(   0), INT8_C(   0), INT8_C( -31), INT8_C(   0),
                           INT8_C( -31), INT8_C(   0), INT8_C( -31), INT8_C( -31)) },
    { UINT64_C( 9693935732927043828),
      INT8_C(  57),
      simde_mm512_set_epi8(INT8_C(  57), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  57), INT8_C(  57), INT8_C(   0),
                           INT8_C(  57), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  57), INT8_C(  57), INT8_C(  57),
                           INT8_C(  57), INT8_C(  57), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  57), INT8_C(  57), INT8_C(  57),
                           INT8_C(   0), INT8_C(   0), INT8_C(  57), INT8_C(  57),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  57), INT8_C(  57),
                           INT8_C(  57), INT8_C(  57), INT8_C(   0), INT8_C(   0),
                           INT8_C(  57), INT8_C(   0), INT8_C(   0), INT8_C(  57),
                           INT8_C(   0), INT8_C(  57), INT8_C(   0), INT8_C(  57),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  57),
                           INT8_C(  57), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  57), INT8_C(  57), INT8_C(  57), INT8_C(  57),
                           INT8_C(   0), INT8_C(  57), INT8_C(   0), INT8_C(   0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_set1_epi8(test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_set1_epi16(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask32 k;
    int16_t a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi16(INT16_C(   874), INT16_C( 15357), INT16_C(  3602), INT16_C( 11090),
                            INT16_C( 31475), INT16_C( 20808), INT16_C(-26328), INT16_C(-21794),
                            INT16_C(-24829), INT16_C(-15530), INT16_C( -9785), INT16_C( 22806),
                            INT16_C( -6385), INT16_C(-26604), INT16_C(-15351), INT16_C(-18936),
                            INT16_C( 28985), INT16_C( 24045), INT16_C(-25535), INT16_C(-25436),
                            INT16_C(   749), INT16_C( 15517), INT16_C(-24369), INT16_C(-27864),
                            INT16_C(  6864), INT16_C( 16553), INT16_C(  -407), INT16_C(-28514),
                            INT16_C( -9423), INT16_C(-29018), INT16_C(-11420), INT16_C(-22112)),
      UINT32_C(1121120418),
      INT16_C(-24380),
      simde_mm512_set_epi16(INT16_C(   874), INT16_C(-24380), INT16_C(  3602), INT16_C( 11090),
                            INT16_C( 31475), INT16_C( 20808), INT16_C(-24380), INT16_C(-21794),
                            INT16_C(-24380), INT16_C(-24380), INT16_C( -9785), INT16_C(-24380),
                            INT16_C( -6385), INT16_C(-26604), INT16_C(-24380), INT16_C(-18936),
                            INT16_C(-24380), INT16_C(-24380), INT16_C(-24380), INT16_C(-24380),
                            INT16_C(   749), INT16_C( 15517), INT16_C(-24369), INT16_C(-27864),
                            INT16_C(-24380), INT16_C( 16553), INT16_C(-24380), INT16_C(-28514),
                            INT16_C( -9423), INT16_C(-29018), INT16_C(-24380), INT16_C(-22112)) },
    { simde_mm512_set_epi16(INT16_C( 21630), INT16_C(    53), INT16_C(-30787), INT16_C( 11298),
                            INT16_C( 13120), INT16_C(-15891), INT16_C( 20834), INT16_C(  5170),
                            INT16_C( 11237), INT16_C(-32025), INT16_C(  2036), INT16_C(-32146),
                            INT16_C(  6820), INT16_C( 29964), INT16_C(-20673), INT16_C( -6255),
                            INT16_C( 12677), INT16_C(  5934), INT16_C( 18392), INT16_C(-16008),
                            INT16_C( -6967), INT16_C(-23263), INT16_C( 28759), INT16_C(  4932),
                            INT16_C(-20928), INT16_C(-12287), INT16_C(-21100), INT16_C(-15604),
                            INT16_C(-25734), INT16_C(-27889), INT16_C( 22154), INT16_C( 16749)),
      UINT32_C( 442706120),
      INT16_C(-18045),
      simde_mm512_set_epi16(INT16_C( 21630), INT16_C(    53), INT16_C(-30787), INT16_C(-18045),
                            INT16_C(-18045), INT16_C(-15891), INT16_C(-18045), INT16_C(  5170),
                            INT16_C( 11237), INT16_C(-18045), INT16_C(-18045), INT16_C(-32146),
                            INT16_C(  6820), INT16_C( 29964), INT16_C(-18045), INT16_C(-18045),
                            INT16_C( 12677), INT16_C(  5934), INT16_C(-18045), INT16_C(-16008),
                            INT16_C(-18045), INT16_C(-23263), INT16_C( 28759), INT16_C(  4932),
                            INT16_C(-18045), INT16_C(-18045), INT16_C(-21100), INT16_C(-15604),
                            INT16_C(-18045), INT16_C(-27889), INT16_C( 22154), INT16_C( 16749)) },
    { simde_mm512_set_epi16(INT16_C(-12675), INT16_C(-13885), INT16_C( -4000), INT16_C( 31908),
                            INT16_C( 16178), INT16_C( -8662), INT16_C(-27877), INT16_C(-11427),
                            INT16_C(-10847), INT16_C(  7965), INT16_C(-13767), INT16_C( 14192),
                            INT16_C( -3024), INT16_C(-20651), INT16_C(  1677), INT16_C(-14378),
                            INT16_C( 13823), INT16_C(-21716), INT16_C(-14569), INT16_C( 19205),
                            INT16_C(-19335), INT16_C( 31769), INT16_C(-13133), INT16_C(-12032),
                            INT16_C(-27851), INT16_C(-12954), INT16_C(-30941), INT16_C( 26210),
                            INT16_C( 10250), INT16_C(-12883), INT16_C(-31618), INT16_C(  -328)),
      UINT32_C(3083705480),
      INT16_C(  4440),
      simde_mm512_set_epi16(INT16_C(  4440), INT16_C(-13885), INT16_C(  4440), INT16_C(  4440),
                            INT16_C( 16178), INT16_C(  4440), INT16_C(  4440), INT16_C(  4440),
                            INT16_C(  4440), INT16_C(  4440), INT16_C(-13767), INT16_C( 14192),
                            INT16_C(  4440), INT16_C(  4440), INT16_C(  1677), INT16_C(  4440),
                            INT16_C(  4440), INT16_C(-21716), INT16_C(-14569), INT16_C(  4440),
                            INT16_C(  4440), INT16_C(  4440), INT16_C(-13133), INT16_C(-12032),
                            INT16_C(  4440), INT16_C(-12954), INT16_C(-30941), INT16_C( 26210),
                            INT16_C(  4440), INT16_C(-12883), INT16_C(-31618), INT16_C(  -328)) },
    { simde_mm512_set_epi16(INT16_C(-23201), INT16_C(  4909), INT16_C(-10596), INT16_C( 25003),
                            INT16_C( 25193), INT16_C(-28193), INT16_C(  7484), INT16_C( 22842),
                            INT16_C( 12827), INT16_C(-21490), INT16_C(-19021), INT16_C( 17939),
                            INT16_C( 14187), INT16_C( 31294), INT16_C(-22999), INT16_C( 25206),
                            INT16_C(-22002), INT16_C( 23505), INT16_C(-20713), INT16_C( 22238),
                            INT16_C( 29284), INT16_C( 28054), INT16_C(-21727), INT16_C( 30369),
                            INT16_C( 19358), INT16_C(  -623), INT16_C(  2386), INT16_C(  9395),
                            INT16_C(-11819), INT16_C( 28599), INT16_C(-11863), INT16_C( -4500)),
      UINT32_C(1729799485),
      INT16_C(   -51),
      simde_mm512_set_epi16(INT16_C(-23201), INT16_C(   -51), INT16_C(   -51), INT16_C( 25003),
                            INT16_C( 25193), INT16_C(   -51), INT16_C(   -51), INT16_C(   -51),
                            INT16_C( 12827), INT16_C(-21490), INT16_C(-19021), INT16_C(   -51),
                            INT16_C(   -51), INT16_C( 31294), INT16_C(   -51), INT16_C( 25206),
                            INT16_C(   -51), INT16_C( 23505), INT16_C(   -51), INT16_C( 22238),
                            INT16_C( 29284), INT16_C(   -51), INT16_C(-21727), INT16_C(   -51),
                            INT16_C( 19358), INT16_C(  -623), INT16_C(   -51), INT16_C(   -51),
                            INT16_C(   -51), INT16_C(   -51), INT16_C(-11863), INT16_C(   -51)) },
    { simde_mm512_set_epi16(INT16_C(-12929), INT16_C( -9559), INT16_C( -1255), INT16_C(-25300),
                            INT16_C( 24130), INT16_C( 22555), INT16_C(-26496), INT16_C(  4179),
                            INT16_C( 25227), INT16_C( 31028), INT16_C( 12492), INT16_C(-27096),
                            INT16_C( 22382), INT16_C( -5113), INT16_C(-30455), INT16_C( 15691),
                            INT16_C(-18605), INT16_C( -4278), INT16_C( 11441), INT16_C(-26478),
                            INT16_C( 11388), INT16_C(-27754), INT16_C(   607), INT16_C( -1601),
                            INT16_C(-14454), INT16_C(  1251), INT16_C( 27178), INT16_C( 11399),
                            INT16_C(  -184), INT16_C( 17990), INT16_C(-12132), INT16_C(-20400)),
      UINT32_C(3701546889),
      INT16_C( 26765),
      simde_mm512_set_epi16(INT16_C( 26765), INT16_C( 26765), INT16_C( -1255), INT16_C( 26765),
                            INT16_C( 26765), INT16_C( 26765), INT16_C(-26496), INT16_C(  4179),
                            INT16_C( 26765), INT16_C( 31028), INT16_C( 26765), INT16_C(-27096),
                            INT16_C( 22382), INT16_C( -5113), INT16_C(-30455), INT16_C( 26765),
                            INT16_C(-18605), INT16_C( -4278), INT16_C( 11441), INT16_C( 26765),
                            INT16_C( 26765), INT16_C( 26765), INT16_C( 26765), INT16_C( 26765),
                            INT16_C( 26765), INT16_C(  1251), INT16_C( 27178), INT16_C( 11399),
                            INT16_C( 26765), INT16_C( 17990), INT16_C(-12132), INT16_C( 26765)) },
    { simde_mm512_set_epi16(INT16_C( 23556), INT16_C( 11192), INT16_C(-13439), INT16_C( -2357),
                            INT16_C(   858), INT16_C( 27575), INT16_C( 20368), INT16_C(-20256),
                            INT16_C(-11019), INT16_C( -7073), INT16_C(-32385), INT16_C( 27749),
                            INT16_C( 17332), INT16_C(-28131), INT16_C( 22510), INT16_C(  -872),
                            INT16_C( 20986), INT16_C(-25896), INT16_C(  7561), INT16_C(-22951),
                            INT16_C( -9997), INT16_C( 18542), INT16_C( -1921), INT16_C(-16319),
                            INT16_C(-24759), INT16_C( 10467), INT16_C(  8453), INT16_C(  5278),
                            INT16_C(-22217), INT16_C( 17080), INT16_C( 16797), INT16_C( -9777)),
      UINT32_C(3298748633),
      INT16_C( -5240),
      simde_mm512_set_epi16(INT16_C( -5240), INT16_C( -5240), INT16_C(-13439), INT16_C( -2357),
                            INT16_C(   858), INT16_C( -5240), INT16_C( 20368), INT16_C(-20256),
                            INT16_C( -5240), INT16_C( -7073), INT16_C(-32385), INT16_C( -5240),
                            INT16_C( -5240), INT16_C( -5240), INT16_C( -5240), INT16_C(  -872),
                            INT16_C( -5240), INT16_C( -5240), INT16_C( -5240), INT16_C(-22951),
                            INT16_C( -5240), INT16_C( 18542), INT16_C( -1921), INT16_C(-16319),
                            INT16_C( -5240), INT16_C( -5240), INT16_C(  8453), INT16_C( -5240),
                            INT16_C( -5240), INT16_C( 17080), INT16_C( 16797), INT16_C( -5240)) },
    { simde_mm512_set_epi16(INT16_C(  -894), INT16_C( 15324), INT16_C(-23364), INT16_C( 25648),
                            INT16_C(  -512), INT16_C( 12172), INT16_C(-27706), INT16_C(-10514),
                            INT16_C(  1026), INT16_C( 20384), INT16_C(-25471), INT16_C( -3464),
                            INT16_C( 14827), INT16_C( 18045), INT16_C(-25826), INT16_C( 12664),
                            INT16_C(-16682), INT16_C( 16498), INT16_C( 29333), INT16_C(  -511),
                            INT16_C( 15382), INT16_C(-19710), INT16_C(-14139), INT16_C( 14459),
                            INT16_C( 16092), INT16_C(-12889), INT16_C(  -337), INT16_C( 29893),
                            INT16_C(-29467), INT16_C( -8274), INT16_C( 30322), INT16_C(-19138)),
      UINT32_C(3605268017),
      INT16_C(-14523),
      simde_mm512_set_epi16(INT16_C(-14523), INT16_C(-14523), INT16_C(-23364), INT16_C(-14523),
                            INT16_C(  -512), INT16_C(-14523), INT16_C(-14523), INT16_C(-10514),
                            INT16_C(-14523), INT16_C(-14523), INT16_C(-14523), INT16_C( -3464),
                            INT16_C( 14827), INT16_C(-14523), INT16_C(-25826), INT16_C( 12664),
                            INT16_C(-16682), INT16_C( 16498), INT16_C( 29333), INT16_C(  -511),
                            INT16_C( 15382), INT16_C(-14523), INT16_C(-14523), INT16_C( 14459),
                            INT16_C( 16092), INT16_C(-12889), INT16_C(-14523), INT16_C(-14523),
                            INT16_C(-29467), INT16_C( -8274), INT16_C( 30322), INT16_C(-14523)) },
    { simde_mm512_set_epi16(INT16_C( -6967), INT16_C(-20070), INT16_C( -8289), INT16_C(  -479),
                            INT16_C(-18969), INT16_C( -6012), INT16_C( 11721), INT16_C( 13564),
                            INT16_C( 19765), INT16_C( 23581), INT16_C(-21527), INT16_C( -2847),
                            INT16_C( 23178), INT16_C(-14967), INT16_C( 17682), INT16_C( 28255),
                            INT16_C(  8882), INT16_C( 14691), INT16_C(-27903), INT16_C( 28973),
                            INT16_C(   619), INT16_C(-10329), INT16_C( 25572), INT16_C(-13439),
                            INT16_C( -3930), INT16_C(  5659), INT16_C(  -675), INT16_C(-18004),
                            INT16_C(-26191), INT16_C(  5303), INT16_C(-13369), INT16_C( 21695)),
      UINT32_C( 349570055),
      INT16_C( 24210),
      simde_mm512_set_epi16(INT16_C( -6967), INT16_C(-20070), INT16_C( -8289), INT16_C( 24210),
                            INT16_C(-18969), INT16_C( 24210), INT16_C( 11721), INT16_C( 13564),
                            INT16_C( 24210), INT16_C( 24210), INT16_C(-21527), INT16_C( 24210),
                            INT16_C( 23178), INT16_C( 24210), INT16_C( 24210), INT16_C( 28255),
                            INT16_C(  8882), INT16_C( 14691), INT16_C(-27903), INT16_C( 28973),
                            INT16_C(   619), INT16_C( 24210), INT16_C( 25572), INT16_C(-13439),
                            INT16_C( -3930), INT16_C(  5659), INT16_C(  -675), INT16_C(-18004),
                            INT16_C(-26191), INT16_C( 24210), INT16_C( 24210), INT16_C( 24210)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_set1_epi16(test_vec[i].src, test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i16(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_maskz_set1_epi16(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask32 k;
    int16_t a;
    simde__m512i r;
  } test_vec[8] = {
   {  UINT32_C( 693683203),
      INT16_C(-16188),
      simde_mm512_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(-16188), INT16_C(     0),
                            INT16_C(-16188), INT16_C(     0), INT16_C(     0), INT16_C(-16188),
                            INT16_C(     0), INT16_C(-16188), INT16_C(     0), INT16_C(-16188),
                            INT16_C(-16188), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(-16188), INT16_C(-16188), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(-16188), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(-16188), INT16_C(-16188)) },
   {  UINT32_C(2322862674),
      INT16_C(-31832),
      simde_mm512_set_epi16(INT16_C(-31832), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(-31832), INT16_C(     0), INT16_C(-31832), INT16_C(     0),
                            INT16_C(     0), INT16_C(-31832), INT16_C(-31832), INT16_C(-31832),
                            INT16_C(     0), INT16_C(-31832), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(-31832),
                            INT16_C(     0), INT16_C(     0), INT16_C(-31832), INT16_C(     0),
                            INT16_C(     0), INT16_C(-31832), INT16_C(     0), INT16_C(-31832),
                            INT16_C(     0), INT16_C(     0), INT16_C(-31832), INT16_C(     0)) },
   {  UINT32_C(3196780114),
      INT16_C(  8083),
      simde_mm512_set_epi16(INT16_C(  8083), INT16_C(     0), INT16_C(  8083), INT16_C(  8083),
                            INT16_C(  8083), INT16_C(  8083), INT16_C(  8083), INT16_C(     0),
                            INT16_C(  8083), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(  8083), INT16_C(     0), INT16_C(  8083), INT16_C(     0),
                            INT16_C(  8083), INT16_C(  8083), INT16_C(  8083), INT16_C(  8083),
                            INT16_C(  8083), INT16_C(  8083), INT16_C(  8083), INT16_C(     0),
                            INT16_C(     0), INT16_C(  8083), INT16_C(     0), INT16_C(  8083),
                            INT16_C(     0), INT16_C(     0), INT16_C(  8083), INT16_C(     0)) },
   {  UINT32_C( 962615778),
      INT16_C( 10134),
      simde_mm512_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C( 10134), INT16_C( 10134),
                            INT16_C( 10134), INT16_C(     0), INT16_C(     0), INT16_C( 10134),
                            INT16_C(     0), INT16_C( 10134), INT16_C( 10134), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C( 10134), INT16_C(     0), INT16_C( 10134),
                            INT16_C( 10134), INT16_C(     0), INT16_C(     0), INT16_C( 10134),
                            INT16_C( 10134), INT16_C( 10134), INT16_C( 10134), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C( 10134), INT16_C(     0)) },
   {  UINT32_C(3651012064),
      INT16_C(-28841),
      simde_mm512_set_epi16(INT16_C(-28841), INT16_C(-28841), INT16_C(     0), INT16_C(-28841),
                            INT16_C(-28841), INT16_C(     0), INT16_C(     0), INT16_C(-28841),
                            INT16_C(-28841), INT16_C(     0), INT16_C(     0), INT16_C(-28841),
                            INT16_C(-28841), INT16_C(-28841), INT16_C(-28841), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(-28841), INT16_C(     0), INT16_C(-28841),
                            INT16_C(-28841), INT16_C(-28841), INT16_C(-28841), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)) },
   {  UINT32_C(1153035128),
      INT16_C(  9546),
      simde_mm512_set_epi16(INT16_C(     0), INT16_C(  9546), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(  9546), INT16_C(     0), INT16_C(     0),
                            INT16_C(  9546), INT16_C(     0), INT16_C(  9546), INT16_C(  9546),
                            INT16_C(  9546), INT16_C(     0), INT16_C(     0), INT16_C(  9546),
                            INT16_C(  9546), INT16_C(  9546), INT16_C(  9546), INT16_C(     0),
                            INT16_C(  9546), INT16_C(     0), INT16_C(  9546), INT16_C(  9546),
                            INT16_C(     0), INT16_C(  9546), INT16_C(  9546), INT16_C(  9546),
                            INT16_C(  9546), INT16_C(     0), INT16_C(     0), INT16_C(     0)) },
   {  UINT32_C(2648275992),
      INT16_C(-29002),
      simde_mm512_set_epi16(INT16_C(-29002), INT16_C(     0), INT16_C(     0), INT16_C(-29002),
                            INT16_C(-29002), INT16_C(-29002), INT16_C(     0), INT16_C(-29002),
                            INT16_C(-29002), INT16_C(-29002), INT16_C(     0), INT16_C(-29002),
                            INT16_C(-29002), INT16_C(     0), INT16_C(     0), INT16_C(-29002),
                            INT16_C(     0), INT16_C(-29002), INT16_C(-29002), INT16_C(-29002),
                            INT16_C(-29002), INT16_C(-29002), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(-29002),
                            INT16_C(-29002), INT16_C(     0), INT16_C(     0), INT16_C(     0)) },
   {  UINT32_C(1548742660),
      INT16_C( 11362),
      simde_mm512_set_epi16(INT16_C(     0), INT16_C( 11362), INT16_C(     0), INT16_C( 11362),
                            INT16_C( 11362), INT16_C( 11362), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C( 11362), INT16_C(     0), INT16_C(     0),
                            INT16_C( 11362), INT16_C( 11362), INT16_C( 11362), INT16_C( 11362),
                            INT16_C( 11362), INT16_C( 11362), INT16_C( 11362), INT16_C( 11362),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C( 11362), INT16_C(     0), INT16_C(     0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_set1_epi16(test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i16(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_abs_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C( -97), INT8_C(  22), INT8_C(  -8), INT8_C(-101),
                           INT8_C( -18), INT8_C( 124), INT8_C( -73), INT8_C( -35),
                           INT8_C(-107), INT8_C( 125), INT8_C( -49), INT8_C( -14),
                           INT8_C( -55), INT8_C(  -2), INT8_C(   3), INT8_C( -86),
                           INT8_C( -70), INT8_C( -16), INT8_C(  -3), INT8_C( -98),
                           INT8_C( -20), INT8_C( -18), INT8_C( -58), INT8_C( -57),
                           INT8_C( 119), INT8_C(  17), INT8_C( -79), INT8_C(  80),
                           INT8_C(  82), INT8_C(   3), INT8_C( -18), INT8_C( -99),
                           INT8_C(  25), INT8_C(  25), INT8_C(  83), INT8_C(  88),
                           INT8_C( 117), INT8_C(-128), INT8_C(  16), INT8_C( -42),
                           INT8_C( 114), INT8_C(  -1), INT8_C(-110), INT8_C(  53),
                           INT8_C( 127), INT8_C( -61), INT8_C( -68), INT8_C(  74),
                           INT8_C( 103), INT8_C(  92), INT8_C(-115), INT8_C( -60),
                           INT8_C( -23), INT8_C(  82), INT8_C(-123), INT8_C(  21),
                           INT8_C( -37), INT8_C( 119), INT8_C( -39), INT8_C( -31),
                           INT8_C(  25), INT8_C( -69), INT8_C( -57), INT8_C(  30)),
      simde_mm512_set_epi8(INT8_C(  97), INT8_C(  22), INT8_C(   8), INT8_C( 101),
                           INT8_C(  18), INT8_C( 124), INT8_C(  73), INT8_C(  35),
                           INT8_C( 107), INT8_C( 125), INT8_C(  49), INT8_C(  14),
                           INT8_C(  55), INT8_C(   2), INT8_C(   3), INT8_C(  86),
                           INT8_C(  70), INT8_C(  16), INT8_C(   3), INT8_C(  98),
                           INT8_C(  20), INT8_C(  18), INT8_C(  58), INT8_C(  57),
                           INT8_C( 119), INT8_C(  17), INT8_C(  79), INT8_C(  80),
                           INT8_C(  82), INT8_C(   3), INT8_C(  18), INT8_C(  99),
                           INT8_C(  25), INT8_C(  25), INT8_C(  83), INT8_C(  88),
                           INT8_C( 117), INT8_C(-128), INT8_C(  16), INT8_C(  42),
                           INT8_C( 114), INT8_C(   1), INT8_C( 110), INT8_C(  53),
                           INT8_C( 127), INT8_C(  61), INT8_C(  68), INT8_C(  74),
                           INT8_C( 103), INT8_C(  92), INT8_C( 115), INT8_C(  60),
                           INT8_C(  23), INT8_C(  82), INT8_C( 123), INT8_C(  21),
                           INT8_C(  37), INT8_C( 119), INT8_C(  39), INT8_C(  31),
                           INT8_C(  25), INT8_C(  69), INT8_C(  57), INT8_C(  30)) },
    { simde_mm512_set_epi8(INT8_C( 122), INT8_C(  62), INT8_C( -43), INT8_C( -88),
                           INT8_C(  92), INT8_C(-116), INT8_C(  -6), INT8_C(  36),
                           INT8_C(  10), INT8_C(   2), INT8_C( -66), INT8_C( 108),
                           INT8_C( -38), INT8_C( 112), INT8_C( 123), INT8_C(  87),
                           INT8_C(  99), INT8_C( -46), INT8_C( -53), INT8_C(  41),
                           INT8_C(-105), INT8_C( -98), INT8_C(  18), INT8_C( -12),
                           INT8_C( -82), INT8_C( 126), INT8_C( -77), INT8_C( -19),
                           INT8_C(  18), INT8_C(  16), INT8_C(  35), INT8_C( -10),
                           INT8_C( -58), INT8_C(  48), INT8_C(-120), INT8_C(  38),
                           INT8_C(  62), INT8_C(  17), INT8_C(  33), INT8_C(-120),
                           INT8_C( 106), INT8_C(  25), INT8_C( -91), INT8_C(  15),
                           INT8_C( 101), INT8_C( 114), INT8_C( -46), INT8_C( -58),
                           INT8_C( 113), INT8_C(   4), INT8_C(  50), INT8_C(  42),
                           INT8_C(  -1), INT8_C( -29), INT8_C( -27), INT8_C( -23),
                           INT8_C( -69), INT8_C(  92), INT8_C( -67), INT8_C(  89),
                           INT8_C( -10), INT8_C( -42), INT8_C(  79), INT8_C( 112)),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C(  62), INT8_C(  43), INT8_C(  88),
                           INT8_C(  92), INT8_C( 116), INT8_C(   6), INT8_C(  36),
                           INT8_C(  10), INT8_C(   2), INT8_C(  66), INT8_C( 108),
                           INT8_C(  38), INT8_C( 112), INT8_C( 123), INT8_C(  87),
                           INT8_C(  99), INT8_C(  46), INT8_C(  53), INT8_C(  41),
                           INT8_C( 105), INT8_C(  98), INT8_C(  18), INT8_C(  12),
                           INT8_C(  82), INT8_C( 126), INT8_C(  77), INT8_C(  19),
                           INT8_C(  18), INT8_C(  16), INT8_C(  35), INT8_C(  10),
                           INT8_C(  58), INT8_C(  48), INT8_C( 120), INT8_C(  38),
                           INT8_C(  62), INT8_C(  17), INT8_C(  33), INT8_C( 120),
                           INT8_C( 106), INT8_C(  25), INT8_C(  91), INT8_C(  15),
                           INT8_C( 101), INT8_C( 114), INT8_C(  46), INT8_C(  58),
                           INT8_C( 113), INT8_C(   4), INT8_C(  50), INT8_C(  42),
                           INT8_C(   1), INT8_C(  29), INT8_C(  27), INT8_C(  23),
                           INT8_C(  69), INT8_C(  92), INT8_C(  67), INT8_C(  89),
                           INT8_C(  10), INT8_C(  42), INT8_C(  79), INT8_C( 112)) },
    { simde_mm512_set_epi8(INT8_C(-115), INT8_C( 121), INT8_C( -28), INT8_C( -32),
                           INT8_C(  39), INT8_C(  97), INT8_C( 104), INT8_C( -44),
                           INT8_C( 120), INT8_C( -11), INT8_C( -74), INT8_C( -63),
                           INT8_C( -24), INT8_C( -35), INT8_C(-108), INT8_C(  -9),
                           INT8_C(  30), INT8_C( -94), INT8_C(  96), INT8_C(-119),
                           INT8_C( -14), INT8_C( -94), INT8_C(  34), INT8_C(-111),
                           INT8_C(  86), INT8_C(  -6), INT8_C(-116), INT8_C(  56),
                           INT8_C(  -2), INT8_C(  -8), INT8_C( -66), INT8_C(  73),
                           INT8_C(-111), INT8_C(  20), INT8_C( 114), INT8_C(  16),
                           INT8_C(  71), INT8_C(  17), INT8_C( -13), INT8_C(-101),
                           INT8_C(  32), INT8_C(  52), INT8_C(  -6), INT8_C( -16),
                           INT8_C(  78), INT8_C(  58), INT8_C(  14), INT8_C( -85),
                           INT8_C( -58), INT8_C( 120), INT8_C( 102), INT8_C(-125),
                           INT8_C(  73), INT8_C(-121), INT8_C(-118), INT8_C( -77),
                           INT8_C(  84), INT8_C(  62), INT8_C( 100), INT8_C(-122),
                           INT8_C( -17), INT8_C(  81), INT8_C( 105), INT8_C( -71)),
      simde_mm512_set_epi8(INT8_C( 115), INT8_C( 121), INT8_C(  28), INT8_C(  32),
                           INT8_C(  39), INT8_C(  97), INT8_C( 104), INT8_C(  44),
                           INT8_C( 120), INT8_C(  11), INT8_C(  74), INT8_C(  63),
                           INT8_C(  24), INT8_C(  35), INT8_C( 108), INT8_C(   9),
                           INT8_C(  30), INT8_C(  94), INT8_C(  96), INT8_C( 119),
                           INT8_C(  14), INT8_C(  94), INT8_C(  34), INT8_C( 111),
                           INT8_C(  86), INT8_C(   6), INT8_C( 116), INT8_C(  56),
                           INT8_C(   2), INT8_C(   8), INT8_C(  66), INT8_C(  73),
                           INT8_C( 111), INT8_C(  20), INT8_C( 114), INT8_C(  16),
                           INT8_C(  71), INT8_C(  17), INT8_C(  13), INT8_C( 101),
                           INT8_C(  32), INT8_C(  52), INT8_C(   6), INT8_C(  16),
                           INT8_C(  78), INT8_C(  58), INT8_C(  14), INT8_C(  85),
                           INT8_C(  58), INT8_C( 120), INT8_C( 102), INT8_C( 125),
                           INT8_C(  73), INT8_C( 121), INT8_C( 118), INT8_C(  77),
                           INT8_C(  84), INT8_C(  62), INT8_C( 100), INT8_C( 122),
                           INT8_C(  17), INT8_C(  81), INT8_C( 105), INT8_C(  71)) },
    { simde_mm512_set_epi8(INT8_C( 104), INT8_C(  89), INT8_C(  23), INT8_C( -69),
                           INT8_C( -81), INT8_C( -18), INT8_C(-115), INT8_C(  45),
                           INT8_C( 111), INT8_C(  97), INT8_C( -96), INT8_C( -52),
                           INT8_C( 117), INT8_C( -89), INT8_C(  83), INT8_C(  55),
                           INT8_C( -79), INT8_C( -41), INT8_C(  65), INT8_C( -18),
                           INT8_C( -14), INT8_C( -36), INT8_C(  -5), INT8_C(-118),
                           INT8_C( 102), INT8_C(  66), INT8_C(   6), INT8_C(  63),
                           INT8_C(   2), INT8_C(  71), INT8_C( -79), INT8_C( 103),
                           INT8_C(  99), INT8_C(  75), INT8_C(  18), INT8_C(-125),
                           INT8_C(  89), INT8_C(  97), INT8_C( -12), INT8_C( -68),
                           INT8_C( -29), INT8_C(  64), INT8_C(  90), INT8_C( 106),
                           INT8_C( -66), INT8_C(  46), INT8_C( -67), INT8_C(-122),
                           INT8_C(  35), INT8_C(  89), INT8_C(-123), INT8_C(  49),
                           INT8_C(  79), INT8_C(-111), INT8_C( 102), INT8_C(  13),
                           INT8_C(  18), INT8_C(   7), INT8_C(  11), INT8_C( -54),
                           INT8_C(  79), INT8_C( -18), INT8_C(  80), INT8_C(  58)),
      simde_mm512_set_epi8(INT8_C( 104), INT8_C(  89), INT8_C(  23), INT8_C(  69),
                           INT8_C(  81), INT8_C(  18), INT8_C( 115), INT8_C(  45),
                           INT8_C( 111), INT8_C(  97), INT8_C(  96), INT8_C(  52),
                           INT8_C( 117), INT8_C(  89), INT8_C(  83), INT8_C(  55),
                           INT8_C(  79), INT8_C(  41), INT8_C(  65), INT8_C(  18),
                           INT8_C(  14), INT8_C(  36), INT8_C(   5), INT8_C( 118),
                           INT8_C( 102), INT8_C(  66), INT8_C(   6), INT8_C(  63),
                           INT8_C(   2), INT8_C(  71), INT8_C(  79), INT8_C( 103),
                           INT8_C(  99), INT8_C(  75), INT8_C(  18), INT8_C( 125),
                           INT8_C(  89), INT8_C(  97), INT8_C(  12), INT8_C(  68),
                           INT8_C(  29), INT8_C(  64), INT8_C(  90), INT8_C( 106),
                           INT8_C(  66), INT8_C(  46), INT8_C(  67), INT8_C( 122),
                           INT8_C(  35), INT8_C(  89), INT8_C( 123), INT8_C(  49),
                           INT8_C(  79), INT8_C( 111), INT8_C( 102), INT8_C(  13),
                           INT8_C(  18), INT8_C(   7), INT8_C(  11), INT8_C(  54),
                           INT8_C(  79), INT8_C(  18), INT8_C(  80), INT8_C(  58)) },
    { simde_mm512_set_epi8(INT8_C( -69), INT8_C( -18), INT8_C( -24), INT8_C(  31),
                           INT8_C(-118), INT8_C(  28), INT8_C( 111), INT8_C(   9),
                           INT8_C( -62), INT8_C(   2), INT8_C(  24), INT8_C(  57),
                           INT8_C(  60), INT8_C(  85), INT8_C(-124), INT8_C(   4),
                           INT8_C( -47), INT8_C(  -2), INT8_C( -42), INT8_C(   4),
                           INT8_C(-111), INT8_C(   1), INT8_C(  -7), INT8_C(  49),
                           INT8_C(  87), INT8_C(-117), INT8_C(  70), INT8_C( -68),
                           INT8_C(  92), INT8_C(  73), INT8_C( 108), INT8_C(   6),
                           INT8_C( 108), INT8_C( -36), INT8_C(  61), INT8_C(  29),
                           INT8_C(  87), INT8_C(  64), INT8_C(-117), INT8_C(  17),
                           INT8_C( -12), INT8_C(  46), INT8_C( -75), INT8_C(  42),
                           INT8_C(  80), INT8_C( -38), INT8_C(  85), INT8_C(-124),
                           INT8_C(-126), INT8_C( -12), INT8_C(  41), INT8_C(  12),
                           INT8_C( -57), INT8_C( -47), INT8_C(  80), INT8_C( -60),
                           INT8_C(  24), INT8_C(  89), INT8_C( -45), INT8_C(-122),
                           INT8_C( -52), INT8_C(  21), INT8_C(  54), INT8_C( 124)),
      simde_mm512_set_epi8(INT8_C(  69), INT8_C(  18), INT8_C(  24), INT8_C(  31),
                           INT8_C( 118), INT8_C(  28), INT8_C( 111), INT8_C(   9),
                           INT8_C(  62), INT8_C(   2), INT8_C(  24), INT8_C(  57),
                           INT8_C(  60), INT8_C(  85), INT8_C( 124), INT8_C(   4),
                           INT8_C(  47), INT8_C(   2), INT8_C(  42), INT8_C(   4),
                           INT8_C( 111), INT8_C(   1), INT8_C(   7), INT8_C(  49),
                           INT8_C(  87), INT8_C( 117), INT8_C(  70), INT8_C(  68),
                           INT8_C(  92), INT8_C(  73), INT8_C( 108), INT8_C(   6),
                           INT8_C( 108), INT8_C(  36), INT8_C(  61), INT8_C(  29),
                           INT8_C(  87), INT8_C(  64), INT8_C( 117), INT8_C(  17),
                           INT8_C(  12), INT8_C(  46), INT8_C(  75), INT8_C(  42),
                           INT8_C(  80), INT8_C(  38), INT8_C(  85), INT8_C( 124),
                           INT8_C( 126), INT8_C(  12), INT8_C(  41), INT8_C(  12),
                           INT8_C(  57), INT8_C(  47), INT8_C(  80), INT8_C(  60),
                           INT8_C(  24), INT8_C(  89), INT8_C(  45), INT8_C( 122),
                           INT8_C(  52), INT8_C(  21), INT8_C(  54), INT8_C( 124)) },
    { simde_mm512_set_epi8(INT8_C(  23), INT8_C( -45), INT8_C( -87), INT8_C(-128),
                           INT8_C(  79), INT8_C(  64), INT8_C( -72), INT8_C( 109),
                           INT8_C(  -1), INT8_C( 120), INT8_C( -18), INT8_C(-122),
                           INT8_C( -56), INT8_C(   0), INT8_C( 100), INT8_C(  60),
                           INT8_C( -78), INT8_C( -63), INT8_C(  26), INT8_C(  35),
                           INT8_C( -65), INT8_C(  72), INT8_C(  38), INT8_C( -77),
                           INT8_C(-123), INT8_C( 106), INT8_C(   7), INT8_C(  83),
                           INT8_C(  87), INT8_C( 105), INT8_C( -86), INT8_C(  65),
                           INT8_C( -41), INT8_C( 111), INT8_C( -74), INT8_C( -72),
                           INT8_C(  30), INT8_C( -92), INT8_C(  62), INT8_C( -69),
                           INT8_C( -56), INT8_C( 120), INT8_C(  86), INT8_C(  20),
                           INT8_C( -82), INT8_C(  72), INT8_C(  45), INT8_C(  66),
                           INT8_C( -71), INT8_C(-128), INT8_C( -35), INT8_C(  10),
                           INT8_C( -92), INT8_C( -41), INT8_C( 102), INT8_C( -89),
                           INT8_C(  47), INT8_C(  44), INT8_C(  12), INT8_C(  18),
                           INT8_C( -29), INT8_C( 113), INT8_C( -21), INT8_C( 122)),
      simde_mm512_set_epi8(INT8_C(  23), INT8_C(  45), INT8_C(  87), INT8_C(-128),
                           INT8_C(  79), INT8_C(  64), INT8_C(  72), INT8_C( 109),
                           INT8_C(   1), INT8_C( 120), INT8_C(  18), INT8_C( 122),
                           INT8_C(  56), INT8_C(   0), INT8_C( 100), INT8_C(  60),
                           INT8_C(  78), INT8_C(  63), INT8_C(  26), INT8_C(  35),
                           INT8_C(  65), INT8_C(  72), INT8_C(  38), INT8_C(  77),
                           INT8_C( 123), INT8_C( 106), INT8_C(   7), INT8_C(  83),
                           INT8_C(  87), INT8_C( 105), INT8_C(  86), INT8_C(  65),
                           INT8_C(  41), INT8_C( 111), INT8_C(  74), INT8_C(  72),
                           INT8_C(  30), INT8_C(  92), INT8_C(  62), INT8_C(  69),
                           INT8_C(  56), INT8_C( 120), INT8_C(  86), INT8_C(  20),
                           INT8_C(  82), INT8_C(  72), INT8_C(  45), INT8_C(  66),
                           INT8_C(  71), INT8_C(-128), INT8_C(  35), INT8_C(  10),
                           INT8_C(  92), INT8_C(  41), INT8_C( 102), INT8_C(  89),
                           INT8_C(  47), INT8_C(  44), INT8_C(  12), INT8_C(  18),
                           INT8_C(  29), INT8_C( 113), INT8_C(  21), INT8_C( 122)) },
    { simde_mm512_set_epi8(INT8_C(   6), INT8_C( -58), INT8_C( -97), INT8_C(  99),
                           INT8_C(  24), INT8_C( 108), INT8_C( -42), INT8_C( 116),
                           INT8_C( -51), INT8_C(  37), INT8_C(  17), INT8_C(  87),
                           INT8_C( 119), INT8_C(  22), INT8_C(  38), INT8_C( -86),
                           INT8_C(  70), INT8_C( -19), INT8_C( 116), INT8_C(   4),
                           INT8_C( -77), INT8_C( -68), INT8_C(  19), INT8_C( -39),
                           INT8_C(  -4), INT8_C(-120), INT8_C(  84), INT8_C( -27),
                           INT8_C( -68), INT8_C( 120), INT8_C(-117), INT8_C( -33),
                           INT8_C(   3), INT8_C( 109), INT8_C(  85), INT8_C( -14),
                           INT8_C( 121), INT8_C(  30), INT8_C( 108), INT8_C(  -1),
                           INT8_C( 114), INT8_C( -61), INT8_C(  46), INT8_C(  93),
                           INT8_C(  48), INT8_C( -57), INT8_C( -97), INT8_C(-100),
                           INT8_C(  84), INT8_C(   0), INT8_C( -87), INT8_C( -47),
                           INT8_C(  85), INT8_C(   2), INT8_C( 125), INT8_C(  35),
                           INT8_C( -12), INT8_C(  -7), INT8_C(   3), INT8_C(   4),
                           INT8_C(  86), INT8_C( 111), INT8_C( -66), INT8_C(  29)),
      simde_mm512_set_epi8(INT8_C(   6), INT8_C(  58), INT8_C(  97), INT8_C(  99),
                           INT8_C(  24), INT8_C( 108), INT8_C(  42), INT8_C( 116),
                           INT8_C(  51), INT8_C(  37), INT8_C(  17), INT8_C(  87),
                           INT8_C( 119), INT8_C(  22), INT8_C(  38), INT8_C(  86),
                           INT8_C(  70), INT8_C(  19), INT8_C( 116), INT8_C(   4),
                           INT8_C(  77), INT8_C(  68), INT8_C(  19), INT8_C(  39),
                           INT8_C(   4), INT8_C( 120), INT8_C(  84), INT8_C(  27),
                           INT8_C(  68), INT8_C( 120), INT8_C( 117), INT8_C(  33),
                           INT8_C(   3), INT8_C( 109), INT8_C(  85), INT8_C(  14),
                           INT8_C( 121), INT8_C(  30), INT8_C( 108), INT8_C(   1),
                           INT8_C( 114), INT8_C(  61), INT8_C(  46), INT8_C(  93),
                           INT8_C(  48), INT8_C(  57), INT8_C(  97), INT8_C( 100),
                           INT8_C(  84), INT8_C(   0), INT8_C(  87), INT8_C(  47),
                           INT8_C(  85), INT8_C(   2), INT8_C( 125), INT8_C(  35),
                           INT8_C(  12), INT8_C(   7), INT8_C(   3), INT8_C(   4),
                           INT8_C(  86), INT8_C( 111), INT8_C(  66), INT8_C(  29)) },
    { simde_mm512_set_epi8(INT8_C(  48), INT8_C(  61), INT8_C( 127), INT8_C(  76),
                           INT8_C( -86), INT8_C( 122), INT8_C( -96), INT8_C(-118),
                           INT8_C( -38), INT8_C(  -8), INT8_C(  56), INT8_C(-108),
                           INT8_C(   1), INT8_C(   8), INT8_C(  22), INT8_C(-116),
                           INT8_C( -52), INT8_C(  92), INT8_C(  68), INT8_C( 112),
                           INT8_C( -94), INT8_C( -84), INT8_C(  98), INT8_C( -49),
                           INT8_C( -43), INT8_C( 105), INT8_C(  71), INT8_C(  34),
                           INT8_C(-126), INT8_C(  -5), INT8_C(   5), INT8_C( -61),
                           INT8_C(-125), INT8_C( -31), INT8_C(-128), INT8_C( -41),
                           INT8_C(  82), INT8_C(  17), INT8_C( -47), INT8_C(-121),
                           INT8_C(   0), INT8_C( 118), INT8_C( -18), INT8_C( -96),
                           INT8_C(  45), INT8_C(  28), INT8_C( 105), INT8_C(-104),
                           INT8_C( -15), INT8_C(  24), INT8_C(  94), INT8_C( 103),
                           INT8_C( -54), INT8_C(-112), INT8_C(  15), INT8_C( 123),
                           INT8_C( -27), INT8_C( 121), INT8_C(-118), INT8_C(-112),
                           INT8_C( -70), INT8_C(  97), INT8_C(  58), INT8_C( -42)),
      simde_mm512_set_epi8(INT8_C(  48), INT8_C(  61), INT8_C( 127), INT8_C(  76),
                           INT8_C(  86), INT8_C( 122), INT8_C(  96), INT8_C( 118),
                           INT8_C(  38), INT8_C(   8), INT8_C(  56), INT8_C( 108),
                           INT8_C(   1), INT8_C(   8), INT8_C(  22), INT8_C( 116),
                           INT8_C(  52), INT8_C(  92), INT8_C(  68), INT8_C( 112),
                           INT8_C(  94), INT8_C(  84), INT8_C(  98), INT8_C(  49),
                           INT8_C(  43), INT8_C( 105), INT8_C(  71), INT8_C(  34),
                           INT8_C( 126), INT8_C(   5), INT8_C(   5), INT8_C(  61),
                           INT8_C( 125), INT8_C(  31), INT8_C(-128), INT8_C(  41),
                           INT8_C(  82), INT8_C(  17), INT8_C(  47), INT8_C( 121),
                           INT8_C(   0), INT8_C( 118), INT8_C(  18), INT8_C(  96),
                           INT8_C(  45), INT8_C(  28), INT8_C( 105), INT8_C( 104),
                           INT8_C(  15), INT8_C(  24), INT8_C(  94), INT8_C( 103),
                           INT8_C(  54), INT8_C( 112), INT8_C(  15), INT8_C( 123),
                           INT8_C(  27), INT8_C( 121), INT8_C( 118), INT8_C( 112),
                           INT8_C(  70), INT8_C(  97), INT8_C(  58), INT8_C(  42)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_abs_epi8(test_vec[i].a);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_abs_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C( 117), INT8_C(-104), INT8_C( -35), INT8_C( -40),
                           INT8_C(  -1), INT8_C(  43), INT8_C(  10), INT8_C( -45),
                           INT8_C( -42), INT8_C(  80), INT8_C( -69), INT8_C( -15),
                           INT8_C( -14), INT8_C(-122), INT8_C(  60), INT8_C(  93),
                           INT8_C(  23), INT8_C( 122), INT8_C(  10), INT8_C( 108),
                           INT8_C( -24), INT8_C( -65), INT8_C( -39), INT8_C( -98),
                           INT8_C( -57), INT8_C(  -6), INT8_C(  81), INT8_C( -45),
                           INT8_C( -27), INT8_C(  28), INT8_C( -85), INT8_C(  15),
                           INT8_C(-118), INT8_C(  52), INT8_C(  10), INT8_C(-116),
                           INT8_C(  26), INT8_C( -43), INT8_C( -38), INT8_C( -27),
                           INT8_C(  66), INT8_C( -52), INT8_C(   5), INT8_C(  -1),
                           INT8_C( -28), INT8_C(   3), INT8_C( 123), INT8_C(-116),
                           INT8_C( -34), INT8_C( -32), INT8_C(  98), INT8_C( 103),
                           INT8_C( -19), INT8_C(-118), INT8_C( -77), INT8_C( -32),
                           INT8_C(  60), INT8_C( -80), INT8_C(  22), INT8_C( -26),
                           INT8_C(  60), INT8_C( -12), INT8_C( -65), INT8_C(  88)),
      UINT64_C(          2117573942),
      simde_mm512_set_epi8(INT8_C(  32), INT8_C(  22), INT8_C(  88), INT8_C( -34),
                           INT8_C(  12), INT8_C(  90), INT8_C(-101), INT8_C(  -4),
                           INT8_C( -14), INT8_C(  42), INT8_C( -87), INT8_C( 105),
                           INT8_C(  22), INT8_C(  34), INT8_C( 113), INT8_C( -72),
                           INT8_C( -40), INT8_C( -70), INT8_C( -24), INT8_C( -97),
                           INT8_C( -68), INT8_C(  -6), INT8_C(  98), INT8_C(-124),
                           INT8_C( -35), INT8_C(  11), INT8_C(-118), INT8_C( -49),
                           INT8_C( -42), INT8_C(  24), INT8_C( -34), INT8_C(  73),
                           INT8_C(  -3), INT8_C( -72), INT8_C(-103), INT8_C(  26),
                           INT8_C( -36), INT8_C(-109), INT8_C(  37), INT8_C(  50),
                           INT8_C(  26), INT8_C(  78), INT8_C(  33), INT8_C(  67),
                           INT8_C(  -8), INT8_C( -66), INT8_C(  29), INT8_C(  31),
                           INT8_C(  34), INT8_C(  40), INT8_C( -67), INT8_C(  86),
                           INT8_C(  38), INT8_C(-128), INT8_C(-106), INT8_C( -15),
                           INT8_C( 100), INT8_C(  53), INT8_C(  42), INT8_C(  55),
                           INT8_C(  87), INT8_C( -15), INT8_C(  -5), INT8_C( -85)),
      simde_mm512_set_epi8(INT8_C( 117), INT8_C(-104), INT8_C( -35), INT8_C( -40),
                           INT8_C(  -1), INT8_C(  43), INT8_C(  10), INT8_C( -45),
                           INT8_C( -42), INT8_C(  80), INT8_C( -69), INT8_C( -15),
                           INT8_C( -14), INT8_C(-122), INT8_C(  60), INT8_C(  93),
                           INT8_C(  23), INT8_C( 122), INT8_C(  10), INT8_C( 108),
                           INT8_C( -24), INT8_C( -65), INT8_C( -39), INT8_C( -98),
                           INT8_C( -57), INT8_C(  -6), INT8_C(  81), INT8_C( -45),
                           INT8_C( -27), INT8_C(  28), INT8_C( -85), INT8_C(  15),
                           INT8_C(-118), INT8_C(  72), INT8_C( 103), INT8_C(  26),
                           INT8_C(  36), INT8_C( 109), INT8_C(  37), INT8_C( -27),
                           INT8_C(  66), INT8_C( -52), INT8_C(  33), INT8_C(  67),
                           INT8_C( -28), INT8_C(  66), INT8_C(  29), INT8_C(  31),
                           INT8_C(  34), INT8_C( -32), INT8_C(  98), INT8_C(  86),
                           INT8_C(  38), INT8_C(-128), INT8_C( -77), INT8_C(  15),
                           INT8_C(  60), INT8_C( -80), INT8_C(  42), INT8_C(  55),
                           INT8_C(  60), INT8_C(  15), INT8_C(   5), INT8_C(  88)) },
    { simde_mm512_set_epi8(INT8_C( -27), INT8_C(-108), INT8_C(-117), INT8_C( -88),
                           INT8_C(-107), INT8_C(  53), INT8_C( -16), INT8_C(  -1),
                           INT8_C( -92), INT8_C(-119), INT8_C(  17), INT8_C(-122),
                           INT8_C(  22), INT8_C( -13), INT8_C(   7), INT8_C(-126),
                           INT8_C( -24), INT8_C( -51), INT8_C( -29), INT8_C(-114),
                           INT8_C( 100), INT8_C( -53), INT8_C(   0), INT8_C(-112),
                           INT8_C( -80), INT8_C(  89), INT8_C(  91), INT8_C(   1),
                           INT8_C( 102), INT8_C(  -2), INT8_C( -67), INT8_C( -88),
                           INT8_C(  -5), INT8_C( -85), INT8_C(  24), INT8_C(  13),
                           INT8_C(  67), INT8_C(  49), INT8_C(  20), INT8_C( -71),
                           INT8_C( -24), INT8_C(  19), INT8_C( -18), INT8_C(  58),
                           INT8_C( 109), INT8_C(-116), INT8_C(  95), INT8_C(  71),
                           INT8_C(  47), INT8_C( 118), INT8_C( -15), INT8_C( -31),
                           INT8_C( -70), INT8_C( -81), INT8_C(  45), INT8_C(  88),
                           INT8_C( -92), INT8_C(  95), INT8_C(  -3), INT8_C( -29),
                           INT8_C(  20), INT8_C( -86), INT8_C(  -5), INT8_C(  57)),
      UINT64_C(          3796566764),
      simde_mm512_set_epi8(INT8_C( -74), INT8_C(   1), INT8_C( -40), INT8_C(  93),
                           INT8_C(  28), INT8_C(  66), INT8_C(  14), INT8_C( 119),
                           INT8_C(  -8), INT8_C(-103), INT8_C( 124), INT8_C( -64),
                           INT8_C(  -5), INT8_C(  73), INT8_C(  83), INT8_C(-107),
                           INT8_C( -64), INT8_C( -31), INT8_C(  11), INT8_C(  45),
                           INT8_C( -14), INT8_C(-110), INT8_C( 100), INT8_C(  -6),
                           INT8_C( -50), INT8_C(-123), INT8_C( -94), INT8_C(  12),
                           INT8_C( -29), INT8_C(-100), INT8_C(  97), INT8_C(-115),
                           INT8_C( 103), INT8_C( -79), INT8_C( 102), INT8_C(  -6),
                           INT8_C( -20), INT8_C(-105), INT8_C(  -6), INT8_C(  69),
                           INT8_C(  19), INT8_C( 102), INT8_C(-126), INT8_C( -17),
                           INT8_C(  26), INT8_C(-105), INT8_C(  91), INT8_C( -38),
                           INT8_C( 106), INT8_C(   8), INT8_C(  85), INT8_C( -66),
                           INT8_C(  40), INT8_C( -49), INT8_C(  10), INT8_C(  15),
                           INT8_C(  30), INT8_C(  97), INT8_C( -48), INT8_C(  26),
                           INT8_C(  77), INT8_C( 104), INT8_C(-118), INT8_C(  49)),
      simde_mm512_set_epi8(INT8_C( -27), INT8_C(-108), INT8_C(-117), INT8_C( -88),
                           INT8_C(-107), INT8_C(  53), INT8_C( -16), INT8_C(  -1),
                           INT8_C( -92), INT8_C(-119), INT8_C(  17), INT8_C(-122),
                           INT8_C(  22), INT8_C( -13), INT8_C(   7), INT8_C(-126),
                           INT8_C( -24), INT8_C( -51), INT8_C( -29), INT8_C(-114),
                           INT8_C( 100), INT8_C( -53), INT8_C(   0), INT8_C(-112),
                           INT8_C( -80), INT8_C(  89), INT8_C(  91), INT8_C(   1),
                           INT8_C( 102), INT8_C(  -2), INT8_C( -67), INT8_C( -88),
                           INT8_C( 103), INT8_C(  79), INT8_C( 102), INT8_C(  13),
                           INT8_C(  67), INT8_C(  49), INT8_C(   6), INT8_C( -71),
                           INT8_C( -24), INT8_C( 102), INT8_C( -18), INT8_C(  58),
                           INT8_C(  26), INT8_C(-116), INT8_C(  91), INT8_C(  38),
                           INT8_C(  47), INT8_C( 118), INT8_C( -15), INT8_C( -31),
                           INT8_C( -70), INT8_C( -81), INT8_C(  10), INT8_C(  88),
                           INT8_C(  30), INT8_C(  97), INT8_C(  48), INT8_C( -29),
                           INT8_C(  77), INT8_C( 104), INT8_C(  -5), INT8_C(  57)) },
    { simde_mm512_set_epi8(INT8_C(  64), INT8_C(  45), INT8_C( -70), INT8_C(  94),
                           INT8_C( 127), INT8_C( -70), INT8_C( 127), INT8_C( -78),
                           INT8_C( -58), INT8_C(  92), INT8_C( -25), INT8_C(  -8),
                           INT8_C(  21), INT8_C(  89), INT8_C(   8), INT8_C(   1),
                           INT8_C(  85), INT8_C(   5), INT8_C( 111), INT8_C( 109),
                           INT8_C(   6), INT8_C( -27), INT8_C(  18), INT8_C(  62),
                           INT8_C(  -7), INT8_C( 126), INT8_C( -22), INT8_C( -36),
                           INT8_C( -10), INT8_C(  -1), INT8_C(   1), INT8_C( 115),
                           INT8_C(  87), INT8_C(  93), INT8_C( -71), INT8_C(-100),
                           INT8_C( -92), INT8_C( 103), INT8_C( -19), INT8_C(  -4),
                           INT8_C( 126), INT8_C( 112), INT8_C( -72), INT8_C(  45),
                           INT8_C(  61), INT8_C( -10), INT8_C(  68), INT8_C( -93),
                           INT8_C(   5), INT8_C( 127), INT8_C( 109), INT8_C( -62),
                           INT8_C( -89), INT8_C(-117), INT8_C(-126), INT8_C(  52),
                           INT8_C(  -8), INT8_C( -92), INT8_C( -23), INT8_C( -48),
                           INT8_C( 104), INT8_C(-120), INT8_C(  -2), INT8_C(-108)),
      UINT64_C(          2131497860),
      simde_mm512_set_epi8(INT8_C(  85), INT8_C( 118), INT8_C( 120), INT8_C( -48),
                           INT8_C( 112), INT8_C(  80), INT8_C( -83), INT8_C(  55),
                           INT8_C(  10), INT8_C(-104), INT8_C(  -7), INT8_C(-106),
                           INT8_C(  -6), INT8_C(   9), INT8_C( -88), INT8_C(  52),
                           INT8_C(  69), INT8_C(  91), INT8_C(-122), INT8_C(  83),
                           INT8_C(  54), INT8_C( -42), INT8_C(   9), INT8_C( 100),
                           INT8_C(  84), INT8_C(  66), INT8_C(  99), INT8_C( -57),
                           INT8_C(  20), INT8_C( -56), INT8_C( -41), INT8_C(  34),
                           INT8_C(  96), INT8_C( 125), INT8_C(  40), INT8_C( -10),
                           INT8_C(  37), INT8_C( -54), INT8_C( -41), INT8_C( 111),
                           INT8_C( -17), INT8_C(  73), INT8_C(  10), INT8_C(  78),
                           INT8_C( -64), INT8_C(  57), INT8_C(  95), INT8_C(  52),
                           INT8_C(-123), INT8_C( 102), INT8_C( -91), INT8_C( -25),
                           INT8_C( -74), INT8_C(  23), INT8_C(-127), INT8_C( -43),
                           INT8_C( 123), INT8_C( -21), INT8_C( -69), INT8_C(  72),
                           INT8_C( -86), INT8_C(  39), INT8_C( -52), INT8_C(  88)),
      simde_mm512_set_epi8(INT8_C(  64), INT8_C(  45), INT8_C( -70), INT8_C(  94),
                           INT8_C( 127), INT8_C( -70), INT8_C( 127), INT8_C( -78),
                           INT8_C( -58), INT8_C(  92), INT8_C( -25), INT8_C(  -8),
                           INT8_C(  21), INT8_C(  89), INT8_C(   8), INT8_C(   1),
                           INT8_C(  85), INT8_C(   5), INT8_C( 111), INT8_C( 109),
                           INT8_C(   6), INT8_C( -27), INT8_C(  18), INT8_C(  62),
                           INT8_C(  -7), INT8_C( 126), INT8_C( -22), INT8_C( -36),
                           INT8_C( -10), INT8_C(  -1), INT8_C(   1), INT8_C( 115),
                           INT8_C(  87), INT8_C( 125), INT8_C(  40), INT8_C(  10),
                           INT8_C(  37), INT8_C(  54), INT8_C(  41), INT8_C( 111),
                           INT8_C( 126), INT8_C( 112), INT8_C( -72), INT8_C(  45),
                           INT8_C(  64), INT8_C(  57), INT8_C(  68), INT8_C( -93),
                           INT8_C(   5), INT8_C( 127), INT8_C( 109), INT8_C(  25),
                           INT8_C( -89), INT8_C(-117), INT8_C( 127), INT8_C(  43),
                           INT8_C( 123), INT8_C( -92), INT8_C( -23), INT8_C( -48),
                           INT8_C( 104), INT8_C(  39), INT8_C(  -2), INT8_C(-108)) },
    { simde_mm512_set_epi8(INT8_C( -39), INT8_C(-117), INT8_C( -99), INT8_C( -55),
                           INT8_C(   3), INT8_C( -15), INT8_C( 113), INT8_C(  -3),
                           INT8_C( -35), INT8_C( 100), INT8_C( -74), INT8_C(-107),
                           INT8_C(  44), INT8_C( -58), INT8_C(  20), INT8_C(  23),
                           INT8_C( 105), INT8_C( -68), INT8_C( 118), INT8_C( -13),
                           INT8_C( -81), INT8_C(  41), INT8_C( -73), INT8_C(-115),
                           INT8_C(-111), INT8_C(  21), INT8_C(  99), INT8_C( 117),
                           INT8_C( -14), INT8_C(-112), INT8_C(  71), INT8_C(  21),
                           INT8_C(-114), INT8_C( -75), INT8_C(  66), INT8_C(-119),
                           INT8_C( -62), INT8_C( -30), INT8_C(  86), INT8_C(-128),
                           INT8_C( 109), INT8_C(  15), INT8_C( -69), INT8_C(  22),
                           INT8_C( -13), INT8_C(  38), INT8_C( -93), INT8_C( -41),
                           INT8_C(  96), INT8_C(  79), INT8_C( -24), INT8_C( -40),
                           INT8_C(  90), INT8_C(  31), INT8_C( -35), INT8_C(  22),
                           INT8_C(-112), INT8_C( -37), INT8_C(  29), INT8_C(  29),
                           INT8_C(   7), INT8_C(   8), INT8_C( 106), INT8_C( -46)),
      UINT64_C(           127712386),
      simde_mm512_set_epi8(INT8_C(  68), INT8_C( 120), INT8_C( -69), INT8_C( -50),
                           INT8_C( 102), INT8_C(-123), INT8_C(  95), INT8_C( 110),
                           INT8_C(  90), INT8_C( -66), INT8_C( -52), INT8_C(  44),
                           INT8_C(-111), INT8_C(  10), INT8_C(-111), INT8_C(  20),
                           INT8_C( -11), INT8_C(-128), INT8_C( -17), INT8_C( -40),
                           INT8_C( -41), INT8_C(   0), INT8_C( -15), INT8_C( 105),
                           INT8_C(  81), INT8_C(   3), INT8_C(  23), INT8_C( 107),
                           INT8_C( -18), INT8_C(  80), INT8_C(-106), INT8_C(  52),
                           INT8_C(  80), INT8_C( 120), INT8_C(  83), INT8_C(-117),
                           INT8_C(  84), INT8_C( -78), INT8_C(  47), INT8_C( -33),
                           INT8_C( 103), INT8_C(  66), INT8_C(  79), INT8_C(  53),
                           INT8_C( -45), INT8_C(  20), INT8_C( 111), INT8_C( -59),
                           INT8_C( -18), INT8_C(  30), INT8_C(  70), INT8_C( -25),
                           INT8_C( -57), INT8_C(  18), INT8_C(  -4), INT8_C( 101),
                           INT8_C(  75), INT8_C(  12), INT8_C(  85), INT8_C(  93),
                           INT8_C( -79), INT8_C( -13), INT8_C(  43), INT8_C(  45)),
      simde_mm512_set_epi8(INT8_C( -39), INT8_C(-117), INT8_C( -99), INT8_C( -55),
                           INT8_C(   3), INT8_C( -15), INT8_C( 113), INT8_C(  -3),
                           INT8_C( -35), INT8_C( 100), INT8_C( -74), INT8_C(-107),
                           INT8_C(  44), INT8_C( -58), INT8_C(  20), INT8_C(  23),
                           INT8_C( 105), INT8_C( -68), INT8_C( 118), INT8_C( -13),
                           INT8_C( -81), INT8_C(  41), INT8_C( -73), INT8_C(-115),
                           INT8_C(-111), INT8_C(  21), INT8_C(  99), INT8_C( 117),
                           INT8_C( -14), INT8_C(-112), INT8_C(  71), INT8_C(  21),
                           INT8_C(-114), INT8_C( -75), INT8_C(  66), INT8_C(-119),
                           INT8_C( -62), INT8_C(  78), INT8_C(  47), INT8_C(  33),
                           INT8_C( 103), INT8_C(  15), INT8_C( -69), INT8_C(  53),
                           INT8_C(  45), INT8_C(  20), INT8_C( -93), INT8_C( -41),
                           INT8_C(  18), INT8_C(  79), INT8_C(  70), INT8_C(  25),
                           INT8_C(  57), INT8_C(  18), INT8_C( -35), INT8_C(  22),
                           INT8_C(  75), INT8_C( -37), INT8_C(  29), INT8_C(  29),
                           INT8_C(   7), INT8_C(   8), INT8_C(  43), INT8_C( -46)) },
    { simde_mm512_set_epi8(INT8_C( -81), INT8_C(  98), INT8_C(  23), INT8_C(-108),
                           INT8_C(-126), INT8_C(  95), INT8_C( -44), INT8_C( -56),
                           INT8_C(  42), INT8_C(  32), INT8_C( -91), INT8_C(-126),
                           INT8_C( 119), INT8_C(  88), INT8_C( 110), INT8_C(  93),
                           INT8_C(  75), INT8_C( -49), INT8_C( -63), INT8_C( -42),
                           INT8_C(  54), INT8_C( -71), INT8_C(  87), INT8_C(  -1),
                           INT8_C( -25), INT8_C( -60), INT8_C( 102), INT8_C( -98),
                           INT8_C( -95), INT8_C( -34), INT8_C( -46), INT8_C(  94),
                           INT8_C( 118), INT8_C( 127), INT8_C( -62), INT8_C( -70),
                           INT8_C(  80), INT8_C( 125), INT8_C( -12), INT8_C(  33),
                           INT8_C( 110), INT8_C(  -9), INT8_C( -29), INT8_C(-115),
                           INT8_C(-117), INT8_C(  52), INT8_C(-126), INT8_C( -15),
                           INT8_C(-118), INT8_C(-123), INT8_C( -16), INT8_C(  72),
                           INT8_C(  84), INT8_C(  54), INT8_C(  76), INT8_C( -48),
                           INT8_C( -79), INT8_C( 100), INT8_C( -58), INT8_C(  30),
                           INT8_C(  35), INT8_C(  68), INT8_C( -40), INT8_C(   8)),
      UINT64_C(           522030218),
      simde_mm512_set_epi8(INT8_C(  -1), INT8_C( -56), INT8_C( -80), INT8_C(  17),
                           INT8_C( 127), INT8_C(  83), INT8_C(  -9), INT8_C(   0),
                           INT8_C(  -1), INT8_C( 117), INT8_C( -15), INT8_C(  26),
                           INT8_C(  30), INT8_C( -32), INT8_C(  47), INT8_C(  99),
                           INT8_C( -59), INT8_C( -81), INT8_C( -58), INT8_C(  71),
                           INT8_C(-119), INT8_C( -65), INT8_C( -78), INT8_C(-101),
                           INT8_C( -14), INT8_C(   4), INT8_C( -24), INT8_C( -95),
                           INT8_C( 106), INT8_C(  31), INT8_C( 104), INT8_C(  20),
                           INT8_C(  65), INT8_C(  -8), INT8_C( -75), INT8_C(-128),
                           INT8_C( -81), INT8_C(  68), INT8_C( -86), INT8_C(  98),
                           INT8_C( -55), INT8_C(  10), INT8_C(  75), INT8_C(  51),
                           INT8_C( -57), INT8_C(-111), INT8_C(  87), INT8_C(  47),
                           INT8_C( -21), INT8_C( 105), INT8_C(  17), INT8_C( 107),
                           INT8_C(-119), INT8_C( -18), INT8_C(-123), INT8_C(  81),
                           INT8_C(  54), INT8_C(-122), INT8_C( -83), INT8_C(  81),
                           INT8_C(  21), INT8_C(  13), INT8_C(   6), INT8_C( -56)),
      simde_mm512_set_epi8(INT8_C( -81), INT8_C(  98), INT8_C(  23), INT8_C(-108),
                           INT8_C(-126), INT8_C(  95), INT8_C( -44), INT8_C( -56),
                           INT8_C(  42), INT8_C(  32), INT8_C( -91), INT8_C(-126),
                           INT8_C( 119), INT8_C(  88), INT8_C( 110), INT8_C(  93),
                           INT8_C(  75), INT8_C( -49), INT8_C( -63), INT8_C( -42),
                           INT8_C(  54), INT8_C( -71), INT8_C(  87), INT8_C(  -1),
                           INT8_C( -25), INT8_C( -60), INT8_C( 102), INT8_C( -98),
                           INT8_C( -95), INT8_C( -34), INT8_C( -46), INT8_C(  94),
                           INT8_C( 118), INT8_C( 127), INT8_C( -62), INT8_C(-128),
                           INT8_C(  81), INT8_C(  68), INT8_C(  86), INT8_C(  98),
                           INT8_C( 110), INT8_C(  -9), INT8_C( -29), INT8_C(  51),
                           INT8_C(  57), INT8_C( 111), INT8_C(-126), INT8_C(  47),
                           INT8_C(  21), INT8_C(-123), INT8_C( -16), INT8_C(  72),
                           INT8_C( 119), INT8_C(  18), INT8_C(  76), INT8_C( -48),
                           INT8_C(  54), INT8_C( 100), INT8_C( -58), INT8_C(  30),
                           INT8_C(  21), INT8_C(  68), INT8_C(   6), INT8_C(   8)) },
    { simde_mm512_set_epi8(INT8_C(-112), INT8_C( -53), INT8_C(-107), INT8_C(  41),
                           INT8_C( -50), INT8_C( -58), INT8_C(  56), INT8_C(  54),
                           INT8_C(-101), INT8_C(-123), INT8_C(  64), INT8_C( -70),
                           INT8_C( -46), INT8_C(  -1), INT8_C(  70), INT8_C( -46),
                           INT8_C(  96), INT8_C(  45), INT8_C(  57), INT8_C(  -8),
                           INT8_C(  23), INT8_C(  34), INT8_C( -16), INT8_C( -48),
                           INT8_C(  74), INT8_C(  85), INT8_C(-106), INT8_C(  98),
                           INT8_C(  81), INT8_C(-107), INT8_C( -43), INT8_C(  64),
                           INT8_C(-110), INT8_C( 124), INT8_C(-122), INT8_C(-123),
                           INT8_C(  20), INT8_C( 122), INT8_C(  57), INT8_C( -15),
                           INT8_C(  58), INT8_C(  90), INT8_C(-103), INT8_C(  57),
                           INT8_C(  51), INT8_C(-118), INT8_C(  37), INT8_C( -79),
                           INT8_C(  13), INT8_C( 116), INT8_C( -79), INT8_C( -18),
                           INT8_C( -87), INT8_C( -79), INT8_C( -83), INT8_C( -25),
                           INT8_C( -30), INT8_C( -40), INT8_C( 126), INT8_C(  80),
                           INT8_C( -74), INT8_C(  71), INT8_C( -68), INT8_C(  53)),
      UINT64_C(          2821348422),
      simde_mm512_set_epi8(INT8_C(-126), INT8_C(  -8), INT8_C(  35), INT8_C( 112),
                           INT8_C( -78), INT8_C(  75), INT8_C( -25), INT8_C(   1),
                           INT8_C( -27), INT8_C( -67), INT8_C(  49), INT8_C(  75),
                           INT8_C( -39), INT8_C( -68), INT8_C( -51), INT8_C(  42),
                           INT8_C( -30), INT8_C(   1), INT8_C( -18), INT8_C(  -4),
                           INT8_C(  39), INT8_C(  85), INT8_C(  69), INT8_C(  68),
                           INT8_C(-113), INT8_C( -38), INT8_C(  28), INT8_C(  83),
                           INT8_C( -31), INT8_C(  61), INT8_C(  37), INT8_C(  67),
                           INT8_C(  46), INT8_C( -43), INT8_C(  32), INT8_C( -73),
                           INT8_C( -26), INT8_C(   2), INT8_C(  -6), INT8_C( 122),
                           INT8_C( -51), INT8_C( 118), INT8_C(   3), INT8_C(  17),
                           INT8_C(  32), INT8_C(  82), INT8_C(  40), INT8_C(   0),
                           INT8_C(  28), INT8_C(  37), INT8_C(  -3), INT8_C( -85),
                           INT8_C( -92), INT8_C(  45), INT8_C( -23), INT8_C( -58),
                           INT8_C(-108), INT8_C(  44), INT8_C(  28), INT8_C(  77),
                           INT8_C(  12), INT8_C(  81), INT8_C(-103), INT8_C(   7)),
      simde_mm512_set_epi8(INT8_C(-112), INT8_C( -53), INT8_C(-107), INT8_C(  41),
                           INT8_C( -50), INT8_C( -58), INT8_C(  56), INT8_C(  54),
                           INT8_C(-101), INT8_C(-123), INT8_C(  64), INT8_C( -70),
                           INT8_C( -46), INT8_C(  -1), INT8_C(  70), INT8_C( -46),
                           INT8_C(  96), INT8_C(  45), INT8_C(  57), INT8_C(  -8),
                           INT8_C(  23), INT8_C(  34), INT8_C( -16), INT8_C( -48),
                           INT8_C(  74), INT8_C(  85), INT8_C(-106), INT8_C(  98),
                           INT8_C(  81), INT8_C(-107), INT8_C( -43), INT8_C(  64),
                           INT8_C(  46), INT8_C( 124), INT8_C(  32), INT8_C(-123),
                           INT8_C(  26), INT8_C( 122), INT8_C(  57), INT8_C( -15),
                           INT8_C(  58), INT8_C(  90), INT8_C(   3), INT8_C(  57),
                           INT8_C(  32), INT8_C(-118), INT8_C(  40), INT8_C( -79),
                           INT8_C(  13), INT8_C(  37), INT8_C( -79), INT8_C(  85),
                           INT8_C(  92), INT8_C(  45), INT8_C( -83), INT8_C( -25),
                           INT8_C( -30), INT8_C(  44), INT8_C( 126), INT8_C(  80),
                           INT8_C( -74), INT8_C(  81), INT8_C( 103), INT8_C(  53)) },
    { simde_mm512_set_epi8(INT8_C( 115), INT8_C( -13), INT8_C( 104), INT8_C(  83),
                           INT8_C(  80), INT8_C(-118), INT8_C(  34), INT8_C(  48),
                           INT8_C(  50), INT8_C( -65), INT8_C(  88), INT8_C(  76),
                           INT8_C( -17), INT8_C( -86), INT8_C( -68), INT8_C(  75),
                           INT8_C( 121), INT8_C(   9), INT8_C( -63), INT8_C( 106),
                           INT8_C(  93), INT8_C(  44), INT8_C(   0), INT8_C( -33),
                           INT8_C( -53), INT8_C( 101), INT8_C(  76), INT8_C(  37),
                           INT8_C(  94), INT8_C( -32), INT8_C(-104), INT8_C( -20),
                           INT8_C( -48), INT8_C(  45), INT8_C(  88), INT8_C( -93),
                           INT8_C( 104), INT8_C(  42), INT8_C( -99), INT8_C(  59),
                           INT8_C(  90), INT8_C( -69), INT8_C( 107), INT8_C(  16),
                           INT8_C(-118), INT8_C(-119), INT8_C( -60), INT8_C(  51),
                           INT8_C( 126), INT8_C( -78), INT8_C( 114), INT8_C( -75),
                           INT8_C( -75), INT8_C(  19), INT8_C( 113), INT8_C(  84),
                           INT8_C(  47), INT8_C( -83), INT8_C( -26), INT8_C( -38),
                           INT8_C(  64), INT8_C(-106), INT8_C( 107), INT8_C(  56)),
      UINT64_C(          1977462364),
      simde_mm512_set_epi8(INT8_C(-106), INT8_C( -34), INT8_C( 105), INT8_C( -49),
                           INT8_C( -33), INT8_C( 121), INT8_C(   0), INT8_C( 127),
                           INT8_C( -65), INT8_C( -90), INT8_C(-123), INT8_C( 112),
                           INT8_C( -57), INT8_C(  77), INT8_C(  42), INT8_C(  34),
                           INT8_C( -12), INT8_C( -47), INT8_C( 117), INT8_C(  40),
                           INT8_C(  42), INT8_C(  16), INT8_C( -26), INT8_C( 122),
                           INT8_C( 122), INT8_C( -37), INT8_C( -98), INT8_C( -20),
                           INT8_C(  86), INT8_C( -87), INT8_C( -90), INT8_C(-112),
                           INT8_C(-115), INT8_C(  79), INT8_C( 123), INT8_C(  33),
                           INT8_C( -55), INT8_C(-125), INT8_C( 102), INT8_C(  59),
                           INT8_C( -57), INT8_C(  19), INT8_C(  -4), INT8_C( -55),
                           INT8_C( -86), INT8_C(  88), INT8_C( -47), INT8_C(  29),
                           INT8_C(-116), INT8_C( -58), INT8_C( 115), INT8_C( -63),
                           INT8_C( -15), INT8_C( -54), INT8_C(  84), INT8_C(  -1),
                           INT8_C(   5), INT8_C( -33), INT8_C( -96), INT8_C(  93),
                           INT8_C(  97), INT8_C( 124), INT8_C(  26), INT8_C( -34)),
      simde_mm512_set_epi8(INT8_C( 115), INT8_C( -13), INT8_C( 104), INT8_C(  83),
                           INT8_C(  80), INT8_C(-118), INT8_C(  34), INT8_C(  48),
                           INT8_C(  50), INT8_C( -65), INT8_C(  88), INT8_C(  76),
                           INT8_C( -17), INT8_C( -86), INT8_C( -68), INT8_C(  75),
                           INT8_C( 121), INT8_C(   9), INT8_C( -63), INT8_C( 106),
                           INT8_C(  93), INT8_C(  44), INT8_C(   0), INT8_C( -33),
                           INT8_C( -53), INT8_C( 101), INT8_C(  76), INT8_C(  37),
                           INT8_C(  94), INT8_C( -32), INT8_C(-104), INT8_C( -20),
                           INT8_C( -48), INT8_C(  79), INT8_C( 123), INT8_C(  33),
                           INT8_C( 104), INT8_C( 125), INT8_C( -99), INT8_C(  59),
                           INT8_C(  57), INT8_C(  19), INT8_C( 107), INT8_C(  55),
                           INT8_C(  86), INT8_C(  88), INT8_C( -60), INT8_C(  29),
                           INT8_C( 116), INT8_C( -78), INT8_C( 115), INT8_C( -75),
                           INT8_C(  15), INT8_C(  54), INT8_C(  84), INT8_C(  84),
                           INT8_C(  47), INT8_C(  33), INT8_C( -26), INT8_C(  93),
                           INT8_C(  97), INT8_C( 124), INT8_C( 107), INT8_C(  56)) },
    { simde_mm512_set_epi8(INT8_C(   2), INT8_C(  -4), INT8_C( 108), INT8_C(  27),
                           INT8_C( -49), INT8_C(  69), INT8_C( -84), INT8_C(  82),
                           INT8_C(   9), INT8_C(   0), INT8_C(  42), INT8_C( 118),
                           INT8_C(  -3), INT8_C( -67), INT8_C(   6), INT8_C(  30),
                           INT8_C( -88), INT8_C( -69), INT8_C( 118), INT8_C(  36),
                           INT8_C( 110), INT8_C(  81), INT8_C( -37), INT8_C(  36),
                           INT8_C( -74), INT8_C(-109), INT8_C(  47), INT8_C(  12),
                           INT8_C( -29), INT8_C( -81), INT8_C(  76), INT8_C( -22),
                           INT8_C(  91), INT8_C( 125), INT8_C(  98), INT8_C(  17),
                           INT8_C( 115), INT8_C(  58), INT8_C(-107), INT8_C(  90),
                           INT8_C( 115), INT8_C( -24), INT8_C(  83), INT8_C(  17),
                           INT8_C( -11), INT8_C(  20), INT8_C(  81), INT8_C(  54),
                           INT8_C( -59), INT8_C( 112), INT8_C(-102), INT8_C(  13),
                           INT8_C(   8), INT8_C(-105), INT8_C( -27), INT8_C(-127),
                           INT8_C(-112), INT8_C( 125), INT8_C(  21), INT8_C(  55),
                           INT8_C(  24), INT8_C(  58), INT8_C(   7), INT8_C( 127)),
      UINT64_C(           751965274),
      simde_mm512_set_epi8(INT8_C(  90), INT8_C(  75), INT8_C( -70), INT8_C(  89),
                           INT8_C(  25), INT8_C( -86), INT8_C( -40), INT8_C(  -9),
                           INT8_C(-119), INT8_C( -19), INT8_C( 110), INT8_C( -26),
                           INT8_C(-126), INT8_C( 124), INT8_C(   6), INT8_C( -11),
                           INT8_C( -92), INT8_C(  66), INT8_C( -68), INT8_C(  20),
                           INT8_C(  35), INT8_C(  35), INT8_C(  58), INT8_C(  98),
                           INT8_C(  84), INT8_C( -34), INT8_C(  36), INT8_C(-124),
                           INT8_C(  32), INT8_C( -74), INT8_C(  73), INT8_C( -74),
                           INT8_C(  77), INT8_C( 116), INT8_C(  50), INT8_C(  82),
                           INT8_C(  68), INT8_C(  72), INT8_C(  23), INT8_C(  32),
                           INT8_C( -54), INT8_C(  82), INT8_C(  53), INT8_C(  71),
                           INT8_C(  22), INT8_C(  92), INT8_C(  42), INT8_C(-123),
                           INT8_C( -41), INT8_C(  34), INT8_C(  75), INT8_C(  63),
                           INT8_C(-117), INT8_C(  23), INT8_C(-115), INT8_C(  66),
                           INT8_C( -90), INT8_C(  99), INT8_C( -73), INT8_C( -19),
                           INT8_C( -43), INT8_C( -64), INT8_C( -21), INT8_C(  20)),
      simde_mm512_set_epi8(INT8_C(   2), INT8_C(  -4), INT8_C( 108), INT8_C(  27),
                           INT8_C( -49), INT8_C(  69), INT8_C( -84), INT8_C(  82),
                           INT8_C(   9), INT8_C(   0), INT8_C(  42), INT8_C( 118),
                           INT8_C(  -3), INT8_C( -67), INT8_C(   6), INT8_C(  30),
                           INT8_C( -88), INT8_C( -69), INT8_C( 118), INT8_C(  36),
                           INT8_C( 110), INT8_C(  81), INT8_C( -37), INT8_C(  36),
                           INT8_C( -74), INT8_C(-109), INT8_C(  47), INT8_C(  12),
                           INT8_C( -29), INT8_C( -81), INT8_C(  76), INT8_C( -22),
                           INT8_C(  91), INT8_C( 125), INT8_C(  50), INT8_C(  17),
                           INT8_C(  68), INT8_C(  72), INT8_C(-107), INT8_C(  90),
                           INT8_C(  54), INT8_C(  82), INT8_C(  83), INT8_C(  71),
                           INT8_C( -11), INT8_C(  20), INT8_C(  42), INT8_C(  54),
                           INT8_C( -59), INT8_C( 112), INT8_C(-102), INT8_C(  63),
                           INT8_C(   8), INT8_C(  23), INT8_C( -27), INT8_C(-127),
                           INT8_C(-112), INT8_C(  99), INT8_C(  21), INT8_C(  19),
                           INT8_C(  43), INT8_C(  58), INT8_C(  21), INT8_C( 127)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_abs_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i32(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_maskz_abs_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C(          1713497089),
      simde_mm512_set_epi8(INT8_C(-105), INT8_C(  80), INT8_C( -16), INT8_C(-124),
                           INT8_C( -48), INT8_C(  76), INT8_C( -91), INT8_C(-128),
                           INT8_C(  54), INT8_C(  63), INT8_C( 114), INT8_C( -73),
                           INT8_C( -26), INT8_C( -48), INT8_C( -24), INT8_C( -13),
                           INT8_C(   5), INT8_C( 123), INT8_C( -45), INT8_C( -57),
                           INT8_C(-107), INT8_C(  47), INT8_C(  90), INT8_C( -54),
                           INT8_C(   1), INT8_C( 118), INT8_C(  37), INT8_C(  -7),
                           INT8_C(  83), INT8_C(  31), INT8_C( -23), INT8_C( -20),
                           INT8_C(-104), INT8_C( 114), INT8_C(  63), INT8_C(  25),
                           INT8_C( -80), INT8_C(  17), INT8_C(  37), INT8_C( -44),
                           INT8_C(-112), INT8_C(  41), INT8_C( -18), INT8_C(  86),
                           INT8_C( 114), INT8_C( -23), INT8_C( -86), INT8_C( -99),
                           INT8_C( 114), INT8_C(  25), INT8_C(  94), INT8_C(  34),
                           INT8_C( -48), INT8_C(  -4), INT8_C(-123), INT8_C( -44),
                           INT8_C( -68), INT8_C(  19), INT8_C(  47), INT8_C(-122),
                           INT8_C( 117), INT8_C(  69), INT8_C(-121), INT8_C(  66)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 114), INT8_C(  63), INT8_C(   0),
                           INT8_C(   0), INT8_C(  17), INT8_C(  37), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  18), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  99),
                           INT8_C( 114), INT8_C(  25), INT8_C(  94), INT8_C(   0),
                           INT8_C(   0), INT8_C(   4), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  66)) },
    { UINT64_C(           549841533),
      simde_mm512_set_epi8(INT8_C( -84), INT8_C(  24), INT8_C(  17), INT8_C( -28),
                           INT8_C(  -3), INT8_C(  88), INT8_C(  98), INT8_C( -52),
                           INT8_C( -76), INT8_C( -19), INT8_C( 100), INT8_C(  59),
                           INT8_C( -64), INT8_C( -60), INT8_C( -53), INT8_C(  16),
                           INT8_C(   0), INT8_C( -89), INT8_C(  13), INT8_C(  17),
                           INT8_C( 116), INT8_C(  41), INT8_C(  54), INT8_C(  -8),
                           INT8_C(-112), INT8_C( 109), INT8_C(  94), INT8_C(  19),
                           INT8_C(  46), INT8_C( -55), INT8_C( 103), INT8_C(   7),
                           INT8_C( -15), INT8_C( -12), INT8_C( -22), INT8_C( 127),
                           INT8_C( -48), INT8_C( -83), INT8_C(  -9), INT8_C( -85),
                           INT8_C( -79), INT8_C( -12), INT8_C(  76), INT8_C( -65),
                           INT8_C( -90), INT8_C(  19), INT8_C(  33), INT8_C( -50),
                           INT8_C(  89), INT8_C( -40), INT8_C(-117), INT8_C( 111),
                           INT8_C(  48), INT8_C( 119), INT8_C( -55), INT8_C(  66),
                           INT8_C( 113), INT8_C(  -2), INT8_C( -49), INT8_C(-110),
                           INT8_C( -55), INT8_C(  44), INT8_C( 125), INT8_C( -61)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  22), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  79), INT8_C(  12), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  19), INT8_C(   0), INT8_C(  50),
                           INT8_C(  89), INT8_C(  40), INT8_C( 117), INT8_C(   0),
                           INT8_C(  48), INT8_C(   0), INT8_C(  55), INT8_C(   0),
                           INT8_C(   0), INT8_C(   2), INT8_C(  49), INT8_C( 110),
                           INT8_C(  55), INT8_C(  44), INT8_C(   0), INT8_C(  61)) },
    { UINT64_C(          2304862624),
      simde_mm512_set_epi8(INT8_C(  71), INT8_C( -17), INT8_C(   0), INT8_C( -82),
                           INT8_C( -27), INT8_C( 124), INT8_C(  45), INT8_C(  57),
                           INT8_C( 107), INT8_C( -93), INT8_C( -77), INT8_C(  53),
                           INT8_C( 126), INT8_C(  10), INT8_C( 123), INT8_C(-113),
                           INT8_C( -41), INT8_C(-108), INT8_C( -59), INT8_C( -36),
                           INT8_C( -24), INT8_C( -51), INT8_C( -68), INT8_C( -38),
                           INT8_C(  19), INT8_C( 120), INT8_C(-118), INT8_C(  63),
                           INT8_C(  24), INT8_C(  72), INT8_C(  39), INT8_C(  31),
                           INT8_C( -92), INT8_C(  52), INT8_C(  81), INT8_C(  39),
                           INT8_C( -70), INT8_C(  73), INT8_C(  76), INT8_C( 114),
                           INT8_C(  -7), INT8_C(   4), INT8_C( -55), INT8_C( -68),
                           INT8_C( 120), INT8_C(  98), INT8_C(-115), INT8_C( -56),
                           INT8_C(  93), INT8_C(  -2), INT8_C(  78), INT8_C(  16),
                           INT8_C(  88), INT8_C(  71), INT8_C(-112), INT8_C(-118),
                           INT8_C(   4), INT8_C( -88), INT8_C(  76), INT8_C(  88),
                           INT8_C( -97), INT8_C( 107), INT8_C( -28), INT8_C( -59)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  92), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  70), INT8_C(   0), INT8_C(   0), INT8_C( 114),
                           INT8_C(   0), INT8_C(   4), INT8_C(  55), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  56),
                           INT8_C(   0), INT8_C(   2), INT8_C(  78), INT8_C(   0),
                           INT8_C(  88), INT8_C(   0), INT8_C(   0), INT8_C( 118),
                           INT8_C(   4), INT8_C(   0), INT8_C(  76), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(          2156618221),
      simde_mm512_set_epi8(INT8_C( -88), INT8_C( -28), INT8_C( -75), INT8_C(  34),
                           INT8_C( -30), INT8_C(  -1), INT8_C(  52), INT8_C( -92),
                           INT8_C( -85), INT8_C(  43), INT8_C(   9), INT8_C(  24),
                           INT8_C( -64), INT8_C( 107), INT8_C( -57), INT8_C(  38),
                           INT8_C(  95), INT8_C( -18), INT8_C(  11), INT8_C(  96),
                           INT8_C(  -4), INT8_C( -94), INT8_C( 116), INT8_C( -31),
                           INT8_C(  52), INT8_C(  -2), INT8_C(  98), INT8_C(  10),
                           INT8_C(   5), INT8_C(  19), INT8_C( -65), INT8_C(  10),
                           INT8_C(-109), INT8_C(  52), INT8_C( -85), INT8_C( -32),
                           INT8_C(  38), INT8_C(  92), INT8_C(   6), INT8_C( -71),
                           INT8_C( -79), INT8_C(  79), INT8_C( -94), INT8_C( 113),
                           INT8_C(-117), INT8_C(  20), INT8_C( -82), INT8_C(  82),
                           INT8_C(-120), INT8_C( 114), INT8_C( -52), INT8_C( -68),
                           INT8_C( -20), INT8_C( -47), INT8_C( -90), INT8_C( -87),
                           INT8_C(  79), INT8_C( -37), INT8_C(  63), INT8_C( -89),
                           INT8_C( -40), INT8_C( -67), INT8_C( -69), INT8_C(-117)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 109), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  79), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 117), INT8_C(   0), INT8_C(  82), INT8_C(  82),
                           INT8_C(   0), INT8_C( 114), INT8_C(  52), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  87),
                           INT8_C(  79), INT8_C(  37), INT8_C(  63), INT8_C(   0),
                           INT8_C(  40), INT8_C(  67), INT8_C(   0), INT8_C( 117)) },
    { UINT64_C(          2985927056),
      simde_mm512_set_epi8(INT8_C(-128), INT8_C(  11), INT8_C( -31), INT8_C( 116),
                           INT8_C( -77), INT8_C(  97), INT8_C(  87), INT8_C(  53),
                           INT8_C( -33), INT8_C(  37), INT8_C(  28), INT8_C(  24),
                           INT8_C(-103), INT8_C(  99), INT8_C( -75), INT8_C(  41),
                           INT8_C(  83), INT8_C(  39), INT8_C( 120), INT8_C( 115),
                           INT8_C( -51), INT8_C( -28), INT8_C( 102), INT8_C( -98),
                           INT8_C( -77), INT8_C( 121), INT8_C(  42), INT8_C( 114),
                           INT8_C(  -1), INT8_C( 112), INT8_C(  17), INT8_C( -31),
                           INT8_C( 108), INT8_C( -27), INT8_C(  66), INT8_C(  23),
                           INT8_C(  69), INT8_C( -90), INT8_C( -46), INT8_C( -91),
                           INT8_C( -81), INT8_C( -87), INT8_C(   1), INT8_C( -11),
                           INT8_C(  84), INT8_C(-117), INT8_C(  79), INT8_C(-110),
                           INT8_C( -44), INT8_C( -30), INT8_C(  33), INT8_C(  53),
                           INT8_C(  64), INT8_C( -16), INT8_C(-111), INT8_C( -41),
                           INT8_C(-102), INT8_C(  13), INT8_C(  97), INT8_C( -55),
                           INT8_C(  19), INT8_C( -16), INT8_C( -68), INT8_C( -83)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 108), INT8_C(   0), INT8_C(  66), INT8_C(  23),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  91),
                           INT8_C(  81), INT8_C(  87), INT8_C(   1), INT8_C(  11),
                           INT8_C(  84), INT8_C(   0), INT8_C(   0), INT8_C( 110),
                           INT8_C(  44), INT8_C(   0), INT8_C(  33), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  41),
                           INT8_C( 102), INT8_C(   0), INT8_C(   0), INT8_C(  55),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(           390836854),
      simde_mm512_set_epi8(INT8_C(  -6), INT8_C( 127), INT8_C(-110), INT8_C(  -8),
                           INT8_C( 106), INT8_C(  95), INT8_C(-126), INT8_C(-127),
                           INT8_C(-103), INT8_C( -21), INT8_C( -20), INT8_C( -71),
                           INT8_C( 106), INT8_C(  23), INT8_C( -51), INT8_C( -47),
                           INT8_C(-107), INT8_C(  61), INT8_C( -93), INT8_C(  10),
                           INT8_C(   4), INT8_C( 110), INT8_C( -43), INT8_C(  40),
                           INT8_C(  60), INT8_C( -40), INT8_C(  36), INT8_C( -39),
                           INT8_C( -80), INT8_C(-110), INT8_C(  14), INT8_C( -61),
                           INT8_C( -39), INT8_C( -70), INT8_C(-116), INT8_C( -99),
                           INT8_C( -82), INT8_C(-113), INT8_C(-120), INT8_C(-116),
                           INT8_C( -58), INT8_C(  18), INT8_C(  72), INT8_C(  23),
                           INT8_C(-117), INT8_C(-105), INT8_C(  83), INT8_C(   3),
                           INT8_C(-104), INT8_C(  34), INT8_C(  72), INT8_C( -33),
                           INT8_C(  84), INT8_C( -90), INT8_C(-116), INT8_C( -46),
                           INT8_C( -18), INT8_C(  96), INT8_C( -46), INT8_C(-109),
                           INT8_C(-103), INT8_C( -18), INT8_C( -39), INT8_C(  67)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  99),
                           INT8_C(   0), INT8_C( 113), INT8_C( 120), INT8_C( 116),
                           INT8_C(   0), INT8_C(  18), INT8_C(   0), INT8_C(   0),
                           INT8_C( 117), INT8_C(   0), INT8_C(  83), INT8_C(   3),
                           INT8_C( 104), INT8_C(   0), INT8_C(  72), INT8_C(  33),
                           INT8_C(   0), INT8_C(   0), INT8_C( 116), INT8_C(   0),
                           INT8_C(   0), INT8_C(  96), INT8_C(  46), INT8_C( 109),
                           INT8_C(   0), INT8_C(  18), INT8_C(  39), INT8_C(   0)) },
    { UINT64_C(           189869641),
      simde_mm512_set_epi8(INT8_C(  28), INT8_C(-101), INT8_C(-104), INT8_C(-117),
                           INT8_C(  24), INT8_C( -55), INT8_C(  82), INT8_C(-100),
                           INT8_C( -42), INT8_C(  62), INT8_C(-113), INT8_C( 110),
                           INT8_C( -92), INT8_C( 127), INT8_C( -92), INT8_C(  20),
                           INT8_C( -35), INT8_C(  35), INT8_C(  30), INT8_C( -86),
                           INT8_C( 120), INT8_C(  91), INT8_C( -69), INT8_C( -49),
                           INT8_C(  19), INT8_C( -87), INT8_C(  42), INT8_C(-110),
                           INT8_C(  68), INT8_C(  97), INT8_C(-125), INT8_C(  75),
                           INT8_C(  30), INT8_C( -54), INT8_C( -38), INT8_C( -20),
                           INT8_C( -96), INT8_C(  84), INT8_C( 108), INT8_C(  24),
                           INT8_C( -54), INT8_C( -26), INT8_C(-125), INT8_C( -53),
                           INT8_C(  48), INT8_C( -78), INT8_C( -96), INT8_C(  82),
                           INT8_C( -16), INT8_C( -68), INT8_C( -65), INT8_C(  28),
                           INT8_C( -82), INT8_C(-116), INT8_C( 119), INT8_C(-113),
                           INT8_C( 102), INT8_C(  90), INT8_C(  86), INT8_C( -14),
                           INT8_C( -49), INT8_C(  71), INT8_C(   2), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  96), INT8_C(   0), INT8_C( 108), INT8_C(  24),
                           INT8_C(   0), INT8_C(  26), INT8_C(   0), INT8_C(  53),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  82),
                           INT8_C(   0), INT8_C(   0), INT8_C(  65), INT8_C(   0),
                           INT8_C(  82), INT8_C( 116), INT8_C( 119), INT8_C(   0),
                           INT8_C(   0), INT8_C(  90), INT8_C(   0), INT8_C(   0),
                           INT8_C(  49), INT8_C(   0), INT8_C(   0), INT8_C(  28)) },
    { UINT64_C(          2755545546),
      simde_mm512_set_epi8(INT8_C( -71), INT8_C(  48), INT8_C(  -1), INT8_C( -17),
                           INT8_C( -90), INT8_C(   3), INT8_C( -34), INT8_C(  36),
                           INT8_C( -17), INT8_C( -38), INT8_C( 100), INT8_C( -30),
                           INT8_C( 118), INT8_C(  42), INT8_C( -25), INT8_C( -45),
                           INT8_C(   4), INT8_C(   8), INT8_C(  53), INT8_C(  84),
                           INT8_C(-120), INT8_C(  61), INT8_C(  90), INT8_C( -19),
                           INT8_C(  31), INT8_C(-108), INT8_C( -76), INT8_C(  95),
                           INT8_C( 101), INT8_C( -99), INT8_C( -14), INT8_C(  26),
                           INT8_C( -35), INT8_C( -61), INT8_C(  15), INT8_C(  71),
                           INT8_C( 113), INT8_C( 109), INT8_C(  91), INT8_C(-117),
                           INT8_C(   0), INT8_C( 121), INT8_C(  48), INT8_C( 109),
                           INT8_C(  55), INT8_C( 125), INT8_C(-112), INT8_C(  80),
                           INT8_C(  48), INT8_C(  40), INT8_C(  32), INT8_C( -98),
                           INT8_C(  64), INT8_C( -31), INT8_C( -10), INT8_C(  -6),
                           INT8_C( -40), INT8_C(  37), INT8_C(  76), INT8_C( -51),
                           INT8_C(  27), INT8_C(  -2), INT8_C(-101), INT8_C( -10)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  35), INT8_C(   0), INT8_C(  15), INT8_C(   0),
                           INT8_C(   0), INT8_C( 109), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  48), INT8_C( 109),
                           INT8_C(  55), INT8_C( 125), INT8_C( 112), INT8_C(   0),
                           INT8_C(   0), INT8_C(  40), INT8_C(   0), INT8_C(   0),
                           INT8_C(  64), INT8_C(   0), INT8_C(   0), INT8_C(   6),
                           INT8_C(  40), INT8_C(  37), INT8_C(   0), INT8_C(   0),
                           INT8_C(  27), INT8_C(   0), INT8_C( 101), INT8_C(   0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_abs_epi8(test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_abs_epi16(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi16(INT16_C(-24810), INT16_C( -1893), INT16_C( -4484), INT16_C(-18467),
                            INT16_C(-27267), INT16_C(-12302), INT16_C(-13826), INT16_C(   938),
                            INT16_C(-17680), INT16_C(  -610), INT16_C( -4882), INT16_C(-14649),
                            INT16_C( 30481), INT16_C(-20144), INT16_C( 20995), INT16_C( -4451),
                            INT16_C(  6425), INT16_C( 21336), INT16_C( 30080), INT16_C(  4310),
                            INT16_C( 29439), INT16_C(-28107), INT16_C( 32707), INT16_C(-17334),
                            INT16_C( 26460), INT16_C(-29244), INT16_C( -5806), INT16_C(-31467),
                            INT16_C( -9353), INT16_C( -9759), INT16_C(  6587), INT16_C(-14562)),
      simde_mm512_set_epi16(INT16_C( 24810), INT16_C(  1893), INT16_C(  4484), INT16_C( 18467),
                            INT16_C( 27267), INT16_C( 12302), INT16_C( 13826), INT16_C(   938),
                            INT16_C( 17680), INT16_C(   610), INT16_C(  4882), INT16_C( 14649),
                            INT16_C( 30481), INT16_C( 20144), INT16_C( 20995), INT16_C(  4451),
                            INT16_C(  6425), INT16_C( 21336), INT16_C( 30080), INT16_C(  4310),
                            INT16_C( 29439), INT16_C( 28107), INT16_C( 32707), INT16_C( 17334),
                            INT16_C( 26460), INT16_C( 29244), INT16_C(  5806), INT16_C( 31467),
                            INT16_C(  9353), INT16_C(  9759), INT16_C(  6587), INT16_C( 14562)) },
    { simde_mm512_set_epi16(INT16_C( 31294), INT16_C(-10840), INT16_C( 23692), INT16_C( -1500),
                            INT16_C(  2562), INT16_C(-16788), INT16_C( -9616), INT16_C( 31575),
                            INT16_C( 25554), INT16_C(-13527), INT16_C(-26722), INT16_C(  4852),
                            INT16_C(-20866), INT16_C(-19475), INT16_C(  4624), INT16_C(  9206),
                            INT16_C(-14800), INT16_C(-30682), INT16_C( 15889), INT16_C(  8584),
                            INT16_C( 27161), INT16_C(-23281), INT16_C( 25970), INT16_C(-11578),
                            INT16_C( 28932), INT16_C( 12842), INT16_C(   -29), INT16_C( -6679),
                            INT16_C(-17572), INT16_C(-17063), INT16_C( -2346), INT16_C( 20336)),
      simde_mm512_set_epi16(INT16_C( 31294), INT16_C( 10840), INT16_C( 23692), INT16_C(  1500),
                            INT16_C(  2562), INT16_C( 16788), INT16_C(  9616), INT16_C( 31575),
                            INT16_C( 25554), INT16_C( 13527), INT16_C( 26722), INT16_C(  4852),
                            INT16_C( 20866), INT16_C( 19475), INT16_C(  4624), INT16_C(  9206),
                            INT16_C( 14800), INT16_C( 30682), INT16_C( 15889), INT16_C(  8584),
                            INT16_C( 27161), INT16_C( 23281), INT16_C( 25970), INT16_C( 11578),
                            INT16_C( 28932), INT16_C( 12842), INT16_C(    29), INT16_C(  6679),
                            INT16_C( 17572), INT16_C( 17063), INT16_C(  2346), INT16_C( 20336)) },
    { simde_mm512_set_epi16(INT16_C(-29319), INT16_C( -6944), INT16_C( 10081), INT16_C( 26836),
                            INT16_C( 30965), INT16_C(-18751), INT16_C( -5923), INT16_C(-27401),
                            INT16_C(  7842), INT16_C( 24713), INT16_C( -3422), INT16_C(  8849),
                            INT16_C( 22266), INT16_C(-29640), INT16_C(  -264), INT16_C(-16823),
                            INT16_C(-28396), INT16_C( 29200), INT16_C( 18193), INT16_C( -3173),
                            INT16_C(  8244), INT16_C( -1296), INT16_C( 20026), INT16_C(  3755),
                            INT16_C(-14728), INT16_C( 26243), INT16_C( 18823), INT16_C(-30029),
                            INT16_C( 21566), INT16_C( 25734), INT16_C( -4271), INT16_C( 27065)),
      simde_mm512_set_epi16(INT16_C( 29319), INT16_C(  6944), INT16_C( 10081), INT16_C( 26836),
                            INT16_C( 30965), INT16_C( 18751), INT16_C(  5923), INT16_C( 27401),
                            INT16_C(  7842), INT16_C( 24713), INT16_C(  3422), INT16_C(  8849),
                            INT16_C( 22266), INT16_C( 29640), INT16_C(   264), INT16_C( 16823),
                            INT16_C( 28396), INT16_C( 29200), INT16_C( 18193), INT16_C(  3173),
                            INT16_C(  8244), INT16_C(  1296), INT16_C( 20026), INT16_C(  3755),
                            INT16_C( 14728), INT16_C( 26243), INT16_C( 18823), INT16_C( 30029),
                            INT16_C( 21566), INT16_C( 25734), INT16_C(  4271), INT16_C( 27065)) },
    { simde_mm512_set_epi16(INT16_C( 26713), INT16_C(  6075), INT16_C(-20498), INT16_C(-29395),
                            INT16_C( 28513), INT16_C(-24372), INT16_C( 30119), INT16_C( 21303),
                            INT16_C(-20009), INT16_C( 16878), INT16_C( -3364), INT16_C( -1142),
                            INT16_C( 26178), INT16_C(  1599), INT16_C(   583), INT16_C(-20121),
                            INT16_C( 25419), INT16_C(  4739), INT16_C( 22881), INT16_C( -2884),
                            INT16_C( -7360), INT16_C( 23146), INT16_C(-16850), INT16_C(-17018),
                            INT16_C(  9049), INT16_C(-31439), INT16_C( 20369), INT16_C( 26125),
                            INT16_C(  4615), INT16_C(  3018), INT16_C( 20462), INT16_C( 20538)),
      simde_mm512_set_epi16(INT16_C( 26713), INT16_C(  6075), INT16_C( 20498), INT16_C( 29395),
                            INT16_C( 28513), INT16_C( 24372), INT16_C( 30119), INT16_C( 21303),
                            INT16_C( 20009), INT16_C( 16878), INT16_C(  3364), INT16_C(  1142),
                            INT16_C( 26178), INT16_C(  1599), INT16_C(   583), INT16_C( 20121),
                            INT16_C( 25419), INT16_C(  4739), INT16_C( 22881), INT16_C(  2884),
                            INT16_C(  7360), INT16_C( 23146), INT16_C( 16850), INT16_C( 17018),
                            INT16_C(  9049), INT16_C( 31439), INT16_C( 20369), INT16_C( 26125),
                            INT16_C(  4615), INT16_C(  3018), INT16_C( 20462), INT16_C( 20538)) },
    { simde_mm512_set_epi16(INT16_C(-17426), INT16_C( -6113), INT16_C(-30180), INT16_C( 28425),
                            INT16_C(-15870), INT16_C(  6201), INT16_C( 15445), INT16_C(-31740),
                            INT16_C(-11778), INT16_C(-10748), INT16_C(-28415), INT16_C( -1743),
                            INT16_C( 22411), INT16_C( 18108), INT16_C( 23625), INT16_C( 27654),
                            INT16_C( 27868), INT16_C( 15645), INT16_C( 22336), INT16_C(-29935),
                            INT16_C( -3026), INT16_C(-19158), INT16_C( 20698), INT16_C( 21892),
                            INT16_C(-32012), INT16_C( 10508), INT16_C(-14383), INT16_C( 20676),
                            INT16_C(  6233), INT16_C(-11386), INT16_C(-13291), INT16_C( 13948)),
      simde_mm512_set_epi16(INT16_C( 17426), INT16_C(  6113), INT16_C( 30180), INT16_C( 28425),
                            INT16_C( 15870), INT16_C(  6201), INT16_C( 15445), INT16_C( 31740),
                            INT16_C( 11778), INT16_C( 10748), INT16_C( 28415), INT16_C(  1743),
                            INT16_C( 22411), INT16_C( 18108), INT16_C( 23625), INT16_C( 27654),
                            INT16_C( 27868), INT16_C( 15645), INT16_C( 22336), INT16_C( 29935),
                            INT16_C(  3026), INT16_C( 19158), INT16_C( 20698), INT16_C( 21892),
                            INT16_C( 32012), INT16_C( 10508), INT16_C( 14383), INT16_C( 20676),
                            INT16_C(  6233), INT16_C( 11386), INT16_C( 13291), INT16_C( 13948)) },
    { simde_mm512_set_epi16(INT16_C(  6099), INT16_C(-22144), INT16_C( 20288), INT16_C(-18323),
                            INT16_C(  -136), INT16_C( -4474), INT16_C(-14336), INT16_C( 25660),
                            INT16_C(-19775), INT16_C(  6691), INT16_C(-16568), INT16_C(  9907),
                            INT16_C(-31382), INT16_C(  1875), INT16_C( 22377), INT16_C(-21951),
                            INT16_C(-10385), INT16_C(-18760), INT16_C(  7844), INT16_C( 16059),
                            INT16_C(-14216), INT16_C( 22036), INT16_C(-20920), INT16_C( 11586),
                            INT16_C(-18048), INT16_C( -8950), INT16_C(-23337), INT16_C( 26279),
                            INT16_C( 12076), INT16_C(  3090), INT16_C( -7311), INT16_C( -5254)),
      simde_mm512_set_epi16(INT16_C(  6099), INT16_C( 22144), INT16_C( 20288), INT16_C( 18323),
                            INT16_C(   136), INT16_C(  4474), INT16_C( 14336), INT16_C( 25660),
                            INT16_C( 19775), INT16_C(  6691), INT16_C( 16568), INT16_C(  9907),
                            INT16_C( 31382), INT16_C(  1875), INT16_C( 22377), INT16_C( 21951),
                            INT16_C( 10385), INT16_C( 18760), INT16_C(  7844), INT16_C( 16059),
                            INT16_C( 14216), INT16_C( 22036), INT16_C( 20920), INT16_C( 11586),
                            INT16_C( 18048), INT16_C(  8950), INT16_C( 23337), INT16_C( 26279),
                            INT16_C( 12076), INT16_C(  3090), INT16_C(  7311), INT16_C(  5254)) },
    { simde_mm512_set_epi16(INT16_C(  1734), INT16_C(-24733), INT16_C(  6252), INT16_C(-10636),
                            INT16_C(-13019), INT16_C(  4439), INT16_C( 30486), INT16_C(  9898),
                            INT16_C( 18157), INT16_C( 29700), INT16_C(-19524), INT16_C(  5081),
                            INT16_C(  -888), INT16_C( 21733), INT16_C(-17288), INT16_C(-29729),
                            INT16_C(   877), INT16_C( 22002), INT16_C( 31006), INT16_C( 27903),
                            INT16_C( 29379), INT16_C( 11869), INT16_C( 12487), INT16_C(-24676),
                            INT16_C( 21504), INT16_C(-22063), INT16_C( 21762), INT16_C( 32035),
                            INT16_C( -2823), INT16_C(   772), INT16_C( 22127), INT16_C(-16867)),
      simde_mm512_set_epi16(INT16_C(  1734), INT16_C( 24733), INT16_C(  6252), INT16_C( 10636),
                            INT16_C( 13019), INT16_C(  4439), INT16_C( 30486), INT16_C(  9898),
                            INT16_C( 18157), INT16_C( 29700), INT16_C( 19524), INT16_C(  5081),
                            INT16_C(   888), INT16_C( 21733), INT16_C( 17288), INT16_C( 29729),
                            INT16_C(   877), INT16_C( 22002), INT16_C( 31006), INT16_C( 27903),
                            INT16_C( 29379), INT16_C( 11869), INT16_C( 12487), INT16_C( 24676),
                            INT16_C( 21504), INT16_C( 22063), INT16_C( 21762), INT16_C( 32035),
                            INT16_C(  2823), INT16_C(   772), INT16_C( 22127), INT16_C( 16867)) },
    { simde_mm512_set_epi16(INT16_C( 12349), INT16_C( 32588), INT16_C(-21894), INT16_C(-24438),
                            INT16_C( -9480), INT16_C( 14484), INT16_C(   264), INT16_C(  5772),
                            INT16_C(-13220), INT16_C( 17520), INT16_C(-23892), INT16_C( 25295),
                            INT16_C(-10903), INT16_C( 18210), INT16_C(-32005), INT16_C(  1475),
                            INT16_C(-31775), INT16_C(-32553), INT16_C( 21009), INT16_C(-11897),
                            INT16_C(   118), INT16_C( -4448), INT16_C( 11548), INT16_C( 27032),
                            INT16_C( -3816), INT16_C( 24167), INT16_C(-13680), INT16_C(  3963),
                            INT16_C( -6791), INT16_C(-30064), INT16_C(-17823), INT16_C( 15062)),
      simde_mm512_set_epi16(INT16_C( 12349), INT16_C( 32588), INT16_C( 21894), INT16_C( 24438),
                            INT16_C(  9480), INT16_C( 14484), INT16_C(   264), INT16_C(  5772),
                            INT16_C( 13220), INT16_C( 17520), INT16_C( 23892), INT16_C( 25295),
                            INT16_C( 10903), INT16_C( 18210), INT16_C( 32005), INT16_C(  1475),
                            INT16_C( 31775), INT16_C( 32553), INT16_C( 21009), INT16_C( 11897),
                            INT16_C(   118), INT16_C(  4448), INT16_C( 11548), INT16_C( 27032),
                            INT16_C(  3816), INT16_C( 24167), INT16_C( 13680), INT16_C(  3963),
                            INT16_C(  6791), INT16_C( 30064), INT16_C( 17823), INT16_C( 15062)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_abs_epi16(test_vec[i].a);
    simde_assert_m512i_i16(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_abs_epi16 (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const int16_t src[32];
    const simde__mmask32 k;
    const int16_t a[32];
    const int16_t r[32];
  } test_vec[] = {
    { { -INT16_C(  5316), -INT16_C( 21434),  INT16_C( 23082), -INT16_C( 11070), -INT16_C( 21411), -INT16_C(  1395),  INT16_C( 31798), -INT16_C( 18159),
        -INT16_C( 19036), -INT16_C( 29365),  INT16_C( 11378),  INT16_C( 16016), -INT16_C( 11452), -INT16_C( 20127),  INT16_C( 12785),  INT16_C( 11729),
         INT16_C(  5916),  INT16_C( 18393), -INT16_C( 25742), -INT16_C( 12517), -INT16_C( 22456),  INT16_C( 32458), -INT16_C(  9436), -INT16_C( 14025),
        -INT16_C( 32112),  INT16_C(   598), -INT16_C(  6225), -INT16_C(  3264), -INT16_C( 24134), -INT16_C( 21596),  INT16_C( 30418), -INT16_C(  4136) },
      UINT32_C(4281774477),
      {  INT16_C( 20812), -INT16_C( 27441), -INT16_C( 26119),  INT16_C(  7442),  INT16_C( 18804),  INT16_C(  1254),  INT16_C( 15820),  INT16_C( 31494),
         INT16_C( 17956), -INT16_C(  8594),  INT16_C(  4839), -INT16_C( 18039),  INT16_C( 24968),  INT16_C(  5800), -INT16_C(  8686),  INT16_C( 24085),
        -INT16_C(  7121),  INT16_C( 10483),  INT16_C(  1405), -INT16_C(  3770),  INT16_C( 11343),  INT16_C(  7157), -INT16_C(  1175), -INT16_C( 29290),
         INT16_C(  1089),  INT16_C( 10347), -INT16_C(  3050), -INT16_C( 24606), -INT16_C( 30123),  INT16_C( 26549), -INT16_C( 13719), -INT16_C( 26426) },
      {  INT16_C( 20812), -INT16_C( 21434),  INT16_C( 26119),  INT16_C(  7442), -INT16_C( 21411), -INT16_C(  1395),  INT16_C( 31798),  INT16_C( 31494),
         INT16_C( 17956), -INT16_C( 29365),  INT16_C( 11378),  INT16_C( 16016),  INT16_C( 24968),  INT16_C(  5800),  INT16_C( 12785),  INT16_C( 24085),
         INT16_C(  5916),  INT16_C( 10483),  INT16_C(  1405), -INT16_C( 12517),  INT16_C( 11343),  INT16_C(  7157), -INT16_C(  9436), -INT16_C( 14025),
         INT16_C(  1089),  INT16_C( 10347),  INT16_C(  3050),  INT16_C( 24606),  INT16_C( 30123),  INT16_C( 26549),  INT16_C( 13719),  INT16_C( 26426) } },
    { { -INT16_C( 18001),  INT16_C( 11457),  INT16_C(  1982),  INT16_C(  3358),  INT16_C(  4915), -INT16_C( 25304), -INT16_C( 16881),  INT16_C( 20522),
        -INT16_C( 26942), -INT16_C(  9863),  INT16_C( 23434), -INT16_C(  8072),  INT16_C( 11749),  INT16_C( 20039),  INT16_C(  3575), -INT16_C( 22809),
        -INT16_C( 22330), -INT16_C( 31277), -INT16_C(  3665), -INT16_C(  7534), -INT16_C( 17660),  INT16_C(  4991), -INT16_C( 21895),  INT16_C( 15460),
        -INT16_C(  8896), -INT16_C( 13803), -INT16_C( 29384),  INT16_C(  7594), -INT16_C(  3398), -INT16_C( 20116),  INT16_C( 21503), -INT16_C( 14760) },
      UINT32_C(2857053179),
      { -INT16_C(  8932),  INT16_C(  8332),  INT16_C(  3224),  INT16_C(  4660), -INT16_C( 26442), -INT16_C(  2482),  INT16_C( 25461), -INT16_C( 21056),
         INT16_C( 27632), -INT16_C( 21814),  INT16_C( 13917),  INT16_C( 23643), -INT16_C( 19575), -INT16_C( 31710),  INT16_C( 28126), -INT16_C(  1490),
        -INT16_C( 17589), -INT16_C(  7397),  INT16_C( 20423),  INT16_C( 32245),  INT16_C( 17383),  INT16_C( 23667),  INT16_C( 13222), -INT16_C( 27127),
        -INT16_C( 11362), -INT16_C(  1216), -INT16_C( 25590), -INT16_C( 27816),  INT16_C( 31311),  INT16_C( 11800),  INT16_C( 18152),  INT16_C( 13096) },
      {  INT16_C(  8932),  INT16_C(  8332),  INT16_C(  1982),  INT16_C(  4660),  INT16_C( 26442),  INT16_C(  2482),  INT16_C( 25461),  INT16_C( 21056),
         INT16_C( 27632),  INT16_C( 21814),  INT16_C( 23434),  INT16_C( 23643),  INT16_C( 11749),  INT16_C( 31710),  INT16_C(  3575), -INT16_C( 22809),
         INT16_C( 17589),  INT16_C(  7397), -INT16_C(  3665),  INT16_C( 32245), -INT16_C( 17660),  INT16_C(  4991),  INT16_C( 13222),  INT16_C( 15460),
        -INT16_C(  8896),  INT16_C(  1216), -INT16_C( 29384),  INT16_C( 27816), -INT16_C(  3398),  INT16_C( 11800),  INT16_C( 21503),  INT16_C( 13096) } },
    { {  INT16_C( 17153), -INT16_C( 14314),  INT16_C(  3218),  INT16_C( 31045), -INT16_C( 18353), -INT16_C(  2347), -INT16_C(  8468), -INT16_C( 30068),
        -INT16_C( 12878), -INT16_C( 17274), -INT16_C(  8599), -INT16_C( 18353),  INT16_C( 26456),  INT16_C( 16614),  INT16_C(  4014), -INT16_C( 20621),
        -INT16_C( 30126), -INT16_C(  6792), -INT16_C( 17002), -INT16_C(  6818),  INT16_C( 13430),  INT16_C( 25307),  INT16_C( 26642), -INT16_C( 15124),
         INT16_C( 29237), -INT16_C( 24960), -INT16_C( 12208), -INT16_C( 22186),  INT16_C( 15671), -INT16_C(  6679),  INT16_C( 23884), -INT16_C( 24939) },
      UINT32_C(2105740775),
      { -INT16_C(  7478),  INT16_C( 16482),  INT16_C( 15894),  INT16_C( 10402), -INT16_C( 28762), -INT16_C(  9235),  INT16_C( 27905),  INT16_C( 21113),
        -INT16_C( 12483),  INT16_C( 30203), -INT16_C(  7156),  INT16_C( 22618), -INT16_C(  4287),  INT16_C( 10487),  INT16_C( 31484), -INT16_C( 14427),
         INT16_C(  2140),  INT16_C( 29191), -INT16_C( 21946), -INT16_C(  4965), -INT16_C( 30663),  INT16_C( 15047),  INT16_C( 16629),  INT16_C( 13196),
        -INT16_C( 30961),  INT16_C(  7336),  INT16_C(   620), -INT16_C( 21132),  INT16_C( 27634), -INT16_C(  4394),  INT16_C( 31718),  INT16_C( 17077) },
      {  INT16_C(  7478),  INT16_C( 16482),  INT16_C( 15894),  INT16_C( 31045), -INT16_C( 18353),  INT16_C(  9235),  INT16_C( 27905),  INT16_C( 21113),
         INT16_C( 12483), -INT16_C( 17274),  INT16_C(  7156),  INT16_C( 22618),  INT16_C( 26456),  INT16_C( 16614),  INT16_C(  4014), -INT16_C( 20621),
         INT16_C(  2140),  INT16_C( 29191), -INT16_C( 17002), -INT16_C(  6818),  INT16_C( 13430),  INT16_C( 25307),  INT16_C( 26642),  INT16_C( 13196),
         INT16_C( 30961), -INT16_C( 24960),  INT16_C(   620),  INT16_C( 21132),  INT16_C( 27634),  INT16_C(  4394),  INT16_C( 31718), -INT16_C( 24939) } },
    { { -INT16_C( 17021), -INT16_C( 13899),  INT16_C( 20583), -INT16_C( 24395),  INT16_C( 31960), -INT16_C( 12838),  INT16_C( 26556), -INT16_C( 13312),
        -INT16_C( 22290),  INT16_C( 23272),  INT16_C( 23723), -INT16_C( 25336), -INT16_C(  8504), -INT16_C( 20853),  INT16_C( 16729), -INT16_C(  8720),
        -INT16_C( 23042),  INT16_C( 26022),  INT16_C( 23797), -INT16_C( 13051), -INT16_C(  8232), -INT16_C( 27237), -INT16_C( 25786),  INT16_C( 13665),
         INT16_C( 18756), -INT16_C(  4209), -INT16_C( 26715),  INT16_C( 28044),  INT16_C(  6005), -INT16_C( 12517),  INT16_C(  3160),  INT16_C( 22188) },
      UINT32_C(2814071473),
      { -INT16_C( 16210), -INT16_C( 30860),  INT16_C(  4000), -INT16_C(  6628),  INT16_C( 32171), -INT16_C(  4325), -INT16_C( 21562),  INT16_C( 27614),
         INT16_C( 27202), -INT16_C( 18215), -INT16_C(  2943), -INT16_C(  9593),  INT16_C( 13056), -INT16_C( 19920), -INT16_C(  4987),  INT16_C( 13401),
        -INT16_C( 12884),  INT16_C( 19643), -INT16_C( 10275), -INT16_C( 30669),  INT16_C( 20052),  INT16_C(  6775),  INT16_C( 22009),  INT16_C( 15493),
         INT16_C( 24255),  INT16_C( 16628),  INT16_C( 31571),  INT16_C( 21274),  INT16_C( 19374),  INT16_C( 13061),  INT16_C( 24119), -INT16_C(  7321) },
      {  INT16_C( 16210), -INT16_C( 13899),  INT16_C( 20583), -INT16_C( 24395),  INT16_C( 32171),  INT16_C(  4325),  INT16_C( 26556),  INT16_C( 27614),
        -INT16_C( 22290),  INT16_C( 18215),  INT16_C( 23723), -INT16_C( 25336),  INT16_C( 13056), -INT16_C( 20853),  INT16_C(  4987), -INT16_C(  8720),
         INT16_C( 12884),  INT16_C( 19643),  INT16_C( 23797),  INT16_C( 30669),  INT16_C( 20052),  INT16_C(  6775), -INT16_C( 25786),  INT16_C( 15493),
         INT16_C( 24255),  INT16_C( 16628),  INT16_C( 31571),  INT16_C( 28044),  INT16_C(  6005),  INT16_C( 13061),  INT16_C(  3160),  INT16_C(  7321) } },
    { {  INT16_C(  8748),  INT16_C(  2352),  INT16_C( 25593),  INT16_C( 19857),  INT16_C(  2225), -INT16_C( 21657), -INT16_C(  4771),  INT16_C(  7399),
        -INT16_C(  9397), -INT16_C( 24996),  INT16_C( 30550),  INT16_C(  1266), -INT16_C(  2110), -INT16_C(  1737), -INT16_C( 24746), -INT16_C( 32036),
         INT16_C(  3265), -INT16_C( 17525),  INT16_C(  7279),  INT16_C(  8456),  INT16_C( 28708), -INT16_C( 32308), -INT16_C( 19619), -INT16_C( 22371),
        -INT16_C(  1650), -INT16_C(  7097),  INT16_C( 14704),  INT16_C( 13032),  INT16_C(  7984), -INT16_C( 31189),  INT16_C(  2238), -INT16_C( 32760) },
      UINT32_C(2218496788),
      {  INT16_C( 17327), -INT16_C( 11355),  INT16_C( 29107),  INT16_C(  4180), -INT16_C(  3804), -INT16_C( 19783),  INT16_C(   235),  INT16_C( 23446),
         INT16_C( 32313),  INT16_C( 27022), -INT16_C( 18019),  INT16_C( 23792), -INT16_C(  1855), -INT16_C( 10532),  INT16_C(  6028),  INT16_C( 15194),
        -INT16_C(   166),  INT16_C(  3599),  INT16_C( 25456), -INT16_C( 27618), -INT16_C( 10411),  INT16_C( 16454), -INT16_C(  9001),  INT16_C(  4251),
         INT16_C( 10586), -INT16_C(  2182),  INT16_C( 27363), -INT16_C( 23469),  INT16_C( 12130), -INT16_C(  4486), -INT16_C( 11194), -INT16_C( 24278) },
      {  INT16_C(  8748),  INT16_C(  2352),  INT16_C( 29107),  INT16_C( 19857),  INT16_C(  3804), -INT16_C( 21657), -INT16_C(  4771),  INT16_C(  7399),
         INT16_C( 32313),  INT16_C( 27022),  INT16_C( 30550),  INT16_C(  1266),  INT16_C(  1855), -INT16_C(  1737), -INT16_C( 24746),  INT16_C( 15194),
         INT16_C(   166),  INT16_C(  3599),  INT16_C(  7279),  INT16_C( 27618),  INT16_C( 10411),  INT16_C( 16454), -INT16_C( 19619), -INT16_C( 22371),
        -INT16_C(  1650), -INT16_C(  7097),  INT16_C( 27363),  INT16_C( 13032),  INT16_C(  7984), -INT16_C( 31189),  INT16_C(  2238),  INT16_C( 24278) } },
    { {  INT16_C( 14803),  INT16_C( 17327), -INT16_C( 12900), -INT16_C(  3625),  INT16_C(  7589),  INT16_C( 31793), -INT16_C( 12807),  INT16_C( 21389),
         INT16_C(  2038), -INT16_C(  9909), -INT16_C( 24975), -INT16_C( 11394), -INT16_C(  1842),  INT16_C(  5314), -INT16_C(  4915), -INT16_C( 24395),
         INT16_C( 25637), -INT16_C( 15900), -INT16_C( 17614), -INT16_C( 10317), -INT16_C(  6951), -INT16_C( 11693), -INT16_C(  8015), -INT16_C( 22490),
         INT16_C( 29159),  INT16_C( 22657), -INT16_C(   241), -INT16_C(  8916), -INT16_C(  4360), -INT16_C( 14862), -INT16_C( 22566), -INT16_C(   155) },
      UINT32_C(1052789004),
      {  INT16_C( 29445), -INT16_C(  8683),  INT16_C( 26712),  INT16_C(  2480), -INT16_C( 10679),  INT16_C( 12465),  INT16_C( 13127),  INT16_C( 22409),
        -INT16_C( 19150),  INT16_C( 10804),  INT16_C(  9891),  INT16_C( 32239),  INT16_C( 21966), -INT16_C(  9604),  INT16_C( 15518), -INT16_C( 23784),
         INT16_C( 11696),  INT16_C(  2177),  INT16_C( 12949), -INT16_C(  8687), -INT16_C( 15608),  INT16_C( 20495), -INT16_C( 26378),  INT16_C( 10407),
        -INT16_C(  9395), -INT16_C(  4013),  INT16_C( 16898), -INT16_C( 12179), -INT16_C(  5737),  INT16_C( 13994), -INT16_C( 15835), -INT16_C( 10791) },
      {  INT16_C( 14803),  INT16_C( 17327),  INT16_C( 26712),  INT16_C(  2480),  INT16_C(  7589),  INT16_C( 31793), -INT16_C( 12807),  INT16_C( 21389),
         INT16_C( 19150), -INT16_C(  9909), -INT16_C( 24975),  INT16_C( 32239), -INT16_C(  1842),  INT16_C(  5314),  INT16_C( 15518), -INT16_C( 24395),
         INT16_C( 25637), -INT16_C( 15900), -INT16_C( 17614), -INT16_C( 10317), -INT16_C(  6951), -INT16_C( 11693),  INT16_C( 26378),  INT16_C( 10407),
         INT16_C( 29159),  INT16_C(  4013),  INT16_C( 16898),  INT16_C( 12179),  INT16_C(  5737),  INT16_C( 13994), -INT16_C( 22566), -INT16_C(   155) } },
    { {  INT16_C( 23535), -INT16_C( 31523), -INT16_C(  4211), -INT16_C( 27293),  INT16_C( 29362), -INT16_C( 22299), -INT16_C( 29686),  INT16_C( 22480),
         INT16_C(  9064),  INT16_C( 27207), -INT16_C( 19354), -INT16_C(   710), -INT16_C(  7011), -INT16_C( 15821),  INT16_C(  3494), -INT16_C( 27240),
         INT16_C( 30056), -INT16_C(  2791),  INT16_C( 31844),  INT16_C(  5770),  INT16_C( 28910), -INT16_C(  1858), -INT16_C( 28676),  INT16_C( 25679),
        -INT16_C( 26958),  INT16_C(  6350),  INT16_C(  2122), -INT16_C(  6378),  INT16_C( 18924), -INT16_C( 27990),  INT16_C( 16982), -INT16_C( 16857) },
      UINT32_C( 481509815),
      {  INT16_C( 16061), -INT16_C( 21454), -INT16_C(  3666), -INT16_C( 21852), -INT16_C(  2944),  INT16_C( 12815), -INT16_C(  8822), -INT16_C( 10933),
         INT16_C( 25062), -INT16_C( 11588),  INT16_C( 26282),  INT16_C(   357), -INT16_C( 29528),  INT16_C( 24767),  INT16_C( 29645), -INT16_C( 29828),
        -INT16_C( 20815),  INT16_C( 24375), -INT16_C(  9313),  INT16_C(  7945),  INT16_C(  6351),  INT16_C( 23122), -INT16_C( 25098), -INT16_C(  9169),
        -INT16_C(  5122), -INT16_C( 22354),  INT16_C(  4946), -INT16_C(  1367),  INT16_C( 27040),  INT16_C( 27994), -INT16_C( 10532), -INT16_C( 29192) },
      {  INT16_C( 16061),  INT16_C( 21454),  INT16_C(  3666), -INT16_C( 27293),  INT16_C(  2944),  INT16_C( 12815), -INT16_C( 29686),  INT16_C( 10933),
         INT16_C( 25062),  INT16_C( 27207), -INT16_C( 19354), -INT16_C(   710), -INT16_C(  7011), -INT16_C( 15821),  INT16_C( 29645), -INT16_C( 27240),
         INT16_C( 20815),  INT16_C( 24375),  INT16_C( 31844),  INT16_C(  5770),  INT16_C(  6351),  INT16_C( 23122), -INT16_C( 28676),  INT16_C(  9169),
        -INT16_C( 26958),  INT16_C(  6350),  INT16_C(  4946),  INT16_C(  1367),  INT16_C( 27040), -INT16_C( 27990),  INT16_C( 16982), -INT16_C( 16857) } },
    { {  INT16_C( 12165),  INT16_C(  9452), -INT16_C(  2805), -INT16_C(  9660), -INT16_C( 27122),  INT16_C(  1076),  INT16_C( 25395),  INT16_C( 12768),
        -INT16_C( 29105), -INT16_C( 24103), -INT16_C( 31838),  INT16_C( 17051), -INT16_C(  2324), -INT16_C( 14161), -INT16_C( 22324),  INT16_C( 20821),
         INT16_C( 16855), -INT16_C(  7562), -INT16_C( 17866),  INT16_C( 17597), -INT16_C(  3760), -INT16_C( 31928),  INT16_C( 10325), -INT16_C( 23372),
        -INT16_C( 29257),  INT16_C( 22853), -INT16_C(  8176), -INT16_C(   869),  INT16_C( 19158), -INT16_C( 23612),  INT16_C(  6642), -INT16_C( 13580) },
      UINT32_C(2443995738),
      {  INT16_C( 26916),  INT16_C( 29909),  INT16_C(  7771), -INT16_C( 20233), -INT16_C( 21690), -INT16_C(   684), -INT16_C( 26311),  INT16_C( 18774),
        -INT16_C(  3719),  INT16_C( 20550),  INT16_C(  2620),  INT16_C( 12019), -INT16_C(  6364),  INT16_C( 32504), -INT16_C( 23214),  INT16_C( 30223),
        -INT16_C(  6898),  INT16_C( 27115), -INT16_C(  7677),  INT16_C( 18713),  INT16_C( 28046), -INT16_C( 14521), -INT16_C( 25338), -INT16_C( 32752),
         INT16_C( 22159), -INT16_C( 13360), -INT16_C( 15519), -INT16_C( 31239), -INT16_C(  3414), -INT16_C(  1021),  INT16_C(  5015), -INT16_C( 23181) },
      {  INT16_C( 12165),  INT16_C( 29909), -INT16_C(  2805),  INT16_C( 20233),  INT16_C( 21690),  INT16_C(  1076),  INT16_C( 26311),  INT16_C( 12768),
        -INT16_C( 29105),  INT16_C( 20550), -INT16_C( 31838),  INT16_C( 12019), -INT16_C(  2324),  INT16_C( 32504),  INT16_C( 23214),  INT16_C( 20821),
         INT16_C( 16855), -INT16_C(  7562),  INT16_C(  7677),  INT16_C( 18713), -INT16_C(  3760),  INT16_C( 14521),  INT16_C( 10325),  INT16_C( 32752),
         INT16_C( 22159),  INT16_C( 22853), -INT16_C(  8176), -INT16_C(   869),  INT16_C(  3414), -INT16_C( 23612),  INT16_C(  6642),  INT16_C( 23181) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i src = simde_mm512_loadu_epi16(test_vec[i].src);
    simde__m512i a = simde_mm512_loadu_epi16(test_vec[i].a);
    simde__m512i r = simde_mm512_mask_abs_epi16(src, test_vec[i].k, a);
    simde_test_x86_assert_equal_i16x32(r, simde_mm512_loadu_epi16(test_vec[i].r));
  }

  return 0;
}

static int
test_simde_mm512_maskz_abs_epi16 (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const simde__mmask32 k;
    const int16_t a[32];
    const int16_t r[32];
  } test_vec[] = {
    { UINT32_C( 426916685),
      {  INT16_C( 30267),  INT16_C( 27257), -INT16_C( 27872), -INT16_C( 31845), -INT16_C( 31872),  INT16_C( 14983), -INT16_C( 30143),  INT16_C(   666),
         INT16_C( 12540),  INT16_C(  6967), -INT16_C( 16243),  INT16_C(   692), -INT16_C(  5341),  INT16_C( 28883),  INT16_C( 17702),  INT16_C( 24969),
         INT16_C(   955), -INT16_C(  9013),  INT16_C( 26518),  INT16_C(  5727), -INT16_C(  6422),  INT16_C( 11089), -INT16_C(  5264),  INT16_C( 27693),
         INT16_C( 25627), -INT16_C( 22392),  INT16_C( 15396),  INT16_C( 18346),  INT16_C( 32295),  INT16_C( 19896),  INT16_C( 16835),  INT16_C( 32686) },
      {  INT16_C( 30267),  INT16_C(     0),  INT16_C( 27872),  INT16_C( 31845),  INT16_C(     0),  INT16_C(     0),  INT16_C( 30143),  INT16_C(     0),
         INT16_C( 12540),  INT16_C(  6967),  INT16_C(     0),  INT16_C(   692),  INT16_C(  5341),  INT16_C( 28883),  INT16_C(     0),  INT16_C(     0),
         INT16_C(     0),  INT16_C(  9013),  INT16_C(     0),  INT16_C(     0),  INT16_C(  6422),  INT16_C( 11089),  INT16_C(  5264),  INT16_C(     0),
         INT16_C( 25627),  INT16_C(     0),  INT16_C(     0),  INT16_C( 18346),  INT16_C( 32295),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0) } },
    { UINT32_C(3680205380),
      { -INT16_C( 17695), -INT16_C( 13327),  INT16_C( 17057),  INT16_C(  4599),  INT16_C(  9261),  INT16_C( 18558),  INT16_C(  1673), -INT16_C( 21008),
        -INT16_C( 25790),  INT16_C( 27125), -INT16_C( 21223), -INT16_C(  9034),  INT16_C( 25838),  INT16_C( 13147), -INT16_C( 18722), -INT16_C( 16626),
        -INT16_C(   143),  INT16_C(  4747), -INT16_C( 32190),  INT16_C( 28451), -INT16_C( 24154),  INT16_C( 12216), -INT16_C( 22361), -INT16_C(  5667),
        -INT16_C( 11709),  INT16_C( 23634),  INT16_C(  2175),  INT16_C( 27961), -INT16_C( 27539),  INT16_C( 19360), -INT16_C( 20917), -INT16_C( 17397) },
      {  INT16_C(     0),  INT16_C(     0),  INT16_C( 17057),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(  1673),  INT16_C(     0),
         INT16_C(     0),  INT16_C( 27125),  INT16_C(     0),  INT16_C(  9034),  INT16_C( 25838),  INT16_C( 13147),  INT16_C( 18722),  INT16_C(     0),
         INT16_C(   143),  INT16_C(  4747),  INT16_C(     0),  INT16_C( 28451),  INT16_C( 24154),  INT16_C(     0),  INT16_C( 22361),  INT16_C(     0),
         INT16_C( 11709),  INT16_C( 23634),  INT16_C(     0),  INT16_C( 27961),  INT16_C( 27539),  INT16_C(     0),  INT16_C( 20917),  INT16_C( 17397) } },
    { UINT32_C(4040070830),
      { -INT16_C(  3816), -INT16_C( 16801),  INT16_C(  6035),  INT16_C( 15086), -INT16_C( 13376),  INT16_C(   804),  INT16_C( 30365),  INT16_C(  7264),
        -INT16_C( 26241), -INT16_C(  4983),  INT16_C( 10797),  INT16_C( 30775),  INT16_C( 17112), -INT16_C( 31180),  INT16_C(   728), -INT16_C(  3978),
        -INT16_C( 10508), -INT16_C( 30801), -INT16_C( 25107), -INT16_C( 21055), -INT16_C(  6808),  INT16_C(  1457),  INT16_C(  4444), -INT16_C(  9439),
        -INT16_C( 21846), -INT16_C( 10297), -INT16_C(   300), -INT16_C( 21168), -INT16_C( 31679),  INT16_C(  6451), -INT16_C( 21881),  INT16_C( 31498) },
      {  INT16_C(     0),  INT16_C( 16801),  INT16_C(  6035),  INT16_C( 15086),  INT16_C(     0),  INT16_C(   804),  INT16_C(     0),  INT16_C(  7264),
         INT16_C(     0),  INT16_C(  4983),  INT16_C( 10797),  INT16_C(     0),  INT16_C( 17112),  INT16_C(     0),  INT16_C(     0),  INT16_C(  3978),
         INT16_C(     0),  INT16_C( 30801),  INT16_C( 25107),  INT16_C( 21055),  INT16_C(     0),  INT16_C(     0),  INT16_C(  4444),  INT16_C(  9439),
         INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C( 31679),  INT16_C(  6451),  INT16_C( 21881),  INT16_C( 31498) } },
    { UINT32_C(1828895104),
      { -INT16_C( 15530), -INT16_C( 16869), -INT16_C( 13143),  INT16_C(  1475), -INT16_C(  6947), -INT16_C( 30752), -INT16_C( 22642),  INT16_C( 25438),
        -INT16_C( 20827), -INT16_C(  6640),  INT16_C( 17203), -INT16_C( 17920),  INT16_C(  2797),  INT16_C( 27957),  INT16_C( 14275),  INT16_C(  6619),
        -INT16_C(  2310), -INT16_C( 23593), -INT16_C( 25918), -INT16_C( 24664), -INT16_C( 30594),  INT16_C(  3110), -INT16_C( 31697), -INT16_C( 10897),
         INT16_C( 32563),  INT16_C( 26299), -INT16_C( 17469), -INT16_C( 20448),  INT16_C( 21957), -INT16_C( 30690), -INT16_C(  1652), -INT16_C( 31071) },
      {  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C( 25438),
         INT16_C( 20827),  INT16_C(     0),  INT16_C(     0),  INT16_C( 17920),  INT16_C(  2797),  INT16_C( 27957),  INT16_C(     0),  INT16_C(  6619),
         INT16_C(     0),  INT16_C( 23593),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),
         INT16_C( 32563),  INT16_C(     0),  INT16_C( 17469),  INT16_C( 20448),  INT16_C(     0),  INT16_C( 30690),  INT16_C(  1652),  INT16_C(     0) } },
    { UINT32_C(2972350703),
      { -INT16_C( 11758), -INT16_C( 28592),  INT16_C( 30299), -INT16_C( 30051),  INT16_C(  3322),  INT16_C( 11615),  INT16_C(  7052),  INT16_C( 20371),
        -INT16_C( 19498), -INT16_C( 25345),  INT16_C(  7432), -INT16_C( 27612), -INT16_C( 14826),  INT16_C(  1307),  INT16_C( 17726),  INT16_C( 20918),
         INT16_C(  1559),  INT16_C( 29409),  INT16_C( 32380),  INT16_C( 30717),  INT16_C( 23691),  INT16_C(  6052),  INT16_C( 14455),  INT16_C( 20070),
         INT16_C( 26091), -INT16_C(  2838),  INT16_C(  3715), -INT16_C( 26232), -INT16_C( 23596),  INT16_C(  5023),  INT16_C( 21992),  INT16_C(   100) },
      {  INT16_C( 11758),  INT16_C( 28592),  INT16_C( 30299),  INT16_C( 30051),  INT16_C(     0),  INT16_C( 11615),  INT16_C(  7052),  INT16_C( 20371),
         INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C( 27612),  INT16_C( 14826),  INT16_C(  1307),  INT16_C( 17726),  INT16_C(     0),
         INT16_C(     0),  INT16_C( 29409),  INT16_C(     0),  INT16_C( 30717),  INT16_C(     0),  INT16_C(  6052),  INT16_C(     0),  INT16_C(     0),
         INT16_C( 26091),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C( 23596),  INT16_C(  5023),  INT16_C(     0),  INT16_C(   100) } },
    { UINT32_C(3631367516),
      {  INT16_C( 28612),  INT16_C( 20303), -INT16_C(  2868),  INT16_C( 17254), -INT16_C( 13268),  INT16_C(  6033),  INT16_C( 31537), -INT16_C( 19445),
        -INT16_C( 27510),  INT16_C( 24142), -INT16_C(  4809),  INT16_C(  8305), -INT16_C( 10942), -INT16_C( 25056), -INT16_C( 28133), -INT16_C(  8329),
        -INT16_C( 14846), -INT16_C( 12754), -INT16_C( 27462), -INT16_C(  6639), -INT16_C( 23712), -INT16_C( 28162),  INT16_C(  2334), -INT16_C( 22458),
        -INT16_C( 27491), -INT16_C( 11001),  INT16_C( 30849), -INT16_C( 15371),  INT16_C(  5454),  INT16_C( 26978), -INT16_C(  9817), -INT16_C( 22200) },
      {  INT16_C(     0),  INT16_C(     0),  INT16_C(  2868),  INT16_C( 17254),  INT16_C( 13268),  INT16_C(     0),  INT16_C( 31537),  INT16_C(     0),
         INT16_C( 27510),  INT16_C(     0),  INT16_C(  4809),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C( 28133),  INT16_C(     0),
         INT16_C(     0),  INT16_C( 12754),  INT16_C(     0),  INT16_C(     0),  INT16_C( 23712),  INT16_C( 28162),  INT16_C(  2334),  INT16_C(     0),
         INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C( 15371),  INT16_C(  5454),  INT16_C(     0),  INT16_C(  9817),  INT16_C( 22200) } },
    { UINT32_C(1517778591),
      { -INT16_C( 30454),  INT16_C( 27200),  INT16_C( 15916),  INT16_C( 19195),  INT16_C( 16712), -INT16_C(  6669), -INT16_C(  1323),  INT16_C( 22202),
        -INT16_C( 20622), -INT16_C( 16358),  INT16_C( 31940),  INT16_C( 27689),  INT16_C( 29013), -INT16_C(  3051), -INT16_C( 29209), -INT16_C(  3762),
        -INT16_C( 28906),  INT16_C( 16987),  INT16_C( 22477),  INT16_C(  5516),  INT16_C( 32664),  INT16_C( 28411), -INT16_C( 19079), -INT16_C(  4924),
        -INT16_C(  8603),  INT16_C( 10668), -INT16_C( 10662), -INT16_C( 20587), -INT16_C( 21689),  INT16_C( 12196), -INT16_C(  3528),  INT16_C( 20000) },
      {  INT16_C( 30454),  INT16_C( 27200),  INT16_C( 15916),  INT16_C( 19195),  INT16_C( 16712),  INT16_C(     0),  INT16_C(     0),  INT16_C( 22202),
         INT16_C(     0),  INT16_C( 16358),  INT16_C( 31940),  INT16_C(     0),  INT16_C( 29013),  INT16_C(  3051),  INT16_C( 29209),  INT16_C(     0),
         INT16_C( 28906),  INT16_C( 16987),  INT16_C( 22477),  INT16_C(     0),  INT16_C( 32664),  INT16_C( 28411),  INT16_C( 19079),  INT16_C(     0),
         INT16_C(     0),  INT16_C( 10668),  INT16_C(     0),  INT16_C( 20587),  INT16_C( 21689),  INT16_C(     0),  INT16_C(  3528),  INT16_C(     0) } },
    { UINT32_C(1334869121),
      {  INT16_C(  7379),  INT16_C( 27492),  INT16_C( 24476),  INT16_C(  5593), -INT16_C( 25067),  INT16_C( 31233), -INT16_C( 20868), -INT16_C( 10333),
         INT16_C( 14724), -INT16_C( 13434),  INT16_C( 10980),  INT16_C(  7418),  INT16_C(  6941), -INT16_C( 24982), -INT16_C(  1385),  INT16_C( 27373),
         INT16_C( 21014), -INT16_C( 19755), -INT16_C( 20559), -INT16_C( 14648), -INT16_C( 14003), -INT16_C( 14016), -INT16_C(  7049), -INT16_C(  1120),
         INT16_C( 10013),  INT16_C(   455), -INT16_C( 16047),  INT16_C( 28189), -INT16_C( 30756),  INT16_C( 29453), -INT16_C(  1407), -INT16_C( 26659) },
      {  INT16_C(  7379),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C( 10333),
         INT16_C(     0),  INT16_C(     0),  INT16_C( 10980),  INT16_C(  7418),  INT16_C(  6941),  INT16_C( 24982),  INT16_C(  1385),  INT16_C(     0),
         INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C( 14003),  INT16_C(     0),  INT16_C(     0),  INT16_C(  1120),
         INT16_C( 10013),  INT16_C(   455),  INT16_C( 16047),  INT16_C( 28189),  INT16_C(     0),  INT16_C(     0),  INT16_C(  1407),  INT16_C(     0) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i a = simde_mm512_loadu_epi16(test_vec[i].a);
    simde__m512i r = simde_mm512_maskz_abs_epi16(test_vec[i].k, a);
    simde_test_x86_assert_equal_i16x32(r, simde_mm512_loadu_epi16(test_vec[i].r));
  }

  return 0;
}

static int
test_simde_mm512_add_epi8 (SIMDE_MUNIT_TEST_ARGS) {
  struct {
    const int8_t a[64];
    const int8_t b[64];
    const int8_t r[64];
  } test_vec[] = {
    { {  INT8_C(  16), -INT8_C(  23), -INT8_C(  42), -INT8_C( 110), -INT8_C(  66), -INT8_C(  42),  INT8_C(  81), -INT8_C( 107),
        -INT8_C(  64), -INT8_C(  89),  INT8_C( 109),  INT8_C(  69),  INT8_C(  32), -INT8_C(  26), -INT8_C(  52), -INT8_C( 121),
        -INT8_C(  91), -INT8_C( 119),  INT8_C(  20), -INT8_C( 127),  INT8_C(  41), -INT8_C(  19),  INT8_C(  18),  INT8_C(   3),
         INT8_C( 103),  INT8_C( 122),  INT8_C(  63), -INT8_C(  75),  INT8_C(  40), -INT8_C(  38), -INT8_C(  44),  INT8_C(  56),
        -INT8_C(  61), -INT8_C(  86), -INT8_C(  54), -INT8_C( 127),      INT8_MIN,  INT8_C(  27),  INT8_C(  22),  INT8_C(  64),
        -INT8_C(  61), -INT8_C( 125), -INT8_C( 122), -INT8_C(  29),  INT8_C( 105),  INT8_C(  82),  INT8_C( 106),  INT8_C(  14),
        -INT8_C(  37),  INT8_C( 126), -INT8_C( 113),  INT8_C(   5),  INT8_C( 107), -INT8_C(  95),  INT8_C(   8), -INT8_C(  46),
         INT8_C(  27),  INT8_C(  71), -INT8_C( 120),  INT8_C(  67),  INT8_C(  33),  INT8_C(  92),  INT8_C( 124), -INT8_C(  28) },
      {  INT8_C(   6),  INT8_C(  70),  INT8_C( 101), -INT8_C( 122),  INT8_C(  98),  INT8_C( 123), -INT8_C(  58),  INT8_C(  37),
        -INT8_C(   1),  INT8_C(  76),  INT8_C(   8),  INT8_C( 104), -INT8_C(  98),  INT8_C( 114),  INT8_C( 119),  INT8_C( 122),
        -INT8_C(  16),  INT8_C(   6),      INT8_MAX,  INT8_C(  91), -INT8_C(  88), -INT8_C( 121),  INT8_C(  45), -INT8_C(  61),
        -INT8_C(  50), -INT8_C(  75),  INT8_C(   7), -INT8_C(  17),  INT8_C(  17), -INT8_C( 125), -INT8_C(  45),  INT8_C(  23),
        -INT8_C(  55),  INT8_C(  56), -INT8_C(  99),  INT8_C(  43), -INT8_C(  77),  INT8_C( 100),  INT8_C(  80), -INT8_C(  78),
        -INT8_C(  80),  INT8_C(  88),  INT8_C(  27),  INT8_C(  79), -INT8_C(  54), -INT8_C( 110), -INT8_C(  55), -INT8_C(  70),
        -INT8_C( 104),  INT8_C(  72),  INT8_C(  21),  INT8_C(  64), -INT8_C(  49),  INT8_C(  67),  INT8_C(   4), -INT8_C(  99),
        -INT8_C(   8),  INT8_C(  11), -INT8_C( 116),  INT8_C(  10), -INT8_C( 114),  INT8_C(  95),  INT8_C(  33),  INT8_C(  87) },
      {  INT8_C(  22),  INT8_C(  47),  INT8_C(  59),  INT8_C(  24),  INT8_C(  32),  INT8_C(  81),  INT8_C(  23), -INT8_C(  70),
        -INT8_C(  65), -INT8_C(  13),  INT8_C( 117), -INT8_C(  83), -INT8_C(  66),  INT8_C(  88),  INT8_C(  67),  INT8_C(   1),
        -INT8_C( 107), -INT8_C( 113), -INT8_C( 109), -INT8_C(  36), -INT8_C(  47),  INT8_C( 116),  INT8_C(  63), -INT8_C(  58),
         INT8_C(  53),  INT8_C(  47),  INT8_C(  70), -INT8_C(  92),  INT8_C(  57),  INT8_C(  93), -INT8_C(  89),  INT8_C(  79),
        -INT8_C( 116), -INT8_C(  30),  INT8_C( 103), -INT8_C(  84),  INT8_C(  51),      INT8_MAX,  INT8_C( 102), -INT8_C(  14),
         INT8_C( 115), -INT8_C(  37), -INT8_C(  95),  INT8_C(  50),  INT8_C(  51), -INT8_C(  28),  INT8_C(  51), -INT8_C(  56),
         INT8_C( 115), -INT8_C(  58), -INT8_C(  92),  INT8_C(  69),  INT8_C(  58), -INT8_C(  28),  INT8_C(  12),  INT8_C( 111),
         INT8_C(  19),  INT8_C(  82),  INT8_C(  20),  INT8_C(  77), -INT8_C(  81), -INT8_C(  69), -INT8_C(  99),  INT8_C(  59) } },
    { { -INT8_C( 105), -INT8_C(  65), -INT8_C( 125),  INT8_C(  74),  INT8_C(  35), -INT8_C(  45), -INT8_C(   3), -INT8_C(  45),
         INT8_C(  44),  INT8_C(  24),  INT8_C(  34), -INT8_C(  10), -INT8_C(  86), -INT8_C(  21), -INT8_C(  79),  INT8_C(  66),
         INT8_C(  51), -INT8_C(  58), -INT8_C( 125),  INT8_C(   2),  INT8_C(   9), -INT8_C( 121), -INT8_C(  97),  INT8_C(   2),
        -INT8_C( 110),  INT8_C(  43),  INT8_C(  12),  INT8_C(  32), -INT8_C( 118),  INT8_C(  45),  INT8_C( 119),  INT8_C(  33),
        -INT8_C(  20), -INT8_C(   6),  INT8_C( 108),  INT8_C(  15), -INT8_C(  50),  INT8_C( 105), -INT8_C(  29), -INT8_C(   6),
        -INT8_C( 127),  INT8_C(   5), -INT8_C(  16),  INT8_C(  43), -INT8_C(  15), -INT8_C(  95),  INT8_C( 109),  INT8_C(  36),
         INT8_C( 104), -INT8_C(  16),  INT8_C(  39),  INT8_C( 113),  INT8_C( 119), -INT8_C(  58),  INT8_C( 115),  INT8_C(   9),
        -INT8_C(  14),      INT8_MAX,  INT8_C(  41),  INT8_C( 124), -INT8_C(  83), -INT8_C(  95), -INT8_C(  98), -INT8_C( 103) },
      { -INT8_C( 101),  INT8_C(  10), -INT8_C(  87),  INT8_C( 105),  INT8_C( 115), -INT8_C( 116),  INT8_C(  99), -INT8_C(  12),
        -INT8_C( 111),  INT8_C(  84),  INT8_C(  31), -INT8_C( 126), -INT8_C(  11), -INT8_C( 116), -INT8_C(  89),  INT8_C(  93),
         INT8_C( 125), -INT8_C(  50), -INT8_C(  49), -INT8_C(  12), -INT8_C( 108),  INT8_C(  66), -INT8_C(   2), -INT8_C( 122),
        -INT8_C(  62),  INT8_C(  39),  INT8_C(   3),  INT8_C( 111), -INT8_C(  56), -INT8_C(  95),  INT8_C(   8),  INT8_C( 100),
        -INT8_C(  85), -INT8_C(  79), -INT8_C(  51),  INT8_C(  30),  INT8_C(  61),  INT8_C(  49),  INT8_C(  18), -INT8_C(  49),
        -INT8_C( 123),  INT8_C(  49),  INT8_C(  81),  INT8_C( 122), -INT8_C(  67), -INT8_C(   8), -INT8_C(  40),  INT8_C(  58),
        -INT8_C(  58), -INT8_C(  89),  INT8_C(  47),  INT8_C(  91), -INT8_C(  23),  INT8_C(  45), -INT8_C(  31), -INT8_C(  85),
         INT8_C(  84), -INT8_C(  28),  INT8_C(  26),  INT8_C(  29), -INT8_C( 123),  INT8_C(  35), -INT8_C( 127),  INT8_C(  48) },
      {  INT8_C(  50), -INT8_C(  55),  INT8_C(  44), -INT8_C(  77), -INT8_C( 106),  INT8_C(  95),  INT8_C(  96), -INT8_C(  57),
        -INT8_C(  67),  INT8_C( 108),  INT8_C(  65),  INT8_C( 120), -INT8_C(  97),  INT8_C( 119),  INT8_C(  88), -INT8_C(  97),
        -INT8_C(  80), -INT8_C( 108),  INT8_C(  82), -INT8_C(  10), -INT8_C(  99), -INT8_C(  55), -INT8_C(  99), -INT8_C( 120),
         INT8_C(  84),  INT8_C(  82),  INT8_C(  15), -INT8_C( 113),  INT8_C(  82), -INT8_C(  50),      INT8_MAX, -INT8_C( 123),
        -INT8_C( 105), -INT8_C(  85),  INT8_C(  57),  INT8_C(  45),  INT8_C(  11), -INT8_C( 102), -INT8_C(  11), -INT8_C(  55),
         INT8_C(   6),  INT8_C(  54),  INT8_C(  65), -INT8_C(  91), -INT8_C(  82), -INT8_C( 103),  INT8_C(  69),  INT8_C(  94),
         INT8_C(  46), -INT8_C( 105),  INT8_C(  86), -INT8_C(  52),  INT8_C(  96), -INT8_C(  13),  INT8_C(  84), -INT8_C(  76),
         INT8_C(  70),  INT8_C(  99),  INT8_C(  67), -INT8_C( 103),  INT8_C(  50), -INT8_C(  60),  INT8_C(  31), -INT8_C(  55) } },
    { { -INT8_C(  44),  INT8_C(  78),  INT8_C(  78),  INT8_C(  18),      INT8_MAX,  INT8_C(  96), -INT8_C(  31),  INT8_C(   4),
        -INT8_C( 111),  INT8_C(  50),      INT8_MAX,  INT8_C(  79),  INT8_C(  43),  INT8_C(  87), -INT8_C( 119), -INT8_C(  15),
        -INT8_C(   2), -INT8_C(  72),  INT8_C(  76), -INT8_C(  25), -INT8_C(  27),  INT8_C(  46), -INT8_C( 109),  INT8_C(  58),
         INT8_C(  18), -INT8_C(  83),  INT8_C(  87), -INT8_C( 104), -INT8_C(  48), -INT8_C(  40), -INT8_C(  56), -INT8_C(  91),
         INT8_C(  38),  INT8_C(  23), -INT8_C(  73), -INT8_C(  90),  INT8_C( 119), -INT8_C( 104), -INT8_C(  86),  INT8_C(   9),
        -INT8_C(  54),  INT8_C(  41),  INT8_C(  88), -INT8_C(  11),      INT8_MIN, -INT8_C(  31), -INT8_C(  25),  INT8_C( 126),
        -INT8_C( 102),  INT8_C(  51),  INT8_C( 102),      INT8_MAX,  INT8_C(  97), -INT8_C(   7), -INT8_C(  71),  INT8_C( 116),
        -INT8_C(  90),  INT8_C(  16),  INT8_C(  12),  INT8_C( 119), -INT8_C(  24), -INT8_C(  44),  INT8_C(  28),  INT8_C(  15) },
      { -INT8_C(  21), -INT8_C(  45), -INT8_C(  75),  INT8_C(  99),  INT8_C( 107),  INT8_C(  95),  INT8_C( 108),  INT8_C(  53),
        -INT8_C( 119), -INT8_C(  60),  INT8_C(  43),  INT8_C(   9), -INT8_C(  91),  INT8_C(  18), -INT8_C( 120),  INT8_C(  63),
         INT8_C(  69), -INT8_C(  18), -INT8_C(  65), -INT8_C(  89), -INT8_C(  25),  INT8_C( 120),  INT8_C(  27), -INT8_C( 115),
        -INT8_C( 119),  INT8_C(  39),  INT8_C(   4),  INT8_C( 113), -INT8_C(   5),  INT8_C(  32),      INT8_MIN, -INT8_C(  25),
        -INT8_C(  13),  INT8_C(  53),  INT8_C(  74),  INT8_C(  94), -INT8_C( 107), -INT8_C(  74), -INT8_C( 108),  INT8_C(  30),
         INT8_C( 122), -INT8_C(  65),  INT8_C(  39),  INT8_C(  31), -INT8_C(  47), -INT8_C(  81),  INT8_C(  95),  INT8_C(  22),
        -INT8_C(  99),  INT8_C(  30), -INT8_C(  67), -INT8_C( 124), -INT8_C( 106), -INT8_C(  40),  INT8_C(  18),  INT8_C(  31),
        -INT8_C(   1),  INT8_C(  22), -INT8_C( 111), -INT8_C(   5),  INT8_C(  55),  INT8_C(  17), -INT8_C(  30),  INT8_C(  42) },
      { -INT8_C(  65),  INT8_C(  33),  INT8_C(   3),  INT8_C( 117), -INT8_C(  22), -INT8_C(  65),  INT8_C(  77),  INT8_C(  57),
         INT8_C(  26), -INT8_C(  10), -INT8_C(  86),  INT8_C(  88), -INT8_C(  48),  INT8_C( 105),  INT8_C(  17),  INT8_C(  48),
         INT8_C(  67), -INT8_C(  90),  INT8_C(  11), -INT8_C( 114), -INT8_C(  52), -INT8_C(  90), -INT8_C(  82), -INT8_C(  57),
        -INT8_C( 101), -INT8_C(  44),  INT8_C(  91),  INT8_C(   9), -INT8_C(  53), -INT8_C(   8),  INT8_C(  72), -INT8_C( 116),
         INT8_C(  25),  INT8_C(  76),  INT8_C(   1),  INT8_C(   4),  INT8_C(  12),  INT8_C(  78),  INT8_C(  62),  INT8_C(  39),
         INT8_C(  68), -INT8_C(  24),      INT8_MAX,  INT8_C(  20),  INT8_C(  81), -INT8_C( 112),  INT8_C(  70), -INT8_C( 108),
         INT8_C(  55),  INT8_C(  81),  INT8_C(  35),  INT8_C(   3), -INT8_C(   9), -INT8_C(  47), -INT8_C(  53), -INT8_C( 109),
        -INT8_C(  91),  INT8_C(  38), -INT8_C(  99),  INT8_C( 114),  INT8_C(  31), -INT8_C(  27), -INT8_C(   2),  INT8_C(  57) } },
    { {  INT8_C(  71),  INT8_C(  44), -INT8_C( 119), -INT8_C(  36), -INT8_C(  30),  INT8_C(  29), -INT8_C(   6),  INT8_C(  92),
        -INT8_C(  36),  INT8_C(  33),  INT8_C( 123), -INT8_C(  83), -INT8_C(  47), -INT8_C(  38), -INT8_C(  61),  INT8_C( 110),
        -INT8_C(   8), -INT8_C( 127), -INT8_C(  13), -INT8_C( 113),  INT8_C(  89),  INT8_C(   5), -INT8_C(  82),  INT8_C(  89),
         INT8_C(  27),  INT8_C(  63),  INT8_C(  84),  INT8_C(  82),  INT8_C(  81),  INT8_C(  54),  INT8_C( 125), -INT8_C( 104),
         INT8_C(  98),  INT8_C(   6),  INT8_C( 116),  INT8_C(  68),  INT8_C(  35),  INT8_C( 110), -INT8_C(  96), -INT8_C(   1),
        -INT8_C( 113),  INT8_C(  27), -INT8_C(  84),  INT8_C(  96), -INT8_C(  10),  INT8_C( 111), -INT8_C(  49), -INT8_C(  18),
        -INT8_C(  16), -INT8_C(  62),  INT8_C( 125),  INT8_C(  74), -INT8_C(  57),  INT8_C(  44), -INT8_C(  93), -INT8_C(  30),
         INT8_C( 107), -INT8_C(   9),  INT8_C(  53), -INT8_C(  68),  INT8_C(  45), -INT8_C(  78),  INT8_C(  84), -INT8_C( 113) },
      { -INT8_C(  72), -INT8_C(  56), -INT8_C(  45), -INT8_C(  37),  INT8_C(  54),  INT8_C( 115), -INT8_C(  38), -INT8_C(  58),
        -INT8_C( 114), -INT8_C( 122),  INT8_C(  38), -INT8_C( 124), -INT8_C(  11), -INT8_C(  11),  INT8_C( 115), -INT8_C(  26),
        -INT8_C(  73), -INT8_C(  16),  INT8_C(  48),  INT8_C( 126),  INT8_C(  28), -INT8_C(  45),  INT8_C(  97), -INT8_C( 120),
        -INT8_C(  54), -INT8_C( 106),  INT8_C(  68), -INT8_C(   9),  INT8_C(  72), -INT8_C( 103), -INT8_C( 122),  INT8_C(   0),
         INT8_C(  97),  INT8_C(  89), -INT8_C(  37), -INT8_C( 104), -INT8_C(  52), -INT8_C(  75),  INT8_C(  94),  INT8_C(  90),
         INT8_C(  59), -INT8_C( 124), -INT8_C(  33),  INT8_C(  48),  INT8_C( 122),  INT8_C(  82),  INT8_C(  22),  INT8_C(  49),
         INT8_C(  66),  INT8_C(  70), -INT8_C(  80),  INT8_C(  95),  INT8_C(  25),  INT8_C(  17), -INT8_C(  25), -INT8_C(  29),
        -INT8_C(  89),  INT8_C(  43), -INT8_C(  38), -INT8_C(  17), -INT8_C(  60),  INT8_C(  96), -INT8_C(  17),  INT8_C(  38) },
      { -INT8_C(   1), -INT8_C(  12),  INT8_C(  92), -INT8_C(  73),  INT8_C(  24), -INT8_C( 112), -INT8_C(  44),  INT8_C(  34),
         INT8_C( 106), -INT8_C(  89), -INT8_C(  95),  INT8_C(  49), -INT8_C(  58), -INT8_C(  49),  INT8_C(  54),  INT8_C(  84),
        -INT8_C(  81),  INT8_C( 113),  INT8_C(  35),  INT8_C(  13),  INT8_C( 117), -INT8_C(  40),  INT8_C(  15), -INT8_C(  31),
        -INT8_C(  27), -INT8_C(  43), -INT8_C( 104),  INT8_C(  73), -INT8_C( 103), -INT8_C(  49),  INT8_C(   3), -INT8_C( 104),
        -INT8_C(  61),  INT8_C(  95),  INT8_C(  79), -INT8_C(  36), -INT8_C(  17),  INT8_C(  35), -INT8_C(   2),  INT8_C(  89),
        -INT8_C(  54), -INT8_C(  97), -INT8_C( 117), -INT8_C( 112),  INT8_C( 112), -INT8_C(  63), -INT8_C(  27),  INT8_C(  31),
         INT8_C(  50),  INT8_C(   8),  INT8_C(  45), -INT8_C(  87), -INT8_C(  32),  INT8_C(  61), -INT8_C( 118), -INT8_C(  59),
         INT8_C(  18),  INT8_C(  34),  INT8_C(  15), -INT8_C(  85), -INT8_C(  15),  INT8_C(  18),  INT8_C(  67), -INT8_C(  75) } },
    { { -INT8_C(  71), -INT8_C(  54), -INT8_C(  66), -INT8_C( 123),      INT8_MAX,  INT8_C(  28), -INT8_C(  32), -INT8_C(  70),
        -INT8_C(  96), -INT8_C(  65), -INT8_C(  22),  INT8_C(  26),  INT8_C(  17),  INT8_C(   1),  INT8_C(  76),  INT8_C(  83),
         INT8_C(  71), -INT8_C(   4), -INT8_C(  78),  INT8_C(  97),  INT8_C(  13), -INT8_C( 103),  INT8_C(  68), -INT8_C(  76),
        -INT8_C(  59),  INT8_C(  31), -INT8_C(  93), -INT8_C( 119),      INT8_MAX, -INT8_C( 110), -INT8_C(  81),  INT8_C(  57),
         INT8_C(  92),  INT8_C( 109), -INT8_C(  66), -INT8_C(  37), -INT8_C( 119), -INT8_C(  98), -INT8_C( 107),  INT8_C(  42),
         INT8_C(  93),      INT8_MAX,  INT8_C(  68),  INT8_C( 110),      INT8_MIN, -INT8_C( 112), -INT8_C(  62), -INT8_C(  56),
        -INT8_C( 116),  INT8_C( 116),  INT8_C(  41), -INT8_C( 103),  INT8_C(  14),  INT8_C( 109),  INT8_C(  77), -INT8_C(  45),
        -INT8_C( 116), -INT8_C(  16),  INT8_C(  92),  INT8_C(  12), -INT8_C( 126),  INT8_C(  12),  INT8_C(  69), -INT8_C(  34) },
      {  INT8_C( 121),  INT8_C(   3), -INT8_C(  71),  INT8_C(   3), -INT8_C(  94),  INT8_C(  78),  INT8_C(  45), -INT8_C(   1),
        -INT8_C(  50),  INT8_C( 113),  INT8_C( 110),  INT8_C(  78),  INT8_C(   2),  INT8_C(  48),  INT8_C(  22), -INT8_C( 114),
        -INT8_C(  92),  INT8_C(  63),  INT8_C(  40), -INT8_C(  78), -INT8_C(  83),  INT8_C( 117), -INT8_C( 123),  INT8_C(  57),
         INT8_C( 102), -INT8_C(  30),  INT8_C(  69), -INT8_C(  24), -INT8_C(  18), -INT8_C( 118), -INT8_C(  57),  INT8_C( 103),
        -INT8_C( 114),      INT8_MIN,  INT8_C( 106),  INT8_C(  48), -INT8_C(  49), -INT8_C( 105),  INT8_C(  47), -INT8_C(  99),
         INT8_C(   9), -INT8_C(  99), -INT8_C(  21),  INT8_C(  11), -INT8_C(  51),  INT8_C(   2), -INT8_C( 103),  INT8_C( 114),
         INT8_C(  65), -INT8_C(  63),  INT8_C(  36), -INT8_C(  18),  INT8_C(  55), -INT8_C(  86),  INT8_C(  40), -INT8_C(  99),
        -INT8_C( 116),  INT8_C( 109), -INT8_C( 123),  INT8_C( 122), -INT8_C(   8),  INT8_C(  76), -INT8_C(  31), -INT8_C( 122) },
      {  INT8_C(  50), -INT8_C(  51),  INT8_C( 119), -INT8_C( 120),  INT8_C(  33),  INT8_C( 106),  INT8_C(  13), -INT8_C(  71),
         INT8_C( 110),  INT8_C(  48),  INT8_C(  88),  INT8_C( 104),  INT8_C(  19),  INT8_C(  49),  INT8_C(  98), -INT8_C(  31),
        -INT8_C(  21),  INT8_C(  59), -INT8_C(  38),  INT8_C(  19), -INT8_C(  70),  INT8_C(  14), -INT8_C(  55), -INT8_C(  19),
         INT8_C(  43),  INT8_C(   1), -INT8_C(  24),  INT8_C( 113),  INT8_C( 109),  INT8_C(  28),  INT8_C( 118), -INT8_C(  96),
        -INT8_C(  22), -INT8_C(  19),  INT8_C(  40),  INT8_C(  11),  INT8_C(  88),  INT8_C(  53), -INT8_C(  60), -INT8_C(  57),
         INT8_C( 102),  INT8_C(  28),  INT8_C(  47),  INT8_C( 121),  INT8_C(  77), -INT8_C( 110),  INT8_C(  91),  INT8_C(  58),
        -INT8_C(  51),  INT8_C(  53),  INT8_C(  77), -INT8_C( 121),  INT8_C(  69),  INT8_C(  23),  INT8_C( 117),  INT8_C( 112),
         INT8_C(  24),  INT8_C(  93), -INT8_C(  31), -INT8_C( 122),  INT8_C( 122),  INT8_C(  88),  INT8_C(  38),  INT8_C( 100) } },
    { { -INT8_C(  51),  INT8_C(  76), -INT8_C(  74), -INT8_C( 100), -INT8_C(  29), -INT8_C(  27),  INT8_C(  57), -INT8_C(  20),
        -INT8_C( 125),  INT8_C(  36), -INT8_C(   9),  INT8_C(  80),  INT8_C(  38), -INT8_C( 111), -INT8_C(  62),  INT8_C( 104),
         INT8_C(  82), -INT8_C(  25),  INT8_C(  86), -INT8_C( 119), -INT8_C( 111),  INT8_C( 126),  INT8_C(  38),  INT8_C(  29),
        -INT8_C(  20), -INT8_C(  84), -INT8_C( 105), -INT8_C(  28), -INT8_C(   8),  INT8_C( 120),  INT8_C( 106), -INT8_C(  59),
        -INT8_C(  60),  INT8_C(  32),  INT8_C(  97), -INT8_C(  88),  INT8_C(   5), -INT8_C( 102), -INT8_C( 108), -INT8_C( 120),
        -INT8_C(  65), -INT8_C( 116), -INT8_C(  39), -INT8_C(  27),  INT8_C(  29), -INT8_C( 101),  INT8_C(  77),  INT8_C( 111),
        -INT8_C( 126), -INT8_C(  92), -INT8_C(   7),  INT8_C(  19),  INT8_C(  34),  INT8_C(  31),  INT8_C(  48),  INT8_C(  14),
        -INT8_C(  53), -INT8_C(  57), -INT8_C(  14), -INT8_C(  60),  INT8_C(  64),  INT8_C(  92), -INT8_C( 119),  INT8_C(   4) },
      {  INT8_C( 124), -INT8_C(  21), -INT8_C(  84), -INT8_C( 126), -INT8_C( 123),  INT8_C(  65),  INT8_C(  10),  INT8_C(  68),
        -INT8_C(  51), -INT8_C(  29),  INT8_C(  42), -INT8_C(  22),      INT8_MAX,  INT8_C( 119),  INT8_C(  89),  INT8_C(   1),
         INT8_C(  27),  INT8_C(  82),  INT8_C(  21),  INT8_C(  62),  INT8_C( 114),  INT8_C(  69),  INT8_C(  76),  INT8_C(  61),
         INT8_C(  13),  INT8_C(  63),  INT8_C(   1),  INT8_C(  77), -INT8_C( 101), -INT8_C( 117),  INT8_C(  81),  INT8_C(  24),
         INT8_C( 118), -INT8_C(   2), -INT8_C( 102), -INT8_C(   5),  INT8_C(  63), -INT8_C(  92),  INT8_C(  64),  INT8_C(  12),
        -INT8_C( 120),  INT8_C( 106), -INT8_C(  10),  INT8_C(   7), -INT8_C(  31),  INT8_C(  79),  INT8_C(   8), -INT8_C(   3),
        -INT8_C(  94),  INT8_C(  29),  INT8_C(  59),  INT8_C(  20),  INT8_C(  99), -INT8_C( 121),  INT8_C(  81),  INT8_C( 112),
        -INT8_C(  58),  INT8_C(  83), -INT8_C(  67),  INT8_C(  98), -INT8_C(  34),  INT8_C(  14),  INT8_C( 122),  INT8_C(  84) },
      {  INT8_C(  73),  INT8_C(  55),  INT8_C(  98),  INT8_C(  30),  INT8_C( 104),  INT8_C(  38),  INT8_C(  67),  INT8_C(  48),
         INT8_C(  80),  INT8_C(   7),  INT8_C(  33),  INT8_C(  58), -INT8_C(  91),  INT8_C(   8),  INT8_C(  27),  INT8_C( 105),
         INT8_C( 109),  INT8_C(  57),  INT8_C( 107), -INT8_C(  57),  INT8_C(   3), -INT8_C(  61),  INT8_C( 114),  INT8_C(  90),
        -INT8_C(   7), -INT8_C(  21), -INT8_C( 104),  INT8_C(  49), -INT8_C( 109),  INT8_C(   3), -INT8_C(  69), -INT8_C(  35),
         INT8_C(  58),  INT8_C(  30), -INT8_C(   5), -INT8_C(  93),  INT8_C(  68),  INT8_C(  62), -INT8_C(  44), -INT8_C( 108),
         INT8_C(  71), -INT8_C(  10), -INT8_C(  49), -INT8_C(  20), -INT8_C(   2), -INT8_C(  22),  INT8_C(  85),  INT8_C( 108),
         INT8_C(  36), -INT8_C(  63),  INT8_C(  52),  INT8_C(  39), -INT8_C( 123), -INT8_C(  90), -INT8_C( 127),  INT8_C( 126),
        -INT8_C( 111),  INT8_C(  26), -INT8_C(  81),  INT8_C(  38),  INT8_C(  30),  INT8_C( 106),  INT8_C(   3),  INT8_C(  88) } },
    { {  INT8_C(  12),  INT8_C(  20),  INT8_C(  79),  INT8_C(  75), -INT8_C(  72), -INT8_C( 113),  INT8_C(  87),  INT8_C(  64),
        -INT8_C(   7),  INT8_C(  77),  INT8_C(  71), -INT8_C(  37), -INT8_C(  99),  INT8_C(  80), -INT8_C(  40),  INT8_C(  63),
         INT8_C( 109),  INT8_C(  19),  INT8_C(  83), -INT8_C(  48), -INT8_C( 102), -INT8_C(  92),  INT8_C(  64),  INT8_C(  97),
        -INT8_C(   9), -INT8_C(   3), -INT8_C(  61), -INT8_C(  43),  INT8_C(  12),  INT8_C(  61),  INT8_C(  41),  INT8_C(  24),
         INT8_C(  81),  INT8_C( 121),  INT8_C( 100),  INT8_C(   9),  INT8_C(   8), -INT8_C(  69),  INT8_C(  74),  INT8_C(   2),
         INT8_C(   9), -INT8_C( 111), -INT8_C(  35), -INT8_C(  90), -INT8_C(  31), -INT8_C(  75), -INT8_C(  27),  INT8_C(  79),
        -INT8_C(  56),  INT8_C(  56),  INT8_C(  31),  INT8_C(  98), -INT8_C(  36),  INT8_C(  96), -INT8_C(  61), -INT8_C(  44),
         INT8_C(  93), -INT8_C( 122), -INT8_C(  87),  INT8_C( 105), -INT8_C(  61), -INT8_C(  45), -INT8_C( 126),  INT8_C(  20) },
      {  INT8_C(  76), -INT8_C(  26),  INT8_C(  30),  INT8_C(  84), -INT8_C(  95),  INT8_C( 104),  INT8_C(  86), -INT8_C(  86),
        -INT8_C(   7),  INT8_C(  51),  INT8_C(  80), -INT8_C(  37), -INT8_C(  24),  INT8_C(  53),  INT8_C(  42), -INT8_C(  80),
         INT8_C( 109),  INT8_C(  73),  INT8_C(  19),  INT8_C(  74), -INT8_C(  87), -INT8_C(  42),  INT8_C(  30),  INT8_C(   7),
         INT8_C(  93), -INT8_C(  57),  INT8_C( 112),  INT8_C(  32), -INT8_C( 102), -INT8_C(  14),  INT8_C(  53), -INT8_C(  26),
        -INT8_C(  40),  INT8_C(  83),  INT8_C(  59),  INT8_C( 122), -INT8_C(  69), -INT8_C( 111),  INT8_C(  36), -INT8_C(  76),
        -INT8_C(  59),  INT8_C( 117), -INT8_C( 113), -INT8_C(  83), -INT8_C(  86), -INT8_C(  71),  INT8_C(  94),  INT8_C(  24),
         INT8_C(   3),  INT8_C( 113),  INT8_C(  98), -INT8_C(  84),  INT8_C(  71),      INT8_MIN, -INT8_C(  77), -INT8_C(  92),
         INT8_C(  71),  INT8_C(  36), -INT8_C(  59), -INT8_C(  30),  INT8_C(  22), -INT8_C(   6), -INT8_C(  56), -INT8_C(  17) },
      {  INT8_C(  88), -INT8_C(   6),  INT8_C( 109), -INT8_C(  97),  INT8_C(  89), -INT8_C(   9), -INT8_C(  83), -INT8_C(  22),
        -INT8_C(  14),      INT8_MIN, -INT8_C( 105), -INT8_C(  74), -INT8_C( 123), -INT8_C( 123),  INT8_C(   2), -INT8_C(  17),
        -INT8_C(  38),  INT8_C(  92),  INT8_C( 102),  INT8_C(  26),  INT8_C(  67),  INT8_C( 122),  INT8_C(  94),  INT8_C( 104),
         INT8_C(  84), -INT8_C(  60),  INT8_C(  51), -INT8_C(  11), -INT8_C(  90),  INT8_C(  47),  INT8_C(  94), -INT8_C(   2),
         INT8_C(  41), -INT8_C(  52), -INT8_C(  97), -INT8_C( 125), -INT8_C(  61),  INT8_C(  76),  INT8_C( 110), -INT8_C(  74),
        -INT8_C(  50),  INT8_C(   6),  INT8_C( 108),  INT8_C(  83), -INT8_C( 117),  INT8_C( 110),  INT8_C(  67),  INT8_C( 103),
        -INT8_C(  53), -INT8_C(  87), -INT8_C( 127),  INT8_C(  14),  INT8_C(  35), -INT8_C(  32),  INT8_C( 118),  INT8_C( 120),
        -INT8_C(  92), -INT8_C(  86),  INT8_C( 110),  INT8_C(  75), -INT8_C(  39), -INT8_C(  51),  INT8_C(  74),  INT8_C(   3) } },
    { {  INT8_C(  77),  INT8_C(   3),  INT8_C( 105),  INT8_C(   8), -INT8_C( 107), -INT8_C( 115), -INT8_C(  68),  INT8_C(  90),
         INT8_C(   2),  INT8_C(  76),  INT8_C(   7), -INT8_C(  83),  INT8_C(   5),  INT8_C( 101), -INT8_C(  59),  INT8_C(   8),
        -INT8_C(  42),  INT8_C(  39), -INT8_C(  75),  INT8_C(  30), -INT8_C(  89),  INT8_C( 104), -INT8_C(  62), -INT8_C(  18),
        -INT8_C( 116), -INT8_C( 121), -INT8_C(  48), -INT8_C(  93), -INT8_C( 127), -INT8_C( 103), -INT8_C( 110), -INT8_C(  50),
        -INT8_C( 100), -INT8_C(   5), -INT8_C(  42),  INT8_C(  49), -INT8_C( 120), -INT8_C( 109), -INT8_C( 117), -INT8_C( 117),
        -INT8_C(  33), -INT8_C( 109),  INT8_C(  56), -INT8_C(  28), -INT8_C(   8), -INT8_C(   3), -INT8_C(  19), -INT8_C(  49),
         INT8_C(  36), -INT8_C(  94), -INT8_C(  19), -INT8_C(  53),  INT8_C(  10), -INT8_C(  81), -INT8_C(  71), -INT8_C( 105),
         INT8_C(  55), -INT8_C( 118),  INT8_C(  58), -INT8_C(  72),  INT8_C(  35), -INT8_C(  52), -INT8_C( 121), -INT8_C(  65) },
      { -INT8_C(  57),  INT8_C(  93), -INT8_C(  15),  INT8_C(  79), -INT8_C(  16),  INT8_C( 124), -INT8_C(  38), -INT8_C(  49),
         INT8_C(  15),  INT8_C(  18), -INT8_C(  76),  INT8_C(   8),  INT8_C(  15), -INT8_C(  95), -INT8_C(  41),  INT8_C(  51),
         INT8_C(  67), -INT8_C(  60), -INT8_C(   2),  INT8_C(  77),  INT8_C( 115), -INT8_C(  72), -INT8_C(  28), -INT8_C(  86),
         INT8_C(  66),  INT8_C(  30),  INT8_C(  99),  INT8_C( 101), -INT8_C(  22), -INT8_C(  22),  INT8_C(  36), -INT8_C(  79),
         INT8_C(  71),  INT8_C(  21),  INT8_C(   1),  INT8_C(  56), -INT8_C( 110), -INT8_C(  37),  INT8_C(   7), -INT8_C(  95),
        -INT8_C(  18), -INT8_C(  69), -INT8_C(  87), -INT8_C(   3),  INT8_C(  92),      INT8_MIN,  INT8_C(  49), -INT8_C(  97),
         INT8_C(  68),  INT8_C(  47), -INT8_C(  19), -INT8_C(  72), -INT8_C(  25), -INT8_C(  47),  INT8_C(  98),  INT8_C(  41),
        -INT8_C(  16), -INT8_C(  59), -INT8_C( 114), -INT8_C(  38), -INT8_C(  81), -INT8_C(  77), -INT8_C( 116), -INT8_C(   9) },
      {  INT8_C(  20),  INT8_C(  96),  INT8_C(  90),  INT8_C(  87), -INT8_C( 123),  INT8_C(   9), -INT8_C( 106),  INT8_C(  41),
         INT8_C(  17),  INT8_C(  94), -INT8_C(  69), -INT8_C(  75),  INT8_C(  20),  INT8_C(   6), -INT8_C( 100),  INT8_C(  59),
         INT8_C(  25), -INT8_C(  21), -INT8_C(  77),  INT8_C( 107),  INT8_C(  26),  INT8_C(  32), -INT8_C(  90), -INT8_C( 104),
        -INT8_C(  50), -INT8_C(  91),  INT8_C(  51),  INT8_C(   8),  INT8_C( 107), -INT8_C( 125), -INT8_C(  74),      INT8_MAX,
        -INT8_C(  29),  INT8_C(  16), -INT8_C(  41),  INT8_C( 105),  INT8_C(  26),  INT8_C( 110), -INT8_C( 110),  INT8_C(  44),
        -INT8_C(  51),  INT8_C(  78), -INT8_C(  31), -INT8_C(  31),  INT8_C(  84),  INT8_C( 125),  INT8_C(  30),  INT8_C( 110),
         INT8_C( 104), -INT8_C(  47), -INT8_C(  38), -INT8_C( 125), -INT8_C(  15),      INT8_MIN,  INT8_C(  27), -INT8_C(  64),
         INT8_C(  39),  INT8_C(  79), -INT8_C(  56), -INT8_C( 110), -INT8_C(  46),      INT8_MAX,  INT8_C(  19), -INT8_C(  74) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i a = simde_mm512_loadu_epi8(test_vec[i].a);
    simde__m512i b = simde_mm512_loadu_epi8(test_vec[i].b);
    simde__m512i r = simde_mm512_add_epi8(a, b);
    simde_test_x86_assert_equal_i8x64(r, simde_mm512_loadu_epi8(test_vec[i].r));
  }

  return 0;
}

static int
test_simde_mm512_mask_add_epi8 (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const int8_t src[64];
    const simde__mmask64 k;
    const int8_t a[64];
    const int8_t b[64];
    const int8_t r[64];
  } test_vec[] = {
    { {  INT8_C(  20), -INT8_C(  19),  INT8_C(  38),  INT8_C(  45), -INT8_C(  89), -INT8_C(  95),  INT8_C(  34), -INT8_C(   3),
        -INT8_C(  21),  INT8_C(  99), -INT8_C(  35),  INT8_C(  73),  INT8_C(   3), -INT8_C( 119),  INT8_C(   1), -INT8_C(   7),
        -INT8_C( 123), -INT8_C(  90),  INT8_C(  32),  INT8_C(  73), -INT8_C(  12), -INT8_C( 115), -INT8_C(  93),  INT8_C(  56),
         INT8_C( 116),  INT8_C(  96), -INT8_C(  89), -INT8_C( 108),  INT8_C(  46), -INT8_C(  17),  INT8_C(  92),  INT8_C(  67),
        -INT8_C(  35), -INT8_C( 125),  INT8_C( 112), -INT8_C( 124),  INT8_C(  36), -INT8_C( 110), -INT8_C( 127),  INT8_C(  15),
        -INT8_C(  11),  INT8_C(  95),  INT8_C(  88), -INT8_C(   8), -INT8_C(  24),  INT8_C(  89), -INT8_C(  14),  INT8_C( 109),
        -INT8_C(   1),  INT8_C(  18), -INT8_C(  73), -INT8_C(  13), -INT8_C(  97),  INT8_C(  90),  INT8_C(  43),  INT8_C(  19),
        -INT8_C(  69), -INT8_C(  45), -INT8_C(  88), -INT8_C(  23), -INT8_C(  62),  INT8_C(   4),  INT8_C(  44), -INT8_C(  97) },
      UINT64_C( 2646890825868614791),
      {  INT8_C(   4),  INT8_C(  19),  INT8_C(  28), -INT8_C(  20),  INT8_C( 109),  INT8_C(  14),  INT8_C(  90),  INT8_C( 108),
         INT8_C(  32),  INT8_C(  17),  INT8_C(  96), -INT8_C(  64),  INT8_C( 107), -INT8_C( 117), -INT8_C(  45),  INT8_C(  38),
         INT8_C(  94),  INT8_C( 123),  INT8_C(  16),  INT8_C(  33),      INT8_MIN,  INT8_C(  60), -INT8_C(  64),  INT8_C(   7),
        -INT8_C(  39), -INT8_C(  28), -INT8_C(  77),  INT8_C(   7), -INT8_C( 119),  INT8_C( 110),  INT8_C(  43), -INT8_C( 115),
        -INT8_C( 127),  INT8_C(  72),  INT8_C( 121), -INT8_C(  18),  INT8_C(  86), -INT8_C(  45),  INT8_C(  91),  INT8_C( 119),
        -INT8_C(  28), -INT8_C(  69),  INT8_C(  55),  INT8_C(  80),  INT8_C(  70),  INT8_C(  10),  INT8_C( 118), -INT8_C(  91),
        -INT8_C( 122), -INT8_C( 122), -INT8_C(  58),  INT8_C(   6), -INT8_C(  61), -INT8_C( 122),  INT8_C(  13), -INT8_C( 100),
         INT8_C( 106), -INT8_C(  64), -INT8_C(  93), -INT8_C(  13),  INT8_C(  46), -INT8_C(  49),      INT8_MIN, -INT8_C(  80) },
      {  INT8_C(  23), -INT8_C(   6), -INT8_C(  98),  INT8_C( 109), -INT8_C(  51), -INT8_C(   7), -INT8_C(  28), -INT8_C(  78),
        -INT8_C(  76),  INT8_C(  27),  INT8_C(   2), -INT8_C(   5),  INT8_C(  38),  INT8_C( 120), -INT8_C(  96), -INT8_C(  84),
        -INT8_C(   1),  INT8_C( 102), -INT8_C(  78), -INT8_C(  62), -INT8_C(  20), -INT8_C(  65),  INT8_C(  94),  INT8_C(  87),
             INT8_MIN,  INT8_C(   1),  INT8_C(  74), -INT8_C(  82), -INT8_C(  48), -INT8_C(  53),  INT8_C(  94), -INT8_C(  25),
        -INT8_C(  59), -INT8_C(   3),  INT8_C(  85), -INT8_C( 110), -INT8_C(  10),  INT8_C(  57),  INT8_C(  68), -INT8_C(  85),
         INT8_C(  85),  INT8_C(  70), -INT8_C(  90),  INT8_C( 123), -INT8_C(  65),  INT8_C(  70),  INT8_C(  39), -INT8_C(  66),
        -INT8_C(  84), -INT8_C(  39),      INT8_MIN, -INT8_C( 104), -INT8_C( 104), -INT8_C(  34), -INT8_C(  17),  INT8_C(  24),
        -INT8_C(  33),  INT8_C(  58), -INT8_C(  57), -INT8_C(  80),  INT8_C(   5),  INT8_C(  37), -INT8_C( 105), -INT8_C(  54) },
      {  INT8_C(  27),  INT8_C(  13), -INT8_C(  70),  INT8_C(  45), -INT8_C(  89), -INT8_C(  95),  INT8_C(  34),  INT8_C(  30),
        -INT8_C(  21),  INT8_C(  99),  INT8_C(  98), -INT8_C(  69), -INT8_C( 111), -INT8_C( 119),  INT8_C(   1), -INT8_C(  46),
         INT8_C(  93), -INT8_C(  31),  INT8_C(  32),  INT8_C(  73), -INT8_C(  12), -INT8_C(   5), -INT8_C(  93),  INT8_C(  56),
         INT8_C(  89), -INT8_C(  27), -INT8_C(  89), -INT8_C(  75),  INT8_C(  46),  INT8_C(  57),  INT8_C(  92),  INT8_C( 116),
        -INT8_C(  35),  INT8_C(  69), -INT8_C(  50),      INT8_MIN,  INT8_C(  36),  INT8_C(  12), -INT8_C( 127),  INT8_C(  15),
         INT8_C(  57),  INT8_C(  95), -INT8_C(  35), -INT8_C(   8), -INT8_C(  24),  INT8_C(  80), -INT8_C(  14),  INT8_C(  99),
         INT8_C(  50),  INT8_C(  95), -INT8_C(  73), -INT8_C(  98),  INT8_C(  91),  INT8_C( 100),  INT8_C(  43), -INT8_C(  76),
        -INT8_C(  69), -INT8_C(  45),  INT8_C( 106), -INT8_C(  23), -INT8_C(  62), -INT8_C(  12),  INT8_C(  44), -INT8_C(  97) } },
    { {  INT8_C(  34), -INT8_C(  20),  INT8_C(  92),  INT8_C(  25),  INT8_C(  38), -INT8_C(  95), -INT8_C(  60),  INT8_C( 123),
        -INT8_C(  25),  INT8_C( 106), -INT8_C(  10), -INT8_C(  90), -INT8_C(  80),  INT8_C(  29),  INT8_C( 100),  INT8_C(  92),
        -INT8_C(  10), -INT8_C(  28), -INT8_C(  12), -INT8_C( 114), -INT8_C(  62), -INT8_C(  28), -INT8_C(  89), -INT8_C(  94),
         INT8_C(  30),  INT8_C( 110),  INT8_C(  82),  INT8_C(  35), -INT8_C( 109), -INT8_C(  23), -INT8_C(  19), -INT8_C(  74),
        -INT8_C(  42),  INT8_C(  73), -INT8_C(  49), -INT8_C(   4), -INT8_C(  22), -INT8_C( 109),  INT8_C( 119), -INT8_C(  46),
        -INT8_C(   3),  INT8_C( 109),  INT8_C( 120), -INT8_C(  83), -INT8_C( 118), -INT8_C(  35),  INT8_C(   9),      INT8_MIN,
        -INT8_C(  63), -INT8_C(   3),  INT8_C(  14), -INT8_C( 124), -INT8_C(  31), -INT8_C(  75),  INT8_C(  38), -INT8_C(   1),
         INT8_C(  35),  INT8_C( 120),  INT8_C(  34), -INT8_C(  73),  INT8_C(  97),  INT8_C(  15),  INT8_C( 109),  INT8_C(  55) },
      UINT64_C(14705847965410606169),
      {  INT8_C(  23), -INT8_C( 114),  INT8_C( 121), -INT8_C(  95),  INT8_C( 107), -INT8_C( 126),  INT8_C(  33),  INT8_C(  44),
             INT8_MAX,  INT8_C(  48), -INT8_C(  80),  INT8_C(  97), -INT8_C(  27), -INT8_C(  42),  INT8_C(  96),  INT8_C(   9),
         INT8_C(  78), -INT8_C( 125), -INT8_C(  64), -INT8_C(  80), -INT8_C( 110),  INT8_C(  45), -INT8_C(  25), -INT8_C(  21),
         INT8_C( 105),  INT8_C(  27),  INT8_C(  47),  INT8_C(  56), -INT8_C(  59),  INT8_C(  68),  INT8_C(   4), -INT8_C(  35),
        -INT8_C(  46),  INT8_C( 125),  INT8_C( 126),  INT8_C(  61), -INT8_C(   1), -INT8_C(  96),  INT8_C( 106),  INT8_C( 126),
        -INT8_C(  48),  INT8_C(  26), -INT8_C(  33), -INT8_C(  75), -INT8_C(  15),  INT8_C(  64), -INT8_C(  66),  INT8_C(  63),
        -INT8_C(  61),  INT8_C( 126), -INT8_C(  17),  INT8_C(  85), -INT8_C(  85), -INT8_C(  41),  INT8_C(  65),  INT8_C(  20),
        -INT8_C(  14),  INT8_C( 112),  INT8_C(  76), -INT8_C(  73), -INT8_C(  76),  INT8_C(  80), -INT8_C( 108), -INT8_C( 121) },
      { -INT8_C(  51),  INT8_C(  19), -INT8_C(  60), -INT8_C(  52), -INT8_C(  77),  INT8_C(  46),  INT8_C(  75), -INT8_C( 125),
         INT8_C(  73),  INT8_C(  42),  INT8_C(  56),  INT8_C(  58),  INT8_C( 106), -INT8_C(   9),  INT8_C( 121),  INT8_C(  45),
         INT8_C( 117),  INT8_C( 105), -INT8_C( 125),  INT8_C(  33),  INT8_C(  64), -INT8_C(  60),  INT8_C(  53),  INT8_C(  50),
         INT8_C(  52), -INT8_C( 126), -INT8_C(  23), -INT8_C(  24), -INT8_C(  46),  INT8_C( 126),  INT8_C( 111), -INT8_C(  96),
        -INT8_C( 111),  INT8_C(  52),  INT8_C( 108),  INT8_C(  68),  INT8_C(  98), -INT8_C(  73), -INT8_C(  57), -INT8_C(  85),
        -INT8_C(  30), -INT8_C(   1), -INT8_C(  27),  INT8_C(  76), -INT8_C(  10),  INT8_C(  95),  INT8_C( 122),  INT8_C( 108),
        -INT8_C(  56), -INT8_C(   3), -INT8_C( 115),  INT8_C(   8), -INT8_C(  63), -INT8_C(  62),  INT8_C(  58), -INT8_C(  11),
         INT8_C(  68),  INT8_C(  35), -INT8_C(  35),  INT8_C(  23), -INT8_C(  95),  INT8_C(  77), -INT8_C(  73),  INT8_C(  50) },
      { -INT8_C(  28), -INT8_C(  20),  INT8_C(  92),  INT8_C( 109),  INT8_C(  30), -INT8_C(  95),  INT8_C( 108),  INT8_C( 123),
        -INT8_C(  25),  INT8_C( 106), -INT8_C(  24), -INT8_C( 101),  INT8_C(  79), -INT8_C(  51),  INT8_C( 100),  INT8_C(  92),
        -INT8_C(  61), -INT8_C(  20), -INT8_C(  12), -INT8_C( 114), -INT8_C(  46), -INT8_C(  15), -INT8_C(  89), -INT8_C(  94),
        -INT8_C(  99), -INT8_C(  99),  INT8_C(  82),  INT8_C(  35), -INT8_C( 109), -INT8_C(  23),  INT8_C( 115), -INT8_C(  74),
         INT8_C(  99), -INT8_C(  79), -INT8_C(  22), -INT8_C( 127), -INT8_C(  22), -INT8_C( 109),  INT8_C(  49),  INT8_C(  41),
        -INT8_C(   3),  INT8_C(  25),  INT8_C( 120),  INT8_C(   1), -INT8_C( 118), -INT8_C(  97),  INT8_C(   9), -INT8_C(  85),
        -INT8_C( 117), -INT8_C(   3),  INT8_C( 124), -INT8_C( 124),  INT8_C( 108), -INT8_C(  75),  INT8_C(  38), -INT8_C(   1),
         INT8_C(  35),  INT8_C( 120),  INT8_C(  41), -INT8_C(  50),  INT8_C(  97),  INT8_C(  15),  INT8_C(  75), -INT8_C(  71) } },
    { { -INT8_C( 127),  INT8_C(  35),  INT8_C( 118), -INT8_C(  29), -INT8_C(  37),  INT8_C(  61), -INT8_C( 113), -INT8_C(  67),
         INT8_C(  61),  INT8_C( 116),  INT8_C(   9),  INT8_C(  51), -INT8_C(  45), -INT8_C( 125), -INT8_C(  97), -INT8_C( 101),
             INT8_MIN,  INT8_C(  44), -INT8_C(  93),  INT8_C(  65), -INT8_C(  17), -INT8_C(  35),  INT8_C(  54),  INT8_C(  51),
         INT8_C(   1),  INT8_C(  20),  INT8_C(  74), -INT8_C(  94),  INT8_C(  97),  INT8_C(   1), -INT8_C(  43), -INT8_C(  30),
         INT8_C(  37),  INT8_C(  75), -INT8_C(  59),  INT8_C(   0), -INT8_C( 119),  INT8_C(  84), -INT8_C(  67), -INT8_C(  58),
        -INT8_C(  55), -INT8_C(  58), -INT8_C(   7), -INT8_C( 100),  INT8_C(  74), -INT8_C( 103),  INT8_C(  56), -INT8_C(  54),
        -INT8_C(  59), -INT8_C(  37),  INT8_C(  12), -INT8_C(  76), -INT8_C(  71),  INT8_C(  66), -INT8_C(  24), -INT8_C(  70),
         INT8_C(  86),  INT8_C(  50),  INT8_C(  92), -INT8_C(  73),  INT8_C(  52),  INT8_C(  49), -INT8_C( 103),  INT8_C(  89) },
      UINT64_C( 8992587514113515389),
      { -INT8_C(  36), -INT8_C(  59),  INT8_C(  25),  INT8_C(  38),  INT8_C(  94),  INT8_C(  81), -INT8_C(  15),  INT8_C(  36),
         INT8_C(  44), -INT8_C(   3), -INT8_C(  40), -INT8_C(  27),  INT8_C(  63), -INT8_C(  64), -INT8_C(  97), -INT8_C( 106),
        -INT8_C(  13), -INT8_C(   4),  INT8_C(  77),  INT8_C(  39),  INT8_C(  45), -INT8_C(  25),      INT8_MIN, -INT8_C(  86),
         INT8_C(  70), -INT8_C(  39), -INT8_C(  80), -INT8_C(   7), -INT8_C(  17),  INT8_C( 124),  INT8_C( 118), -INT8_C(  53),
         INT8_C(  66), -INT8_C( 113), -INT8_C(  14), -INT8_C(  96), -INT8_C(  32), -INT8_C(  29), -INT8_C(  60),  INT8_C(  12),
        -INT8_C(  32), -INT8_C(  99), -INT8_C(  14),  INT8_C(  31),  INT8_C(  93), -INT8_C( 111), -INT8_C(  75),  INT8_C(  80),
        -INT8_C( 115),  INT8_C(   3),  INT8_C( 119), -INT8_C(  69), -INT8_C(  22), -INT8_C(   9),  INT8_C( 101),  INT8_C(  48),
        -INT8_C(  48),  INT8_C(  22),  INT8_C(  41), -INT8_C(  65), -INT8_C( 110), -INT8_C(  97), -INT8_C( 117), -INT8_C(  44) },
      {  INT8_C(  46),  INT8_C( 125),  INT8_C( 117),  INT8_C(  14),  INT8_C(  96),  INT8_C(  57),  INT8_C(  27),  INT8_C(  64),
        -INT8_C(  42),  INT8_C(  13),  INT8_C(  95),  INT8_C(  52), -INT8_C(  98),  INT8_C(  21), -INT8_C( 124),  INT8_C(  44),
         INT8_C(  24), -INT8_C(   4), -INT8_C(  25),  INT8_C(   2), -INT8_C(  13),  INT8_C(  76),  INT8_C(  50), -INT8_C(  60),
         INT8_C(  98),  INT8_C(  91), -INT8_C( 125), -INT8_C(  11), -INT8_C(   5),  INT8_C(  14), -INT8_C(  55),  INT8_C(  41),
        -INT8_C( 117),  INT8_C(  62),  INT8_C(  56), -INT8_C(  21),  INT8_C( 120),  INT8_C(  83),  INT8_C(  43),  INT8_C(  78),
         INT8_C(  96), -INT8_C( 117), -INT8_C( 126), -INT8_C(   2), -INT8_C(  96),  INT8_C(   7),  INT8_C(  42), -INT8_C(  72),
         INT8_C(   3),  INT8_C(  17), -INT8_C(  70), -INT8_C(  10),  INT8_C(  94), -INT8_C(  20), -INT8_C(  70), -INT8_C(  64),
         INT8_C(  71),  INT8_C(  62), -INT8_C(  75),  INT8_C(  66),  INT8_C(  76),      INT8_MAX,  INT8_C( 108), -INT8_C(  40) },
      {  INT8_C(  10),  INT8_C(  35), -INT8_C( 114),  INT8_C(  52), -INT8_C(  66), -INT8_C( 118),  INT8_C(  12), -INT8_C(  67),
         INT8_C(   2),  INT8_C(  10),  INT8_C(  55),  INT8_C(  25), -INT8_C(  35), -INT8_C( 125),  INT8_C(  35), -INT8_C( 101),
         INT8_C(  11),  INT8_C(  44), -INT8_C(  93),  INT8_C(  41),  INT8_C(  32), -INT8_C(  35), -INT8_C(  78),  INT8_C(  51),
         INT8_C(   1),  INT8_C(  52),  INT8_C(  51), -INT8_C(  94),  INT8_C(  97),  INT8_C(   1), -INT8_C(  43), -INT8_C(  30),
        -INT8_C(  51), -INT8_C(  51), -INT8_C(  59),  INT8_C(   0),  INT8_C(  88),  INT8_C(  54), -INT8_C(  67),  INT8_C(  90),
        -INT8_C(  55),  INT8_C(  40),  INT8_C( 116), -INT8_C( 100), -INT8_C(   3), -INT8_C( 103),  INT8_C(  56), -INT8_C(  54),
        -INT8_C(  59), -INT8_C(  37),  INT8_C(  49), -INT8_C(  79), -INT8_C(  71),  INT8_C(  66),  INT8_C(  31), -INT8_C(  16),
         INT8_C(  86),  INT8_C(  50), -INT8_C(  34),  INT8_C(   1), -INT8_C(  34),  INT8_C(  30), -INT8_C(   9),  INT8_C(  89) } },
    { { -INT8_C(  67), -INT8_C(  92), -INT8_C(  61),  INT8_C(  53), -INT8_C(   9), -INT8_C(  17), -INT8_C( 124),  INT8_C(  87),
         INT8_C( 122),  INT8_C(   6),  INT8_C(  85),  INT8_C(  26),  INT8_C(  13),      INT8_MIN, -INT8_C(  46),  INT8_C(  16),
        -INT8_C( 111), -INT8_C( 116),  INT8_C(   7), -INT8_C(  17),  INT8_C( 120), -INT8_C(  63), -INT8_C(  80), -INT8_C(  65),
        -INT8_C(   1),  INT8_C( 101),  INT8_C(   2),  INT8_C(  76), -INT8_C(  28),  INT8_C( 110),  INT8_C(  36), -INT8_C(  94),
         INT8_C(  18), -INT8_C(  25), -INT8_C(  41),  INT8_C(   9), -INT8_C(  42),  INT8_C(  91),  INT8_C(  96),  INT8_C(  80),
         INT8_C(  98), -INT8_C(  75),  INT8_C( 106),  INT8_C( 111),  INT8_C(  53),  INT8_C(  60),      INT8_MIN, -INT8_C(  57),
        -INT8_C(  56), -INT8_C( 121), -INT8_C(  74),  INT8_C(  64),  INT8_C(  72),  INT8_C( 102),  INT8_C(   0),  INT8_C(  72),
        -INT8_C(  52),  INT8_C(   2), -INT8_C( 108), -INT8_C(  80),  INT8_C( 112), -INT8_C(  72),  INT8_C(  82), -INT8_C( 126) },
      UINT64_C(16701295226602072735),
      { -INT8_C(  96),  INT8_C(  49),  INT8_C(  87), -INT8_C(  42),  INT8_C( 109), -INT8_C(  41), -INT8_C(  99),  INT8_C(  54),
         INT8_C(  94),  INT8_C(  83),  INT8_C( 118), -INT8_C(  90), -INT8_C(  70),  INT8_C( 118), -INT8_C(  18), -INT8_C( 122),
         INT8_C( 120), -INT8_C( 126),  INT8_C(  54), -INT8_C(  24),  INT8_C(  58), -INT8_C( 119),  INT8_C( 106), -INT8_C(  38),
        -INT8_C(  77), -INT8_C(  11),  INT8_C(  80),  INT8_C(  56), -INT8_C(  32),  INT8_C(  22),  INT8_C(  32), -INT8_C( 127),
         INT8_C(  71),  INT8_C( 119),  INT8_C(  87), -INT8_C(  75),  INT8_C(  78), -INT8_C(  12), -INT8_C(  21), -INT8_C(  84),
         INT8_C(  71),  INT8_C(  97),  INT8_C(  82),  INT8_C(   1), -INT8_C(  40),  INT8_C(  65), -INT8_C( 121),  INT8_C(  80),
        -INT8_C(  61), -INT8_C(  66),  INT8_C(  57), -INT8_C(   2),  INT8_C(  71), -INT8_C(  93), -INT8_C(  40), -INT8_C(   6),
        -INT8_C( 103),  INT8_C(  40),  INT8_C(  50),  INT8_C( 121),  INT8_C(  62),  INT8_C(  82), -INT8_C(   6), -INT8_C( 122) },
      { -INT8_C(  55),  INT8_C(  81),  INT8_C(  59),  INT8_C(  23),  INT8_C(  69),  INT8_C(  38), -INT8_C(  61), -INT8_C( 115),
        -INT8_C( 121),  INT8_C(  22), -INT8_C( 114),  INT8_C(  95),  INT8_C(  87),  INT8_C(  22), -INT8_C(  80),  INT8_C(  26),
        -INT8_C(  44), -INT8_C(  23),  INT8_C(  24),  INT8_C(  27), -INT8_C( 116), -INT8_C(  16),  INT8_C(  21),  INT8_C(  37),
         INT8_C(  24),  INT8_C(  71), -INT8_C(  97),  INT8_C(  87), -INT8_C( 102), -INT8_C( 103), -INT8_C(  35),  INT8_C(  99),
        -INT8_C(  21),  INT8_C(  24),  INT8_C( 123),  INT8_C(  48),  INT8_C(  62),  INT8_C(  62), -INT8_C(  67), -INT8_C(  59),
         INT8_C(  84),  INT8_C(  76),  INT8_C(  37), -INT8_C(  85),  INT8_C(  98), -INT8_C(  43), -INT8_C(  58),  INT8_C(  54),
        -INT8_C(  66), -INT8_C(  34),  INT8_C(  81),  INT8_C(  74), -INT8_C(  49),  INT8_C( 102),  INT8_C( 112), -INT8_C(  25),
        -INT8_C(  83),  INT8_C(  15),  INT8_C(  62),  INT8_C(  71), -INT8_C(  88),  INT8_C(  27), -INT8_C(  85), -INT8_C( 109) },
      {  INT8_C( 105), -INT8_C( 126), -INT8_C( 110), -INT8_C(  19), -INT8_C(  78), -INT8_C(  17), -INT8_C( 124), -INT8_C(  61),
         INT8_C( 122),  INT8_C( 105),  INT8_C(  85),  INT8_C(   5),  INT8_C(  13), -INT8_C( 116), -INT8_C(  46),  INT8_C(  16),
         INT8_C(  76),  INT8_C( 107),  INT8_C(   7),  INT8_C(   3),  INT8_C( 120), -INT8_C(  63), -INT8_C(  80), -INT8_C(   1),
        -INT8_C(   1),  INT8_C(  60), -INT8_C(  17),  INT8_C(  76),  INT8_C( 122), -INT8_C(  81), -INT8_C(   3), -INT8_C(  94),
         INT8_C(  50), -INT8_C(  25), -INT8_C(  46),  INT8_C(   9), -INT8_C(  42),  INT8_C(  91),  INT8_C(  96),  INT8_C( 113),
        -INT8_C( 101), -INT8_C(  83),  INT8_C( 106), -INT8_C(  84),  INT8_C(  53),  INT8_C(  22),  INT8_C(  77), -INT8_C( 122),
        -INT8_C(  56), -INT8_C( 100), -INT8_C( 118),  INT8_C(  64),  INT8_C(  72),  INT8_C( 102),  INT8_C(  72), -INT8_C(  31),
         INT8_C(  70),  INT8_C(  55),  INT8_C( 112), -INT8_C(  80),  INT8_C( 112),  INT8_C( 109), -INT8_C(  91),  INT8_C(  25) } },
    { {  INT8_C(  51),  INT8_C(  38), -INT8_C(  60),  INT8_C( 113),  INT8_C( 100), -INT8_C( 127),  INT8_C(  55), -INT8_C(  71),
        -INT8_C(  51),  INT8_C(  92),  INT8_C( 100),  INT8_C(  47),  INT8_C(  49),  INT8_C(  42),  INT8_C( 101), -INT8_C(  17),
         INT8_C(   9), -INT8_C(  74),  INT8_C(  57), -INT8_C(  40),  INT8_C(  28), -INT8_C(  87), -INT8_C(  65), -INT8_C(  54),
        -INT8_C(  72), -INT8_C(   2),  INT8_C(  17),  INT8_C(  97),  INT8_C(  25), -INT8_C(  68), -INT8_C(  12),  INT8_C(  77),
        -INT8_C(  30), -INT8_C(  72), -INT8_C(  66),  INT8_C(  71),  INT8_C(  58), -INT8_C(  11),  INT8_C(   0),  INT8_C(   7),
         INT8_C(  81),  INT8_C( 100),  INT8_C(  55), -INT8_C( 126), -INT8_C( 113), -INT8_C( 100),  INT8_C( 113), -INT8_C( 104),
         INT8_C(  83), -INT8_C(  85),  INT8_C( 112),  INT8_C( 111),  INT8_C(  84),  INT8_C(  47),  INT8_C(  57),  INT8_C(  13),
         INT8_C(  45),  INT8_C(  75),  INT8_C( 110),  INT8_C(  71),  INT8_C(   7),  INT8_C(  98), -INT8_C( 108), -INT8_C(  22) },
      UINT64_C(11050761772397056539),
      { -INT8_C( 107), -INT8_C( 109),  INT8_C(  28),  INT8_C(  36),  INT8_C(  48), -INT8_C( 115), -INT8_C(  68), -INT8_C( 125),
         INT8_C(  56),  INT8_C(  44), -INT8_C(  14), -INT8_C( 115),  INT8_C(  92),  INT8_C(  44), -INT8_C( 102), -INT8_C( 119),
         INT8_C( 119),  INT8_C(   8), -INT8_C(  48),  INT8_C( 126),  INT8_C( 106),  INT8_C( 100),  INT8_C( 104), -INT8_C( 123),
        -INT8_C(  73), -INT8_C( 103), -INT8_C(  38), -INT8_C(   1), -INT8_C(  54),  INT8_C(  55), -INT8_C( 104),  INT8_C(  96),
        -INT8_C(  54), -INT8_C(  76), -INT8_C( 124), -INT8_C(   6),  INT8_C(  66),  INT8_C(  65),  INT8_C( 125),  INT8_C( 122),
         INT8_C( 109),  INT8_C( 112),  INT8_C(   7), -INT8_C(  55), -INT8_C( 100), -INT8_C(  95),  INT8_C(  83),  INT8_C(  19),
        -INT8_C(  87),  INT8_C(  35), -INT8_C( 111),  INT8_C(  20), -INT8_C( 120), -INT8_C(   6), -INT8_C( 103),  INT8_C(  63),
        -INT8_C( 109),  INT8_C( 116),  INT8_C(  62),  INT8_C(  94), -INT8_C(  85), -INT8_C(  42), -INT8_C(  66),  INT8_C( 117) },
      { -INT8_C( 117),  INT8_C(  66),  INT8_C( 112), -INT8_C(  51), -INT8_C( 125), -INT8_C(  19),  INT8_C(  71), -INT8_C(  15),
         INT8_C(  93),  INT8_C(  79), -INT8_C(  70), -INT8_C(   7), -INT8_C(  16),  INT8_C(  13),  INT8_C(  12), -INT8_C( 102),
         INT8_C(  49), -INT8_C(  98), -INT8_C(  82), -INT8_C(  71), -INT8_C( 104),  INT8_C(  71), -INT8_C(   8),  INT8_C(  43),
        -INT8_C(  69),  INT8_C(  54), -INT8_C( 119),  INT8_C( 102),  INT8_C(  12),  INT8_C(  71), -INT8_C(  36), -INT8_C( 105),
        -INT8_C( 118),  INT8_C(  76),  INT8_C( 100),  INT8_C(  13),  INT8_C(  57), -INT8_C(  84), -INT8_C(   2), -INT8_C( 105),
        -INT8_C(   5), -INT8_C(  71), -INT8_C( 112), -INT8_C(  21), -INT8_C(  58), -INT8_C(  99), -INT8_C( 123), -INT8_C(   9),
         INT8_C(  59),  INT8_C(  51), -INT8_C(  80), -INT8_C(  45),  INT8_C( 123), -INT8_C(  88), -INT8_C(   2),  INT8_C(  54),
        -INT8_C(  34), -INT8_C( 120), -INT8_C(  99), -INT8_C(  21), -INT8_C(  49),  INT8_C( 121), -INT8_C( 126),  INT8_C(  89) },
      {  INT8_C(  32), -INT8_C(  43), -INT8_C(  60), -INT8_C(  15), -INT8_C(  77), -INT8_C( 127),  INT8_C(  55), -INT8_C(  71),
        -INT8_C(  51),  INT8_C( 123),  INT8_C( 100),  INT8_C(  47),  INT8_C(  76),  INT8_C(  42), -INT8_C(  90), -INT8_C(  17),
        -INT8_C(  88), -INT8_C(  74),  INT8_C(  57), -INT8_C(  40),  INT8_C(   2), -INT8_C(  85), -INT8_C(  65), -INT8_C(  54),
         INT8_C( 114), -INT8_C(   2),  INT8_C(  99),  INT8_C(  97), -INT8_C(  42), -INT8_C(  68),  INT8_C( 116),  INT8_C(  77),
        -INT8_C(  30), -INT8_C(  72), -INT8_C(  66),  INT8_C(   7),  INT8_C(  58), -INT8_C(  11),  INT8_C( 123),  INT8_C(   7),
         INT8_C( 104),  INT8_C( 100),  INT8_C(  55), -INT8_C( 126),  INT8_C(  98),  INT8_C(  62),  INT8_C( 113), -INT8_C( 104),
         INT8_C(  83), -INT8_C(  85),  INT8_C(  65), -INT8_C(  25),  INT8_C(   3),  INT8_C(  47), -INT8_C( 105),  INT8_C(  13),
         INT8_C( 113),  INT8_C(  75),  INT8_C( 110),  INT8_C(  73),  INT8_C( 122),  INT8_C(  98), -INT8_C( 108), -INT8_C(  50) } },
    { { -INT8_C(  59), -INT8_C(  25),  INT8_C( 103), -INT8_C(   2), -INT8_C( 109),  INT8_C( 101), -INT8_C( 107), -INT8_C( 114),
         INT8_C(  30),  INT8_C(  38),  INT8_C( 121), -INT8_C(  27), -INT8_C(  61), -INT8_C(   1), -INT8_C(  36), -INT8_C(   2),
         INT8_C(  50), -INT8_C( 115), -INT8_C(  47), -INT8_C(  83),  INT8_C(  53), -INT8_C(  49), -INT8_C(  28),  INT8_C(  20),
         INT8_C(  87), -INT8_C( 127), -INT8_C(   1),  INT8_C(  39), -INT8_C(   6), -INT8_C( 127),      INT8_MIN, -INT8_C(  65),
         INT8_C( 104), -INT8_C(  25), -INT8_C(  67), -INT8_C(   5),  INT8_C(  77),  INT8_C(  83), -INT8_C( 119),  INT8_C( 107),
         INT8_C( 121),  INT8_C(   3),  INT8_C(  80),  INT8_C(  60),  INT8_C(   2),  INT8_C(  45),  INT8_C(  58),  INT8_C(  52),
        -INT8_C(  70),  INT8_C(  11), -INT8_C(  30), -INT8_C(  17), -INT8_C(  38), -INT8_C(  58),  INT8_C(   3),  INT8_C(  50),
         INT8_C(  71),  INT8_C(   2),  INT8_C(  89),  INT8_C(  65), -INT8_C( 124), -INT8_C(  39),  INT8_C(   0), -INT8_C(  20) },
      UINT64_C( 9906073169161665985),
      {  INT8_C( 116), -INT8_C(  54), -INT8_C(  59),  INT8_C( 118), -INT8_C(   9), -INT8_C(   1), -INT8_C(  85), -INT8_C(  79),
         INT8_C(  10), -INT8_C( 115), -INT8_C(  96), -INT8_C(  27),  INT8_C(  83), -INT8_C(  92),  INT8_C(  23), -INT8_C( 102),
        -INT8_C(  90),  INT8_C( 112), -INT8_C(  37),  INT8_C(  42),  INT8_C(  73), -INT8_C(  37),  INT8_C(  23),  INT8_C(  10),
        -INT8_C( 104), -INT8_C(   1),  INT8_C(  24), -INT8_C(  87),  INT8_C( 112), -INT8_C( 110),  INT8_C(  50), -INT8_C(  27),
         INT8_C(  92), -INT8_C(   8),  INT8_C(  91),  INT8_C(  83), -INT8_C(   9),  INT8_C(   6),  INT8_C(   4),  INT8_C(   2),
        -INT8_C( 109), -INT8_C(  92), -INT8_C(  25), -INT8_C(  26),  INT8_C(  72), -INT8_C(   2),      INT8_MIN, -INT8_C(  17),
         INT8_C( 110),  INT8_C(  91),  INT8_C(  25), -INT8_C(  73),  INT8_C(  54),  INT8_C(  48), -INT8_C(  62), -INT8_C(  49),
         INT8_C(  47), -INT8_C(  38),  INT8_C( 120), -INT8_C(  96),  INT8_C( 108), -INT8_C(  86), -INT8_C( 123), -INT8_C(  56) },
      { -INT8_C(  94), -INT8_C(  32),  INT8_C(  27), -INT8_C( 102), -INT8_C(  25),  INT8_C(  31), -INT8_C( 100),  INT8_C( 122),
        -INT8_C(  60), -INT8_C( 125),  INT8_C(  97),  INT8_C(  12), -INT8_C( 127), -INT8_C(  31), -INT8_C(   5), -INT8_C(  17),
         INT8_C(  61),  INT8_C(  21), -INT8_C(  90),  INT8_C( 115),  INT8_C(  69),  INT8_C( 104),  INT8_C(  66),  INT8_C( 117),
         INT8_C(  67), -INT8_C(  70),  INT8_C(  21), -INT8_C(  81),  INT8_C( 101), -INT8_C( 102),  INT8_C( 120),  INT8_C(   7),
         INT8_C( 122), -INT8_C( 109), -INT8_C(  95),  INT8_C(  97), -INT8_C(  77),  INT8_C(  61), -INT8_C(  36),  INT8_C( 119),
        -INT8_C(  64),  INT8_C(  61), -INT8_C( 125),  INT8_C(  65),  INT8_C(  30),      INT8_MAX,  INT8_C(  48),  INT8_C(  91),
        -INT8_C( 108), -INT8_C(  41), -INT8_C(  49), -INT8_C(  39),  INT8_C(  63),  INT8_C(  17),  INT8_C(  78), -INT8_C( 126),
        -INT8_C(  52),  INT8_C(  99),  INT8_C(  50),  INT8_C(  49), -INT8_C(   3), -INT8_C(  86),  INT8_C(  56),  INT8_C( 120) },
      {  INT8_C(  22), -INT8_C(  25),  INT8_C( 103), -INT8_C(   2), -INT8_C( 109),  INT8_C( 101),  INT8_C(  71),  INT8_C(  43),
        -INT8_C(  50),  INT8_C(  38),  INT8_C(   1), -INT8_C(  15), -INT8_C(  44), -INT8_C( 123), -INT8_C(  36), -INT8_C( 119),
         INT8_C(  50), -INT8_C( 115), -INT8_C(  47), -INT8_C(  99),  INT8_C(  53),  INT8_C(  67),  INT8_C(  89),      INT8_MAX,
         INT8_C(  87), -INT8_C(  71),  INT8_C(  45),  INT8_C(  88), -INT8_C(   6), -INT8_C( 127),      INT8_MIN, -INT8_C(  65),
         INT8_C( 104), -INT8_C(  25), -INT8_C(  67), -INT8_C(   5), -INT8_C(  86),  INT8_C(  83), -INT8_C( 119),  INT8_C( 107),
         INT8_C(  83),  INT8_C(   3),  INT8_C(  80),  INT8_C(  60),  INT8_C( 102),  INT8_C( 125), -INT8_C(  80),  INT8_C(  52),
         INT8_C(   2),  INT8_C(  11), -INT8_C(  30), -INT8_C( 112),  INT8_C( 117),  INT8_C(  65),  INT8_C(  16),  INT8_C(  50),
        -INT8_C(   5),  INT8_C(   2),  INT8_C(  89), -INT8_C(  47), -INT8_C( 124), -INT8_C(  39),  INT8_C(   0),  INT8_C(  64) } },
    { {  INT8_C(  61), -INT8_C(  38), -INT8_C(  39), -INT8_C(  16),  INT8_C(  23), -INT8_C(  75),  INT8_C( 103), -INT8_C(  40),
        -INT8_C(  14), -INT8_C(  21),  INT8_C(  25),  INT8_C(  17),  INT8_C( 106),  INT8_C(  74),  INT8_C( 108), -INT8_C(   2),
         INT8_C(  33),  INT8_C(  59), -INT8_C(  41),  INT8_C(  96),  INT8_C(  77),  INT8_C(  38), -INT8_C(  29),  INT8_C(  25),
        -INT8_C( 119),  INT8_C(  21),  INT8_C(  74), -INT8_C( 121), -INT8_C(  65), -INT8_C( 126), -INT8_C(   1), -INT8_C(   4),
         INT8_C(  92), -INT8_C(  40), -INT8_C(  19),  INT8_C( 116), -INT8_C( 114),  INT8_C(  84),  INT8_C(  76),      INT8_MIN,
         INT8_C(  63),  INT8_C( 101), -INT8_C( 111), -INT8_C(  87), -INT8_C(  81), -INT8_C(   2), -INT8_C(  89), -INT8_C(  48),
         INT8_C(  57),      INT8_MAX,  INT8_C(  49), -INT8_C( 122), -INT8_C(  91),  INT8_C(  20), -INT8_C(  97),  INT8_C(  46),
         INT8_C(  41), -INT8_C(  23), -INT8_C(  75), -INT8_C(  24),  INT8_C( 108), -INT8_C(  76), -INT8_C(  28), -INT8_C(  56) },
      UINT64_C( 7321595316467978637),
      { -INT8_C(  18),  INT8_C(  45),  INT8_C(  15), -INT8_C(  99),  INT8_C(  43), -INT8_C(  74),  INT8_C( 110),  INT8_C( 100),
         INT8_C(  53), -INT8_C(  97), -INT8_C(  21), -INT8_C(  38), -INT8_C(  77), -INT8_C( 118),  INT8_C(   9), -INT8_C(  36),
         INT8_C( 116), -INT8_C(  66), -INT8_C(  60), -INT8_C(  32),  INT8_C( 115), -INT8_C(  88), -INT8_C(  88),  INT8_C(   0),
         INT8_C( 122), -INT8_C(  27),  INT8_C(  27), -INT8_C(  96),  INT8_C( 109), -INT8_C(  74),  INT8_C(   5),  INT8_C(  91),
        -INT8_C(  29),  INT8_C(  20), -INT8_C(   7),  INT8_C(  14), -INT8_C(  53),  INT8_C( 103),  INT8_C( 115),  INT8_C(   0),
         INT8_C(   6),  INT8_C(  94), -INT8_C(  37), -INT8_C(  71), -INT8_C(  24), -INT8_C(  28), -INT8_C( 107),  INT8_C(  92),
        -INT8_C(  94),  INT8_C(  89),  INT8_C(  60),  INT8_C(  21),  INT8_C(   1), -INT8_C(  27),  INT8_C(  21),  INT8_C( 123),
        -INT8_C(  54),  INT8_C(  48),  INT8_C(  27),  INT8_C(  55), -INT8_C(  25),  INT8_C(  33), -INT8_C( 109), -INT8_C(  54) },
      {  INT8_C(  53), -INT8_C( 116), -INT8_C(  39),  INT8_C(   0), -INT8_C(  13),  INT8_C(  76),  INT8_C(   1), -INT8_C(   7),
        -INT8_C(  86), -INT8_C(  36), -INT8_C(  78), -INT8_C( 110), -INT8_C(  64),  INT8_C(  71), -INT8_C(  17),  INT8_C(  98),
        -INT8_C(  96),  INT8_C(  43),  INT8_C( 120), -INT8_C(  95),  INT8_C(  16), -INT8_C( 115),  INT8_C(  29), -INT8_C(  38),
        -INT8_C(  66),  INT8_C(  56),  INT8_C(  18), -INT8_C(  91),  INT8_C(  89), -INT8_C(  91),  INT8_C( 111), -INT8_C( 113),
         INT8_C(  49),  INT8_C(  72), -INT8_C( 113),  INT8_C(  36), -INT8_C( 108), -INT8_C( 112),  INT8_C(  29),  INT8_C(  62),
         INT8_C( 108), -INT8_C(  49), -INT8_C(  47),  INT8_C(  44),  INT8_C(  22), -INT8_C(  64), -INT8_C( 113), -INT8_C(  74),
        -INT8_C(  21),  INT8_C(   7),  INT8_C(  87), -INT8_C(   4), -INT8_C( 108),  INT8_C( 116), -INT8_C(  42),  INT8_C(  82),
        -INT8_C(  83), -INT8_C(  24), -INT8_C(   9),  INT8_C(   6), -INT8_C( 115),  INT8_C( 103), -INT8_C( 107), -INT8_C(  66) },
      {  INT8_C(  35), -INT8_C(  38), -INT8_C(  24), -INT8_C(  99),  INT8_C(  23), -INT8_C(  75),  INT8_C( 103),  INT8_C(  93),
        -INT8_C(  33), -INT8_C(  21),  INT8_C(  25),  INT8_C(  17),  INT8_C( 115),  INT8_C(  74), -INT8_C(   8),  INT8_C(  62),
         INT8_C(  33),  INT8_C(  59),  INT8_C(  60), -INT8_C( 127), -INT8_C( 125),  INT8_C(  53), -INT8_C(  29),  INT8_C(  25),
         INT8_C(  56),  INT8_C(  29),  INT8_C(  74),  INT8_C(  69), -INT8_C(  58), -INT8_C( 126), -INT8_C(   1), -INT8_C(   4),
         INT8_C(  92),  INT8_C(  92), -INT8_C( 120),  INT8_C( 116), -INT8_C( 114), -INT8_C(   9),  INT8_C(  76),      INT8_MIN,
         INT8_C(  63),  INT8_C( 101), -INT8_C( 111), -INT8_C(  27), -INT8_C(  81), -INT8_C(   2), -INT8_C(  89),  INT8_C(  18),
        -INT8_C( 115),  INT8_C(  96),  INT8_C(  49),  INT8_C(  17), -INT8_C( 107),  INT8_C(  20), -INT8_C(  97), -INT8_C(  51),
         INT8_C( 119), -INT8_C(  23),  INT8_C(  18), -INT8_C(  24),  INT8_C( 108), -INT8_C( 120),  INT8_C(  40), -INT8_C(  56) } },
    { { -INT8_C(  81),  INT8_C(  37), -INT8_C(  30),  INT8_C(  68), -INT8_C(  75), -INT8_C(   1), -INT8_C( 126),  INT8_C(  34),
        -INT8_C(  50),  INT8_C(  83),  INT8_C(  78), -INT8_C(  28),  INT8_C(  19), -INT8_C(  35), -INT8_C( 102), -INT8_C(   1),
        -INT8_C(  28), -INT8_C(  14), -INT8_C(   5),  INT8_C( 121),  INT8_C( 102), -INT8_C(  47), -INT8_C(  53),  INT8_C(  19),
        -INT8_C(  70), -INT8_C(  61),  INT8_C(  26),  INT8_C(  71),  INT8_C(  42), -INT8_C(  81),  INT8_C(   6), -INT8_C(  39),
        -INT8_C(  44), -INT8_C(  24),  INT8_C(  29), -INT8_C( 118), -INT8_C(  24), -INT8_C(  96), -INT8_C(  84), -INT8_C(  74),
        -INT8_C(  13), -INT8_C(   6), -INT8_C( 101),  INT8_C(   7), -INT8_C(  40),  INT8_C(  53),  INT8_C(   6), -INT8_C(  68),
         INT8_C(  39),  INT8_C(   1),  INT8_C(  53), -INT8_C( 114), -INT8_C(  46),  INT8_C(   1), -INT8_C(  95), -INT8_C( 116),
        -INT8_C(  60), -INT8_C(  69), -INT8_C(  44), -INT8_C(  18),  INT8_C( 107), -INT8_C(  38), -INT8_C(  57),  INT8_C(  63) },
      UINT64_C( 8674343574248744386),
      {  INT8_C( 112), -INT8_C(   4),      INT8_MAX,  INT8_C(  72),  INT8_C(  49), -INT8_C( 123),  INT8_C(   4),  INT8_C(  89),
        -INT8_C( 122),  INT8_C(  58), -INT8_C(  25),  INT8_C(  89),  INT8_C(  59), -INT8_C( 120), -INT8_C(  27), -INT8_C(   1),
         INT8_C(  68), -INT8_C(  71), -INT8_C(  19), -INT8_C(  81), -INT8_C( 109), -INT8_C(  76), -INT8_C(  18),  INT8_C(  86),
        -INT8_C( 103), -INT8_C(  72),  INT8_C(   0),  INT8_C(  30),  INT8_C(  45),  INT8_C(  97), -INT8_C( 105), -INT8_C(  99),
         INT8_C(  93),  INT8_C(  22), -INT8_C(  27), -INT8_C( 113), -INT8_C( 100), -INT8_C(  22), -INT8_C(  24),  INT8_C(  34),
         INT8_C(  36), -INT8_C(  49),  INT8_C( 123),  INT8_C(  95),  INT8_C(  87),  INT8_C(  97),  INT8_C(  94), -INT8_C( 101),
         INT8_C(  26),  INT8_C(  75),  INT8_C(  74), -INT8_C(  82), -INT8_C(   1),  INT8_C(  57),  INT8_C(   4), -INT8_C( 103),
        -INT8_C(  15),  INT8_C(   4), -INT8_C(  73),  INT8_C(  30),  INT8_C( 102),  INT8_C(  78), -INT8_C(  68), -INT8_C(  61) },
      {  INT8_C( 101), -INT8_C(  95),  INT8_C(  82),  INT8_C(   1), -INT8_C( 117),  INT8_C(  58),  INT8_C(  35), -INT8_C(  81),
         INT8_C(   9), -INT8_C(  97),  INT8_C(  14),  INT8_C(  97),  INT8_C(   0),  INT8_C( 108), -INT8_C(   4),  INT8_C(  26),
        -INT8_C(  73),  INT8_C(  71), -INT8_C(  56), -INT8_C(  73),      INT8_MIN, -INT8_C(  52),  INT8_C(  80),  INT8_C( 113),
        -INT8_C(  47),  INT8_C(   7), -INT8_C( 113),  INT8_C(  55),  INT8_C(  86),  INT8_C(  75), -INT8_C(   6), -INT8_C(  69),
        -INT8_C(  19),  INT8_C(  77), -INT8_C(  68),  INT8_C( 120), -INT8_C( 121), -INT8_C(  33),  INT8_C(  40), -INT8_C( 111),
         INT8_C( 126),  INT8_C(  54), -INT8_C(  14),  INT8_C( 126), -INT8_C(  93), -INT8_C(  18), -INT8_C( 103),  INT8_C(  90),
         INT8_C(  53),  INT8_C(  97),  INT8_C(  17), -INT8_C(  75),  INT8_C(  46),  INT8_C(  97),  INT8_C(  38), -INT8_C(   1),
         INT8_C( 105), -INT8_C(  74),  INT8_C(  54), -INT8_C(  65),  INT8_C(   1),  INT8_C(  48),  INT8_C( 122), -INT8_C(  18) },
      { -INT8_C(  81), -INT8_C(  99), -INT8_C(  30),  INT8_C(  68), -INT8_C(  75), -INT8_C(   1),  INT8_C(  39),  INT8_C(   8),
        -INT8_C( 113),  INT8_C(  83), -INT8_C(  11), -INT8_C(  28),  INT8_C(  19), -INT8_C(  12), -INT8_C(  31),  INT8_C(  25),
        -INT8_C(   5), -INT8_C(  14), -INT8_C(   5),  INT8_C( 102),  INT8_C( 102), -INT8_C(  47),  INT8_C(  62), -INT8_C(  57),
        -INT8_C(  70), -INT8_C(  65),  INT8_C(  26),  INT8_C(  85),  INT8_C(  42), -INT8_C(  84),  INT8_C(   6),  INT8_C(  88),
         INT8_C(  74), -INT8_C(  24), -INT8_C(  95), -INT8_C( 118), -INT8_C(  24), -INT8_C(  96), -INT8_C(  84), -INT8_C(  77),
        -INT8_C(  94), -INT8_C(   6),  INT8_C( 109),  INT8_C(   7), -INT8_C(   6),  INT8_C(  79), -INT8_C(   9), -INT8_C(  68),
         INT8_C(  79),  INT8_C(   1),  INT8_C(  53), -INT8_C( 114), -INT8_C(  46), -INT8_C( 102),  INT8_C(  42), -INT8_C( 116),
        -INT8_C(  60), -INT8_C(  69), -INT8_C(  44), -INT8_C(  35),  INT8_C( 103),  INT8_C( 126),  INT8_C(  54),  INT8_C(  63) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i src = simde_mm512_loadu_epi8(test_vec[i].src);
    simde__m512i a = simde_mm512_loadu_epi8(test_vec[i].a);
    simde__m512i b = simde_mm512_loadu_epi8(test_vec[i].b);
    simde__m512i r = simde_mm512_mask_add_epi8(src, test_vec[i].k, a, b);
    simde_test_x86_assert_equal_i8x64(r, simde_mm512_loadu_epi8(test_vec[i].r));
  }

  return 0;
}

static int
test_simde_mm512_maskz_add_epi8 (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const simde__mmask64 k;
    const int8_t a[64];
    const int8_t b[64];
    const int8_t r[64];
  } test_vec[] = {
    { UINT64_C( 9122680976650596708),
      {  INT8_C(  68), -INT8_C(  57),  INT8_C(  11), -INT8_C( 119), -INT8_C( 113),  INT8_C( 124),  INT8_C(  91),  INT8_C(   1),
         INT8_C( 112), -INT8_C( 126),  INT8_C(  44), -INT8_C(  65),  INT8_C(  76), -INT8_C(  60), -INT8_C(  30),  INT8_C(  88),
        -INT8_C(   8),  INT8_C(  72), -INT8_C(  34), -INT8_C( 108),  INT8_C(   2),  INT8_C(  65), -INT8_C(  12),  INT8_C( 102),
         INT8_C(  50),  INT8_C( 109),  INT8_C(  10),  INT8_C(  54), -INT8_C(  77), -INT8_C(  91), -INT8_C(  76), -INT8_C(   9),
         INT8_C( 108), -INT8_C(  65),      INT8_MIN, -INT8_C(   5),  INT8_C(  60), -INT8_C(  36), -INT8_C(   4), -INT8_C(  84),
         INT8_C(  94),  INT8_C(  40),  INT8_C( 108), -INT8_C(  86), -INT8_C(  20),  INT8_C(  78),  INT8_C(   2), -INT8_C(  27),
        -INT8_C( 106), -INT8_C(  32),  INT8_C( 121), -INT8_C( 104),  INT8_C(  34),  INT8_C( 110), -INT8_C(   2),  INT8_C(  84),
        -INT8_C(  37),  INT8_C(   8), -INT8_C( 118), -INT8_C( 114), -INT8_C(  83),  INT8_C(  63), -INT8_C( 122),  INT8_C(  25) },
      { -INT8_C(   2),  INT8_C(   6),  INT8_C(  20),  INT8_C(  58), -INT8_C(  30),  INT8_C(  16), -INT8_C(  25),  INT8_C(  65),
         INT8_C(  56),  INT8_C(  83), -INT8_C(  21),  INT8_C(  37), -INT8_C(  95), -INT8_C(  18),  INT8_C(  10),  INT8_C(  55),
        -INT8_C(  50), -INT8_C( 125), -INT8_C(  49), -INT8_C(  16), -INT8_C(  15), -INT8_C(  51),  INT8_C(  69), -INT8_C(  52),
        -INT8_C(  43), -INT8_C(  49),  INT8_C(  91), -INT8_C( 125),  INT8_C(  14), -INT8_C(  31), -INT8_C( 100),  INT8_C(  13),
        -INT8_C(  25), -INT8_C(  79),  INT8_C(  71), -INT8_C(  54), -INT8_C(  63),  INT8_C(  46),  INT8_C(  11), -INT8_C(   6),
        -INT8_C( 127), -INT8_C(  10),  INT8_C(  31),  INT8_C(  34), -INT8_C(  28),  INT8_C(  41),  INT8_C(  89), -INT8_C(  77),
        -INT8_C(  84),  INT8_C(  40), -INT8_C(  93), -INT8_C(  98), -INT8_C(  11), -INT8_C(  24),  INT8_C( 106), -INT8_C(  53),
        -INT8_C(  72), -INT8_C(  59),  INT8_C(  78), -INT8_C(  58), -INT8_C(  90), -INT8_C(  22), -INT8_C(  45), -INT8_C( 114) },
      {  INT8_C(   0),  INT8_C(   0),  INT8_C(  31),  INT8_C(   0),  INT8_C(   0), -INT8_C( 116),  INT8_C(  66),  INT8_C(   0),
        -INT8_C(  88),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0), -INT8_C(  19), -INT8_C(  78), -INT8_C(  20), -INT8_C( 113),
         INT8_C(   0),  INT8_C(   0),  INT8_C(   0), -INT8_C( 124), -INT8_C(  13),  INT8_C(  14),  INT8_C(  57),  INT8_C(   0),
         INT8_C(   0),  INT8_C(   0),  INT8_C( 101),  INT8_C(   0),  INT8_C(   0), -INT8_C( 122),  INT8_C(   0),  INT8_C(   4),
         INT8_C(  83),  INT8_C( 112),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
         INT8_C(   0),  INT8_C(  30), -INT8_C( 117),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(  91),  INT8_C(   0),
         INT8_C(   0),  INT8_C(   8),  INT8_C(   0),  INT8_C(  54),  INT8_C(  23),  INT8_C(   0),  INT8_C(   0),  INT8_C(  31),
         INT8_C(   0), -INT8_C(  51), -INT8_C(  40),  INT8_C(  84),  INT8_C(  83),  INT8_C(  41),  INT8_C(  89),  INT8_C(   0) } },
    { UINT64_C(14652289079423015835),
      {  INT8_C(  89),  INT8_C( 118), -INT8_C(  19),  INT8_C(  62), -INT8_C(  97),  INT8_C(  71), -INT8_C(  15),  INT8_C(  75),
         INT8_C( 111), -INT8_C( 108), -INT8_C(  23),  INT8_C( 101),  INT8_C( 125),  INT8_C(  84),  INT8_C(  48),  INT8_C(  53),
         INT8_C(  25),  INT8_C( 126), -INT8_C(   5), -INT8_C(  64),  INT8_C( 104), -INT8_C(  49),  INT8_C(  78),  INT8_C(   4),
        -INT8_C(  22), -INT8_C(  90),  INT8_C(  97),  INT8_C(  51),  INT8_C(   9), -INT8_C(  72), -INT8_C(   2),  INT8_C(  98),
         INT8_C(  46), -INT8_C(  20), -INT8_C(  96), -INT8_C(  51),  INT8_C(  51), -INT8_C( 111),  INT8_C(  24), -INT8_C(  94),
         INT8_C(  38),  INT8_C(   2),  INT8_C(   7), -INT8_C(  93),  INT8_C(  86),  INT8_C(  55), -INT8_C(  40),  INT8_C( 111),
        -INT8_C(  75), -INT8_C(  45),  INT8_C(  47),  INT8_C(  30), -INT8_C(  94),  INT8_C( 125),  INT8_C(  34), -INT8_C( 116),
         INT8_C(  35), -INT8_C( 125), -INT8_C(  64),  INT8_C(  44),  INT8_C(  59), -INT8_C(  66), -INT8_C( 113),  INT8_C( 105) },
      { -INT8_C(  86),  INT8_C(  47),  INT8_C(  54), -INT8_C(  35), -INT8_C(  63),  INT8_C(  78),      INT8_MIN, -INT8_C(  25),
         INT8_C(  80), -INT8_C( 121), -INT8_C( 118), -INT8_C(  90), -INT8_C(  65),  INT8_C(  98),  INT8_C(  22),  INT8_C( 116),
         INT8_C(  53),  INT8_C(  69), -INT8_C( 110), -INT8_C(  40), -INT8_C(  61), -INT8_C(  76),  INT8_C( 100), -INT8_C(  26),
         INT8_C(  55),  INT8_C(  36),  INT8_C(  19),  INT8_C( 114), -INT8_C(  29), -INT8_C(  94), -INT8_C(  37), -INT8_C( 115),
        -INT8_C(  47),  INT8_C(  17),  INT8_C( 107), -INT8_C( 110),  INT8_C(  96), -INT8_C(  21),  INT8_C( 121), -INT8_C(  80),
         INT8_C( 114),  INT8_C(   3),  INT8_C(  87),  INT8_C(  49),  INT8_C( 101),  INT8_C( 109), -INT8_C(  90), -INT8_C( 101),
        -INT8_C(  78),  INT8_C(  56),  INT8_C( 115),  INT8_C( 117), -INT8_C(  19), -INT8_C(  41),  INT8_C(  92),  INT8_C(  36),
        -INT8_C(   4),  INT8_C( 111), -INT8_C( 105), -INT8_C(  33),  INT8_C(  17),  INT8_C( 114),  INT8_C( 108), -INT8_C(  30) },
      {  INT8_C(   3), -INT8_C(  91),  INT8_C(   0),  INT8_C(  27),  INT8_C(  96),  INT8_C(   0),  INT8_C(   0),  INT8_C(  50),
        -INT8_C(  65),  INT8_C(  27),  INT8_C(   0),  INT8_C(  11),  INT8_C(  60),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
         INT8_C(   0),  INT8_C(   0),  INT8_C(   0), -INT8_C( 104),  INT8_C(  43),  INT8_C(   0), -INT8_C(  78),  INT8_C(   0),
         INT8_C(  33),  INT8_C(   0),  INT8_C( 116), -INT8_C(  91), -INT8_C(  20),  INT8_C(   0), -INT8_C(  39),  INT8_C(   0),
        -INT8_C(   1),  INT8_C(   0),  INT8_C(   0),  INT8_C(  95),  INT8_C(   0),  INT8_C(   0), -INT8_C( 111),  INT8_C(   0),
        -INT8_C( 104),  INT8_C(   5),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0), -INT8_C(  92),  INT8_C( 126),  INT8_C(   0),
         INT8_C( 103),  INT8_C(  11), -INT8_C(  94),  INT8_C(   0), -INT8_C( 113),  INT8_C(   0),  INT8_C( 126),  INT8_C(   0),
         INT8_C(  31), -INT8_C(  14),  INT8_C(   0),  INT8_C(  11),  INT8_C(   0),  INT8_C(   0), -INT8_C(   5),  INT8_C(  75) } },
    { UINT64_C( 3860973301387351940),
      { -INT8_C(  14), -INT8_C(  21),  INT8_C( 102),  INT8_C(  87),  INT8_C(  88),  INT8_C(  12), -INT8_C(  14),  INT8_C(  11),
         INT8_C(  69),  INT8_C( 101),      INT8_MIN,  INT8_C(  50),  INT8_C(  61), -INT8_C(  36),  INT8_C(  86),  INT8_C(  57),
         INT8_C(  75), -INT8_C(  19),  INT8_C(  24),  INT8_C(  92),  INT8_C(  96), -INT8_C( 124),  INT8_C(  63), -INT8_C(  28),
         INT8_C(  92), -INT8_C(  76), -INT8_C(  56),  INT8_C(  30), -INT8_C(  94),  INT8_C(  92),  INT8_C(  83), -INT8_C( 108),
         INT8_C(  72), -INT8_C(  70), -INT8_C(  20), -INT8_C(  96), -INT8_C(  58), -INT8_C(  34), -INT8_C(  85),  INT8_C(  11),
         INT8_C(  68),  INT8_C(  44),  INT8_C(  61), -INT8_C( 127),  INT8_C(   8), -INT8_C( 108), -INT8_C(  70),  INT8_C(  84),
        -INT8_C( 127), -INT8_C(  46), -INT8_C(  80), -INT8_C(  31),  INT8_C(  86), -INT8_C(  17), -INT8_C(  59), -INT8_C(  78),
        -INT8_C(  93), -INT8_C( 115), -INT8_C(  47),  INT8_C(  70), -INT8_C(  22),  INT8_C(  36), -INT8_C(  38),  INT8_C(  50) },
      { -INT8_C(  34), -INT8_C(  58), -INT8_C(  46), -INT8_C(  91), -INT8_C(  91),  INT8_C( 126), -INT8_C(  80), -INT8_C(  23),
        -INT8_C(  86), -INT8_C(  18),  INT8_C( 106), -INT8_C(  78), -INT8_C( 126),  INT8_C(  36),  INT8_C(   6),  INT8_C(   3),
        -INT8_C(  10), -INT8_C(  73), -INT8_C(  27),  INT8_C(  76), -INT8_C(  90), -INT8_C(  86), -INT8_C(   1),  INT8_C(  74),
         INT8_C(  56), -INT8_C(  48), -INT8_C( 112),  INT8_C(  34), -INT8_C(  12),  INT8_C( 106),  INT8_C(  84), -INT8_C(  45),
         INT8_C(  49),  INT8_C(  38),  INT8_C( 120), -INT8_C(  42), -INT8_C(  92),  INT8_C(  40), -INT8_C(  65),  INT8_C(  78),
         INT8_C(  22),  INT8_C(  41),  INT8_C(   1), -INT8_C( 104),  INT8_C(  77),  INT8_C(   7), -INT8_C( 100),  INT8_C(  67),
        -INT8_C(  66), -INT8_C( 127), -INT8_C( 113),  INT8_C( 101),  INT8_C(  43), -INT8_C( 114), -INT8_C(  81),  INT8_C(  99),
         INT8_C(  94),  INT8_C(  63), -INT8_C( 123),  INT8_C(  83), -INT8_C(  87), -INT8_C(  39),  INT8_C(  38), -INT8_C(  38) },
      {  INT8_C(   0),  INT8_C(   0),  INT8_C(  56),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0), -INT8_C(  12),
        -INT8_C(  17),  INT8_C(  83), -INT8_C(  22),  INT8_C(   0), -INT8_C(  65),  INT8_C(   0),  INT8_C(  92),  INT8_C(  60),
         INT8_C(  65),  INT8_C(   0), -INT8_C(   3),  INT8_C(   0),  INT8_C(   6),  INT8_C(  46),  INT8_C(  62),  INT8_C(   0),
         INT8_C(   0),  INT8_C(   0),  INT8_C(  88),  INT8_C(   0),  INT8_C(   0), -INT8_C(  58), -INT8_C(  89),  INT8_C( 103),
         INT8_C(   0), -INT8_C(  32),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C( 106),  INT8_C(  89),
         INT8_C(   0),  INT8_C(  85),  INT8_C(  62),  INT8_C(  25),  INT8_C(   0), -INT8_C( 101),  INT8_C(  86), -INT8_C( 105),
         INT8_C(   0),  INT8_C(   0),  INT8_C(  63),  INT8_C(   0), -INT8_C( 127),  INT8_C(   0),  INT8_C(   0),  INT8_C(  21),
         INT8_C(   1),  INT8_C(   0),  INT8_C(  86),  INT8_C(   0), -INT8_C( 109), -INT8_C(   3),  INT8_C(   0),  INT8_C(   0) } },
    { UINT64_C(15993249600680009216),
      { -INT8_C( 104), -INT8_C(  12),  INT8_C( 117), -INT8_C(  27), -INT8_C(   5),  INT8_C(  17),  INT8_C(  40), -INT8_C(  70),
        -INT8_C( 110), -INT8_C(  72),  INT8_C(  31), -INT8_C(  66),  INT8_C(  70), -INT8_C(  50),  INT8_C(  33), -INT8_C(  91),
         INT8_C(  13), -INT8_C(  89), -INT8_C(   8), -INT8_C(  74),      INT8_MIN,  INT8_C(  30), -INT8_C( 111),      INT8_MIN,
        -INT8_C(  68),  INT8_C(  65),  INT8_C(  37), -INT8_C( 126), -INT8_C(  79),  INT8_C(  24),  INT8_C(  95),  INT8_C(  73),
         INT8_C(  12), -INT8_C(  43),  INT8_C(  47),  INT8_C(   7), -INT8_C(  26),  INT8_C(  87), -INT8_C(  63),  INT8_C( 121),
         INT8_C(  15), -INT8_C(  32),  INT8_C(  55),  INT8_C(  86), -INT8_C(  82),  INT8_C(  88), -INT8_C(   5), -INT8_C(  69),
        -INT8_C(   1), -INT8_C(  13),  INT8_C( 114),      INT8_MIN,  INT8_C(  17),  INT8_C(   3),  INT8_C(   0), -INT8_C(  51),
         INT8_C(  68),  INT8_C(  37),  INT8_C(  79), -INT8_C(  11),  INT8_C(  61), -INT8_C(  81),  INT8_C(  63),  INT8_C(  73) },
      { -INT8_C( 124),  INT8_C( 110),  INT8_C(  81),  INT8_C( 106), -INT8_C(  59),  INT8_C(  18), -INT8_C(  29), -INT8_C(  43),
        -INT8_C(  13),  INT8_C(  26),  INT8_C(  43), -INT8_C(  95),  INT8_C( 115),  INT8_C(  38),  INT8_C(  93),  INT8_C( 114),
         INT8_C(  25), -INT8_C(  49), -INT8_C(  14),  INT8_C(  42), -INT8_C(  46), -INT8_C(  13), -INT8_C(   9),  INT8_C(  22),
         INT8_C(  24),  INT8_C(  70),  INT8_C(  12),  INT8_C(  86), -INT8_C(  11),  INT8_C(  75), -INT8_C(  97),  INT8_C( 121),
        -INT8_C(  71), -INT8_C(  16), -INT8_C(  28),  INT8_C( 126),  INT8_C(   3), -INT8_C(  57),  INT8_C(  83), -INT8_C(  10),
        -INT8_C(  30),  INT8_C( 126), -INT8_C( 105),  INT8_C(  85), -INT8_C(  92), -INT8_C(  12), -INT8_C(  57), -INT8_C(  67),
        -INT8_C(  61), -INT8_C(  70), -INT8_C(  25), -INT8_C( 107), -INT8_C(  83), -INT8_C(  34), -INT8_C(  84), -INT8_C(  59),
         INT8_C(  37), -INT8_C(  72),  INT8_C(  27),  INT8_C(  26),  INT8_C(   3), -INT8_C(  69), -INT8_C( 108), -INT8_C(  68) },
      {  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
         INT8_C(   0), -INT8_C(  46),  INT8_C(  74),  INT8_C(  95), -INT8_C(  71),  INT8_C(   0),  INT8_C(   0),  INT8_C(  23),
         INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(  82),  INT8_C(  17),  INT8_C(   0), -INT8_C( 106),
         INT8_C(   0),  INT8_C(   0),  INT8_C(  49),  INT8_C(   0),  INT8_C(   0),  INT8_C(  99),  INT8_C(   0), -INT8_C(  62),
         INT8_C(   0), -INT8_C(  59),  INT8_C(  19),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(  20),  INT8_C( 111),
        -INT8_C(  15),  INT8_C(  94), -INT8_C(  50), -INT8_C(  85),  INT8_C(   0),  INT8_C(  76), -INT8_C(  62),  INT8_C(   0),
        -INT8_C(  62), -INT8_C(  83),  INT8_C(   0),  INT8_C(   0), -INT8_C(  66), -INT8_C(  31), -INT8_C(  84), -INT8_C( 110),
         INT8_C( 105),  INT8_C(   0),  INT8_C( 106),  INT8_C(  15),  INT8_C(  64),  INT8_C(   0), -INT8_C(  45),  INT8_C(   5) } },
    { UINT64_C( 2424218903589320875),
      {  INT8_C(  12),  INT8_C(  60),  INT8_C( 118), -INT8_C(  79),  INT8_C(  48),  INT8_C(  62),  INT8_C( 110), -INT8_C(  12),
        -INT8_C(   8),  INT8_C(  86), -INT8_C( 119), -INT8_C(  91),  INT8_C(  52),  INT8_C(  53),  INT8_C( 106),  INT8_C(  89),
        -INT8_C(  19), -INT8_C( 122),  INT8_C( 116), -INT8_C(  16),  INT8_C(  65),  INT8_C(   8), -INT8_C(  84), -INT8_C(  20),
             INT8_MIN, -INT8_C(  25), -INT8_C( 101), -INT8_C(  65),  INT8_C( 117),  INT8_C(  63), -INT8_C(  31), -INT8_C( 127),
         INT8_C( 123),  INT8_C(  87),  INT8_C(  50), -INT8_C(  84), -INT8_C( 107), -INT8_C(  95), -INT8_C(  96), -INT8_C( 115),
        -INT8_C(   9),  INT8_C(  41),  INT8_C(  50),  INT8_C(  43),  INT8_C(  95), -INT8_C(  99), -INT8_C( 123),  INT8_C(  76),
         INT8_C(  35), -INT8_C(   7),  INT8_C(  61),  INT8_C( 100),  INT8_C(   1), -INT8_C(  23),  INT8_C(  80), -INT8_C( 127),
        -INT8_C(  48), -INT8_C(  21),  INT8_C(  64),  INT8_C(  69),  INT8_C(  43),  INT8_C(  33), -INT8_C(  57), -INT8_C(  90) },
      {  INT8_C( 121), -INT8_C(   7),  INT8_C(  82),  INT8_C(  14), -INT8_C( 102), -INT8_C(  14), -INT8_C( 100), -INT8_C( 111),
         INT8_C(  28), -INT8_C(  50), -INT8_C(  67),  INT8_C( 123),  INT8_C( 107),  INT8_C(  66), -INT8_C(  57), -INT8_C( 114),
         INT8_C(  59),  INT8_C(   4), -INT8_C(  14),  INT8_C(  60), -INT8_C(  18),  INT8_C(  67), -INT8_C(  67), -INT8_C(  66),
         INT8_C(  46), -INT8_C(   3),  INT8_C(   4),  INT8_C(  89),  INT8_C(  31), -INT8_C(  53),  INT8_C(   0), -INT8_C( 104),
        -INT8_C(  60),  INT8_C(  82), -INT8_C(  90),  INT8_C(  95),  INT8_C(  69),  INT8_C(  66), -INT8_C(  16),  INT8_C(  97),
         INT8_C(  17), -INT8_C(  83), -INT8_C(  36),  INT8_C( 124), -INT8_C(  17), -INT8_C(  93),  INT8_C(  11),  INT8_C(  42),
        -INT8_C(  88), -INT8_C(   3),  INT8_C( 102), -INT8_C( 106),  INT8_C(  64),  INT8_C(  35),  INT8_C(  84),  INT8_C( 111),
         INT8_C(  33),  INT8_C(  88), -INT8_C(  56),  INT8_C(  64),  INT8_C(  35), -INT8_C(  56), -INT8_C(  40), -INT8_C(  24) },
      { -INT8_C( 123),  INT8_C(  53),  INT8_C(   0), -INT8_C(  65),  INT8_C(   0),  INT8_C(  48),  INT8_C(   0), -INT8_C( 123),
         INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(  32), -INT8_C(  97),  INT8_C( 119),  INT8_C(  49),  INT8_C(   0),
         INT8_C(   0), -INT8_C( 118),  INT8_C(   0),  INT8_C(  44),  INT8_C(  47),  INT8_C(  75),  INT8_C(   0),  INT8_C(   0),
         INT8_C(   0), -INT8_C(  28), -INT8_C(  97),  INT8_C(  24),  INT8_C(   0),  INT8_C(  10),  INT8_C(   0),  INT8_C(  25),
         INT8_C(  63), -INT8_C(  87), -INT8_C(  40),  INT8_C(  11), -INT8_C(  38), -INT8_C(  29),  INT8_C(   0),  INT8_C(   0),
         INT8_C(   0), -INT8_C(  42),  INT8_C(  14), -INT8_C(  89),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C( 118),
         INT8_C(   0),  INT8_C(   0), -INT8_C(  93),  INT8_C(   0),  INT8_C(   0),  INT8_C(  12),  INT8_C(   0), -INT8_C(  16),
        -INT8_C(  15),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0), -INT8_C(  23),  INT8_C(   0),  INT8_C(   0) } },
    { UINT64_C(15186480722153537051),
      { -INT8_C(  27), -INT8_C(  99),  INT8_C(  78), -INT8_C(  44),  INT8_C(  64),  INT8_C(  89), -INT8_C(   1), -INT8_C(  24),
         INT8_C(  87),  INT8_C( 101),  INT8_C( 126), -INT8_C( 105), -INT8_C( 119), -INT8_C(  45),  INT8_C(   6), -INT8_C(  86),
         INT8_C(  43), -INT8_C(  49), -INT8_C(  22),  INT8_C(  79), -INT8_C( 105), -INT8_C(  62),  INT8_C(  55), -INT8_C(  78),
         INT8_C(  64),  INT8_C( 126),  INT8_C(  18),  INT8_C(   1), -INT8_C(  75), -INT8_C(  45), -INT8_C(  45), -INT8_C( 102),
         INT8_C( 112),  INT8_C(  34),  INT8_C( 111), -INT8_C(  79),  INT8_C( 123),  INT8_C( 110), -INT8_C( 103), -INT8_C(  46),
        -INT8_C(  45),  INT8_C(  24),  INT8_C( 106),  INT8_C(  92), -INT8_C(  21),  INT8_C( 112),  INT8_C(   6),  INT8_C(  22),
         INT8_C(  63), -INT8_C(  16),  INT8_C( 101), -INT8_C(  41), -INT8_C(  78), -INT8_C( 100), -INT8_C( 119), -INT8_C(  13),
         INT8_C(  26), -INT8_C( 100), -INT8_C(  12), -INT8_C(  48),  INT8_C( 111), -INT8_C(  56),  INT8_C( 106), -INT8_C(  32) },
      { -INT8_C(  22), -INT8_C(  39), -INT8_C( 111),  INT8_C( 101),  INT8_C(  71),  INT8_C(  42),  INT8_C(  56),  INT8_C(  27),
         INT8_C(  66), -INT8_C(  94),  INT8_C( 119),  INT8_C(  45),  INT8_C(  18),  INT8_C( 126),  INT8_C(  68),  INT8_C(  82),
         INT8_C( 110), -INT8_C(  87),  INT8_C(  41),  INT8_C(  33),  INT8_C(  70), -INT8_C(  78),  INT8_C(  20),  INT8_C(  96),
         INT8_C(  78),  INT8_C(   8),  INT8_C(  48), -INT8_C(  66), -INT8_C(  48), -INT8_C( 101), -INT8_C(  98), -INT8_C(  70),
         INT8_C( 116),  INT8_C(  47),  INT8_C(  32), -INT8_C(  68),  INT8_C(  89),  INT8_C(  88), -INT8_C(  41), -INT8_C( 100),
        -INT8_C(   6),  INT8_C(  78), -INT8_C(  55),  INT8_C(  12), -INT8_C(  52),  INT8_C(  13),  INT8_C(  94),  INT8_C(  59),
        -INT8_C(  73), -INT8_C( 121),  INT8_C(  92), -INT8_C(   3),  INT8_C(  58),  INT8_C( 112),  INT8_C(  93), -INT8_C( 120),
         INT8_C( 120), -INT8_C( 114),  INT8_C(  70),  INT8_C(  73),  INT8_C(  41), -INT8_C(  28),  INT8_C(   3), -INT8_C(  99) },
      { -INT8_C(  49),  INT8_C( 118),  INT8_C(   0),  INT8_C(  57), -INT8_C( 121),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
         INT8_C(   0),  INT8_C(   7), -INT8_C(  11), -INT8_C(  60), -INT8_C( 101),  INT8_C(  81),  INT8_C(  74),  INT8_C(   0),
        -INT8_C( 103),  INT8_C( 120),  INT8_C(  19),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(  75),  INT8_C(   0),
         INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C( 110),  INT8_C( 113),  INT8_C(   0),
        -INT8_C(  28),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C( 112),  INT8_C( 110),
        -INT8_C(  51),  INT8_C( 102),  INT8_C(  51),  INT8_C(   0), -INT8_C(  73),  INT8_C( 125),  INT8_C(   0),  INT8_C(   0),
        -INT8_C(  10),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0), -INT8_C(  26),  INT8_C( 123),
         INT8_C(   0),  INT8_C(  42),  INT8_C(   0),  INT8_C(   0), -INT8_C( 104),  INT8_C(   0),  INT8_C( 109),  INT8_C( 125) } },
    { UINT64_C( 8433325083901633299),
      {      INT8_MAX, -INT8_C(  46), -INT8_C( 126),  INT8_C(  75), -INT8_C(  32), -INT8_C(  32), -INT8_C( 122), -INT8_C( 105),
         INT8_C( 104), -INT8_C(  30), -INT8_C( 108), -INT8_C(  94),  INT8_C(  82), -INT8_C(  15),  INT8_C(  42), -INT8_C(  53),
             INT8_MAX,  INT8_C( 113),  INT8_C(  20), -INT8_C(  88),  INT8_C(  85),  INT8_C(  23),  INT8_C(  70),  INT8_C( 105),
         INT8_C(  59), -INT8_C(  97), -INT8_C(  42), -INT8_C(  74), -INT8_C(  48), -INT8_C(  33),  INT8_C(  44),  INT8_C(  79),
        -INT8_C(  79), -INT8_C(  82), -INT8_C( 102), -INT8_C( 111), -INT8_C( 114),  INT8_C(  33),  INT8_C(  40), -INT8_C(  10),
         INT8_C(   3), -INT8_C(  68), -INT8_C( 104),  INT8_C(  86), -INT8_C(  82), -INT8_C(  61),  INT8_C(  33),  INT8_C(  45),
         INT8_C(  52),  INT8_C(  53), -INT8_C(  42), -INT8_C( 119),  INT8_C(  76),  INT8_C(  28), -INT8_C(  14), -INT8_C( 121),
        -INT8_C(  69), -INT8_C(  56),  INT8_C(  62), -INT8_C( 117), -INT8_C(  89),  INT8_C( 106), -INT8_C(  38),  INT8_C(  89) },
      {  INT8_C(  24),  INT8_C( 117), -INT8_C(  22), -INT8_C(  90), -INT8_C( 106),  INT8_C(  19), -INT8_C(  99), -INT8_C( 103),
        -INT8_C(  49),  INT8_C(  53), -INT8_C(  17),  INT8_C( 125), -INT8_C(   8),  INT8_C(  16), -INT8_C(  85),  INT8_C(  44),
         INT8_C(  69), -INT8_C( 127), -INT8_C(  74), -INT8_C( 110), -INT8_C(  99), -INT8_C(  88),  INT8_C(  25),  INT8_C(  88),
         INT8_C( 113),  INT8_C(  87), -INT8_C(  28),  INT8_C(  24), -INT8_C(  63), -INT8_C(  66),  INT8_C( 113), -INT8_C(  39),
         INT8_C(  51),  INT8_C(  92),      INT8_MIN, -INT8_C(  55),  INT8_C( 111),  INT8_C(  29),  INT8_C(  99),  INT8_C(  62),
         INT8_C(  82),  INT8_C(  82), -INT8_C(  68),  INT8_C(  75),  INT8_C(  99),  INT8_C( 103),  INT8_C( 119), -INT8_C(  88),
        -INT8_C(  24),  INT8_C(  45),  INT8_C(  58), -INT8_C( 123), -INT8_C(  42),  INT8_C(  84), -INT8_C(  35),  INT8_C(  71),
        -INT8_C(  85), -INT8_C(  63),  INT8_C(  95),  INT8_C( 109),      INT8_MIN, -INT8_C(  47),  INT8_C(  70), -INT8_C(  77) },
      { -INT8_C( 105),  INT8_C(  71),  INT8_C(   0),  INT8_C(   0),  INT8_C( 118),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
         INT8_C(  55),  INT8_C(  23),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   1),  INT8_C(   0),  INT8_C(   0),
        -INT8_C(  60),  INT8_C(   0),  INT8_C(   0),  INT8_C(  58), -INT8_C(  14),  INT8_C(   0),  INT8_C(  95),  INT8_C(   0),
        -INT8_C(  84),  INT8_C(   0), -INT8_C(  70), -INT8_C(  50),  INT8_C(   0), -INT8_C(  99), -INT8_C(  99),  INT8_C(   0),
        -INT8_C(  28),  INT8_C(  10),  INT8_C(   0),  INT8_C(  90), -INT8_C(   3),  INT8_C(  62), -INT8_C( 117),  INT8_C(   0),
         INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(  17),  INT8_C(  42),  INT8_C(   0),  INT8_C(   0),
         INT8_C(  28),  INT8_C(   0),  INT8_C(   0),  INT8_C(  14),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
         INT8_C( 102),  INT8_C(   0), -INT8_C(  99),  INT8_C(   0),  INT8_C(  39),  INT8_C(  59),  INT8_C(  32),  INT8_C(   0) } },
    { UINT64_C( 3952718891158717997),
      {  INT8_C(  50), -INT8_C( 106), -INT8_C( 127), -INT8_C( 107), -INT8_C(   3), -INT8_C(   8),  INT8_C(  62), -INT8_C(  27),
         INT8_C(  38),  INT8_C( 120),  INT8_C( 106), -INT8_C(   4), -INT8_C(  52),  INT8_C(  72),  INT8_C(  67),  INT8_C( 120),
         INT8_C(   9), -INT8_C(  94), -INT8_C(  27), -INT8_C( 119),  INT8_C( 115),  INT8_C(  43),  INT8_C(  61), -INT8_C(  96),
        -INT8_C(  14), -INT8_C(  70),  INT8_C(  60), -INT8_C(  43), -INT8_C( 102),  INT8_C(  23),  INT8_C(  11), -INT8_C(  52),
        -INT8_C(  83), -INT8_C( 116),  INT8_C(  98), -INT8_C(  85), -INT8_C( 123), -INT8_C(  96), -INT8_C( 112), -INT8_C(  85),
         INT8_C(  24), -INT8_C(   5), -INT8_C(  89), -INT8_C(  27),  INT8_C(  67), -INT8_C(  22),  INT8_C(  93),  INT8_C(  76),
        -INT8_C( 116),  INT8_C(  66), -INT8_C(  42),  INT8_C(   0),  INT8_C( 109),  INT8_C(  19), -INT8_C(  96),  INT8_C(  95),
        -INT8_C(  51), -INT8_C(  35),  INT8_C(  53),  INT8_C( 103), -INT8_C(  12),  INT8_C(  64),  INT8_C(  51), -INT8_C(  95) },
      { -INT8_C(  51), -INT8_C( 107),  INT8_C(  76),  INT8_C(  82),  INT8_C(  53), -INT8_C(  35), -INT8_C(   3),  INT8_C(  78),
        -INT8_C(  40), -INT8_C(  92),  INT8_C(  51),  INT8_C(  27), -INT8_C( 114), -INT8_C( 112),  INT8_C( 103),  INT8_C(  26),
        -INT8_C(  46),  INT8_C(  61),  INT8_C(  26),  INT8_C(  63),  INT8_C(  80), -INT8_C(  69), -INT8_C(  97),  INT8_C(  29),
        -INT8_C( 104), -INT8_C(  44), -INT8_C( 124), -INT8_C( 116),  INT8_C(  20), -INT8_C(  72),  INT8_C(  45), -INT8_C(  31),
         INT8_C(  77),  INT8_C( 122),  INT8_C(  51), -INT8_C( 125),  INT8_C(  87),  INT8_C(  48), -INT8_C(  47),  INT8_C(  47),
        -INT8_C(  44),  INT8_C(   4),  INT8_C(  74),  INT8_C(  98), -INT8_C( 108), -INT8_C(  79),  INT8_C( 125),  INT8_C( 102),
        -INT8_C(  17), -INT8_C( 105), -INT8_C(  91),  INT8_C(  63),  INT8_C(  82),  INT8_C(  68),  INT8_C(  93), -INT8_C(  22),
         INT8_C(  24), -INT8_C(  31),  INT8_C( 118),  INT8_C(  45), -INT8_C( 103), -INT8_C(  92),  INT8_C(  14), -INT8_C(  25) },
      { -INT8_C(   1),  INT8_C(   0), -INT8_C(  51), -INT8_C(  25),  INT8_C(   0), -INT8_C(  43),  INT8_C(   0),  INT8_C(   0),
         INT8_C(   0),  INT8_C(  28), -INT8_C(  99),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0), -INT8_C(  86), -INT8_C( 110),
        -INT8_C(  37),  INT8_C(   0), -INT8_C(   1), -INT8_C(  56), -INT8_C(  61), -INT8_C(  26), -INT8_C(  36),  INT8_C(   0),
         INT8_C(   0),  INT8_C(   0), -INT8_C(  64),  INT8_C(  97), -INT8_C(  82),  INT8_C(   0),  INT8_C(   0), -INT8_C(  83),
        -INT8_C(   6),  INT8_C(   6),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0), -INT8_C(  48),  INT8_C(  97), -INT8_C(  38),
         INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0), -INT8_C( 101), -INT8_C(  38), -INT8_C(  78),
         INT8_C(   0), -INT8_C(  39),  INT8_C(   0),  INT8_C(  63), -INT8_C(  65),  INT8_C(   0), -INT8_C(   3),  INT8_C(  73),
         INT8_C(   0), -INT8_C(  66), -INT8_C(  85),  INT8_C(   0), -INT8_C( 115), -INT8_C(  28),  INT8_C(   0),  INT8_C(   0) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i a = simde_mm512_loadu_epi8(test_vec[i].a);
    simde__m512i b = simde_mm512_loadu_epi8(test_vec[i].b);
    simde__m512i r = simde_mm512_maskz_add_epi8(test_vec[i].k, a, b);
    simde_test_x86_assert_equal_i8x64(r, simde_mm512_loadu_epi8(test_vec[i].r));
  }

  return 0;
}

static int
test_simde_mm512_add_epi16 (SIMDE_MUNIT_TEST_ARGS) {
  struct {
    const int16_t a[32];
    const int16_t b[32];
    const int16_t r[32];
  } test_vec[] = {
    { {  INT16_C( 11452),  INT16_C( 18562),  INT16_C(  2675), -INT16_C( 17089),  INT16_C( 30550), -INT16_C( 14832), -INT16_C( 11694), -INT16_C( 20057),
         INT16_C( 31125),  INT16_C(  7807), -INT16_C( 11481),  INT16_C( 12519), -INT16_C(   410), -INT16_C( 11992),  INT16_C( 27537),  INT16_C( 19885),
         INT16_C( 12440),  INT16_C(  2965), -INT16_C( 11206), -INT16_C( 28472), -INT16_C( 10164), -INT16_C( 25001), -INT16_C(   342),  INT16_C( 16463),
        -INT16_C( 12424), -INT16_C( 24738),  INT16_C( 17826),  INT16_C(  2255), -INT16_C(  1981), -INT16_C( 11047), -INT16_C( 30877), -INT16_C(  1246) },
      { -INT16_C( 18505), -INT16_C(  3833), -INT16_C( 12404), -INT16_C( 10111), -INT16_C( 10072),  INT16_C( 21110), -INT16_C( 14633),  INT16_C( 20370),
        -INT16_C(  3947),  INT16_C( 14318), -INT16_C( 17098),  INT16_C( 31040),  INT16_C(  6581),  INT16_C(  6478),  INT16_C( 28832),  INT16_C( 22292),
         INT16_C(  6951), -INT16_C( 19640), -INT16_C( 13589), -INT16_C( 27765),  INT16_C(   674),  INT16_C( 31205),  INT16_C( 30920),  INT16_C( 24008),
        -INT16_C( 18840), -INT16_C( 24940), -INT16_C( 11148),  INT16_C( 10520),  INT16_C( 26350), -INT16_C( 29118),  INT16_C( 22486), -INT16_C(   538) },
      { -INT16_C(  7053),  INT16_C( 14729), -INT16_C(  9729), -INT16_C( 27200),  INT16_C( 20478),  INT16_C(  6278), -INT16_C( 26327),  INT16_C(   313),
         INT16_C( 27178),  INT16_C( 22125), -INT16_C( 28579), -INT16_C( 21977),  INT16_C(  6171), -INT16_C(  5514), -INT16_C(  9167), -INT16_C( 23359),
         INT16_C( 19391), -INT16_C( 16675), -INT16_C( 24795),  INT16_C(  9299), -INT16_C(  9490),  INT16_C(  6204),  INT16_C( 30578), -INT16_C( 25065),
        -INT16_C( 31264),  INT16_C( 15858),  INT16_C(  6678),  INT16_C( 12775),  INT16_C( 24369),  INT16_C( 25371), -INT16_C(  8391), -INT16_C(  1784) } },
    { {  INT16_C( 11890),  INT16_C( 23985),  INT16_C( 15608), -INT16_C( 25616), -INT16_C( 10690),  INT16_C(  1556), -INT16_C(  8882), -INT16_C( 18845),
        -INT16_C(  1901),  INT16_C(  1877),  INT16_C( 28108), -INT16_C( 17871),  INT16_C( 29651), -INT16_C( 22199),  INT16_C( 12234),  INT16_C( 15782),
         INT16_C( 22365),  INT16_C( 22170), -INT16_C( 29804), -INT16_C( 11535),  INT16_C(  1377), -INT16_C( 20519),  INT16_C( 15586),  INT16_C( 30309),
        -INT16_C( 17868),  INT16_C(   381), -INT16_C( 20953), -INT16_C(  1349),  INT16_C(  1058), -INT16_C(  4957),  INT16_C( 18995), -INT16_C( 28375) },
      { -INT16_C( 15199),  INT16_C( 13799), -INT16_C( 10161), -INT16_C( 20472), -INT16_C(  7715), -INT16_C( 16289), -INT16_C( 15331),  INT16_C( 21046),
        -INT16_C( 19585), -INT16_C( 22957),  INT16_C(  3682), -INT16_C( 31583),  INT16_C( 17427),  INT16_C( 18032), -INT16_C( 25970),  INT16_C( 12503),
        -INT16_C( 16802), -INT16_C( 21147),  INT16_C( 28054),  INT16_C( 29789), -INT16_C( 17330),  INT16_C( 27700),  INT16_C( 27264), -INT16_C(    66),
         INT16_C(  4381),  INT16_C( 32678),  INT16_C( 18207),  INT16_C( 12803),  INT16_C( 29835),  INT16_C(  6777),  INT16_C( 20494),  INT16_C( 27722) },
      { -INT16_C(  3309), -INT16_C( 27752),  INT16_C(  5447),  INT16_C( 19448), -INT16_C( 18405), -INT16_C( 14733), -INT16_C( 24213),  INT16_C(  2201),
        -INT16_C( 21486), -INT16_C( 21080),  INT16_C( 31790),  INT16_C( 16082), -INT16_C( 18458), -INT16_C(  4167), -INT16_C( 13736),  INT16_C( 28285),
         INT16_C(  5563),  INT16_C(  1023), -INT16_C(  1750),  INT16_C( 18254), -INT16_C( 15953),  INT16_C(  7181), -INT16_C( 22686),  INT16_C( 30243),
        -INT16_C( 13487), -INT16_C( 32477), -INT16_C(  2746),  INT16_C( 11454),  INT16_C( 30893),  INT16_C(  1820), -INT16_C( 26047), -INT16_C(   653) } },
    { { -INT16_C( 20721), -INT16_C( 23271),  INT16_C( 30237),  INT16_C( 27417),  INT16_C( 19762), -INT16_C( 19753), -INT16_C( 27209), -INT16_C( 10830),
         INT16_C( 22694), -INT16_C( 14764),  INT16_C( 22687),  INT16_C( 11000),  INT16_C( 29132), -INT16_C(  9660), -INT16_C( 28990), -INT16_C( 11962),
         INT16_C( 24382),  INT16_C( 23414), -INT16_C( 28459),  INT16_C(  1990), -INT16_C( 24867), -INT16_C( 27207),  INT16_C( 27443), -INT16_C(  9622),
        -INT16_C( 16701),  INT16_C( 25248), -INT16_C( 26602), -INT16_C(  7539), -INT16_C( 12022), -INT16_C( 13124),  INT16_C(   608), -INT16_C( 24931) },
      {  INT16_C(  4961),  INT16_C( 14073), -INT16_C( 16477), -INT16_C( 32451), -INT16_C(  2211), -INT16_C( 28394), -INT16_C( 32670),  INT16_C(  9835),
         INT16_C(  2878),  INT16_C( 21896),  INT16_C(  5539), -INT16_C( 21193), -INT16_C(  2841),  INT16_C( 18297),  INT16_C(  5878),  INT16_C( 22757),
        -INT16_C(  8662), -INT16_C( 12914), -INT16_C( 13155), -INT16_C(  1202),  INT16_C( 25795),  INT16_C(  9612), -INT16_C(  2076),  INT16_C(  9035),
        -INT16_C( 11262), -INT16_C( 23176), -INT16_C( 20503), -INT16_C( 12205), -INT16_C( 13149), -INT16_C( 26089), -INT16_C(   797),  INT16_C(  3570) },
      { -INT16_C( 15760), -INT16_C(  9198),  INT16_C( 13760), -INT16_C(  5034),  INT16_C( 17551),  INT16_C( 17389),  INT16_C(  5657), -INT16_C(   995),
         INT16_C( 25572),  INT16_C(  7132),  INT16_C( 28226), -INT16_C( 10193),  INT16_C( 26291),  INT16_C(  8637), -INT16_C( 23112),  INT16_C( 10795),
         INT16_C( 15720),  INT16_C( 10500),  INT16_C( 23922),  INT16_C(   788),  INT16_C(   928), -INT16_C( 17595),  INT16_C( 25367), -INT16_C(   587),
        -INT16_C( 27963),  INT16_C(  2072),  INT16_C( 18431), -INT16_C( 19744), -INT16_C( 25171),  INT16_C( 26323), -INT16_C(   189), -INT16_C( 21361) } },
    { { -INT16_C( 32550),  INT16_C( 30938),  INT16_C( 10572),  INT16_C(  3955), -INT16_C(   115),  INT16_C( 29237), -INT16_C( 32522), -INT16_C(  1899),
         INT16_C(  3412),  INT16_C( 16029), -INT16_C(  3908),  INT16_C( 24590),  INT16_C(  9917), -INT16_C( 24326), -INT16_C(  5086), -INT16_C(   595),
        -INT16_C( 30868), -INT16_C( 18059), -INT16_C(  5968),  INT16_C( 16072), -INT16_C(   537), -INT16_C(  8784),  INT16_C( 17790), -INT16_C( 11563),
         INT16_C( 29266),  INT16_C(  3600),  INT16_C(  8035),  INT16_C(  8302),  INT16_C( 26693),  INT16_C( 26560),  INT16_C( 27988), -INT16_C( 16028) },
      { -INT16_C(  9740), -INT16_C( 23174),  INT16_C( 17089), -INT16_C( 22301), -INT16_C( 27840), -INT16_C( 16763),  INT16_C( 23256),  INT16_C( 10896),
        -INT16_C( 24115),  INT16_C( 12344), -INT16_C( 22592),  INT16_C(  1360),  INT16_C(  4111),  INT16_C( 25708), -INT16_C( 11907),  INT16_C( 28965),
        -INT16_C( 24662),  INT16_C( 27670), -INT16_C(  1567),  INT16_C(  8468), -INT16_C( 25972),  INT16_C( 25823),  INT16_C( 28916), -INT16_C( 15986),
        -INT16_C( 14575), -INT16_C( 11791),  INT16_C( 16750),  INT16_C( 32214),  INT16_C( 16977), -INT16_C( 12575),  INT16_C(  1555), -INT16_C( 16832) },
      {  INT16_C( 23246),  INT16_C(  7764),  INT16_C( 27661), -INT16_C( 18346), -INT16_C( 27955),  INT16_C( 12474), -INT16_C(  9266),  INT16_C(  8997),
        -INT16_C( 20703),  INT16_C( 28373), -INT16_C( 26500),  INT16_C( 25950),  INT16_C( 14028),  INT16_C(  1382), -INT16_C( 16993),  INT16_C( 28370),
         INT16_C( 10006),  INT16_C(  9611), -INT16_C(  7535),  INT16_C( 24540), -INT16_C( 26509),  INT16_C( 17039), -INT16_C( 18830), -INT16_C( 27549),
         INT16_C( 14691), -INT16_C(  8191),  INT16_C( 24785), -INT16_C( 25020), -INT16_C( 21866),  INT16_C( 13985),  INT16_C( 29543),  INT16_C( 32676) } },
    { {  INT16_C( 22181), -INT16_C( 30934),  INT16_C( 15952), -INT16_C(  9048), -INT16_C( 30504), -INT16_C( 12991), -INT16_C( 12296),  INT16_C(  2446),
        -INT16_C( 32618),  INT16_C(  1242), -INT16_C( 20287),  INT16_C(  4994),  INT16_C( 25586),  INT16_C(  1761),  INT16_C(  8554),  INT16_C(  4036),
        -INT16_C(  4488), -INT16_C( 14186),  INT16_C( 16172),  INT16_C(  1444), -INT16_C(  6713), -INT16_C( 16430),  INT16_C( 24757),  INT16_C( 19400),
        -INT16_C( 23840), -INT16_C( 23984), -INT16_C( 11694),  INT16_C( 17589), -INT16_C( 27083), -INT16_C( 24758),  INT16_C(  3768),  INT16_C( 12463) },
      {  INT16_C( 17916),  INT16_C( 10744), -INT16_C( 25468),  INT16_C( 19246),  INT16_C(   130),  INT16_C( 14090), -INT16_C( 11680),  INT16_C( 16770),
        -INT16_C( 11660), -INT16_C( 14621), -INT16_C( 26460), -INT16_C(  9717),  INT16_C( 21806), -INT16_C(  6535),  INT16_C( 10340),  INT16_C( 24598),
         INT16_C(  3694), -INT16_C(  3447), -INT16_C( 18517),  INT16_C( 11582),  INT16_C( 18615),  INT16_C(  6244), -INT16_C(  6629), -INT16_C( 28839),
         INT16_C( 15545),  INT16_C( 23894),  INT16_C( 25044),  INT16_C(   567), -INT16_C( 20042),  INT16_C(  6889), -INT16_C(    39),  INT16_C( 18299) },
      { -INT16_C( 25439), -INT16_C( 20190), -INT16_C(  9516),  INT16_C( 10198), -INT16_C( 30374),  INT16_C(  1099), -INT16_C( 23976),  INT16_C( 19216),
         INT16_C( 21258), -INT16_C( 13379),  INT16_C( 18789), -INT16_C(  4723), -INT16_C( 18144), -INT16_C(  4774),  INT16_C( 18894),  INT16_C( 28634),
        -INT16_C(   794), -INT16_C( 17633), -INT16_C(  2345),  INT16_C( 13026),  INT16_C( 11902), -INT16_C( 10186),  INT16_C( 18128), -INT16_C(  9439),
        -INT16_C(  8295), -INT16_C(    90),  INT16_C( 13350),  INT16_C( 18156),  INT16_C( 18411), -INT16_C( 17869),  INT16_C(  3729),  INT16_C( 30762) } },
    { {  INT16_C(  1038), -INT16_C( 18118),  INT16_C( 30908),  INT16_C( 29670),  INT16_C( 19136), -INT16_C(  9333), -INT16_C(  7120), -INT16_C(  5781),
        -INT16_C( 16096), -INT16_C(  3001),  INT16_C( 32290), -INT16_C(  9993), -INT16_C(  8145),  INT16_C(  2547),  INT16_C( 28383), -INT16_C(  4784),
        -INT16_C( 30094),  INT16_C( 11942), -INT16_C( 29694), -INT16_C( 15454),  INT16_C( 11734),  INT16_C(  1950),  INT16_C(  2322),  INT16_C( 13040),
         INT16_C( 14282), -INT16_C(  5081),  INT16_C(  7862), -INT16_C(  6715), -INT16_C( 18178), -INT16_C(  8722),  INT16_C( 16166), -INT16_C( 26421) },
      {  INT16_C( 29129), -INT16_C( 13113),  INT16_C( 27134), -INT16_C( 11121),  INT16_C( 11670), -INT16_C( 22309), -INT16_C( 13257),  INT16_C(   475),
         INT16_C(   515), -INT16_C( 17938), -INT16_C( 19680),  INT16_C(  7839), -INT16_C( 29333), -INT16_C( 28165), -INT16_C( 14644), -INT16_C( 27095),
        -INT16_C(  4040),  INT16_C( 13922), -INT16_C(  3751), -INT16_C(  4086), -INT16_C(  6626),  INT16_C( 21912),  INT16_C( 29618), -INT16_C( 19113),
         INT16_C( 17781), -INT16_C( 27281),  INT16_C(  3832),  INT16_C( 25523), -INT16_C( 20581),  INT16_C( 26868),  INT16_C(  7541), -INT16_C( 20994) },
      {  INT16_C( 30167), -INT16_C( 31231), -INT16_C(  7494),  INT16_C( 18549),  INT16_C( 30806), -INT16_C( 31642), -INT16_C( 20377), -INT16_C(  5306),
        -INT16_C( 15581), -INT16_C( 20939),  INT16_C( 12610), -INT16_C(  2154),  INT16_C( 28058), -INT16_C( 25618),  INT16_C( 13739), -INT16_C( 31879),
         INT16_C( 31402),  INT16_C( 25864),  INT16_C( 32091), -INT16_C( 19540),  INT16_C(  5108),  INT16_C( 23862),  INT16_C( 31940), -INT16_C(  6073),
         INT16_C( 32063), -INT16_C( 32362),  INT16_C( 11694),  INT16_C( 18808),  INT16_C( 26777),  INT16_C( 18146),  INT16_C( 23707),  INT16_C( 18121) } },
    { {  INT16_C( 24590),  INT16_C( 26595), -INT16_C(  4527),  INT16_C( 28503), -INT16_C(  3884), -INT16_C( 31035),  INT16_C(  7267), -INT16_C(  9925),
        -INT16_C( 21919),  INT16_C( 22894),  INT16_C(  8888),  INT16_C( 21692), -INT16_C( 20271),  INT16_C( 18108), -INT16_C( 17715), -INT16_C(  9228),
        -INT16_C( 10470),  INT16_C( 27459), -INT16_C( 25915), -INT16_C( 26150), -INT16_C( 24694), -INT16_C(  4577),  INT16_C( 23483),  INT16_C(  7367),
         INT16_C( 13573), -INT16_C( 16779),  INT16_C( 12631),  INT16_C( 10258), -INT16_C( 12575), -INT16_C( 20625),  INT16_C( 25480), -INT16_C( 23926) },
      { -INT16_C( 12998),  INT16_C(    13), -INT16_C(  6296), -INT16_C(  3431), -INT16_C( 18041),  INT16_C( 17120), -INT16_C( 22764),  INT16_C(  6495),
        -INT16_C( 11043),  INT16_C( 13527), -INT16_C(  5882), -INT16_C(  6307), -INT16_C( 13129),  INT16_C( 16278),  INT16_C(  8495),  INT16_C( 27105),
        -INT16_C(  4370),  INT16_C( 22121),  INT16_C(   982),  INT16_C( 23881),  INT16_C( 10684), -INT16_C( 12129), -INT16_C(   303), -INT16_C( 20759),
        -INT16_C( 15917), -INT16_C(  9758),  INT16_C( 16298),  INT16_C( 25280),  INT16_C( 22283),  INT16_C( 15009), -INT16_C( 31880),  INT16_C( 26276) },
      {  INT16_C( 11592),  INT16_C( 26608), -INT16_C( 10823),  INT16_C( 25072), -INT16_C( 21925), -INT16_C( 13915), -INT16_C( 15497), -INT16_C(  3430),
         INT16_C( 32574), -INT16_C( 29115),  INT16_C(  3006),  INT16_C( 15385),  INT16_C( 32136), -INT16_C( 31150), -INT16_C(  9220),  INT16_C( 17877),
        -INT16_C( 14840), -INT16_C( 15956), -INT16_C( 24933), -INT16_C(  2269), -INT16_C( 14010), -INT16_C( 16706),  INT16_C( 23180), -INT16_C( 13392),
        -INT16_C(  2344), -INT16_C( 26537),  INT16_C( 28929), -INT16_C( 29998),  INT16_C(  9708), -INT16_C(  5616), -INT16_C(  6400),  INT16_C(  2350) } },
    { {  INT16_C(  3441),  INT16_C( 18365),  INT16_C(  1552), -INT16_C( 13148),  INT16_C( 17455),  INT16_C(   156), -INT16_C( 31166),  INT16_C(  5550),
        -INT16_C( 28345), -INT16_C(  3602), -INT16_C( 20528), -INT16_C(  9133), -INT16_C(  2810),  INT16_C( 32278), -INT16_C( 17800), -INT16_C(  5660),
        -INT16_C( 24120), -INT16_C( 10191), -INT16_C( 10841), -INT16_C( 10331),  INT16_C( 16665),  INT16_C( 23767), -INT16_C( 31033),  INT16_C(  3697),
         INT16_C( 24599), -INT16_C(  6400),  INT16_C( 21263),  INT16_C(  5571), -INT16_C(  9656), -INT16_C( 16237),  INT16_C( 30612),  INT16_C( 23722) },
      { -INT16_C(  9447), -INT16_C( 16331), -INT16_C(  9552), -INT16_C( 13673),  INT16_C( 28443), -INT16_C(  7386), -INT16_C( 26635),  INT16_C(  3313),
        -INT16_C(  3593),  INT16_C(  1779), -INT16_C( 18619), -INT16_C( 29413), -INT16_C( 20847),  INT16_C(  9550), -INT16_C(  2010),  INT16_C( 16258),
        -INT16_C( 18477), -INT16_C( 31745), -INT16_C( 26735), -INT16_C( 21427),  INT16_C( 29446), -INT16_C(  1137), -INT16_C( 32501),  INT16_C(   519),
        -INT16_C(  1422), -INT16_C( 18679),  INT16_C(  9393),  INT16_C( 16965), -INT16_C( 27693), -INT16_C(  1688), -INT16_C(  5493),  INT16_C( 24120) },
      { -INT16_C(  6006),  INT16_C(  2034), -INT16_C(  8000), -INT16_C( 26821), -INT16_C( 19638), -INT16_C(  7230),  INT16_C(  7735),  INT16_C(  8863),
        -INT16_C( 31938), -INT16_C(  1823),  INT16_C( 26389),  INT16_C( 26990), -INT16_C( 23657), -INT16_C( 23708), -INT16_C( 19810),  INT16_C( 10598),
         INT16_C( 22939),  INT16_C( 23600),  INT16_C( 27960), -INT16_C( 31758), -INT16_C( 19425),  INT16_C( 22630),  INT16_C(  2002),  INT16_C(  4216),
         INT16_C( 23177), -INT16_C( 25079),  INT16_C( 30656),  INT16_C( 22536),  INT16_C( 28187), -INT16_C( 17925),  INT16_C( 25119), -INT16_C( 17694) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i a = simde_mm512_loadu_epi16(test_vec[i].a);
    simde__m512i b = simde_mm512_loadu_epi16(test_vec[i].b);
    simde__m512i r = simde_mm512_add_epi16(a, b);
    simde_test_x86_assert_equal_i16x32(r, simde_mm512_loadu_epi16(test_vec[i].r));
  }

  return 0;
}

static int
test_simde_mm512_mask_add_epi16 (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const int16_t src[32];
    const simde__mmask32 k;
    const int16_t a[32];
    const int16_t b[32];
    const int16_t r[32];
  } test_vec[] = {
    { {  INT16_C( 19989),  INT16_C( 17201), -INT16_C(   484), -INT16_C(  4807), -INT16_C( 18583),  INT16_C(  7804),  INT16_C( 26728),  INT16_C( 16294),
        -INT16_C( 31636),  INT16_C( 28135), -INT16_C( 32158),  INT16_C( 20064), -INT16_C( 16695),  INT16_C(  3157),  INT16_C( 32300),  INT16_C( 16873),
         INT16_C(  6860), -INT16_C(  5755), -INT16_C( 16872), -INT16_C( 32042),  INT16_C( 21110), -INT16_C(  8544),  INT16_C( 18106),  INT16_C(  9757),
         INT16_C(  1482),  INT16_C( 11668), -INT16_C(  2937),  INT16_C( 20859), -INT16_C( 12110), -INT16_C(  8611),  INT16_C( 17999),  INT16_C(  6944) },
      UINT32_C(2030347617),
      { -INT16_C( 25811), -INT16_C(  6217), -INT16_C( 10782), -INT16_C( 21490), -INT16_C( 23846),  INT16_C( 25049),  INT16_C( 21910),  INT16_C( 18610),
         INT16_C(  4133),  INT16_C( 29734),  INT16_C( 18006), -INT16_C( 18544), -INT16_C( 27413),  INT16_C( 20273),  INT16_C( 11375), -INT16_C( 25560),
        -INT16_C(  7992), -INT16_C( 21885), -INT16_C( 28235), -INT16_C( 28842),  INT16_C( 12339), -INT16_C( 13840), -INT16_C( 23675), -INT16_C( 21999),
         INT16_C( 14515),  INT16_C(  2335), -INT16_C( 20610),  INT16_C( 27329), -INT16_C(  3517), -INT16_C( 19783), -INT16_C(  7906), -INT16_C(  6578) },
      { -INT16_C( 11583),  INT16_C( 30352), -INT16_C(  6301), -INT16_C( 26875), -INT16_C(  2537), -INT16_C( 25504),  INT16_C( 29337),  INT16_C( 19526),
         INT16_C( 26026),  INT16_C( 10325),  INT16_C(  5652),  INT16_C( 22674),  INT16_C( 19208),  INT16_C(  9994),  INT16_C( 22829), -INT16_C(  4595),
        -INT16_C( 25045), -INT16_C( 29083),  INT16_C( 27269), -INT16_C( 25563), -INT16_C( 31136), -INT16_C(  1736),  INT16_C( 32504), -INT16_C( 23995),
        -INT16_C( 25628), -INT16_C(  1846),  INT16_C( 23985), -INT16_C( 17840),  INT16_C( 23464), -INT16_C( 10783), -INT16_C(  4428), -INT16_C(  8252) },
      {  INT16_C( 28142),  INT16_C( 17201), -INT16_C(   484), -INT16_C(  4807), -INT16_C( 18583), -INT16_C(   455), -INT16_C( 14289),  INT16_C( 16294),
         INT16_C( 30159),  INT16_C( 28135),  INT16_C( 23658),  INT16_C( 20064), -INT16_C( 16695),  INT16_C( 30267),  INT16_C( 32300), -INT16_C( 30155),
         INT16_C(  6860), -INT16_C(  5755), -INT16_C(   966), -INT16_C( 32042),  INT16_C( 21110), -INT16_C(  8544),  INT16_C( 18106),  INT16_C(  9757),
        -INT16_C( 11113),  INT16_C( 11668), -INT16_C(  2937),  INT16_C(  9489),  INT16_C( 19947), -INT16_C( 30566), -INT16_C( 12334),  INT16_C(  6944) } },
    { {  INT16_C( 10636),  INT16_C(  4461), -INT16_C( 27757), -INT16_C(  2899), -INT16_C(  6887),  INT16_C(  4589),  INT16_C( 13156),  INT16_C( 18611),
         INT16_C( 32206),  INT16_C( 32576), -INT16_C( 28198), -INT16_C( 31943),  INT16_C(  6892), -INT16_C( 24488),  INT16_C(  7177), -INT16_C( 27265),
        -INT16_C(  5051), -INT16_C(  9817),  INT16_C( 21631), -INT16_C( 26419), -INT16_C( 17862), -INT16_C( 24919),  INT16_C( 23789), -INT16_C( 17434),
         INT16_C(  9946), -INT16_C( 19397),  INT16_C( 29879), -INT16_C( 23753), -INT16_C( 28529), -INT16_C( 26557), -INT16_C( 15700), -INT16_C(  3539) },
      UINT32_C( 785110191),
      {  INT16_C( 28754),  INT16_C( 16385), -INT16_C(  6195), -INT16_C( 22533),  INT16_C( 13837), -INT16_C( 15013), -INT16_C( 27733),  INT16_C( 14952),
        -INT16_C( 21469), -INT16_C( 12334), -INT16_C(   146),  INT16_C(  7617), -INT16_C( 29484), -INT16_C(   692),  INT16_C(  4900),  INT16_C( 30560),
         INT16_C( 24963),  INT16_C( 20663), -INT16_C( 19896),  INT16_C( 22007),  INT16_C( 21481), -INT16_C( 27622), -INT16_C( 31770),  INT16_C(  2510),
        -INT16_C( 24529), -INT16_C( 25128), -INT16_C( 25953),  INT16_C( 29627),  INT16_C(  1830),  INT16_C( 19312), -INT16_C( 12262), -INT16_C( 25150) },
      {  INT16_C( 31025),  INT16_C( 31214), -INT16_C(  6869),  INT16_C(  5327), -INT16_C(  5832),  INT16_C(  7848),  INT16_C( 30316), -INT16_C( 25817),
         INT16_C(    22), -INT16_C( 18887), -INT16_C(  2918), -INT16_C( 16343), -INT16_C( 25861),  INT16_C(  5387), -INT16_C( 12950), -INT16_C( 25422),
        -INT16_C( 24506),  INT16_C( 29205), -INT16_C(  7034), -INT16_C( 16762),  INT16_C( 12238),  INT16_C( 15069),  INT16_C(  1189), -INT16_C( 17194),
         INT16_C(  3844), -INT16_C( 24974), -INT16_C( 25853), -INT16_C(   417),  INT16_C( 27189), -INT16_C( 24557), -INT16_C( 15048),  INT16_C( 32316) },
      { -INT16_C(  5757), -INT16_C( 17937), -INT16_C( 13064), -INT16_C( 17206), -INT16_C(  6887), -INT16_C(  7165),  INT16_C( 13156), -INT16_C( 10865),
         INT16_C( 32206),  INT16_C( 32576), -INT16_C(  3064), -INT16_C( 31943),  INT16_C( 10191), -INT16_C( 24488), -INT16_C(  8050),  INT16_C(  5138),
         INT16_C(   457), -INT16_C( 15668),  INT16_C( 21631),  INT16_C(  5245), -INT16_C( 17862), -INT16_C( 24919), -INT16_C( 30581), -INT16_C( 14684),
         INT16_C(  9946),  INT16_C( 15434),  INT16_C( 13730),  INT16_C( 29210), -INT16_C( 28529), -INT16_C(  5245), -INT16_C( 15700), -INT16_C(  3539) } },
    { {  INT16_C( 20838), -INT16_C(  4880),  INT16_C( 30518),  INT16_C(  1194), -INT16_C( 30810),  INT16_C( 19262),  INT16_C(  5260), -INT16_C( 28665),
         INT16_C( 31011),  INT16_C(  9775), -INT16_C( 29163),  INT16_C( 18980),  INT16_C( 14328),  INT16_C( 12522),  INT16_C(  9981),  INT16_C( 25519),
        -INT16_C( 24712), -INT16_C( 20913), -INT16_C(  1770), -INT16_C( 17230), -INT16_C(  3967),  INT16_C(  3336),  INT16_C(  3845),  INT16_C( 10397),
        -INT16_C( 13175), -INT16_C( 25009),  INT16_C( 29530),  INT16_C( 21480), -INT16_C( 11349), -INT16_C( 22397),  INT16_C( 13049),  INT16_C( 28939) },
      UINT32_C(3894368978),
      { -INT16_C( 21054), -INT16_C( 14367),  INT16_C( 32700),  INT16_C( 17903),  INT16_C( 15947), -INT16_C( 22813), -INT16_C( 13134),  INT16_C( 24057),
         INT16_C( 31903), -INT16_C( 26619),  INT16_C(  4271), -INT16_C( 32502),  INT16_C( 10602), -INT16_C( 17047),  INT16_C(  3835), -INT16_C( 17006),
         INT16_C( 29627),  INT16_C( 30852),  INT16_C( 29682),  INT16_C( 16061), -INT16_C( 24142),  INT16_C( 25828), -INT16_C(  8851),  INT16_C(  3265),
        -INT16_C( 14759),  INT16_C(  2212), -INT16_C( 20778),  INT16_C( 16521), -INT16_C(  3112), -INT16_C( 11267), -INT16_C( 28927), -INT16_C( 17008) },
      {  INT16_C(  5123), -INT16_C(  2763), -INT16_C(  3449),  INT16_C( 14643),  INT16_C(  6035),  INT16_C(   157),  INT16_C( 24308),  INT16_C( 19980),
        -INT16_C( 20188), -INT16_C(  1450), -INT16_C(  8097),  INT16_C( 14138),  INT16_C( 14547), -INT16_C( 11254), -INT16_C( 25913), -INT16_C( 13679),
        -INT16_C( 14674),  INT16_C( 14016), -INT16_C(  3143),  INT16_C( 19567),  INT16_C(  3339), -INT16_C(   179),  INT16_C( 22891), -INT16_C( 28595),
        -INT16_C( 23542),  INT16_C( 27274), -INT16_C( 14972),  INT16_C( 22433), -INT16_C( 21251), -INT16_C( 15317), -INT16_C( 17082), -INT16_C(  2673) },
      {  INT16_C( 20838), -INT16_C( 17130),  INT16_C( 30518),  INT16_C(  1194),  INT16_C( 21982),  INT16_C( 19262),  INT16_C( 11174), -INT16_C( 21499),
         INT16_C( 31011), -INT16_C( 28069), -INT16_C( 29163), -INT16_C( 18364),  INT16_C( 25149),  INT16_C( 12522), -INT16_C( 22078),  INT16_C( 25519),
         INT16_C( 14953), -INT16_C( 20668),  INT16_C( 26539), -INT16_C( 29908), -INT16_C( 20803),  INT16_C(  3336),  INT16_C(  3845),  INT16_C( 10397),
        -INT16_C( 13175), -INT16_C( 25009),  INT16_C( 29530), -INT16_C( 26582), -INT16_C( 11349), -INT16_C( 26584),  INT16_C( 19527), -INT16_C( 19681) } },
    { {  INT16_C( 20355),  INT16_C( 15403), -INT16_C( 26046),  INT16_C( 19849), -INT16_C( 10585),  INT16_C(  4941), -INT16_C( 26065),  INT16_C( 15011),
         INT16_C( 11582), -INT16_C( 15708),  INT16_C( 17906), -INT16_C(  4327),  INT16_C( 17905),  INT16_C( 14516),  INT16_C( 17154), -INT16_C( 31443),
         INT16_C( 22674), -INT16_C( 11070),  INT16_C( 19442), -INT16_C( 26078),  INT16_C( 28449),  INT16_C( 20653),  INT16_C( 20489),  INT16_C( 18570),
         INT16_C( 11901),  INT16_C( 28682),  INT16_C(  9332),  INT16_C( 25951),  INT16_C(  4969),  INT16_C( 27549), -INT16_C( 13738), -INT16_C(  5904) },
      UINT32_C( 364753442),
      {  INT16_C( 23630),  INT16_C( 22383), -INT16_C(  1620),  INT16_C( 10655), -INT16_C( 21976), -INT16_C( 25447), -INT16_C(  1586),  INT16_C( 14081),
        -INT16_C( 24820),  INT16_C( 25506), -INT16_C( 28055), -INT16_C( 29621),  INT16_C(  2117),  INT16_C( 17057),  INT16_C( 20711),  INT16_C( 13665),
        -INT16_C( 12116),  INT16_C( 22669),  INT16_C( 11465), -INT16_C(  3711),  INT16_C(  7126), -INT16_C( 23411), -INT16_C( 28908),  INT16_C(  8411),
         INT16_C( 32046), -INT16_C( 26749), -INT16_C( 12528),  INT16_C( 21795), -INT16_C( 15145), -INT16_C( 16489), -INT16_C(  2028), -INT16_C( 16140) },
      { -INT16_C( 32312), -INT16_C( 28136), -INT16_C( 25938), -INT16_C( 31613),  INT16_C(  4533), -INT16_C( 14039),  INT16_C(  1184), -INT16_C( 12567),
         INT16_C( 28034), -INT16_C( 28059), -INT16_C( 30404),  INT16_C(  5095),  INT16_C( 32333),  INT16_C( 25298), -INT16_C( 14473),  INT16_C( 16162),
         INT16_C( 15176), -INT16_C(  2351),  INT16_C( 21973), -INT16_C( 30085), -INT16_C( 23450),  INT16_C(  1619),  INT16_C( 15528),  INT16_C( 10964),
         INT16_C( 14761), -INT16_C(  6724), -INT16_C( 23614),  INT16_C(  4345), -INT16_C( 13534), -INT16_C( 26254), -INT16_C( 27502), -INT16_C(  9256) },
      {  INT16_C( 20355), -INT16_C(  5753), -INT16_C( 26046),  INT16_C( 19849), -INT16_C( 10585),  INT16_C( 26050), -INT16_C( 26065),  INT16_C( 15011),
         INT16_C( 11582), -INT16_C(  2553),  INT16_C( 17906), -INT16_C(  4327), -INT16_C( 31086), -INT16_C( 23181),  INT16_C( 17154),  INT16_C( 29827),
         INT16_C(  3060), -INT16_C( 11070), -INT16_C( 32098),  INT16_C( 31740), -INT16_C( 16324), -INT16_C( 21792),  INT16_C( 20489),  INT16_C( 19375),
        -INT16_C( 18729),  INT16_C( 28682),  INT16_C( 29394),  INT16_C( 25951), -INT16_C( 28679),  INT16_C( 27549), -INT16_C( 13738), -INT16_C(  5904) } },
    { { -INT16_C( 21809), -INT16_C( 23343),  INT16_C( 19711),  INT16_C( 25902), -INT16_C( 32272), -INT16_C( 26261),  INT16_C( 16318),  INT16_C( 26563),
        -INT16_C( 32648),  INT16_C( 15181),  INT16_C( 17955),  INT16_C( 17739), -INT16_C( 17135), -INT16_C( 23330), -INT16_C( 18607),  INT16_C(  8575),
         INT16_C( 20577),  INT16_C( 24773), -INT16_C(  2915), -INT16_C( 29243),  INT16_C( 12405),  INT16_C( 13094), -INT16_C(  5521), -INT16_C(  6245),
        -INT16_C(  6038), -INT16_C( 29406),  INT16_C( 27950),  INT16_C( 16339), -INT16_C( 20182),  INT16_C( 31971),  INT16_C( 25192), -INT16_C( 13923) },
      UINT32_C(1344889523),
      {  INT16_C(  1054), -INT16_C( 29185), -INT16_C( 25874),  INT16_C( 22645), -INT16_C( 26750), -INT16_C( 20251), -INT16_C( 18427),  INT16_C( 12272),
        -INT16_C( 11414), -INT16_C( 11605),  INT16_C( 18486), -INT16_C(  5732), -INT16_C( 14933),  INT16_C(   313),  INT16_C(  5812), -INT16_C( 11571),
        -INT16_C( 13030),  INT16_C(  2144), -INT16_C( 10905), -INT16_C(  5536),  INT16_C( 18028),  INT16_C( 29082), -INT16_C( 29954),  INT16_C( 26785),
         INT16_C( 19550), -INT16_C( 27589), -INT16_C( 10347),  INT16_C( 16509), -INT16_C( 18788),  INT16_C( 20545),  INT16_C(  4044), -INT16_C(  6365) },
      { -INT16_C( 31780),  INT16_C( 17391),  INT16_C( 20568), -INT16_C( 15315), -INT16_C( 14186), -INT16_C( 27594), -INT16_C( 10414), -INT16_C( 20227),
         INT16_C( 14371), -INT16_C( 18364), -INT16_C( 16113), -INT16_C( 21512),  INT16_C( 14967),  INT16_C( 17660),  INT16_C(  8009),  INT16_C(  9515),
         INT16_C(  6818), -INT16_C(  1432), -INT16_C( 27030),  INT16_C(   190), -INT16_C(  2978), -INT16_C( 20331), -INT16_C( 27957), -INT16_C(  4255),
        -INT16_C( 23094), -INT16_C(  9817), -INT16_C( 24473), -INT16_C(  8572), -INT16_C( 32550),  INT16_C(  8994),  INT16_C( 19871),  INT16_C( 16712) },
      { -INT16_C( 30726), -INT16_C( 11794),  INT16_C( 19711),  INT16_C( 25902),  INT16_C( 24600),  INT16_C( 17691),  INT16_C( 16318), -INT16_C(  7955),
        -INT16_C( 32648), -INT16_C( 29969),  INT16_C( 17955),  INT16_C( 17739), -INT16_C( 17135),  INT16_C( 17973),  INT16_C( 13821),  INT16_C(  8575),
        -INT16_C(  6212),  INT16_C( 24773), -INT16_C(  2915), -INT16_C(  5346),  INT16_C( 12405),  INT16_C(  8751), -INT16_C(  5521), -INT16_C(  6245),
        -INT16_C(  6038), -INT16_C( 29406),  INT16_C( 27950),  INT16_C( 16339),  INT16_C( 14198),  INT16_C( 31971),  INT16_C( 23915), -INT16_C( 13923) } },
    { { -INT16_C( 20376), -INT16_C( 11717), -INT16_C(  1466), -INT16_C( 23341),  INT16_C( 26862), -INT16_C( 17835), -INT16_C( 18694), -INT16_C( 15191),
         INT16_C( 20571), -INT16_C( 15715),  INT16_C(  8688), -INT16_C( 13663), -INT16_C( 15454),  INT16_C( 16877),  INT16_C( 13585),  INT16_C( 31107),
        -INT16_C( 16666),  INT16_C( 11339),  INT16_C(  7864), -INT16_C( 22575),  INT16_C(  9862), -INT16_C( 32671),  INT16_C(  2780),  INT16_C( 14148),
        -INT16_C(  7846),  INT16_C( 19450), -INT16_C( 25853), -INT16_C( 23275),  INT16_C(   862),  INT16_C( 28646),  INT16_C( 26936),  INT16_C(  7912) },
      UINT32_C(3763024936),
      { -INT16_C(  6078),  INT16_C(  7769), -INT16_C( 24846),  INT16_C( 19797),  INT16_C( 20351), -INT16_C( 32104), -INT16_C( 21014),  INT16_C( 18727),
         INT16_C(  3760), -INT16_C(  5704), -INT16_C( 24201), -INT16_C( 24825),  INT16_C( 21205),  INT16_C( 10112),  INT16_C(  1902), -INT16_C( 20480),
         INT16_C( 23280), -INT16_C(  7474),  INT16_C(  9464),  INT16_C( 30511), -INT16_C( 14477),  INT16_C( 24314),  INT16_C(  8565),  INT16_C(  9639),
         INT16_C( 24367), -INT16_C( 22770),  INT16_C(  5632), -INT16_C( 10938), -INT16_C( 14744), -INT16_C( 10243), -INT16_C(   562), -INT16_C( 16761) },
      {  INT16_C( 22103),  INT16_C( 20384), -INT16_C( 12166), -INT16_C(  4665), -INT16_C( 15977),  INT16_C(  3147), -INT16_C(  3358),  INT16_C(  4658),
         INT16_C( 16466),  INT16_C( 21177), -INT16_C(   170), -INT16_C( 16600),  INT16_C(  9670), -INT16_C( 27498),  INT16_C(  7458),  INT16_C( 31314),
        -INT16_C(  3469), -INT16_C(  4663), -INT16_C( 28478),  INT16_C( 23259),  INT16_C(  9809),  INT16_C( 13414), -INT16_C( 26599),  INT16_C( 27462),
        -INT16_C(    39),  INT16_C( 12221), -INT16_C(  6658), -INT16_C( 15122), -INT16_C( 31734),  INT16_C( 11608), -INT16_C( 21854),  INT16_C(  5543) },
      { -INT16_C( 20376), -INT16_C( 11717), -INT16_C(  1466),  INT16_C( 15132),  INT16_C( 26862), -INT16_C( 28957), -INT16_C( 18694), -INT16_C( 15191),
         INT16_C( 20571), -INT16_C( 15715), -INT16_C( 24371), -INT16_C( 13663),  INT16_C( 30875), -INT16_C( 17386),  INT16_C( 13585),  INT16_C( 31107),
         INT16_C( 19811), -INT16_C( 12137),  INT16_C(  7864), -INT16_C( 11766),  INT16_C(  9862), -INT16_C( 32671), -INT16_C( 18034),  INT16_C( 14148),
        -INT16_C(  7846),  INT16_C( 19450), -INT16_C( 25853), -INT16_C( 23275),  INT16_C(   862),  INT16_C(  1365), -INT16_C( 22416), -INT16_C( 11218) } },
    { {  INT16_C( 28829),  INT16_C( 24323), -INT16_C(  8703),  INT16_C( 21177),  INT16_C(  8196),  INT16_C(  7558), -INT16_C( 13128), -INT16_C( 28280),
         INT16_C( 18123), -INT16_C( 13631), -INT16_C( 20693),  INT16_C( 13966), -INT16_C(  6348), -INT16_C( 10653),  INT16_C(  2705),  INT16_C( 12011),
        -INT16_C(  4486),  INT16_C( 31630),  INT16_C( 18380), -INT16_C( 11826),  INT16_C( 21607),  INT16_C(  8430),  INT16_C( 30497), -INT16_C(  4943),
         INT16_C( 29373), -INT16_C(  5962),  INT16_C( 17698),  INT16_C( 22046), -INT16_C( 32468), -INT16_C( 17108),  INT16_C(  6027),  INT16_C(  1772) },
      UINT32_C(3531700742),
      { -INT16_C( 27996), -INT16_C( 15031), -INT16_C(  1527), -INT16_C( 14671),  INT16_C( 26733), -INT16_C( 28754), -INT16_C( 12883), -INT16_C(  9755),
         INT16_C(  4430), -INT16_C(  9578), -INT16_C( 32216),  INT16_C( 12000),  INT16_C( 25084), -INT16_C( 16895), -INT16_C( 23375),  INT16_C( 21991),
         INT16_C( 12342),  INT16_C( 16154), -INT16_C( 13526), -INT16_C( 26875), -INT16_C( 19405), -INT16_C(  8154),  INT16_C(  2945), -INT16_C( 12359),
         INT16_C( 20508),  INT16_C( 17833), -INT16_C( 30254), -INT16_C( 12429),  INT16_C( 29931), -INT16_C( 25459),  INT16_C( 29721),  INT16_C( 20465) },
      {  INT16_C(  2980), -INT16_C( 12657), -INT16_C( 27434),  INT16_C(  2662), -INT16_C( 29624), -INT16_C( 13846), -INT16_C( 23400), -INT16_C( 19303),
         INT16_C( 17140), -INT16_C( 14599),  INT16_C( 28108), -INT16_C( 18539),  INT16_C(  8929), -INT16_C(  1453),  INT16_C( 17558),  INT16_C( 14922),
        -INT16_C(  9905),  INT16_C(  9481),  INT16_C( 28525), -INT16_C( 18897),  INT16_C(  6907), -INT16_C( 27777),  INT16_C(  6334), -INT16_C( 19896),
         INT16_C( 16731),  INT16_C( 10104),  INT16_C(  3758), -INT16_C( 28450),  INT16_C( 12592), -INT16_C( 14454), -INT16_C( 11147), -INT16_C( 15359) },
      {  INT16_C( 28829), -INT16_C( 27688), -INT16_C( 28961),  INT16_C( 21177),  INT16_C(  8196),  INT16_C(  7558), -INT16_C( 13128), -INT16_C( 28280),
         INT16_C( 18123), -INT16_C( 24177), -INT16_C( 20693), -INT16_C(  6539), -INT16_C( 31523), -INT16_C( 18348), -INT16_C(  5817),  INT16_C( 12011),
         INT16_C(  2437),  INT16_C( 31630),  INT16_C( 18380), -INT16_C( 11826),  INT16_C( 21607),  INT16_C(  8430),  INT16_C( 30497), -INT16_C( 32255),
         INT16_C( 29373),  INT16_C( 27937),  INT16_C( 17698),  INT16_C( 22046), -INT16_C( 23013), -INT16_C( 17108),  INT16_C( 18574),  INT16_C(  5106) } },
    { {  INT16_C(  2733),  INT16_C(  7145),  INT16_C(  6521),  INT16_C( 30161),  INT16_C( 20531), -INT16_C(  3832),  INT16_C( 20585), -INT16_C( 15197),
         INT16_C(  7058),  INT16_C( 16619), -INT16_C( 14039),  INT16_C( 23248),  INT16_C( 23546),  INT16_C( 28449),  INT16_C(  8751), -INT16_C(  8909),
         INT16_C(  7213), -INT16_C( 22792), -INT16_C( 14027),  INT16_C( 26651),  INT16_C(  9241), -INT16_C( 32167), -INT16_C(   908),  INT16_C(  1606),
         INT16_C( 12568),  INT16_C( 16711),  INT16_C(  6138), -INT16_C(  2917), -INT16_C( 17294), -INT16_C( 23965), -INT16_C( 26913),  INT16_C(  3199) },
      UINT32_C(3904010163),
      { -INT16_C( 21774),  INT16_C( 26332),  INT16_C(  8871), -INT16_C( 16531), -INT16_C( 19372),  INT16_C( 19968), -INT16_C( 25397),  INT16_C( 15939),
        -INT16_C( 22952),  INT16_C( 14304),  INT16_C( 24381), -INT16_C(  4029), -INT16_C(  2346),  INT16_C(  5848),  INT16_C( 10692), -INT16_C( 18833),
         INT16_C( 19412),  INT16_C( 31516), -INT16_C( 30354), -INT16_C( 15814),  INT16_C( 14909),  INT16_C(  2320),  INT16_C( 21462),  INT16_C( 12103),
         INT16_C( 10234),  INT16_C( 14182), -INT16_C( 21882),  INT16_C( 23591), -INT16_C(    96),  INT16_C( 25714), -INT16_C(  7895), -INT16_C(   742) },
      {  INT16_C( 13869), -INT16_C( 25736), -INT16_C( 19776), -INT16_C(   675),  INT16_C( 28140), -INT16_C( 15610),  INT16_C( 19905), -INT16_C( 17422),
         INT16_C( 22644), -INT16_C(  1294),  INT16_C(  6402), -INT16_C( 23978), -INT16_C( 14312),  INT16_C( 16646),  INT16_C(  8362), -INT16_C( 10434),
        -INT16_C( 18857),  INT16_C(  6002), -INT16_C( 12440),  INT16_C( 21780),  INT16_C(  6972), -INT16_C(   744),  INT16_C(  2664), -INT16_C(  8776),
        -INT16_C( 21918),  INT16_C( 26071),  INT16_C( 11971), -INT16_C(  9209),  INT16_C(  3830), -INT16_C( 24547),  INT16_C( 23598), -INT16_C( 31369) },
      { -INT16_C(  7905),  INT16_C(   596),  INT16_C(  6521),  INT16_C( 30161),  INT16_C(  8768),  INT16_C(  4358),  INT16_C( 20585), -INT16_C(  1483),
        -INT16_C(   308),  INT16_C( 13010),  INT16_C( 30783),  INT16_C( 23248), -INT16_C( 16658),  INT16_C( 22494),  INT16_C( 19054), -INT16_C(  8909),
         INT16_C(  7213), -INT16_C( 28018), -INT16_C( 14027),  INT16_C( 26651),  INT16_C( 21881),  INT16_C(  1576), -INT16_C(   908),  INT16_C(  3327),
         INT16_C( 12568),  INT16_C( 16711),  INT16_C(  6138),  INT16_C( 14382), -INT16_C( 17294),  INT16_C(  1167),  INT16_C( 15703), -INT16_C( 32111) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i src = simde_mm512_loadu_epi16(test_vec[i].src);
    simde__m512i a = simde_mm512_loadu_epi16(test_vec[i].a);
    simde__m512i b = simde_mm512_loadu_epi16(test_vec[i].b);
    simde__m512i r = simde_mm512_mask_add_epi16(src, test_vec[i].k, a, b);
    simde_test_x86_assert_equal_i16x32(r, simde_mm512_loadu_epi16(test_vec[i].r));
  }

  return 0;
}

static int
test_simde_mm512_maskz_add_epi16 (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const simde__mmask32 k;
    const int16_t a[32];
    const int16_t b[32];
    const int16_t r[32];
  } test_vec[] = {
    { UINT32_C(1970569674),
      { -INT16_C(  4224), -INT16_C( 11503), -INT16_C( 18041),  INT16_C(  6436), -INT16_C(  9270), -INT16_C( 15814), -INT16_C( 27569),  INT16_C( 13042),
        -INT16_C( 23737), -INT16_C( 13044),  INT16_C(  7220), -INT16_C(   316),  INT16_C( 14494), -INT16_C(   908),  INT16_C( 27220), -INT16_C( 11118),
        -INT16_C( 23719), -INT16_C(  8025), -INT16_C( 13476),  INT16_C(  9977),  INT16_C( 13479), -INT16_C(  2328), -INT16_C(  9528),  INT16_C(  3881),
         INT16_C( 13693), -INT16_C( 19747), -INT16_C( 24239), -INT16_C(  4176),  INT16_C(  9433),  INT16_C( 11756),  INT16_C( 32398), -INT16_C(  6143) },
      { -INT16_C( 22239),  INT16_C( 32200), -INT16_C( 15756),  INT16_C(  7075), -INT16_C( 29450), -INT16_C( 16878),  INT16_C( 15206), -INT16_C(  6962),
        -INT16_C( 21648), -INT16_C( 15978),  INT16_C( 17996),  INT16_C(  9649), -INT16_C( 25237), -INT16_C(  1709),  INT16_C( 21531),  INT16_C( 15585),
        -INT16_C( 21763),  INT16_C( 29369),  INT16_C( 23660),  INT16_C( 25229), -INT16_C( 24600),  INT16_C( 20256), -INT16_C(  4390),  INT16_C( 18995),
        -INT16_C( 13927), -INT16_C(  6900), -INT16_C( 17137),  INT16_C( 31243),  INT16_C( 24154),  INT16_C( 30068),  INT16_C( 21938), -INT16_C( 20303) },
      {  INT16_C(     0),  INT16_C( 20697),  INT16_C(     0),  INT16_C( 13511),  INT16_C(     0),  INT16_C(     0), -INT16_C( 12363),  INT16_C(  6080),
         INT16_C( 20151),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(  4467),
         INT16_C(     0),  INT16_C(     0),  INT16_C( 10184),  INT16_C(     0), -INT16_C( 11121),  INT16_C( 17928), -INT16_C( 13918),  INT16_C(     0),
        -INT16_C(   234),  INT16_C(     0),  INT16_C( 24160),  INT16_C(     0), -INT16_C( 31949), -INT16_C( 23712), -INT16_C( 11200),  INT16_C(     0) } },
    { UINT32_C(1797417727),
      { -INT16_C(  4529),  INT16_C( 10750),  INT16_C( 12764),  INT16_C( 30324), -INT16_C( 32518),  INT16_C(  2395),  INT16_C( 26173), -INT16_C( 26748),
        -INT16_C(  1852),  INT16_C( 30476), -INT16_C( 17075),  INT16_C( 19751),  INT16_C( 18727), -INT16_C(  4680), -INT16_C( 30984),  INT16_C( 18332),
        -INT16_C( 25996),  INT16_C( 20593), -INT16_C(  6709), -INT16_C( 14906),  INT16_C(  8805), -INT16_C( 23857),  INT16_C( 21384),  INT16_C( 19769),
         INT16_C( 17739), -INT16_C( 26428), -INT16_C(  5374),  INT16_C( 10725), -INT16_C( 25036),  INT16_C( 11286), -INT16_C( 19676), -INT16_C( 26508) },
      { -INT16_C(  6835),  INT16_C(  6632), -INT16_C( 20534),  INT16_C( 12254), -INT16_C( 21039),  INT16_C( 22993),  INT16_C(  2560),  INT16_C( 19366),
         INT16_C( 27215),  INT16_C( 20964), -INT16_C( 13995), -INT16_C( 30342), -INT16_C( 28569), -INT16_C( 29770),  INT16_C( 10819), -INT16_C( 28381),
         INT16_C(  3087), -INT16_C(  9814), -INT16_C( 30533), -INT16_C( 29688), -INT16_C(  9930),  INT16_C( 14053), -INT16_C( 29469),  INT16_C( 12930),
         INT16_C( 26358),  INT16_C( 19587), -INT16_C(   721), -INT16_C( 26667), -INT16_C( 29811), -INT16_C( 11998),  INT16_C( 18101), -INT16_C( 15262) },
      { -INT16_C( 11364),  INT16_C( 17382), -INT16_C(  7770), -INT16_C( 22958),  INT16_C( 11979),  INT16_C( 25388),  INT16_C( 28733), -INT16_C(  7382),
         INT16_C(     0), -INT16_C( 14096),  INT16_C(     0), -INT16_C( 10591),  INT16_C(     0),  INT16_C( 31086), -INT16_C( 20165),  INT16_C(     0),
         INT16_C(     0),  INT16_C( 10779),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0), -INT16_C(  9804),  INT16_C(     0),  INT16_C(     0),
        -INT16_C( 21439), -INT16_C(  6841),  INT16_C(     0), -INT16_C( 15942),  INT16_C(     0), -INT16_C(   712), -INT16_C(  1575),  INT16_C(     0) } },
    { UINT32_C( 228396114),
      {  INT16_C( 32382),  INT16_C( 24833), -INT16_C( 31990),  INT16_C(   403),  INT16_C(  5865),  INT16_C(  6221),  INT16_C(  8723), -INT16_C( 24145),
        -INT16_C( 11602),  INT16_C( 25458), -INT16_C( 11240),  INT16_C( 27176), -INT16_C( 14880),  INT16_C( 29815),  INT16_C(  4203), -INT16_C(  5825),
         INT16_C( 16526), -INT16_C( 26293), -INT16_C(  8509), -INT16_C( 21350), -INT16_C(  6155),  INT16_C(  2244),  INT16_C( 29705), -INT16_C( 18519),
         INT16_C(  6982),  INT16_C( 24091),  INT16_C( 17391), -INT16_C( 12344),  INT16_C( 16136),  INT16_C( 29508), -INT16_C( 31921), -INT16_C(  8867) },
      { -INT16_C( 22333), -INT16_C( 31114),  INT16_C(  4230),  INT16_C( 31538), -INT16_C(  2313),  INT16_C(   388),  INT16_C( 11626), -INT16_C( 20296),
        -INT16_C( 11447),  INT16_C( 14350), -INT16_C( 10730),  INT16_C(  7944),  INT16_C( 19477),  INT16_C( 25746), -INT16_C(  4145), -INT16_C( 28094),
        -INT16_C( 18281),  INT16_C(  7704),  INT16_C( 19145), -INT16_C( 16231),  INT16_C(  7488), -INT16_C( 21567),  INT16_C( 31307), -INT16_C( 27557),
         INT16_C( 27213),  INT16_C( 25804), -INT16_C( 11200),  INT16_C( 22147),  INT16_C(  5408), -INT16_C(  4166), -INT16_C(  1019), -INT16_C( 25471) },
      {  INT16_C(     0), -INT16_C(  6281),  INT16_C(     0),  INT16_C(     0),  INT16_C(  3552),  INT16_C(     0),  INT16_C( 20349),  INT16_C(     0),
         INT16_C(     0),  INT16_C(     0), -INT16_C( 21970), -INT16_C( 30416),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),
        -INT16_C(  1755),  INT16_C(     0),  INT16_C( 10636),  INT16_C( 27955),  INT16_C(  1333),  INT16_C(     0),  INT16_C(     0),  INT16_C( 19460),
        -INT16_C( 31341),  INT16_C(     0),  INT16_C(  6191),  INT16_C(  9803),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0) } },
    { UINT32_C(2126158261),
      {  INT16_C(   113), -INT16_C( 17201),  INT16_C( 10874), -INT16_C( 14512),  INT16_C(  7572), -INT16_C( 10965), -INT16_C( 20751),  INT16_C(  4651),
        -INT16_C(  6716), -INT16_C( 14079), -INT16_C( 31774), -INT16_C( 26779),  INT16_C(  8220),  INT16_C(    21),  INT16_C( 21364), -INT16_C(  6876),
        -INT16_C(  3245), -INT16_C( 12894), -INT16_C(  3555), -INT16_C( 19819), -INT16_C( 16369),  INT16_C(   391), -INT16_C( 19857),  INT16_C( 13075),
         INT16_C(  5271),  INT16_C( 31228),  INT16_C( 24983), -INT16_C( 19440),  INT16_C(  9601), -INT16_C(  2636), -INT16_C( 10119), -INT16_C( 13093) },
      {  INT16_C( 32203), -INT16_C(  5990),  INT16_C( 12143),  INT16_C( 32666),  INT16_C(  8687),  INT16_C( 24192), -INT16_C( 27693),  INT16_C( 27537),
        -INT16_C( 29273),  INT16_C( 16356), -INT16_C(  2577),  INT16_C( 28915), -INT16_C( 22758), -INT16_C( 27802),  INT16_C( 16767),  INT16_C( 19040),
        -INT16_C(  1346),  INT16_C( 11570), -INT16_C( 13015),  INT16_C(  6316),  INT16_C( 11502), -INT16_C( 15753),  INT16_C(  2239),  INT16_C( 26413),
         INT16_C(  4502), -INT16_C( 31322), -INT16_C( 26362),  INT16_C(  8693),  INT16_C( 23360), -INT16_C( 16460),  INT16_C(  5276),  INT16_C( 23049) },
      {  INT16_C( 32316),  INT16_C(     0),  INT16_C( 23017),  INT16_C(     0),  INT16_C( 16259),  INT16_C( 13227),  INT16_C(     0),  INT16_C( 32188),
         INT16_C( 29547),  INT16_C(     0),  INT16_C(     0),  INT16_C(  2136), -INT16_C( 14538),  INT16_C(     0),  INT16_C(     0),  INT16_C( 12164),
         INT16_C(     0), -INT16_C(  1324),  INT16_C(     0), -INT16_C( 13503), -INT16_C(  4867), -INT16_C( 15362),  INT16_C(     0), -INT16_C( 26048),
         INT16_C(     0), -INT16_C(    94), -INT16_C(  1379), -INT16_C( 10747), -INT16_C( 32575), -INT16_C( 19096), -INT16_C(  4843),  INT16_C(     0) } },
    { UINT32_C( 931674894),
      { -INT16_C( 14495),  INT16_C(  8377), -INT16_C(  6449),  INT16_C( 25991),  INT16_C( 11767), -INT16_C(   278), -INT16_C(  7994),  INT16_C(  1567),
        -INT16_C( 11461), -INT16_C( 10043), -INT16_C( 12568), -INT16_C(  2510), -INT16_C( 17910),  INT16_C(  4654),  INT16_C( 32495),  INT16_C( 20489),
        -INT16_C( 15803),  INT16_C(  5232), -INT16_C(  1880), -INT16_C( 24454),  INT16_C( 25637), -INT16_C(  4962), -INT16_C( 17084), -INT16_C( 32526),
        -INT16_C( 18288),  INT16_C( 30808), -INT16_C( 30074), -INT16_C( 28561), -INT16_C( 25275),  INT16_C( 13475), -INT16_C( 21477),  INT16_C( 24708) },
      { -INT16_C(  2961),  INT16_C(  6004), -INT16_C(  4372),  INT16_C(  4791),  INT16_C( 21843), -INT16_C( 26626), -INT16_C(  4078), -INT16_C( 23785),
         INT16_C( 28584),  INT16_C( 12059), -INT16_C( 29958),  INT16_C( 16319),  INT16_C( 25127),  INT16_C( 17011), -INT16_C(  2289),  INT16_C( 32418),
         INT16_C(  6123), -INT16_C( 10091),  INT16_C( 19717),  INT16_C( 22762), -INT16_C(  5982), -INT16_C( 18960),  INT16_C(  2008), -INT16_C( 32424),
         INT16_C( 29559),  INT16_C( 29104),  INT16_C( 28670),  INT16_C(  9648),  INT16_C(  9170), -INT16_C(  7832),  INT16_C(  2586),  INT16_C(  1375) },
      {  INT16_C(     0),  INT16_C( 14381), -INT16_C( 10821),  INT16_C( 30782),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),
         INT16_C( 17123),  INT16_C(  2016),  INT16_C(     0),  INT16_C( 13809),  INT16_C(  7217),  INT16_C( 21665),  INT16_C(     0),  INT16_C(     0),
         INT16_C(     0),  INT16_C(     0),  INT16_C(     0), -INT16_C(  1692),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(   586),
         INT16_C( 11271), -INT16_C(  5624), -INT16_C(  1404),  INT16_C(     0), -INT16_C( 16105),  INT16_C(  5643),  INT16_C(     0),  INT16_C(     0) } },
    { UINT32_C( 668857377),
      {  INT16_C( 28591), -INT16_C( 30567), -INT16_C(  3721), -INT16_C(  4599), -INT16_C( 18076),  INT16_C( 25183),  INT16_C(  3880), -INT16_C(  1400),
        -INT16_C(  4046),  INT16_C( 19675),  INT16_C( 15098),  INT16_C(  7249),  INT16_C( 12079),  INT16_C( 28739), -INT16_C( 15626), -INT16_C( 22956),
        -INT16_C(  4814), -INT16_C( 22226),  INT16_C( 14302),  INT16_C( 17303), -INT16_C(  2320),  INT16_C(  6309),  INT16_C( 11525),  INT16_C( 14099),
        -INT16_C(  4579),  INT16_C(  6275), -INT16_C( 11223),  INT16_C( 22580),  INT16_C( 30467), -INT16_C(  1336),  INT16_C(  7481),  INT16_C( 27552) },
      { -INT16_C( 12790), -INT16_C(  5868), -INT16_C( 21755), -INT16_C(  2772), -INT16_C( 11871), -INT16_C( 23027),  INT16_C(  8447),  INT16_C(  7389),
         INT16_C( 24591),  INT16_C( 14388),  INT16_C( 26677),  INT16_C( 14480),  INT16_C( 22751),  INT16_C(  6450), -INT16_C( 11659), -INT16_C( 32636),
        -INT16_C( 26208), -INT16_C( 23191), -INT16_C( 27324), -INT16_C(  6502), -INT16_C( 22426),  INT16_C( 25996),  INT16_C( 27336), -INT16_C( 10366),
        -INT16_C( 18742), -INT16_C(   241), -INT16_C( 24801), -INT16_C(   456),  INT16_C( 27384),  INT16_C( 27927), -INT16_C( 25539), -INT16_C(  8723) },
      {  INT16_C( 15801),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(  2156),  INT16_C(     0),  INT16_C(     0),
         INT16_C(     0),  INT16_C(     0), -INT16_C( 23761),  INT16_C(     0), -INT16_C( 30706), -INT16_C( 30347), -INT16_C( 27285),  INT16_C(  9944),
        -INT16_C( 31022),  INT16_C(     0), -INT16_C( 13022),  INT16_C( 10801), -INT16_C( 24746),  INT16_C(     0), -INT16_C( 26675),  INT16_C(  3733),
        -INT16_C( 23321),  INT16_C(  6034),  INT16_C( 29512),  INT16_C(     0),  INT16_C(     0),  INT16_C( 26591),  INT16_C(     0),  INT16_C(     0) } },
    { UINT32_C(2038650421),
      { -INT16_C(  4923), -INT16_C( 29001),  INT16_C( 14678),  INT16_C(  8293),  INT16_C( 30192),  INT16_C(  3872),  INT16_C( 22548),  INT16_C(  3085),
         INT16_C(  9666), -INT16_C(   134),  INT16_C( 26561), -INT16_C(  2339),  INT16_C( 24766), -INT16_C( 22161), -INT16_C( 12419),  INT16_C( 17403),
        -INT16_C( 19525),  INT16_C(  4561),  INT16_C( 14060), -INT16_C(  9167),  INT16_C( 20907), -INT16_C( 16149), -INT16_C(  1623),  INT16_C( 27852),
         INT16_C( 17950), -INT16_C(  8341),  INT16_C( 18606),  INT16_C( 27861),  INT16_C( 17576),  INT16_C(  9749),  INT16_C(  4371), -INT16_C( 12695) },
      {  INT16_C( 15044), -INT16_C( 20257),  INT16_C(  4464),  INT16_C(  7309),  INT16_C( 30818),  INT16_C(  3292), -INT16_C( 22415), -INT16_C( 28808),
        -INT16_C(  7185), -INT16_C( 25234),  INT16_C( 17196), -INT16_C( 11255),  INT16_C(  7816), -INT16_C( 25606),  INT16_C( 25391), -INT16_C(  3222),
         INT16_C( 18845),  INT16_C(  3748),  INT16_C( 12634), -INT16_C( 17110),  INT16_C(  1705),  INT16_C(  7113),  INT16_C( 16814), -INT16_C( 25174),
         INT16_C(  6436),  INT16_C( 20538),  INT16_C( 17244), -INT16_C(  7131),  INT16_C(  8034), -INT16_C( 28288), -INT16_C(  5501),  INT16_C(  8325) },
      {  INT16_C( 10121),  INT16_C(     0),  INT16_C( 19142),  INT16_C(     0), -INT16_C(  4526),  INT16_C(  7164),  INT16_C(     0),  INT16_C(     0),
         INT16_C(     0), -INT16_C( 25368), -INT16_C( 21779),  INT16_C(     0),  INT16_C( 32582),  INT16_C(     0),  INT16_C( 12972),  INT16_C(     0),
        -INT16_C(   680),  INT16_C(  8309),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(  2678),
         INT16_C( 24386),  INT16_C(     0),  INT16_C(     0),  INT16_C( 20730),  INT16_C( 25610), -INT16_C( 18539), -INT16_C(  1130),  INT16_C(     0) } },
    { UINT32_C(2385389875),
      {  INT16_C(  5214),  INT16_C(  3358), -INT16_C( 13995),  INT16_C( 31146), -INT16_C(  6686),  INT16_C( 16074), -INT16_C(  4312), -INT16_C( 30173),
        -INT16_C( 23794), -INT16_C( 28388), -INT16_C( 24179), -INT16_C( 16206), -INT16_C(  7990),  INT16_C(  9294), -INT16_C( 26311), -INT16_C( 26841),
         INT16_C( 18093),  INT16_C(   676),  INT16_C( 20239), -INT16_C(  3716),  INT16_C( 17972),  INT16_C( 23599),  INT16_C( 21045),  INT16_C( 17383),
         INT16_C(  1013), -INT16_C( 32043), -INT16_C( 30812),  INT16_C( 28227), -INT16_C( 28313), -INT16_C( 24430), -INT16_C( 18133), -INT16_C( 10184) },
      { -INT16_C(  8961),  INT16_C(  3803),  INT16_C( 22315),  INT16_C( 24575),  INT16_C( 12189), -INT16_C( 11588), -INT16_C( 23679),  INT16_C( 30485),
        -INT16_C(  5466),  INT16_C( 19193),  INT16_C( 15473), -INT16_C(  9800),  INT16_C( 19150), -INT16_C(  1671), -INT16_C( 20221),  INT16_C(   977),
        -INT16_C( 21362), -INT16_C( 18159),  INT16_C(  4355), -INT16_C( 24551), -INT16_C( 10944), -INT16_C( 16014), -INT16_C( 30600),  INT16_C(  7736),
         INT16_C( 12914), -INT16_C(  7064),  INT16_C(  8302),  INT16_C( 15549),  INT16_C( 13930),  INT16_C( 27957),  INT16_C(  2024),  INT16_C( 30320) },
      { -INT16_C(  3747),  INT16_C(  7161),  INT16_C(     0),  INT16_C(     0),  INT16_C(  5503),  INT16_C(  4486),  INT16_C(     0),  INT16_C(     0),
        -INT16_C( 29260),  INT16_C(     0),  INT16_C(     0), -INT16_C( 26006),  INT16_C(     0),  INT16_C(  7623),  INT16_C(     0),  INT16_C(     0),
         INT16_C(     0), -INT16_C( 17483),  INT16_C( 24594), -INT16_C( 28267),  INT16_C(     0),  INT16_C(  7585),  INT16_C(     0),  INT16_C(     0),
         INT16_C(     0),  INT16_C( 26429), -INT16_C( 22510), -INT16_C( 21760),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C( 20136) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i a = simde_mm512_loadu_epi16(test_vec[i].a);
    simde__m512i b = simde_mm512_loadu_epi16(test_vec[i].b);
    simde__m512i r = simde_mm512_maskz_add_epi16(test_vec[i].k, a, b);
    simde_test_x86_assert_equal_i16x32(r, simde_mm512_loadu_epi16(test_vec[i].r));
  }

  return 0;
}

static int
test_simde_mm512_adds_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C( -30), INT8_C( -16), INT8_C( -64), INT8_C( 113),
                           INT8_C(  51), INT8_C(-115), INT8_C(  19), INT8_C( -80),
                           INT8_C(-110), INT8_C( -62), INT8_C( -91), INT8_C(   8),
                           INT8_C(  11), INT8_C( -49), INT8_C( -43), INT8_C(-101),
                           INT8_C(  16), INT8_C(  61), INT8_C(  -2), INT8_C(-100),
                           INT8_C(   1), INT8_C( -80), INT8_C( 127), INT8_C(-105),
                           INT8_C( -74), INT8_C(-126), INT8_C( 122), INT8_C(  30),
                           INT8_C( -73), INT8_C(  48), INT8_C( -33), INT8_C(   2),
                           INT8_C( -82), INT8_C( -10), INT8_C(  33), INT8_C(  20),
                           INT8_C(-120), INT8_C(-120), INT8_C( -46), INT8_C( -54),
                           INT8_C( -43), INT8_C(  63), INT8_C(  81), INT8_C( 103),
                           INT8_C( 118), INT8_C( -84), INT8_C(  76), INT8_C(  47),
                           INT8_C( 101), INT8_C( -83), INT8_C(  15), INT8_C(  23),
                           INT8_C(  36), INT8_C(-116), INT8_C( -88), INT8_C( -45),
                           INT8_C(  -6), INT8_C(  86), INT8_C(  20), INT8_C(  39),
                           INT8_C( 117), INT8_C(  80), INT8_C(  97), INT8_C(  41)),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C(  43), INT8_C(  38), INT8_C(  97),
                           INT8_C(  38), INT8_C(  68), INT8_C(  88), INT8_C(  56),
                           INT8_C( -39), INT8_C(  61), INT8_C( -57), INT8_C( -66),
                           INT8_C(-121), INT8_C(  29), INT8_C( 110), INT8_C( 127),
                           INT8_C(-115), INT8_C(  16), INT8_C( -46), INT8_C(  65),
                           INT8_C( -36), INT8_C(  26), INT8_C(  12), INT8_C( -79),
                           INT8_C( -66), INT8_C( -28), INT8_C( -67), INT8_C( -79),
                           INT8_C( -60), INT8_C( -13), INT8_C(  74), INT8_C(  25),
                           INT8_C(  46), INT8_C(   8), INT8_C(  70), INT8_C( 106),
                           INT8_C(-119), INT8_C(   0), INT8_C( -96), INT8_C( -51),
                           INT8_C( -50), INT8_C(  93), INT8_C(  92), INT8_C(  65),
                           INT8_C( -96), INT8_C(-126), INT8_C(   4), INT8_C(   9),
                           INT8_C(  26), INT8_C(-119), INT8_C(  93), INT8_C(  15),
                           INT8_C(-115), INT8_C(  77), INT8_C( 125), INT8_C( -62),
                           INT8_C(  77), INT8_C( -22), INT8_C( 101), INT8_C(  83),
                           INT8_C(  45), INT8_C( -68), INT8_C(  97), INT8_C( -19)),
      simde_mm512_set_epi8(INT8_C(  92), INT8_C(  27), INT8_C( -26), INT8_C( 127),
                           INT8_C(  89), INT8_C( -47), INT8_C( 107), INT8_C( -24),
                           INT8_C(-128), INT8_C(  -1), INT8_C(-128), INT8_C( -58),
                           INT8_C(-110), INT8_C( -20), INT8_C(  67), INT8_C(  26),
                           INT8_C( -99), INT8_C(  77), INT8_C( -48), INT8_C( -35),
                           INT8_C( -35), INT8_C( -54), INT8_C( 127), INT8_C(-128),
                           INT8_C(-128), INT8_C(-128), INT8_C(  55), INT8_C( -49),
                           INT8_C(-128), INT8_C(  35), INT8_C(  41), INT8_C(  27),
                           INT8_C( -36), INT8_C(  -2), INT8_C( 103), INT8_C( 126),
                           INT8_C(-128), INT8_C(-120), INT8_C(-128), INT8_C(-105),
                           INT8_C( -93), INT8_C( 127), INT8_C( 127), INT8_C( 127),
                           INT8_C(  22), INT8_C(-128), INT8_C(  80), INT8_C(  56),
                           INT8_C( 127), INT8_C(-128), INT8_C( 108), INT8_C(  38),
                           INT8_C( -79), INT8_C( -39), INT8_C(  37), INT8_C(-107),
                           INT8_C(  71), INT8_C(  64), INT8_C( 121), INT8_C( 122),
                           INT8_C( 127), INT8_C(  12), INT8_C( 127), INT8_C(  22)) },
    { simde_mm512_set_epi8(INT8_C(  60), INT8_C(  96), INT8_C(-106), INT8_C(-115),
                           INT8_C(  31), INT8_C(-108), INT8_C(  15), INT8_C(  63),
                           INT8_C( -77), INT8_C( 125), INT8_C(  41), INT8_C( -80),
                           INT8_C(  36), INT8_C(-118), INT8_C(-116), INT8_C( -63),
                           INT8_C( -44), INT8_C(  70), INT8_C(  99), INT8_C(  48),
                           INT8_C(  67), INT8_C(  43), INT8_C(  83), INT8_C(  53),
                           INT8_C(  60), INT8_C(  57), INT8_C(-118), INT8_C(  55),
                           INT8_C( -62), INT8_C( -42), INT8_C(  19), INT8_C(  52),
                           INT8_C( -37), INT8_C( -32), INT8_C(  33), INT8_C(-114),
                           INT8_C( -96), INT8_C(  53), INT8_C(  18), INT8_C( -37),
                           INT8_C(   6), INT8_C( -87), INT8_C( -11), INT8_C( -10),
                           INT8_C(  -4), INT8_C(  84), INT8_C( 104), INT8_C(  55),
                           INT8_C(  92), INT8_C( 117), INT8_C(  16), INT8_C( 115),
                           INT8_C(  83), INT8_C(  80), INT8_C(-125), INT8_C(  64),
                           INT8_C(  74), INT8_C(  -9), INT8_C( -62), INT8_C(  67),
                           INT8_C( 102), INT8_C(  66), INT8_C( -86), INT8_C(-112)),
      simde_mm512_set_epi8(INT8_C( -97), INT8_C(  52), INT8_C( -91), INT8_C(   7),
                           INT8_C(  -1), INT8_C( -19), INT8_C(  38), INT8_C(  15),
                           INT8_C(  76), INT8_C(  63), INT8_C(  10), INT8_C(  18),
                           INT8_C(  54), INT8_C(  73), INT8_C(  15), INT8_C( -54),
                           INT8_C(-114), INT8_C(  63), INT8_C(  44), INT8_C(   4),
                           INT8_C(  41), INT8_C(  90), INT8_C( -78), INT8_C( -67),
                           INT8_C(  95), INT8_C( -14), INT8_C( -10), INT8_C( -44),
                           INT8_C(  53), INT8_C( 102), INT8_C( 127), INT8_C( 120),
                           INT8_C( -89), INT8_C(  10), INT8_C( -36), INT8_C( -50),
                           INT8_C( 118), INT8_C(-106), INT8_C( -52), INT8_C(  76),
                           INT8_C(  66), INT8_C( -36), INT8_C( -79), INT8_C(  91),
                           INT8_C(  14), INT8_C( 103), INT8_C( -73), INT8_C(-123),
                           INT8_C(  68), INT8_C( -54), INT8_C(-103), INT8_C(  38),
                           INT8_C(  58), INT8_C(   0), INT8_C( -62), INT8_C( -76),
                           INT8_C(  93), INT8_C( 119), INT8_C(  14), INT8_C(  84),
                           INT8_C( -83), INT8_C(  76), INT8_C( -47), INT8_C( -53)),
      simde_mm512_set_epi8(INT8_C( -37), INT8_C( 127), INT8_C(-128), INT8_C(-108),
                           INT8_C(  30), INT8_C(-127), INT8_C(  53), INT8_C(  78),
                           INT8_C(  -1), INT8_C( 127), INT8_C(  51), INT8_C( -62),
                           INT8_C(  90), INT8_C( -45), INT8_C(-101), INT8_C(-117),
                           INT8_C(-128), INT8_C( 127), INT8_C( 127), INT8_C(  52),
                           INT8_C( 108), INT8_C( 127), INT8_C(   5), INT8_C( -14),
                           INT8_C( 127), INT8_C(  43), INT8_C(-128), INT8_C(  11),
                           INT8_C(  -9), INT8_C(  60), INT8_C( 127), INT8_C( 127),
                           INT8_C(-126), INT8_C( -22), INT8_C(  -3), INT8_C(-128),
                           INT8_C(  22), INT8_C( -53), INT8_C( -34), INT8_C(  39),
                           INT8_C(  72), INT8_C(-123), INT8_C( -90), INT8_C(  81),
                           INT8_C(  10), INT8_C( 127), INT8_C(  31), INT8_C( -68),
                           INT8_C( 127), INT8_C(  63), INT8_C( -87), INT8_C( 127),
                           INT8_C( 127), INT8_C(  80), INT8_C(-128), INT8_C( -12),
                           INT8_C( 127), INT8_C( 110), INT8_C( -48), INT8_C( 127),
                           INT8_C(  19), INT8_C( 127), INT8_C(-128), INT8_C(-128)) },
    { simde_mm512_set_epi8(INT8_C( -80), INT8_C( 122), INT8_C(-100), INT8_C( 123),
                           INT8_C(  82), INT8_C(-107), INT8_C(  95), INT8_C( -80),
                           INT8_C(-115), INT8_C(-109), INT8_C(  60), INT8_C(  72),
                           INT8_C(  57), INT8_C(  99), INT8_C( -30), INT8_C(-115),
                           INT8_C(  69), INT8_C(  18), INT8_C(  -5), INT8_C(  -6),
                           INT8_C( -90), INT8_C( -20), INT8_C(  17), INT8_C( 121),
                           INT8_C(-100), INT8_C( -55), INT8_C(  90), INT8_C( -42),
                           INT8_C(-113), INT8_C( 119), INT8_C(  44), INT8_C(-123),
                           INT8_C( -39), INT8_C( 114), INT8_C(  37), INT8_C( -84),
                           INT8_C( -88), INT8_C(  15), INT8_C(  23), INT8_C( 114),
                           INT8_C(  63), INT8_C( -61), INT8_C(  22), INT8_C(   8),
                           INT8_C(  54), INT8_C(  19), INT8_C( -34), INT8_C(  18),
                           INT8_C( -36), INT8_C( 104), INT8_C(   1), INT8_C(   5),
                           INT8_C(-116), INT8_C(  79), INT8_C( -20), INT8_C(  -4),
                           INT8_C(  95), INT8_C( 103), INT8_C(   3), INT8_C(  64),
                           INT8_C(  34), INT8_C( -49), INT8_C( -27), INT8_C(  41)),
      simde_mm512_set_epi8(INT8_C(  97), INT8_C(-116), INT8_C( -44), INT8_C( -44),
                           INT8_C(  67), INT8_C( -66), INT8_C(  77), INT8_C(  60),
                           INT8_C(  74), INT8_C( -19), INT8_C(-123), INT8_C( -81),
                           INT8_C( -74), INT8_C( -21), INT8_C( -32), INT8_C(-122),
                           INT8_C(-110), INT8_C( 116), INT8_C( 115), INT8_C(  99),
                           INT8_C(  29), INT8_C(  50), INT8_C(-119), INT8_C(-126),
                           INT8_C( -53), INT8_C(  68), INT8_C( -37), INT8_C(  84),
                           INT8_C(  23), INT8_C( -10), INT8_C(  15), INT8_C(  37),
                           INT8_C( -93), INT8_C(  57), INT8_C(  28), INT8_C(-116),
                           INT8_C(  56), INT8_C(-124), INT8_C( -93), INT8_C( -67),
                           INT8_C(  27), INT8_C(  -1), INT8_C( -70), INT8_C( -30),
                           INT8_C( -39), INT8_C(  59), INT8_C(  76), INT8_C( 108),
                           INT8_C(  13), INT8_C( -29), INT8_C(  60), INT8_C( 106),
                           INT8_C( 106), INT8_C( -77), INT8_C(-102), INT8_C(   3),
                           INT8_C( -18), INT8_C(  23), INT8_C( 113), INT8_C( -97),
                           INT8_C( 109), INT8_C(  81), INT8_C(  42), INT8_C(  93)),
      simde_mm512_set_epi8(INT8_C(  17), INT8_C(   6), INT8_C(-128), INT8_C(  79),
                           INT8_C( 127), INT8_C(-128), INT8_C( 127), INT8_C( -20),
                           INT8_C( -41), INT8_C(-128), INT8_C( -63), INT8_C(  -9),
                           INT8_C( -17), INT8_C(  78), INT8_C( -62), INT8_C(-128),
                           INT8_C( -41), INT8_C( 127), INT8_C( 110), INT8_C(  93),
                           INT8_C( -61), INT8_C(  30), INT8_C(-102), INT8_C(  -5),
                           INT8_C(-128), INT8_C(  13), INT8_C(  53), INT8_C(  42),
                           INT8_C( -90), INT8_C( 109), INT8_C(  59), INT8_C( -86),
                           INT8_C(-128), INT8_C( 127), INT8_C(  65), INT8_C(-128),
                           INT8_C( -32), INT8_C(-109), INT8_C( -70), INT8_C(  47),
                           INT8_C(  90), INT8_C( -62), INT8_C( -48), INT8_C( -22),
                           INT8_C(  15), INT8_C(  78), INT8_C(  42), INT8_C( 126),
                           INT8_C( -23), INT8_C(  75), INT8_C(  61), INT8_C( 111),
                           INT8_C( -10), INT8_C(   2), INT8_C(-122), INT8_C(  -1),
                           INT8_C(  77), INT8_C( 126), INT8_C( 116), INT8_C( -33),
                           INT8_C( 127), INT8_C(  32), INT8_C(  15), INT8_C( 127)) },
    { simde_mm512_set_epi8(INT8_C( -94), INT8_C(  96), INT8_C( -77), INT8_C( -55),
                           INT8_C(  18), INT8_C(  12), INT8_C(  78), INT8_C( -17),
                           INT8_C( -94), INT8_C(  83), INT8_C( -20), INT8_C(-101),
                           INT8_C( -62), INT8_C( -62), INT8_C( -77), INT8_C(  21),
                           INT8_C(  21), INT8_C( -49), INT8_C(-127), INT8_C( -47),
                           INT8_C( -26), INT8_C(  62), INT8_C( -51), INT8_C( -34),
                           INT8_C(   9), INT8_C( -56), INT8_C(  63), INT8_C(   4),
                           INT8_C(  64), INT8_C(  46), INT8_C(  68), INT8_C( -18),
                           INT8_C(-110), INT8_C( 103), INT8_C(-101), INT8_C(  45),
                           INT8_C( -81), INT8_C( 125), INT8_C(   8), INT8_C(  72),
                           INT8_C( -48), INT8_C( -28), INT8_C( 102), INT8_C( -90),
                           INT8_C(-101), INT8_C( -40), INT8_C( -94), INT8_C(-127),
                           INT8_C( -36), INT8_C( -32), INT8_C(  34), INT8_C( -39),
                           INT8_C( -64), INT8_C( 111), INT8_C(  36), INT8_C(  91),
                           INT8_C(  90), INT8_C( -10), INT8_C(  88), INT8_C(-117),
                           INT8_C( 117), INT8_C(-111), INT8_C(-128), INT8_C( -35)),
      simde_mm512_set_epi8(INT8_C(  65), INT8_C(  -2), INT8_C(   4), INT8_C( -77),
                           INT8_C(  33), INT8_C(-119), INT8_C( -36), INT8_C(  95),
                           INT8_C( -54), INT8_C(  57), INT8_C( -15), INT8_C(  20),
                           INT8_C( 119), INT8_C( -56), INT8_C( -57), INT8_C(  22),
                           INT8_C( -23), INT8_C( -56), INT8_C( -77), INT8_C( 114),
                           INT8_C( -25), INT8_C(  85), INT8_C(  65), INT8_C( 124),
                           INT8_C(  80), INT8_C(  94), INT8_C(  -6), INT8_C(-128),
                           INT8_C(  25), INT8_C( -80), INT8_C(  31), INT8_C( -23),
                           INT8_C( 123), INT8_C(-123), INT8_C( -56), INT8_C(  34),
                           INT8_C(  72), INT8_C( -39), INT8_C( -17), INT8_C(  39),
                           INT8_C(  29), INT8_C( -88), INT8_C(  65), INT8_C(  81),
                           INT8_C(-120), INT8_C(  80), INT8_C( -76), INT8_C( -59),
                           INT8_C(  48), INT8_C( -90), INT8_C( -85), INT8_C(  82),
                           INT8_C( 115), INT8_C(-114), INT8_C(  84), INT8_C( -40),
                           INT8_C( -69), INT8_C( -11), INT8_C(-118), INT8_C(  39),
                           INT8_C( -17), INT8_C( -23), INT8_C(   4), INT8_C( -37)),
      simde_mm512_set_epi8(INT8_C( -29), INT8_C(  94), INT8_C( -73), INT8_C(-128),
                           INT8_C(  51), INT8_C(-107), INT8_C(  42), INT8_C(  78),
                           INT8_C(-128), INT8_C( 127), INT8_C( -35), INT8_C( -81),
                           INT8_C(  57), INT8_C(-118), INT8_C(-128), INT8_C(  43),
                           INT8_C(  -2), INT8_C(-105), INT8_C(-128), INT8_C(  67),
                           INT8_C( -51), INT8_C( 127), INT8_C(  14), INT8_C(  90),
                           INT8_C(  89), INT8_C(  38), INT8_C(  57), INT8_C(-124),
                           INT8_C(  89), INT8_C( -34), INT8_C(  99), INT8_C( -41),
                           INT8_C(  13), INT8_C( -20), INT8_C(-128), INT8_C(  79),
                           INT8_C(  -9), INT8_C(  86), INT8_C(  -9), INT8_C( 111),
                           INT8_C( -19), INT8_C(-116), INT8_C( 127), INT8_C(  -9),
                           INT8_C(-128), INT8_C(  40), INT8_C(-128), INT8_C(-128),
                           INT8_C(  12), INT8_C(-122), INT8_C( -51), INT8_C(  43),
                           INT8_C(  51), INT8_C(  -3), INT8_C( 120), INT8_C(  51),
                           INT8_C(  21), INT8_C( -21), INT8_C( -30), INT8_C( -78),
                           INT8_C( 100), INT8_C(-128), INT8_C(-124), INT8_C( -72)) },
    { simde_mm512_set_epi8(INT8_C(  31), INT8_C( -81), INT8_C( 115), INT8_C(  18),
                           INT8_C(  20), INT8_C( -33), INT8_C(-125), INT8_C( -45),
                           INT8_C(  54), INT8_C(  82), INT8_C(  61), INT8_C(  81),
                           INT8_C( 123), INT8_C(  18), INT8_C(  89), INT8_C(  34),
                           INT8_C(  10), INT8_C( -54), INT8_C( -24), INT8_C(  54),
                           INT8_C(  49), INT8_C( -70), INT8_C(   7), INT8_C( -12),
                           INT8_C( 110), INT8_C( -16), INT8_C( -10), INT8_C(   4),
                           INT8_C(   3), INT8_C( -17), INT8_C( -46), INT8_C( -29),
                           INT8_C(  26), INT8_C( -38), INT8_C(-107), INT8_C( -25),
                           INT8_C(  61), INT8_C(  -4), INT8_C( -21), INT8_C( -11),
                           INT8_C( -29), INT8_C(  62), INT8_C( 120), INT8_C(  84),
                           INT8_C( -48), INT8_C( -42), INT8_C( -15), INT8_C( -64),
                           INT8_C( -90), INT8_C( 111), INT8_C(-123), INT8_C(  61),
                           INT8_C(  22), INT8_C( -48), INT8_C(-107), INT8_C( 122),
                           INT8_C(  27), INT8_C( 119), INT8_C( -63), INT8_C( -61),
                           INT8_C( -69), INT8_C(  46), INT8_C(  34), INT8_C(-101)),
      simde_mm512_set_epi8(INT8_C(  44), INT8_C( 101), INT8_C( -48), INT8_C( -49),
                           INT8_C(  63), INT8_C(  93), INT8_C( -48), INT8_C(-122),
                           INT8_C( -67), INT8_C(  27), INT8_C(   1), INT8_C( -55),
                           INT8_C( -79), INT8_C( -44), INT8_C(-115), INT8_C(-126),
                           INT8_C( -42), INT8_C(  29), INT8_C(  66), INT8_C( -83),
                           INT8_C( 108), INT8_C(  -1), INT8_C( -47), INT8_C(-104),
                           INT8_C(  62), INT8_C(  29), INT8_C(   4), INT8_C( -47),
                           INT8_C(  98), INT8_C(-109), INT8_C( -23), INT8_C(  69),
                           INT8_C(-110), INT8_C( -47), INT8_C(  48), INT8_C(-101),
                           INT8_C( -80), INT8_C(-110), INT8_C( -55), INT8_C(  25),
                           INT8_C(  39), INT8_C(  58), INT8_C(   4), INT8_C(-108),
                           INT8_C( -23), INT8_C( -79), INT8_C( 124), INT8_C(  36),
                           INT8_C( 113), INT8_C( 110), INT8_C( 105), INT8_C( 113),
                           INT8_C( -54), INT8_C( -63), INT8_C(  50), INT8_C( -99),
                           INT8_C(  -8), INT8_C( -76), INT8_C( 102), INT8_C(  51),
                           INT8_C(  58), INT8_C(  16), INT8_C( -94), INT8_C( -93)),
      simde_mm512_set_epi8(INT8_C(  75), INT8_C(  20), INT8_C(  67), INT8_C( -31),
                           INT8_C(  83), INT8_C(  60), INT8_C(-128), INT8_C(-128),
                           INT8_C( -13), INT8_C( 109), INT8_C(  62), INT8_C(  26),
                           INT8_C(  44), INT8_C( -26), INT8_C( -26), INT8_C( -92),
                           INT8_C( -32), INT8_C( -25), INT8_C(  42), INT8_C( -29),
                           INT8_C( 127), INT8_C( -71), INT8_C( -40), INT8_C(-116),
                           INT8_C( 127), INT8_C(  13), INT8_C(  -6), INT8_C( -43),
                           INT8_C( 101), INT8_C(-126), INT8_C( -69), INT8_C(  40),
                           INT8_C( -84), INT8_C( -85), INT8_C( -59), INT8_C(-126),
                           INT8_C( -19), INT8_C(-114), INT8_C( -76), INT8_C(  14),
                           INT8_C(  10), INT8_C( 120), INT8_C( 124), INT8_C( -24),
                           INT8_C( -71), INT8_C(-121), INT8_C( 109), INT8_C( -28),
                           INT8_C(  23), INT8_C( 127), INT8_C( -18), INT8_C( 127),
                           INT8_C( -32), INT8_C(-111), INT8_C( -57), INT8_C(  23),
                           INT8_C(  19), INT8_C(  43), INT8_C(  39), INT8_C( -10),
                           INT8_C( -11), INT8_C(  62), INT8_C( -60), INT8_C(-128)) },
    { simde_mm512_set_epi8(INT8_C(  64), INT8_C(  55), INT8_C(  97), INT8_C( -61),
                           INT8_C(  89), INT8_C( 120), INT8_C(  49), INT8_C( 124),
                           INT8_C(  16), INT8_C( 113), INT8_C(  48), INT8_C(  70),
                           INT8_C(  60), INT8_C( -11), INT8_C(  98), INT8_C(  70),
                           INT8_C( 111), INT8_C(  55), INT8_C( -50), INT8_C( -21),
                           INT8_C(-102), INT8_C(   3), INT8_C(  75), INT8_C(  -9),
                           INT8_C(  34), INT8_C(  96), INT8_C(-104), INT8_C(  37),
                           INT8_C(  74), INT8_C(  22), INT8_C(  13), INT8_C(  82),
                           INT8_C(-108), INT8_C(-112), INT8_C(  49), INT8_C( -58),
                           INT8_C( 116), INT8_C(  58), INT8_C( -29), INT8_C(  60),
                           INT8_C( 125), INT8_C( 105), INT8_C( -20), INT8_C(  -4),
                           INT8_C(-106), INT8_C(-111), INT8_C( -29), INT8_C( -32),
                           INT8_C( -43), INT8_C(-103), INT8_C(  84), INT8_C(  40),
                           INT8_C(  63), INT8_C(  88), INT8_C( -74), INT8_C( -49),
                           INT8_C(  10), INT8_C(  50), INT8_C(  38), INT8_C( 108),
                           INT8_C(  42), INT8_C( -40), INT8_C( -81), INT8_C(  31)),
      simde_mm512_set_epi8(INT8_C(-107), INT8_C( 105), INT8_C( -15), INT8_C( -49),
                           INT8_C(  74), INT8_C( -31), INT8_C( -49), INT8_C( 112),
                           INT8_C(-103), INT8_C(  69), INT8_C( -55), INT8_C(-115),
                           INT8_C( -48), INT8_C(  96), INT8_C(  -8), INT8_C( -35),
                           INT8_C( -24), INT8_C( 101), INT8_C(  70), INT8_C( -69),
                           INT8_C(-105), INT8_C( -28), INT8_C( -38), INT8_C( -85),
                           INT8_C( -94), INT8_C(-122), INT8_C( -80), INT8_C(  95),
                           INT8_C(  -1), INT8_C(  87), INT8_C(  21), INT8_C(   6),
                           INT8_C(-103), INT8_C(  38), INT8_C(  15), INT8_C( -98),
                           INT8_C( -27), INT8_C(  57), INT8_C( -76), INT8_C(-112),
                           INT8_C(  77), INT8_C(  -3), INT8_C(  57), INT8_C(   3),
                           INT8_C( 123), INT8_C( -18), INT8_C( -90), INT8_C(-119),
                           INT8_C( 112), INT8_C(  61), INT8_C( -48), INT8_C( -16),
                           INT8_C( -36), INT8_C(-125), INT8_C( -10), INT8_C(  77),
                           INT8_C( 106), INT8_C(  72), INT8_C(  62), INT8_C( -24),
                           INT8_C( -65), INT8_C( 102), INT8_C(-122), INT8_C(  19)),
      simde_mm512_set_epi8(INT8_C( -43), INT8_C( 127), INT8_C(  82), INT8_C(-110),
                           INT8_C( 127), INT8_C(  89), INT8_C(   0), INT8_C( 127),
                           INT8_C( -87), INT8_C( 127), INT8_C(  -7), INT8_C( -45),
                           INT8_C(  12), INT8_C(  85), INT8_C(  90), INT8_C(  35),
                           INT8_C(  87), INT8_C( 127), INT8_C(  20), INT8_C( -90),
                           INT8_C(-128), INT8_C( -25), INT8_C(  37), INT8_C( -94),
                           INT8_C( -60), INT8_C( -26), INT8_C(-128), INT8_C( 127),
                           INT8_C(  73), INT8_C( 109), INT8_C(  34), INT8_C(  88),
                           INT8_C(-128), INT8_C( -74), INT8_C(  64), INT8_C(-128),
                           INT8_C(  89), INT8_C( 115), INT8_C(-105), INT8_C( -52),
                           INT8_C( 127), INT8_C( 102), INT8_C(  37), INT8_C(  -1),
                           INT8_C(  17), INT8_C(-128), INT8_C(-119), INT8_C(-128),
                           INT8_C(  69), INT8_C( -42), INT8_C(  36), INT8_C(  24),
                           INT8_C(  27), INT8_C( -37), INT8_C( -84), INT8_C(  28),
                           INT8_C( 116), INT8_C( 122), INT8_C( 100), INT8_C(  84),
                           INT8_C( -23), INT8_C(  62), INT8_C(-128), INT8_C(  50)) },
    { simde_mm512_set_epi8(INT8_C(  90), INT8_C(-125), INT8_C(  -5), INT8_C( -69),
                           INT8_C( 103), INT8_C( -40), INT8_C(  35), INT8_C( -38),
                           INT8_C( 107), INT8_C(-117), INT8_C( -80), INT8_C( 123),
                           INT8_C(  57), INT8_C( -70), INT8_C( -34), INT8_C(  38),
                           INT8_C( 114), INT8_C(-126), INT8_C(  20), INT8_C( -93),
                           INT8_C(  17), INT8_C(-128), INT8_C(   2), INT8_C(  15),
                           INT8_C(-122), INT8_C( -10), INT8_C(  -2), INT8_C(  84),
                           INT8_C(  93), INT8_C(  89), INT8_C(  57), INT8_C( -50),
                           INT8_C(   4), INT8_C( -63), INT8_C( 118), INT8_C(  19),
                           INT8_C( -68), INT8_C( -29), INT8_C( -16), INT8_C( -30),
                           INT8_C( -76), INT8_C(-110), INT8_C( 121), INT8_C(  87),
                           INT8_C(-117), INT8_C(-113), INT8_C( -94), INT8_C(  61),
                           INT8_C( -29), INT8_C(  43), INT8_C( -69), INT8_C( 123),
                           INT8_C(  79), INT8_C(-101), INT8_C(  40), INT8_C(  64),
                           INT8_C(  34), INT8_C(-102), INT8_C(  77), INT8_C( 114),
                           INT8_C( -49), INT8_C( -31), INT8_C( 103), INT8_C(  81)),
      simde_mm512_set_epi8(INT8_C(  34), INT8_C(-125), INT8_C( -96), INT8_C(-111),
                           INT8_C(  23), INT8_C(  58), INT8_C(  -5), INT8_C( -22),
                           INT8_C( -80), INT8_C( -90), INT8_C( -33), INT8_C( -65),
                           INT8_C( -34), INT8_C( 100), INT8_C( -10), INT8_C( -57),
                           INT8_C(  37), INT8_C(  -9), INT8_C( -29), INT8_C(-114),
                           INT8_C(-102), INT8_C(  53), INT8_C( 107), INT8_C( 124),
                           INT8_C( -12), INT8_C( -57), INT8_C( -57), INT8_C( -37),
                           INT8_C(  50), INT8_C(  22), INT8_C( -71), INT8_C(  -2),
                           INT8_C( -31), INT8_C(  60), INT8_C(  62), INT8_C(  19),
                           INT8_C( 117), INT8_C(   1), INT8_C( -26), INT8_C(-100),
                           INT8_C(  29), INT8_C(  -6), INT8_C(   7), INT8_C(-100),
                           INT8_C(-120), INT8_C( -33), INT8_C(  17), INT8_C(-103),
                           INT8_C(  10), INT8_C( -45), INT8_C( -76), INT8_C(  10),
                           INT8_C( -10), INT8_C(  15), INT8_C(  36), INT8_C(   2),
                           INT8_C(  74), INT8_C(  44), INT8_C( -16), INT8_C( 122),
                           INT8_C(  -4), INT8_C(  15), INT8_C( -27), INT8_C( -15)),
      simde_mm512_set_epi8(INT8_C( 124), INT8_C(-128), INT8_C(-101), INT8_C(-128),
                           INT8_C( 126), INT8_C(  18), INT8_C(  30), INT8_C( -60),
                           INT8_C(  27), INT8_C(-128), INT8_C(-113), INT8_C(  58),
                           INT8_C(  23), INT8_C(  30), INT8_C( -44), INT8_C( -19),
                           INT8_C( 127), INT8_C(-128), INT8_C(  -9), INT8_C(-128),
                           INT8_C( -85), INT8_C( -75), INT8_C( 109), INT8_C( 127),
                           INT8_C(-128), INT8_C( -67), INT8_C( -59), INT8_C(  47),
                           INT8_C( 127), INT8_C( 111), INT8_C( -14), INT8_C( -52),
                           INT8_C( -27), INT8_C(  -3), INT8_C( 127), INT8_C(  38),
                           INT8_C(  49), INT8_C( -28), INT8_C( -42), INT8_C(-128),
                           INT8_C( -47), INT8_C(-116), INT8_C( 127), INT8_C( -13),
                           INT8_C(-128), INT8_C(-128), INT8_C( -77), INT8_C( -42),
                           INT8_C( -19), INT8_C(  -2), INT8_C(-128), INT8_C( 127),
                           INT8_C(  69), INT8_C( -86), INT8_C(  76), INT8_C(  66),
                           INT8_C( 108), INT8_C( -58), INT8_C(  61), INT8_C( 127),
                           INT8_C( -53), INT8_C( -16), INT8_C(  76), INT8_C(  66)) },
    { simde_mm512_set_epi8(INT8_C( -52), INT8_C(-111), INT8_C(  67), INT8_C( -14),
                           INT8_C(  11), INT8_C( -63), INT8_C( -35), INT8_C( -86),
                           INT8_C(-114), INT8_C( -97), INT8_C( 124), INT8_C( -30),
                           INT8_C(  -1), INT8_C(  55), INT8_C(  84), INT8_C(  12),
                           INT8_C(  86), INT8_C( -43), INT8_C(  81), INT8_C( -30),
                           INT8_C( -25), INT8_C(  74), INT8_C(-105), INT8_C(  11),
                           INT8_C( -97), INT8_C(   0), INT8_C(  98), INT8_C( 106),
                           INT8_C( -83), INT8_C( -89), INT8_C(  16), INT8_C( -42),
                           INT8_C(  81), INT8_C(  35), INT8_C(-127), INT8_C(-127),
                           INT8_C( -38), INT8_C(  51), INT8_C( -75), INT8_C(  24),
                           INT8_C(  86), INT8_C( -37), INT8_C(  97), INT8_C( -82),
                           INT8_C( 109), INT8_C(  21), INT8_C( 127), INT8_C(  16),
                           INT8_C( 101), INT8_C( -69), INT8_C(  95), INT8_C(-121),
                           INT8_C( -66), INT8_C(  39), INT8_C( 104), INT8_C(-109),
                           INT8_C(  -1), INT8_C(  35), INT8_C(  68), INT8_C(  93),
                           INT8_C( -25), INT8_C( 120), INT8_C( -19), INT8_C(  84)),
      simde_mm512_set_epi8(INT8_C(-111), INT8_C(-108), INT8_C( 102), INT8_C( -40),
                           INT8_C(-124), INT8_C( -61), INT8_C(  80), INT8_C( 102),
                           INT8_C( -35), INT8_C(   3), INT8_C( -76), INT8_C(  98),
                           INT8_C(   9), INT8_C( -39), INT8_C( -24), INT8_C( -92),
                           INT8_C( -73), INT8_C( -19), INT8_C(-103), INT8_C( -41),
                           INT8_C( -32), INT8_C(  -8), INT8_C( 126), INT8_C(  75),
                           INT8_C( -64), INT8_C( -26), INT8_C( -15), INT8_C( -35),
                           INT8_C( -20), INT8_C(  -6), INT8_C(  86), INT8_C( -56),
                           INT8_C( -56), INT8_C(  67), INT8_C(  59), INT8_C( -73),
                           INT8_C(  35), INT8_C( -67), INT8_C(  92), INT8_C(  34),
                           INT8_C(  16), INT8_C( -12), INT8_C(  44), INT8_C( -59),
                           INT8_C( -82), INT8_C(-102), INT8_C(  93), INT8_C( -43),
                           INT8_C(  79), INT8_C( -19), INT8_C( -45), INT8_C( -87),
                           INT8_C( -50), INT8_C( -23), INT8_C( -17), INT8_C( 110),
                           INT8_C( 102), INT8_C( -59), INT8_C(-117), INT8_C(  84),
                           INT8_C( -75), INT8_C(  87), INT8_C(  69), INT8_C(  -6)),
      simde_mm512_set_epi8(INT8_C(-128), INT8_C(-128), INT8_C( 127), INT8_C( -54),
                           INT8_C(-113), INT8_C(-124), INT8_C(  45), INT8_C(  16),
                           INT8_C(-128), INT8_C( -94), INT8_C(  48), INT8_C(  68),
                           INT8_C(   8), INT8_C(  16), INT8_C(  60), INT8_C( -80),
                           INT8_C(  13), INT8_C( -62), INT8_C( -22), INT8_C( -71),
                           INT8_C( -57), INT8_C(  66), INT8_C(  21), INT8_C(  86),
                           INT8_C(-128), INT8_C( -26), INT8_C(  83), INT8_C(  71),
                           INT8_C(-103), INT8_C( -95), INT8_C( 102), INT8_C( -98),
                           INT8_C(  25), INT8_C( 102), INT8_C( -68), INT8_C(-128),
                           INT8_C(  -3), INT8_C( -16), INT8_C(  17), INT8_C(  58),
                           INT8_C( 102), INT8_C( -49), INT8_C( 127), INT8_C(-128),
                           INT8_C(  27), INT8_C( -81), INT8_C( 127), INT8_C( -27),
                           INT8_C( 127), INT8_C( -88), INT8_C(  50), INT8_C(-128),
                           INT8_C(-116), INT8_C(  16), INT8_C(  87), INT8_C(   1),
                           INT8_C( 101), INT8_C( -24), INT8_C( -49), INT8_C( 127),
                           INT8_C(-100), INT8_C( 127), INT8_C(  50), INT8_C(  78)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_adds_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_adds_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  92), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C( -73), INT8_C(  22), INT8_C( -66), INT8_C( -29),
                           INT8_C(  55), INT8_C(  78), INT8_C( -45), INT8_C(-119),
                           INT8_C(  30), INT8_C( -29), INT8_C( -23), INT8_C(  89),
                           INT8_C(  15), INT8_C( 119), INT8_C( -88), INT8_C( 109),
                           INT8_C( -16), INT8_C( -10), INT8_C(   0), INT8_C( -18),
                           INT8_C(   1), INT8_C( 116), INT8_C(  62), INT8_C( -73),
                           INT8_C(-122), INT8_C(   0), INT8_C( 111), INT8_C(  95),
                           INT8_C( -20), INT8_C(   3), INT8_C( 122), INT8_C(-121),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(-127),
                           INT8_C(  82), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  73), INT8_C( 108), INT8_C( -18), INT8_C(  15),
                           INT8_C(  81), INT8_C( -27), INT8_C( 102), INT8_C( 118),
                           INT8_C(  39), INT8_C( -77), INT8_C(  45), INT8_C(  81),
                           INT8_C( -17), INT8_C( -28), INT8_C(  67), INT8_C(-118),
                           INT8_C(  79), INT8_C(-113), INT8_C(-122), INT8_C( 124)),
      UINT64_C(10224647434006242820),
      simde_mm512_set_epi8(INT8_C(  68), INT8_C(-108), INT8_C(-121), INT8_C(-115),
                           INT8_C( -59), INT8_C( -78), INT8_C(-111), INT8_C(  56),
                           INT8_C(   9), INT8_C(-121), INT8_C( 120), INT8_C( -36),
                           INT8_C(  36), INT8_C(-103), INT8_C(-104), INT8_C(  25),
                           INT8_C(-111), INT8_C( -63), INT8_C( -35), INT8_C(-120),
                           INT8_C(  28), INT8_C( -44), INT8_C( -26), INT8_C( -86),
                           INT8_C( -13), INT8_C(  53), INT8_C( -88), INT8_C(-107),
                           INT8_C(  68), INT8_C(  42), INT8_C(-118), INT8_C( 111),
                           INT8_C(  54), INT8_C( -58), INT8_C( -13), INT8_C(  27),
                           INT8_C(  23), INT8_C(  41), INT8_C(-119), INT8_C(  44),
                           INT8_C(   7), INT8_C(-120), INT8_C(  32), INT8_C( -43),
                           INT8_C( 114), INT8_C( -72), INT8_C(  73), INT8_C( -96),
                           INT8_C(  96), INT8_C( 110), INT8_C( -81), INT8_C( -76),
                           INT8_C( 103), INT8_C(-100), INT8_C( -22), INT8_C(  18),
                           INT8_C( 115), INT8_C(  54), INT8_C( -40), INT8_C( 125),
                           INT8_C( 110), INT8_C(  31), INT8_C(  51), INT8_C(-104)),
      simde_mm512_set_epi8(INT8_C( -14), INT8_C(  85), INT8_C( -80), INT8_C(  80),
                           INT8_C(  48), INT8_C(  93), INT8_C(  79), INT8_C( 127),
                           INT8_C(  16), INT8_C(  41), INT8_C(  54), INT8_C(-116),
                           INT8_C(  17), INT8_C(  42), INT8_C( -86), INT8_C(  38),
                           INT8_C(-118), INT8_C( -56), INT8_C(  60), INT8_C(  19),
                           INT8_C(-100), INT8_C(-107), INT8_C( 105), INT8_C( -76),
                           INT8_C(  10), INT8_C(  -9), INT8_C( -12), INT8_C( -56),
                           INT8_C( -71), INT8_C(  96), INT8_C(   6), INT8_C(  24),
                           INT8_C(  69), INT8_C(  73), INT8_C( -27), INT8_C(   3),
                           INT8_C( -95), INT8_C(  50), INT8_C( -67), INT8_C( -39),
                           INT8_C(  97), INT8_C(  62), INT8_C( 101), INT8_C(  56),
                           INT8_C( -79), INT8_C(  83), INT8_C( -99), INT8_C( -56),
                           INT8_C( -17), INT8_C( -56), INT8_C(  -8), INT8_C( -16),
                           INT8_C(  84), INT8_C( -95), INT8_C( -73), INT8_C(  54),
                           INT8_C( 125), INT8_C(  85), INT8_C(  78), INT8_C( -65),
                           INT8_C(   4), INT8_C( 113), INT8_C( -16), INT8_C( -53)),
      simde_mm512_set_epi8(INT8_C(  54), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C( -11), INT8_C(  15), INT8_C( -66), INT8_C( 127),
                           INT8_C(  25), INT8_C( -80), INT8_C( 127), INT8_C(-119),
                           INT8_C(  30), INT8_C( -61), INT8_C( -23), INT8_C(  63),
                           INT8_C(  15), INT8_C( 119), INT8_C(  25), INT8_C(-101),
                           INT8_C( -72), INT8_C(-128), INT8_C(  79), INT8_C( -18),
                           INT8_C(  -3), INT8_C( 116), INT8_C(-100), INT8_C( -73),
                           INT8_C(  -3), INT8_C(   0), INT8_C(-112), INT8_C( 127),
                           INT8_C( -20), INT8_C(   3), INT8_C( -40), INT8_C(  30),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(   5),
                           INT8_C( 104), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  35), INT8_C(  11), INT8_C( -18), INT8_C(-128),
                           INT8_C(  81), INT8_C( -27), INT8_C( -89), INT8_C( 118),
                           INT8_C(  39), INT8_C(-128), INT8_C( -95), INT8_C(  81),
                           INT8_C( -17), INT8_C( -28), INT8_C(  67), INT8_C(-118),
                           INT8_C(  79), INT8_C( 127), INT8_C(-122), INT8_C( 124)) },
    { simde_mm512_set_epi8(INT8_C(-123), INT8_C(-100), INT8_C( -39), INT8_C( -44),
                           INT8_C(  22), INT8_C( 112), INT8_C(  16), INT8_C(  15),
                           INT8_C(-104), INT8_C(-102), INT8_C( 102), INT8_C( -95),
                           INT8_C(  69), INT8_C(  13), INT8_C( -21), INT8_C(  45),
                           INT8_C(  62), INT8_C(-120), INT8_C(-111), INT8_C(  32),
                           INT8_C(-107), INT8_C( -30), INT8_C(  99), INT8_C( -64),
                           INT8_C(   8), INT8_C( -42), INT8_C(  81), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -71), INT8_C(  46),
                           INT8_C( -21), INT8_C( -73), INT8_C(  21), INT8_C(  83),
                           INT8_C(-108), INT8_C( -97), INT8_C( -69), INT8_C(  73),
                           INT8_C(  57), INT8_C( -37), INT8_C(  21), INT8_C(  82),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C( 115), INT8_C(  31), INT8_C( -79), INT8_C(  28),
                           INT8_C(-106), INT8_C( -18), INT8_C(  65), INT8_C(-104),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  -2)),
      UINT64_C( 4597426592773770833),
      simde_mm512_set_epi8(INT8_C(  74), INT8_C(  72), INT8_C(  -4), INT8_C(  28),
                           INT8_C(-115), INT8_C(  93), INT8_C( 102), INT8_C(  44),
                           INT8_C(-103), INT8_C( -29), INT8_C( -50), INT8_C(  48),
                           INT8_C( -96), INT8_C( -50), INT8_C(  46), INT8_C( -65),
                           INT8_C(   4), INT8_C(  43), INT8_C( -75), INT8_C(  97),
                           INT8_C( -26), INT8_C(-103), INT8_C(  71), INT8_C(-107),
                           INT8_C(  91), INT8_C(  45), INT8_C( -11), INT8_C(  47),
                           INT8_C(  29), INT8_C(  25), INT8_C(  26), INT8_C(  -9),
                           INT8_C(  10), INT8_C(  36), INT8_C( -79), INT8_C( -53),
                           INT8_C(  41), INT8_C(   1), INT8_C( -23), INT8_C( -63),
                           INT8_C(-127), INT8_C(  68), INT8_C(  48), INT8_C(  36),
                           INT8_C(  89), INT8_C(-112), INT8_C( -31), INT8_C( 120),
                           INT8_C(  35), INT8_C(  62), INT8_C( -21), INT8_C(-114),
                           INT8_C(-104), INT8_C(  57), INT8_C(  42), INT8_C(-111),
                           INT8_C(  94), INT8_C( -63), INT8_C(  -9), INT8_C(  64),
                           INT8_C( -65), INT8_C(  -2), INT8_C( 110), INT8_C(  -8)),
      simde_mm512_set_epi8(INT8_C(  44), INT8_C( -92), INT8_C( -31), INT8_C(  26),
                           INT8_C( -99), INT8_C( -53), INT8_C( 117), INT8_C(  18),
                           INT8_C( -63), INT8_C(  45), INT8_C(  12), INT8_C(  24),
                           INT8_C(-108), INT8_C(  18), INT8_C( -60), INT8_C(  28),
                           INT8_C(  50), INT8_C( -11), INT8_C( -68), INT8_C( -31),
                           INT8_C( 105), INT8_C(-106), INT8_C(  98), INT8_C(  51),
                           INT8_C(  58), INT8_C( 103), INT8_C( 111), INT8_C(-127),
                           INT8_C(  68), INT8_C( -56), INT8_C( 124), INT8_C(-119),
                           INT8_C(  74), INT8_C( -62), INT8_C(-116), INT8_C(  37),
                           INT8_C( -12), INT8_C( 114), INT8_C(   0), INT8_C(  61),
                           INT8_C( 103), INT8_C(  -4), INT8_C(-105), INT8_C( -68),
                           INT8_C(  39), INT8_C(-100), INT8_C( -93), INT8_C(  11),
                           INT8_C( -80), INT8_C( -19), INT8_C( -22), INT8_C( -39),
                           INT8_C( 127), INT8_C( -38), INT8_C(-125), INT8_C(-111),
                           INT8_C(  84), INT8_C( -96), INT8_C(  87), INT8_C( -22),
                           INT8_C(  -5), INT8_C(  -3), INT8_C(-127), INT8_C(  41)),
      simde_mm512_set_epi8(INT8_C(-123), INT8_C(-100), INT8_C( -35), INT8_C(  54),
                           INT8_C(-128), INT8_C(  40), INT8_C( 127), INT8_C(  62),
                           INT8_C(-128), INT8_C(  16), INT8_C( 102), INT8_C( -95),
                           INT8_C(-128), INT8_C( -32), INT8_C( -21), INT8_C( -37),
                           INT8_C(  62), INT8_C(  32), INT8_C(-111), INT8_C(  66),
                           INT8_C(-107), INT8_C(-128), INT8_C( 127), INT8_C( -56),
                           INT8_C(   8), INT8_C( -42), INT8_C( 100), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  84), INT8_C(  -7), INT8_C(-128), INT8_C( -16),
                           INT8_C(  29), INT8_C( 115), INT8_C( -23), INT8_C(  -2),
                           INT8_C(-108), INT8_C( -97), INT8_C( -57), INT8_C( -32),
                           INT8_C(  57), INT8_C(-128), INT8_C(-124), INT8_C( 127),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C(  23), INT8_C(  19), INT8_C( -83), INT8_C(  28),
                           INT8_C(-106), INT8_C(-128), INT8_C(  65), INT8_C(  42),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  33)) },
    { simde_mm512_set_epi8(INT8_C( -30), INT8_C( -37), INT8_C(  51), INT8_C( -36),
                           INT8_C(   8), INT8_C(  52), INT8_C(  97), INT8_C( 123),
                           INT8_C( -49), INT8_C(-124), INT8_C(  95), INT8_C( -83),
                           INT8_C(  70), INT8_C( -50), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(  11),
                           INT8_C( -14), INT8_C( 126), INT8_C(  81), INT8_C(  45),
                           INT8_C( -23), INT8_C( 120), INT8_C( -83), INT8_C( -16),
                           INT8_C(   7), INT8_C(  51), INT8_C( -57), INT8_C( -50),
                           INT8_C( -21), INT8_C(  98), INT8_C(  88), INT8_C(   0),
                           INT8_C( -66), INT8_C(   3), INT8_C( 124), INT8_C(-113),
                           INT8_C(  50), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C( -44), INT8_C( -13), INT8_C( -94), INT8_C(  17),
                           INT8_C(  -2), INT8_C(  79), INT8_C(-116), INT8_C(  43),
                           INT8_C( -77), INT8_C(-125), INT8_C( -23), INT8_C(-120),
                           INT8_C(  96), INT8_C( -64), INT8_C( -23), INT8_C( -46),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90)),
      UINT64_C(12627002542648829104),
      simde_mm512_set_epi8(INT8_C(  56), INT8_C( -45), INT8_C(-108), INT8_C( -19),
                           INT8_C(-124), INT8_C( -27), INT8_C(  22), INT8_C( 126),
                           INT8_C(-106), INT8_C( -68), INT8_C( -60), INT8_C(   8),
                           INT8_C(  60), INT8_C(  93), INT8_C( -33), INT8_C( -27),
                           INT8_C(  -7), INT8_C(  27), INT8_C(-122), INT8_C( -38),
                           INT8_C(  23), INT8_C(   6), INT8_C(  45), INT8_C( -21),
                           INT8_C( -23), INT8_C(-101), INT8_C( 116), INT8_C( 127),
                           INT8_C(  96), INT8_C(  40), INT8_C( -97), INT8_C(  40),
                           INT8_C(  86), INT8_C( -44), INT8_C(  70), INT8_C( -71),
                           INT8_C(  62), INT8_C( -21), INT8_C(  66), INT8_C(  68),
                           INT8_C( -87), INT8_C( -61), INT8_C(  48), INT8_C( -70),
                           INT8_C(  18), INT8_C( -78), INT8_C( -98), INT8_C( 117),
                           INT8_C(  74), INT8_C(  32), INT8_C(  93), INT8_C( 125),
                           INT8_C( -47), INT8_C( -60), INT8_C( -86), INT8_C( 117),
                           INT8_C( 122), INT8_C( -54), INT8_C(  50), INT8_C( 123),
                           INT8_C( -31), INT8_C( -74), INT8_C( -64), INT8_C(  54)),
      simde_mm512_set_epi8(INT8_C( 115), INT8_C(  51), INT8_C( -91), INT8_C(  56),
                           INT8_C(  64), INT8_C( -39), INT8_C(-119), INT8_C( -28),
                           INT8_C( -54), INT8_C(  28), INT8_C(  54), INT8_C(  -8),
                           INT8_C( -54), INT8_C(-128), INT8_C( -28), INT8_C( -71),
                           INT8_C( 107), INT8_C( -66), INT8_C(-114), INT8_C( -88),
                           INT8_C(  34), INT8_C( -83), INT8_C( -21), INT8_C( -64),
                           INT8_C( 121), INT8_C( -20), INT8_C( -89), INT8_C( -94),
                           INT8_C( 112), INT8_C( -27), INT8_C(  81), INT8_C( -54),
                           INT8_C( -64), INT8_C(-114), INT8_C(  48), INT8_C( -89),
                           INT8_C( -61), INT8_C(  26), INT8_C(  43), INT8_C(  29),
                           INT8_C(   0), INT8_C(  64), INT8_C( 123), INT8_C( -67),
                           INT8_C(  15), INT8_C( 120), INT8_C(  36), INT8_C(  40),
                           INT8_C( 106), INT8_C(-118), INT8_C(-108), INT8_C( -58),
                           INT8_C(  26), INT8_C(-111), INT8_C(  63), INT8_C( -98),
                           INT8_C( -13), INT8_C( -12), INT8_C(-124), INT8_C(  96),
                           INT8_C( -13), INT8_C( -98), INT8_C(  99), INT8_C( -13)),
      simde_mm512_set_epi8(INT8_C( 127), INT8_C( -37), INT8_C(-128), INT8_C( -36),
                           INT8_C( -60), INT8_C( -66), INT8_C( -97), INT8_C(  98),
                           INT8_C( -49), INT8_C(-124), INT8_C(  -6), INT8_C(   0),
                           INT8_C(   6), INT8_C( -35), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(-126),
                           INT8_C(  57), INT8_C( -77), INT8_C(  24), INT8_C( -85),
                           INT8_C(  98), INT8_C(-121), INT8_C(  27), INT8_C( -16),
                           INT8_C( 127), INT8_C(  51), INT8_C( -57), INT8_C( -14),
                           INT8_C( -21), INT8_C(-128), INT8_C( 118), INT8_C(   0),
                           INT8_C(   1), INT8_C(   5), INT8_C( 124), INT8_C(-113),
                           INT8_C( -87), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C(  33), INT8_C( -13), INT8_C( -94), INT8_C( 127),
                           INT8_C( 127), INT8_C(  79), INT8_C( -15), INT8_C(  43),
                           INT8_C( -77), INT8_C(-128), INT8_C( -23), INT8_C(-120),
                           INT8_C( 109), INT8_C( -64), INT8_C( -74), INT8_C( 127),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90)) },
    { simde_mm512_set_epi8(INT8_C(  72), INT8_C(  45), INT8_C( 120), INT8_C(  -5),
                           INT8_C(-109), INT8_C(  62), INT8_C(  17), INT8_C(  31),
                           INT8_C( -30), INT8_C( -58), INT8_C(  56), INT8_C(  21),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(  32), INT8_C(  64),
                           INT8_C(-128), INT8_C( 102), INT8_C( -21), INT8_C(  28),
                           INT8_C( 105), INT8_C(  52), INT8_C(  85), INT8_C(-104),
                           INT8_C(  57), INT8_C( -31), INT8_C( -38), INT8_C(-124),
                           INT8_C(-107), INT8_C(  -2), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  18), INT8_C(  70),
                           INT8_C(  89), INT8_C( 125), INT8_C( -42), INT8_C(-125),
                           INT8_C( 121), INT8_C( -11), INT8_C( -69), INT8_C( -59),
                           INT8_C( -53), INT8_C(  34), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  69), INT8_C(  -8),
                           INT8_C( -15), INT8_C( -51), INT8_C(   1), INT8_C(  90)),
      UINT64_C(14515151237088493607),
      simde_mm512_set_epi8(INT8_C( -26), INT8_C(  -9), INT8_C(  66), INT8_C(   1),
                           INT8_C( -13), INT8_C(  60), INT8_C(-119), INT8_C( -83),
                           INT8_C(-122), INT8_C( -64), INT8_C( -83), INT8_C( -74),
                           INT8_C( 119), INT8_C(  -8), INT8_C(  12), INT8_C( 113),
                           INT8_C( -12), INT8_C( -84), INT8_C(   6), INT8_C(  69),
                           INT8_C(   2), INT8_C( -75), INT8_C( -34), INT8_C(-126),
                           INT8_C(   3), INT8_C(-128), INT8_C(  -9), INT8_C(  24),
                           INT8_C(  11), INT8_C( -94), INT8_C( -32), INT8_C( 110),
                           INT8_C(  33), INT8_C( -24), INT8_C( 125), INT8_C(  35),
                           INT8_C(-103), INT8_C( -48), INT8_C( -22), INT8_C(  38),
                           INT8_C( -81), INT8_C(   9), INT8_C( -11), INT8_C(-124),
                           INT8_C(  71), INT8_C(  31), INT8_C( -42), INT8_C(  93),
                           INT8_C(  67), INT8_C(  45), INT8_C(  51), INT8_C( -92),
                           INT8_C( 126), INT8_C( 108), INT8_C(-123), INT8_C( -71),
                           INT8_C( 113), INT8_C(  32), INT8_C(  71), INT8_C(  55),
                           INT8_C( -26), INT8_C(  82), INT8_C( -81), INT8_C( -20)),
      simde_mm512_set_epi8(INT8_C(-125), INT8_C( 121), INT8_C(-128), INT8_C( 103),
                           INT8_C(   0), INT8_C( 101), INT8_C( -41), INT8_C(  89),
                           INT8_C( -83), INT8_C( -65), INT8_C(   9), INT8_C(  -7),
                           INT8_C( -63), INT8_C(  13), INT8_C( 105), INT8_C(  92),
                           INT8_C( -18), INT8_C( -21), INT8_C(-102), INT8_C(-114),
                           INT8_C(  74), INT8_C( 121), INT8_C( -45), INT8_C(  52),
                           INT8_C( -63), INT8_C( -93), INT8_C(  98), INT8_C( 106),
                           INT8_C(-109), INT8_C( -47), INT8_C(  37), INT8_C(  70),
                           INT8_C( 100), INT8_C( 121), INT8_C(  18), INT8_C(  28),
                           INT8_C(-117), INT8_C( 107), INT8_C(   3), INT8_C( -62),
                           INT8_C(  42), INT8_C(  72), INT8_C(  91), INT8_C(  86),
                           INT8_C( -72), INT8_C(   9), INT8_C( -80), INT8_C( 118),
                           INT8_C( 122), INT8_C(-108), INT8_C( -70), INT8_C( -63),
                           INT8_C(  56), INT8_C(  71), INT8_C( -14), INT8_C(  49),
                           INT8_C( -73), INT8_C(  53), INT8_C( -29), INT8_C(   3),
                           INT8_C( -73), INT8_C(  43), INT8_C( -22), INT8_C(  85)),
      simde_mm512_set_epi8(INT8_C(-128), INT8_C( 112), INT8_C( 120), INT8_C(  -5),
                           INT8_C( -13), INT8_C(  62), INT8_C(  17), INT8_C(   6),
                           INT8_C( -30), INT8_C(-128), INT8_C( -74), INT8_C( -81),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C( -96), INT8_C(  64),
                           INT8_C(  76), INT8_C(  46), INT8_C( -21), INT8_C( -74),
                           INT8_C( 105), INT8_C(  52), INT8_C(  89), INT8_C(-104),
                           INT8_C(  57), INT8_C(-128), INT8_C( -38), INT8_C( 127),
                           INT8_C(-107), INT8_C(  97), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C( -19), INT8_C( -24),
                           INT8_C( -39), INT8_C( 125), INT8_C(  80), INT8_C( -38),
                           INT8_C(  -1), INT8_C( -11), INT8_C(-122), INT8_C( 127),
                           INT8_C( -53), INT8_C( -63), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  42), INT8_C(  -8),
                           INT8_C( -15), INT8_C( 125), INT8_C(-103), INT8_C(  65)) },
    { simde_mm512_set_epi8(INT8_C( -47), INT8_C(  84), INT8_C(-126), INT8_C( -64),
                           INT8_C(  14), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  67), INT8_C( 124), INT8_C(  58), INT8_C( -94),
                           INT8_C(  30), INT8_C( -33), INT8_C(  70), INT8_C( -24),
                           INT8_C(  38), INT8_C( -97), INT8_C( -56), INT8_C( -60),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(  45),
                           INT8_C( -11), INT8_C(  55), INT8_C( -82), INT8_C(  12),
                           INT8_C( 106), INT8_C(  22), INT8_C(-124), INT8_C(  -4),
                           INT8_C(   2), INT8_C( -81), INT8_C(  14), INT8_C(  90),
                           INT8_C(-100), INT8_C(-122), INT8_C( -35), INT8_C(  81),
                           INT8_C( -14), INT8_C( -42), INT8_C( 125), INT8_C(-125),
                           INT8_C( -57), INT8_C(  90), INT8_C(  -9), INT8_C(  63),
                           INT8_C(  53), INT8_C(  77), INT8_C(  63), INT8_C( -84),
                           INT8_C(  27), INT8_C(  22), INT8_C(   3), INT8_C( -37),
                           INT8_C(  65), INT8_C( 118), INT8_C(-126), INT8_C(  97),
                           INT8_C( 109), INT8_C(   7), INT8_C(-114), INT8_C( -75)),
      UINT64_C( 8707623543556880126),
      simde_mm512_set_epi8(INT8_C(  84), INT8_C( -71), INT8_C(   8), INT8_C(  12),
                           INT8_C( -11), INT8_C( -76), INT8_C(  62), INT8_C(  93),
                           INT8_C( -75), INT8_C( -77), INT8_C( -84), INT8_C(-108),
                           INT8_C( -35), INT8_C(  14), INT8_C( -60), INT8_C(  18),
                           INT8_C(  23), INT8_C( -60), INT8_C( -63), INT8_C(-114),
                           INT8_C( -55), INT8_C(  75), INT8_C( -99), INT8_C( -55),
                           INT8_C(  58), INT8_C(  76), INT8_C(-102), INT8_C(-118),
                           INT8_C( -30), INT8_C(  39), INT8_C( 119), INT8_C(  85),
                           INT8_C(  -8), INT8_C( -72), INT8_C( -60), INT8_C( -94),
                           INT8_C(-112), INT8_C( 119), INT8_C( 124), INT8_C(  76),
                           INT8_C( -42), INT8_C(-124), INT8_C(  54), INT8_C(  74),
                           INT8_C( -92), INT8_C(  99), INT8_C(  79), INT8_C(  -3),
                           INT8_C(  61), INT8_C( -89), INT8_C(  84), INT8_C( -94),
                           INT8_C(  31), INT8_C(-116), INT8_C( -67), INT8_C(-102),
                           INT8_C( -72), INT8_C( -91), INT8_C(-105), INT8_C(-108),
                           INT8_C( -44), INT8_C(  74), INT8_C( -28), INT8_C( 124)),
      simde_mm512_set_epi8(INT8_C(   1), INT8_C(  75), INT8_C(  21), INT8_C( -36),
                           INT8_C(-126), INT8_C( 122), INT8_C(  71), INT8_C(  76),
                           INT8_C(  28), INT8_C( -56), INT8_C(  32), INT8_C( 101),
                           INT8_C(-107), INT8_C(-111), INT8_C( -88), INT8_C( -19),
                           INT8_C( -77), INT8_C(  19), INT8_C( -21), INT8_C(-111),
                           INT8_C( -68), INT8_C(  82), INT8_C(-118), INT8_C( -76),
                           INT8_C(  47), INT8_C( 127), INT8_C(  62), INT8_C( -16),
                           INT8_C(  10), INT8_C( -14), INT8_C(-100), INT8_C(  86),
                           INT8_C(  29), INT8_C( 107), INT8_C(  56), INT8_C(  21),
                           INT8_C(  24), INT8_C(  68), INT8_C( -96), INT8_C(  64),
                           INT8_C(  48), INT8_C(  13), INT8_C( -83), INT8_C(   4),
                           INT8_C(  -3), INT8_C( -64), INT8_C(  17), INT8_C(-115),
                           INT8_C(  21), INT8_C( 108), INT8_C( 125), INT8_C( -60),
                           INT8_C( -72), INT8_C(  74), INT8_C(  -5), INT8_C( -58),
                           INT8_C( -41), INT8_C(  22), INT8_C(-115), INT8_C( 102),
                           INT8_C(  59), INT8_C( -80), INT8_C( -15), INT8_C( -63)),
      simde_mm512_set_epi8(INT8_C( -47), INT8_C(   4), INT8_C(  29), INT8_C( -24),
                           INT8_C(-128), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C( -47), INT8_C(-128), INT8_C(  58), INT8_C(  -7),
                           INT8_C(  30), INT8_C( -97), INT8_C(-128), INT8_C(  -1),
                           INT8_C( -54), INT8_C( -97), INT8_C( -84), INT8_C(-128),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(-128),
                           INT8_C( -11), INT8_C( 127), INT8_C( -40), INT8_C(-128),
                           INT8_C( -20), INT8_C(  22), INT8_C(  19), INT8_C(  -4),
                           INT8_C(   2), INT8_C(  35), INT8_C(  14), INT8_C( -73),
                           INT8_C(-100), INT8_C( 127), INT8_C(  28), INT8_C( 127),
                           INT8_C(   6), INT8_C( -42), INT8_C( 125), INT8_C(-125),
                           INT8_C( -95), INT8_C(  90), INT8_C(  -9), INT8_C(-118),
                           INT8_C(  53), INT8_C(  77), INT8_C( 127), INT8_C(-128),
                           INT8_C(  27), INT8_C( -42), INT8_C( -72), INT8_C( -37),
                           INT8_C(-113), INT8_C( -69), INT8_C(-128), INT8_C(  -6),
                           INT8_C(  15), INT8_C(  -6), INT8_C( -43), INT8_C( -75)) },
    { simde_mm512_set_epi8(INT8_C( -64), INT8_C( -53), INT8_C( -42), INT8_C( 126),
                           INT8_C(  67), INT8_C(  50), INT8_C( -18), INT8_C(  76),
                           INT8_C( -19), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C( -74), INT8_C(  44), INT8_C( 117), INT8_C( 103),
                           INT8_C(  81), INT8_C( 122), INT8_C(  56), INT8_C( -10),
                           INT8_C(  67), INT8_C(  79), INT8_C(  83), INT8_C( -38),
                           INT8_C( -13), INT8_C(  43), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C( 126), INT8_C(  38), INT8_C( -62),
                           INT8_C( -24), INT8_C( 117), INT8_C( -38), INT8_C( -93),
                           INT8_C( -58), INT8_C(-124), INT8_C( -75), INT8_C(  10),
                           INT8_C(  18), INT8_C( -74), INT8_C(  14), INT8_C(  36),
                           INT8_C(  -7), INT8_C( 113), INT8_C(  40), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  85),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C( -21),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  72), INT8_C(  93), INT8_C( 108), INT8_C( 125)),
      UINT64_C(12576710173448868104),
      simde_mm512_set_epi8(INT8_C(  90), INT8_C( -38), INT8_C( -98), INT8_C( -70),
                           INT8_C(-108), INT8_C(  20), INT8_C(  43), INT8_C(-128),
                           INT8_C(  77), INT8_C( 108), INT8_C(  53), INT8_C(  82),
                           INT8_C( -50), INT8_C(  52), INT8_C(  56), INT8_C(  58),
                           INT8_C(-120), INT8_C( -43), INT8_C( 114), INT8_C(  93),
                           INT8_C( -44), INT8_C( -15), INT8_C(  38), INT8_C( -17),
                           INT8_C(-110), INT8_C(-123), INT8_C( -39), INT8_C( 114),
                           INT8_C(  51), INT8_C(-115), INT8_C( -74), INT8_C(  43),
                           INT8_C(  41), INT8_C( -36), INT8_C(  19), INT8_C(  69),
                           INT8_C(  60), INT8_C( -53), INT8_C( 112), INT8_C( 108),
                           INT8_C(   8), INT8_C(  46), INT8_C( -35), INT8_C(  26),
                           INT8_C(  11), INT8_C(  42), INT8_C(  47), INT8_C(  59),
                           INT8_C( -57), INT8_C(  94), INT8_C(-125), INT8_C(-124),
                           INT8_C(  36), INT8_C(  57), INT8_C(  68), INT8_C( -52),
                           INT8_C(  39), INT8_C(  50), INT8_C( -48), INT8_C(  94),
                           INT8_C(  53), INT8_C(  11), INT8_C(  29), INT8_C(  65)),
      simde_mm512_set_epi8(INT8_C(-107), INT8_C( 120), INT8_C( -58), INT8_C( 107),
                           INT8_C( -32), INT8_C( -32), INT8_C(  88), INT8_C( -43),
                           INT8_C(  31), INT8_C( -32), INT8_C( -64), INT8_C(  27),
                           INT8_C(  82), INT8_C( -90), INT8_C( -54), INT8_C( -84),
                           INT8_C( -30), INT8_C(  63), INT8_C(  24), INT8_C(  81),
                           INT8_C(  -8), INT8_C(   9), INT8_C( -35), INT8_C(-101),
                           INT8_C(  83), INT8_C( 107), INT8_C( -47), INT8_C( -56),
                           INT8_C(  57), INT8_C( -88), INT8_C(-115), INT8_C( -20),
                           INT8_C(  58), INT8_C(  75), INT8_C(  56), INT8_C(  93),
                           INT8_C(  49), INT8_C(  43), INT8_C( 108), INT8_C( 118),
                           INT8_C( -79), INT8_C( 112), INT8_C(  44), INT8_C(-112),
                           INT8_C( -52), INT8_C(  10), INT8_C(  28), INT8_C( -86),
                           INT8_C(  65), INT8_C(  62), INT8_C(  86), INT8_C(-107),
                           INT8_C(  24), INT8_C( -55), INT8_C(  54), INT8_C(-110),
                           INT8_C( -33), INT8_C( 110), INT8_C(-116), INT8_C( -39),
                           INT8_C(  39), INT8_C(-112), INT8_C(  64), INT8_C(  43)),
      simde_mm512_set_epi8(INT8_C( -17), INT8_C( -53), INT8_C(-128), INT8_C( 126),
                           INT8_C(-128), INT8_C( -12), INT8_C( 127), INT8_C(  76),
                           INT8_C( 108), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C(  32), INT8_C(  44), INT8_C( 117), INT8_C( -26),
                           INT8_C(  81), INT8_C(  20), INT8_C( 127), INT8_C( 127),
                           INT8_C(  67), INT8_C(  79), INT8_C(   3), INT8_C(-118),
                           INT8_C( -13), INT8_C( -16), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C(-128), INT8_C(  38), INT8_C( -62),
                           INT8_C(  99), INT8_C( 117), INT8_C(  75), INT8_C( 127),
                           INT8_C( 109), INT8_C(-124), INT8_C( 127), INT8_C( 127),
                           INT8_C(  18), INT8_C( 127), INT8_C(   9), INT8_C( -86),
                           INT8_C(  -7), INT8_C(  52), INT8_C(  75), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(-128),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C(-128),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  92), INT8_C(  93), INT8_C( 108), INT8_C( 125)) },
    { simde_mm512_set_epi8(INT8_C(-103), INT8_C(-124), INT8_C(  13), INT8_C( -80),
                           INT8_C( -32), INT8_C( 123), INT8_C( 115), INT8_C( -49),
                           INT8_C( 113), INT8_C( -51), INT8_C( 119), INT8_C( -67),
                           INT8_C( -21), INT8_C(  19), INT8_C( -12), INT8_C(  29),
                           INT8_C(  91), INT8_C( -64), INT8_C(  88), INT8_C(-105),
                           INT8_C(  24), INT8_C(  31), INT8_C(  77), INT8_C(  92),
                           INT8_C( -85), INT8_C(  48), INT8_C(-113), INT8_C(-114),
                           INT8_C(  16), INT8_C(  18), INT8_C( -44), INT8_C( -66),
                           INT8_C(  25), INT8_C(-105), INT8_C(-100), INT8_C( -91),
                           INT8_C(  26), INT8_C(-123), INT8_C( -33), INT8_C( -37),
                           INT8_C(  63), INT8_C(  13), INT8_C(-124), INT8_C(  41),
                           INT8_C(-104), INT8_C( -59), INT8_C(  -2), INT8_C( -54),
                           INT8_C(  73), INT8_C(   3), INT8_C( -18), INT8_C(  10),
                           INT8_C(  19), INT8_C(  58), INT8_C( -12), INT8_C( -75),
                           INT8_C( -88), INT8_C(  59), INT8_C( 104), INT8_C( -40),
                           INT8_C( -82), INT8_C(  42), INT8_C( -73), INT8_C( -94)),
      UINT64_C( 2633789449456316803),
      simde_mm512_set_epi8(INT8_C( 118), INT8_C(  44), INT8_C( -14), INT8_C(  84),
                           INT8_C( -69), INT8_C( -48), INT8_C(  40), INT8_C(  86),
                           INT8_C(  -1), INT8_C( 121), INT8_C( -40), INT8_C(  44),
                           INT8_C(  -1), INT8_C(  38), INT8_C( -44), INT8_C(  38),
                           INT8_C(  93), INT8_C(-107), INT8_C(  -4), INT8_C( -61),
                           INT8_C( -52), INT8_C(  22), INT8_C( -54), INT8_C(-125),
                           INT8_C( -29), INT8_C(  25), INT8_C( -77), INT8_C( -68),
                           INT8_C(   9), INT8_C( -35), INT8_C( -11), INT8_C(  53),
                           INT8_C(  28), INT8_C(  61), INT8_C( -35), INT8_C(-106),
                           INT8_C( -46), INT8_C( 121), INT8_C(-102), INT8_C( 121),
                           INT8_C( -54), INT8_C( -60), INT8_C(   7), INT8_C(   2),
                           INT8_C(-119), INT8_C( 111), INT8_C( -20), INT8_C( -58),
                           INT8_C( -98), INT8_C(  83), INT8_C(  32), INT8_C( -49),
                           INT8_C( -11), INT8_C(  48), INT8_C(  92), INT8_C(  47),
                           INT8_C( -38), INT8_C(  11), INT8_C(  26), INT8_C(  90),
                           INT8_C(  -5), INT8_C(  73), INT8_C(  45), INT8_C(  -2)),
      simde_mm512_set_epi8(INT8_C( -31), INT8_C( 126), INT8_C(-118), INT8_C( -57),
                           INT8_C(-126), INT8_C(  29), INT8_C( 101), INT8_C( -15),
                           INT8_C( -61), INT8_C( 118), INT8_C( 102), INT8_C(  12),
                           INT8_C( -59), INT8_C( -41), INT8_C( -60), INT8_C(  46),
                           INT8_C(  63), INT8_C(  78), INT8_C(  87), INT8_C(  18),
                           INT8_C(  18), INT8_C(  32), INT8_C( -26), INT8_C(  -6),
                           INT8_C( -20), INT8_C(-123), INT8_C(  99), INT8_C(  65),
                           INT8_C(  13), INT8_C(  25), INT8_C( 108), INT8_C(-121),
                           INT8_C(  42), INT8_C(   0), INT8_C( 104), INT8_C( -17),
                           INT8_C( 111), INT8_C(-110), INT8_C( -39), INT8_C( 125),
                           INT8_C( -50), INT8_C( -47), INT8_C(  30), INT8_C(  92),
                           INT8_C(  19), INT8_C(  -8), INT8_C(-120), INT8_C( 127),
                           INT8_C( -49), INT8_C(  23), INT8_C(  16), INT8_C( -64),
                           INT8_C( -79), INT8_C( 116), INT8_C(  -5), INT8_C( -50),
                           INT8_C(  32), INT8_C(  22), INT8_C( -42), INT8_C(  -3),
                           INT8_C(  30), INT8_C(  64), INT8_C(  96), INT8_C( -66)),
      simde_mm512_set_epi8(INT8_C(-103), INT8_C(-124), INT8_C(-128), INT8_C( -80),
                           INT8_C( -32), INT8_C( -19), INT8_C( 115), INT8_C( -49),
                           INT8_C( -62), INT8_C( -51), INT8_C( 119), INT8_C( -67),
                           INT8_C( -60), INT8_C(  -3), INT8_C( -12), INT8_C(  84),
                           INT8_C(  91), INT8_C( -64), INT8_C(  88), INT8_C( -43),
                           INT8_C( -34), INT8_C(  31), INT8_C(  77), INT8_C(-128),
                           INT8_C( -49), INT8_C(  48), INT8_C(-113), INT8_C(-114),
                           INT8_C(  22), INT8_C( -10), INT8_C( -44), INT8_C( -66),
                           INT8_C(  70), INT8_C(  61), INT8_C(-100), INT8_C( -91),
                           INT8_C(  26), INT8_C(  11), INT8_C( -33), INT8_C( -37),
                           INT8_C(  63), INT8_C(  13), INT8_C(-124), INT8_C(  41),
                           INT8_C(-104), INT8_C( -59), INT8_C(-128), INT8_C(  69),
                           INT8_C(-128), INT8_C( 106), INT8_C(  48), INT8_C(-113),
                           INT8_C(  19), INT8_C(  58), INT8_C( -12), INT8_C(  -3),
                           INT8_C(  -6), INT8_C(  59), INT8_C( 104), INT8_C( -40),
                           INT8_C( -82), INT8_C(  42), INT8_C( 127), INT8_C( -68)) },
    { simde_mm512_set_epi8(INT8_C( 117), INT8_C(  69), INT8_C( 121), INT8_C( -45),
                           INT8_C(  30), INT8_C( -73), INT8_C(   2), INT8_C( -40),
                           INT8_C(  95), INT8_C(  -3), INT8_C(  16), INT8_C( -78),
                           INT8_C(-128), INT8_C( -41), INT8_C( -66), INT8_C(  66),
                           INT8_C(  93), INT8_C( -32), INT8_C( -50), INT8_C(  -2),
                           INT8_C( -61), INT8_C(  29), INT8_C( -88), INT8_C(-118),
                           INT8_C( -27), INT8_C(  42), INT8_C(  78), INT8_C( -46),
                           INT8_C( -79), INT8_C(  38), INT8_C( -75), INT8_C(  14),
                           INT8_C(-118), INT8_C(-114), INT8_C(-120), INT8_C(  42),
                           INT8_C(   4), INT8_C(  79), INT8_C( -84), INT8_C(-110),
                           INT8_C(   0), INT8_C(  85), INT8_C( -20), INT8_C(  61),
                           INT8_C(  40), INT8_C( -75), INT8_C(  69), INT8_C( -99),
                           INT8_C(  73), INT8_C( -34), INT8_C( -14), INT8_C(  72),
                           INT8_C( 101), INT8_C(  96), INT8_C(-114), INT8_C(-124),
                           INT8_C( -87), INT8_C(  43), INT8_C(-118), INT8_C( 114),
                           INT8_C( -88), INT8_C(   8), INT8_C( -52), INT8_C(  75)),
      UINT64_C(14890918166471265655),
      simde_mm512_set_epi8(INT8_C( -56), INT8_C( -70), INT8_C(  66), INT8_C(-111),
                           INT8_C( -69), INT8_C(  15), INT8_C( -82), INT8_C( -12),
                           INT8_C( -89), INT8_C(  37), INT8_C(  80), INT8_C( 120),
                           INT8_C( -83), INT8_C(-120), INT8_C(  95), INT8_C(  21),
                           INT8_C(  91), INT8_C( -97), INT8_C( -72), INT8_C(  42),
                           INT8_C(  22), INT8_C( -70), INT8_C(  71), INT8_C( -78),
                           INT8_C(  -5), INT8_C(  52), INT8_C( -22), INT8_C( -34),
                           INT8_C(  16), INT8_C(  92), INT8_C(  91), INT8_C( -72),
                           INT8_C(   3), INT8_C( -31), INT8_C( -95), INT8_C( -56),
                           INT8_C( -50), INT8_C(  68), INT8_C( -24), INT8_C( -50),
                           INT8_C(  94), INT8_C(  67), INT8_C( 108), INT8_C(-118),
                           INT8_C( -65), INT8_C(  31), INT8_C(  70), INT8_C( 108),
                           INT8_C( -66), INT8_C( 107), INT8_C( -85), INT8_C(  38),
                           INT8_C(   2), INT8_C(  32), INT8_C(  56), INT8_C(  66),
                           INT8_C(  -2), INT8_C( -74), INT8_C( 112), INT8_C(  10),
                           INT8_C(  64), INT8_C( 100), INT8_C( -55), INT8_C(  83)),
      simde_mm512_set_epi8(INT8_C( -69), INT8_C( -45), INT8_C(  23), INT8_C(  70),
                           INT8_C(  22), INT8_C( 113), INT8_C(  75), INT8_C(-117),
                           INT8_C(  69), INT8_C( -74), INT8_C(  40), INT8_C( -39),
                           INT8_C( -51), INT8_C( -91), INT8_C(  25), INT8_C(  -4),
                           INT8_C( -12), INT8_C( -13), INT8_C( -77), INT8_C(  75),
                           INT8_C(-116), INT8_C( -36), INT8_C(  38), INT8_C( -52),
                           INT8_C(  13), INT8_C( -52), INT8_C(-100), INT8_C( -46),
                           INT8_C(  13), INT8_C(  83), INT8_C( -94), INT8_C( 102),
                           INT8_C( 116), INT8_C( -60), INT8_C(  44), INT8_C(  -7),
                           INT8_C( 104), INT8_C( -50), INT8_C( -30), INT8_C(  17),
                           INT8_C(  13), INT8_C(-107), INT8_C( 111), INT8_C( -13),
                           INT8_C(  17), INT8_C( -45), INT8_C( -31), INT8_C(  76),
                           INT8_C(-102), INT8_C( -71), INT8_C( 116), INT8_C(  72),
                           INT8_C( -11), INT8_C( -97), INT8_C(  93), INT8_C(  48),
                           INT8_C( -75), INT8_C( -90), INT8_C( -10), INT8_C( -78),
                           INT8_C(  -8), INT8_C( -10), INT8_C(  48), INT8_C( -11)),
      simde_mm512_set_epi8(INT8_C(-125), INT8_C(-115), INT8_C( 121), INT8_C( -45),
                           INT8_C( -47), INT8_C( 127), INT8_C(  -7), INT8_C( -40),
                           INT8_C( -20), INT8_C(  -3), INT8_C( 120), INT8_C( -78),
                           INT8_C(-128), INT8_C(-128), INT8_C( 120), INT8_C(  17),
                           INT8_C(  93), INT8_C( -32), INT8_C(-128), INT8_C(  -2),
                           INT8_C( -94), INT8_C(  29), INT8_C( 109), INT8_C(-128),
                           INT8_C( -27), INT8_C(  42), INT8_C(-122), INT8_C( -46),
                           INT8_C(  29), INT8_C( 127), INT8_C( -75), INT8_C(  30),
                           INT8_C(-118), INT8_C( -91), INT8_C(-120), INT8_C(  42),
                           INT8_C(  54), INT8_C(  79), INT8_C( -54), INT8_C( -33),
                           INT8_C( 107), INT8_C( -40), INT8_C( 127), INT8_C(  61),
                           INT8_C( -48), INT8_C( -14), INT8_C(  39), INT8_C( -99),
                           INT8_C(  73), INT8_C(  36), INT8_C( -14), INT8_C(  72),
                           INT8_C(  -9), INT8_C( -65), INT8_C(-114), INT8_C( 114),
                           INT8_C( -87), INT8_C(-128), INT8_C( 102), INT8_C( -68),
                           INT8_C( -88), INT8_C(  90), INT8_C(  -7), INT8_C(  72)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_adds_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_maskz_adds_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C(17286015531074160252),
      simde_mm512_set_epi8(INT8_C(-115), INT8_C( -27), INT8_C(  62), INT8_C( -85),
                           INT8_C(  49), INT8_C(-115), INT8_C(  38), INT8_C(   4),
                           INT8_C(  92), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C( -73), INT8_C(  22), INT8_C( -66), INT8_C( -29),
                           INT8_C(  55), INT8_C(  78), INT8_C( -45), INT8_C(-119),
                           INT8_C(  30), INT8_C( -29), INT8_C( -23), INT8_C(  89),
                           INT8_C(  15), INT8_C( 119), INT8_C( -88), INT8_C( 109),
                           INT8_C( -16), INT8_C( -10), INT8_C(   0), INT8_C( -18),
                           INT8_C(   1), INT8_C( 116), INT8_C(  62), INT8_C( -73),
                           INT8_C(-122), INT8_C(   0), INT8_C( 111), INT8_C(  95),
                           INT8_C( -20), INT8_C(   3), INT8_C( 122), INT8_C(-121),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(-127),
                           INT8_C(  82), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  73), INT8_C( 108), INT8_C( -18), INT8_C(  15),
                           INT8_C(  81), INT8_C( -27), INT8_C( 102), INT8_C( 118),
                           INT8_C(  39), INT8_C( -77), INT8_C(  45), INT8_C(  81)),
      simde_mm512_set_epi8(INT8_C(  68), INT8_C(-108), INT8_C(-121), INT8_C(-115),
                           INT8_C( -59), INT8_C( -78), INT8_C(-111), INT8_C(  56),
                           INT8_C(   9), INT8_C(-121), INT8_C( 120), INT8_C( -36),
                           INT8_C(  36), INT8_C(-103), INT8_C(-104), INT8_C(  25),
                           INT8_C(-111), INT8_C( -63), INT8_C( -35), INT8_C(-120),
                           INT8_C(  28), INT8_C( -44), INT8_C( -26), INT8_C( -86),
                           INT8_C( -13), INT8_C(  53), INT8_C( -88), INT8_C(-107),
                           INT8_C(  68), INT8_C(  42), INT8_C(-118), INT8_C( 111),
                           INT8_C(  54), INT8_C( -58), INT8_C( -13), INT8_C(  27),
                           INT8_C(  23), INT8_C(  41), INT8_C(-119), INT8_C(  44),
                           INT8_C(   7), INT8_C(-120), INT8_C(  32), INT8_C( -43),
                           INT8_C( 114), INT8_C( -72), INT8_C(  73), INT8_C( -96),
                           INT8_C(  96), INT8_C( 110), INT8_C( -81), INT8_C( -76),
                           INT8_C( 103), INT8_C(-100), INT8_C( -22), INT8_C(  18),
                           INT8_C( 115), INT8_C(  54), INT8_C( -40), INT8_C( 125),
                           INT8_C( 110), INT8_C(  31), INT8_C(  51), INT8_C(-104)),
      simde_mm512_set_epi8(INT8_C( -47), INT8_C(-128), INT8_C( -59), INT8_C(   0),
                           INT8_C( -10), INT8_C(-128), INT8_C( -73), INT8_C(  60),
                           INT8_C( 101), INT8_C(  -5), INT8_C(  42), INT8_C(   0),
                           INT8_C(   0), INT8_C( -81), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  15), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -49), INT8_C(   3),
                           INT8_C(   2), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  52), INT8_C(   0), INT8_C(-118), INT8_C(   0),
                           INT8_C(   0), INT8_C(  58), INT8_C(   0), INT8_C(   0),
                           INT8_C( -99), INT8_C(  41), INT8_C(  -8), INT8_C( 127),
                           INT8_C( -13), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 127), INT8_C( -47), INT8_C(  38), INT8_C(-128),
                           INT8_C( 127), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   8), INT8_C( -40), INT8_C(   0),
                           INT8_C(   0), INT8_C(  27), INT8_C(  62), INT8_C( 127),
                           INT8_C( 127), INT8_C( -46), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C( 9031211210081693899),
      simde_mm512_set_epi8(INT8_C(-106), INT8_C( -18), INT8_C(  65), INT8_C(-104),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  -2),
                           INT8_C( -14), INT8_C(  85), INT8_C( -80), INT8_C(  80),
                           INT8_C(  48), INT8_C(  93), INT8_C(  79), INT8_C( 127),
                           INT8_C(  16), INT8_C(  41), INT8_C(  54), INT8_C(-116),
                           INT8_C(  17), INT8_C(  42), INT8_C( -86), INT8_C(  38),
                           INT8_C(-118), INT8_C( -56), INT8_C(  60), INT8_C(  19),
                           INT8_C(-100), INT8_C(-107), INT8_C( 105), INT8_C( -76),
                           INT8_C(  10), INT8_C(  -9), INT8_C( -12), INT8_C( -56),
                           INT8_C( -71), INT8_C(  96), INT8_C(   6), INT8_C(  24),
                           INT8_C(  69), INT8_C(  73), INT8_C( -27), INT8_C(   3),
                           INT8_C( -95), INT8_C(  50), INT8_C( -67), INT8_C( -39),
                           INT8_C(  97), INT8_C(  62), INT8_C( 101), INT8_C(  56),
                           INT8_C( -79), INT8_C(  83), INT8_C( -99), INT8_C( -56),
                           INT8_C( -17), INT8_C( -56), INT8_C(  -8), INT8_C( -16),
                           INT8_C(  84), INT8_C( -95), INT8_C( -73), INT8_C(  54)),
      simde_mm512_set_epi8(INT8_C(  63), INT8_C( -51), INT8_C(  87), INT8_C(  32),
                           INT8_C( -65), INT8_C(  55), INT8_C(  14), INT8_C(  81),
                           INT8_C(-123), INT8_C(-100), INT8_C( -39), INT8_C( -44),
                           INT8_C(  22), INT8_C( 112), INT8_C(  16), INT8_C(  15),
                           INT8_C(-104), INT8_C(-102), INT8_C( 102), INT8_C( -95),
                           INT8_C(  69), INT8_C(  13), INT8_C( -21), INT8_C(  45),
                           INT8_C(  62), INT8_C(-120), INT8_C(-111), INT8_C(  32),
                           INT8_C(-107), INT8_C( -30), INT8_C(  99), INT8_C( -64),
                           INT8_C(   8), INT8_C( -42), INT8_C(  81), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -71), INT8_C(  46),
                           INT8_C( -21), INT8_C( -73), INT8_C(  21), INT8_C(  83),
                           INT8_C(-108), INT8_C( -97), INT8_C( -69), INT8_C(  73),
                           INT8_C(  57), INT8_C( -37), INT8_C(  21), INT8_C(  82),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C( 115), INT8_C(  31), INT8_C( -79), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C( -69), INT8_C( 127), INT8_C( -72),
                           INT8_C(  16), INT8_C(  93), INT8_C(   0), INT8_C(  79),
                           INT8_C(   0), INT8_C( -15), INT8_C(   0), INT8_C(  36),
                           INT8_C(   0), INT8_C( 127), INT8_C(   0), INT8_C( 127),
                           INT8_C(   0), INT8_C( -61), INT8_C(   0), INT8_C(   0),
                           INT8_C(  86), INT8_C(  55), INT8_C(-107), INT8_C(   0),
                           INT8_C( -56), INT8_C(   0), INT8_C( -51), INT8_C(  51),
                           INT8_C(-128), INT8_C(-128), INT8_C( 127), INT8_C(-128),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 122), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  66), INT8_C( -98), INT8_C(  49),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  44),
                           INT8_C( -11), INT8_C( -35), INT8_C(  32), INT8_C( 127),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-128), INT8_C(-128), INT8_C(   0), INT8_C(   0),
                           INT8_C( 127), INT8_C(   0), INT8_C(-128), INT8_C(  82)) },
    { UINT64_C( 6828010367541473016),
      simde_mm512_set_epi8(INT8_C(  84), INT8_C( -96), INT8_C(  87), INT8_C( -22),
                           INT8_C(  -5), INT8_C(  -3), INT8_C(-127), INT8_C(  41),
                           INT8_C(  74), INT8_C(  72), INT8_C(  -4), INT8_C(  28),
                           INT8_C(-115), INT8_C(  93), INT8_C( 102), INT8_C(  44),
                           INT8_C(-103), INT8_C( -29), INT8_C( -50), INT8_C(  48),
                           INT8_C( -96), INT8_C( -50), INT8_C(  46), INT8_C( -65),
                           INT8_C(   4), INT8_C(  43), INT8_C( -75), INT8_C(  97),
                           INT8_C( -26), INT8_C(-103), INT8_C(  71), INT8_C(-107),
                           INT8_C(  91), INT8_C(  45), INT8_C( -11), INT8_C(  47),
                           INT8_C(  29), INT8_C(  25), INT8_C(  26), INT8_C(  -9),
                           INT8_C(  10), INT8_C(  36), INT8_C( -79), INT8_C( -53),
                           INT8_C(  41), INT8_C(   1), INT8_C( -23), INT8_C( -63),
                           INT8_C(-127), INT8_C(  68), INT8_C(  48), INT8_C(  36),
                           INT8_C(  89), INT8_C(-112), INT8_C( -31), INT8_C( 120),
                           INT8_C(  35), INT8_C(  62), INT8_C( -21), INT8_C(-114),
                           INT8_C(-104), INT8_C(  57), INT8_C(  42), INT8_C(-111)),
      simde_mm512_set_epi8(INT8_C(  96), INT8_C( -64), INT8_C( -23), INT8_C( -46),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90),
                           INT8_C(  44), INT8_C( -92), INT8_C( -31), INT8_C(  26),
                           INT8_C( -99), INT8_C( -53), INT8_C( 117), INT8_C(  18),
                           INT8_C( -63), INT8_C(  45), INT8_C(  12), INT8_C(  24),
                           INT8_C(-108), INT8_C(  18), INT8_C( -60), INT8_C(  28),
                           INT8_C(  50), INT8_C( -11), INT8_C( -68), INT8_C( -31),
                           INT8_C( 105), INT8_C(-106), INT8_C(  98), INT8_C(  51),
                           INT8_C(  58), INT8_C( 103), INT8_C( 111), INT8_C(-127),
                           INT8_C(  68), INT8_C( -56), INT8_C( 124), INT8_C(-119),
                           INT8_C(  74), INT8_C( -62), INT8_C(-116), INT8_C(  37),
                           INT8_C( -12), INT8_C( 114), INT8_C(   0), INT8_C(  61),
                           INT8_C( 103), INT8_C(  -4), INT8_C(-105), INT8_C( -68),
                           INT8_C(  39), INT8_C(-100), INT8_C( -93), INT8_C(  11),
                           INT8_C( -80), INT8_C( -19), INT8_C( -22), INT8_C( -39),
                           INT8_C( 127), INT8_C( -38), INT8_C(-125), INT8_C(-111)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(-128), INT8_C(   0), INT8_C( -68),
                           INT8_C( -34), INT8_C( -74), INT8_C( -56), INT8_C(   0),
                           INT8_C( 118), INT8_C( -20), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  62),
                           INT8_C(-128), INT8_C(  16), INT8_C( -38), INT8_C(  72),
                           INT8_C(   0), INT8_C( -32), INT8_C( -14), INT8_C( -37),
                           INT8_C(   0), INT8_C(  32), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 127), INT8_C(   0), INT8_C( 100), INT8_C( -80),
                           INT8_C(  97), INT8_C( -31), INT8_C( 127), INT8_C(-128),
                           INT8_C(  84), INT8_C( -26), INT8_C(-128), INT8_C( -16),
                           INT8_C(  29), INT8_C( 115), INT8_C( -23), INT8_C(   0),
                           INT8_C(   0), INT8_C(  64), INT8_C( -57), INT8_C(   0),
                           INT8_C( 127), INT8_C(-128), INT8_C(-124), INT8_C(   0),
                           INT8_C( -45), INT8_C(  43), INT8_C( -43), INT8_C(-128),
                           INT8_C(  23), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(18325019528117086600),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C( -54), INT8_C(  50), INT8_C( 123),
                           INT8_C( -31), INT8_C( -74), INT8_C( -64), INT8_C(  54),
                           INT8_C( -81), INT8_C(  60), INT8_C(  31), INT8_C( -23),
                           INT8_C( 108), INT8_C(-119), INT8_C( -92), INT8_C( -80),
                           INT8_C( -30), INT8_C( -37), INT8_C(  51), INT8_C( -36),
                           INT8_C(   8), INT8_C(  52), INT8_C(  97), INT8_C( 123),
                           INT8_C( -49), INT8_C(-124), INT8_C(  95), INT8_C( -83),
                           INT8_C(  70), INT8_C( -50), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(  11),
                           INT8_C( -14), INT8_C( 126), INT8_C(  81), INT8_C(  45),
                           INT8_C( -23), INT8_C( 120), INT8_C( -83), INT8_C( -16),
                           INT8_C(   7), INT8_C(  51), INT8_C( -57), INT8_C( -50),
                           INT8_C( -21), INT8_C(  98), INT8_C(  88), INT8_C(   0),
                           INT8_C( -66), INT8_C(   3), INT8_C( 124), INT8_C(-113),
                           INT8_C(  50), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C( -44), INT8_C( -13), INT8_C( -94), INT8_C(  17)),
      simde_mm512_set_epi8(INT8_C( -13), INT8_C( -12), INT8_C(-124), INT8_C(  96),
                           INT8_C( -13), INT8_C( -98), INT8_C(  99), INT8_C( -13),
                           INT8_C(  56), INT8_C( -45), INT8_C(-108), INT8_C( -19),
                           INT8_C(-124), INT8_C( -27), INT8_C(  22), INT8_C( 126),
                           INT8_C(-106), INT8_C( -68), INT8_C( -60), INT8_C(   8),
                           INT8_C(  60), INT8_C(  93), INT8_C( -33), INT8_C( -27),
                           INT8_C(  -7), INT8_C(  27), INT8_C(-122), INT8_C( -38),
                           INT8_C(  23), INT8_C(   6), INT8_C(  45), INT8_C( -21),
                           INT8_C( -23), INT8_C(-101), INT8_C( 116), INT8_C( 127),
                           INT8_C(  96), INT8_C(  40), INT8_C( -97), INT8_C(  40),
                           INT8_C(  86), INT8_C( -44), INT8_C(  70), INT8_C( -71),
                           INT8_C(  62), INT8_C( -21), INT8_C(  66), INT8_C(  68),
                           INT8_C( -87), INT8_C( -61), INT8_C(  48), INT8_C( -70),
                           INT8_C(  18), INT8_C( -78), INT8_C( -98), INT8_C( 117),
                           INT8_C(  74), INT8_C(  32), INT8_C(  93), INT8_C( 125),
                           INT8_C( -47), INT8_C( -60), INT8_C( -86), INT8_C( 117)),
      simde_mm512_set_epi8(INT8_C( 109), INT8_C( -66), INT8_C( -74), INT8_C( 127),
                           INT8_C( -44), INT8_C(-128), INT8_C(  35), INT8_C(   0),
                           INT8_C(   0), INT8_C(  15), INT8_C(   0), INT8_C(   0),
                           INT8_C( -16), INT8_C(-128), INT8_C( -70), INT8_C(  46),
                           INT8_C(-128), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  68), INT8_C( 127), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -27), INT8_C(   0),
                           INT8_C(  93), INT8_C(   0), INT8_C( -16), INT8_C(   4),
                           INT8_C(-120), INT8_C(   0), INT8_C(  58), INT8_C( 127),
                           INT8_C(   0), INT8_C(   0), INT8_C( -16), INT8_C(  85),
                           INT8_C(  63), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   9), INT8_C(  18),
                           INT8_C(-108), INT8_C(  37), INT8_C( 127), INT8_C(   0),
                           INT8_C( -48), INT8_C(   0), INT8_C(   0), INT8_C(   4),
                           INT8_C( 124), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -91), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C( 7677112093376593822),
      simde_mm512_set_epi8(INT8_C( -53), INT8_C(  34), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  69), INT8_C(  -8),
                           INT8_C( -15), INT8_C( -51), INT8_C(   1), INT8_C(  90),
                           INT8_C( 115), INT8_C(  51), INT8_C( -91), INT8_C(  56),
                           INT8_C(  64), INT8_C( -39), INT8_C(-119), INT8_C( -28),
                           INT8_C( -54), INT8_C(  28), INT8_C(  54), INT8_C(  -8),
                           INT8_C( -54), INT8_C(-128), INT8_C( -28), INT8_C( -71),
                           INT8_C( 107), INT8_C( -66), INT8_C(-114), INT8_C( -88),
                           INT8_C(  34), INT8_C( -83), INT8_C( -21), INT8_C( -64),
                           INT8_C( 121), INT8_C( -20), INT8_C( -89), INT8_C( -94),
                           INT8_C( 112), INT8_C( -27), INT8_C(  81), INT8_C( -54),
                           INT8_C( -64), INT8_C(-114), INT8_C(  48), INT8_C( -89),
                           INT8_C( -61), INT8_C(  26), INT8_C(  43), INT8_C(  29),
                           INT8_C(   0), INT8_C(  64), INT8_C( 123), INT8_C( -67),
                           INT8_C(  15), INT8_C( 120), INT8_C(  36), INT8_C(  40)),
      simde_mm512_set_epi8(INT8_C( 113), INT8_C(  32), INT8_C(  71), INT8_C(  55),
                           INT8_C( -26), INT8_C(  82), INT8_C( -81), INT8_C( -20),
                           INT8_C( -55), INT8_C( 112), INT8_C(  45), INT8_C(  37),
                           INT8_C(  67), INT8_C( -69), INT8_C(  64), INT8_C(  39),
                           INT8_C(  72), INT8_C(  45), INT8_C( 120), INT8_C(  -5),
                           INT8_C(-109), INT8_C(  62), INT8_C(  17), INT8_C(  31),
                           INT8_C( -30), INT8_C( -58), INT8_C(  56), INT8_C(  21),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(  32), INT8_C(  64),
                           INT8_C(-128), INT8_C( 102), INT8_C( -21), INT8_C(  28),
                           INT8_C( 105), INT8_C(  52), INT8_C(  85), INT8_C(-104),
                           INT8_C(  57), INT8_C( -31), INT8_C( -38), INT8_C(-124),
                           INT8_C(-107), INT8_C(  -2), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  18), INT8_C(  70),
                           INT8_C(  89), INT8_C( 125), INT8_C( -42), INT8_C(-125),
                           INT8_C( 121), INT8_C( -11), INT8_C( -69), INT8_C( -59)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(  66), INT8_C(  80), INT8_C(   0),
                           INT8_C( -87), INT8_C(   0), INT8_C(-128), INT8_C(   0),
                           INT8_C(  10), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  52), INT8_C(   0), INT8_C(  65), INT8_C(   0),
                           INT8_C( 127), INT8_C(   0), INT8_C(   0), INT8_C(  51),
                           INT8_C(   0), INT8_C(  23), INT8_C(   0), INT8_C(   0),
                           INT8_C( -84), INT8_C( -30), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-128), INT8_C( -68), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -24),
                           INT8_C( -94), INT8_C(   0), INT8_C( -42), INT8_C(   0),
                           INT8_C( 127), INT8_C(   0), INT8_C(   0), INT8_C(-128),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-128),
                           INT8_C(   0), INT8_C(   0), INT8_C( 103), INT8_C( -43),
                           INT8_C(-128), INT8_C( 103), INT8_C(  61), INT8_C(  99),
                           INT8_C(  89), INT8_C(   0), INT8_C(   0), INT8_C(-128),
                           INT8_C( 127), INT8_C( 109), INT8_C( -33), INT8_C(   0)) },
    { UINT64_C( 4840581956081845689),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C(-108), INT8_C( -70), INT8_C( -63),
                           INT8_C(  56), INT8_C(  71), INT8_C( -14), INT8_C(  49),
                           INT8_C( -73), INT8_C(  53), INT8_C( -29), INT8_C(   3),
                           INT8_C( -73), INT8_C(  43), INT8_C( -22), INT8_C(  85),
                           INT8_C( -26), INT8_C(  -9), INT8_C(  66), INT8_C(   1),
                           INT8_C( -13), INT8_C(  60), INT8_C(-119), INT8_C( -83),
                           INT8_C(-122), INT8_C( -64), INT8_C( -83), INT8_C( -74),
                           INT8_C( 119), INT8_C(  -8), INT8_C(  12), INT8_C( 113),
                           INT8_C( -12), INT8_C( -84), INT8_C(   6), INT8_C(  69),
                           INT8_C(   2), INT8_C( -75), INT8_C( -34), INT8_C(-126),
                           INT8_C(   3), INT8_C(-128), INT8_C(  -9), INT8_C(  24),
                           INT8_C(  11), INT8_C( -94), INT8_C( -32), INT8_C( 110),
                           INT8_C(  33), INT8_C( -24), INT8_C( 125), INT8_C(  35),
                           INT8_C(-103), INT8_C( -48), INT8_C( -22), INT8_C(  38),
                           INT8_C( -81), INT8_C(   9), INT8_C( -11), INT8_C(-124),
                           INT8_C(  71), INT8_C(  31), INT8_C( -42), INT8_C(  93)),
      simde_mm512_set_epi8(INT8_C(  53), INT8_C(  77), INT8_C(  63), INT8_C( -84),
                           INT8_C(  27), INT8_C(  22), INT8_C(   3), INT8_C( -37),
                           INT8_C(  65), INT8_C( 118), INT8_C(-126), INT8_C(  97),
                           INT8_C( 109), INT8_C(   7), INT8_C(-114), INT8_C( -75),
                           INT8_C(-125), INT8_C( 121), INT8_C(-128), INT8_C( 103),
                           INT8_C(   0), INT8_C( 101), INT8_C( -41), INT8_C(  89),
                           INT8_C( -83), INT8_C( -65), INT8_C(   9), INT8_C(  -7),
                           INT8_C( -63), INT8_C(  13), INT8_C( 105), INT8_C(  92),
                           INT8_C( -18), INT8_C( -21), INT8_C(-102), INT8_C(-114),
                           INT8_C(  74), INT8_C( 121), INT8_C( -45), INT8_C(  52),
                           INT8_C( -63), INT8_C( -93), INT8_C(  98), INT8_C( 106),
                           INT8_C(-109), INT8_C( -47), INT8_C(  37), INT8_C(  70),
                           INT8_C( 100), INT8_C( 121), INT8_C(  18), INT8_C(  28),
                           INT8_C(-117), INT8_C( 107), INT8_C(   3), INT8_C( -62),
                           INT8_C(  42), INT8_C(  72), INT8_C(  91), INT8_C(  86),
                           INT8_C( -72), INT8_C(   9), INT8_C( -80), INT8_C( 118)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C( -31), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -11), INT8_C(  12),
                           INT8_C(   0), INT8_C(   0), INT8_C(-128), INT8_C(   0),
                           INT8_C(  36), INT8_C(  50), INT8_C(   0), INT8_C(  10),
                           INT8_C(   0), INT8_C(   0), INT8_C( -62), INT8_C( 104),
                           INT8_C(   0), INT8_C(   0), INT8_C(-128), INT8_C(   6),
                           INT8_C(-128), INT8_C(   0), INT8_C( -74), INT8_C(   0),
                           INT8_C(   0), INT8_C(   5), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-105), INT8_C( -96), INT8_C( -45),
                           INT8_C(  76), INT8_C(  46), INT8_C( -79), INT8_C(   0),
                           INT8_C(   0), INT8_C(-128), INT8_C(  89), INT8_C(   0),
                           INT8_C( -98), INT8_C(-128), INT8_C(   0), INT8_C(   0),
                           INT8_C( 127), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  59), INT8_C(   0), INT8_C( -24),
                           INT8_C( -39), INT8_C(   0), INT8_C(  80), INT8_C( -38),
                           INT8_C(  -1), INT8_C(   0), INT8_C(   0), INT8_C( 127)) },
    { UINT64_C(17498311407133456191),
      simde_mm512_set_epi8(INT8_C(  61), INT8_C( -89), INT8_C(  84), INT8_C( -94),
                           INT8_C(  31), INT8_C(-116), INT8_C( -67), INT8_C(-102),
                           INT8_C( -72), INT8_C( -91), INT8_C(-105), INT8_C(-108),
                           INT8_C( -44), INT8_C(  74), INT8_C( -28), INT8_C( 124),
                           INT8_C( 120), INT8_C( -41), INT8_C( -79), INT8_C( 122),
                           INT8_C(  87), INT8_C(-119), INT8_C(  54), INT8_C(  -2),
                           INT8_C( -47), INT8_C(  84), INT8_C(-126), INT8_C( -64),
                           INT8_C(  14), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  67), INT8_C( 124), INT8_C(  58), INT8_C( -94),
                           INT8_C(  30), INT8_C( -33), INT8_C(  70), INT8_C( -24),
                           INT8_C(  38), INT8_C( -97), INT8_C( -56), INT8_C( -60),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(  45),
                           INT8_C( -11), INT8_C(  55), INT8_C( -82), INT8_C(  12),
                           INT8_C( 106), INT8_C(  22), INT8_C(-124), INT8_C(  -4),
                           INT8_C(   2), INT8_C( -81), INT8_C(  14), INT8_C(  90),
                           INT8_C(-100), INT8_C(-122), INT8_C( -35), INT8_C(  81)),
      simde_mm512_set_epi8(INT8_C(  21), INT8_C( 108), INT8_C( 125), INT8_C( -60),
                           INT8_C( -72), INT8_C(  74), INT8_C(  -5), INT8_C( -58),
                           INT8_C( -41), INT8_C(  22), INT8_C(-115), INT8_C( 102),
                           INT8_C(  59), INT8_C( -80), INT8_C( -15), INT8_C( -63),
                           INT8_C(  84), INT8_C( -71), INT8_C(   8), INT8_C(  12),
                           INT8_C( -11), INT8_C( -76), INT8_C(  62), INT8_C(  93),
                           INT8_C( -75), INT8_C( -77), INT8_C( -84), INT8_C(-108),
                           INT8_C( -35), INT8_C(  14), INT8_C( -60), INT8_C(  18),
                           INT8_C(  23), INT8_C( -60), INT8_C( -63), INT8_C(-114),
                           INT8_C( -55), INT8_C(  75), INT8_C( -99), INT8_C( -55),
                           INT8_C(  58), INT8_C(  76), INT8_C(-102), INT8_C(-118),
                           INT8_C( -30), INT8_C(  39), INT8_C( 119), INT8_C(  85),
                           INT8_C(  -8), INT8_C( -72), INT8_C( -60), INT8_C( -94),
                           INT8_C(-112), INT8_C( 119), INT8_C( 124), INT8_C(  76),
                           INT8_C( -42), INT8_C(-124), INT8_C(  54), INT8_C(  74),
                           INT8_C( -92), INT8_C(  99), INT8_C(  79), INT8_C(  -3)),
      simde_mm512_set_epi8(INT8_C(  82), INT8_C(  19), INT8_C( 127), INT8_C(-128),
                           INT8_C(   0), INT8_C(   0), INT8_C( -72), INT8_C(   0),
                           INT8_C(-113), INT8_C( -69), INT8_C(   0), INT8_C(  -6),
                           INT8_C(   0), INT8_C(  -6), INT8_C( -43), INT8_C(   0),
                           INT8_C(   0), INT8_C(-112), INT8_C( -71), INT8_C( 127),
                           INT8_C(  76), INT8_C(-128), INT8_C(   0), INT8_C(  91),
                           INT8_C(-122), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -23), INT8_C(  -5),
                           INT8_C(  90), INT8_C(  64), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  42), INT8_C( -29), INT8_C( -79),
                           INT8_C(   0), INT8_C( -21), INT8_C(   0), INT8_C(-128),
                           INT8_C( -89), INT8_C(   0), INT8_C(  45), INT8_C(   0),
                           INT8_C( -19), INT8_C( -17), INT8_C(-128), INT8_C( -82),
                           INT8_C(   0), INT8_C( 127), INT8_C(   0), INT8_C(  72),
                           INT8_C(   0), INT8_C(   0), INT8_C(  68), INT8_C( 127),
                           INT8_C(-128), INT8_C( -23), INT8_C(  44), INT8_C(  78)) },
    { UINT64_C( 3462613925466476941),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C( -74), INT8_C(  14), INT8_C(  36),
                           INT8_C(  -7), INT8_C( 113), INT8_C(  40), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  85),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C( -21),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  72), INT8_C(  93), INT8_C( 108), INT8_C( 125),
                           INT8_C(   1), INT8_C(  75), INT8_C(  21), INT8_C( -36),
                           INT8_C(-126), INT8_C( 122), INT8_C(  71), INT8_C(  76),
                           INT8_C(  28), INT8_C( -56), INT8_C(  32), INT8_C( 101),
                           INT8_C(-107), INT8_C(-111), INT8_C( -88), INT8_C( -19),
                           INT8_C( -77), INT8_C(  19), INT8_C( -21), INT8_C(-111),
                           INT8_C( -68), INT8_C(  82), INT8_C(-118), INT8_C( -76),
                           INT8_C(  47), INT8_C( 127), INT8_C(  62), INT8_C( -16),
                           INT8_C(  10), INT8_C( -14), INT8_C(-100), INT8_C(  86),
                           INT8_C(  29), INT8_C( 107), INT8_C(  56), INT8_C(  21),
                           INT8_C(  24), INT8_C(  68), INT8_C( -96), INT8_C(  64)),
      simde_mm512_set_epi8(INT8_C( -57), INT8_C(  94), INT8_C(-125), INT8_C(-124),
                           INT8_C(  36), INT8_C(  57), INT8_C(  68), INT8_C( -52),
                           INT8_C(  39), INT8_C(  50), INT8_C( -48), INT8_C(  94),
                           INT8_C(  53), INT8_C(  11), INT8_C(  29), INT8_C(  65),
                           INT8_C( -82), INT8_C(-119), INT8_C( 115), INT8_C(  68),
                           INT8_C( -69), INT8_C( 118), INT8_C(  17), INT8_C(   8),
                           INT8_C( -64), INT8_C( -53), INT8_C( -42), INT8_C( 126),
                           INT8_C(  67), INT8_C(  50), INT8_C( -18), INT8_C(  76),
                           INT8_C( -19), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C( -74), INT8_C(  44), INT8_C( 117), INT8_C( 103),
                           INT8_C(  81), INT8_C( 122), INT8_C(  56), INT8_C( -10),
                           INT8_C(  67), INT8_C(  79), INT8_C(  83), INT8_C( -38),
                           INT8_C( -13), INT8_C(  43), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C( 126), INT8_C(  38), INT8_C( -62),
                           INT8_C( -24), INT8_C( 117), INT8_C( -38), INT8_C( -93),
                           INT8_C( -58), INT8_C(-124), INT8_C( -75), INT8_C(  10)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(-111), INT8_C( -88),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  18), INT8_C(-105), INT8_C(   0), INT8_C(  44),
                           INT8_C( -67), INT8_C(   0), INT8_C( 127), INT8_C(   0),
                           INT8_C(   3), INT8_C( 127), INT8_C(   0), INT8_C( 127),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 127), INT8_C(   0), INT8_C(   0),
                           INT8_C(   9), INT8_C(  67), INT8_C( -55), INT8_C( 127),
                           INT8_C(-128), INT8_C( -67), INT8_C(   0), INT8_C(  84),
                           INT8_C(   4), INT8_C( 127), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-113),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  24),
                           INT8_C(   5), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -34), INT8_C( -56), INT8_C(   0), INT8_C(  74)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_adds_epi8(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_adds_epi16(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi16(INT16_C(  5952), INT16_C(-21138), INT16_C( 23605), INT16_C( -3799),
                            INT16_C(  1987), INT16_C( 29254), INT16_C( -4184), INT16_C( 13346),
                            INT16_C( 26203), INT16_C(-24373), INT16_C( 15487), INT16_C( 15569),
                            INT16_C( 13821), INT16_C( -3315), INT16_C( 30667), INT16_C(  9811),
                            INT16_C( 22769), INT16_C( 21964), INT16_C(  -315), INT16_C(-15723),
                            INT16_C( -9658), INT16_C(-27088), INT16_C( 18289), INT16_C( 13213),
                            INT16_C(-12712), INT16_C( 23293), INT16_C( 12497), INT16_C( 16576),
                            INT16_C(-19358), INT16_C(-11263), INT16_C( -3745), INT16_C(  7925)),
      simde_mm512_set_epi16(INT16_C(-22600), INT16_C(  9825), INT16_C( 27347), INT16_C( -4649),
                            INT16_C(  4812), INT16_C( 27489), INT16_C( 14729), INT16_C(-20872),
                            INT16_C(-24487), INT16_C( 23053), INT16_C( 28966), INT16_C(-23890),
                            INT16_C( -9737), INT16_C(-24021), INT16_C( 12009), INT16_C(-16892),
                            INT16_C(-11018), INT16_C( -7664), INT16_C( 22598), INT16_C(  9112),
                            INT16_C(  -468), INT16_C(-16246), INT16_C( 11633), INT16_C(  3402),
                            INT16_C( 12940), INT16_C(-18453), INT16_C(-10463), INT16_C(-24372),
                            INT16_C(  9722), INT16_C(  4912), INT16_C( 14086), INT16_C( -2976)),
      simde_mm512_set_epi16(INT16_C(-16648), INT16_C(-11313), INT16_C( 32767), INT16_C( -8448),
                            INT16_C(  6799), INT16_C( 32767), INT16_C( 10545), INT16_C( -7526),
                            INT16_C(  1716), INT16_C( -1320), INT16_C( 32767), INT16_C( -8321),
                            INT16_C(  4084), INT16_C(-27336), INT16_C( 32767), INT16_C( -7081),
                            INT16_C( 11751), INT16_C( 14300), INT16_C( 22283), INT16_C( -6611),
                            INT16_C(-10126), INT16_C(-32768), INT16_C( 29922), INT16_C( 16615),
                            INT16_C(   228), INT16_C(  4840), INT16_C(  2034), INT16_C( -7796),
                            INT16_C( -9636), INT16_C( -6351), INT16_C( 10341), INT16_C(  4949)) },
    { simde_mm512_set_epi16(INT16_C(-21870), INT16_C( -1966), INT16_C(-26101), INT16_C(  8905),
                            INT16_C(-13069), INT16_C( 13555), INT16_C(-23554), INT16_C(-12947),
                            INT16_C( 31779), INT16_C( 21013), INT16_C( 32688), INT16_C( 12512),
                            INT16_C(-26721), INT16_C(  7598), INT16_C( 21566), INT16_C(-11203),
                            INT16_C( 27021), INT16_C( -8539), INT16_C(  -532), INT16_C(-17200),
                            INT16_C(-18609), INT16_C(-30604), INT16_C(  6829), INT16_C(-13538),
                            INT16_C( 21529), INT16_C( 29340), INT16_C( 23176), INT16_C( 10860),
                            INT16_C( 31408), INT16_C(  3656), INT16_C(-30572), INT16_C( -4393)),
      simde_mm512_set_epi16(INT16_C( 29137), INT16_C( 29112), INT16_C(-21893), INT16_C( 14830),
                            INT16_C( 28350), INT16_C( 21222), INT16_C( 26922), INT16_C( 26197),
                            INT16_C(-25881), INT16_C( 28163), INT16_C(-19268), INT16_C( 10158),
                            INT16_C(-29245), INT16_C( 16103), INT16_C(-23323), INT16_C( 12478),
                            INT16_C( -6515), INT16_C( 24007), INT16_C(-28366), INT16_C(-32677),
                            INT16_C(-27350), INT16_C(-26916), INT16_C(-11979), INT16_C( 13820),
                            INT16_C(-22393), INT16_C(-20903), INT16_C( -9892), INT16_C(-22447),
                            INT16_C(-14286), INT16_C(  3532), INT16_C( 19664), INT16_C(-26842)),
      simde_mm512_set_epi16(INT16_C(  7267), INT16_C( 27146), INT16_C(-32768), INT16_C( 23735),
                            INT16_C( 15281), INT16_C( 32767), INT16_C(  3368), INT16_C( 13250),
                            INT16_C(  5898), INT16_C( 32767), INT16_C( 13420), INT16_C( 22670),
                            INT16_C(-32768), INT16_C( 23701), INT16_C( -1757), INT16_C(  1275),
                            INT16_C( 20506), INT16_C( 15468), INT16_C(-28898), INT16_C(-32768),
                            INT16_C(-32768), INT16_C(-32768), INT16_C( -5150), INT16_C(   282),
                            INT16_C(  -864), INT16_C(  8437), INT16_C( 13284), INT16_C(-11587),
                            INT16_C( 17122), INT16_C(  7188), INT16_C(-10908), INT16_C(-31235)) },
    { simde_mm512_set_epi16(INT16_C(-22689), INT16_C( 25207), INT16_C( -9300), INT16_C( 28977),
                            INT16_C(  2270), INT16_C(-32394), INT16_C( 26182), INT16_C( 23367),
                            INT16_C( 31661), INT16_C(  9636), INT16_C(-18580), INT16_C(-28875),
                            INT16_C(-25943), INT16_C( 14067), INT16_C( 10599), INT16_C( 30831),
                            INT16_C(-23557), INT16_C( 11377), INT16_C( -4608), INT16_C( 14955),
                            INT16_C( 11781), INT16_C(-12602), INT16_C( -3223), INT16_C( 11440),
                            INT16_C( -2896), INT16_C(-24304), INT16_C( 29156), INT16_C( -4347),
                            INT16_C( -2421), INT16_C( 31033), INT16_C( -3132), INT16_C(-19324)),
      simde_mm512_set_epi16(INT16_C( -2724), INT16_C(  4704), INT16_C( 23772), INT16_C(-20368),
                            INT16_C(-30374), INT16_C( 15838), INT16_C( 19402), INT16_C( 16976),
                            INT16_C(-28476), INT16_C( -2715), INT16_C(-27679), INT16_C( -8608),
                            INT16_C(-20120), INT16_C( 29206), INT16_C( -1643), INT16_C(-29856),
                            INT16_C( 18656), INT16_C( -9660), INT16_C( -4660), INT16_C(-30272),
                            INT16_C(   610), INT16_C( -3787), INT16_C( 22038), INT16_C(-29446),
                            INT16_C(-26504), INT16_C(-28984), INT16_C(-21830), INT16_C(-27507),
                            INT16_C( 24148), INT16_C(-12945), INT16_C( 24529), INT16_C(  7913)),
      simde_mm512_set_epi16(INT16_C(-25413), INT16_C( 29911), INT16_C( 14472), INT16_C(  8609),
                            INT16_C(-28104), INT16_C(-16556), INT16_C( 32767), INT16_C( 32767),
                            INT16_C(  3185), INT16_C(  6921), INT16_C(-32768), INT16_C(-32768),
                            INT16_C(-32768), INT16_C( 32767), INT16_C(  8956), INT16_C(   975),
                            INT16_C( -4901), INT16_C(  1717), INT16_C( -9268), INT16_C(-15317),
                            INT16_C( 12391), INT16_C(-16389), INT16_C( 18815), INT16_C(-18006),
                            INT16_C(-29400), INT16_C(-32768), INT16_C(  7326), INT16_C(-31854),
                            INT16_C( 21727), INT16_C( 18088), INT16_C( 21397), INT16_C(-11411)) },
    { simde_mm512_set_epi16(INT16_C(-18069), INT16_C( 21685), INT16_C( -5808), INT16_C( 24672),
                            INT16_C( -8190), INT16_C( -2830), INT16_C(-23214), INT16_C(  1083),
                            INT16_C(  6699), INT16_C(   871), INT16_C(-14072), INT16_C( -2337),
                            INT16_C( 13356), INT16_C(  7260), INT16_C(-23788), INT16_C(-19723),
                            INT16_C( 13480), INT16_C(-15429), INT16_C(-20153), INT16_C( 18680),
                            INT16_C(-26180), INT16_C( 27923), INT16_C(-14099), INT16_C( 25829),
                            INT16_C(-27481), INT16_C( 21639), INT16_C( 16654), INT16_C( 19972),
                            INT16_C( 15776), INT16_C( 23126), INT16_C( 30799), INT16_C(-14043)),
      simde_mm512_set_epi16(INT16_C( 16111), INT16_C(-26103), INT16_C( -8800), INT16_C(-24747),
                            INT16_C( 27941), INT16_C(   603), INT16_C( -8112), INT16_C(-28325),
                            INT16_C( -6110), INT16_C(-15530), INT16_C(  -938), INT16_C(-26515),
                            INT16_C( -2492), INT16_C( 16124), INT16_C(-27181), INT16_C( -3573),
                            INT16_C( 11652), INT16_C( 11646), INT16_C(  6964), INT16_C( 27675),
                            INT16_C( 13103), INT16_C( -2742), INT16_C( 27906), INT16_C( -1077),
                            INT16_C(-30636), INT16_C(-23050), INT16_C(  8363), INT16_C( 31350),
                            INT16_C( -4750), INT16_C(  -220), INT16_C( -8954), INT16_C( 15617)),
      simde_mm512_set_epi16(INT16_C( -1958), INT16_C( -4418), INT16_C(-14608), INT16_C(   -75),
                            INT16_C( 19751), INT16_C( -2227), INT16_C(-31326), INT16_C(-27242),
                            INT16_C(   589), INT16_C(-14659), INT16_C(-15010), INT16_C(-28852),
                            INT16_C( 10864), INT16_C( 23384), INT16_C(-32768), INT16_C(-23296),
                            INT16_C( 25132), INT16_C( -3783), INT16_C(-13189), INT16_C( 32767),
                            INT16_C(-13077), INT16_C( 25181), INT16_C( 13807), INT16_C( 24752),
                            INT16_C(-32768), INT16_C( -1411), INT16_C( 25017), INT16_C( 32767),
                            INT16_C( 11026), INT16_C( 22906), INT16_C( 21845), INT16_C(  1574)) },
    { simde_mm512_set_epi16(INT16_C( 25180), INT16_C(-32332), INT16_C(-18604), INT16_C(-25763),
                            INT16_C( 28237), INT16_C(-22027), INT16_C( 18301), INT16_C( 27599),
                            INT16_C( 11815), INT16_C(-14839), INT16_C(-13552), INT16_C( -6300),
                            INT16_C(-30211), INT16_C(-25552), INT16_C(  7375), INT16_C(  5267),
                            INT16_C(-14761), INT16_C(-28375), INT16_C(-32756), INT16_C( 13128),
                            INT16_C( 17683), INT16_C( -4430), INT16_C( -1805), INT16_C(-17763),
                            INT16_C(   206), INT16_C( 15851), INT16_C(  1078), INT16_C( 27402),
                            INT16_C(-15177), INT16_C(  5068), INT16_C(-15079), INT16_C(-13584)),
      simde_mm512_set_epi16(INT16_C( -3533), INT16_C( -3885), INT16_C(   789), INT16_C( -3755),
                            INT16_C(  3668), INT16_C( 19955), INT16_C(-22356), INT16_C(  8403),
                            INT16_C(-16920), INT16_C( 15195), INT16_C( -1853), INT16_C(-12121),
                            INT16_C(  5095), INT16_C( -9909), INT16_C(   574), INT16_C( 31911),
                            INT16_C( -1319), INT16_C( -2880), INT16_C(-31000), INT16_C(-30829),
                            INT16_C(-12917), INT16_C( 21541), INT16_C( 27413), INT16_C(-28040),
                            INT16_C(-19236), INT16_C(-24178), INT16_C(-29369), INT16_C( -3607),
                            INT16_C( -2666), INT16_C(-13470), INT16_C(  4416), INT16_C( 23850)),
      simde_mm512_set_epi16(INT16_C( 21647), INT16_C(-32768), INT16_C(-17815), INT16_C(-29518),
                            INT16_C( 31905), INT16_C( -2072), INT16_C( -4055), INT16_C( 32767),
                            INT16_C( -5105), INT16_C(   356), INT16_C(-15405), INT16_C(-18421),
                            INT16_C(-25116), INT16_C(-32768), INT16_C(  7949), INT16_C( 32767),
                            INT16_C(-16080), INT16_C(-31255), INT16_C(-32768), INT16_C(-17701),
                            INT16_C(  4766), INT16_C( 17111), INT16_C( 25608), INT16_C(-32768),
                            INT16_C(-19030), INT16_C( -8327), INT16_C(-28291), INT16_C( 23795),
                            INT16_C(-17843), INT16_C( -8402), INT16_C(-10663), INT16_C( 10266)) },
    { simde_mm512_set_epi16(INT16_C( 11424), INT16_C( 29699), INT16_C( 29618), INT16_C(-29898),
                            INT16_C(-23079), INT16_C( -6822), INT16_C( -7340), INT16_C(-12296),
                            INT16_C( 17833), INT16_C( -2043), INT16_C(-29766), INT16_C( 30776),
                            INT16_C(-18161), INT16_C(-32768), INT16_C(-31882), INT16_C(  3163),
                            INT16_C( 20808), INT16_C(-24577), INT16_C(  7685), INT16_C(  6279),
                            INT16_C(-27880), INT16_C( 27718), INT16_C(-18275), INT16_C( 24470),
                            INT16_C(  8834), INT16_C( 20594), INT16_C( 23052), INT16_C(-18860),
                            INT16_C(  7784), INT16_C(-16668), INT16_C(-30440), INT16_C(  6387)),
      simde_mm512_set_epi16(INT16_C( 15054), INT16_C(-23448), INT16_C(   866), INT16_C(-23509),
                            INT16_C(    -2), INT16_C(  6267), INT16_C(-15891), INT16_C(-24685),
                            INT16_C( 17511), INT16_C(  7218), INT16_C(-13659), INT16_C(-27162),
                            INT16_C( 10378), INT16_C(-16488), INT16_C(-11578), INT16_C(-27832),
                            INT16_C(-17566), INT16_C(-29377), INT16_C( -2221), INT16_C( 18656),
                            INT16_C(  7516), INT16_C(-30776), INT16_C(-19010), INT16_C( 26269),
                            INT16_C(-18451), INT16_C( 31467), INT16_C(-22066), INT16_C( 30155),
                            INT16_C( -3394), INT16_C( -6131), INT16_C( 13533), INT16_C( 21770)),
      simde_mm512_set_epi16(INT16_C( 26478), INT16_C(  6251), INT16_C( 30484), INT16_C(-32768),
                            INT16_C(-23081), INT16_C(  -555), INT16_C(-23231), INT16_C(-32768),
                            INT16_C( 32767), INT16_C(  5175), INT16_C(-32768), INT16_C(  3614),
                            INT16_C( -7783), INT16_C(-32768), INT16_C(-32768), INT16_C(-24669),
                            INT16_C(  3242), INT16_C(-32768), INT16_C(  5464), INT16_C( 24935),
                            INT16_C(-20364), INT16_C( -3058), INT16_C(-32768), INT16_C( 32767),
                            INT16_C( -9617), INT16_C( 32767), INT16_C(   986), INT16_C( 11295),
                            INT16_C(  4390), INT16_C(-22799), INT16_C(-16907), INT16_C( 28157)) },
    { simde_mm512_set_epi16(INT16_C( 11108), INT16_C(  5360), INT16_C(  8246), INT16_C(  2034),
                            INT16_C(  1485), INT16_C( 28421), INT16_C( 17428), INT16_C(-13900),
                            INT16_C(  4889), INT16_C( 17148), INT16_C( 13806), INT16_C(-26968),
                            INT16_C( -7783), INT16_C( 11345), INT16_C( 17472), INT16_C( 26483),
                            INT16_C(-10340), INT16_C( -7816), INT16_C( 22407), INT16_C( 32028),
                            INT16_C( 18301), INT16_C(-30148), INT16_C( -4736), INT16_C(-10574),
                            INT16_C( 10686), INT16_C( -5463), INT16_C( 19858), INT16_C( -4320),
                            INT16_C(-28154), INT16_C(  8984), INT16_C( 32741), INT16_C( 29052)),
      simde_mm512_set_epi16(INT16_C(-22772), INT16_C(-14596), INT16_C( -9458), INT16_C(  2054),
                            INT16_C(-24090), INT16_C(  1808), INT16_C(  9897), INT16_C( 20003),
                            INT16_C( 21444), INT16_C(  8548), INT16_C( -1773), INT16_C(  8905),
                            INT16_C( 14811), INT16_C(  5752), INT16_C(-17876), INT16_C( -7032),
                            INT16_C(-19669), INT16_C(-30631), INT16_C(-19220), INT16_C( 18906),
                            INT16_C( 15935), INT16_C(  2767), INT16_C(-30937), INT16_C( 13780),
                            INT16_C( 28270), INT16_C( 29263), INT16_C( 11106), INT16_C( 19546),
                            INT16_C( 16947), INT16_C(-29470), INT16_C( -1882), INT16_C(-19990)),
      simde_mm512_set_epi16(INT16_C(-11664), INT16_C( -9236), INT16_C( -1212), INT16_C(  4088),
                            INT16_C(-22605), INT16_C( 30229), INT16_C( 27325), INT16_C(  6103),
                            INT16_C( 26333), INT16_C( 25696), INT16_C( 12033), INT16_C(-18063),
                            INT16_C(  7028), INT16_C( 17097), INT16_C(  -404), INT16_C( 19451),
                            INT16_C(-30009), INT16_C(-32768), INT16_C(  3187), INT16_C( 32767),
                            INT16_C( 32767), INT16_C(-27381), INT16_C(-32768), INT16_C(  3206),
                            INT16_C( 32767), INT16_C( 23800), INT16_C( 30964), INT16_C( 15226),
                            INT16_C(-11207), INT16_C(-20486), INT16_C( 30859), INT16_C(  9062)) },
    { simde_mm512_set_epi16(INT16_C(-30561), INT16_C( -5745), INT16_C( 32288), INT16_C( 11324),
                            INT16_C(-18220), INT16_C(-24874), INT16_C(-10154), INT16_C( 15837),
                            INT16_C( 22748), INT16_C(  6197), INT16_C( 23429), INT16_C(-23495),
                            INT16_C( -9809), INT16_C(-19367), INT16_C(-10631), INT16_C( -3845),
                            INT16_C( -5637), INT16_C(-22436), INT16_C(  6126), INT16_C( 16975),
                            INT16_C(  5830), INT16_C( 26963), INT16_C(-12238), INT16_C( 18631),
                            INT16_C(-23641), INT16_C(-17151), INT16_C(-13103), INT16_C(  5981),
                            INT16_C( 25710), INT16_C( 32081), INT16_C(-26911), INT16_C(-20494)),
      simde_mm512_set_epi16(INT16_C( 30869), INT16_C(-18069), INT16_C(  6380), INT16_C(-23760),
                            INT16_C( -6614), INT16_C( 32014), INT16_C( -2152), INT16_C( 25253),
                            INT16_C( -8172), INT16_C(-22416), INT16_C(  2949), INT16_C(  5712),
                            INT16_C( 30074), INT16_C( 20521), INT16_C( 28471), INT16_C( -3867),
                            INT16_C( -3892), INT16_C( 21304), INT16_C(  2611), INT16_C(  5827),
                            INT16_C(-30009), INT16_C( 31479), INT16_C(-19390), INT16_C(  1047),
                            INT16_C(-19967), INT16_C( 11404), INT16_C( 25909), INT16_C(  6741),
                            INT16_C(  1933), INT16_C(-26599), INT16_C(-25469), INT16_C(-30351)),
      simde_mm512_set_epi16(INT16_C(   308), INT16_C(-23814), INT16_C( 32767), INT16_C(-12436),
                            INT16_C(-24834), INT16_C(  7140), INT16_C(-12306), INT16_C( 32767),
                            INT16_C( 14576), INT16_C(-16219), INT16_C( 26378), INT16_C(-17783),
                            INT16_C( 20265), INT16_C(  1154), INT16_C( 17840), INT16_C( -7712),
                            INT16_C( -9529), INT16_C( -1132), INT16_C(  8737), INT16_C( 22802),
                            INT16_C(-24179), INT16_C( 32767), INT16_C(-31628), INT16_C( 19678),
                            INT16_C(-32768), INT16_C( -5747), INT16_C( 12806), INT16_C( 12722),
                            INT16_C( 27643), INT16_C(  5482), INT16_C(-32768), INT16_C(-32768)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_adds_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i16(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_adds_epi16 (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const int16_t src[32];
    const simde__mmask32 k;
    const int16_t a[32];
    const int16_t b[32];
    const int16_t r[32];
  } test_vec[] = {
    { {  INT16_C(    72), -INT16_C(  5287), -INT16_C(  4542),  INT16_C(  2288), -INT16_C(  8745),  INT16_C( 27056), -INT16_C( 11265), -INT16_C( 27298),
        -INT16_C( 32448), -INT16_C( 11055), -INT16_C( 28733),  INT16_C(  7301),  INT16_C( 28274), -INT16_C( 27095), -INT16_C(  1294),  INT16_C( 15311),
         INT16_C( 10490),  INT16_C( 15398),  INT16_C(  5654), -INT16_C(  4795), -INT16_C(  2572), -INT16_C(  3241), -INT16_C( 19000),  INT16_C(  2185),
         INT16_C( 23095), -INT16_C(  1315),  INT16_C( 25321),  INT16_C( 23574),  INT16_C( 16336), -INT16_C( 15374), -INT16_C( 16071),  INT16_C( 13566) },
      UINT32_C(   7349481),
      { -INT16_C( 19142),  INT16_C( 12013),  INT16_C( 17579),  INT16_C( 29474), -INT16_C( 21510),  INT16_C( 12668),  INT16_C( 22789), -INT16_C(  4565),
         INT16_C( 17083), -INT16_C( 29878),  INT16_C( 15489), -INT16_C( 17586),  INT16_C( 19709), -INT16_C(  6161),  INT16_C( 24432), -INT16_C( 21529),
        -INT16_C( 11243), -INT16_C( 16167), -INT16_C(  1255),  INT16_C(  4915), -INT16_C( 20570), -INT16_C( 21692),  INT16_C( 28424), -INT16_C( 15462),
        -INT16_C(  6991),  INT16_C( 13135), -INT16_C( 25311),  INT16_C(  7918), -INT16_C(  8726),  INT16_C( 23045), -INT16_C(  5060),  INT16_C( 20741) },
      { -INT16_C(  8255), -INT16_C(  9711),  INT16_C( 17882), -INT16_C( 32275),  INT16_C( 12788), -INT16_C(   724), -INT16_C( 14688),  INT16_C( 21184),
         INT16_C(  4011), -INT16_C( 13179),  INT16_C( 29613), -INT16_C( 26646), -INT16_C(  4016), -INT16_C( 29455), -INT16_C(  2084), -INT16_C( 25122),
        -INT16_C(  4138), -INT16_C( 20361),  INT16_C( 25652),  INT16_C( 10545),  INT16_C( 24213),  INT16_C( 13862), -INT16_C(  6620), -INT16_C( 12408),
         INT16_C(  3574), -INT16_C( 23653), -INT16_C( 31104), -INT16_C( 12230),  INT16_C( 11126),  INT16_C( 21084),  INT16_C( 14882), -INT16_C(  1808) },
      { -INT16_C( 27397), -INT16_C(  5287), -INT16_C(  4542), -INT16_C(  2801), -INT16_C(  8745),  INT16_C( 11944),  INT16_C(  8101),  INT16_C( 16619),
        -INT16_C( 32448), -INT16_C( 11055),       INT16_MAX,  INT16_C(  7301),  INT16_C( 28274),       INT16_MIN, -INT16_C(  1294),  INT16_C( 15311),
         INT16_C( 10490),  INT16_C( 15398),  INT16_C(  5654), -INT16_C(  4795),  INT16_C(  3643), -INT16_C(  7830),  INT16_C( 21804),  INT16_C(  2185),
         INT16_C( 23095), -INT16_C(  1315),  INT16_C( 25321),  INT16_C( 23574),  INT16_C( 16336), -INT16_C( 15374), -INT16_C( 16071),  INT16_C( 13566) } },
    { {  INT16_C( 26410),  INT16_C( 24233), -INT16_C(  9524),  INT16_C( 24967), -INT16_C( 21192),  INT16_C( 23959),  INT16_C(  8084), -INT16_C( 30164),
        -INT16_C( 14292), -INT16_C( 21459),  INT16_C( 26446), -INT16_C( 15236), -INT16_C(  9838), -INT16_C( 19178),  INT16_C(  1555),  INT16_C( 15789),
         INT16_C( 22126),  INT16_C( 15004),  INT16_C(  9009),  INT16_C( 27035),  INT16_C( 13265),  INT16_C( 26054), -INT16_C(  3246),  INT16_C( 32751),
         INT16_C(  7355),  INT16_C(  2347), -INT16_C( 22397),  INT16_C(  5581), -INT16_C(  7295), -INT16_C( 27446),  INT16_C( 30954),  INT16_C( 22738) },
      UINT32_C(4287786702),
      {  INT16_C( 11665),  INT16_C( 25193),  INT16_C( 12128), -INT16_C( 19513), -INT16_C( 18910), -INT16_C(  8910),  INT16_C( 24018),  INT16_C( 21990),
        -INT16_C( 19707), -INT16_C( 31125),  INT16_C( 13719), -INT16_C( 32485), -INT16_C(  4691),  INT16_C( 31961),  INT16_C( 27483), -INT16_C(  4997),
        -INT16_C(  7016), -INT16_C(  1713),  INT16_C(  5652),  INT16_C( 13996), -INT16_C(  8499), -INT16_C( 24812), -INT16_C(  1477),  INT16_C( 16885),
         INT16_C( 24750),  INT16_C( 17863), -INT16_C(  7531),  INT16_C( 17350), -INT16_C( 24625),  INT16_C( 10943),  INT16_C( 14858), -INT16_C( 24041) },
      {  INT16_C( 26143),  INT16_C( 13211),  INT16_C( 18300),  INT16_C( 18793),  INT16_C( 32037),  INT16_C( 25065), -INT16_C(  8584),  INT16_C(  9890),
         INT16_C( 26942), -INT16_C( 11413),  INT16_C( 12620),  INT16_C(  6934), -INT16_C( 10800), -INT16_C(  9658),  INT16_C( 23824),  INT16_C( 12156),
         INT16_C(  6339),  INT16_C( 16226), -INT16_C( 13473), -INT16_C( 31351),  INT16_C( 29257), -INT16_C( 15898), -INT16_C( 30640), -INT16_C( 28953),
         INT16_C( 21233),  INT16_C( 15713),  INT16_C( 30851),  INT16_C( 21337), -INT16_C( 24755),  INT16_C( 23853), -INT16_C( 22020), -INT16_C( 16500) },
      {  INT16_C( 26410),       INT16_MAX,  INT16_C( 30428), -INT16_C(   720), -INT16_C( 21192),  INT16_C( 23959),  INT16_C( 15434),  INT16_C( 31880),
        -INT16_C( 14292),       INT16_MIN,  INT16_C( 26339), -INT16_C( 25551), -INT16_C(  9838),  INT16_C( 22303),       INT16_MAX,  INT16_C( 15789),
         INT16_C( 22126),  INT16_C( 14513),  INT16_C(  9009),  INT16_C( 27035),  INT16_C( 20758),  INT16_C( 26054), -INT16_C(  3246), -INT16_C( 12068),
              INT16_MAX,       INT16_MAX,  INT16_C( 23320),       INT16_MAX,       INT16_MIN,       INT16_MAX, -INT16_C(  7162),       INT16_MIN } },
    { { -INT16_C(  4415),  INT16_C(  8702), -INT16_C( 30790),  INT16_C(   934), -INT16_C( 29447),  INT16_C( 18884), -INT16_C( 21740),  INT16_C(  1495),
         INT16_C( 14845), -INT16_C( 32701), -INT16_C( 25423), -INT16_C(   301),  INT16_C(    59),  INT16_C( 14172), -INT16_C(  5975),  INT16_C( 27638),
        -INT16_C(  2857), -INT16_C( 28276),  INT16_C( 12924),  INT16_C( 30100),  INT16_C( 22718), -INT16_C( 11585), -INT16_C( 27133),  INT16_C(   215),
         INT16_C(  6863), -INT16_C( 32640),  INT16_C( 21430), -INT16_C(  3713), -INT16_C(  9389), -INT16_C(   984),  INT16_C(  7875), -INT16_C( 26009) },
      UINT32_C(2402022163),
      { -INT16_C( 16603), -INT16_C(  7420), -INT16_C( 15593),  INT16_C(  6837), -INT16_C( 29350),  INT16_C( 10522), -INT16_C( 25945),  INT16_C( 24234),
         INT16_C( 10733),  INT16_C( 16463),  INT16_C( 30724), -INT16_C( 14531), -INT16_C( 23402), -INT16_C( 22174), -INT16_C( 29288), -INT16_C( 17096),
         INT16_C( 15693),  INT16_C( 25761),  INT16_C( 22016),  INT16_C( 23167), -INT16_C( 26141), -INT16_C( 29820),  INT16_C( 11828),  INT16_C(  8681),
         INT16_C( 14423),  INT16_C( 23394), -INT16_C( 24656),  INT16_C( 18210), -INT16_C( 31677), -INT16_C(  9232),  INT16_C( 10514),  INT16_C( 24473) },
      {  INT16_C( 14950),  INT16_C( 26307),  INT16_C( 17040),  INT16_C( 29889),  INT16_C( 17884),  INT16_C(  4351), -INT16_C(  6029), -INT16_C( 13775),
        -INT16_C( 27872), -INT16_C( 11995),  INT16_C( 18226),  INT16_C( 30232),  INT16_C(  2252), -INT16_C(  8623), -INT16_C(  5583), -INT16_C( 26819),
         INT16_C(    36), -INT16_C( 18946), -INT16_C( 16573),  INT16_C(  7977),  INT16_C( 10244),  INT16_C( 30511),  INT16_C( 24592),  INT16_C( 12353),
         INT16_C( 26356),  INT16_C(  9729),  INT16_C(  6573),  INT16_C( 31132), -INT16_C(  4574),  INT16_C( 21335), -INT16_C( 27432), -INT16_C(   533) },
      { -INT16_C(  1653),  INT16_C( 18887), -INT16_C( 30790),  INT16_C(   934), -INT16_C( 11466),  INT16_C( 18884), -INT16_C( 21740),  INT16_C(  1495),
        -INT16_C( 17139),  INT16_C(  4468), -INT16_C( 25423), -INT16_C(   301), -INT16_C( 21150), -INT16_C( 30797),       INT16_MIN,       INT16_MIN,
         INT16_C( 15729),  INT16_C(  6815),  INT16_C( 12924),  INT16_C( 31144),  INT16_C( 22718),  INT16_C(   691), -INT16_C( 27133),  INT16_C(   215),
              INT16_MAX,       INT16_MAX, -INT16_C( 18083),       INT16_MAX, -INT16_C(  9389), -INT16_C(   984),  INT16_C(  7875),  INT16_C( 23940) } },
    { { -INT16_C(  5739), -INT16_C( 10062), -INT16_C(  9304), -INT16_C( 21257),  INT16_C(  9731),  INT16_C(  4899),  INT16_C( 25734),  INT16_C( 31299),
         INT16_C( 17866),  INT16_C( 30625),  INT16_C( 15710), -INT16_C( 32527),  INT16_C( 18475),  INT16_C(  1236), -INT16_C( 16419),  INT16_C( 29185),
        -INT16_C( 19544),  INT16_C( 20554),  INT16_C( 16782), -INT16_C( 28164),  INT16_C(  8039), -INT16_C(  4700), -INT16_C(  6269),  INT16_C( 19816),
         INT16_C(  2348), -INT16_C( 29756), -INT16_C( 19130),  INT16_C( 29195), -INT16_C(  8194), -INT16_C(  9354),  INT16_C( 30622),  INT16_C( 17997) },
      UINT32_C(3096876842),
      { -INT16_C( 27944),  INT16_C( 16201), -INT16_C(  4687),  INT16_C( 13356), -INT16_C( 27436),  INT16_C(   385),  INT16_C( 18077), -INT16_C(  7028),
        -INT16_C( 26629), -INT16_C(  1706), -INT16_C( 13193),  INT16_C(  5588),  INT16_C(  8515),  INT16_C( 27996), -INT16_C(  3400), -INT16_C( 28635),
         INT16_C( 28293),  INT16_C( 14031), -INT16_C(   933),  INT16_C( 12139), -INT16_C(  4976),  INT16_C( 11824), -INT16_C( 17358),  INT16_C( 11794),
         INT16_C( 26708), -INT16_C( 13529), -INT16_C(   972),  INT16_C( 30688),  INT16_C( 15389), -INT16_C( 10524),  INT16_C(  2351), -INT16_C( 19354) },
      {  INT16_C( 13943), -INT16_C( 11542),  INT16_C( 21810), -INT16_C( 15871),  INT16_C( 12866),  INT16_C( 29936),  INT16_C(   750),  INT16_C( 17058),
        -INT16_C( 13718), -INT16_C( 25075), -INT16_C(  4410), -INT16_C(  7403), -INT16_C(  1750),  INT16_C( 22969),  INT16_C(  8194),  INT16_C( 30989),
        -INT16_C(  1962), -INT16_C( 30645),  INT16_C( 19789), -INT16_C( 28854),  INT16_C( 15231),  INT16_C( 27908), -INT16_C( 22979), -INT16_C( 22352),
        -INT16_C( 17040),  INT16_C( 13894),  INT16_C( 23723), -INT16_C( 10726), -INT16_C( 11435),  INT16_C( 22575),  INT16_C( 15859),  INT16_C( 18897) },
      { -INT16_C(  5739),  INT16_C(  4659), -INT16_C(  9304), -INT16_C(  2515),  INT16_C(  9731),  INT16_C( 30321),  INT16_C( 25734),  INT16_C( 31299),
              INT16_MIN, -INT16_C( 26781), -INT16_C( 17603), -INT16_C( 32527),  INT16_C(  6765),  INT16_C(  1236), -INT16_C( 16419),  INT16_C(  2354),
        -INT16_C( 19544), -INT16_C( 16614),  INT16_C( 18856), -INT16_C( 28164),  INT16_C( 10255), -INT16_C(  4700), -INT16_C(  6269), -INT16_C( 10558),
         INT16_C(  2348), -INT16_C( 29756), -INT16_C( 19130),  INT16_C( 19962),  INT16_C(  3954),  INT16_C( 12051),  INT16_C( 30622), -INT16_C(   457) } },
    { {  INT16_C(  7477), -INT16_C( 32047),  INT16_C(  7274), -INT16_C(  5870),  INT16_C(  5719), -INT16_C( 27562),  INT16_C(  1724),  INT16_C( 11580),
        -INT16_C( 31804),  INT16_C( 28515),  INT16_C( 32223),  INT16_C( 13381),  INT16_C( 30033),  INT16_C( 17548),  INT16_C( 24242), -INT16_C(  6258),
         INT16_C( 24443), -INT16_C(  6807),  INT16_C( 31611), -INT16_C( 11570),  INT16_C(  9361),  INT16_C( 20071), -INT16_C( 23765), -INT16_C(  4229),
        -INT16_C(  8666),  INT16_C(  1374), -INT16_C( 23460), -INT16_C( 21190), -INT16_C( 14823), -INT16_C( 13327),  INT16_C( 32548), -INT16_C( 24654) },
      UINT32_C(1518607327),
      {  INT16_C( 21143),  INT16_C( 10285), -INT16_C( 27529), -INT16_C( 23946), -INT16_C(  3785),  INT16_C( 24209), -INT16_C(  4144),  INT16_C( 11363),
        -INT16_C( 25197), -INT16_C( 21287), -INT16_C( 13724), -INT16_C( 30601),  INT16_C( 10570),  INT16_C( 10536), -INT16_C( 21435), -INT16_C(  9085),
        -INT16_C( 20225),  INT16_C( 30212),  INT16_C( 31556),  INT16_C( 31768), -INT16_C( 22164),  INT16_C( 15578),  INT16_C( 15768),  INT16_C( 11368),
         INT16_C( 16859),  INT16_C( 16344),  INT16_C( 20492),  INT16_C( 22215), -INT16_C(  4231), -INT16_C( 16769),  INT16_C(   668), -INT16_C( 25702) },
      { -INT16_C( 24653), -INT16_C(  2287),  INT16_C( 10522), -INT16_C( 31117),  INT16_C( 19922),  INT16_C( 27331),  INT16_C( 11147),  INT16_C( 26262),
         INT16_C( 28525),  INT16_C( 31141),  INT16_C( 27839),  INT16_C( 14543),  INT16_C( 20060), -INT16_C(  1801), -INT16_C( 28336),  INT16_C(   915),
        -INT16_C( 23504),  INT16_C( 19195),  INT16_C( 28365), -INT16_C( 24623), -INT16_C( 27460),  INT16_C( 18185), -INT16_C( 24385),  INT16_C( 11437),
         INT16_C( 21007), -INT16_C( 12635),  INT16_C( 29886),  INT16_C(  6662), -INT16_C(   574),  INT16_C(  4882), -INT16_C( 23153), -INT16_C( 16618) },
      { -INT16_C(  3510),  INT16_C(  7998), -INT16_C( 17007),       INT16_MIN,  INT16_C( 16137), -INT16_C( 27562),  INT16_C(  7003),       INT16_MAX,
         INT16_C(  3328),  INT16_C(  9854),  INT16_C( 32223), -INT16_C( 16058),  INT16_C( 30630),  INT16_C( 17548),  INT16_C( 24242), -INT16_C(  6258),
         INT16_C( 24443), -INT16_C(  6807),       INT16_MAX, -INT16_C( 11570),  INT16_C(  9361),  INT16_C( 20071), -INT16_C( 23765),  INT16_C( 22805),
        -INT16_C(  8666),  INT16_C(  3709), -INT16_C( 23460),  INT16_C( 28877), -INT16_C(  4805), -INT16_C( 13327), -INT16_C( 22485), -INT16_C( 24654) } },
    { {  INT16_C(  4425),  INT16_C(  5642), -INT16_C(  9344),  INT16_C( 15541), -INT16_C( 16529),  INT16_C( 11907),  INT16_C( 12383),  INT16_C( 28251),
         INT16_C(   130),  INT16_C( 16444),  INT16_C( 17013),  INT16_C( 14171),  INT16_C( 27968), -INT16_C( 12470),  INT16_C( 24851),  INT16_C( 23694),
        -INT16_C( 26510), -INT16_C(  3469),  INT16_C( 10355), -INT16_C(  7634), -INT16_C( 19993),  INT16_C( 17937),  INT16_C( 27873),  INT16_C( 25524),
        -INT16_C(  3988), -INT16_C(  7772), -INT16_C(   205),  INT16_C( 29465),  INT16_C( 25452),  INT16_C( 32578), -INT16_C( 12092),  INT16_C( 14300) },
      UINT32_C(3693694825),
      {  INT16_C( 22647),  INT16_C( 24511), -INT16_C( 12279), -INT16_C(  5211),  INT16_C( 23100), -INT16_C( 22450), -INT16_C(  3510),  INT16_C( 32138),
        -INT16_C( 23567),  INT16_C( 24304),  INT16_C( 12806), -INT16_C( 13347), -INT16_C( 18173),  INT16_C( 27650),  INT16_C( 11016), -INT16_C( 32696),
         INT16_C(  1923), -INT16_C( 29217), -INT16_C( 31529),  INT16_C(  4984), -INT16_C( 14626),  INT16_C( 10684),  INT16_C( 18105), -INT16_C( 21850),
        -INT16_C( 26647), -INT16_C(  4344), -INT16_C(  6455), -INT16_C( 13126), -INT16_C( 17249), -INT16_C( 22472), -INT16_C( 32280),  INT16_C( 27432) },
      {  INT16_C(  1928),  INT16_C( 24824),  INT16_C( 28811),  INT16_C( 27251),  INT16_C( 12087), -INT16_C(  3949),  INT16_C( 14709),  INT16_C( 24218),
        -INT16_C( 23600), -INT16_C( 26034),  INT16_C(  2185),  INT16_C( 10342), -INT16_C( 24635), -INT16_C( 21040), -INT16_C(  2016), -INT16_C( 22504),
         INT16_C(  4607), -INT16_C( 29944),  INT16_C( 31873), -INT16_C( 18187), -INT16_C( 30549),  INT16_C(  8616),  INT16_C( 17345), -INT16_C( 28033),
        -INT16_C( 12826),  INT16_C( 28460), -INT16_C( 27946), -INT16_C( 25705),  INT16_C( 26673),  INT16_C( 20808),  INT16_C( 24672),  INT16_C( 24826) },
      {  INT16_C( 24575),  INT16_C(  5642), -INT16_C(  9344),  INT16_C( 22040), -INT16_C( 16529), -INT16_C( 26399),  INT16_C( 11199),  INT16_C( 28251),
              INT16_MIN, -INT16_C(  1730),  INT16_C( 14991), -INT16_C(  3005),  INT16_C( 27968), -INT16_C( 12470),  INT16_C(  9000),  INT16_C( 23694),
         INT16_C(  6530), -INT16_C(  3469),  INT16_C( 10355), -INT16_C( 13203), -INT16_C( 19993),  INT16_C( 19300),  INT16_C( 27873),  INT16_C( 25524),
        -INT16_C(  3988), -INT16_C(  7772),       INT16_MIN,       INT16_MIN,  INT16_C(  9424),  INT16_C( 32578), -INT16_C(  7608),       INT16_MAX } },
    { {  INT16_C(   625), -INT16_C(  3093), -INT16_C(  8066),  INT16_C( 10923),  INT16_C( 21608),  INT16_C( 10571), -INT16_C( 13673),  INT16_C( 32187),
        -INT16_C(  6248),  INT16_C( 28396), -INT16_C( 31878), -INT16_C( 21751),  INT16_C( 20971),  INT16_C( 19709), -INT16_C(  2127),  INT16_C(  9132),
        -INT16_C( 26631),  INT16_C( 30742), -INT16_C( 16009), -INT16_C(  8286), -INT16_C(  4843), -INT16_C( 21496), -INT16_C( 15177),  INT16_C( 20265),
         INT16_C(  5547),  INT16_C(  9661), -INT16_C( 14695), -INT16_C( 31535), -INT16_C( 12777), -INT16_C( 13872),  INT16_C( 31941), -INT16_C( 16660) },
      UINT32_C(2318795283),
      { -INT16_C( 10045), -INT16_C(  9879),  INT16_C( 29381),  INT16_C( 32133), -INT16_C( 20682), -INT16_C(  7732), -INT16_C( 30012),  INT16_C( 23815),
        -INT16_C( 10160),  INT16_C( 26850), -INT16_C( 19802),  INT16_C( 27441),  INT16_C(  7471),  INT16_C( 16937),  INT16_C( 24607), -INT16_C(  7475),
         INT16_C( 13880), -INT16_C(   325),  INT16_C( 16808), -INT16_C(  8581),  INT16_C( 18416), -INT16_C( 19264), -INT16_C( 14383),  INT16_C(  8722),
        -INT16_C(  2913),  INT16_C( 17802), -INT16_C( 17498), -INT16_C( 10832), -INT16_C(  9768), -INT16_C(  2280), -INT16_C(  6855),  INT16_C( 29401) },
      { -INT16_C( 27365), -INT16_C( 15248), -INT16_C(  5162), -INT16_C( 14686),  INT16_C( 25138),  INT16_C(  1146), -INT16_C( 29655), -INT16_C( 14298),
        -INT16_C( 20352),  INT16_C(  9997), -INT16_C( 17045),  INT16_C( 17404),  INT16_C(  5271), -INT16_C( 12230),  INT16_C(  5113),  INT16_C(  5442),
        -INT16_C( 19800),  INT16_C( 32473),  INT16_C( 31645), -INT16_C( 12220), -INT16_C( 16418),  INT16_C(  2004), -INT16_C(  1461), -INT16_C( 13104),
        -INT16_C(  8790),  INT16_C(  5619), -INT16_C(  4197),  INT16_C( 12888), -INT16_C( 28156), -INT16_C(   766),  INT16_C( 17829),  INT16_C( 19986) },
      {       INT16_MIN, -INT16_C( 25127), -INT16_C(  8066),  INT16_C( 10923),  INT16_C(  4456),  INT16_C( 10571), -INT16_C( 13673),  INT16_C( 32187),
        -INT16_C(  6248),       INT16_MAX, -INT16_C( 31878), -INT16_C( 21751),  INT16_C( 20971),  INT16_C( 19709), -INT16_C(  2127),  INT16_C(  9132),
        -INT16_C( 26631),  INT16_C( 32148),       INT16_MAX, -INT16_C(  8286),  INT16_C(  1998), -INT16_C( 17260), -INT16_C( 15177),  INT16_C( 20265),
         INT16_C(  5547),  INT16_C( 23421), -INT16_C( 14695),  INT16_C(  2056), -INT16_C( 12777), -INT16_C( 13872),  INT16_C( 31941),       INT16_MAX } },
    { { -INT16_C(  5129), -INT16_C( 27188),  INT16_C(  4455),  INT16_C( 17765),  INT16_C( 14800),  INT16_C(  6988),  INT16_C(  7219), -INT16_C(  8729),
        -INT16_C(  9478), -INT16_C( 27150),  INT16_C( 19146), -INT16_C( 12601), -INT16_C( 13860), -INT16_C( 32309), -INT16_C(  8690),  INT16_C(  1743),
        -INT16_C( 25399),  INT16_C( 12443),  INT16_C(   173),  INT16_C( 32117), -INT16_C( 15815),  INT16_C( 27800), -INT16_C( 32546), -INT16_C( 10167),
         INT16_C( 15194),  INT16_C(  9325),  INT16_C( 13445),  INT16_C( 25074), -INT16_C( 16642),  INT16_C(  3298), -INT16_C( 19812),  INT16_C( 25874) },
      UINT32_C(4220955982),
      {  INT16_C(  2989), -INT16_C(  6536),  INT16_C(  4301), -INT16_C( 21422), -INT16_C( 25712), -INT16_C(  5244), -INT16_C(  3370),  INT16_C( 23311),
         INT16_C(   550),  INT16_C(  9404), -INT16_C( 24640),  INT16_C( 23601),  INT16_C( 17233), -INT16_C( 24639),  INT16_C( 22513), -INT16_C( 24934),
         INT16_C(  4707),  INT16_C( 12421), -INT16_C( 10462), -INT16_C( 19492),  INT16_C( 24947),  INT16_C( 18846), -INT16_C( 21165),  INT16_C( 31141),
         INT16_C( 25007),  INT16_C( 28574), -INT16_C( 12544),  INT16_C( 20939), -INT16_C( 29422),  INT16_C(  1008), -INT16_C( 29980),  INT16_C( 18338) },
      {  INT16_C( 10140), -INT16_C( 16520),  INT16_C( 21758),  INT16_C( 29042),  INT16_C(  4277),  INT16_C(  2235),  INT16_C( 24765),  INT16_C( 28034),
         INT16_C(  8385), -INT16_C( 15652), -INT16_C( 22289),  INT16_C(   275),  INT16_C(  1077),  INT16_C(  6405), -INT16_C( 22642),  INT16_C( 11105),
        -INT16_C(  9778), -INT16_C( 13078),  INT16_C( 23597), -INT16_C(  7362), -INT16_C(  1684),  INT16_C( 10731),  INT16_C( 27993),  INT16_C(  6806),
         INT16_C( 29581),  INT16_C( 31964), -INT16_C(  4069),  INT16_C( 20606), -INT16_C( 31756), -INT16_C( 32151), -INT16_C( 13782), -INT16_C(  1875) },
      { -INT16_C(  5129), -INT16_C( 23056),  INT16_C( 26059),  INT16_C(  7620),  INT16_C( 14800),  INT16_C(  6988),  INT16_C( 21395), -INT16_C(  8729),
         INT16_C(  8935), -INT16_C( 27150),       INT16_MIN,  INT16_C( 23876), -INT16_C( 13860), -INT16_C( 18234), -INT16_C(  8690), -INT16_C( 13829),
        -INT16_C( 25399), -INT16_C(   657),  INT16_C( 13135),  INT16_C( 32117),  INT16_C( 23263),  INT16_C( 27800), -INT16_C( 32546),       INT16_MAX,
              INT16_MAX,       INT16_MAX,  INT16_C( 13445),       INT16_MAX,       INT16_MIN, -INT16_C( 31143),       INT16_MIN,  INT16_C( 16463) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i src = simde_mm512_loadu_epi16(test_vec[i].src);
    simde__m512i a = simde_mm512_loadu_epi16(test_vec[i].a);
    simde__m512i b = simde_mm512_loadu_epi16(test_vec[i].b);
    simde__m512i r = simde_mm512_mask_adds_epi16(src, test_vec[i].k, a, b);
    simde_test_x86_assert_equal_i16x32(r, simde_mm512_loadu_epi16(test_vec[i].r));
  }

  return 0;
}

static int
test_simde_mm512_maskz_adds_epi16 (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const simde__mmask32 k;
    const int16_t a[32];
    const int16_t b[32];
    const int16_t r[32];
  } test_vec[] = {
    { UINT32_C(1382488990),
      {  INT16_C( 13382), -INT16_C(  1131), -INT16_C(  8449),  INT16_C(  8490),  INT16_C( 27735),  INT16_C( 28052), -INT16_C( 21201),  INT16_C( 29768),
         INT16_C( 19795), -INT16_C( 30934), -INT16_C( 32642),  INT16_C( 22005),  INT16_C(  9346),  INT16_C(  8543), -INT16_C( 14529), -INT16_C( 31373),
         INT16_C(  2299), -INT16_C(  1408), -INT16_C( 21530),  INT16_C( 15643), -INT16_C( 20713),  INT16_C( 18091), -INT16_C(  3236), -INT16_C( 20549),
        -INT16_C(  6847), -INT16_C( 16586),  INT16_C( 11109), -INT16_C(  6124),  INT16_C( 29776), -INT16_C( 28919),  INT16_C( 31803),  INT16_C( 13845) },
      { -INT16_C( 27260),  INT16_C( 27184),  INT16_C( 19264),  INT16_C( 22695),  INT16_C( 21242),  INT16_C( 22174),  INT16_C( 22854), -INT16_C( 30971),
         INT16_C( 15423), -INT16_C( 23482),  INT16_C( 23399), -INT16_C( 18548), -INT16_C( 27185),  INT16_C(  2631),  INT16_C( 23569), -INT16_C( 27328),
         INT16_C( 28913),  INT16_C( 13055), -INT16_C( 22597), -INT16_C( 19062),  INT16_C( 10489),  INT16_C( 16139),  INT16_C(  4226), -INT16_C( 15930),
         INT16_C(  3404), -INT16_C( 19355), -INT16_C(  3480),  INT16_C( 14187), -INT16_C( 19833), -INT16_C( 26303), -INT16_C( 32498),  INT16_C(    46) },
      {  INT16_C(     0),  INT16_C( 26053),  INT16_C( 10815),  INT16_C( 31185),       INT16_MAX,  INT16_C(     0),  INT16_C(     0), -INT16_C(  1203),
              INT16_MAX,       INT16_MIN,  INT16_C(     0),  INT16_C(  3457), -INT16_C( 17839),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),
         INT16_C( 31212),  INT16_C( 11647),       INT16_MIN,  INT16_C(     0),  INT16_C(     0),       INT16_MAX,  INT16_C(   990),  INT16_C(     0),
         INT16_C(     0),       INT16_MIN,  INT16_C(     0),  INT16_C(     0),  INT16_C(  9943),  INT16_C(     0), -INT16_C(   695),  INT16_C(     0) } },
    { UINT32_C(2888969969),
      { -INT16_C( 17195), -INT16_C( 12703),  INT16_C( 27876),  INT16_C( 26126), -INT16_C( 11140), -INT16_C( 14041), -INT16_C( 29215),  INT16_C( 18813),
        -INT16_C(  6017),  INT16_C(  1664), -INT16_C( 15973), -INT16_C( 22113), -INT16_C( 12734),  INT16_C( 13225), -INT16_C(  9220), -INT16_C( 11809),
         INT16_C( 16535),  INT16_C( 31903), -INT16_C( 21076),  INT16_C( 10722),  INT16_C(  2690),  INT16_C( 25586),  INT16_C( 28567),  INT16_C(  5805),
         INT16_C( 11607), -INT16_C(  3556), -INT16_C( 17169),  INT16_C( 12700),  INT16_C( 17802), -INT16_C( 31131),  INT16_C( 17441), -INT16_C( 18345) },
      { -INT16_C(  2427),  INT16_C( 12596),  INT16_C(  6052),  INT16_C(  9818),  INT16_C( 19489), -INT16_C( 18295),  INT16_C( 14011),  INT16_C(  5070),
        -INT16_C(  5532),  INT16_C( 21253), -INT16_C( 24154),  INT16_C( 12420), -INT16_C(  5657),  INT16_C(  2230),  INT16_C(  3374), -INT16_C( 19520),
        -INT16_C(  2812), -INT16_C( 22300),  INT16_C( 16140),  INT16_C( 11726),  INT16_C( 22411),  INT16_C( 18405), -INT16_C( 19570), -INT16_C(  3494),
         INT16_C( 24477),  INT16_C( 17477), -INT16_C( 14079), -INT16_C(  6028),  INT16_C( 11187), -INT16_C(  7696), -INT16_C( 20424),  INT16_C( 15508) },
      { -INT16_C( 19622),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(  8349), -INT16_C( 32336), -INT16_C( 15204),  INT16_C( 23883),
         INT16_C(     0),  INT16_C( 22917),       INT16_MIN, -INT16_C(  9693),  INT16_C(     0),  INT16_C( 15455),  INT16_C(     0),  INT16_C(     0),
         INT16_C(     0),  INT16_C(  9603),  INT16_C(     0),  INT16_C(     0),  INT16_C( 25101),       INT16_MAX,  INT16_C(     0),  INT16_C(     0),
         INT16_C(     0),  INT16_C(     0), -INT16_C( 31248),  INT16_C(  6672),  INT16_C(     0),       INT16_MIN,  INT16_C(     0), -INT16_C(  2837) } },
    { UINT32_C(2984540325),
      { -INT16_C( 19785),  INT16_C( 17374), -INT16_C( 15606), -INT16_C( 26486), -INT16_C(  7050),  INT16_C(  5258), -INT16_C( 12477),  INT16_C( 17496),
        -INT16_C( 13160),  INT16_C( 19244),  INT16_C(  7415),  INT16_C( 12332), -INT16_C( 16179),  INT16_C( 29292),  INT16_C( 20793), -INT16_C(  4060),
         INT16_C(   515),  INT16_C(  3379), -INT16_C( 16954),  INT16_C( 15525),  INT16_C( 12193), -INT16_C(  6832), -INT16_C( 22274), -INT16_C( 26839),
         INT16_C( 22133),  INT16_C( 27874),  INT16_C(  3954),  INT16_C( 16284),  INT16_C(  2511),  INT16_C(  2226), -INT16_C( 10662),  INT16_C( 24057) },
      {  INT16_C( 11480), -INT16_C( 24981),  INT16_C(  4330), -INT16_C( 29733),  INT16_C( 11072),  INT16_C( 15984), -INT16_C( 25900),  INT16_C( 18901),
        -INT16_C( 18192),  INT16_C( 25269),  INT16_C( 21191), -INT16_C( 26974),  INT16_C( 21595), -INT16_C( 19041), -INT16_C( 26582),  INT16_C(   530),
         INT16_C( 32196), -INT16_C( 20831),  INT16_C( 31886), -INT16_C( 12742), -INT16_C( 21849),  INT16_C( 31500), -INT16_C(  7612),  INT16_C( 13508),
         INT16_C( 31386),  INT16_C( 24983),  INT16_C( 14796),  INT16_C( 10231), -INT16_C( 26995), -INT16_C( 18468), -INT16_C(  4562), -INT16_C(  3143) },
      { -INT16_C(  8305),  INT16_C(     0), -INT16_C( 11276),  INT16_C(     0),  INT16_C(     0),  INT16_C( 21242),  INT16_C(     0),       INT16_MAX,
         INT16_C(     0),  INT16_C(     0),  INT16_C(     0), -INT16_C( 14642),  INT16_C(  5416),  INT16_C( 10251), -INT16_C(  5789),  INT16_C(     0),
         INT16_C(     0),  INT16_C(     0),  INT16_C( 14932),  INT16_C(     0),  INT16_C(     0),  INT16_C( 24668), -INT16_C( 29886), -INT16_C( 13331),
              INT16_MAX,  INT16_C(     0),  INT16_C(     0),  INT16_C(     0), -INT16_C( 24484), -INT16_C( 16242),  INT16_C(     0),  INT16_C( 20914) } },
    { UINT32_C(4204878444),
      { -INT16_C(  9258),  INT16_C( 32456), -INT16_C( 11130), -INT16_C( 13575), -INT16_C( 16714),  INT16_C( 20735), -INT16_C( 27080),  INT16_C(  1201),
        -INT16_C( 22065),  INT16_C( 23595),  INT16_C(  1855),  INT16_C( 28179), -INT16_C( 13067),  INT16_C( 24929),  INT16_C(   551), -INT16_C(   677),
         INT16_C(  9182),  INT16_C( 25723),  INT16_C( 30200), -INT16_C( 20946),  INT16_C( 11571),  INT16_C( 27647), -INT16_C( 20285), -INT16_C( 28049),
        -INT16_C( 26023), -INT16_C( 26130),  INT16_C(   417), -INT16_C( 27129),  INT16_C( 26830), -INT16_C(  2568),  INT16_C( 21354),  INT16_C( 18674) },
      {  INT16_C( 28279),  INT16_C( 28588), -INT16_C(  9245),  INT16_C(  5661),  INT16_C(  7176), -INT16_C( 13183), -INT16_C(  3891),  INT16_C(  9822),
         INT16_C( 19850),  INT16_C( 11199), -INT16_C( 14770),  INT16_C(  7361), -INT16_C( 18130), -INT16_C( 26351),  INT16_C(  1037), -INT16_C( 31519),
        -INT16_C( 29070),  INT16_C( 22003),  INT16_C(  4201),  INT16_C( 29035), -INT16_C(  5075), -INT16_C(  1475), -INT16_C( 25380),  INT16_C( 26144),
        -INT16_C(  7959),  INT16_C( 14225),  INT16_C( 21158), -INT16_C( 10924),  INT16_C( 25868),  INT16_C(  6510),  INT16_C( 20329), -INT16_C(  9315) },
      {  INT16_C(     0),  INT16_C(     0), -INT16_C( 20375), -INT16_C(  7914),  INT16_C(     0),  INT16_C(  7552), -INT16_C( 30971),  INT16_C(     0),
         INT16_C(     0),       INT16_MAX,  INT16_C(     0),       INT16_MAX, -INT16_C( 31197),  INT16_C(     0),  INT16_C(  1588),  INT16_C(     0),
        -INT16_C( 19888),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C( 26172),  INT16_C(     0), -INT16_C(  1905),
         INT16_C(     0), -INT16_C( 11905),  INT16_C(     0),       INT16_MIN,       INT16_MAX,  INT16_C(  3942),       INT16_MAX,  INT16_C(  9359) } },
    { UINT32_C(1177587933),
      { -INT16_C( 25696), -INT16_C( 12872), -INT16_C(  2681),  INT16_C( 25543), -INT16_C(  5999),  INT16_C( 31433),  INT16_C( 23240),  INT16_C( 28338),
         INT16_C(  1709), -INT16_C( 18109), -INT16_C( 20117), -INT16_C( 10798),  INT16_C( 28417), -INT16_C(  8528), -INT16_C(  7681), -INT16_C( 24795),
        -INT16_C(  8836),  INT16_C(  1133),  INT16_C( 13522),  INT16_C( 25703),  INT16_C( 12572), -INT16_C(  6946), -INT16_C( 28533),  INT16_C( 14419),
        -INT16_C( 26986),  INT16_C(   753), -INT16_C( 15544),  INT16_C( 18903), -INT16_C( 30926),  INT16_C( 12583),  INT16_C( 19560), -INT16_C(  6703) },
      {  INT16_C( 15913), -INT16_C(   791),  INT16_C( 20594), -INT16_C( 28832),  INT16_C( 16001),  INT16_C(  3443), -INT16_C( 14641),  INT16_C( 25925),
         INT16_C( 14173), -INT16_C( 23193),  INT16_C( 16122),  INT16_C( 11758),  INT16_C(  5574),  INT16_C( 11870),  INT16_C( 12130), -INT16_C( 29933),
        -INT16_C(   915), -INT16_C(  8057), -INT16_C(  6323), -INT16_C( 12689), -INT16_C(  7642), -INT16_C(  2597),  INT16_C(  8617),  INT16_C(  1626),
        -INT16_C( 15784),  INT16_C( 21163), -INT16_C( 26368), -INT16_C( 14721), -INT16_C(  8530),  INT16_C(  4341),  INT16_C(  2061),  INT16_C( 31644) },
      { -INT16_C(  9783),  INT16_C(     0),  INT16_C( 17913), -INT16_C(  3289),  INT16_C( 10002),  INT16_C(     0),  INT16_C(  8599),       INT16_MAX,
         INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),       INT16_MAX,  INT16_C(     0),  INT16_C(     0),       INT16_MIN,
         INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(  4930), -INT16_C(  9543),  INT16_C(     0),  INT16_C(     0),
         INT16_C(     0),  INT16_C( 21916),       INT16_MIN,  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C( 21621),  INT16_C(     0) } },
    { UINT32_C(1381704453),
      { -INT16_C( 13813),  INT16_C( 12576), -INT16_C(   852),  INT16_C( 21798), -INT16_C( 32739),  INT16_C( 30043),  INT16_C(  1602),  INT16_C( 17351),
         INT16_C( 18335),  INT16_C( 19977), -INT16_C(   475),  INT16_C( 12894), -INT16_C(  1529),  INT16_C(  3245),  INT16_C(  2078),  INT16_C( 10590),
         INT16_C( 32466),  INT16_C( 32602), -INT16_C( 32646), -INT16_C( 26668),  INT16_C( 12288),  INT16_C( 17164), -INT16_C( 11210), -INT16_C( 10618),
        -INT16_C( 28901),  INT16_C( 16420), -INT16_C( 32114), -INT16_C( 27278),  INT16_C(  8317), -INT16_C( 25695), -INT16_C(   216), -INT16_C(  1084) },
      {  INT16_C(  7805), -INT16_C(  1926),  INT16_C( 20126), -INT16_C( 24945), -INT16_C( 25474), -INT16_C( 18975),  INT16_C( 26480), -INT16_C( 29813),
        -INT16_C( 20489), -INT16_C( 31285),  INT16_C( 15665), -INT16_C( 20966), -INT16_C( 17571), -INT16_C( 31159),  INT16_C(  3514),  INT16_C( 14209),
        -INT16_C(  1237), -INT16_C( 14033), -INT16_C( 16567), -INT16_C( 14232),  INT16_C( 18779), -INT16_C( 13443),  INT16_C(  2225), -INT16_C( 22442),
         INT16_C(  8631), -INT16_C(  6099),  INT16_C( 18270), -INT16_C( 17257), -INT16_C(  8190), -INT16_C( 17342), -INT16_C( 15378),  INT16_C(  6643) },
      { -INT16_C(  6008),  INT16_C(     0),  INT16_C( 19274),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),
        -INT16_C(  2154), -INT16_C( 11308),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0), -INT16_C( 27914),  INT16_C(     0),  INT16_C(     0),
         INT16_C( 31229),  INT16_C( 18569),  INT16_C(     0),       INT16_MIN,  INT16_C( 31067),  INT16_C(     0), -INT16_C(  8985),  INT16_C(     0),
         INT16_C(     0),  INT16_C( 10321),  INT16_C(     0),  INT16_C(     0),  INT16_C(   127),  INT16_C(     0), -INT16_C( 15594),  INT16_C(     0) } },
    { UINT32_C( 132326334),
      {  INT16_C( 19426),  INT16_C( 15823),  INT16_C( 19604),  INT16_C( 17672),  INT16_C( 24148),  INT16_C(  3053),  INT16_C(  6783), -INT16_C(  8716),
        -INT16_C( 29855),  INT16_C( 25497), -INT16_C(  9365),  INT16_C( 22815),  INT16_C(  5022),  INT16_C( 23667),  INT16_C( 22070),  INT16_C(  6244),
         INT16_C( 13217),  INT16_C( 13653),  INT16_C( 23936), -INT16_C( 11141),  INT16_C( 26811),  INT16_C( 15072), -INT16_C( 11133), -INT16_C(  7145),
        -INT16_C( 20129), -INT16_C( 13752),  INT16_C( 26508),  INT16_C( 11044), -INT16_C( 26758), -INT16_C( 20345), -INT16_C(  5139), -INT16_C( 28984) },
      {  INT16_C(  7455), -INT16_C( 24637),  INT16_C( 15994),  INT16_C( 13683),  INT16_C( 21415),  INT16_C( 10863), -INT16_C( 30937), -INT16_C( 31218),
         INT16_C( 22072), -INT16_C( 15279),  INT16_C( 30142),  INT16_C( 14575),  INT16_C( 30476), -INT16_C(  1559), -INT16_C( 20126), -INT16_C( 32377),
         INT16_C( 19151),  INT16_C( 18720), -INT16_C( 27511),  INT16_C( 12415), -INT16_C(  4377),  INT16_C(  3930),  INT16_C( 26741), -INT16_C( 21099),
        -INT16_C(  6465),  INT16_C( 32114),  INT16_C( 24923),  INT16_C( 26549), -INT16_C( 24872),  INT16_C( 15200), -INT16_C(  6320),  INT16_C(  8124) },
      {  INT16_C(     0), -INT16_C(  8814),       INT16_MAX,  INT16_C( 31355),       INT16_MAX,  INT16_C( 13916),  INT16_C(     0),       INT16_MIN,
        -INT16_C(  7783),  INT16_C( 10218),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C( 22108),  INT16_C(     0),  INT16_C(     0),
         INT16_C( 32368),  INT16_C( 32373),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C( 19002),  INT16_C( 15608), -INT16_C( 28244),
        -INT16_C( 26594),  INT16_C( 18362),       INT16_MAX,  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0) } },
    { UINT32_C(3144211762),
      { -INT16_C(  6287),  INT16_C( 22763),  INT16_C( 17878),  INT16_C( 19303), -INT16_C(   595),  INT16_C( 27897),  INT16_C( 27619),  INT16_C( 16361),
        -INT16_C( 24628), -INT16_C( 23130),  INT16_C(  1853), -INT16_C( 29216), -INT16_C( 25362),  INT16_C(  8364),  INT16_C(  5497), -INT16_C(  5413),
        -INT16_C( 14596), -INT16_C( 11709), -INT16_C( 22005), -INT16_C( 18146),  INT16_C(  6055), -INT16_C( 29915),  INT16_C(  3970),  INT16_C( 20170),
         INT16_C( 28846), -INT16_C(  5133), -INT16_C( 11401),  INT16_C( 26233),  INT16_C(  9584), -INT16_C(  5754),  INT16_C( 25146),  INT16_C( 14292) },
      {  INT16_C(  5928),  INT16_C( 13321),  INT16_C( 10177),  INT16_C( 27117),  INT16_C(  4670), -INT16_C( 16140), -INT16_C( 16863), -INT16_C( 12529),
         INT16_C(   558), -INT16_C( 22853),  INT16_C( 13526),  INT16_C( 17932), -INT16_C( 28071), -INT16_C( 27601),  INT16_C(  1012),  INT16_C(  7627),
        -INT16_C( 11238), -INT16_C(  9135),  INT16_C( 16124),  INT16_C( 14917),  INT16_C( 14672),  INT16_C( 29435),  INT16_C(  2807),  INT16_C(  9537),
        -INT16_C(  1012), -INT16_C(  7477), -INT16_C( 10448), -INT16_C( 30168),  INT16_C( 22634),  INT16_C( 24094), -INT16_C(  5797),  INT16_C( 30331) },
      {  INT16_C(     0),       INT16_MAX,  INT16_C(     0),  INT16_C(     0),  INT16_C(  4075),  INT16_C( 11757),  INT16_C(     0),  INT16_C(     0),
        -INT16_C( 24070),  INT16_C(     0),  INT16_C( 15379), -INT16_C( 11284),       INT16_MIN,  INT16_C(     0),  INT16_C(  6509),  INT16_C(  2214),
         INT16_C(     0),  INT16_C(     0),  INT16_C(     0), -INT16_C(  3229),  INT16_C(     0), -INT16_C(   480),  INT16_C(  6777),  INT16_C(     0),
         INT16_C( 27834), -INT16_C( 12610),  INT16_C(     0), -INT16_C(  3935),  INT16_C( 32218),  INT16_C( 18340),  INT16_C(     0),       INT16_MAX } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i a = simde_mm512_loadu_epi16(test_vec[i].a);
    simde__m512i b = simde_mm512_loadu_epi16(test_vec[i].b);
    simde__m512i r = simde_mm512_maskz_adds_epi16(test_vec[i].k, a, b);
    simde_test_x86_assert_equal_i16x32(r, simde_mm512_loadu_epi16(test_vec[i].r));
  }

  return 0;
}

static int
test_simde_mm512_adds_epu8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C( 52), UINT8_C( 29), UINT8_C( 31), UINT8_C(206),
                             UINT8_C( 40), UINT8_C(160), UINT8_C(244), UINT8_C( 85),
                             UINT8_C( 47), UINT8_C(153), UINT8_C(218), UINT8_C(226),
                             UINT8_C( 99), UINT8_C(129), UINT8_C( 68), UINT8_C(218),
                             UINT8_C(122), UINT8_C( 56), UINT8_C(240), UINT8_C( 10),
                             UINT8_C(228), UINT8_C( 40), UINT8_C( 70), UINT8_C( 14),
                             UINT8_C( 67), UINT8_C( 37), UINT8_C( 87), UINT8_C(131),
                             UINT8_C( 29), UINT8_C(175), UINT8_C(167), UINT8_C(223),
                             UINT8_C(170), UINT8_C( 76), UINT8_C( 39), UINT8_C(254),
                             UINT8_C(222), UINT8_C(105), UINT8_C(193), UINT8_C(144),
                             UINT8_C(182), UINT8_C(106), UINT8_C(199), UINT8_C(161),
                             UINT8_C(173), UINT8_C( 65), UINT8_C( 54), UINT8_C(148),
                             UINT8_C(222), UINT8_C(  9), UINT8_C(237), UINT8_C( 76),
                             UINT8_C(149), UINT8_C(196), UINT8_C(194), UINT8_C(114),
                             UINT8_C(167), UINT8_C( 47), UINT8_C(174), UINT8_C(135),
                             UINT8_C(170), UINT8_C(  1), UINT8_C( 40), UINT8_C( 68)),
      simde_x_mm512_set_epu8(UINT8_C(183), UINT8_C(129), UINT8_C(214), UINT8_C( 34),
                             UINT8_C(187), UINT8_C(142), UINT8_C(238), UINT8_C(248),
                             UINT8_C(175), UINT8_C(127), UINT8_C(231), UINT8_C(164),
                             UINT8_C( 16), UINT8_C(128), UINT8_C( 32), UINT8_C( 28),
                             UINT8_C(111), UINT8_C( 40), UINT8_C(  8), UINT8_C(160),
                             UINT8_C( 37), UINT8_C(193), UINT8_C(195), UINT8_C(135),
                             UINT8_C(102), UINT8_C( 87), UINT8_C(146), UINT8_C(206),
                             UINT8_C( 94), UINT8_C(109), UINT8_C(112), UINT8_C( 83),
                             UINT8_C( 63), UINT8_C(215), UINT8_C( 46), UINT8_C( 55),
                             UINT8_C( 78), UINT8_C(211), UINT8_C(175), UINT8_C(210),
                             UINT8_C( 60), UINT8_C(205), UINT8_C(118), UINT8_C(142),
                             UINT8_C(109), UINT8_C( 48), UINT8_C( 54), UINT8_C( 54),
                             UINT8_C( 99), UINT8_C(248), UINT8_C(120), UINT8_C(165),
                             UINT8_C(189), UINT8_C(132), UINT8_C(130), UINT8_C( 16),
                             UINT8_C(  6), UINT8_C(104), UINT8_C(176), UINT8_C(111),
                             UINT8_C(254), UINT8_C(193), UINT8_C(106), UINT8_C(  5)),
      simde_x_mm512_set_epu8(UINT8_C(235), UINT8_C(158), UINT8_C(245), UINT8_C(240),
                             UINT8_C(227), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(222), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(115), UINT8_C(255), UINT8_C(100), UINT8_C(246),
                             UINT8_C(233), UINT8_C( 96), UINT8_C(248), UINT8_C(170),
                             UINT8_C(255), UINT8_C(233), UINT8_C(255), UINT8_C(149),
                             UINT8_C(169), UINT8_C(124), UINT8_C(233), UINT8_C(255),
                             UINT8_C(123), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(233), UINT8_C(255), UINT8_C( 85), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(242), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(113), UINT8_C(108), UINT8_C(202),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(241),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(130),
                             UINT8_C(173), UINT8_C(151), UINT8_C(255), UINT8_C(246),
                             UINT8_C(255), UINT8_C(194), UINT8_C(146), UINT8_C( 73)) },
    { simde_x_mm512_set_epu8(UINT8_C( 38), UINT8_C(254), UINT8_C(204), UINT8_C( 72),
                             UINT8_C(177), UINT8_C( 63), UINT8_C( 67), UINT8_C( 50),
                             UINT8_C( 71), UINT8_C(226), UINT8_C(146), UINT8_C(  4),
                             UINT8_C(134), UINT8_C( 91), UINT8_C(195), UINT8_C(148),
                             UINT8_C( 28), UINT8_C(158), UINT8_C(223), UINT8_C(181),
                             UINT8_C(218), UINT8_C(114), UINT8_C(200), UINT8_C(243),
                             UINT8_C(255), UINT8_C( 48), UINT8_C(233), UINT8_C( 82),
                             UINT8_C( 22), UINT8_C( 26), UINT8_C(128), UINT8_C(166),
                             UINT8_C( 79), UINT8_C(206), UINT8_C(109), UINT8_C(113),
                             UINT8_C( 86), UINT8_C(112), UINT8_C(215), UINT8_C(187),
                             UINT8_C(174), UINT8_C(250), UINT8_C(225), UINT8_C(206),
                             UINT8_C(242), UINT8_C(141), UINT8_C(197), UINT8_C(179),
                             UINT8_C( 88), UINT8_C(237), UINT8_C(191), UINT8_C(149),
                             UINT8_C(130), UINT8_C( 63), UINT8_C( 54), UINT8_C(129),
                             UINT8_C(126), UINT8_C( 18), UINT8_C( 43), UINT8_C(251),
                             UINT8_C(214), UINT8_C(155), UINT8_C( 61), UINT8_C(138)),
      simde_x_mm512_set_epu8(UINT8_C(142), UINT8_C( 33), UINT8_C( 51), UINT8_C(244),
                             UINT8_C( 33), UINT8_C(106), UINT8_C( 75), UINT8_C(210),
                             UINT8_C(121), UINT8_C( 52), UINT8_C(233), UINT8_C(109),
                             UINT8_C(205), UINT8_C(175), UINT8_C(230), UINT8_C( 70),
                             UINT8_C( 28), UINT8_C(216), UINT8_C( 76), UINT8_C(137),
                             UINT8_C(129), UINT8_C(  5), UINT8_C(149), UINT8_C(132),
                             UINT8_C(159), UINT8_C( 55), UINT8_C( 47), UINT8_C(212),
                             UINT8_C(202), UINT8_C( 26), UINT8_C(247), UINT8_C( 19),
                             UINT8_C(109), UINT8_C( 59), UINT8_C( 49), UINT8_C(175),
                             UINT8_C( 15), UINT8_C(240), UINT8_C(155), UINT8_C( 20),
                             UINT8_C( 85), UINT8_C( 57), UINT8_C( 91), UINT8_C(177),
                             UINT8_C(179), UINT8_C(200), UINT8_C( 26), UINT8_C( 99),
                             UINT8_C(  9), UINT8_C(177), UINT8_C(151), UINT8_C(246),
                             UINT8_C(116), UINT8_C(162), UINT8_C(144), UINT8_C( 44),
                             UINT8_C(240), UINT8_C(226), UINT8_C(215), UINT8_C(206),
                             UINT8_C(114), UINT8_C(250), UINT8_C(170), UINT8_C(220)),
      simde_x_mm512_set_epu8(UINT8_C(180), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(210), UINT8_C(169), UINT8_C(142), UINT8_C(255),
                             UINT8_C(192), UINT8_C(255), UINT8_C(255), UINT8_C(113),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(218),
                             UINT8_C( 56), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(119), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(103), UINT8_C(255), UINT8_C(255),
                             UINT8_C(224), UINT8_C( 52), UINT8_C(255), UINT8_C(185),
                             UINT8_C(188), UINT8_C(255), UINT8_C(158), UINT8_C(255),
                             UINT8_C(101), UINT8_C(255), UINT8_C(255), UINT8_C(207),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(223), UINT8_C(255),
                             UINT8_C( 97), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(246), UINT8_C(225), UINT8_C(198), UINT8_C(173),
                             UINT8_C(255), UINT8_C(244), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(231), UINT8_C(255)) },
    { simde_x_mm512_set_epu8(UINT8_C(103), UINT8_C(253), UINT8_C( 31), UINT8_C(185),
                             UINT8_C(101), UINT8_C(201), UINT8_C( 20), UINT8_C( 77),
                             UINT8_C(110), UINT8_C(116), UINT8_C(226), UINT8_C( 37),
                             UINT8_C(155), UINT8_C( 44), UINT8_C(198), UINT8_C(182),
                             UINT8_C(132), UINT8_C( 61), UINT8_C(104), UINT8_C(181),
                             UINT8_C( 77), UINT8_C(161), UINT8_C(154), UINT8_C(195),
                             UINT8_C(148), UINT8_C(239), UINT8_C(178), UINT8_C(165),
                             UINT8_C(  6), UINT8_C(251), UINT8_C( 97), UINT8_C(247),
                             UINT8_C(  8), UINT8_C( 52), UINT8_C( 96), UINT8_C( 34),
                             UINT8_C(233), UINT8_C(  1), UINT8_C(  7), UINT8_C(254),
                             UINT8_C(  3), UINT8_C(  8), UINT8_C(168), UINT8_C(221),
                             UINT8_C(238), UINT8_C(144), UINT8_C( 18), UINT8_C(245),
                             UINT8_C(216), UINT8_C(239), UINT8_C(128), UINT8_C(174),
                             UINT8_C(108), UINT8_C(236), UINT8_C(204), UINT8_C(151),
                             UINT8_C( 83), UINT8_C(224), UINT8_C(253), UINT8_C( 94),
                             UINT8_C( 40), UINT8_C( 10), UINT8_C(195), UINT8_C( 72)),
      simde_x_mm512_set_epu8(UINT8_C(196), UINT8_C(220), UINT8_C(209), UINT8_C(146),
                             UINT8_C( 66), UINT8_C(240), UINT8_C(160), UINT8_C( 58),
                             UINT8_C(206), UINT8_C(157), UINT8_C(225), UINT8_C(238),
                             UINT8_C(235), UINT8_C( 53), UINT8_C( 91), UINT8_C( 97),
                             UINT8_C(175), UINT8_C( 22), UINT8_C( 33), UINT8_C(101),
                             UINT8_C(189), UINT8_C(131), UINT8_C(219), UINT8_C( 30),
                             UINT8_C( 36), UINT8_C( 11), UINT8_C(180), UINT8_C( 46),
                             UINT8_C(126), UINT8_C(239), UINT8_C(135), UINT8_C( 44),
                             UINT8_C(198), UINT8_C(149), UINT8_C(235), UINT8_C( 72),
                             UINT8_C( 18), UINT8_C(214), UINT8_C( 92), UINT8_C(199),
                             UINT8_C( 79), UINT8_C( 28), UINT8_C(156), UINT8_C( 37),
                             UINT8_C(212), UINT8_C(167), UINT8_C( 62), UINT8_C(201),
                             UINT8_C(139), UINT8_C(215), UINT8_C( 68), UINT8_C(117),
                             UINT8_C( 83), UINT8_C(105), UINT8_C(232), UINT8_C(251),
                             UINT8_C(  6), UINT8_C(165), UINT8_C(199), UINT8_C(183),
                             UINT8_C(254), UINT8_C( 55), UINT8_C(167), UINT8_C(238)),
      simde_x_mm512_set_epu8(UINT8_C(255), UINT8_C(255), UINT8_C(240), UINT8_C(255),
                             UINT8_C(167), UINT8_C(255), UINT8_C(180), UINT8_C(135),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C( 97), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C( 83), UINT8_C(137), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(225),
                             UINT8_C(184), UINT8_C(250), UINT8_C(255), UINT8_C(211),
                             UINT8_C(132), UINT8_C(255), UINT8_C(232), UINT8_C(255),
                             UINT8_C(206), UINT8_C(201), UINT8_C(255), UINT8_C(106),
                             UINT8_C(251), UINT8_C(215), UINT8_C( 99), UINT8_C(255),
                             UINT8_C( 82), UINT8_C( 36), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C( 80), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(196), UINT8_C(255),
                             UINT8_C(191), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C( 89), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C( 65), UINT8_C(255), UINT8_C(255)) },
    { simde_x_mm512_set_epu8(UINT8_C(  7), UINT8_C( 99), UINT8_C(210), UINT8_C(110),
                             UINT8_C(202), UINT8_C( 10), UINT8_C(247), UINT8_C( 68),
                             UINT8_C(177), UINT8_C(186), UINT8_C(247), UINT8_C( 36),
                             UINT8_C(212), UINT8_C(146), UINT8_C(251), UINT8_C( 66),
                             UINT8_C(  0), UINT8_C(  8), UINT8_C(116), UINT8_C(102),
                             UINT8_C(175), UINT8_C(223), UINT8_C( 15), UINT8_C(232),
                             UINT8_C(127), UINT8_C( 63), UINT8_C( 84), UINT8_C(165),
                             UINT8_C( 18), UINT8_C(250), UINT8_C( 71), UINT8_C( 18),
                             UINT8_C(132), UINT8_C(155), UINT8_C(102), UINT8_C( 18),
                             UINT8_C(177), UINT8_C(146), UINT8_C(169), UINT8_C(139),
                             UINT8_C( 21), UINT8_C( 79), UINT8_C(  4), UINT8_C(129),
                             UINT8_C(168), UINT8_C( 42), UINT8_C(  9), UINT8_C(184),
                             UINT8_C( 46), UINT8_C( 53), UINT8_C(243), UINT8_C(140),
                             UINT8_C(158), UINT8_C(112), UINT8_C( 35), UINT8_C( 49),
                             UINT8_C(253), UINT8_C(233), UINT8_C( 33), UINT8_C(178),
                             UINT8_C(117), UINT8_C(161), UINT8_C(168), UINT8_C( 39)),
      simde_x_mm512_set_epu8(UINT8_C( 75), UINT8_C(218), UINT8_C(162), UINT8_C( 30),
                             UINT8_C(119), UINT8_C(231), UINT8_C(193), UINT8_C(230),
                             UINT8_C(151), UINT8_C( 49), UINT8_C(234), UINT8_C( 78),
                             UINT8_C( 76), UINT8_C( 37), UINT8_C(174), UINT8_C(105),
                             UINT8_C(224), UINT8_C(210), UINT8_C(188), UINT8_C(142),
                             UINT8_C(116), UINT8_C(129), UINT8_C( 93), UINT8_C(124),
                             UINT8_C(248), UINT8_C(145), UINT8_C(230), UINT8_C( 41),
                             UINT8_C( 66), UINT8_C(115), UINT8_C(180), UINT8_C( 47),
                             UINT8_C( 55), UINT8_C(104), UINT8_C(123), UINT8_C(150),
                             UINT8_C(165), UINT8_C( 22), UINT8_C(  0), UINT8_C(101),
                             UINT8_C( 55), UINT8_C( 23), UINT8_C( 90), UINT8_C( 64),
                             UINT8_C( 52), UINT8_C(254), UINT8_C(116), UINT8_C(243),
                             UINT8_C(  4), UINT8_C( 84), UINT8_C( 82), UINT8_C(103),
                             UINT8_C( 43), UINT8_C(237), UINT8_C(  7), UINT8_C( 76),
                             UINT8_C( 88), UINT8_C(212), UINT8_C( 63), UINT8_C(146),
                             UINT8_C(224), UINT8_C(223), UINT8_C(207), UINT8_C(220)),
      simde_x_mm512_set_epu8(UINT8_C( 82), UINT8_C(255), UINT8_C(255), UINT8_C(140),
                             UINT8_C(255), UINT8_C(241), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(235), UINT8_C(255), UINT8_C(114),
                             UINT8_C(255), UINT8_C(183), UINT8_C(255), UINT8_C(171),
                             UINT8_C(224), UINT8_C(218), UINT8_C(255), UINT8_C(244),
                             UINT8_C(255), UINT8_C(255), UINT8_C(108), UINT8_C(255),
                             UINT8_C(255), UINT8_C(208), UINT8_C(255), UINT8_C(206),
                             UINT8_C( 84), UINT8_C(255), UINT8_C(251), UINT8_C( 65),
                             UINT8_C(187), UINT8_C(255), UINT8_C(225), UINT8_C(168),
                             UINT8_C(255), UINT8_C(168), UINT8_C(169), UINT8_C(240),
                             UINT8_C( 76), UINT8_C(102), UINT8_C( 94), UINT8_C(193),
                             UINT8_C(220), UINT8_C(255), UINT8_C(125), UINT8_C(255),
                             UINT8_C( 50), UINT8_C(137), UINT8_C(255), UINT8_C(243),
                             UINT8_C(201), UINT8_C(255), UINT8_C( 42), UINT8_C(125),
                             UINT8_C(255), UINT8_C(255), UINT8_C( 96), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255)) },
    { simde_x_mm512_set_epu8(UINT8_C(233), UINT8_C(112), UINT8_C( 62), UINT8_C( 65),
                             UINT8_C( 37), UINT8_C(247), UINT8_C(105), UINT8_C( 54),
                             UINT8_C(214), UINT8_C(255), UINT8_C(145), UINT8_C( 18),
                             UINT8_C(160), UINT8_C( 92), UINT8_C( 29), UINT8_C(253),
                             UINT8_C(230), UINT8_C( 83), UINT8_C(176), UINT8_C( 43),
                             UINT8_C( 78), UINT8_C( 31), UINT8_C(113), UINT8_C(239),
                             UINT8_C( 38), UINT8_C(192), UINT8_C(127), UINT8_C( 44),
                             UINT8_C(218), UINT8_C(134), UINT8_C(224), UINT8_C( 35),
                             UINT8_C(155), UINT8_C(171), UINT8_C( 44), UINT8_C( 53),
                             UINT8_C(101), UINT8_C(234), UINT8_C(121), UINT8_C( 95),
                             UINT8_C(232), UINT8_C(104), UINT8_C( 20), UINT8_C( 52),
                             UINT8_C( 59), UINT8_C( 62), UINT8_C( 55), UINT8_C( 43),
                             UINT8_C(246), UINT8_C( 36), UINT8_C( 25), UINT8_C( 98),
                             UINT8_C(155), UINT8_C(231), UINT8_C( 43), UINT8_C(203),
                             UINT8_C( 77), UINT8_C( 43), UINT8_C( 80), UINT8_C( 85),
                             UINT8_C(227), UINT8_C( 34), UINT8_C( 77), UINT8_C(179)),
      simde_x_mm512_set_epu8(UINT8_C( 68), UINT8_C(183), UINT8_C(190), UINT8_C(248),
                             UINT8_C( 54), UINT8_C(194), UINT8_C(  0), UINT8_C(190),
                             UINT8_C(102), UINT8_C(185), UINT8_C(  5), UINT8_C(238),
                             UINT8_C(188), UINT8_C(104), UINT8_C(139), UINT8_C(163),
                             UINT8_C(242), UINT8_C( 94), UINT8_C(181), UINT8_C(214),
                             UINT8_C(170), UINT8_C(182), UINT8_C(139), UINT8_C( 96),
                             UINT8_C( 80), UINT8_C( 38), UINT8_C(151), UINT8_C(132),
                             UINT8_C(243), UINT8_C( 37), UINT8_C(120), UINT8_C( 30),
                             UINT8_C(115), UINT8_C( 34), UINT8_C(222), UINT8_C(121),
                             UINT8_C(112), UINT8_C(205), UINT8_C(161), UINT8_C( 52),
                             UINT8_C(142), UINT8_C(118), UINT8_C(195), UINT8_C(200),
                             UINT8_C( 59), UINT8_C(  6), UINT8_C(115), UINT8_C(109),
                             UINT8_C( 93), UINT8_C(174), UINT8_C(200), UINT8_C(190),
                             UINT8_C(151), UINT8_C(126), UINT8_C(210), UINT8_C(200),
                             UINT8_C( 79), UINT8_C( 43), UINT8_C( 20), UINT8_C(239),
                             UINT8_C(149), UINT8_C(119), UINT8_C( 96), UINT8_C(120)),
      simde_x_mm512_set_epu8(UINT8_C(255), UINT8_C(255), UINT8_C(252), UINT8_C(255),
                             UINT8_C( 91), UINT8_C(255), UINT8_C(105), UINT8_C(244),
                             UINT8_C(255), UINT8_C(255), UINT8_C(150), UINT8_C(255),
                             UINT8_C(255), UINT8_C(196), UINT8_C(168), UINT8_C(255),
                             UINT8_C(255), UINT8_C(177), UINT8_C(255), UINT8_C(255),
                             UINT8_C(248), UINT8_C(213), UINT8_C(252), UINT8_C(255),
                             UINT8_C(118), UINT8_C(230), UINT8_C(255), UINT8_C(176),
                             UINT8_C(255), UINT8_C(171), UINT8_C(255), UINT8_C( 65),
                             UINT8_C(255), UINT8_C(205), UINT8_C(255), UINT8_C(174),
                             UINT8_C(213), UINT8_C(255), UINT8_C(255), UINT8_C(147),
                             UINT8_C(255), UINT8_C(222), UINT8_C(215), UINT8_C(252),
                             UINT8_C(118), UINT8_C( 68), UINT8_C(170), UINT8_C(152),
                             UINT8_C(255), UINT8_C(210), UINT8_C(225), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(253), UINT8_C(255),
                             UINT8_C(156), UINT8_C( 86), UINT8_C(100), UINT8_C(255),
                             UINT8_C(255), UINT8_C(153), UINT8_C(173), UINT8_C(255)) },
    { simde_x_mm512_set_epu8(UINT8_C(150), UINT8_C(150), UINT8_C(146), UINT8_C(157),
                             UINT8_C(103), UINT8_C( 31), UINT8_C(236), UINT8_C(192),
                             UINT8_C(155), UINT8_C( 46), UINT8_C(170), UINT8_C(176),
                             UINT8_C(189), UINT8_C( 74), UINT8_C(246), UINT8_C(  0),
                             UINT8_C( 85), UINT8_C( 30), UINT8_C(190), UINT8_C( 12),
                             UINT8_C(117), UINT8_C( 74), UINT8_C(194), UINT8_C( 97),
                             UINT8_C(132), UINT8_C( 63), UINT8_C(227), UINT8_C( 21),
                             UINT8_C(244), UINT8_C(229), UINT8_C(176), UINT8_C(122),
                             UINT8_C(159), UINT8_C( 35), UINT8_C(115), UINT8_C(240),
                             UINT8_C( 88), UINT8_C(151), UINT8_C(101), UINT8_C(194),
                             UINT8_C( 49), UINT8_C(128), UINT8_C( 87), UINT8_C(152),
                             UINT8_C(173), UINT8_C(242), UINT8_C(150), UINT8_C( 26),
                             UINT8_C(183), UINT8_C( 56), UINT8_C(181), UINT8_C(193),
                             UINT8_C(231), UINT8_C(135), UINT8_C(190), UINT8_C( 42),
                             UINT8_C( 33), UINT8_C(174), UINT8_C( 57), UINT8_C(232),
                             UINT8_C(176), UINT8_C(125), UINT8_C( 87), UINT8_C( 79)),
      simde_x_mm512_set_epu8(UINT8_C( 68), UINT8_C(  1), UINT8_C(208), UINT8_C( 74),
                             UINT8_C(102), UINT8_C(168), UINT8_C( 41), UINT8_C( 41),
                             UINT8_C( 83), UINT8_C( 95), UINT8_C(152), UINT8_C(131),
                             UINT8_C(230), UINT8_C( 27), UINT8_C(126), UINT8_C(230),
                             UINT8_C(128), UINT8_C(133), UINT8_C(107), UINT8_C(197),
                             UINT8_C( 23), UINT8_C(  2), UINT8_C(108), UINT8_C(207),
                             UINT8_C( 82), UINT8_C(175), UINT8_C(247), UINT8_C(180),
                             UINT8_C( 57), UINT8_C( 31), UINT8_C(124), UINT8_C(203),
                             UINT8_C(246), UINT8_C(195), UINT8_C(173), UINT8_C(161),
                             UINT8_C(132), UINT8_C(162), UINT8_C( 13), UINT8_C(205),
                             UINT8_C(225), UINT8_C( 25), UINT8_C( 39), UINT8_C(181),
                             UINT8_C(149), UINT8_C(149), UINT8_C(138), UINT8_C(158),
                             UINT8_C(215), UINT8_C(147), UINT8_C(  0), UINT8_C( 87),
                             UINT8_C(244), UINT8_C( 10), UINT8_C(  1), UINT8_C( 19),
                             UINT8_C(173), UINT8_C(221), UINT8_C(118), UINT8_C( 51),
                             UINT8_C( 98), UINT8_C(183), UINT8_C(125), UINT8_C( 92)),
      simde_x_mm512_set_epu8(UINT8_C(218), UINT8_C(151), UINT8_C(255), UINT8_C(231),
                             UINT8_C(205), UINT8_C(199), UINT8_C(255), UINT8_C(233),
                             UINT8_C(238), UINT8_C(141), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(101), UINT8_C(255), UINT8_C(230),
                             UINT8_C(213), UINT8_C(163), UINT8_C(255), UINT8_C(209),
                             UINT8_C(140), UINT8_C( 76), UINT8_C(255), UINT8_C(255),
                             UINT8_C(214), UINT8_C(238), UINT8_C(255), UINT8_C(201),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(230), UINT8_C(255), UINT8_C(255),
                             UINT8_C(220), UINT8_C(255), UINT8_C(114), UINT8_C(255),
                             UINT8_C(255), UINT8_C(153), UINT8_C(126), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(184),
                             UINT8_C(255), UINT8_C(203), UINT8_C(181), UINT8_C(255),
                             UINT8_C(255), UINT8_C(145), UINT8_C(191), UINT8_C( 61),
                             UINT8_C(206), UINT8_C(255), UINT8_C(175), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(212), UINT8_C(171)) },
    { simde_x_mm512_set_epu8(UINT8_C(166), UINT8_C(112), UINT8_C( 16), UINT8_C( 20),
                             UINT8_C(189), UINT8_C( 23), UINT8_C( 28), UINT8_C(226),
                             UINT8_C( 92), UINT8_C(105), UINT8_C(249), UINT8_C( 71),
                             UINT8_C( 22), UINT8_C(153), UINT8_C( 38), UINT8_C( 58),
                             UINT8_C( 86), UINT8_C(191), UINT8_C( 97), UINT8_C(186),
                             UINT8_C(117), UINT8_C( 93), UINT8_C( 63), UINT8_C(142),
                             UINT8_C( 82), UINT8_C(123), UINT8_C(210), UINT8_C(159),
                             UINT8_C(175), UINT8_C(187), UINT8_C( 33), UINT8_C(134),
                             UINT8_C(156), UINT8_C(243), UINT8_C(191), UINT8_C(139),
                             UINT8_C(173), UINT8_C( 70), UINT8_C(113), UINT8_C( 30),
                             UINT8_C(184), UINT8_C( 82), UINT8_C(234), UINT8_C(177),
                             UINT8_C(234), UINT8_C(131), UINT8_C(180), UINT8_C( 12),
                             UINT8_C( 47), UINT8_C(213), UINT8_C( 54), UINT8_C(222),
                             UINT8_C(114), UINT8_C(251), UINT8_C(236), UINT8_C( 57),
                             UINT8_C(205), UINT8_C(187), UINT8_C( 48), UINT8_C(112),
                             UINT8_C( 34), UINT8_C( 49), UINT8_C( 95), UINT8_C(198)),
      simde_x_mm512_set_epu8(UINT8_C(116), UINT8_C(101), UINT8_C(212), UINT8_C(199),
                             UINT8_C( 88), UINT8_C(165), UINT8_C(253), UINT8_C( 88),
                             UINT8_C(138), UINT8_C( 27), UINT8_C(153), UINT8_C(155),
                             UINT8_C(248), UINT8_C(175), UINT8_C(152), UINT8_C(246),
                             UINT8_C( 17), UINT8_C(224), UINT8_C( 49), UINT8_C(127),
                             UINT8_C(200), UINT8_C( 46), UINT8_C( 58), UINT8_C(159),
                             UINT8_C(177), UINT8_C( 24), UINT8_C(139), UINT8_C(240),
                             UINT8_C( 45), UINT8_C(115), UINT8_C(179), UINT8_C(230),
                             UINT8_C(249), UINT8_C(217), UINT8_C(202), UINT8_C( 21),
                             UINT8_C(134), UINT8_C(111), UINT8_C( 79), UINT8_C(153),
                             UINT8_C(130), UINT8_C( 83), UINT8_C(196), UINT8_C(101),
                             UINT8_C(151), UINT8_C(117), UINT8_C(152), UINT8_C(155),
                             UINT8_C(116), UINT8_C(201), UINT8_C(241), UINT8_C( 71),
                             UINT8_C( 24), UINT8_C(105), UINT8_C(212), UINT8_C(191),
                             UINT8_C(  1), UINT8_C(252), UINT8_C( 15), UINT8_C( 49),
                             UINT8_C(105), UINT8_C(159), UINT8_C(109), UINT8_C( 31)),
      simde_x_mm512_set_epu8(UINT8_C(255), UINT8_C(213), UINT8_C(228), UINT8_C(219),
                             UINT8_C(255), UINT8_C(188), UINT8_C(255), UINT8_C(255),
                             UINT8_C(230), UINT8_C(132), UINT8_C(255), UINT8_C(226),
                             UINT8_C(255), UINT8_C(255), UINT8_C(190), UINT8_C(255),
                             UINT8_C(103), UINT8_C(255), UINT8_C(146), UINT8_C(255),
                             UINT8_C(255), UINT8_C(139), UINT8_C(121), UINT8_C(255),
                             UINT8_C(255), UINT8_C(147), UINT8_C(255), UINT8_C(255),
                             UINT8_C(220), UINT8_C(255), UINT8_C(212), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(160),
                             UINT8_C(255), UINT8_C(181), UINT8_C(192), UINT8_C(183),
                             UINT8_C(255), UINT8_C(165), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(248), UINT8_C(255), UINT8_C(167),
                             UINT8_C(163), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(138), UINT8_C(255), UINT8_C(255), UINT8_C(248),
                             UINT8_C(206), UINT8_C(255), UINT8_C( 63), UINT8_C(161),
                             UINT8_C(139), UINT8_C(208), UINT8_C(204), UINT8_C(229)) },
    { simde_x_mm512_set_epu8(UINT8_C(239), UINT8_C(174), UINT8_C( 81), UINT8_C( 89),
                             UINT8_C( 63), UINT8_C(160), UINT8_C(219), UINT8_C(204),
                             UINT8_C(161), UINT8_C(  4), UINT8_C(134), UINT8_C(137),
                             UINT8_C( 48), UINT8_C( 33), UINT8_C(178), UINT8_C(122),
                             UINT8_C( 99), UINT8_C(167), UINT8_C( 95), UINT8_C(109),
                             UINT8_C( 38), UINT8_C(191), UINT8_C(  3), UINT8_C( 48),
                             UINT8_C(143), UINT8_C( 51), UINT8_C( 81), UINT8_C( 76),
                             UINT8_C(251), UINT8_C(204), UINT8_C(198), UINT8_C(  1),
                             UINT8_C(175), UINT8_C(123), UINT8_C( 24), UINT8_C(237),
                             UINT8_C(190), UINT8_C( 62), UINT8_C( 87), UINT8_C(255),
                             UINT8_C(119), UINT8_C(202), UINT8_C(  4), UINT8_C( 40),
                             UINT8_C(152), UINT8_C(128), UINT8_C(116), UINT8_C( 72),
                             UINT8_C(245), UINT8_C(148), UINT8_C( 39), UINT8_C(106),
                             UINT8_C(195), UINT8_C(186), UINT8_C(241), UINT8_C(178),
                             UINT8_C( 68), UINT8_C(210), UINT8_C( 61), UINT8_C(218),
                             UINT8_C(116), UINT8_C( 98), UINT8_C( 41), UINT8_C( 22)),
      simde_x_mm512_set_epu8(UINT8_C(  3), UINT8_C(245), UINT8_C(  8), UINT8_C(179),
                             UINT8_C(242), UINT8_C( 19), UINT8_C(107), UINT8_C(170),
                             UINT8_C(178), UINT8_C(175), UINT8_C(174), UINT8_C(170),
                             UINT8_C( 72), UINT8_C(195), UINT8_C(199), UINT8_C( 66),
                             UINT8_C(182), UINT8_C(183), UINT8_C( 58), UINT8_C(245),
                             UINT8_C( 62), UINT8_C( 31), UINT8_C( 93), UINT8_C( 74),
                             UINT8_C(114), UINT8_C( 92), UINT8_C(199), UINT8_C( 53),
                             UINT8_C( 94), UINT8_C(185), UINT8_C(107), UINT8_C(124),
                             UINT8_C(160), UINT8_C(193), UINT8_C( 17), UINT8_C( 65),
                             UINT8_C(242), UINT8_C( 55), UINT8_C(163), UINT8_C(102),
                             UINT8_C( 59), UINT8_C(173), UINT8_C(244), UINT8_C(232),
                             UINT8_C(182), UINT8_C(139), UINT8_C(254), UINT8_C( 81),
                             UINT8_C(228), UINT8_C(175), UINT8_C(104), UINT8_C(167),
                             UINT8_C( 38), UINT8_C(114), UINT8_C(184), UINT8_C(118),
                             UINT8_C(167), UINT8_C( 58), UINT8_C(153), UINT8_C(103),
                             UINT8_C(204), UINT8_C(126), UINT8_C(111), UINT8_C( 63)),
      simde_x_mm512_set_epu8(UINT8_C(242), UINT8_C(255), UINT8_C( 89), UINT8_C(255),
                             UINT8_C(255), UINT8_C(179), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(179), UINT8_C(255), UINT8_C(255),
                             UINT8_C(120), UINT8_C(228), UINT8_C(255), UINT8_C(188),
                             UINT8_C(255), UINT8_C(255), UINT8_C(153), UINT8_C(255),
                             UINT8_C(100), UINT8_C(222), UINT8_C( 96), UINT8_C(122),
                             UINT8_C(255), UINT8_C(143), UINT8_C(255), UINT8_C(129),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(125),
                             UINT8_C(255), UINT8_C(255), UINT8_C( 41), UINT8_C(255),
                             UINT8_C(255), UINT8_C(117), UINT8_C(250), UINT8_C(255),
                             UINT8_C(178), UINT8_C(255), UINT8_C(248), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(153),
                             UINT8_C(255), UINT8_C(255), UINT8_C(143), UINT8_C(255),
                             UINT8_C(233), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(235), UINT8_C(255), UINT8_C(214), UINT8_C(255),
                             UINT8_C(255), UINT8_C(224), UINT8_C(152), UINT8_C( 85)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_adds_epu8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_adds_epu8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C(  92), UINT8_C( 116), UINT8_C( 178), UINT8_C( 237),
                             UINT8_C( 183), UINT8_C(  22), UINT8_C( 190), UINT8_C( 227),
                             UINT8_C(  55), UINT8_C(  78), UINT8_C( 211), UINT8_C( 137),
                             UINT8_C(  30), UINT8_C( 227), UINT8_C( 233), UINT8_C(  89),
                             UINT8_C(  15), UINT8_C( 119), UINT8_C( 168), UINT8_C( 109),
                             UINT8_C( 240), UINT8_C( 246), UINT8_C(   0), UINT8_C( 238),
                             UINT8_C(   1), UINT8_C( 116), UINT8_C(  62), UINT8_C( 183),
                             UINT8_C( 134), UINT8_C(   0), UINT8_C( 111), UINT8_C(  95),
                             UINT8_C( 236), UINT8_C(   3), UINT8_C( 122), UINT8_C( 135),
                             UINT8_C(  13), UINT8_C(  25), UINT8_C( 221), UINT8_C( 129),
                             UINT8_C(  82), UINT8_C(  90), UINT8_C(  53), UINT8_C( 123),
                             UINT8_C(  73), UINT8_C( 108), UINT8_C( 238), UINT8_C(  15),
                             UINT8_C(  81), UINT8_C( 229), UINT8_C( 102), UINT8_C( 118),
                             UINT8_C(  39), UINT8_C( 179), UINT8_C(  45), UINT8_C(  81),
                             UINT8_C( 239), UINT8_C( 228), UINT8_C(  67), UINT8_C( 138),
                             UINT8_C(  79), UINT8_C( 143), UINT8_C( 134), UINT8_C( 124)),
      UINT64_C(10224647434006242820),
      simde_x_mm512_set_epu8(UINT8_C(  68), UINT8_C( 148), UINT8_C( 135), UINT8_C( 141),
                             UINT8_C( 197), UINT8_C( 178), UINT8_C( 145), UINT8_C(  56),
                             UINT8_C(   9), UINT8_C( 135), UINT8_C( 120), UINT8_C( 220),
                             UINT8_C(  36), UINT8_C( 153), UINT8_C( 152), UINT8_C(  25),
                             UINT8_C( 145), UINT8_C( 193), UINT8_C( 221), UINT8_C( 136),
                             UINT8_C(  28), UINT8_C( 212), UINT8_C( 230), UINT8_C( 170),
                             UINT8_C( 243), UINT8_C(  53), UINT8_C( 168), UINT8_C( 149),
                             UINT8_C(  68), UINT8_C(  42), UINT8_C( 138), UINT8_C( 111),
                             UINT8_C(  54), UINT8_C( 198), UINT8_C( 243), UINT8_C(  27),
                             UINT8_C(  23), UINT8_C(  41), UINT8_C( 137), UINT8_C(  44),
                             UINT8_C(   7), UINT8_C( 136), UINT8_C(  32), UINT8_C( 213),
                             UINT8_C( 114), UINT8_C( 184), UINT8_C(  73), UINT8_C( 160),
                             UINT8_C(  96), UINT8_C( 110), UINT8_C( 175), UINT8_C( 180),
                             UINT8_C( 103), UINT8_C( 156), UINT8_C( 234), UINT8_C(  18),
                             UINT8_C( 115), UINT8_C(  54), UINT8_C( 216), UINT8_C( 125),
                             UINT8_C( 110), UINT8_C(  31), UINT8_C(  51), UINT8_C( 152)),
      simde_x_mm512_set_epu8(UINT8_C( 242), UINT8_C(  85), UINT8_C( 176), UINT8_C(  80),
                             UINT8_C(  48), UINT8_C(  93), UINT8_C(  79), UINT8_C( 127),
                             UINT8_C(  16), UINT8_C(  41), UINT8_C(  54), UINT8_C( 140),
                             UINT8_C(  17), UINT8_C(  42), UINT8_C( 170), UINT8_C(  38),
                             UINT8_C( 138), UINT8_C( 200), UINT8_C(  60), UINT8_C(  19),
                             UINT8_C( 156), UINT8_C( 149), UINT8_C( 105), UINT8_C( 180),
                             UINT8_C(  10), UINT8_C( 247), UINT8_C( 244), UINT8_C( 200),
                             UINT8_C( 185), UINT8_C(  96), UINT8_C(   6), UINT8_C(  24),
                             UINT8_C(  69), UINT8_C(  73), UINT8_C( 229), UINT8_C(   3),
                             UINT8_C( 161), UINT8_C(  50), UINT8_C( 189), UINT8_C( 217),
                             UINT8_C(  97), UINT8_C(  62), UINT8_C( 101), UINT8_C(  56),
                             UINT8_C( 177), UINT8_C(  83), UINT8_C( 157), UINT8_C( 200),
                             UINT8_C( 239), UINT8_C( 200), UINT8_C( 248), UINT8_C( 240),
                             UINT8_C(  84), UINT8_C( 161), UINT8_C( 183), UINT8_C(  54),
                             UINT8_C( 125), UINT8_C(  85), UINT8_C(  78), UINT8_C( 191),
                             UINT8_C(   4), UINT8_C( 113), UINT8_C( 240), UINT8_C( 203)),
      simde_x_mm512_set_epu8(UINT8_C( 255), UINT8_C( 116), UINT8_C( 178), UINT8_C( 237),
                             UINT8_C( 245), UINT8_C( 255), UINT8_C( 190), UINT8_C( 183),
                             UINT8_C(  25), UINT8_C( 176), UINT8_C( 174), UINT8_C( 137),
                             UINT8_C(  30), UINT8_C( 195), UINT8_C( 233), UINT8_C(  63),
                             UINT8_C(  15), UINT8_C( 119), UINT8_C( 255), UINT8_C( 155),
                             UINT8_C( 184), UINT8_C( 255), UINT8_C( 255), UINT8_C( 238),
                             UINT8_C( 253), UINT8_C( 116), UINT8_C( 255), UINT8_C( 183),
                             UINT8_C( 253), UINT8_C(   0), UINT8_C( 144), UINT8_C( 135),
                             UINT8_C( 236), UINT8_C(   3), UINT8_C( 255), UINT8_C(  30),
                             UINT8_C(  13), UINT8_C(  25), UINT8_C( 221), UINT8_C( 255),
                             UINT8_C( 104), UINT8_C(  90), UINT8_C(  53), UINT8_C( 123),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 238), UINT8_C( 255),
                             UINT8_C(  81), UINT8_C( 229), UINT8_C( 255), UINT8_C( 118),
                             UINT8_C(  39), UINT8_C( 255), UINT8_C( 255), UINT8_C(  81),
                             UINT8_C( 239), UINT8_C( 228), UINT8_C(  67), UINT8_C( 138),
                             UINT8_C(  79), UINT8_C( 144), UINT8_C( 134), UINT8_C( 124)) },
    { simde_x_mm512_set_epu8(UINT8_C( 133), UINT8_C( 156), UINT8_C( 217), UINT8_C( 212),
                             UINT8_C(  22), UINT8_C( 112), UINT8_C(  16), UINT8_C(  15),
                             UINT8_C( 152), UINT8_C( 154), UINT8_C( 102), UINT8_C( 161),
                             UINT8_C(  69), UINT8_C(  13), UINT8_C( 235), UINT8_C(  45),
                             UINT8_C(  62), UINT8_C( 136), UINT8_C( 145), UINT8_C(  32),
                             UINT8_C( 149), UINT8_C( 226), UINT8_C(  99), UINT8_C( 192),
                             UINT8_C(   8), UINT8_C( 214), UINT8_C(  81), UINT8_C( 222),
                             UINT8_C( 210), UINT8_C(  26), UINT8_C(  31), UINT8_C( 254),
                             UINT8_C(  68), UINT8_C( 249), UINT8_C( 185), UINT8_C(  46),
                             UINT8_C( 235), UINT8_C( 183), UINT8_C(  21), UINT8_C(  83),
                             UINT8_C( 148), UINT8_C( 159), UINT8_C( 187), UINT8_C(  73),
                             UINT8_C(  57), UINT8_C( 219), UINT8_C(  21), UINT8_C(  82),
                             UINT8_C( 137), UINT8_C( 130), UINT8_C( 126), UINT8_C(  91),
                             UINT8_C( 115), UINT8_C(  31), UINT8_C( 177), UINT8_C(  28),
                             UINT8_C( 150), UINT8_C( 238), UINT8_C(  65), UINT8_C( 152),
                             UINT8_C(  81), UINT8_C(  38), UINT8_C( 172), UINT8_C( 254)),
      UINT64_C( 4597426592773770833),
      simde_x_mm512_set_epu8(UINT8_C(  74), UINT8_C(  72), UINT8_C( 252), UINT8_C(  28),
                             UINT8_C( 141), UINT8_C(  93), UINT8_C( 102), UINT8_C(  44),
                             UINT8_C( 153), UINT8_C( 227), UINT8_C( 206), UINT8_C(  48),
                             UINT8_C( 160), UINT8_C( 206), UINT8_C(  46), UINT8_C( 191),
                             UINT8_C(   4), UINT8_C(  43), UINT8_C( 181), UINT8_C(  97),
                             UINT8_C( 230), UINT8_C( 153), UINT8_C(  71), UINT8_C( 149),
                             UINT8_C(  91), UINT8_C(  45), UINT8_C( 245), UINT8_C(  47),
                             UINT8_C(  29), UINT8_C(  25), UINT8_C(  26), UINT8_C( 247),
                             UINT8_C(  10), UINT8_C(  36), UINT8_C( 177), UINT8_C( 203),
                             UINT8_C(  41), UINT8_C(   1), UINT8_C( 233), UINT8_C( 193),
                             UINT8_C( 129), UINT8_C(  68), UINT8_C(  48), UINT8_C(  36),
                             UINT8_C(  89), UINT8_C( 144), UINT8_C( 225), UINT8_C( 120),
                             UINT8_C(  35), UINT8_C(  62), UINT8_C( 235), UINT8_C( 142),
                             UINT8_C( 152), UINT8_C(  57), UINT8_C(  42), UINT8_C( 145),
                             UINT8_C(  94), UINT8_C( 193), UINT8_C( 247), UINT8_C(  64),
                             UINT8_C( 191), UINT8_C( 254), UINT8_C( 110), UINT8_C( 248)),
      simde_x_mm512_set_epu8(UINT8_C(  44), UINT8_C( 164), UINT8_C( 225), UINT8_C(  26),
                             UINT8_C( 157), UINT8_C( 203), UINT8_C( 117), UINT8_C(  18),
                             UINT8_C( 193), UINT8_C(  45), UINT8_C(  12), UINT8_C(  24),
                             UINT8_C( 148), UINT8_C(  18), UINT8_C( 196), UINT8_C(  28),
                             UINT8_C(  50), UINT8_C( 245), UINT8_C( 188), UINT8_C( 225),
                             UINT8_C( 105), UINT8_C( 150), UINT8_C(  98), UINT8_C(  51),
                             UINT8_C(  58), UINT8_C( 103), UINT8_C( 111), UINT8_C( 129),
                             UINT8_C(  68), UINT8_C( 200), UINT8_C( 124), UINT8_C( 137),
                             UINT8_C(  74), UINT8_C( 194), UINT8_C( 140), UINT8_C(  37),
                             UINT8_C( 244), UINT8_C( 114), UINT8_C(   0), UINT8_C(  61),
                             UINT8_C( 103), UINT8_C( 252), UINT8_C( 151), UINT8_C( 188),
                             UINT8_C(  39), UINT8_C( 156), UINT8_C( 163), UINT8_C(  11),
                             UINT8_C( 176), UINT8_C( 237), UINT8_C( 234), UINT8_C( 217),
                             UINT8_C( 127), UINT8_C( 218), UINT8_C( 131), UINT8_C( 145),
                             UINT8_C(  84), UINT8_C( 160), UINT8_C(  87), UINT8_C( 234),
                             UINT8_C( 251), UINT8_C( 253), UINT8_C( 129), UINT8_C(  41)),
      simde_x_mm512_set_epu8(UINT8_C( 133), UINT8_C( 156), UINT8_C( 255), UINT8_C(  54),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 219), UINT8_C(  62),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 102), UINT8_C( 161),
                             UINT8_C( 255), UINT8_C( 224), UINT8_C( 235), UINT8_C( 219),
                             UINT8_C(  62), UINT8_C( 255), UINT8_C( 145), UINT8_C( 255),
                             UINT8_C( 149), UINT8_C( 255), UINT8_C( 169), UINT8_C( 200),
                             UINT8_C(   8), UINT8_C( 214), UINT8_C( 255), UINT8_C( 222),
                             UINT8_C( 210), UINT8_C(  26), UINT8_C(  31), UINT8_C( 254),
                             UINT8_C(  84), UINT8_C( 249), UINT8_C( 255), UINT8_C( 240),
                             UINT8_C( 255), UINT8_C( 115), UINT8_C( 233), UINT8_C( 254),
                             UINT8_C( 148), UINT8_C( 159), UINT8_C( 199), UINT8_C( 224),
                             UINT8_C(  57), UINT8_C( 255), UINT8_C( 255), UINT8_C( 131),
                             UINT8_C( 137), UINT8_C( 130), UINT8_C( 126), UINT8_C(  91),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 173), UINT8_C(  28),
                             UINT8_C( 150), UINT8_C( 255), UINT8_C(  65), UINT8_C( 255),
                             UINT8_C(  81), UINT8_C(  38), UINT8_C( 172), UINT8_C( 255)) },
    { simde_x_mm512_set_epu8(UINT8_C( 226), UINT8_C( 219), UINT8_C(  51), UINT8_C( 220),
                             UINT8_C(   8), UINT8_C(  52), UINT8_C(  97), UINT8_C( 123),
                             UINT8_C( 207), UINT8_C( 132), UINT8_C(  95), UINT8_C( 173),
                             UINT8_C(  70), UINT8_C( 206), UINT8_C( 195), UINT8_C(  25),
                             UINT8_C( 159), UINT8_C(  28), UINT8_C( 198), UINT8_C(  11),
                             UINT8_C( 242), UINT8_C( 126), UINT8_C(  81), UINT8_C(  45),
                             UINT8_C( 233), UINT8_C( 120), UINT8_C( 173), UINT8_C( 240),
                             UINT8_C(   7), UINT8_C(  51), UINT8_C( 199), UINT8_C( 206),
                             UINT8_C( 235), UINT8_C(  98), UINT8_C(  88), UINT8_C(   0),
                             UINT8_C( 190), UINT8_C(   3), UINT8_C( 124), UINT8_C( 143),
                             UINT8_C(  50), UINT8_C(  88), UINT8_C( 171), UINT8_C( 163),
                             UINT8_C( 212), UINT8_C( 243), UINT8_C( 162), UINT8_C(  17),
                             UINT8_C( 254), UINT8_C(  79), UINT8_C( 140), UINT8_C(  43),
                             UINT8_C( 179), UINT8_C( 131), UINT8_C( 233), UINT8_C( 136),
                             UINT8_C(  96), UINT8_C( 192), UINT8_C( 233), UINT8_C( 210),
                             UINT8_C( 227), UINT8_C( 185), UINT8_C(  71), UINT8_C(  90)),
      UINT64_C(12627002542648829104),
      simde_x_mm512_set_epu8(UINT8_C(  56), UINT8_C( 211), UINT8_C( 148), UINT8_C( 237),
                             UINT8_C( 132), UINT8_C( 229), UINT8_C(  22), UINT8_C( 126),
                             UINT8_C( 150), UINT8_C( 188), UINT8_C( 196), UINT8_C(   8),
                             UINT8_C(  60), UINT8_C(  93), UINT8_C( 223), UINT8_C( 229),
                             UINT8_C( 249), UINT8_C(  27), UINT8_C( 134), UINT8_C( 218),
                             UINT8_C(  23), UINT8_C(   6), UINT8_C(  45), UINT8_C( 235),
                             UINT8_C( 233), UINT8_C( 155), UINT8_C( 116), UINT8_C( 127),
                             UINT8_C(  96), UINT8_C(  40), UINT8_C( 159), UINT8_C(  40),
                             UINT8_C(  86), UINT8_C( 212), UINT8_C(  70), UINT8_C( 185),
                             UINT8_C(  62), UINT8_C( 235), UINT8_C(  66), UINT8_C(  68),
                             UINT8_C( 169), UINT8_C( 195), UINT8_C(  48), UINT8_C( 186),
                             UINT8_C(  18), UINT8_C( 178), UINT8_C( 158), UINT8_C( 117),
                             UINT8_C(  74), UINT8_C(  32), UINT8_C(  93), UINT8_C( 125),
                             UINT8_C( 209), UINT8_C( 196), UINT8_C( 170), UINT8_C( 117),
                             UINT8_C( 122), UINT8_C( 202), UINT8_C(  50), UINT8_C( 123),
                             UINT8_C( 225), UINT8_C( 182), UINT8_C( 192), UINT8_C(  54)),
      simde_x_mm512_set_epu8(UINT8_C( 115), UINT8_C(  51), UINT8_C( 165), UINT8_C(  56),
                             UINT8_C(  64), UINT8_C( 217), UINT8_C( 137), UINT8_C( 228),
                             UINT8_C( 202), UINT8_C(  28), UINT8_C(  54), UINT8_C( 248),
                             UINT8_C( 202), UINT8_C( 128), UINT8_C( 228), UINT8_C( 185),
                             UINT8_C( 107), UINT8_C( 190), UINT8_C( 142), UINT8_C( 168),
                             UINT8_C(  34), UINT8_C( 173), UINT8_C( 235), UINT8_C( 192),
                             UINT8_C( 121), UINT8_C( 236), UINT8_C( 167), UINT8_C( 162),
                             UINT8_C( 112), UINT8_C( 229), UINT8_C(  81), UINT8_C( 202),
                             UINT8_C( 192), UINT8_C( 142), UINT8_C(  48), UINT8_C( 167),
                             UINT8_C( 195), UINT8_C(  26), UINT8_C(  43), UINT8_C(  29),
                             UINT8_C(   0), UINT8_C(  64), UINT8_C( 123), UINT8_C( 189),
                             UINT8_C(  15), UINT8_C( 120), UINT8_C(  36), UINT8_C(  40),
                             UINT8_C( 106), UINT8_C( 138), UINT8_C( 148), UINT8_C( 198),
                             UINT8_C(  26), UINT8_C( 145), UINT8_C(  63), UINT8_C( 158),
                             UINT8_C( 243), UINT8_C( 244), UINT8_C( 132), UINT8_C(  96),
                             UINT8_C( 243), UINT8_C( 158), UINT8_C(  99), UINT8_C( 243)),
      simde_x_mm512_set_epu8(UINT8_C( 171), UINT8_C( 219), UINT8_C( 255), UINT8_C( 220),
                             UINT8_C( 196), UINT8_C( 255), UINT8_C( 159), UINT8_C( 255),
                             UINT8_C( 207), UINT8_C( 132), UINT8_C( 250), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C( 221), UINT8_C( 195), UINT8_C(  25),
                             UINT8_C( 159), UINT8_C(  28), UINT8_C( 198), UINT8_C( 255),
                             UINT8_C(  57), UINT8_C( 179), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 255), UINT8_C( 240),
                             UINT8_C( 208), UINT8_C(  51), UINT8_C( 199), UINT8_C( 242),
                             UINT8_C( 235), UINT8_C( 255), UINT8_C( 118), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 124), UINT8_C( 143),
                             UINT8_C( 169), UINT8_C(  88), UINT8_C( 171), UINT8_C( 163),
                             UINT8_C(  33), UINT8_C( 243), UINT8_C( 162), UINT8_C( 157),
                             UINT8_C( 180), UINT8_C(  79), UINT8_C( 241), UINT8_C(  43),
                             UINT8_C( 179), UINT8_C( 255), UINT8_C( 233), UINT8_C( 136),
                             UINT8_C( 255), UINT8_C( 192), UINT8_C( 182), UINT8_C( 219),
                             UINT8_C( 227), UINT8_C( 185), UINT8_C(  71), UINT8_C(  90)) },
    { simde_x_mm512_set_epu8(UINT8_C(  72), UINT8_C(  45), UINT8_C( 120), UINT8_C( 251),
                             UINT8_C( 147), UINT8_C(  62), UINT8_C(  17), UINT8_C(  31),
                             UINT8_C( 226), UINT8_C( 198), UINT8_C(  56), UINT8_C(  21),
                             UINT8_C(  72), UINT8_C( 182), UINT8_C( 216), UINT8_C( 120),
                             UINT8_C(  95), UINT8_C( 108), UINT8_C(  32), UINT8_C(  64),
                             UINT8_C( 128), UINT8_C( 102), UINT8_C( 235), UINT8_C(  28),
                             UINT8_C( 105), UINT8_C(  52), UINT8_C(  85), UINT8_C( 152),
                             UINT8_C(  57), UINT8_C( 225), UINT8_C( 218), UINT8_C( 132),
                             UINT8_C( 149), UINT8_C( 254), UINT8_C(  55), UINT8_C(  46),
                             UINT8_C( 185), UINT8_C(  77), UINT8_C(  18), UINT8_C(  70),
                             UINT8_C(  89), UINT8_C( 125), UINT8_C( 214), UINT8_C( 131),
                             UINT8_C( 121), UINT8_C( 245), UINT8_C( 187), UINT8_C( 197),
                             UINT8_C( 203), UINT8_C(  34), UINT8_C(   9), UINT8_C(  64),
                             UINT8_C( 195), UINT8_C( 231), UINT8_C( 141), UINT8_C( 100),
                             UINT8_C(  65), UINT8_C(   8), UINT8_C(  69), UINT8_C( 248),
                             UINT8_C( 241), UINT8_C( 205), UINT8_C(   1), UINT8_C(  90)),
      UINT64_C(14515151237088493607),
      simde_x_mm512_set_epu8(UINT8_C( 230), UINT8_C( 247), UINT8_C(  66), UINT8_C(   1),
                             UINT8_C( 243), UINT8_C(  60), UINT8_C( 137), UINT8_C( 173),
                             UINT8_C( 134), UINT8_C( 192), UINT8_C( 173), UINT8_C( 182),
                             UINT8_C( 119), UINT8_C( 248), UINT8_C(  12), UINT8_C( 113),
                             UINT8_C( 244), UINT8_C( 172), UINT8_C(   6), UINT8_C(  69),
                             UINT8_C(   2), UINT8_C( 181), UINT8_C( 222), UINT8_C( 130),
                             UINT8_C(   3), UINT8_C( 128), UINT8_C( 247), UINT8_C(  24),
                             UINT8_C(  11), UINT8_C( 162), UINT8_C( 224), UINT8_C( 110),
                             UINT8_C(  33), UINT8_C( 232), UINT8_C( 125), UINT8_C(  35),
                             UINT8_C( 153), UINT8_C( 208), UINT8_C( 234), UINT8_C(  38),
                             UINT8_C( 175), UINT8_C(   9), UINT8_C( 245), UINT8_C( 132),
                             UINT8_C(  71), UINT8_C(  31), UINT8_C( 214), UINT8_C(  93),
                             UINT8_C(  67), UINT8_C(  45), UINT8_C(  51), UINT8_C( 164),
                             UINT8_C( 126), UINT8_C( 108), UINT8_C( 133), UINT8_C( 185),
                             UINT8_C( 113), UINT8_C(  32), UINT8_C(  71), UINT8_C(  55),
                             UINT8_C( 230), UINT8_C(  82), UINT8_C( 175), UINT8_C( 236)),
      simde_x_mm512_set_epu8(UINT8_C( 131), UINT8_C( 121), UINT8_C( 128), UINT8_C( 103),
                             UINT8_C(   0), UINT8_C( 101), UINT8_C( 215), UINT8_C(  89),
                             UINT8_C( 173), UINT8_C( 191), UINT8_C(   9), UINT8_C( 249),
                             UINT8_C( 193), UINT8_C(  13), UINT8_C( 105), UINT8_C(  92),
                             UINT8_C( 238), UINT8_C( 235), UINT8_C( 154), UINT8_C( 142),
                             UINT8_C(  74), UINT8_C( 121), UINT8_C( 211), UINT8_C(  52),
                             UINT8_C( 193), UINT8_C( 163), UINT8_C(  98), UINT8_C( 106),
                             UINT8_C( 147), UINT8_C( 209), UINT8_C(  37), UINT8_C(  70),
                             UINT8_C( 100), UINT8_C( 121), UINT8_C(  18), UINT8_C(  28),
                             UINT8_C( 139), UINT8_C( 107), UINT8_C(   3), UINT8_C( 194),
                             UINT8_C(  42), UINT8_C(  72), UINT8_C(  91), UINT8_C(  86),
                             UINT8_C( 184), UINT8_C(   9), UINT8_C( 176), UINT8_C( 118),
                             UINT8_C( 122), UINT8_C( 148), UINT8_C( 186), UINT8_C( 193),
                             UINT8_C(  56), UINT8_C(  71), UINT8_C( 242), UINT8_C(  49),
                             UINT8_C( 183), UINT8_C(  53), UINT8_C( 227), UINT8_C(   3),
                             UINT8_C( 183), UINT8_C(  43), UINT8_C( 234), UINT8_C(  85)),
      simde_x_mm512_set_epu8(UINT8_C( 255), UINT8_C( 255), UINT8_C( 120), UINT8_C( 251),
                             UINT8_C( 243), UINT8_C(  62), UINT8_C(  17), UINT8_C( 255),
                             UINT8_C( 226), UINT8_C( 255), UINT8_C( 182), UINT8_C( 255),
                             UINT8_C(  72), UINT8_C( 182), UINT8_C( 216), UINT8_C( 120),
                             UINT8_C(  95), UINT8_C( 108), UINT8_C( 160), UINT8_C(  64),
                             UINT8_C(  76), UINT8_C( 255), UINT8_C( 235), UINT8_C( 182),
                             UINT8_C( 105), UINT8_C(  52), UINT8_C( 255), UINT8_C( 152),
                             UINT8_C(  57), UINT8_C( 255), UINT8_C( 218), UINT8_C( 180),
                             UINT8_C( 149), UINT8_C( 255), UINT8_C(  55), UINT8_C(  46),
                             UINT8_C( 185), UINT8_C(  77), UINT8_C( 237), UINT8_C( 232),
                             UINT8_C( 217), UINT8_C( 125), UINT8_C( 255), UINT8_C( 218),
                             UINT8_C( 255), UINT8_C( 245), UINT8_C( 255), UINT8_C( 211),
                             UINT8_C( 203), UINT8_C( 193), UINT8_C(   9), UINT8_C(  64),
                             UINT8_C( 195), UINT8_C( 231), UINT8_C( 141), UINT8_C( 100),
                             UINT8_C(  65), UINT8_C(   8), UINT8_C( 255), UINT8_C( 248),
                             UINT8_C( 241), UINT8_C( 125), UINT8_C( 255), UINT8_C( 255)) },
    { simde_x_mm512_set_epu8(UINT8_C( 209), UINT8_C(  84), UINT8_C( 130), UINT8_C( 192),
                             UINT8_C(  14), UINT8_C(  11), UINT8_C(  37), UINT8_C( 233),
                             UINT8_C(  67), UINT8_C( 124), UINT8_C(  58), UINT8_C( 162),
                             UINT8_C(  30), UINT8_C( 223), UINT8_C(  70), UINT8_C( 232),
                             UINT8_C(  38), UINT8_C( 159), UINT8_C( 200), UINT8_C( 196),
                             UINT8_C( 197), UINT8_C(  65), UINT8_C( 182), UINT8_C(  45),
                             UINT8_C( 245), UINT8_C(  55), UINT8_C( 174), UINT8_C(  12),
                             UINT8_C( 106), UINT8_C(  22), UINT8_C( 132), UINT8_C( 252),
                             UINT8_C(   2), UINT8_C( 175), UINT8_C(  14), UINT8_C(  90),
                             UINT8_C( 156), UINT8_C( 134), UINT8_C( 221), UINT8_C(  81),
                             UINT8_C( 242), UINT8_C( 214), UINT8_C( 125), UINT8_C( 131),
                             UINT8_C( 199), UINT8_C(  90), UINT8_C( 247), UINT8_C(  63),
                             UINT8_C(  53), UINT8_C(  77), UINT8_C(  63), UINT8_C( 172),
                             UINT8_C(  27), UINT8_C(  22), UINT8_C(   3), UINT8_C( 219),
                             UINT8_C(  65), UINT8_C( 118), UINT8_C( 130), UINT8_C(  97),
                             UINT8_C( 109), UINT8_C(   7), UINT8_C( 142), UINT8_C( 181)),
      UINT64_C( 8707623543556880126),
      simde_x_mm512_set_epu8(UINT8_C(  84), UINT8_C( 185), UINT8_C(   8), UINT8_C(  12),
                             UINT8_C( 245), UINT8_C( 180), UINT8_C(  62), UINT8_C(  93),
                             UINT8_C( 181), UINT8_C( 179), UINT8_C( 172), UINT8_C( 148),
                             UINT8_C( 221), UINT8_C(  14), UINT8_C( 196), UINT8_C(  18),
                             UINT8_C(  23), UINT8_C( 196), UINT8_C( 193), UINT8_C( 142),
                             UINT8_C( 201), UINT8_C(  75), UINT8_C( 157), UINT8_C( 201),
                             UINT8_C(  58), UINT8_C(  76), UINT8_C( 154), UINT8_C( 138),
                             UINT8_C( 226), UINT8_C(  39), UINT8_C( 119), UINT8_C(  85),
                             UINT8_C( 248), UINT8_C( 184), UINT8_C( 196), UINT8_C( 162),
                             UINT8_C( 144), UINT8_C( 119), UINT8_C( 124), UINT8_C(  76),
                             UINT8_C( 214), UINT8_C( 132), UINT8_C(  54), UINT8_C(  74),
                             UINT8_C( 164), UINT8_C(  99), UINT8_C(  79), UINT8_C( 253),
                             UINT8_C(  61), UINT8_C( 167), UINT8_C(  84), UINT8_C( 162),
                             UINT8_C(  31), UINT8_C( 140), UINT8_C( 189), UINT8_C( 154),
                             UINT8_C( 184), UINT8_C( 165), UINT8_C( 151), UINT8_C( 148),
                             UINT8_C( 212), UINT8_C(  74), UINT8_C( 228), UINT8_C( 124)),
      simde_x_mm512_set_epu8(UINT8_C(   1), UINT8_C(  75), UINT8_C(  21), UINT8_C( 220),
                             UINT8_C( 130), UINT8_C( 122), UINT8_C(  71), UINT8_C(  76),
                             UINT8_C(  28), UINT8_C( 200), UINT8_C(  32), UINT8_C( 101),
                             UINT8_C( 149), UINT8_C( 145), UINT8_C( 168), UINT8_C( 237),
                             UINT8_C( 179), UINT8_C(  19), UINT8_C( 235), UINT8_C( 145),
                             UINT8_C( 188), UINT8_C(  82), UINT8_C( 138), UINT8_C( 180),
                             UINT8_C(  47), UINT8_C( 127), UINT8_C(  62), UINT8_C( 240),
                             UINT8_C(  10), UINT8_C( 242), UINT8_C( 156), UINT8_C(  86),
                             UINT8_C(  29), UINT8_C( 107), UINT8_C(  56), UINT8_C(  21),
                             UINT8_C(  24), UINT8_C(  68), UINT8_C( 160), UINT8_C(  64),
                             UINT8_C(  48), UINT8_C(  13), UINT8_C( 173), UINT8_C(   4),
                             UINT8_C( 253), UINT8_C( 192), UINT8_C(  17), UINT8_C( 141),
                             UINT8_C(  21), UINT8_C( 108), UINT8_C( 125), UINT8_C( 196),
                             UINT8_C( 184), UINT8_C(  74), UINT8_C( 251), UINT8_C( 198),
                             UINT8_C( 215), UINT8_C(  22), UINT8_C( 141), UINT8_C( 102),
                             UINT8_C(  59), UINT8_C( 176), UINT8_C( 241), UINT8_C( 193)),
      simde_x_mm512_set_epu8(UINT8_C( 209), UINT8_C( 255), UINT8_C(  29), UINT8_C( 232),
                             UINT8_C( 255), UINT8_C(  11), UINT8_C(  37), UINT8_C( 233),
                             UINT8_C( 209), UINT8_C( 255), UINT8_C(  58), UINT8_C( 249),
                             UINT8_C(  30), UINT8_C( 159), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 202), UINT8_C( 159), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 197), UINT8_C(  65), UINT8_C( 182), UINT8_C( 255),
                             UINT8_C( 245), UINT8_C( 203), UINT8_C( 216), UINT8_C( 255),
                             UINT8_C( 236), UINT8_C(  22), UINT8_C( 255), UINT8_C( 252),
                             UINT8_C(   2), UINT8_C( 255), UINT8_C(  14), UINT8_C( 183),
                             UINT8_C( 156), UINT8_C( 187), UINT8_C( 255), UINT8_C( 140),
                             UINT8_C( 255), UINT8_C( 214), UINT8_C( 125), UINT8_C( 131),
                             UINT8_C( 255), UINT8_C(  90), UINT8_C( 247), UINT8_C( 255),
                             UINT8_C(  53), UINT8_C(  77), UINT8_C( 209), UINT8_C( 255),
                             UINT8_C(  27), UINT8_C( 214), UINT8_C( 255), UINT8_C( 219),
                             UINT8_C( 255), UINT8_C( 187), UINT8_C( 255), UINT8_C( 250),
                             UINT8_C( 255), UINT8_C( 250), UINT8_C( 255), UINT8_C( 181)) },
    { simde_x_mm512_set_epu8(UINT8_C( 192), UINT8_C( 203), UINT8_C( 214), UINT8_C( 126),
                             UINT8_C(  67), UINT8_C(  50), UINT8_C( 238), UINT8_C(  76),
                             UINT8_C( 237), UINT8_C( 123), UINT8_C( 169), UINT8_C( 106),
                             UINT8_C( 182), UINT8_C(  44), UINT8_C( 117), UINT8_C( 103),
                             UINT8_C(  81), UINT8_C( 122), UINT8_C(  56), UINT8_C( 246),
                             UINT8_C(  67), UINT8_C(  79), UINT8_C(  83), UINT8_C( 218),
                             UINT8_C( 243), UINT8_C(  43), UINT8_C(  27), UINT8_C( 159),
                             UINT8_C( 102), UINT8_C( 126), UINT8_C(  38), UINT8_C( 194),
                             UINT8_C( 232), UINT8_C( 117), UINT8_C( 218), UINT8_C( 163),
                             UINT8_C( 198), UINT8_C( 132), UINT8_C( 181), UINT8_C(  10),
                             UINT8_C(  18), UINT8_C( 182), UINT8_C(  14), UINT8_C(  36),
                             UINT8_C( 249), UINT8_C( 113), UINT8_C(  40), UINT8_C(  48),
                             UINT8_C( 149), UINT8_C( 222), UINT8_C( 181), UINT8_C(  85),
                             UINT8_C( 221), UINT8_C( 140), UINT8_C(  65), UINT8_C( 235),
                             UINT8_C(  15), UINT8_C(   3), UINT8_C(  45), UINT8_C(  21),
                             UINT8_C(  72), UINT8_C(  93), UINT8_C( 108), UINT8_C( 125)),
      UINT64_C(12576710173448868104),
      simde_x_mm512_set_epu8(UINT8_C(  90), UINT8_C( 218), UINT8_C( 158), UINT8_C( 186),
                             UINT8_C( 148), UINT8_C(  20), UINT8_C(  43), UINT8_C( 128),
                             UINT8_C(  77), UINT8_C( 108), UINT8_C(  53), UINT8_C(  82),
                             UINT8_C( 206), UINT8_C(  52), UINT8_C(  56), UINT8_C(  58),
                             UINT8_C( 136), UINT8_C( 213), UINT8_C( 114), UINT8_C(  93),
                             UINT8_C( 212), UINT8_C( 241), UINT8_C(  38), UINT8_C( 239),
                             UINT8_C( 146), UINT8_C( 133), UINT8_C( 217), UINT8_C( 114),
                             UINT8_C(  51), UINT8_C( 141), UINT8_C( 182), UINT8_C(  43),
                             UINT8_C(  41), UINT8_C( 220), UINT8_C(  19), UINT8_C(  69),
                             UINT8_C(  60), UINT8_C( 203), UINT8_C( 112), UINT8_C( 108),
                             UINT8_C(   8), UINT8_C(  46), UINT8_C( 221), UINT8_C(  26),
                             UINT8_C(  11), UINT8_C(  42), UINT8_C(  47), UINT8_C(  59),
                             UINT8_C( 199), UINT8_C(  94), UINT8_C( 131), UINT8_C( 132),
                             UINT8_C(  36), UINT8_C(  57), UINT8_C(  68), UINT8_C( 204),
                             UINT8_C(  39), UINT8_C(  50), UINT8_C( 208), UINT8_C(  94),
                             UINT8_C(  53), UINT8_C(  11), UINT8_C(  29), UINT8_C(  65)),
      simde_x_mm512_set_epu8(UINT8_C( 149), UINT8_C( 120), UINT8_C( 198), UINT8_C( 107),
                             UINT8_C( 224), UINT8_C( 224), UINT8_C(  88), UINT8_C( 213),
                             UINT8_C(  31), UINT8_C( 224), UINT8_C( 192), UINT8_C(  27),
                             UINT8_C(  82), UINT8_C( 166), UINT8_C( 202), UINT8_C( 172),
                             UINT8_C( 226), UINT8_C(  63), UINT8_C(  24), UINT8_C(  81),
                             UINT8_C( 248), UINT8_C(   9), UINT8_C( 221), UINT8_C( 155),
                             UINT8_C(  83), UINT8_C( 107), UINT8_C( 209), UINT8_C( 200),
                             UINT8_C(  57), UINT8_C( 168), UINT8_C( 141), UINT8_C( 236),
                             UINT8_C(  58), UINT8_C(  75), UINT8_C(  56), UINT8_C(  93),
                             UINT8_C(  49), UINT8_C(  43), UINT8_C( 108), UINT8_C( 118),
                             UINT8_C( 177), UINT8_C( 112), UINT8_C(  44), UINT8_C( 144),
                             UINT8_C( 204), UINT8_C(  10), UINT8_C(  28), UINT8_C( 170),
                             UINT8_C(  65), UINT8_C(  62), UINT8_C(  86), UINT8_C( 149),
                             UINT8_C(  24), UINT8_C( 201), UINT8_C(  54), UINT8_C( 146),
                             UINT8_C( 223), UINT8_C( 110), UINT8_C( 140), UINT8_C( 217),
                             UINT8_C(  39), UINT8_C( 144), UINT8_C(  64), UINT8_C(  43)),
      simde_x_mm512_set_epu8(UINT8_C( 239), UINT8_C( 203), UINT8_C( 255), UINT8_C( 126),
                             UINT8_C( 255), UINT8_C( 244), UINT8_C( 131), UINT8_C(  76),
                             UINT8_C( 108), UINT8_C( 123), UINT8_C( 169), UINT8_C( 106),
                             UINT8_C( 255), UINT8_C(  44), UINT8_C( 117), UINT8_C( 230),
                             UINT8_C(  81), UINT8_C( 255), UINT8_C( 138), UINT8_C( 174),
                             UINT8_C(  67), UINT8_C(  79), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 243), UINT8_C( 240), UINT8_C(  27), UINT8_C( 159),
                             UINT8_C( 102), UINT8_C( 255), UINT8_C(  38), UINT8_C( 194),
                             UINT8_C(  99), UINT8_C( 117), UINT8_C(  75), UINT8_C( 162),
                             UINT8_C( 109), UINT8_C( 132), UINT8_C( 220), UINT8_C( 226),
                             UINT8_C(  18), UINT8_C( 158), UINT8_C( 255), UINT8_C( 170),
                             UINT8_C( 249), UINT8_C(  52), UINT8_C(  75), UINT8_C(  48),
                             UINT8_C( 149), UINT8_C( 222), UINT8_C( 181), UINT8_C( 255),
                             UINT8_C( 221), UINT8_C( 140), UINT8_C(  65), UINT8_C( 255),
                             UINT8_C(  15), UINT8_C(   3), UINT8_C(  45), UINT8_C(  21),
                             UINT8_C(  92), UINT8_C(  93), UINT8_C( 108), UINT8_C( 125)) },
    { simde_x_mm512_set_epu8(UINT8_C( 153), UINT8_C( 132), UINT8_C(  13), UINT8_C( 176),
                             UINT8_C( 224), UINT8_C( 123), UINT8_C( 115), UINT8_C( 207),
                             UINT8_C( 113), UINT8_C( 205), UINT8_C( 119), UINT8_C( 189),
                             UINT8_C( 235), UINT8_C(  19), UINT8_C( 244), UINT8_C(  29),
                             UINT8_C(  91), UINT8_C( 192), UINT8_C(  88), UINT8_C( 151),
                             UINT8_C(  24), UINT8_C(  31), UINT8_C(  77), UINT8_C(  92),
                             UINT8_C( 171), UINT8_C(  48), UINT8_C( 143), UINT8_C( 142),
                             UINT8_C(  16), UINT8_C(  18), UINT8_C( 212), UINT8_C( 190),
                             UINT8_C(  25), UINT8_C( 151), UINT8_C( 156), UINT8_C( 165),
                             UINT8_C(  26), UINT8_C( 133), UINT8_C( 223), UINT8_C( 219),
                             UINT8_C(  63), UINT8_C(  13), UINT8_C( 132), UINT8_C(  41),
                             UINT8_C( 152), UINT8_C( 197), UINT8_C( 254), UINT8_C( 202),
                             UINT8_C(  73), UINT8_C(   3), UINT8_C( 238), UINT8_C(  10),
                             UINT8_C(  19), UINT8_C(  58), UINT8_C( 244), UINT8_C( 181),
                             UINT8_C( 168), UINT8_C(  59), UINT8_C( 104), UINT8_C( 216),
                             UINT8_C( 174), UINT8_C(  42), UINT8_C( 183), UINT8_C( 162)),
      UINT64_C( 2633789449456316803),
      simde_x_mm512_set_epu8(UINT8_C( 118), UINT8_C(  44), UINT8_C( 242), UINT8_C(  84),
                             UINT8_C( 187), UINT8_C( 208), UINT8_C(  40), UINT8_C(  86),
                             UINT8_C( 255), UINT8_C( 121), UINT8_C( 216), UINT8_C(  44),
                             UINT8_C( 255), UINT8_C(  38), UINT8_C( 212), UINT8_C(  38),
                             UINT8_C(  93), UINT8_C( 149), UINT8_C( 252), UINT8_C( 195),
                             UINT8_C( 204), UINT8_C(  22), UINT8_C( 202), UINT8_C( 131),
                             UINT8_C( 227), UINT8_C(  25), UINT8_C( 179), UINT8_C( 188),
                             UINT8_C(   9), UINT8_C( 221), UINT8_C( 245), UINT8_C(  53),
                             UINT8_C(  28), UINT8_C(  61), UINT8_C( 221), UINT8_C( 150),
                             UINT8_C( 210), UINT8_C( 121), UINT8_C( 154), UINT8_C( 121),
                             UINT8_C( 202), UINT8_C( 196), UINT8_C(   7), UINT8_C(   2),
                             UINT8_C( 137), UINT8_C( 111), UINT8_C( 236), UINT8_C( 198),
                             UINT8_C( 158), UINT8_C(  83), UINT8_C(  32), UINT8_C( 207),
                             UINT8_C( 245), UINT8_C(  48), UINT8_C(  92), UINT8_C(  47),
                             UINT8_C( 218), UINT8_C(  11), UINT8_C(  26), UINT8_C(  90),
                             UINT8_C( 251), UINT8_C(  73), UINT8_C(  45), UINT8_C( 254)),
      simde_x_mm512_set_epu8(UINT8_C( 225), UINT8_C( 126), UINT8_C( 138), UINT8_C( 199),
                             UINT8_C( 130), UINT8_C(  29), UINT8_C( 101), UINT8_C( 241),
                             UINT8_C( 195), UINT8_C( 118), UINT8_C( 102), UINT8_C(  12),
                             UINT8_C( 197), UINT8_C( 215), UINT8_C( 196), UINT8_C(  46),
                             UINT8_C(  63), UINT8_C(  78), UINT8_C(  87), UINT8_C(  18),
                             UINT8_C(  18), UINT8_C(  32), UINT8_C( 230), UINT8_C( 250),
                             UINT8_C( 236), UINT8_C( 133), UINT8_C(  99), UINT8_C(  65),
                             UINT8_C(  13), UINT8_C(  25), UINT8_C( 108), UINT8_C( 135),
                             UINT8_C(  42), UINT8_C(   0), UINT8_C( 104), UINT8_C( 239),
                             UINT8_C( 111), UINT8_C( 146), UINT8_C( 217), UINT8_C( 125),
                             UINT8_C( 206), UINT8_C( 209), UINT8_C(  30), UINT8_C(  92),
                             UINT8_C(  19), UINT8_C( 248), UINT8_C( 136), UINT8_C( 127),
                             UINT8_C( 207), UINT8_C(  23), UINT8_C(  16), UINT8_C( 192),
                             UINT8_C( 177), UINT8_C( 116), UINT8_C( 251), UINT8_C( 206),
                             UINT8_C(  32), UINT8_C(  22), UINT8_C( 214), UINT8_C( 253),
                             UINT8_C(  30), UINT8_C(  64), UINT8_C(  96), UINT8_C( 190)),
      simde_x_mm512_set_epu8(UINT8_C( 153), UINT8_C( 132), UINT8_C( 255), UINT8_C( 176),
                             UINT8_C( 224), UINT8_C( 237), UINT8_C( 115), UINT8_C( 207),
                             UINT8_C( 255), UINT8_C( 205), UINT8_C( 119), UINT8_C( 189),
                             UINT8_C( 255), UINT8_C( 253), UINT8_C( 244), UINT8_C(  84),
                             UINT8_C(  91), UINT8_C( 192), UINT8_C(  88), UINT8_C( 213),
                             UINT8_C( 222), UINT8_C(  31), UINT8_C(  77), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(  48), UINT8_C( 143), UINT8_C( 142),
                             UINT8_C(  22), UINT8_C( 246), UINT8_C( 212), UINT8_C( 190),
                             UINT8_C(  70), UINT8_C(  61), UINT8_C( 156), UINT8_C( 165),
                             UINT8_C(  26), UINT8_C( 255), UINT8_C( 223), UINT8_C( 219),
                             UINT8_C(  63), UINT8_C(  13), UINT8_C( 132), UINT8_C(  41),
                             UINT8_C( 152), UINT8_C( 197), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C( 106), UINT8_C(  48), UINT8_C( 255),
                             UINT8_C(  19), UINT8_C(  58), UINT8_C( 244), UINT8_C( 253),
                             UINT8_C( 250), UINT8_C(  59), UINT8_C( 104), UINT8_C( 216),
                             UINT8_C( 174), UINT8_C(  42), UINT8_C( 141), UINT8_C( 255)) },
    { simde_x_mm512_set_epu8(UINT8_C( 117), UINT8_C(  69), UINT8_C( 121), UINT8_C( 211),
                             UINT8_C(  30), UINT8_C( 183), UINT8_C(   2), UINT8_C( 216),
                             UINT8_C(  95), UINT8_C( 253), UINT8_C(  16), UINT8_C( 178),
                             UINT8_C( 128), UINT8_C( 215), UINT8_C( 190), UINT8_C(  66),
                             UINT8_C(  93), UINT8_C( 224), UINT8_C( 206), UINT8_C( 254),
                             UINT8_C( 195), UINT8_C(  29), UINT8_C( 168), UINT8_C( 138),
                             UINT8_C( 229), UINT8_C(  42), UINT8_C(  78), UINT8_C( 210),
                             UINT8_C( 177), UINT8_C(  38), UINT8_C( 181), UINT8_C(  14),
                             UINT8_C( 138), UINT8_C( 142), UINT8_C( 136), UINT8_C(  42),
                             UINT8_C(   4), UINT8_C(  79), UINT8_C( 172), UINT8_C( 146),
                             UINT8_C(   0), UINT8_C(  85), UINT8_C( 236), UINT8_C(  61),
                             UINT8_C(  40), UINT8_C( 181), UINT8_C(  69), UINT8_C( 157),
                             UINT8_C(  73), UINT8_C( 222), UINT8_C( 242), UINT8_C(  72),
                             UINT8_C( 101), UINT8_C(  96), UINT8_C( 142), UINT8_C( 132),
                             UINT8_C( 169), UINT8_C(  43), UINT8_C( 138), UINT8_C( 114),
                             UINT8_C( 168), UINT8_C(   8), UINT8_C( 204), UINT8_C(  75)),
      UINT64_C(14890918166471265655),
      simde_x_mm512_set_epu8(UINT8_C( 200), UINT8_C( 186), UINT8_C(  66), UINT8_C( 145),
                             UINT8_C( 187), UINT8_C(  15), UINT8_C( 174), UINT8_C( 244),
                             UINT8_C( 167), UINT8_C(  37), UINT8_C(  80), UINT8_C( 120),
                             UINT8_C( 173), UINT8_C( 136), UINT8_C(  95), UINT8_C(  21),
                             UINT8_C(  91), UINT8_C( 159), UINT8_C( 184), UINT8_C(  42),
                             UINT8_C(  22), UINT8_C( 186), UINT8_C(  71), UINT8_C( 178),
                             UINT8_C( 251), UINT8_C(  52), UINT8_C( 234), UINT8_C( 222),
                             UINT8_C(  16), UINT8_C(  92), UINT8_C(  91), UINT8_C( 184),
                             UINT8_C(   3), UINT8_C( 225), UINT8_C( 161), UINT8_C( 200),
                             UINT8_C( 206), UINT8_C(  68), UINT8_C( 232), UINT8_C( 206),
                             UINT8_C(  94), UINT8_C(  67), UINT8_C( 108), UINT8_C( 138),
                             UINT8_C( 191), UINT8_C(  31), UINT8_C(  70), UINT8_C( 108),
                             UINT8_C( 190), UINT8_C( 107), UINT8_C( 171), UINT8_C(  38),
                             UINT8_C(   2), UINT8_C(  32), UINT8_C(  56), UINT8_C(  66),
                             UINT8_C( 254), UINT8_C( 182), UINT8_C( 112), UINT8_C(  10),
                             UINT8_C(  64), UINT8_C( 100), UINT8_C( 201), UINT8_C(  83)),
      simde_x_mm512_set_epu8(UINT8_C( 187), UINT8_C( 211), UINT8_C(  23), UINT8_C(  70),
                             UINT8_C(  22), UINT8_C( 113), UINT8_C(  75), UINT8_C( 139),
                             UINT8_C(  69), UINT8_C( 182), UINT8_C(  40), UINT8_C( 217),
                             UINT8_C( 205), UINT8_C( 165), UINT8_C(  25), UINT8_C( 252),
                             UINT8_C( 244), UINT8_C( 243), UINT8_C( 179), UINT8_C(  75),
                             UINT8_C( 140), UINT8_C( 220), UINT8_C(  38), UINT8_C( 204),
                             UINT8_C(  13), UINT8_C( 204), UINT8_C( 156), UINT8_C( 210),
                             UINT8_C(  13), UINT8_C(  83), UINT8_C( 162), UINT8_C( 102),
                             UINT8_C( 116), UINT8_C( 196), UINT8_C(  44), UINT8_C( 249),
                             UINT8_C( 104), UINT8_C( 206), UINT8_C( 226), UINT8_C(  17),
                             UINT8_C(  13), UINT8_C( 149), UINT8_C( 111), UINT8_C( 243),
                             UINT8_C(  17), UINT8_C( 211), UINT8_C( 225), UINT8_C(  76),
                             UINT8_C( 154), UINT8_C( 185), UINT8_C( 116), UINT8_C(  72),
                             UINT8_C( 245), UINT8_C( 159), UINT8_C(  93), UINT8_C(  48),
                             UINT8_C( 181), UINT8_C( 166), UINT8_C( 246), UINT8_C( 178),
                             UINT8_C( 248), UINT8_C( 246), UINT8_C(  48), UINT8_C( 245)),
      simde_x_mm512_set_epu8(UINT8_C( 255), UINT8_C( 255), UINT8_C( 121), UINT8_C( 211),
                             UINT8_C( 209), UINT8_C( 128), UINT8_C( 249), UINT8_C( 216),
                             UINT8_C( 236), UINT8_C( 253), UINT8_C( 120), UINT8_C( 178),
                             UINT8_C( 128), UINT8_C( 255), UINT8_C( 120), UINT8_C( 255),
                             UINT8_C(  93), UINT8_C( 224), UINT8_C( 255), UINT8_C( 254),
                             UINT8_C( 162), UINT8_C(  29), UINT8_C( 109), UINT8_C( 255),
                             UINT8_C( 229), UINT8_C(  42), UINT8_C( 255), UINT8_C( 210),
                             UINT8_C(  29), UINT8_C( 175), UINT8_C( 181), UINT8_C( 255),
                             UINT8_C( 138), UINT8_C( 255), UINT8_C( 136), UINT8_C(  42),
                             UINT8_C( 255), UINT8_C(  79), UINT8_C( 255), UINT8_C( 223),
                             UINT8_C( 107), UINT8_C( 216), UINT8_C( 219), UINT8_C(  61),
                             UINT8_C( 208), UINT8_C( 242), UINT8_C( 255), UINT8_C( 157),
                             UINT8_C(  73), UINT8_C( 255), UINT8_C( 242), UINT8_C(  72),
                             UINT8_C( 247), UINT8_C( 191), UINT8_C( 142), UINT8_C( 114),
                             UINT8_C( 169), UINT8_C( 255), UINT8_C( 255), UINT8_C( 188),
                             UINT8_C( 168), UINT8_C( 255), UINT8_C( 249), UINT8_C( 255)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_adds_epu8(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_maskz_adds_epu8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C(17286015531074160252),
      simde_x_mm512_set_epu8(UINT8_C( 141), UINT8_C( 229), UINT8_C(  62), UINT8_C( 171),
                             UINT8_C(  49), UINT8_C( 141), UINT8_C(  38), UINT8_C(   4),
                             UINT8_C(  92), UINT8_C( 116), UINT8_C( 178), UINT8_C( 237),
                             UINT8_C( 183), UINT8_C(  22), UINT8_C( 190), UINT8_C( 227),
                             UINT8_C(  55), UINT8_C(  78), UINT8_C( 211), UINT8_C( 137),
                             UINT8_C(  30), UINT8_C( 227), UINT8_C( 233), UINT8_C(  89),
                             UINT8_C(  15), UINT8_C( 119), UINT8_C( 168), UINT8_C( 109),
                             UINT8_C( 240), UINT8_C( 246), UINT8_C(   0), UINT8_C( 238),
                             UINT8_C(   1), UINT8_C( 116), UINT8_C(  62), UINT8_C( 183),
                             UINT8_C( 134), UINT8_C(   0), UINT8_C( 111), UINT8_C(  95),
                             UINT8_C( 236), UINT8_C(   3), UINT8_C( 122), UINT8_C( 135),
                             UINT8_C(  13), UINT8_C(  25), UINT8_C( 221), UINT8_C( 129),
                             UINT8_C(  82), UINT8_C(  90), UINT8_C(  53), UINT8_C( 123),
                             UINT8_C(  73), UINT8_C( 108), UINT8_C( 238), UINT8_C(  15),
                             UINT8_C(  81), UINT8_C( 229), UINT8_C( 102), UINT8_C( 118),
                             UINT8_C(  39), UINT8_C( 179), UINT8_C(  45), UINT8_C(  81)),
      simde_x_mm512_set_epu8(UINT8_C(  68), UINT8_C( 148), UINT8_C( 135), UINT8_C( 141),
                             UINT8_C( 197), UINT8_C( 178), UINT8_C( 145), UINT8_C(  56),
                             UINT8_C(   9), UINT8_C( 135), UINT8_C( 120), UINT8_C( 220),
                             UINT8_C(  36), UINT8_C( 153), UINT8_C( 152), UINT8_C(  25),
                             UINT8_C( 145), UINT8_C( 193), UINT8_C( 221), UINT8_C( 136),
                             UINT8_C(  28), UINT8_C( 212), UINT8_C( 230), UINT8_C( 170),
                             UINT8_C( 243), UINT8_C(  53), UINT8_C( 168), UINT8_C( 149),
                             UINT8_C(  68), UINT8_C(  42), UINT8_C( 138), UINT8_C( 111),
                             UINT8_C(  54), UINT8_C( 198), UINT8_C( 243), UINT8_C(  27),
                             UINT8_C(  23), UINT8_C(  41), UINT8_C( 137), UINT8_C(  44),
                             UINT8_C(   7), UINT8_C( 136), UINT8_C(  32), UINT8_C( 213),
                             UINT8_C( 114), UINT8_C( 184), UINT8_C(  73), UINT8_C( 160),
                             UINT8_C(  96), UINT8_C( 110), UINT8_C( 175), UINT8_C( 180),
                             UINT8_C( 103), UINT8_C( 156), UINT8_C( 234), UINT8_C(  18),
                             UINT8_C( 115), UINT8_C(  54), UINT8_C( 216), UINT8_C( 125),
                             UINT8_C( 110), UINT8_C(  31), UINT8_C(  51), UINT8_C( 152)),
      simde_x_mm512_set_epu8(UINT8_C( 209), UINT8_C( 255), UINT8_C( 197), UINT8_C(   0),
                             UINT8_C( 246), UINT8_C( 255), UINT8_C( 183), UINT8_C(  60),
                             UINT8_C( 101), UINT8_C( 251), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 175), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C( 138), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 157), UINT8_C(  41), UINT8_C( 248), UINT8_C( 139),
                             UINT8_C( 243), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 127), UINT8_C( 209), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 178), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 255), UINT8_C( 243),
                             UINT8_C( 149), UINT8_C( 210), UINT8_C(   0), UINT8_C(   0)) },
    { UINT64_C( 9031211210081693899),
      simde_x_mm512_set_epu8(UINT8_C( 150), UINT8_C( 238), UINT8_C(  65), UINT8_C( 152),
                             UINT8_C(  81), UINT8_C(  38), UINT8_C( 172), UINT8_C( 254),
                             UINT8_C( 242), UINT8_C(  85), UINT8_C( 176), UINT8_C(  80),
                             UINT8_C(  48), UINT8_C(  93), UINT8_C(  79), UINT8_C( 127),
                             UINT8_C(  16), UINT8_C(  41), UINT8_C(  54), UINT8_C( 140),
                             UINT8_C(  17), UINT8_C(  42), UINT8_C( 170), UINT8_C(  38),
                             UINT8_C( 138), UINT8_C( 200), UINT8_C(  60), UINT8_C(  19),
                             UINT8_C( 156), UINT8_C( 149), UINT8_C( 105), UINT8_C( 180),
                             UINT8_C(  10), UINT8_C( 247), UINT8_C( 244), UINT8_C( 200),
                             UINT8_C( 185), UINT8_C(  96), UINT8_C(   6), UINT8_C(  24),
                             UINT8_C(  69), UINT8_C(  73), UINT8_C( 229), UINT8_C(   3),
                             UINT8_C( 161), UINT8_C(  50), UINT8_C( 189), UINT8_C( 217),
                             UINT8_C(  97), UINT8_C(  62), UINT8_C( 101), UINT8_C(  56),
                             UINT8_C( 177), UINT8_C(  83), UINT8_C( 157), UINT8_C( 200),
                             UINT8_C( 239), UINT8_C( 200), UINT8_C( 248), UINT8_C( 240),
                             UINT8_C(  84), UINT8_C( 161), UINT8_C( 183), UINT8_C(  54)),
      simde_x_mm512_set_epu8(UINT8_C(  63), UINT8_C( 205), UINT8_C(  87), UINT8_C(  32),
                             UINT8_C( 191), UINT8_C(  55), UINT8_C(  14), UINT8_C(  81),
                             UINT8_C( 133), UINT8_C( 156), UINT8_C( 217), UINT8_C( 212),
                             UINT8_C(  22), UINT8_C( 112), UINT8_C(  16), UINT8_C(  15),
                             UINT8_C( 152), UINT8_C( 154), UINT8_C( 102), UINT8_C( 161),
                             UINT8_C(  69), UINT8_C(  13), UINT8_C( 235), UINT8_C(  45),
                             UINT8_C(  62), UINT8_C( 136), UINT8_C( 145), UINT8_C(  32),
                             UINT8_C( 149), UINT8_C( 226), UINT8_C(  99), UINT8_C( 192),
                             UINT8_C(   8), UINT8_C( 214), UINT8_C(  81), UINT8_C( 222),
                             UINT8_C( 210), UINT8_C(  26), UINT8_C(  31), UINT8_C( 254),
                             UINT8_C(  68), UINT8_C( 249), UINT8_C( 185), UINT8_C(  46),
                             UINT8_C( 235), UINT8_C( 183), UINT8_C(  21), UINT8_C(  83),
                             UINT8_C( 148), UINT8_C( 159), UINT8_C( 187), UINT8_C(  73),
                             UINT8_C(  57), UINT8_C( 219), UINT8_C(  21), UINT8_C(  82),
                             UINT8_C( 137), UINT8_C( 130), UINT8_C( 126), UINT8_C(  91),
                             UINT8_C( 115), UINT8_C(  31), UINT8_C( 177), UINT8_C(  28)),
      simde_x_mm512_set_epu8(UINT8_C(   0), UINT8_C( 255), UINT8_C( 152), UINT8_C( 184),
                             UINT8_C( 255), UINT8_C(  93), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C( 241), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C( 205), UINT8_C(   0), UINT8_C( 142),
                             UINT8_C(   0), UINT8_C( 195), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(  86), UINT8_C(  55), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 200), UINT8_C(   0), UINT8_C( 205), UINT8_C(  51),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 204), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 122), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 255), UINT8_C(  49),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 245), UINT8_C( 221), UINT8_C( 255), UINT8_C( 129),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 199), UINT8_C(   0), UINT8_C( 255), UINT8_C(  82)) },
    { UINT64_C( 6828010367541473016),
      simde_x_mm512_set_epu8(UINT8_C(  84), UINT8_C( 160), UINT8_C(  87), UINT8_C( 234),
                             UINT8_C( 251), UINT8_C( 253), UINT8_C( 129), UINT8_C(  41),
                             UINT8_C(  74), UINT8_C(  72), UINT8_C( 252), UINT8_C(  28),
                             UINT8_C( 141), UINT8_C(  93), UINT8_C( 102), UINT8_C(  44),
                             UINT8_C( 153), UINT8_C( 227), UINT8_C( 206), UINT8_C(  48),
                             UINT8_C( 160), UINT8_C( 206), UINT8_C(  46), UINT8_C( 191),
                             UINT8_C(   4), UINT8_C(  43), UINT8_C( 181), UINT8_C(  97),
                             UINT8_C( 230), UINT8_C( 153), UINT8_C(  71), UINT8_C( 149),
                             UINT8_C(  91), UINT8_C(  45), UINT8_C( 245), UINT8_C(  47),
                             UINT8_C(  29), UINT8_C(  25), UINT8_C(  26), UINT8_C( 247),
                             UINT8_C(  10), UINT8_C(  36), UINT8_C( 177), UINT8_C( 203),
                             UINT8_C(  41), UINT8_C(   1), UINT8_C( 233), UINT8_C( 193),
                             UINT8_C( 129), UINT8_C(  68), UINT8_C(  48), UINT8_C(  36),
                             UINT8_C(  89), UINT8_C( 144), UINT8_C( 225), UINT8_C( 120),
                             UINT8_C(  35), UINT8_C(  62), UINT8_C( 235), UINT8_C( 142),
                             UINT8_C( 152), UINT8_C(  57), UINT8_C(  42), UINT8_C( 145)),
      simde_x_mm512_set_epu8(UINT8_C(  96), UINT8_C( 192), UINT8_C( 233), UINT8_C( 210),
                             UINT8_C( 227), UINT8_C( 185), UINT8_C(  71), UINT8_C(  90),
                             UINT8_C(  44), UINT8_C( 164), UINT8_C( 225), UINT8_C(  26),
                             UINT8_C( 157), UINT8_C( 203), UINT8_C( 117), UINT8_C(  18),
                             UINT8_C( 193), UINT8_C(  45), UINT8_C(  12), UINT8_C(  24),
                             UINT8_C( 148), UINT8_C(  18), UINT8_C( 196), UINT8_C(  28),
                             UINT8_C(  50), UINT8_C( 245), UINT8_C( 188), UINT8_C( 225),
                             UINT8_C( 105), UINT8_C( 150), UINT8_C(  98), UINT8_C(  51),
                             UINT8_C(  58), UINT8_C( 103), UINT8_C( 111), UINT8_C( 129),
                             UINT8_C(  68), UINT8_C( 200), UINT8_C( 124), UINT8_C( 137),
                             UINT8_C(  74), UINT8_C( 194), UINT8_C( 140), UINT8_C(  37),
                             UINT8_C( 244), UINT8_C( 114), UINT8_C(   0), UINT8_C(  61),
                             UINT8_C( 103), UINT8_C( 252), UINT8_C( 151), UINT8_C( 188),
                             UINT8_C(  39), UINT8_C( 156), UINT8_C( 163), UINT8_C(  11),
                             UINT8_C( 176), UINT8_C( 237), UINT8_C( 234), UINT8_C( 217),
                             UINT8_C( 127), UINT8_C( 218), UINT8_C( 131), UINT8_C( 145)),
      simde_x_mm512_set_epu8(UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 200), UINT8_C(   0),
                             UINT8_C( 118), UINT8_C( 236), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(  62),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 218), UINT8_C(  72),
                             UINT8_C(   0), UINT8_C( 224), UINT8_C( 242), UINT8_C( 219),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 149), UINT8_C(   0), UINT8_C( 255), UINT8_C( 176),
                             UINT8_C(  97), UINT8_C( 225), UINT8_C( 150), UINT8_C( 255),
                             UINT8_C(  84), UINT8_C( 230), UINT8_C( 255), UINT8_C( 240),
                             UINT8_C( 255), UINT8_C( 115), UINT8_C( 233), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 199), UINT8_C(   0),
                             UINT8_C( 128), UINT8_C( 255), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 211), UINT8_C( 255), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0)) },
    { UINT64_C(18325019528117086600),
      simde_x_mm512_set_epu8(UINT8_C( 122), UINT8_C( 202), UINT8_C(  50), UINT8_C( 123),
                             UINT8_C( 225), UINT8_C( 182), UINT8_C( 192), UINT8_C(  54),
                             UINT8_C( 175), UINT8_C(  60), UINT8_C(  31), UINT8_C( 233),
                             UINT8_C( 108), UINT8_C( 137), UINT8_C( 164), UINT8_C( 176),
                             UINT8_C( 226), UINT8_C( 219), UINT8_C(  51), UINT8_C( 220),
                             UINT8_C(   8), UINT8_C(  52), UINT8_C(  97), UINT8_C( 123),
                             UINT8_C( 207), UINT8_C( 132), UINT8_C(  95), UINT8_C( 173),
                             UINT8_C(  70), UINT8_C( 206), UINT8_C( 195), UINT8_C(  25),
                             UINT8_C( 159), UINT8_C(  28), UINT8_C( 198), UINT8_C(  11),
                             UINT8_C( 242), UINT8_C( 126), UINT8_C(  81), UINT8_C(  45),
                             UINT8_C( 233), UINT8_C( 120), UINT8_C( 173), UINT8_C( 240),
                             UINT8_C(   7), UINT8_C(  51), UINT8_C( 199), UINT8_C( 206),
                             UINT8_C( 235), UINT8_C(  98), UINT8_C(  88), UINT8_C(   0),
                             UINT8_C( 190), UINT8_C(   3), UINT8_C( 124), UINT8_C( 143),
                             UINT8_C(  50), UINT8_C(  88), UINT8_C( 171), UINT8_C( 163),
                             UINT8_C( 212), UINT8_C( 243), UINT8_C( 162), UINT8_C(  17)),
      simde_x_mm512_set_epu8(UINT8_C( 243), UINT8_C( 244), UINT8_C( 132), UINT8_C(  96),
                             UINT8_C( 243), UINT8_C( 158), UINT8_C(  99), UINT8_C( 243),
                             UINT8_C(  56), UINT8_C( 211), UINT8_C( 148), UINT8_C( 237),
                             UINT8_C( 132), UINT8_C( 229), UINT8_C(  22), UINT8_C( 126),
                             UINT8_C( 150), UINT8_C( 188), UINT8_C( 196), UINT8_C(   8),
                             UINT8_C(  60), UINT8_C(  93), UINT8_C( 223), UINT8_C( 229),
                             UINT8_C( 249), UINT8_C(  27), UINT8_C( 134), UINT8_C( 218),
                             UINT8_C(  23), UINT8_C(   6), UINT8_C(  45), UINT8_C( 235),
                             UINT8_C( 233), UINT8_C( 155), UINT8_C( 116), UINT8_C( 127),
                             UINT8_C(  96), UINT8_C(  40), UINT8_C( 159), UINT8_C(  40),
                             UINT8_C(  86), UINT8_C( 212), UINT8_C(  70), UINT8_C( 185),
                             UINT8_C(  62), UINT8_C( 235), UINT8_C(  66), UINT8_C(  68),
                             UINT8_C( 169), UINT8_C( 195), UINT8_C(  48), UINT8_C( 186),
                             UINT8_C(  18), UINT8_C( 178), UINT8_C( 158), UINT8_C( 117),
                             UINT8_C(  74), UINT8_C(  32), UINT8_C(  93), UINT8_C( 125),
                             UINT8_C( 209), UINT8_C( 196), UINT8_C( 170), UINT8_C( 117)),
      simde_x_mm512_set_epu8(UINT8_C( 255), UINT8_C( 255), UINT8_C( 182), UINT8_C( 219),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 240), UINT8_C( 255), UINT8_C( 186), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(  68), UINT8_C( 145), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 229), UINT8_C(   0),
                             UINT8_C(  93), UINT8_C(   0), UINT8_C( 240), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C( 255), UINT8_C( 138),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 240), UINT8_C(  85),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 136), UINT8_C(   0),
                             UINT8_C( 208), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 124), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0)) },
    { UINT64_C( 7677112093376593822),
      simde_x_mm512_set_epu8(UINT8_C( 203), UINT8_C(  34), UINT8_C(   9), UINT8_C(  64),
                             UINT8_C( 195), UINT8_C( 231), UINT8_C( 141), UINT8_C( 100),
                             UINT8_C(  65), UINT8_C(   8), UINT8_C(  69), UINT8_C( 248),
                             UINT8_C( 241), UINT8_C( 205), UINT8_C(   1), UINT8_C(  90),
                             UINT8_C( 115), UINT8_C(  51), UINT8_C( 165), UINT8_C(  56),
                             UINT8_C(  64), UINT8_C( 217), UINT8_C( 137), UINT8_C( 228),
                             UINT8_C( 202), UINT8_C(  28), UINT8_C(  54), UINT8_C( 248),
                             UINT8_C( 202), UINT8_C( 128), UINT8_C( 228), UINT8_C( 185),
                             UINT8_C( 107), UINT8_C( 190), UINT8_C( 142), UINT8_C( 168),
                             UINT8_C(  34), UINT8_C( 173), UINT8_C( 235), UINT8_C( 192),
                             UINT8_C( 121), UINT8_C( 236), UINT8_C( 167), UINT8_C( 162),
                             UINT8_C( 112), UINT8_C( 229), UINT8_C(  81), UINT8_C( 202),
                             UINT8_C( 192), UINT8_C( 142), UINT8_C(  48), UINT8_C( 167),
                             UINT8_C( 195), UINT8_C(  26), UINT8_C(  43), UINT8_C(  29),
                             UINT8_C(   0), UINT8_C(  64), UINT8_C( 123), UINT8_C( 189),
                             UINT8_C(  15), UINT8_C( 120), UINT8_C(  36), UINT8_C(  40)),
      simde_x_mm512_set_epu8(UINT8_C( 113), UINT8_C(  32), UINT8_C(  71), UINT8_C(  55),
                             UINT8_C( 230), UINT8_C(  82), UINT8_C( 175), UINT8_C( 236),
                             UINT8_C( 201), UINT8_C( 112), UINT8_C(  45), UINT8_C(  37),
                             UINT8_C(  67), UINT8_C( 187), UINT8_C(  64), UINT8_C(  39),
                             UINT8_C(  72), UINT8_C(  45), UINT8_C( 120), UINT8_C( 251),
                             UINT8_C( 147), UINT8_C(  62), UINT8_C(  17), UINT8_C(  31),
                             UINT8_C( 226), UINT8_C( 198), UINT8_C(  56), UINT8_C(  21),
                             UINT8_C(  72), UINT8_C( 182), UINT8_C( 216), UINT8_C( 120),
                             UINT8_C(  95), UINT8_C( 108), UINT8_C(  32), UINT8_C(  64),
                             UINT8_C( 128), UINT8_C( 102), UINT8_C( 235), UINT8_C(  28),
                             UINT8_C( 105), UINT8_C(  52), UINT8_C(  85), UINT8_C( 152),
                             UINT8_C(  57), UINT8_C( 225), UINT8_C( 218), UINT8_C( 132),
                             UINT8_C( 149), UINT8_C( 254), UINT8_C(  55), UINT8_C(  46),
                             UINT8_C( 185), UINT8_C(  77), UINT8_C(  18), UINT8_C(  70),
                             UINT8_C(  89), UINT8_C( 125), UINT8_C( 214), UINT8_C( 131),
                             UINT8_C( 121), UINT8_C( 245), UINT8_C( 187), UINT8_C( 197)),
      simde_x_mm512_set_epu8(UINT8_C(   0), UINT8_C(  66), UINT8_C(  80), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(  65), UINT8_C(   0),
                             UINT8_C( 187), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 226), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C( 232),
                             UINT8_C( 162), UINT8_C(   0), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 226), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 103), UINT8_C( 213),
                             UINT8_C( 255), UINT8_C( 103), UINT8_C(  61), UINT8_C(  99),
                             UINT8_C(  89), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 136), UINT8_C( 255), UINT8_C( 223), UINT8_C(   0)) },
    { UINT64_C( 4840581956081845689),
      simde_x_mm512_set_epu8(UINT8_C( 122), UINT8_C( 148), UINT8_C( 186), UINT8_C( 193),
                             UINT8_C(  56), UINT8_C(  71), UINT8_C( 242), UINT8_C(  49),
                             UINT8_C( 183), UINT8_C(  53), UINT8_C( 227), UINT8_C(   3),
                             UINT8_C( 183), UINT8_C(  43), UINT8_C( 234), UINT8_C(  85),
                             UINT8_C( 230), UINT8_C( 247), UINT8_C(  66), UINT8_C(   1),
                             UINT8_C( 243), UINT8_C(  60), UINT8_C( 137), UINT8_C( 173),
                             UINT8_C( 134), UINT8_C( 192), UINT8_C( 173), UINT8_C( 182),
                             UINT8_C( 119), UINT8_C( 248), UINT8_C(  12), UINT8_C( 113),
                             UINT8_C( 244), UINT8_C( 172), UINT8_C(   6), UINT8_C(  69),
                             UINT8_C(   2), UINT8_C( 181), UINT8_C( 222), UINT8_C( 130),
                             UINT8_C(   3), UINT8_C( 128), UINT8_C( 247), UINT8_C(  24),
                             UINT8_C(  11), UINT8_C( 162), UINT8_C( 224), UINT8_C( 110),
                             UINT8_C(  33), UINT8_C( 232), UINT8_C( 125), UINT8_C(  35),
                             UINT8_C( 153), UINT8_C( 208), UINT8_C( 234), UINT8_C(  38),
                             UINT8_C( 175), UINT8_C(   9), UINT8_C( 245), UINT8_C( 132),
                             UINT8_C(  71), UINT8_C(  31), UINT8_C( 214), UINT8_C(  93)),
      simde_x_mm512_set_epu8(UINT8_C(  53), UINT8_C(  77), UINT8_C(  63), UINT8_C( 172),
                             UINT8_C(  27), UINT8_C(  22), UINT8_C(   3), UINT8_C( 219),
                             UINT8_C(  65), UINT8_C( 118), UINT8_C( 130), UINT8_C(  97),
                             UINT8_C( 109), UINT8_C(   7), UINT8_C( 142), UINT8_C( 181),
                             UINT8_C( 131), UINT8_C( 121), UINT8_C( 128), UINT8_C( 103),
                             UINT8_C(   0), UINT8_C( 101), UINT8_C( 215), UINT8_C(  89),
                             UINT8_C( 173), UINT8_C( 191), UINT8_C(   9), UINT8_C( 249),
                             UINT8_C( 193), UINT8_C(  13), UINT8_C( 105), UINT8_C(  92),
                             UINT8_C( 238), UINT8_C( 235), UINT8_C( 154), UINT8_C( 142),
                             UINT8_C(  74), UINT8_C( 121), UINT8_C( 211), UINT8_C(  52),
                             UINT8_C( 193), UINT8_C( 163), UINT8_C(  98), UINT8_C( 106),
                             UINT8_C( 147), UINT8_C( 209), UINT8_C(  37), UINT8_C(  70),
                             UINT8_C( 100), UINT8_C( 121), UINT8_C(  18), UINT8_C(  28),
                             UINT8_C( 139), UINT8_C( 107), UINT8_C(   3), UINT8_C( 194),
                             UINT8_C(  42), UINT8_C(  72), UINT8_C(  91), UINT8_C(  86),
                             UINT8_C( 184), UINT8_C(   9), UINT8_C( 176), UINT8_C( 118)),
      simde_x_mm512_set_epu8(UINT8_C(   0), UINT8_C( 225), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 245), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C(  50), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 194), UINT8_C( 104),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C( 182), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 160), UINT8_C( 211),
                             UINT8_C(  76), UINT8_C( 255), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 158), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 133), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C( 232),
                             UINT8_C( 217), UINT8_C(   0), UINT8_C( 255), UINT8_C( 218),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C( 211)) },
    { UINT64_C(17498311407133456191),
      simde_x_mm512_set_epu8(UINT8_C(  61), UINT8_C( 167), UINT8_C(  84), UINT8_C( 162),
                             UINT8_C(  31), UINT8_C( 140), UINT8_C( 189), UINT8_C( 154),
                             UINT8_C( 184), UINT8_C( 165), UINT8_C( 151), UINT8_C( 148),
                             UINT8_C( 212), UINT8_C(  74), UINT8_C( 228), UINT8_C( 124),
                             UINT8_C( 120), UINT8_C( 215), UINT8_C( 177), UINT8_C( 122),
                             UINT8_C(  87), UINT8_C( 137), UINT8_C(  54), UINT8_C( 254),
                             UINT8_C( 209), UINT8_C(  84), UINT8_C( 130), UINT8_C( 192),
                             UINT8_C(  14), UINT8_C(  11), UINT8_C(  37), UINT8_C( 233),
                             UINT8_C(  67), UINT8_C( 124), UINT8_C(  58), UINT8_C( 162),
                             UINT8_C(  30), UINT8_C( 223), UINT8_C(  70), UINT8_C( 232),
                             UINT8_C(  38), UINT8_C( 159), UINT8_C( 200), UINT8_C( 196),
                             UINT8_C( 197), UINT8_C(  65), UINT8_C( 182), UINT8_C(  45),
                             UINT8_C( 245), UINT8_C(  55), UINT8_C( 174), UINT8_C(  12),
                             UINT8_C( 106), UINT8_C(  22), UINT8_C( 132), UINT8_C( 252),
                             UINT8_C(   2), UINT8_C( 175), UINT8_C(  14), UINT8_C(  90),
                             UINT8_C( 156), UINT8_C( 134), UINT8_C( 221), UINT8_C(  81)),
      simde_x_mm512_set_epu8(UINT8_C(  21), UINT8_C( 108), UINT8_C( 125), UINT8_C( 196),
                             UINT8_C( 184), UINT8_C(  74), UINT8_C( 251), UINT8_C( 198),
                             UINT8_C( 215), UINT8_C(  22), UINT8_C( 141), UINT8_C( 102),
                             UINT8_C(  59), UINT8_C( 176), UINT8_C( 241), UINT8_C( 193),
                             UINT8_C(  84), UINT8_C( 185), UINT8_C(   8), UINT8_C(  12),
                             UINT8_C( 245), UINT8_C( 180), UINT8_C(  62), UINT8_C(  93),
                             UINT8_C( 181), UINT8_C( 179), UINT8_C( 172), UINT8_C( 148),
                             UINT8_C( 221), UINT8_C(  14), UINT8_C( 196), UINT8_C(  18),
                             UINT8_C(  23), UINT8_C( 196), UINT8_C( 193), UINT8_C( 142),
                             UINT8_C( 201), UINT8_C(  75), UINT8_C( 157), UINT8_C( 201),
                             UINT8_C(  58), UINT8_C(  76), UINT8_C( 154), UINT8_C( 138),
                             UINT8_C( 226), UINT8_C(  39), UINT8_C( 119), UINT8_C(  85),
                             UINT8_C( 248), UINT8_C( 184), UINT8_C( 196), UINT8_C( 162),
                             UINT8_C( 144), UINT8_C( 119), UINT8_C( 124), UINT8_C(  76),
                             UINT8_C( 214), UINT8_C( 132), UINT8_C(  54), UINT8_C(  74),
                             UINT8_C( 164), UINT8_C(  99), UINT8_C(  79), UINT8_C( 253)),
      simde_x_mm512_set_epu8(UINT8_C(  82), UINT8_C( 255), UINT8_C( 209), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 187), UINT8_C(   0), UINT8_C( 250),
                             UINT8_C(   0), UINT8_C( 250), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 185), UINT8_C( 134),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 233), UINT8_C( 251),
                             UINT8_C(  90), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 227), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C( 235), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 239), UINT8_C( 255), UINT8_C( 174),
                             UINT8_C(   0), UINT8_C( 141), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(  68), UINT8_C( 164),
                             UINT8_C( 255), UINT8_C( 233), UINT8_C( 255), UINT8_C( 255)) },
    { UINT64_C( 3462613925466476941),
      simde_x_mm512_set_epu8(UINT8_C(  18), UINT8_C( 182), UINT8_C(  14), UINT8_C(  36),
                             UINT8_C( 249), UINT8_C( 113), UINT8_C(  40), UINT8_C(  48),
                             UINT8_C( 149), UINT8_C( 222), UINT8_C( 181), UINT8_C(  85),
                             UINT8_C( 221), UINT8_C( 140), UINT8_C(  65), UINT8_C( 235),
                             UINT8_C(  15), UINT8_C(   3), UINT8_C(  45), UINT8_C(  21),
                             UINT8_C(  72), UINT8_C(  93), UINT8_C( 108), UINT8_C( 125),
                             UINT8_C(   1), UINT8_C(  75), UINT8_C(  21), UINT8_C( 220),
                             UINT8_C( 130), UINT8_C( 122), UINT8_C(  71), UINT8_C(  76),
                             UINT8_C(  28), UINT8_C( 200), UINT8_C(  32), UINT8_C( 101),
                             UINT8_C( 149), UINT8_C( 145), UINT8_C( 168), UINT8_C( 237),
                             UINT8_C( 179), UINT8_C(  19), UINT8_C( 235), UINT8_C( 145),
                             UINT8_C( 188), UINT8_C(  82), UINT8_C( 138), UINT8_C( 180),
                             UINT8_C(  47), UINT8_C( 127), UINT8_C(  62), UINT8_C( 240),
                             UINT8_C(  10), UINT8_C( 242), UINT8_C( 156), UINT8_C(  86),
                             UINT8_C(  29), UINT8_C( 107), UINT8_C(  56), UINT8_C(  21),
                             UINT8_C(  24), UINT8_C(  68), UINT8_C( 160), UINT8_C(  64)),
      simde_x_mm512_set_epu8(UINT8_C( 199), UINT8_C(  94), UINT8_C( 131), UINT8_C( 132),
                             UINT8_C(  36), UINT8_C(  57), UINT8_C(  68), UINT8_C( 204),
                             UINT8_C(  39), UINT8_C(  50), UINT8_C( 208), UINT8_C(  94),
                             UINT8_C(  53), UINT8_C(  11), UINT8_C(  29), UINT8_C(  65),
                             UINT8_C( 174), UINT8_C( 137), UINT8_C( 115), UINT8_C(  68),
                             UINT8_C( 187), UINT8_C( 118), UINT8_C(  17), UINT8_C(   8),
                             UINT8_C( 192), UINT8_C( 203), UINT8_C( 214), UINT8_C( 126),
                             UINT8_C(  67), UINT8_C(  50), UINT8_C( 238), UINT8_C(  76),
                             UINT8_C( 237), UINT8_C( 123), UINT8_C( 169), UINT8_C( 106),
                             UINT8_C( 182), UINT8_C(  44), UINT8_C( 117), UINT8_C( 103),
                             UINT8_C(  81), UINT8_C( 122), UINT8_C(  56), UINT8_C( 246),
                             UINT8_C(  67), UINT8_C(  79), UINT8_C(  83), UINT8_C( 218),
                             UINT8_C( 243), UINT8_C(  43), UINT8_C(  27), UINT8_C( 159),
                             UINT8_C( 102), UINT8_C( 126), UINT8_C(  38), UINT8_C( 194),
                             UINT8_C( 232), UINT8_C( 117), UINT8_C( 218), UINT8_C( 163),
                             UINT8_C( 198), UINT8_C( 132), UINT8_C( 181), UINT8_C(  10)),
      simde_x_mm512_set_epu8(UINT8_C(   0), UINT8_C(   0), UINT8_C( 145), UINT8_C( 168),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 151), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 189), UINT8_C(   0), UINT8_C( 160), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 211), UINT8_C(   0), UINT8_C( 133),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 172), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 201), UINT8_C( 207),
                             UINT8_C( 255), UINT8_C( 189), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C( 141), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 222), UINT8_C( 200), UINT8_C(   0), UINT8_C(  74)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_adds_epu8(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_adds_epu16(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu16(UINT16_C( 57245), UINT16_C( 31803), UINT16_C(  9053), UINT16_C( 21282),
                              UINT16_C( 45515), UINT16_C( 57894), UINT16_C( 50445), UINT16_C( 50583),
                              UINT16_C( 54723), UINT16_C( 52144), UINT16_C( 13347), UINT16_C( 57624),
                              UINT16_C( 20975), UINT16_C( 65317), UINT16_C( 16493), UINT16_C( 47193),
                              UINT16_C(  8805), UINT16_C( 17012), UINT16_C( 15383), UINT16_C(  5484),
                              UINT16_C( 64480), UINT16_C( 10898), UINT16_C( 37488), UINT16_C(  8763),
                              UINT16_C( 45480), UINT16_C(  3307), UINT16_C(  9193), UINT16_C( 26229),
                              UINT16_C( 20008), UINT16_C( 59713), UINT16_C( 53564), UINT16_C( 62675)),
      simde_x_mm512_set_epu16(UINT16_C( 56619), UINT16_C( 61703), UINT16_C(  3086), UINT16_C( 41224),
                              UINT16_C(  8421), UINT16_C( 52766), UINT16_C(  7424), UINT16_C( 48822),
                              UINT16_C( 41975), UINT16_C( 22918), UINT16_C( 59915), UINT16_C( 26727),
                              UINT16_C( 53323), UINT16_C( 34707), UINT16_C( 14572), UINT16_C(   716),
                              UINT16_C( 56087), UINT16_C(  9094), UINT16_C( 20814), UINT16_C( 56962),
                              UINT16_C( 14110), UINT16_C( 52082), UINT16_C(  8468), UINT16_C( 11854),
                              UINT16_C(  1576), UINT16_C( 12690), UINT16_C( 32737), UINT16_C( 51663),
                              UINT16_C( 37115), UINT16_C( 18115), UINT16_C( 50682), UINT16_C(  1653)),
      simde_x_mm512_set_epu16(UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 12139), UINT16_C( 62506),
                              UINT16_C( 53936), UINT16_C( 65535), UINT16_C( 57869), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 31065), UINT16_C( 47909),
                              UINT16_C( 64892), UINT16_C( 26106), UINT16_C( 36197), UINT16_C( 62446),
                              UINT16_C( 65535), UINT16_C( 62980), UINT16_C( 45956), UINT16_C( 20617),
                              UINT16_C( 47056), UINT16_C( 15997), UINT16_C( 41930), UINT16_C( 65535),
                              UINT16_C( 57123), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 64328)) },
    { simde_x_mm512_set_epu16(UINT16_C(  1128), UINT16_C( 14143), UINT16_C( 19763), UINT16_C( 47819),
                              UINT16_C( 62972), UINT16_C( 13428), UINT16_C( 18537), UINT16_C( 38297),
                              UINT16_C( 21721), UINT16_C( 58861), UINT16_C( 42577), UINT16_C( 39379),
                              UINT16_C( 55643), UINT16_C( 20439), UINT16_C( 34514), UINT16_C( 49721),
                              UINT16_C( 18526), UINT16_C( 46886), UINT16_C( 20377), UINT16_C( 31658),
                              UINT16_C( 32537), UINT16_C( 50044), UINT16_C( 28503), UINT16_C(  5895),
                              UINT16_C(  1666), UINT16_C( 50137), UINT16_C( 30976), UINT16_C(  4047),
                              UINT16_C( 24589), UINT16_C( 29183), UINT16_C( 13128), UINT16_C(  3541)),
      simde_x_mm512_set_epu16(UINT16_C( 38521), UINT16_C( 64382), UINT16_C( 35873), UINT16_C( 42497),
                              UINT16_C( 46178), UINT16_C( 38904), UINT16_C( 15657), UINT16_C(  6453),
                              UINT16_C( 15377), UINT16_C( 45418), UINT16_C( 38208), UINT16_C( 44948),
                              UINT16_C( 17985), UINT16_C( 28923), UINT16_C( 11094), UINT16_C( 61254),
                              UINT16_C( 41028), UINT16_C(  4939), UINT16_C( 61438), UINT16_C( 34821),
                              UINT16_C(  9578), UINT16_C( 46329), UINT16_C( 53213), UINT16_C( 42297),
                              UINT16_C( 42846), UINT16_C( 12973), UINT16_C( 32628), UINT16_C( 10992),
                              UINT16_C( 56871), UINT16_C( 37695), UINT16_C( 16317), UINT16_C(  4356)),
      simde_x_mm512_set_epu16(UINT16_C( 39649), UINT16_C( 65535), UINT16_C( 55636), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 52332), UINT16_C( 34194), UINT16_C( 44750),
                              UINT16_C( 37098), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 49362), UINT16_C( 45608), UINT16_C( 65535),
                              UINT16_C( 59554), UINT16_C( 51825), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 42115), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 48192),
                              UINT16_C( 44512), UINT16_C( 63110), UINT16_C( 63604), UINT16_C( 15039),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 29445), UINT16_C(  7897)) },
    { simde_x_mm512_set_epu16(UINT16_C( 14747), UINT16_C( 30570), UINT16_C( 56275), UINT16_C( 58793),
                              UINT16_C( 48636), UINT16_C( 11396), UINT16_C( 12142), UINT16_C( 25883),
                              UINT16_C( 48137), UINT16_C( 31445), UINT16_C( 15524), UINT16_C( 49322),
                              UINT16_C(  6761), UINT16_C( 42681), UINT16_C(  8586), UINT16_C( 53309),
                              UINT16_C( 48898), UINT16_C( 23142), UINT16_C( 17912), UINT16_C( 20578),
                              UINT16_C( 42157), UINT16_C( 25705), UINT16_C( 39154), UINT16_C( 32521),
                              UINT16_C(  7302), UINT16_C( 65263), UINT16_C(  7623), UINT16_C( 47267),
                              UINT16_C( 41612), UINT16_C(  7723), UINT16_C( 51815), UINT16_C( 23273)),
      simde_x_mm512_set_epu16(UINT16_C( 29783), UINT16_C( 35133), UINT16_C( 18722), UINT16_C( 24788),
                              UINT16_C(  4507), UINT16_C( 64908), UINT16_C( 18120), UINT16_C( 53792),
                              UINT16_C( 40447), UINT16_C(  2013), UINT16_C( 19329), UINT16_C( 18474),
                              UINT16_C( 45067), UINT16_C( 37105), UINT16_C( 40003), UINT16_C( 11523),
                              UINT16_C( 28865), UINT16_C(  9988), UINT16_C( 16394), UINT16_C( 60605),
                              UINT16_C( 29530), UINT16_C(   612), UINT16_C( 21547), UINT16_C( 12463),
                              UINT16_C( 46586), UINT16_C(  6619), UINT16_C( 39845), UINT16_C(  4328),
                              UINT16_C( 31818), UINT16_C( 16334), UINT16_C( 57400), UINT16_C( 58095)),
      simde_x_mm512_set_epu16(UINT16_C( 44530), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 53143), UINT16_C( 65535), UINT16_C( 30262), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 33458), UINT16_C( 34853), UINT16_C( 65535),
                              UINT16_C( 51828), UINT16_C( 65535), UINT16_C( 48589), UINT16_C( 64832),
                              UINT16_C( 65535), UINT16_C( 33130), UINT16_C( 34306), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 26317), UINT16_C( 60701), UINT16_C( 44984),
                              UINT16_C( 53888), UINT16_C( 65535), UINT16_C( 47468), UINT16_C( 51595),
                              UINT16_C( 65535), UINT16_C( 24057), UINT16_C( 65535), UINT16_C( 65535)) },
    { simde_x_mm512_set_epu16(UINT16_C( 30682), UINT16_C( 30851), UINT16_C(  8660), UINT16_C( 19219),
                              UINT16_C( 10963), UINT16_C(   474), UINT16_C( 23728), UINT16_C( 46528),
                              UINT16_C( 63120), UINT16_C( 45881), UINT16_C( 63086), UINT16_C( 25197),
                              UINT16_C(  2704), UINT16_C(  4513), UINT16_C( 59294), UINT16_C( 60752),
                              UINT16_C( 50954), UINT16_C( 23266), UINT16_C( 27902), UINT16_C(  8814),
                              UINT16_C(  4863), UINT16_C(  1260), UINT16_C( 11681), UINT16_C( 46962),
                              UINT16_C( 62057), UINT16_C(  1167), UINT16_C( 44133), UINT16_C( 29723),
                              UINT16_C( 20503), UINT16_C( 47951), UINT16_C(  6645), UINT16_C( 27511)),
      simde_x_mm512_set_epu16(UINT16_C( 15286), UINT16_C(  5686), UINT16_C( 62529), UINT16_C( 52414),
                              UINT16_C( 64942), UINT16_C( 55157), UINT16_C(  1921), UINT16_C(   414),
                              UINT16_C( 57075), UINT16_C( 38949), UINT16_C( 49837), UINT16_C( 16574),
                              UINT16_C( 63519), UINT16_C( 21815), UINT16_C( 16534), UINT16_C(  5264),
                              UINT16_C( 40611), UINT16_C(  7582), UINT16_C( 27508), UINT16_C( 40060),
                              UINT16_C( 17332), UINT16_C( 48486), UINT16_C( 46457), UINT16_C(  3074),
                              UINT16_C( 49520), UINT16_C( 35694), UINT16_C( 14820), UINT16_C( 26739),
                              UINT16_C( 52931), UINT16_C( 30426), UINT16_C( 34639), UINT16_C( 60126)),
      simde_x_mm512_set_epu16(UINT16_C( 45968), UINT16_C( 36537), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 55631), UINT16_C( 25649), UINT16_C( 46942),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 41771),
                              UINT16_C( 65535), UINT16_C( 26328), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 30848), UINT16_C( 55410), UINT16_C( 48874),
                              UINT16_C( 22195), UINT16_C( 49746), UINT16_C( 58138), UINT16_C( 50036),
                              UINT16_C( 65535), UINT16_C( 36861), UINT16_C( 58953), UINT16_C( 56462),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 41284), UINT16_C( 65535)) },
    { simde_x_mm512_set_epu16(UINT16_C( 20277), UINT16_C(  2901), UINT16_C(  9119), UINT16_C( 39166),
                              UINT16_C( 42714), UINT16_C( 26596), UINT16_C( 65466), UINT16_C( 41724),
                              UINT16_C( 43509), UINT16_C( 36161), UINT16_C( 14559), UINT16_C( 39814),
                              UINT16_C( 39598), UINT16_C( 35810), UINT16_C( 32670), UINT16_C(  2206),
                              UINT16_C( 28889), UINT16_C( 41636), UINT16_C( 48990), UINT16_C( 37294),
                              UINT16_C( 39242), UINT16_C( 39778), UINT16_C(  6979), UINT16_C( 54232),
                              UINT16_C( 47738), UINT16_C( 57923), UINT16_C( 37900), UINT16_C( 45798),
                              UINT16_C( 44781), UINT16_C( 27960), UINT16_C(  1998), UINT16_C( 61149)),
      simde_x_mm512_set_epu16(UINT16_C( 20730), UINT16_C( 18080), UINT16_C( 51364), UINT16_C( 27968),
                              UINT16_C( 47873), UINT16_C( 51993), UINT16_C( 18829), UINT16_C( 15054),
                              UINT16_C( 50771), UINT16_C( 37023), UINT16_C( 39205), UINT16_C( 18252),
                              UINT16_C( 53613), UINT16_C( 36736), UINT16_C( 53958), UINT16_C( 13137),
                              UINT16_C( 43763), UINT16_C( 19789), UINT16_C(  2934), UINT16_C( 22986),
                              UINT16_C( 46964), UINT16_C( 64986), UINT16_C( 13395), UINT16_C( 61287),
                              UINT16_C( 61677), UINT16_C( 22301), UINT16_C( 41322), UINT16_C( 35063),
                              UINT16_C( 22663), UINT16_C( 28062), UINT16_C( 45351), UINT16_C( 21097)),
      simde_x_mm512_set_epu16(UINT16_C( 41007), UINT16_C( 20981), UINT16_C( 60483), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 56778),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 53764), UINT16_C( 58066),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 15343),
                              UINT16_C( 65535), UINT16_C( 61425), UINT16_C( 51924), UINT16_C( 60280),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 20374), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 56022), UINT16_C( 47349), UINT16_C( 65535)) },
    { simde_x_mm512_set_epu16(UINT16_C( 29192), UINT16_C(  8654), UINT16_C( 22850), UINT16_C( 62764),
                              UINT16_C( 24193), UINT16_C( 41054), UINT16_C( 47201), UINT16_C( 29473),
                              UINT16_C(  7514), UINT16_C( 21604), UINT16_C( 55170), UINT16_C( 17089),
                              UINT16_C( 58910), UINT16_C( 18576), UINT16_C( 50942), UINT16_C( 19375),
                              UINT16_C( 32394), UINT16_C(  6670), UINT16_C( 34291), UINT16_C( 10597),
                              UINT16_C( 63848), UINT16_C( 24622), UINT16_C( 55141), UINT16_C( 33399),
                              UINT16_C( 17676), UINT16_C( 53111), UINT16_C( 57678), UINT16_C( 53869),
                              UINT16_C(  1069), UINT16_C( 35377), UINT16_C( 20392), UINT16_C(  6033)),
      simde_x_mm512_set_epu16(UINT16_C( 30110), UINT16_C(  5765), UINT16_C( 21533), UINT16_C( 32154),
                              UINT16_C( 47788), UINT16_C(  4708), UINT16_C( 49450), UINT16_C( 15569),
                              UINT16_C( 11433), UINT16_C( 48528), UINT16_C( 18868), UINT16_C( 49914),
                              UINT16_C( 29591), UINT16_C( 10234), UINT16_C( 18676), UINT16_C( 18833),
                              UINT16_C( 53298), UINT16_C( 44056), UINT16_C(   163), UINT16_C( 14043),
                              UINT16_C( 52308), UINT16_C( 55462), UINT16_C(  1379), UINT16_C( 56593),
                              UINT16_C( 40649), UINT16_C( 10209), UINT16_C( 62181), UINT16_C(  6865),
                              UINT16_C( 33659), UINT16_C( 12643), UINT16_C( 58853), UINT16_C( 27590)),
      simde_x_mm512_set_epu16(UINT16_C( 59302), UINT16_C( 14419), UINT16_C( 44383), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 45762), UINT16_C( 65535), UINT16_C( 45042),
                              UINT16_C( 18947), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 28810), UINT16_C( 65535), UINT16_C( 38208),
                              UINT16_C( 65535), UINT16_C( 50726), UINT16_C( 34454), UINT16_C( 24640),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 56520), UINT16_C( 65535),
                              UINT16_C( 58325), UINT16_C( 63320), UINT16_C( 65535), UINT16_C( 60734),
                              UINT16_C( 34728), UINT16_C( 48020), UINT16_C( 65535), UINT16_C( 33623)) },
    { simde_x_mm512_set_epu16(UINT16_C( 54408), UINT16_C( 44486), UINT16_C( 24517), UINT16_C( 51207),
                              UINT16_C(  2791), UINT16_C( 45592), UINT16_C( 48586), UINT16_C( 36784),
                              UINT16_C( 53369), UINT16_C( 43811), UINT16_C( 65046), UINT16_C( 44235),
                              UINT16_C( 48681), UINT16_C( 21401), UINT16_C( 55417), UINT16_C(  5581),
                              UINT16_C( 56410), UINT16_C( 42092), UINT16_C( 49678), UINT16_C( 22777),
                              UINT16_C( 15839), UINT16_C( 59069), UINT16_C(  3836), UINT16_C( 55877),
                              UINT16_C( 35316), UINT16_C( 40611), UINT16_C( 30925), UINT16_C( 38925),
                              UINT16_C( 44290), UINT16_C( 48844), UINT16_C( 41388), UINT16_C( 24135)),
      simde_x_mm512_set_epu16(UINT16_C(  7663), UINT16_C(  4305), UINT16_C( 48670), UINT16_C( 39779),
                              UINT16_C(  2052), UINT16_C( 40026), UINT16_C( 47264), UINT16_C(  7297),
                              UINT16_C( 11022), UINT16_C( 64822), UINT16_C( 63292), UINT16_C( 56921),
                              UINT16_C(  8160), UINT16_C( 61766), UINT16_C( 22014), UINT16_C( 41597),
                              UINT16_C( 60919), UINT16_C( 45399), UINT16_C( 45462), UINT16_C( 35135),
                              UINT16_C( 13486), UINT16_C( 42127), UINT16_C(  6466), UINT16_C(  5931),
                              UINT16_C( 30448), UINT16_C( 27493), UINT16_C( 24921), UINT16_C( 23842),
                              UINT16_C( 21170), UINT16_C( 62954), UINT16_C(  7914), UINT16_C( 35527)),
      simde_x_mm512_set_epu16(UINT16_C( 62071), UINT16_C( 48791), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C(  4843), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 44081),
                              UINT16_C( 64391), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 56841), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 47178),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 57912),
                              UINT16_C( 29325), UINT16_C( 65535), UINT16_C( 10302), UINT16_C( 61808),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 55846), UINT16_C( 62767),
                              UINT16_C( 65460), UINT16_C( 65535), UINT16_C( 49302), UINT16_C( 59662)) },
    { simde_x_mm512_set_epu16(UINT16_C( 61865), UINT16_C( 23426), UINT16_C(  1768), UINT16_C( 58636),
                              UINT16_C( 57533), UINT16_C( 19108), UINT16_C( 59802), UINT16_C( 30792),
                              UINT16_C( 61240), UINT16_C(  6209), UINT16_C( 32476), UINT16_C( 14300),
                              UINT16_C(  7420), UINT16_C(  1985), UINT16_C( 25770), UINT16_C( 58800),
                              UINT16_C( 51482), UINT16_C( 20894), UINT16_C(   680), UINT16_C( 29487),
                              UINT16_C( 45202), UINT16_C( 20181), UINT16_C( 14712), UINT16_C( 17612),
                              UINT16_C( 16683), UINT16_C(  1453), UINT16_C( 15990), UINT16_C( 36509),
                              UINT16_C( 51737), UINT16_C( 56324), UINT16_C( 34493), UINT16_C( 17761)),
      simde_x_mm512_set_epu16(UINT16_C( 37550), UINT16_C( 51250), UINT16_C( 42874), UINT16_C(  8384),
                              UINT16_C( 13698), UINT16_C( 33689), UINT16_C( 64372), UINT16_C( 20393),
                              UINT16_C( 17692), UINT16_C( 65383), UINT16_C(   545), UINT16_C( 27220),
                              UINT16_C( 18321), UINT16_C( 26532), UINT16_C( 40835), UINT16_C( 14036),
                              UINT16_C(  3666), UINT16_C(  2040), UINT16_C( 61839), UINT16_C( 38748),
                              UINT16_C( 62699), UINT16_C( 55831), UINT16_C( 23293), UINT16_C( 13208),
                              UINT16_C( 60975), UINT16_C( 12632), UINT16_C( 13392), UINT16_C( 63703),
                              UINT16_C( 41286), UINT16_C(  6117), UINT16_C( 32645), UINT16_C( 56152)),
      simde_x_mm512_set_epu16(UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 44642), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 52797), UINT16_C( 65535), UINT16_C( 51185),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 33021), UINT16_C( 41520),
                              UINT16_C( 25741), UINT16_C( 28517), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 55148), UINT16_C( 22934), UINT16_C( 62519), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 38005), UINT16_C( 30820),
                              UINT16_C( 65535), UINT16_C( 14085), UINT16_C( 29382), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 62441), UINT16_C( 65535), UINT16_C( 65535)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_adds_epu16(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u16(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_adds_epu16 (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const int16_t src[32];
    const simde__mmask32 k;
    const uint16_t a[32];
    const uint16_t b[32];
    const uint16_t r[32];
  } test_vec[] = {
    { { -INT16_C( 25480),  INT16_C( 16389),  INT16_C( 16810),  INT16_C( 20465), -INT16_C( 11763),  INT16_C(  1143),  INT16_C( 11613),  INT16_C(  5547),
        -INT16_C(   217),  INT16_C(  4795),  INT16_C(  5277), -INT16_C( 31526), -INT16_C(  1895),  INT16_C(  7976), -INT16_C(  7252),  INT16_C(  9466),
        -INT16_C(   129),  INT16_C( 10853),  INT16_C( 22080),  INT16_C( 19833), -INT16_C(  4056), -INT16_C( 31151), -INT16_C(   994),  INT16_C( 17819),
         INT16_C( 22267), -INT16_C( 26281),  INT16_C( 12651),  INT16_C(  1053),  INT16_C( 17962), -INT16_C( 10716),  INT16_C(  7721), -INT16_C( 22278) },
      UINT32_C(1590845213),
      { UINT16_C(19382), UINT16_C(57003), UINT16_C(64828), UINT16_C(23140), UINT16_C(65529), UINT16_C(62879), UINT16_C(63062), UINT16_C(49550),
        UINT16_C(43815), UINT16_C(20933), UINT16_C(59889), UINT16_C( 6695), UINT16_C( 8711), UINT16_C( 9667), UINT16_C(38273), UINT16_C(14211),
        UINT16_C(12001), UINT16_C( 7446), UINT16_C(31275), UINT16_C( 9591), UINT16_C( 5754), UINT16_C(53274), UINT16_C(43020), UINT16_C(13201),
        UINT16_C(22099), UINT16_C(17797), UINT16_C(44096), UINT16_C(18271), UINT16_C( 8910), UINT16_C(20588), UINT16_C(61368), UINT16_C(39303) },
      { UINT16_C(40222), UINT16_C(18870), UINT16_C(11544), UINT16_C(37486), UINT16_C(34883), UINT16_C(20322), UINT16_C(62256), UINT16_C(33922),
        UINT16_C( 1865), UINT16_C(35273), UINT16_C(10420), UINT16_C(33489), UINT16_C(15691), UINT16_C(  978), UINT16_C(23085), UINT16_C(19356),
        UINT16_C(21239), UINT16_C( 3988), UINT16_C(  895), UINT16_C(49825), UINT16_C(  907), UINT16_C(48145), UINT16_C(37878), UINT16_C(16448),
        UINT16_C( 2459), UINT16_C(20425), UINT16_C(39473), UINT16_C(31953), UINT16_C(42200), UINT16_C( 1407), UINT16_C( 7166), UINT16_C(62800) },
      { UINT16_C(59604), UINT16_C(16389),      UINT16_MAX, UINT16_C(60626),      UINT16_MAX, UINT16_C( 1143), UINT16_C(11613), UINT16_C( 5547),
        UINT16_C(45680), UINT16_C(56206),      UINT16_MAX, UINT16_C(40184), UINT16_C(24402), UINT16_C( 7976), UINT16_C(61358), UINT16_C( 9466),
        UINT16_C(65407), UINT16_C(11434), UINT16_C(22080), UINT16_C(19833), UINT16_C( 6661), UINT16_C(34385),      UINT16_MAX, UINT16_C(29649),
        UINT16_C(22267), UINT16_C(38222),      UINT16_MAX, UINT16_C(50224), UINT16_C(51110), UINT16_C(54820),      UINT16_MAX, UINT16_C(43258) } },
    { { -INT16_C(  7059), -INT16_C(  5115), -INT16_C( 22809),  INT16_C( 29614), -INT16_C( 16470), -INT16_C( 24529),  INT16_C( 28499), -INT16_C(  4384),
        -INT16_C( 21896), -INT16_C( 22211),  INT16_C(  3652),  INT16_C(  7206), -INT16_C( 23118), -INT16_C( 20447),  INT16_C( 29121),  INT16_C( 11942),
        -INT16_C( 21674),  INT16_C( 15643), -INT16_C( 13999), -INT16_C(  1104), -INT16_C(  8311), -INT16_C(  9060),  INT16_C( 31822), -INT16_C( 14646),
         INT16_C(  1830),  INT16_C( 27504), -INT16_C( 27115), -INT16_C( 14201), -INT16_C( 22213), -INT16_C(   904),  INT16_C(  7706),  INT16_C( 28715) },
      UINT32_C( 464406217),
      { UINT16_C(24079), UINT16_C(38934), UINT16_C(45630), UINT16_C(35956), UINT16_C(15919), UINT16_C(21843), UINT16_C(49989), UINT16_C(23488),
        UINT16_C(18521), UINT16_C(37923), UINT16_C(39921), UINT16_C( 2961), UINT16_C(48314), UINT16_C(33660), UINT16_C(10754), UINT16_C( 4510),
        UINT16_C(46472), UINT16_C(50858), UINT16_C( 7783), UINT16_C(38483), UINT16_C(42589), UINT16_C(41708), UINT16_C(44137), UINT16_C(49917),
        UINT16_C( 8436), UINT16_C(58710), UINT16_C(59324), UINT16_C(30449), UINT16_C(28067), UINT16_C(42489), UINT16_C(39063), UINT16_C( 8119) },
      { UINT16_C(24909), UINT16_C(46310), UINT16_C(14719), UINT16_C(56395), UINT16_C(14303), UINT16_C(18559), UINT16_C(31971), UINT16_C(55306),
        UINT16_C(24733), UINT16_C(22973), UINT16_C(44616), UINT16_C(60367), UINT16_C(51227), UINT16_C(45713), UINT16_C(18528), UINT16_C(44498),
        UINT16_C(47273), UINT16_C(10338), UINT16_C(44529), UINT16_C(53253), UINT16_C(34020), UINT16_C(50968), UINT16_C( 8704), UINT16_C(40351),
        UINT16_C(23938), UINT16_C(51958), UINT16_C(50443), UINT16_C(10166), UINT16_C(18318), UINT16_C(61145), UINT16_C(43919), UINT16_C(14492) },
      { UINT16_C(48988), UINT16_C(60421), UINT16_C(42727),      UINT16_MAX, UINT16_C(49066), UINT16_C(41007),      UINT16_MAX,      UINT16_MAX,
        UINT16_C(43640), UINT16_C(60896),      UINT16_MAX, UINT16_C( 7206), UINT16_C(42418), UINT16_C(45089), UINT16_C(29282), UINT16_C(11942),
        UINT16_C(43862), UINT16_C(61196), UINT16_C(52312),      UINT16_MAX, UINT16_C(57225),      UINT16_MAX, UINT16_C(31822),      UINT16_MAX,
        UINT16_C(32374),      UINT16_MAX, UINT16_C(38421), UINT16_C(40615), UINT16_C(46385), UINT16_C(64632), UINT16_C( 7706), UINT16_C(28715) } },
    { { -INT16_C(   413),  INT16_C( 21600),  INT16_C( 26027), -INT16_C( 28892),  INT16_C( 15593), -INT16_C(  5546), -INT16_C(  2466), -INT16_C(  7801),
         INT16_C( 32339),  INT16_C( 24235),  INT16_C( 24899), -INT16_C( 11899),  INT16_C( 24488),  INT16_C( 14272),  INT16_C( 23562),  INT16_C( 28271),
        -INT16_C( 12198),  INT16_C(  1474), -INT16_C(  6347),  INT16_C(  8084), -INT16_C(  5597), -INT16_C( 32247), -INT16_C( 28448),  INT16_C( 13155),
         INT16_C(  3598),  INT16_C( 21138),  INT16_C(  6000),  INT16_C(  6179), -INT16_C(  7306), -INT16_C( 32432), -INT16_C( 16577), -INT16_C( 26129) },
      UINT32_C(3315511695),
      { UINT16_C(12952), UINT16_C(48356), UINT16_C(60701), UINT16_C(64830), UINT16_C(41341), UINT16_C(35889), UINT16_C(50095), UINT16_C( 8158),
        UINT16_C(  474), UINT16_C(20792), UINT16_C(35045), UINT16_C( 9426), UINT16_C(49479), UINT16_C(55230), UINT16_C(23666), UINT16_C( 2972),
        UINT16_C(32911), UINT16_C(44231), UINT16_C( 1389), UINT16_C(60073), UINT16_C(55974), UINT16_C(21878), UINT16_C(21661), UINT16_C(30837),
        UINT16_C(44374), UINT16_C(15305), UINT16_C(39733), UINT16_C(31839), UINT16_C( 7516), UINT16_C(52819), UINT16_C(61306), UINT16_C( 2521) },
      { UINT16_C(41071), UINT16_C(56501), UINT16_C(24229), UINT16_C(19399), UINT16_C(15673), UINT16_C(54945), UINT16_C( 5778), UINT16_C(59470),
        UINT16_C( 6083), UINT16_C(63523), UINT16_C(33458), UINT16_C( 3700), UINT16_C(51360), UINT16_C( 6877), UINT16_C(46775), UINT16_C(10019),
        UINT16_C(55383), UINT16_C(64515), UINT16_C(51766), UINT16_C(28488), UINT16_C(59656), UINT16_C(39494), UINT16_C(38143), UINT16_C(49794),
        UINT16_C(42412), UINT16_C(24250), UINT16_C(11815), UINT16_C(51053), UINT16_C(19190), UINT16_C(44769), UINT16_C( 1024), UINT16_C(22485) },
      { UINT16_C(54023),      UINT16_MAX,      UINT16_MAX,      UINT16_MAX, UINT16_C(15593), UINT16_C(59990), UINT16_C(63070),      UINT16_MAX,
        UINT16_C( 6557), UINT16_C(24235), UINT16_C(24899), UINT16_C(53637),      UINT16_MAX, UINT16_C(62107), UINT16_C(23562), UINT16_C(12991),
        UINT16_C(53338),      UINT16_MAX, UINT16_C(53155),      UINT16_MAX,      UINT16_MAX, UINT16_C(33289), UINT16_C(37088),      UINT16_MAX,
             UINT16_MAX, UINT16_C(21138), UINT16_C(51548), UINT16_C( 6179), UINT16_C(58230), UINT16_C(33104), UINT16_C(62330), UINT16_C(25006) } },
    { { -INT16_C( 10020),  INT16_C(  4948), -INT16_C( 25437), -INT16_C( 21630), -INT16_C( 14203), -INT16_C( 31675), -INT16_C( 14499),  INT16_C(  2374),
         INT16_C(   108), -INT16_C( 27801), -INT16_C( 11218),  INT16_C(  9563),  INT16_C( 15390),  INT16_C(  8147), -INT16_C( 22463),  INT16_C(  7542),
        -INT16_C( 13696),  INT16_C(  9008), -INT16_C( 19610), -INT16_C(  5170),  INT16_C(  4987), -INT16_C( 10129), -INT16_C( 18982),  INT16_C( 18145),
         INT16_C( 18869), -INT16_C(  6950),  INT16_C( 13597),  INT16_C( 15369), -INT16_C(  9103), -INT16_C( 19877), -INT16_C( 11900),  INT16_C(  1232) },
      UINT32_C(  36176028),
      { UINT16_C(63155), UINT16_C(12270), UINT16_C(23818), UINT16_C(58375), UINT16_C(59667), UINT16_C(51243), UINT16_C( 1330), UINT16_C(20396),
        UINT16_C(46394), UINT16_C(43915), UINT16_C(59025), UINT16_C( 5470), UINT16_C(11960), UINT16_C(21530), UINT16_C(16942), UINT16_C(57942),
        UINT16_C(17464), UINT16_C(16913), UINT16_C( 6306), UINT16_C(46375), UINT16_C(20993), UINT16_C(13181), UINT16_C(10839), UINT16_C(37251),
        UINT16_C( 3807), UINT16_C(28988), UINT16_C(39669), UINT16_C(44422), UINT16_C(41160), UINT16_C(63233), UINT16_C(22498), UINT16_C( 7129) },
      { UINT16_C(60060), UINT16_C(15965), UINT16_C(33794), UINT16_C( 1267), UINT16_C(28886), UINT16_C(11575), UINT16_C(47770), UINT16_C(31422),
        UINT16_C(64457), UINT16_C(48875), UINT16_C(29077), UINT16_C(24171), UINT16_C(27666), UINT16_C(62549), UINT16_C(11971), UINT16_C(24335),
        UINT16_C(27928), UINT16_C( 6813), UINT16_C(37105), UINT16_C(51230), UINT16_C(22017), UINT16_C(39925), UINT16_C(46096), UINT16_C(55573),
        UINT16_C(  175), UINT16_C(17559), UINT16_C(  626), UINT16_C(33954), UINT16_C(63342), UINT16_C(12920), UINT16_C(34853), UINT16_C(15761) },
      { UINT16_C(55516), UINT16_C( 4948), UINT16_C(57612), UINT16_C(59642),      UINT16_MAX, UINT16_C(33861), UINT16_C(51037), UINT16_C(51818),
        UINT16_C(  108), UINT16_C(37735), UINT16_C(54318), UINT16_C( 9563), UINT16_C(15390), UINT16_C( 8147), UINT16_C(43073), UINT16_C( 7542),
        UINT16_C(51840), UINT16_C( 9008), UINT16_C(45926),      UINT16_MAX, UINT16_C( 4987), UINT16_C(53106), UINT16_C(46554), UINT16_C(18145),
        UINT16_C(18869), UINT16_C(46547), UINT16_C(13597), UINT16_C(15369), UINT16_C(56433), UINT16_C(45659), UINT16_C(53636), UINT16_C( 1232) } },
    { {  INT16_C( 12277), -INT16_C(  6568),  INT16_C( 30399), -INT16_C( 16210), -INT16_C( 23348), -INT16_C(  8868),  INT16_C( 29016),  INT16_C(  1974),
         INT16_C( 20082), -INT16_C(  7093), -INT16_C(  4528), -INT16_C( 16536), -INT16_C(  7963),  INT16_C(  3057), -INT16_C( 32152),  INT16_C( 23880),
        -INT16_C( 24399),  INT16_C( 28996), -INT16_C(  3561), -INT16_C(  7375), -INT16_C( 29290), -INT16_C(  4416),  INT16_C( 30719),  INT16_C( 29173),
         INT16_C( 16837),  INT16_C(  5461), -INT16_C( 17105),  INT16_C(  5332), -INT16_C( 14947),  INT16_C(  1567),  INT16_C( 26696), -INT16_C(  1693) },
      UINT32_C( 527083272),
      { UINT16_C(40090), UINT16_C(12291), UINT16_C(49961), UINT16_C(10271), UINT16_C( 5178), UINT16_C(65433), UINT16_C(61013), UINT16_C(33813),
        UINT16_C(59819), UINT16_C(18841), UINT16_C(47279), UINT16_C(63311), UINT16_C(45600), UINT16_C(10736), UINT16_C(23386), UINT16_C(62536),
        UINT16_C(19447), UINT16_C( 8228), UINT16_C(17167), UINT16_C(18761), UINT16_C(57944), UINT16_C(44361), UINT16_C(24273), UINT16_C(31794),
        UINT16_C(52039), UINT16_C(63173), UINT16_C( 5251), UINT16_C(42221), UINT16_C(57031), UINT16_C( 8653), UINT16_C( 5433), UINT16_C(12309) },
      { UINT16_C(14689), UINT16_C(28752), UINT16_C(39293), UINT16_C(54713), UINT16_C(  636), UINT16_C(19842), UINT16_C(46176), UINT16_C(43209),
        UINT16_C(36735), UINT16_C(  926), UINT16_C(36003), UINT16_C(27303), UINT16_C(29802), UINT16_C(41867), UINT16_C(41097), UINT16_C(60115),
        UINT16_C( 9178), UINT16_C(22362), UINT16_C( 5309), UINT16_C(14636), UINT16_C(44566), UINT16_C(30598), UINT16_C(20323), UINT16_C(57887),
        UINT16_C(48606), UINT16_C(33509), UINT16_C(35913), UINT16_C(46060), UINT16_C(30720), UINT16_C(35414), UINT16_C(10520), UINT16_C(62068) },
      { UINT16_C(12277), UINT16_C(58968), UINT16_C(30399), UINT16_C(64984), UINT16_C(42188), UINT16_C(56668), UINT16_C(29016), UINT16_C( 1974),
             UINT16_MAX, UINT16_C(19767),      UINT16_MAX, UINT16_C(49000), UINT16_C(57573), UINT16_C(52603), UINT16_C(33384),      UINT16_MAX,
        UINT16_C(41137), UINT16_C(30590), UINT16_C(61975), UINT16_C(33397), UINT16_C(36246),      UINT16_MAX, UINT16_C(44596), UINT16_C(29173),
             UINT16_MAX,      UINT16_MAX, UINT16_C(41164),      UINT16_MAX,      UINT16_MAX, UINT16_C( 1567), UINT16_C(26696), UINT16_C(63843) } },
    { { -INT16_C( 12467),  INT16_C(  2633),  INT16_C( 30179), -INT16_C(  1725), -INT16_C( 14044), -INT16_C( 30864), -INT16_C( 28904), -INT16_C(  2199),
         INT16_C( 20301), -INT16_C( 27015),  INT16_C( 26075), -INT16_C(  9142), -INT16_C( 24355), -INT16_C(  2458), -INT16_C(  9526),  INT16_C(  6120),
         INT16_C( 12969), -INT16_C( 29663),  INT16_C( 25767), -INT16_C( 13434), -INT16_C(  2515),  INT16_C( 17746), -INT16_C( 17274), -INT16_C( 11460),
        -INT16_C( 19189), -INT16_C(  6551), -INT16_C( 19685), -INT16_C(  1854),  INT16_C( 10324),  INT16_C(  7918), -INT16_C( 10493), -INT16_C( 21451) },
      UINT32_C(2956547593),
      { UINT16_C(49082), UINT16_C(59260), UINT16_C(52917), UINT16_C(15148), UINT16_C(27018), UINT16_C(38158), UINT16_C(30750), UINT16_C(14716),
        UINT16_C(15915), UINT16_C(32562), UINT16_C( 8295), UINT16_C(27293), UINT16_C(54007), UINT16_C(   22), UINT16_C(20264), UINT16_C(58033),
        UINT16_C(11534), UINT16_C(50377), UINT16_C(63227), UINT16_C(34559), UINT16_C( 3679), UINT16_C(32027), UINT16_C(38790), UINT16_C(45495),
        UINT16_C(59862), UINT16_C(15665), UINT16_C(52745), UINT16_C(  423), UINT16_C(48545), UINT16_C(51457), UINT16_C(45581), UINT16_C( 7084) },
      { UINT16_C(30175), UINT16_C(56287), UINT16_C(57195), UINT16_C(51809), UINT16_C(31981), UINT16_C(29512), UINT16_C(65300), UINT16_C(59940),
        UINT16_C(21992), UINT16_C(61735), UINT16_C(52772), UINT16_C(50674), UINT16_C(62603), UINT16_C(39054), UINT16_C(15014), UINT16_C(34484),
        UINT16_C(37808), UINT16_C( 7009), UINT16_C(49778), UINT16_C(24550), UINT16_C(11838), UINT16_C(21202), UINT16_C(63277), UINT16_C( 5436),
        UINT16_C(25420), UINT16_C(28678), UINT16_C(63793), UINT16_C(48437), UINT16_C(50413), UINT16_C(37717), UINT16_C( 2558), UINT16_C(44569) },
      {      UINT16_MAX, UINT16_C( 2633), UINT16_C(30179),      UINT16_MAX, UINT16_C(51492), UINT16_C(34672), UINT16_C(36632), UINT16_C(63337),
        UINT16_C(20301),      UINT16_MAX, UINT16_C(61067), UINT16_C(56394),      UINT16_MAX, UINT16_C(63078), UINT16_C(35278), UINT16_C( 6120),
        UINT16_C(49342), UINT16_C(35873), UINT16_C(25767), UINT16_C(59109), UINT16_C(15517), UINT16_C(53229), UINT16_C(48262), UINT16_C(54076),
        UINT16_C(46347), UINT16_C(58985), UINT16_C(45851), UINT16_C(63682),      UINT16_MAX,      UINT16_MAX, UINT16_C(55043), UINT16_C(51653) } },
    { {  INT16_C( 31389),  INT16_C(  4042), -INT16_C( 20420),  INT16_C( 31599),  INT16_C( 16862),  INT16_C(  3021),  INT16_C(  2616), -INT16_C( 31456),
         INT16_C(  9837), -INT16_C( 24587),  INT16_C( 11039),  INT16_C(  3164), -INT16_C( 19985), -INT16_C(  4704), -INT16_C( 17989),  INT16_C( 22684),
         INT16_C( 26164),  INT16_C( 28775), -INT16_C( 10730), -INT16_C(  2837), -INT16_C( 18152),  INT16_C( 20735),  INT16_C(  8131),  INT16_C( 12501),
        -INT16_C( 13499),  INT16_C( 26063),  INT16_C( 11254), -INT16_C(  6799),  INT16_C(  4573), -INT16_C( 26414),  INT16_C( 28363), -INT16_C(    16) },
      UINT32_C(3933165524),
      { UINT16_C(23342), UINT16_C(18142), UINT16_C(56596), UINT16_C(55190), UINT16_C(27900), UINT16_C(16903), UINT16_C(55095), UINT16_C(11687),
        UINT16_C( 6146), UINT16_C(57106), UINT16_C(58410), UINT16_C(62839), UINT16_C(26451), UINT16_C(10228), UINT16_C(25535), UINT16_C(60690),
        UINT16_C(61630), UINT16_C(53811), UINT16_C(51662), UINT16_C(51881), UINT16_C(45365), UINT16_C(27660), UINT16_C(45960), UINT16_C(35481),
        UINT16_C(43980), UINT16_C(63082), UINT16_C(57744), UINT16_C(58347), UINT16_C(57161), UINT16_C( 2058), UINT16_C( 7234), UINT16_C(  501) },
      { UINT16_C(10253), UINT16_C(56275), UINT16_C(32241), UINT16_C(10149), UINT16_C(45614), UINT16_C(46739), UINT16_C(11621), UINT16_C(12608),
        UINT16_C(43736), UINT16_C(26663), UINT16_C( 4748), UINT16_C(54603), UINT16_C(22257), UINT16_C(13533), UINT16_C(53874), UINT16_C(32565),
        UINT16_C( 2298), UINT16_C(60250), UINT16_C(  133), UINT16_C(45842), UINT16_C(42674), UINT16_C( 5993), UINT16_C(43731), UINT16_C(43849),
        UINT16_C(28756), UINT16_C(57364), UINT16_C(24451), UINT16_C(29877), UINT16_C(37557), UINT16_C(10408), UINT16_C(56676), UINT16_C(24231) },
      { UINT16_C(31389), UINT16_C( 4042),      UINT16_MAX, UINT16_C(31599),      UINT16_MAX, UINT16_C( 3021),      UINT16_MAX, UINT16_C(24295),
        UINT16_C(49882),      UINT16_MAX, UINT16_C(63158), UINT16_C( 3164), UINT16_C(48708), UINT16_C(60832),      UINT16_MAX, UINT16_C(22684),
        UINT16_C(63928),      UINT16_MAX, UINT16_C(51795),      UINT16_MAX, UINT16_C(47384), UINT16_C(33653),      UINT16_MAX, UINT16_C(12501),
        UINT16_C(52037),      UINT16_MAX, UINT16_C(11254),      UINT16_MAX, UINT16_C( 4573), UINT16_C(12466), UINT16_C(63910), UINT16_C(24732) } },
    { {  INT16_C(   742),  INT16_C( 27466),  INT16_C( 23554), -INT16_C( 19425), -INT16_C( 30718), -INT16_C( 10805),  INT16_C(  5170), -INT16_C( 30847),
        -INT16_C( 27259),  INT16_C(  2151),  INT16_C(  7668), -INT16_C( 21892),  INT16_C(  9647),  INT16_C(  5330),  INT16_C( 30978), -INT16_C(  6030),
        -INT16_C( 17285),  INT16_C( 32084),  INT16_C( 29465),  INT16_C(  6961), -INT16_C(   517),  INT16_C( 12017),  INT16_C( 29201), -INT16_C( 26955),
         INT16_C(  7175), -INT16_C(  1122),  INT16_C(  6969), -INT16_C(  5723),  INT16_C( 30528),  INT16_C( 17149),  INT16_C( 28657),  INT16_C( 27691) },
      UINT32_C(1172995884),
      { UINT16_C( 7154), UINT16_C(60768), UINT16_C(20760), UINT16_C(10779), UINT16_C(53443), UINT16_C(51904), UINT16_C(24557), UINT16_C( 9926),
        UINT16_C(27514), UINT16_C(47631), UINT16_C( 3299), UINT16_C(54524), UINT16_C(10108), UINT16_C(43072), UINT16_C(10918), UINT16_C(39149),
        UINT16_C(19782), UINT16_C(24198), UINT16_C(41375), UINT16_C(25224), UINT16_C(18802), UINT16_C(24365), UINT16_C(62376), UINT16_C( 8837),
        UINT16_C(38238), UINT16_C(16860), UINT16_C(55457), UINT16_C( 7445), UINT16_C(22016), UINT16_C(42693), UINT16_C(45696), UINT16_C(50751) },
      { UINT16_C(50432), UINT16_C(40741), UINT16_C(44390), UINT16_C(55297), UINT16_C(12022), UINT16_C(40503), UINT16_C(48417), UINT16_C(32960),
        UINT16_C(40018), UINT16_C(62401), UINT16_C(55157), UINT16_C(29969), UINT16_C(54829), UINT16_C(44315), UINT16_C(23177), UINT16_C(35188),
        UINT16_C(39199), UINT16_C(34344), UINT16_C(10566), UINT16_C(15710), UINT16_C(38488), UINT16_C(31195), UINT16_C(40019), UINT16_C(42489),
        UINT16_C(47928), UINT16_C(44440), UINT16_C(43410), UINT16_C(48930), UINT16_C(16000), UINT16_C( 2412), UINT16_C(57496), UINT16_C(47250) },
      { UINT16_C(  742), UINT16_C(27466), UINT16_C(65150),      UINT16_MAX, UINT16_C(34818),      UINT16_MAX, UINT16_C( 5170), UINT16_C(34689),
             UINT16_MAX,      UINT16_MAX, UINT16_C(58456),      UINT16_MAX, UINT16_C(64937),      UINT16_MAX, UINT16_C(34095), UINT16_C(59506),
        UINT16_C(48251), UINT16_C(58542), UINT16_C(29465), UINT16_C(40934), UINT16_C(65019), UINT16_C(55560),      UINT16_MAX, UINT16_C(51326),
             UINT16_MAX, UINT16_C(64414),      UINT16_MAX, UINT16_C(59813), UINT16_C(30528), UINT16_C(17149),      UINT16_MAX, UINT16_C(27691) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i src = simde_mm512_loadu_epi16(test_vec[i].src);
    simde__m512i a = simde_mm512_loadu_epi16(test_vec[i].a);
    simde__m512i b = simde_mm512_loadu_epi16(test_vec[i].b);
    simde__m512i r = simde_mm512_mask_adds_epu16(src, test_vec[i].k, a, b);
    simde_test_x86_assert_equal_u16x32(r, simde_mm512_loadu_epi16(test_vec[i].r));
  }

  return 0;
}

static int
test_simde_mm512_maskz_adds_epu16 (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const simde__mmask32 k;
    const uint16_t a[32];
    const uint16_t b[32];
    const uint16_t r[32];
  } test_vec[] = {
    { UINT32_C( 298122215),
      { UINT16_C(43877), UINT16_C(21426), UINT16_C(12985), UINT16_C(37214), UINT16_C(44901), UINT16_C(48588), UINT16_C(18525), UINT16_C(41048),
        UINT16_C(22359), UINT16_C(46043), UINT16_C(52738), UINT16_C(43622), UINT16_C(52530), UINT16_C( 6625), UINT16_C(42696), UINT16_C(11818),
        UINT16_C(56401), UINT16_C( 2689), UINT16_C(57359), UINT16_C(29852), UINT16_C(26767), UINT16_C(60465), UINT16_C(35504), UINT16_C( 2188),
        UINT16_C(26593), UINT16_C(58555), UINT16_C( 8501), UINT16_C(26510), UINT16_C(28654), UINT16_C(46976), UINT16_C(43541), UINT16_C(26597) },
      { UINT16_C(26246), UINT16_C(38257), UINT16_C( 3398), UINT16_C(54538), UINT16_C(15221), UINT16_C( 9921), UINT16_C(19909), UINT16_C(42798),
        UINT16_C(59828), UINT16_C(59787), UINT16_C( 6411), UINT16_C(63824), UINT16_C(53384), UINT16_C(40624), UINT16_C(38266), UINT16_C(  261),
        UINT16_C(30460), UINT16_C(17046), UINT16_C(41092), UINT16_C(63768), UINT16_C(55772), UINT16_C(41247), UINT16_C(19751), UINT16_C(56136),
        UINT16_C(54071), UINT16_C(17093), UINT16_C( 5612), UINT16_C(30011), UINT16_C(60646), UINT16_C(24595), UINT16_C( 6273), UINT16_C(32097) },
      {      UINT16_MAX, UINT16_C(59683), UINT16_C(16383), UINT16_C(    0), UINT16_C(    0), UINT16_C(58509), UINT16_C(38434),      UINT16_MAX,
             UINT16_MAX,      UINT16_MAX, UINT16_C(    0),      UINT16_MAX,      UINT16_MAX, UINT16_C(47249),      UINT16_MAX, UINT16_C(12079),
        UINT16_C(    0), UINT16_C(    0),      UINT16_MAX, UINT16_C(    0), UINT16_C(    0), UINT16_C(    0), UINT16_C(55255), UINT16_C(58324),
             UINT16_MAX, UINT16_C(    0), UINT16_C(    0), UINT16_C(    0),      UINT16_MAX, UINT16_C(    0), UINT16_C(    0), UINT16_C(    0) } },
    { UINT32_C( 314636430),
      { UINT16_C(55448), UINT16_C(29708), UINT16_C(11185), UINT16_C(55318), UINT16_C(24185), UINT16_C(45236), UINT16_C(31026), UINT16_C( 7922),
        UINT16_C(11662), UINT16_C(29843), UINT16_C(42521), UINT16_C(39893), UINT16_C(14014), UINT16_C(19736), UINT16_C(55342), UINT16_C(51039),
        UINT16_C(27568), UINT16_C(25147), UINT16_C(20887), UINT16_C( 4154), UINT16_C(61104), UINT16_C(58048), UINT16_C(45671), UINT16_C(62976),
        UINT16_C(38111), UINT16_C(63850), UINT16_C(16186), UINT16_C(63892), UINT16_C(44150), UINT16_C(42054), UINT16_C(42373), UINT16_C(13675) },
      { UINT16_C(42769), UINT16_C(43159), UINT16_C(54008), UINT16_C(43192), UINT16_C(30912), UINT16_C(10378), UINT16_C(35626), UINT16_C( 2334),
        UINT16_C(34847), UINT16_C(22786), UINT16_C(38600), UINT16_C(15954), UINT16_C(38979), UINT16_C(51426), UINT16_C(20030), UINT16_C(20477),
        UINT16_C(38389), UINT16_C(60919), UINT16_C(44903), UINT16_C(10134), UINT16_C( 8231), UINT16_C(20815), UINT16_C(28075), UINT16_C(51802),
        UINT16_C(24054), UINT16_C(48676), UINT16_C(30451), UINT16_C(14076), UINT16_C(56847), UINT16_C(19966), UINT16_C(64556), UINT16_C( 8604) },
      { UINT16_C(    0),      UINT16_MAX, UINT16_C(65193),      UINT16_MAX, UINT16_C(    0), UINT16_C(    0), UINT16_C(    0), UINT16_C(10256),
        UINT16_C(    0), UINT16_C(    0), UINT16_C(    0), UINT16_C(55847), UINT16_C(52993),      UINT16_MAX,      UINT16_MAX,      UINT16_MAX,
        UINT16_C(    0), UINT16_C(    0), UINT16_C(    0), UINT16_C(    0), UINT16_C(    0), UINT16_C(    0),      UINT16_MAX,      UINT16_MAX,
        UINT16_C(    0),      UINT16_MAX, UINT16_C(    0), UINT16_C(    0),      UINT16_MAX, UINT16_C(    0), UINT16_C(    0), UINT16_C(    0) } },
    { UINT32_C(4161770385),
      { UINT16_C(42306), UINT16_C(26911), UINT16_C(28613), UINT16_C(29114), UINT16_C( 5340), UINT16_C(53819), UINT16_C(24433), UINT16_C(26000),
        UINT16_C(36054), UINT16_C(58779), UINT16_C(39531), UINT16_C(38706), UINT16_C(52886), UINT16_C(10169), UINT16_C(51297), UINT16_C(41759),
        UINT16_C(15981), UINT16_C(12812), UINT16_C(50861), UINT16_C(35491), UINT16_C(57306), UINT16_C(19548), UINT16_C(60734), UINT16_C( 5297),
        UINT16_C(19577), UINT16_C(58617), UINT16_C(11238), UINT16_C(31868), UINT16_C(13817), UINT16_C(23203), UINT16_C(49917), UINT16_C(27389) },
      { UINT16_C( 2305), UINT16_C(44700), UINT16_C(16591), UINT16_C(43576), UINT16_C(38175), UINT16_C(24054), UINT16_C(42882), UINT16_C(64370),
        UINT16_C(27635), UINT16_C(56032), UINT16_C(23703), UINT16_C(36950), UINT16_C(64145), UINT16_C(36587), UINT16_C(59580), UINT16_C(48632),
        UINT16_C(38130), UINT16_C(49516), UINT16_C(42196), UINT16_C(62315), UINT16_C(24889), UINT16_C(47953), UINT16_C(49928), UINT16_C(64695),
        UINT16_C(38702), UINT16_C(50646), UINT16_C(11507), UINT16_C(33878), UINT16_C(16678), UINT16_C(58130), UINT16_C( 2601), UINT16_C( 7072) },
      { UINT16_C(44611), UINT16_C(    0), UINT16_C(    0), UINT16_C(    0), UINT16_C(43515), UINT16_C(    0), UINT16_C(    0),      UINT16_MAX,
        UINT16_C(63689),      UINT16_MAX, UINT16_C(    0), UINT16_C(    0),      UINT16_MAX, UINT16_C(    0), UINT16_C(    0),      UINT16_MAX,
        UINT16_C(54111), UINT16_C(62328),      UINT16_MAX,      UINT16_MAX, UINT16_C(    0), UINT16_C(    0), UINT16_C(    0), UINT16_C(    0),
        UINT16_C(    0), UINT16_C(    0), UINT16_C(    0),      UINT16_MAX, UINT16_C(30495),      UINT16_MAX, UINT16_C(52518), UINT16_C(34461) } },
    { UINT32_C(1943866526),
      { UINT16_C(18609), UINT16_C(60006), UINT16_C(47018), UINT16_C(45734), UINT16_C(23930), UINT16_C(43438), UINT16_C(34036), UINT16_C(59246),
        UINT16_C(50353), UINT16_C(55147), UINT16_C(32005), UINT16_C(12218), UINT16_C(23431), UINT16_C( 9546), UINT16_C(10087), UINT16_C( 6296),
        UINT16_C(65392), UINT16_C( 6659), UINT16_C(43446), UINT16_C(12748), UINT16_C(31494), UINT16_C(64218), UINT16_C(18687), UINT16_C(45281),
        UINT16_C(19469), UINT16_C( 4744), UINT16_C(17097), UINT16_C(20545), UINT16_C(35997), UINT16_C( 1397), UINT16_C( 3763), UINT16_C( 8989) },
      { UINT16_C( 8205), UINT16_C(49981), UINT16_C( 2761), UINT16_C(53236), UINT16_C(52869), UINT16_C(33993), UINT16_C(43543), UINT16_C( 9269),
        UINT16_C(48630), UINT16_C(48950), UINT16_C(30975), UINT16_C(40207), UINT16_C(34052), UINT16_C(47010), UINT16_C(49043), UINT16_C(41179),
        UINT16_C( 6368), UINT16_C(43363), UINT16_C(22562), UINT16_C(42873), UINT16_C(16934), UINT16_C(15660), UINT16_C(25069), UINT16_C(58209),
        UINT16_C(38942), UINT16_C( 7587), UINT16_C(45584), UINT16_C( 5306), UINT16_C(23607), UINT16_C(51915), UINT16_C(42524), UINT16_C(64618) },
      { UINT16_C(    0),      UINT16_MAX, UINT16_C(49779),      UINT16_MAX,      UINT16_MAX, UINT16_C(    0), UINT16_C(    0),      UINT16_MAX,
        UINT16_C(    0), UINT16_C(    0), UINT16_C(62980), UINT16_C(52425), UINT16_C(    0), UINT16_C(    0), UINT16_C(    0), UINT16_C(    0),
             UINT16_MAX, UINT16_C(    0),      UINT16_MAX, UINT16_C(55621), UINT16_C(48428), UINT16_C(    0), UINT16_C(43756),      UINT16_MAX,
        UINT16_C(58411), UINT16_C(12331), UINT16_C(    0), UINT16_C(    0), UINT16_C(59604), UINT16_C(53312), UINT16_C(46287), UINT16_C(    0) } },
    { UINT32_C(3785739967),
      { UINT16_C( 7718), UINT16_C(19593), UINT16_C(46433), UINT16_C(20106), UINT16_C(60182), UINT16_C(13361), UINT16_C(54403), UINT16_C(37713),
        UINT16_C( 3207), UINT16_C(48807), UINT16_C(29544), UINT16_C(33929), UINT16_C(62233), UINT16_C(55424), UINT16_C( 9921), UINT16_C(59322),
        UINT16_C(17220), UINT16_C(42292), UINT16_C(48888), UINT16_C( 3827), UINT16_C( 9641), UINT16_C(11586), UINT16_C(37881), UINT16_C(32960),
        UINT16_C(26783), UINT16_C( 2111), UINT16_C(51419), UINT16_C(62604), UINT16_C( 3515), UINT16_C(32205), UINT16_C(34611), UINT16_C(30564) },
      { UINT16_C(39114), UINT16_C(49693), UINT16_C( 4182), UINT16_C(  208), UINT16_C( 4661), UINT16_C(12077), UINT16_C(60837), UINT16_C(17839),
        UINT16_C(61013), UINT16_C(12365), UINT16_C(55734), UINT16_C(29221), UINT16_C(62182), UINT16_C( 6639), UINT16_C(21369), UINT16_C(17297),
        UINT16_C(44780), UINT16_C(16901), UINT16_C(54718), UINT16_C(62530), UINT16_C(28647), UINT16_C(35875), UINT16_C(53853), UINT16_C(45777),
        UINT16_C( 7873), UINT16_C(30691), UINT16_C( 2296), UINT16_C(57065), UINT16_C(55546), UINT16_C(29688), UINT16_C(35116), UINT16_C( 6326) },
      { UINT16_C(46832),      UINT16_MAX, UINT16_C(50615), UINT16_C(20314), UINT16_C(64843), UINT16_C(25438), UINT16_C(    0), UINT16_C(55552),
        UINT16_C(    0), UINT16_C(61172),      UINT16_MAX, UINT16_C(63150), UINT16_C(    0), UINT16_C(    0), UINT16_C(31290),      UINT16_MAX,
        UINT16_C(62000), UINT16_C(    0),      UINT16_MAX, UINT16_C(    0), UINT16_C(    0), UINT16_C(47461), UINT16_C(    0),      UINT16_MAX,
        UINT16_C(34656), UINT16_C(    0), UINT16_C(    0), UINT16_C(    0), UINT16_C(    0), UINT16_C(61893),      UINT16_MAX, UINT16_C(36890) } },
    { UINT32_C(4116364087),
      { UINT16_C(40336), UINT16_C(30697), UINT16_C( 3084), UINT16_C(26883), UINT16_C(54751), UINT16_C(40988), UINT16_C(65523), UINT16_C(60183),
        UINT16_C(  263), UINT16_C(  458), UINT16_C(49881), UINT16_C( 1396), UINT16_C(10827), UINT16_C(33309), UINT16_C(30949), UINT16_C(30071),
        UINT16_C(24853), UINT16_C( 8684), UINT16_C(61293), UINT16_C(19595), UINT16_C(42948), UINT16_C(47340), UINT16_C( 1190), UINT16_C(44451),
        UINT16_C(27909), UINT16_C(57006), UINT16_C( 8751), UINT16_C(31460), UINT16_C(  332), UINT16_C(12796), UINT16_C(29817), UINT16_C(36518) },
      { UINT16_C(37589), UINT16_C(17072), UINT16_C(15233), UINT16_C(18063), UINT16_C(31714), UINT16_C(35070), UINT16_C(41343), UINT16_C(33845),
        UINT16_C(58127), UINT16_C(15971), UINT16_C(18181), UINT16_C(20921), UINT16_C(46408), UINT16_C(49794), UINT16_C(10281), UINT16_C(65104),
        UINT16_C(  186), UINT16_C(15169), UINT16_C(53307), UINT16_C( 7553), UINT16_C(32587), UINT16_C(52133), UINT16_C(55841), UINT16_C(12367),
        UINT16_C(45757), UINT16_C(49774), UINT16_C(10233), UINT16_C(16915), UINT16_C(38365), UINT16_C( 1540), UINT16_C(21693), UINT16_C(30469) },
      {      UINT16_MAX, UINT16_C(47769), UINT16_C(18317), UINT16_C(    0),      UINT16_MAX,      UINT16_MAX, UINT16_C(    0), UINT16_C(    0),
        UINT16_C(58390), UINT16_C(16429), UINT16_C(    0), UINT16_C(22317), UINT16_C(57235),      UINT16_MAX, UINT16_C(    0),      UINT16_MAX,
        UINT16_C(    0), UINT16_C(23853), UINT16_C(    0), UINT16_C(27148),      UINT16_MAX, UINT16_C(    0), UINT16_C(57031), UINT16_C(    0),
             UINT16_MAX, UINT16_C(    0), UINT16_C(18984), UINT16_C(    0), UINT16_C(38697), UINT16_C(14336), UINT16_C(51510),      UINT16_MAX } },
    { UINT32_C(2427668053),
      { UINT16_C(13334), UINT16_C(25006), UINT16_C(21428), UINT16_C(54572), UINT16_C(31790), UINT16_C(60165), UINT16_C(29486), UINT16_C(10414),
        UINT16_C(49563), UINT16_C(30826), UINT16_C(28247), UINT16_C( 5246), UINT16_C(33730), UINT16_C( 6028), UINT16_C(16329), UINT16_C(57256),
        UINT16_C(22131), UINT16_C(10049), UINT16_C(28073), UINT16_C(55292), UINT16_C(  489), UINT16_C( 6339), UINT16_C(29045), UINT16_C( 4160),
        UINT16_C(43570), UINT16_C(35208), UINT16_C( 1560), UINT16_C(55966), UINT16_C(10890), UINT16_C(21490), UINT16_C(39529), UINT16_C(56371) },
      { UINT16_C(29936), UINT16_C(39172), UINT16_C(  225), UINT16_C(52081), UINT16_C(13314), UINT16_C(30691), UINT16_C( 9125), UINT16_C(55175),
        UINT16_C( 4045), UINT16_C(58721), UINT16_C(65301), UINT16_C(40895), UINT16_C(45353), UINT16_C(37619), UINT16_C( 9803), UINT16_C(15214),
        UINT16_C(29338), UINT16_C(31701), UINT16_C(18035), UINT16_C(30022), UINT16_C(10618), UINT16_C( 8172), UINT16_C(29516), UINT16_C( 6646),
        UINT16_C(22402), UINT16_C(38910), UINT16_C(48726), UINT16_C(32567), UINT16_C(10863), UINT16_C(47889), UINT16_C(32848), UINT16_C(60150) },
      { UINT16_C(43270), UINT16_C(    0), UINT16_C(21653), UINT16_C(    0), UINT16_C(45104), UINT16_C(    0), UINT16_C(38611), UINT16_C(    0),
        UINT16_C(    0),      UINT16_MAX,      UINT16_MAX, UINT16_C(    0), UINT16_C(    0), UINT16_C(    0), UINT16_C(26132), UINT16_C(    0),
        UINT16_C(51469), UINT16_C(41750), UINT16_C(    0), UINT16_C(    0), UINT16_C(11107), UINT16_C(14511), UINT16_C(    0), UINT16_C(10806),
        UINT16_C(    0), UINT16_C(    0), UINT16_C(    0), UINT16_C(    0), UINT16_C(21753), UINT16_C(    0), UINT16_C(    0),      UINT16_MAX } },
    { UINT32_C(1701170162),
      { UINT16_C(44049), UINT16_C(35802), UINT16_C(50901), UINT16_C( 8874), UINT16_C(41273), UINT16_C(47931), UINT16_C(15096), UINT16_C(20307),
        UINT16_C(35576), UINT16_C(26574), UINT16_C(57524), UINT16_C( 1058), UINT16_C( 6496), UINT16_C(21230), UINT16_C(21476), UINT16_C(63160),
        UINT16_C(37631), UINT16_C(54657), UINT16_C(11353), UINT16_C(37623), UINT16_C(13005), UINT16_C(50510), UINT16_C(41324), UINT16_C(25620),
        UINT16_C(58155), UINT16_C(57292), UINT16_C(61123), UINT16_C( 9187), UINT16_C(53511), UINT16_C(60533), UINT16_C(11556), UINT16_C( 9442) },
      { UINT16_C(25536), UINT16_C( 6649), UINT16_C(61583), UINT16_C(23723), UINT16_C(63778), UINT16_C(36642), UINT16_C(13978), UINT16_C(50675),
        UINT16_C(48921), UINT16_C(56484), UINT16_C(34734), UINT16_C(46591), UINT16_C(30040), UINT16_C(32161), UINT16_C(33698), UINT16_C(25249),
        UINT16_C(39655), UINT16_C(30331), UINT16_C(10122), UINT16_C(44243), UINT16_C(62752), UINT16_C(47931), UINT16_C(12075), UINT16_C(17792),
        UINT16_C( 9710), UINT16_C(39969), UINT16_C( 8620), UINT16_C( 1362), UINT16_C(62358), UINT16_C(14466), UINT16_C( 9079), UINT16_C(24219) },
      { UINT16_C(    0), UINT16_C(42451), UINT16_C(    0), UINT16_C(    0),      UINT16_MAX,      UINT16_MAX, UINT16_C(29074),      UINT16_MAX,
             UINT16_MAX,      UINT16_MAX, UINT16_C(    0), UINT16_C(47649), UINT16_C(    0), UINT16_C(    0), UINT16_C(55174),      UINT16_MAX,
             UINT16_MAX, UINT16_C(    0), UINT16_C(21475), UINT16_C(    0), UINT16_C(    0),      UINT16_MAX, UINT16_C(53399), UINT16_C(    0),
             UINT16_MAX, UINT16_C(    0),      UINT16_MAX, UINT16_C(    0), UINT16_C(    0),      UINT16_MAX, UINT16_C(20635), UINT16_C(    0) } }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512i a = simde_mm512_loadu_epi16(test_vec[i].a);
    simde__m512i b = simde_mm512_loadu_epi16(test_vec[i].b);
    simde__m512i r = simde_mm512_maskz_adds_epu16(test_vec[i].k, a, b);
    simde_test_x86_assert_equal_u16x32(r, simde_mm512_loadu_epi16(test_vec[i].r));
  }

  return 0;
}

static int
test_simde_mm512_avg_epu8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C( 54), UINT8_C( 98), UINT8_C(144), UINT8_C( 33),
                             UINT8_C(227), UINT8_C( 68), UINT8_C( 44), UINT8_C(252),
                             UINT8_C(188), UINT8_C(131), UINT8_C( 22), UINT8_C(137),
                             UINT8_C(110), UINT8_C(230), UINT8_C(116), UINT8_C( 30),
                             UINT8_C(237), UINT8_C(136), UINT8_C(151), UINT8_C(122),
                             UINT8_C( 83), UINT8_C(138), UINT8_C(146), UINT8_C(187),
                             UINT8_C( 83), UINT8_C(179), UINT8_C(167), UINT8_C( 88),
                             UINT8_C(248), UINT8_C( 88), UINT8_C(101), UINT8_C(132),
                             UINT8_C(203), UINT8_C( 36), UINT8_C( 53), UINT8_C(174),
                             UINT8_C( 78), UINT8_C( 97), UINT8_C(124), UINT8_C(201),
                             UINT8_C( 12), UINT8_C(233), UINT8_C(196), UINT8_C(121),
                             UINT8_C( 77), UINT8_C(  2), UINT8_C(189), UINT8_C(251),
                             UINT8_C(252), UINT8_C(129), UINT8_C( 38), UINT8_C(107),
                             UINT8_C(130), UINT8_C(227), UINT8_C(158), UINT8_C(158),
                             UINT8_C(195), UINT8_C( 10), UINT8_C(101), UINT8_C( 55),
                             UINT8_C( 64), UINT8_C(106), UINT8_C(118), UINT8_C( 58)),
      simde_x_mm512_set_epu8(UINT8_C(139), UINT8_C( 91), UINT8_C( 12), UINT8_C(185),
                             UINT8_C( 48), UINT8_C(130), UINT8_C(230), UINT8_C(176),
                             UINT8_C(212), UINT8_C( 20), UINT8_C(110), UINT8_C(217),
                             UINT8_C(186), UINT8_C(186), UINT8_C(132), UINT8_C(114),
                             UINT8_C(188), UINT8_C(251), UINT8_C(225), UINT8_C(230),
                             UINT8_C(165), UINT8_C(108), UINT8_C( 17), UINT8_C(  9),
                             UINT8_C(245), UINT8_C(227), UINT8_C(125), UINT8_C(240),
                             UINT8_C( 47), UINT8_C( 91), UINT8_C(  3), UINT8_C(135),
                             UINT8_C(243), UINT8_C(103), UINT8_C(152), UINT8_C(185),
                             UINT8_C( 49), UINT8_C(  8), UINT8_C( 66), UINT8_C(147),
                             UINT8_C( 50), UINT8_C(167), UINT8_C( 57), UINT8_C(102),
                             UINT8_C(142), UINT8_C( 47), UINT8_C(173), UINT8_C( 47),
                             UINT8_C(172), UINT8_C(237), UINT8_C( 57), UINT8_C(255),
                             UINT8_C(101), UINT8_C(227), UINT8_C(198), UINT8_C(199),
                             UINT8_C( 25), UINT8_C(175), UINT8_C(229), UINT8_C(172),
                             UINT8_C(210), UINT8_C(198), UINT8_C(215), UINT8_C(150)),
      simde_x_mm512_set_epu8(UINT8_C( 97), UINT8_C( 95), UINT8_C( 78), UINT8_C(109),
                             UINT8_C(138), UINT8_C( 99), UINT8_C(137), UINT8_C(214),
                             UINT8_C(200), UINT8_C( 76), UINT8_C( 66), UINT8_C(177),
                             UINT8_C(148), UINT8_C(208), UINT8_C(124), UINT8_C( 72),
                             UINT8_C(213), UINT8_C(194), UINT8_C(188), UINT8_C(176),
                             UINT8_C(124), UINT8_C(123), UINT8_C( 82), UINT8_C( 98),
                             UINT8_C(164), UINT8_C(203), UINT8_C(146), UINT8_C(164),
                             UINT8_C(148), UINT8_C( 90), UINT8_C( 52), UINT8_C(134),
                             UINT8_C(223), UINT8_C( 70), UINT8_C(103), UINT8_C(180),
                             UINT8_C( 64), UINT8_C( 53), UINT8_C( 95), UINT8_C(174),
                             UINT8_C( 31), UINT8_C(200), UINT8_C(127), UINT8_C(112),
                             UINT8_C(110), UINT8_C( 25), UINT8_C(181), UINT8_C(149),
                             UINT8_C(212), UINT8_C(183), UINT8_C( 48), UINT8_C(181),
                             UINT8_C(116), UINT8_C(227), UINT8_C(178), UINT8_C(179),
                             UINT8_C(110), UINT8_C( 93), UINT8_C(165), UINT8_C(114),
                             UINT8_C(137), UINT8_C(152), UINT8_C(167), UINT8_C(104)) },
    { simde_x_mm512_set_epu8(UINT8_C(208), UINT8_C(219), UINT8_C( 57), UINT8_C(220),
                             UINT8_C(  6), UINT8_C( 65), UINT8_C( 21), UINT8_C( 70),
                             UINT8_C( 42), UINT8_C( 69), UINT8_C(205), UINT8_C( 75),
                             UINT8_C( 45), UINT8_C( 93), UINT8_C(126), UINT8_C(  6),
                             UINT8_C(174), UINT8_C( 50), UINT8_C( 17), UINT8_C(221),
                             UINT8_C(217), UINT8_C(127), UINT8_C(111), UINT8_C(120),
                             UINT8_C(131), UINT8_C(148), UINT8_C(141), UINT8_C(152),
                             UINT8_C(144), UINT8_C(136), UINT8_C( 66), UINT8_C( 61),
                             UINT8_C(132), UINT8_C(112), UINT8_C( 28), UINT8_C(152),
                             UINT8_C(127), UINT8_C(231), UINT8_C(109), UINT8_C(161),
                             UINT8_C(158), UINT8_C(  6), UINT8_C(213), UINT8_C(173),
                             UINT8_C(118), UINT8_C(179), UINT8_C( 79), UINT8_C(178),
                             UINT8_C( 46), UINT8_C(236), UINT8_C( 49), UINT8_C( 56),
                             UINT8_C(157), UINT8_C(129), UINT8_C( 46), UINT8_C(200),
                             UINT8_C( 89), UINT8_C(130), UINT8_C(187), UINT8_C(247),
                             UINT8_C(213), UINT8_C( 39), UINT8_C(146), UINT8_C(142)),
      simde_x_mm512_set_epu8(UINT8_C( 76), UINT8_C(227), UINT8_C(192), UINT8_C(129),
                             UINT8_C(228), UINT8_C( 26), UINT8_C(165), UINT8_C(150),
                             UINT8_C(111), UINT8_C( 32), UINT8_C( 11), UINT8_C( 66),
                             UINT8_C( 65), UINT8_C(106), UINT8_C(209), UINT8_C(140),
                             UINT8_C( 66), UINT8_C(  2), UINT8_C(157), UINT8_C(126),
                             UINT8_C( 65), UINT8_C(  8), UINT8_C( 57), UINT8_C( 55),
                             UINT8_C(150), UINT8_C( 40), UINT8_C(164), UINT8_C( 54),
                             UINT8_C( 94), UINT8_C(153), UINT8_C(234), UINT8_C(140),
                             UINT8_C( 45), UINT8_C( 64), UINT8_C(136), UINT8_C(209),
                             UINT8_C(101), UINT8_C(213), UINT8_C(147), UINT8_C(253),
                             UINT8_C( 57), UINT8_C(116), UINT8_C( 96), UINT8_C( 87),
                             UINT8_C(172), UINT8_C( 78), UINT8_C(156), UINT8_C(126),
                             UINT8_C(  3), UINT8_C(150), UINT8_C(133), UINT8_C( 13),
                             UINT8_C(226), UINT8_C( 18), UINT8_C(106), UINT8_C(202),
                             UINT8_C( 95), UINT8_C( 92), UINT8_C( 59), UINT8_C(210),
                             UINT8_C(140), UINT8_C( 87), UINT8_C(213), UINT8_C( 52)),
      simde_x_mm512_set_epu8(UINT8_C(142), UINT8_C(223), UINT8_C(125), UINT8_C(175),
                             UINT8_C(117), UINT8_C( 46), UINT8_C( 93), UINT8_C(110),
                             UINT8_C( 77), UINT8_C( 51), UINT8_C(108), UINT8_C( 71),
                             UINT8_C( 55), UINT8_C(100), UINT8_C(168), UINT8_C( 73),
                             UINT8_C(120), UINT8_C( 26), UINT8_C( 87), UINT8_C(174),
                             UINT8_C(141), UINT8_C( 68), UINT8_C( 84), UINT8_C( 88),
                             UINT8_C(141), UINT8_C( 94), UINT8_C(153), UINT8_C(103),
                             UINT8_C(119), UINT8_C(145), UINT8_C(150), UINT8_C(101),
                             UINT8_C( 89), UINT8_C( 88), UINT8_C( 82), UINT8_C(181),
                             UINT8_C(114), UINT8_C(222), UINT8_C(128), UINT8_C(207),
                             UINT8_C(108), UINT8_C( 61), UINT8_C(155), UINT8_C(130),
                             UINT8_C(145), UINT8_C(129), UINT8_C(118), UINT8_C(152),
                             UINT8_C( 25), UINT8_C(193), UINT8_C( 91), UINT8_C( 35),
                             UINT8_C(192), UINT8_C( 74), UINT8_C( 76), UINT8_C(201),
                             UINT8_C( 92), UINT8_C(111), UINT8_C(123), UINT8_C(229),
                             UINT8_C(177), UINT8_C( 63), UINT8_C(180), UINT8_C( 97)) },
    { simde_x_mm512_set_epu8(UINT8_C( 11), UINT8_C(110), UINT8_C(145), UINT8_C( 98),
                             UINT8_C(192), UINT8_C(110), UINT8_C(161), UINT8_C( 50),
                             UINT8_C(252), UINT8_C(104), UINT8_C(187), UINT8_C( 15),
                             UINT8_C(183), UINT8_C(198), UINT8_C( 79), UINT8_C(  9),
                             UINT8_C( 68), UINT8_C(123), UINT8_C(137), UINT8_C(144),
                             UINT8_C(105), UINT8_C( 90), UINT8_C( 86), UINT8_C( 94),
                             UINT8_C( 93), UINT8_C( 77), UINT8_C(192), UINT8_C(  8),
                             UINT8_C( 44), UINT8_C( 25), UINT8_C( 87), UINT8_C(143),
                             UINT8_C(226), UINT8_C( 88), UINT8_C(154), UINT8_C(252),
                             UINT8_C( 55), UINT8_C(166), UINT8_C(142), UINT8_C(195),
                             UINT8_C(169), UINT8_C(178), UINT8_C(205), UINT8_C( 91),
                             UINT8_C( 65), UINT8_C(198), UINT8_C(127), UINT8_C( 53),
                             UINT8_C(245), UINT8_C( 24), UINT8_C(177), UINT8_C(240),
                             UINT8_C(199), UINT8_C( 24), UINT8_C(143), UINT8_C(108),
                             UINT8_C( 39), UINT8_C(170), UINT8_C(163), UINT8_C(222),
                             UINT8_C( 56), UINT8_C(160), UINT8_C(200), UINT8_C(122)),
      simde_x_mm512_set_epu8(UINT8_C( 57), UINT8_C( 48), UINT8_C(248), UINT8_C( 92),
                             UINT8_C( 57), UINT8_C(154), UINT8_C( 83), UINT8_C(125),
                             UINT8_C( 10), UINT8_C(154), UINT8_C( 72), UINT8_C(111),
                             UINT8_C( 67), UINT8_C( 46), UINT8_C(125), UINT8_C(202),
                             UINT8_C( 45), UINT8_C( 61), UINT8_C( 52), UINT8_C(168),
                             UINT8_C(212), UINT8_C( 16), UINT8_C( 37), UINT8_C(131),
                             UINT8_C( 48), UINT8_C( 90), UINT8_C(210), UINT8_C(233),
                             UINT8_C(148), UINT8_C(  2), UINT8_C( 10), UINT8_C( 62),
                             UINT8_C( 89), UINT8_C(180), UINT8_C( 94), UINT8_C( 22),
                             UINT8_C(254), UINT8_C( 77), UINT8_C(  0), UINT8_C(151),
                             UINT8_C(212), UINT8_C( 38), UINT8_C(106), UINT8_C(205),
                             UINT8_C( 72), UINT8_C(159), UINT8_C(226), UINT8_C( 51),
                             UINT8_C( 53), UINT8_C(162), UINT8_C(189), UINT8_C( 88),
                             UINT8_C( 42), UINT8_C(136), UINT8_C(104), UINT8_C(208),
                             UINT8_C(154), UINT8_C(241), UINT8_C(187), UINT8_C(143),
                             UINT8_C(157), UINT8_C( 95), UINT8_C( 29), UINT8_C( 97)),
      simde_x_mm512_set_epu8(UINT8_C( 34), UINT8_C( 79), UINT8_C(197), UINT8_C( 95),
                             UINT8_C(125), UINT8_C(132), UINT8_C(122), UINT8_C( 88),
                             UINT8_C(131), UINT8_C(129), UINT8_C(130), UINT8_C( 63),
                             UINT8_C(125), UINT8_C(122), UINT8_C(102), UINT8_C(106),
                             UINT8_C( 57), UINT8_C( 92), UINT8_C( 95), UINT8_C(156),
                             UINT8_C(159), UINT8_C( 53), UINT8_C( 62), UINT8_C(113),
                             UINT8_C( 71), UINT8_C( 84), UINT8_C(201), UINT8_C(121),
                             UINT8_C( 96), UINT8_C( 14), UINT8_C( 49), UINT8_C(103),
                             UINT8_C(158), UINT8_C(134), UINT8_C(124), UINT8_C(137),
                             UINT8_C(155), UINT8_C(122), UINT8_C( 71), UINT8_C(173),
                             UINT8_C(191), UINT8_C(108), UINT8_C(156), UINT8_C(148),
                             UINT8_C( 69), UINT8_C(179), UINT8_C(177), UINT8_C( 52),
                             UINT8_C(149), UINT8_C( 93), UINT8_C(183), UINT8_C(164),
                             UINT8_C(121), UINT8_C( 80), UINT8_C(124), UINT8_C(158),
                             UINT8_C( 97), UINT8_C(206), UINT8_C(175), UINT8_C(183),
                             UINT8_C(107), UINT8_C(128), UINT8_C(115), UINT8_C(110)) },
    { simde_x_mm512_set_epu8(UINT8_C(130), UINT8_C( 79), UINT8_C( 82), UINT8_C(  5),
                             UINT8_C(236), UINT8_C(119), UINT8_C( 25), UINT8_C( 77),
                             UINT8_C(139), UINT8_C(103), UINT8_C(204), UINT8_C( 53),
                             UINT8_C( 70), UINT8_C( 81), UINT8_C( 35), UINT8_C(154),
                             UINT8_C(229), UINT8_C( 64), UINT8_C( 94), UINT8_C(131),
                             UINT8_C(217), UINT8_C(  4), UINT8_C(103), UINT8_C(204),
                             UINT8_C( 53), UINT8_C( 46), UINT8_C(123), UINT8_C(123),
                             UINT8_C(251), UINT8_C(227), UINT8_C(153), UINT8_C( 16),
                             UINT8_C( 79), UINT8_C(199), UINT8_C( 15), UINT8_C(177),
                             UINT8_C( 83), UINT8_C( 15), UINT8_C( 37), UINT8_C(215),
                             UINT8_C(178), UINT8_C(145), UINT8_C(240), UINT8_C( 53),
                             UINT8_C(116), UINT8_C(195), UINT8_C(101), UINT8_C(243),
                             UINT8_C(134), UINT8_C( 93), UINT8_C( 64), UINT8_C(103),
                             UINT8_C( 73), UINT8_C( 82), UINT8_C(189), UINT8_C( 37),
                             UINT8_C(202), UINT8_C( 62), UINT8_C(157), UINT8_C( 97),
                             UINT8_C(142), UINT8_C(  6), UINT8_C( 38), UINT8_C( 24)),
      simde_x_mm512_set_epu8(UINT8_C( 57), UINT8_C( 93), UINT8_C(144), UINT8_C( 30),
                             UINT8_C( 11), UINT8_C(223), UINT8_C( 55), UINT8_C(131),
                             UINT8_C( 29), UINT8_C(176), UINT8_C( 52), UINT8_C( 84),
                             UINT8_C( 79), UINT8_C( 47), UINT8_C(128), UINT8_C( 28),
                             UINT8_C( 73), UINT8_C(131), UINT8_C(138), UINT8_C(  1),
                             UINT8_C( 98), UINT8_C(110), UINT8_C(210), UINT8_C(168),
                             UINT8_C(208), UINT8_C(103), UINT8_C(151), UINT8_C( 58),
                             UINT8_C(149), UINT8_C( 16), UINT8_C(113), UINT8_C( 41),
                             UINT8_C(201), UINT8_C( 13), UINT8_C(211), UINT8_C(230),
                             UINT8_C(208), UINT8_C(154), UINT8_C( 49), UINT8_C(127),
                             UINT8_C( 93), UINT8_C(  7), UINT8_C(136), UINT8_C( 53),
                             UINT8_C( 19), UINT8_C( 95), UINT8_C(187), UINT8_C(149),
                             UINT8_C(  0), UINT8_C(161), UINT8_C(228), UINT8_C( 84),
                             UINT8_C( 84), UINT8_C(105), UINT8_C( 90), UINT8_C( 17),
                             UINT8_C(  3), UINT8_C(183), UINT8_C(131), UINT8_C( 24),
                             UINT8_C(201), UINT8_C(  5), UINT8_C(128), UINT8_C( 80)),
      simde_x_mm512_set_epu8(UINT8_C( 94), UINT8_C( 86), UINT8_C(113), UINT8_C( 18),
                             UINT8_C(124), UINT8_C(171), UINT8_C( 40), UINT8_C(104),
                             UINT8_C( 84), UINT8_C(140), UINT8_C(128), UINT8_C( 69),
                             UINT8_C( 75), UINT8_C( 64), UINT8_C( 82), UINT8_C( 91),
                             UINT8_C(151), UINT8_C( 98), UINT8_C(116), UINT8_C( 66),
                             UINT8_C(158), UINT8_C( 57), UINT8_C(157), UINT8_C(186),
                             UINT8_C(131), UINT8_C( 75), UINT8_C(137), UINT8_C( 91),
                             UINT8_C(200), UINT8_C(122), UINT8_C(133), UINT8_C( 29),
                             UINT8_C(140), UINT8_C(106), UINT8_C(113), UINT8_C(204),
                             UINT8_C(146), UINT8_C( 85), UINT8_C( 43), UINT8_C(171),
                             UINT8_C(136), UINT8_C( 76), UINT8_C(188), UINT8_C( 53),
                             UINT8_C( 68), UINT8_C(145), UINT8_C(144), UINT8_C(196),
                             UINT8_C( 67), UINT8_C(127), UINT8_C(146), UINT8_C( 94),
                             UINT8_C( 79), UINT8_C( 94), UINT8_C(140), UINT8_C( 27),
                             UINT8_C(103), UINT8_C(123), UINT8_C(144), UINT8_C( 61),
                             UINT8_C(172), UINT8_C(  6), UINT8_C( 83), UINT8_C( 52)) },
    { simde_x_mm512_set_epu8(UINT8_C( 64), UINT8_C( 98), UINT8_C(116), UINT8_C(169),
                             UINT8_C(168), UINT8_C(153), UINT8_C(192), UINT8_C(140),
                             UINT8_C( 79), UINT8_C( 29), UINT8_C(180), UINT8_C(232),
                             UINT8_C( 89), UINT8_C( 84), UINT8_C(140), UINT8_C(130),
                             UINT8_C(108), UINT8_C(184), UINT8_C(116), UINT8_C( 83),
                             UINT8_C(161), UINT8_C(105), UINT8_C( 17), UINT8_C(119),
                             UINT8_C(  0), UINT8_C(101), UINT8_C(104), UINT8_C(103),
                             UINT8_C(226), UINT8_C( 60), UINT8_C( 23), UINT8_C(129),
                             UINT8_C(141), UINT8_C(179), UINT8_C( 87), UINT8_C(113),
                             UINT8_C(251), UINT8_C(219), UINT8_C(107), UINT8_C(119),
                             UINT8_C( 70), UINT8_C(169), UINT8_C( 11), UINT8_C( 91),
                             UINT8_C( 23), UINT8_C(156), UINT8_C( 99), UINT8_C( 36),
                             UINT8_C(154), UINT8_C( 26), UINT8_C( 23), UINT8_C(168),
                             UINT8_C( 12), UINT8_C(101), UINT8_C(189), UINT8_C(124),
                             UINT8_C(154), UINT8_C( 52), UINT8_C(134), UINT8_C(128),
                             UINT8_C(213), UINT8_C( 85), UINT8_C(189), UINT8_C(209)),
      simde_x_mm512_set_epu8(UINT8_C( 21), UINT8_C( 27), UINT8_C( 57), UINT8_C(175),
                             UINT8_C(191), UINT8_C( 35), UINT8_C( 75), UINT8_C(  5),
                             UINT8_C(168), UINT8_C( 42), UINT8_C(198), UINT8_C(223),
                             UINT8_C(239), UINT8_C(225), UINT8_C(227), UINT8_C(  5),
                             UINT8_C( 85), UINT8_C(196), UINT8_C(184), UINT8_C(155),
                             UINT8_C( 73), UINT8_C(109), UINT8_C(131), UINT8_C(103),
                             UINT8_C(131), UINT8_C(155), UINT8_C(105), UINT8_C( 70),
                             UINT8_C(164), UINT8_C(114), UINT8_C(114), UINT8_C(212),
                             UINT8_C(157), UINT8_C( 34), UINT8_C(220), UINT8_C(250),
                             UINT8_C(254), UINT8_C(227), UINT8_C(240), UINT8_C( 41),
                             UINT8_C(208), UINT8_C( 26), UINT8_C(221), UINT8_C(132),
                             UINT8_C(121), UINT8_C(178), UINT8_C(219), UINT8_C( 55),
                             UINT8_C( 45), UINT8_C( 78), UINT8_C(233), UINT8_C( 53),
                             UINT8_C( 87), UINT8_C(172), UINT8_C(122), UINT8_C(147),
                             UINT8_C(187), UINT8_C(115), UINT8_C( 22), UINT8_C(254),
                             UINT8_C(  9), UINT8_C(218), UINT8_C(224), UINT8_C(214)),
      simde_x_mm512_set_epu8(UINT8_C( 43), UINT8_C( 63), UINT8_C( 87), UINT8_C(172),
                             UINT8_C(180), UINT8_C( 94), UINT8_C(134), UINT8_C( 73),
                             UINT8_C(124), UINT8_C( 36), UINT8_C(189), UINT8_C(228),
                             UINT8_C(164), UINT8_C(155), UINT8_C(184), UINT8_C( 68),
                             UINT8_C( 97), UINT8_C(190), UINT8_C(150), UINT8_C(119),
                             UINT8_C(117), UINT8_C(107), UINT8_C( 74), UINT8_C(111),
                             UINT8_C( 66), UINT8_C(128), UINT8_C(105), UINT8_C( 87),
                             UINT8_C(195), UINT8_C( 87), UINT8_C( 69), UINT8_C(171),
                             UINT8_C(149), UINT8_C(107), UINT8_C(154), UINT8_C(182),
                             UINT8_C(253), UINT8_C(223), UINT8_C(174), UINT8_C( 80),
                             UINT8_C(139), UINT8_C( 98), UINT8_C(116), UINT8_C(112),
                             UINT8_C( 72), UINT8_C(167), UINT8_C(159), UINT8_C( 46),
                             UINT8_C(100), UINT8_C( 52), UINT8_C(128), UINT8_C(111),
                             UINT8_C( 50), UINT8_C(137), UINT8_C(156), UINT8_C(136),
                             UINT8_C(171), UINT8_C( 84), UINT8_C( 78), UINT8_C(191),
                             UINT8_C(111), UINT8_C(152), UINT8_C(207), UINT8_C(212)) },
    { simde_x_mm512_set_epu8(UINT8_C(136), UINT8_C( 77), UINT8_C( 92), UINT8_C(127),
                             UINT8_C(250), UINT8_C( 34), UINT8_C(180), UINT8_C(171),
                             UINT8_C( 31), UINT8_C(112), UINT8_C(162), UINT8_C(182),
                             UINT8_C(240), UINT8_C(136), UINT8_C( 96), UINT8_C( 85),
                             UINT8_C( 41), UINT8_C( 52), UINT8_C( 59), UINT8_C(203),
                             UINT8_C(213), UINT8_C(103), UINT8_C(221), UINT8_C(176),
                             UINT8_C( 99), UINT8_C(  2), UINT8_C( 21), UINT8_C(182),
                             UINT8_C(  7), UINT8_C(176), UINT8_C(125), UINT8_C(109),
                             UINT8_C(233), UINT8_C(242), UINT8_C(  5), UINT8_C(109),
                             UINT8_C( 73), UINT8_C(240), UINT8_C(175), UINT8_C( 24),
                             UINT8_C( 44), UINT8_C(103), UINT8_C(204), UINT8_C( 40),
                             UINT8_C( 78), UINT8_C(117), UINT8_C(221), UINT8_C(168),
                             UINT8_C(194), UINT8_C( 10), UINT8_C( 15), UINT8_C(227),
                             UINT8_C( 13), UINT8_C(241), UINT8_C( 93), UINT8_C( 23),
                             UINT8_C( 31), UINT8_C( 84), UINT8_C(219), UINT8_C( 76),
                             UINT8_C( 52), UINT8_C( 31), UINT8_C( 22), UINT8_C(183)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C( 70), UINT8_C(193), UINT8_C(116),
                             UINT8_C(  9), UINT8_C( 85), UINT8_C(190), UINT8_C(154),
                             UINT8_C( 37), UINT8_C(184), UINT8_C(193), UINT8_C(107),
                             UINT8_C( 79), UINT8_C(235), UINT8_C( 33), UINT8_C(125),
                             UINT8_C(111), UINT8_C(108), UINT8_C( 99), UINT8_C(162),
                             UINT8_C(175), UINT8_C(211), UINT8_C( 79), UINT8_C(167),
                             UINT8_C(166), UINT8_C( 89), UINT8_C( 21), UINT8_C(138),
                             UINT8_C( 15), UINT8_C(105), UINT8_C(191), UINT8_C(205),
                             UINT8_C( 34), UINT8_C(122), UINT8_C(209), UINT8_C(143),
                             UINT8_C(216), UINT8_C(162), UINT8_C(239), UINT8_C(190),
                             UINT8_C(212), UINT8_C(246), UINT8_C(251), UINT8_C(206),
                             UINT8_C( 61), UINT8_C( 80), UINT8_C(151), UINT8_C( 93),
                             UINT8_C( 56), UINT8_C(135), UINT8_C(169), UINT8_C(  8),
                             UINT8_C(191), UINT8_C( 66), UINT8_C( 60), UINT8_C( 24),
                             UINT8_C( 93), UINT8_C(156), UINT8_C( 32), UINT8_C( 27),
                             UINT8_C( 48), UINT8_C(210), UINT8_C(231), UINT8_C( 10)),
      simde_x_mm512_set_epu8(UINT8_C( 68), UINT8_C( 74), UINT8_C(143), UINT8_C(122),
                             UINT8_C(130), UINT8_C( 60), UINT8_C(185), UINT8_C(163),
                             UINT8_C( 34), UINT8_C(148), UINT8_C(178), UINT8_C(145),
                             UINT8_C(160), UINT8_C(186), UINT8_C( 65), UINT8_C(105),
                             UINT8_C( 76), UINT8_C( 80), UINT8_C( 79), UINT8_C(183),
                             UINT8_C(194), UINT8_C(157), UINT8_C(150), UINT8_C(172),
                             UINT8_C(133), UINT8_C( 46), UINT8_C( 21), UINT8_C(160),
                             UINT8_C( 11), UINT8_C(141), UINT8_C(158), UINT8_C(157),
                             UINT8_C(134), UINT8_C(182), UINT8_C(107), UINT8_C(126),
                             UINT8_C(145), UINT8_C(201), UINT8_C(207), UINT8_C(107),
                             UINT8_C(128), UINT8_C(175), UINT8_C(228), UINT8_C(123),
                             UINT8_C( 70), UINT8_C( 99), UINT8_C(186), UINT8_C(131),
                             UINT8_C(125), UINT8_C( 73), UINT8_C( 92), UINT8_C(118),
                             UINT8_C(102), UINT8_C(154), UINT8_C( 77), UINT8_C( 24),
                             UINT8_C( 62), UINT8_C(120), UINT8_C(126), UINT8_C( 52),
                             UINT8_C( 50), UINT8_C(121), UINT8_C(127), UINT8_C( 97)) },
    { simde_x_mm512_set_epu8(UINT8_C(234), UINT8_C(192), UINT8_C(234), UINT8_C(237),
                             UINT8_C(  5), UINT8_C(121), UINT8_C(180), UINT8_C( 23),
                             UINT8_C( 48), UINT8_C(184), UINT8_C(208), UINT8_C(106),
                             UINT8_C( 94), UINT8_C(238), UINT8_C(124), UINT8_C( 15),
                             UINT8_C(123), UINT8_C(203), UINT8_C( 16), UINT8_C( 14),
                             UINT8_C(131), UINT8_C(218), UINT8_C( 99), UINT8_C(178),
                             UINT8_C(217), UINT8_C(189), UINT8_C(211), UINT8_C(222),
                             UINT8_C( 27), UINT8_C( 25), UINT8_C( 55), UINT8_C(187),
                             UINT8_C( 24), UINT8_C(250), UINT8_C( 44), UINT8_C(207),
                             UINT8_C(143), UINT8_C(198), UINT8_C(115), UINT8_C(  4),
                             UINT8_C( 18), UINT8_C( 78), UINT8_C( 97), UINT8_C( 62),
                             UINT8_C( 38), UINT8_C(184), UINT8_C(216), UINT8_C(124),
                             UINT8_C(155), UINT8_C( 45), UINT8_C( 66), UINT8_C( 36),
                             UINT8_C(  7), UINT8_C( 22), UINT8_C(106), UINT8_C( 14),
                             UINT8_C( 55), UINT8_C(  9), UINT8_C(104), UINT8_C(136),
                             UINT8_C(167), UINT8_C(129), UINT8_C(  7), UINT8_C( 98)),
      simde_x_mm512_set_epu8(UINT8_C(  4), UINT8_C( 28), UINT8_C(178), UINT8_C(230),
                             UINT8_C(  8), UINT8_C( 80), UINT8_C(138), UINT8_C(121),
                             UINT8_C(141), UINT8_C(178), UINT8_C(150), UINT8_C( 72),
                             UINT8_C(121), UINT8_C( 20), UINT8_C( 28), UINT8_C(243),
                             UINT8_C(255), UINT8_C(153), UINT8_C( 78), UINT8_C(119),
                             UINT8_C( 23), UINT8_C(182), UINT8_C(133), UINT8_C(168),
                             UINT8_C(148), UINT8_C(129), UINT8_C(203), UINT8_C(206),
                             UINT8_C( 25), UINT8_C(232), UINT8_C( 71), UINT8_C( 92),
                             UINT8_C( 90), UINT8_C(159), UINT8_C(196), UINT8_C( 86),
                             UINT8_C(163), UINT8_C(105), UINT8_C(169), UINT8_C(248),
                             UINT8_C(169), UINT8_C( 85), UINT8_C(177), UINT8_C(146),
                             UINT8_C( 77), UINT8_C( 44), UINT8_C(150), UINT8_C( 64),
                             UINT8_C(145), UINT8_C( 33), UINT8_C(163), UINT8_C(255),
                             UINT8_C( 33), UINT8_C( 86), UINT8_C(  3), UINT8_C(162),
                             UINT8_C(241), UINT8_C(203), UINT8_C( 13), UINT8_C( 95),
                             UINT8_C(247), UINT8_C( 54), UINT8_C( 73), UINT8_C(154)),
      simde_x_mm512_set_epu8(UINT8_C(119), UINT8_C(110), UINT8_C(206), UINT8_C(234),
                             UINT8_C(  7), UINT8_C(101), UINT8_C(159), UINT8_C( 72),
                             UINT8_C( 95), UINT8_C(181), UINT8_C(179), UINT8_C( 89),
                             UINT8_C(108), UINT8_C(129), UINT8_C( 76), UINT8_C(129),
                             UINT8_C(189), UINT8_C(178), UINT8_C( 47), UINT8_C( 67),
                             UINT8_C( 77), UINT8_C(200), UINT8_C(116), UINT8_C(173),
                             UINT8_C(183), UINT8_C(159), UINT8_C(207), UINT8_C(214),
                             UINT8_C( 26), UINT8_C(129), UINT8_C( 63), UINT8_C(140),
                             UINT8_C( 57), UINT8_C(205), UINT8_C(120), UINT8_C(147),
                             UINT8_C(153), UINT8_C(152), UINT8_C(142), UINT8_C(126),
                             UINT8_C( 94), UINT8_C( 82), UINT8_C(137), UINT8_C(104),
                             UINT8_C( 58), UINT8_C(114), UINT8_C(183), UINT8_C( 94),
                             UINT8_C(150), UINT8_C( 39), UINT8_C(115), UINT8_C(146),
                             UINT8_C( 20), UINT8_C( 54), UINT8_C( 55), UINT8_C( 88),
                             UINT8_C(148), UINT8_C(106), UINT8_C( 59), UINT8_C(116),
                             UINT8_C(207), UINT8_C( 92), UINT8_C( 40), UINT8_C(126)) },
    { simde_x_mm512_set_epu8(UINT8_C( 83), UINT8_C(142), UINT8_C( 42), UINT8_C(220),
                             UINT8_C( 37), UINT8_C( 62), UINT8_C( 98), UINT8_C(238),
                             UINT8_C(153), UINT8_C( 28), UINT8_C(206), UINT8_C(122),
                             UINT8_C( 85), UINT8_C(118), UINT8_C(175), UINT8_C(149),
                             UINT8_C(220), UINT8_C( 77), UINT8_C( 29), UINT8_C( 65),
                             UINT8_C(199), UINT8_C(150), UINT8_C( 85), UINT8_C(205),
                             UINT8_C(179), UINT8_C(171), UINT8_C( 47), UINT8_C( 79),
                             UINT8_C(186), UINT8_C(189), UINT8_C(  5), UINT8_C( 88),
                             UINT8_C(186), UINT8_C(241), UINT8_C(203), UINT8_C(126),
                             UINT8_C(116), UINT8_C( 53), UINT8_C( 43), UINT8_C(208),
                             UINT8_C(141), UINT8_C(174), UINT8_C(168), UINT8_C( 33),
                             UINT8_C(144), UINT8_C(236), UINT8_C( 92), UINT8_C(185),
                             UINT8_C(194), UINT8_C( 20), UINT8_C(  6), UINT8_C( 82),
                             UINT8_C( 17), UINT8_C(156), UINT8_C(193), UINT8_C(  6),
                             UINT8_C( 65), UINT8_C( 12), UINT8_C( 82), UINT8_C(186),
                             UINT8_C(  9), UINT8_C( 38), UINT8_C(161), UINT8_C(250)),
      simde_x_mm512_set_epu8(UINT8_C(  7), UINT8_C(237), UINT8_C(219), UINT8_C(171),
                             UINT8_C(236), UINT8_C(104), UINT8_C( 84), UINT8_C(  1),
                             UINT8_C(226), UINT8_C( 80), UINT8_C( 28), UINT8_C(225),
                             UINT8_C(190), UINT8_C(201), UINT8_C(130), UINT8_C(143),
                             UINT8_C( 85), UINT8_C(214), UINT8_C(162), UINT8_C(248),
                             UINT8_C(236), UINT8_C(124), UINT8_C(162), UINT8_C(253),
                             UINT8_C(116), UINT8_C(105), UINT8_C(252), UINT8_C(254),
                             UINT8_C( 40), UINT8_C( 36), UINT8_C( 40), UINT8_C(179),
                             UINT8_C(113), UINT8_C(185), UINT8_C( 37), UINT8_C(245),
                             UINT8_C( 41), UINT8_C(  6), UINT8_C(210), UINT8_C( 50),
                             UINT8_C( 82), UINT8_C(223), UINT8_C(202), UINT8_C( 34),
                             UINT8_C(124), UINT8_C( 12), UINT8_C(156), UINT8_C(107),
                             UINT8_C( 75), UINT8_C(221), UINT8_C(108), UINT8_C(193),
                             UINT8_C(  4), UINT8_C(112), UINT8_C(113), UINT8_C(115),
                             UINT8_C(250), UINT8_C( 35), UINT8_C(161), UINT8_C( 10),
                             UINT8_C(151), UINT8_C(213), UINT8_C(128), UINT8_C(  1)),
      simde_x_mm512_set_epu8(UINT8_C( 45), UINT8_C(190), UINT8_C(131), UINT8_C(196),
                             UINT8_C(137), UINT8_C( 83), UINT8_C( 91), UINT8_C(120),
                             UINT8_C(190), UINT8_C( 54), UINT8_C(117), UINT8_C(174),
                             UINT8_C(138), UINT8_C(160), UINT8_C(153), UINT8_C(146),
                             UINT8_C(153), UINT8_C(146), UINT8_C( 96), UINT8_C(157),
                             UINT8_C(218), UINT8_C(137), UINT8_C(124), UINT8_C(229),
                             UINT8_C(148), UINT8_C(138), UINT8_C(150), UINT8_C(167),
                             UINT8_C(113), UINT8_C(113), UINT8_C( 23), UINT8_C(134),
                             UINT8_C(150), UINT8_C(213), UINT8_C(120), UINT8_C(186),
                             UINT8_C( 79), UINT8_C( 30), UINT8_C(127), UINT8_C(129),
                             UINT8_C(112), UINT8_C(199), UINT8_C(185), UINT8_C( 34),
                             UINT8_C(134), UINT8_C(124), UINT8_C(124), UINT8_C(146),
                             UINT8_C(135), UINT8_C(121), UINT8_C( 57), UINT8_C(138),
                             UINT8_C( 11), UINT8_C(134), UINT8_C(153), UINT8_C( 61),
                             UINT8_C(158), UINT8_C( 24), UINT8_C(122), UINT8_C( 98),
                             UINT8_C( 80), UINT8_C(126), UINT8_C(145), UINT8_C(126)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_avg_epu8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_avg_epu8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C(117), UINT8_C(152), UINT8_C(221), UINT8_C(216),
                             UINT8_C(255), UINT8_C( 43), UINT8_C( 10), UINT8_C(211),
                             UINT8_C(214), UINT8_C( 80), UINT8_C(187), UINT8_C(241),
                             UINT8_C(242), UINT8_C(134), UINT8_C( 60), UINT8_C( 93),
                             UINT8_C( 23), UINT8_C(122), UINT8_C( 10), UINT8_C(108),
                             UINT8_C(232), UINT8_C(191), UINT8_C(217), UINT8_C(158),
                             UINT8_C(199), UINT8_C(250), UINT8_C( 81), UINT8_C(211),
                             UINT8_C(229), UINT8_C( 28), UINT8_C(171), UINT8_C( 15),
                             UINT8_C(138), UINT8_C( 52), UINT8_C( 10), UINT8_C(140),
                             UINT8_C( 26), UINT8_C(213), UINT8_C(218), UINT8_C(229),
                             UINT8_C( 66), UINT8_C(204), UINT8_C(  5), UINT8_C(255),
                             UINT8_C(228), UINT8_C(  3), UINT8_C(123), UINT8_C(140),
                             UINT8_C(222), UINT8_C(224), UINT8_C( 98), UINT8_C(103),
                             UINT8_C(237), UINT8_C(138), UINT8_C(179), UINT8_C(224),
                             UINT8_C( 60), UINT8_C(176), UINT8_C( 22), UINT8_C(230),
                             UINT8_C( 60), UINT8_C(244), UINT8_C(191), UINT8_C( 88)),
      UINT64_C(          2117573942),
      simde_x_mm512_set_epu8(UINT8_C( 32), UINT8_C( 22), UINT8_C( 88), UINT8_C(222),
                             UINT8_C( 12), UINT8_C( 90), UINT8_C(155), UINT8_C(252),
                             UINT8_C(242), UINT8_C( 42), UINT8_C(169), UINT8_C(105),
                             UINT8_C( 22), UINT8_C( 34), UINT8_C(113), UINT8_C(184),
                             UINT8_C(216), UINT8_C(186), UINT8_C(232), UINT8_C(159),
                             UINT8_C(188), UINT8_C(250), UINT8_C( 98), UINT8_C(132),
                             UINT8_C(221), UINT8_C( 11), UINT8_C(138), UINT8_C(207),
                             UINT8_C(214), UINT8_C( 24), UINT8_C(222), UINT8_C( 73),
                             UINT8_C(253), UINT8_C(184), UINT8_C(153), UINT8_C( 26),
                             UINT8_C(220), UINT8_C(147), UINT8_C( 37), UINT8_C( 50),
                             UINT8_C( 26), UINT8_C( 78), UINT8_C( 33), UINT8_C( 67),
                             UINT8_C(248), UINT8_C(190), UINT8_C( 29), UINT8_C( 31),
                             UINT8_C( 34), UINT8_C( 40), UINT8_C(189), UINT8_C( 86),
                             UINT8_C( 38), UINT8_C(128), UINT8_C(150), UINT8_C(241),
                             UINT8_C(100), UINT8_C( 53), UINT8_C( 42), UINT8_C( 55),
                             UINT8_C( 87), UINT8_C(241), UINT8_C(251), UINT8_C(171)),
      simde_x_mm512_set_epu8(UINT8_C(229), UINT8_C(148), UINT8_C(139), UINT8_C(168),
                             UINT8_C(149), UINT8_C( 53), UINT8_C(240), UINT8_C(255),
                             UINT8_C(164), UINT8_C(137), UINT8_C( 17), UINT8_C(134),
                             UINT8_C( 22), UINT8_C(243), UINT8_C(  7), UINT8_C(130),
                             UINT8_C(232), UINT8_C(205), UINT8_C(227), UINT8_C(142),
                             UINT8_C(100), UINT8_C(203), UINT8_C(  0), UINT8_C(144),
                             UINT8_C(176), UINT8_C( 89), UINT8_C( 91), UINT8_C(  1),
                             UINT8_C(102), UINT8_C(254), UINT8_C(189), UINT8_C(168),
                             UINT8_C(251), UINT8_C(171), UINT8_C( 24), UINT8_C( 13),
                             UINT8_C( 67), UINT8_C( 49), UINT8_C( 20), UINT8_C(185),
                             UINT8_C(232), UINT8_C( 19), UINT8_C(238), UINT8_C( 58),
                             UINT8_C(109), UINT8_C(140), UINT8_C( 95), UINT8_C( 71),
                             UINT8_C( 47), UINT8_C(118), UINT8_C(241), UINT8_C(225),
                             UINT8_C(186), UINT8_C(175), UINT8_C( 45), UINT8_C( 88),
                             UINT8_C(164), UINT8_C( 95), UINT8_C(253), UINT8_C(227),
                             UINT8_C( 20), UINT8_C(170), UINT8_C(251), UINT8_C( 57)),
      simde_x_mm512_set_epu8(UINT8_C(117), UINT8_C(152), UINT8_C(221), UINT8_C(216),
                             UINT8_C(255), UINT8_C( 43), UINT8_C( 10), UINT8_C(211),
                             UINT8_C(214), UINT8_C( 80), UINT8_C(187), UINT8_C(241),
                             UINT8_C(242), UINT8_C(134), UINT8_C( 60), UINT8_C( 93),
                             UINT8_C( 23), UINT8_C(122), UINT8_C( 10), UINT8_C(108),
                             UINT8_C(232), UINT8_C(191), UINT8_C(217), UINT8_C(158),
                             UINT8_C(199), UINT8_C(250), UINT8_C( 81), UINT8_C(211),
                             UINT8_C(229), UINT8_C( 28), UINT8_C(171), UINT8_C( 15),
                             UINT8_C(138), UINT8_C(178), UINT8_C( 89), UINT8_C( 20),
                             UINT8_C(144), UINT8_C( 98), UINT8_C( 29), UINT8_C(229),
                             UINT8_C( 66), UINT8_C(204), UINT8_C(136), UINT8_C( 63),
                             UINT8_C(228), UINT8_C(165), UINT8_C( 62), UINT8_C( 51),
                             UINT8_C( 41), UINT8_C(224), UINT8_C( 98), UINT8_C(156),
                             UINT8_C(112), UINT8_C(152), UINT8_C(179), UINT8_C(165),
                             UINT8_C( 60), UINT8_C(176), UINT8_C(148), UINT8_C(141),
                             UINT8_C( 60), UINT8_C(206), UINT8_C(251), UINT8_C( 88)) },
    { simde_x_mm512_set_epu8(UINT8_C(248), UINT8_C(153), UINT8_C(124), UINT8_C(192),
                             UINT8_C(251), UINT8_C( 73), UINT8_C( 83), UINT8_C(149),
                             UINT8_C(192), UINT8_C(225), UINT8_C( 11), UINT8_C( 45),
                             UINT8_C(242), UINT8_C(146), UINT8_C(100), UINT8_C(250),
                             UINT8_C(206), UINT8_C(133), UINT8_C(162), UINT8_C( 12),
                             UINT8_C(227), UINT8_C(156), UINT8_C( 97), UINT8_C(141),
                             UINT8_C(103), UINT8_C(177), UINT8_C(102), UINT8_C(250),
                             UINT8_C(236), UINT8_C(151), UINT8_C(250), UINT8_C( 69),
                             UINT8_C( 19), UINT8_C(102), UINT8_C(130), UINT8_C(239),
                             UINT8_C( 26), UINT8_C(151), UINT8_C( 91), UINT8_C(218),
                             UINT8_C(106), UINT8_C(  8), UINT8_C( 85), UINT8_C(190),
                             UINT8_C( 40), UINT8_C(207), UINT8_C( 10), UINT8_C( 15),
                             UINT8_C( 30), UINT8_C( 97), UINT8_C(208), UINT8_C( 26),
                             UINT8_C( 77), UINT8_C(104), UINT8_C(138), UINT8_C( 49),
                             UINT8_C(222), UINT8_C(133), UINT8_C( 22), UINT8_C(114),
                             UINT8_C(226), UINT8_C( 75), UINT8_C(  2), UINT8_C(236)),
      UINT64_C(           474091127),
      simde_x_mm512_set_epu8(UINT8_C( 64), UINT8_C( 45), UINT8_C(186), UINT8_C( 94),
                             UINT8_C(127), UINT8_C(186), UINT8_C(127), UINT8_C(178),
                             UINT8_C(198), UINT8_C( 92), UINT8_C(231), UINT8_C(248),
                             UINT8_C( 21), UINT8_C( 89), UINT8_C(  8), UINT8_C(  1),
                             UINT8_C( 85), UINT8_C(  5), UINT8_C(111), UINT8_C(109),
                             UINT8_C(  6), UINT8_C(229), UINT8_C( 18), UINT8_C( 62),
                             UINT8_C(249), UINT8_C(126), UINT8_C(234), UINT8_C(220),
                             UINT8_C(246), UINT8_C(255), UINT8_C(  1), UINT8_C(115),
                             UINT8_C( 87), UINT8_C( 93), UINT8_C(185), UINT8_C(156),
                             UINT8_C(164), UINT8_C(103), UINT8_C(237), UINT8_C(252),
                             UINT8_C(126), UINT8_C(112), UINT8_C(184), UINT8_C( 45),
                             UINT8_C( 61), UINT8_C(246), UINT8_C( 68), UINT8_C(163),
                             UINT8_C(  5), UINT8_C(127), UINT8_C(109), UINT8_C(194),
                             UINT8_C(167), UINT8_C(139), UINT8_C(130), UINT8_C( 52),
                             UINT8_C(248), UINT8_C(164), UINT8_C(233), UINT8_C(208),
                             UINT8_C(104), UINT8_C(136), UINT8_C(254), UINT8_C(148)),
      simde_x_mm512_set_epu8(UINT8_C( 10), UINT8_C(152), UINT8_C(249), UINT8_C(150),
                             UINT8_C(250), UINT8_C(  9), UINT8_C(168), UINT8_C( 52),
                             UINT8_C( 69), UINT8_C( 91), UINT8_C(134), UINT8_C( 83),
                             UINT8_C( 54), UINT8_C(214), UINT8_C(  9), UINT8_C(100),
                             UINT8_C( 84), UINT8_C( 66), UINT8_C( 99), UINT8_C(199),
                             UINT8_C( 20), UINT8_C(200), UINT8_C(215), UINT8_C( 34),
                             UINT8_C( 96), UINT8_C(125), UINT8_C( 40), UINT8_C(246),
                             UINT8_C( 37), UINT8_C(202), UINT8_C(215), UINT8_C(111),
                             UINT8_C(239), UINT8_C( 73), UINT8_C( 10), UINT8_C( 78),
                             UINT8_C(192), UINT8_C( 57), UINT8_C( 95), UINT8_C( 52),
                             UINT8_C(133), UINT8_C(102), UINT8_C(165), UINT8_C(231),
                             UINT8_C(182), UINT8_C( 23), UINT8_C(129), UINT8_C(213),
                             UINT8_C(123), UINT8_C(235), UINT8_C(187), UINT8_C( 72),
                             UINT8_C(170), UINT8_C( 39), UINT8_C(204), UINT8_C( 88),
                             UINT8_C( 48), UINT8_C( 73), UINT8_C(134), UINT8_C( 45),
                             UINT8_C(127), UINT8_C( 12), UINT8_C( 19), UINT8_C(132)),
      simde_x_mm512_set_epu8(UINT8_C(248), UINT8_C(153), UINT8_C(124), UINT8_C(192),
                             UINT8_C(251), UINT8_C( 73), UINT8_C( 83), UINT8_C(149),
                             UINT8_C(192), UINT8_C(225), UINT8_C( 11), UINT8_C( 45),
                             UINT8_C(242), UINT8_C(146), UINT8_C(100), UINT8_C(250),
                             UINT8_C(206), UINT8_C(133), UINT8_C(162), UINT8_C( 12),
                             UINT8_C(227), UINT8_C(156), UINT8_C( 97), UINT8_C(141),
                             UINT8_C(103), UINT8_C(177), UINT8_C(102), UINT8_C(250),
                             UINT8_C(236), UINT8_C(151), UINT8_C(250), UINT8_C( 69),
                             UINT8_C( 19), UINT8_C(102), UINT8_C(130), UINT8_C(117),
                             UINT8_C(178), UINT8_C( 80), UINT8_C( 91), UINT8_C(218),
                             UINT8_C(106), UINT8_C(107), UINT8_C( 85), UINT8_C(190),
                             UINT8_C( 40), UINT8_C(207), UINT8_C( 99), UINT8_C( 15),
                             UINT8_C( 30), UINT8_C( 97), UINT8_C(208), UINT8_C( 26),
                             UINT8_C(169), UINT8_C( 89), UINT8_C(167), UINT8_C( 49),
                             UINT8_C(222), UINT8_C(119), UINT8_C(184), UINT8_C(127),
                             UINT8_C(226), UINT8_C( 74), UINT8_C(137), UINT8_C(140)) },
    { simde_x_mm512_set_epu8(UINT8_C(221), UINT8_C(100), UINT8_C(182), UINT8_C(149),
                             UINT8_C( 44), UINT8_C(198), UINT8_C( 20), UINT8_C( 23),
                             UINT8_C(105), UINT8_C(188), UINT8_C(118), UINT8_C(243),
                             UINT8_C(175), UINT8_C( 41), UINT8_C(183), UINT8_C(141),
                             UINT8_C(145), UINT8_C( 21), UINT8_C( 99), UINT8_C(117),
                             UINT8_C(242), UINT8_C(144), UINT8_C( 71), UINT8_C( 21),
                             UINT8_C(142), UINT8_C(181), UINT8_C( 66), UINT8_C(137),
                             UINT8_C(194), UINT8_C(226), UINT8_C( 86), UINT8_C(128),
                             UINT8_C(109), UINT8_C( 15), UINT8_C(187), UINT8_C( 22),
                             UINT8_C(243), UINT8_C( 38), UINT8_C(163), UINT8_C(215),
                             UINT8_C( 96), UINT8_C( 79), UINT8_C(232), UINT8_C(216),
                             UINT8_C( 90), UINT8_C( 31), UINT8_C(221), UINT8_C( 22),
                             UINT8_C(144), UINT8_C(219), UINT8_C( 29), UINT8_C( 29),
                             UINT8_C(  7), UINT8_C(  8), UINT8_C(106), UINT8_C(210),
                             UINT8_C( 85), UINT8_C(118), UINT8_C(120), UINT8_C(208),
                             UINT8_C(112), UINT8_C( 80), UINT8_C(173), UINT8_C( 55)),
      UINT64_C(            66155005),
      simde_x_mm512_set_epu8(UINT8_C( 90), UINT8_C(190), UINT8_C(204), UINT8_C( 44),
                             UINT8_C(145), UINT8_C( 10), UINT8_C(145), UINT8_C( 20),
                             UINT8_C(245), UINT8_C(128), UINT8_C(239), UINT8_C(216),
                             UINT8_C(215), UINT8_C(  0), UINT8_C(241), UINT8_C(105),
                             UINT8_C( 81), UINT8_C(  3), UINT8_C( 23), UINT8_C(107),
                             UINT8_C(238), UINT8_C( 80), UINT8_C(150), UINT8_C( 52),
                             UINT8_C( 80), UINT8_C(120), UINT8_C( 83), UINT8_C(139),
                             UINT8_C( 84), UINT8_C(178), UINT8_C( 47), UINT8_C(223),
                             UINT8_C(103), UINT8_C( 66), UINT8_C( 79), UINT8_C( 53),
                             UINT8_C(211), UINT8_C( 20), UINT8_C(111), UINT8_C(197),
                             UINT8_C(238), UINT8_C( 30), UINT8_C( 70), UINT8_C(231),
                             UINT8_C(199), UINT8_C( 18), UINT8_C(252), UINT8_C(101),
                             UINT8_C( 75), UINT8_C( 12), UINT8_C( 85), UINT8_C( 93),
                             UINT8_C(177), UINT8_C(243), UINT8_C( 43), UINT8_C( 45),
                             UINT8_C( 40), UINT8_C(175), UINT8_C( 99), UINT8_C(172),
                             UINT8_C(  7), UINT8_C(156), UINT8_C(188), UINT8_C(130)),
      simde_x_mm512_set_epu8(UINT8_C( 42), UINT8_C( 32), UINT8_C(165), UINT8_C(130),
                             UINT8_C(119), UINT8_C( 88), UINT8_C(110), UINT8_C( 93),
                             UINT8_C( 75), UINT8_C(207), UINT8_C(193), UINT8_C(214),
                             UINT8_C( 54), UINT8_C(185), UINT8_C( 87), UINT8_C(255),
                             UINT8_C(231), UINT8_C(196), UINT8_C(102), UINT8_C(158),
                             UINT8_C(161), UINT8_C(222), UINT8_C(210), UINT8_C( 94),
                             UINT8_C(118), UINT8_C(127), UINT8_C(194), UINT8_C(186),
                             UINT8_C( 80), UINT8_C(125), UINT8_C(244), UINT8_C( 33),
                             UINT8_C(110), UINT8_C(247), UINT8_C(227), UINT8_C(141),
                             UINT8_C(139), UINT8_C( 52), UINT8_C(130), UINT8_C(241),
                             UINT8_C(138), UINT8_C(133), UINT8_C(240), UINT8_C( 72),
                             UINT8_C( 84), UINT8_C( 54), UINT8_C( 76), UINT8_C(208),
                             UINT8_C(177), UINT8_C(100), UINT8_C(198), UINT8_C( 30),
                             UINT8_C( 35), UINT8_C( 68), UINT8_C(216), UINT8_C(  8),
                             UINT8_C( 68), UINT8_C(120), UINT8_C(187), UINT8_C(206),
                             UINT8_C(102), UINT8_C(133), UINT8_C( 95), UINT8_C(110)),
      simde_x_mm512_set_epu8(UINT8_C(221), UINT8_C(100), UINT8_C(182), UINT8_C(149),
                             UINT8_C( 44), UINT8_C(198), UINT8_C( 20), UINT8_C( 23),
                             UINT8_C(105), UINT8_C(188), UINT8_C(118), UINT8_C(243),
                             UINT8_C(175), UINT8_C( 41), UINT8_C(183), UINT8_C(141),
                             UINT8_C(145), UINT8_C( 21), UINT8_C( 99), UINT8_C(117),
                             UINT8_C(242), UINT8_C(144), UINT8_C( 71), UINT8_C( 21),
                             UINT8_C(142), UINT8_C(181), UINT8_C( 66), UINT8_C(137),
                             UINT8_C(194), UINT8_C(226), UINT8_C( 86), UINT8_C(128),
                             UINT8_C(109), UINT8_C( 15), UINT8_C(187), UINT8_C( 22),
                             UINT8_C(243), UINT8_C( 38), UINT8_C(121), UINT8_C(219),
                             UINT8_C(188), UINT8_C( 82), UINT8_C(155), UINT8_C(152),
                             UINT8_C( 90), UINT8_C( 31), UINT8_C(221), UINT8_C(155),
                             UINT8_C(144), UINT8_C( 56), UINT8_C(142), UINT8_C( 62),
                             UINT8_C(  7), UINT8_C(  8), UINT8_C(106), UINT8_C( 27),
                             UINT8_C( 54), UINT8_C(148), UINT8_C(143), UINT8_C(189),
                             UINT8_C( 55), UINT8_C(145), UINT8_C(173), UINT8_C(120)) },
    { simde_x_mm512_set_epu8(UINT8_C(197), UINT8_C(175), UINT8_C(198), UINT8_C( 71),
                             UINT8_C(137), UINT8_C(191), UINT8_C(178), UINT8_C(155),
                             UINT8_C(242), UINT8_C(  4), UINT8_C(232), UINT8_C(161),
                             UINT8_C(106), UINT8_C( 31), UINT8_C(104), UINT8_C( 20),
                             UINT8_C( 65), UINT8_C(248), UINT8_C(181), UINT8_C(128),
                             UINT8_C(175), UINT8_C( 68), UINT8_C(170), UINT8_C( 98),
                             UINT8_C(201), UINT8_C( 10), UINT8_C( 75), UINT8_C( 51),
                             UINT8_C(199), UINT8_C(145), UINT8_C( 87), UINT8_C( 47),
                             UINT8_C(235), UINT8_C(105), UINT8_C( 17), UINT8_C(107),
                             UINT8_C(137), UINT8_C(238), UINT8_C(133), UINT8_C( 81),
                             UINT8_C( 54), UINT8_C(134), UINT8_C(173), UINT8_C( 81),
                             UINT8_C( 21), UINT8_C( 13), UINT8_C(  6), UINT8_C(200),
                             UINT8_C(140), UINT8_C(177), UINT8_C(141), UINT8_C( 81),
                             UINT8_C( 31), UINT8_C( 29), UINT8_C(140), UINT8_C(138),
                             UINT8_C(175), UINT8_C( 98), UINT8_C( 23), UINT8_C(148),
                             UINT8_C(130), UINT8_C( 95), UINT8_C(212), UINT8_C(200)),
      UINT64_C(           518008675),
      simde_x_mm512_set_epu8(UINT8_C(155), UINT8_C(133), UINT8_C( 64), UINT8_C(186),
                             UINT8_C(210), UINT8_C(255), UINT8_C( 70), UINT8_C(210),
                             UINT8_C( 96), UINT8_C( 45), UINT8_C( 57), UINT8_C(248),
                             UINT8_C( 23), UINT8_C( 34), UINT8_C(240), UINT8_C(208),
                             UINT8_C( 74), UINT8_C( 85), UINT8_C(150), UINT8_C( 98),
                             UINT8_C( 81), UINT8_C(149), UINT8_C(213), UINT8_C( 64),
                             UINT8_C(146), UINT8_C(124), UINT8_C(134), UINT8_C(133),
                             UINT8_C( 20), UINT8_C(122), UINT8_C( 57), UINT8_C(241),
                             UINT8_C( 58), UINT8_C( 90), UINT8_C(153), UINT8_C( 57),
                             UINT8_C( 51), UINT8_C(138), UINT8_C( 37), UINT8_C(177),
                             UINT8_C( 13), UINT8_C(116), UINT8_C(177), UINT8_C(238),
                             UINT8_C(169), UINT8_C(177), UINT8_C(173), UINT8_C(231),
                             UINT8_C(226), UINT8_C(216), UINT8_C(126), UINT8_C( 80),
                             UINT8_C(182), UINT8_C( 71), UINT8_C(188), UINT8_C( 53),
                             UINT8_C(255), UINT8_C(200), UINT8_C(176), UINT8_C( 17),
                             UINT8_C(127), UINT8_C( 83), UINT8_C(247), UINT8_C(  0)),
      simde_x_mm512_set_epu8(UINT8_C(226), UINT8_C(  1), UINT8_C(238), UINT8_C(252),
                             UINT8_C( 39), UINT8_C( 85), UINT8_C( 69), UINT8_C( 68),
                             UINT8_C(143), UINT8_C(218), UINT8_C( 28), UINT8_C( 83),
                             UINT8_C(225), UINT8_C( 61), UINT8_C( 37), UINT8_C( 67),
                             UINT8_C( 46), UINT8_C(213), UINT8_C( 32), UINT8_C(183),
                             UINT8_C(230), UINT8_C(  2), UINT8_C(250), UINT8_C(122),
                             UINT8_C(205), UINT8_C(118), UINT8_C(  3), UINT8_C( 17),
                             UINT8_C( 32), UINT8_C( 82), UINT8_C( 40), UINT8_C(  0),
                             UINT8_C( 28), UINT8_C( 37), UINT8_C(253), UINT8_C(171),
                             UINT8_C(164), UINT8_C( 45), UINT8_C(233), UINT8_C(198),
                             UINT8_C(148), UINT8_C( 44), UINT8_C( 28), UINT8_C( 77),
                             UINT8_C( 12), UINT8_C( 81), UINT8_C(153), UINT8_C(  7),
                             UINT8_C(234), UINT8_C( 32), UINT8_C(228), UINT8_C(142),
                             UINT8_C(168), UINT8_C( 42), UINT8_C( 92), UINT8_C( 70),
                             UINT8_C(144), UINT8_C(203), UINT8_C(149), UINT8_C( 41),
                             UINT8_C(206), UINT8_C(198), UINT8_C( 56), UINT8_C( 54)),
      simde_x_mm512_set_epu8(UINT8_C(197), UINT8_C(175), UINT8_C(198), UINT8_C( 71),
                             UINT8_C(137), UINT8_C(191), UINT8_C(178), UINT8_C(155),
                             UINT8_C(242), UINT8_C(  4), UINT8_C(232), UINT8_C(161),
                             UINT8_C(106), UINT8_C( 31), UINT8_C(104), UINT8_C( 20),
                             UINT8_C( 65), UINT8_C(248), UINT8_C(181), UINT8_C(128),
                             UINT8_C(175), UINT8_C( 68), UINT8_C(170), UINT8_C( 98),
                             UINT8_C(201), UINT8_C( 10), UINT8_C( 75), UINT8_C( 51),
                             UINT8_C(199), UINT8_C(145), UINT8_C( 87), UINT8_C( 47),
                             UINT8_C(235), UINT8_C(105), UINT8_C( 17), UINT8_C(114),
                             UINT8_C(108), UINT8_C( 92), UINT8_C(135), UINT8_C( 81),
                             UINT8_C( 81), UINT8_C( 80), UINT8_C(103), UINT8_C( 81),
                             UINT8_C( 21), UINT8_C( 13), UINT8_C(  6), UINT8_C(200),
                             UINT8_C(140), UINT8_C(177), UINT8_C(177), UINT8_C( 81),
                             UINT8_C(175), UINT8_C( 57), UINT8_C(140), UINT8_C( 62),
                             UINT8_C(175), UINT8_C(202), UINT8_C(163), UINT8_C(148),
                             UINT8_C(130), UINT8_C( 95), UINT8_C(152), UINT8_C( 27)) },
    { simde_x_mm512_set_epu8(UINT8_C(121), UINT8_C(  9), UINT8_C(193), UINT8_C(106),
                             UINT8_C( 93), UINT8_C( 44), UINT8_C(  0), UINT8_C(223),
                             UINT8_C(203), UINT8_C(101), UINT8_C( 76), UINT8_C( 37),
                             UINT8_C( 94), UINT8_C(224), UINT8_C(152), UINT8_C(236),
                             UINT8_C(208), UINT8_C( 45), UINT8_C( 88), UINT8_C(163),
                             UINT8_C(104), UINT8_C( 42), UINT8_C(157), UINT8_C( 59),
                             UINT8_C( 90), UINT8_C(187), UINT8_C(107), UINT8_C( 16),
                             UINT8_C(138), UINT8_C(137), UINT8_C(196), UINT8_C( 51),
                             UINT8_C(126), UINT8_C(178), UINT8_C(114), UINT8_C(181),
                             UINT8_C(181), UINT8_C( 19), UINT8_C(113), UINT8_C( 84),
                             UINT8_C( 47), UINT8_C(173), UINT8_C(230), UINT8_C(218),
                             UINT8_C( 64), UINT8_C(150), UINT8_C(107), UINT8_C( 56),
                             UINT8_C(130), UINT8_C(248), UINT8_C( 35), UINT8_C(112),
                             UINT8_C(178), UINT8_C( 75), UINT8_C(231), UINT8_C(  1),
                             UINT8_C(229), UINT8_C(189), UINT8_C( 49), UINT8_C( 75),
                             UINT8_C(217), UINT8_C(188), UINT8_C(205), UINT8_C( 42)),
      UINT64_C(          4020943947),
      simde_x_mm512_set_epu8(UINT8_C(244), UINT8_C(209), UINT8_C(117), UINT8_C( 40),
                             UINT8_C( 42), UINT8_C( 16), UINT8_C(230), UINT8_C(122),
                             UINT8_C(122), UINT8_C(219), UINT8_C(158), UINT8_C(236),
                             UINT8_C( 86), UINT8_C(169), UINT8_C(166), UINT8_C(144),
                             UINT8_C(141), UINT8_C( 79), UINT8_C(123), UINT8_C( 33),
                             UINT8_C(201), UINT8_C(131), UINT8_C(102), UINT8_C( 59),
                             UINT8_C(199), UINT8_C( 19), UINT8_C(252), UINT8_C(201),
                             UINT8_C(170), UINT8_C( 88), UINT8_C(209), UINT8_C( 29),
                             UINT8_C(140), UINT8_C(198), UINT8_C(115), UINT8_C(193),
                             UINT8_C(241), UINT8_C(202), UINT8_C( 84), UINT8_C(255),
                             UINT8_C(  5), UINT8_C(223), UINT8_C(160), UINT8_C( 93),
                             UINT8_C( 97), UINT8_C(124), UINT8_C( 26), UINT8_C(222),
                             UINT8_C(175), UINT8_C(168), UINT8_C( 26), UINT8_C(155),
                             UINT8_C(117), UINT8_C(221), UINT8_C(174), UINT8_C( 92),
                             UINT8_C(115), UINT8_C(243), UINT8_C(104), UINT8_C( 83),
                             UINT8_C( 80), UINT8_C(138), UINT8_C( 34), UINT8_C( 48)),
      simde_x_mm512_set_epu8(UINT8_C(168), UINT8_C(187), UINT8_C(118), UINT8_C( 36),
                             UINT8_C(110), UINT8_C( 81), UINT8_C(219), UINT8_C( 36),
                             UINT8_C(182), UINT8_C(147), UINT8_C( 47), UINT8_C( 12),
                             UINT8_C(227), UINT8_C(175), UINT8_C( 76), UINT8_C(234),
                             UINT8_C( 91), UINT8_C(125), UINT8_C( 98), UINT8_C( 17),
                             UINT8_C(115), UINT8_C( 58), UINT8_C(149), UINT8_C( 90),
                             UINT8_C(115), UINT8_C(232), UINT8_C( 83), UINT8_C( 17),
                             UINT8_C(245), UINT8_C( 20), UINT8_C( 81), UINT8_C( 54),
                             UINT8_C(197), UINT8_C(112), UINT8_C(154), UINT8_C( 13),
                             UINT8_C(  8), UINT8_C(151), UINT8_C(229), UINT8_C(129),
                             UINT8_C(144), UINT8_C(125), UINT8_C( 21), UINT8_C( 55),
                             UINT8_C( 24), UINT8_C( 58), UINT8_C(  7), UINT8_C(127),
                             UINT8_C(150), UINT8_C(222), UINT8_C(105), UINT8_C(207),
                             UINT8_C(223), UINT8_C(121), UINT8_C(  0), UINT8_C(127),
                             UINT8_C(191), UINT8_C(166), UINT8_C(133), UINT8_C(112),
                             UINT8_C(199), UINT8_C( 77), UINT8_C( 42), UINT8_C( 34)),
      simde_x_mm512_set_epu8(UINT8_C(121), UINT8_C(  9), UINT8_C(193), UINT8_C(106),
                             UINT8_C( 93), UINT8_C( 44), UINT8_C(  0), UINT8_C(223),
                             UINT8_C(203), UINT8_C(101), UINT8_C( 76), UINT8_C( 37),
                             UINT8_C( 94), UINT8_C(224), UINT8_C(152), UINT8_C(236),
                             UINT8_C(208), UINT8_C( 45), UINT8_C( 88), UINT8_C(163),
                             UINT8_C(104), UINT8_C( 42), UINT8_C(157), UINT8_C( 59),
                             UINT8_C( 90), UINT8_C(187), UINT8_C(107), UINT8_C( 16),
                             UINT8_C(138), UINT8_C(137), UINT8_C(196), UINT8_C( 51),
                             UINT8_C(169), UINT8_C(155), UINT8_C(135), UINT8_C(181),
                             UINT8_C(125), UINT8_C(177), UINT8_C(157), UINT8_C(192),
                             UINT8_C( 75), UINT8_C(173), UINT8_C( 91), UINT8_C(218),
                             UINT8_C( 61), UINT8_C(150), UINT8_C( 17), UINT8_C( 56),
                             UINT8_C(163), UINT8_C(248), UINT8_C( 66), UINT8_C(181),
                             UINT8_C(170), UINT8_C(171), UINT8_C(231), UINT8_C(  1),
                             UINT8_C(229), UINT8_C(205), UINT8_C( 49), UINT8_C( 75),
                             UINT8_C(140), UINT8_C(188), UINT8_C( 38), UINT8_C( 41)) },
    { simde_x_mm512_set_epu8(UINT8_C( 84), UINT8_C(222), UINT8_C( 36), UINT8_C(132),
                             UINT8_C( 32), UINT8_C(182), UINT8_C( 73), UINT8_C(182),
                             UINT8_C( 77), UINT8_C(116), UINT8_C( 50), UINT8_C( 82),
                             UINT8_C( 68), UINT8_C( 72), UINT8_C( 23), UINT8_C( 32),
                             UINT8_C(202), UINT8_C( 82), UINT8_C( 53), UINT8_C( 71),
                             UINT8_C( 22), UINT8_C( 92), UINT8_C( 42), UINT8_C(133),
                             UINT8_C(215), UINT8_C( 34), UINT8_C( 75), UINT8_C( 63),
                             UINT8_C(139), UINT8_C( 23), UINT8_C(141), UINT8_C( 66),
                             UINT8_C(166), UINT8_C( 99), UINT8_C(183), UINT8_C(237),
                             UINT8_C(213), UINT8_C(192), UINT8_C(235), UINT8_C( 20),
                             UINT8_C(108), UINT8_C(253), UINT8_C(147), UINT8_C(214),
                             UINT8_C( 44), UINT8_C(210), UINT8_C( 20), UINT8_C( 90),
                             UINT8_C(  2), UINT8_C(252), UINT8_C(108), UINT8_C( 27),
                             UINT8_C(207), UINT8_C( 69), UINT8_C(172), UINT8_C( 82),
                             UINT8_C(  9), UINT8_C(  0), UINT8_C( 42), UINT8_C(118),
                             UINT8_C(253), UINT8_C(189), UINT8_C(  6), UINT8_C( 30)),
      UINT64_C(           589511266),
      simde_x_mm512_set_epu8(UINT8_C(159), UINT8_C(199), UINT8_C( 92), UINT8_C(122),
                             UINT8_C( 12), UINT8_C(  6), UINT8_C( 73), UINT8_C(222),
                             UINT8_C( 93), UINT8_C(236), UINT8_C(196), UINT8_C(151),
                             UINT8_C( 37), UINT8_C(206), UINT8_C(135), UINT8_C(234),
                             UINT8_C(134), UINT8_C( 99), UINT8_C(198), UINT8_C( 81),
                             UINT8_C( 12), UINT8_C(102), UINT8_C(195), UINT8_C(222),
                             UINT8_C( 31), UINT8_C( 64), UINT8_C( 80), UINT8_C( 65),
                             UINT8_C(110), UINT8_C(185), UINT8_C(  8), UINT8_C( 98),
                             UINT8_C(113), UINT8_C( 81), UINT8_C(193), UINT8_C(220),
                             UINT8_C(195), UINT8_C(204), UINT8_C(  7), UINT8_C(184),
                             UINT8_C(203), UINT8_C(  3), UINT8_C(246), UINT8_C(115),
                             UINT8_C(106), UINT8_C(122), UINT8_C( 85), UINT8_C(105),
                             UINT8_C( 90), UINT8_C( 75), UINT8_C(186), UINT8_C( 89),
                             UINT8_C( 25), UINT8_C(170), UINT8_C(216), UINT8_C(247),
                             UINT8_C(137), UINT8_C(237), UINT8_C(110), UINT8_C(230),
                             UINT8_C(130), UINT8_C(124), UINT8_C(  6), UINT8_C(245)),
      simde_x_mm512_set_epu8(UINT8_C( 79), UINT8_C( 23), UINT8_C(207), UINT8_C( 80),
                             UINT8_C(207), UINT8_C( 81), UINT8_C(  7), UINT8_C(130),
                             UINT8_C(181), UINT8_C(246), UINT8_C(189), UINT8_C(163),
                             UINT8_C(120), UINT8_C( 35), UINT8_C(200), UINT8_C(  3),
                             UINT8_C( 24), UINT8_C(158), UINT8_C(243), UINT8_C(  3),
                             UINT8_C(150), UINT8_C(228), UINT8_C(184), UINT8_C(101),
                             UINT8_C(219), UINT8_C(121), UINT8_C( 65), UINT8_C( 30),
                             UINT8_C(249), UINT8_C( 33), UINT8_C(115), UINT8_C(122),
                             UINT8_C(244), UINT8_C(143), UINT8_C(149), UINT8_C( 29),
                             UINT8_C(178), UINT8_C(131), UINT8_C(101), UINT8_C(120),
                             UINT8_C( 82), UINT8_C(219), UINT8_C(186), UINT8_C(193),
                             UINT8_C(234), UINT8_C(139), UINT8_C( 28), UINT8_C( 91),
                             UINT8_C(105), UINT8_C(250), UINT8_C(223), UINT8_C(189),
                             UINT8_C(224), UINT8_C(245), UINT8_C(188), UINT8_C( 51),
                             UINT8_C( 24), UINT8_C( 89), UINT8_C( 22), UINT8_C( 52),
                             UINT8_C(174), UINT8_C(224), UINT8_C( 67), UINT8_C(156)),
      simde_x_mm512_set_epu8(UINT8_C( 84), UINT8_C(222), UINT8_C( 36), UINT8_C(132),
                             UINT8_C( 32), UINT8_C(182), UINT8_C( 73), UINT8_C(182),
                             UINT8_C( 77), UINT8_C(116), UINT8_C( 50), UINT8_C( 82),
                             UINT8_C( 68), UINT8_C( 72), UINT8_C( 23), UINT8_C( 32),
                             UINT8_C(202), UINT8_C( 82), UINT8_C( 53), UINT8_C( 71),
                             UINT8_C( 22), UINT8_C( 92), UINT8_C( 42), UINT8_C(133),
                             UINT8_C(215), UINT8_C( 34), UINT8_C( 75), UINT8_C( 63),
                             UINT8_C(139), UINT8_C( 23), UINT8_C(141), UINT8_C( 66),
                             UINT8_C(166), UINT8_C( 99), UINT8_C(171), UINT8_C(237),
                             UINT8_C(213), UINT8_C(192), UINT8_C( 54), UINT8_C(152),
                             UINT8_C(108), UINT8_C(253), UINT8_C(216), UINT8_C(214),
                             UINT8_C( 44), UINT8_C(210), UINT8_C( 57), UINT8_C( 98),
                             UINT8_C(  2), UINT8_C(252), UINT8_C(205), UINT8_C(139),
                             UINT8_C(125), UINT8_C( 69), UINT8_C(202), UINT8_C( 82),
                             UINT8_C(  9), UINT8_C(163), UINT8_C( 66), UINT8_C(118),
                             UINT8_C(253), UINT8_C(189), UINT8_C( 37), UINT8_C( 30)) },
    { simde_x_mm512_set_epu8(UINT8_C(122), UINT8_C( 31), UINT8_C(165), UINT8_C(180),
                             UINT8_C(160), UINT8_C(238), UINT8_C( 21), UINT8_C( 93),
                             UINT8_C(118), UINT8_C( 87), UINT8_C(251), UINT8_C( 43),
                             UINT8_C(165), UINT8_C(232), UINT8_C(151), UINT8_C(210),
                             UINT8_C(191), UINT8_C( 60), UINT8_C(141), UINT8_C(172),
                             UINT8_C(143), UINT8_C(152), UINT8_C( 64), UINT8_C(105),
                             UINT8_C( 15), UINT8_C(129), UINT8_C(227), UINT8_C( 58),
                             UINT8_C( 92), UINT8_C(145), UINT8_C( 98), UINT8_C(228),
                             UINT8_C(166), UINT8_C( 72), UINT8_C(150), UINT8_C( 59),
                             UINT8_C( 16), UINT8_C(  1), UINT8_C(194), UINT8_C( 73),
                             UINT8_C(230), UINT8_C(150), UINT8_C(242), UINT8_C( 38),
                             UINT8_C(140), UINT8_C(234), UINT8_C( 77), UINT8_C( 54),
                             UINT8_C(  3), UINT8_C(126), UINT8_C(200), UINT8_C(132),
                             UINT8_C(171), UINT8_C(245), UINT8_C(169), UINT8_C(148),
                             UINT8_C(166), UINT8_C(  7), UINT8_C(  6), UINT8_C(227),
                             UINT8_C( 91), UINT8_C(103), UINT8_C( 93), UINT8_C(244)),
      UINT64_C(          1742408254),
      simde_x_mm512_set_epu8(UINT8_C(195), UINT8_C(222), UINT8_C( 29), UINT8_C(255),
                             UINT8_C(195), UINT8_C(117), UINT8_C(247), UINT8_C(187),
                             UINT8_C( 69), UINT8_C(188), UINT8_C(174), UINT8_C(241),
                             UINT8_C(175), UINT8_C(167), UINT8_C(226), UINT8_C( 66),
                             UINT8_C(177), UINT8_C(104), UINT8_C(172), UINT8_C(245),
                             UINT8_C( 53), UINT8_C( 17), UINT8_C( 64), UINT8_C( 70),
                             UINT8_C(209), UINT8_C(113), UINT8_C( 86), UINT8_C(118),
                             UINT8_C( 56), UINT8_C( 92), UINT8_C(177), UINT8_C(185),
                             UINT8_C(205), UINT8_C(241), UINT8_C(149), UINT8_C(204),
                             UINT8_C(155), UINT8_C( 35), UINT8_C(114), UINT8_C( 12),
                             UINT8_C(212), UINT8_C( 63), UINT8_C( 66), UINT8_C( 74),
                             UINT8_C( 97), UINT8_C(253), UINT8_C(218), UINT8_C( 22),
                             UINT8_C( 38), UINT8_C( 68), UINT8_C(247), UINT8_C(250),
                             UINT8_C(215), UINT8_C( 66), UINT8_C( 67), UINT8_C( 91),
                             UINT8_C(177), UINT8_C(159), UINT8_C(198), UINT8_C(145),
                             UINT8_C(183), UINT8_C( 26), UINT8_C( 66), UINT8_C(165)),
      simde_x_mm512_set_epu8(UINT8_C(104), UINT8_C(148), UINT8_C(187), UINT8_C(240),
                             UINT8_C(224), UINT8_C(131), UINT8_C(  1), UINT8_C(106),
                             UINT8_C( 77), UINT8_C(151), UINT8_C(127), UINT8_C(197),
                             UINT8_C(118), UINT8_C( 35), UINT8_C( 55), UINT8_C(144),
                             UINT8_C( 54), UINT8_C(201), UINT8_C( 41), UINT8_C(221),
                             UINT8_C(189), UINT8_C( 99), UINT8_C(112), UINT8_C(181),
                             UINT8_C( 52), UINT8_C(200), UINT8_C(153), UINT8_C(231),
                             UINT8_C(146), UINT8_C(105), UINT8_C(102), UINT8_C(227),
                             UINT8_C(214), UINT8_C(182), UINT8_C( 31), UINT8_C( 41),
                             UINT8_C( 93), UINT8_C(234), UINT8_C( 82), UINT8_C( 71),
                             UINT8_C( 52), UINT8_C(241), UINT8_C(224), UINT8_C( 69),
                             UINT8_C( 73), UINT8_C( 93), UINT8_C(195), UINT8_C( 84),
                             UINT8_C(170), UINT8_C(173), UINT8_C(170), UINT8_C( 88),
                             UINT8_C( 60), UINT8_C(109), UINT8_C( 86), UINT8_C(119),
                             UINT8_C(141), UINT8_C(206), UINT8_C( 51), UINT8_C(  6),
                             UINT8_C( 71), UINT8_C(253), UINT8_C( 22), UINT8_C( 92)),
      simde_x_mm512_set_epu8(UINT8_C(122), UINT8_C( 31), UINT8_C(165), UINT8_C(180),
                             UINT8_C(160), UINT8_C(238), UINT8_C( 21), UINT8_C( 93),
                             UINT8_C(118), UINT8_C( 87), UINT8_C(251), UINT8_C( 43),
                             UINT8_C(165), UINT8_C(232), UINT8_C(151), UINT8_C(210),
                             UINT8_C(191), UINT8_C( 60), UINT8_C(141), UINT8_C(172),
                             UINT8_C(143), UINT8_C(152), UINT8_C( 64), UINT8_C(105),
                             UINT8_C( 15), UINT8_C(129), UINT8_C(227), UINT8_C( 58),
                             UINT8_C( 92), UINT8_C(145), UINT8_C( 98), UINT8_C(228),
                             UINT8_C(166), UINT8_C(212), UINT8_C( 90), UINT8_C( 59),
                             UINT8_C( 16), UINT8_C(135), UINT8_C( 98), UINT8_C( 42),
                             UINT8_C(132), UINT8_C(152), UINT8_C(242), UINT8_C( 72),
                             UINT8_C( 85), UINT8_C(234), UINT8_C(207), UINT8_C( 53),
                             UINT8_C(  3), UINT8_C(126), UINT8_C(200), UINT8_C(132),
                             UINT8_C(138), UINT8_C(245), UINT8_C( 77), UINT8_C(148),
                             UINT8_C(166), UINT8_C(  7), UINT8_C(125), UINT8_C( 76),
                             UINT8_C(127), UINT8_C(140), UINT8_C( 44), UINT8_C(244)) },
    { simde_x_mm512_set_epu8(UINT8_C(204), UINT8_C( 72), UINT8_C(160), UINT8_C( 51),
                             UINT8_C( 17), UINT8_C( 91), UINT8_C( 99), UINT8_C(232),
                             UINT8_C(230), UINT8_C( 75), UINT8_C( 98), UINT8_C(249),
                             UINT8_C(240), UINT8_C(193), UINT8_C( 40), UINT8_C(144),
                             UINT8_C( 13), UINT8_C(232), UINT8_C(120), UINT8_C( 62),
                             UINT8_C(136), UINT8_C(  7), UINT8_C(252), UINT8_C(  3),
                             UINT8_C(225), UINT8_C( 43), UINT8_C(176), UINT8_C(138),
                             UINT8_C(205), UINT8_C( 22), UINT8_C(172), UINT8_C( 52),
                             UINT8_C(224), UINT8_C(163), UINT8_C( 92), UINT8_C(198),
                             UINT8_C(193), UINT8_C( 77), UINT8_C(  2), UINT8_C( 58),
                             UINT8_C(117), UINT8_C(166), UINT8_C( 25), UINT8_C( 65),
                             UINT8_C( 70), UINT8_C( 62), UINT8_C(155), UINT8_C(179),
                             UINT8_C(194), UINT8_C(252), UINT8_C(155), UINT8_C(113),
                             UINT8_C( 69), UINT8_C( 48), UINT8_C( 10), UINT8_C( 99),
                             UINT8_C( 95), UINT8_C(207), UINT8_C( 28), UINT8_C(202),
                             UINT8_C(125), UINT8_C(229), UINT8_C(112), UINT8_C( 77)),
      UINT64_C(          3364149510),
      simde_x_mm512_set_epu8(UINT8_C( 11), UINT8_C( 82), UINT8_C( 84), UINT8_C(224),
                             UINT8_C(162), UINT8_C(242), UINT8_C(204), UINT8_C( 68),
                             UINT8_C(182), UINT8_C( 59), UINT8_C( 47), UINT8_C(221),
                             UINT8_C( 34), UINT8_C(151), UINT8_C(204), UINT8_C( 95),
                             UINT8_C(116), UINT8_C( 40), UINT8_C(133), UINT8_C(233),
                             UINT8_C(222), UINT8_C( 50), UINT8_C( 44), UINT8_C( 33),
                             UINT8_C( 29), UINT8_C(204), UINT8_C(121), UINT8_C( 27),
                             UINT8_C(138), UINT8_C(185), UINT8_C(  5), UINT8_C(107),
                             UINT8_C(  3), UINT8_C( 36), UINT8_C( 56), UINT8_C(124),
                             UINT8_C(129), UINT8_C( 58), UINT8_C( 37), UINT8_C(111),
                             UINT8_C(254), UINT8_C(180), UINT8_C( 54), UINT8_C(250),
                             UINT8_C( 42), UINT8_C( 75), UINT8_C(154), UINT8_C(231),
                             UINT8_C(115), UINT8_C(171), UINT8_C(247), UINT8_C(142),
                             UINT8_C(  9), UINT8_C(239), UINT8_C(101), UINT8_C( 47),
                             UINT8_C( 79), UINT8_C(209), UINT8_C(133), UINT8_C(218),
                             UINT8_C(253), UINT8_C( 22), UINT8_C( 28), UINT8_C(216)),
      simde_x_mm512_set_epu8(UINT8_C( 60), UINT8_C( 92), UINT8_C(115), UINT8_C(  5),
                             UINT8_C(100), UINT8_C( 27), UINT8_C(227), UINT8_C(100),
                             UINT8_C( 89), UINT8_C(205), UINT8_C( 67), UINT8_C( 82),
                             UINT8_C(155), UINT8_C(204), UINT8_C(152), UINT8_C(151),
                             UINT8_C(209), UINT8_C(229), UINT8_C(210), UINT8_C( 14),
                             UINT8_C(231), UINT8_C( 89), UINT8_C(236), UINT8_C(229),
                             UINT8_C(214), UINT8_C( 93), UINT8_C( 51), UINT8_C(119),
                             UINT8_C( 13), UINT8_C( 60), UINT8_C(212), UINT8_C(222),
                             UINT8_C( 67), UINT8_C( 38), UINT8_C( 63), UINT8_C(141),
                             UINT8_C( 12), UINT8_C(159), UINT8_C( 36), UINT8_C(134),
                             UINT8_C(  6), UINT8_C(139), UINT8_C( 90), UINT8_C(132),
                             UINT8_C(140), UINT8_C(228), UINT8_C(152), UINT8_C(216),
                             UINT8_C(137), UINT8_C(105), UINT8_C(237), UINT8_C(202),
                             UINT8_C( 29), UINT8_C(230), UINT8_C( 44), UINT8_C(  5),
                             UINT8_C( 39), UINT8_C( 73), UINT8_C(177), UINT8_C(242),
                             UINT8_C(209), UINT8_C( 96), UINT8_C( 58), UINT8_C(209)),
      simde_x_mm512_set_epu8(UINT8_C(204), UINT8_C( 72), UINT8_C(160), UINT8_C( 51),
                             UINT8_C( 17), UINT8_C( 91), UINT8_C( 99), UINT8_C(232),
                             UINT8_C(230), UINT8_C( 75), UINT8_C( 98), UINT8_C(249),
                             UINT8_C(240), UINT8_C(193), UINT8_C( 40), UINT8_C(144),
                             UINT8_C( 13), UINT8_C(232), UINT8_C(120), UINT8_C( 62),
                             UINT8_C(136), UINT8_C(  7), UINT8_C(252), UINT8_C(  3),
                             UINT8_C(225), UINT8_C( 43), UINT8_C(176), UINT8_C(138),
                             UINT8_C(205), UINT8_C( 22), UINT8_C(172), UINT8_C( 52),
                             UINT8_C( 35), UINT8_C( 37), UINT8_C( 92), UINT8_C(198),
                             UINT8_C( 71), UINT8_C( 77), UINT8_C(  2), UINT8_C( 58),
                             UINT8_C(130), UINT8_C(166), UINT8_C( 25), UINT8_C( 65),
                             UINT8_C( 70), UINT8_C(152), UINT8_C(155), UINT8_C(179),
                             UINT8_C(126), UINT8_C(138), UINT8_C(155), UINT8_C(172),
                             UINT8_C( 19), UINT8_C( 48), UINT8_C( 10), UINT8_C( 26),
                             UINT8_C( 95), UINT8_C(207), UINT8_C( 28), UINT8_C(202),
                             UINT8_C(125), UINT8_C( 59), UINT8_C( 43), UINT8_C( 77)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_avg_epu8(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u32(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_maskz_avg_epu8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
{ UINT64_C(          1713497089),
      simde_x_mm512_set_epu8(UINT8_C(151), UINT8_C( 80), UINT8_C(240), UINT8_C(132),
                             UINT8_C(208), UINT8_C( 76), UINT8_C(165), UINT8_C(128),
                             UINT8_C( 54), UINT8_C( 63), UINT8_C(114), UINT8_C(183),
                             UINT8_C(230), UINT8_C(208), UINT8_C(232), UINT8_C(243),
                             UINT8_C(  5), UINT8_C(123), UINT8_C(211), UINT8_C(199),
                             UINT8_C(149), UINT8_C( 47), UINT8_C( 90), UINT8_C(202),
                             UINT8_C(  1), UINT8_C(118), UINT8_C( 37), UINT8_C(249),
                             UINT8_C( 83), UINT8_C( 31), UINT8_C(233), UINT8_C(236),
                             UINT8_C(152), UINT8_C(114), UINT8_C( 63), UINT8_C( 25),
                             UINT8_C(176), UINT8_C( 17), UINT8_C( 37), UINT8_C(212),
                             UINT8_C(144), UINT8_C( 41), UINT8_C(238), UINT8_C( 86),
                             UINT8_C(114), UINT8_C(233), UINT8_C(170), UINT8_C(157),
                             UINT8_C(114), UINT8_C( 25), UINT8_C( 94), UINT8_C( 34),
                             UINT8_C(208), UINT8_C(252), UINT8_C(133), UINT8_C(212),
                             UINT8_C(188), UINT8_C( 19), UINT8_C( 47), UINT8_C(134),
                             UINT8_C(117), UINT8_C( 69), UINT8_C(135), UINT8_C( 66)),
      simde_x_mm512_set_epu8(UINT8_C(180), UINT8_C(237), UINT8_C(100), UINT8_C( 59),
                             UINT8_C(192), UINT8_C(196), UINT8_C(203), UINT8_C( 16),
                             UINT8_C(  0), UINT8_C(167), UINT8_C( 13), UINT8_C( 17),
                             UINT8_C(116), UINT8_C( 41), UINT8_C( 54), UINT8_C(248),
                             UINT8_C(144), UINT8_C(109), UINT8_C( 94), UINT8_C( 19),
                             UINT8_C( 46), UINT8_C(201), UINT8_C(103), UINT8_C(  7),
                             UINT8_C(241), UINT8_C(244), UINT8_C(234), UINT8_C(127),
                             UINT8_C(208), UINT8_C(173), UINT8_C(247), UINT8_C(171),
                             UINT8_C(177), UINT8_C(244), UINT8_C( 76), UINT8_C(191),
                             UINT8_C(166), UINT8_C( 19), UINT8_C( 33), UINT8_C(206),
                             UINT8_C( 89), UINT8_C(216), UINT8_C(139), UINT8_C(111),
                             UINT8_C( 48), UINT8_C(119), UINT8_C(201), UINT8_C( 66),
                             UINT8_C(113), UINT8_C(254), UINT8_C(207), UINT8_C(146),
                             UINT8_C(201), UINT8_C( 44), UINT8_C(125), UINT8_C(195),
                             UINT8_C(221), UINT8_C(218), UINT8_C(229), UINT8_C(236),
                             UINT8_C( 32), UINT8_C(197), UINT8_C(234), UINT8_C(125)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(179), UINT8_C( 70), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 18), UINT8_C( 35), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(189), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(112),
                             UINT8_C(114), UINT8_C(140), UINT8_C(151), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(148), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 96)) },
    { UINT64_C(          4250428108),
      simde_x_mm512_set_epu8(UINT8_C(107), UINT8_C(163), UINT8_C(179), UINT8_C( 53),
                             UINT8_C(126), UINT8_C( 10), UINT8_C(123), UINT8_C(143),
                             UINT8_C(215), UINT8_C(148), UINT8_C(197), UINT8_C(220),
                             UINT8_C(232), UINT8_C(205), UINT8_C(188), UINT8_C(218),
                             UINT8_C( 19), UINT8_C(120), UINT8_C(138), UINT8_C( 63),
                             UINT8_C( 24), UINT8_C( 72), UINT8_C( 39), UINT8_C( 31),
                             UINT8_C(164), UINT8_C( 52), UINT8_C( 81), UINT8_C( 39),
                             UINT8_C(186), UINT8_C( 73), UINT8_C( 76), UINT8_C(114),
                             UINT8_C(249), UINT8_C(  4), UINT8_C(201), UINT8_C(188),
                             UINT8_C(120), UINT8_C( 98), UINT8_C(141), UINT8_C(200),
                             UINT8_C( 93), UINT8_C(254), UINT8_C( 78), UINT8_C( 16),
                             UINT8_C( 88), UINT8_C( 71), UINT8_C(144), UINT8_C(138),
                             UINT8_C(  4), UINT8_C(168), UINT8_C( 76), UINT8_C( 88),
                             UINT8_C(159), UINT8_C(107), UINT8_C(228), UINT8_C(197),
                             UINT8_C(209), UINT8_C(111), UINT8_C( 61), UINT8_C(147),
                             UINT8_C(137), UINT8_C( 97), UINT8_C(105), UINT8_C(160)),
      simde_x_mm512_set_epu8(UINT8_C( 95), UINT8_C(238), UINT8_C( 11), UINT8_C( 96),
                             UINT8_C(252), UINT8_C(162), UINT8_C(116), UINT8_C(225),
                             UINT8_C( 52), UINT8_C(254), UINT8_C( 98), UINT8_C( 10),
                             UINT8_C(  5), UINT8_C( 19), UINT8_C(191), UINT8_C( 10),
                             UINT8_C(147), UINT8_C( 52), UINT8_C(171), UINT8_C(224),
                             UINT8_C( 38), UINT8_C( 92), UINT8_C(  6), UINT8_C(185),
                             UINT8_C(177), UINT8_C( 79), UINT8_C(162), UINT8_C(113),
                             UINT8_C(139), UINT8_C( 20), UINT8_C(174), UINT8_C( 82),
                             UINT8_C(136), UINT8_C(114), UINT8_C(204), UINT8_C(188),
                             UINT8_C(236), UINT8_C(209), UINT8_C(166), UINT8_C(169),
                             UINT8_C( 79), UINT8_C(219), UINT8_C( 63), UINT8_C(167),
                             UINT8_C(216), UINT8_C(189), UINT8_C(187), UINT8_C(139),
                             UINT8_C(254), UINT8_C(206), UINT8_C(156), UINT8_C(171),
                             UINT8_C(128), UINT8_C(139), UINT8_C( 97), UINT8_C(237),
                             UINT8_C( 71), UINT8_C(239), UINT8_C(  0), UINT8_C(174),
                             UINT8_C(229), UINT8_C(124), UINT8_C( 45), UINT8_C( 57)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(193), UINT8_C( 59), UINT8_C(203), UINT8_C(188),
                             UINT8_C(178), UINT8_C(154), UINT8_C(  0), UINT8_C(185),
                             UINT8_C(  0), UINT8_C(237), UINT8_C(  0), UINT8_C( 92),
                             UINT8_C(152), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(187), UINT8_C(116), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(163), UINT8_C(  0),
                             UINT8_C(140), UINT8_C(175), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(183), UINT8_C(111), UINT8_C(  0), UINT8_C(  0)) },
    { UINT64_C(          3228288806),
      simde_x_mm512_set_epu8(UINT8_C( 83), UINT8_C( 39), UINT8_C(120), UINT8_C(115),
                             UINT8_C(205), UINT8_C(228), UINT8_C(102), UINT8_C(158),
                             UINT8_C(179), UINT8_C(121), UINT8_C( 42), UINT8_C(114),
                             UINT8_C(255), UINT8_C(112), UINT8_C( 17), UINT8_C(225),
                             UINT8_C(108), UINT8_C(229), UINT8_C( 66), UINT8_C( 23),
                             UINT8_C( 69), UINT8_C(166), UINT8_C(210), UINT8_C(165),
                             UINT8_C(175), UINT8_C(169), UINT8_C(  1), UINT8_C(245),
                             UINT8_C( 84), UINT8_C(139), UINT8_C( 79), UINT8_C(146),
                             UINT8_C(212), UINT8_C(226), UINT8_C( 33), UINT8_C( 53),
                             UINT8_C( 64), UINT8_C(240), UINT8_C(145), UINT8_C(215),
                             UINT8_C(154), UINT8_C( 13), UINT8_C( 97), UINT8_C(201),
                             UINT8_C( 19), UINT8_C(240), UINT8_C(188), UINT8_C(173),
                             UINT8_C(228), UINT8_C( 88), UINT8_C( 41), UINT8_C( 18),
                             UINT8_C(177), UINT8_C(249), UINT8_C(161), UINT8_C(144),
                             UINT8_C(168), UINT8_C(228), UINT8_C(181), UINT8_C( 34),
                             UINT8_C(226), UINT8_C(255), UINT8_C( 52), UINT8_C(164)),
      simde_x_mm512_set_epu8(UINT8_C( 60), UINT8_C(216), UINT8_C( 36), UINT8_C(217),
                             UINT8_C(176), UINT8_C(146), UINT8_C( 14), UINT8_C(195),
                             UINT8_C(217), UINT8_C(186), UINT8_C(140), UINT8_C(157),
                             UINT8_C(174), UINT8_C(143), UINT8_C(136), UINT8_C(140),
                             UINT8_C(198), UINT8_C( 18), UINT8_C( 72), UINT8_C( 23),
                             UINT8_C(139), UINT8_C(151), UINT8_C( 83), UINT8_C(  3),
                             UINT8_C(152), UINT8_C( 34), UINT8_C( 72), UINT8_C(223),
                             UINT8_C( 84), UINT8_C(166), UINT8_C(140), UINT8_C(210),
                             UINT8_C(238), UINT8_C( 96), UINT8_C(210), UINT8_C(147),
                             UINT8_C(153), UINT8_C(238), UINT8_C(217), UINT8_C( 67),
                             UINT8_C(118), UINT8_C( 12), UINT8_C(237), UINT8_C(171),
                             UINT8_C( 23), UINT8_C( 75), UINT8_C(178), UINT8_C(118),
                             UINT8_C(128), UINT8_C( 11), UINT8_C(225), UINT8_C(116),
                             UINT8_C(179), UINT8_C( 97), UINT8_C( 87), UINT8_C( 53),
                             UINT8_C(223), UINT8_C( 37), UINT8_C( 28), UINT8_C( 24),
                             UINT8_C(153), UINT8_C( 99), UINT8_C(181), UINT8_C( 41)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(225), UINT8_C(161), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 13), UINT8_C(167), UINT8_C(  0),
                             UINT8_C( 21), UINT8_C(  0), UINT8_C(183), UINT8_C(146),
                             UINT8_C(178), UINT8_C( 50), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(173), UINT8_C(124), UINT8_C( 99),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(105), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(177), UINT8_C(117), UINT8_C(  0)) },
    { UINT64_C(            74372392),
      simde_x_mm512_set_epu8(UINT8_C( 19), UINT8_C(169), UINT8_C( 42), UINT8_C(146),
                             UINT8_C( 68), UINT8_C( 97), UINT8_C(131), UINT8_C( 75),
                             UINT8_C( 30), UINT8_C(202), UINT8_C(218), UINT8_C(236),
                             UINT8_C(160), UINT8_C( 84), UINT8_C(108), UINT8_C( 24),
                             UINT8_C(202), UINT8_C(230), UINT8_C(131), UINT8_C(203),
                             UINT8_C( 48), UINT8_C(178), UINT8_C(160), UINT8_C( 82),
                             UINT8_C(240), UINT8_C(188), UINT8_C(191), UINT8_C( 28),
                             UINT8_C(174), UINT8_C(140), UINT8_C(119), UINT8_C(143),
                             UINT8_C(102), UINT8_C( 90), UINT8_C( 86), UINT8_C(242),
                             UINT8_C(207), UINT8_C( 71), UINT8_C(  2), UINT8_C( 28),
                             UINT8_C(194), UINT8_C( 53), UINT8_C(214), UINT8_C(158),
                             UINT8_C( 11), UINT8_C( 81), UINT8_C( 46), UINT8_C( 73),
                             UINT8_C(250), UINT8_C(127), UINT8_C(146), UINT8_C(248),
                             UINT8_C(106), UINT8_C( 95), UINT8_C(130), UINT8_C(129),
                             UINT8_C(153), UINT8_C(235), UINT8_C(236), UINT8_C(185),
                             UINT8_C(106), UINT8_C( 23), UINT8_C(205), UINT8_C(209)),
      simde_x_mm512_set_epu8(UINT8_C(221), UINT8_C(195), UINT8_C( 15), UINT8_C( 71),
                             UINT8_C(113), UINT8_C(109), UINT8_C( 91), UINT8_C(139),
                             UINT8_C(  0), UINT8_C(121), UINT8_C( 48), UINT8_C(109),
                             UINT8_C( 55), UINT8_C(125), UINT8_C(144), UINT8_C( 80),
                             UINT8_C( 48), UINT8_C( 40), UINT8_C( 32), UINT8_C(158),
                             UINT8_C( 64), UINT8_C(225), UINT8_C(246), UINT8_C(250),
                             UINT8_C(216), UINT8_C( 37), UINT8_C( 76), UINT8_C(205),
                             UINT8_C( 27), UINT8_C(254), UINT8_C(155), UINT8_C(246),
                             UINT8_C(218), UINT8_C( 69), UINT8_C(  1), UINT8_C(216),
                             UINT8_C(164), UINT8_C( 62), UINT8_C( 73), UINT8_C(202),
                             UINT8_C( 28), UINT8_C(155), UINT8_C(152), UINT8_C(139),
                             UINT8_C( 24), UINT8_C(201), UINT8_C( 82), UINT8_C(156),
                             UINT8_C(214), UINT8_C( 62), UINT8_C(143), UINT8_C(110),
                             UINT8_C(164), UINT8_C(127), UINT8_C(164), UINT8_C( 20),
                             UINT8_C(221), UINT8_C( 35), UINT8_C( 30), UINT8_C(170),
                             UINT8_C(120), UINT8_C( 91), UINT8_C(187), UINT8_C(207)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 67), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(104), UINT8_C(183), UINT8_C(  0),
                             UINT8_C( 18), UINT8_C(141), UINT8_C( 64), UINT8_C(  0),
                             UINT8_C(232), UINT8_C( 95), UINT8_C(  0), UINT8_C(179),
                             UINT8_C(  0), UINT8_C(111), UINT8_C(  0), UINT8_C( 75),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(133), UINT8_C(  0),
                             UINT8_C(113), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0)) },
    { UINT64_C(          1704849946),
      simde_x_mm512_set_epu8(UINT8_C( 75), UINT8_C(130), UINT8_C(174), UINT8_C(185),
                             UINT8_C(240), UINT8_C(251), UINT8_C(233), UINT8_C(143),
                             UINT8_C(196), UINT8_C( 48), UINT8_C(196), UINT8_C( 72),
                             UINT8_C(201), UINT8_C(123), UINT8_C( 70), UINT8_C(237),
                             UINT8_C( 30), UINT8_C(225), UINT8_C(201), UINT8_C(186),
                             UINT8_C(  9), UINT8_C(202), UINT8_C( 73), UINT8_C(192),
                             UINT8_C( 82), UINT8_C(124), UINT8_C( 29), UINT8_C(  8),
                             UINT8_C( 64), UINT8_C( 66), UINT8_C(254), UINT8_C(144),
                             UINT8_C(122), UINT8_C(124), UINT8_C( 90), UINT8_C( 22),
                             UINT8_C(107), UINT8_C(236), UINT8_C( 37), UINT8_C(140),
                             UINT8_C(185), UINT8_C( 48), UINT8_C(255), UINT8_C(239),
                             UINT8_C(166), UINT8_C(  3), UINT8_C(222), UINT8_C( 36),
                             UINT8_C(239), UINT8_C(218), UINT8_C(100), UINT8_C(226),
                             UINT8_C(118), UINT8_C( 42), UINT8_C(231), UINT8_C(211),
                             UINT8_C(  4), UINT8_C(  8), UINT8_C( 53), UINT8_C( 84),
                             UINT8_C(136), UINT8_C( 61), UINT8_C( 90), UINT8_C(237)),
      simde_x_mm512_set_epu8(UINT8_C( 81), UINT8_C( 81), UINT8_C( 43), UINT8_C( 91),
                             UINT8_C(149), UINT8_C(240), UINT8_C( 71), UINT8_C(161),
                             UINT8_C(204), UINT8_C( 80), UINT8_C( 62), UINT8_C(128),
                             UINT8_C(178), UINT8_C( 60), UINT8_C( 92), UINT8_C( 64),
                             UINT8_C( 44), UINT8_C(188), UINT8_C(121), UINT8_C(108),
                             UINT8_C( 90), UINT8_C( 48), UINT8_C(  8), UINT8_C(192),
                             UINT8_C(189), UINT8_C(101), UINT8_C( 72), UINT8_C(114),
                             UINT8_C(232), UINT8_C(233), UINT8_C(205), UINT8_C(  5),
                             UINT8_C(117), UINT8_C( 79), UINT8_C( 29), UINT8_C(232),
                             UINT8_C( 51), UINT8_C(176), UINT8_C(226), UINT8_C(160),
                             UINT8_C(230), UINT8_C(138), UINT8_C( 64), UINT8_C(111),
                             UINT8_C(190), UINT8_C(200), UINT8_C(126), UINT8_C(168),
                             UINT8_C(222), UINT8_C(  5), UINT8_C(142), UINT8_C(  0),
                             UINT8_C( 60), UINT8_C( 23), UINT8_C(145), UINT8_C(197),
                             UINT8_C( 92), UINT8_C( 21), UINT8_C(182), UINT8_C( 99),
                             UINT8_C(234), UINT8_C(209), UINT8_C(134), UINT8_C( 50)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(102), UINT8_C( 60), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(206), UINT8_C(  0), UINT8_C(150),
                             UINT8_C(208), UINT8_C(  0), UINT8_C(  0), UINT8_C(175),
                             UINT8_C(178), UINT8_C(102), UINT8_C(  0), UINT8_C(102),
                             UINT8_C(231), UINT8_C(112), UINT8_C(121), UINT8_C(113),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(188), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 92),
                             UINT8_C(185), UINT8_C(  0), UINT8_C(112), UINT8_C(  0)) },
    { UINT64_C(           616766838),
      simde_x_mm512_set_epu8(UINT8_C(180), UINT8_C(137), UINT8_C( 51), UINT8_C( 92),
                             UINT8_C(187), UINT8_C( 82), UINT8_C( 53), UINT8_C( 28),
                             UINT8_C(223), UINT8_C(152), UINT8_C(200), UINT8_C(193),
                             UINT8_C(225), UINT8_C(154), UINT8_C(231), UINT8_C( 61),
                             UINT8_C(162), UINT8_C( 56), UINT8_C(127), UINT8_C(187),
                             UINT8_C(196), UINT8_C(180), UINT8_C(126), UINT8_C( 42),
                             UINT8_C(219), UINT8_C(  5), UINT8_C(113), UINT8_C(138),
                             UINT8_C(204), UINT8_C(253), UINT8_C(215), UINT8_C(247),
                             UINT8_C(235), UINT8_C( 43), UINT8_C(234), UINT8_C( 33),
                             UINT8_C(112), UINT8_C(108), UINT8_C(220), UINT8_C( 90),
                             UINT8_C(144), UINT8_C(181), UINT8_C( 55), UINT8_C( 53),
                             UINT8_C( 64), UINT8_C(203), UINT8_C(190), UINT8_C(189),
                             UINT8_C(102), UINT8_C(244), UINT8_C( 66), UINT8_C(205),
                             UINT8_C( 39), UINT8_C(196), UINT8_C(165), UINT8_C(215),
                             UINT8_C(172), UINT8_C( 65), UINT8_C( 68), UINT8_C(204),
                             UINT8_C( 53), UINT8_C( 34), UINT8_C( 78), UINT8_C(127)),
      simde_x_mm512_set_epu8(UINT8_C(141), UINT8_C(142), UINT8_C(201), UINT8_C(183),
                             UINT8_C( 28), UINT8_C(210), UINT8_C( 48), UINT8_C(119),
                             UINT8_C(143), UINT8_C( 53), UINT8_C(224), UINT8_C( 96),
                             UINT8_C(218), UINT8_C(201), UINT8_C(253), UINT8_C(241),
                             UINT8_C( 77), UINT8_C(249), UINT8_C( 74), UINT8_C( 43),
                             UINT8_C(181), UINT8_C(113), UINT8_C(189), UINT8_C(106),
                             UINT8_C( 54), UINT8_C( 32), UINT8_C(202), UINT8_C( 67),
                             UINT8_C(214), UINT8_C( 23), UINT8_C(167), UINT8_C( 40),
                             UINT8_C(139), UINT8_C( 52), UINT8_C( 60), UINT8_C( 38),
                             UINT8_C( 95), UINT8_C( 19), UINT8_C(138), UINT8_C(217),
                             UINT8_C(209), UINT8_C( 61), UINT8_C( 63), UINT8_C(128),
                             UINT8_C(163), UINT8_C( 56), UINT8_C(251), UINT8_C(135),
                             UINT8_C( 69), UINT8_C(144), UINT8_C(129), UINT8_C(103),
                             UINT8_C(244), UINT8_C( 97), UINT8_C(191), UINT8_C( 58),
                             UINT8_C(119), UINT8_C( 19), UINT8_C(105), UINT8_C(174),
                             UINT8_C(180), UINT8_C( 41), UINT8_C(251), UINT8_C(155)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(147), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 64), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(177), UINT8_C(121), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(221), UINT8_C(162),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(154),
                             UINT8_C(142), UINT8_C(147), UINT8_C(  0), UINT8_C(137),
                             UINT8_C(  0), UINT8_C( 42), UINT8_C( 87), UINT8_C(189),
                             UINT8_C(  0), UINT8_C( 38), UINT8_C(165), UINT8_C(  0)) },
    { UINT64_C(           771922964),
      simde_x_mm512_set_epu8(UINT8_C( 84), UINT8_C(193), UINT8_C(196), UINT8_C(188),
                             UINT8_C( 28), UINT8_C( 14), UINT8_C(183), UINT8_C( 63),
                             UINT8_C(195), UINT8_C( 17), UINT8_C( 60), UINT8_C(196),
                             UINT8_C(140), UINT8_C(189), UINT8_C(109), UINT8_C( 63),
                             UINT8_C( 42), UINT8_C(192), UINT8_C(240), UINT8_C(166),
                             UINT8_C( 14), UINT8_C(224), UINT8_C(252), UINT8_C( 17),
                             UINT8_C( 46), UINT8_C(184), UINT8_C(253), UINT8_C( 54),
                             UINT8_C( 94), UINT8_C( 75), UINT8_C(123), UINT8_C(145),
                             UINT8_C(160), UINT8_C(164), UINT8_C(123), UINT8_C(216),
                             UINT8_C(170), UINT8_C(112), UINT8_C(140), UINT8_C( 56),
                             UINT8_C( 30), UINT8_C(182), UINT8_C(108), UINT8_C( 63),
                             UINT8_C( 54), UINT8_C( 68), UINT8_C( 21), UINT8_C( 50),
                             UINT8_C( 82), UINT8_C( 10), UINT8_C(167), UINT8_C(177),
                             UINT8_C(210), UINT8_C(  2), UINT8_C( 48), UINT8_C( 73),
                             UINT8_C(153), UINT8_C( 42), UINT8_C( 43), UINT8_C( 19),
                             UINT8_C( 82), UINT8_C(112), UINT8_C(146), UINT8_C( 77)),
      simde_x_mm512_set_epu8(UINT8_C(117), UINT8_C( 61), UINT8_C(219), UINT8_C(166),
                             UINT8_C(101), UINT8_C(146), UINT8_C(252), UINT8_C(220),
                             UINT8_C(111), UINT8_C(  7), UINT8_C(233), UINT8_C( 32),
                             UINT8_C(239), UINT8_C(243), UINT8_C(204), UINT8_C(249),
                             UINT8_C(179), UINT8_C(241), UINT8_C(226), UINT8_C(120),
                             UINT8_C(244), UINT8_C(118), UINT8_C(248), UINT8_C(141),
                             UINT8_C(179), UINT8_C(252), UINT8_C(219), UINT8_C( 58),
                             UINT8_C( 62), UINT8_C(244), UINT8_C(181), UINT8_C( 77),
                             UINT8_C( 48), UINT8_C(136), UINT8_C(150), UINT8_C( 74),
                             UINT8_C( 87), UINT8_C(176), UINT8_C(194), UINT8_C( 45),
                             UINT8_C(190), UINT8_C(213), UINT8_C( 70), UINT8_C( 70),
                             UINT8_C(177), UINT8_C(254), UINT8_C(160), UINT8_C( 78),
                             UINT8_C(253), UINT8_C(131), UINT8_C(202), UINT8_C(108),
                             UINT8_C(174), UINT8_C(186), UINT8_C(172), UINT8_C(193),
                             UINT8_C(162), UINT8_C(235), UINT8_C(165), UINT8_C(158),
                             UINT8_C(140), UINT8_C(172), UINT8_C(251), UINT8_C(116)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(137), UINT8_C(  0),
                             UINT8_C(129), UINT8_C(144), UINT8_C(167), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 91), UINT8_C(  0),
                             UINT8_C(168), UINT8_C(  0), UINT8_C(  0), UINT8_C(143),
                             UINT8_C(192), UINT8_C( 94), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 89),
                             UINT8_C(  0), UINT8_C(142), UINT8_C(  0), UINT8_C(  0)) },
    { UINT64_C(            97696573),
      simde_x_mm512_set_epu8(UINT8_C( 56), UINT8_C(233), UINT8_C(161), UINT8_C( 70),
                             UINT8_C( 29), UINT8_C(119), UINT8_C(231), UINT8_C(252),
                             UINT8_C(132), UINT8_C(198), UINT8_C( 18), UINT8_C(195),
                             UINT8_C( 88), UINT8_C(114), UINT8_C(173), UINT8_C( 54),
                             UINT8_C( 75), UINT8_C(  3), UINT8_C(214), UINT8_C(  2),
                             UINT8_C(139), UINT8_C(186), UINT8_C( 99), UINT8_C(154),
                             UINT8_C(177), UINT8_C(145), UINT8_C(140), UINT8_C(170),
                             UINT8_C(124), UINT8_C( 32), UINT8_C(208), UINT8_C(227),
                             UINT8_C( 14), UINT8_C( 57), UINT8_C( 96), UINT8_C(190),
                             UINT8_C(123), UINT8_C(184), UINT8_C( 51), UINT8_C( 34),
                             UINT8_C(239), UINT8_C( 21), UINT8_C(170), UINT8_C(146),
                             UINT8_C(232), UINT8_C(  0), UINT8_C(180), UINT8_C( 80),
                             UINT8_C( 72), UINT8_C(231), UINT8_C(149), UINT8_C(142),
                             UINT8_C(142), UINT8_C( 86), UINT8_C( 39), UINT8_C(243),
                             UINT8_C( 33), UINT8_C(235), UINT8_C( 93), UINT8_C(129),
                             UINT8_C( 46), UINT8_C(131), UINT8_C(184), UINT8_C(105)),
      simde_x_mm512_set_epu8(UINT8_C(188), UINT8_C(104), UINT8_C(150), UINT8_C( 91),
                             UINT8_C(223), UINT8_C( 10), UINT8_C(154), UINT8_C(110),
                             UINT8_C(234), UINT8_C(193), UINT8_C( 58), UINT8_C(132),
                             UINT8_C( 18), UINT8_C(225), UINT8_C( 95), UINT8_C(  7),
                             UINT8_C(253), UINT8_C( 41), UINT8_C(230), UINT8_C(186),
                             UINT8_C(  9), UINT8_C( 18), UINT8_C(163), UINT8_C( 56),
                             UINT8_C( 96), UINT8_C(249), UINT8_C( 80), UINT8_C( 62),
                             UINT8_C(194), UINT8_C( 89), UINT8_C(163), UINT8_C(133),
                             UINT8_C( 35), UINT8_C(148), UINT8_C(177), UINT8_C( 29),
                             UINT8_C(195), UINT8_C(169), UINT8_C( 29), UINT8_C( 99),
                             UINT8_C(232), UINT8_C( 69), UINT8_C( 58), UINT8_C(168),
                             UINT8_C(144), UINT8_C(242), UINT8_C(220), UINT8_C(  1),
                             UINT8_C( 48), UINT8_C(123), UINT8_C( 36), UINT8_C(240),
                             UINT8_C( 56), UINT8_C(103), UINT8_C(183), UINT8_C(  7),
                             UINT8_C(134), UINT8_C(138), UINT8_C(158), UINT8_C(199),
                             UINT8_C( 65), UINT8_C( 92), UINT8_C(182), UINT8_C(118)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(177), UINT8_C(  0), UINT8_C( 67),
                             UINT8_C(236), UINT8_C( 45), UINT8_C(  0), UINT8_C(157),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(200), UINT8_C(  0),
                             UINT8_C( 60), UINT8_C(  0), UINT8_C( 93), UINT8_C(191),
                             UINT8_C( 99), UINT8_C(  0), UINT8_C(111), UINT8_C(125),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(126), UINT8_C(164),
                             UINT8_C( 56), UINT8_C(112), UINT8_C(  0), UINT8_C(112)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_avg_epu8(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_avg_epu16(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu16(UINT16_C( 13922), UINT16_C( 36897), UINT16_C( 58180), UINT16_C( 11516),
                              UINT16_C( 48259), UINT16_C(  5769), UINT16_C( 28390), UINT16_C( 29726),
                              UINT16_C( 60808), UINT16_C( 38778), UINT16_C( 21386), UINT16_C( 37563),
                              UINT16_C( 21427), UINT16_C( 42840), UINT16_C( 63576), UINT16_C( 25988),
                              UINT16_C( 52004), UINT16_C( 13742), UINT16_C( 20065), UINT16_C( 31945),
                              UINT16_C(  3305), UINT16_C( 50297), UINT16_C( 19714), UINT16_C( 48635),
                              UINT16_C( 64641), UINT16_C(  9835), UINT16_C( 33507), UINT16_C( 40606),
                              UINT16_C( 49930), UINT16_C( 25911), UINT16_C( 16490), UINT16_C( 30266)),
      simde_x_mm512_set_epu16(UINT16_C( 35675), UINT16_C(  3257), UINT16_C( 12418), UINT16_C( 59056),
                              UINT16_C( 54292), UINT16_C( 28377), UINT16_C( 47802), UINT16_C( 33906),
                              UINT16_C( 48379), UINT16_C( 57830), UINT16_C( 42348), UINT16_C(  4361),
                              UINT16_C( 62947), UINT16_C( 32240), UINT16_C( 12123), UINT16_C(   903),
                              UINT16_C( 62311), UINT16_C( 39097), UINT16_C( 12552), UINT16_C( 17043),
                              UINT16_C( 12967), UINT16_C( 14694), UINT16_C( 36399), UINT16_C( 44335),
                              UINT16_C( 44269), UINT16_C( 14847), UINT16_C( 26083), UINT16_C( 50887),
                              UINT16_C(  6575), UINT16_C( 58796), UINT16_C( 53958), UINT16_C( 55190)),
      simde_x_mm512_set_epu16(UINT16_C( 24799), UINT16_C( 20077), UINT16_C( 35299), UINT16_C( 35286),
                              UINT16_C( 51276), UINT16_C( 17073), UINT16_C( 38096), UINT16_C( 31816),
                              UINT16_C( 54594), UINT16_C( 48304), UINT16_C( 31867), UINT16_C( 20962),
                              UINT16_C( 42187), UINT16_C( 37540), UINT16_C( 37850), UINT16_C( 13446),
                              UINT16_C( 57158), UINT16_C( 26420), UINT16_C( 16309), UINT16_C( 24494),
                              UINT16_C(  8136), UINT16_C( 32496), UINT16_C( 28057), UINT16_C( 46485),
                              UINT16_C( 54455), UINT16_C( 12341), UINT16_C( 29795), UINT16_C( 45747),
                              UINT16_C( 28253), UINT16_C( 42354), UINT16_C( 35224), UINT16_C( 42728)) },
    { simde_x_mm512_set_epu16(UINT16_C( 53467), UINT16_C( 14812), UINT16_C(  1601), UINT16_C(  5446),
                              UINT16_C( 10821), UINT16_C( 52555), UINT16_C( 11613), UINT16_C( 32262),
                              UINT16_C( 44594), UINT16_C(  4573), UINT16_C( 55679), UINT16_C( 28536),
                              UINT16_C( 33684), UINT16_C( 36248), UINT16_C( 37000), UINT16_C( 16957),
                              UINT16_C( 33904), UINT16_C(  7320), UINT16_C( 32743), UINT16_C( 28065),
                              UINT16_C( 40454), UINT16_C( 54701), UINT16_C( 30387), UINT16_C( 20402),
                              UINT16_C( 12012), UINT16_C( 12600), UINT16_C( 40321), UINT16_C( 11976),
                              UINT16_C( 22914), UINT16_C( 48119), UINT16_C( 54567), UINT16_C( 37518)),
      simde_x_mm512_set_epu16(UINT16_C( 19683), UINT16_C( 49281), UINT16_C( 58394), UINT16_C( 42390),
                              UINT16_C( 28448), UINT16_C(  2882), UINT16_C( 16746), UINT16_C( 53644),
                              UINT16_C( 16898), UINT16_C( 40318), UINT16_C( 16648), UINT16_C( 14647),
                              UINT16_C( 38440), UINT16_C( 42038), UINT16_C( 24217), UINT16_C( 60044),
                              UINT16_C( 11584), UINT16_C( 35025), UINT16_C( 26069), UINT16_C( 37885),
                              UINT16_C( 14708), UINT16_C( 24663), UINT16_C( 44110), UINT16_C( 40062),
                              UINT16_C(   918), UINT16_C( 34061), UINT16_C( 57874), UINT16_C( 27338),
                              UINT16_C( 24412), UINT16_C( 15314), UINT16_C( 35927), UINT16_C( 54580)),
      simde_x_mm512_set_epu16(UINT16_C( 36575), UINT16_C( 32047), UINT16_C( 29998), UINT16_C( 23918),
                              UINT16_C( 19635), UINT16_C( 27719), UINT16_C( 14180), UINT16_C( 42953),
                              UINT16_C( 30746), UINT16_C( 22446), UINT16_C( 36164), UINT16_C( 21592),
                              UINT16_C( 36062), UINT16_C( 39143), UINT16_C( 30609), UINT16_C( 38501),
                              UINT16_C( 22744), UINT16_C( 21173), UINT16_C( 29406), UINT16_C( 32975),
                              UINT16_C( 27581), UINT16_C( 39682), UINT16_C( 37249), UINT16_C( 30232),
                              UINT16_C(  6465), UINT16_C( 23331), UINT16_C( 49098), UINT16_C( 19657),
                              UINT16_C( 23663), UINT16_C( 31717), UINT16_C( 45247), UINT16_C( 46049)) },
    { simde_x_mm512_set_epu16(UINT16_C(  2926), UINT16_C( 37218), UINT16_C( 49262), UINT16_C( 41266),
                              UINT16_C( 64616), UINT16_C( 47887), UINT16_C( 47046), UINT16_C( 20233),
                              UINT16_C( 17531), UINT16_C( 35216), UINT16_C( 26970), UINT16_C( 22110),
                              UINT16_C( 23885), UINT16_C( 49160), UINT16_C( 11289), UINT16_C( 22415),
                              UINT16_C( 57944), UINT16_C( 39676), UINT16_C( 14246), UINT16_C( 36547),
                              UINT16_C( 43442), UINT16_C( 52571), UINT16_C( 16838), UINT16_C( 32565),
                              UINT16_C( 62744), UINT16_C( 45552), UINT16_C( 50968), UINT16_C( 36716),
                              UINT16_C( 10154), UINT16_C( 41950), UINT16_C( 14496), UINT16_C( 51322)),
      simde_x_mm512_set_epu16(UINT16_C( 14640), UINT16_C( 63580), UINT16_C( 14746), UINT16_C( 21373),
                              UINT16_C(  2714), UINT16_C( 18543), UINT16_C( 17198), UINT16_C( 32202),
                              UINT16_C( 11581), UINT16_C( 13480), UINT16_C( 54288), UINT16_C(  9603),
                              UINT16_C( 12378), UINT16_C( 53993), UINT16_C( 37890), UINT16_C(  2622),
                              UINT16_C( 22964), UINT16_C( 24086), UINT16_C( 65101), UINT16_C(   151),
                              UINT16_C( 54310), UINT16_C( 27341), UINT16_C( 18591), UINT16_C( 57907),
                              UINT16_C( 13730), UINT16_C( 48472), UINT16_C( 10888), UINT16_C( 26832),
                              UINT16_C( 39665), UINT16_C( 48015), UINT16_C( 40287), UINT16_C(  7521)),
      simde_x_mm512_set_epu16(UINT16_C(  8783), UINT16_C( 50399), UINT16_C( 32004), UINT16_C( 31320),
                              UINT16_C( 33665), UINT16_C( 33215), UINT16_C( 32122), UINT16_C( 26218),
                              UINT16_C( 14556), UINT16_C( 24348), UINT16_C( 40629), UINT16_C( 15857),
                              UINT16_C( 18132), UINT16_C( 51577), UINT16_C( 24590), UINT16_C( 12519),
                              UINT16_C( 40454), UINT16_C( 31881), UINT16_C( 39674), UINT16_C( 18349),
                              UINT16_C( 48876), UINT16_C( 39956), UINT16_C( 17715), UINT16_C( 45236),
                              UINT16_C( 38237), UINT16_C( 47012), UINT16_C( 30928), UINT16_C( 31774),
                              UINT16_C( 24910), UINT16_C( 44983), UINT16_C( 27392), UINT16_C( 29422)) },
    { simde_x_mm512_set_epu16(UINT16_C( 33359), UINT16_C( 20997), UINT16_C( 60535), UINT16_C(  6477),
                              UINT16_C( 35687), UINT16_C( 52277), UINT16_C( 18001), UINT16_C(  9114),
                              UINT16_C( 58688), UINT16_C( 24195), UINT16_C( 55556), UINT16_C( 26572),
                              UINT16_C( 13614), UINT16_C( 31611), UINT16_C( 64483), UINT16_C( 39184),
                              UINT16_C( 20423), UINT16_C(  4017), UINT16_C( 21263), UINT16_C(  9687),
                              UINT16_C( 45713), UINT16_C( 61493), UINT16_C( 29891), UINT16_C( 26099),
                              UINT16_C( 34397), UINT16_C( 16487), UINT16_C( 18770), UINT16_C( 48421),
                              UINT16_C( 51774), UINT16_C( 40289), UINT16_C( 36358), UINT16_C(  9752)),
      simde_x_mm512_set_epu16(UINT16_C( 14685), UINT16_C( 36894), UINT16_C(  3039), UINT16_C( 14211),
                              UINT16_C(  7600), UINT16_C( 13396), UINT16_C( 20271), UINT16_C( 32796),
                              UINT16_C( 18819), UINT16_C( 35329), UINT16_C( 25198), UINT16_C( 53928),
                              UINT16_C( 53351), UINT16_C( 38714), UINT16_C( 38160), UINT16_C( 28969),
                              UINT16_C( 51469), UINT16_C( 54246), UINT16_C( 53402), UINT16_C( 12671),
                              UINT16_C( 23815), UINT16_C( 34869), UINT16_C(  4959), UINT16_C( 48021),
                              UINT16_C(   161), UINT16_C( 58452), UINT16_C( 21609), UINT16_C( 23057),
                              UINT16_C(   951), UINT16_C( 33560), UINT16_C( 51461), UINT16_C( 32848)),
      simde_x_mm512_set_epu16(UINT16_C( 24022), UINT16_C( 28946), UINT16_C( 31787), UINT16_C( 10344),
                              UINT16_C( 21644), UINT16_C( 32837), UINT16_C( 19136), UINT16_C( 20955),
                              UINT16_C( 38754), UINT16_C( 29762), UINT16_C( 40377), UINT16_C( 40250),
                              UINT16_C( 33483), UINT16_C( 35163), UINT16_C( 51322), UINT16_C( 34077),
                              UINT16_C( 35946), UINT16_C( 29132), UINT16_C( 37333), UINT16_C( 11179),
                              UINT16_C( 34764), UINT16_C( 48181), UINT16_C( 17425), UINT16_C( 37060),
                              UINT16_C( 17279), UINT16_C( 37470), UINT16_C( 20190), UINT16_C( 35739),
                              UINT16_C( 26363), UINT16_C( 36925), UINT16_C( 43910), UINT16_C( 21300)) },
    { simde_x_mm512_set_epu16(UINT16_C( 16482), UINT16_C( 29865), UINT16_C( 43161), UINT16_C( 49292),
                              UINT16_C( 20253), UINT16_C( 46312), UINT16_C( 22868), UINT16_C( 35970),
                              UINT16_C( 27832), UINT16_C( 29779), UINT16_C( 41321), UINT16_C(  4471),
                              UINT16_C(   101), UINT16_C( 26727), UINT16_C( 57916), UINT16_C(  6017),
                              UINT16_C( 36275), UINT16_C( 22385), UINT16_C( 64475), UINT16_C( 27511),
                              UINT16_C( 18089), UINT16_C(  2907), UINT16_C(  6044), UINT16_C( 25380),
                              UINT16_C( 39450), UINT16_C(  6056), UINT16_C(  3173), UINT16_C( 48508),
                              UINT16_C( 39476), UINT16_C( 34432), UINT16_C( 54613), UINT16_C( 48593)),
      simde_x_mm512_set_epu16(UINT16_C(  5403), UINT16_C( 14767), UINT16_C( 48931), UINT16_C( 19205),
                              UINT16_C( 43050), UINT16_C( 50911), UINT16_C( 61409), UINT16_C( 58117),
                              UINT16_C( 21956), UINT16_C( 47259), UINT16_C( 18797), UINT16_C( 33639),
                              UINT16_C( 33691), UINT16_C( 26950), UINT16_C( 42098), UINT16_C( 29396),
                              UINT16_C( 40226), UINT16_C( 56570), UINT16_C( 65251), UINT16_C( 61481),
                              UINT16_C( 53274), UINT16_C( 56708), UINT16_C( 31154), UINT16_C( 56119),
                              UINT16_C( 11598), UINT16_C( 59701), UINT16_C( 22444), UINT16_C( 31379),
                              UINT16_C( 47987), UINT16_C(  5886), UINT16_C(  2522), UINT16_C( 57558)),
      simde_x_mm512_set_epu16(UINT16_C( 10943), UINT16_C( 22316), UINT16_C( 46046), UINT16_C( 34249),
                              UINT16_C( 31652), UINT16_C( 48612), UINT16_C( 42139), UINT16_C( 47044),
                              UINT16_C( 24894), UINT16_C( 38519), UINT16_C( 30059), UINT16_C( 19055),
                              UINT16_C( 16896), UINT16_C( 26839), UINT16_C( 50007), UINT16_C( 17707),
                              UINT16_C( 38251), UINT16_C( 39478), UINT16_C( 64863), UINT16_C( 44496),
                              UINT16_C( 35682), UINT16_C( 29808), UINT16_C( 18599), UINT16_C( 40750),
                              UINT16_C( 25524), UINT16_C( 32879), UINT16_C( 12809), UINT16_C( 39944),
                              UINT16_C( 43732), UINT16_C( 20159), UINT16_C( 28568), UINT16_C( 53076)) },
    { simde_x_mm512_set_epu16(UINT16_C( 34893), UINT16_C( 23679), UINT16_C( 64034), UINT16_C( 46251),
                              UINT16_C(  8048), UINT16_C( 41654), UINT16_C( 61576), UINT16_C( 24661),
                              UINT16_C( 10548), UINT16_C( 15307), UINT16_C( 54631), UINT16_C( 56752),
                              UINT16_C( 25346), UINT16_C(  5558), UINT16_C(  1968), UINT16_C( 32109),
                              UINT16_C( 59890), UINT16_C(  1389), UINT16_C( 18928), UINT16_C( 44824),
                              UINT16_C( 11367), UINT16_C( 52264), UINT16_C( 20085), UINT16_C( 56744),
                              UINT16_C( 49674), UINT16_C(  4067), UINT16_C(  3569), UINT16_C( 23831),
                              UINT16_C(  8020), UINT16_C( 56140), UINT16_C( 13343), UINT16_C(  5815)),
      simde_x_mm512_set_epu16(UINT16_C(    70), UINT16_C( 49524), UINT16_C(  2389), UINT16_C( 48794),
                              UINT16_C(  9656), UINT16_C( 49515), UINT16_C( 20459), UINT16_C(  8573),
                              UINT16_C( 28524), UINT16_C( 25506), UINT16_C( 45011), UINT16_C( 20391),
                              UINT16_C( 42585), UINT16_C(  5514), UINT16_C(  3945), UINT16_C( 49101),
                              UINT16_C(  8826), UINT16_C( 53647), UINT16_C( 55458), UINT16_C( 61374),
                              UINT16_C( 54518), UINT16_C( 64462), UINT16_C( 15696), UINT16_C( 38749),
                              UINT16_C( 14471), UINT16_C( 43272), UINT16_C( 48962), UINT16_C( 15384),
                              UINT16_C( 23964), UINT16_C(  8219), UINT16_C( 12498), UINT16_C( 59146)),
      simde_x_mm512_set_epu16(UINT16_C( 17482), UINT16_C( 36602), UINT16_C( 33212), UINT16_C( 47523),
                              UINT16_C(  8852), UINT16_C( 45585), UINT16_C( 41018), UINT16_C( 16617),
                              UINT16_C( 19536), UINT16_C( 20407), UINT16_C( 49821), UINT16_C( 38572),
                              UINT16_C( 33966), UINT16_C(  5536), UINT16_C(  2957), UINT16_C( 40605),
                              UINT16_C( 34358), UINT16_C( 27518), UINT16_C( 37193), UINT16_C( 53099),
                              UINT16_C( 32943), UINT16_C( 58363), UINT16_C( 17891), UINT16_C( 47747),
                              UINT16_C( 32073), UINT16_C( 23670), UINT16_C( 26266), UINT16_C( 19608),
                              UINT16_C( 15992), UINT16_C( 32180), UINT16_C( 12921), UINT16_C( 32481)) },
    { simde_x_mm512_set_epu16(UINT16_C( 60096), UINT16_C( 60141), UINT16_C(  1401), UINT16_C( 46103),
                              UINT16_C( 12472), UINT16_C( 53354), UINT16_C( 24302), UINT16_C( 31759),
                              UINT16_C( 31691), UINT16_C(  4110), UINT16_C( 33754), UINT16_C( 25522),
                              UINT16_C( 55741), UINT16_C( 54238), UINT16_C(  6937), UINT16_C( 14267),
                              UINT16_C(  6394), UINT16_C( 11471), UINT16_C( 36806), UINT16_C( 29444),
                              UINT16_C(  4686), UINT16_C( 24894), UINT16_C(  9912), UINT16_C( 55420),
                              UINT16_C( 39725), UINT16_C( 16932), UINT16_C(  1814), UINT16_C( 27150),
                              UINT16_C( 14089), UINT16_C( 26760), UINT16_C( 42881), UINT16_C(  1890)),
      simde_x_mm512_set_epu16(UINT16_C(  1052), UINT16_C( 45798), UINT16_C(  2128), UINT16_C( 35449),
                              UINT16_C( 36274), UINT16_C( 38472), UINT16_C( 30996), UINT16_C(  7411),
                              UINT16_C( 65433), UINT16_C( 20087), UINT16_C(  6070), UINT16_C( 34216),
                              UINT16_C( 38017), UINT16_C( 52174), UINT16_C(  6632), UINT16_C( 18268),
                              UINT16_C( 23199), UINT16_C( 50262), UINT16_C( 41833), UINT16_C( 43512),
                              UINT16_C( 43349), UINT16_C( 45458), UINT16_C( 19756), UINT16_C( 38464),
                              UINT16_C( 37153), UINT16_C( 41983), UINT16_C(  8534), UINT16_C(   930),
                              UINT16_C( 61899), UINT16_C(  3423), UINT16_C( 63286), UINT16_C( 18842)),
      simde_x_mm512_set_epu16(UINT16_C( 30574), UINT16_C( 52970), UINT16_C(  1765), UINT16_C( 40776),
                              UINT16_C( 24373), UINT16_C( 45913), UINT16_C( 27649), UINT16_C( 19585),
                              UINT16_C( 48562), UINT16_C( 12099), UINT16_C( 19912), UINT16_C( 29869),
                              UINT16_C( 46879), UINT16_C( 53206), UINT16_C(  6785), UINT16_C( 16268),
                              UINT16_C( 14797), UINT16_C( 30867), UINT16_C( 39320), UINT16_C( 36478),
                              UINT16_C( 24018), UINT16_C( 35176), UINT16_C( 14834), UINT16_C( 46942),
                              UINT16_C( 38439), UINT16_C( 29458), UINT16_C(  5174), UINT16_C( 14040),
                              UINT16_C( 37994), UINT16_C( 15092), UINT16_C( 53084), UINT16_C( 10366)) },
    { simde_x_mm512_set_epu16(UINT16_C( 21390), UINT16_C( 10972), UINT16_C(  9534), UINT16_C( 25326),
                              UINT16_C( 39196), UINT16_C( 52858), UINT16_C( 21878), UINT16_C( 44949),
                              UINT16_C( 56397), UINT16_C(  7489), UINT16_C( 51094), UINT16_C( 21965),
                              UINT16_C( 45995), UINT16_C( 12111), UINT16_C( 47805), UINT16_C(  1368),
                              UINT16_C( 47857), UINT16_C( 52094), UINT16_C( 29749), UINT16_C( 11216),
                              UINT16_C( 36270), UINT16_C( 43041), UINT16_C( 37100), UINT16_C( 23737),
                              UINT16_C( 49684), UINT16_C(  1618), UINT16_C(  4508), UINT16_C( 49414),
                              UINT16_C( 16652), UINT16_C( 21178), UINT16_C(  2342), UINT16_C( 41466)),
      simde_x_mm512_set_epu16(UINT16_C(  2029), UINT16_C( 56235), UINT16_C( 60520), UINT16_C( 21505),
                              UINT16_C( 57936), UINT16_C(  7393), UINT16_C( 48841), UINT16_C( 33423),
                              UINT16_C( 21974), UINT16_C( 41720), UINT16_C( 60540), UINT16_C( 41725),
                              UINT16_C( 29801), UINT16_C( 64766), UINT16_C( 10276), UINT16_C( 10419),
                              UINT16_C( 29113), UINT16_C(  9717), UINT16_C( 10502), UINT16_C( 53810),
                              UINT16_C( 21215), UINT16_C( 51746), UINT16_C( 31756), UINT16_C( 40043),
                              UINT16_C( 19421), UINT16_C( 27841), UINT16_C(  1136), UINT16_C( 29043),
                              UINT16_C( 64035), UINT16_C( 41226), UINT16_C( 38869), UINT16_C( 32769)),
      simde_x_mm512_set_epu16(UINT16_C( 11710), UINT16_C( 33604), UINT16_C( 35027), UINT16_C( 23416),
                              UINT16_C( 48566), UINT16_C( 30126), UINT16_C( 35360), UINT16_C( 39186),
                              UINT16_C( 39186), UINT16_C( 24605), UINT16_C( 55817), UINT16_C( 31845),
                              UINT16_C( 37898), UINT16_C( 38439), UINT16_C( 29041), UINT16_C(  5894),
                              UINT16_C( 38485), UINT16_C( 30906), UINT16_C( 20126), UINT16_C( 32513),
                              UINT16_C( 28743), UINT16_C( 47394), UINT16_C( 34428), UINT16_C( 31890),
                              UINT16_C( 34553), UINT16_C( 14730), UINT16_C(  2822), UINT16_C( 39229),
                              UINT16_C( 40344), UINT16_C( 31202), UINT16_C( 20606), UINT16_C( 37118)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_avg_epu16(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u16(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_broadcastb_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m128i a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm_set_epi8(INT8_C( -17), INT8_C(  88), INT8_C(-122), INT8_C(-119),
                        INT8_C( 111), INT8_C(  87), INT8_C( -76), INT8_C(  27),
                        INT8_C( -93), INT8_C(  -8), INT8_C( -17), INT8_C(  24),
                        INT8_C(  69), INT8_C( 116), INT8_C( -78), INT8_C(-124)),
      simde_mm512_set_epi8(INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124)) },
    { simde_mm_set_epi8(INT8_C(  -5), INT8_C(-114), INT8_C( -86), INT8_C(  -2),
                        INT8_C(  33), INT8_C(  90), INT8_C( -50), INT8_C(  28),
                        INT8_C(  15), INT8_C(  12), INT8_C(  32), INT8_C(  54),
                        INT8_C( -15), INT8_C( -57), INT8_C(  36), INT8_C( -50)),
      simde_mm512_set_epi8(INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50)) },
    { simde_mm_set_epi8(INT8_C( -49), INT8_C( -76), INT8_C( -62), INT8_C( 118),
                        INT8_C(  -4), INT8_C( -25), INT8_C( -58), INT8_C( 126),
                        INT8_C(-115), INT8_C( 126), INT8_C(-104), INT8_C( 127),
                        INT8_C(  15), INT8_C(  41), INT8_C(  68), INT8_C(  31)),
      simde_mm512_set_epi8(INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31)) },
    { simde_mm_set_epi8(INT8_C( -30), INT8_C( -23), INT8_C( -42), INT8_C( -27),
                        INT8_C(-102), INT8_C(  -5), INT8_C( -87), INT8_C(  98),
                        INT8_C(  33), INT8_C(  73), INT8_C( 125), INT8_C( 120),
                        INT8_C( -70), INT8_C(  59), INT8_C( 124), INT8_C(  46)),
      simde_mm512_set_epi8(INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46)) },
    { simde_mm_set_epi8(INT8_C( -18), INT8_C(  28), INT8_C( -19), INT8_C( -73),
                        INT8_C( -19), INT8_C(  67), INT8_C(  79), INT8_C( -45),
                        INT8_C(-124), INT8_C(  80), INT8_C(-101), INT8_C(-122),
                        INT8_C( -54), INT8_C(  30), INT8_C( -16), INT8_C(  55)),
      simde_mm512_set_epi8(INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55)) },
    { simde_mm_set_epi8(INT8_C(   6), INT8_C(  -5), INT8_C(  37), INT8_C( -97),
                        INT8_C(  16), INT8_C(  -5), INT8_C( -18), INT8_C(  14),
                        INT8_C(-120), INT8_C( -59), INT8_C( -43), INT8_C( -97),
                        INT8_C( -71), INT8_C( -73), INT8_C( -73), INT8_C( -50)),
      simde_mm512_set_epi8(INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50)) },
    { simde_mm_set_epi8(INT8_C( 119), INT8_C(  60), INT8_C(  63), INT8_C( -26),
                        INT8_C(  50), INT8_C(  56), INT8_C(  40), INT8_C(  -7),
                        INT8_C(  68), INT8_C( -11), INT8_C( -21), INT8_C( -77),
                        INT8_C(  56), INT8_C(-109), INT8_C(-118), INT8_C(-108)),
      simde_mm512_set_epi8(INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108)) },
    { simde_mm_set_epi8(INT8_C(-112), INT8_C(  65), INT8_C(  26), INT8_C( -90),
                        INT8_C( -77), INT8_C(  72), INT8_C(   2), INT8_C(   4),
                        INT8_C( -52), INT8_C( -82), INT8_C( -18), INT8_C( -66),
                        INT8_C(-118), INT8_C( -10), INT8_C(  52), INT8_C( -40)),
      simde_mm512_set_epi8(INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_broadcastb_epi8(test_vec[i].a);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_broadcastb_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m128i a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  65), INT8_C( -68), INT8_C( 102), INT8_C(-122),
                           INT8_C(  40), INT8_C(  19), INT8_C(-111), INT8_C(   8),
                           INT8_C( -58), INT8_C(-120), INT8_C( 111), INT8_C(  10),
                           INT8_C( -54), INT8_C(-100), INT8_C(  36), INT8_C(  27),
                           INT8_C(-106), INT8_C(-123), INT8_C( 120), INT8_C(  43),
                           INT8_C( -31), INT8_C(   4), INT8_C(  10), INT8_C(  96),
                           INT8_C( -40), INT8_C(  23), INT8_C(  31), INT8_C(  73),
                           INT8_C( -51), INT8_C(  91), INT8_C(  68), INT8_C( -23),
                           INT8_C(-108), INT8_C(  52), INT8_C(  23), INT8_C( 115),
                           INT8_C(  -4), INT8_C(  24), INT8_C( 106), INT8_C( -92),
                           INT8_C( 126), INT8_C(  -6), INT8_C(  16), INT8_C( 102),
                           INT8_C( -47), INT8_C(-116), INT8_C(  -4), INT8_C(  33),
                           INT8_C( -25), INT8_C(-108), INT8_C(-115), INT8_C(-104),
                           INT8_C( -39), INT8_C(  49), INT8_C(  72), INT8_C(  44),
                           INT8_C( -17), INT8_C( -66), INT8_C( -61), INT8_C( -68),
                           INT8_C( 124), INT8_C(  20), INT8_C(  64), INT8_C( -49)),
      UINT64_C(          2970261907),
      simde_mm_set_epi8(INT8_C( -78), INT8_C( -60), INT8_C(-122), INT8_C( -66),
                        INT8_C(   8), INT8_C( -42), INT8_C(  44), INT8_C(  45),
                        INT8_C(  37), INT8_C(  -9), INT8_C( -14), INT8_C(  38),
                        INT8_C( -85), INT8_C(  35), INT8_C(   8), INT8_C(-127)),
      simde_mm512_set_epi8(INT8_C(  65), INT8_C( -68), INT8_C( 102), INT8_C(-122),
                           INT8_C(  40), INT8_C(  19), INT8_C(-111), INT8_C(   8),
                           INT8_C( -58), INT8_C(-120), INT8_C( 111), INT8_C(  10),
                           INT8_C( -54), INT8_C(-100), INT8_C(  36), INT8_C(  27),
                           INT8_C(-106), INT8_C(-123), INT8_C( 120), INT8_C(  43),
                           INT8_C( -31), INT8_C(   4), INT8_C(  10), INT8_C(  96),
                           INT8_C( -40), INT8_C(  23), INT8_C(  31), INT8_C(  73),
                           INT8_C( -51), INT8_C(  91), INT8_C(  68), INT8_C( -23),
                           INT8_C(-127), INT8_C(  52), INT8_C(-127), INT8_C(-127),
                           INT8_C(  -4), INT8_C(  24), INT8_C( 106), INT8_C(-127),
                           INT8_C( 126), INT8_C(  -6), INT8_C(  16), INT8_C( 102),
                           INT8_C(-127), INT8_C(-116), INT8_C(-127), INT8_C(  33),
                           INT8_C(-127), INT8_C(-108), INT8_C(-115), INT8_C(-127),
                           INT8_C(-127), INT8_C(  49), INT8_C(  72), INT8_C(-127),
                           INT8_C(-127), INT8_C( -66), INT8_C( -61), INT8_C(-127),
                           INT8_C( 124), INT8_C(  20), INT8_C(-127), INT8_C(-127)) },
    { simde_mm512_set_epi8(INT8_C( -76), INT8_C(  58), INT8_C(  70), INT8_C(-106),
                           INT8_C( 120), INT8_C(  72), INT8_C(  -4), INT8_C( -60),
                           INT8_C( 104), INT8_C( 101), INT8_C(  53), INT8_C(-121),
                           INT8_C( 102), INT8_C(-115), INT8_C(  90), INT8_C(  31),
                           INT8_C(  11), INT8_C(  68), INT8_C(  48), INT8_C(   4),
                           INT8_C(  55), INT8_C( -83), INT8_C(  75), INT8_C( -60),
                           INT8_C( -54), INT8_C(  57), INT8_C(  70), INT8_C(-114),
                           INT8_C(  51), INT8_C( -72), INT8_C( -71), INT8_C(  17),
                           INT8_C(  48), INT8_C(  40), INT8_C(-108), INT8_C( -12),
                           INT8_C( -11), INT8_C( -71), INT8_C(-114), INT8_C( -36),
                           INT8_C( -92), INT8_C( 101), INT8_C(  30), INT8_C(  10),
                           INT8_C(  43), INT8_C(-116), INT8_C( -45), INT8_C(-104),
                           INT8_C(  99), INT8_C( 108), INT8_C(  90), INT8_C(   7),
                           INT8_C( 112), INT8_C(  86), INT8_C(-125), INT8_C(  88),
                           INT8_C(  27), INT8_C(  40), INT8_C(  10), INT8_C(-105),
                           INT8_C(  76), INT8_C(-101), INT8_C(  87), INT8_C( 112)),
      UINT64_C(           458960523),
      simde_mm_set_epi8(INT8_C(  70), INT8_C( -73), INT8_C( -42), INT8_C( -19),
                        INT8_C( 110), INT8_C( -58), INT8_C(-117), INT8_C(-100),
                        INT8_C(  52), INT8_C( -63), INT8_C( -88), INT8_C( -55),
                        INT8_C(  90), INT8_C( -15), INT8_C( -11), INT8_C( -21)),
      simde_mm512_set_epi8(INT8_C( -76), INT8_C(  58), INT8_C(  70), INT8_C(-106),
                           INT8_C( 120), INT8_C(  72), INT8_C(  -4), INT8_C( -60),
                           INT8_C( 104), INT8_C( 101), INT8_C(  53), INT8_C(-121),
                           INT8_C( 102), INT8_C(-115), INT8_C(  90), INT8_C(  31),
                           INT8_C(  11), INT8_C(  68), INT8_C(  48), INT8_C(   4),
                           INT8_C(  55), INT8_C( -83), INT8_C(  75), INT8_C( -60),
                           INT8_C( -54), INT8_C(  57), INT8_C(  70), INT8_C(-114),
                           INT8_C(  51), INT8_C( -72), INT8_C( -71), INT8_C(  17),
                           INT8_C(  48), INT8_C(  40), INT8_C(-108), INT8_C( -21),
                           INT8_C( -21), INT8_C( -71), INT8_C( -21), INT8_C( -21),
                           INT8_C( -92), INT8_C( -21), INT8_C(  30), INT8_C( -21),
                           INT8_C( -21), INT8_C(-116), INT8_C( -21), INT8_C( -21),
                           INT8_C(  99), INT8_C( 108), INT8_C( -21), INT8_C(   7),
                           INT8_C( -21), INT8_C( -21), INT8_C( -21), INT8_C(  88),
                           INT8_C( -21), INT8_C(  40), INT8_C(  10), INT8_C(-105),
                           INT8_C( -21), INT8_C(-101), INT8_C( -21), INT8_C( -21)) },
    { simde_mm512_set_epi8(INT8_C( -65), INT8_C(  -9), INT8_C( -93), INT8_C(-113),
                           INT8_C( -10), INT8_C(  74), INT8_C(  39), INT8_C(  57),
                           INT8_C(  91), INT8_C( -48), INT8_C(  11), INT8_C( -15),
                           INT8_C(  21), INT8_C( -88), INT8_C(  91), INT8_C(  87),
                           INT8_C(-120), INT8_C(-105), INT8_C( -47), INT8_C(  85),
                           INT8_C( -98), INT8_C(  22), INT8_C(-124), INT8_C(-124),
                           INT8_C(   2), INT8_C(-104), INT8_C(  27), INT8_C(  96),
                           INT8_C( -89), INT8_C(  31), INT8_C(  20), INT8_C(  31),
                           INT8_C( -95), INT8_C(  13), INT8_C(  37), INT8_C(  31),
                           INT8_C( -72), INT8_C(  83), INT8_C(  94), INT8_C(  52),
                           INT8_C(  41), INT8_C(  25), INT8_C( -42), INT8_C(-109),
                           INT8_C(  31), INT8_C(  88), INT8_C( -71), INT8_C( -89),
                           INT8_C( 103), INT8_C( -85), INT8_C( -29), INT8_C(  86),
                           INT8_C(  71), INT8_C(  28), INT8_C( -23), INT8_C(  28),
                           INT8_C( -53), INT8_C( -82), INT8_C(  58), INT8_C( -12),
                           INT8_C(  63), INT8_C(  39), INT8_C( -32), INT8_C( -94)),
      UINT64_C(          1058428392),
      simde_mm_set_epi8(INT8_C(  85), INT8_C( -11), INT8_C( -21), INT8_C(  66),
                        INT8_C(  72), INT8_C(  -7), INT8_C( -18), INT8_C(-121),
                        INT8_C(  56), INT8_C(  51), INT8_C( 101), INT8_C(  91),
                        INT8_C( -85), INT8_C( -32), INT8_C( -40), INT8_C( -81)),
      simde_mm512_set_epi8(INT8_C( -65), INT8_C(  -9), INT8_C( -93), INT8_C(-113),
                           INT8_C( -10), INT8_C(  74), INT8_C(  39), INT8_C(  57),
                           INT8_C(  91), INT8_C( -48), INT8_C(  11), INT8_C( -15),
                           INT8_C(  21), INT8_C( -88), INT8_C(  91), INT8_C(  87),
                           INT8_C(-120), INT8_C(-105), INT8_C( -47), INT8_C(  85),
                           INT8_C( -98), INT8_C(  22), INT8_C(-124), INT8_C(-124),
                           INT8_C(   2), INT8_C(-104), INT8_C(  27), INT8_C(  96),
                           INT8_C( -89), INT8_C(  31), INT8_C(  20), INT8_C(  31),
                           INT8_C( -95), INT8_C(  13), INT8_C( -81), INT8_C( -81),
                           INT8_C( -81), INT8_C( -81), INT8_C( -81), INT8_C( -81),
                           INT8_C(  41), INT8_C(  25), INT8_C( -42), INT8_C( -81),
                           INT8_C(  31), INT8_C( -81), INT8_C( -81), INT8_C( -89),
                           INT8_C( 103), INT8_C( -81), INT8_C( -29), INT8_C( -81),
                           INT8_C(  71), INT8_C( -81), INT8_C( -23), INT8_C( -81),
                           INT8_C( -81), INT8_C( -81), INT8_C( -81), INT8_C( -12),
                           INT8_C( -81), INT8_C(  39), INT8_C( -32), INT8_C( -94)) },
    { simde_mm512_set_epi8(INT8_C(  85), INT8_C(  18), INT8_C(-117), INT8_C( -50),
                           INT8_C(  -8), INT8_C( 126), INT8_C( 103), INT8_C( -42),
                           INT8_C( 107), INT8_C( -60), INT8_C( -85), INT8_C( 123),
                           INT8_C( -11), INT8_C(  41), INT8_C(  98), INT8_C( 115),
                           INT8_C(  14), INT8_C(  34), INT8_C(  89), INT8_C( 101),
                           INT8_C(  39), INT8_C(  26), INT8_C( 121), INT8_C(  70),
                           INT8_C( -20), INT8_C( -34), INT8_C( -11), INT8_C(  72),
                           INT8_C(   8), INT8_C( -24), INT8_C(-104), INT8_C(  61),
                           INT8_C(-108), INT8_C( -43), INT8_C( 102), INT8_C( 100),
                           INT8_C( -29), INT8_C( -21), INT8_C(  70), INT8_C( -28),
                           INT8_C( -21), INT8_C( -82), INT8_C( -18), INT8_C(   9),
                           INT8_C(  94), INT8_C( -32), INT8_C(  97), INT8_C( -86),
                           INT8_C(  87), INT8_C(  62), INT8_C(-118), INT8_C(  17),
                           INT8_C(  18), INT8_C(-126), INT8_C(  74), INT8_C( -83),
                           INT8_C( -46), INT8_C(-103), INT8_C( -21), INT8_C( 108),
                           INT8_C( -58), INT8_C(-126), INT8_C( -28), INT8_C(-112)),
      UINT64_C(           923153287),
      simde_mm_set_epi8(INT8_C(  73), INT8_C( -73), INT8_C( -11), INT8_C(  36),
                        INT8_C( -17), INT8_C(  70), INT8_C(-102), INT8_C(-111),
                        INT8_C(  27), INT8_C( -97), INT8_C(  -6), INT8_C(  -7),
                        INT8_C(  28), INT8_C( -52), INT8_C( -54), INT8_C( -50)),
      simde_mm512_set_epi8(INT8_C(  85), INT8_C(  18), INT8_C(-117), INT8_C( -50),
                           INT8_C(  -8), INT8_C( 126), INT8_C( 103), INT8_C( -42),
                           INT8_C( 107), INT8_C( -60), INT8_C( -85), INT8_C( 123),
                           INT8_C( -11), INT8_C(  41), INT8_C(  98), INT8_C( 115),
                           INT8_C(  14), INT8_C(  34), INT8_C(  89), INT8_C( 101),
                           INT8_C(  39), INT8_C(  26), INT8_C( 121), INT8_C(  70),
                           INT8_C( -20), INT8_C( -34), INT8_C( -11), INT8_C(  72),
                           INT8_C(   8), INT8_C( -24), INT8_C(-104), INT8_C(  61),
                           INT8_C(-108), INT8_C( -43), INT8_C( -50), INT8_C( -50),
                           INT8_C( -29), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -21), INT8_C( -82), INT8_C( -18), INT8_C(   9),
                           INT8_C(  94), INT8_C( -50), INT8_C( -50), INT8_C( -86),
                           INT8_C(  87), INT8_C(  62), INT8_C( -50), INT8_C( -50),
                           INT8_C(  18), INT8_C(-126), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C(-103), INT8_C( -21), INT8_C( 108),
                           INT8_C( -58), INT8_C( -50), INT8_C( -50), INT8_C( -50)) },
    { simde_mm512_set_epi8(INT8_C(  67), INT8_C(-107), INT8_C(  82), INT8_C(  55),
                           INT8_C(  64), INT8_C(  72), INT8_C( -53), INT8_C(  66),
                           INT8_C( -50), INT8_C( 103), INT8_C( -13), INT8_C(  78),
                           INT8_C(  15), INT8_C(  32), INT8_C(  76), INT8_C(  78),
                           INT8_C(  28), INT8_C( -98), INT8_C(-128), INT8_C(  80),
                           INT8_C( 106), INT8_C( -45), INT8_C(  79), INT8_C( 116),
                           INT8_C(  23), INT8_C(  31), INT8_C( 117), INT8_C( -12),
                           INT8_C( -59), INT8_C( -16), INT8_C(  98), INT8_C( -49),
                           INT8_C( 116), INT8_C( -82), INT8_C(  92), INT8_C(   1),
                           INT8_C(  30), INT8_C(-100), INT8_C(  61), INT8_C( -14),
                           INT8_C(  26), INT8_C( -40), INT8_C( -78), INT8_C( -85),
                           INT8_C( -24), INT8_C( -47), INT8_C( -93), INT8_C(  -1),
                           INT8_C(  21), INT8_C(  82), INT8_C( 119), INT8_C(  64),
                           INT8_C(  74), INT8_C( -53), INT8_C(  58), INT8_C(  33),
                           INT8_C(  14), INT8_C( 114), INT8_C(  35), INT8_C( 109),
                           INT8_C( -74), INT8_C( -59), INT8_C( -81), INT8_C(  16)),
      UINT64_C(           594368556),
      simde_mm_set_epi8(INT8_C(  26), INT8_C( -78), INT8_C(  32), INT8_C(  10),
                        INT8_C(-126), INT8_C(  64), INT8_C(  35), INT8_C( -54),
                        INT8_C( -42), INT8_C( -70), INT8_C( 114), INT8_C( 111),
                        INT8_C( 111), INT8_C(  11), INT8_C( 104), INT8_C(  39)),
      simde_mm512_set_epi8(INT8_C(  67), INT8_C(-107), INT8_C(  82), INT8_C(  55),
                           INT8_C(  64), INT8_C(  72), INT8_C( -53), INT8_C(  66),
                           INT8_C( -50), INT8_C( 103), INT8_C( -13), INT8_C(  78),
                           INT8_C(  15), INT8_C(  32), INT8_C(  76), INT8_C(  78),
                           INT8_C(  28), INT8_C( -98), INT8_C(-128), INT8_C(  80),
                           INT8_C( 106), INT8_C( -45), INT8_C(  79), INT8_C( 116),
                           INT8_C(  23), INT8_C(  31), INT8_C( 117), INT8_C( -12),
                           INT8_C( -59), INT8_C( -16), INT8_C(  98), INT8_C( -49),
                           INT8_C( 116), INT8_C( -82), INT8_C(  39), INT8_C(   1),
                           INT8_C(  30), INT8_C(-100), INT8_C(  39), INT8_C(  39),
                           INT8_C(  26), INT8_C(  39), INT8_C(  39), INT8_C( -85),
                           INT8_C(  39), INT8_C(  39), INT8_C( -93), INT8_C(  39),
                           INT8_C(  21), INT8_C(  39), INT8_C( 119), INT8_C(  39),
                           INT8_C(  39), INT8_C( -53), INT8_C(  58), INT8_C(  33),
                           INT8_C(  14), INT8_C( 114), INT8_C(  39), INT8_C( 109),
                           INT8_C(  39), INT8_C(  39), INT8_C( -81), INT8_C(  16)) },
    { simde_mm512_set_epi8(INT8_C( 124), INT8_C(  71), INT8_C(-128), INT8_C( 110),
                           INT8_C(-123), INT8_C( -14), INT8_C( 123), INT8_C( -42),
                           INT8_C(  94), INT8_C(  60), INT8_C( 116), INT8_C( -89),
                           INT8_C(  73), INT8_C( -61), INT8_C(  -3), INT8_C(-114),
                           INT8_C( -92), INT8_C( -78), INT8_C(  90), INT8_C(  44),
                           INT8_C( -84), INT8_C( -33), INT8_C( 116), INT8_C(  -6),
                           INT8_C( -44), INT8_C( 126), INT8_C( -26), INT8_C(  80),
                           INT8_C( -91), INT8_C(-125), INT8_C(  72), INT8_C(  -8),
                           INT8_C( -16), INT8_C(  95), INT8_C( -25), INT8_C( -16),
                           INT8_C( -52), INT8_C( 116), INT8_C( -23), INT8_C(-102),
                           INT8_C( 119), INT8_C( -76), INT8_C(  48), INT8_C(  26),
                           INT8_C(-128), INT8_C(  43), INT8_C(  99), INT8_C( -34),
                           INT8_C(-103), INT8_C( -40), INT8_C(  47), INT8_C(-112),
                           INT8_C(-117), INT8_C( 111), INT8_C(-126), INT8_C(-115),
                           INT8_C(  65), INT8_C( -55), INT8_C(  49), INT8_C(  37),
                           INT8_C(-110), INT8_C(-124), INT8_C( 126), INT8_C(  -2)),
      UINT64_C(          1610616610),
      simde_mm_set_epi8(INT8_C( -95), INT8_C(  29), INT8_C( -58), INT8_C( -87),
                        INT8_C(  73), INT8_C(  12), INT8_C( -29), INT8_C(  41),
                        INT8_C( -96), INT8_C( 122), INT8_C( -95), INT8_C( -33),
                        INT8_C(-128), INT8_C(   2), INT8_C( 115), INT8_C( 108)),
      simde_mm512_set_epi8(INT8_C( 124), INT8_C(  71), INT8_C(-128), INT8_C( 110),
                           INT8_C(-123), INT8_C( -14), INT8_C( 123), INT8_C( -42),
                           INT8_C(  94), INT8_C(  60), INT8_C( 116), INT8_C( -89),
                           INT8_C(  73), INT8_C( -61), INT8_C(  -3), INT8_C(-114),
                           INT8_C( -92), INT8_C( -78), INT8_C(  90), INT8_C(  44),
                           INT8_C( -84), INT8_C( -33), INT8_C( 116), INT8_C(  -6),
                           INT8_C( -44), INT8_C( 126), INT8_C( -26), INT8_C(  80),
                           INT8_C( -91), INT8_C(-125), INT8_C(  72), INT8_C(  -8),
                           INT8_C( -16), INT8_C( 108), INT8_C( 108), INT8_C( -16),
                           INT8_C( -52), INT8_C( 116), INT8_C( -23), INT8_C(-102),
                           INT8_C( 119), INT8_C( -76), INT8_C(  48), INT8_C(  26),
                           INT8_C(-128), INT8_C(  43), INT8_C(  99), INT8_C( -34),
                           INT8_C(-103), INT8_C( -40), INT8_C(  47), INT8_C(-112),
                           INT8_C( 108), INT8_C( 108), INT8_C( 108), INT8_C( 108),
                           INT8_C(  65), INT8_C( -55), INT8_C( 108), INT8_C(  37),
                           INT8_C(-110), INT8_C(-124), INT8_C( 108), INT8_C(  -2)) },
    { simde_mm512_set_epi8(INT8_C(  73), INT8_C( -95), INT8_C( -44), INT8_C( 123),
                           INT8_C( -34), INT8_C(-122), INT8_C( 105), INT8_C( -63),
                           INT8_C( -13), INT8_C( -78), INT8_C(  -7), INT8_C(  88),
                           INT8_C(-101), INT8_C(  60), INT8_C(  29), INT8_C( -15),
                           INT8_C(  87), INT8_C( -77), INT8_C(  65), INT8_C(  71),
                           INT8_C( 113), INT8_C(-124), INT8_C( -41), INT8_C( -18),
                           INT8_C(  37), INT8_C( -20), INT8_C( 112), INT8_C(  70),
                           INT8_C(  36), INT8_C( -80), INT8_C( 122), INT8_C( -28),
                           INT8_C( -45), INT8_C(-113), INT8_C(  68), INT8_C(  23),
                           INT8_C(  84), INT8_C(  56), INT8_C( -44), INT8_C( -61),
                           INT8_C( -78), INT8_C(   6), INT8_C(-108), INT8_C(  73),
                           INT8_C( -22), INT8_C( -71), INT8_C(   1), INT8_C(   7),
                           INT8_C(  47), INT8_C(  18), INT8_C(-127), INT8_C( 127),
                           INT8_C( -16), INT8_C( -48), INT8_C( -39), INT8_C( 106),
                           INT8_C(  27), INT8_C(  40), INT8_C( -58), INT8_C( -56),
                           INT8_C( -27), INT8_C(  17), INT8_C(  29), INT8_C( -46)),
      UINT64_C(          2168160586),
      simde_mm_set_epi8(INT8_C(  45), INT8_C(  89), INT8_C( -40), INT8_C(  94),
                        INT8_C( -55), INT8_C( -34), INT8_C(-119), INT8_C(-109),
                        INT8_C(   3), INT8_C(-117), INT8_C(-101), INT8_C(  63),
                        INT8_C( 122), INT8_C(  -4), INT8_C(-100), INT8_C( -84)),
      simde_mm512_set_epi8(INT8_C(  73), INT8_C( -95), INT8_C( -44), INT8_C( 123),
                           INT8_C( -34), INT8_C(-122), INT8_C( 105), INT8_C( -63),
                           INT8_C( -13), INT8_C( -78), INT8_C(  -7), INT8_C(  88),
                           INT8_C(-101), INT8_C(  60), INT8_C(  29), INT8_C( -15),
                           INT8_C(  87), INT8_C( -77), INT8_C(  65), INT8_C(  71),
                           INT8_C( 113), INT8_C(-124), INT8_C( -41), INT8_C( -18),
                           INT8_C(  37), INT8_C( -20), INT8_C( 112), INT8_C(  70),
                           INT8_C(  36), INT8_C( -80), INT8_C( 122), INT8_C( -28),
                           INT8_C( -84), INT8_C(-113), INT8_C(  68), INT8_C(  23),
                           INT8_C(  84), INT8_C(  56), INT8_C( -44), INT8_C( -84),
                           INT8_C( -78), INT8_C(   6), INT8_C( -84), INT8_C( -84),
                           INT8_C( -84), INT8_C( -71), INT8_C( -84), INT8_C( -84),
                           INT8_C( -84), INT8_C(  18), INT8_C(-127), INT8_C( 127),
                           INT8_C( -16), INT8_C( -48), INT8_C( -39), INT8_C( -84),
                           INT8_C(  27), INT8_C( -84), INT8_C( -58), INT8_C( -56),
                           INT8_C( -84), INT8_C(  17), INT8_C( -84), INT8_C( -46)) },
    { simde_mm512_set_epi8(INT8_C(  38), INT8_C( -12), INT8_C( -37), INT8_C(  58),
                           INT8_C(  89), INT8_C(-127), INT8_C( -11), INT8_C(  26),
                           INT8_C( -29), INT8_C(-122), INT8_C(  86), INT8_C(  69),
                           INT8_C(  63), INT8_C(  74), INT8_C(  90), INT8_C(  88),
                           INT8_C( -75), INT8_C( -43), INT8_C(  36), INT8_C(  61),
                           INT8_C( -19), INT8_C(  27), INT8_C(-123), INT8_C(  78),
                           INT8_C(  67), INT8_C(  58), INT8_C( -32), INT8_C(  42),
                           INT8_C(  25), INT8_C( -26), INT8_C( 122), INT8_C(-100),
                           INT8_C(-107), INT8_C( -53), INT8_C(-114), INT8_C(  63),
                           INT8_C(-100), INT8_C(  53), INT8_C( -32), INT8_C( -39),
                           INT8_C( -75), INT8_C(-119), INT8_C( -67), INT8_C(  96),
                           INT8_C(  -6), INT8_C( -22), INT8_C( -12), INT8_C(  19),
                           INT8_C( -51), INT8_C(  42), INT8_C(  39), INT8_C(-124),
                           INT8_C(  38), INT8_C( -95), INT8_C(-119), INT8_C(  -9),
                           INT8_C(  94), INT8_C( -51), INT8_C(   1), INT8_C( -64),
                           INT8_C( -67), INT8_C(-127), INT8_C( -33), INT8_C(  75)),
      UINT64_C(          3579095368),
      simde_mm_set_epi8(INT8_C( -71), INT8_C(-112), INT8_C(-122), INT8_C( -13),
                        INT8_C(-109), INT8_C(  21), INT8_C(  27), INT8_C(-109),
                        INT8_C(  55), INT8_C(   9), INT8_C( 117), INT8_C( -28),
                        INT8_C( -58), INT8_C(  -1), INT8_C(   3), INT8_C( -34)),
      simde_mm512_set_epi8(INT8_C(  38), INT8_C( -12), INT8_C( -37), INT8_C(  58),
                           INT8_C(  89), INT8_C(-127), INT8_C( -11), INT8_C(  26),
                           INT8_C( -29), INT8_C(-122), INT8_C(  86), INT8_C(  69),
                           INT8_C(  63), INT8_C(  74), INT8_C(  90), INT8_C(  88),
                           INT8_C( -75), INT8_C( -43), INT8_C(  36), INT8_C(  61),
                           INT8_C( -19), INT8_C(  27), INT8_C(-123), INT8_C(  78),
                           INT8_C(  67), INT8_C(  58), INT8_C( -32), INT8_C(  42),
                           INT8_C(  25), INT8_C( -26), INT8_C( 122), INT8_C(-100),
                           INT8_C( -34), INT8_C( -34), INT8_C(-114), INT8_C( -34),
                           INT8_C(-100), INT8_C( -34), INT8_C( -32), INT8_C( -34),
                           INT8_C( -75), INT8_C( -34), INT8_C( -67), INT8_C( -34),
                           INT8_C(  -6), INT8_C( -34), INT8_C( -12), INT8_C(  19),
                           INT8_C( -34), INT8_C(  42), INT8_C( -34), INT8_C(-124),
                           INT8_C( -34), INT8_C( -95), INT8_C(-119), INT8_C( -34),
                           INT8_C(  94), INT8_C( -34), INT8_C(   1), INT8_C( -64),
                           INT8_C( -34), INT8_C(-127), INT8_C( -33), INT8_C(  75)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_broadcastb_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_maskz_broadcastb_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask64 k;
    simde__m128i a;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C(          2081702095),
      simde_mm_set_epi8(INT8_C( 126), INT8_C(  -6), INT8_C(  16), INT8_C( 102),
                        INT8_C( -47), INT8_C(-116), INT8_C(  -4), INT8_C(  33),
                        INT8_C( -25), INT8_C(-108), INT8_C(-115), INT8_C(-104),
                        INT8_C( -39), INT8_C(  49), INT8_C(  72), INT8_C(  44)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  44), INT8_C(  44), INT8_C(  44),
                           INT8_C(  44), INT8_C(  44), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  44),
                           INT8_C(   0), INT8_C(  44), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  44), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  44), INT8_C(  44), INT8_C(   0), INT8_C(   0),
                           INT8_C(  44), INT8_C(  44), INT8_C(  44), INT8_C(  44)) },
    { UINT64_C(          4229458596),
      simde_mm_set_epi8(INT8_C(-106), INT8_C(-123), INT8_C( 120), INT8_C(  43),
                        INT8_C( -31), INT8_C(   4), INT8_C(  10), INT8_C(  96),
                        INT8_C( -40), INT8_C(  23), INT8_C(  31), INT8_C(  73),
                        INT8_C( -51), INT8_C(  91), INT8_C(  68), INT8_C( -23)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -23), INT8_C( -23), INT8_C( -23), INT8_C( -23),
                           INT8_C( -23), INT8_C( -23), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -23),
                           INT8_C( -23), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -23), INT8_C( -23), INT8_C(   0),
                           INT8_C( -23), INT8_C(   0), INT8_C( -23), INT8_C(   0),
                           INT8_C( -23), INT8_C(   0), INT8_C( -23), INT8_C(   0),
                           INT8_C(   0), INT8_C( -23), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(          3399230491),
      simde_mm_set_epi8(INT8_C( -40), INT8_C( -29), INT8_C(  78), INT8_C(  94),
                        INT8_C( -79), INT8_C(  10), INT8_C(-103), INT8_C(-109),
                        INT8_C(  65), INT8_C( -68), INT8_C( 102), INT8_C(-122),
                        INT8_C(  40), INT8_C(  19), INT8_C(-111), INT8_C(   8)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   8), INT8_C(   8), INT8_C(   0), INT8_C(   0),
                           INT8_C(   8), INT8_C(   0), INT8_C(   8), INT8_C(   0),
                           INT8_C(   8), INT8_C(   0), INT8_C(   0), INT8_C(   8),
                           INT8_C(   8), INT8_C(   8), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   8), INT8_C(   0),
                           INT8_C(   0), INT8_C(   8), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   8),
                           INT8_C(   8), INT8_C(   0), INT8_C(   8), INT8_C(   8)) },
    { UINT64_C(          2871199873),
      simde_mm_set_epi8(INT8_C(  27), INT8_C(  40), INT8_C(  10), INT8_C(-105),
                        INT8_C(  76), INT8_C(-101), INT8_C(  87), INT8_C( 112),
                        INT8_C( -78), INT8_C( -60), INT8_C(-122), INT8_C( -66),
                        INT8_C(   8), INT8_C( -42), INT8_C(  44), INT8_C(  45)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  45), INT8_C(   0), INT8_C(  45), INT8_C(   0),
                           INT8_C(  45), INT8_C(   0), INT8_C(  45), INT8_C(  45),
                           INT8_C(   0), INT8_C(   0), INT8_C(  45), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  45), INT8_C(  45),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  45), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  45), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  45)) },
    { UINT64_C(          1884717912),
      simde_mm_set_epi8(INT8_C(  48), INT8_C(  40), INT8_C(-108), INT8_C( -12),
                        INT8_C( -11), INT8_C( -71), INT8_C(-114), INT8_C( -36),
                        INT8_C( -92), INT8_C( 101), INT8_C(  30), INT8_C(  10),
                        INT8_C(  43), INT8_C(-116), INT8_C( -45), INT8_C(-104)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-104), INT8_C(-104), INT8_C(-104),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-104), INT8_C(   0), INT8_C(-104),
                           INT8_C(   0), INT8_C(-104), INT8_C(-104), INT8_C(   0),
                           INT8_C(-104), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(-104), INT8_C(-104),
                           INT8_C(   0), INT8_C(-104), INT8_C(   0), INT8_C(-104),
                           INT8_C(-104), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(           867744017),
      simde_mm_set_epi8(INT8_C( 104), INT8_C( 101), INT8_C(  53), INT8_C(-121),
                        INT8_C( 102), INT8_C(-115), INT8_C(  90), INT8_C(  31),
                        INT8_C(  11), INT8_C(  68), INT8_C(  48), INT8_C(   4),
                        INT8_C(  55), INT8_C( -83), INT8_C(  75), INT8_C( -60)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -60), INT8_C( -60),
                           INT8_C(   0), INT8_C(   0), INT8_C( -60), INT8_C( -60),
                           INT8_C( -60), INT8_C(   0), INT8_C( -60), INT8_C( -60),
                           INT8_C( -60), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -60), INT8_C(   0), INT8_C( -60), INT8_C( -60),
                           INT8_C( -60), INT8_C(   0), INT8_C(   0), INT8_C( -60),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -60),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -60)) },
    { UINT64_C(          2018049220),
      simde_mm_set_epi8(INT8_C(  52), INT8_C( -63), INT8_C( -88), INT8_C( -55),
                        INT8_C(  90), INT8_C( -15), INT8_C( -11), INT8_C( -21),
                        INT8_C( 100), INT8_C( -84), INT8_C( -92), INT8_C( -78),
                        INT8_C(  27), INT8_C(  91), INT8_C(  46), INT8_C(-117)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-117), INT8_C(-117), INT8_C(-117),
                           INT8_C(-117), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-117), INT8_C(   0), INT8_C(   0),
                           INT8_C(-117), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-117), INT8_C(-117), INT8_C(-117), INT8_C(-117),
                           INT8_C(-117), INT8_C(-117), INT8_C(   0), INT8_C(   0),
                           INT8_C(-117), INT8_C(-117), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-117), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(          1858505628),
      simde_mm_set_epi8(INT8_C( 103), INT8_C( -85), INT8_C( -29), INT8_C(  86),
                        INT8_C(  71), INT8_C(  28), INT8_C( -23), INT8_C(  28),
                        INT8_C( -53), INT8_C( -82), INT8_C(  58), INT8_C( -12),
                        INT8_C(  63), INT8_C(  39), INT8_C( -32), INT8_C( -94)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -94), INT8_C( -94), INT8_C(   0),
                           INT8_C( -94), INT8_C( -94), INT8_C( -94), INT8_C(   0),
                           INT8_C( -94), INT8_C( -94), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -94), INT8_C( -94), INT8_C(   0),
                           INT8_C( -94), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -94), INT8_C(   0), INT8_C( -94), INT8_C( -94),
                           INT8_C( -94), INT8_C(   0), INT8_C(   0), INT8_C( -94),
                           INT8_C( -94), INT8_C( -94), INT8_C(   0), INT8_C(   0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_broadcastb_epi8(test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_broadcastw_epi16(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m128i a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm_set_epi16(INT16_C( -4264), INT16_C(-31095), INT16_C( 28503), INT16_C(-19429),
                         INT16_C(-23560), INT16_C( -4328), INT16_C( 17780), INT16_C(-19836)),
      simde_mm512_set_epi16(INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836),
                            INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836),
                            INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836),
                            INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836),
                            INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836),
                            INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836),
                            INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836),
                            INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836)) },
    { simde_mm_set_epi16(INT16_C( -1138), INT16_C(-21762), INT16_C(  8538), INT16_C(-12772),
                         INT16_C(  3852), INT16_C(  8246), INT16_C( -3641), INT16_C(  9422)),
      simde_mm512_set_epi16(INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422),
                            INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422),
                            INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422),
                            INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422),
                            INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422),
                            INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422),
                            INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422),
                            INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422)) },
    { simde_mm_set_epi16(INT16_C(-12364), INT16_C(-15754), INT16_C(  -793), INT16_C(-14722),
                         INT16_C(-29314), INT16_C(-26497), INT16_C(  3881), INT16_C( 17439)),
      simde_mm512_set_epi16(INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439),
                            INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439),
                            INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439),
                            INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439),
                            INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439),
                            INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439),
                            INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439),
                            INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439)) },
    { simde_mm_set_epi16(INT16_C( -7447), INT16_C(-10523), INT16_C(-25861), INT16_C(-22174),
                         INT16_C(  8521), INT16_C( 32120), INT16_C(-17861), INT16_C( 31790)),
      simde_mm512_set_epi16(INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790),
                            INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790),
                            INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790),
                            INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790),
                            INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790),
                            INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790),
                            INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790),
                            INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790)) },
    { simde_mm_set_epi16(INT16_C( -4580), INT16_C( -4681), INT16_C( -4797), INT16_C( 20435),
                         INT16_C(-31664), INT16_C(-25722), INT16_C(-13794), INT16_C( -4041)),
      simde_mm512_set_epi16(INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041),
                            INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041),
                            INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041),
                            INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041),
                            INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041),
                            INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041),
                            INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041),
                            INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041)) },
    { simde_mm_set_epi16(INT16_C(  1787), INT16_C(  9631), INT16_C(  4347), INT16_C( -4594),
                         INT16_C(-30523), INT16_C(-10849), INT16_C(-17993), INT16_C(-18482)),
      simde_mm512_set_epi16(INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482),
                            INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482),
                            INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482),
                            INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482),
                            INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482),
                            INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482),
                            INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482),
                            INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482)) },
    { simde_mm_set_epi16(INT16_C( 30524), INT16_C( 16358), INT16_C( 12856), INT16_C( 10489),
                         INT16_C( 17653), INT16_C( -5197), INT16_C( 14483), INT16_C(-30060)),
      simde_mm512_set_epi16(INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060),
                            INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060),
                            INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060),
                            INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060),
                            INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060),
                            INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060),
                            INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060),
                            INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060)) },
    { simde_mm_set_epi16(INT16_C(-28607), INT16_C(  6822), INT16_C(-19640), INT16_C(   516),
                         INT16_C(-13138), INT16_C( -4418), INT16_C(-29962), INT16_C( 13528)),
      simde_mm512_set_epi16(INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528),
                            INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528),
                            INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528),
                            INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528),
                            INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528),
                            INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528),
                            INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528),
                            INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_broadcastw_epi16(test_vec[i].a);
    simde_assert_m512i_i16(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_shuffle_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  56), INT8_C( -94), INT8_C( -41), INT8_C( -59),
                           INT8_C(  40), INT8_C(  78), INT8_C(  93), INT8_C( 107),
                           INT8_C( -47), INT8_C(  66), INT8_C(  -8), INT8_C( -52),
                           INT8_C(  50), INT8_C(  78), INT8_C(  13), INT8_C(  26),
                           INT8_C( -33), INT8_C( 120), INT8_C(  67), INT8_C( -12),
                           INT8_C(  80), INT8_C(  88), INT8_C( -65), INT8_C(  49),
                           INT8_C(  28), INT8_C(  96), INT8_C( -99), INT8_C(-119),
                           INT8_C( 126), INT8_C(  24), INT8_C(  35), INT8_C(  11),
                           INT8_C( -43), INT8_C( -24), INT8_C(   1), INT8_C( -61),
                           INT8_C( 101), INT8_C(   5), INT8_C(  67), INT8_C( -42),
                           INT8_C( -46), INT8_C(-115), INT8_C(-105), INT8_C( -92),
                           INT8_C(  -3), INT8_C( -44), INT8_C(  13), INT8_C( -36),
                           INT8_C( 110), INT8_C( -38), INT8_C( -48), INT8_C(  36),
                           INT8_C( 117), INT8_C( -59), INT8_C( 109), INT8_C( -27),
                           INT8_C( -62), INT8_C(  98), INT8_C(-121), INT8_C(-108),
                           INT8_C(  -7), INT8_C(-112), INT8_C( -52), INT8_C( -84)),
      simde_mm512_set_epi8(INT8_C(  34), INT8_C(  34), INT8_C( -71), INT8_C( -63),
                           INT8_C( -34), INT8_C(-128), INT8_C( 113), INT8_C( -72),
                           INT8_C(  86), INT8_C( -73), INT8_C( -43), INT8_C(  95),
                           INT8_C(   3), INT8_C(  13), INT8_C(  19), INT8_C(  -1),
                           INT8_C( -54), INT8_C( 114), INT8_C(  27), INT8_C( -30),
                           INT8_C(  52), INT8_C( -54), INT8_C(  78), INT8_C(  23),
                           INT8_C(  71), INT8_C(  87), INT8_C( 107), INT8_C( -27),
                           INT8_C( -35), INT8_C(-122), INT8_C(  40), INT8_C(  55),
                           INT8_C(  -2), INT8_C(  40), INT8_C( -63), INT8_C(  85),
                           INT8_C( -25), INT8_C( -93), INT8_C(  25), INT8_C(  70),
                           INT8_C( 117), INT8_C(  66), INT8_C( -79), INT8_C(  57),
                           INT8_C(-115), INT8_C( -27), INT8_C(  59), INT8_C(  25),
                           INT8_C(  -6), INT8_C(  42), INT8_C( -27), INT8_C( -34),
                           INT8_C( -16), INT8_C(   5), INT8_C( -55), INT8_C(  74),
                           INT8_C( -29), INT8_C(  77), INT8_C( -17), INT8_C(  16),
                           INT8_C( -98), INT8_C( -38), INT8_C( 116), INT8_C( -56)),
      simde_mm512_set_epi8(INT8_C(  78), INT8_C(  78), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  13), INT8_C(   0),
                           INT8_C(  66), INT8_C(   0), INT8_C(   0), INT8_C(  56),
                           INT8_C(  50), INT8_C( -41), INT8_C(  50), INT8_C(   0),
                           INT8_C(   0), INT8_C(  24), INT8_C(  80), INT8_C(   0),
                           INT8_C(-119), INT8_C(   0), INT8_C( 120), INT8_C(  28),
                           INT8_C(  28), INT8_C(  28), INT8_C(  80), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  49), INT8_C(  28),
                           INT8_C(   0), INT8_C( -42), INT8_C(   0), INT8_C(-105),
                           INT8_C(   0), INT8_C(   0), INT8_C(  67), INT8_C(-115),
                           INT8_C(-105), INT8_C( -44), INT8_C(   0), INT8_C(  67),
                           INT8_C(   0), INT8_C(   0), INT8_C( 101), INT8_C(  67),
                           INT8_C(   0), INT8_C( -59), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-121), INT8_C(   0), INT8_C( -59),
                           INT8_C(   0), INT8_C( -48), INT8_C(   0), INT8_C( -84),
                           INT8_C(   0), INT8_C(   0), INT8_C(-108), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C( -75), INT8_C(-123), INT8_C( -44), INT8_C( -97),
                           INT8_C(  61), INT8_C(-112), INT8_C( 109), INT8_C(  27),
                           INT8_C(  -9), INT8_C( -31), INT8_C(-111), INT8_C( -59),
                           INT8_C(  94), INT8_C( 110), INT8_C(  31), INT8_C(  50),
                           INT8_C( -86), INT8_C(  24), INT8_C(  91), INT8_C(-105),
                           INT8_C(  39), INT8_C(  25), INT8_C( -65), INT8_C(  69),
                           INT8_C( -59), INT8_C( -57), INT8_C( -98), INT8_C(  26),
                           INT8_C( -35), INT8_C(  -2), INT8_C( 114), INT8_C( -51),
                           INT8_C( -16), INT8_C( 101), INT8_C( -92), INT8_C(  65),
                           INT8_C( -88), INT8_C(  19), INT8_C(-102), INT8_C( -51),
                           INT8_C( -94), INT8_C( -30), INT8_C(  60), INT8_C(  -9),
                           INT8_C(   4), INT8_C( -93), INT8_C( 110), INT8_C(-102),
                           INT8_C( 109), INT8_C(   1), INT8_C( 113), INT8_C( 114),
                           INT8_C( 100), INT8_C(  80), INT8_C(  18), INT8_C(  -7),
                           INT8_C( -87), INT8_C(   0), INT8_C( -55), INT8_C(  37),
                           INT8_C(  13), INT8_C(  86), INT8_C(-114), INT8_C(-125)),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C(  11), INT8_C(  73), INT8_C(  57),
                           INT8_C( -54), INT8_C(   9), INT8_C(  69), INT8_C( -45),
                           INT8_C(  71), INT8_C(  -6), INT8_C( -68), INT8_C(  -8),
                           INT8_C(  14), INT8_C( -27), INT8_C(  84), INT8_C( -90),
                           INT8_C( -10), INT8_C( -81), INT8_C(  77), INT8_C(-113),
                           INT8_C(  32), INT8_C(  17), INT8_C(  62), INT8_C( -18),
                           INT8_C( 124), INT8_C( -42), INT8_C( -52), INT8_C(-109),
                           INT8_C( -19), INT8_C(  30), INT8_C( -51), INT8_C(-111),
                           INT8_C( 100), INT8_C(  63), INT8_C( -80), INT8_C(-126),
                           INT8_C(   3), INT8_C( 119), INT8_C(  38), INT8_C( -44),
                           INT8_C( -48), INT8_C( -43), INT8_C(   6), INT8_C(-113),
                           INT8_C(  -5), INT8_C( -18), INT8_C(  58), INT8_C(  77),
                           INT8_C( -49), INT8_C(-107), INT8_C( -77), INT8_C( 119),
                           INT8_C(  -6), INT8_C(  92), INT8_C(-122), INT8_C(  43),
                           INT8_C(  85), INT8_C(-111), INT8_C( -15), INT8_C(  90),
                           INT8_C(-104), INT8_C(  31), INT8_C(  -4), INT8_C(  57)),
      simde_mm512_set_epi8(INT8_C( 110), INT8_C(  61), INT8_C( 109), INT8_C( 109),
                           INT8_C(   0), INT8_C( 109), INT8_C(-111), INT8_C(   0),
                           INT8_C(  -9), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-123), INT8_C(   0), INT8_C( -59), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  91), INT8_C(   0),
                           INT8_C( -51), INT8_C( 114), INT8_C(  24), INT8_C(   0),
                           INT8_C(-105), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  24), INT8_C(   0), INT8_C(   0),
                           INT8_C(  -9), INT8_C( -16), INT8_C(   0), INT8_C(   0),
                           INT8_C(   4), INT8_C( -94), INT8_C( -30), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -30), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  19), INT8_C( -92),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -87),
                           INT8_C(   0), INT8_C( 114), INT8_C(   0), INT8_C( 100),
                           INT8_C( -55), INT8_C(   0), INT8_C(   0), INT8_C(  80),
                           INT8_C(   0), INT8_C( 109), INT8_C(   0), INT8_C(  18)) },
    { simde_mm512_set_epi8(INT8_C( -54), INT8_C(  53), INT8_C(  35), INT8_C(  51),
                           INT8_C(  24), INT8_C( 100), INT8_C(  80), INT8_C(   7),
                           INT8_C(  54), INT8_C( 114), INT8_C( -42), INT8_C(  -2),
                           INT8_C(  18), INT8_C( 100), INT8_C(  26), INT8_C( -68),
                           INT8_C(  82), INT8_C( -30), INT8_C(  -4), INT8_C( 110),
                           INT8_C(  24), INT8_C(  88), INT8_C(-100), INT8_C(-120),
                           INT8_C( -17), INT8_C(-109), INT8_C(  92), INT8_C(-105),
                           INT8_C( -20), INT8_C(  34), INT8_C(  98), INT8_C( -17),
                           INT8_C(   2), INT8_C(   6), INT8_C(  37), INT8_C( -85),
                           INT8_C( 118), INT8_C(  28), INT8_C(  34), INT8_C( 117),
                           INT8_C(  77), INT8_C( -32), INT8_C(  25), INT8_C( -74),
                           INT8_C(  93), INT8_C(-108), INT8_C(   3), INT8_C( -90),
                           INT8_C(  13), INT8_C( -29), INT8_C( -88), INT8_C( 116),
                           INT8_C(  14), INT8_C( -29), INT8_C(  30), INT8_C( -26),
                           INT8_C(-115), INT8_C( -36), INT8_C(  94), INT8_C(-125),
                           INT8_C( 118), INT8_C( 125), INT8_C( -91), INT8_C(  31)),
      simde_mm512_set_epi8(INT8_C( -74), INT8_C( -13), INT8_C( -87), INT8_C( -10),
                           INT8_C(  21), INT8_C(  49), INT8_C( -64), INT8_C(  52),
                           INT8_C( -97), INT8_C(-103), INT8_C(-127), INT8_C(  53),
                           INT8_C(  99), INT8_C(  80), INT8_C(  55), INT8_C( 111),
                           INT8_C(  61), INT8_C( -93), INT8_C( -87), INT8_C(  81),
                           INT8_C( 108), INT8_C(  89), INT8_C(  63), INT8_C(-109),
                           INT8_C( -47), INT8_C( -32), INT8_C( 105), INT8_C(  91),
                           INT8_C(  88), INT8_C(  85), INT8_C( -96), INT8_C(  88),
                           INT8_C( -85), INT8_C(   3), INT8_C( 124), INT8_C( -33),
                           INT8_C( -21), INT8_C(  -7), INT8_C( -31), INT8_C(-126),
                           INT8_C(   3), INT8_C( -17), INT8_C(  40), INT8_C(   5),
                           INT8_C( 126), INT8_C( -60), INT8_C( -91), INT8_C(-112),
                           INT8_C(  88), INT8_C(  11), INT8_C( 100), INT8_C( 114),
                           INT8_C( 112), INT8_C( -53), INT8_C(  89), INT8_C(  78),
                           INT8_C( 115), INT8_C( 117), INT8_C( -33), INT8_C(  14),
                           INT8_C( -42), INT8_C( -15), INT8_C(  80), INT8_C( -46)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -42), INT8_C(  26), INT8_C(   0), INT8_C(  -2),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -42),
                           INT8_C(  18), INT8_C( -68), INT8_C(  54), INT8_C( -54),
                           INT8_C(  -4), INT8_C(   0), INT8_C(   0), INT8_C(  98),
                           INT8_C( 110), INT8_C(-100), INT8_C(  82), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(-100), INT8_C(  24),
                           INT8_C(-120), INT8_C(  92), INT8_C(   0), INT8_C(-120),
                           INT8_C(   0), INT8_C(  93), INT8_C( -85), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  93), INT8_C(   0), INT8_C( 117), INT8_C(  25),
                           INT8_C(   6), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -26), INT8_C(  14), INT8_C(-125), INT8_C( 125),
                           INT8_C(  31), INT8_C(   0), INT8_C(  30), INT8_C( -29),
                           INT8_C( 118), INT8_C(  94), INT8_C(   0), INT8_C( -29),
                           INT8_C(   0), INT8_C(   0), INT8_C(  31), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C(-109), INT8_C(  14), INT8_C( -91), INT8_C( -44),
                           INT8_C(  79), INT8_C(  -4), INT8_C(  88), INT8_C(  49),
                           INT8_C( -95), INT8_C( -92), INT8_C(-116), INT8_C(   8),
                           INT8_C(  25), INT8_C(  30), INT8_C( -55), INT8_C(-120),
                           INT8_C( -58), INT8_C( -84), INT8_C(  99), INT8_C( -92),
                           INT8_C( -29), INT8_C( -47), INT8_C(  42), INT8_C( -56),
                           INT8_C( 109), INT8_C( -71), INT8_C( -73), INT8_C( -30),
                           INT8_C( -15), INT8_C(-106), INT8_C( -91), INT8_C( -57),
                           INT8_C(  51), INT8_C(  -8), INT8_C(  55), INT8_C(  36),
                           INT8_C( -55), INT8_C(-103), INT8_C(  51), INT8_C( -28),
                           INT8_C(  70), INT8_C( 114), INT8_C(  -3), INT8_C(  49),
                           INT8_C(  23), INT8_C( -28), INT8_C( -87), INT8_C(  57),
                           INT8_C(  28), INT8_C( -12), INT8_C( -51), INT8_C(  37),
                           INT8_C(  29), INT8_C( -58), INT8_C( -69), INT8_C(  30),
                           INT8_C(  43), INT8_C( -65), INT8_C(  -2), INT8_C( -83),
                           INT8_C( -27), INT8_C(-122), INT8_C(  77), INT8_C(  47)),
      simde_mm512_set_epi8(INT8_C(-116), INT8_C(-127), INT8_C( -95), INT8_C( -97),
                           INT8_C( -78), INT8_C( -53), INT8_C( -36), INT8_C(  62),
                           INT8_C(  63), INT8_C(  28), INT8_C( -37), INT8_C(  40),
                           INT8_C( -14), INT8_C(   2), INT8_C( -65), INT8_C( -67),
                           INT8_C(  79), INT8_C(  51), INT8_C( -51), INT8_C( -64),
                           INT8_C( -40), INT8_C(-102), INT8_C(-107), INT8_C(  82),
                           INT8_C(  20), INT8_C(  54), INT8_C(  66), INT8_C(   7),
                           INT8_C(  33), INT8_C( 108), INT8_C( -88), INT8_C(  69),
                           INT8_C(  98), INT8_C(  43), INT8_C(  25), INT8_C(  58),
                           INT8_C( 117), INT8_C( -34), INT8_C( -70), INT8_C(   3),
                           INT8_C(   1), INT8_C( 100), INT8_C(   3), INT8_C(  14),
                           INT8_C( 117), INT8_C( -91), INT8_C( -89), INT8_C(  66),
                           INT8_C(  32), INT8_C( -35), INT8_C( 104), INT8_C(  65),
                           INT8_C(-100), INT8_C(  27), INT8_C(  42), INT8_C(  91),
                           INT8_C( -47), INT8_C(  39), INT8_C( -65), INT8_C(-124),
                           INT8_C( -84), INT8_C( -95), INT8_C( -46), INT8_C(-113)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  14),
                           INT8_C(-109), INT8_C( -44), INT8_C(   0), INT8_C(  49),
                           INT8_C(   0), INT8_C(  30), INT8_C(   0), INT8_C(   0),
                           INT8_C( -58), INT8_C( -15), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-106),
                           INT8_C( -30), INT8_C( -71), INT8_C(-106), INT8_C( 109),
                           INT8_C( -91), INT8_C( -92), INT8_C(   0), INT8_C( -73),
                           INT8_C( -28), INT8_C( -55), INT8_C(  51), INT8_C(-103),
                           INT8_C(  -3), INT8_C(   0), INT8_C(   0), INT8_C(  23),
                           INT8_C( -87), INT8_C(  49), INT8_C(  23), INT8_C(  -8),
                           INT8_C(  -3), INT8_C(   0), INT8_C(   0), INT8_C( -28),
                           INT8_C(  47), INT8_C(   0), INT8_C(  30), INT8_C(  77),
                           INT8_C(   0), INT8_C(  29), INT8_C( -58), INT8_C(  29),
                           INT8_C(   0), INT8_C(  43), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C(-119), INT8_C(  55), INT8_C( -13), INT8_C(-118),
                           INT8_C(   5), INT8_C(  14), INT8_C(-103), INT8_C(  58),
                           INT8_C( 109), INT8_C(-113), INT8_C( -44), INT8_C( 126),
                           INT8_C(  70), INT8_C(-126), INT8_C(  24), INT8_C(-117),
                           INT8_C(  80), INT8_C(  25), INT8_C(  64), INT8_C( -89),
                           INT8_C(  60), INT8_C(   5), INT8_C(-119), INT8_C( -29),
                           INT8_C( -95), INT8_C( -26), INT8_C(  25), INT8_C( -65),
                           INT8_C( -81), INT8_C( -84), INT8_C(  46), INT8_C(  62),
                           INT8_C( -25), INT8_C(-116), INT8_C(-126), INT8_C(-103),
                           INT8_C( 126), INT8_C( -39), INT8_C( 111), INT8_C( -10),
                           INT8_C( -48), INT8_C( 122), INT8_C( -86), INT8_C( -25),
                           INT8_C(  35), INT8_C(  -4), INT8_C(  -7), INT8_C(  76),
                           INT8_C(-116), INT8_C(   1), INT8_C( 126), INT8_C( -30),
                           INT8_C( -11), INT8_C(  82), INT8_C(  81), INT8_C(  27),
                           INT8_C( -15), INT8_C( -14), INT8_C(  56), INT8_C(  60),
                           INT8_C( -29), INT8_C( -65), INT8_C( -35), INT8_C(  21)),
      simde_mm512_set_epi8(INT8_C( 125), INT8_C( -43), INT8_C( -42), INT8_C( -51),
                           INT8_C( -36), INT8_C(  38), INT8_C(  42), INT8_C(  18),
                           INT8_C(  24), INT8_C( -25), INT8_C(  19), INT8_C(  15),
                           INT8_C(-119), INT8_C(-124), INT8_C( 104), INT8_C( -93),
                           INT8_C(  22), INT8_C( -16), INT8_C(  31), INT8_C( 116),
                           INT8_C( -99), INT8_C(  45), INT8_C( -54), INT8_C(  50),
                           INT8_C( -72), INT8_C(-107), INT8_C(  48), INT8_C( 118),
                           INT8_C( -68), INT8_C( -15), INT8_C(-108), INT8_C( -29),
                           INT8_C( 118), INT8_C(  96), INT8_C( -51), INT8_C( 107),
                           INT8_C( -23), INT8_C( -97), INT8_C(  -6), INT8_C(  91),
                           INT8_C( -57), INT8_C( -67), INT8_C(-105), INT8_C(  68),
                           INT8_C( -50), INT8_C(  16), INT8_C( -86), INT8_C(   6),
                           INT8_C(  55), INT8_C(-118), INT8_C( 112), INT8_C( 125),
                           INT8_C(  92), INT8_C(  91), INT8_C( -27), INT8_C(  53),
                           INT8_C(  28), INT8_C( -66), INT8_C( -69), INT8_C(-117),
                           INT8_C( -30), INT8_C(-106), INT8_C(   1), INT8_C(  95)),
      simde_mm512_set_epi8(INT8_C( -13), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-113), INT8_C(  14), INT8_C(-126),
                           INT8_C(  58), INT8_C(   0), INT8_C(  70), INT8_C(-119),
                           INT8_C(   0), INT8_C(   0), INT8_C(  58), INT8_C(   0),
                           INT8_C( -26), INT8_C(   0), INT8_C(  80), INT8_C( -65),
                           INT8_C(   0), INT8_C(  64), INT8_C(   0), INT8_C( -84),
                           INT8_C(   0), INT8_C(   0), INT8_C(  62), INT8_C( -26),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 122), INT8_C(  76), INT8_C(   0), INT8_C( 126),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( 126),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -25),
                           INT8_C(   0), INT8_C(  76), INT8_C(   0), INT8_C( 122),
                           INT8_C( -15), INT8_C(   0), INT8_C(  21), INT8_C( 126),
                           INT8_C( -30), INT8_C( -11), INT8_C(   0), INT8_C(  56),
                           INT8_C( -30), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -35), INT8_C(-116)) },
    { simde_mm512_set_epi8(INT8_C(  18), INT8_C(-124), INT8_C(  -6), INT8_C( -41),
                           INT8_C(-109), INT8_C(  19), INT8_C(  47), INT8_C(  73),
                           INT8_C( -58), INT8_C( -50), INT8_C(  73), INT8_C( 110),
                           INT8_C(  56), INT8_C( -30), INT8_C( -79), INT8_C( 123),
                           INT8_C(  77), INT8_C(  62), INT8_C( -28), INT8_C(  45),
                           INT8_C( -95), INT8_C(  12), INT8_C(  53), INT8_C(  75),
                           INT8_C(  66), INT8_C( -89), INT8_C(  46), INT8_C( -47),
                           INT8_C(   6), INT8_C(   4), INT8_C( 112), INT8_C( -34),
                           INT8_C( 121), INT8_C(  -3), INT8_C(-102), INT8_C(-115),
                           INT8_C( -12), INT8_C(  80), INT8_C(   3), INT8_C(  56),
                           INT8_C(  85), INT8_C( -43), INT8_C( -93), INT8_C(  34),
                           INT8_C( -58), INT8_C(-101), INT8_C(  51), INT8_C(   1),
                           INT8_C( -18), INT8_C( -90), INT8_C( -71), INT8_C(  74),
                           INT8_C(  -5), INT8_C(-113), INT8_C(  71), INT8_C(  61),
                           INT8_C(  92), INT8_C(  73), INT8_C( 116), INT8_C( 110),
                           INT8_C(-117), INT8_C(  96), INT8_C( -77), INT8_C(  45)),
      simde_mm512_set_epi8(INT8_C(  52), INT8_C( -84), INT8_C( 103), INT8_C(-105),
                           INT8_C( -57), INT8_C(  17), INT8_C(-110), INT8_C(-113),
                           INT8_C(  56), INT8_C( 125), INT8_C(  56), INT8_C( -88),
                           INT8_C( -31), INT8_C( 119), INT8_C( -86), INT8_C( 114),
                           INT8_C( -85), INT8_C(  14), INT8_C(  60), INT8_C(  84),
                           INT8_C( -61), INT8_C(-111), INT8_C(  74), INT8_C( 113),
                           INT8_C(  13), INT8_C( -89), INT8_C(-114), INT8_C( -79),
                           INT8_C( -34), INT8_C( -73), INT8_C(  -9), INT8_C(-108),
                           INT8_C(  93), INT8_C( -78), INT8_C(  -1), INT8_C(-102),
                           INT8_C(  12), INT8_C( 117), INT8_C(  80), INT8_C(  44),
                           INT8_C(  29), INT8_C(  18), INT8_C(  91), INT8_C( -23),
                           INT8_C( 110), INT8_C(-126), INT8_C( -71), INT8_C(  65),
                           INT8_C( -76), INT8_C(  85), INT8_C(  93), INT8_C( -86),
                           INT8_C(-123), INT8_C(-115), INT8_C(-105), INT8_C(  75),
                           INT8_C(  45), INT8_C(  22), INT8_C(  73), INT8_C(  74),
                           INT8_C( 107), INT8_C( -60), INT8_C( -28), INT8_C( -57)),
      simde_mm512_set_epi8(INT8_C( 110), INT8_C(   0), INT8_C( -58), INT8_C(   0),
                           INT8_C(   0), INT8_C( -79), INT8_C(   0), INT8_C(   0),
                           INT8_C(  73), INT8_C(  -6), INT8_C(  73), INT8_C(   0),
                           INT8_C(   0), INT8_C( -58), INT8_C(   0), INT8_C( -30),
                           INT8_C(   0), INT8_C(  62), INT8_C(  45), INT8_C( -47),
                           INT8_C(   0), INT8_C(   0), INT8_C(  12), INT8_C( 112),
                           INT8_C( -28), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-102), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-115), INT8_C( -93), INT8_C(   1), INT8_C(-115),
                           INT8_C(-102), INT8_C(-101), INT8_C( -12), INT8_C(   0),
                           INT8_C(  -3), INT8_C(   0), INT8_C(   0), INT8_C(  51),
                           INT8_C(   0), INT8_C( 116), INT8_C( -71), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -5),
                           INT8_C( -71), INT8_C(  73), INT8_C(  71), INT8_C(-113),
                           INT8_C(  -5), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C(   4), INT8_C( -30), INT8_C( -68), INT8_C(  57),
                           INT8_C(  73), INT8_C(  25), INT8_C( -45), INT8_C( 112),
                           INT8_C(  41), INT8_C(  41), INT8_C( -56), INT8_C( -93),
                           INT8_C(  29), INT8_C(  99), INT8_C(  15), INT8_C( 122),
                           INT8_C(  74), INT8_C(   0), INT8_C(  89), INT8_C(  61),
                           INT8_C( 124), INT8_C(  36), INT8_C( -87), INT8_C( -25),
                           INT8_C(  42), INT8_C(-125), INT8_C( -87), INT8_C(  69),
                           INT8_C(  81), INT8_C(   4), INT8_C(  55), INT8_C( 107),
                           INT8_C(   0), INT8_C(  -7), INT8_C(  37), INT8_C( -15),
                           INT8_C( 117), INT8_C(   9), INT8_C( -27), INT8_C(  11),
                           INT8_C(  16), INT8_C(  87), INT8_C( 119), INT8_C(-107),
                           INT8_C( -22), INT8_C(  27), INT8_C( -86), INT8_C( -63),
                           INT8_C(  90), INT8_C( -44), INT8_C(-113), INT8_C(-126),
                           INT8_C( -75), INT8_C(  67), INT8_C(  88), INT8_C( 105),
                           INT8_C(  80), INT8_C(   7), INT8_C(  66), INT8_C( 126),
                           INT8_C(  17), INT8_C( -20), INT8_C( -91), INT8_C( -99)),
      simde_mm512_set_epi8(INT8_C( 123), INT8_C( 117), INT8_C(  18), INT8_C(   2),
                           INT8_C(-105), INT8_C( -51), INT8_C(  -9), INT8_C(  72),
                           INT8_C(  69), INT8_C(-116), INT8_C(  95), INT8_C(-110),
                           INT8_C( -32), INT8_C( 110), INT8_C(  -8), INT8_C(  85),
                           INT8_C( -41), INT8_C(  80), INT8_C( -44), INT8_C( 110),
                           INT8_C( -28), INT8_C( 116), INT8_C(  41), INT8_C( -31),
                           INT8_C(  12), INT8_C(  40), INT8_C(   5), INT8_C(   1),
                           INT8_C( -14), INT8_C(  66), INT8_C( -95), INT8_C( 106),
                           INT8_C(  66), INT8_C( -91), INT8_C( -20), INT8_C(-109),
                           INT8_C( -46), INT8_C(  41), INT8_C(  82), INT8_C( -61),
                           INT8_C(   2), INT8_C(   3), INT8_C(  62), INT8_C( -90),
                           INT8_C(  99), INT8_C( -54), INT8_C( -28), INT8_C( -21),
                           INT8_C( 126), INT8_C( 115), INT8_C( -46), INT8_C(  76),
                           INT8_C( -43), INT8_C(  46), INT8_C( 107), INT8_C(  75),
                           INT8_C( -93), INT8_C(  67), INT8_C( -37), INT8_C(   4),
                           INT8_C(-127), INT8_C( -50), INT8_C( -26), INT8_C(  99)),
      simde_mm512_set_epi8(INT8_C(  73), INT8_C( -56), INT8_C(  99), INT8_C(  99),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( 112),
                           INT8_C( -56), INT8_C(   0), INT8_C(   4), INT8_C(   0),
                           INT8_C(   0), INT8_C( -30), INT8_C(   0), INT8_C( -56),
                           INT8_C(   0), INT8_C( 107), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  69), INT8_C( -87), INT8_C(   0),
                           INT8_C(  61), INT8_C( -25), INT8_C( -87), INT8_C(  55),
                           INT8_C(   0), INT8_C(   4), INT8_C(   0), INT8_C(  36),
                           INT8_C(  27), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -27), INT8_C(  27), INT8_C(   0),
                           INT8_C(  27), INT8_C( -22), INT8_C(  -7), INT8_C(   0),
                           INT8_C( -22), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -44), INT8_C(  17), INT8_C(   0), INT8_C(-126),
                           INT8_C(   0), INT8_C( -44), INT8_C( -75), INT8_C( -75),
                           INT8_C(   0), INT8_C(  17), INT8_C(   0), INT8_C( 126),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  17)) },
    { simde_mm512_set_epi8(INT8_C(  56), INT8_C(  24), INT8_C( -33), INT8_C(  82),
                           INT8_C(  72), INT8_C(  63), INT8_C(-114), INT8_C(  14),
                           INT8_C(   2), INT8_C(  71), INT8_C( -31), INT8_C( -46),
                           INT8_C(  64), INT8_C( -11), INT8_C(  35), INT8_C(  -7),
                           INT8_C( -78), INT8_C( 125), INT8_C( -28), INT8_C( -59),
                           INT8_C(   6), INT8_C(-127), INT8_C(  34), INT8_C(  64),
                           INT8_C(  88), INT8_C( -88), INT8_C(  70), INT8_C( -90),
                           INT8_C(  47), INT8_C( -21), INT8_C(-104), INT8_C( -27),
                           INT8_C( -16), INT8_C( -29), INT8_C(  51), INT8_C(-116),
                           INT8_C( -87), INT8_C(  91), INT8_C(-106), INT8_C(  -3),
                           INT8_C( -55), INT8_C( -15), INT8_C(-109), INT8_C(-108),
                           INT8_C( -41), INT8_C(  79), INT8_C(  54), INT8_C(  68),
                           INT8_C( -51), INT8_C(-108), INT8_C( -83), INT8_C( 104),
                           INT8_C(  18), INT8_C(-128), INT8_C( -75), INT8_C( -12),
                           INT8_C(  56), INT8_C(-104), INT8_C(  56), INT8_C(  47),
                           INT8_C( -30), INT8_C( -15), INT8_C(-115), INT8_C(  88)),
      simde_mm512_set_epi8(INT8_C( 107), INT8_C( 125), INT8_C(-111), INT8_C( -89),
                           INT8_C(  -9), INT8_C( 122), INT8_C(  -2), INT8_C( -26),
                           INT8_C(-100), INT8_C(  80), INT8_C(  89), INT8_C(  38),
                           INT8_C(  95), INT8_C( -82), INT8_C( -66), INT8_C( 108),
                           INT8_C( 104), INT8_C( -20), INT8_C(  72), INT8_C( -82),
                           INT8_C(  23), INT8_C( -45), INT8_C( -20), INT8_C(   8),
                           INT8_C(  -2), INT8_C( -77), INT8_C(-112), INT8_C( 102),
                           INT8_C(  83), INT8_C(  80), INT8_C(  56), INT8_C( -53),
                           INT8_C( -83), INT8_C( -86), INT8_C(  15), INT8_C(  30),
                           INT8_C( -92), INT8_C(  -2), INT8_C(  42), INT8_C( -79),
                           INT8_C( 108), INT8_C(  44), INT8_C(  17), INT8_C(  83),
                           INT8_C( -49), INT8_C( -44), INT8_C( -42), INT8_C( -54),
                           INT8_C(-127), INT8_C(  12), INT8_C(  88), INT8_C(-118),
                           INT8_C( -23), INT8_C( -69), INT8_C( -23), INT8_C( -36),
                           INT8_C( -23), INT8_C( -80), INT8_C(  33), INT8_C(  82),
                           INT8_C( -43), INT8_C( -91), INT8_C( -36), INT8_C( -56)),
      simde_mm512_set_epi8(INT8_C(  72), INT8_C( -33), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  63), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  -7), INT8_C(-114), INT8_C(  71),
                           INT8_C(  56), INT8_C(   0), INT8_C(   0), INT8_C(  82),
                           INT8_C(  64), INT8_C(   0), INT8_C(  64), INT8_C(   0),
                           INT8_C(  88), INT8_C(   0), INT8_C(   0), INT8_C(  64),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -88),
                           INT8_C(  47), INT8_C( -27), INT8_C(  64), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -16), INT8_C( -29),
                           INT8_C(   0), INT8_C(   0), INT8_C(  91), INT8_C(   0),
                           INT8_C(-116), INT8_C(-116), INT8_C(  54), INT8_C( -41),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 104), INT8_C( -12), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(-115), INT8_C( -15),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_shuffle_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_mask_shuffle_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  92), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C( -73), INT8_C(  22), INT8_C( -66), INT8_C( -29),
                           INT8_C(  55), INT8_C(  78), INT8_C( -45), INT8_C(-119),
                           INT8_C(  30), INT8_C( -29), INT8_C( -23), INT8_C(  89),
                           INT8_C(  15), INT8_C( 119), INT8_C( -88), INT8_C( 109),
                           INT8_C( -16), INT8_C( -10), INT8_C(   0), INT8_C( -18),
                           INT8_C(   1), INT8_C( 116), INT8_C(  62), INT8_C( -73),
                           INT8_C(-122), INT8_C(   0), INT8_C( 111), INT8_C(  95),
                           INT8_C( -20), INT8_C(   3), INT8_C( 122), INT8_C(-121),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(-127),
                           INT8_C(  82), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  73), INT8_C( 108), INT8_C( -18), INT8_C(  15),
                           INT8_C(  81), INT8_C( -27), INT8_C( 102), INT8_C( 118),
                           INT8_C(  39), INT8_C( -77), INT8_C(  45), INT8_C(  81),
                           INT8_C( -17), INT8_C( -28), INT8_C(  67), INT8_C(-118),
                           INT8_C(  79), INT8_C(-113), INT8_C(-122), INT8_C( 124)),
      UINT64_C(10224647434006242820),
      simde_mm512_set_epi8(INT8_C(  68), INT8_C(-108), INT8_C(-121), INT8_C(-115),
                           INT8_C( -59), INT8_C( -78), INT8_C(-111), INT8_C(  56),
                           INT8_C(   9), INT8_C(-121), INT8_C( 120), INT8_C( -36),
                           INT8_C(  36), INT8_C(-103), INT8_C(-104), INT8_C(  25),
                           INT8_C(-111), INT8_C( -63), INT8_C( -35), INT8_C(-120),
                           INT8_C(  28), INT8_C( -44), INT8_C( -26), INT8_C( -86),
                           INT8_C( -13), INT8_C(  53), INT8_C( -88), INT8_C(-107),
                           INT8_C(  68), INT8_C(  42), INT8_C(-118), INT8_C( 111),
                           INT8_C(  54), INT8_C( -58), INT8_C( -13), INT8_C(  27),
                           INT8_C(  23), INT8_C(  41), INT8_C(-119), INT8_C(  44),
                           INT8_C(   7), INT8_C(-120), INT8_C(  32), INT8_C( -43),
                           INT8_C( 114), INT8_C( -72), INT8_C(  73), INT8_C( -96),
                           INT8_C(  96), INT8_C( 110), INT8_C( -81), INT8_C( -76),
                           INT8_C( 103), INT8_C(-100), INT8_C( -22), INT8_C(  18),
                           INT8_C( 115), INT8_C(  54), INT8_C( -40), INT8_C( 125),
                           INT8_C( 110), INT8_C(  31), INT8_C(  51), INT8_C(-104)),
      simde_mm512_set_epi8(INT8_C( -14), INT8_C(  85), INT8_C( -80), INT8_C(  80),
                           INT8_C(  48), INT8_C(  93), INT8_C(  79), INT8_C( 127),
                           INT8_C(  16), INT8_C(  41), INT8_C(  54), INT8_C(-116),
                           INT8_C(  17), INT8_C(  42), INT8_C( -86), INT8_C(  38),
                           INT8_C(-118), INT8_C( -56), INT8_C(  60), INT8_C(  19),
                           INT8_C(-100), INT8_C(-107), INT8_C( 105), INT8_C( -76),
                           INT8_C(  10), INT8_C(  -9), INT8_C( -12), INT8_C( -56),
                           INT8_C( -71), INT8_C(  96), INT8_C(   6), INT8_C(  24),
                           INT8_C(  69), INT8_C(  73), INT8_C( -27), INT8_C(   3),
                           INT8_C( -95), INT8_C(  50), INT8_C( -67), INT8_C( -39),
                           INT8_C(  97), INT8_C(  62), INT8_C( 101), INT8_C(  56),
                           INT8_C( -79), INT8_C(  83), INT8_C( -99), INT8_C( -56),
                           INT8_C( -17), INT8_C( -56), INT8_C(  -8), INT8_C( -16),
                           INT8_C(  84), INT8_C( -95), INT8_C( -73), INT8_C(  54),
                           INT8_C( 125), INT8_C(  85), INT8_C(  78), INT8_C( -65),
                           INT8_C(   4), INT8_C( 113), INT8_C( -16), INT8_C( -53)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C(  25), INT8_C(-121), INT8_C( -66), INT8_C(  68),
                           INT8_C(  25), INT8_C(-111), INT8_C(-121), INT8_C(-119),
                           INT8_C(  30), INT8_C( -78), INT8_C( -23), INT8_C(-121),
                           INT8_C(  15), INT8_C( 119), INT8_C(-120), INT8_C(  68),
                           INT8_C(   0), INT8_C(   0), INT8_C( -26), INT8_C( -18),
                           INT8_C( -44), INT8_C( 116), INT8_C(   0), INT8_C( -73),
                           INT8_C(   0), INT8_C(   0), INT8_C(  53), INT8_C( -86),
                           INT8_C( -20), INT8_C(   3), INT8_C(   0), INT8_C( 114),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(   0),
                           INT8_C(  73), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(   0), INT8_C( 114), INT8_C( -18), INT8_C(   0),
                           INT8_C(  81), INT8_C( -27), INT8_C(   0), INT8_C( 118),
                           INT8_C(  39), INT8_C(   0), INT8_C(   0), INT8_C(  81),
                           INT8_C( -17), INT8_C( -28), INT8_C(  67), INT8_C(-118),
                           INT8_C(  79), INT8_C(  51), INT8_C(-122), INT8_C( 124)) },
    { simde_mm512_set_epi8(INT8_C(-123), INT8_C(-100), INT8_C( -39), INT8_C( -44),
                           INT8_C(  22), INT8_C( 112), INT8_C(  16), INT8_C(  15),
                           INT8_C(-104), INT8_C(-102), INT8_C( 102), INT8_C( -95),
                           INT8_C(  69), INT8_C(  13), INT8_C( -21), INT8_C(  45),
                           INT8_C(  62), INT8_C(-120), INT8_C(-111), INT8_C(  32),
                           INT8_C(-107), INT8_C( -30), INT8_C(  99), INT8_C( -64),
                           INT8_C(   8), INT8_C( -42), INT8_C(  81), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -71), INT8_C(  46),
                           INT8_C( -21), INT8_C( -73), INT8_C(  21), INT8_C(  83),
                           INT8_C(-108), INT8_C( -97), INT8_C( -69), INT8_C(  73),
                           INT8_C(  57), INT8_C( -37), INT8_C(  21), INT8_C(  82),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C( 115), INT8_C(  31), INT8_C( -79), INT8_C(  28),
                           INT8_C(-106), INT8_C( -18), INT8_C(  65), INT8_C(-104),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  -2)),
      UINT64_C( 4597426592773770833),
      simde_mm512_set_epi8(INT8_C(  74), INT8_C(  72), INT8_C(  -4), INT8_C(  28),
                           INT8_C(-115), INT8_C(  93), INT8_C( 102), INT8_C(  44),
                           INT8_C(-103), INT8_C( -29), INT8_C( -50), INT8_C(  48),
                           INT8_C( -96), INT8_C( -50), INT8_C(  46), INT8_C( -65),
                           INT8_C(   4), INT8_C(  43), INT8_C( -75), INT8_C(  97),
                           INT8_C( -26), INT8_C(-103), INT8_C(  71), INT8_C(-107),
                           INT8_C(  91), INT8_C(  45), INT8_C( -11), INT8_C(  47),
                           INT8_C(  29), INT8_C(  25), INT8_C(  26), INT8_C(  -9),
                           INT8_C(  10), INT8_C(  36), INT8_C( -79), INT8_C( -53),
                           INT8_C(  41), INT8_C(   1), INT8_C( -23), INT8_C( -63),
                           INT8_C(-127), INT8_C(  68), INT8_C(  48), INT8_C(  36),
                           INT8_C(  89), INT8_C(-112), INT8_C( -31), INT8_C( 120),
                           INT8_C(  35), INT8_C(  62), INT8_C( -21), INT8_C(-114),
                           INT8_C(-104), INT8_C(  57), INT8_C(  42), INT8_C(-111),
                           INT8_C(  94), INT8_C( -63), INT8_C(  -9), INT8_C(  64),
                           INT8_C( -65), INT8_C(  -2), INT8_C( 110), INT8_C(  -8)),
      simde_mm512_set_epi8(INT8_C(  44), INT8_C( -92), INT8_C( -31), INT8_C(  26),
                           INT8_C( -99), INT8_C( -53), INT8_C( 117), INT8_C(  18),
                           INT8_C( -63), INT8_C(  45), INT8_C(  12), INT8_C(  24),
                           INT8_C(-108), INT8_C(  18), INT8_C( -60), INT8_C(  28),
                           INT8_C(  50), INT8_C( -11), INT8_C( -68), INT8_C( -31),
                           INT8_C( 105), INT8_C(-106), INT8_C(  98), INT8_C(  51),
                           INT8_C(  58), INT8_C( 103), INT8_C( 111), INT8_C(-127),
                           INT8_C(  68), INT8_C( -56), INT8_C( 124), INT8_C(-119),
                           INT8_C(  74), INT8_C( -62), INT8_C(-116), INT8_C(  37),
                           INT8_C( -12), INT8_C( 114), INT8_C(   0), INT8_C(  61),
                           INT8_C( 103), INT8_C(  -4), INT8_C(-105), INT8_C( -68),
                           INT8_C(  39), INT8_C(-100), INT8_C( -93), INT8_C(  11),
                           INT8_C( -80), INT8_C( -19), INT8_C( -22), INT8_C( -39),
                           INT8_C( 127), INT8_C( -38), INT8_C(-125), INT8_C(-111),
                           INT8_C(  84), INT8_C( -96), INT8_C(  87), INT8_C( -22),
                           INT8_C(  -5), INT8_C(  -3), INT8_C(-127), INT8_C(  41)),
      simde_mm512_set_epi8(INT8_C(-123), INT8_C(-100), INT8_C(   0), INT8_C(  93),
                           INT8_C(   0), INT8_C(   0), INT8_C( -50), INT8_C( -50),
                           INT8_C(   0), INT8_C(  -4), INT8_C( 102), INT8_C( -95),
                           INT8_C(   0), INT8_C( -50), INT8_C( -21), INT8_C(  28),
                           INT8_C(  62), INT8_C(   0), INT8_C(-111), INT8_C(   0),
                           INT8_C(-107), INT8_C(   0), INT8_C(  25), INT8_C(  29),
                           INT8_C(   8), INT8_C( -42), INT8_C(   4), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(   1), INT8_C(  -7), INT8_C(   0), INT8_C(  48),
                           INT8_C(   0), INT8_C(-112), INT8_C( 120), INT8_C( -79),
                           INT8_C(-108), INT8_C( -97), INT8_C(   0), INT8_C(   0),
                           INT8_C(  57), INT8_C(   0), INT8_C(   0), INT8_C(  41),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C(  35), INT8_C(   0), INT8_C(   0), INT8_C(  28),
                           INT8_C(-106), INT8_C(   0), INT8_C(  65), INT8_C(   0),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  42)) },
    { simde_mm512_set_epi8(INT8_C( -30), INT8_C( -37), INT8_C(  51), INT8_C( -36),
                           INT8_C(   8), INT8_C(  52), INT8_C(  97), INT8_C( 123),
                           INT8_C( -49), INT8_C(-124), INT8_C(  95), INT8_C( -83),
                           INT8_C(  70), INT8_C( -50), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(  11),
                           INT8_C( -14), INT8_C( 126), INT8_C(  81), INT8_C(  45),
                           INT8_C( -23), INT8_C( 120), INT8_C( -83), INT8_C( -16),
                           INT8_C(   7), INT8_C(  51), INT8_C( -57), INT8_C( -50),
                           INT8_C( -21), INT8_C(  98), INT8_C(  88), INT8_C(   0),
                           INT8_C( -66), INT8_C(   3), INT8_C( 124), INT8_C(-113),
                           INT8_C(  50), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C( -44), INT8_C( -13), INT8_C( -94), INT8_C(  17),
                           INT8_C(  -2), INT8_C(  79), INT8_C(-116), INT8_C(  43),
                           INT8_C( -77), INT8_C(-125), INT8_C( -23), INT8_C(-120),
                           INT8_C(  96), INT8_C( -64), INT8_C( -23), INT8_C( -46),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90)),
      UINT64_C(12627002542648829104),
      simde_mm512_set_epi8(INT8_C(  56), INT8_C( -45), INT8_C(-108), INT8_C( -19),
                           INT8_C(-124), INT8_C( -27), INT8_C(  22), INT8_C( 126),
                           INT8_C(-106), INT8_C( -68), INT8_C( -60), INT8_C(   8),
                           INT8_C(  60), INT8_C(  93), INT8_C( -33), INT8_C( -27),
                           INT8_C(  -7), INT8_C(  27), INT8_C(-122), INT8_C( -38),
                           INT8_C(  23), INT8_C(   6), INT8_C(  45), INT8_C( -21),
                           INT8_C( -23), INT8_C(-101), INT8_C( 116), INT8_C( 127),
                           INT8_C(  96), INT8_C(  40), INT8_C( -97), INT8_C(  40),
                           INT8_C(  86), INT8_C( -44), INT8_C(  70), INT8_C( -71),
                           INT8_C(  62), INT8_C( -21), INT8_C(  66), INT8_C(  68),
                           INT8_C( -87), INT8_C( -61), INT8_C(  48), INT8_C( -70),
                           INT8_C(  18), INT8_C( -78), INT8_C( -98), INT8_C( 117),
                           INT8_C(  74), INT8_C(  32), INT8_C(  93), INT8_C( 125),
                           INT8_C( -47), INT8_C( -60), INT8_C( -86), INT8_C( 117),
                           INT8_C( 122), INT8_C( -54), INT8_C(  50), INT8_C( 123),
                           INT8_C( -31), INT8_C( -74), INT8_C( -64), INT8_C(  54)),
      simde_mm512_set_epi8(INT8_C( 115), INT8_C(  51), INT8_C( -91), INT8_C(  56),
                           INT8_C(  64), INT8_C( -39), INT8_C(-119), INT8_C( -28),
                           INT8_C( -54), INT8_C(  28), INT8_C(  54), INT8_C(  -8),
                           INT8_C( -54), INT8_C(-128), INT8_C( -28), INT8_C( -71),
                           INT8_C( 107), INT8_C( -66), INT8_C(-114), INT8_C( -88),
                           INT8_C(  34), INT8_C( -83), INT8_C( -21), INT8_C( -64),
                           INT8_C( 121), INT8_C( -20), INT8_C( -89), INT8_C( -94),
                           INT8_C( 112), INT8_C( -27), INT8_C(  81), INT8_C( -54),
                           INT8_C( -64), INT8_C(-114), INT8_C(  48), INT8_C( -89),
                           INT8_C( -61), INT8_C(  26), INT8_C(  43), INT8_C(  29),
                           INT8_C(   0), INT8_C(  64), INT8_C( 123), INT8_C( -67),
                           INT8_C(  15), INT8_C( 120), INT8_C(  36), INT8_C(  40),
                           INT8_C( 106), INT8_C(-118), INT8_C(-108), INT8_C( -58),
                           INT8_C(  26), INT8_C(-111), INT8_C(  63), INT8_C( -98),
                           INT8_C( -13), INT8_C( -12), INT8_C(-124), INT8_C(  96),
                           INT8_C( -13), INT8_C( -98), INT8_C(  99), INT8_C( -13)),
      simde_mm512_set_epi8(INT8_C(  60), INT8_C( -37), INT8_C(   0), INT8_C( -36),
                           INT8_C( -27), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -49), INT8_C(-124), INT8_C( -68), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(   0),
                           INT8_C(  40), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  45), INT8_C(   0), INT8_C(   0), INT8_C( -16),
                           INT8_C(  40), INT8_C(  51), INT8_C( -57), INT8_C(   0),
                           INT8_C( -21), INT8_C(   0), INT8_C( 117), INT8_C(   0),
                           INT8_C(   0), INT8_C( -21), INT8_C( 124), INT8_C(-113),
                           INT8_C( 117), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C(  86), INT8_C( -13), INT8_C( -94), INT8_C(  68),
                           INT8_C( -60), INT8_C(  79), INT8_C(   0), INT8_C(  43),
                           INT8_C( -77), INT8_C(   0), INT8_C( -23), INT8_C(-120),
                           INT8_C(   0), INT8_C( -64), INT8_C(   0), INT8_C(  54),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90)) },
    { simde_mm512_set_epi8(INT8_C(  72), INT8_C(  45), INT8_C( 120), INT8_C(  -5),
                           INT8_C(-109), INT8_C(  62), INT8_C(  17), INT8_C(  31),
                           INT8_C( -30), INT8_C( -58), INT8_C(  56), INT8_C(  21),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(  32), INT8_C(  64),
                           INT8_C(-128), INT8_C( 102), INT8_C( -21), INT8_C(  28),
                           INT8_C( 105), INT8_C(  52), INT8_C(  85), INT8_C(-104),
                           INT8_C(  57), INT8_C( -31), INT8_C( -38), INT8_C(-124),
                           INT8_C(-107), INT8_C(  -2), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  18), INT8_C(  70),
                           INT8_C(  89), INT8_C( 125), INT8_C( -42), INT8_C(-125),
                           INT8_C( 121), INT8_C( -11), INT8_C( -69), INT8_C( -59),
                           INT8_C( -53), INT8_C(  34), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  69), INT8_C(  -8),
                           INT8_C( -15), INT8_C( -51), INT8_C(   1), INT8_C(  90)),
      UINT64_C(14515151237088493607),
      simde_mm512_set_epi8(INT8_C( -26), INT8_C(  -9), INT8_C(  66), INT8_C(   1),
                           INT8_C( -13), INT8_C(  60), INT8_C(-119), INT8_C( -83),
                           INT8_C(-122), INT8_C( -64), INT8_C( -83), INT8_C( -74),
                           INT8_C( 119), INT8_C(  -8), INT8_C(  12), INT8_C( 113),
                           INT8_C( -12), INT8_C( -84), INT8_C(   6), INT8_C(  69),
                           INT8_C(   2), INT8_C( -75), INT8_C( -34), INT8_C(-126),
                           INT8_C(   3), INT8_C(-128), INT8_C(  -9), INT8_C(  24),
                           INT8_C(  11), INT8_C( -94), INT8_C( -32), INT8_C( 110),
                           INT8_C(  33), INT8_C( -24), INT8_C( 125), INT8_C(  35),
                           INT8_C(-103), INT8_C( -48), INT8_C( -22), INT8_C(  38),
                           INT8_C( -81), INT8_C(   9), INT8_C( -11), INT8_C(-124),
                           INT8_C(  71), INT8_C(  31), INT8_C( -42), INT8_C(  93),
                           INT8_C(  67), INT8_C(  45), INT8_C(  51), INT8_C( -92),
                           INT8_C( 126), INT8_C( 108), INT8_C(-123), INT8_C( -71),
                           INT8_C( 113), INT8_C(  32), INT8_C(  71), INT8_C(  55),
                           INT8_C( -26), INT8_C(  82), INT8_C( -81), INT8_C( -20)),
      simde_mm512_set_epi8(INT8_C(-125), INT8_C( 121), INT8_C(-128), INT8_C( 103),
                           INT8_C(   0), INT8_C( 101), INT8_C( -41), INT8_C(  89),
                           INT8_C( -83), INT8_C( -65), INT8_C(   9), INT8_C(  -7),
                           INT8_C( -63), INT8_C(  13), INT8_C( 105), INT8_C(  92),
                           INT8_C( -18), INT8_C( -21), INT8_C(-102), INT8_C(-114),
                           INT8_C(  74), INT8_C( 121), INT8_C( -45), INT8_C(  52),
                           INT8_C( -63), INT8_C( -93), INT8_C(  98), INT8_C( 106),
                           INT8_C(-109), INT8_C( -47), INT8_C(  37), INT8_C(  70),
                           INT8_C( 100), INT8_C( 121), INT8_C(  18), INT8_C(  28),
                           INT8_C(-117), INT8_C( 107), INT8_C(   3), INT8_C( -62),
                           INT8_C(  42), INT8_C(  72), INT8_C(  91), INT8_C(  86),
                           INT8_C( -72), INT8_C(   9), INT8_C( -80), INT8_C( 118),
                           INT8_C( 122), INT8_C(-108), INT8_C( -70), INT8_C( -63),
                           INT8_C(  56), INT8_C(  71), INT8_C( -14), INT8_C(  49),
                           INT8_C( -73), INT8_C(  53), INT8_C( -29), INT8_C(   3),
                           INT8_C( -73), INT8_C(  43), INT8_C( -22), INT8_C(  85)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(-119), INT8_C( 120), INT8_C(  -5),
                           INT8_C( 113), INT8_C(  62), INT8_C(  17), INT8_C(-119),
                           INT8_C( -30), INT8_C(   0), INT8_C(-119), INT8_C(   0),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(   0), INT8_C(  64),
                           INT8_C( -75), INT8_C( -34), INT8_C( -21), INT8_C(  24),
                           INT8_C( 105), INT8_C(  52), INT8_C( -94), INT8_C(-104),
                           INT8_C(  57), INT8_C(   0), INT8_C( -38), INT8_C(-128),
                           INT8_C(-107), INT8_C( -22), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  71), INT8_C(   0),
                           INT8_C( -48), INT8_C( 125), INT8_C(-103), INT8_C(   9),
                           INT8_C(   0), INT8_C( -11), INT8_C(   0), INT8_C(   9),
                           INT8_C( -53), INT8_C(   0), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(   0), INT8_C(  -8),
                           INT8_C( -15), INT8_C( 126), INT8_C(   0), INT8_C(  71)) },
    { simde_mm512_set_epi8(INT8_C( -47), INT8_C(  84), INT8_C(-126), INT8_C( -64),
                           INT8_C(  14), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  67), INT8_C( 124), INT8_C(  58), INT8_C( -94),
                           INT8_C(  30), INT8_C( -33), INT8_C(  70), INT8_C( -24),
                           INT8_C(  38), INT8_C( -97), INT8_C( -56), INT8_C( -60),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(  45),
                           INT8_C( -11), INT8_C(  55), INT8_C( -82), INT8_C(  12),
                           INT8_C( 106), INT8_C(  22), INT8_C(-124), INT8_C(  -4),
                           INT8_C(   2), INT8_C( -81), INT8_C(  14), INT8_C(  90),
                           INT8_C(-100), INT8_C(-122), INT8_C( -35), INT8_C(  81),
                           INT8_C( -14), INT8_C( -42), INT8_C( 125), INT8_C(-125),
                           INT8_C( -57), INT8_C(  90), INT8_C(  -9), INT8_C(  63),
                           INT8_C(  53), INT8_C(  77), INT8_C(  63), INT8_C( -84),
                           INT8_C(  27), INT8_C(  22), INT8_C(   3), INT8_C( -37),
                           INT8_C(  65), INT8_C( 118), INT8_C(-126), INT8_C(  97),
                           INT8_C( 109), INT8_C(   7), INT8_C(-114), INT8_C( -75)),
      UINT64_C( 8707623543556880126),
      simde_mm512_set_epi8(INT8_C(  84), INT8_C( -71), INT8_C(   8), INT8_C(  12),
                           INT8_C( -11), INT8_C( -76), INT8_C(  62), INT8_C(  93),
                           INT8_C( -75), INT8_C( -77), INT8_C( -84), INT8_C(-108),
                           INT8_C( -35), INT8_C(  14), INT8_C( -60), INT8_C(  18),
                           INT8_C(  23), INT8_C( -60), INT8_C( -63), INT8_C(-114),
                           INT8_C( -55), INT8_C(  75), INT8_C( -99), INT8_C( -55),
                           INT8_C(  58), INT8_C(  76), INT8_C(-102), INT8_C(-118),
                           INT8_C( -30), INT8_C(  39), INT8_C( 119), INT8_C(  85),
                           INT8_C(  -8), INT8_C( -72), INT8_C( -60), INT8_C( -94),
                           INT8_C(-112), INT8_C( 119), INT8_C( 124), INT8_C(  76),
                           INT8_C( -42), INT8_C(-124), INT8_C(  54), INT8_C(  74),
                           INT8_C( -92), INT8_C(  99), INT8_C(  79), INT8_C(  -3),
                           INT8_C(  61), INT8_C( -89), INT8_C(  84), INT8_C( -94),
                           INT8_C(  31), INT8_C(-116), INT8_C( -67), INT8_C(-102),
                           INT8_C( -72), INT8_C( -91), INT8_C(-105), INT8_C(-108),
                           INT8_C( -44), INT8_C(  74), INT8_C( -28), INT8_C( 124)),
      simde_mm512_set_epi8(INT8_C(   1), INT8_C(  75), INT8_C(  21), INT8_C( -36),
                           INT8_C(-126), INT8_C( 122), INT8_C(  71), INT8_C(  76),
                           INT8_C(  28), INT8_C( -56), INT8_C(  32), INT8_C( 101),
                           INT8_C(-107), INT8_C(-111), INT8_C( -88), INT8_C( -19),
                           INT8_C( -77), INT8_C(  19), INT8_C( -21), INT8_C(-111),
                           INT8_C( -68), INT8_C(  82), INT8_C(-118), INT8_C( -76),
                           INT8_C(  47), INT8_C( 127), INT8_C(  62), INT8_C( -16),
                           INT8_C(  10), INT8_C( -14), INT8_C(-100), INT8_C(  86),
                           INT8_C(  29), INT8_C( 107), INT8_C(  56), INT8_C(  21),
                           INT8_C(  24), INT8_C(  68), INT8_C( -96), INT8_C(  64),
                           INT8_C(  48), INT8_C(  13), INT8_C( -83), INT8_C(   4),
                           INT8_C(  -3), INT8_C( -64), INT8_C(  17), INT8_C(-115),
                           INT8_C(  21), INT8_C( 108), INT8_C( 125), INT8_C( -60),
                           INT8_C( -72), INT8_C(  74), INT8_C(  -5), INT8_C( -58),
                           INT8_C( -41), INT8_C(  22), INT8_C(-115), INT8_C( 102),
                           INT8_C(  59), INT8_C( -80), INT8_C( -15), INT8_C( -63)),
      simde_mm512_set_epi8(INT8_C( -47), INT8_C( -11), INT8_C( -84), INT8_C(   0),
                           INT8_C(   0), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  12), INT8_C(   0), INT8_C(  58), INT8_C( -84),
                           INT8_C(  30), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -97), INT8_C(   0), INT8_C(   0),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(   0),
                           INT8_C( -11), INT8_C(  23), INT8_C( -60), INT8_C(   0),
                           INT8_C(  75), INT8_C(  22), INT8_C(   0), INT8_C(  -4),
                           INT8_C(   2), INT8_C(-112), INT8_C(  14), INT8_C(  54),
                           INT8_C(-100), INT8_C(  74), INT8_C(   0), INT8_C(  -3),
                           INT8_C(  -3), INT8_C( -42), INT8_C( 125), INT8_C(-125),
                           INT8_C(   0), INT8_C(  90), INT8_C(  -9), INT8_C(   0),
                           INT8_C(  53), INT8_C(  77), INT8_C(  84), INT8_C(   0),
                           INT8_C(  27), INT8_C(-116), INT8_C(   0), INT8_C( -37),
                           INT8_C(   0), INT8_C( -91), INT8_C(   0), INT8_C( -91),
                           INT8_C(  31), INT8_C(   0), INT8_C(   0), INT8_C( -75)) },
    { simde_mm512_set_epi8(INT8_C( -64), INT8_C( -53), INT8_C( -42), INT8_C( 126),
                           INT8_C(  67), INT8_C(  50), INT8_C( -18), INT8_C(  76),
                           INT8_C( -19), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C( -74), INT8_C(  44), INT8_C( 117), INT8_C( 103),
                           INT8_C(  81), INT8_C( 122), INT8_C(  56), INT8_C( -10),
                           INT8_C(  67), INT8_C(  79), INT8_C(  83), INT8_C( -38),
                           INT8_C( -13), INT8_C(  43), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C( 126), INT8_C(  38), INT8_C( -62),
                           INT8_C( -24), INT8_C( 117), INT8_C( -38), INT8_C( -93),
                           INT8_C( -58), INT8_C(-124), INT8_C( -75), INT8_C(  10),
                           INT8_C(  18), INT8_C( -74), INT8_C(  14), INT8_C(  36),
                           INT8_C(  -7), INT8_C( 113), INT8_C(  40), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  85),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C( -21),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  72), INT8_C(  93), INT8_C( 108), INT8_C( 125)),
      UINT64_C(12576710173448868104),
      simde_mm512_set_epi8(INT8_C(  90), INT8_C( -38), INT8_C( -98), INT8_C( -70),
                           INT8_C(-108), INT8_C(  20), INT8_C(  43), INT8_C(-128),
                           INT8_C(  77), INT8_C( 108), INT8_C(  53), INT8_C(  82),
                           INT8_C( -50), INT8_C(  52), INT8_C(  56), INT8_C(  58),
                           INT8_C(-120), INT8_C( -43), INT8_C( 114), INT8_C(  93),
                           INT8_C( -44), INT8_C( -15), INT8_C(  38), INT8_C( -17),
                           INT8_C(-110), INT8_C(-123), INT8_C( -39), INT8_C( 114),
                           INT8_C(  51), INT8_C(-115), INT8_C( -74), INT8_C(  43),
                           INT8_C(  41), INT8_C( -36), INT8_C(  19), INT8_C(  69),
                           INT8_C(  60), INT8_C( -53), INT8_C( 112), INT8_C( 108),
                           INT8_C(   8), INT8_C(  46), INT8_C( -35), INT8_C(  26),
                           INT8_C(  11), INT8_C(  42), INT8_C(  47), INT8_C(  59),
                           INT8_C( -57), INT8_C(  94), INT8_C(-125), INT8_C(-124),
                           INT8_C(  36), INT8_C(  57), INT8_C(  68), INT8_C( -52),
                           INT8_C(  39), INT8_C(  50), INT8_C( -48), INT8_C(  94),
                           INT8_C(  53), INT8_C(  11), INT8_C(  29), INT8_C(  65)),
      simde_mm512_set_epi8(INT8_C(-107), INT8_C( 120), INT8_C( -58), INT8_C( 107),
                           INT8_C( -32), INT8_C( -32), INT8_C(  88), INT8_C( -43),
                           INT8_C(  31), INT8_C( -32), INT8_C( -64), INT8_C(  27),
                           INT8_C(  82), INT8_C( -90), INT8_C( -54), INT8_C( -84),
                           INT8_C( -30), INT8_C(  63), INT8_C(  24), INT8_C(  81),
                           INT8_C(  -8), INT8_C(   9), INT8_C( -35), INT8_C(-101),
                           INT8_C(  83), INT8_C( 107), INT8_C( -47), INT8_C( -56),
                           INT8_C(  57), INT8_C( -88), INT8_C(-115), INT8_C( -20),
                           INT8_C(  58), INT8_C(  75), INT8_C(  56), INT8_C(  93),
                           INT8_C(  49), INT8_C(  43), INT8_C( 108), INT8_C( 118),
                           INT8_C( -79), INT8_C( 112), INT8_C(  44), INT8_C(-112),
                           INT8_C( -52), INT8_C(  10), INT8_C(  28), INT8_C( -86),
                           INT8_C(  65), INT8_C(  62), INT8_C(  86), INT8_C(-107),
                           INT8_C(  24), INT8_C( -55), INT8_C(  54), INT8_C(-110),
                           INT8_C( -33), INT8_C( 110), INT8_C(-116), INT8_C( -39),
                           INT8_C(  39), INT8_C(-112), INT8_C(  64), INT8_C(  43)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C( -53), INT8_C(   0), INT8_C( 126),
                           INT8_C(   0), INT8_C(   0), INT8_C(-128), INT8_C(  76),
                           INT8_C(  90), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C(  52), INT8_C(  44), INT8_C( 117), INT8_C(   0),
                           INT8_C(  81), INT8_C(-120), INT8_C( -17), INT8_C( -74),
                           INT8_C(  67), INT8_C(  79), INT8_C(   0), INT8_C(   0),
                           INT8_C( -13), INT8_C( -44), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C(   0), INT8_C(  38), INT8_C( -62),
                           INT8_C( -53), INT8_C( 117), INT8_C( 108), INT8_C(  19),
                           INT8_C(  47), INT8_C(-124), INT8_C(  69), INT8_C(  46),
                           INT8_C(  18), INT8_C(  59), INT8_C(  69), INT8_C(   0),
                           INT8_C(  -7), INT8_C( -53), INT8_C(  69), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(   0),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C(   0),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  39), INT8_C(  93), INT8_C( 108), INT8_C( 125)) },
    { simde_mm512_set_epi8(INT8_C(-103), INT8_C(-124), INT8_C(  13), INT8_C( -80),
                           INT8_C( -32), INT8_C( 123), INT8_C( 115), INT8_C( -49),
                           INT8_C( 113), INT8_C( -51), INT8_C( 119), INT8_C( -67),
                           INT8_C( -21), INT8_C(  19), INT8_C( -12), INT8_C(  29),
                           INT8_C(  91), INT8_C( -64), INT8_C(  88), INT8_C(-105),
                           INT8_C(  24), INT8_C(  31), INT8_C(  77), INT8_C(  92),
                           INT8_C( -85), INT8_C(  48), INT8_C(-113), INT8_C(-114),
                           INT8_C(  16), INT8_C(  18), INT8_C( -44), INT8_C( -66),
                           INT8_C(  25), INT8_C(-105), INT8_C(-100), INT8_C( -91),
                           INT8_C(  26), INT8_C(-123), INT8_C( -33), INT8_C( -37),
                           INT8_C(  63), INT8_C(  13), INT8_C(-124), INT8_C(  41),
                           INT8_C(-104), INT8_C( -59), INT8_C(  -2), INT8_C( -54),
                           INT8_C(  73), INT8_C(   3), INT8_C( -18), INT8_C(  10),
                           INT8_C(  19), INT8_C(  58), INT8_C( -12), INT8_C( -75),
                           INT8_C( -88), INT8_C(  59), INT8_C( 104), INT8_C( -40),
                           INT8_C( -82), INT8_C(  42), INT8_C( -73), INT8_C( -94)),
      UINT64_C( 2633789449456316803),
      simde_mm512_set_epi8(INT8_C( 118), INT8_C(  44), INT8_C( -14), INT8_C(  84),
                           INT8_C( -69), INT8_C( -48), INT8_C(  40), INT8_C(  86),
                           INT8_C(  -1), INT8_C( 121), INT8_C( -40), INT8_C(  44),
                           INT8_C(  -1), INT8_C(  38), INT8_C( -44), INT8_C(  38),
                           INT8_C(  93), INT8_C(-107), INT8_C(  -4), INT8_C( -61),
                           INT8_C( -52), INT8_C(  22), INT8_C( -54), INT8_C(-125),
                           INT8_C( -29), INT8_C(  25), INT8_C( -77), INT8_C( -68),
                           INT8_C(   9), INT8_C( -35), INT8_C( -11), INT8_C(  53),
                           INT8_C(  28), INT8_C(  61), INT8_C( -35), INT8_C(-106),
                           INT8_C( -46), INT8_C( 121), INT8_C(-102), INT8_C( 121),
                           INT8_C( -54), INT8_C( -60), INT8_C(   7), INT8_C(   2),
                           INT8_C(-119), INT8_C( 111), INT8_C( -20), INT8_C( -58),
                           INT8_C( -98), INT8_C(  83), INT8_C(  32), INT8_C( -49),
                           INT8_C( -11), INT8_C(  48), INT8_C(  92), INT8_C(  47),
                           INT8_C( -38), INT8_C(  11), INT8_C(  26), INT8_C(  90),
                           INT8_C(  -5), INT8_C(  73), INT8_C(  45), INT8_C(  -2)),
      simde_mm512_set_epi8(INT8_C( -31), INT8_C( 126), INT8_C(-118), INT8_C( -57),
                           INT8_C(-126), INT8_C(  29), INT8_C( 101), INT8_C( -15),
                           INT8_C( -61), INT8_C( 118), INT8_C( 102), INT8_C(  12),
                           INT8_C( -59), INT8_C( -41), INT8_C( -60), INT8_C(  46),
                           INT8_C(  63), INT8_C(  78), INT8_C(  87), INT8_C(  18),
                           INT8_C(  18), INT8_C(  32), INT8_C( -26), INT8_C(  -6),
                           INT8_C( -20), INT8_C(-123), INT8_C(  99), INT8_C(  65),
                           INT8_C(  13), INT8_C(  25), INT8_C( 108), INT8_C(-121),
                           INT8_C(  42), INT8_C(   0), INT8_C( 104), INT8_C( -17),
                           INT8_C( 111), INT8_C(-110), INT8_C( -39), INT8_C( 125),
                           INT8_C( -50), INT8_C( -47), INT8_C(  30), INT8_C(  92),
                           INT8_C(  19), INT8_C(  -8), INT8_C(-120), INT8_C( 127),
                           INT8_C( -49), INT8_C(  23), INT8_C(  16), INT8_C( -64),
                           INT8_C( -79), INT8_C( 116), INT8_C(  -5), INT8_C( -50),
                           INT8_C(  32), INT8_C(  22), INT8_C( -42), INT8_C(  -3),
                           INT8_C(  30), INT8_C(  64), INT8_C(  96), INT8_C( -66)),
      simde_mm512_set_epi8(INT8_C(-103), INT8_C(-124), INT8_C(   0), INT8_C( -80),
                           INT8_C( -32), INT8_C( -14), INT8_C( 115), INT8_C( -49),
                           INT8_C(   0), INT8_C( -51), INT8_C( 119), INT8_C( -67),
                           INT8_C(   0), INT8_C(   0), INT8_C( -12), INT8_C(  44),
                           INT8_C(  91), INT8_C( -64), INT8_C(  88), INT8_C( -35),
                           INT8_C( -35), INT8_C(  31), INT8_C(  77), INT8_C(   0),
                           INT8_C(   0), INT8_C(  48), INT8_C(-113), INT8_C(-114),
                           INT8_C(  -4), INT8_C( -54), INT8_C( -44), INT8_C( -66),
                           INT8_C( 121), INT8_C( -58), INT8_C(-100), INT8_C( -91),
                           INT8_C(  26), INT8_C(   0), INT8_C( -33), INT8_C( -37),
                           INT8_C(  63), INT8_C(  13), INT8_C(-124), INT8_C(  41),
                           INT8_C(-104), INT8_C( -59), INT8_C(   0), INT8_C(  28),
                           INT8_C(   0), INT8_C( -38), INT8_C(  -2), INT8_C(   0),
                           INT8_C(  19), INT8_C(  58), INT8_C( -12), INT8_C(   0),
                           INT8_C(  -2), INT8_C(  59), INT8_C( 104), INT8_C( -40),
                           INT8_C( -82), INT8_C(  42), INT8_C(  -2), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C( 117), INT8_C(  69), INT8_C( 121), INT8_C( -45),
                           INT8_C(  30), INT8_C( -73), INT8_C(   2), INT8_C( -40),
                           INT8_C(  95), INT8_C(  -3), INT8_C(  16), INT8_C( -78),
                           INT8_C(-128), INT8_C( -41), INT8_C( -66), INT8_C(  66),
                           INT8_C(  93), INT8_C( -32), INT8_C( -50), INT8_C(  -2),
                           INT8_C( -61), INT8_C(  29), INT8_C( -88), INT8_C(-118),
                           INT8_C( -27), INT8_C(  42), INT8_C(  78), INT8_C( -46),
                           INT8_C( -79), INT8_C(  38), INT8_C( -75), INT8_C(  14),
                           INT8_C(-118), INT8_C(-114), INT8_C(-120), INT8_C(  42),
                           INT8_C(   4), INT8_C(  79), INT8_C( -84), INT8_C(-110),
                           INT8_C(   0), INT8_C(  85), INT8_C( -20), INT8_C(  61),
                           INT8_C(  40), INT8_C( -75), INT8_C(  69), INT8_C( -99),
                           INT8_C(  73), INT8_C( -34), INT8_C( -14), INT8_C(  72),
                           INT8_C( 101), INT8_C(  96), INT8_C(-114), INT8_C(-124),
                           INT8_C( -87), INT8_C(  43), INT8_C(-118), INT8_C( 114),
                           INT8_C( -88), INT8_C(   8), INT8_C( -52), INT8_C(  75)),
      UINT64_C(14890918166471265655),
      simde_mm512_set_epi8(INT8_C( -56), INT8_C( -70), INT8_C(  66), INT8_C(-111),
                           INT8_C( -69), INT8_C(  15), INT8_C( -82), INT8_C( -12),
                           INT8_C( -89), INT8_C(  37), INT8_C(  80), INT8_C( 120),
                           INT8_C( -83), INT8_C(-120), INT8_C(  95), INT8_C(  21),
                           INT8_C(  91), INT8_C( -97), INT8_C( -72), INT8_C(  42),
                           INT8_C(  22), INT8_C( -70), INT8_C(  71), INT8_C( -78),
                           INT8_C(  -5), INT8_C(  52), INT8_C( -22), INT8_C( -34),
                           INT8_C(  16), INT8_C(  92), INT8_C(  91), INT8_C( -72),
                           INT8_C(   3), INT8_C( -31), INT8_C( -95), INT8_C( -56),
                           INT8_C( -50), INT8_C(  68), INT8_C( -24), INT8_C( -50),
                           INT8_C(  94), INT8_C(  67), INT8_C( 108), INT8_C(-118),
                           INT8_C( -65), INT8_C(  31), INT8_C(  70), INT8_C( 108),
                           INT8_C( -66), INT8_C( 107), INT8_C( -85), INT8_C(  38),
                           INT8_C(   2), INT8_C(  32), INT8_C(  56), INT8_C(  66),
                           INT8_C(  -2), INT8_C( -74), INT8_C( 112), INT8_C(  10),
                           INT8_C(  64), INT8_C( 100), INT8_C( -55), INT8_C(  83)),
      simde_mm512_set_epi8(INT8_C( -69), INT8_C( -45), INT8_C(  23), INT8_C(  70),
                           INT8_C(  22), INT8_C( 113), INT8_C(  75), INT8_C(-117),
                           INT8_C(  69), INT8_C( -74), INT8_C(  40), INT8_C( -39),
                           INT8_C( -51), INT8_C( -91), INT8_C(  25), INT8_C(  -4),
                           INT8_C( -12), INT8_C( -13), INT8_C( -77), INT8_C(  75),
                           INT8_C(-116), INT8_C( -36), INT8_C(  38), INT8_C( -52),
                           INT8_C(  13), INT8_C( -52), INT8_C(-100), INT8_C( -46),
                           INT8_C(  13), INT8_C(  83), INT8_C( -94), INT8_C( 102),
                           INT8_C( 116), INT8_C( -60), INT8_C(  44), INT8_C(  -7),
                           INT8_C( 104), INT8_C( -50), INT8_C( -30), INT8_C(  17),
                           INT8_C(  13), INT8_C(-107), INT8_C( 111), INT8_C( -13),
                           INT8_C(  17), INT8_C( -45), INT8_C( -31), INT8_C(  76),
                           INT8_C(-102), INT8_C( -71), INT8_C( 116), INT8_C(  72),
                           INT8_C( -11), INT8_C( -97), INT8_C(  93), INT8_C(  48),
                           INT8_C( -75), INT8_C( -90), INT8_C( -10), INT8_C( -78),
                           INT8_C(  -8), INT8_C( -10), INT8_C(  48), INT8_C( -11)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C( 121), INT8_C( -45),
                           INT8_C(  37), INT8_C(  95), INT8_C( -69), INT8_C( -40),
                           INT8_C(  80), INT8_C(  -3), INT8_C( -12), INT8_C( -78),
                           INT8_C(-128), INT8_C(   0), INT8_C( -82), INT8_C(   0),
                           INT8_C(  93), INT8_C( -32), INT8_C(   0), INT8_C(  -2),
                           INT8_C(   0), INT8_C(  29), INT8_C(  52), INT8_C(   0),
                           INT8_C( -27), INT8_C(  42), INT8_C(   0), INT8_C( -46),
                           INT8_C( -72), INT8_C(  16), INT8_C( -75), INT8_C(  52),
                           INT8_C(-118), INT8_C(   0), INT8_C(-120), INT8_C(  42),
                           INT8_C( -50), INT8_C(  79), INT8_C(   0), INT8_C(  70),
                           INT8_C( -95), INT8_C(   0), INT8_C(   3), INT8_C(  61),
                           INT8_C(  70), INT8_C(   0), INT8_C(   0), INT8_C( -99),
                           INT8_C(  73), INT8_C(   0), INT8_C( -14), INT8_C(  72),
                           INT8_C(   0), INT8_C(   0), INT8_C(-114), INT8_C(  83),
                           INT8_C( -87), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -88), INT8_C(   0), INT8_C(  83), INT8_C(   0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_shuffle_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_maskz_shuffle_epi8(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C(17286015531074160252),
      simde_mm512_set_epi8(INT8_C(-115), INT8_C( -27), INT8_C(  62), INT8_C( -85),
                           INT8_C(  49), INT8_C(-115), INT8_C(  38), INT8_C(   4),
                           INT8_C(  92), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C( -73), INT8_C(  22), INT8_C( -66), INT8_C( -29),
                           INT8_C(  55), INT8_C(  78), INT8_C( -45), INT8_C(-119),
                           INT8_C(  30), INT8_C( -29), INT8_C( -23), INT8_C(  89),
                           INT8_C(  15), INT8_C( 119), INT8_C( -88), INT8_C( 109),
                           INT8_C( -16), INT8_C( -10), INT8_C(   0), INT8_C( -18),
                           INT8_C(   1), INT8_C( 116), INT8_C(  62), INT8_C( -73),
                           INT8_C(-122), INT8_C(   0), INT8_C( 111), INT8_C(  95),
                           INT8_C( -20), INT8_C(   3), INT8_C( 122), INT8_C(-121),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(-127),
                           INT8_C(  82), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  73), INT8_C( 108), INT8_C( -18), INT8_C(  15),
                           INT8_C(  81), INT8_C( -27), INT8_C( 102), INT8_C( 118),
                           INT8_C(  39), INT8_C( -77), INT8_C(  45), INT8_C(  81)),
      simde_mm512_set_epi8(INT8_C(  68), INT8_C(-108), INT8_C(-121), INT8_C(-115),
                           INT8_C( -59), INT8_C( -78), INT8_C(-111), INT8_C(  56),
                           INT8_C(   9), INT8_C(-121), INT8_C( 120), INT8_C( -36),
                           INT8_C(  36), INT8_C(-103), INT8_C(-104), INT8_C(  25),
                           INT8_C(-111), INT8_C( -63), INT8_C( -35), INT8_C(-120),
                           INT8_C(  28), INT8_C( -44), INT8_C( -26), INT8_C( -86),
                           INT8_C( -13), INT8_C(  53), INT8_C( -88), INT8_C(-107),
                           INT8_C(  68), INT8_C(  42), INT8_C(-118), INT8_C( 111),
                           INT8_C(  54), INT8_C( -58), INT8_C( -13), INT8_C(  27),
                           INT8_C(  23), INT8_C(  41), INT8_C(-119), INT8_C(  44),
                           INT8_C(   7), INT8_C(-120), INT8_C(  32), INT8_C( -43),
                           INT8_C( 114), INT8_C( -72), INT8_C(  73), INT8_C( -96),
                           INT8_C(  96), INT8_C( 110), INT8_C( -81), INT8_C( -76),
                           INT8_C( 103), INT8_C(-100), INT8_C( -22), INT8_C(  18),
                           INT8_C( 115), INT8_C(  54), INT8_C( -40), INT8_C( 125),
                           INT8_C( 110), INT8_C(  31), INT8_C(  51), INT8_C(-104)),
      simde_mm512_set_epi8(INT8_C( -19), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   4),
                           INT8_C(  38), INT8_C(   0), INT8_C(   4), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 109), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -20), INT8_C( 111), INT8_C(   0), INT8_C( -73),
                           INT8_C( -20), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  25), INT8_C(   0), INT8_C( 111), INT8_C(   0),
                           INT8_C(  81), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -27), INT8_C(   0), INT8_C(  53),
                           INT8_C(  90), INT8_C(  82), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C( 9031211210081693899),
      simde_mm512_set_epi8(INT8_C(-106), INT8_C( -18), INT8_C(  65), INT8_C(-104),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  -2),
                           INT8_C( -14), INT8_C(  85), INT8_C( -80), INT8_C(  80),
                           INT8_C(  48), INT8_C(  93), INT8_C(  79), INT8_C( 127),
                           INT8_C(  16), INT8_C(  41), INT8_C(  54), INT8_C(-116),
                           INT8_C(  17), INT8_C(  42), INT8_C( -86), INT8_C(  38),
                           INT8_C(-118), INT8_C( -56), INT8_C(  60), INT8_C(  19),
                           INT8_C(-100), INT8_C(-107), INT8_C( 105), INT8_C( -76),
                           INT8_C(  10), INT8_C(  -9), INT8_C( -12), INT8_C( -56),
                           INT8_C( -71), INT8_C(  96), INT8_C(   6), INT8_C(  24),
                           INT8_C(  69), INT8_C(  73), INT8_C( -27), INT8_C(   3),
                           INT8_C( -95), INT8_C(  50), INT8_C( -67), INT8_C( -39),
                           INT8_C(  97), INT8_C(  62), INT8_C( 101), INT8_C(  56),
                           INT8_C( -79), INT8_C(  83), INT8_C( -99), INT8_C( -56),
                           INT8_C( -17), INT8_C( -56), INT8_C(  -8), INT8_C( -16),
                           INT8_C(  84), INT8_C( -95), INT8_C( -73), INT8_C(  54)),
      simde_mm512_set_epi8(INT8_C(  63), INT8_C( -51), INT8_C(  87), INT8_C(  32),
                           INT8_C( -65), INT8_C(  55), INT8_C(  14), INT8_C(  81),
                           INT8_C(-123), INT8_C(-100), INT8_C( -39), INT8_C( -44),
                           INT8_C(  22), INT8_C( 112), INT8_C(  16), INT8_C(  15),
                           INT8_C(-104), INT8_C(-102), INT8_C( 102), INT8_C( -95),
                           INT8_C(  69), INT8_C(  13), INT8_C( -21), INT8_C(  45),
                           INT8_C(  62), INT8_C(-120), INT8_C(-111), INT8_C(  32),
                           INT8_C(-107), INT8_C( -30), INT8_C(  99), INT8_C( -64),
                           INT8_C(   8), INT8_C( -42), INT8_C(  81), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -71), INT8_C(  46),
                           INT8_C( -21), INT8_C( -73), INT8_C(  21), INT8_C(  83),
                           INT8_C(-108), INT8_C( -97), INT8_C( -69), INT8_C(  73),
                           INT8_C(  57), INT8_C( -37), INT8_C(  21), INT8_C(  82),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C( 115), INT8_C(  31), INT8_C( -79), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C( -14), INT8_C( 127),
                           INT8_C(   0), INT8_C( -14), INT8_C(   0), INT8_C(  79),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 127), INT8_C(   0), INT8_C(-106),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  60), INT8_C(  54), INT8_C(   0), INT8_C(   0),
                           INT8_C(  41), INT8_C(   0), INT8_C(   0), INT8_C( -76),
                           INT8_C(   0), INT8_C(   0), INT8_C(-100), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  96), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -9),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -95),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -99),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  84), INT8_C(   0), INT8_C(   0), INT8_C(  56)) },
    { UINT64_C( 6828010367541473016),
      simde_mm512_set_epi8(INT8_C(  84), INT8_C( -96), INT8_C(  87), INT8_C( -22),
                           INT8_C(  -5), INT8_C(  -3), INT8_C(-127), INT8_C(  41),
                           INT8_C(  74), INT8_C(  72), INT8_C(  -4), INT8_C(  28),
                           INT8_C(-115), INT8_C(  93), INT8_C( 102), INT8_C(  44),
                           INT8_C(-103), INT8_C( -29), INT8_C( -50), INT8_C(  48),
                           INT8_C( -96), INT8_C( -50), INT8_C(  46), INT8_C( -65),
                           INT8_C(   4), INT8_C(  43), INT8_C( -75), INT8_C(  97),
                           INT8_C( -26), INT8_C(-103), INT8_C(  71), INT8_C(-107),
                           INT8_C(  91), INT8_C(  45), INT8_C( -11), INT8_C(  47),
                           INT8_C(  29), INT8_C(  25), INT8_C(  26), INT8_C(  -9),
                           INT8_C(  10), INT8_C(  36), INT8_C( -79), INT8_C( -53),
                           INT8_C(  41), INT8_C(   1), INT8_C( -23), INT8_C( -63),
                           INT8_C(-127), INT8_C(  68), INT8_C(  48), INT8_C(  36),
                           INT8_C(  89), INT8_C(-112), INT8_C( -31), INT8_C( 120),
                           INT8_C(  35), INT8_C(  62), INT8_C( -21), INT8_C(-114),
                           INT8_C(-104), INT8_C(  57), INT8_C(  42), INT8_C(-111)),
      simde_mm512_set_epi8(INT8_C(  96), INT8_C( -64), INT8_C( -23), INT8_C( -46),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90),
                           INT8_C(  44), INT8_C( -92), INT8_C( -31), INT8_C(  26),
                           INT8_C( -99), INT8_C( -53), INT8_C( 117), INT8_C(  18),
                           INT8_C( -63), INT8_C(  45), INT8_C(  12), INT8_C(  24),
                           INT8_C(-108), INT8_C(  18), INT8_C( -60), INT8_C(  28),
                           INT8_C(  50), INT8_C( -11), INT8_C( -68), INT8_C( -31),
                           INT8_C( 105), INT8_C(-106), INT8_C(  98), INT8_C(  51),
                           INT8_C(  58), INT8_C( 103), INT8_C( 111), INT8_C(-127),
                           INT8_C(  68), INT8_C( -56), INT8_C( 124), INT8_C(-119),
                           INT8_C(  74), INT8_C( -62), INT8_C(-116), INT8_C(  37),
                           INT8_C( -12), INT8_C( 114), INT8_C(   0), INT8_C(  61),
                           INT8_C( 103), INT8_C(  -4), INT8_C(-105), INT8_C( -68),
                           INT8_C(  39), INT8_C(-100), INT8_C( -93), INT8_C(  11),
                           INT8_C( -80), INT8_C( -19), INT8_C( -22), INT8_C( -39),
                           INT8_C( 127), INT8_C( -38), INT8_C(-125), INT8_C(-111)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  74), INT8_C(   0),
                           INT8_C( -22), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  93),
                           INT8_C(   0), INT8_C( -50), INT8_C(  48), INT8_C( -65),
                           INT8_C(   0), INT8_C(-103), INT8_C(   0), INT8_C(  48),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  25), INT8_C(   0), INT8_C(  91), INT8_C(   0),
                           INT8_C( -53), INT8_C(   0), INT8_C(  47), INT8_C(   0),
                           INT8_C(  25), INT8_C(   0), INT8_C(   0), INT8_C( -79),
                           INT8_C(   0), INT8_C(   1), INT8_C( -63), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  35), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-127), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(18325019528117086600),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C( -54), INT8_C(  50), INT8_C( 123),
                           INT8_C( -31), INT8_C( -74), INT8_C( -64), INT8_C(  54),
                           INT8_C( -81), INT8_C(  60), INT8_C(  31), INT8_C( -23),
                           INT8_C( 108), INT8_C(-119), INT8_C( -92), INT8_C( -80),
                           INT8_C( -30), INT8_C( -37), INT8_C(  51), INT8_C( -36),
                           INT8_C(   8), INT8_C(  52), INT8_C(  97), INT8_C( 123),
                           INT8_C( -49), INT8_C(-124), INT8_C(  95), INT8_C( -83),
                           INT8_C(  70), INT8_C( -50), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(  11),
                           INT8_C( -14), INT8_C( 126), INT8_C(  81), INT8_C(  45),
                           INT8_C( -23), INT8_C( 120), INT8_C( -83), INT8_C( -16),
                           INT8_C(   7), INT8_C(  51), INT8_C( -57), INT8_C( -50),
                           INT8_C( -21), INT8_C(  98), INT8_C(  88), INT8_C(   0),
                           INT8_C( -66), INT8_C(   3), INT8_C( 124), INT8_C(-113),
                           INT8_C(  50), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C( -44), INT8_C( -13), INT8_C( -94), INT8_C(  17)),
      simde_mm512_set_epi8(INT8_C( -13), INT8_C( -12), INT8_C(-124), INT8_C(  96),
                           INT8_C( -13), INT8_C( -98), INT8_C(  99), INT8_C( -13),
                           INT8_C(  56), INT8_C( -45), INT8_C(-108), INT8_C( -19),
                           INT8_C(-124), INT8_C( -27), INT8_C(  22), INT8_C( 126),
                           INT8_C(-106), INT8_C( -68), INT8_C( -60), INT8_C(   8),
                           INT8_C(  60), INT8_C(  93), INT8_C( -33), INT8_C( -27),
                           INT8_C(  -7), INT8_C(  27), INT8_C(-122), INT8_C( -38),
                           INT8_C(  23), INT8_C(   6), INT8_C(  45), INT8_C( -21),
                           INT8_C( -23), INT8_C(-101), INT8_C( 116), INT8_C( 127),
                           INT8_C(  96), INT8_C(  40), INT8_C( -97), INT8_C(  40),
                           INT8_C(  86), INT8_C( -44), INT8_C(  70), INT8_C( -71),
                           INT8_C(  62), INT8_C( -21), INT8_C(  66), INT8_C(  68),
                           INT8_C( -87), INT8_C( -61), INT8_C(  48), INT8_C( -70),
                           INT8_C(  18), INT8_C( -78), INT8_C( -98), INT8_C( 117),
                           INT8_C(  74), INT8_C(  32), INT8_C(  93), INT8_C( 125),
                           INT8_C( -47), INT8_C( -60), INT8_C( -86), INT8_C( 117)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -80),
                           INT8_C(   0), INT8_C(   0), INT8_C( 108), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  60), INT8_C( -54),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -36), INT8_C(  51), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -49), INT8_C(   0), INT8_C(  51), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -16), INT8_C( -97),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  45),
                           INT8_C( 120), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  51), INT8_C( -16),
                           INT8_C(   0), INT8_C(   0), INT8_C(  17), INT8_C(   0),
                           INT8_C( -13), INT8_C(   0), INT8_C(   0), INT8_C( -85),
                           INT8_C(   3), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C( 7677112093376593822),
      simde_mm512_set_epi8(INT8_C( -53), INT8_C(  34), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  69), INT8_C(  -8),
                           INT8_C( -15), INT8_C( -51), INT8_C(   1), INT8_C(  90),
                           INT8_C( 115), INT8_C(  51), INT8_C( -91), INT8_C(  56),
                           INT8_C(  64), INT8_C( -39), INT8_C(-119), INT8_C( -28),
                           INT8_C( -54), INT8_C(  28), INT8_C(  54), INT8_C(  -8),
                           INT8_C( -54), INT8_C(-128), INT8_C( -28), INT8_C( -71),
                           INT8_C( 107), INT8_C( -66), INT8_C(-114), INT8_C( -88),
                           INT8_C(  34), INT8_C( -83), INT8_C( -21), INT8_C( -64),
                           INT8_C( 121), INT8_C( -20), INT8_C( -89), INT8_C( -94),
                           INT8_C( 112), INT8_C( -27), INT8_C(  81), INT8_C( -54),
                           INT8_C( -64), INT8_C(-114), INT8_C(  48), INT8_C( -89),
                           INT8_C( -61), INT8_C(  26), INT8_C(  43), INT8_C(  29),
                           INT8_C(   0), INT8_C(  64), INT8_C( 123), INT8_C( -67),
                           INT8_C(  15), INT8_C( 120), INT8_C(  36), INT8_C(  40)),
      simde_mm512_set_epi8(INT8_C( 113), INT8_C(  32), INT8_C(  71), INT8_C(  55),
                           INT8_C( -26), INT8_C(  82), INT8_C( -81), INT8_C( -20),
                           INT8_C( -55), INT8_C( 112), INT8_C(  45), INT8_C(  37),
                           INT8_C(  67), INT8_C( -69), INT8_C(  64), INT8_C(  39),
                           INT8_C(  72), INT8_C(  45), INT8_C( 120), INT8_C(  -5),
                           INT8_C(-109), INT8_C(  62), INT8_C(  17), INT8_C(  31),
                           INT8_C( -30), INT8_C( -58), INT8_C(  56), INT8_C(  21),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(  32), INT8_C(  64),
                           INT8_C(-128), INT8_C( 102), INT8_C( -21), INT8_C(  28),
                           INT8_C( 105), INT8_C(  52), INT8_C(  85), INT8_C(-104),
                           INT8_C(  57), INT8_C( -31), INT8_C( -38), INT8_C(-124),
                           INT8_C(-107), INT8_C(  -2), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  18), INT8_C(  70),
                           INT8_C(  89), INT8_C( 125), INT8_C( -42), INT8_C(-125),
                           INT8_C( 121), INT8_C( -11), INT8_C( -69), INT8_C( -59)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(  90), INT8_C(  65), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -15), INT8_C(   0), INT8_C(  90), INT8_C(   0),
                           INT8_C( -28), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  51), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -54),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -21), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-114),
                           INT8_C(   0), INT8_C(  48), INT8_C( 120), INT8_C(  64),
                           INT8_C(  43), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  43), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C( 4840581956081845689),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C(-108), INT8_C( -70), INT8_C( -63),
                           INT8_C(  56), INT8_C(  71), INT8_C( -14), INT8_C(  49),
                           INT8_C( -73), INT8_C(  53), INT8_C( -29), INT8_C(   3),
                           INT8_C( -73), INT8_C(  43), INT8_C( -22), INT8_C(  85),
                           INT8_C( -26), INT8_C(  -9), INT8_C(  66), INT8_C(   1),
                           INT8_C( -13), INT8_C(  60), INT8_C(-119), INT8_C( -83),
                           INT8_C(-122), INT8_C( -64), INT8_C( -83), INT8_C( -74),
                           INT8_C( 119), INT8_C(  -8), INT8_C(  12), INT8_C( 113),
                           INT8_C( -12), INT8_C( -84), INT8_C(   6), INT8_C(  69),
                           INT8_C(   2), INT8_C( -75), INT8_C( -34), INT8_C(-126),
                           INT8_C(   3), INT8_C(-128), INT8_C(  -9), INT8_C(  24),
                           INT8_C(  11), INT8_C( -94), INT8_C( -32), INT8_C( 110),
                           INT8_C(  33), INT8_C( -24), INT8_C( 125), INT8_C(  35),
                           INT8_C(-103), INT8_C( -48), INT8_C( -22), INT8_C(  38),
                           INT8_C( -81), INT8_C(   9), INT8_C( -11), INT8_C(-124),
                           INT8_C(  71), INT8_C(  31), INT8_C( -42), INT8_C(  93)),
      simde_mm512_set_epi8(INT8_C(  53), INT8_C(  77), INT8_C(  63), INT8_C( -84),
                           INT8_C(  27), INT8_C(  22), INT8_C(   3), INT8_C( -37),
                           INT8_C(  65), INT8_C( 118), INT8_C(-126), INT8_C(  97),
                           INT8_C( 109), INT8_C(   7), INT8_C(-114), INT8_C( -75),
                           INT8_C(-125), INT8_C( 121), INT8_C(-128), INT8_C( 103),
                           INT8_C(   0), INT8_C( 101), INT8_C( -41), INT8_C(  89),
                           INT8_C( -83), INT8_C( -65), INT8_C(   9), INT8_C(  -7),
                           INT8_C( -63), INT8_C(  13), INT8_C( 105), INT8_C(  92),
                           INT8_C( -18), INT8_C( -21), INT8_C(-102), INT8_C(-114),
                           INT8_C(  74), INT8_C( 121), INT8_C( -45), INT8_C(  52),
                           INT8_C( -63), INT8_C( -93), INT8_C(  98), INT8_C( 106),
                           INT8_C(-109), INT8_C( -47), INT8_C(  37), INT8_C(  70),
                           INT8_C( 100), INT8_C( 121), INT8_C(  18), INT8_C(  28),
                           INT8_C(-117), INT8_C( 107), INT8_C(   3), INT8_C( -62),
                           INT8_C(  42), INT8_C(  72), INT8_C(  91), INT8_C(  86),
                           INT8_C( -72), INT8_C(   9), INT8_C( -80), INT8_C( 118)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C( -70), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -73), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -70), INT8_C( -73), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-122),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-119),
                           INT8_C(   0), INT8_C(   0), INT8_C(-119), INT8_C(   0),
                           INT8_C(   0), INT8_C(  66), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -75), INT8_C( -34), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -94), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-124), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-103), INT8_C(   0), INT8_C(   0),
                           INT8_C( -48), INT8_C(   0), INT8_C(-103), INT8_C(   9),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   9)) },
    { UINT64_C(17498311407133456191),
      simde_mm512_set_epi8(INT8_C(  61), INT8_C( -89), INT8_C(  84), INT8_C( -94),
                           INT8_C(  31), INT8_C(-116), INT8_C( -67), INT8_C(-102),
                           INT8_C( -72), INT8_C( -91), INT8_C(-105), INT8_C(-108),
                           INT8_C( -44), INT8_C(  74), INT8_C( -28), INT8_C( 124),
                           INT8_C( 120), INT8_C( -41), INT8_C( -79), INT8_C( 122),
                           INT8_C(  87), INT8_C(-119), INT8_C(  54), INT8_C(  -2),
                           INT8_C( -47), INT8_C(  84), INT8_C(-126), INT8_C( -64),
                           INT8_C(  14), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  67), INT8_C( 124), INT8_C(  58), INT8_C( -94),
                           INT8_C(  30), INT8_C( -33), INT8_C(  70), INT8_C( -24),
                           INT8_C(  38), INT8_C( -97), INT8_C( -56), INT8_C( -60),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(  45),
                           INT8_C( -11), INT8_C(  55), INT8_C( -82), INT8_C(  12),
                           INT8_C( 106), INT8_C(  22), INT8_C(-124), INT8_C(  -4),
                           INT8_C(   2), INT8_C( -81), INT8_C(  14), INT8_C(  90),
                           INT8_C(-100), INT8_C(-122), INT8_C( -35), INT8_C(  81)),
      simde_mm512_set_epi8(INT8_C(  21), INT8_C( 108), INT8_C( 125), INT8_C( -60),
                           INT8_C( -72), INT8_C(  74), INT8_C(  -5), INT8_C( -58),
                           INT8_C( -41), INT8_C(  22), INT8_C(-115), INT8_C( 102),
                           INT8_C(  59), INT8_C( -80), INT8_C( -15), INT8_C( -63),
                           INT8_C(  84), INT8_C( -71), INT8_C(   8), INT8_C(  12),
                           INT8_C( -11), INT8_C( -76), INT8_C(  62), INT8_C(  93),
                           INT8_C( -75), INT8_C( -77), INT8_C( -84), INT8_C(-108),
                           INT8_C( -35), INT8_C(  14), INT8_C( -60), INT8_C(  18),
                           INT8_C(  23), INT8_C( -60), INT8_C( -63), INT8_C(-114),
                           INT8_C( -55), INT8_C(  75), INT8_C( -99), INT8_C( -55),
                           INT8_C(  58), INT8_C(  76), INT8_C(-102), INT8_C(-118),
                           INT8_C( -30), INT8_C(  39), INT8_C( 119), INT8_C(  85),
                           INT8_C(  -8), INT8_C( -72), INT8_C( -60), INT8_C( -94),
                           INT8_C(-112), INT8_C( 119), INT8_C( 124), INT8_C(  76),
                           INT8_C( -42), INT8_C(-124), INT8_C(  54), INT8_C(  74),
                           INT8_C( -92), INT8_C(  99), INT8_C(  79), INT8_C(  -3)),
      simde_mm512_set_epi8(INT8_C(-105), INT8_C( -94), INT8_C(  84), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -91), INT8_C(   0), INT8_C( -91),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  -2), INT8_C( 122),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -79),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  11),
                           INT8_C(  38), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  30), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -94), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  38), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   2), INT8_C(  12), INT8_C(  12),
                           INT8_C(   0), INT8_C(   0), INT8_C( -81), INT8_C(  22),
                           INT8_C(   0), INT8_C(-100), INT8_C( -11), INT8_C(   0)) },
    { UINT64_C( 3462613925466476941),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C( -74), INT8_C(  14), INT8_C(  36),
                           INT8_C(  -7), INT8_C( 113), INT8_C(  40), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  85),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C( -21),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  72), INT8_C(  93), INT8_C( 108), INT8_C( 125),
                           INT8_C(   1), INT8_C(  75), INT8_C(  21), INT8_C( -36),
                           INT8_C(-126), INT8_C( 122), INT8_C(  71), INT8_C(  76),
                           INT8_C(  28), INT8_C( -56), INT8_C(  32), INT8_C( 101),
                           INT8_C(-107), INT8_C(-111), INT8_C( -88), INT8_C( -19),
                           INT8_C( -77), INT8_C(  19), INT8_C( -21), INT8_C(-111),
                           INT8_C( -68), INT8_C(  82), INT8_C(-118), INT8_C( -76),
                           INT8_C(  47), INT8_C( 127), INT8_C(  62), INT8_C( -16),
                           INT8_C(  10), INT8_C( -14), INT8_C(-100), INT8_C(  86),
                           INT8_C(  29), INT8_C( 107), INT8_C(  56), INT8_C(  21),
                           INT8_C(  24), INT8_C(  68), INT8_C( -96), INT8_C(  64)),
      simde_mm512_set_epi8(INT8_C( -57), INT8_C(  94), INT8_C(-125), INT8_C(-124),
                           INT8_C(  36), INT8_C(  57), INT8_C(  68), INT8_C( -52),
                           INT8_C(  39), INT8_C(  50), INT8_C( -48), INT8_C(  94),
                           INT8_C(  53), INT8_C(  11), INT8_C(  29), INT8_C(  65),
                           INT8_C( -82), INT8_C(-119), INT8_C( 115), INT8_C(  68),
                           INT8_C( -69), INT8_C( 118), INT8_C(  17), INT8_C(   8),
                           INT8_C( -64), INT8_C( -53), INT8_C( -42), INT8_C( 126),
                           INT8_C(  67), INT8_C(  50), INT8_C( -18), INT8_C(  76),
                           INT8_C( -19), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C( -74), INT8_C(  44), INT8_C( 117), INT8_C( 103),
                           INT8_C(  81), INT8_C( 122), INT8_C(  56), INT8_C( -10),
                           INT8_C(  67), INT8_C(  79), INT8_C(  83), INT8_C( -38),
                           INT8_C( -13), INT8_C(  43), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C( 126), INT8_C(  38), INT8_C( -62),
                           INT8_C( -24), INT8_C( 117), INT8_C( -38), INT8_C( -93),
                           INT8_C( -58), INT8_C(-124), INT8_C( -75), INT8_C(  10)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -75), INT8_C(  -7), INT8_C(   0), INT8_C(  65),
                           INT8_C(   0), INT8_C(   0), INT8_C(-126), INT8_C(   0),
                           INT8_C(   0), INT8_C(  75), INT8_C(   0), INT8_C( 125),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 122), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-107), INT8_C(   0), INT8_C(-111),
                           INT8_C(   0), INT8_C( 101), INT8_C(   0), INT8_C( -77),
                           INT8_C(-118), INT8_C(-111), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -14)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_shuffle_epi8(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_cmpeq_epi8_mask(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i   a;
    simde__m512i   b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  73), INT8_C(  68), INT8_C( -71), INT8_C( -32),
                           INT8_C( 100), INT8_C( 125), INT8_C(  89), INT8_C(  95),
                           INT8_C( -23), INT8_C(  76), INT8_C(  84), INT8_C( -43),
                           INT8_C(  86), INT8_C(  29), INT8_C(  64), INT8_C(  30),
                           INT8_C( -17), INT8_C( -61), INT8_C( 115), INT8_C( -53),
                           INT8_C(-100), INT8_C( 104), INT8_C( 111), INT8_C( -59),
                           INT8_C( -31), INT8_C(  20), INT8_C(  31), INT8_C(-121),
                           INT8_C(  90), INT8_C(  18), INT8_C(   6), INT8_C(  39),
                           INT8_C(  15), INT8_C(  62), INT8_C(  39), INT8_C( -25),
                           INT8_C(  60), INT8_C( 110), INT8_C(  45), INT8_C( 113),
                           INT8_C(  81), INT8_C(  78), INT8_C( -53), INT8_C(  11),
                           INT8_C( -27), INT8_C(-113), INT8_C(  -3), INT8_C(  14),
                           INT8_C( 109), INT8_C(  43), INT8_C( -54), INT8_C( 111),
                           INT8_C( -91), INT8_C( -21), INT8_C( 102), INT8_C(   8),
                           INT8_C( -41), INT8_C( -47), INT8_C( -90), INT8_C(   3),
                           INT8_C(  18), INT8_C(  32), INT8_C(  89), INT8_C( -62)),
      simde_mm512_set_epi8(INT8_C(  73), INT8_C(  68), INT8_C( -71), INT8_C( -46),
                           INT8_C(  72), INT8_C(  42), INT8_C(  65), INT8_C( -27),
                           INT8_C( -37), INT8_C(  76), INT8_C(  84), INT8_C( -95),
                           INT8_C( -29), INT8_C(  29), INT8_C(  64), INT8_C(  75),
                           INT8_C( -17), INT8_C( -61), INT8_C(  76), INT8_C(  88),
                           INT8_C(-100), INT8_C( -91), INT8_C( 111), INT8_C( -59),
                           INT8_C( -31), INT8_C( -17), INT8_C(  31), INT8_C(  68),
                           INT8_C(  90), INT8_C(  18), INT8_C(-110), INT8_C(  39),
                           INT8_C(  15), INT8_C(  62), INT8_C(  24), INT8_C( -25),
                           INT8_C(  80), INT8_C( 122), INT8_C( 103), INT8_C(-115),
                           INT8_C(  81), INT8_C(  24), INT8_C(  32), INT8_C(  82),
                           INT8_C( -27), INT8_C( 105), INT8_C(  -3), INT8_C(  14),
                           INT8_C( 109), INT8_C(  43), INT8_C( -54), INT8_C(-121),
                           INT8_C( -91), INT8_C(-124), INT8_C( 102), INT8_C(  46),
                           INT8_C( -41), INT8_C( 101), INT8_C(  51), INT8_C(   3),
                           INT8_C(  18), INT8_C(  32), INT8_C( -12), INT8_C( -62)),
      UINT64_C(0xe066cbadd08bea9d) },
    { simde_mm512_set_epi8(INT8_C( -84), INT8_C(-108), INT8_C(  13), INT8_C( -97),
                           INT8_C( -34), INT8_C(  27), INT8_C( 124), INT8_C(-120),
                           INT8_C(   3), INT8_C(  26), INT8_C(  43), INT8_C( -96),
                           INT8_C( -63), INT8_C(  49), INT8_C( 127), INT8_C(   0),
                           INT8_C( -20), INT8_C( -31), INT8_C( 125), INT8_C(  14),
                           INT8_C( -53), INT8_C( -87), INT8_C( 115), INT8_C( -20),
                           INT8_C( -93), INT8_C(  70), INT8_C(  29), INT8_C( -90),
                           INT8_C( 105), INT8_C( -54), INT8_C(  96), INT8_C(-106),
                           INT8_C(  94), INT8_C( -52), INT8_C( -50), INT8_C( -79),
                           INT8_C( -54), INT8_C(  78), INT8_C(  17), INT8_C(  81),
                           INT8_C(  35), INT8_C( 120), INT8_C(  47), INT8_C( -25),
                           INT8_C( 110), INT8_C(  55), INT8_C(  40), INT8_C( -31),
                           INT8_C(  93), INT8_C( -23), INT8_C(   4), INT8_C(  45),
                           INT8_C(  59), INT8_C( -33), INT8_C( 124), INT8_C( -52),
                           INT8_C(  42), INT8_C( -14), INT8_C(-119), INT8_C(  88),
                           INT8_C( -38), INT8_C( -31), INT8_C(-113), INT8_C(  33)),
      simde_mm512_set_epi8(INT8_C(  25), INT8_C(-108), INT8_C(  13), INT8_C( -97),
                           INT8_C( -34), INT8_C( 119), INT8_C( 122), INT8_C(  82),
                           INT8_C(   3), INT8_C(-111), INT8_C(  60), INT8_C( -96),
                           INT8_C(  26), INT8_C(   3), INT8_C(  -7), INT8_C(  -8),
                           INT8_C(  94), INT8_C( -31), INT8_C( -71), INT8_C(  14),
                           INT8_C(-105), INT8_C( -87), INT8_C( 115), INT8_C( -68),
                           INT8_C( -93), INT8_C(  70), INT8_C( -47), INT8_C(-106),
                           INT8_C( 105), INT8_C( -54), INT8_C(  96), INT8_C( 105),
                           INT8_C(  94), INT8_C(  84), INT8_C( -50), INT8_C( -79),
                           INT8_C( -54), INT8_C(  78), INT8_C(  17), INT8_C(  39),
                           INT8_C(  35), INT8_C( -87), INT8_C( -83), INT8_C( -25),
                           INT8_C( 110), INT8_C(   2), INT8_C( -90), INT8_C( -31),
                           INT8_C(  19), INT8_C( -23), INT8_C(   4), INT8_C(  16),
                           INT8_C(  59), INT8_C( -33), INT8_C( 124), INT8_C( 127),
                           INT8_C( -60), INT8_C( -14), INT8_C(-119), INT8_C(  88),
                           INT8_C( -38), INT8_C( 109), INT8_C(-113), INT8_C(  25)),
      UINT64_C(0x789056cebe996e7a) },
    { simde_mm512_set_epi8(INT8_C(  93), INT8_C( 110), INT8_C( 120), INT8_C(  25),
                           INT8_C( -37), INT8_C( -25), INT8_C( -34), INT8_C(-108),
                           INT8_C( -77), INT8_C(-114), INT8_C(  79), INT8_C( -50),
                           INT8_C( -94), INT8_C(  22), INT8_C( -28), INT8_C(-105),
                           INT8_C( 110), INT8_C(  29), INT8_C(  -9), INT8_C( -13),
                           INT8_C( -71), INT8_C( 107), INT8_C(-115), INT8_C(  86),
                           INT8_C(-127), INT8_C(-100), INT8_C(   1), INT8_C(  21),
                           INT8_C( -55), INT8_C( -85), INT8_C( -55), INT8_C( -81),
                           INT8_C( -41), INT8_C(  39), INT8_C(  18), INT8_C( -92),
                           INT8_C(  11), INT8_C( -32), INT8_C( -53), INT8_C(  38),
                           INT8_C( -49), INT8_C(-118), INT8_C(  20), INT8_C(  66),
                           INT8_C(-106), INT8_C(-109), INT8_C(  45), INT8_C( -24),
                           INT8_C( -47), INT8_C(  95), INT8_C(  50), INT8_C( 105),
                           INT8_C(  58), INT8_C(  25), INT8_C( -53), INT8_C( -61),
                           INT8_C( -90), INT8_C(  92), INT8_C(  83), INT8_C( 120),
                           INT8_C( 107), INT8_C( -72), INT8_C(   3), INT8_C(  -1)),
      simde_mm512_set_epi8(INT8_C(  93), INT8_C( 110), INT8_C( 120), INT8_C( -75),
                           INT8_C( -37), INT8_C( -25), INT8_C(  14), INT8_C(-108),
                           INT8_C(   5), INT8_C(-114), INT8_C(  79), INT8_C(  57),
                           INT8_C( -94), INT8_C(  22), INT8_C(   4), INT8_C(   3),
                           INT8_C(  66), INT8_C(  29), INT8_C(  -9), INT8_C(  20),
                           INT8_C(  93), INT8_C( 107), INT8_C(   6), INT8_C(  86),
                           INT8_C(  84), INT8_C(-100), INT8_C(  81), INT8_C(  21),
                           INT8_C( 117), INT8_C(  22), INT8_C( -55), INT8_C( -81),
                           INT8_C( -41), INT8_C( -17), INT8_C(  19), INT8_C( 106),
                           INT8_C( 114), INT8_C( -32), INT8_C(  98), INT8_C( -16),
                           INT8_C( -49), INT8_C(-118), INT8_C(  20), INT8_C(  66),
                           INT8_C(-106), INT8_C(-109), INT8_C(  97), INT8_C(  29),
                           INT8_C( -47), INT8_C( -47), INT8_C(  50), INT8_C(-111),
                           INT8_C(  58), INT8_C( 115), INT8_C( -53), INT8_C(  93),
                           INT8_C( -90), INT8_C( -27), INT8_C(  41), INT8_C( 120),
                           INT8_C( 119), INT8_C(  86), INT8_C( -36), INT8_C(  -1)),
      UINT64_C(0xed6c655384fcaa91) },
    { simde_mm512_set_epi8(INT8_C(  10), INT8_C(  75), INT8_C(  91), INT8_C( -99),
                           INT8_C( -88), INT8_C(  99), INT8_C( -86), INT8_C(  96),
                           INT8_C(  14), INT8_C(  -1), INT8_C(  14), INT8_C( 100),
                           INT8_C(-114), INT8_C(  63), INT8_C(  68), INT8_C(-113),
                           INT8_C( -59), INT8_C( -42), INT8_C( -14), INT8_C(-111),
                           INT8_C(   6), INT8_C(  68), INT8_C(  11), INT8_C(-108),
                           INT8_C( -62), INT8_C(  87), INT8_C( -72), INT8_C( -23),
                           INT8_C(  78), INT8_C( -18), INT8_C( -36), INT8_C(  -6),
                           INT8_C( -68), INT8_C(-115), INT8_C( -24), INT8_C( 127),
                           INT8_C( -36), INT8_C(  21), INT8_C(  38), INT8_C(-106),
                           INT8_C(  33), INT8_C( -66), INT8_C(-121), INT8_C(  36),
                           INT8_C(  24), INT8_C(  61), INT8_C(  66), INT8_C(  20),
                           INT8_C(  63), INT8_C( -18), INT8_C(  11), INT8_C(-103),
                           INT8_C( -19), INT8_C( -42), INT8_C( -69), INT8_C(  53),
                           INT8_C( -40), INT8_C( 112), INT8_C(   8), INT8_C( -69),
                           INT8_C(-102), INT8_C(  62), INT8_C(  85), INT8_C(  62)),
      simde_mm512_set_epi8(INT8_C(  10), INT8_C(  75), INT8_C( -74), INT8_C( -47),
                           INT8_C( -88), INT8_C(  99), INT8_C( -86), INT8_C(-128),
                           INT8_C(  94), INT8_C(  -1), INT8_C(  99), INT8_C( 100),
                           INT8_C( -25), INT8_C(   7), INT8_C(  59), INT8_C(-113),
                           INT8_C( 119), INT8_C( -42), INT8_C( -14), INT8_C(  79),
                           INT8_C(   4), INT8_C(-111), INT8_C(  11), INT8_C(  80),
                           INT8_C( -78), INT8_C(  87), INT8_C( -72), INT8_C(-111),
                           INT8_C( -95), INT8_C( -18), INT8_C( -36), INT8_C( -40),
                           INT8_C( -68), INT8_C(-115), INT8_C( -24), INT8_C( -50),
                           INT8_C( -36), INT8_C(  10), INT8_C(  47), INT8_C(  62),
                           INT8_C( -15), INT8_C( -66), INT8_C(-122), INT8_C(  36),
                           INT8_C( -22), INT8_C(  61), INT8_C( -11), INT8_C(  20),
                           INT8_C(  63), INT8_C(  82), INT8_C(-113), INT8_C(-103),
                           INT8_C( -19), INT8_C( -42), INT8_C( -69), INT8_C(  53),
                           INT8_C( -40), INT8_C( 112), INT8_C(   8), INT8_C( -69),
                           INT8_C(-102), INT8_C(  23), INT8_C(  85), INT8_C(  62)),
      UINT64_C(0xce516266e8559ffb) },
    { simde_mm512_set_epi8(INT8_C(  -7), INT8_C(   2), INT8_C(-111), INT8_C(  64),
                           INT8_C(-100), INT8_C(  87), INT8_C( 100), INT8_C( -30),
                           INT8_C( -39), INT8_C( -38), INT8_C( 121), INT8_C(  55),
                           INT8_C( -64), INT8_C(  81), INT8_C(  -3), INT8_C(  79),
                           INT8_C( -41), INT8_C( 118), INT8_C( -37), INT8_C( -34),
                           INT8_C( -13), INT8_C(  63), INT8_C(  26), INT8_C( -81),
                           INT8_C(  90), INT8_C(  43), INT8_C( -31), INT8_C( -17),
                           INT8_C(-100), INT8_C( -71), INT8_C(-104), INT8_C( -66),
                           INT8_C( -94), INT8_C( -89), INT8_C( 100), INT8_C(  36),
                           INT8_C(  17), INT8_C( 116), INT8_C( -30), INT8_C(  16),
                           INT8_C( 110), INT8_C(  98), INT8_C(  11), INT8_C( -42),
                           INT8_C( -78), INT8_C( -68), INT8_C( -26), INT8_C( -35),
                           INT8_C(  12), INT8_C( -40), INT8_C( -27), INT8_C( -40),
                           INT8_C(-102), INT8_C(-109), INT8_C(  39), INT8_C(  29),
                           INT8_C(  21), INT8_C(   9), INT8_C(  49), INT8_C( -13),
                           INT8_C( -49), INT8_C(   7), INT8_C(  91), INT8_C(  15)),
      simde_mm512_set_epi8(INT8_C(  78), INT8_C(   2), INT8_C( -91), INT8_C(  64),
                           INT8_C(-100), INT8_C(  41), INT8_C( -34), INT8_C( -46),
                           INT8_C( -39), INT8_C(  31), INT8_C(  13), INT8_C(  55),
                           INT8_C( -42), INT8_C(  33), INT8_C(  -3), INT8_C(  79),
                           INT8_C( -41), INT8_C( 118), INT8_C( -37), INT8_C(  90),
                           INT8_C( -13), INT8_C(  63), INT8_C(  51), INT8_C( -81),
                           INT8_C(  90), INT8_C(  43), INT8_C( -31), INT8_C(-112),
                           INT8_C(-100), INT8_C(  41), INT8_C(-104), INT8_C( -66),
                           INT8_C( -94), INT8_C( -89), INT8_C( -85), INT8_C(-109),
                           INT8_C( 113), INT8_C( 116), INT8_C( 100), INT8_C(  16),
                           INT8_C(   5), INT8_C( -50), INT8_C( -51), INT8_C( -42),
                           INT8_C( -95), INT8_C( -68), INT8_C( -26), INT8_C( -35),
                           INT8_C( -73), INT8_C(  71), INT8_C(  65), INT8_C( -40),
                           INT8_C(-102), INT8_C(   7), INT8_C(  94), INT8_C(  29),
                           INT8_C(  65), INT8_C(   9), INT8_C(  49), INT8_C( -13),
                           INT8_C( -33), INT8_C(   7), INT8_C(-101), INT8_C(  15)),
      UINT64_C(0x5893edebc5171975) },
    { simde_mm512_set_epi8(INT8_C( -34), INT8_C( -12), INT8_C( 105), INT8_C(-124),
                           INT8_C( -33), INT8_C( -79), INT8_C(  -6), INT8_C(  54),
                           INT8_C(  81), INT8_C( -11), INT8_C(  67), INT8_C(  63),
                           INT8_C( 103), INT8_C( 119), INT8_C( -89), INT8_C(  40),
                           INT8_C(   8), INT8_C( -38), INT8_C(  71), INT8_C(  66),
                           INT8_C(-106), INT8_C( -45), INT8_C(  18), INT8_C( 100),
                           INT8_C( 122), INT8_C(  93), INT8_C( -42), INT8_C(   5),
                           INT8_C( -39), INT8_C(  37), INT8_C( -70), INT8_C(  13),
                           INT8_C(  99), INT8_C( -57), INT8_C( -88), INT8_C( -36),
                           INT8_C(-103), INT8_C(  25), INT8_C(  94), INT8_C(-107),
                           INT8_C( -32), INT8_C( -12), INT8_C( -14), INT8_C(  32),
                           INT8_C( -38), INT8_C(  10), INT8_C(  89), INT8_C( -69),
                           INT8_C(  -8), INT8_C(  69), INT8_C( -20), INT8_C(-122),
                           INT8_C( -75), INT8_C( -71), INT8_C(   3), INT8_C( 102),
                           INT8_C( 119), INT8_C( -58), INT8_C( -49), INT8_C(  80),
                           INT8_C( -15), INT8_C( -97), INT8_C(  45), INT8_C(  96)),
      simde_mm512_set_epi8(INT8_C( -34), INT8_C( -12), INT8_C(  81), INT8_C(-115),
                           INT8_C( -33), INT8_C( -79), INT8_C(-117), INT8_C( -34),
                           INT8_C(  81), INT8_C( -11), INT8_C( -63), INT8_C( -61),
                           INT8_C(  53), INT8_C( 119), INT8_C(  26), INT8_C(  40),
                           INT8_C(   8), INT8_C( -38), INT8_C(  25), INT8_C( -23),
                           INT8_C( -16), INT8_C( -45), INT8_C( -64), INT8_C( 100),
                           INT8_C(  91), INT8_C(  93), INT8_C( -42), INT8_C(   5),
                           INT8_C(  81), INT8_C( -76), INT8_C( -70), INT8_C(  13),
                           INT8_C(  26), INT8_C( -57), INT8_C( -88), INT8_C( -64),
                           INT8_C( -68), INT8_C( -91), INT8_C(-123), INT8_C(  38),
                           INT8_C( -32), INT8_C(  29), INT8_C(  82), INT8_C(  54),
                           INT8_C(-107), INT8_C(  10), INT8_C(  89), INT8_C(  28),
                           INT8_C( -27), INT8_C(  41), INT8_C( -20), INT8_C(-122),
                           INT8_C( -75), INT8_C( -71), INT8_C(   3), INT8_C( -30),
                           INT8_C(  97), INT8_C(  18), INT8_C( -90), INT8_C( 107),
                           INT8_C(  99), INT8_C(  10), INT8_C(  45), INT8_C(  96)),
      UINT64_C(0xccc5c57360863e03) },
    { simde_mm512_set_epi8(INT8_C(  48), INT8_C(  94), INT8_C( 112), INT8_C(-107),
                           INT8_C( -34), INT8_C( -86), INT8_C(  65), INT8_C(  92),
                           INT8_C(  97), INT8_C( -99), INT8_C(  28), INT8_C(  47),
                           INT8_C(-117), INT8_C( -22), INT8_C(-111), INT8_C( -67),
                           INT8_C( 113), INT8_C(-107), INT8_C( -23), INT8_C(  77),
                           INT8_C(  60), INT8_C( 104), INT8_C(-116), INT8_C( -86),
                           INT8_C(-113), INT8_C( -79), INT8_C( -64), INT8_C( -15),
                           INT8_C(-123), INT8_C(  99), INT8_C(  25), INT8_C(  27),
                           INT8_C( -40), INT8_C( 126), INT8_C( -66), INT8_C( -45),
                           INT8_C(  57), INT8_C( -30), INT8_C( -12), INT8_C(  16),
                           INT8_C( 122), INT8_C( 124), INT8_C( -75), INT8_C(  50),
                           INT8_C(  -6), INT8_C(  41), INT8_C( -47), INT8_C(  -3),
                           INT8_C(  29), INT8_C( -20), INT8_C( -45), INT8_C( -46),
                           INT8_C( -45), INT8_C( -14), INT8_C(  99), INT8_C(  84),
                           INT8_C( -62), INT8_C( -99), INT8_C(-104), INT8_C( -78),
                           INT8_C( 106), INT8_C(-117), INT8_C( -94), INT8_C(   3)),
      simde_mm512_set_epi8(INT8_C( -88), INT8_C( -74), INT8_C(   2), INT8_C( -83),
                           INT8_C(-112), INT8_C( -91), INT8_C(  65), INT8_C(  92),
                           INT8_C(  97), INT8_C(  52), INT8_C(  28), INT8_C( -65),
                           INT8_C(-117), INT8_C( -90), INT8_C(-111), INT8_C( -67),
                           INT8_C( 113), INT8_C(  16), INT8_C(-124), INT8_C(  77),
                           INT8_C(  60), INT8_C( -64), INT8_C(-116), INT8_C( -89),
                           INT8_C(  -7), INT8_C( -79), INT8_C(  46), INT8_C( 114),
                           INT8_C(-107), INT8_C(  99), INT8_C( -79), INT8_C(  80),
                           INT8_C( -40), INT8_C( -81), INT8_C( -66), INT8_C( -45),
                           INT8_C(  57), INT8_C( -30), INT8_C(  66), INT8_C(  71),
                           INT8_C( 122), INT8_C(  95), INT8_C( -43), INT8_C(  50),
                           INT8_C(  -6), INT8_C(  41), INT8_C( -47), INT8_C(  95),
                           INT8_C(   5), INT8_C( -20), INT8_C( -45), INT8_C(-118),
                           INT8_C(  70), INT8_C(  81), INT8_C(   0), INT8_C(  84),
                           INT8_C( -62), INT8_C(-101), INT8_C(  13), INT8_C(  33),
                           INT8_C(-104), INT8_C(-117), INT8_C( -11), INT8_C(  20)),
      UINT64_C(0x3ab9a44bc9e6184) },
    { simde_mm512_set_epi8(INT8_C(  67), INT8_C(  34), INT8_C( -33), INT8_C(  31),
                           INT8_C(-128), INT8_C(  55), INT8_C(  93), INT8_C(  58),
                           INT8_C(  57), INT8_C( 104), INT8_C(-110), INT8_C(  59),
                           INT8_C(  55), INT8_C(  33), INT8_C(-122), INT8_C(  69),
                           INT8_C(  57), INT8_C(  30), INT8_C( -13), INT8_C( -65),
                           INT8_C( -22), INT8_C(-100), INT8_C(  18), INT8_C( -65),
                           INT8_C( -60), INT8_C(-105), INT8_C(  27), INT8_C( -71),
                           INT8_C(  52), INT8_C(  12), INT8_C(  -4), INT8_C(  64),
                           INT8_C(  20), INT8_C(  51), INT8_C(  87), INT8_C(  43),
                           INT8_C(  26), INT8_C(   6), INT8_C( -66), INT8_C( -40),
                           INT8_C(  87), INT8_C(   1), INT8_C( -26), INT8_C(  92),
                           INT8_C( -33), INT8_C(   8), INT8_C(  42), INT8_C( -93),
                           INT8_C(  44), INT8_C( -55), INT8_C(-113), INT8_C( -43),
                           INT8_C(  32), INT8_C( 105), INT8_C( -27), INT8_C(  96),
                           INT8_C(  72), INT8_C(  48), INT8_C( -46), INT8_C(  24),
                           INT8_C( -10), INT8_C( -98), INT8_C( -56), INT8_C( -41)),
      simde_mm512_set_epi8(INT8_C(  67), INT8_C( -63), INT8_C( -33), INT8_C(  31),
                           INT8_C(-128), INT8_C(  55), INT8_C(  93), INT8_C(  -8),
                           INT8_C(  82), INT8_C( 104), INT8_C(-110), INT8_C(  59),
                           INT8_C(  55), INT8_C(   0), INT8_C( -25), INT8_C(  69),
                           INT8_C(  27), INT8_C(  30), INT8_C( -13), INT8_C( -65),
                           INT8_C(  -7), INT8_C( -28), INT8_C(  18), INT8_C( -65),
                           INT8_C(  67), INT8_C(  -3), INT8_C(  57), INT8_C( -68),
                           INT8_C(  52), INT8_C(  12), INT8_C(  -4), INT8_C(-128),
                           INT8_C(  20), INT8_C(  37), INT8_C(   9), INT8_C(  80),
                           INT8_C(  26), INT8_C(   6), INT8_C( -66), INT8_C(   9),
                           INT8_C( -98), INT8_C(   1), INT8_C( -26), INT8_C(  92),
                           INT8_C( -33), INT8_C(   8), INT8_C( -81), INT8_C( -93),
                           INT8_C( 116), INT8_C( -55), INT8_C(-113), INT8_C( -43),
                           INT8_C(  32), INT8_C( 105), INT8_C( -27), INT8_C(  37),
                           INT8_C(  72), INT8_C( -73), INT8_C( -19), INT8_C(  96),
                           INT8_C(  52), INT8_C( -98), INT8_C( -45), INT8_C( -41)),
      UINT64_C(0xbe79730e8e7d7e85) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask64 r = simde_mm512_cmpeq_epi8_mask(test_vec[i].a, test_vec[i].b);
    simde_assert_mmask64(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_cmpge_epi8_mask(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i   a;
    simde__m512i   b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  92), INT8_C(-121), INT8_C( 120), INT8_C( -19),
                           INT8_C( -73), INT8_C(  22), INT8_C( -66), INT8_C( -29),
                           INT8_C(  55), INT8_C( -63), INT8_C( -45), INT8_C(-119),
                           INT8_C(  30), INT8_C( -29), INT8_C( -26), INT8_C(  89),
                           INT8_C( -13), INT8_C( 119), INT8_C( -88), INT8_C( 109),
                           INT8_C(  68), INT8_C( -10), INT8_C(   0), INT8_C( -18),
                           INT8_C(   1), INT8_C( 116), INT8_C( -13), INT8_C( -73),
                           INT8_C(-122), INT8_C(   0), INT8_C( 111), INT8_C(  95),
                           INT8_C( -20), INT8_C(   3), INT8_C( 122), INT8_C( -43),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(-127),
                           INT8_C(  82), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  73), INT8_C( 108), INT8_C( -18), INT8_C(  15),
                           INT8_C( 115), INT8_C(  54), INT8_C( 102), INT8_C( 118),
                           INT8_C(  39), INT8_C( -77), INT8_C(  45), INT8_C(  81),
                           INT8_C( -17), INT8_C( -28), INT8_C(  67), INT8_C( -85),
                           INT8_C(  79), INT8_C(-113), INT8_C(-122), INT8_C( 124)),
      simde_mm512_set_epi8(INT8_C(   9), INT8_C(-121), INT8_C( 120), INT8_C( -36),
                           INT8_C(  36), INT8_C(-103), INT8_C(-104), INT8_C(  25),
                           INT8_C(-111), INT8_C( -63), INT8_C( -35), INT8_C(-120),
                           INT8_C(  28), INT8_C( -44), INT8_C( -26), INT8_C( -86),
                           INT8_C( -13), INT8_C(  53), INT8_C( -88), INT8_C(-107),
                           INT8_C(  68), INT8_C(  42), INT8_C(-118), INT8_C( 111),
                           INT8_C(  54), INT8_C( -58), INT8_C( -13), INT8_C(  27),
                           INT8_C(  23), INT8_C(  41), INT8_C(-119), INT8_C(  44),
                           INT8_C(   7), INT8_C(-120), INT8_C(  32), INT8_C( -43),
                           INT8_C( 114), INT8_C( -72), INT8_C(  73), INT8_C( -96),
                           INT8_C(  96), INT8_C( 110), INT8_C( -81), INT8_C( -76),
                           INT8_C( 103), INT8_C(-100), INT8_C( -22), INT8_C(  18),
                           INT8_C( 115), INT8_C(  54), INT8_C( -40), INT8_C( 125),
                           INT8_C( 110), INT8_C(  31), INT8_C(  51), INT8_C(-104),
                           INT8_C(-115), INT8_C( -27), INT8_C(  62), INT8_C( -85),
                           INT8_C(  49), INT8_C(-115), INT8_C(  38), INT8_C(   4)),
      UINT64_C(0xf6dffa637436e1bd) },
    { simde_mm512_set_epi8(INT8_C(  16), INT8_C(  41), INT8_C( 102), INT8_C( -95),
                           INT8_C(  17), INT8_C(  42), INT8_C( -86), INT8_C(  38),
                           INT8_C(  62), INT8_C( -56), INT8_C(  60), INT8_C(  19),
                           INT8_C(-100), INT8_C(-107), INT8_C( 105), INT8_C( -76),
                           INT8_C(  10), INT8_C(  -9), INT8_C( -12), INT8_C( -56),
                           INT8_C( -71), INT8_C(  96), INT8_C(  31), INT8_C(  24),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -27), INT8_C(   3),
                           INT8_C( -21), INT8_C(  50), INT8_C( -67), INT8_C( -39),
                           INT8_C(-108), INT8_C(  62), INT8_C( 101), INT8_C(  56),
                           INT8_C( -79), INT8_C( -37), INT8_C( -99), INT8_C( -56),
                           INT8_C(-119), INT8_C( -56), INT8_C(  -8), INT8_C( -16),
                           INT8_C( 115), INT8_C( -95), INT8_C( -73), INT8_C(  54),
                           INT8_C( 125), INT8_C(  85), INT8_C(  78), INT8_C( -65),
                           INT8_C(   4), INT8_C(  38), INT8_C( -84), INT8_C( -53),
                           INT8_C(  68), INT8_C(-108), INT8_C(-121), INT8_C(-115),
                           INT8_C( -59), INT8_C( -78), INT8_C(-111), INT8_C(  56)),
      simde_mm512_set_epi8(INT8_C(-104), INT8_C(-102), INT8_C( 102), INT8_C( -95),
                           INT8_C(  69), INT8_C(  13), INT8_C( -21), INT8_C(  45),
                           INT8_C(  62), INT8_C(-120), INT8_C(-111), INT8_C(  32),
                           INT8_C(-107), INT8_C( -30), INT8_C(  99), INT8_C( -64),
                           INT8_C(   8), INT8_C( -42), INT8_C(  81), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -71), INT8_C(  46),
                           INT8_C( -21), INT8_C( -73), INT8_C(  21), INT8_C(  83),
                           INT8_C(-108), INT8_C( -97), INT8_C( -69), INT8_C(  73),
                           INT8_C(  57), INT8_C( -37), INT8_C(  21), INT8_C(  82),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C( 115), INT8_C(  31), INT8_C( -79), INT8_C(  28),
                           INT8_C(-106), INT8_C( -18), INT8_C(  65), INT8_C(-104),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  -2),
                           INT8_C( -14), INT8_C(  85), INT8_C( -80), INT8_C(  80),
                           INT8_C(  48), INT8_C(  93), INT8_C(  79), INT8_C( 127)),
      UINT64_C(0xf4eac7ece4cbf680) },
    { simde_mm512_set_epi8(INT8_C(  50), INT8_C(  43), INT8_C( -68), INT8_C(  97),
                           INT8_C( -26), INT8_C(-103), INT8_C(  71), INT8_C(-107),
                           INT8_C(  91), INT8_C(  45), INT8_C( -11), INT8_C(  47),
                           INT8_C(  29), INT8_C( -56), INT8_C(  26), INT8_C(  -9),
                           INT8_C(  10), INT8_C(  36), INT8_C(-116), INT8_C( -53),
                           INT8_C(  41), INT8_C(   1), INT8_C( -23), INT8_C(  61),
                           INT8_C(-127), INT8_C(  -4), INT8_C(  48), INT8_C( -68),
                           INT8_C(  89), INT8_C(-112), INT8_C( -31), INT8_C( 120),
                           INT8_C(  35), INT8_C(  62), INT8_C( -21), INT8_C(-114),
                           INT8_C(-104), INT8_C(  57), INT8_C(  42), INT8_C(-111),
                           INT8_C(  94), INT8_C( -63), INT8_C(  87), INT8_C(  64),
                           INT8_C( -65), INT8_C(  -2), INT8_C( 110), INT8_C(  -8),
                           INT8_C(  63), INT8_C( -51), INT8_C(  -4), INT8_C(  32),
                           INT8_C( -65), INT8_C(  55), INT8_C(  14), INT8_C(  81),
                           INT8_C(-123), INT8_C(-100), INT8_C( -39), INT8_C( -44),
                           INT8_C(  22), INT8_C( 112), INT8_C(  16), INT8_C(  15)),
      simde_mm512_set_epi8(INT8_C(  50), INT8_C( -11), INT8_C( -68), INT8_C( -31),
                           INT8_C( 105), INT8_C(-106), INT8_C(  98), INT8_C(  51),
                           INT8_C(  58), INT8_C( 103), INT8_C( 111), INT8_C(-127),
                           INT8_C(  68), INT8_C( -56), INT8_C( 124), INT8_C(-119),
                           INT8_C(  74), INT8_C( -62), INT8_C(-116), INT8_C(  37),
                           INT8_C( -12), INT8_C( 114), INT8_C(   0), INT8_C(  61),
                           INT8_C( 103), INT8_C(  -4), INT8_C(-105), INT8_C( -68),
                           INT8_C(  39), INT8_C(-100), INT8_C( -93), INT8_C(  11),
                           INT8_C( -80), INT8_C( -19), INT8_C( -22), INT8_C( -39),
                           INT8_C( 127), INT8_C( -38), INT8_C(-125), INT8_C(-111),
                           INT8_C(  84), INT8_C( -96), INT8_C(  87), INT8_C( -22),
                           INT8_C(  -5), INT8_C(  -3), INT8_C(-127), INT8_C(  41),
                           INT8_C(  74), INT8_C(  72), INT8_C(  -4), INT8_C(  28),
                           INT8_C(-115), INT8_C(  93), INT8_C( 102), INT8_C(  44),
                           INT8_C(-103), INT8_C( -29), INT8_C( -50), INT8_C(  48),
                           INT8_C( -96), INT8_C( -50), INT8_C(  46), INT8_C( -65)),
      UINT64_C(0xf495697be7f6392d) },
    { simde_mm512_set_epi8(INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(  11),
                           INT8_C( -14), INT8_C( 126), INT8_C(  81), INT8_C(  45),
                           INT8_C( -23), INT8_C( 120), INT8_C( -83), INT8_C( -16),
                           INT8_C(   7), INT8_C(  51), INT8_C( -57), INT8_C( -50),
                           INT8_C( -21), INT8_C(  98), INT8_C(  88), INT8_C(   0),
                           INT8_C( -66), INT8_C(   3), INT8_C( 124), INT8_C(-113),
                           INT8_C(  50), INT8_C(  32), INT8_C( -85), INT8_C( -93),
                           INT8_C( -44), INT8_C( -13), INT8_C( -94), INT8_C(  17),
                           INT8_C( 122), INT8_C(  79), INT8_C(-116), INT8_C(  43),
                           INT8_C( -77), INT8_C(-125), INT8_C( -23), INT8_C(-120),
                           INT8_C(  96), INT8_C( -64), INT8_C( -23), INT8_C( -46),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C( -80),
                           INT8_C(  44), INT8_C( -92), INT8_C( -31), INT8_C(  26),
                           INT8_C(   8), INT8_C(  52), INT8_C( 117), INT8_C( 123),
                           INT8_C( -63), INT8_C(  45), INT8_C(  95), INT8_C(  24),
                           INT8_C(-108), INT8_C(  18), INT8_C( -60), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C( -23), INT8_C(-101), INT8_C( 116), INT8_C( 127),
                           INT8_C(  96), INT8_C(  40), INT8_C( -97), INT8_C(  40),
                           INT8_C(  86), INT8_C( -44), INT8_C(  70), INT8_C( -71),
                           INT8_C(  62), INT8_C( -21), INT8_C(  66), INT8_C(  68),
                           INT8_C( -87), INT8_C( -61), INT8_C(  48), INT8_C( -70),
                           INT8_C(  18), INT8_C( -78), INT8_C( -98), INT8_C( 117),
                           INT8_C(  74), INT8_C(  32), INT8_C(  93), INT8_C( 125),
                           INT8_C( -47), INT8_C( -60), INT8_C( -86), INT8_C( 117),
                           INT8_C( 122), INT8_C( -54), INT8_C(  50), INT8_C( 123),
                           INT8_C( -31), INT8_C( -74), INT8_C( -64), INT8_C(  54),
                           INT8_C( -81), INT8_C(  60), INT8_C(  31), INT8_C( -23),
                           INT8_C( 108), INT8_C(-119), INT8_C( -92), INT8_C( -80),
                           INT8_C( -30), INT8_C( -37), INT8_C(  51), INT8_C( -36),
                           INT8_C(   8), INT8_C(  52), INT8_C(  97), INT8_C( 123),
                           INT8_C( -49), INT8_C(-124), INT8_C(  95), INT8_C( -83),
                           INT8_C(  70), INT8_C( -50), INT8_C( -61), INT8_C(  25)),
      UINT64_C(0x4754f64cc2879f77) },
    { simde_mm512_set_epi8(INT8_C( 121), INT8_C( -20), INT8_C( -89), INT8_C( -94),
                           INT8_C( 112), INT8_C( -27), INT8_C(  81), INT8_C( -54),
                           INT8_C( -64), INT8_C(-114), INT8_C(  48), INT8_C( -89),
                           INT8_C( -61), INT8_C(  26), INT8_C(  43), INT8_C(  29),
                           INT8_C(   0), INT8_C( 125), INT8_C( -42), INT8_C( -67),
                           INT8_C(  15), INT8_C( 120), INT8_C(  36), INT8_C(  40),
                           INT8_C( -53), INT8_C(  34), INT8_C(-108), INT8_C( -58),
                           INT8_C(  26), INT8_C(-111), INT8_C(  63), INT8_C( -98),
                           INT8_C(  65), INT8_C(   8), INT8_C(-124), INT8_C(  96),
                           INT8_C( -13), INT8_C( -98), INT8_C(  99), INT8_C(  90),
                           INT8_C(  56), INT8_C( -45), INT8_C(-108), INT8_C( -19),
                           INT8_C(-124), INT8_C( -27), INT8_C(  22), INT8_C( 126),
                           INT8_C(-106), INT8_C( -68), INT8_C( -60), INT8_C(   8),
                           INT8_C( -54), INT8_C(  93), INT8_C( -33), INT8_C( -27),
                           INT8_C(  -7), INT8_C(  27), INT8_C(-122), INT8_C( -88),
                           INT8_C(  23), INT8_C(   6), INT8_C(  45), INT8_C( -21)),
      simde_mm512_set_epi8(INT8_C( 105), INT8_C(  52), INT8_C(  85), INT8_C(-104),
                           INT8_C(  57), INT8_C( -31), INT8_C( -38), INT8_C(-124),
                           INT8_C(-107), INT8_C(  -2), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  18), INT8_C(  70),
                           INT8_C(  89), INT8_C( 125), INT8_C( -42), INT8_C(-125),
                           INT8_C( 121), INT8_C( -11), INT8_C( -69), INT8_C( -59),
                           INT8_C( -53), INT8_C(  34), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  69), INT8_C(  -8),
                           INT8_C( -15), INT8_C( -51), INT8_C(   1), INT8_C(  90),
                           INT8_C( 115), INT8_C(  51), INT8_C( -91), INT8_C(  56),
                           INT8_C(  64), INT8_C( -39), INT8_C(-119), INT8_C( -28),
                           INT8_C( -54), INT8_C(  28), INT8_C(  54), INT8_C(  -8),
                           INT8_C( -54), INT8_C(-128), INT8_C( -28), INT8_C( -71),
                           INT8_C( 107), INT8_C( -66), INT8_C(-114), INT8_C( -88),
                           INT8_C(  34), INT8_C( -83), INT8_C( -21), INT8_C( -64)),
      UINT64_C(0x9f8a77cadb071d57) },
    { simde_mm512_set_epi8(INT8_C(  33), INT8_C( 121), INT8_C( 125), INT8_C(  35),
                           INT8_C(-103), INT8_C( -48), INT8_C( -22), INT8_C(  38),
                           INT8_C( -81), INT8_C(   9), INT8_C( -11), INT8_C(-124),
                           INT8_C(  71), INT8_C(   9), INT8_C( -42), INT8_C( 118),
                           INT8_C(  67), INT8_C(  45), INT8_C(  51), INT8_C( -92),
                           INT8_C( 126), INT8_C( 108), INT8_C(-123), INT8_C( -71),
                           INT8_C( 113), INT8_C(  32), INT8_C(  71), INT8_C(   3),
                           INT8_C( -26), INT8_C(  82), INT8_C( -81), INT8_C( -20),
                           INT8_C( -55), INT8_C( 112), INT8_C(  66), INT8_C(  37),
                           INT8_C(  67), INT8_C( -69), INT8_C(  64), INT8_C(  39),
                           INT8_C(  72), INT8_C(  45), INT8_C( 120), INT8_C(  -5),
                           INT8_C(-109), INT8_C(  62), INT8_C(  17), INT8_C(  31),
                           INT8_C( -30), INT8_C( -58), INT8_C(  56), INT8_C(  21),
                           INT8_C(  72), INT8_C( -75), INT8_C( -34), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(  32), INT8_C(  64),
                           INT8_C(-128), INT8_C( 102), INT8_C( -21), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C( 100), INT8_C( 121), INT8_C(  18), INT8_C(  28),
                           INT8_C(-117), INT8_C( 107), INT8_C(   3), INT8_C( -62),
                           INT8_C(  42), INT8_C(  72), INT8_C(  91), INT8_C(  86),
                           INT8_C( -72), INT8_C(   9), INT8_C( -80), INT8_C( 118),
                           INT8_C( 122), INT8_C(-108), INT8_C( -70), INT8_C( -63),
                           INT8_C(  56), INT8_C(  71), INT8_C( -14), INT8_C(  49),
                           INT8_C( -73), INT8_C(  53), INT8_C( -29), INT8_C(   3),
                           INT8_C( -73), INT8_C(  43), INT8_C( -22), INT8_C(  85),
                           INT8_C( -26), INT8_C(  -9), INT8_C(  66), INT8_C(   1),
                           INT8_C( -13), INT8_C(  60), INT8_C(-119), INT8_C( -83),
                           INT8_C(-122), INT8_C( -64), INT8_C( -83), INT8_C( -74),
                           INT8_C( 119), INT8_C(  -8), INT8_C(  12), INT8_C( 113),
                           INT8_C( -12), INT8_C( -84), INT8_C(   6), INT8_C(  69),
                           INT8_C(   2), INT8_C( -75), INT8_C( -34), INT8_C(-126),
                           INT8_C(   3), INT8_C(-128), INT8_C(  -9), INT8_C(  24),
                           INT8_C(  11), INT8_C( -94), INT8_C( -32), INT8_C( 110)),
      UINT64_C(0x790f6cbc7bf66ff6) },
    { simde_mm512_set_epi8(INT8_C(   2), INT8_C( -81), INT8_C(  14), INT8_C(  90),
                           INT8_C(-100), INT8_C(-122), INT8_C( -35), INT8_C(  81),
                           INT8_C( -14), INT8_C( -42), INT8_C( 125), INT8_C(-125),
                           INT8_C( -57), INT8_C(  90), INT8_C(  -9), INT8_C(  63),
                           INT8_C(  53), INT8_C(  77), INT8_C(  63), INT8_C( -84),
                           INT8_C(  27), INT8_C(  22), INT8_C( -28), INT8_C( -37),
                           INT8_C(  65), INT8_C( 118), INT8_C(-126), INT8_C(  97),
                           INT8_C( 109), INT8_C(-119), INT8_C(-114), INT8_C( -75),
                           INT8_C(-125), INT8_C( 121), INT8_C(-128), INT8_C( 103),
                           INT8_C(   0), INT8_C( 101), INT8_C( -41), INT8_C(  89),
                           INT8_C(  67), INT8_C( -65), INT8_C(   9), INT8_C(  -7),
                           INT8_C( -63), INT8_C(  13), INT8_C( 105), INT8_C(  92),
                           INT8_C( -18), INT8_C( -21), INT8_C(-102), INT8_C(-114),
                           INT8_C(  74), INT8_C( 121), INT8_C( -45), INT8_C(  52),
                           INT8_C( -63), INT8_C( -93), INT8_C(  98), INT8_C( 106),
                           INT8_C(-109), INT8_C( -47), INT8_C(  37), INT8_C(  70)),
      simde_mm512_set_epi8(INT8_C( -42), INT8_C(-124), INT8_C(  54), INT8_C(  74),
                           INT8_C( -92), INT8_C(  99), INT8_C(  79), INT8_C(  -3),
                           INT8_C(  61), INT8_C( -89), INT8_C(  84), INT8_C( -94),
                           INT8_C(  31), INT8_C(-116), INT8_C( -67), INT8_C(-102),
                           INT8_C( -72), INT8_C( -91), INT8_C(-105), INT8_C(-108),
                           INT8_C( -44), INT8_C(  74), INT8_C( -28), INT8_C( 124),
                           INT8_C( 120), INT8_C( -41), INT8_C( -79), INT8_C( 122),
                           INT8_C(  87), INT8_C(-119), INT8_C(  54), INT8_C(  -2),
                           INT8_C( -47), INT8_C(  84), INT8_C(-126), INT8_C( -64),
                           INT8_C(  14), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  67), INT8_C( 124), INT8_C(  58), INT8_C( -94),
                           INT8_C(  30), INT8_C( -33), INT8_C(  70), INT8_C( -24),
                           INT8_C(  38), INT8_C( -97), INT8_C( -56), INT8_C( -60),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(  45),
                           INT8_C( -11), INT8_C(  55), INT8_C( -82), INT8_C(  12),
                           INT8_C( 106), INT8_C(  22), INT8_C(-124), INT8_C(  -4)),
      UINT64_C(0xd167fa4c55974f33) },
    { simde_mm512_set_epi8(INT8_C(  18), INT8_C(  13), INT8_C(  14), INT8_C(   4),
                           INT8_C(  -3), INT8_C( -64), INT8_C(  17), INT8_C(-115),
                           INT8_C(  21), INT8_C( -34), INT8_C( 125), INT8_C( -60),
                           INT8_C( -72), INT8_C(  74), INT8_C(  -5), INT8_C( -21),
                           INT8_C( -41), INT8_C(  22), INT8_C(  45), INT8_C( 102),
                           INT8_C(  59), INT8_C( -80), INT8_C( -15), INT8_C( -63),
                           INT8_C(  84), INT8_C( -71), INT8_C(   8), INT8_C(  12),
                           INT8_C( -11), INT8_C( -76), INT8_C(  62), INT8_C(  93),
                           INT8_C( -75), INT8_C( -77), INT8_C( -84), INT8_C(-108),
                           INT8_C( -35), INT8_C(  14), INT8_C( -60), INT8_C(  18),
                           INT8_C(  23), INT8_C( -60), INT8_C( -63), INT8_C(-114),
                           INT8_C( -55), INT8_C(  75), INT8_C( -99), INT8_C( -55),
                           INT8_C(  58), INT8_C(  76), INT8_C(-102), INT8_C(-118),
                           INT8_C(  10), INT8_C(  39), INT8_C( 119), INT8_C(  85),
                           INT8_C(  -8), INT8_C( -72), INT8_C( -60), INT8_C( -94),
                           INT8_C(-112), INT8_C( 119), INT8_C( 124), INT8_C(  76)),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C( -74), INT8_C(  14), INT8_C(  36),
                           INT8_C(  -7), INT8_C( 113), INT8_C(  40), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  85),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C( -21),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  72), INT8_C(  93), INT8_C( 108), INT8_C( 125),
                           INT8_C(   1), INT8_C(  75), INT8_C(  21), INT8_C( -36),
                           INT8_C(-126), INT8_C( 122), INT8_C(  71), INT8_C(  76),
                           INT8_C(  28), INT8_C( -56), INT8_C(  32), INT8_C( 101),
                           INT8_C(-107), INT8_C(-111), INT8_C( -88), INT8_C( -19),
                           INT8_C( -77), INT8_C(  19), INT8_C( -21), INT8_C(-111),
                           INT8_C( -68), INT8_C(  82), INT8_C(-118), INT8_C( -76),
                           INT8_C(  47), INT8_C( 127), INT8_C(  62), INT8_C( -16),
                           INT8_C(  10), INT8_C( -14), INT8_C(-100), INT8_C(  86),
                           INT8_C(  29), INT8_C( 107), INT8_C(  56), INT8_C(  21),
                           INT8_C(  24), INT8_C(  68), INT8_C( -96), INT8_C(  64)),
      UINT64_C(0xe8e570990f8b8e07) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask64 r = simde_mm512_cmpge_epi8_mask(test_vec[i].a, test_vec[i].b);
    simde_assert_mmask64(r, ==, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_cmpge_epu8_mask(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i   a;
    simde__m512i   b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C( 92), UINT8_C(135), UINT8_C(120), UINT8_C(237),
                             UINT8_C(183), UINT8_C( 22), UINT8_C(190), UINT8_C(227),
                             UINT8_C( 55), UINT8_C(193), UINT8_C(211), UINT8_C(137),
                             UINT8_C( 30), UINT8_C(227), UINT8_C(230), UINT8_C( 89),
                             UINT8_C(243), UINT8_C(119), UINT8_C(168), UINT8_C(109),
                             UINT8_C( 68), UINT8_C(246), UINT8_C(  0), UINT8_C(238),
                             UINT8_C(  1), UINT8_C(116), UINT8_C(243), UINT8_C(183),
                             UINT8_C(134), UINT8_C(  0), UINT8_C(111), UINT8_C( 95),
                             UINT8_C(236), UINT8_C(  3), UINT8_C(122), UINT8_C(213),
                             UINT8_C( 13), UINT8_C( 25), UINT8_C(221), UINT8_C(129),
                             UINT8_C( 82), UINT8_C( 90), UINT8_C( 53), UINT8_C(123),
                             UINT8_C( 73), UINT8_C(108), UINT8_C(238), UINT8_C( 15),
                             UINT8_C(115), UINT8_C( 54), UINT8_C(102), UINT8_C(118),
                             UINT8_C( 39), UINT8_C(179), UINT8_C( 45), UINT8_C( 81),
                             UINT8_C(239), UINT8_C(228), UINT8_C( 67), UINT8_C(171),
                             UINT8_C( 79), UINT8_C(143), UINT8_C(134), UINT8_C(124)),
      simde_x_mm512_set_epu8(UINT8_C(  9), UINT8_C(135), UINT8_C(120), UINT8_C(220),
                             UINT8_C( 36), UINT8_C(153), UINT8_C(152), UINT8_C( 25),
                             UINT8_C(145), UINT8_C(193), UINT8_C(221), UINT8_C(136),
                             UINT8_C( 28), UINT8_C(212), UINT8_C(230), UINT8_C(170),
                             UINT8_C(243), UINT8_C( 53), UINT8_C(168), UINT8_C(149),
                             UINT8_C( 68), UINT8_C( 42), UINT8_C(138), UINT8_C(111),
                             UINT8_C( 54), UINT8_C(198), UINT8_C(243), UINT8_C( 27),
                             UINT8_C( 23), UINT8_C( 41), UINT8_C(137), UINT8_C( 44),
                             UINT8_C(  7), UINT8_C(136), UINT8_C( 32), UINT8_C(213),
                             UINT8_C(114), UINT8_C(184), UINT8_C( 73), UINT8_C(160),
                             UINT8_C( 96), UINT8_C(110), UINT8_C(175), UINT8_C(180),
                             UINT8_C(103), UINT8_C(156), UINT8_C(234), UINT8_C( 18),
                             UINT8_C(115), UINT8_C( 54), UINT8_C(216), UINT8_C(125),
                             UINT8_C(110), UINT8_C( 31), UINT8_C( 51), UINT8_C(152),
                             UINT8_C(141), UINT8_C(229), UINT8_C( 62), UINT8_C(171),
                             UINT8_C( 49), UINT8_C(141), UINT8_C( 38), UINT8_C(  4)),
      UINT64_C(0xfb5eed39b202c4bf) },
    { simde_x_mm512_set_epu8(UINT8_C( 16), UINT8_C( 41), UINT8_C(102), UINT8_C(161),
                             UINT8_C( 17), UINT8_C( 42), UINT8_C(170), UINT8_C( 38),
                             UINT8_C( 62), UINT8_C(200), UINT8_C( 60), UINT8_C( 19),
                             UINT8_C(156), UINT8_C(149), UINT8_C(105), UINT8_C(180),
                             UINT8_C( 10), UINT8_C(247), UINT8_C(244), UINT8_C(200),
                             UINT8_C(185), UINT8_C( 96), UINT8_C( 31), UINT8_C( 24),
                             UINT8_C( 68), UINT8_C(249), UINT8_C(229), UINT8_C(  3),
                             UINT8_C(235), UINT8_C( 50), UINT8_C(189), UINT8_C(217),
                             UINT8_C(148), UINT8_C( 62), UINT8_C(101), UINT8_C( 56),
                             UINT8_C(177), UINT8_C(219), UINT8_C(157), UINT8_C(200),
                             UINT8_C(137), UINT8_C(200), UINT8_C(248), UINT8_C(240),
                             UINT8_C(115), UINT8_C(161), UINT8_C(183), UINT8_C( 54),
                             UINT8_C(125), UINT8_C( 85), UINT8_C( 78), UINT8_C(191),
                             UINT8_C(  4), UINT8_C( 38), UINT8_C(172), UINT8_C(203),
                             UINT8_C( 68), UINT8_C(148), UINT8_C(135), UINT8_C(141),
                             UINT8_C(197), UINT8_C(178), UINT8_C(145), UINT8_C( 56)),
      simde_x_mm512_set_epu8(UINT8_C(152), UINT8_C(154), UINT8_C(102), UINT8_C(161),
                             UINT8_C( 69), UINT8_C( 13), UINT8_C(235), UINT8_C( 45),
                             UINT8_C( 62), UINT8_C(136), UINT8_C(145), UINT8_C( 32),
                             UINT8_C(149), UINT8_C(226), UINT8_C( 99), UINT8_C(192),
                             UINT8_C(  8), UINT8_C(214), UINT8_C( 81), UINT8_C(222),
                             UINT8_C(210), UINT8_C( 26), UINT8_C( 31), UINT8_C(254),
                             UINT8_C( 68), UINT8_C(249), UINT8_C(185), UINT8_C( 46),
                             UINT8_C(235), UINT8_C(183), UINT8_C( 21), UINT8_C( 83),
                             UINT8_C(148), UINT8_C(159), UINT8_C(187), UINT8_C( 73),
                             UINT8_C( 57), UINT8_C(219), UINT8_C( 21), UINT8_C( 82),
                             UINT8_C(137), UINT8_C(130), UINT8_C(126), UINT8_C( 91),
                             UINT8_C(115), UINT8_C( 31), UINT8_C(177), UINT8_C( 28),
                             UINT8_C(150), UINT8_C(238), UINT8_C( 65), UINT8_C(152),
                             UINT8_C( 81), UINT8_C( 38), UINT8_C(172), UINT8_C(254),
                             UINT8_C(242), UINT8_C( 85), UINT8_C(176), UINT8_C( 80),
                             UINT8_C( 48), UINT8_C( 93), UINT8_C( 79), UINT8_C(127)),
      UINT64_C(0x34cae6eb8fff365e) },
    { simde_x_mm512_set_epu8(UINT8_C( 50), UINT8_C( 43), UINT8_C(188), UINT8_C( 97),
                             UINT8_C(230), UINT8_C(153), UINT8_C( 71), UINT8_C(149),
                             UINT8_C( 91), UINT8_C( 45), UINT8_C(245), UINT8_C( 47),
                             UINT8_C( 29), UINT8_C(200), UINT8_C( 26), UINT8_C(247),
                             UINT8_C( 10), UINT8_C( 36), UINT8_C(140), UINT8_C(203),
                             UINT8_C( 41), UINT8_C(  1), UINT8_C(233), UINT8_C( 61),
                             UINT8_C(129), UINT8_C(252), UINT8_C( 48), UINT8_C(188),
                             UINT8_C( 89), UINT8_C(144), UINT8_C(225), UINT8_C(120),
                             UINT8_C( 35), UINT8_C( 62), UINT8_C(235), UINT8_C(142),
                             UINT8_C(152), UINT8_C( 57), UINT8_C( 42), UINT8_C(145),
                             UINT8_C( 94), UINT8_C(193), UINT8_C( 87), UINT8_C( 64),
                             UINT8_C(191), UINT8_C(254), UINT8_C(110), UINT8_C(248),
                             UINT8_C( 63), UINT8_C(205), UINT8_C(252), UINT8_C( 32),
                             UINT8_C(191), UINT8_C( 55), UINT8_C( 14), UINT8_C( 81),
                             UINT8_C(133), UINT8_C(156), UINT8_C(217), UINT8_C(212),
                             UINT8_C( 22), UINT8_C(112), UINT8_C( 16), UINT8_C( 15)),
      simde_x_mm512_set_epu8(UINT8_C( 50), UINT8_C(245), UINT8_C(188), UINT8_C(225),
                             UINT8_C(105), UINT8_C(150), UINT8_C( 98), UINT8_C( 51),
                             UINT8_C( 58), UINT8_C(103), UINT8_C(111), UINT8_C(129),
                             UINT8_C( 68), UINT8_C(200), UINT8_C(124), UINT8_C(137),
                             UINT8_C( 74), UINT8_C(194), UINT8_C(140), UINT8_C( 37),
                             UINT8_C(244), UINT8_C(114), UINT8_C(  0), UINT8_C( 61),
                             UINT8_C(103), UINT8_C(252), UINT8_C(151), UINT8_C(188),
                             UINT8_C( 39), UINT8_C(156), UINT8_C(163), UINT8_C( 11),
                             UINT8_C(176), UINT8_C(237), UINT8_C(234), UINT8_C(217),
                             UINT8_C(127), UINT8_C(218), UINT8_C(131), UINT8_C(145),
                             UINT8_C( 84), UINT8_C(160), UINT8_C( 87), UINT8_C(234),
                             UINT8_C(251), UINT8_C(253), UINT8_C(129), UINT8_C( 41),
                             UINT8_C( 74), UINT8_C( 72), UINT8_C(252), UINT8_C( 28),
                             UINT8_C(141), UINT8_C( 93), UINT8_C(102), UINT8_C( 44),
                             UINT8_C(153), UINT8_C(227), UINT8_C(206), UINT8_C( 48),
                             UINT8_C(160), UINT8_C(206), UINT8_C( 46), UINT8_C(191)),
      UINT64_C(0xada533db29e57930) },
    { simde_x_mm512_set_epu8(UINT8_C(159), UINT8_C( 28), UINT8_C(198), UINT8_C( 11),
                             UINT8_C(242), UINT8_C(126), UINT8_C( 81), UINT8_C( 45),
                             UINT8_C(233), UINT8_C(120), UINT8_C(173), UINT8_C(240),
                             UINT8_C(  7), UINT8_C( 51), UINT8_C(199), UINT8_C(206),
                             UINT8_C(235), UINT8_C( 98), UINT8_C( 88), UINT8_C(  0),
                             UINT8_C(190), UINT8_C(  3), UINT8_C(124), UINT8_C(143),
                             UINT8_C( 50), UINT8_C( 32), UINT8_C(171), UINT8_C(163),
                             UINT8_C(212), UINT8_C(243), UINT8_C(162), UINT8_C( 17),
                             UINT8_C(122), UINT8_C( 79), UINT8_C(140), UINT8_C( 43),
                             UINT8_C(179), UINT8_C(131), UINT8_C(233), UINT8_C(136),
                             UINT8_C( 96), UINT8_C(192), UINT8_C(233), UINT8_C(210),
                             UINT8_C(227), UINT8_C(185), UINT8_C( 71), UINT8_C(176),
                             UINT8_C( 44), UINT8_C(164), UINT8_C(225), UINT8_C( 26),
                             UINT8_C(  8), UINT8_C( 52), UINT8_C(117), UINT8_C(123),
                             UINT8_C(193), UINT8_C( 45), UINT8_C( 95), UINT8_C( 24),
                             UINT8_C(148), UINT8_C( 18), UINT8_C(196), UINT8_C( 28)),
      simde_x_mm512_set_epu8(UINT8_C(233), UINT8_C(155), UINT8_C(116), UINT8_C(127),
                             UINT8_C( 96), UINT8_C( 40), UINT8_C(159), UINT8_C( 40),
                             UINT8_C( 86), UINT8_C(212), UINT8_C( 70), UINT8_C(185),
                             UINT8_C( 62), UINT8_C(235), UINT8_C( 66), UINT8_C( 68),
                             UINT8_C(169), UINT8_C(195), UINT8_C( 48), UINT8_C(186),
                             UINT8_C( 18), UINT8_C(178), UINT8_C(158), UINT8_C(117),
                             UINT8_C( 74), UINT8_C( 32), UINT8_C( 93), UINT8_C(125),
                             UINT8_C(209), UINT8_C(196), UINT8_C(170), UINT8_C(117),
                             UINT8_C(122), UINT8_C(202), UINT8_C( 50), UINT8_C(123),
                             UINT8_C(225), UINT8_C(182), UINT8_C(192), UINT8_C( 54),
                             UINT8_C(175), UINT8_C( 60), UINT8_C( 31), UINT8_C(233),
                             UINT8_C(108), UINT8_C(137), UINT8_C(164), UINT8_C(176),
                             UINT8_C(226), UINT8_C(219), UINT8_C( 51), UINT8_C(220),
                             UINT8_C(  8), UINT8_C( 52), UINT8_C( 97), UINT8_C(123),
                             UINT8_C(207), UINT8_C(132), UINT8_C( 95), UINT8_C(173),
                             UINT8_C( 70), UINT8_C(206), UINT8_C(195), UINT8_C( 25)),
      UINT64_C(0x2db3a97ca36d2f2b) },
    { simde_x_mm512_set_epu8(UINT8_C(121), UINT8_C(236), UINT8_C(167), UINT8_C(162),
                             UINT8_C(112), UINT8_C(229), UINT8_C( 81), UINT8_C(202),
                             UINT8_C(192), UINT8_C(142), UINT8_C( 48), UINT8_C(167),
                             UINT8_C(195), UINT8_C( 26), UINT8_C( 43), UINT8_C( 29),
                             UINT8_C(  0), UINT8_C(125), UINT8_C(214), UINT8_C(189),
                             UINT8_C( 15), UINT8_C(120), UINT8_C( 36), UINT8_C( 40),
                             UINT8_C(203), UINT8_C( 34), UINT8_C(148), UINT8_C(198),
                             UINT8_C( 26), UINT8_C(145), UINT8_C( 63), UINT8_C(158),
                             UINT8_C( 65), UINT8_C(  8), UINT8_C(132), UINT8_C( 96),
                             UINT8_C(243), UINT8_C(158), UINT8_C( 99), UINT8_C( 90),
                             UINT8_C( 56), UINT8_C(211), UINT8_C(148), UINT8_C(237),
                             UINT8_C(132), UINT8_C(229), UINT8_C( 22), UINT8_C(126),
                             UINT8_C(150), UINT8_C(188), UINT8_C(196), UINT8_C(  8),
                             UINT8_C(202), UINT8_C( 93), UINT8_C(223), UINT8_C(229),
                             UINT8_C(249), UINT8_C( 27), UINT8_C(134), UINT8_C(168),
                             UINT8_C( 23), UINT8_C(  6), UINT8_C( 45), UINT8_C(235)),
      simde_x_mm512_set_epu8(UINT8_C(105), UINT8_C( 52), UINT8_C( 85), UINT8_C(152),
                             UINT8_C( 57), UINT8_C(225), UINT8_C(218), UINT8_C(132),
                             UINT8_C(149), UINT8_C(254), UINT8_C( 55), UINT8_C( 46),
                             UINT8_C(185), UINT8_C( 77), UINT8_C( 18), UINT8_C( 70),
                             UINT8_C( 89), UINT8_C(125), UINT8_C(214), UINT8_C(131),
                             UINT8_C(121), UINT8_C(245), UINT8_C(187), UINT8_C(197),
                             UINT8_C(203), UINT8_C( 34), UINT8_C(  9), UINT8_C( 64),
                             UINT8_C(195), UINT8_C(231), UINT8_C(141), UINT8_C(100),
                             UINT8_C( 65), UINT8_C(  8), UINT8_C( 69), UINT8_C(248),
                             UINT8_C(241), UINT8_C(205), UINT8_C(  1), UINT8_C( 90),
                             UINT8_C(115), UINT8_C( 51), UINT8_C(165), UINT8_C( 56),
                             UINT8_C( 64), UINT8_C(217), UINT8_C(137), UINT8_C(228),
                             UINT8_C(202), UINT8_C( 28), UINT8_C( 54), UINT8_C(248),
                             UINT8_C(202), UINT8_C(128), UINT8_C(228), UINT8_C(185),
                             UINT8_C(107), UINT8_C(190), UINT8_C(142), UINT8_C(168),
                             UINT8_C( 34), UINT8_C(173), UINT8_C(235), UINT8_C(192)),
      UINT64_C(0xfd9a70f1eb5c6991) },
    { simde_x_mm512_set_epu8(UINT8_C( 33), UINT8_C(121), UINT8_C(125), UINT8_C( 35),
                             UINT8_C(153), UINT8_C(208), UINT8_C(234), UINT8_C( 38),
                             UINT8_C(175), UINT8_C(  9), UINT8_C(245), UINT8_C(132),
                             UINT8_C( 71), UINT8_C(  9), UINT8_C(214), UINT8_C(118),
                             UINT8_C( 67), UINT8_C( 45), UINT8_C( 51), UINT8_C(164),
                             UINT8_C(126), UINT8_C(108), UINT8_C(133), UINT8_C(185),
                             UINT8_C(113), UINT8_C( 32), UINT8_C( 71), UINT8_C(  3),
                             UINT8_C(230), UINT8_C( 82), UINT8_C(175), UINT8_C(236),
                             UINT8_C(201), UINT8_C(112), UINT8_C( 66), UINT8_C( 37),
                             UINT8_C( 67), UINT8_C(187), UINT8_C( 64), UINT8_C( 39),
                             UINT8_C( 72), UINT8_C( 45), UINT8_C(120), UINT8_C(251),
                             UINT8_C(147), UINT8_C( 62), UINT8_C( 17), UINT8_C( 31),
                             UINT8_C(226), UINT8_C(198), UINT8_C( 56), UINT8_C( 21),
                             UINT8_C( 72), UINT8_C(181), UINT8_C(222), UINT8_C(120),
                             UINT8_C( 95), UINT8_C(108), UINT8_C( 32), UINT8_C( 64),
                             UINT8_C(128), UINT8_C(102), UINT8_C(235), UINT8_C( 28)),
      simde_x_mm512_set_epu8(UINT8_C(100), UINT8_C(121), UINT8_C( 18), UINT8_C( 28),
                             UINT8_C(139), UINT8_C(107), UINT8_C(  3), UINT8_C(194),
                             UINT8_C( 42), UINT8_C( 72), UINT8_C( 91), UINT8_C( 86),
                             UINT8_C(184), UINT8_C(  9), UINT8_C(176), UINT8_C(118),
                             UINT8_C(122), UINT8_C(148), UINT8_C(186), UINT8_C(193),
                             UINT8_C( 56), UINT8_C( 71), UINT8_C(242), UINT8_C( 49),
                             UINT8_C(183), UINT8_C( 53), UINT8_C(227), UINT8_C(  3),
                             UINT8_C(183), UINT8_C( 43), UINT8_C(234), UINT8_C( 85),
                             UINT8_C(230), UINT8_C(247), UINT8_C( 66), UINT8_C(  1),
                             UINT8_C(243), UINT8_C( 60), UINT8_C(137), UINT8_C(173),
                             UINT8_C(134), UINT8_C(192), UINT8_C(173), UINT8_C(182),
                             UINT8_C(119), UINT8_C(248), UINT8_C( 12), UINT8_C(113),
                             UINT8_C(244), UINT8_C(172), UINT8_C(  6), UINT8_C( 69),
                             UINT8_C(  2), UINT8_C(181), UINT8_C(222), UINT8_C(130),
                             UINT8_C(  3), UINT8_C(128), UINT8_C(247), UINT8_C( 24),
                             UINT8_C( 11), UINT8_C(162), UINT8_C(224), UINT8_C(110)),
      UINT64_C(0x7eb70d1d341a6e9a) },
    { simde_x_mm512_set_epu8(UINT8_C(  2), UINT8_C(175), UINT8_C( 14), UINT8_C( 90),
                             UINT8_C(156), UINT8_C(134), UINT8_C(221), UINT8_C( 81),
                             UINT8_C(242), UINT8_C(214), UINT8_C(125), UINT8_C(131),
                             UINT8_C(199), UINT8_C( 90), UINT8_C(247), UINT8_C( 63),
                             UINT8_C( 53), UINT8_C( 77), UINT8_C( 63), UINT8_C(172),
                             UINT8_C( 27), UINT8_C( 22), UINT8_C(228), UINT8_C(219),
                             UINT8_C( 65), UINT8_C(118), UINT8_C(130), UINT8_C( 97),
                             UINT8_C(109), UINT8_C(137), UINT8_C(142), UINT8_C(181),
                             UINT8_C(131), UINT8_C(121), UINT8_C(128), UINT8_C(103),
                             UINT8_C(  0), UINT8_C(101), UINT8_C(215), UINT8_C( 89),
                             UINT8_C( 67), UINT8_C(191), UINT8_C(  9), UINT8_C(249),
                             UINT8_C(193), UINT8_C( 13), UINT8_C(105), UINT8_C( 92),
                             UINT8_C(238), UINT8_C(235), UINT8_C(154), UINT8_C(142),
                             UINT8_C( 74), UINT8_C(121), UINT8_C(211), UINT8_C( 52),
                             UINT8_C(193), UINT8_C(163), UINT8_C( 98), UINT8_C(106),
                             UINT8_C(147), UINT8_C(209), UINT8_C( 37), UINT8_C( 70)),
      simde_x_mm512_set_epu8(UINT8_C(214), UINT8_C(132), UINT8_C( 54), UINT8_C( 74),
                             UINT8_C(164), UINT8_C( 99), UINT8_C( 79), UINT8_C(253),
                             UINT8_C( 61), UINT8_C(167), UINT8_C( 84), UINT8_C(162),
                             UINT8_C( 31), UINT8_C(140), UINT8_C(189), UINT8_C(154),
                             UINT8_C(184), UINT8_C(165), UINT8_C(151), UINT8_C(148),
                             UINT8_C(212), UINT8_C( 74), UINT8_C(228), UINT8_C(124),
                             UINT8_C(120), UINT8_C(215), UINT8_C(177), UINT8_C(122),
                             UINT8_C( 87), UINT8_C(137), UINT8_C( 54), UINT8_C(254),
                             UINT8_C(209), UINT8_C( 84), UINT8_C(130), UINT8_C(192),
                             UINT8_C( 14), UINT8_C( 11), UINT8_C( 37), UINT8_C(233),
                             UINT8_C( 67), UINT8_C(124), UINT8_C( 58), UINT8_C(162),
                             UINT8_C( 30), UINT8_C(223), UINT8_C( 70), UINT8_C(232),
                             UINT8_C( 38), UINT8_C(159), UINT8_C(200), UINT8_C(196),
                             UINT8_C(197), UINT8_C( 65), UINT8_C(182), UINT8_C( 45),
                             UINT8_C(245), UINT8_C( 55), UINT8_C(174), UINT8_C( 12),
                             UINT8_C(106), UINT8_C( 22), UINT8_C(132), UINT8_C(