/***************************************************************************
                          skydmin.h  -  description
                             -------------------
    begin                : Fri Jan 23 2009
    copyright            : (C) 2009 by Christophe Gros
    email                : skylendar@yahoo.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "ui_skydmin.h"
#include <QDialog>
#include <QSqlDatabase>
#include <QProcess>
#include <QNetworkReply>
#include <QFile>
#include "ui_asteroid.h"
#include <iostream>

class QSqlTableModel;
class QSqlRecord;
class QModelIndex;
class QStringList;
class QNetworkReply;

#define i18n(s) s
#define USER_AGENT "skylendar 4.21nn"
#define SE_PATH "http://www.astro.com/ftp/swisseph/ephe/"

class SkyDmin;

class SkyBase
{
 public:
  QSqlDatabase db;
  virtual bool Connect(const QString& db) = 0;
  QString Path, SqlFile;
  char User[40] = {0, };
  virtual void Msg(const QString& s) = 0;
 void Postgres() const;
 protected:
  QProcess Qp;
 private:
  virtual bool run(const QString&, const QStringList&) = 0;
};


class GetAsteroid: public QDialog, public Ui_Asteroids
{
 private:
  Q_OBJECT

 public:
  GetAsteroid(SkyDmin* sd);
  ~GetAsteroid() {}

  public slots:
    void on_Search_clicked();
    void gotData(const QList<QVariant>& vl, const QVariant v);
    void gotError(int i, const QString& s, const QVariant& v);
 private:
    SkyDmin* Sd;
};

class SkyDmin: public QDialog, public Ui_Skydmin, public SkyBase
{
  Q_OBJECT

 public:

  SkyDmin(char *c);


  QSqlTableModel *Tbm[5];
  bool Connect(const QString& db);
  inline void Msg(const QString& s) { Install->append(s); }
  QString SePath;
  public slots:

    void on_tabWidget_currentChanged(int);
    void on_LoginButton_clicked();
    void on_Insert_clicked();
    void UpdateAccess(int, QSqlRecord&);
    void on_Delete_clicked();
    void on_InstallButton_clicked();
    void on_UninstallButton_clicked();
    void on_DeleteSources_clicked();
    void on_DownloadSe1_clicked();
    void on_DownloadAster_clicked();
    void Clicked(const QModelIndex&);
    void Progress(qint64 bytesReceived, qint64 bytesTotal);

 private:

    void Fill();
    int T, R, P;
    bool Logged;
    bool run(const QString&, const QStringList&);
    bool LoadSePath();
    void LoadSe1(const QString&, const QString& dir = "");
    QString SeName(int idx) const;;
    QNetworkAccessManager *Manager;
};

class Install: public QObject, public SkyBase
{
  Q_OBJECT
	
 public:
  Install(char *c);
  bool Connect(const QString& db);
  inline void Msg(const QString& s) { std::cout << s.toUtf8().data() << std::endl; }

 private:
  bool run(const QString&, const QStringList&);
};
