/***************************************************************************
                          localhorizonchart.h  -  description
                             -------------------
    begin                : lun jun 2 2003
    copyright            : (C) 2003 by Christophe Gros
    email                : skylendar@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOCALHORIZONCHART_H
#define LOCALHORIZONCHART_H

#include <astrographics.h>
#include "astrotable.h"
#include "ui_target.h"

class AstroObjs;
class AstroConstellations;
class LocalHorizonChart;

class AstroTarget: public QWidget, public Ui_Target
{
    Q_OBJECT

public:

    AstroTarget(QWidget*, LocalHorizonChart* lhc);

    void SetAz(float az);
    void SetEl(float el);

    float Azimuth = 0.0, Elevation = 0.0;

public slots:

    void on_AzDeg_valueChanged(int);
    void on_AzMin_valueChanged(int);
    void on_ElDeg_valueChanged(int);
    void on_ElMin_valueChanged(int);

private:

    LocalHorizonChart* Lhc;
};

/**This class manages the local horizon graphic chart
  *@author Christophe Gros
  */

class LocalHorizonChart : public GraphicChartBase
{

	Q_DECLARE_TR_FUNCTIONS(LocalHorizonChart)

public:
    LocalHorizonChart(ChartBaseParams*, ObjsVector*);
    ~LocalHorizonChart();

    bool Redisplay();

    void DrawTarget(float az, float el);

    void SetTarget(float az, float el);

    void GetCoord(int x, int y, double* rx, double* ry) const;

    struct Pos
    {
        short x, y, px, py;
        unsigned short o;
    };

private:

    //void ReCoord(short& x, short& y) const;
    void ReCoord(float az, float el, short& x, short& y) const;
    void Place(int i, int j);
    inline bool CheckDist(short x, short y, short x1, short y1, short dist) const
    {
        short dx = x1 - x, dy = y1 - y;
        short d = short(sqrtf(dx * dx + dy * dy));
        return d >= dist ? true : false;
    }
    inline void Angle(short& x, short& y, short r, float angle) const
    {
        angle = DEGRAD(Normalize(angle + 270.0));
        y -= short(r * sinf(angle));
        x += short(r * cosf(angle));
    }
    void DisplayCons();
    Pos Pos[Last_Star];
    int Size, SizeX, SizeY, SizeOOO, W, H, T, U;
    float Az = 0.0, El = 0.0;
    enum CompModes Cms;
    bool h;
    AstroTarget* At = nullptr;
#ifdef QT
		QRegion Mask;
#endif

};

#endif
