#!/bin/sh

version="0.5.2"

if [ -z "$1" ]; then
    echo "Usage: $0 <bundle.app>"
    exit 1
fi

name=$(basename "$1" | perl -pe 's/(.*).app/\1/')
bundle_dir="$1"
temp_dir="dmg/$name"
output_file="$name-$version.dmg"

rm -rf "$temp_dir"
rm -f "$output_file"

mkdir -p "$temp_dir"
#mkdir -p "$temp_dir/.background"
#cp ../dist/macos/dmg_background.png "$temp_dir/.background/background.png"
#cp ../dist/macos/DS_Store.in "$temp_dir/.DS_Store"
#chmod go-rwx "$temp_dir/.DS_Store"
ln -s /Applications "$temp_dir/Applications"
# Copies the prepared bundle into the dir that will become the DMG
cp -R "$bundle_dir" "$temp_dir"

# Create dmg
hdiutil makehybrid -hfs -hfs-volume-name "$name" -hfs-openfolder "$temp_dir" "$temp_dir" -o tmp.dmg
hdiutil convert -format UDZO -imagekey zlib-level=9 tmp.dmg -o "$output_file"
