/*
 * Copyright 2006 Sony Computer Entertainment Inc.
 *
 * Licensed under the SCEA Shared Source License, Version 1.0 (the "License"); you may not use this
 * file except in compliance with the License. You may obtain a copy of the License at:
 * http://research.scea.com/scea_shared_source_license.html
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing permissions and limitations under the
 * License.
 */

#ifndef __DOM_CONSTANTS_H__
#define __DOM_CONSTANTS_H__

#include <dae/daeDomTypes.h>

extern DLLSPEC daeString COLLADA_VERSION;
extern DLLSPEC daeString COLLADA_NAMESPACE;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_BINORMAL;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_COLOR;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_CONTINUITY;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_IMAGE;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_IN_TANGENT;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_INPUT;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_INTERPOLATION;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_INV_BIND_MATRIX;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_JOINT;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_LINEAR_STEPS;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_MORPH_TARGET;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_MORPH_WEIGHT;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_NORMAL;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_OUTPUT;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_OUT_TANGENT;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_POSITION;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_TANGENT;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_TEXBINORMAL;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_TEXCOORD;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_TEXTANGENT;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_UV;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_VERTEX;
extern DLLSPEC daeString COMMON_PROFILE_INPUT_WEIGHT;

extern DLLSPEC daeString COMMON_PROFILE_PARAM_A;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_ANGLE;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_B;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_DOUBLE_SIDED;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_G;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_P;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_Q;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_R;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_S;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_T;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_TIME;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_U;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_V;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_W;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_X;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_Y;
extern DLLSPEC daeString COMMON_PROFILE_PARAM_Z;


extern DLLSPEC daeString COLLADA_TYPE_INPUTGLOBAL;
extern DLLSPEC daeString COLLADA_TYPE_INPUTLOCAL;
extern DLLSPEC daeString COLLADA_TYPE_INPUTLOCALOFFSET;
extern DLLSPEC daeString COLLADA_TYPE_INSTANCEWITHEXTRA;
extern DLLSPEC daeString COLLADA_TYPE_TARGETABLEFLOAT;
extern DLLSPEC daeString COLLADA_TYPE_TARGETABLEFLOAT3;
extern DLLSPEC daeString COLLADA_TYPE_FX_SURFACE_FORMAT_HINT_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_CHANNELS;
extern DLLSPEC daeString COLLADA_TYPE_RANGE;
extern DLLSPEC daeString COLLADA_TYPE_PRECISION;
extern DLLSPEC daeString COLLADA_TYPE_OPTION;
extern DLLSPEC daeString COLLADA_TYPE_FX_SURFACE_INIT_PLANAR_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_ALL;
extern DLLSPEC daeString COLLADA_TYPE_FX_SURFACE_INIT_VOLUME_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_PRIMARY;
extern DLLSPEC daeString COLLADA_TYPE_FX_SURFACE_INIT_CUBE_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_ORDER;
extern DLLSPEC daeString COLLADA_TYPE_FACE;
extern DLLSPEC daeString COLLADA_TYPE_FX_SURFACE_INIT_FROM_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_FX_SURFACE_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_FORMAT;
extern DLLSPEC daeString COLLADA_TYPE_SIZE;
extern DLLSPEC daeString COLLADA_TYPE_VIEWPORT_RATIO;
extern DLLSPEC daeString COLLADA_TYPE_MIP_LEVELS;
extern DLLSPEC daeString COLLADA_TYPE_MIPMAP_GENERATE;
extern DLLSPEC daeString COLLADA_TYPE_FX_SAMPLER1D_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_SOURCE;
extern DLLSPEC daeString COLLADA_TYPE_WRAP_S;
extern DLLSPEC daeString COLLADA_TYPE_MINFILTER;
extern DLLSPEC daeString COLLADA_TYPE_MAGFILTER;
extern DLLSPEC daeString COLLADA_TYPE_MIPFILTER;
extern DLLSPEC daeString COLLADA_TYPE_BORDER_COLOR;
extern DLLSPEC daeString COLLADA_TYPE_MIPMAP_MAXLEVEL;
extern DLLSPEC daeString COLLADA_TYPE_MIPMAP_BIAS;
extern DLLSPEC daeString COLLADA_TYPE_FX_SAMPLER2D_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_WRAP_T;
extern DLLSPEC daeString COLLADA_TYPE_FX_SAMPLER3D_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_WRAP_P;
extern DLLSPEC daeString COLLADA_TYPE_FX_SAMPLERCUBE_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_FX_SAMPLERRECT_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_FX_SAMPLERDEPTH_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_FX_COLORTARGET_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_FX_DEPTHTARGET_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_FX_STENCILTARGET_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_FX_CLEARCOLOR_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_FX_CLEARDEPTH_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_FX_CLEARSTENCIL_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_FX_ANNOTATE_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_FX_INCLUDE_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_FX_NEWPARAM_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_SEMANTIC;
extern DLLSPEC daeString COLLADA_TYPE_MODIFIER;
extern DLLSPEC daeString COLLADA_TYPE_FX_CODE_PROFILE;
extern DLLSPEC daeString COLLADA_TYPE_GL_SAMPLER1D;
extern DLLSPEC daeString COLLADA_TYPE_GL_SAMPLER2D;
extern DLLSPEC daeString COLLADA_TYPE_GL_SAMPLER3D;
extern DLLSPEC daeString COLLADA_TYPE_GL_SAMPLERCUBE;
extern DLLSPEC daeString COLLADA_TYPE_GL_SAMPLERRECT;
extern DLLSPEC daeString COLLADA_TYPE_GL_SAMPLERDEPTH;
extern DLLSPEC daeString COLLADA_TYPE_GLSL_NEWARRAY_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_GLSL_SETARRAY_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_GLSL_SURFACE_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_GENERATOR;
extern DLLSPEC daeString COLLADA_TYPE_NAME;
extern DLLSPEC daeString COLLADA_TYPE_GLSL_NEWPARAM;
extern DLLSPEC daeString COLLADA_TYPE_GLSL_SETPARAM_SIMPLE;
extern DLLSPEC daeString COLLADA_TYPE_GLSL_SETPARAM;
extern DLLSPEC daeString COLLADA_TYPE_COMMON_FLOAT_OR_PARAM_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT;
extern DLLSPEC daeString COLLADA_TYPE_PARAM;
extern DLLSPEC daeString COLLADA_TYPE_COMMON_COLOR_OR_TEXTURE_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_COLOR;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURE;
extern DLLSPEC daeString COLLADA_TYPE_COMMON_TRANSPARENT_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_COMMON_NEWPARAM_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT2;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT3;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT4;
extern DLLSPEC daeString COLLADA_TYPE_CG_SAMPLER1D;
extern DLLSPEC daeString COLLADA_TYPE_CG_SAMPLER2D;
extern DLLSPEC daeString COLLADA_TYPE_CG_SAMPLER3D;
extern DLLSPEC daeString COLLADA_TYPE_CG_SAMPLERCUBE;
extern DLLSPEC daeString COLLADA_TYPE_CG_SAMPLERRECT;
extern DLLSPEC daeString COLLADA_TYPE_CG_SAMPLERDEPTH;
extern DLLSPEC daeString COLLADA_TYPE_CG_CONNECT_PARAM;
extern DLLSPEC daeString COLLADA_TYPE_CG_NEWARRAY_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_CG_SETARRAY_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_CG_SETUSER_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_CG_SURFACE_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_CG_NEWPARAM;
extern DLLSPEC daeString COLLADA_TYPE_CG_SETPARAM_SIMPLE;
extern DLLSPEC daeString COLLADA_TYPE_CG_SETPARAM;
extern DLLSPEC daeString COLLADA_TYPE_GLES_TEXTURE_CONSTANT_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_GLES_TEXENV_COMMAND_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_GLES_TEXCOMBINER_ARGUMENTRGB_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_GLES_TEXCOMBINER_ARGUMENTALPHA_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_GLES_TEXCOMBINER_COMMANDRGB_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_GLES_TEXCOMBINER_COMMANDALPHA_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_GLES_TEXCOMBINER_COMMAND_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_GLES_TEXTURE_PIPELINE;
extern DLLSPEC daeString COLLADA_TYPE_GLES_TEXTURE_UNIT;
extern DLLSPEC daeString COLLADA_TYPE_SURFACE;
extern DLLSPEC daeString COLLADA_TYPE_SAMPLER_STATE;
extern DLLSPEC daeString COLLADA_TYPE_TEXCOORD;
extern DLLSPEC daeString COLLADA_TYPE_GLES_SAMPLER_STATE;
extern DLLSPEC daeString COLLADA_TYPE_GLES_NEWPARAM;
extern DLLSPEC daeString COLLADA_TYPE_FX_SURFACE_INIT_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_INIT_AS_NULL;
extern DLLSPEC daeString COLLADA_TYPE_INIT_AS_TARGET;
extern DLLSPEC daeString COLLADA_TYPE_FX_ANNOTATE_TYPE_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_BOOL;
extern DLLSPEC daeString COLLADA_TYPE_BOOL2;
extern DLLSPEC daeString COLLADA_TYPE_BOOL3;
extern DLLSPEC daeString COLLADA_TYPE_BOOL4;
extern DLLSPEC daeString COLLADA_TYPE_INT;
extern DLLSPEC daeString COLLADA_TYPE_INT2;
extern DLLSPEC daeString COLLADA_TYPE_INT3;
extern DLLSPEC daeString COLLADA_TYPE_INT4;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT2X2;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT3X3;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT4X4;
extern DLLSPEC daeString COLLADA_TYPE_STRING;
extern DLLSPEC daeString COLLADA_TYPE_FX_BASIC_TYPE_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT1X1;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT1X2;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT1X3;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT1X4;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT2X1;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT2X3;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT2X4;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT3X1;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT3X2;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT3X4;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT4X1;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT4X2;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT4X3;
extern DLLSPEC daeString COLLADA_TYPE_ENUM;
extern DLLSPEC daeString COLLADA_TYPE_GL_PIPELINE_SETTINGS;
extern DLLSPEC daeString COLLADA_TYPE_ALPHA_FUNC;
extern DLLSPEC daeString COLLADA_TYPE_FUNC;
extern DLLSPEC daeString COLLADA_TYPE_VALUE;
extern DLLSPEC daeString COLLADA_TYPE_BLEND_FUNC;
extern DLLSPEC daeString COLLADA_TYPE_SRC;
extern DLLSPEC daeString COLLADA_TYPE_DEST;
extern DLLSPEC daeString COLLADA_TYPE_BLEND_FUNC_SEPARATE;
extern DLLSPEC daeString COLLADA_TYPE_SRC_RGB;
extern DLLSPEC daeString COLLADA_TYPE_DEST_RGB;
extern DLLSPEC daeString COLLADA_TYPE_SRC_ALPHA;
extern DLLSPEC daeString COLLADA_TYPE_DEST_ALPHA;
extern DLLSPEC daeString COLLADA_TYPE_BLEND_EQUATION;
extern DLLSPEC daeString COLLADA_TYPE_BLEND_EQUATION_SEPARATE;
extern DLLSPEC daeString COLLADA_TYPE_RGB;
extern DLLSPEC daeString COLLADA_TYPE_ALPHA;
extern DLLSPEC daeString COLLADA_TYPE_COLOR_MATERIAL;
extern DLLSPEC daeString COLLADA_TYPE_MODE;
extern DLLSPEC daeString COLLADA_TYPE_CULL_FACE;
extern DLLSPEC daeString COLLADA_TYPE_DEPTH_FUNC;
extern DLLSPEC daeString COLLADA_TYPE_FOG_MODE;
extern DLLSPEC daeString COLLADA_TYPE_FOG_COORD_SRC;
extern DLLSPEC daeString COLLADA_TYPE_FRONT_FACE;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_MODEL_COLOR_CONTROL;
extern DLLSPEC daeString COLLADA_TYPE_LOGIC_OP;
extern DLLSPEC daeString COLLADA_TYPE_POLYGON_MODE;
extern DLLSPEC daeString COLLADA_TYPE_SHADE_MODEL;
extern DLLSPEC daeString COLLADA_TYPE_STENCIL_FUNC;
extern DLLSPEC daeString COLLADA_TYPE_REF;
extern DLLSPEC daeString COLLADA_TYPE_MASK;
extern DLLSPEC daeString COLLADA_TYPE_STENCIL_OP;
extern DLLSPEC daeString COLLADA_TYPE_FAIL;
extern DLLSPEC daeString COLLADA_TYPE_ZFAIL;
extern DLLSPEC daeString COLLADA_TYPE_ZPASS;
extern DLLSPEC daeString COLLADA_TYPE_STENCIL_FUNC_SEPARATE;
extern DLLSPEC daeString COLLADA_TYPE_FRONT;
extern DLLSPEC daeString COLLADA_TYPE_BACK;
extern DLLSPEC daeString COLLADA_TYPE_STENCIL_OP_SEPARATE;
extern DLLSPEC daeString COLLADA_TYPE_STENCIL_MASK_SEPARATE;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_AMBIENT;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_DIFFUSE;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_SPECULAR;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_POSITION;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_CONSTANT_ATTENUATION;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_LINEAR_ATTENUATION;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_QUADRATIC_ATTENUATION;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_SPOT_CUTOFF;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_SPOT_DIRECTION;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_SPOT_EXPONENT;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURE1D;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURE2D;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURE3D;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURECUBE;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURERECT;
extern DLLSPEC daeString COLLADA_TYPE_TEXTUREDEPTH;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURE1D_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURE2D_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURE3D_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURECUBE_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURERECT_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_TEXTUREDEPTH_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURE_ENV_COLOR;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURE_ENV_MODE;
extern DLLSPEC daeString COLLADA_TYPE_CLIP_PLANE;
extern DLLSPEC daeString COLLADA_TYPE_CLIP_PLANE_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_BLEND_COLOR;
extern DLLSPEC daeString COLLADA_TYPE_CLEAR_COLOR;
extern DLLSPEC daeString COLLADA_TYPE_CLEAR_STENCIL;
extern DLLSPEC daeString COLLADA_TYPE_CLEAR_DEPTH;
extern DLLSPEC daeString COLLADA_TYPE_COLOR_MASK;
extern DLLSPEC daeString COLLADA_TYPE_DEPTH_BOUNDS;
extern DLLSPEC daeString COLLADA_TYPE_DEPTH_MASK;
extern DLLSPEC daeString COLLADA_TYPE_DEPTH_RANGE;
extern DLLSPEC daeString COLLADA_TYPE_FOG_DENSITY;
extern DLLSPEC daeString COLLADA_TYPE_FOG_START;
extern DLLSPEC daeString COLLADA_TYPE_FOG_END;
extern DLLSPEC daeString COLLADA_TYPE_FOG_COLOR;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_MODEL_AMBIENT;
extern DLLSPEC daeString COLLADA_TYPE_LIGHTING_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_LINE_STIPPLE;
extern DLLSPEC daeString COLLADA_TYPE_LINE_WIDTH;
extern DLLSPEC daeString COLLADA_TYPE_MATERIAL_AMBIENT;
extern DLLSPEC daeString COLLADA_TYPE_MATERIAL_DIFFUSE;
extern DLLSPEC daeString COLLADA_TYPE_MATERIAL_EMISSION;
extern DLLSPEC daeString COLLADA_TYPE_MATERIAL_SHININESS;
extern DLLSPEC daeString COLLADA_TYPE_MATERIAL_SPECULAR;
extern DLLSPEC daeString COLLADA_TYPE_MODEL_VIEW_MATRIX;
extern DLLSPEC daeString COLLADA_TYPE_POINT_DISTANCE_ATTENUATION;
extern DLLSPEC daeString COLLADA_TYPE_POINT_FADE_THRESHOLD_SIZE;
extern DLLSPEC daeString COLLADA_TYPE_POINT_SIZE;
extern DLLSPEC daeString COLLADA_TYPE_POINT_SIZE_MIN;
extern DLLSPEC daeString COLLADA_TYPE_POINT_SIZE_MAX;
extern DLLSPEC daeString COLLADA_TYPE_POLYGON_OFFSET;
extern DLLSPEC daeString COLLADA_TYPE_PROJECTION_MATRIX;
extern DLLSPEC daeString COLLADA_TYPE_SCISSOR;
extern DLLSPEC daeString COLLADA_TYPE_STENCIL_MASK;
extern DLLSPEC daeString COLLADA_TYPE_ALPHA_TEST_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_AUTO_NORMAL_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_BLEND_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_COLOR_LOGIC_OP_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_COLOR_MATERIAL_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_CULL_FACE_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_DEPTH_BOUNDS_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_DEPTH_CLAMP_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_DEPTH_TEST_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_DITHER_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_FOG_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_MODEL_LOCAL_VIEWER_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_MODEL_TWO_SIDE_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_LINE_SMOOTH_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_LINE_STIPPLE_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_LOGIC_OP_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_MULTISAMPLE_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_NORMALIZE_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_POINT_SMOOTH_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_POLYGON_OFFSET_FILL_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_POLYGON_OFFSET_LINE_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_POLYGON_OFFSET_POINT_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_POLYGON_SMOOTH_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_POLYGON_STIPPLE_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_RESCALE_NORMAL_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_SAMPLE_ALPHA_TO_COVERAGE_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_SAMPLE_ALPHA_TO_ONE_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_SAMPLE_COVERAGE_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_SCISSOR_TEST_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_STENCIL_TEST_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_GLSL_PARAM_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_CG_PARAM_TYPE;
extern DLLSPEC daeString COLLADA_TYPE_BOOL1;
extern DLLSPEC daeString COLLADA_TYPE_BOOL1X1;
extern DLLSPEC daeString COLLADA_TYPE_BOOL1X2;
extern DLLSPEC daeString COLLADA_TYPE_BOOL1X3;
extern DLLSPEC daeString COLLADA_TYPE_BOOL1X4;
extern DLLSPEC daeString COLLADA_TYPE_BOOL2X1;
extern DLLSPEC daeString COLLADA_TYPE_BOOL2X2;
extern DLLSPEC daeString COLLADA_TYPE_BOOL2X3;
extern DLLSPEC daeString COLLADA_TYPE_BOOL2X4;
extern DLLSPEC daeString COLLADA_TYPE_BOOL3X1;
extern DLLSPEC daeString COLLADA_TYPE_BOOL3X2;
extern DLLSPEC daeString COLLADA_TYPE_BOOL3X3;
extern DLLSPEC daeString COLLADA_TYPE_BOOL3X4;
extern DLLSPEC daeString COLLADA_TYPE_BOOL4X1;
extern DLLSPEC daeString COLLADA_TYPE_BOOL4X2;
extern DLLSPEC daeString COLLADA_TYPE_BOOL4X3;
extern DLLSPEC daeString COLLADA_TYPE_BOOL4X4;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT1;
extern DLLSPEC daeString COLLADA_TYPE_INT1;
extern DLLSPEC daeString COLLADA_TYPE_INT1X1;
extern DLLSPEC daeString COLLADA_TYPE_INT1X2;
extern DLLSPEC daeString COLLADA_TYPE_INT1X3;
extern DLLSPEC daeString COLLADA_TYPE_INT1X4;
extern DLLSPEC daeString COLLADA_TYPE_INT2X1;
extern DLLSPEC daeString COLLADA_TYPE_INT2X2;
extern DLLSPEC daeString COLLADA_TYPE_INT2X3;
extern DLLSPEC daeString COLLADA_TYPE_INT2X4;
extern DLLSPEC daeString COLLADA_TYPE_INT3X1;
extern DLLSPEC daeString COLLADA_TYPE_INT3X2;
extern DLLSPEC daeString COLLADA_TYPE_INT3X3;
extern DLLSPEC daeString COLLADA_TYPE_INT3X4;
extern DLLSPEC daeString COLLADA_TYPE_INT4X1;
extern DLLSPEC daeString COLLADA_TYPE_INT4X2;
extern DLLSPEC daeString COLLADA_TYPE_INT4X3;
extern DLLSPEC daeString COLLADA_TYPE_INT4X4;
extern DLLSPEC daeString COLLADA_TYPE_HALF;
extern DLLSPEC daeString COLLADA_TYPE_HALF1;
extern DLLSPEC daeString COLLADA_TYPE_HALF2;
extern DLLSPEC daeString COLLADA_TYPE_HALF3;
extern DLLSPEC daeString COLLADA_TYPE_HALF4;
extern DLLSPEC daeString COLLADA_TYPE_HALF1X1;
extern DLLSPEC daeString COLLADA_TYPE_HALF1X2;
extern DLLSPEC daeString COLLADA_TYPE_HALF1X3;
extern DLLSPEC daeString COLLADA_TYPE_HALF1X4;
extern DLLSPEC daeString COLLADA_TYPE_HALF2X1;
extern DLLSPEC daeString COLLADA_TYPE_HALF2X2;
extern DLLSPEC daeString COLLADA_TYPE_HALF2X3;
extern DLLSPEC daeString COLLADA_TYPE_HALF2X4;
extern DLLSPEC daeString COLLADA_TYPE_HALF3X1;
extern DLLSPEC daeString COLLADA_TYPE_HALF3X2;
extern DLLSPEC daeString COLLADA_TYPE_HALF3X3;
extern DLLSPEC daeString COLLADA_TYPE_HALF3X4;
extern DLLSPEC daeString COLLADA_TYPE_HALF4X1;
extern DLLSPEC daeString COLLADA_TYPE_HALF4X2;
extern DLLSPEC daeString COLLADA_TYPE_HALF4X3;
extern DLLSPEC daeString COLLADA_TYPE_HALF4X4;
extern DLLSPEC daeString COLLADA_TYPE_FIXED;
extern DLLSPEC daeString COLLADA_TYPE_FIXED1;
extern DLLSPEC daeString COLLADA_TYPE_FIXED2;
extern DLLSPEC daeString COLLADA_TYPE_FIXED3;
extern DLLSPEC daeString COLLADA_TYPE_FIXED4;
extern DLLSPEC daeString COLLADA_TYPE_FIXED1X1;
extern DLLSPEC daeString COLLADA_TYPE_FIXED1X2;
extern DLLSPEC daeString COLLADA_TYPE_FIXED1X3;
extern DLLSPEC daeString COLLADA_TYPE_FIXED1X4;
extern DLLSPEC daeString COLLADA_TYPE_FIXED2X1;
extern DLLSPEC daeString COLLADA_TYPE_FIXED2X2;
extern DLLSPEC daeString COLLADA_TYPE_FIXED2X3;
extern DLLSPEC daeString COLLADA_TYPE_FIXED2X4;
extern DLLSPEC daeString COLLADA_TYPE_FIXED3X1;
extern DLLSPEC daeString COLLADA_TYPE_FIXED3X2;
extern DLLSPEC daeString COLLADA_TYPE_FIXED3X3;
extern DLLSPEC daeString COLLADA_TYPE_FIXED3X4;
extern DLLSPEC daeString COLLADA_TYPE_FIXED4X1;
extern DLLSPEC daeString COLLADA_TYPE_FIXED4X2;
extern DLLSPEC daeString COLLADA_TYPE_FIXED4X3;
extern DLLSPEC daeString COLLADA_TYPE_FIXED4X4;
extern DLLSPEC daeString COLLADA_TYPE_GLES_PIPELINE_SETTINGS;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURE_PIPELINE;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT_LINEAR_ATTENUTATION;
extern DLLSPEC daeString COLLADA_TYPE_TEXTURE_PIPELINE_ENABLE;
extern DLLSPEC daeString COLLADA_TYPE_GLES_BASIC_TYPE_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_COLLADA;
extern DLLSPEC daeString COLLADA_TYPE_SCENE;
extern DLLSPEC daeString COLLADA_TYPE_IDREF_ARRAY;
extern DLLSPEC daeString COLLADA_TYPE_NAME_ARRAY;
extern DLLSPEC daeString COLLADA_TYPE_BOOL_ARRAY;
extern DLLSPEC daeString COLLADA_TYPE_FLOAT_ARRAY;
extern DLLSPEC daeString COLLADA_TYPE_INT_ARRAY;
extern DLLSPEC daeString COLLADA_TYPE_ACCESSOR;
extern DLLSPEC daeString COLLADA_TYPE_TECHNIQUE_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_GEOMETRY;
extern DLLSPEC daeString COLLADA_TYPE_MESH;
extern DLLSPEC daeString COLLADA_TYPE_SPLINE;
extern DLLSPEC daeString COLLADA_TYPE_CONTROL_VERTICES;
extern DLLSPEC daeString COLLADA_TYPE_P;
extern DLLSPEC daeString COLLADA_TYPE_LINES;
extern DLLSPEC daeString COLLADA_TYPE_LINESTRIPS;
extern DLLSPEC daeString COLLADA_TYPE_POLYGONS;
extern DLLSPEC daeString COLLADA_TYPE_PH;
extern DLLSPEC daeString COLLADA_TYPE_H;
extern DLLSPEC daeString COLLADA_TYPE_POLYLIST;
extern DLLSPEC daeString COLLADA_TYPE_VCOUNT;
extern DLLSPEC daeString COLLADA_TYPE_TRIANGLES;
extern DLLSPEC daeString COLLADA_TYPE_TRIFANS;
extern DLLSPEC daeString COLLADA_TYPE_TRISTRIPS;
extern DLLSPEC daeString COLLADA_TYPE_VERTICES;
extern DLLSPEC daeString COLLADA_TYPE_LOOKAT;
extern DLLSPEC daeString COLLADA_TYPE_MATRIX;
extern DLLSPEC daeString COLLADA_TYPE_ROTATE;
extern DLLSPEC daeString COLLADA_TYPE_SCALE;
extern DLLSPEC daeString COLLADA_TYPE_SKEW;
extern DLLSPEC daeString COLLADA_TYPE_TRANSLATE;
extern DLLSPEC daeString COLLADA_TYPE_IMAGE;
extern DLLSPEC daeString COLLADA_TYPE_DATA;
extern DLLSPEC daeString COLLADA_TYPE_INIT_FROM;
extern DLLSPEC daeString COLLADA_TYPE_LIGHT;
extern DLLSPEC daeString COLLADA_TYPE_AMBIENT;
extern DLLSPEC daeString COLLADA_TYPE_DIRECTIONAL;
extern DLLSPEC daeString COLLADA_TYPE_POINT;
extern DLLSPEC daeString COLLADA_TYPE_SPOT;
extern DLLSPEC daeString COLLADA_TYPE_MATERIAL;
extern DLLSPEC daeString COLLADA_TYPE_CAMERA;
extern DLLSPEC daeString COLLADA_TYPE_OPTICS;
extern DLLSPEC daeString COLLADA_TYPE_ORTHOGRAPHIC;
extern DLLSPEC daeString COLLADA_TYPE_PERSPECTIVE;
extern DLLSPEC daeString COLLADA_TYPE_IMAGER;
extern DLLSPEC daeString COLLADA_TYPE_ANIMATION;
extern DLLSPEC daeString COLLADA_TYPE_ANIMATION_CLIP;
extern DLLSPEC daeString COLLADA_TYPE_CHANNEL;
extern DLLSPEC daeString COLLADA_TYPE_SAMPLER;
extern DLLSPEC daeString COLLADA_TYPE_CONTROLLER;
extern DLLSPEC daeString COLLADA_TYPE_SKIN;
extern DLLSPEC daeString COLLADA_TYPE_BIND_SHAPE_MATRIX;
extern DLLSPEC daeString COLLADA_TYPE_JOINTS;
extern DLLSPEC daeString COLLADA_TYPE_VERTEX_WEIGHTS;
extern DLLSPEC daeString COLLADA_TYPE_V;
extern DLLSPEC daeString COLLADA_TYPE_MORPH;
extern DLLSPEC daeString COLLADA_TYPE_TARGETS;
extern DLLSPEC daeString COLLADA_TYPE_ASSET;
extern DLLSPEC daeString COLLADA_TYPE_CONTRIBUTOR;
extern DLLSPEC daeString COLLADA_TYPE_AUTHOR;
extern DLLSPEC daeString COLLADA_TYPE_AUTHORING_TOOL;
extern DLLSPEC daeString COLLADA_TYPE_COMMENTS;
extern DLLSPEC daeString COLLADA_TYPE_COPYRIGHT;
extern DLLSPEC daeString COLLADA_TYPE_SOURCE_DATA;
extern DLLSPEC daeString COLLADA_TYPE_CREATED;
extern DLLSPEC daeString COLLADA_TYPE_KEYWORDS;
extern DLLSPEC daeString COLLADA_TYPE_MODIFIED;
extern DLLSPEC daeString COLLADA_TYPE_REVISION;
extern DLLSPEC daeString COLLADA_TYPE_SUBJECT;
extern DLLSPEC daeString COLLADA_TYPE_TITLE;
extern DLLSPEC daeString COLLADA_TYPE_UNIT;
extern DLLSPEC daeString COLLADA_TYPE_UP_AXIS;
extern DLLSPEC daeString COLLADA_TYPE_EXTRA;
extern DLLSPEC daeString COLLADA_TYPE_TECHNIQUE;
extern DLLSPEC daeString COLLADA_TYPE_NODE;
extern DLLSPEC daeString COLLADA_TYPE_VISUAL_SCENE;
extern DLLSPEC daeString COLLADA_TYPE_EVALUATE_SCENE;
extern DLLSPEC daeString COLLADA_TYPE_RENDER;
extern DLLSPEC daeString COLLADA_TYPE_LAYER;
extern DLLSPEC daeString COLLADA_TYPE_BIND_MATERIAL;
extern DLLSPEC daeString COLLADA_TYPE_INSTANCE_CAMERA;
extern DLLSPEC daeString COLLADA_TYPE_INSTANCE_CONTROLLER;
extern DLLSPEC daeString COLLADA_TYPE_SKELETON;
extern DLLSPEC daeString COLLADA_TYPE_INSTANCE_EFFECT;
extern DLLSPEC daeString COLLADA_TYPE_TECHNIQUE_HINT;
extern DLLSPEC daeString COLLADA_TYPE_SETPARAM;
extern DLLSPEC daeString COLLADA_TYPE_INSTANCE_FORCE_FIELD;
extern DLLSPEC daeString COLLADA_TYPE_INSTANCE_GEOMETRY;
extern DLLSPEC daeString COLLADA_TYPE_INSTANCE_LIGHT;
extern DLLSPEC daeString COLLADA_TYPE_INSTANCE_MATERIAL;
extern DLLSPEC daeString COLLADA_TYPE_BIND;
extern DLLSPEC daeString COLLADA_TYPE_BIND_VERTEX_INPUT;
extern DLLSPEC daeString COLLADA_TYPE_INSTANCE_NODE;
extern DLLSPEC daeString COLLADA_TYPE_INSTANCE_PHYSICS_MATERIAL;
extern DLLSPEC daeString COLLADA_TYPE_INSTANCE_PHYSICS_MODEL;
extern DLLSPEC daeString COLLADA_TYPE_INSTANCE_RIGID_BODY;
extern DLLSPEC daeString COLLADA_TYPE_ANGULAR_VELOCITY;
extern DLLSPEC daeString COLLADA_TYPE_VELOCITY;
extern DLLSPEC daeString COLLADA_TYPE_DYNAMIC;
extern DLLSPEC daeString COLLADA_TYPE_MASS_FRAME;
extern DLLSPEC daeString COLLADA_TYPE_SHAPE;
extern DLLSPEC daeString COLLADA_TYPE_HOLLOW;
extern DLLSPEC daeString COLLADA_TYPE_INSTANCE_RIGID_CONSTRAINT;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_ANIMATIONS;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_ANIMATION_CLIPS;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_CAMERAS;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_CONTROLLERS;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_GEOMETRIES;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_EFFECTS;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_FORCE_FIELDS;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_IMAGES;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_LIGHTS;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_MATERIALS;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_NODES;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_PHYSICS_MATERIALS;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_PHYSICS_MODELS;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_PHYSICS_SCENES;
extern DLLSPEC daeString COLLADA_TYPE_LIBRARY_VISUAL_SCENES;
extern DLLSPEC daeString COLLADA_TYPE_FX_PROFILE_ABSTRACT;
extern DLLSPEC daeString COLLADA_TYPE_EFFECT;
extern DLLSPEC daeString COLLADA_TYPE_GL_HOOK_ABSTRACT;
extern DLLSPEC daeString COLLADA_TYPE_PROFILE_GLSL;
extern DLLSPEC daeString COLLADA_TYPE_PASS;
extern DLLSPEC daeString COLLADA_TYPE_DRAW;
extern DLLSPEC daeString COLLADA_TYPE_SHADER;
extern DLLSPEC daeString COLLADA_TYPE_COMPILER_TARGET;
extern DLLSPEC daeString COLLADA_TYPE_COMPILER_OPTIONS;
extern DLLSPEC daeString COLLADA_TYPE_PROFILE_COMMON;
extern DLLSPEC daeString COLLADA_TYPE_CONSTANT;
extern DLLSPEC daeString COLLADA_TYPE_LAMBERT;
extern DLLSPEC daeString COLLADA_TYPE_PHONG;
extern DLLSPEC daeString COLLADA_TYPE_BLINN;
extern DLLSPEC daeString COLLADA_TYPE_PROFILE_CG;
extern DLLSPEC daeString COLLADA_TYPE_PROFILE_GLES;
extern DLLSPEC daeString COLLADA_TYPE_COLOR_TARGET;
extern DLLSPEC daeString COLLADA_TYPE_DEPTH_TARGET;
extern DLLSPEC daeString COLLADA_TYPE_STENCIL_TARGET;
extern DLLSPEC daeString COLLADA_TYPE_COLOR_CLEAR;
extern DLLSPEC daeString COLLADA_TYPE_DEPTH_CLEAR;
extern DLLSPEC daeString COLLADA_TYPE_STENCIL_CLEAR;
extern DLLSPEC daeString COLLADA_TYPE_BOX;
extern DLLSPEC daeString COLLADA_TYPE_HALF_EXTENTS;
extern DLLSPEC daeString COLLADA_TYPE_PLANE;
extern DLLSPEC daeString COLLADA_TYPE_EQUATION;
extern DLLSPEC daeString COLLADA_TYPE_SPHERE;
extern DLLSPEC daeString COLLADA_TYPE_RADIUS;
extern DLLSPEC daeString COLLADA_TYPE_ELLIPSOID;
extern DLLSPEC daeString COLLADA_TYPE_CYLINDER;
extern DLLSPEC daeString COLLADA_TYPE_HEIGHT;
extern DLLSPEC daeString COLLADA_TYPE_TAPERED_CYLINDER;
extern DLLSPEC daeString COLLADA_TYPE_RADIUS1;
extern DLLSPEC daeString COLLADA_TYPE_RADIUS2;
extern DLLSPEC daeString COLLADA_TYPE_CAPSULE;
extern DLLSPEC daeString COLLADA_TYPE_TAPERED_CAPSULE;
extern DLLSPEC daeString COLLADA_TYPE_CONVEX_MESH;
extern DLLSPEC daeString COLLADA_TYPE_FORCE_FIELD;
extern DLLSPEC daeString COLLADA_TYPE_PHYSICS_MATERIAL;
extern DLLSPEC daeString COLLADA_TYPE_PHYSICS_SCENE;
extern DLLSPEC daeString COLLADA_TYPE_RIGID_BODY;
extern DLLSPEC daeString COLLADA_TYPE_RIGID_CONSTRAINT;
extern DLLSPEC daeString COLLADA_TYPE_REF_ATTACHMENT;
extern DLLSPEC daeString COLLADA_TYPE_ATTACHMENT;
extern DLLSPEC daeString COLLADA_TYPE_ENABLED;
extern DLLSPEC daeString COLLADA_TYPE_INTERPENETRATE;
extern DLLSPEC daeString COLLADA_TYPE_LIMITS;
extern DLLSPEC daeString COLLADA_TYPE_SWING_CONE_AND_TWIST;
extern DLLSPEC daeString COLLADA_TYPE_LINEAR;
extern DLLSPEC daeString COLLADA_TYPE_SPRING;
extern DLLSPEC daeString COLLADA_TYPE_ANGULAR;
extern DLLSPEC daeString COLLADA_TYPE_PHYSICS_MODEL;

extern DLLSPEC daeString COLLADA_ELEMENT_COLLADA;
extern DLLSPEC daeString COLLADA_ELEMENT_EXTRA;
extern DLLSPEC daeString COLLADA_ELEMENT_CHANNELS;
extern DLLSPEC daeString COLLADA_ELEMENT_RANGE;
extern DLLSPEC daeString COLLADA_ELEMENT_PRECISION;
extern DLLSPEC daeString COLLADA_ELEMENT_OPTION;
extern DLLSPEC daeString COLLADA_ELEMENT_ALL;
extern DLLSPEC daeString COLLADA_ELEMENT_PRIMARY;
extern DLLSPEC daeString COLLADA_ELEMENT_FACE;
extern DLLSPEC daeString COLLADA_ELEMENT_ORDER;
extern DLLSPEC daeString COLLADA_ELEMENT_FX_SURFACE_INIT_COMMON;
extern DLLSPEC daeString COLLADA_ELEMENT_FORMAT;
extern DLLSPEC daeString COLLADA_ELEMENT_FORMAT_HINT;
extern DLLSPEC daeString COLLADA_ELEMENT_SIZE;
extern DLLSPEC daeString COLLADA_ELEMENT_VIEWPORT_RATIO;
extern DLLSPEC daeString COLLADA_ELEMENT_MIP_LEVELS;
extern DLLSPEC daeString COLLADA_ELEMENT_MIPMAP_GENERATE;
extern DLLSPEC daeString COLLADA_ELEMENT_SOURCE;
extern DLLSPEC daeString COLLADA_ELEMENT_WRAP_S;
extern DLLSPEC daeString COLLADA_ELEMENT_MINFILTER;
extern DLLSPEC daeString COLLADA_ELEMENT_MAGFILTER;
extern DLLSPEC daeString COLLADA_ELEMENT_MIPFILTER;
extern DLLSPEC daeString COLLADA_ELEMENT_BORDER_COLOR;
extern DLLSPEC daeString COLLADA_ELEMENT_MIPMAP_MAXLEVEL;
extern DLLSPEC daeString COLLADA_ELEMENT_MIPMAP_BIAS;
extern DLLSPEC daeString COLLADA_ELEMENT_WRAP_T;
extern DLLSPEC daeString COLLADA_ELEMENT_WRAP_P;
extern DLLSPEC daeString COLLADA_ELEMENT_FX_ANNOTATE_TYPE_COMMON;
extern DLLSPEC daeString COLLADA_ELEMENT_ANNOTATE;
extern DLLSPEC daeString COLLADA_ELEMENT_SEMANTIC;
extern DLLSPEC daeString COLLADA_ELEMENT_MODIFIER;
extern DLLSPEC daeString COLLADA_ELEMENT_FX_BASIC_TYPE_COMMON;
extern DLLSPEC daeString COLLADA_ELEMENT_GLSL_PARAM_TYPE;
extern DLLSPEC daeString COLLADA_ELEMENT_ARRAY;
extern DLLSPEC daeString COLLADA_ELEMENT_GENERATOR;
extern DLLSPEC daeString COLLADA_ELEMENT_CODE;
extern DLLSPEC daeString COLLADA_ELEMENT_INCLUDE;
extern DLLSPEC daeString COLLADA_ELEMENT_NAME;
extern DLLSPEC daeString COLLADA_ELEMENT_SETPARAM;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT;
extern DLLSPEC daeString COLLADA_ELEMENT_PARAM;
extern DLLSPEC daeString COLLADA_ELEMENT_COLOR;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURE;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT2;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT3;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT4;
extern DLLSPEC daeString COLLADA_ELEMENT_SURFACE;
extern DLLSPEC daeString COLLADA_ELEMENT_SAMPLER2D;
extern DLLSPEC daeString COLLADA_ELEMENT_CG_PARAM_TYPE;
extern DLLSPEC daeString COLLADA_ELEMENT_USERTYPE;
extern DLLSPEC daeString COLLADA_ELEMENT_CONNECT_PARAM;
extern DLLSPEC daeString COLLADA_ELEMENT_CONSTANT;
extern DLLSPEC daeString COLLADA_ELEMENT_ARGUMENT;
extern DLLSPEC daeString COLLADA_ELEMENT_RGB;
extern DLLSPEC daeString COLLADA_ELEMENT_ALPHA;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXCOMBINER;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXENV;
extern DLLSPEC daeString COLLADA_ELEMENT_SAMPLER_STATE;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXCOORD;
extern DLLSPEC daeString COLLADA_ELEMENT_GLES_BASIC_TYPE_COMMON;
extern DLLSPEC daeString COLLADA_ELEMENT_INIT_AS_NULL;
extern DLLSPEC daeString COLLADA_ELEMENT_INIT_AS_TARGET;
extern DLLSPEC daeString COLLADA_ELEMENT_INIT_CUBE;
extern DLLSPEC daeString COLLADA_ELEMENT_INIT_VOLUME;
extern DLLSPEC daeString COLLADA_ELEMENT_INIT_PLANAR;
extern DLLSPEC daeString COLLADA_ELEMENT_INIT_FROM;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL2;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL3;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL4;
extern DLLSPEC daeString COLLADA_ELEMENT_INT;
extern DLLSPEC daeString COLLADA_ELEMENT_INT2;
extern DLLSPEC daeString COLLADA_ELEMENT_INT3;
extern DLLSPEC daeString COLLADA_ELEMENT_INT4;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT2X2;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT3X3;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT4X4;
extern DLLSPEC daeString COLLADA_ELEMENT_STRING;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT1X1;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT1X2;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT1X3;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT1X4;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT2X1;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT2X3;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT2X4;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT3X1;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT3X2;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT3X4;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT4X1;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT4X2;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT4X3;
extern DLLSPEC daeString COLLADA_ELEMENT_SAMPLER1D;
extern DLLSPEC daeString COLLADA_ELEMENT_SAMPLER3D;
extern DLLSPEC daeString COLLADA_ELEMENT_SAMPLERCUBE;
extern DLLSPEC daeString COLLADA_ELEMENT_SAMPLERRECT;
extern DLLSPEC daeString COLLADA_ELEMENT_SAMPLERDEPTH;
extern DLLSPEC daeString COLLADA_ELEMENT_ENUM;
extern DLLSPEC daeString COLLADA_ELEMENT_ALPHA_FUNC;
extern DLLSPEC daeString COLLADA_ELEMENT_BLEND_FUNC;
extern DLLSPEC daeString COLLADA_ELEMENT_BLEND_FUNC_SEPARATE;
extern DLLSPEC daeString COLLADA_ELEMENT_BLEND_EQUATION;
extern DLLSPEC daeString COLLADA_ELEMENT_BLEND_EQUATION_SEPARATE;
extern DLLSPEC daeString COLLADA_ELEMENT_COLOR_MATERIAL;
extern DLLSPEC daeString COLLADA_ELEMENT_CULL_FACE;
extern DLLSPEC daeString COLLADA_ELEMENT_DEPTH_FUNC;
extern DLLSPEC daeString COLLADA_ELEMENT_FOG_MODE;
extern DLLSPEC daeString COLLADA_ELEMENT_FOG_COORD_SRC;
extern DLLSPEC daeString COLLADA_ELEMENT_FRONT_FACE;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_MODEL_COLOR_CONTROL;
extern DLLSPEC daeString COLLADA_ELEMENT_LOGIC_OP;
extern DLLSPEC daeString COLLADA_ELEMENT_POLYGON_MODE;
extern DLLSPEC daeString COLLADA_ELEMENT_SHADE_MODEL;
extern DLLSPEC daeString COLLADA_ELEMENT_STENCIL_FUNC;
extern DLLSPEC daeString COLLADA_ELEMENT_STENCIL_OP;
extern DLLSPEC daeString COLLADA_ELEMENT_STENCIL_FUNC_SEPARATE;
extern DLLSPEC daeString COLLADA_ELEMENT_STENCIL_OP_SEPARATE;
extern DLLSPEC daeString COLLADA_ELEMENT_STENCIL_MASK_SEPARATE;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_AMBIENT;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_DIFFUSE;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_SPECULAR;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_POSITION;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_CONSTANT_ATTENUATION;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_LINEAR_ATTENUATION;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_QUADRATIC_ATTENUATION;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_SPOT_CUTOFF;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_SPOT_DIRECTION;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_SPOT_EXPONENT;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURE1D;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURE2D;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURE3D;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURECUBE;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURERECT;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTUREDEPTH;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURE1D_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURE2D_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURE3D_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURECUBE_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURERECT_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTUREDEPTH_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURE_ENV_COLOR;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURE_ENV_MODE;
extern DLLSPEC daeString COLLADA_ELEMENT_CLIP_PLANE;
extern DLLSPEC daeString COLLADA_ELEMENT_CLIP_PLANE_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_BLEND_COLOR;
extern DLLSPEC daeString COLLADA_ELEMENT_CLEAR_COLOR;
extern DLLSPEC daeString COLLADA_ELEMENT_CLEAR_STENCIL;
extern DLLSPEC daeString COLLADA_ELEMENT_CLEAR_DEPTH;
extern DLLSPEC daeString COLLADA_ELEMENT_COLOR_MASK;
extern DLLSPEC daeString COLLADA_ELEMENT_DEPTH_BOUNDS;
extern DLLSPEC daeString COLLADA_ELEMENT_DEPTH_MASK;
extern DLLSPEC daeString COLLADA_ELEMENT_DEPTH_RANGE;
extern DLLSPEC daeString COLLADA_ELEMENT_FOG_DENSITY;
extern DLLSPEC daeString COLLADA_ELEMENT_FOG_START;
extern DLLSPEC daeString COLLADA_ELEMENT_FOG_END;
extern DLLSPEC daeString COLLADA_ELEMENT_FOG_COLOR;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_MODEL_AMBIENT;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHTING_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_LINE_STIPPLE;
extern DLLSPEC daeString COLLADA_ELEMENT_LINE_WIDTH;
extern DLLSPEC daeString COLLADA_ELEMENT_MATERIAL_AMBIENT;
extern DLLSPEC daeString COLLADA_ELEMENT_MATERIAL_DIFFUSE;
extern DLLSPEC daeString COLLADA_ELEMENT_MATERIAL_EMISSION;
extern DLLSPEC daeString COLLADA_ELEMENT_MATERIAL_SHININESS;
extern DLLSPEC daeString COLLADA_ELEMENT_MATERIAL_SPECULAR;
extern DLLSPEC daeString COLLADA_ELEMENT_MODEL_VIEW_MATRIX;
extern DLLSPEC daeString COLLADA_ELEMENT_POINT_DISTANCE_ATTENUATION;
extern DLLSPEC daeString COLLADA_ELEMENT_POINT_FADE_THRESHOLD_SIZE;
extern DLLSPEC daeString COLLADA_ELEMENT_POINT_SIZE;
extern DLLSPEC daeString COLLADA_ELEMENT_POINT_SIZE_MIN;
extern DLLSPEC daeString COLLADA_ELEMENT_POINT_SIZE_MAX;
extern DLLSPEC daeString COLLADA_ELEMENT_POLYGON_OFFSET;
extern DLLSPEC daeString COLLADA_ELEMENT_PROJECTION_MATRIX;
extern DLLSPEC daeString COLLADA_ELEMENT_SCISSOR;
extern DLLSPEC daeString COLLADA_ELEMENT_STENCIL_MASK;
extern DLLSPEC daeString COLLADA_ELEMENT_ALPHA_TEST_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_AUTO_NORMAL_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_BLEND_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_COLOR_LOGIC_OP_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_COLOR_MATERIAL_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_CULL_FACE_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_DEPTH_BOUNDS_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_DEPTH_CLAMP_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_DEPTH_TEST_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_DITHER_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_FOG_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_MODEL_LOCAL_VIEWER_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_MODEL_TWO_SIDE_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_LINE_SMOOTH_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_LINE_STIPPLE_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_LOGIC_OP_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_MULTISAMPLE_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_NORMALIZE_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_POINT_SMOOTH_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_POLYGON_OFFSET_FILL_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_POLYGON_OFFSET_LINE_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_POLYGON_OFFSET_POINT_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_POLYGON_SMOOTH_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_POLYGON_STIPPLE_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_RESCALE_NORMAL_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_SAMPLE_ALPHA_TO_COVERAGE_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_SAMPLE_ALPHA_TO_ONE_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_SAMPLE_COVERAGE_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_SCISSOR_TEST_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_STENCIL_TEST_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_GL_HOOK_ABSTRACT;
extern DLLSPEC daeString COLLADA_ELEMENT_FUNC;
extern DLLSPEC daeString COLLADA_ELEMENT_VALUE;
extern DLLSPEC daeString COLLADA_ELEMENT_SRC;
extern DLLSPEC daeString COLLADA_ELEMENT_DEST;
extern DLLSPEC daeString COLLADA_ELEMENT_SRC_RGB;
extern DLLSPEC daeString COLLADA_ELEMENT_DEST_RGB;
extern DLLSPEC daeString COLLADA_ELEMENT_SRC_ALPHA;
extern DLLSPEC daeString COLLADA_ELEMENT_DEST_ALPHA;
extern DLLSPEC daeString COLLADA_ELEMENT_rgb;
extern DLLSPEC daeString COLLADA_ELEMENT_MODE;
extern DLLSPEC daeString COLLADA_ELEMENT_REF;
extern DLLSPEC daeString COLLADA_ELEMENT_MASK;
extern DLLSPEC daeString COLLADA_ELEMENT_FAIL;
extern DLLSPEC daeString COLLADA_ELEMENT_ZFAIL;
extern DLLSPEC daeString COLLADA_ELEMENT_ZPASS;
extern DLLSPEC daeString COLLADA_ELEMENT_FRONT;
extern DLLSPEC daeString COLLADA_ELEMENT_BACK;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL1;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL1X1;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL1X2;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL1X3;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL1X4;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL2X1;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL2X2;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL2X3;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL2X4;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL3X1;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL3X2;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL3X3;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL3X4;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL4X1;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL4X2;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL4X3;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL4X4;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT1;
extern DLLSPEC daeString COLLADA_ELEMENT_INT1;
extern DLLSPEC daeString COLLADA_ELEMENT_INT1X1;
extern DLLSPEC daeString COLLADA_ELEMENT_INT1X2;
extern DLLSPEC daeString COLLADA_ELEMENT_INT1X3;
extern DLLSPEC daeString COLLADA_ELEMENT_INT1X4;
extern DLLSPEC daeString COLLADA_ELEMENT_INT2X1;
extern DLLSPEC daeString COLLADA_ELEMENT_INT2X2;
extern DLLSPEC daeString COLLADA_ELEMENT_INT2X3;
extern DLLSPEC daeString COLLADA_ELEMENT_INT2X4;
extern DLLSPEC daeString COLLADA_ELEMENT_INT3X1;
extern DLLSPEC daeString COLLADA_ELEMENT_INT3X2;
extern DLLSPEC daeString COLLADA_ELEMENT_INT3X3;
extern DLLSPEC daeString COLLADA_ELEMENT_INT3X4;
extern DLLSPEC daeString COLLADA_ELEMENT_INT4X1;
extern DLLSPEC daeString COLLADA_ELEMENT_INT4X2;
extern DLLSPEC daeString COLLADA_ELEMENT_INT4X3;
extern DLLSPEC daeString COLLADA_ELEMENT_INT4X4;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF1;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF2;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF3;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF4;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF1X1;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF1X2;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF1X3;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF1X4;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF2X1;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF2X2;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF2X3;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF2X4;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF3X1;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF3X2;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF3X3;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF3X4;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF4X1;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF4X2;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF4X3;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF4X4;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED1;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED2;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED3;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED4;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED1X1;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED1X2;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED1X3;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED1X4;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED2X1;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED2X2;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED2X3;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED2X4;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED3X1;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED3X2;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED3X3;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED3X4;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED4X1;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED4X2;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED4X3;
extern DLLSPEC daeString COLLADA_ELEMENT_FIXED4X4;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURE_PIPELINE;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT_LINEAR_ATTENUTATION;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURE_PIPELINE_ENABLE;
extern DLLSPEC daeString COLLADA_ELEMENT_TEXTURE_UNIT;
extern DLLSPEC daeString COLLADA_ELEMENT_ASSET;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_ANIMATIONS;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_ANIMATION_CLIPS;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_CAMERAS;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_CONTROLLERS;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_GEOMETRIES;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_EFFECTS;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_FORCE_FIELDS;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_IMAGES;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_LIGHTS;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_MATERIALS;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_NODES;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_PHYSICS_MATERIALS;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_PHYSICS_MODELS;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_PHYSICS_SCENES;
extern DLLSPEC daeString COLLADA_ELEMENT_LIBRARY_VISUAL_SCENES;
extern DLLSPEC daeString COLLADA_ELEMENT_SCENE;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_PHYSICS_SCENE;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_VISUAL_SCENE;
extern DLLSPEC daeString COLLADA_ELEMENT_IDREF_ARRAY;
extern DLLSPEC daeString COLLADA_ELEMENT_NAME_ARRAY;
extern DLLSPEC daeString COLLADA_ELEMENT_BOOL_ARRAY;
extern DLLSPEC daeString COLLADA_ELEMENT_FLOAT_ARRAY;
extern DLLSPEC daeString COLLADA_ELEMENT_INT_ARRAY;
extern DLLSPEC daeString COLLADA_ELEMENT_TECHNIQUE_COMMON;
extern DLLSPEC daeString COLLADA_ELEMENT_TECHNIQUE;
extern DLLSPEC daeString COLLADA_ELEMENT_ACCESSOR;
extern DLLSPEC daeString COLLADA_ELEMENT_CONVEX_MESH;
extern DLLSPEC daeString COLLADA_ELEMENT_MESH;
extern DLLSPEC daeString COLLADA_ELEMENT_SPLINE;
extern DLLSPEC daeString COLLADA_ELEMENT_VERTICES;
extern DLLSPEC daeString COLLADA_ELEMENT_LINES;
extern DLLSPEC daeString COLLADA_ELEMENT_LINESTRIPS;
extern DLLSPEC daeString COLLADA_ELEMENT_POLYGONS;
extern DLLSPEC daeString COLLADA_ELEMENT_POLYLIST;
extern DLLSPEC daeString COLLADA_ELEMENT_TRIANGLES;
extern DLLSPEC daeString COLLADA_ELEMENT_TRIFANS;
extern DLLSPEC daeString COLLADA_ELEMENT_TRISTRIPS;
extern DLLSPEC daeString COLLADA_ELEMENT_CONTROL_VERTICES;
extern DLLSPEC daeString COLLADA_ELEMENT_INPUT;
extern DLLSPEC daeString COLLADA_ELEMENT_P;
extern DLLSPEC daeString COLLADA_ELEMENT_PH;
extern DLLSPEC daeString COLLADA_ELEMENT_H;
extern DLLSPEC daeString COLLADA_ELEMENT_VCOUNT;
extern DLLSPEC daeString COLLADA_ELEMENT_DATA;
extern DLLSPEC daeString COLLADA_ELEMENT_AMBIENT;
extern DLLSPEC daeString COLLADA_ELEMENT_DIRECTIONAL;
extern DLLSPEC daeString COLLADA_ELEMENT_POINT;
extern DLLSPEC daeString COLLADA_ELEMENT_SPOT;
extern DLLSPEC daeString COLLADA_ELEMENT_CONSTANT_ATTENUATION;
extern DLLSPEC daeString COLLADA_ELEMENT_LINEAR_ATTENUATION;
extern DLLSPEC daeString COLLADA_ELEMENT_QUADRATIC_ATTENUATION;
extern DLLSPEC daeString COLLADA_ELEMENT_FALLOFF_ANGLE;
extern DLLSPEC daeString COLLADA_ELEMENT_FALLOFF_EXPONENT;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_EFFECT;
extern DLLSPEC daeString COLLADA_ELEMENT_OPTICS;
extern DLLSPEC daeString COLLADA_ELEMENT_IMAGER;
extern DLLSPEC daeString COLLADA_ELEMENT_ORTHOGRAPHIC;
extern DLLSPEC daeString COLLADA_ELEMENT_PERSPECTIVE;
extern DLLSPEC daeString COLLADA_ELEMENT_XMAG;
extern DLLSPEC daeString COLLADA_ELEMENT_YMAG;
extern DLLSPEC daeString COLLADA_ELEMENT_ASPECT_RATIO;
extern DLLSPEC daeString COLLADA_ELEMENT_ZNEAR;
extern DLLSPEC daeString COLLADA_ELEMENT_ZFAR;
extern DLLSPEC daeString COLLADA_ELEMENT_XFOV;
extern DLLSPEC daeString COLLADA_ELEMENT_YFOV;
extern DLLSPEC daeString COLLADA_ELEMENT_SAMPLER;
extern DLLSPEC daeString COLLADA_ELEMENT_CHANNEL;
extern DLLSPEC daeString COLLADA_ELEMENT_ANIMATION;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_ANIMATION;
extern DLLSPEC daeString COLLADA_ELEMENT_SKIN;
extern DLLSPEC daeString COLLADA_ELEMENT_MORPH;
extern DLLSPEC daeString COLLADA_ELEMENT_BIND_SHAPE_MATRIX;
extern DLLSPEC daeString COLLADA_ELEMENT_JOINTS;
extern DLLSPEC daeString COLLADA_ELEMENT_VERTEX_WEIGHTS;
extern DLLSPEC daeString COLLADA_ELEMENT_V;
extern DLLSPEC daeString COLLADA_ELEMENT_TARGETS;
extern DLLSPEC daeString COLLADA_ELEMENT_CONTRIBUTOR;
extern DLLSPEC daeString COLLADA_ELEMENT_CREATED;
extern DLLSPEC daeString COLLADA_ELEMENT_KEYWORDS;
extern DLLSPEC daeString COLLADA_ELEMENT_MODIFIED;
extern DLLSPEC daeString COLLADA_ELEMENT_REVISION;
extern DLLSPEC daeString COLLADA_ELEMENT_SUBJECT;
extern DLLSPEC daeString COLLADA_ELEMENT_TITLE;
extern DLLSPEC daeString COLLADA_ELEMENT_UNIT;
extern DLLSPEC daeString COLLADA_ELEMENT_UP_AXIS;
extern DLLSPEC daeString COLLADA_ELEMENT_AUTHOR;
extern DLLSPEC daeString COLLADA_ELEMENT_AUTHORING_TOOL;
extern DLLSPEC daeString COLLADA_ELEMENT_COMMENTS;
extern DLLSPEC daeString COLLADA_ELEMENT_COPYRIGHT;
extern DLLSPEC daeString COLLADA_ELEMENT_SOURCE_DATA;
extern DLLSPEC daeString COLLADA_ELEMENT_LOOKAT;
extern DLLSPEC daeString COLLADA_ELEMENT_MATRIX;
extern DLLSPEC daeString COLLADA_ELEMENT_ROTATE;
extern DLLSPEC daeString COLLADA_ELEMENT_SCALE;
extern DLLSPEC daeString COLLADA_ELEMENT_SKEW;
extern DLLSPEC daeString COLLADA_ELEMENT_TRANSLATE;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_CAMERA;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_CONTROLLER;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_GEOMETRY;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_LIGHT;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_NODE;
extern DLLSPEC daeString COLLADA_ELEMENT_NODE;
extern DLLSPEC daeString COLLADA_ELEMENT_EVALUATE_SCENE;
extern DLLSPEC daeString COLLADA_ELEMENT_RENDER;
extern DLLSPEC daeString COLLADA_ELEMENT_LAYER;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_MATERIAL;
extern DLLSPEC daeString COLLADA_ELEMENT_SKELETON;
extern DLLSPEC daeString COLLADA_ELEMENT_BIND_MATERIAL;
extern DLLSPEC daeString COLLADA_ELEMENT_TECHNIQUE_HINT;
extern DLLSPEC daeString COLLADA_ELEMENT_BIND;
extern DLLSPEC daeString COLLADA_ELEMENT_BIND_VERTEX_INPUT;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_FORCE_FIELD;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_RIGID_BODY;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_RIGID_CONSTRAINT;
extern DLLSPEC daeString COLLADA_ELEMENT_ANGULAR_VELOCITY;
extern DLLSPEC daeString COLLADA_ELEMENT_VELOCITY;
extern DLLSPEC daeString COLLADA_ELEMENT_DYNAMIC;
extern DLLSPEC daeString COLLADA_ELEMENT_MASS;
extern DLLSPEC daeString COLLADA_ELEMENT_MASS_FRAME;
extern DLLSPEC daeString COLLADA_ELEMENT_INERTIA;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_PHYSICS_MATERIAL;
extern DLLSPEC daeString COLLADA_ELEMENT_PHYSICS_MATERIAL;
extern DLLSPEC daeString COLLADA_ELEMENT_SHAPE;
extern DLLSPEC daeString COLLADA_ELEMENT_HOLLOW;
extern DLLSPEC daeString COLLADA_ELEMENT_DENSITY;
extern DLLSPEC daeString COLLADA_ELEMENT_PLANE;
extern DLLSPEC daeString COLLADA_ELEMENT_BOX;
extern DLLSPEC daeString COLLADA_ELEMENT_SPHERE;
extern DLLSPEC daeString COLLADA_ELEMENT_CYLINDER;
extern DLLSPEC daeString COLLADA_ELEMENT_TAPERED_CYLINDER;
extern DLLSPEC daeString COLLADA_ELEMENT_CAPSULE;
extern DLLSPEC daeString COLLADA_ELEMENT_TAPERED_CAPSULE;
extern DLLSPEC daeString COLLADA_ELEMENT_ANIMATION_CLIP;
extern DLLSPEC daeString COLLADA_ELEMENT_CAMERA;
extern DLLSPEC daeString COLLADA_ELEMENT_CONTROLLER;
extern DLLSPEC daeString COLLADA_ELEMENT_GEOMETRY;
extern DLLSPEC daeString COLLADA_ELEMENT_EFFECT;
extern DLLSPEC daeString COLLADA_ELEMENT_FORCE_FIELD;
extern DLLSPEC daeString COLLADA_ELEMENT_IMAGE;
extern DLLSPEC daeString COLLADA_ELEMENT_LIGHT;
extern DLLSPEC daeString COLLADA_ELEMENT_MATERIAL;
extern DLLSPEC daeString COLLADA_ELEMENT_PHYSICS_MODEL;
extern DLLSPEC daeString COLLADA_ELEMENT_PHYSICS_SCENE;
extern DLLSPEC daeString COLLADA_ELEMENT_VISUAL_SCENE;
extern DLLSPEC daeString COLLADA_ELEMENT_NEWPARAM;
extern DLLSPEC daeString COLLADA_ELEMENT_FX_PROFILE_ABSTRACT;
extern DLLSPEC daeString COLLADA_ELEMENT_PROFILE_GLSL;
extern DLLSPEC daeString COLLADA_ELEMENT_PASS;
extern DLLSPEC daeString COLLADA_ELEMENT_COLOR_TARGET;
extern DLLSPEC daeString COLLADA_ELEMENT_DEPTH_TARGET;
extern DLLSPEC daeString COLLADA_ELEMENT_STENCIL_TARGET;
extern DLLSPEC daeString COLLADA_ELEMENT_COLOR_CLEAR;
extern DLLSPEC daeString COLLADA_ELEMENT_DEPTH_CLEAR;
extern DLLSPEC daeString COLLADA_ELEMENT_STENCIL_CLEAR;
extern DLLSPEC daeString COLLADA_ELEMENT_DRAW;
extern DLLSPEC daeString COLLADA_ELEMENT_GL_PIPELINE_SETTINGS;
extern DLLSPEC daeString COLLADA_ELEMENT_SHADER;
extern DLLSPEC daeString COLLADA_ELEMENT_COMPILER_TARGET;
extern DLLSPEC daeString COLLADA_ELEMENT_COMPILER_OPTIONS;
extern DLLSPEC daeString COLLADA_ELEMENT_PROFILE_COMMON;
extern DLLSPEC daeString COLLADA_ELEMENT_LAMBERT;
extern DLLSPEC daeString COLLADA_ELEMENT_PHONG;
extern DLLSPEC daeString COLLADA_ELEMENT_BLINN;
extern DLLSPEC daeString COLLADA_ELEMENT_EMISSION;
extern DLLSPEC daeString COLLADA_ELEMENT_REFLECTIVE;
extern DLLSPEC daeString COLLADA_ELEMENT_REFLECTIVITY;
extern DLLSPEC daeString COLLADA_ELEMENT_TRANSPARENT;
extern DLLSPEC daeString COLLADA_ELEMENT_TRANSPARENCY;
extern DLLSPEC daeString COLLADA_ELEMENT_INDEX_OF_REFRACTION;
extern DLLSPEC daeString COLLADA_ELEMENT_DIFFUSE;
extern DLLSPEC daeString COLLADA_ELEMENT_SPECULAR;
extern DLLSPEC daeString COLLADA_ELEMENT_SHININESS;
extern DLLSPEC daeString COLLADA_ELEMENT_PROFILE_CG;
extern DLLSPEC daeString COLLADA_ELEMENT_PROFILE_GLES;
extern DLLSPEC daeString COLLADA_ELEMENT_GLES_PIPELINE_SETTINGS;
extern DLLSPEC daeString COLLADA_ELEMENT_HALF_EXTENTS;
extern DLLSPEC daeString COLLADA_ELEMENT_EQUATION;
extern DLLSPEC daeString COLLADA_ELEMENT_RADIUS;
extern DLLSPEC daeString COLLADA_ELEMENT_HEIGHT;
extern DLLSPEC daeString COLLADA_ELEMENT_RADIUS1;
extern DLLSPEC daeString COLLADA_ELEMENT_RADIUS2;
extern DLLSPEC daeString COLLADA_ELEMENT_DYNAMIC_FRICTION;
extern DLLSPEC daeString COLLADA_ELEMENT_RESTITUTION;
extern DLLSPEC daeString COLLADA_ELEMENT_STATIC_FRICTION;
extern DLLSPEC daeString COLLADA_ELEMENT_INSTANCE_PHYSICS_MODEL;
extern DLLSPEC daeString COLLADA_ELEMENT_GRAVITY;
extern DLLSPEC daeString COLLADA_ELEMENT_TIME_STEP;
extern DLLSPEC daeString COLLADA_ELEMENT_REF_ATTACHMENT;
extern DLLSPEC daeString COLLADA_ELEMENT_ATTACHMENT;
extern DLLSPEC daeString COLLADA_ELEMENT_ENABLED;
extern DLLSPEC daeString COLLADA_ELEMENT_INTERPENETRATE;
extern DLLSPEC daeString COLLADA_ELEMENT_LIMITS;
extern DLLSPEC daeString COLLADA_ELEMENT_SPRING;
extern DLLSPEC daeString COLLADA_ELEMENT_SWING_CONE_AND_TWIST;
extern DLLSPEC daeString COLLADA_ELEMENT_LINEAR;
extern DLLSPEC daeString COLLADA_ELEMENT_MIN;
extern DLLSPEC daeString COLLADA_ELEMENT_MAX;
extern DLLSPEC daeString COLLADA_ELEMENT_ANGULAR;
extern DLLSPEC daeString COLLADA_ELEMENT_STIFFNESS;
extern DLLSPEC daeString COLLADA_ELEMENT_DAMPING;
extern DLLSPEC daeString COLLADA_ELEMENT_TARGET_VALUE;
extern DLLSPEC daeString COLLADA_ELEMENT_RIGID_BODY;
extern DLLSPEC daeString COLLADA_ELEMENT_RIGID_CONSTRAINT;

#endif //__DOM_CONSTANTS_H__

