# I release this sample under the MIT license: free for any use, provided 
# you hold me harmless from any such use you make, and you retain my 
# copyright on the actual sources.
# Copyright 2005 Jon Watte.

# Dynamic Library Template

# If this errors out, you didn't specify the right variable value, or 
# you're including the wrong template makefile.

LIBNAME := {$projName}
{assign var="dirWalk" value=$fileArray}
SOURCES := {foreach from=$dirWalk item=file key=key}
{include file="make_fileRecurse.tpl" dirWalk=$file}
{/foreach}

LDFLAGS_{$projName} := -g -m32 -shared
LDLIBS_{$projName} := -lstdc++ -lpthread
CFLAGS_{$projName} := -MMD -I. -m32 -mmmx -msse -march=i686 

{foreach item=def from=$projIncludes}CFLAGS_{$projName} += -I{$def}
{/foreach}

CFLAGS_{$projName} += -DUNICODE
CFLAGS_{$projName} += -DLINUX

{foreach item=def from=$projDefines}CFLAGS_{$projName} += -D{$def}
{/foreach}

CFLAGS_DEBUG_{$projName} := $(CFLAGS_{$projName}) -ggdb
CFLAGS_DEBUG_{$projName} += -DTORQUE_DEBUG
CFLAGS_DEBUG_{$projName} += -DTORQUE_DEBUG_GUARD
CFLAGS_DEBUG_{$projName} += -DTORQUE_NET_STATS

CFLAGS_{$projName} += -O0

CC := gcc
LD := gcc

SHARED_LIB_TARGETS += {$projName}.so
SHARED_LIB_TARGETS_DEBUG += {$projName}_DEBUG.so

OBJS_{$projName} := $(patsubst ../../../../Engine/source/%,Release/{$projName}/%.o,$(SOURCES))
OBJS_{$projName} += $(patsubst ../../source/%,Release/{$projName}/%.o,$(SOURCES))
OBJS_{$projName} := $(filter %.o, $(OBJS_{$projName}))
OBJS_{$projName}_DEBUG := $(patsubst ../../../../Engine/source/%,Debug/{$projName}/%.o,$(SOURCES))
OBJS_{$projName}_DEBUG += $(patsubst ../../source/%, Debug/{$projName}/%.o,$(SOURCES))
OBJS_{$projName}_DEBUG := $(filter %.o, $(OBJS_{$projName}_DEBUG))

# Deriving the variable name from the target name is the secret sauce 
# of the build system.
#
{$projName}.so:	$(OBJS_{$projName}) $(LIB_TARGETS)
	$(LD) $(LDFLAGS_{$projName}) -o $@ $(OBJS_{$projName}) $(LIB_TARGETS) $(LDLIBS_{$projName})
   
{$projName}_DEBUG.so:	$(OBJS_{$projName}_DEBUG) $(LIB_TARGETS_DEBUG)
	$(LD) $(LDFLAGS_{$projName}) -o $@ $(OBJS_{$projName}_DEBUG) $(LIB_TARGETS_DEBUG) $(LDLIBS_{$projName})

Release/{$projName}/%.asm.o:	../../../../Engine/source/%.asm
	@mkdir -p $(dir $@)
	nasm -f elf $< -o $@

Release/{$projName}/%.o:	../../../../Engine/source/%
	@mkdir -p $(dir $@)
	$(CC) -c $(CFLAGS_{$projName}) $< -o $@

Release/{$projName}/%.o:	../../source/%
	@mkdir -p $(dir $@)
	$(CC) -c $(CFLAGS_{$projName}) $< -o $@

Debug/{$projName}/%.asm.o:	../../../../Engine/source/%.asm
	@mkdir -p $(dir $@)
	nasm -f elf $< -o $@

Debug/{$projName}/%.o:	../../../../Engine/source/%
	@mkdir -p $(dir $@)
	$(CC) -c $(CFLAGS_DEBUG_{$projName}) $< -o $@

Debug/{$projName}/%.o:	../../source/%
	@mkdir -p $(dir $@)
	$(CC) -c $(CFLAGS_DEBUG_{$projName}) $< -o $@

release_{$projName}: {$projName}.so
debug_{$projName}: {$projName}_DEBUG.so

.PHONY: debug_{$projName} release_{$projName}

DEPS += $(patsubst %.o,%.d,$(OBJS_{$projName}))
DEPS += $(patsubst %.o,%.d,$(OBJS_{$projName}_DEBUG))

