/*
 * Copyright (C) 2009, 2013 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#ifndef WebGLShader_h
#define WebGLShader_h

#include "WebGLSharedObject.h"

namespace WebCore {

class WebGLShader final : public WebGLSharedObject {
public:
    virtual ~WebGLShader();

    static Ref<WebGLShader> create(WebGLRenderingContextBase*, GC3Denum);

    GC3Denum getType() const { return m_type; }
    const String& getSource() const { return m_source; }

    void setSource(const String& source) { m_source = source; }

    bool isValid() const { return m_isValid; }
    void setValid(bool valid) { m_isValid = valid; }

private:
    WebGLShader(WebGLRenderingContextBase*, GC3Denum);

    void deleteObjectImpl(GraphicsContext3D*, Platform3DObject) override;

    bool isShader() const override { return true; }

    GC3Denum m_type;
    String m_source;
    bool m_isValid;
};

} // namespace WebCore

#endif // WebGLShader_h
