#ifndef _P80211_IMPL_H
#define _P80211_IMPL_H

/* Module init/cleanup */
extern int p80211_input_init(void);
extern void p80211_input_cleanup(void);

int p80211_output(struct wireless_info *, u16);

struct wireless_info *p80211_find_by_dev(struct net_device *);

static inline void wireless_get(struct wireless_info *p)
{
	atomic_inc(&p->refcnt);
}

extern void __p80211_destroy(struct wireless_info *);

static inline void wireless_put(struct wireless_info *p)
{
	if (atomic_dec_and_test(&p->refcnt))
		__p80211_destroy(p);
}

#endif /* !(_P80211_IMPL_H) */
