/*
 *	$Id: hp600_keyb.c,v 1.1 2000/06/10 21:45:30 yaegashi Exp $
 *	Copyright (C) 2000 YAEGASHI Takeshi
 *	HP600 keyboard scan routine and translate table
 */

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <asm/io.h>
#include "scan_keyb.h"

#define PCDR 0xa4000124
#define PDDR 0xa4000126
#define PEDR 0xa4000128
#define PFDR 0xa400012a
#define PGDR 0xa400012c
#define PHDR 0xa400012e

static const unsigned char hp690_japanese_table[]={
	0x00, 0x00, 0x00, 0x01, 0x00, 0x29, 0x70, 0x3a,
	0x3f, 0x3e, 0x40, 0x41, 0x42, 0x3d, 0x3c, 0x3b,

	0x00, 0x00, 0x00, 0x2c, 0x00, 0x1c, 0x28, 0x35,
	0x31, 0x30, 0x32, 0x33, 0x34, 0x2f, 0x2e, 0x2d,

	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x50,
	0x7b, 0x38, 0x00, 0x00, 0x4b, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xf9, 0x73, 0x53, 0x39, 0x00, 0x1d,

	0x00, 0x00, 0x00, 0x1e, 0x00, 0x2b, 0x1b, 0x27,
	0x23, 0x22, 0x24, 0x25, 0x26, 0x21, 0x20, 0x1f,

	0x00, 0x00, 0x00, 0x0f, 0x00, 0x36, 0x7d, 0x48,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x00,

	0x00, 0x00, 0x00, 0x10, 0x00, 0x0e, 0x1a, 0x19,
	0x15, 0x14, 0x16, 0x17, 0x18, 0x13, 0x12, 0x11,

	0x00, 0x00, 0x00, 0x02, 0x00, 0x0d, 0x0c, 0x0b,
	0x07, 0x06, 0x08, 0x09, 0x0a, 0x05, 0x04, 0x03,

	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};


static const unsigned char hp690_switch[]= {
	0xfd, 0xff,
	0xdf, 0xff,
	0x7f, 0xff,
	0xff, 0xfe,
	0xff, 0xfd,
	0xff, 0xf7,
	0xff, 0xbf,
	0xff, 0x7f,
};


static void hp690_japanese_scan_kbd(unsigned char *s)
{
	int i;
	unsigned const char *t=hp690_switch;

	for(i=0; i<9; i++) {
		ctrl_outb(*t++, PDDR);
		ctrl_outb(*t++, PEDR);
		*s++=ctrl_inb(PCDR);
		*s++=ctrl_inb(PFDR);
	}

	ctrl_outb(0xff, PDDR);
	ctrl_outb(0xff, PEDR);

	*s++=ctrl_inb(PGDR);
	*s++=ctrl_inb(PHDR);
}


void __init hp600_kbd_init_hw(void)
{
	scan_kbd_init();
	register_scan_keyboard(hp690_japanese_scan_kbd,
			       hp690_japanese_table, 18);
	printk(KERN_INFO "HP600 matrix scan keyboard registered\n");
}


/****************************************************************
HP Jornada 690(Japanese version) keyboard scan matrix

	PTC7	PTC6	PTC5	PTC4	PTC3	PTC2	PTC1	PTC0	
PTD1	REC			Escape	on/off	Han/Zen	Hira	Eisu	
PTD5	REC			Z	on/off	Enter	:	/	
PTD7	REC						Right	Down	
PTE0	REC			Windows	on/off				
PTE1	REC			A	on/off	]	[	;	
PTE3	REC			Tab	on/off	ShirtR	\	Up	
PTE6	REC			Q	on/off	BS	@	P	
PTE7	REC			1	on/off	^	-	0	


	PTF7	PTF6	PTF5	PTF4	PTF3	PTF2	PTF1	PTF0
PTD1	F5	F4	F6	F7	F8	F3	F2	F1	
PTD5	N	B	M	,	.	V	C	X	
PTD7	Muhen	Alt			Left				
PTE0			Henkan	_	Del	Space		Ctrl	
PTE1	H	G	J	K	L	F	D	S	
PTE3							ShiftL		
PTE6	Y	T	U	I	O	R	E	W	
PTE7	6	5	7	8	9	4	3	2	

	PTG5	PTG4	PTG3	PTG0	PTH0
*	REC	REW	FWW	Cover	on/off


		7	6	5	4	3	2	1	0
C: 0xffff 0xdf	IP	IP	IP	IP	IP	IP	IP	IP
D: 0x6786 0x59	O	I	O	IP	I	F	O	I
E: 0x5045 0x00	O	O	F	F	O	F	O	O
F: 0xffff 0xff	IP	IP	IP	IP	IP	IP	IP	IP
G: 0xaffe 0xfd	I	I	IP	IP	IP	IP	IP	I
H: 0x70f2 0x49	O	IP	F	F	IP	IP	F	I
J: 0x0704 0x22	F	F	O	IP	F	F	O	F
K: 0x0100 0x10	F	F	F	O	F	F	F	F
L: 0x0c3c 0x26	F	F	IP	F	F	IP	IP	F

****************************************************************/
