/* $XFree86$ */
/*
 * Register settings for SiS 300 series
 *
 * Copyright 2002, 2003 by Thomas Winischhofer, Vienna, Austria
 *
 * If distributed as part of the linux kernel, the contents of this file
 * is entirely covered by the GPL.
 *
 * Otherwise, the following terms apply:
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the copyright holder not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  The copyright holder makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: 	Thomas Winischhofer <thomas@winischhofer.net>
 *
 * Based on code by Silicon Intergrated Systems
 *
 */

typedef struct _SiS300_StStruct
{
	UCHAR St_ModeID;
	USHORT St_ModeFlag;
	UCHAR St_StTableIndex;
	UCHAR St_CRT2CRTC;
	UCHAR St_ResInfo;
	UCHAR VB_StTVFlickerIndex;
	UCHAR VB_StTVEdgeIndex;
	UCHAR VB_StTVYFilterIndex;
} SiS300_StStruct;

static const SiS300_StStruct  SiS300_SModeIDTable[] =
{
	{0x01,0x9208,0x01,0x00,0x00,0x00,0x00,0x00},
	{0x01,0x1210,0x14,0x01,0x01,0x00,0x00,0x00},
	{0x01,0x1010,0x17,0x02,0x02,0x00,0x00,0x00},
	{0x03,0x8208,0x03,0x00,0x00,0x00,0x00,0x00},
	{0x03,0x0210,0x16,0x01,0x01,0x00,0x00,0x00},
	{0x03,0x0010,0x18,0x02,0x02,0x00,0x00,0x00},
	{0x05,0x9209,0x05,0x00,0x00,0x00,0x00,0x00},
	{0x06,0x8209,0x06,0x00,0x00,0x00,0x00,0x00},
	{0x07,0x0000,0x07,0x03,0x03,0x00,0x00,0x00},
	{0x07,0x0000,0x19,0x02,0x02,0x00,0x00,0x00},
	{0x0d,0x920a,0x0d,0x00,0x00,0x00,0x00,0x00},
	{0x0e,0x820a,0x0e,0x00,0x00,0x00,0x00,0x00},
	{0x0f,0x0202,0x11,0x01,0x01,0x00,0x00,0x00},
	{0x10,0x0212,0x12,0x01,0x01,0x00,0x00,0x00},
	{0x11,0x0212,0x1a,0x04,0x04,0x00,0x00,0x00},
	{0x12,0x0212,0x1b,0x04,0x04,0x00,0x00,0x00},
	{0x13,0x021b,0x1c,0x00,0x00,0x00,0x00,0x00},
	{0x12,0x0010,0x18,0x02,0x02,0x00,0x00,0x00},
	{0x12,0x0210,0x18,0x01,0x01,0x00,0x00,0x00},
	{0xff,     0,   0,   0,   0,   0,   0,   0}
};

typedef struct _SiS300_ExtStruct
{
	UCHAR  Ext_ModeID;
	USHORT Ext_ModeFlag;
	USHORT Ext_ModeInfo;
	USHORT Ext_VESAID;
	UCHAR  Ext_RESINFO;
	UCHAR  VB_ExtTVFlickerIndex;
	UCHAR  VB_ExtTVEdgeIndex;
	UCHAR  VB_ExtTVYFilterIndex;
	UCHAR  REFindex;
} SiS300_ExtStruct;

static const SiS300_ExtStruct  SiS300_EModeIDTable[] =
{
	{0x6a,0x2212,0x0407,0x0102,SIS_RI_800x600,  0x00,0x00,0x00,0x00},  /* 800x600x? */
	{0x2e,0x0a1b,0x0306,0x0101,SIS_RI_640x480,  0x00,0x00,0x00,0x08},
	{0x2f,0x021b,0x0305,0x0100,SIS_RI_640x400,  0x00,0x00,0x00,0x10},  /* 640x400x8 */
	{0x30,0x2a1b,0x0407,0x0103,SIS_RI_800x600,  0x00,0x00,0x00,0x00},
	{0x31,0x0a1b,0x0a0d,0x0000,SIS_RI_720x480,  0x00,0x00,0x00,0x11},  /* 720x480x8 */
	{0x32,0x2a1b,0x0a0e,0x0000,SIS_RI_720x576,  0x00,0x00,0x00,0x12},  /* 720x576x8 */
	{0x33,0x0a1d,0x0a0d,0x0000,SIS_RI_720x480,  0x00,0x00,0x00,0x11},  /* 720x480x16 */
	{0x34,0x2a1d,0x0a0e,0x0000,SIS_RI_720x576,  0x00,0x00,0x00,0x12},  /* 720x576x16 */
	{0x35,0x0a1f,0x0a0d,0x0000,SIS_RI_720x480,  0x00,0x00,0x00,0x11},  /* 720x480x32 */
	{0x36,0x2a1f,0x0a0e,0x0000,SIS_RI_720x576,  0x00,0x00,0x00,0x12},  /* 720x576x32 */
	{0x37,0x0212,0x0508,0x0104,SIS_RI_1024x768, 0x00,0x00,0x00,0x13},  /* 1024x768x? */
	{0x38,0x0a1b,0x0508,0x0105,SIS_RI_1024x768, 0x00,0x00,0x00,0x13},  /* 1024x768x8 */
	{0x3a,0x0e3b,0x0609,0x0107,SIS_RI_1280x1024,0x00,0x00,0x00,0x1a},  /* 1280x1024x8 */
	{0x3c,0x063b,0x070a,0x0130,SIS_RI_1600x1200,0x00,0x00,0x00,0x1e},
	{0x3d,0x067d,0x070a,0x0131,SIS_RI_1600x1200,0x00,0x00,0x00,0x1e},
	{0x40,0x921c,0x0000,0x010d,SIS_RI_320x200,  0x00,0x00,0x00,0x23},  /* 320x200x15 */
	{0x41,0x921d,0x0000,0x010e,SIS_RI_320x200,  0x00,0x00,0x00,0x23},  /* 320x200x16 */
	{0x43,0x0a1c,0x0306,0x0110,SIS_RI_640x480,  0x00,0x00,0x00,0x08},
	{0x44,0x0a1d,0x0306,0x0111,SIS_RI_640x480,  0x00,0x00,0x00,0x08},
	{0x46,0x2a1c,0x0407,0x0113,SIS_RI_800x600,  0x00,0x00,0x00,0x00},  /* 800x600x15 */
	{0x47,0x2a1d,0x0407,0x0114,SIS_RI_800x600,  0x00,0x00,0x00,0x00},  /* 800x600x16 */
	{0x49,0x0a3c,0x0508,0x0116,SIS_RI_1024x768, 0x00,0x00,0x00,0x13},
	{0x4a,0x0a3d,0x0508,0x0117,SIS_RI_1024x768, 0x00,0x00,0x00,0x13},
	{0x4c,0x0e7c,0x0609,0x0119,SIS_RI_1280x1024,0x00,0x00,0x00,0x1a},
	{0x4d,0x0e7d,0x0609,0x011a,SIS_RI_1280x1024,0x00,0x00,0x00,0x1a},
	{0x50,0x921b,0x0001,0x0132,SIS_RI_320x240,  0x00,0x00,0x00,0x24},  /* 320x240x8  */
	{0x51,0xb21b,0x0103,0x0133,SIS_RI_400x300,  0x00,0x00,0x00,0x25},  /* 400x300x8  */
	{0x52,0x921b,0x0204,0x0134,SIS_RI_512x384,  0x00,0x00,0x00,0x26},  /* 512x384x8  */
	{0x56,0x921d,0x0001,0x0135,SIS_RI_320x240,  0x00,0x00,0x00,0x24},  /* 320x240x16 */
	{0x57,0xb21d,0x0103,0x0136,SIS_RI_400x300,  0x00,0x00,0x00,0x25},  /* 400x300x16 */
	{0x58,0x921d,0x0204,0x0137,SIS_RI_512x384,  0x00,0x00,0x00,0x26},  /* 512x384x16 */
	{0x59,0x921b,0x0000,0x0138,SIS_RI_320x200,  0x00,0x00,0x00,0x23},  /* 320x200x8  */
	{0x5c,0x921f,0x0204,0x0000,SIS_RI_512x384,  0x00,0x00,0x00,0x26},  /* 512x384x32 */
	{0x5d,0x021d,0x0305,0x0139,SIS_RI_640x400,  0x00,0x00,0x00,0x10},  /* 640x400x16 */
 	{0x5e,0x021f,0x0305,0x0000,SIS_RI_640x400,  0x00,0x00,0x00,0x10},  /* 640x400x32 */
	{0x62,0x0a3f,0x0306,0x013a,SIS_RI_640x480,  0x00,0x00,0x00,0x08},
	{0x63,0x2a3f,0x0407,0x013b,SIS_RI_800x600,  0x00,0x00,0x00,0x00},  /* 800x600x32 */
	{0x64,0x0a7f,0x0508,0x013c,SIS_RI_1024x768, 0x00,0x00,0x00,0x13},
	{0x65,0x0eff,0x0609,0x013d,SIS_RI_1280x1024,0x00,0x00,0x00,0x1a},
	{0x66,0x06ff,0x070a,0x013e,SIS_RI_1600x1200,0x00,0x00,0x00,0x1e},
	{0x68,0x067b,0x080b,0x013f,SIS_RI_1920x1440,0x00,0x00,0x00,0x27},
	{0x69,0x06fd,0x080b,0x0140,SIS_RI_1920x1440,0x00,0x00,0x00,0x27},
	{0x6b,0x07ff,0x080b,0x0000,SIS_RI_1920x1440,0x00,0x00,0x00,0x27},
	{0x6c,0x067b,0x090c,0x0000,SIS_RI_2048x1536,0x00,0x00,0x00,0x28},  /* 2048x1536x8 - not in BIOS! */
	{0x6d,0x06fd,0x090c,0x0000,SIS_RI_2048x1536,0x00,0x00,0x00,0x28},  /* 2048x1536x16 - not in BIOS! */
	{0x70,0x2a1b,0x0400,0x0000,SIS_RI_800x480,  0x00,0x00,0x07,0x2d},  /* 800x480x8 */
	{0x71,0x0a1b,0x0501,0x0000,SIS_RI_1024x576, 0x00,0x00,0x00,0x30},  /* 1024x576x8 */
	{0x74,0x0a1d,0x0501,0x0000,SIS_RI_1024x576, 0x00,0x00,0x00,0x30},  /* 1024x576x16 */
	{0x75,0x0e3d,0x0602,0x0000,SIS_RI_1280x720, 0x00,0x00,0x00,0x33},  /* 1280x720x16 */
	{0x76,0x2a1f,0x0400,0x0000,SIS_RI_800x480,  0x00,0x00,0x07,0x2d},  /* 800x480x32 */
	{0x77,0x0a3f,0x0501,0x0000,SIS_RI_1024x576, 0x00,0x00,0x00,0x30},  /* 1024x576x32 */
	{0x78,0x0eff,0x0602,0x0000,SIS_RI_1280x720, 0x00,0x00,0x00,0x33},  /* 1280x720x32 */
	{0x79,0x0e3b,0x0602,0x0000,SIS_RI_1280x720, 0x00,0x00,0x00,0x33},  /* 1280x720x8 */
	{0x7a,0x2a1d,0x0400,0x0000,SIS_RI_800x480,  0x00,0x00,0x07,0x2d},  /* 800x480x16 */
	{0x7c,0x0a3b,0x060f,0x0000,SIS_RI_1280x960, 0x00,0x00,0x00,0x29},  /* 1280x960x8 */
	{0x7d,0x0a7d,0x060f,0x0000,SIS_RI_1280x960, 0x00,0x00,0x00,0x29},  /* 1280x960x16 */
	{0x7e,0x0aff,0x060f,0x0000,SIS_RI_1280x960, 0x00,0x00,0x00,0x29},  /* 1280x960x32 */
	{0x20,0x0a1b,0x0504,0x0000,SIS_RI_1024x600, 0x00,0x00,0x00,0x2b},  /* 1024x600 */
	{0x21,0x0a3d,0x0504,0x0000,SIS_RI_1024x600, 0x00,0x00,0x00,0x2b},
	{0x22,0x0a7f,0x0504,0x0000,SIS_RI_1024x600, 0x00,0x00,0x00,0x2b},
	{0x23,0x0a1b,0x0c05,0x0000,SIS_RI_1152x768, 0x00,0x00,0x00,0x2c},  /* 1152x768 */
	{0x24,0x0a3d,0x0c05,0x0000,SIS_RI_1152x768, 0x00,0x00,0x00,0x2c},
	{0x25,0x0a7f,0x0c05,0x0000,SIS_RI_1152x768, 0x00,0x00,0x00,0x2c},
	{0x29,0x0e1b,0x0c05,0x0000,SIS_RI_1152x864, 0x00,0x00,0x00,0x36},  /* 1152x864 */
	{0x2a,0x0e3d,0x0c05,0x0000,SIS_RI_1152x864, 0x00,0x00,0x00,0x36},
	{0x2b,0x0e7f,0x0c05,0x0000,SIS_RI_1152x864, 0x00,0x00,0x00,0x36},
	{0x39,0x2a1b,0x0d06,0x0000,SIS_RI_848x480,  0x00,0x00,0x00,0x38},  /* 848x480 */
	{0x3b,0x2a3d,0x0d06,0x0000,SIS_RI_848x480,  0x00,0x00,0x00,0x38},
	{0x3e,0x2a7f,0x0d06,0x0000,SIS_RI_848x480,  0x00,0x00,0x00,0x38},
	{0x3f,0x2a1b,0x0d07,0x0000,SIS_RI_856x480,  0x00,0x00,0x00,0x3a},  /* 856x480 */
	{0x42,0x2a3d,0x0d07,0x0000,SIS_RI_856x480,  0x00,0x00,0x00,0x3a},
	{0x45,0x2a7f,0x0d07,0x0000,SIS_RI_856x480,  0x00,0x00,0x00,0x3a},
	{0x48,0x223b,0x0e08,0x0000,SIS_RI_1360x768, 0x00,0x00,0x00,0x3c},  /* 1360x768 */
	{0x4b,0x227d,0x0e08,0x0000,SIS_RI_1360x768, 0x00,0x00,0x00,0x3c},
	{0x4e,0x22ff,0x0e08,0x0000,SIS_RI_1360x768, 0x00,0x00,0x00,0x3c},
	{0x4f,0x921f,0x0000,0x0000,SIS_RI_320x200,  0x00,0x00,0x00,0x23},  /* 320x200x32 */
	{0x53,0x921f,0x0001,0x0000,SIS_RI_320x240,  0x00,0x00,0x00,0x24},  /* 320x240x32 */
	{0x54,0xb21f,0x0103,0x0000,SIS_RI_400x300,  0x00,0x00,0x00,0x25},  /* 400x300x32 */
	{0x55,0x2e3b,0x0609,0x0000,SIS_RI_1280x768, 0x00,0x00,0x00,0x3d},  /* 1280x768   */
	{0x5a,0x2e7d,0x0609,0x0000,SIS_RI_1280x768, 0x00,0x00,0x00,0x3d},
	{0x5b,0x2eff,0x0609,0x0000,SIS_RI_1280x768, 0x00,0x00,0x00,0x3d},
	{0x5f,0x2a1b,0x0f0e,0x0000,SIS_RI_768x576,  0x00,0x00,0x00,0x3e},  /* 768x576x8 */
	{0x60,0x2a1d,0x0f0e,0x0000,SIS_RI_768x576,  0x00,0x00,0x00,0x3e},  /* 768x576x16 */
	{0x61,0x2a1f,0x0f0e,0x0000,SIS_RI_768x576,  0x00,0x00,0x00,0x3e},  /* 768x576x32 */
	{0x67,0x2e3b,0x0e08,0x0000,SIS_RI_1360x1024,0x00,0x00,0x00,0x3f},  /* 1360x1024x8 (BARCO) */
	{0x6f,0x2e7d,0x0e08,0x0000,SIS_RI_1360x1024,0x00,0x00,0x00,0x3f},  /* 1360x1024x16 (BARCO) */
	{0x72,0x2eff,0x0e08,0x0000,SIS_RI_1360x1024,0x00,0x00,0x00,0x3f},  /* 1360x1024x32 (BARCO) */
	{0xff,0x0000,0x0000,0xffff,0x00,            0x00,0x00,0x00,0x00}
};

typedef struct _SiS300_Ext2Struct
{
	USHORT Ext_InfoFlag;
	UCHAR Ext_CRT1CRTC;  /* TW: Index in SiS300_CRT1Table */
	UCHAR Ext_CRTVCLK;   /* TW: Index in VCLK array */
	UCHAR Ext_CRT2CRTC;  /* TW: Index in LCD Paneltype arrays (&3f) */
	UCHAR  ModeID;
	USHORT XRes;
	USHORT YRes;
} SiS300_Ext2Struct;

static const SiS300_Ext2Struct  SiS300_RefIndex[] =
{ /* TW: Don't ever insert anything here, table is indexed */
	{0x085f,0x0d,0x03,0x05,0x6a, 800, 600}, /* 00 */
	{0x0467,0x0e,0x44,0x05,0x6a, 800, 600}, /* 01 */
	{0x0067,0x0f,0x07,0x48,0x6a, 800, 600}, /* 02 - CRT1CRTC was 0x4f */
	{0x0067,0x10,0x06,0x8b,0x6a, 800, 600}, /* 03 */
	{0x0147,0x11,0x08,0x00,0x6a, 800, 600}, /* 04 */
	{0x0147,0x12,0x0c,0x00,0x6a, 800, 600}, /* 05 */
	{0x0047,0x11,0x4e,0x00,0x6a, 800, 600}, /* 06 - CRT1CRTC was 0x51 */
	{0x0047,0x11,0x13,0x00,0x6a, 800, 600}, /* 07 */
	{0xc85f,0x05,0x00,0x04,0x2e, 640, 480}, /* 08 */
	{0xc067,0x06,0x02,0x04,0x2e, 640, 480}, /* 09 */
	{0xc067,0x07,0x02,0x47,0x2e, 640, 480}, /* 0a */
	{0xc067,0x08,0x03,0x8a,0x2e, 640, 480}, /* 0b */
	{0xc047,0x09,0x05,0x00,0x2e, 640, 480}, /* 0c */
	{0xc047,0x0a,0x08,0x00,0x2e, 640, 480}, /* 0d */
	{0xc047,0x0b,0x0a,0x00,0x2e, 640, 480}, /* 0e */
	{0xc047,0x0c,0x10,0x00,0x2e, 640, 480}, /* 0f */
	{0x487f,0x04,0x00,0x00,0x2f, 640, 400}, /* 10 */
	{0xc00f,0x31,0x01,0x06,0x31, 720, 480}, /* 11 */
	{0x000f,0x32,0x03,0x06,0x32, 720, 576}, /* 12 */
	{0x0187,0x15,0x05,0x00,0x37,1024, 768}, /* 13 */
        {0xc877,0x16,0x09,0x06,0x37,1024, 768}, /* 14 */
	{0xc067,0x17,0x0b,0x49,0x37,1024, 768}, /* 15 - CRT1CRTC was 0x97 */
	{0x0267,0x18,0x0d,0x00,0x37,1024, 768}, /* 16 */
	{0x0047,0x19,0x11,0x8c,0x37,1024, 768}, /* 17 - CRT1CRTC was 0x59 */
	{0x0047,0x1a,0x52,0x00,0x37,1024, 768}, /* 18 */
	{0x0007,0x1b,0x16,0x00,0x37,1024, 768}, /* 19 - CRT1CRTC was 0x5b */
	{0x0387,0x1c,0x4d,0x00,0x3a,1280,1024}, /* 1a - CRT1CRTC was 0x5c */
	{0x0077,0x1d,0x14,0x07,0x3a,1280,1024}, /* 1b */
	{0x0047,0x1e,0x17,0x00,0x3a,1280,1024}, /* 1c */
	{0x0007,0x1f,0x98,0x00,0x3a,1280,1024}, /* 1d */
	{0x0007,0x20,0x59,0x00,0x3c,1600,1200}, /* 1e - CRT1CRTC was 0x60 */
	{0x0007,0x21,0x5a,0x00,0x3c,1600,1200}, /* 1f */
	{0x0007,0x22,0x1b,0x00,0x3c,1600,1200}, /* 20 */
	{0x0007,0x23,0x1d,0x00,0x3c,1600,1200}, /* 21 - CRT1CRTC was 0x63 */
	{0x0007,0x24,0x1e,0x00,0x3c,1600,1200}, /* 22 */
	{0x407f,0x00,0x00,0x00,0x40, 320, 200}, /* 23 */
	{0xc07f,0x01,0x00,0x04,0x50, 320, 240}, /* 24 */
	{0x0077,0x02,0x04,0x05,0x51, 400, 300}, /* 25 */
	{0xc877,0x03,0x09,0x06,0x52, 512, 384}, /* 26 */  /* was c077 */
	{0x8207,0x25,0x1f,0x00,0x68,1920,1440}, /* 27 */
	{0x0007,0x26,0x20,0x00,0x6c,2048,1536}, /* 28 */
	{0x0067,0x27,0x14,0x08,0x6e,1280, 960}, /* 29 - TW: 1280x960-60 */
	{0x0027,0x45,0x3c,0x08,0x6e,1280, 960}, /* 2a - TW: 1280x960-85 */
	{0xc077,0x33,0x09,0x06,0x20,1024, 600}, /* 2b */
	{0xc077,0x34,0x0b,0x06,0x23,1152, 768}, /* 2c */	/* VCLK 0x09 */
	{0x0057,0x35,0x27,0x08,0x70, 800, 480}, /* 2d */
	{0x0047,0x36,0x37,0x08,0x70, 800, 480}, /* 2e */
	{0x0047,0x37,0x08,0x08,0x70, 800, 480}, /* 2f */
	{0x0057,0x38,0x09,0x09,0x71,1024, 576}, /* 30 */
	{0x0047,0x39,0x38,0x09,0x71,1024, 576}, /* 31 */
	{0x0047,0x3a,0x11,0x09,0x71,1024, 576}, /* 32 */
	{0x0057,0x3b,0x39,0x0a,0x75,1280, 720}, /* 33 */
	{0x0047,0x3c,0x3a,0x0a,0x75,1280, 720}, /* 34 */
	{0x0007,0x3d,0x3b,0x0a,0x75,1280, 720}, /* 35 */
	{0x0047,0x3e,0x34,0x06,0x29,1152, 864}, /* 36 1152x864-75Hz */
	{0x0047,0x44,0x3a,0x06,0x29,1152, 864}, /* 37 1152x864-85Hz */
	{0x00c7,0x3f,0x28,0x00,0x39, 848, 480}, /* 38 848x480-38Hzi */
	{0xc067,0x40,0x3d,0x0b,0x39, 848, 480}, /* 39 848x480-60Hz  */
	{0x00c7,0x41,0x28,0x00,0x3f, 856, 480}, /* 3a 856x480-38Hzi */
	{0xc047,0x42,0x28,0x00,0x3f, 856, 480}, /* 3b 856x480-60Hz  */
	{0x0067,0x43,0x3e,0x0c,0x48,1360, 768}, /* 3c 1360x768-60Hz */
	{0x0077,0x46,0x3f,0x08,0x55,1280, 768}, /* 3d 1280x768-60Hz */
	{0x000f,0x47,0x03,0x06,0x5f, 768, 576}, /* 3e 768x576 */
	{0x0027,0x48,0x13,0x08,0x67,1360,1024}, /* 3f 1360x1024-59Hz (BARCO1366 only) */
	{0xffff,   0,   0,   0,   0,   0,   0}
};

typedef struct _SiS_VBModeIDTableStruct
{
	UCHAR  ModeID;
	UCHAR  VB_TVDelayIndex;
	UCHAR  VB_TVFlickerIndex;
	UCHAR  VB_TVPhaseIndex;
	UCHAR  VB_TVYFilterIndex;
	UCHAR  VB_LCDDelayIndex;
	UCHAR  _VB_LCDHIndex;
	UCHAR  _VB_LCDVIndex;
}SiS_VBModeIDTableStruct;

static const SiS_VBModeIDTableStruct  SiS300_VBModeIDTable[] =
{
	{0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01},
	{0x01,0x00,0x00,0x00,0x01,0x00,0x01,0x02},
	{0x03,0x00,0x00,0x00,0x02,0x00,0x02,0x00},
	{0x03,0x00,0x00,0x00,0x02,0x00,0x02,0x01},
	{0x03,0x00,0x00,0x00,0x03,0x00,0x03,0x02},
	{0x05,0x00,0x00,0x01,0x04,0x00,0x00,0x00},
	{0x06,0x00,0x00,0x01,0x05,0x00,0x02,0x00},
	{0x07,0x00,0x00,0x00,0x03,0x00,0x03,0x01},
	{0x07,0x00,0x00,0x00,0x03,0x00,0x03,0x02},
	{0x0d,0x00,0x00,0x01,0x04,0x00,0x00,0x00},
	{0x0e,0x00,0x00,0x01,0x05,0x00,0x02,0x00},
	{0x0f,0x00,0x00,0x01,0x05,0x00,0x02,0x01},
	{0x10,0x00,0x00,0x01,0x05,0x00,0x02,0x01},
	{0x11,0x00,0x00,0x01,0x05,0x00,0x02,0x03},
	{0x12,0x00,0x00,0x01,0x05,0x00,0x02,0x03},
	{0x13,0x00,0x00,0x01,0x04,0x00,0x04,0x00},
	{0x6a,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x2e,0x00,0x00,0x01,0x05,0x00,0x06,0x08},
	{0x2f,0x00,0x00,0x01,0x05,0x00,0x06,0x06},
	{0x30,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x31,0x00,0x00,0x01,0x06,0x00,0x00,0x00},
	{0x32,0x00,0x00,0x01,0x06,0x00,0x00,0x00},
	{0x37,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x38,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x3a,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x40,0x00,0x00,0x01,0x04,0x00,0x05,0x05},
	{0x41,0x00,0x00,0x01,0x04,0x00,0x05,0x05},
	{0x43,0x00,0x00,0x01,0x05,0x00,0x06,0x08},
	{0x44,0x00,0x00,0x01,0x05,0x00,0x06,0x08},
	{0x46,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x47,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x49,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x4a,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x4c,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x4d,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x50,0x00,0x00,0x01,0x04,0x00,0x05,0x07},
	{0x51,0x00,0x00,0x01,0x07,0x00,0x07,0x09},
	{0x52,0x00,0x00,0x01,0x00,0x00,0x09,0x0b},
	{0x56,0x00,0x00,0x01,0x04,0x00,0x05,0x07},
	{0x57,0x00,0x00,0x01,0x07,0x00,0x07,0x09},
	{0x58,0x00,0x00,0x01,0x00,0x00,0x09,0x0b},
	{0x59,0x00,0x00,0x01,0x04,0x00,0x05,0x05},
	{0x5d,0x00,0x00,0x01,0x07,0x00,0x06,0x06},
	{0x62,0x00,0x00,0x01,0x05,0x00,0x06,0x08},
	{0x63,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x64,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x65,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x6e,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x6f,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x7b,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};

typedef struct _SiS300_CRT1TableStruct
{
	UCHAR CR[17];
} SiS300_CRT1TableStruct;

static const SiS300_CRT1TableStruct  SiS300_CRT1Table[] =
{
#if 1
 {{0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,    /* 0x00 - 320x200 */
  0x9c,0x8e,0x8f,0x96,0xb9,0x30,0x00,0x00,     /* HRE [4],[15] is invalid - but correcting it does not work */
  0x00}},
#endif
#if 0
 {{0x2d,0x27,0x27,0x91,0x2c,0x92,0xbf,0x1f,    /* 0x00 - corrected 320x200-72 - does not work */
  0x9c,0x8e,0x8f,0x96,0xb9,0x30,0x00,0x04,
  0x00}},
#endif
 {{0x2d,0x27,0x28,0x90,0x2c,0x80,0x0b,0x3e,    /* 0x01 */
  0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x00,     /* HRE [4],[15] is invalid - but correcting it does not work */
  0x00}},
#if 0
 {{0x2d,0x27,0x27,0x91,0x2c,0x92,0x0b,0x3e,    /* 0x01 - corrected 320x240-60 - does not work */
  0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x04,
  0x00}},
#endif
 {{0x3d,0x31,0x31,0x81,0x37,0x1f,0x72,0xf0,    /* 0x02 */
  0x58,0x8c,0x57,0x57,0x73,0x20,0x00,0x05,
  0x01}},
#if 0
 {{0x3d,0x31,0x31,0x81,0x37,0x1f,0x72,0xf0,    /* 0x02 - corrected 400x300-60 */
  0x58,0x8c,0x57,0x57,0x73,0x20,0x00,0x05,
  0x01}},
#endif  
 {{0x4f,0x3f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
  0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x01,
  0x01}},
 {{0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
  0x9c,0x8e,0x8f,0x96,0xb9,0x30,0x00,0x05,
  0x00}},
#if 0  
 {{0x5f,0x4f,0x50,0x82,0x55,0x81,0x0b,0x3e,    /* 0x05 */
  0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x05,
  0x00}},
#endif
 {{0x5f,0x4f,0x4f,0x83,0x55,0x81,0x0b,0x3e,    /* 0x05 - corrected 640x480-60 */
  0xe9,0x8b,0xdf,0xe8,0x0c,0x00,0x00,0x05,
  0x00}},
#if 0  
 {{0x63,0x4f,0x50,0x86,0x56,0x9b,0x06,0x3e,    /* 0x06 */
  0xe8,0x8b,0xdf,0xe7,0xff,0x10,0x00,0x01,
  0x00}},
#endif  
 {{0x63,0x4f,0x4f,0x87,0x56,0x9b,0x06,0x3e,    /* 0x06 - corrected 640x480-72 */
  0xe8,0x8a,0xdf,0xe7,0x07,0x00,0x00,0x01,
  0x00}},
 {{0x64,0x4f,0x4f,0x88,0x55,0x9d,0xf2,0x1f,
  0xe0,0x83,0xdf,0xdf,0xf3,0x10,0x00,0x01,
  0x00}},
 {{0x63,0x4f,0x4f,0x87,0x5a,0x81,0xfb,0x1f,
  0xe0,0x83,0xdf,0xdf,0xfc,0x10,0x00,0x05,
  0x00}},
#if 0  
 {{0x66,0x4f,0x4f,0x86,0x56,0x9e,0x03,0x3e,    /* 0x09 */
  0xe4,0x87,0xdf,0xdf,0x04,0x00,0x00,0x01,
  0x00}},
#endif
 {{0x67,0x4f,0x4f,0x8b,0x57,0x83,0x10,0x3e,    /* 0x09 - corrected 640x480-100 */
  0xe7,0x8d,0xdf,0xe6,0x11,0x00,0x00,0x05,
  0x00}},
#if 0  
 {{0x6c,0x4f,0x4f,0x83,0x59,0x9e,0x00,0x3e,    /* 0x0a */
  0xe5,0x8d,0xdf,0xdf,0x01,0x00,0x00,0x01,
  0x00}},
#endif    
 {{0x67,0x4f,0x4f,0x8b,0x57,0x83,0x10,0x3e,    /* 0x0a - corrected 640x480-120 */
  0xe7,0x8d,0xdf,0xe6,0x11,0x00,0x00,0x05,
  0x00}},
 {{0x63,0x4f,0x4f,0x87,0x56,0x9d,0xfb,0x1f,
  0xe0,0x83,0xdf,0xdf,0xfc,0x10,0x00,0x01,
  0x00}},
 {{0x65,0x4f,0x4f,0x89,0x57,0x9f,0xfb,0x1f,
  0xe6,0x8a,0xdf,0xdf,0xfc,0x10,0x00,0x01,    /* TW: Corrected VDE, VBE */
  0x00}},
 {{0x7b,0x63,0x63,0x9f,0x6a,0x93,0x6f,0xf0,
  0x58,0x8a,0x57,0x57,0x70,0x20,0x00,0x05,
  0x01}},
 {{0x7f,0x63,0x63,0x83,0x6c,0x1c,0x72,0xf0,
  0x58,0x8c,0x57,0x57,0x73,0x20,0x00,0x06,
  0x01}},
 {{0x7d,0x63,0x63,0x81,0x6e,0x1d,0x98,0xf0,
  0x7c,0x82,0x57,0x57,0x99,0x00,0x00,0x06,
  0x01}},
 {{0x7f,0x63,0x63,0x83,0x69,0x13,0x6f,0xf0,
  0x58,0x8b,0x57,0x57,0x70,0x20,0x00,0x06,
  0x01}},
 {{0x7e,0x63,0x63,0x82,0x6b,0x13,0x75,0xf0,
  0x58,0x8b,0x57,0x57,0x76,0x20,0x00,0x06,
  0x01}},
 {{0x8c,0x63,0x63,0x87,0x72,0x16,0x7e,0xf0,
  0x59,0x8d,0x57,0x57,0x7f,0x00,0x00,0x06,
  0x01}},
 {{0x7e,0x63,0x63,0x82,0x6c,0x14,0x75,0xe0,
  0x58,0x0b,0x57,0x57,0x76,0x20,0x00,0x06,
  0x01}},
 {{0x7e,0x63,0x63,0x82,0x6c,0x14,0x75,0xe0,   /* 0x14 */
  0x58,0x0b,0x57,0x57,0x76,0x20,0x00,0x06,
  0x01}},
 {{0x99,0x7f,0x7f,0x9d,0x84,0x1a,0x96,0x1f,
  0x7f,0x83,0x7f,0x7f,0x97,0x10,0x00,0x02,
  0x00}},
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
  0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
  0x01}},
 {{0xa1,0x7f,0x7f,0x85,0x86,0x97,0x24,0xf5,
  0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
  0x01}},
 {{0x9f,0x7f,0x7f,0x83,0x85,0x91,0x1e,0xf5,
  0x00,0x83,0xff,0xff,0x1f,0x10,0x00,0x02,
  0x01}},
 {{0xa7,0x7f,0x7f,0x8b,0x89,0x95,0x26,0xf5,
  0x00,0x83,0xff,0xff,0x27,0x10,0x00,0x02,
  0x01}},
 {{0x9f,0x7f,0x7f,0x83,0x83,0x93,0x1e,0xf5,  /* 0x1a */
  0x00,0x84,0xff,0xff,0x1f,0x10,0x00,0x02,
  0x01}},
 {{0xa2,0x7f,0x7f,0x86,0x84,0x94,0x37,0xf5,
  0x0b,0x82,0xff,0xff,0x38,0x10,0x00,0x02,
  0x01}},
 {{0xcf,0x9f,0x9f,0x93,0xb2,0x01,0x14,0xba,
  0x00,0x83,0xff,0xff,0x15,0x00,0x00,0x03,
  0x00}},
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x28,0x5a,
  0x00,0x83,0xff,0xff,0x29,0x09,0x00,0x07,
  0x01}},
 {{0xce,0x9f,0x9f,0x92,0xa5,0x17,0x28,0x5a,  /* 0x1e */
  0x00,0x83,0xff,0xff,0x29,0x09,0x00,0x07,
  0x01}},
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0x2e,0x5a,
  0x00,0x83,0xff,0xff,0x2f,0x09,0x00,0x07,
  0x01}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,  /* 36: 1600x1200x85Hz */
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x3f,0xef,0xef,0x83,0xfd,0x1a,0xda,0x1f,  /* 37: 1920x1440x60Hz */
  0xa0,0x84,0x9f,0x9f,0xdb,0x1f,0x01,0x01,
  0x00}},
 {{0x55,0xff,0xff,0x99,0x0d,0x0c,0x3e,0xba,
  0x00,0x84,0xff,0xff,0x3f,0x0f,0x41,0x05,
  0x00}},
#if 0  
 {{0xdc,0x9f,0x9f,0x00,0xab,0x19,0xe6,0xef,  /* 0x27: 1280x960-70 - invalid! */
  0xc0,0xc3,0xbf,0xbf,0xe7,0x10,0x00,0x07,
  0x01}},
#endif  
 {{0xdc,0x9f,0x9f,0x80,0xaf,0x9d,0xe6,0xff,  /* 0x27: 1280x960-60 - correct */
  0xc0,0x83,0xbf,0xbf,0xe7,0x10,0x00,0x07,
  0x01}},
 {{0x7f,0x63,0x63,0x83,0x6c,0x1c,0x72,0xba,  /* 0x28 */
  0x27,0x8b,0xdf,0xdf,0x73,0x00,0x00,0x06,
  0x01}},
 {{0x7f,0x63,0x63,0x83,0x69,0x13,0x6f,0xba,
  0x26,0x89,0xdf,0xdf,0x6f,0x00,0x00,0x06,
  0x01}},
 {{0x7f,0x63,0x63,0x82,0x6b,0x13,0x75,0xba,
  0x29,0x8c,0xdf,0xdf,0x75,0x00,0x00,0x06,
  0x01}},
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf1,
  0xaf,0x85,0x3f,0x3f,0x25,0x30,0x00,0x02,
  0x01}},
 {{0x9f,0x7f,0x7f,0x83,0x85,0x91,0x1e,0xf1,
  0xad,0x81,0x3f,0x3f,0x1f,0x30,0x00,0x02,
  0x01}},
 {{0xa7,0x7f,0x7f,0x88,0x89,0x15,0x26,0xf1,
  0xb1,0x85,0x3f,0x3f,0x27,0x30,0x00,0x02,
  0x01}},
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x28,0xc4,
  0x7a,0x8e,0xcf,0xcf,0x29,0x21,0x00,0x07,
  0x01}},
 {{0xce,0x9f,0x9f,0x92,0xa5,0x17,0x28,0xd4,
  0x7a,0x8e,0xcf,0xcf,0x29,0x21,0x00,0x07,
  0x01}},
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0x2e,0xd4,
  0x7d,0x81,0xcf,0xcf,0x2f,0x21,0x00,0x07,
  0x01}},
 {{0x6b,0x59,0x59,0x8f,0x5e,0x8c,0x0b,0x3e,
  0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x05,
  0x00}},
 {{0x7b,0x59,0x63,0x9f,0x6a,0x93,0x6f,0xf0,  /* 0x32 */
  0x58,0x8a,0x3f,0x57,0x70,0x20,0x00,0x05,
  0x01}},
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x1e,0xf1,  /* 0x33 - 1024x600 */
  0xae,0x85,0x57,0x57,0x1f,0x30,0x00,0x02,
  0x01}},
 {{0xa3,0x8f,0x8f,0x97,0x96,0x97,0x24,0xf5,  /* 0x34 - 1152x768 - corrected */
  0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
  0x01}},
 {{0x7f,0x63,0x63,0x83,0x6c,0x1c,0x72,0xba,  /* 0x35 */
   0x27,0x8b,0xdf,0xdf,0x73,0x00,0x00,0x06,
   0x01}}, /* 0x35 */
 {{0x7f,0x63,0x63,0x83,0x69,0x13,0x6f,0xba,
   0x26,0x89,0xdf,0xdf,0x6f,0x00,0x00,0x06,
   0x01}}, /* 0x36 */
 {{0x7f,0x63,0x63,0x82,0x6b,0x13,0x75,0xba,
   0x29,0x8c,0xdf,0xdf,0x75,0x00,0x00,0x06,
   0x01}}, /* 0x37 */
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf1,
   0xaf,0x85,0x3f,0x3f,0x25,0x30,0x00,0x02,
   0x01}}, /* 0x38 */
 {{0x9f,0x7f,0x7f,0x83,0x85,0x91,0x1e,0xf1,
   0xad,0x81,0x3f,0x3f,0x1f,0x30,0x00,0x02,
   0x01}}, /* 0x39 */
 {{0xa7,0x7f,0x7f,0x88,0x89,0x95,0x26,0xf1,  /* 95 was 15 - illegal HBE! */
   0xb1,0x85,0x3f,0x3f,0x27,0x30,0x00,0x02,
   0x01}}, /* 0x3a */
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x28,0xc4,
   0x7a,0x8e,0xcf,0xcf,0x29,0x21,0x00,0x07,
   0x01}}, /* 0x3b */
 {{0xce,0x9f,0x9f,0x92,0xa5,0x17,0x28,0xd4,
   0x7a,0x8e,0xcf,0xcf,0x29,0x21,0x00,0x07,
   0x01}}, /* 0x3c */
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0x2e,0xd4,
   0x7d,0x81,0xcf,0xcf,0x2f,0x21,0x00,0x07,
   0x01}}, /* 0x3d */
 {{0xc3,0x8f,0x8f,0x87,0x9b,0x0b,0x82,0xef,  /* 1152x864-75 */
   0x60,0x83,0x5f,0x5f,0x83,0x10,0x00,0x07,
   0x01}},  /* 0x3e */
 {{0x86,0x69,0x69,0x8A,0x74,0x06,0x8C,0x15,  /* 848x480-38i */
   0x4F,0x83,0xEF,0xEF,0x8D,0x30,0x00,0x02,
   0x00}}, /* 0x3f */
 {{0x83,0x69,0x69,0x87,0x6f,0x1d,0x03,0x3E,  /* 848x480-60  */
   0xE5,0x8d,0xDF,0xe4,0x04,0x00,0x00,0x06,
   0x00}}, /* 0x40 */
 {{0x86,0x6A,0x6A,0x8A,0x74,0x06,0x8C,0x15,  /* 856x480-38i */
   0x4F,0x83,0xEF,0xEF,0x8D,0x30,0x00,0x02,
   0x00}}, /* 0x41 */
 {{0x81,0x6A,0x6A,0x85,0x70,0x00,0x0F,0x3E,  /* 856x480-60  */
   0xEB,0x8E,0xDF,0xDF,0x10,0x00,0x00,0x02,
   0x00}}, /* 0x42 */
 {{0xdd,0xa9,0xa9,0x81,0xb4,0x97,0x26,0xfd,  /* 1360x768-60 */
   0x01,0x8d,0xff,0x00,0x27,0x10,0x00,0x03,
   0x01}}, /* 0x43 */
 {{0xd9,0x8f,0x8f,0x9d,0xba,0x0a,0x8a,0xff,  /* 1152x864-84 */
   0x60,0x8b,0x5f,0x5f,0x8b,0x10,0x00,0x03,
   0x01}}, /* 0x44 */
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0xf1,0xff,  /* 1280x960-85 */
   0xc0,0x83,0xbf,0xbf,0xf2,0x10,0x00,0x07,
   0x01}}, /* 0x45 */
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x20,0xf5,  /* 1280x768-60 */
   0x03,0x88,0xff,0xff,0x21,0x10,0x00,0x07,
   0x01}},  /* 0x46 */
 {{0x7b,0x5f,0x63,0x9f,0x6a,0x93,0x6f,0xf0,  /* 768x576 */
   0x58,0x8a,0x3f,0x57,0x70,0x20,0x00,0x05,
   0x01}},  /* 0x47 */
 {{0xce,0xa9,0xa9,0x92,0xb1,0x07,0x28,0x52,  /* 1360x1024 (Barco iQ Pro R300) */
   0x02,0x8e,0xff,0x00,0x29,0x0d,0x00,0x03,
   0x00}}   /* 0x48 */
};

typedef struct _SiS300_MCLKDataStruct
{
	UCHAR SR28,SR29,SR2A;
	USHORT CLOCK;
} SiS300_MCLKDataStruct;

static const SiS300_MCLKDataStruct  SiS300_MCLKData_630[] =
{
	{ 0x5a,0x64,0x80, 66},
	{ 0xb3,0x45,0x80, 83},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x22,0x80,133},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100}
};

static const SiS300_MCLKDataStruct  SiS300_MCLKData_300[] =
{
	{ 0x68,0x43,0x80,125},
	{ 0x68,0x43,0x80,125},
	{ 0x68,0x43,0x80,125},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100}
};

#ifdef LINUXBIOS
typedef struct _SiS300_ECLKDataStruct
{
	UCHAR SR2E,SR2F,SR30;
	USHORT CLOCK;
} SiS300_ECLKDataStruct;

static const SiS300_ECLKDataStruct  SiS300_ECLKData[] =
{
	{ 0x54,0x43,0x80,100},
	{ 0x53,0x43,0x80,100},
	{ 0x55,0x43,0x80,100},
	{ 0x52,0x43,0x80,100},
	{ 0x3f,0x42,0x80,100},
	{ 0x54,0x43,0x80,100},
	{ 0x54,0x43,0x80,100},
	{ 0x54,0x43,0x80,100}
};
#endif

typedef struct _SiS300_VCLKDataStruct
{
	UCHAR SR2B,SR2C;
	USHORT CLOCK;
} SiS300_VCLKDataStruct;

static const SiS300_VCLKDataStruct  SiS300_VCLKData[] =
{
	{ 0x1b,0xe1, 25}, /* 0x00 */
	{ 0x4e,0xe4, 28}, /* 0x01 */
	{ 0x57,0xe4, 32}, /* 0x02 */
	{ 0xc3,0xc8, 36}, /* 0x03 */
	{ 0x42,0xc3, 40}, /* 0x04 */
	{ 0x5d,0xc4, 45}, /* 0x05 */
	{ 0x52,0x65, 50}, /* 0x06 */
	{ 0x53,0x65, 50}, /* 0x07 */
	{ 0x6d,0x66, 56}, /* 0x08 */
	{ 0x5a,0x64, 65}, /* 0x09 */
	{ 0x46,0x44, 68}, /* 0x0a */
	{ 0x3e,0x43, 75}, /* 0x0b */
	{ 0x6d,0x46, 76}, /* 0x0c */  /* 800x600 | LVDS_2(CH), MITAC(CH);  - 730, A901(301B): 0xb1,0x46, 76 */
	{ 0x41,0x43, 79}, /* 0x0d */
	{ 0x31,0x42, 79}, /* 0x0e */
	{ 0x46,0x25, 85}, /* 0x0f */
	{ 0x78,0x29, 87}, /* 0x10 */
	{ 0x62,0x44, 95}, /* 0x11 */
	{ 0x2b,0x22,105}, /* 0x12 */
	{ 0x49,0x24,106}, /* 0x13 */
	{ 0xc3,0x28,108}, /* 0x14 */
	{ 0x3c,0x23,109}, /* 0x15 */
	{ 0xf7,0x2c,132}, /* 0x16 */
	{ 0xd4,0x28,136}, /* 0x17 */
	{ 0x41,0x05,158}, /* 0x18 */
	{ 0x43,0x05,162}, /* 0x19 */
	{ 0xe1,0x0f,175}, /* 0x1a */
	{ 0xfc,0x12,189}, /* 0x1b */
	{ 0xde,0x26,194}, /* 0x1c */
	{ 0x54,0x05,203}, /* 0x1d */
	{ 0x3f,0x03,230}, /* 0x1e */
	{ 0x30,0x02,234}, /* 0x1f */
	{ 0x24,0x01,266}, /* 0x20 */
	{ 0x52,0x2a, 54}, /* 0x21 */  /* 301 TV */
	{ 0x52,0x6a, 27}, /* 0x22 */  /* 301 TV */
	{ 0x62,0x24, 70}, /* 0x23 */  /* 301 TV */
	{ 0x62,0x64, 70}, /* 0x24 */  /* 301 TV */
	{ 0xa8,0x4c, 30}, /* 0x25 */  /* 301 TV */
	{ 0x20,0x26, 33}, /* 0x26 */  /* 301 TV */
	{ 0x31,0xc2, 39}, /* 0x27 */
	{ 0xbf,0xc8, 35}, /* 0x28 */  /* 856x480 */
	{ 0x60,0x36, 30}, /* 0x29 */  /* CH/UNTSC TEXT | LVDS_2(CH) - 730, A901(301B), Mitac(CH): 0xe0, 0xb6, 30 */
	{ 0x40,0x4a, 28}, /* 0x2a */  /* CH-TV */
	{ 0x9f,0x46, 44}, /* 0x2b */  /* CH-TV */
	{ 0x97,0x2c, 26}, /* 0x2c */  /* CH-TV */
	{ 0x44,0xe4, 25}, /* 0x2d */  /* CH-TV */
	{ 0x7e,0x32, 47}, /* 0x2e */  /* CH-TV */
	{ 0x8a,0x24, 31}, /* 0x2f */  /* CH/PAL TEXT | LVDS_2(CH), Mitac(CH) -  730, A901(301B): 0x57, 0xe4, 31 */
	{ 0x97,0x2c, 26}, /* 0x30 */  /* CH-TV */
	{ 0xce,0x3c, 39}, /* 0x31 */  /* CH-TV */
	{ 0x52,0x4a, 36}, /* 0x32 */  /* CH/PAL 800x600 5/6 */
	{ 0x34,0x61, 95}, /* 0x33 */
	{ 0x78,0x27,108}, /* 0x34 */  /* Replacement for index 0x14 for 630 (?) */
	{ 0xce,0x25,189}, /* 0x35 */  /* Replacement for index 0x1b for 730 (and 540?) */
	{ 0x45,0x6b, 21}, /* 0x36 */  /* Chrontel SuperOverscan */
	{ 0x52,0xe2, 49}, /* 0x37 */  /* 16:9 modes  */
	{ 0x2b,0x61, 78}, /* 0x38 */  /* 16:9 modes  */
	{ 0x70,0x44,108}, /* 0x39 */  /* 16:9 modes  */
	{ 0x54,0x42,135}, /* 0x3a */  /* 16:9 modes  */
	{ 0x41,0x22,157}, /* 0x3b */  /* 16:9 modes  */
	{ 0x52,0x07,149}, /* 0x3c */  /* 1280x960-85 */
	{ 0x62,0xc6, 34}, /* 0x3d */  /* 848x480-60  */
	{ 0x30,0x23, 88}, /* 0x3e */  /* 1360x768-60 */
#if 0
	{ 0x3f,0x64, 46}, /* 0x3f */  /* 640x480-100 */
#endif
        { 0x70,0x29, 81}, /* 0x3f */  /* 1280x768-60 */
	{ 0x72,0x2a, 76}, /* 0x40 */  /* test for SiS730 */
	{ 0x15,0x21, 79}, /* 0x41 */  /* test for SiS730 */
	{ 0xa1,0x42,108}, /* 0x42 */  /* 1280x960 LCD */
	{ 0x37,0x61,100}, /* 0x43 */  /* 1280x960 LCD */
	{ 0xe3,0x9a,106}, /* 0x44 */  /* 1360x1024 - special for Barco iQ R300 */
	{ 0xff,0x00,  0}   
};

#if 0 /* TW: This table is in all BIOSes, but not used */
static const SiS300_VCLKDataStruct  SiS300_VBVCLKData[] =
{
	{ 0x1b,0xe1, 25},
	{ 0x4e,0xe4, 28},
	{ 0x57,0xe4, 31},
	{ 0xc3,0xc8, 36},
	{ 0x42,0x47, 40},
	{ 0x5d,0xc4, 44},
	{ 0x52,0x47, 49},
	{ 0x53,0x47, 50},
	{ 0x6d,0x66, 56},
	{ 0x5a,0x64, 65},
	{ 0x46,0x44, 67},
	{ 0x29,0x61, 75},
	{ 0x6d,0x46, 75},
	{ 0x41,0x43, 78},
	{ 0x31,0x42, 79},
	{ 0x46,0x25, 84},
	{ 0x78,0x29, 86}, /* 0x10 */
	{ 0x62,0x44, 94},
	{ 0x2b,0x22,104},
	{ 0x49,0x24,105},
	{ 0x43,0x42,108},
	{ 0x3c,0x23,109},
	{ 0xe0,0x46,132},
	{ 0x70,0x25,135},
	{ 0x41,0x22,157},
	{ 0x43,0x22,162},
	{ 0x30,0x21,175},
	{ 0xc1,0x24,189},
	{ 0xde,0x26,194},
	{ 0x70,0x07,202},
	{ 0x3f,0x03,229},
	{ 0x30,0x02,234},  /* 0x1f */
	{ 0x24,0x01,265},  /* 0x20 */
	{ 0x52,0x2a, 54},
	{ 0x52,0x6a, 27},
	{ 0x62,0x24, 70},
	{ 0x62,0x64, 70},
	{ 0xa8,0x4c, 30},
	{ 0x20,0x26, 33},
	{ 0x31,0xc2, 39},
	{ 0x2e,0x48, 25},  /* 0x28 */
	{ 0x24,0x46, 25},  /* 0x29 */
	{ 0x26,0x64, 28},
	{ 0x37,0x64, 40},
	{ 0xa1,0x42,108},
	{ 0x37,0x61,100},
	{ 0x78,0x27,108},
	{ 0xff,0x00,  0}
};
#endif

static const UCHAR  SiS300_ScreenOffset[] =
{
	0x14,0x19,0x20,0x28,0x32,0x40,0x50,
        0x64,0x78,0x80,0x2d,0x35,0x48,0x35,
	0x55,0x30,0xff
};

#ifndef LINUX_XF86
static UCHAR SiS300_SR07 = 0x10;
#endif

static const UCHAR  SiS300_SR15[8][4] =
{
	{0x01,0x09,0xa3,0x00},
	{0x43,0x43,0x43,0x00},
	{0x1e,0x1e,0x1e,0x00},
	{0x2a,0x2a,0x2a,0x00},
	{0x06,0x06,0x06,0x00},
	{0x00,0x00,0x00,0x00},
	{0x00,0x00,0x00,0x00},
	{0x00,0x00,0x00,0x00}
};

#ifndef LINUX_XF86
static UCHAR SiS300_SR1F = 0x00;
static UCHAR SiS300_SR21 = 0x16;
static UCHAR SiS300_SR22 = 0xb2;
static UCHAR SiS300_SR23 = 0xf6;
static UCHAR SiS300_SR24 = 0x0d;
static UCHAR SiS300_SR25[] = {0x0,0x0};
static UCHAR SiS300_SR31 = 0x00;
static UCHAR SiS300_SR32 = 0x11;
static UCHAR SiS300_SR33 = 0x00;
static UCHAR SiS300_CRT2Data_1_2 = 0x40;
static UCHAR SiS300_CRT2Data_4_D = 0x00;
static UCHAR SiS300_CRT2Data_4_E = 0x00;
static UCHAR SiS300_CRT2Data_4_10 = 0x80;

static const USHORT SiS300_RGBSenseData = 0xd1;
static const USHORT SiS300_VideoSenseData = 0xb3;
static const USHORT SiS300_YCSenseData = 0xb9;
static const USHORT SiS300_RGBSenseData2 = 0x0190;
static const USHORT SiS300_VideoSenseData2 = 0x0174;
static const USHORT SiS300_YCSenseData2 = 0x016b;

static const UCHAR SiS300_CR40[5][4];

static UCHAR SiS300_CR49[2];
#endif

typedef struct _SiS300_PanelDelayTblStruct
{
	UCHAR timer[2];
} SiS300_PanelDelayTblStruct;

static const SiS300_PanelDelayTblStruct  SiS300_PanelDelayTbl[] =
{
	{{0x05,0xaa}},
	{{0x05,0x14}},
	{{0x05,0x36}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x90}},
	{{0x05,0x90}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x20,0x80}},
	{{0x05,0x14}},
	{{0x05,0x40}},
	{{0x05,0x60}}
};

static const SiS300_PanelDelayTblStruct  SiS300_PanelDelayTblLVDS[] =
{
	{{0x05,0xaa}},
	{{0x05,0x14}},
	{{0x05,0x36}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x90}},
	{{0x05,0x90}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},  /* 2.07a (JVC): 14,96 */
	{{0x05,0x28}},  /* 2.04.5c: 20, 80 - Clevo (2.04.2c): 05, 28 */
	{{0x05,0x14}},
	{{0x05,0x14}},  /* Some BIOSes: 05, 40 */
	{{0x05,0x60}}
};

typedef struct _SiS300_LCDDataStruct
{
	USHORT RVBHCMAX;
	USHORT RVBHCFACT;
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT LCDHT;
	USHORT LCDVT;
} SiS300_LCDDataStruct;

static const SiS300_LCDDataStruct  SiS300_StLCD1024x768Data[] =
{
	{   66,  31, 992, 510,1320, 816},
	{   66,  31, 992, 510,1320, 816},
	{  176,  75, 900, 510,1320, 816},
	{  176,  75, 900, 510,1320, 816},
	{   66,  31, 992, 510,1320, 816},
	{   27,  16,1024, 650,1350, 832},
	{    1,   1,1344, 806,1344, 806}
};

static const SiS300_LCDDataStruct  SiS300_ExtLCD1024x768Data[] =
{
	{   12,   5, 896, 512,1344, 806},
	{   12,   5, 896, 510,1344, 806},
	{   32,  15,1008, 505,1344, 806},
	{   32,  15,1008, 514,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

static const SiS300_LCDDataStruct  SiS300_St2LCD1024x768Data[] =
{
	{   62,  25, 800, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
	{  104,  45, 945, 496,1344, 806},
	{   62,  25, 800, 546,1344, 806},
	{   31,  18,1008, 624,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

static const SiS300_LCDDataStruct  SiS300_StLCD1280x1024Data[] =
{
	{    4,   1, 880, 510,1650,1088},
	{    4,   1, 880, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{    4,   1, 880, 510,1650,1088},
	{   13,   5,1024, 675,1560,1152},
	{   16,   9,1266, 804,1688,1072},
	{    1,   1,1688,1066,1688,1066}
};

static const SiS300_LCDDataStruct  SiS300_ExtLCD1280x1024Data[] =
{
	{  211,  60,1024, 501,1688,1066},
	{  211,  60,1024, 508,1688,1066},
	{  211,  60,1024, 501,1688,1066},
	{  211,  60,1024, 508,1688,1066},
	{  211,  60,1024, 500,1688,1066},
	{  211,  75,1024, 625,1688,1066},
	{  211, 120,1280, 798,1688,1066},
	{    1,   1,1688,1066,1688,1066}
};

static const SiS300_LCDDataStruct  SiS300_St2LCD1280x1024Data[] =
{
	{   22,   5, 800, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{   13,   5,1024, 675,1560,1152},
	{   16,   9,1266, 804,1688,1072},
	{    1,   1,1688,1066,1688,1066}
};

static const SiS300_LCDDataStruct  SiS300_NoScaleData1024x768[] =
{
	{    1,   1, 800, 449, 800, 449},
	{    1,   1, 800, 449, 800, 449},
	{    1,   1, 900, 449, 900, 449},
	{    1,   1, 900, 449, 900, 449},
	{    1,   1, 800, 525, 800, 525},
	{    1,   1,1056, 628,1056, 628},
	{    1,   1,1344, 806,1344, 806},
	{    1,   1,1688,1066,1688,1066}
};

static const SiS300_LCDDataStruct  SiS300_NoScaleData1280x1024[] =  /* TW: Fake */
{
	{    1,   1, 800, 449, 800, 449},
	{    1,   1, 800, 449, 800, 449},
	{    1,   1, 900, 449, 900, 449},
	{    1,   1, 900, 449, 900, 449},
	{    1,   1, 800, 525, 800, 525},
	{    1,   1,1056, 628,1056, 628},
	{    1,   1,1344, 806,1344, 806},
	{    1,   1,1688,1066,1688,1066}
};

typedef struct _SiS300_LVDSDataStruct
{
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT LCDHT;
	USHORT LCDVT;
} SiS300_LVDSDataStruct;

static const SiS300_LVDSDataStruct  SiS300_CHTVUPALData[] =
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{ 840, 750, 840, 750},
	{ 936, 836, 936, 836}
};

static const SiS300_LVDSDataStruct  SiS300_CHTVOPALData[] =
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{ 840, 625, 840, 625},
	{ 960, 750, 960, 750}
};

static const SiS300_LVDSDataStruct  SiS300_CHTVSOPALData[] =
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{ 840, 500, 840, 500},
	{ 944, 625, 944, 625}
};

typedef struct _SiS300_LVDSDesStruct
{
	USHORT LCDHDES;
	USHORT LCDVDES;
} SiS300_LVDSDesStruct;

static const SiS300_LVDSDesStruct  SiS300_PanelType00_1[] =
{
	{ 1059, 626 },   /* 2.08 */
	{ 1059, 624 },
	{ 1059, 626 },
	{ 1059, 624 },
	{ 1059, 624 },
	{    0, 627 },
	{    0, 627 },
	{    0,   0 },
	{    0,   0 }
#if 0
	{0, 626},
	{0, 624},
	{0, 626},
	{0, 624},
	{0, 624},
	{0, 627},
	{0, 627},
	{0,   0},
	{0,   0}
#endif
};

static const SiS300_LVDSDesStruct  SiS300_PanelType01_1[] =
{
	{   0,   0 },  /* 2.08 */
	{   0,   0 },
	{   0,   0 },
	{   0,   0 },
	{   0,   0 },
	{   0,   0 },
	{   0,   0 },
	{   0,   0 },
	{   0,   0 }
#if 0
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{   0, 805},
	{   0, 794},
	{   0,   0}
#endif
};

static const SiS300_LVDSDesStruct  SiS300_PanelType02_1[] =
{
	{ 1059, 626 },  /* 2.08 */
	{ 1059, 624 },
	{ 1059, 626 },
	{ 1059, 624 },
	{ 1059, 624 },
	{    0, 627 },
	{    0, 627 },
	{    0,   0 },
	{    0,   0 }
#if 0
	{0, 626},
	{0, 624},
	{0, 626},
	{0, 624},
	{0, 624},
	{0, 627},
	{0, 627},
	{0,   0},
	{0,   0}
#endif
};

static const SiS300_LVDSDesStruct  SiS300_PanelType03_1[] =
{
	{   8, 436},
	{   8, 440},
	{   8, 436},
	{   8, 440},
	{   8, 512},
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType04_1[] =	/* 1280x1024 */
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType05_1[] =
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType06_1[] =
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType07_1[] =
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType08_1[] =
{
	{1059, 626},
	{1059, 624},
	{1059, 626},
	{1059, 624},
	{1059, 624},
	{   0, 627},
	{   0, 627},
	{   0,   0},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType09_1[] =
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0a_1[] =
{
	{1059, 626},
	{1059, 624},
	{1059, 626},
	{1059, 624},
	{1059, 624},
	{   0, 627},
	{   0, 627},
	{   0,   0},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0b_1[] =
{
	{1343,   0},
	{1343,   0},
	{1343,   0},
	{1343,   0},
	{1343,   0},
	{1343,   0},
	{   0, 799},
	{   0,   0},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0c_1[] =
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0d_1[] =
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0e_1[] =
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},    /* 640x480 */
	{1343,   0},    /* 800x600 */
	{   0, 805},    /* 1024x768 */
	{   0, 794},    /* 1280x1024 */
	{   0,   0}     /* 1280x960 - not applicable */
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0f_1[] =
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType00_2[] =
{
	{976, 527},
	{976, 502},
	{976, 527},
	{976, 502},
	{976, 567},
	{  0, 627},
	{  0, 627},
	{  0,   0},
	{  0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType01_2[] =
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType02_2[] =
{
	{976, 527},
	{976, 502},
	{976, 527},
	{976, 502},
	{976, 567},
	{  0, 627},
	{  0, 627},
	{  0,   0},
	{  0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType03_2[] =
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805},
	{1152, 622},
	{1152, 597}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType04_2[] =
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType05_2[] =
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType06_2[] =
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType07_2[] =
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType08_2[] =
{
 	{976, 527},
 	{976, 502},
 	{976, 527},
 	{976, 502},
 	{976, 567},
 	{  0, 627},
 	{  0, 627},
 	{  0,   0},
 	{  0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType09_2[] =
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0a_2[] =
{
 	{976, 527},
 	{976, 502},
 	{976, 527},
 	{976, 502},
 	{976, 567},
 	{  0, 627},
 	{  0, 627},
 	{  0,   0},
 	{  0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0b_2[] =
{
 	{ 1152, 700},
 	{ 1152, 675},
 	{ 1152, 700},
 	{ 1152, 675},
 	{ 1152, 740},
 	{ 1232, 799},
 	{    0, 799},
 	{    0,   0},
 	{    0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0c_2[] =
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0d_2[] =
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0e_2[] =
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0f_2[] =
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

/* Custom data for Barco iQ R200/300/400 (BIOS 2.00.07) */
static const SiS300_LVDSDesStruct  SiS300_PanelType04_1a[] =	/* 1280x1024 (1366x1024) */
{
	{1330, 798},  /* 320x200 */
	{1330, 794},
	{1330, 798},
	{1330, 794},
	{1330,   0},  /* 640x480 / 320x240  */
	{1343,   0},  /* 800x600 / 400x300  */
	{   0, 805},  /* 1024x768 / 512x384 */
	{1688,1066},  /* 1280x1024          */
	{   0,   0}   /* 1360x1024          */
};

static const SiS300_LVDSDesStruct  SiS300_PanelType04_2a[] =
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805},
	{1688,1066},
	{   0,   0}
};

/* Custom data for Barco iQ G200/300/400 (BIOS 2.00.07) */
static const SiS300_LVDSDesStruct  SiS300_PanelType04_1b[] =	/* 1024x768 */
{
	{1330, 798},  /* 320x200 */
	{1330, 794},
	{1330, 798},
	{1330, 794},
	{1330,   0},  /* 640x480 / 320x240  */
	{1343,   0},  /* 800x600 / 400x300  */
	{   0, 805}   /* 1024x768 / 512x384 */
};

static const SiS300_LVDSDesStruct  SiS300_PanelType04_2b[] =
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805}
};


typedef struct _SiS300_Part2PortTblStruct
{
 	UCHAR CR[12];
} SiS300_Part2PortTblStruct;

static const SiS300_Part2PortTblStruct SiS300_CRT2Part2_1024x768_1[] =
{ /* VESA Timing */
 {{0x21,0x12,0xbf,0xe4,0xc0,0x21,0x45,0x09,0x00,0xa9,0x09,0x04}},
 {{0x2c,0x12,0x9a,0xae,0x88,0x21,0x45,0x09,0x00,0xa9,0x09,0x04}},
 {{0x21,0x12,0xbf,0xe4,0xc0,0x21,0x45,0x09,0x00,0xa9,0x09,0x04}},
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
 {{0x22,0x13,0xfe,0x25,0xff,0x21,0x45,0x0a,0x00,0xa9,0x0d,0x04}},
 {{0x22,0x13,0xfe,0x25,0xff,0x21,0x45,0x0a,0x00,0xa9,0x0d,0x04}},
 {{0x22,0x13,0xfe,0x25,0xff,0x21,0x45,0x0a,0x00,0xa9,0x0d,0x04}}
};

static const SiS300_Part2PortTblStruct SiS300_CRT2Part2_1280x1024_1[] =
{	/* TW: Temporary data, invalid */
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
};

static const SiS300_Part2PortTblStruct SiS300_CRT2Part2_1400x1050_1[] =
{	/* TW: Temporary data, invalid */
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
};

static const SiS300_Part2PortTblStruct SiS300_CRT2Part2_1600x1200_1[] =
{	/* TW: Temporary data, invalid */
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
};

static const SiS300_Part2PortTblStruct SiS300_CRT2Part2_1024x768_2[] =
{  /* Non-VESA */
 {{0x28,0x12,0xa3,0xd0,0xaa,0x5a,0x45,0x0a,0x07,0xfa,0x0a,0x24}},
 {{0x2c,0x12,0x9a,0xae,0x88,0x5a,0x45,0x0a,0x07,0xfa,0x0a,0x24}},
 {{0x28,0x12,0xa3,0xd0,0xaa,0x5a,0x45,0x0a,0x07,0xfa,0x0a,0x24}},
 {{0x2c,0x12,0x9a,0xae,0x88,0x5a,0x45,0x0a,0x07,0xfa,0x0a,0x24}},
 {{0x28,0x13,0xe7,0x0b,0xe8,0x5a,0x45,0x0a,0x07,0xfa,0x0a,0x24}},
 {{0x38,0x18,0x16,0x00,0x00,0x5a,0x45,0x0a,0x07,0xfa,0x0a,0x24}},
 {{0x36,0x13,0x13,0x25,0xff,0x5a,0x45,0x0a,0x07,0xfa,0x0a,0x24}}
};

static const SiS300_Part2PortTblStruct SiS300_CRT2Part2_1280x1024_2[] =
{
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
};

static const SiS300_Part2PortTblStruct SiS300_CRT2Part2_1400x1050_2[] =
{
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
};

static const SiS300_Part2PortTblStruct SiS300_CRT2Part2_1600x1200_2[] =
{	/* TW: Temporary data, invalid */
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
};

static const SiS300_Part2PortTblStruct SiS300_CRT2Part2_1024x768_3[] =
{	/* TW: Temporary data, invalid */
 {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
};

static const SiS300_Part2PortTblStruct SiS300_CRT2Part2_1280x1024_3[] =
{	/* TW: Temporary data, invalid */
  {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
};

static const SiS300_Part2PortTblStruct SiS300_CRT2Part2_1400x1050_3[] =
{	/* TW: Temporary data, invalid */
  {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
};

static const SiS300_Part2PortTblStruct SiS300_CRT2Part2_1600x1200_3[] =
{	/* TW: Temporary data, invalid */
  {{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}
};

typedef struct _SiS300_LVDSCRT1DataStruct
{
UCHAR CR[15];
} SiS300_LVDSCRT1DataStruct;

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT1800x600_1[] =
{
	{{0x65,0x4f,0x89,0x56,0x83,0xaf,0x1f,
	  0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
	  0x00 }},
	{{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
	  0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
	  0x00 }},
	{{0x65,0x4f,0x89,0x56,0x83,0xaf,0x1f,
	  0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
	  0x00 }},
	{{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
	  0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
	  0x00 }},
	{{0x65,0x4f,0x89,0x56,0x83,0x04,0x3e,
	  0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
	  0x00 }},
	{{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
	  0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT1800x600_1_H[] =
{
	{{0x30,0x27,0x94,0x2c,0x92,0xaf,0x1f,
	  0x90,0x85,0x8f,0xab,0x30,0x00,0x04,
	  0x00 }},
	{{0x30,0x27,0x94,0x2c,0x92,0x83,0x1f,
	  0x5e,0x83,0x5d,0x79,0x10,0x00,0x04,
	  0x00 }},
	{{0x30,0x27,0x94,0x2c,0x92,0xaf,0x1f,
	  0x90,0x85,0x8f,0xab,0x30,0x00,0x04,
	  0x00 }},
	{{0x30,0x27,0x94,0x2c,0x92,0x83,0x1f,
	  0x5e,0x83,0x5d,0x79,0x10,0x00,0x04,
	  0x00 }},
	{{0x30,0x27,0x94,0x2c,0x92,0x04,0x3e,
	  0xe0,0x85,0xdf,0xfb,0x10,0x00,0x04,
	  0x00 }},
	{{0x3d,0x31,0x81,0x37,0x1f,0x72,0xf0,
	  0x58,0x8c,0x57,0x73,0x20,0x00,0x05,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x768_1[] =
{ 
	{{0x64,0x4f,0x88,0x54,0x9f,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00}},
	{{0x64,0x4f,0x88,0x54,0x9f,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00}},
	{{0x64,0x4f,0x88,0x54,0x9f,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00}},
	{{0x64,0x4f,0x88,0x54,0x9f,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00}},
	{{0x64,0x4f,0x88,0x54,0x9f,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x01,
	  0x00}},
	{{0x7e,0x63,0x82,0x68,0x15,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x26,
	  0x01}},
	{{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01}}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x768_1_H[] =
{
	{{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00 }},
	{{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
	  0x60,0x87,0x5D,0x83,0x10,0x00,0x44,
	  0x00}},
	{{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
	{{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
	  0x60,0x87,0x5D,0x83,0x10,0x00,0x44,
	  0x00}},
	{{0x2f,0x27,0x93,0x2b,0x90,0x04,0x3e,
	  0xE2,0x89,0xdf,0x05,0x00,0x00,0x44,
	  0x00}},
	{{0x3c,0x31,0x80,0x35,0x1c,0x7c,0xf0,
	  0x5A,0x8F,0x57,0x7D,0x20,0x00,0x55,
	  0x01}},
	{{0x4f,0x3F,0x93,0x45,0x0D,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01 }}

#if 0
	{{0x37,0x27,0x9B,0x2b,0x94,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00 }},
	{{0x37,0x27,0x9B,0x2b,0x94,0x97,0x1f,
	  0x60,0x87,0x5D,0x83,0x01,0x00,0x44,
	  0x00}},
	{{0x37,0x27,0x9B,0x2b,0x94,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
	{{0x37,0x27,0x9B,0x2b,0x94,0x97,0x1f,
	  0x60,0x87,0x5D,0x83,0x01,0x00,0x44,
	  0x00}},
	{{0x37,0x27,0x9B,0x2b,0x94,0x04,0x3e,
	  0xE2,0x89,0xDf,0x05,0x00,0x00,0x44,
	  0x00}},
	{{0x41,0x31,0x85,0x35,0x1d,0x7c,0xf0,
	  0x5A,0x8F,0x57,0x7D,0x20,0x00,0x55,
	  0x01}},
	{{0x4f,0x3F,0x93,0x45,0x0D,0x24,0xf5,
	  0x02,0x88,0xFf,0x25,0x10,0x00,0x01,
	  0x01 }}
#endif
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11280x1024_1[] =
{
	{{0x63,0x4f,0x87,0x54,0x9f,0xb4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x54,0x9f,0x82,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x54,0x9f,0xb4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x54,0x9f,0x82,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x54,0x9f,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x01,
	  0x00 }},
	{{0x7e,0x63,0x82,0x68,0x15,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x26,
	  0x01 }},
	{{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11280x1024_1_H[] =
{
	{{0x2f,0x27,0x93,0x2b,0x90,0xb4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x04,
	  0x00 }},
	{{0x2f,0x27,0x93,0x2b,0x90,0x82,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x04,
	  0x00 }},
	{{0x2f,0x27,0x93,0x2b,0x90,0xb4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x04,
	  0x00 }},
	{{0x2f,0x27,0x93,0x2b,0x90,0x82,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x04,
	  0x00 }},
	{{0x2f,0x27,0x93,0x2b,0x90,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x04,
	  0x00 }},
	{{0x3c,0x31,0x80,0x35,0x1c,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x55,
	  0x01 }},
	{{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT1800x600_2[] =
{
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
	  0xf4,0x88,0x8f,0x73,0x20,0x00,0x06,
	  0x00 }},
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
	  0xdb,0x8f,0x5d,0x73,0x20,0x00,0x06,
	  0x00 }},
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
	  0xf4,0x88,0x8f,0x73,0x20,0x00,0x06,
	  0x00 }},
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
	  0xdb,0x8f,0x5d,0x73,0x20,0x00,0x06,
	  0x00 }},
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0xba,
	  0x1c,0x80,0xdf,0x73,0x00,0x00,0x06,
	  0x00 }},
	{{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
	  0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT1800x600_2_H[] =
{
	{{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
	  0xf4,0x88,0x8f,0x73,0x20,0x00,0x05,
	  0x00 }},
	{{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
	  0xdb,0x8f,0x5d,0x73,0x20,0x00,0x05,
	  0x00 }},
	{{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
	  0xf4,0x88,0x8f,0x73,0x20,0x00,0x05,
	  0x00 }},
	{{0x3d,0x27,0x81,0x3a,0x1a,0x72,0x3e,
	  0xdb,0x8f,0x5d,0x73,0x20,0x00,0x05,
	  0x00 }},
	{{0x3d,0x27,0x81,0x32,0x1a,0x72,0xba,
	  0x1c,0x80,0xdf,0x73,0x00,0x00,0x05,
	  0x00 }},
	{{0x3d,0x31,0x81,0x37,0x1f,0x72,0xf0,
	  0x58,0x8c,0x57,0x73,0x20,0x00,0x05,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x768_2[] =
{
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x02,
	  0x01 }},
	{{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x768_2_H[] =
{
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x31,0x93,0x3e,0x06,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x01,
	  0x01 }},
	{{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11280x1024_2[] =
{
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x02,
	  0x01 }},
	{{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11280x1024_2_H[] =
{
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x31,0x93,0x3e,0x86,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x01,
	  0x01 }},
	{{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_CHTVCRT1UNTSC[] =
{
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xe8,0x84,0x8f,0x57,0x20,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xd0,0x82,0x5d,0x57,0x00,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xe8,0x84,0x8f,0x57,0x20,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xd0,0x82,0x5d,0x57,0x00,0x00,0x01,
	  0x00 }},
	{{0x5d,0x4f,0x81,0x53,0x9c,0x56,0xba,
	  0x18,0x84,0xdf,0x57,0x00,0x00,0x01,
	  0x00 }},
	{{0x80,0x63,0x84,0x6c,0x17,0xec,0xf0,
	  0x90,0x8c,0x57,0xed,0x20,0x00,0x06,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_CHTVCRT1ONTSC[] =
{
	{{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
	  0xc0,0x84,0x8f,0x0c,0x20,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
	  0xb0,0x8d,0x5d,0x0c,0x00,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
	  0xc0,0x84,0x8f,0x0c,0x20,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
	  0xb0,0x8d,0x5d,0x0c,0x00,0x00,0x01,
	  0x00 }},
	{{0x5d,0x4f,0x81,0x56,0x9c,0x0b,0x3e,
	  0xe8,0x84,0xdf,0x0c,0x00,0x00,0x01,
	  0x00 }},
	{{0x7d,0x63,0x81,0x6a,0x16,0xba,0xf0,
	  0x7f,0x86,0x57,0xbb,0x00,0x00,0x06,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_CHTVCRT1UPAL[] =
{
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf8,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf8,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x64,0x4f,0x88,0x55,0x80,0xec,0xba,
	  0x50,0x84,0xdf,0xed,0x00,0x00,0x05,
	  0x00 }},
	{{0x70,0x63,0x94,0x68,0x8d,0x42,0xf1,
	  0xc8,0x8c,0x57,0xe9,0x20,0x00,0x05,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_CHTVCRT1OPAL[] =
{
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x64,0x4f,0x88,0x55,0x80,0x6f,0xba,
	  0x20,0x83,0xdf,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x73,0x63,0x97,0x69,0x8e,0xec,0xf0,
	  0x90,0x8c,0x57,0xed,0x20,0x00,0x05,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_CHTVCRT1SOPAL[] =
{
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x64,0x4f,0x88,0x55,0x80,0x6f,0xba,  /* TODO */
	  0x20,0x83,0xdf,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x73,0x63,0x97,0x69,0x8e,0xec,0xf0,  /* TODO */
	  0x90,0x8c,0x57,0xed,0x20,0x00,0x05,
	  0x01 }}
};

typedef struct _SiS300_CHTVRegDataStruct
{
	UCHAR Reg[16];
} SiS300_CHTVRegDataStruct;

static const SiS300_CHTVRegDataStruct SiS300_CHTVReg_UNTSC[] =
{
	{{0x4a,0x94,0x00,0x48,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x4a,0x94,0x00,0x48,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x4a,0x94,0x00,0x48,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x4a,0x94,0x00,0x48,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x6a,0x6a,0x00,0x2d,0xfa,0,0,0,0,0,0,0,0,0,0,0}}, /* Mode 17: 640x480 NTSC 7/8  */
	{{0x8d,0xc4,0x00,0x3b,0xfb,0,0,0,0,0,0,0,0,0,0,0}}  /* Mode 24: 800x600 NTSC 7/10 */
};

static const SiS300_CHTVRegDataStruct SiS300_CHTVReg_ONTSC[] =
{
	{{0x49,0x94,0x00,0x34,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x49,0x94,0x00,0x34,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x49,0x94,0x00,0x34,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x49,0x94,0x00,0x34,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x69,0x6a,0x00,0x1e,0xfd,0,0,0,0,0,0,0,0,0,0,0}}, /* Mode 16: 640x480 NTSC 1/1 */
	{{0x8c,0xb4,0x00,0x32,0xf9,0,0,0,0,0,0,0,0,0,0,0}}  /* Mode 23: 800x600 NTSC 3/4 */
};

static const SiS300_CHTVRegDataStruct SiS300_CHTVReg_UPAL[] =
{
	{{0x41,0x12,0x01,0x50,0x34,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x41,0x12,0x00,0x50,0x00,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x41,0x12,0x01,0x50,0x34,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x41,0x12,0x00,0x50,0x00,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x63,0x94,0x01,0x50,0x30,0,0,0,0,0,0,0,0,0,0,0}}, /* Mode 15: 640x480 PAL 5/6 */
	{{0x84,0x64,0x01,0x4e,0x2f,0,0,0,0,0,0,0,0,0,0,0}}  /* Mode 21: 800x600 PAL 3/4 */

};

static const SiS300_CHTVRegDataStruct SiS300_CHTVReg_OPAL[] =
{
	{{0x41,0x12,0x01,0x50,0x34,0,0,0,0,0,0,0,0,0,0,0}}, /* Mode 9: 640x400 PAL 1/1 */
	{{0x41,0x12,0x00,0x50,0x00,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x41,0x12,0x01,0x50,0x34,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x41,0x12,0x00,0x50,0x00,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x61,0x94,0x01,0x36,0x30,0,0,0,0,0,0,0,0,0,0,0}}, /* Mode 14: 640x480 PAL 1/1 */
	{{0x83,0x76,0x01,0x40,0x31,0,0,0,0,0,0,0,0,0,0,0}}  /* Mode 20: 800x600 PAL 5/6 */

};

static const SiS300_CHTVRegDataStruct SiS300_CHTVReg_SOPAL[] =
{
	{{0x41,0x12,0x01,0x50,0x34,0,0,0,0,0,0,0,0,0,0,0}}, /* Mode 9: 640x400 PAL 1/1 */
	{{0x41,0x12,0x00,0x50,0x00,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x41,0x12,0x01,0x50,0x34,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x41,0x12,0x00,0x50,0x00,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x60,0x30,0x00,0x10,0x00,0,0,0,0,0,0,0,0,0,0,0}}, /* TW: Mode 13: 640x480 PAL 5/4 */
	{{0x81,0x50,0x00,0x1b,0x00,0,0,0,0,0,0,0,0,0,0,0}}  /* TW: Mode 19: 800x600 PAL 1/1 */
};

static const UCHAR SiS300_CHTVVCLKUNTSC[]  = {0x29,0x29,0x29,0x29,0x2a,0x2e};

static const UCHAR SiS300_CHTVVCLKONTSC[]  = {0x2c,0x2c,0x2c,0x2c,0x2d,0x2b};

static const UCHAR SiS300_CHTVVCLKSONTSC[] = {0x2c,0x2c,0x2c,0x2c,0x2d,0x2b};

static const UCHAR SiS300_CHTVVCLKUPAL[]   = {0x2f,0x2f,0x2f,0x2f,0x2f,0x31};

static const UCHAR SiS300_CHTVVCLKOPAL[]   = {0x2f,0x2f,0x2f,0x2f,0x30,0x32};

static const UCHAR SiS300_CHTVVCLKSOPAL[]  = {0x2f,0x2f,0x2f,0x2f,0x36,0x29};


