/* SPDX-License-Identifier: ISC */
/*
 * Copyright (c) 2005-2011 Atheros Communications Inc.
 * Copyright (c) 2011-2017 Qualcomm Atheros, Inc.
 * Copyright (c) 2018, The Linux Foundation. All rights reserved.
 */
#ifndef _WMI_TLV_H
#define _WMI_TLV_H

#define WMI_TLV_CMD(grp_id) (((grp_id) << 12) | 0x1)
#define WMI_TLV_EV(grp_id) (((grp_id) << 12) | 0x1)
#define WMI_TLV_CMD_UNSUPPORTED 0
#define WMI_TLV_PDEV_PARAM_UNSUPPORTED 0
#define WMI_TLV_VDEV_PARAM_UNSUPPORTED 0
#define WMI_TLV_MGMT_TX_FRAME_MAX_LEN	64

#define WMI_RSRC_CFG_FLAG_TX_ACK_RSSI		BIT(18)

enum wmi_tlv_grp_id {
	WMI_TLV_GRP_START = 0x3,
	WMI_TLV_GRP_SCAN = WMI_TLV_GRP_START,
	WMI_TLV_GRP_PDEV,
	WMI_TLV_GRP_VDEV,
	WMI_TLV_GRP_PEER,
	WMI_TLV_GRP_MGMT,
	WMI_TLV_GRP_BA_NEG,
	WMI_TLV_GRP_STA_PS,
	WMI_TLV_GRP_DFS,
	WMI_TLV_GRP_ROAM,
	WMI_TLV_GRP_OFL_SCAN,
	WMI_TLV_GRP_P2P,
	WMI_TLV_GRP_AP_PS,
	WMI_TLV_GRP_RATECTL,
	WMI_TLV_GRP_PROFILE,
	WMI_TLV_GRP_SUSPEND,
	WMI_TLV_GRP_BCN_FILTER,
	WMI_TLV_GRP_WOW,
	WMI_TLV_GRP_RTT,
	WMI_TLV_GRP_SPECTRAL,
	WMI_TLV_GRP_STATS,
	WMI_TLV_GRP_ARP_NS_OFL,
	WMI_TLV_GRP_NLO_OFL,
	WMI_TLV_GRP_GTK_OFL,
	WMI_TLV_GRP_CSA_OFL,
	WMI_TLV_GRP_CHATTER,
	WMI_TLV_GRP_TID_ADDBA,
	WMI_TLV_GRP_MISC,
	WMI_TLV_GRP_GPIO,
	WMI_TLV_GRP_FWTEST,
	WMI_TLV_GRP_TDLS,
	WMI_TLV_GRP_RESMGR,
	WMI_TLV_GRP_STA_SMPS,
	WMI_TLV_GRP_WLAN_HB,
	WMI_TLV_GRP_RMC,
	WMI_TLV_GRP_MHF_OFL,
	WMI_TLV_GRP_LOCATION_SCAN,
	WMI_TLV_GRP_OEM,
	WMI_TLV_GRP_NAN,
	WMI_TLV_GRP_COEX,
	WMI_TLV_GRP_OBSS_OFL,
	WMI_TLV_GRP_LPI,
	WMI_TLV_GRP_EXTSCAN,
	WMI_TLV_GRP_DHCP_OFL,
	WMI_TLV_GRP_IPA,
	WMI_TLV_GRP_MDNS_OFL,
	WMI_TLV_GRP_SAP_OFL,
};

enum wmi_tlv_cmd_id {
	WMI_TLV_INIT_CMDID = 0x1,
	WMI_TLV_START_SCAN_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_SCAN),
	WMI_TLV_STOP_SCAN_CMDID,
	WMI_TLV_SCAN_CHAN_LIST_CMDID,
	WMI_TLV_SCAN_SCH_PRIO_TBL_CMDID,
	WMI_TLV_SCAN_UPDATE_REQUEST_CMDID,
	WMI_TLV_SCAN_PROB_REQ_OUI_CMDID,
	WMI_TLV_PDEV_SET_REGDOMAIN_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_PDEV),
	WMI_TLV_PDEV_SET_CHANNEL_CMDID,
	WMI_TLV_PDEV_SET_PARAM_CMDID,
	WMI_TLV_PDEV_PKTLOG_ENABLE_CMDID,
	WMI_TLV_PDEV_PKTLOG_DISABLE_CMDID,
	WMI_TLV_PDEV_SET_WMM_PARAMS_CMDID,
	WMI_TLV_PDEV_SET_HT_CAP_IE_CMDID,
	WMI_TLV_PDEV_SET_VHT_CAP_IE_CMDID,
	WMI_TLV_PDEV_SET_DSCP_TID_MAP_CMDID,
	WMI_TLV_PDEV_SET_QUIET_MODE_CMDID,
	WMI_TLV_PDEV_GREEN_AP_PS_ENABLE_CMDID,
	WMI_TLV_PDEV_GET_TPC_CONFIG_CMDID,
	WMI_TLV_PDEV_SET_BASE_MACADDR_CMDID,
	WMI_TLV_PDEV_DUMP_CMDID,
	WMI_TLV_PDEV_SET_LED_CONFIG_CMDID,
	WMI_TLV_PDEV_GET_TEMPERATURE_CMDID,
	WMI_TLV_PDEV_SET_LED_FLASHING_CMDID,
	WMI_TLV_VDEV_CREATE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_VDEV),
	WMI_TLV_VDEV_DELETE_CMDID,
	WMI_TLV_VDEV_START_REQUEST_CMDID,
	WMI_TLV_VDEV_RESTART_REQUEST_CMDID,
	WMI_TLV_VDEV_UP_CMDID,
	WMI_TLV_VDEV_STOP_CMDID,
	WMI_TLV_VDEV_DOWN_CMDID,
	WMI_TLV_VDEV_SET_PARAM_CMDID,
	WMI_TLV_VDEV_INSTALL_KEY_CMDID,
	WMI_TLV_VDEV_WNM_SLEEPMODE_CMDID,
	WMI_TLV_VDEV_WMM_ADDTS_CMDID,
	WMI_TLV_VDEV_WMM_DELTS_CMDID,
	WMI_TLV_VDEV_SET_WMM_PARAMS_CMDID,
	WMI_TLV_VDEV_SET_GTX_PARAMS_CMDID,
	WMI_TLV_VDEV_IPSEC_NATKEEPALIVE_FILTER_CMDID,
	WMI_TLV_VDEV_PLMREQ_START_CMDID,
	WMI_TLV_VDEV_PLMREQ_STOP_CMDID,
	WMI_TLV_PEER_CREATE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_PEER),
	WMI_TLV_PEER_DELETE_CMDID,
	WMI_TLV_PEER_FLUSH_TIDS_CMDID,
	WMI_TLV_PEER_SET_PARAM_CMDID,
	WMI_TLV_PEER_ASSOC_CMDID,
	WMI_TLV_PEER_ADD_WDS_ENTRY_CMDID,
	WMI_TLV_PEER_REMOVE_WDS_ENTRY_CMDID,
	WMI_TLV_PEER_MCAST_GROUP_CMDID,
	WMI_TLV_PEER_INFO_REQ_CMDID,
	WMI_TLV_PEER_GET_ESTIMATED_LINKSPEED_CMDID,
	WMI_TLV_BCN_TX_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_MGMT),
	WMI_TLV_PDEV_SEND_BCN_CMDID,
	WMI_TLV_BCN_TMPL_CMDID,
	WMI_TLV_BCN_FILTER_RX_CMDID,
	WMI_TLV_PRB_REQ_FILTER_RX_CMDID,
	WMI_TLV_MGMT_TX_CMDID,
	WMI_TLV_PRB_TMPL_CMDID,
	WMI_TLV_MGMT_TX_SEND_CMD,
	WMI_TLV_ADDBA_CLEAR_RESP_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_BA_NEG),
	WMI_TLV_ADDBA_SEND_CMDID,
	WMI_TLV_ADDBA_STATUS_CMDID,
	WMI_TLV_DELBA_SEND_CMDID,
	WMI_TLV_ADDBA_SET_RESP_CMDID,
	WMI_TLV_SEND_SINGLEAMSDU_CMDID,
	WMI_TLV_STA_POWERSAVE_MODE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_STA_PS),
	WMI_TLV_STA_POWERSAVE_PARAM_CMDID,
	WMI_TLV_STA_MIMO_PS_MODE_CMDID,
	WMI_TLV_PDEV_DFS_ENABLE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_DFS),
	WMI_TLV_PDEV_DFS_DISABLE_CMDID,
	WMI_TLV_DFS_PHYERR_FILTER_ENA_CMDID,
	WMI_TLV_DFS_PHYERR_FILTER_DIS_CMDID,
	WMI_TLV_ROAM_SCAN_MODE = WMI_TLV_CMD(WMI_TLV_GRP_ROAM),
	WMI_TLV_ROAM_SCAN_RSSI_THRESHOLD,
	WMI_TLV_ROAM_SCAN_PERIOD,
	WMI_TLV_ROAM_SCAN_RSSI_CHANGE_THRESHOLD,
	WMI_TLV_ROAM_AP_PROFILE,
	WMI_TLV_ROAM_CHAN_LIST,
	WMI_TLV_ROAM_SCAN_CMD,
	WMI_TLV_ROAM_SYNCH_COMPLETE,
	WMI_TLV_ROAM_SET_RIC_REQUEST_CMDID,
	WMI_TLV_ROAM_INVOKE_CMDID,
	WMI_TLV_OFL_SCAN_ADD_AP_PROFILE = WMI_TLV_CMD(WMI_TLV_GRP_OFL_SCAN),
	WMI_TLV_OFL_SCAN_REMOVE_AP_PROFILE,
	WMI_TLV_OFL_SCAN_PERIOD,
	WMI_TLV_P2P_DEV_SET_DEVICE_INFO = WMI_TLV_CMD(WMI_TLV_GRP_P2P),
	WMI_TLV_P2P_DEV_SET_DISCOVERABILITY,
	WMI_TLV_P2P_GO_SET_BEACON_IE,
	WMI_TLV_P2P_GO_SET_PROBE_RESP_IE,
	WMI_TLV_P2P_SET_VENDOR_IE_DATA_CMDID,
	WMI_TLV_P2P_DISC_OFFLOAD_CONFIG_CMDID,
	WMI_TLV_P2P_DISC_OFFLOAD_APPIE_CMDID,
	WMI_TLV_P2P_DISC_OFFLOAD_PATTERN_CMDID,
	WMI_TLV_P2P_SET_OPPPS_PARAM_CMDID,
	WMI_TLV_AP_PS_PEER_PARAM_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_AP_PS),
	WMI_TLV_AP_PS_PEER_UAPSD_COEX_CMDID,
	WMI_TLV_PEER_RATE_RETRY_SCHED_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_RATECTL),
	WMI_TLV_WLAN_PROFILE_TRIGGER_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_PROFILE),
	WMI_TLV_WLAN_PROFILE_SET_HIST_INTVL_CMDID,
	WMI_TLV_WLAN_PROFILE_GET_PROFILE_DATA_CMDID,
	WMI_TLV_WLAN_PROFILE_ENABLE_PROFILE_ID_CMDID,
	WMI_TLV_WLAN_PROFILE_LIST_PROFILE_ID_CMDID,
	WMI_TLV_PDEV_SUSPEND_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_SUSPEND),
	WMI_TLV_PDEV_RESUME_CMDID,
	WMI_TLV_ADD_BCN_FILTER_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_BCN_FILTER),
	WMI_TLV_RMV_BCN_FILTER_CMDID,
	WMI_TLV_WOW_ADD_WAKE_PATTERN_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_WOW),
	WMI_TLV_WOW_DEL_WAKE_PATTERN_CMDID,
	WMI_TLV_WOW_ENABLE_DISABLE_WAKE_EVENT_CMDID,
	WMI_TLV_WOW_ENABLE_CMDID,
	WMI_TLV_WOW_HOSTWAKEUP_FROM_SLEEP_CMDID,
	WMI_TLV_WOW_ACER_IOAC_ADD_KEEPALIVE_CMDID,
	WMI_TLV_WOW_ACER_IOAC_DEL_KEEPALIVE_CMDID,
	WMI_TLV_WOW_ACER_IOAC_ADD_WAKE_PATTERN_CMDID,
	WMI_TLV_WOW_ACER_IOAC_DEL_WAKE_PATTERN_CMDID,
	WMI_TLV_D0_WOW_ENABLE_DISABLE_CMDID,
	WMI_TLV_EXTWOW_ENABLE_CMDID,
	WMI_TLV_EXTWOW_SET_APP_TYPE1_PARAMS_CMDID,
	WMI_TLV_EXTWOW_SET_APP_TYPE2_PARAMS_CMDID,
	WMI_TLV_RTT_MEASREQ_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_RTT),
	WMI_TLV_RTT_TSF_CMDID,
	WMI_TLV_SPECTRAL_SCAN_CONF_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_SPECTRAL),
	WMI_TLV_SPECTRAL_SCAN_ENABLE_CMDID,
	WMI_TLV_REQUEST_STATS_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_STATS),
	WMI_TLV_MCC_SCHED_TRAFFIC_STATS_CMDID,
	WMI_TLV_REQUEST_STATS_EXT_CMDID,
	WMI_TLV_REQUEST_LINK_STATS_CMDID,
	WMI_TLV_START_LINK_STATS_CMDID,
	WMI_TLV_CLEAR_LINK_STATS_CMDID,
	WMI_TLV_SET_ARP_NS_OFFLOAD_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_ARP_NS_OFL),
	WMI_TLV_ADD_PROACTIVE_ARP_RSP_PATTERN_CMDID,
	WMI_TLV_DEL_PROACTIVE_ARP_RSP_PATTERN_CMDID,
	WMI_TLV_NETWORK_LIST_OFFLOAD_CONFIG_CMDID =
			WMI_TLV_CMD(WMI_TLV_GRP_NLO_OFL),
	WMI_TLV_APFIND_CMDID,
	WMI_TLV_GTK_OFFLOAD_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_GTK_OFL),
	WMI_TLV_CSA_OFFLOAD_ENABLE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_CSA_OFL),
	WMI_TLV_CSA_OFFLOAD_CHANSWITCH_CMDID,
	WMI_TLV_CHATTER_SET_MODE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_CHATTER),
	WMI_TLV_CHATTER_ADD_COALESCING_FILTER_CMDID,
	WMI_TLV_CHATTER_DELETE_COALESCING_FILTER_CMDID,
	WMI_TLV_CHATTER_COALESCING_QUERY_CMDID,
	WMI_TLV_PEER_TID_ADDBA_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_TID_ADDBA),
	WMI_TLV_PEER_TID_DELBA_CMDID,
	WMI_TLV_STA_DTIM_PS_METHOD_CMDID,
	WMI_TLV_STA_UAPSD_AUTO_TRIG_CMDID,
	WMI_TLV_STA_KEEPALIVE_CMDID,
	WMI_TLV_BA_REQ_SSN_CMDID,
	WMI_TLV_ECHO_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_MISC),
	WMI_TLV_PDEV_UTF_CMDID,
	WMI_TLV_DBGLOG_CFG_CMDID,
	WMI_TLV_PDEV_QVIT_CMDID,
	WMI_TLV_PDEV_FTM_INTG_CMDID,
	WMI_TLV_VDEV_SET_KEEPALIVE_CMDID,
	WMI_TLV_VDEV_GET_KEEPALIVE_CMDID,
	WMI_TLV_FORCE_FW_HANG_CMDID,
	WMI_TLV_SET_MCASTBCAST_FILTER_CMDID,
	WMI_TLV_THERMAL_MGMT_CMDID,
	WMI_TLV_HOST_AUTO_SHUTDOWN_CFG_CMDID,
	WMI_TLV_TPC_CHAINMASK_CONFIG_CMDID,
	WMI_TLV_SET_ANTENNA_DIVERSITY_CMDID,
	WMI_TLV_GPIO_CONFIG_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_GPIO),
	WMI_TLV_GPIO_OUTPUT_CMDID,
	WMI_TLV_TXBF_CMDID,
	WMI_TLV_FWTEST_VDEV_MCC_SET_TBTT_MODE_CMDID =
			WMI_TLV_CMD(WMI_TLV_GRP_FWTEST),
	WMI_TLV_FWTEST_P2P_SET_NOA_PARAM_CMDID,
	WMI_TLV_UNIT_TEST_CMDID,
	WMI_TLV_TDLS_SET_STATE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_TDLS),
	WMI_TLV_TDLS_PEER_UPDATE_CMDID,
	WMI_TLV_TDLS_SET_OFFCHAN_MODE_CMDID,
	WMI_TLV_RESMGR_ADAPTIVE_OCS_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_RESMGR),
	WMI_TLV_RESMGR_SET_CHAN_TIME_QUOTA_CMDID,
	WMI_TLV_RESMGR_SET_CHAN_LATENCY_CMDID,
	WMI_TLV_STA_SMPS_FORCE_MODE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_STA_SMPS),
	WMI_TLV_STA_SMPS_PARAM_CMDID,
	WMI_TLV_HB_SET_ENABLE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_WLAN_HB),
	WMI_TLV_HB_SET_TCP_PARAMS_CMDID,
	WMI_TLV_HB_SET_TCP_PKT_FILTER_CMDID,
	WMI_TLV_HB_SET_UDP_PARAMS_CMDID,
	WMI_TLV_HB_SET_UDP_PKT_FILTER_CMDID,
	WMI_TLV_RMC_SET_MODE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_RMC),
	WMI_TLV_RMC_SET_ACTION_PERIOD_CMDID,
	WMI_TLV_RMC_CONFIG_CMDID,
	WMI_TLV_MHF_OFFLOAD_SET_MODE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_MHF_OFL),
	WMI_TLV_MHF_OFFLOAD_PLUMB_ROUTING_TBL_CMDID,
	WMI_TLV_BATCH_SCAN_ENABLE_CMDID =
			WMI_TLV_CMD(WMI_TLV_GRP_LOCATION_SCAN),
	WMI_TLV_BATCH_SCAN_DISABLE_CMDID,
	WMI_TLV_BATCH_SCAN_TRIGGER_RESULT_CMDID,
	WMI_TLV_OEM_REQ_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_OEM),
	WMI_TLV_NAN_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_NAN),
	WMI_TLV_MODEM_POWER_STATE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_COEX),
	WMI_TLV_CHAN_AVOID_UPDATE_CMDID,
	WMI_TLV_OBSS_SCAN_ENABLE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_OBSS_OFL),
	WMI_TLV_OBSS_SCAN_DISABLE_CMDID,
	WMI_TLV_LPI_MGMT_SNOOPING_CONFIG_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_LPI),
	WMI_TLV_LPI_START_SCAN_CMDID,
	WMI_TLV_LPI_STOP_SCAN_CMDID,
	WMI_TLV_EXTSCAN_START_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_EXTSCAN),
	WMI_TLV_EXTSCAN_STOP_CMDID,
	WMI_TLV_EXTSCAN_CONFIGURE_WLAN_CHANGE_MONITOR_CMDID,
	WMI_TLV_EXTSCAN_CONFIGURE_HOTLIST_MONITOR_CMDID,
	WMI_TLV_EXTSCAN_GET_CACHED_RESULTS_CMDID,
	WMI_TLV_EXTSCAN_GET_WLAN_CHANGE_RESULTS_CMDID,
	WMI_TLV_EXTSCAN_SET_CAPABILITIES_CMDID,
	WMI_TLV_EXTSCAN_GET_CAPABILITIES_CMDID,
	WMI_TLV_SET_DHCP_SERVER_OFFLOAD_CMDID =
			WMI_TLV_CMD(WMI_TLV_GRP_DHCP_OFL),
	WMI_TLV_IPA_OFFLOAD_ENABLE_DISABLE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_IPA),
	WMI_TLV_MDNS_OFFLOAD_ENABLE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_MDNS_OFL),
	WMI_TLV_MDNS_SET_FQDN_CMDID,
	WMI_TLV_MDNS_SET_RESPONSE_CMDID,
	WMI_TLV_MDNS_GET_STATS_CMDID,
	WMI_TLV_SAP_OFL_ENABLE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_SAP_OFL),
};

enum wmi_tlv_event_id {
	WMI_TLV_SERVICE_READY_EVENTID = 0x1,
	WMI_TLV_READY_EVENTID,
	WMI_TLV_SERVICE_AVAILABLE_EVENTID,
	WMI_TLV_SCAN_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_SCAN),
	WMI_TLV_PDEV_TPC_CONFIG_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_PDEV),
	WMI_TLV_CHAN_INFO_EVENTID,
	WMI_TLV_PHYERR_EVENTID,
	WMI_TLV_PDEV_DUMP_EVENTID,
	WMI_TLV_TX_PAUSE_EVENTID,
	WMI_TLV_DFS_RADAR_EVENTID,
	WMI_TLV_PDEV_L1SS_TRACK_EVENTID,
	WMI_TLV_PDEV_TEMPERATURE_EVENTID,
	WMI_TLV_VDEV_START_RESP_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_VDEV),
	WMI_TLV_VDEV_STOPPED_EVENTID,
	WMI_TLV_VDEV_INSTALL_KEY_COMPLETE_EVENTID,
	WMI_TLV_VDEV_MCC_BCN_INTERVAL_CHANGE_REQ_EVENTID,
	WMI_TLV_PEER_STA_KICKOUT_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_PEER),
	WMI_TLV_PEER_INFO_EVENTID,
	WMI_TLV_PEER_TX_FAIL_CNT_THR_EVENTID,
	WMI_TLV_PEER_ESTIMATED_LINKSPEED_EVENTID,
	WMI_TLV_PEER_STATE_EVENTID,
	WMI_TLV_MGMT_RX_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_MGMT),
	WMI_TLV_HOST_SWBA_EVENTID,
	WMI_TLV_TBTTOFFSET_UPDATE_EVENTID,
	WMI_TLV_OFFLOAD_BCN_TX_STATUS_EVENTID,
	WMI_TLV_OFFLOAD_PROB_RESP_TX_STATUS_EVENTID,
	WMI_TLV_MGMT_TX_COMPLETION_EVENTID,
	WMI_TLV_MGMT_TX_BUNDLE_COMPLETION_EVENTID,
	WMI_TLV_TX_DELBA_COMPLETE_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_BA_NEG),
	WMI_TLV_TX_ADDBA_COMPLETE_EVENTID,
	WMI_TLV_BA_RSP_SSN_EVENTID,
	WMI_TLV_AGGR_STATE_TRIG_EVENTID,
	WMI_TLV_ROAM_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_ROAM),
	WMI_TLV_PROFILE_MATCH,
	WMI_TLV_ROAM_SYNCH_EVENTID,
	WMI_TLV_P2P_DISC_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_P2P),
	WMI_TLV_P2P_NOA_EVENTID,
	WMI_TLV_PDEV_RESUME_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_SUSPEND),
	WMI_TLV_WOW_WAKEUP_HOST_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_WOW),
	WMI_TLV_D0_WOW_DISABLE_ACK_EVENTID,
	WMI_TLV_RTT_MEASUREMENT_REPORT_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_RTT),
	WMI_TLV_TSF_MEASUREMENT_REPORT_EVENTID,
	WMI_TLV_RTT_ERROR_REPORT_EVENTID,
	WMI_TLV_STATS_EXT_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_STATS),
	WMI_TLV_IFACE_LINK_STATS_EVENTID,
	WMI_TLV_PEER_LINK_STATS_EVENTID,
	WMI_TLV_RADIO_LINK_STATS_EVENTID,
	WMI_TLV_NLO_MATCH_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_NLO_OFL),
	WMI_TLV_NLO_SCAN_COMPLETE_EVENTID,
	WMI_TLV_APFIND_EVENTID,
	WMI_TLV_GTK_OFFLOAD_STATUS_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_GTK_OFL),
	WMI_TLV_GTK_REKEY_FAIL_EVENTID,
	WMI_TLV_CSA_HANDLING_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_CSA_OFL),
	WMI_TLV_CHATTER_PC_QUERY_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_CHATTER),
	WMI_TLV_ECHO_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_MISC),
	WMI_TLV_PDEV_UTF_EVENTID,
	WMI_TLV_DEBUG_MESG_EVENTID,
	WMI_TLV_UPDATE_STATS_EVENTID,
	WMI_TLV_DEBUG_PRINT_EVENTID,
	WMI_TLV_DCS_INTERFERENCE_EVENTID,
	WMI_TLV_PDEV_QVIT_EVENTID,
	WMI_TLV_WLAN_PROFILE_DATA_EVENTID,
	WMI_TLV_PDEV_FTM_INTG_EVENTID,
	WMI_TLV_WLAN_FREQ_AVOID_EVENTID,
	WMI_TLV_VDEV_GET_KEEPALIVE_EVENTID,
	WMI_TLV_THERMAL_MGMT_EVENTID,
	WMI_TLV_DIAG_DATA_CONTAINER_EVENTID,
	WMI_TLV_HOST_AUTO_SHUTDOWN_EVENTID,
	WMI_TLV_UPDATE_WHAL_MIB_STATS_EVENTID,
	WMI_TLV_UPDATE_VDEV_RATE_STATS_EVENTID,
	WMI_TLV_DIAG_EVENTID,
	WMI_TLV_GPIO_INPUT_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_GPIO),
	WMI_TLV_UPLOADH_EVENTID,
	WMI_TLV_CAPTUREH_EVENTID,
	WMI_TLV_RFKILL_STATE_CHANGE_EVENTID,
	WMI_TLV_TDLS_PEER_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_TDLS),
	WMI_TLV_BATCH_SCAN_ENABLED_EVENTID =
			WMI_TLV_EV(WMI_TLV_GRP_LOCATION_SCAN),
	WMI_TLV_BATCH_SCAN_RESULT_EVENTID,
	WMI_TLV_OEM_CAPABILITY_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_OEM),
	WMI_TLV_OEM_MEASUREMENT_REPORT_EVENTID,
	WMI_TLV_OEM_ERROR_REPORT_EVENTID,
	WMI_TLV_NAN_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_NAN),
	WMI_TLV_LPI_RESULT_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_LPI),
	WMI_TLV_LPI_STATUS_EVENTID,
	WMI_TLV_LPI_HANDOFF_EVENTID,
	WMI_TLV_EXTSCAN_START_STOP_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_EXTSCAN),
	WMI_TLV_EXTSCAN_OPERATION_EVENTID,
	WMI_TLV_EXTSCAN_TABLE_USAGE_EVENTID,
	WMI_TLV_EXTSCAN_CACHED_RESULTS_EVENTID,
	WMI_TLV_EXTSCAN_WLAN_CHANGE_RESULTS_EVENTID,
	WMI_TLV_EXTSCAN_HOTLIST_MATCH_EVENTID,
	WMI_TLV_EXTSCAN_CAPABILITIES_EVENTID,
	WMI_TLV_MDNS_STATS_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_MDNS_OFL),
	WMI_TLV_SAP_OFL_ADD_STA_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_SAP_OFL),
	WMI_TLV_SAP_OFL_DEL_STA_EVENTID,
};

enum wmi_tlv_pdev_param {
	WMI_TLV_PDEV_PARAM_TX_CHAIN_MASK = 0x1,
	WMI_TLV_PDEV_PARAM_RX_CHAIN_MASK,
	WMI_TLV_PDEV_PARAM_TXPOWER_LIMIT2G,
	WMI_TLV_PDEV_PARAM_TXPOWER_LIMIT5G,
	WMI_TLV_PDEV_PARAM_TXPOWER_SCALE,
	WMI_TLV_PDEV_PARAM_BEACON_GEN_MODE,
	WMI_TLV_PDEV_PARAM_BEACON_TX_MODE,
	WMI_TLV_PDEV_PARAM_RESMGR_OFFCHAN_MODE,
	WMI_TLV_PDEV_PARAM_PROTECTION_MODE,
	WMI_TLV_PDEV_PARAM_DYNAMIC_BW,
	WMI_TLV_PDEV_PARAM_NON_AGG_SW_RETRY_TH,
	WMI_TLV_PDEV_PARAM_AGG_SW_RETRY_TH,
	WMI_TLV_PDEV_PARAM_STA_KICKOUT_TH,
	WMI_TLV_PDEV_PARAM_AC_AGGRSIZE_SCALING,
	WMI_TLV_PDEV_PARAM_LTR_ENABLE,
	WMI_TLV_PDEV_PARAM_LTR_AC_LATENCY_BE,
	WMI_TLV_PDEV_PARAM_LTR_AC_LATENCY_BK,
	WMI_TLV_PDEV_PARAM_LTR_AC_LATENCY_VI,
	WMI_TLV_PDEV_PARAM_LTR_AC_LATENCY_VO,
	WMI_TLV_PDEV_PARAM_LTR_AC_LATENCY_TIMEOUT,
	WMI_TLV_PDEV_PARAM_LTR_SLEEP_OVERRIDE,
	WMI_TLV_PDEV_PARAM_LTR_RX_OVERRIDE,
	WMI_TLV_PDEV_PARAM_LTR_TX_ACTIVITY_TIMEOUT,
	WMI_TLV_PDEV_PARAM_L1SS_ENABLE,
	WMI_TLV_PDEV_PARAM_DSLEEP_ENABLE,
	WMI_TLV_PDEV_PARAM_PCIELP_TXBUF_FLUSH,
	WMI_TLV_PDEV_PARAM_PCIELP_TXBUF_WATERMARK,
	WMI_TLV_PDEV_PARAM_PCIELP_TXBUF_TMO_EN,
	WMI_TLV_PDEV_PARAM_PCIELP_TXBUF_TMO_VALUE,
	WMI_TLV_PDEV_PARAM_PDEV_STATS_UPDATE_PERIOD,
	WMI_TLV_PDEV_PARAM_VDEV_STATS_UPDATE_PERIOD,
	WMI_TLV_PDEV_PARAM_PEER_STATS_UPDATE_PERIOD,
	WMI_TLV_PDEV_PARAM_BCNFLT_STATS_UPDATE_PERIOD,
	WMI_TLV_PDEV_PARAM_PMF_QOS,
	WMI_TLV_PDEV_PARAM_ARP_AC_OVERRIDE,
	WMI_TLV_PDEV_PARAM_DCS,
	WMI_TLV_PDEV_PARAM_ANI_ENABLE,
	WMI_TLV_PDEV_PARAM_ANI_POLL_PERIOD,
	WMI_TLV_PDEV_PARAM_ANI_LISTEN_PERIOD,
	WMI_TLV_PDEV_PARAM_ANI_OFDM_LEVEL,
	WMI_TLV_PDEV_PARAM_ANI_CCK_LEVEL,
	WMI_TLV_PDEV_PARAM_DYNTXCHAIN,
	WMI_TLV_PDEV_PARAM_PROXY_STA,
	WMI_TLV_PDEV_PARAM_IDLE_PS_CONFIG,
	WMI_TLV_PDEV_PARAM_POWER_GATING_SLEEP,
	WMI_TLV_PDEV_PARAM_RFKILL_ENABLE,
	WMI_TLV_PDEV_PARAM_BURST_DUR,
	WMI_TLV_PDEV_PARAM_BURST_ENABLE,
	WMI_TLV_PDEV_PARAM_HW_RFKILL_CONFIG,
	WMI_TLV_PDEV_PARAM_LOW_POWER_RF_ENABLE,
	WMI_TLV_PDEV_PARAM_L1SS_TRACK,
	WMI_TLV_PDEV_PARAM_HYST_EN,
	WMI_TLV_PDEV_PARAM_POWER_COLLAPSE_ENABLE,
	WMI_TLV_PDEV_PARAM_LED_SYS_STATE,
	WMI_TLV_PDEV_PARAM_LED_ENABLE,
	WMI_TLV_PDEV_PARAM_AUDIO_OVER_WLAN_LATENCY,
	WMI_TLV_PDEV_PARAM_AUDIO_OVER_WLAN_ENABLE,
	WMI_TLV_PDEV_PARAM_WHAL_MIB_STATS_UPDATE_ENABLE,
	WMI_TLV_PDEV_PARAM_VDEV_RATE_STATS_UPDATE_PERIOD,
	WMI_TLV_PDEV_PARAM_TXPOWER_REASON_NONE,
	WMI_TLV_PDEV_PARAM_TXPOWER_REASON_SAR,
	WMI_TLV_PDEV_PARAM_TXPOWER_REASON_MAX,
};

enum wmi_tlv_vdev_param {
	WMI_TLV_VDEV_PARAM_RTS_THRESHOLD = 0x1,
	WMI_TLV_VDEV_PARAM_FRAGMENTATION_THRESHOLD,
	WMI_TLV_VDEV_PARAM_BEACON_INTERVAL,
	WMI_TLV_VDEV_PARAM_LISTEN_INTERVAL,
	WMI_TLV_VDEV_PARAM_MULTICAST_RATE,
	WMI_TLV_VDEV_PARAM_MGMT_TX_RATE,
	WMI_TLV_VDEV_PARAM_SLOT_TIME,
	WMI_TLV_VDEV_PARAM_PREAMBLE,
	WMI_TLV_VDEV_PARAM_SWBA_TIME,
	WMI_TLV_VDEV_STATS_UPDATE_PERIOD,
	WMI_TLV_VDEV_PWRSAVE_AGEOUT_TIME,
	WMI_TLV_VDEV_HOST_SWBA_INTERVAL,
	WMI_TLV_VDEV_PARAM_DTIM_PERIOD,
	WMI_TLV_VDEV_OC_SCHEDULER_AIR_TIME_LIMIT,
	WMI_TLV_VDEV_PARAM_WDS,
	WMI_TLV_VDEV_PARAM_ATIM_WINDOW,
	WMI_TLV_VDEV_PARAM_BMISS_COUNT_MAX,
	WMI_TLV_VDEV_PARAM_BMISS_FIRST_BCNT,
	WMI_TLV_VDEV_PARAM_BMISS_FINAL_BCNT,
	WMI_TLV_VDEV_PARAM_FEATURE_WMM,
	WMI_TLV_VDEV_PARAM_CHWIDTH,
	WMI_TLV_VDEV_PARAM_CHEXTOFFSET,
	WMI_TLV_VDEV_PARAM_DISABLE_HTPROTECTION,
	WMI_TLV_VDEV_PARAM_STA_QUICKKICKOUT,
	WMI_TLV_VDEV_PARAM_MGMT_RATE,
	WMI_TLV_VDEV_PARAM_PROTECTION_MODE,
	WMI_TLV_VDEV_PARAM_FIXED_RATE,
	WMI_TLV_VDEV_PARAM_SGI,
	WMI_TLV_VDEV_PARAM_LDPC,
	WMI_TLV_VDEV_PARAM_TX_STBC,
	WMI_TLV_VDEV_PARAM_RX_STBC,
	WMI_TLV_VDEV_PARAM_INTRA_BSS_FWD,
	WMI_TLV_VDEV_PARAM_DEF_KEYID,
	WMI_TLV_VDEV_PARAM_NSS,
	WMI_TLV_VDEV_PARAM_BCAST_DATA_RATE,
	WMI_TLV_VDEV_PARAM_MCAST_DATA_RATE,
	WMI_TLV_VDEV_PARAM_MCAST_INDICATE,
	WMI_TLV_VDEV_PARAM_DHCP_INDICATE,
	WMI_TLV_VDEV_PARAM_UNKNOWN_DEST_INDICATE,
	WMI_TLV_VDEV_PARAM_AP_KEEPALIVE_MIN_IDLE_INACTIVE_TIME_SECS,
	WMI_TLV_VDEV_PARAM_AP_KEEPALIVE_MAX_IDLE_INACTIVE_TIME_SECS,
	WMI_TLV_VDEV_PARAM_AP_KEEPALIVE_MAX_UNRESPONSIVE_TIME_SECS,
	WMI_TLV_VDEV_PARAM_AP_ENABLE_NAWDS,
	WMI_TLV_VDEV_PARAM_ENABLE_RTSCTS,
	WMI_TLV_VDEV_PARAM_TXBF,
	WMI_TLV_VDEV_PARAM_PACKET_POWERSAVE,
	WMI_TLV_VDEV_PARAM_DROP_UNENCRY,
	WMI_TLV_VDEV_PARAM_TX_ENCAP_TYPE,
	WMI_TLV_VDEV_PARAM_AP_DETECT_OUT_OF_SYNC_SLEEPING_STA_TIME_SECS,
	WMI_TLV_VDEV_PARAM_EARLY_RX_ADJUST_ENABLE,
	WMI_TLV_VDEV_PARAM_EARLY_RX_TGT_BMISS_NUM,
	WMI_TLV_VDEV_PARAM_EARLY_RX_BMISS_SAMPLE_CYCLE,
	WMI_TLV_VDEV_PARAM_EARLY_RX_SLOP_STEP,
	WMI_TLV_VDEV_PARAM_EARLY_RX_INIT_SLOP,
	WMI_TLV_VDEV_PARAM_EARLY_RX_ADJUST_PAUSE,
	WMI_TLV_VDEV_PARAM_TX_PWRLIMIT,
	WMI_TLV_VDEV_PARAM_SNR_NUM_FOR_CAL,
	WMI_TLV_VDEV_PARAM_ROAM_FW_OFFLOAD,
	WMI_TLV_VDEV_PARAM_ENABLE_RMC,
	WMI_TLV_VDEV_PARAM_IBSS_MAX_BCN_LOST_MS,
	WMI_TLV_VDEV_PARAM_MAX_RATE,
	WMI_TLV_VDEV_PARAM_EARLY_RX_DRIFT_SAMPLE,
	WMI_TLV_VDEV_PARAM_SET_IBSS_TX_FAIL_CNT_THR,
	WMI_TLV_VDEV_PARAM_EBT_RESYNC_TIMEOUT,
	WMI_TLV_VDEV_PARAM_AGGR_TRIG_EVENT_ENABLE,
	WMI_TLV_VDEV_PARAM_IS_IBSS_POWER_SAVE_ALLOWED,
	WMI_TLV_VDEV_PARAM_IS_POWER_COLLAPSE_ALLOWED,
	WMI_TLV_VDEV_PARAM_IS_AWAKE_ON_TXRX_ENABLED,
	WMI_TLV_VDEV_PARAM_INACTIVITY_CNT,
	WMI_TLV_VDEV_PARAM_TXSP_END_INACTIVITY_TIME_MS,
	WMI_TLV_VDEV_PARAM_DTIM_POLICY,
	WMI_TLV_VDEV_PARAM_IBSS_PS_WARMUP_TIME_SECS,
	WMI_TLV_VDEV_PARAM_IBSS_PS_1RX_CHAIN_IN_ATIM_WINDOW_ENABLE,
};

enum wmi_tlv_peer_flags {
	WMI_TLV_PEER_AUTH = 0x00000001,
	WMI_TLV_PEER_QOS = 0x00000002,
	WMI_TLV_PEER_NEED_PTK_4_WAY = 0x00000004,
	WMI_TLV_PEER_NEED_GTK_2_WAY = 0x00000010,
	WMI_TLV_PEER_APSD = 0x00000800,
	WMI_TLV_PEER_HT = 0x00001000,
	WMI_TLV_PEER_40MHZ = 0x00002000,
	WMI_TLV_PEER_STBC = 0x00008000,
	WMI_TLV_PEER_LDPC = 0x00010000,
	WMI_TLV_PEER_DYN_MIMOPS = 0x00020000,
	WMI_TLV_PEER_STATIC_MIMOPS = 0x00040000,
	WMI_TLV_PEER_SPATIAL_MUX = 0x00200000,
	WMI_TLV_PEER_VHT = 0x02000000,
	WMI_TLV_PEER_80MHZ = 0x04000000,
	WMI_TLV_PEER_PMF = 0x08000000,
	WMI_TLV_PEER_160MHZ = 0x20000000,
};

enum wmi_tlv_tag {
	WMI_TLV_TAG_LAST_RESERVED = 15,

	WMI_TLV_TAG_FIRST_ARRAY_ENUM,
	WMI_TLV_TAG_ARRAY_UINT32 = WMI_TLV_TAG_FIRST_ARRAY_ENUM,
	WMI_TLV_TAG_ARRAY_BYTE,
	WMI_TLV_TAG_ARRAY_STRUCT,
	WMI_TLV_TAG_ARRAY_FIXED_STRUCT,
	WMI_TLV_TAG_LAST_ARRAY_ENUM = 31,

	WMI_TLV_TAG_STRUCT_SERVICE_READY_EVENT,
	WMI_TLV_TAG_STRUCT_HAL_REG_CAPABILITIES,
	WMI_TLV_TAG_STRUCT_WLAN_HOST_MEM_REQ,
	WMI_TLV_TAG_STRUCT_READY_EVENT,
	WMI_TLV_TAG_STRUCT_SCAN_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_TPC_CONFIG_EVENT,
	WMI_TLV_TAG_STRUCT_CHAN_INFO_EVENT,
	WMI_TLV_TAG_STRUCT_COMB_PHYERR_RX_HDR,
	WMI_TLV_TAG_STRUCT_VDEV_START_RESPONSE_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_STOPPED_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_INSTALL_KEY_COMPLETE_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_STA_KICKOUT_EVENT,
	WMI_TLV_TAG_STRUCT_MGMT_RX_HDR,
	WMI_TLV_TAG_STRUCT_TBTT_OFFSET_EVENT,
	WMI_TLV_TAG_STRUCT_TX_DELBA_COMPLETE_EVENT,
	WMI_TLV_TAG_STRUCT_TX_ADDBA_COMPLETE_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_EVENT,
	WMI_TLV_TAG_STRUCT_WOW_EVENT_INFO,
	WMI_TLV_TAG_STRUCT_WOW_EVENT_INFO_SECTION_BITMAP,
	WMI_TLV_TAG_STRUCT_RTT_EVENT_HEADER,
	WMI_TLV_TAG_STRUCT_RTT_ERROR_REPORT_EVENT,
	WMI_TLV_TAG_STRUCT_RTT_MEAS_EVENT,
	WMI_TLV_TAG_STRUCT_ECHO_EVENT,
	WMI_TLV_TAG_STRUCT_FTM_INTG_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_GET_KEEPALIVE_EVENT,
	WMI_TLV_TAG_STRUCT_GPIO_INPUT_EVENT,
	WMI_TLV_TAG_STRUCT_CSA_EVENT,
	WMI_TLV_TAG_STRUCT_GTK_OFFLOAD_STATUS_EVENT,
	WMI_TLV_TAG_STRUCT_IGTK_INFO,
	WMI_TLV_TAG_STRUCT_DCS_INTERFERENCE_EVENT,
	WMI_TLV_TAG_STRUCT_ATH_DCS_CW_INT,
	WMI_TLV_TAG_STRUCT_ATH_DCS_WLAN_INT_STAT,
	WMI_TLV_TAG_STRUCT_WLAN_PROFILE_CTX_T,
	WMI_TLV_TAG_STRUCT_WLAN_PROFILE_T,
	WMI_TLV_TAG_STRUCT_PDEV_QVIT_EVENT,
	WMI_TLV_TAG_STRUCT_HOST_SWBA_EVENT,
	WMI_TLV_TAG_STRUCT_TIM_INFO,
	WMI_TLV_TAG_STRUCT_P2P_NOA_INFO,
	WMI_TLV_TAG_STRUCT_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_AVOID_FREQ_RANGES_EVENT,
	WMI_TLV_TAG_STRUCT_AVOID_FREQ_RANGE_DESC,
	WMI_TLV_TAG_STRUCT_GTK_REKEY_FAIL_EVENT,
	WMI_TLV_TAG_STRUCT_INIT_CMD,
	WMI_TLV_TAG_STRUCT_RESOURCE_CONFIG,
	WMI_TLV_TAG_STRUCT_WLAN_HOST_MEMORY_CHUNK,
	WMI_TLV_TAG_STRUCT_START_SCAN_CMD,
	WMI_TLV_TAG_STRUCT_STOP_SCAN_CMD,
	WMI_TLV_TAG_STRUCT_SCAN_CHAN_LIST_CMD,
	WMI_TLV_TAG_STRUCT_CHANNEL,
	WMI_TLV_TAG_STRUCT_PDEV_SET_REGDOMAIN_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_WMM_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_WMM_PARAMS,
	WMI_TLV_TAG_STRUCT_PDEV_SET_QUIET_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_CREATE_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_DELETE_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_START_REQUEST_CMD,
	WMI_TLV_TAG_STRUCT_P2P_NOA_DESCRIPTOR,
	WMI_TLV_TAG_STRUCT_P2P_GO_SET_BEACON_IE,
	WMI_TLV_TAG_STRUCT_GTK_OFFLOAD_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_UP_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_STOP_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_DOWN_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_SET_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_INSTALL_KEY_CMD,
	WMI_TLV_TAG_STRUCT_PEER_CREATE_CMD,
	WMI_TLV_TAG_STRUCT_PEER_DELETE_CMD,
	WMI_TLV_TAG_STRUCT_PEER_FLUSH_TIDS_CMD,
	WMI_TLV_TAG_STRUCT_PEER_SET_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_PEER_ASSOC_COMPLETE_CMD,
	WMI_TLV_TAG_STRUCT_VHT_RATE_SET,
	WMI_TLV_TAG_STRUCT_BCN_TMPL_CMD,
	WMI_TLV_TAG_STRUCT_PRB_TMPL_CMD,
	WMI_TLV_TAG_STRUCT_BCN_PRB_INFO,
	WMI_TLV_TAG_STRUCT_PEER_TID_ADDBA_CMD,
	WMI_TLV_TAG_STRUCT_PEER_TID_DELBA_CMD,
	WMI_TLV_TAG_STRUCT_STA_POWERSAVE_MODE_CMD,
	WMI_TLV_TAG_STRUCT_STA_POWERSAVE_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_STA_DTIM_PS_METHOD_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_SCAN_MODE,
	WMI_TLV_TAG_STRUCT_ROAM_SCAN_RSSI_THRESHOLD,
	WMI_TLV_TAG_STRUCT_ROAM_SCAN_PERIOD,
	WMI_TLV_TAG_STRUCT_ROAM_SCAN_RSSI_CHANGE_THRESHOLD,
	WMI_TLV_TAG_STRUCT_PDEV_SUSPEND_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_RESUME_CMD,
	WMI_TLV_TAG_STRUCT_ADD_BCN_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_RMV_BCN_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_WOW_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_WOW_HOSTWAKEUP_FROM_SLEEP_CMD,
	WMI_TLV_TAG_STRUCT_STA_UAPSD_AUTO_TRIG_CMD,
	WMI_TLV_TAG_STRUCT_STA_UAPSD_AUTO_TRIG_PARAM,
	WMI_TLV_TAG_STRUCT_SET_ARP_NS_OFFLOAD_CMD,
	WMI_TLV_TAG_STRUCT_ARP_OFFLOAD_TUPLE,
	WMI_TLV_TAG_STRUCT_NS_OFFLOAD_TUPLE,
	WMI_TLV_TAG_STRUCT_FTM_INTG_CMD,
	WMI_TLV_TAG_STRUCT_STA_KEEPALIVE_CMD,
	WMI_TLV_TAG_STRUCT_STA_KEEPALVE_ARP_RESPONSE,
	WMI_TLV_TAG_STRUCT_P2P_SET_VENDOR_IE_DATA_CMD,
	WMI_TLV_TAG_STRUCT_AP_PS_PEER_CMD,
	WMI_TLV_TAG_STRUCT_PEER_RATE_RETRY_SCHED_CMD,
	WMI_TLV_TAG_STRUCT_WLAN_PROFILE_TRIGGER_CMD,
	WMI_TLV_TAG_STRUCT_WLAN_PROFILE_SET_HIST_INTVL_CMD,
	WMI_TLV_TAG_STRUCT_WLAN_PROFILE_GET_PROF_DATA_CMD,
	WMI_TLV_TAG_STRUCT_WLAN_PROFILE_ENABLE_PROFILE_ID_CMD,
	WMI_TLV_TAG_STRUCT_WOW_DEL_PATTERN_CMD,
	WMI_TLV_TAG_STRUCT_WOW_ADD_DEL_EVT_CMD,
	WMI_TLV_TAG_STRUCT_RTT_MEASREQ_HEAD,
	WMI_TLV_TAG_STRUCT_RTT_MEASREQ_BODY,
	WMI_TLV_TAG_STRUCT_RTT_TSF_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_SPECTRAL_CONFIGURE_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_SPECTRAL_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_REQUEST_STATS_CMD,
	WMI_TLV_TAG_STRUCT_NLO_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_NLO_CONFIGURED_PARAMETERS,
	WMI_TLV_TAG_STRUCT_CSA_OFFLOAD_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_CSA_OFFLOAD_CHANSWITCH_CMD,
	WMI_TLV_TAG_STRUCT_CHATTER_SET_MODE_CMD,
	WMI_TLV_TAG_STRUCT_ECHO_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_SET_KEEPALIVE_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_GET_KEEPALIVE_CMD,
	WMI_TLV_TAG_STRUCT_FORCE_FW_HANG_CMD,
	WMI_TLV_TAG_STRUCT_GPIO_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_GPIO_OUTPUT_CMD,
	WMI_TLV_TAG_STRUCT_PEER_ADD_WDS_ENTRY_CMD,
	WMI_TLV_TAG_STRUCT_PEER_REMOVE_WDS_ENTRY_CMD,
	WMI_TLV_TAG_STRUCT_BCN_TX_HDR,
	WMI_TLV_TAG_STRUCT_BCN_SEND_FROM_HOST_CMD,
	WMI_TLV_TAG_STRUCT_MGMT_TX_HDR,
	WMI_TLV_TAG_STRUCT_ADDBA_CLEAR_RESP_CMD,
	WMI_TLV_TAG_STRUCT_ADDBA_SEND_CMD,
	WMI_TLV_TAG_STRUCT_DELBA_SEND_CMD,
	WMI_TLV_TAG_STRUCT_ADDBA_SETRESPONSE_CMD,
	WMI_TLV_TAG_STRUCT_SEND_SINGLEAMSDU_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_PKTLOG_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_PKTLOG_DISABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_HT_IE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_VHT_IE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_DSCP_TID_MAP_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_GREEN_AP_PS_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_GET_TPC_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_BASE_MACADDR_CMD,
	WMI_TLV_TAG_STRUCT_PEER_MCAST_GROUP_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_AP_PROFILE,
	WMI_TLV_TAG_STRUCT_AP_PROFILE,
	WMI_TLV_TAG_STRUCT_SCAN_SCH_PRIORITY_TABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_DFS_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_DFS_DISABLE_CMD,
	WMI_TLV_TAG_STRUCT_WOW_ADD_PATTERN_CMD,
	WMI_TLV_TAG_STRUCT_WOW_BITMAP_PATTERN_T,
	WMI_TLV_TAG_STRUCT_WOW_IPV4_SYNC_PATTERN_T,
	WMI_TLV_TAG_STRUCT_WOW_IPV6_SYNC_PATTERN_T,
	WMI_TLV_TAG_STRUCT_WOW_MAGIC_PATTERN_CMD,
	WMI_TLV_TAG_STRUCT_SCAN_UPDATE_REQUEST_CMD,
	WMI_TLV_TAG_STRUCT_CHATTER_PKT_COALESCING_FILTER,
	WMI_TLV_TAG_STRUCT_CHATTER_COALESCING_ADD_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_CHATTER_COALESCING_DELETE_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_CHATTER_COALESCING_QUERY_CMD,
	WMI_TLV_TAG_STRUCT_TXBF_CMD,
	WMI_TLV_TAG_STRUCT_DEBUG_LOG_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_NLO_EVENT,
	WMI_TLV_TAG_STRUCT_CHATTER_QUERY_REPLY_EVENT,
	WMI_TLV_TAG_STRUCT_UPLOAD_H_HDR,
	WMI_TLV_TAG_STRUCT_CAPTURE_H_EVENT_HDR,
	WMI_TLV_TAG_STRUCT_VDEV_WNM_SLEEPMODE_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_IPSEC_NATKEEPALIVE_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_WMM_ADDTS_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_WMM_DELTS_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_SET_WMM_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_TDLS_SET_STATE_CMD,
	WMI_TLV_TAG_STRUCT_TDLS_PEER_UPDATE_CMD,
	WMI_TLV_TAG_STRUCT_TDLS_PEER_EVENT,
	WMI_TLV_TAG_STRUCT_TDLS_PEER_CAPABILITIES,
	WMI_TLV_TAG_STRUCT_VDEV_MCC_SET_TBTT_MODE_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_CHAN_LIST,
	WMI_TLV_TAG_STRUCT_VDEV_MCC_BCN_INTVL_CHANGE_EVENT,
	WMI_TLV_TAG_STRUCT_RESMGR_ADAPTIVE_OCS_CMD,
	WMI_TLV_TAG_STRUCT_RESMGR_SET_CHAN_TIME_QUOTA_CMD,
	WMI_TLV_TAG_STRUCT_RESMGR_SET_CHAN_LATENCY_CMD,
	WMI_TLV_TAG_STRUCT_BA_REQ_SSN_CMD,
	WMI_TLV_TAG_STRUCT_BA_RSP_SSN_EVENT,
	WMI_TLV_TAG_STRUCT_STA_SMPS_FORCE_MODE_CMD,
	WMI_TLV_TAG_STRUCT_SET_MCASTBCAST_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_P2P_SET_OPPPS_CMD,
	WMI_TLV_TAG_STRUCT_P2P_SET_NOA_CMD,
	WMI_TLV_TAG_STRUCT_BA_REQ_SSN_CMD_SUB_STRUCT_PARAM,
	WMI_TLV_TAG_STRUCT_BA_REQ_SSN_EVENT_SUB_STRUCT_PARAM,
	WMI_TLV_TAG_STRUCT_STA_SMPS_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_SET_GTX_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_MCC_SCHED_TRAFFIC_STATS_CMD,
	WMI_TLV_TAG_STRUCT_MCC_SCHED_STA_TRAFFIC_STATS,
	WMI_TLV_TAG_STRUCT_OFFLOAD_BCN_TX_STATUS_EVENT,
	WMI_TLV_TAG_STRUCT_P2P_NOA_EVENT,
	WMI_TLV_TAG_STRUCT_HB_SET_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_HB_SET_TCP_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_HB_SET_TCP_PKT_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_HB_SET_UDP_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_HB_SET_UDP_PKT_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_HB_IND_EVENT,
	WMI_TLV_TAG_STRUCT_TX_PAUSE_EVENT,
	WMI_TLV_TAG_STRUCT_RFKILL_EVENT,
	WMI_TLV_TAG_STRUCT_DFS_RADAR_EVENT,
	WMI_TLV_TAG_STRUCT_DFS_PHYERR_FILTER_ENA_CMD,
	WMI_TLV_TAG_STRUCT_DFS_PHYERR_FILTER_DIS_CMD,
	WMI_TLV_TAG_STRUCT_BATCH_SCAN_RESULT_SCAN_LIST,
	WMI_TLV_TAG_STRUCT_BATCH_SCAN_RESULT_NETWORK_INFO,
	WMI_TLV_TAG_STRUCT_BATCH_SCAN_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_BATCH_SCAN_DISABLE_CMD,
	WMI_TLV_TAG_STRUCT_BATCH_SCAN_TRIGGER_RESULT_CMD,
	WMI_TLV_TAG_STRUCT_BATCH_SCAN_ENABLED_EVENT,
	WMI_TLV_TAG_STRUCT_BATCH_SCAN_RESULT_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_PLMREQ_START_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_PLMREQ_STOP_CMD,
	WMI_TLV_TAG_STRUCT_THERMAL_MGMT_CMD,
	WMI_TLV_TAG_STRUCT_THERMAL_MGMT_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_INFO_REQ_CMD,
	WMI_TLV_TAG_STRUCT_PEER_INFO_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_INFO,
	WMI_TLV_TAG_STRUCT_PEER_TX_FAIL_CNT_THR_EVENT,
	WMI_TLV_TAG_STRUCT_RMC_SET_MODE_CMD,
	WMI_TLV_TAG_STRUCT_RMC_SET_ACTION_PERIOD_CMD,
	WMI_TLV_TAG_STRUCT_RMC_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_MHF_OFFLOAD_SET_MODE_CMD,
	WMI_TLV_TAG_STRUCT_MHF_OFFLOAD_PLUMB_ROUTING_TABLE_CMD,
	WMI_TLV_TAG_STRUCT_ADD_PROACTIVE_ARP_RSP_PATTERN_CMD,
	WMI_TLV_TAG_STRUCT_DEL_PROACTIVE_ARP_RSP_PATTERN_CMD,
	WMI_TLV_TAG_STRUCT_NAN_CMD_PARAM,
	WMI_TLV_TAG_STRUCT_NAN_EVENT_HDR,
	WMI_TLV_TAG_STRUCT_PDEV_L1SS_TRACK_EVENT,
	WMI_TLV_TAG_STRUCT_DIAG_DATA_CONTAINER_EVENT,
	WMI_TLV_TAG_STRUCT_MODEM_POWER_STATE_CMD_PARAM,
	WMI_TLV_TAG_STRUCT_PEER_GET_ESTIMATED_LINKSPEED_CMD,
	WMI_TLV_TAG_STRUCT_PEER_ESTIMATED_LINKSPEED_EVENT,
	WMI_TLV_TAG_STRUCT_AGGR_STATE_TRIG_EVENT,
	WMI_TLV_TAG_STRUCT_MHF_OFFLOAD_ROUTING_TABLE_ENTRY,
	WMI_TLV_TAG_STRUCT_ROAM_SCAN_CMD,
	WMI_TLV_TAG_STRUCT_REQ_STATS_EXT_CMD,
	WMI_TLV_TAG_STRUCT_STATS_EXT_EVENT,
	WMI_TLV_TAG_STRUCT_OBSS_SCAN_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_OBSS_SCAN_DISABLE_CMD,
	WMI_TLV_TAG_STRUCT_OFFLOAD_PRB_RSP_TX_STATUS_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_SET_LED_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_HOST_AUTO_SHUTDOWN_CFG_CMD,
	WMI_TLV_TAG_STRUCT_HOST_AUTO_SHUTDOWN_EVENT,
	WMI_TLV_TAG_STRUCT_UPDATE_WHAL_MIB_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_CHAN_AVOID_UPDATE_CMD_PARAM,
	WMI_TLV_TAG_STRUCT_WOW_ACER_IOAC_PKT_PATTERN_T,
	WMI_TLV_TAG_STRUCT_WOW_ACER_IOAC_TMR_PATTERN_T,
	WMI_TLV_TAG_STRUCT_WOW_IOAC_ADD_KEEPALIVE_CMD,
	WMI_TLV_TAG_STRUCT_WOW_IOAC_DEL_KEEPALIVE_CMD,
	WMI_TLV_TAG_STRUCT_WOW_IOAC_KEEPALIVE_T,
	WMI_TLV_TAG_STRUCT_WOW_ACER_IOAC_ADD_PATTERN_CMD,
	WMI_TLV_TAG_STRUCT_WOW_ACER_IOAC_DEL_PATTERN_CMD,
	WMI_TLV_TAG_STRUCT_START_LINK_STATS_CMD,
	WMI_TLV_TAG_STRUCT_CLEAR_LINK_STATS_CMD,
	WMI_TLV_TAG_STRUCT_REQUEST_LINK_STATS_CMD,
	WMI_TLV_TAG_STRUCT_IFACE_LINK_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_RADIO_LINK_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_CHANNEL_STATS,
	WMI_TLV_TAG_STRUCT_RADIO_LINK_STATS,
	WMI_TLV_TAG_STRUCT_RATE_STATS,
	WMI_TLV_TAG_STRUCT_PEER_LINK_STATS,
	WMI_TLV_TAG_STRUCT_WMM_AC_STATS,
	WMI_TLV_TAG_STRUCT_IFACE_LINK_STATS,
	WMI_TLV_TAG_STRUCT_LPI_MGMT_SNOOPING_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_LPI_START_SCAN_CMD,
	WMI_TLV_TAG_STRUCT_LPI_STOP_SCAN_CMD,
	WMI_TLV_TAG_STRUCT_LPI_RESULT_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_STATE_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_BUCKET_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_BUCKET_CHANNEL_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_START_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_STOP_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_CONFIGURE_WLAN_CHANGE_MONITOR_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_WLAN_CHANGE_BSSID_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_CONFIGURE_HOTLIST_MONITOR_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_GET_CACHED_RESULTS_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_GET_WLAN_CHANGE_RESULTS_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_SET_CAPABILITIES_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_GET_CAPABILITIES_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_OPERATION_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_START_STOP_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_TABLE_USAGE_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_WLAN_DESCRIPTOR_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_RSSI_INFO_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_CACHED_RESULTS_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_WLAN_CHANGE_RESULTS_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_WLAN_CHANGE_RESULT_BSSID_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_HOTLIST_MATCH_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_CAPABILITIES_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_CACHE_CAPABILITIES_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_WLAN_CHANGE_MONITOR_CAPABILITIES_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_HOTLIST_MONITOR_CAPABILITIES_EVENT,
	WMI_TLV_TAG_STRUCT_D0_WOW_ENABLE_DISABLE_CMD,
	WMI_TLV_TAG_STRUCT_D0_WOW_DISABLE_ACK_EVENT,
	WMI_TLV_TAG_STRUCT_UNIT_TEST_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_OFFLOAD_TLV_PARAM,
	WMI_TLV_TAG_STRUCT_ROAM_11I_OFFLOAD_TLV_PARAM,
	WMI_TLV_TAG_STRUCT_ROAM_11R_OFFLOAD_TLV_PARAM,
	WMI_TLV_TAG_STRUCT_ROAM_ESE_OFFLOAD_TLV_PARAM,
	WMI_TLV_TAG_STRUCT_ROAM_SYNCH_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_SYNCH_COMPLETE,
	WMI_TLV_TAG_STRUCT_EXTWOW_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_EXTWOW_SET_APP_TYPE1_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_EXTWOW_SET_APP_TYPE2_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_LPI_STATUS_EVENT,
	WMI_TLV_TAG_STRUCT_LPI_HANDOFF_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_RATE_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_RATE_HT_INFO,
	WMI_TLV_TAG_STRUCT_RIC_REQUEST,
	WMI_TLV_TAG_STRUCT_PDEV_GET_TEMPERATURE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_TEMPERATURE_EVENT,
	WMI_TLV_TAG_STRUCT_SET_DHCP_SERVER_OFFLOAD_CMD,
	WMI_TLV_TAG_STRUCT_TPC_CHAINMASK_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_RIC_TSPEC,
	WMI_TLV_TAG_STRUCT_TPC_CHAINMASK_CONFIG,
	WMI_TLV_TAG_STRUCT_IPA_OFFLOAD_CMD,
	WMI_TLV_TAG_STRUCT_SCAN_PROB_REQ_OUI_CMD,
	WMI_TLV_TAG_STRUCT_KEY_MATERIAL,
	WMI_TLV_TAG_STRUCT_TDLS_SET_OFFCHAN_MODE_CMD,
	WMI_TLV_TAG_STRUCT_SET_LED_FLASHING_CMD,
	WMI_TLV_TAG_STRUCT_MDNS_OFFLOAD_CMD,
	WMI_TLV_TAG_STRUCT_MDNS_SET_FQDN_CMD,
	WMI_TLV_TAG_STRUCT_MDNS_SET_RESP_CMD,
	WMI_TLV_TAG_STRUCT_MDNS_GET_STATS_CMD,
	WMI_TLV_TAG_STRUCT_MDNS_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_INVOKE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_RESUME_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_SET_ANTENNA_DIVERSITY_CMD,
	WMI_TLV_TAG_STRUCT_SAP_OFL_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_SAP_OFL_ADD_STA_EVENT,
	WMI_TLV_TAG_STRUCT_SAP_OFL_DEL_STA_EVENT,
	WMI_TLV_TAG_STRUCT_APFIND_CMD_PARAM,
	WMI_TLV_TAG_STRUCT_APFIND_EVENT_HDR,
	WMI_TLV_TAG_STRUCT_OCB_SET_SCHED_CMD,
	WMI_TLV_TAG_STRUCT_OCB_SET_SCHED_EVENT,
	WMI_TLV_TAG_STRUCT_OCB_SET_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_OCB_SET_CONFIG_RESP_EVENT,
	WMI_TLV_TAG_STRUCT_OCB_SET_UTC_TIME_CMD,
	WMI_TLV_TAG_STRUCT_OCB_START_TIMING_ADVERT_CMD,
	WMI_TLV_TAG_STRUCT_OCB_STOP_TIMING_ADVERT_CMD,
	WMI_TLV_TAG_STRUCT_OCB_GET_TSF_TIMER_CMD,
	WMI_TLV_TAG_STRUCT_OCB_GET_TSF_TIMER_RESP_EVENT,
	WMI_TLV_TAG_STRUCT_DCC_GET_STATS_CMD,
	WMI_TLV_TAG_STRUCT_DCC_CHANNEL_STATS_REQUEST,
	WMI_TLV_TAG_STRUCT_DCC_GET_STATS_RESP_EVENT,
	WMI_TLV_TAG_STRUCT_DCC_CLEAR_STATS_CMD,
	WMI_TLV_TAG_STRUCT_DCC_UPDATE_NDL_CMD,
	WMI_TLV_TAG_STRUCT_DCC_UPDATE_NDL_RESP_EVENT,
	WMI_TLV_TAG_STRUCT_DCC_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_OCB_CHANNEL,
	WMI_TLV_TAG_STRUCT_OCB_SCHEDULE_ELEMENT,
	WMI_TLV_TAG_STRUCT_DCC_NDL_STATS_PER_CHANNEL,
	WMI_TLV_TAG_STRUCT_DCC_NDL_CHAN,
	WMI_TLV_TAG_STRUCT_QOS_PARAMETER,
	WMI_TLV_TAG_STRUCT_DCC_NDL_ACTIVE_STATE_CONFIG,
	WMI_TLV_TAG_STRUCT_ROAM_SCAN_EXTENDED_THRESHOLD_PARAM,
	WMI_TLV_TAG_STRUCT_ROAM_FILTER_FIXED_PARAM,
	WMI_TLV_TAG_STRUCT_PASSPOINT_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_PASSPOINT_EVENT_HDR,
	WMI_TLV_TAG_STRUCT_EXTSCAN_CONFIGURE_HOTLIST_SSID_MONITOR_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_HOTLIST_SSID_MATCH_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_TSF_TSTAMP_ACTION_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_TSF_REPORT_EVENT,
	WMI_TLV_TAG_STRUCT_GET_FW_MEM_DUMP,
	WMI_TLV_TAG_STRUCT_UPDATE_FW_MEM_DUMP,
	WMI_TLV_TAG_STRUCT_FW_MEM_DUMP_PARAMS,
	WMI_TLV_TAG_STRUCT_DEBUG_MESG_FLUSH,
	WMI_TLV_TAG_STRUCT_DEBUG_MESG_FLUSH_COMPLETE,
	WMI_TLV_TAG_STRUCT_PEER_SET_RATE_REPORT_CONDITION,
	WMI_TLV_TAG_STRUCT_ROAM_SUBNET_CHANGE_CONFIG,
	WMI_TLV_TAG_STRUCT_VDEV_SET_IE_CMD,
	WMI_TLV_TAG_STRUCT_RSSI_BREACH_MONITOR_CONFIG,
	WMI_TLV_TAG_STRUCT_RSSI_BREACH_EVENT,
	WMI_TLV_TAG_STRUCT_EVENT_INITIAL_WAKEUP,
	WMI_TLV_TAG_STRUCT_SOC_SET_PCL_CMD,
	WMI_TLV_TAG_STRUCT_SOC_SET_HW_MODE_CMD,
	WMI_TLV_TAG_STRUCT_SOC_SET_HW_MODE_RESPONSE_EVENT,
	WMI_TLV_TAG_STRUCT_SOC_HW_MODE_TRANSITION_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_TXRX_STREAMS,
	WMI_TLV_TAG_STRUCT_SOC_SET_HW_MODE_RESPONSE_VDEV_MAC_ENTRY,
	WMI_TLV_TAG_STRUCT_SOC_SET_DUAL_MAC_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_SOC_SET_DUAL_MAC_CONFIG_RESPONSE_EVENT,
	WMI_TLV_TAG_STRUCT_IOAC_SOCK_PATTERN_T,
	WMI_TLV_TAG_STRUCT_WOW_ENABLE_ICMPV6_NA_FLT_CMD,
	WMI_TLV_TAG_STRUCT_DIAG_EVENT_LOG_CONFIG,
	WMI_TLV_TAG_STRUCT_DIAG_EVENT_LOG_SUPPORTED_EVENT,
	WMI_TLV_TAG_STRUCT_PACKET_FILTER_CONFIG,
	WMI_TLV_TAG_STRUCT_PACKET_FILTER_ENABLE,
	WMI_TLV_TAG_STRUCT_SAP_SET_BLACKLIST_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_MGMT_TX_CMD,
	WMI_TLV_TAG_STRUCT_MGMT_TX_COMPL_EVENT,
	WMI_TLV_TAG_STRUCT_SOC_SET_ANTENNA_MODE_CMD,
	WMI_TLV_TAG_STRUCT_WOW_UDP_SVC_OFLD_CMD,
	WMI_TLV_TAG_STRUCT_LRO_INFO_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_EARLYSTOP_RSSI_THRES_PARAM,
	WMI_TLV_TAG_STRUCT_SERVICE_READY_EXT_EVENT,
	WMI_TLV_TAG_STRUCT_MAWC_SENSOR_REPORT_IND_CMD,
	WMI_TLV_TAG_STRUCT_MAWC_ENABLE_SENSOR_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_CONFIGURE_MAWC_CMD,
	WMI_TLV_TAG_STRUCT_NLO_CONFIGURE_MAWC_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_CONFIGURE_MAWC_CMD,
	WMI_TLV_TAG_STRUCT_PEER_ASSOC_CONF_EVENT,
	WMI_TLV_TAG_STRUCT_WOW_HOSTWAKEUP_GPIO_PIN_PATTERN_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_AP_PS_EGAP_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_AP_PS_EGAP_INFO_EVENT,
	WMI_TLV_TAG_STRUCT_PMF_OFFLOAD_SET_SA_QUERY_CMD,
	WMI_TLV_TAG_STRUCT_TRANSFER_DATA_TO_FLASH_CMD,
	WMI_TLV_TAG_STRUCT_TRANSFER_DATA_TO_FLASH_COMPLETE_EVENT,
	WMI_TLV_TAG_STRUCT_SCPC_EVENT,
	WMI_TLV_TAG_STRUCT_AP_PS_EGAP_INFO_CHAINMASK_LIST,
	WMI_TLV_TAG_STRUCT_STA_SMPS_FORCE_MODE_COMPLETE_EVENT,
	WMI_TLV_TAG_STRUCT_BPF_GET_CAPABILITY_CMD,
	WMI_TLV_TAG_STRUCT_BPF_CAPABILITY_INFO_EVT,
	WMI_TLV_TAG_STRUCT_BPF_GET_VDEV_STATS_CMD,
	WMI_TLV_TAG_STRUCT_BPF_VDEV_STATS_INFO_EVT,
	WMI_TLV_TAG_STRUCT_BPF_SET_VDEV_INSTRUCTIONS_CMD,
	WMI_TLV_TAG_STRUCT_BPF_DEL_VDEV_INSTRUCTIONS_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_DELETE_RESP_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_DELETE_RESP_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_DENSE_THRES_PARAM,
	WMI_TLV_TAG_STRUCT_ENLO_CANDIDATE_SCORE_PARAM,
	WMI_TLV_TAG_STRUCT_PEER_UPDATE_WDS_ENTRY_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_CONFIG_RATEMASK,
	WMI_TLV_TAG_STRUCT_PDEV_FIPS_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SMART_ANT_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SMART_ANT_SET_RX_ANTENNA_CMD,
	WMI_TLV_TAG_STRUCT_PEER_SMART_ANT_SET_TX_ANTENNA_CMD,
	WMI_TLV_TAG_STRUCT_PEER_SMART_ANT_SET_TRAIN_ANTENNA_CMD,
	WMI_TLV_TAG_STRUCT_PEER_SMART_ANT_SET_NODE_CONFIG_OPS_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_ANT_SWITCH_TBL_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_CTL_TABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_MIMOGAIN_TABLE_CMD,
	WMI_TLV_TAG_STRUCT_FWTEST_SET_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_PEER_ATF_REQUEST,
	WMI_TLV_TAG_STRUCT_VDEV_ATF_REQUEST,
	WMI_TLV_TAG_STRUCT_PDEV_GET_ANI_CCK_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_GET_ANI_OFDM_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_INST_RSSI_STATS_RESP,
	WMI_TLV_TAG_STRUCT_MED_UTIL_REPORT_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_STA_PS_STATECHANGE_EVENT,
	WMI_TLV_TAG_STRUCT_WDS_ADDR_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_RATECODE_LIST_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_NFCAL_POWER_ALL_CHANNELS_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_TPC_EVENT,
	WMI_TLV_TAG_STRUCT_ANI_OFDM_EVENT,
	WMI_TLV_TAG_STRUCT_ANI_CCK_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_CHANNEL_HOPPING_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_FIPS_EVENT,
	WMI_TLV_TAG_STRUCT_ATF_PEER_INFO,
	WMI_TLV_TAG_STRUCT_PDEV_GET_TPC_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_FILTER_NRP_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_QBOOST_CFG_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SMART_ANT_GPIO_HANDLE,
	WMI_TLV_TAG_STRUCT_PEER_SMART_ANT_SET_TX_ANTENNA_SERIES,
	WMI_TLV_TAG_STRUCT_PEER_SMART_ANT_SET_TRAIN_ANTENNA_PARAM,
	WMI_TLV_TAG_STRUCT_PDEV_SET_ANT_CTRL_CHAIN,
	WMI_TLV_TAG_STRUCT_PEER_CCK_OFDM_RATE_INFO,
	WMI_TLV_TAG_STRUCT_PEER_MCS_RATE_INFO,
	WMI_TLV_TAG_STRUCT_PDEV_NFCAL_POWER_ALL_CHANNELS_NFDBR,
	WMI_TLV_TAG_STRUCT_PDEV_NFCAL_POWER_ALL_CHANNELS_NFDBM,
	WMI_TLV_TAG_STRUCT_PDEV_NFCAL_POWER_ALL_CHANNELS_FREQNUM,
	WMI_TLV_TAG_STRUCT_MU_REPORT_TOTAL_MU,
	WMI_TLV_TAG_STRUCT_VDEV_SET_DSCP_TID_MAP_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_SET_MBO,
	WMI_TLV_TAG_STRUCT_MIB_STATS_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_NAN_DISC_IFACE_CREATED_EVENT,
	WMI_TLV_TAG_STRUCT_NAN_DISC_IFACE_DELETED_EVENT,
	WMI_TLV_TAG_STRUCT_NAN_STARTED_CLUSTER_EVENT,
	WMI_TLV_TAG_STRUCT_NAN_JOINED_CLUSTER_EVENT,
	WMI_TLV_TAG_STRUCT_NDI_GET_CAP_REQ,
	WMI_TLV_TAG_STRUCT_NDP_INITIATOR_REQ,
	WMI_TLV_TAG_STRUCT_NDP_RESPONDER_REQ,
	WMI_TLV_TAG_STRUCT_NDP_END_REQ,
	WMI_TLV_TAG_STRUCT_NDI_CAP_RSP_EVENT,
	WMI_TLV_TAG_STRUCT_NDP_INITIATOR_RSP_EVENT,
	WMI_TLV_TAG_STRUCT_NDP_RESPONDER_RSP_EVENT,
	WMI_TLV_TAG_STRUCT_NDP_END_RSP_EVENT,
	WMI_TLV_TAG_STRUCT_NDP_INDICATION_EVENT,
	WMI_TLV_TAG_STRUCT_NDP_CONFIRM_EVENT,
	WMI_TLV_TAG_STRUCT_NDP_END_INDICATION_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_SET_QUIET_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_PCL_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_HW_MODE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_MAC_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_ANTENNA_MODE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_HW_MODE_RESPONSE_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_HW_MODE_TRANSITION_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_SET_HW_MODE_RESPONSE_VDEV_MAC_ENTRY,
	WMI_TLV_TAG_STRUCT_PDEV_SET_MAC_CONFIG_RESPONSE_EVENT,
	WMI_TLV_TAG_STRUCT_COEX_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_CONFIG_ENHANCED_MCAST_FILTER,
	WMI_TLV_TAG_STRUCT_CHAN_AVOID_RPT_ALLOW_CMD,
	WMI_TLV_TAG_STRUCT_SET_PERIODIC_CHANNEL_STATS_CONFIG,
	WMI_TLV_TAG_STRUCT_VDEV_SET_CUSTOM_AGGR_SIZE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_WAL_POWER_DEBUG_CMD,
	WMI_TLV_TAG_STRUCT_MAC_PHY_CAPABILITIES,
	WMI_TLV_TAG_STRUCT_HW_MODE_CAPABILITIES,
	WMI_TLV_TAG_STRUCT_SOC_MAC_PHY_HW_MODE_CAPS,
	WMI_TLV_TAG_STRUCT_HAL_REG_CAPABILITIES_EXT,
	WMI_TLV_TAG_STRUCT_SOC_HAL_REG_CAPABILITIES,
	WMI_TLV_TAG_STRUCT_VDEV_WISA_CMD,
	WMI_TLV_TAG_STRUCT_TX_POWER_LEVEL_STATS_EVT,
	WMI_TLV_TAG_STRUCT_SCAN_ADAPTIVE_DWELL_PARAMETERS_TLV,
	WMI_TLV_TAG_STRUCT_SCAN_ADAPTIVE_DWELL_CONFIG,
	WMI_TLV_TAG_STRUCT_WOW_SET_ACTION_WAKE_UP_CMD,
	WMI_TLV_TAG_STRUCT_NDP_END_RSP_PER_NDI,
	WMI_TLV_TAG_STRUCT_PEER_BWF_REQUEST,
	WMI_TLV_TAG_STRUCT_BWF_PEER_INFO,
	WMI_TLV_TAG_STRUCT_DBGLOG_TIME_STAMP_SYNC_CMD,
	WMI_TLV_TAG_STRUCT_RMC_SET_LEADER_CMD,
	WMI_TLV_TAG_STRUCT_RMC_MANUAL_LEADER_EVENT,
	WMI_TLV_TAG_STRUCT_PER_CHAIN_RSSI_STATS,
	WMI_TLV_TAG_STRUCT_RSSI_STATS,
	WMI_TLV_TAG_STRUCT_P2P_LO_START_CMD,
	WMI_TLV_TAG_STRUCT_P2P_LO_STOP_CMD,
	WMI_TLV_TAG_STRUCT_P2P_LO_STOPPED_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_REORDER_QUEUE_SETUP_CMD,
	WMI_TLV_TAG_STRUCT_PEER_REORDER_QUEUE_REMOVE_CMD,
	WMI_TLV_TAG_STRUCT_SET_MULTIPLE_MCAST_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_MGMT_TX_COMPL_BUNDLE_EVENT,
	WMI_TLV_TAG_STRUCT_READ_DATA_FROM_FLASH_CMD,
	WMI_TLV_TAG_STRUCT_READ_DATA_FROM_FLASH_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_SET_REORDER_TIMEOUT_VAL_CMD,
	WMI_TLV_TAG_STRUCT_PEER_SET_RX_BLOCKSIZE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_WAKEUP_CONFIG_CMDID,
	WMI_TLV_TAG_STRUCT_TLV_BUF_LEN_PARAM,
	WMI_TLV_TAG_STRUCT_SERVICE_AVAILABLE_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_ANTDIV_INFO_REQ_CMD,
	WMI_TLV_TAG_STRUCT_PEER_ANTDIV_INFO_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_ANTDIV_INFO,
	WMI_TLV_TAG_STRUCT_PDEV_GET_ANTDIV_STATUS_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_ANTDIV_STATUS_EVENT,
	WMI_TLV_TAG_STRUCT_MNT_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_GET_CHIP_POWER_STATS_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_CHIP_POWER_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_COEX_GET_ANTENNA_ISOLATION_CMD,
	WMI_TLV_TAG_STRUCT_COEX_REPORT_ISOLATION_EVENT,
	WMI_TLV_TAG_STRUCT_CHAN_CCA_STATS,
	WMI_TLV_TAG_STRUCT_PEER_SIGNAL_STATS,
	WMI_TLV_TAG_STRUCT_TX_STATS,
	WMI_TLV_TAG_STRUCT_PEER_AC_TX_STATS,
	WMI_TLV_TAG_STRUCT_RX_STATS,
	WMI_TLV_TAG_STRUCT_PEER_AC_RX_STATS,
	WMI_TLV_TAG_STRUCT_REPORT_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_CHAN_CCA_STATS_THRESH,
	WMI_TLV_TAG_STRUCT_PEER_SIGNAL_STATS_THRESH,
	WMI_TLV_TAG_STRUCT_TX_STATS_THRESH,
	WMI_TLV_TAG_STRUCT_RX_STATS_THRESH,
	WMI_TLV_TAG_STRUCT_PDEV_SET_STATS_THRESHOLD_CMD,
	WMI_TLV_TAG_STRUCT_REQUEST_WLAN_STATS_CMD,
	WMI_TLV_TAG_STRUCT_RX_AGGR_FAILURE_EVENT,
	WMI_TLV_TAG_STRUCT_RX_AGGR_FAILURE_INFO,
	WMI_TLV_TAG_STRUCT_VDEV_ENCRYPT_DECRYPT_DATA_REQ_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_ENCRYPT_DECRYPT_DATA_RESP_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_BAND_TO_MAC,
	WMI_TLV_TAG_STRUCT_TBTT_OFFSET_INFO,
	WMI_TLV_TAG_STRUCT_TBTT_OFFSET_EXT_EVENT,
	WMI_TLV_TAG_STRUCT_SAR_LIMITS_CMD,
	WMI_TLV_TAG_STRUCT_SAR_LIMIT_CMD_ROW,
	WMI_TLV_TAG_STRUCT_PDEV_DFS_PHYERR_OFFLOAD_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_DFS_PHYERR_OFFLOAD_DISABLE_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_ADFS_CH_CFG_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_ADFS_OCAC_ABORT_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_DFS_RADAR_DETECTION_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_ADFS_OCAC_COMPLETE_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_DFS_CAC_COMPLETE_EVENT,
	WMI_TLV_TAG_STRUCT_VENDOR_OUI,
	WMI_TLV_TAG_STRUCT_REQUEST_RCPI_CMD,
	WMI_TLV_TAG_STRUCT_UPDATE_RCPI_EVENT,
	WMI_TLV_TAG_STRUCT_REQUEST_PEER_STATS_INFO_CMD,
	WMI_TLV_TAG_STRUCT_PEER_STATS_INFO,
	WMI_TLV_TAG_STRUCT_PEER_STATS_INFO_EVENT,
	WMI_TLV_TAG_STRUCT_PKGID_EVENT,
	WMI_TLV_TAG_STRUCT_CONNECTED_NLO_RSSI_PARAMS,
	WMI_TLV_TAG_STRUCT_SET_CURRENT_COUNTRY_CMD,
	WMI_TLV_TAG_STRUCT_REGULATORY_RULE_STRUCT,
	WMI_TLV_TAG_STRUCT_REG_CHAN_LIST_CC_EVENT,
	WMI_TLV_TAG_STRUCT_11D_SCAN_START_CMD,
	WMI_TLV_TAG_STRUCT_11D_SCAN_STOP_CMD,
	WMI_TLV_TAG_STRUCT_11D_NEW_COUNTRY_EVENT,
	WMI_TLV_TAG_STRUCT_REQUEST_RADIO_CHAN_STATS_CMD,
	WMI_TLV_TAG_STRUCT_RADIO_CHAN_STATS,
	WMI_TLV_TAG_STRUCT_RADIO_CHAN_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_PER_CONFIG,
	WMI_TLV_TAG_STRUCT_VDEV_ADD_MAC_ADDR_TO_RX_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_ADD_MAC_ADDR_TO_RX_FILTER_STATUS_EVENT,
	WMI_TLV_TAG_STRUCT_BPF_SET_VDEV_ACTIVE_MODE_CMD,
	WMI_TLV_TAG_STRUCT_HW_DATA_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_CONNECTED_NLO_BSS_BAND_RSSI_PREF,
	WMI_TLV_TAG_STRUCT_PEER_OPER_MODE_CHANGE_EVENT,
	WMI_TLV_TAG_STRUCT_CHIP_POWER_SAVE_FAILURE_DETECTED,
	WMI_TLV_TAG_STRUCT_PDEV_MULTIPLE_VDEV_RESTART_REQUEST_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_CSA_SWITCH_COUNT_STATUS_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_UPDATE_PKT_ROUTING_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_CHECK_CAL_VERSION_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_CHECK_CAL_VERSION_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_SET_DIVERSITY_GAIN_CMD,
	WMI_TLV_TAG_STRUCT_MAC_PHY_CHAINMASK_COMBO,
	WMI_TLV_TAG_STRUCT_MAC_PHY_CHAINMASK_CAPABILITY,
	WMI_TLV_TAG_STRUCT_VDEV_SET_ARP_STATS_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_GET_ARP_STATS_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_GET_ARP_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_IFACE_OFFLOAD_STATS,
	WMI_TLV_TAG_STRUCT_REQUEST_STATS_CMD_SUB_STRUCT_PARAM,
	WMI_TLV_TAG_STRUCT_RSSI_CTL_EXT,
	WMI_TLV_TAG_STRUCT_SINGLE_PHYERR_EXT_RX_HDR,
	WMI_TLV_TAG_STRUCT_COEX_BT_ACTIVITY_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_GET_TX_POWER_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_TX_POWER_EVENT,
	WMI_TLV_TAG_STRUCT_OFFCHAN_DATA_TX_COMPL_EVENT,
	WMI_TLV_TAG_STRUCT_OFFCHAN_DATA_TX_SEND_CMD,
	WMI_TLV_TAG_STRUCT_TX_SEND_PARAMS,
	WMI_TLV_TAG_STRUCT_HE_RATE_SET,
	WMI_TLV_TAG_STRUCT_CONGESTION_STATS,
	WMI_TLV_TAG_STRUCT_SET_INIT_COUNTRY_CMD,
	WMI_TLV_TAG_STRUCT_SCAN_DBS_DUTY_CYCLE,
	WMI_TLV_TAG_STRUCT_SCAN_DBS_DUTY_CYCLE_PARAM_TLV,
	WMI_TLV_TAG_STRUCT_PDEV_DIV_GET_RSSI_ANTID,
	WMI_TLV_TAG_STRUCT_THERM_THROT_CONFIG_REQUEST,
	WMI_TLV_TAG_STRUCT_THERM_THROT_LEVEL_CONFIG_INFO,
	WMI_TLV_TAG_STRUCT_THERM_THROT_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_THERM_THROT_LEVEL_STATS_INFO,
	WMI_TLV_TAG_STRUCT_PDEV_DIV_RSSI_ANTID_EVENT,
	WMI_TLV_TAG_STRUCT_OEM_DMA_RING_CAPABILITIES,
	WMI_TLV_TAG_STRUCT_OEM_DMA_RING_CFG_REQ,
	WMI_TLV_TAG_STRUCT_OEM_DMA_RING_CFG_RSP,
	WMI_TLV_TAG_STRUCT_OEM_INDIRECT_DATA,
	WMI_TLV_TAG_STRUCT_OEM_DMA_BUF_RELEASE,
	WMI_TLV_TAG_STRUCT_OEM_DMA_BUF_RELEASE_ENTRY,
	WMI_TLV_TAG_STRUCT_PDEV_BSS_CHAN_INFO_REQUEST,
	WMI_TLV_TAG_STRUCT_PDEV_BSS_CHAN_INFO_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_LCA_DISALLOW_CONFIG_TLV_PARAM,
	WMI_TLV_TAG_STRUCT_VDEV_LIMIT_OFFCHAN_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_RSSI_REJECTION_OCE_CONFIG_PARAM,
	WMI_TLV_TAG_STRUCT_UNIT_TEST_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_FILS_OFFLOAD_TLV_PARAM,
	WMI_TLV_TAG_STRUCT_PDEV_UPDATE_PMK_CACHE_CMD,
	WMI_TLV_TAG_STRUCT_PMK_CACHE,
	WMI_TLV_TAG_STRUCT_PDEV_UPDATE_FILS_HLP_PKT_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_FILS_SYNCH_TLV_PARAM,
	WMI_TLV_TAG_STRUCT_GTK_OFFLOAD_EXTENDED_TLV_PARAM,
	WMI_TLV_TAG_STRUCT_ROAM_BG_SCAN_ROAMING_PARAM,
	WMI_TLV_TAG_STRUCT_OIC_PING_OFFLOAD_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_OIC_PING_OFFLOAD_SET_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_OIC_PING_HANDOFF_EVENT,
	WMI_TLV_TAG_STRUCT_DHCP_LEASE_RENEW_OFFLOAD_CMD,
	WMI_TLV_TAG_STRUCT_DHCP_LEASE_RENEW_EVENT,
	WMI_TLV_TAG_STRUCT_BTM_CONFIG,
	WMI_TLV_TAG_STRUCT_DEBUG_MESG_FW_DATA_STALL_PARAM,
	WMI_TLV_TAG_STRUCT_WLM_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_UPDATE_CTLTABLE_REQUEST,
	WMI_TLV_TAG_STRUCT_PDEV_UPDATE_CTLTABLE_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_CND_SCORING_PARAM,
	WMI_TLV_TAG_STRUCT_PDEV_CONFIG_VENDOR_OUI_ACTION,
	WMI_TLV_TAG_STRUCT_VENDOR_OUI_EXT,
	WMI_TLV_TAG_STRUCT_ROAM_SYNCH_FRAME_EVENT,
	WMI_TLV_TAG_STRUCT_FD_SEND_FROM_HOST_CMD,
	WMI_TLV_TAG_STRUCT_ENABLE_FILS_CMD,
	WMI_TLV_TAG_STRUCT_HOST_SWFDA_EVENT,

	WMI_TLV_TAG_MAX
};

enum wmi_tlv_service {
	WMI_TLV_SERVICE_BEACON_OFFLOAD = 0,
	WMI_TLV_SERVICE_SCAN_OFFLOAD,
	WMI_TLV_SERVICE_ROAM_SCAN_OFFLOAD,
	WMI_TLV_SERVICE_BCN_MISS_OFFLOAD,
	WMI_TLV_SERVICE_STA_PWRSAVE,
	WMI_TLV_SERVICE_STA_ADVANCED_PWRSAVE,
	WMI_TLV_SERVICE_AP_UAPSD,
	WMI_TLV_SERVICE_AP_DFS,
	WMI_TLV_SERVICE_11AC,
	WMI_TLV_SERVICE_BLOCKACK,
	WMI_TLV_SERVICE_PHYERR,
	WMI_TLV_SERVICE_BCN_FILTER,
	WMI_TLV_SERVICE_RTT,
	WMI_TLV_SERVICE_WOW,
	WMI_TLV_SERVICE_RATECTRL_CACHE,
	WMI_TLV_SERVICE_IRAM_TIDS,
	WMI_TLV_SERVICE_ARPNS_OFFLOAD,
	WMI_TLV_SERVICE_NLO,
	WMI_TLV_SERVICE_GTK_OFFLOAD,
	WMI_TLV_SERVICE_SCAN_SCH,
	WMI_TLV_SERVICE_CSA_OFFLOAD,
	WMI_TLV_SERVICE_CHATTER,
	WMI_TLV_SERVICE_COEX_FREQAVOID,
	WMI_TLV_SERVICE_PACKET_POWER_SAVE,
	WMI_TLV_SERVICE_FORCE_FW_HANG,
	WMI_TLV_SERVICE_GPIO,
	WMI_TLV_SERVICE_STA_DTIM_PS_MODULATED_DTIM,
	WMI_TLV_SERVICE_STA_UAPSD_BASIC_AUTO_TRIG,
	WMI_TLV_SERVICE_STA_UAPSD_VAR_AUTO_TRIG,
	WMI_TLV_SERVICE_STA_KEEP_ALIVE,
	WMI_TLV_SERVICE_TX_ENCAP,
	WMI_TLV_SERVICE_AP_PS_DETECT_OUT_OF_SYNC,
	WMI_TLV_SERVICE_EARLY_RX,
	WMI_TLV_SERVICE_STA_SMPS,
	WMI_TLV_SERVICE_FWTEST,
	WMI_TLV_SERVICE_STA_WMMAC,
	WMI_TLV_SERVICE_TDLS,
	WMI_TLV_SERVICE_BURST,
	WMI_TLV_SERVICE_MCC_BCN_INTERVAL_CHANGE,
	WMI_TLV_SERVICE_ADAPTIVE_OCS,
	WMI_TLV_SERVICE_BA_SSN_SUPPORT,
	WMI_TLV_SERVICE_FILTER_IPSEC_NATKEEPALIVE,
	WMI_TLV_SERVICE_WLAN_HB,
	WMI_TLV_SERVICE_LTE_ANT_SHARE_SUPPORT,
	WMI_TLV_SERVICE_BATCH_SCAN,
	WMI_TLV_SERVICE_QPOWER,
	WMI_TLV_SERVICE_PLMREQ,
	WMI_TLV_SERVICE_THERMAL_MGMT,
	WMI_TLV_SERVICE_RMC,
	WMI_TLV_SERVICE_MHF_OFFLOAD,
	WMI_TLV_SERVICE_COEX_SAR,
	WMI_TLV_SERVICE_BCN_TXRATE_OVERRIDE,
	WMI_TLV_SERVICE_NAN,
	WMI_TLV_SERVICE_L1SS_STAT,
	WMI_TLV_SERVICE_ESTIMATE_LINKSPEED,
	WMI_TLV_SERVICE_OBSS_SCAN,
	WMI_TLV_SERVICE_TDLS_OFFCHAN,
	WMI_TLV_SERVICE_TDLS_UAPSD_BUFFER_STA,
	WMI_TLV_SERVICE_TDLS_UAPSD_SLEEP_STA,
	WMI_TLV_SERVICE_IBSS_PWRSAVE,
	WMI_TLV_SERVICE_LPASS,
	WMI_TLV_SERVICE_EXTSCAN,
	WMI_TLV_SERVICE_D0WOW,
	WMI_TLV_SERVICE_HSOFFLOAD,
	WMI_TLV_SERVICE_ROAM_HO_OFFLOAD,
	WMI_TLV_SERVICE_RX_FULL_REORDER,
	WMI_TLV_SERVICE_DHCP_OFFLOAD,
	WMI_TLV_SERVICE_STA_RX_IPA_OFFLOAD_SUPPORT,
	WMI_TLV_SERVICE_MDNS_OFFLOAD,
	WMI_TLV_SERVICE_SAP_AUTH_OFFLOAD,
	WMI_TLV_SERVICE_DUAL_BAND_SIMULTANEOUS_SUPPORT,
	WMI_TLV_SERVICE_OCB,
	WMI_TLV_SERVICE_AP_ARPNS_OFFLOAD,
	WMI_TLV_SERVICE_PER_BAND_CHAINMASK_SUPPORT,
	WMI_TLV_SERVICE_PACKET_FILTER_OFFLOAD,
	WMI_TLV_SERVICE_MGMT_TX_HTT,
	WMI_TLV_SERVICE_MGMT_TX_WMI,
	WMI_TLV_SERVICE_EXT_MSG,
	WMI_TLV_SERVICE_MAWC,
	WMI_TLV_SERVICE_PEER_ASSOC_CONF,
	WMI_TLV_SERVICE_EGAP,
	WMI_TLV_SERVICE_STA_PMF_OFFLOAD,
	WMI_TLV_SERVICE_UNIFIED_WOW_CAPABILITY,
	WMI_TLV_SERVICE_ENHANCED_PROXY_STA,
	WMI_TLV_SERVICE_ATF,
	WMI_TLV_SERVICE_COEX_GPIO,
	WMI_TLV_SERVICE_AUX_SPECTRAL_INTF,
	WMI_TLV_SERVICE_AUX_CHAN_LOAD_INTF,
	WMI_TLV_SERVICE_BSS_CHANNEL_INFO_64,
	WMI_TLV_SERVICE_ENTERPRISE_MESH,
	WMI_TLV_SERVICE_RESTRT_CHNL_SUPPORT,
	WMI_TLV_SERVICE_BPF_OFFLOAD,
	WMI_TLV_SERVICE_SYNC_DELETE_CMDS,
	WMI_TLV_SERVICE_SMART_ANTENNA_SW_SUPPORT,
	WMI_TLV_SERVICE_SMART_ANTENNA_HW_SUPPORT,
	WMI_TLV_SERVICE_RATECTRL_LIMIT_MAX_MIN_RATES,
	WMI_TLV_SERVICE_NAN_DATA,
	WMI_TLV_SERVICE_NAN_RTT,
	WMI_TLV_SERVICE_11AX,
	WMI_TLV_SERVICE_DEPRECATED_REPLACE,
	WMI_TLV_SERVICE_TDLS_CONN_TRACKER_IN_HOST_MODE,
	WMI_TLV_SERVICE_ENHANCED_MCAST_FILTER,
	WMI_TLV_SERVICE_PERIODIC_CHAN_STAT_SUPPORT,
	WMI_TLV_SERVICE_MESH_11S,
	WMI_TLV_SERVICE_HALF_RATE_QUARTER_RATE_SUPPORT,
	WMI_TLV_SERVICE_VDEV_RX_FILTER,
	WMI_TLV_SERVICE_P2P_LISTEN_OFFLOAD_SUPPORT,
	WMI_TLV_SERVICE_MARK_FIRST_WAKEUP_PACKET,
	WMI_TLV_SERVICE_MULTIPLE_MCAST_FILTER_SET,
	WMI_TLV_SERVICE_HOST_MANAGED_RX_REORDER,
	WMI_TLV_SERVICE_FLASH_RDWR_SUPPORT,
	WMI_TLV_SERVICE_WLAN_STATS_REPORT,
	WMI_TLV_SERVICE_TX_MSDU_ID_NEW_PARTITION_SUPPORT,
	WMI_TLV_SERVICE_DFS_PHYERR_OFFLOAD,
	WMI_TLV_SERVICE_RCPI_SUPPORT,
	WMI_TLV_SERVICE_FW_MEM_DUMP_SUPPORT,
	WMI_TLV_SERVICE_PEER_STATS_INFO,
	WMI_TLV_SERVICE_REGULATORY_DB,
	WMI_TLV_SERVICE_11D_OFFLOAD,
	WMI_TLV_SERVICE_HW_DATA_FILTERING,
	WMI_TLV_SERVICE_MULTIPLE_VDEV_RESTART,
	WMI_TLV_SERVICE_PKT_ROUTING,
	WMI_TLV_SERVICE_CHECK_CAL_VERSION,
	WMI_TLV_SERVICE_OFFCHAN_TX_WMI,
	WMI_TLV_SERVICE_8SS_TX_BFEE,
	WMI_TLV_SERVICE_EXTENDED_NSS_SUPPORT,
	WMI_TLV_SERVICE_ACK_TIMEOUT,
	WMI_TLV_SERVICE_PDEV_BSS_CHANNEL_INFO_64,
	WMI_TLV_MAX_SERVICE = 128,

/* NOTE:
 * The above service flags are delivered in the wmi_service_bitmap field
 * of the WMI_TLV_SERVICE_READY_EVENT message.
 * The below service flags are delivered in a WMI_TLV_SERVICE_AVAILABLE_EVENT
 * message rather than in the WMI_TLV_SERVICE_READY_EVENT message's
 * wmi_service_bitmap field.
 * The WMI_TLV_SERVICE_AVAILABLE_EVENT message immediately precedes the
 * WMI_TLV_SERVICE_READY_EVENT message.
 */

	WMI_TLV_SERVICE_CHAN_LOAD_INFO = 128,
	WMI_TLV_SERVICE_TX_PPDU_INFO_STATS_SUPPORT,
	WMI_TLV_SERVICE_VDEV_LIMIT_OFFCHAN_SUPPORT,
	WMI_TLV_SERVICE_FILS_SUPPORT,
	WMI_TLV_SERVICE_WLAN_OIC_PING_OFFLOAD,
	WMI_TLV_SERVICE_WLAN_DHCP_RENEW,
	WMI_TLV_SERVICE_MAWC_SUPPORT,
	WMI_TLV_SERVICE_VDEV_LATENCY_CONFIG,
	WMI_TLV_SERVICE_PDEV_UPDATE_CTLTABLE_SUPPORT,
	WMI_TLV_SERVICE_PKTLOG_SUPPORT_OVER_HTT,
	WMI_TLV_SERVICE_VDEV_MULTI_GROUP_KEY_SUPPORT,
	WMI_TLV_SERVICE_SCAN_PHYMODE_SUPPORT,
	WMI_TLV_SERVICE_THERM_THROT,
	WMI_TLV_SERVICE_BCN_OFFLOAD_START_STOP_SUPPORT,
	WMI_TLV_SERVICE_WOW_WAKEUP_BY_TIMER_PATTERN,
	WMI_TLV_SERVICE_PEER_MAP_UNMAP_V2_SUPPORT = 143,
	WMI_TLV_SERVICE_OFFCHAN_DATA_TID_SUPPORT = 144,
	WMI_TLV_SERVICE_RX_PROMISC_ENABLE_SUPPORT = 145,
	WMI_TLV_SERVICE_SUPPORT_DIRECT_DMA = 146,
	WMI_TLV_SERVICE_AP_OBSS_DETECTION_OFFLOAD = 147,
	WMI_TLV_SERVICE_11K_NEIGHBOUR_REPORT_SUPPORT = 148,
	WMI_TLV_SERVICE_LISTEN_INTERVAL_OFFLOAD_SUPPORT = 149,
	WMI_TLV_SERVICE_BSS_COLOR_OFFLOAD = 150,
	WMI_TLV_SERVICE_RUNTIME_DPD_RECAL = 151,
	WMI_TLV_SERVICE_STA_TWT = 152,
	WMI_TLV_SERVICE_AP_TWT = 153,
	WMI_TLV_SERVICE_GMAC_OFFLOAD_SUPPORT = 154,
	WMI_TLV_SERVICE_SPOOF_MAC_SUPPORT = 155,
	WMI_TLV_SERVICE_PEER_TID_CONFIGS_SUPPORT = 156,
	WMI_TLV_SERVICE_VDEV_SWRETRY_PER_AC_CONFIG_SUPPORT = 157,
	WMI_TLV_SERVICE_DUAL_BEACON_ON_SINGLE_MAC_SCC_SUPPORT = 158,
	WMI_TLV_SERVICE_DUAL_BEACON_ON_SINGLE_MAC_MCC_SUPPORT = 159,
	WMI_TLV_SERVICE_MOTION_DET = 160,
	WMI_TLV_SERVICE_INFRA_MBSSID = 161,
	WMI_TLV_SERVICE_OBSS_SPATIAL_REUSE = 162,
	WMI_TLV_SERVICE_VDEV_DIFFERENT_BEACON_INTERVAL_SUPPORT = 163,
	WMI_TLV_SERVICE_NAN_DBS_SUPPORT = 164,
	WMI_TLV_SERVICE_NDI_DBS_SUPPORT = 165,
	WMI_TLV_SERVICE_NAN_SAP_SUPPORT = 166,
	WMI_TLV_SERVICE_NDI_SAP_SUPPORT = 167,
	WMI_TLV_SERVICE_CFR_CAPTURE_SUPPORT = 168,
	WMI_TLV_SERVICE_CFR_CAPTURE_IND_MSG_TYPE_1 = 169,
	WMI_TLV_SERVICE_ESP_SUPPORT = 170,
	WMI_TLV_SERVICE_PEER_CHWIDTH_CHANGE = 171,
	WMI_TLV_SERVICE_WLAN_HPCS_PULSE = 172,
	WMI_TLV_SERVICE_PER_VDEV_CHAINMASK_CONFIG_SUPPORT = 173,
	WMI_TLV_SERVICE_TX_DATA_MGMT_ACK_RSSI = 174,

	WMI_TLV_MAX_EXT_SERVICE = 256,
};

#define WMI_TLV_EXT_SERVICE_IS_ENABLED(wmi_svc_bmap, svc_id, len) \
	((svc_id) < (WMI_TLV_MAX_EXT_SERVICE) && \
	 (svc_id) >= (len) && \
	__le32_to_cpu((wmi_svc_bmap)[((svc_id) - (len)) / 32]) & \
	BIT(((((svc_id) - (len)) % 32) & 0x1f)))

#define SVCMAP(x, y, len) \
	do { \
		if ((WMI_SERVICE_IS_ENABLED((in), (x), (len))) || \
			(WMI_TLV_EXT_SERVICE_IS_ENABLED((in), (x), (len)))) \
			__set_bit(y, out); \
	} while (0)

static inline void
wmi_tlv_svc_map(const __le32 *in, unsigned long *out, size_t len)
{
	SVCMAP(WMI_TLV_SERVICE_BEACON_OFFLOAD,
	       WMI_SERVICE_BEACON_OFFLOAD, len);
	SVCMAP(WMI_TLV_SERVICE_SCAN_OFFLOAD,
	       WMI_SERVICE_SCAN_OFFLOAD, len);
	SVCMAP(WMI_TLV_SERVICE_ROAM_SCAN_OFFLOAD,
	       WMI_SERVICE_ROAM_SCAN_OFFLOAD, len);
	SVCMAP(WMI_TLV_SERVICE_BCN_MISS_OFFLOAD,
	       WMI_SERVICE_BCN_MISS_OFFLOAD, len);
	SVCMAP(WMI_TLV_SERVICE_STA_PWRSAVE,
	       WMI_SERVICE_STA_PWRSAVE, len);
	SVCMAP(WMI_TLV_SERVICE_STA_ADVANCED_PWRSAVE,
	       WMI_SERVICE_STA_ADVANCED_PWRSAVE, len);
	SVCMAP(WMI_TLV_SERVICE_AP_UAPSD,
	       WMI_SERVICE_AP_UAPSD, len);
	SVCMAP(WMI_TLV_SERVICE_AP_DFS,
	       WMI_SERVICE_AP_DFS, len);
	SVCMAP(WMI_TLV_SERVICE_11AC,
	       WMI_SERVICE_11AC, len);
	SVCMAP(WMI_TLV_SERVICE_BLOCKACK,
	       WMI_SERVICE_BLOCKACK, len);
	SVCMAP(WMI_TLV_SERVICE_PHYERR,
	       WMI_SERVICE_PHYERR, len);
	SVCMAP(WMI_TLV_SERVICE_BCN_FILTER,
	       WMI_SERVICE_BCN_FILTER, len);
	SVCMAP(WMI_TLV_SERVICE_RTT,
	       WMI_SERVICE_RTT, len);
	SVCMAP(WMI_TLV_SERVICE_WOW,
	       WMI_SERVICE_WOW, len);
	SVCMAP(WMI_TLV_SERVICE_RATECTRL_CACHE,
	       WMI_SERVICE_RATECTRL_CACHE, len);
	SVCMAP(WMI_TLV_SERVICE_IRAM_TIDS,
	       WMI_SERVICE_IRAM_TIDS, len);
	SVCMAP(WMI_TLV_SERVICE_ARPNS_OFFLOAD,
	       WMI_SERVICE_ARPNS_OFFLOAD, len);
	SVCMAP(WMI_TLV_SERVICE_NLO,
	       WMI_SERVICE_NLO, len);
	SVCMAP(WMI_TLV_SERVICE_GTK_OFFLOAD,
	       WMI_SERVICE_GTK_OFFLOAD, len);
	SVCMAP(WMI_TLV_SERVICE_SCAN_SCH,
	       WMI_SERVICE_SCAN_SCH, len);
	SVCMAP(WMI_TLV_SERVICE_CSA_OFFLOAD,
	       WMI_SERVICE_CSA_OFFLOAD, len);
	SVCMAP(WMI_TLV_SERVICE_CHATTER,
	       WMI_SERVICE_CHATTER, len);
	SVCMAP(WMI_TLV_SERVICE_COEX_FREQAVOID,
	       WMI_SERVICE_COEX_FREQAVOID, len);
	SVCMAP(WMI_TLV_SERVICE_PACKET_POWER_SAVE,
	       WMI_SERVICE_PACKET_POWER_SAVE, len);
	SVCMAP(WMI_TLV_SERVICE_FORCE_FW_HANG,
	       WMI_SERVICE_FORCE_FW_HANG, len);
	SVCMAP(WMI_TLV_SERVICE_GPIO,
	       WMI_SERVICE_GPIO, len);
	SVCMAP(WMI_TLV_SERVICE_STA_DTIM_PS_MODULATED_DTIM,
	       WMI_SERVICE_STA_DTIM_PS_MODULATED_DTIM, len);
	SVCMAP(WMI_TLV_SERVICE_STA_UAPSD_BASIC_AUTO_TRIG,
	       WMI_SERVICE_STA_UAPSD_BASIC_AUTO_TRIG, len);
	SVCMAP(WMI_TLV_SERVICE_STA_UAPSD_VAR_AUTO_TRIG,
	       WMI_SERVICE_STA_UAPSD_VAR_AUTO_TRIG, len);
	SVCMAP(WMI_TLV_SERVICE_STA_KEEP_ALIVE,
	       WMI_SERVICE_STA_KEEP_ALIVE, len);
	SVCMAP(WMI_TLV_SERVICE_TX_ENCAP,
	       WMI_SERVICE_TX_ENCAP, len);
	SVCMAP(WMI_TLV_SERVICE_AP_PS_DETECT_OUT_OF_SYNC,
	       WMI_SERVICE_AP_PS_DETECT_OUT_OF_SYNC, len);
	SVCMAP(WMI_TLV_SERVICE_EARLY_RX,
	       WMI_SERVICE_EARLY_RX, len);
	SVCMAP(WMI_TLV_SERVICE_STA_SMPS,
	       WMI_SERVICE_STA_SMPS, len);
	SVCMAP(WMI_TLV_SERVICE_FWTEST,
	       WMI_SERVICE_FWTEST, len);
	SVCMAP(WMI_TLV_SERVICE_STA_WMMAC,
	       WMI_SERVICE_STA_WMMAC, len);
	SVCMAP(WMI_TLV_SERVICE_TDLS,
	       WMI_SERVICE_TDLS, len);
	SVCMAP(WMI_TLV_SERVICE_BURST,
	       WMI_SERVICE_BURST, len);
	SVCMAP(WMI_TLV_SERVICE_MCC_BCN_INTERVAL_CHANGE,
	       WMI_SERVICE_MCC_BCN_INTERVAL_CHANGE, len);
	SVCMAP(WMI_TLV_SERVICE_ADAPTIVE_OCS,
	       WMI_SERVICE_ADAPTIVE_OCS, len);
	SVCMAP(WMI_TLV_SERVICE_BA_SSN_SUPPORT,
	       WMI_SERVICE_BA_SSN_SUPPORT, len);
	SVCMAP(WMI_TLV_SERVICE_FILTER_IPSEC_NATKEEPALIVE,
	       WMI_SERVICE_FILTER_IPSEC_NATKEEPALIVE, len);
	SVCMAP(WMI_TLV_SERVICE_WLAN_HB,
	       WMI_SERVICE_WLAN_HB, len);
	SVCMAP(WMI_TLV_SERVICE_LTE_ANT_SHARE_SUPPORT,
	       WMI_SERVICE_LTE_ANT_SHARE_SUPPORT, len);
	SVCMAP(WMI_TLV_SERVICE_BATCH_SCAN,
	       WMI_SERVICE_BATCH_SCAN, len);
	SVCMAP(WMI_TLV_SERVICE_QPOWER,
	       WMI_SERVICE_QPOWER, len);
	SVCMAP(WMI_TLV_SERVICE_PLMREQ,
	       WMI_SERVICE_PLMREQ, len);
	SVCMAP(WMI_TLV_SERVICE_THERMAL_MGMT,
	       WMI_SERVICE_THERMAL_MGMT, len);
	SVCMAP(WMI_TLV_SERVICE_RMC,
	       WMI_SERVICE_RMC, len);
	SVCMAP(WMI_TLV_SERVICE_MHF_OFFLOAD,
	       WMI_SERVICE_MHF_OFFLOAD, len);
	SVCMAP(WMI_TLV_SERVICE_COEX_SAR,
	       WMI_SERVICE_COEX_SAR, len);
	SVCMAP(WMI_TLV_SERVICE_BCN_TXRATE_OVERRIDE,
	       WMI_SERVICE_BCN_TXRATE_OVERRIDE, len);
	SVCMAP(WMI_TLV_SERVICE_NAN,
	       WMI_SERVICE_NAN, len);
	SVCMAP(WMI_TLV_SERVICE_L1SS_STAT,
	       WMI_SERVICE_L1SS_STAT, len);
	SVCMAP(WMI_TLV_SERVICE_ESTIMATE_LINKSPEED,
	       WMI_SERVICE_ESTIMATE_LINKSPEED, len);
	SVCMAP(WMI_TLV_SERVICE_OBSS_SCAN,
	       WMI_SERVICE_OBSS_SCAN, len);
	SVCMAP(WMI_TLV_SERVICE_TDLS_OFFCHAN,
	       WMI_SERVICE_TDLS_OFFCHAN, len);
	SVCMAP(WMI_TLV_SERVICE_TDLS_UAPSD_BUFFER_STA,
	       WMI_SERVICE_TDLS_UAPSD_BUFFER_STA, len);
	SVCMAP(WMI_TLV_SERVICE_TDLS_UAPSD_SLEEP_STA,
	       WMI_SERVICE_TDLS_UAPSD_SLEEP_STA, len);
	SVCMAP(WMI_TLV_SERVICE_IBSS_PWRSAVE,
	       WMI_SERVICE_IBSS_PWRSAVE, len);
	SVCMAP(WMI_TLV_SERVICE_LPASS,
	       WMI_SERVICE_LPASS, len);
	SVCMAP(WMI_TLV_SERVICE_EXTSCAN,
	       WMI_SERVICE_EXTSCAN, len);
	SVCMAP(WMI_TLV_SERVICE_D0WOW,
	       WMI_SERVICE_D0WOW, len);
	SVCMAP(WMI_TLV_SERVICE_HSOFFLOAD,
	       WMI_SERVICE_HSOFFLOAD, len);
	SVCMAP(WMI_TLV_SERVICE_ROAM_HO_OFFLOAD,
	       WMI_SERVICE_ROAM_HO_OFFLOAD, len);
	SVCMAP(WMI_TLV_SERVICE_RX_FULL_REORDER,
	       WMI_SERVICE_RX_FULL_REORDER, len);
	SVCMAP(WMI_TLV_SERVICE_DHCP_OFFLOAD,
	       WMI_SERVICE_DHCP_OFFLOAD, len);
	SVCMAP(WMI_TLV_SERVICE_STA_RX_IPA_OFFLOAD_SUPPORT,
	       WMI_SERVICE_STA_RX_IPA_OFFLOAD_SUPPORT, len);
	SVCMAP(WMI_TLV_SERVICE_MDNS_OFFLOAD,
	       WMI_SERVICE_MDNS_OFFLOAD, len);
	SVCMAP(WMI_TLV_SERVICE_SAP_AUTH_OFFLOAD,
	       WMI_SERVICE_SAP_AUTH_OFFLOAD, len);
	SVCMAP(WMI_TLV_SERVICE_MGMT_TX_WMI,
	       WMI_SERVICE_MGMT_TX_WMI, len);
}

static inline void
wmi_tlv_svc_map_ext(const __le32 *in, unsigned long *out, size_t len)
{
	SVCMAP(WMI_TLV_SERVICE_SPOOF_MAC_SUPPORT,
	       WMI_SERVICE_SPOOF_MAC_SUPPORT,
	       WMI_TLV_MAX_SERVICE);
	SVCMAP(WMI_TLV_SERVICE_THERM_THROT,
	       WMI_SERVICE_THERM_THROT,
	       WMI_TLV_MAX_SERVICE);
	SVCMAP(WMI_TLV_SERVICE_TX_DATA_MGMT_ACK_RSSI,
	       WMI_SERVICE_TX_DATA_ACK_RSSI, WMI_TLV_MAX_SERVICE);
}

#undef SVCMAP

struct wmi_tlv {
	__le16 len;
	__le16 tag;
	u8 value[0];
} __packed;

struct ath10k_mgmt_tx_pkt_addr {
	void *vaddr;
	dma_addr_t paddr;
};

struct chan_info_params {
	u32 err_code;
	u32 freq;
	u32 cmd_flags;
	u32 noise_floor;
	u32 rx_clear_count;
	u32 cycle_count;
	u32 mac_clk_mhz;
};

#define WMI_TLV_FLAG_MGMT_BUNDLE_TX_COMPL	BIT(9)

struct wmi_tlv_mgmt_tx_compl_ev {
	__le32 desc_id;
	__le32 status;
	__le32 pdev_id;
	__le32 ppdu_id;
	__le32 ack_rssi;
};

#define WMI_TLV_MGMT_RX_NUM_RSSI 4

struct wmi_tlv_mgmt_rx_ev {
	__le32 channel;
	__le32 snr;
	__le32 rate;
	__le32 phy_mode;
	__le32 buf_len;
	__le32 status;
	__le32 rssi[WMI_TLV_MGMT_RX_NUM_RSSI];
} __packed;

struct wmi_tlv_abi_version {
	__le32 abi_ver0;
	__le32 abi_ver1;
	__le32 abi_ver_ns0;
	__le32 abi_ver_ns1;
	__le32 abi_ver_ns2;
	__le32 abi_ver_ns3;
} __packed;

enum wmi_tlv_hw_bd_id {
	WMI_TLV_HW_BD_LEGACY = 0,
	WMI_TLV_HW_BD_QCA6174 = 1,
	WMI_TLV_HW_BD_QCA2582 = 2,
};

struct wmi_tlv_hw_bd_info {
	u8 rev;
	u8 project_id;
	u8 custom_id;
	u8 reference_design_id;
} __packed;

struct wmi_tlv_svc_rdy_ev {
	__le32 fw_build_vers;
	struct wmi_tlv_abi_version abi;
	__le32 phy_capability;
	__le32 max_frag_entry;
	__le32 num_rf_chains;
	__le32 ht_cap_info;
	__le32 vht_cap_info;
	__le32 vht_supp_mcs;
	__le32 hw_min_tx_power;
	__le32 hw_max_tx_power;
	__le32 sys_cap_info;
	__le32 min_pkt_size_enable;
	__le32 max_bcn_ie_size;
	__le32 num_mem_reqs;
	__le32 max_num_scan_chans;
	__le32 hw_bd_id; /* 0 means hw_bd_info is invalid */
	struct wmi_tlv_hw_bd_info hw_bd_info[5];
} __packed;

struct wmi_tlv_rdy_ev {
	struct wmi_tlv_abi_version abi;
	struct wmi_mac_addr mac_addr;
	__le32 status;
} __packed;

struct wmi_tlv_resource_config {
	__le32 num_vdevs;
	__le32 num_peers;
	__le32 num_offload_peers;
	__le32 num_offload_reorder_bufs;
	__le32 num_peer_keys;
	__le32 num_tids;
	__le32 ast_skid_limit;
	__le32 tx_chain_mask;
	__le32 rx_chain_mask;
	__le32 rx_timeout_pri[4];
	__le32 rx_decap_mode;
	__le32 scan_max_pending_reqs;
	__le32 bmiss_offload_max_vdev;
	__le32 roam_offload_max_vdev;
	__le32 roam_offload_max_ap_profiles;
	__le32 num_mcast_groups;
	__le32 num_mcast_table_elems;
	__le32 mcast2ucast_mode;
	__le32 tx_dbg_log_size;
	__le32 num_wds_entries;
	__le32 dma_burst_size;
	__le32 mac_aggr_delim;
	__le32 rx_skip_defrag_timeout_dup_detection_check;
	__le32 vow_config;
	__le32 gtk_offload_max_vdev;
	__le32 num_msdu_desc;
	__le32 max_frag_entries;
	__le32 num_tdls_vdevs;
	__le32 num_tdls_conn_table_entries;
	__le32 beacon_tx_offload_max_vdev;
	__le32 num_multicast_filter_entries;
	__le32 num_wow_filters;
	__le32 num_keep_alive_pattern;
	__le32 keep_alive_pattern_size;
	__le32 max_tdls_concurrent_sleep_sta;
	__le32 max_tdls_concurrent_buffer_sta;
	__le32 wmi_send_separate;
	__le32 num_ocb_vdevs;
	__le32 num_ocb_channels;
	__le32 num_ocb_schedules;
	__le32 host_capab;
} __packed;

struct wmi_tlv_init_cmd {
	struct wmi_tlv_abi_version abi;
	__le32 num_host_mem_chunks;
} __packed;

struct wmi_tlv_pdev_get_temp_cmd {
	__le32 pdev_id; /* not used */
} __packed;

struct wmi_tlv_pdev_temperature_event {
	__le32 tlv_hdr;
	/* temperature value in Celcius degree */
	__le32 temperature;
	__le32 pdev_id;
} __packed;

struct wmi_tlv_pdev_set_param_cmd {
	__le32 pdev_id; /* not used yet */
	__le32 param_id;
	__le32 param_value;
} __packed;

struct wmi_tlv_pdev_set_rd_cmd {
	__le32 pdev_id; /* not used yet */
	__le32 regd;
	__le32 regd_2ghz;
	__le32 regd_5ghz;
	__le32 conform_limit_2ghz;
	__le32 conform_limit_5ghz;
} __packed;

struct wmi_tlv_scan_chan_list_cmd {
	__le32 num_scan_chans;
} __packed;

struct wmi_scan_prob_req_oui_cmd {
/* OUI to be used in Probe Request frame when random MAC address is
 * requested part of scan parameters. This is applied to both FW internal
 * scans and host initiated scans. Host can request for random MAC address
 * with WMI_SCAN_ADD_SPOOFED_MAC_IN_PROBE_REQ flag.
 */
	__le32 prob_req_oui;
}  __packed;

struct wmi_tlv_start_scan_cmd {
	struct wmi_start_scan_common common;
	__le32 burst_duration_ms;
	__le32 num_channels;
	__le32 num_bssids;
	__le32 num_ssids;
	__le32 ie_len;
	__le32 num_probes;
	struct wmi_mac_addr mac_addr;
	struct wmi_mac_addr mac_mask;
} __packed;

struct wmi_tlv_vdev_start_cmd {
	__le32 vdev_id;
	__le32 requestor_id;
	__le32 bcn_intval;
	__le32 dtim_period;
	__le32 flags;
	struct wmi_ssid ssid;
	__le32 bcn_tx_rate;
	__le32 bcn_tx_power;
	__le32 num_noa_descr;
	__le32 disable_hw_ack;
} __packed;

enum {
	WMI_TLV_PEER_TYPE_DEFAULT = 0, /* generic / non-BSS / self-peer */
	WMI_TLV_PEER_TYPE_BSS = 1,
	WMI_TLV_PEER_TYPE_TDLS = 2,
	WMI_TLV_PEER_TYPE_HOST_MAX = 127,
	WMI_TLV_PEER_TYPE_ROAMOFFLOAD_TMP = 128,
};

struct wmi_tlv_peer_create_cmd {
	__le32 vdev_id;
	struct wmi_mac_addr peer_addr;
	__le32 peer_type;
} __packed;

struct wmi_tlv_peer_assoc_cmd {
	struct wmi_mac_addr mac_addr;
	__le32 vdev_id;
	__le32 new_assoc;
	__le32 assoc_id;
	__le32 flags;
	__le32 caps;
	__le32 listen_intval;
	__le32 ht_caps;
	__le32 max_mpdu;
	__le32 mpdu_density;
	__le32 rate_caps;
	__le32 nss;
	__le32 vht_caps;
	__le32 phy_mode;
	__le32 ht_info[2];
	__le32 num_legacy_rates;
	__le32 num_ht_rates;
} __packed;

struct wmi_tlv_pdev_suspend {
	__le32 pdev_id; /* not used yet */
	__le32 opt;
} __packed;

struct wmi_tlv_pdev_set_wmm_cmd {
	__le32 pdev_id; /* not used yet */
	__le32 dg_type; /* no idea.. */
} __packed;

struct wmi_tlv_vdev_wmm_params {
	__le32 dummy;
	struct wmi_wmm_params params;
} __packed;

struct wmi_tlv_vdev_set_wmm_cmd {
	__le32 vdev_id;
	struct wmi_tlv_vdev_wmm_params vdev_wmm_params[4];
} __packed;

struct wmi_tlv_phyerr_ev {
	__le32 num_phyerrs;
	__le32 tsf_l32;
	__le32 tsf_u32;
	__le32 buf_len;
} __packed;

enum wmi_tlv_dbglog_param {
	WMI_TLV_DBGLOG_PARAM_LOG_LEVEL = 1,
	WMI_TLV_DBGLOG_PARAM_VDEV_ENABLE,
	WMI_TLV_DBGLOG_PARAM_VDEV_DISABLE,
	WMI_TLV_DBGLOG_PARAM_VDEV_ENABLE_BITMAP,
	WMI_TLV_DBGLOG_PARAM_VDEV_DISABLE_BITMAP,
};

enum wmi_tlv_dbglog_log_level {
	WMI_TLV_DBGLOG_LOG_LEVEL_VERBOSE = 0,
	WMI_TLV_DBGLOG_LOG_LEVEL_INFO,
	WMI_TLV_DBGLOG_LOG_LEVEL_INFO_LVL_1,
	WMI_TLV_DBGLOG_LOG_LEVEL_INFO_LVL_2,
	WMI_TLV_DBGLOG_LOG_LEVEL_WARN,
	WMI_TLV_DBGLOG_LOG_LEVEL_ERR,
};

#define WMI_TLV_DBGLOG_BITMAP_MAX_IDS 512
#define WMI_TLV_DBGLOG_BITMAP_MAX_WORDS (WMI_TLV_DBGLOG_BITMAP_MAX_IDS / \
					 sizeof(__le32))
#define WMI_TLV_DBGLOG_ALL_MODULES 0xffff
#define WMI_TLV_DBGLOG_LOG_LEVEL_VALUE(module_id, log_level) \
		(((module_id << 16) & 0xffff0000) | \
		 ((log_level <<  0) & 0x000000ff))

struct wmi_tlv_dbglog_cmd {
	__le32 param;
	__le32 value;
} __packed;

struct wmi_tlv_resume_cmd {
	__le32 reserved;
} __packed;

struct wmi_tlv_req_stats_cmd {
	__le32 stats_id; /* wmi_stats_id */
	__le32 vdev_id;
	struct wmi_mac_addr peer_macaddr;
} __packed;

#define WMI_TLV_PEER_RX_DURATION_HIGH_VALID_BIT	31
#define WMI_TLV_PEER_RX_DURATION_HIGH_MASK	GENMASK(30, 0)
#define WMI_TLV_PEER_RX_DURATION_SHIFT		32

struct wmi_tlv_peer_stats_extd {
	struct wmi_mac_addr peer_macaddr;
	__le32 rx_duration;
	__le32 peer_tx_bytes;
	__le32 peer_rx_bytes;
	__le32 last_tx_rate_code;
	__le32 last_tx_power;
	__le32 rx_mc_bc_cnt;
	__le32 rx_duration_high;
	__le32 reserved[2];
} __packed;

struct wmi_tlv_vdev_stats {
	__le32 vdev_id;
	__le32 beacon_snr;
	__le32 data_snr;
	__le32 num_tx_frames[4]; /* per-AC */
	__le32 num_rx_frames;
	__le32 num_tx_frames_retries[4];
	__le32 num_tx_frames_failures[4];
	__le32 num_rts_fail;
	__le32 num_rts_success;
	__le32 num_rx_err;
	__le32 num_rx_discard;
	__le32 num_tx_not_acked;
	__le32 tx_rate_history[10];
	__le32 beacon_rssi_history[10];
} __packed;

struct wmi_tlv_pktlog_enable {
	__le32 reserved;
	__le32 filter;
} __packed;

struct wmi_tlv_pktlog_disable {
	__le32 reserved;
} __packed;

enum wmi_tlv_bcn_tx_status {
	WMI_TLV_BCN_TX_STATUS_OK,
	WMI_TLV_BCN_TX_STATUS_XRETRY,
	WMI_TLV_BCN_TX_STATUS_DROP,
	WMI_TLV_BCN_TX_STATUS_FILTERED,
};

struct wmi_tlv_bcn_tx_status_ev {
	__le32 vdev_id;
	__le32 tx_status;
} __packed;

struct wmi_tlv_bcn_prb_info {
	__le32 caps;
	__le32 erp;
	u8 ies[0];
} __packed;

struct wmi_tlv_bcn_tmpl_cmd {
	__le32 vdev_id;
	__le32 tim_ie_offset;
	__le32 buf_len;
} __packed;

struct wmi_tlv_prb_tmpl_cmd {
	__le32 vdev_id;
	__le32 buf_len;
} __packed;

struct wmi_tlv_p2p_go_bcn_ie {
	__le32 vdev_id;
	__le32 ie_len;
} __packed;

enum wmi_tlv_diag_item_type {
	WMI_TLV_DIAG_ITEM_TYPE_FW_EVENT,
	WMI_TLV_DIAG_ITEM_TYPE_FW_LOG,
	WMI_TLV_DIAG_ITEM_TYPE_FW_DEBUG_MSG,
};

struct wmi_tlv_diag_item {
	u8 type;
	u8 reserved;
	__le16 len;
	__le32 timestamp;
	__le32 code;
	u8 payload[0];
} __packed;

struct wmi_tlv_diag_data_ev {
	__le32 num_items;
} __packed;

struct wmi_tlv_sta_keepalive_cmd {
	__le32 vdev_id;
	__le32 enabled;
	__le32 method; /* WMI_STA_KEEPALIVE_METHOD_ */
	__le32 interval; /* in seconds */
} __packed;

struct wmi_tlv_stats_ev {
	__le32 stats_id; /* WMI_STAT_ */
	__le32 num_pdev_stats;
	__le32 num_vdev_stats;
	__le32 num_peer_stats;
	__le32 num_bcnflt_stats;
	__le32 num_chan_stats;
	__le32 num_mib_stats;
	__le32 pdev_id;
	__le32 num_bcn_stats;
	__le32 num_peer_stats_extd;
} __packed;

struct wmi_tlv_p2p_noa_ev {
	__le32 vdev_id;
} __packed;

struct wmi_tlv_roam_ev {
	__le32 vdev_id;
	__le32 reason;
	__le32 rssi;
} __packed;

struct wmi_tlv_wow_add_del_event_cmd {
	__le32 vdev_id;
	__le32 is_add;
	__le32 event_bitmap;
} __packed;

/* Command to set/unset chip in quiet mode */
struct wmi_tlv_set_quiet_cmd {
	__le32 vdev_id;

	/* in TUs */
	__le32 period;

	/* in TUs */
	__le32 duration;

	/* offset in TUs */
	__le32 next_start;
	__le32 enabled;
} __packed;

enum wmi_tlv_wow_interface_cfg {
	WOW_IFACE_PAUSE_ENABLED,
	WOW_IFACE_PAUSE_DISABLED
};

struct wmi_tlv_wow_enable_cmd {
	__le32 enable;
	__le32 pause_iface_config;
	__le32 flags;
} __packed;

struct wmi_tlv_wow_host_wakeup_ind {
	__le32 reserved;
} __packed;

struct wmi_tlv_wow_event_info {
	__le32 vdev_id;
	__le32 flag;
	__le32 wake_reason;
	__le32 data_len;
} __packed;

enum wmi_tlv_pattern_type {
	WOW_PATTERN_MIN = 0,
	WOW_BITMAP_PATTERN = WOW_PATTERN_MIN,
	WOW_IPV4_SYNC_PATTERN,
	WOW_IPV6_SYNC_PATTERN,
	WOW_WILD_CARD_PATTERN,
	WOW_TIMER_PATTERN,
	WOW_MAGIC_PATTERN,
	WOW_IPV6_RA_PATTERN,
	WOW_IOAC_PKT_PATTERN,
	WOW_IOAC_TMR_PATTERN,
	WOW_PATTERN_MAX
};

#define WOW_DEFAULT_BITMAP_PATTERN_SIZE		148
#define WOW_DEFAULT_BITMASK_SIZE		148

struct wmi_tlv_wow_bitmap_pattern {
	u8 patternbuf[WOW_DEFAULT_BITMAP_PATTERN_SIZE];
	u8 bitmaskbuf[WOW_DEFAULT_BITMASK_SIZE];
	__le32 pattern_offset;
	__le32 pattern_len;
	__le32 bitmask_len;
	__le32 pattern_id;
} __packed;

struct wmi_tlv_wow_add_pattern_cmd {
	__le32 vdev_id;
	__le32 pattern_id;
	__le32 pattern_type;
} __packed;

struct wmi_tlv_wow_del_pattern_cmd {
	__le32 vdev_id;
	__le32 pattern_id;
	__le32 pattern_type;
} __packed;

/* TDLS Options */
enum wmi_tlv_tdls_options {
	WMI_TLV_TDLS_OFFCHAN_EN = BIT(0),
	WMI_TLV_TDLS_BUFFER_STA_EN = BIT(1),
	WMI_TLV_TDLS_SLEEP_STA_EN = BIT(2),
};

struct wmi_tdls_set_state_cmd {
	__le32 vdev_id;
	__le32 state;
	__le32 notification_interval_ms;
	__le32 tx_discovery_threshold;
	__le32 tx_teardown_threshold;
	__le32 rssi_teardown_threshold;
	__le32 rssi_delta;
	__le32 tdls_options;
	__le32 tdls_peer_traffic_ind_window;
	__le32 tdls_peer_traffic_response_timeout_ms;
	__le32 tdls_puapsd_mask;
	__le32 tdls_puapsd_inactivity_time_ms;
	__le32 tdls_puapsd_rx_frame_threshold;
} __packed;

struct wmi_tdls_peer_update_cmd {
	__le32 vdev_id;
	struct wmi_mac_addr peer_macaddr;
	__le32 peer_state;
} __packed;

enum {
	WMI_TLV_TDLS_PEER_QOS_AC_VO = BIT(0),
	WMI_TLV_TDLS_PEER_QOS_AC_VI = BIT(1),
	WMI_TLV_TDLS_PEER_QOS_AC_BK = BIT(2),
	WMI_TLV_TDLS_PEER_QOS_AC_BE = BIT(3),
};

#define WMI_TLV_TDLS_PEER_SP_MASK	0x60
#define WMI_TLV_TDLS_PEER_SP_LSB	5

struct wmi_tdls_peer_capab {
	__le32 peer_qos;
	__le32 buff_sta_support;
	__le32 off_chan_support;
	__le32 peer_curr_operclass;
	__le32 self_curr_operclass;
	__le32 peer_chan_len;
	__le32 peer_operclass_len;
	u8 peer_operclass[WMI_TDLS_MAX_SUPP_OPER_CLASSES];
	__le32 is_peer_responder;
	__le32 pref_offchan_num;
	__le32 pref_offchan_bw;
} __packed;

struct wmi_tlv_adaptive_qcs {
	__le32 enable;
} __packed;

/**
 * wmi_tlv_tx_pause_id - firmware tx queue pause reason types
 *
 * @WMI_TLV_TX_PAUSE_ID_MCC: used for by multi-channel firmware scheduler.
 *		Only vdev_map is valid.
 * @WMI_TLV_TX_PAUSE_ID_AP_PEER_PS: peer in AP mode is asleep.
 *		Only peer_id is valid.
 * @WMI_TLV_TX_PAUSE_ID_AP_PEER_UAPSD: Only peer_id and tid_map are valid.
 * @WMI_TLV_TX_PAUSE_ID_P2P_CLI_NOA: Only vdev_map is valid.
 * @WMI_TLV_TX_PAUSE_ID_P2P_GO_PS: Only vdev_map is valid.
 * @WMI_TLV_TX_PAUSE_ID_STA_ADD_BA: Only peer_id and tid_map are valid.
 * @WMI_TLV_TX_PAUSE_ID_AP_PS: When all peers are asleep in AP mode. Only
 *		vdev_map is valid.
 * @WMI_TLV_TX_PAUSE_ID_IBSS_PS: When all peers are asleep in IBSS mode. Only
 *		vdev_map is valid.
 * @WMI_TLV_TX_PAUSE_ID_HOST: Host itself requested tx pause.
 */
enum wmi_tlv_tx_pause_id {
	WMI_TLV_TX_PAUSE_ID_MCC = 1,
	WMI_TLV_TX_PAUSE_ID_AP_PEER_PS = 2,
	WMI_TLV_TX_PAUSE_ID_AP_PEER_UAPSD = 3,
	WMI_TLV_TX_PAUSE_ID_P2P_CLI_NOA = 4,
	WMI_TLV_TX_PAUSE_ID_P2P_GO_PS = 5,
	WMI_TLV_TX_PAUSE_ID_STA_ADD_BA = 6,
	WMI_TLV_TX_PAUSE_ID_AP_PS = 7,
	WMI_TLV_TX_PAUSE_ID_IBSS_PS = 8,
	WMI_TLV_TX_PAUSE_ID_HOST = 21,
};

enum wmi_tlv_tx_pause_action {
	WMI_TLV_TX_PAUSE_ACTION_STOP,
	WMI_TLV_TX_PAUSE_ACTION_WAKE,
};

struct wmi_tlv_tx_pause_ev {
	__le32 pause_id;
	__le32 action;
	__le32 vdev_map;
	__le32 peer_id;
	__le32 tid_map;
} __packed;

struct wmi_tlv_tdls_peer_event {
	struct wmi_mac_addr    peer_macaddr;
	__le32 peer_status;
	__le32 peer_reason;
	__le32 vdev_id;
} __packed;

void ath10k_wmi_tlv_attach(struct ath10k *ar);

enum wmi_nlo_auth_algorithm {
	WMI_NLO_AUTH_ALGO_80211_OPEN        = 1,
	WMI_NLO_AUTH_ALGO_80211_SHARED_KEY  = 2,
	WMI_NLO_AUTH_ALGO_WPA               = 3,
	WMI_NLO_AUTH_ALGO_WPA_PSK           = 4,
	WMI_NLO_AUTH_ALGO_WPA_NONE          = 5,
	WMI_NLO_AUTH_ALGO_RSNA              = 6,
	WMI_NLO_AUTH_ALGO_RSNA_PSK          = 7,
};

enum wmi_nlo_cipher_algorithm {
	WMI_NLO_CIPHER_ALGO_NONE           = 0x00,
	WMI_NLO_CIPHER_ALGO_WEP40          = 0x01,
	WMI_NLO_CIPHER_ALGO_TKIP           = 0x02,
	WMI_NLO_CIPHER_ALGO_CCMP           = 0x04,
	WMI_NLO_CIPHER_ALGO_WEP104         = 0x05,
	WMI_NLO_CIPHER_ALGO_BIP            = 0x06,
	WMI_NLO_CIPHER_ALGO_RSN_USE_GROUP  = 0x100,
	WMI_NLO_CIPHER_ALGO_WEP            = 0x101,
};

/* SSID broadcast  type passed in NLO params */
enum wmi_nlo_ssid_bcastnwtype {
	WMI_NLO_BCAST_UNKNOWN      = 0,
	WMI_NLO_BCAST_NORMAL       = 1,
	WMI_NLO_BCAST_HIDDEN       = 2,
};

#define WMI_NLO_MAX_SSIDS    16
#define WMI_NLO_MAX_CHAN     48

#define WMI_NLO_CONFIG_STOP                             (0x1 << 0)
#define WMI_NLO_CONFIG_START                            (0x1 << 1)
#define WMI_NLO_CONFIG_RESET                            (0x1 << 2)
#define WMI_NLO_CONFIG_SLOW_SCAN                        (0x1 << 4)
#define WMI_NLO_CONFIG_FAST_SCAN                        (0x1 << 5)
#define WMI_NLO_CONFIG_SSID_HIDE_EN                     (0x1 << 6)

/* This bit is used to indicate if EPNO or supplicant PNO is enabled.
 * Only one of them can be enabled at a given time
 */
#define WMI_NLO_CONFIG_ENLO                             (0x1 << 7)
#define WMI_NLO_CONFIG_SCAN_PASSIVE                     (0x1 << 8)
#define WMI_NLO_CONFIG_ENLO_RESET                       (0x1 << 9)
#define WMI_NLO_CONFIG_SPOOFED_MAC_IN_PROBE_REQ         (0x1 << 10)
#define WMI_NLO_CONFIG_RANDOM_SEQ_NO_IN_PROBE_REQ       (0x1 << 11)
#define WMI_NLO_CONFIG_ENABLE_IE_WHITELIST_IN_PROBE_REQ (0x1 << 12)
#define WMI_NLO_CONFIG_ENABLE_CNLO_RSSI_CONFIG          (0x1 << 13)

/* Whether directed scan needs to be performed (for hidden SSIDs) */
#define WMI_ENLO_FLAG_DIRECTED_SCAN      1

/* Whether PNO event shall be triggered if the network is found on A band */
#define WMI_ENLO_FLAG_A_BAND             2

/* Whether PNO event shall be triggered if the network is found on G band */
#define WMI_ENLO_FLAG_G_BAND             4

/* Whether strict matching is required (i.e. firmware shall not
 * match on the entire SSID)
 */
#define WMI_ENLO_FLAG_STRICT_MATCH       8

/* Code for matching the beacon AUTH IE - additional codes TBD */
/* open */
#define WMI_ENLO_AUTH_CODE_OPEN  1

/* WPA_PSK or WPA2PSK */
#define WMI_ENLO_AUTH_CODE_PSK   2

/* any EAPOL */
#define WMI_ENLO_AUTH_CODE_EAPOL 4

struct wmi_nlo_ssid_param {
	__le32 valid;
	struct wmi_ssid ssid;
} __packed;

struct wmi_nlo_enc_param {
	__le32 valid;
	__le32 enc_type;
} __packed;

struct wmi_nlo_auth_param {
	__le32 valid;
	__le32 auth_type;
} __packed;

struct wmi_nlo_bcast_nw_param {
	__le32 valid;

	/* If WMI_NLO_CONFIG_EPNO is not set. Supplicant PNO is enabled.
	 * The value should be true/false. Otherwise EPNO is enabled.
	 * bcast_nw_type would be used as a bit flag contains WMI_ENLO_FLAG_XXX
	 */
	__le32 bcast_nw_type;
} __packed;

struct wmi_nlo_rssi_param {
	__le32 valid;
	__le32 rssi;
} __packed;

struct nlo_configured_parameters {
	/* TLV tag and len;*/
	__le32 tlv_header;
	struct wmi_nlo_ssid_param ssid;
	struct wmi_nlo_enc_param enc_type;
	struct wmi_nlo_auth_param auth_type;
	struct wmi_nlo_rssi_param rssi_cond;

	/* indicates if the SSID is hidden or not */
	struct wmi_nlo_bcast_nw_param bcast_nw_type;
} __packed;

/* Support channel prediction for PNO scan after scanning top_k_num channels
 * if stationary_threshold is met.
 */
struct nlo_channel_prediction_cfg {
	__le32 tlv_header;

	/* Enable or disable this feature. */
	__le32 enable;

	/* Top K channels will be scanned before deciding whether to further scan
	 * or stop. Minimum value is 3 and maximum is 5.
	 */
	__le32 top_k_num;

	/* Preconfigured stationary threshold.
	 * Lesser value means more conservative. Bigger value means more aggressive.
	 * Maximum is 100 and mininum is 0.
	 */
	__le32 stationary_threshold;

	/* Periodic full channel scan in milliseconds unit.
	 * After full_scan_period_ms since last full scan, channel prediction
	 * scan is suppressed and will do full scan.
	 * This is to help detecting sudden AP power-on or -off. Value 0 means no
	 * full scan at all (not recommended).
	 */
	__le32 full_scan_period_ms;
} __packed;

struct enlo_candidate_score_params_t {
	__le32 tlv_header;   /* TLV tag and len; */

	/* minimum 5GHz RSSI for a BSSID to be considered (units = dBm) */
	__le32 min_5ghz_rssi;

	/* minimum 2.4GHz RSSI for a BSSID to be considered (units = dBm) */
	__le32 min_24ghz_rssi;

	/* the maximum score that a network can have before bonuses */
	__le32 initial_score_max;

	/* current_connection_bonus:
	 * only report when there is a network's score this much higher
	 * than the current connection
	 */
	__le32 current_connection_bonus;

	/* score bonus for all networks with the same network flag */
	__le32 same_network_bonus;

	/* score bonus for networks that are not open */
	__le32 secure_bonus;

	/* 5GHz RSSI score bonus (applied to all 5GHz networks) */
	__le32 band_5ghz_bonus;
} __packed;

struct connected_nlo_bss_band_rssi_pref_t {
	__le32 tlv_header; /* TLV tag and len;*/

	/* band which needs to get preference over other band
	 * - see wmi_set_vdev_ie_band enum
	 */
	__le32 band;

	/* Amount of RSSI preference (in dB) that can be given to a band */
	__le32 rssi_pref;
} __packed;

struct connected_nlo_rssi_params_t {
	__le32 tlv_header; /* TLV tag and len;*/

	/* Relative rssi threshold (in dB) by which new BSS should have
	 * better rssi than the current connected BSS.
	 */
	__le32 relative_rssi;

	/* The amount of rssi preference (in dB) that can be given
	 * to a 5G BSS over 2.4G BSS.
	 */
	__le32 relative_rssi_5g_pref;
} __packed;

struct wmi_tlv_wow_nlo_config_cmd {
	__le32 flags;
	__le32 vdev_id;
	__le32 fast_scan_max_cycles;
	__le32 active_dwell_time;
	__le32 passive_dwell_time; /* PDT in msecs */
	__le32 probe_bundle_size;

	/* ART = IRT */
	__le32 rest_time;

	/* Max value that can be reached after SBM */
	__le32 max_rest_time;

	/* SBM */
	__le32 scan_backoff_multiplier;

	/* SCBM */
	__le32 fast_scan_period;

	/* specific to windows */
	__le32 slow_scan_period;

	__le32 no_of_ssids;

	__le32 num_of_channels;

	/* NLO scan start delay time in milliseconds */
	__le32 delay_start_time;

	/** MAC Address to use in Probe Req as SA **/
	struct wmi_mac_addr mac_addr;

	/** Mask on which MAC has to be randomized **/
	struct wmi_mac_addr mac_mask;

	/** IE bitmap to use in Probe Req **/
	__le32 ie_bitmap[8];

	/** Number of vendor OUIs. In the TLV vendor_oui[] **/
	__le32 num_vendor_oui;

	/** Number of connected NLO band preferences **/
	__le32 num_cnlo_band_pref;

	/* The TLVs will follow.
	 * nlo_configured_parameters nlo_list[];
	 * A_UINT32 channel_list[num_of_channels];
	 * nlo_channel_prediction_cfg ch_prediction_cfg;
	 * enlo_candidate_score_params candidate_score_params;
	 * wmi_vendor_oui vendor_oui[num_vendor_oui];
	 * connected_nlo_rssi_params cnlo_rssi_params;
	 * connected_nlo_bss_band_rssi_pref cnlo_bss_band_rssi_pref[num_cnlo_band_pref];
	 */
} __packed;

struct wmi_tlv_mgmt_tx_cmd {
	__le32 vdev_id;
	__le32 desc_id;
	__le32 chanfreq;
	__le64 paddr;
	__le32 frame_len;
	__le32 buf_len;
} __packed;
#endif
