/* SPDX-License-Identifier: GPL-2.0
 *
 * Copyright 2020-2022 HabanaLabs, Ltd.
 * All Rights Reserved.
 *
 */

#ifndef GAUDI2_MASKS_H_
#define GAUDI2_MASKS_H_

#include "../include/gaudi2/asic_reg/gaudi2_regs.h"

/* Useful masks for bits in various registers */
#define QMAN_GLBL_ERR_CFG_MSG_EN_MASK	\
	((0xF << PDMA0_QM_GLBL_ERR_CFG_PQF_ERR_MSG_EN_SHIFT) | \
	(0x1F << PDMA0_QM_GLBL_ERR_CFG_CQF_ERR_MSG_EN_SHIFT) | \
	(0x1F << PDMA0_QM_GLBL_ERR_CFG_CP_ERR_MSG_EN_SHIFT))

#define QMAN_GLBL_ERR_CFG_STOP_ON_ERR_EN_MASK	\
	((0xF << PDMA0_QM_GLBL_ERR_CFG_PQF_STOP_ON_ERR_SHIFT) | \
	(0x1F << PDMA0_QM_GLBL_ERR_CFG_CQF_STOP_ON_ERR_SHIFT) | \
	(0x1F << PDMA0_QM_GLBL_ERR_CFG_CP_STOP_ON_ERR_SHIFT) | \
	(0x1 << PDMA0_QM_GLBL_ERR_CFG_ARB_STOP_ON_ERR_SHIFT))

#define QMAN_GLBL_ERR_CFG1_MSG_EN_MASK	\
	(0x1 << PDMA0_QM_GLBL_ERR_CFG1_CQF_ERR_MSG_EN_SHIFT)

#define QMAN_GLBL_ERR_CFG1_STOP_ON_ERR_EN_MASK	\
	((0x1 << PDMA0_QM_GLBL_ERR_CFG1_CQF_STOP_ON_ERR_SHIFT) | \
	(0x1 << PDMA0_QM_GLBL_ERR_CFG1_ARC_STOP_ON_ERR_SHIFT))

#define QM_PQC_LBW_WDATA	\
	((1 << DCORE0_SYNC_MNGR_OBJS_SOB_OBJ_VAL_SHIFT) | \
	(1 << DCORE0_SYNC_MNGR_OBJS_SOB_OBJ_INC_SHIFT))

#define QMAN_MAKE_TRUSTED	\
	((0xF << PDMA0_QM_GLBL_PROT_PQF_SHIFT) | \
	(0x1 << PDMA0_QM_GLBL_PROT_ERR_SHIFT) | \
	(0x1 << PDMA0_QM_GLBL_PROT_PQC_SHIFT))

#define QMAN_MAKE_TRUSTED_TEST_MODE	\
	((0xF << PDMA0_QM_GLBL_PROT_PQF_SHIFT) | \
	(0xF << PDMA0_QM_GLBL_PROT_CQF_SHIFT) | \
	(0xF << PDMA0_QM_GLBL_PROT_CP_SHIFT) | \
	(0x1 << PDMA0_QM_GLBL_PROT_ERR_SHIFT) | \
	(0x1 << PDMA0_QM_GLBL_PROT_PQC_SHIFT))

#define QMAN_ENABLE		\
	((0xF << PDMA0_QM_GLBL_CFG0_PQF_EN_SHIFT) | \
	(0x1F << PDMA0_QM_GLBL_CFG0_CQF_EN_SHIFT) | \
	(0x1F << PDMA0_QM_GLBL_CFG0_CP_EN_SHIFT)  | \
	(0x1 << PDMA0_QM_GLBL_CFG0_ARC_CQF_EN_SHIFT))

#define PDMA0_QMAN_ENABLE	\
	((0x3 << PDMA0_QM_GLBL_CFG0_PQF_EN_SHIFT) | \
	(0x1F << PDMA0_QM_GLBL_CFG0_CQF_EN_SHIFT) | \
	(0x1F << PDMA0_QM_GLBL_CFG0_CP_EN_SHIFT)  | \
	(0x1 << PDMA0_QM_GLBL_CFG0_ARC_CQF_EN_SHIFT))

#define PDMA1_QMAN_ENABLE	\
	((0x1 << PDMA0_QM_GLBL_CFG0_PQF_EN_SHIFT) | \
	(0x1F << PDMA0_QM_GLBL_CFG0_CQF_EN_SHIFT) | \
	(0x1F << PDMA0_QM_GLBL_CFG0_CP_EN_SHIFT)  | \
	(0x1 << PDMA0_QM_GLBL_CFG0_ARC_CQF_EN_SHIFT))

/* QM_IDLE_MASK is valid for all engines QM idle check */
#define QM_IDLE_MASK	(DCORE0_EDMA0_QM_GLBL_STS0_PQF_IDLE_MASK | \
			DCORE0_EDMA0_QM_GLBL_STS0_CQF_IDLE_MASK | \
			DCORE0_EDMA0_QM_GLBL_STS0_CP_IDLE_MASK)

#define QM_ARC_IDLE_MASK	DCORE0_EDMA0_QM_GLBL_STS1_ARC_CQF_IDLE_MASK

#define MME_ARCH_IDLE_MASK	\
			(DCORE0_MME_CTRL_LO_ARCH_STATUS_SB_IN_EMPTY_MASK | \
			DCORE0_MME_CTRL_LO_ARCH_STATUS_AGU_COUT_SM_IDLE_MASK | \
			DCORE0_MME_CTRL_LO_ARCH_STATUS_WBC_AXI_IDLE_MASK | \
			DCORE0_MME_CTRL_LO_ARCH_STATUS_SB_IN_AXI_IDLE_MASK | \
			DCORE0_MME_CTRL_LO_ARCH_STATUS_QM_IDLE_MASK | \
			DCORE0_MME_CTRL_LO_ARCH_STATUS_QM_RDY_MASK)

#define TPC_IDLE_MASK	(DCORE0_TPC0_CFG_STATUS_SCALAR_PIPE_EMPTY_MASK | \
			DCORE0_TPC0_CFG_STATUS_VECTOR_PIPE_EMPTY_MASK | \
			DCORE0_TPC0_CFG_STATUS_IQ_EMPTY_MASK | \
			DCORE0_TPC0_CFG_STATUS_SB_EMPTY_MASK | \
			DCORE0_TPC0_CFG_STATUS_QM_IDLE_MASK | \
			DCORE0_TPC0_CFG_STATUS_QM_RDY_MASK)

#define DCORE0_TPC0_QM_CGM_STS_AGENT_IDLE_MASK 0x100

/* CGM_IDLE_MASK is valid for all engines CGM idle check */
#define CGM_IDLE_MASK	DCORE0_TPC0_QM_CGM_STS_AGENT_IDLE_MASK

#define QM_GLBL_CFG1_PQF_STOP		PDMA0_QM_GLBL_CFG1_PQF_STOP_MASK
#define QM_GLBL_CFG1_CQF_STOP		PDMA0_QM_GLBL_CFG1_CQF_STOP_MASK
#define QM_GLBL_CFG1_CP_STOP		PDMA0_QM_GLBL_CFG1_CP_STOP_MASK
#define QM_GLBL_CFG1_PQF_FLUSH		PDMA0_QM_GLBL_CFG1_PQF_FLUSH_MASK
#define QM_GLBL_CFG1_CQF_FLUSH		PDMA0_QM_GLBL_CFG1_CQF_FLUSH_MASK
#define QM_GLBL_CFG1_CP_FLUSH		PDMA0_QM_GLBL_CFG1_CP_FLUSH_MASK

#define QM_GLBL_CFG2_ARC_CQF_STOP	PDMA0_QM_GLBL_CFG2_ARC_CQF_STOP_MASK
#define QM_GLBL_CFG2_ARC_CQF_FLUSH	PDMA0_QM_GLBL_CFG2_ARC_CQF_FLUSH_MASK

#define QM_ARB_ERR_MSG_EN_CHOISE_OVF_MASK                            0x1
#define QM_ARB_ERR_MSG_EN_CHOISE_WDT_MASK                            0x2
#define QM_ARB_ERR_MSG_EN_AXI_LBW_ERR_MASK                           0x4

#define QM_ARB_ERR_MSG_EN_MASK		(\
					QM_ARB_ERR_MSG_EN_CHOISE_OVF_MASK |\
					QM_ARB_ERR_MSG_EN_CHOISE_WDT_MASK |\
					QM_ARB_ERR_MSG_EN_AXI_LBW_ERR_MASK)

#define PCIE_AUX_FLR_CTRL_HW_CTRL_MASK		0x1
#define PCIE_AUX_FLR_CTRL_INT_MASK_MASK		0x2

#define MME_ACC_INTR_MASK_WBC_ERR_RESP_MASK		GENMASK(1, 0)
#define MME_ACC_INTR_MASK_AP_SRC_POS_INF_MASK		BIT(2)
#define MME_ACC_INTR_MASK_AP_SRC_NEG_INF_MASK		BIT(3)
#define MME_ACC_INTR_MASK_AP_SRC_NAN_MASK		BIT(4)
#define MME_ACC_INTR_MASK_AP_RESULT_POS_INF_MASK	BIT(5)
#define MME_ACC_INTR_MASK_AP_RESULT_NEG_INF_MASK	BIT(6)

#define SM_CQ_L2H_MASK_VAL		0xFFFFFFFFFC000000ull
#define SM_CQ_L2H_CMPR_VAL		0x1000007FFC000000ull
#define SM_CQ_L2H_LOW_MASK		GENMASK(31, 20)
#define SM_CQ_L2H_LOW_SHIFT		20

#define MMU_STATIC_MULTI_PAGE_SIZE_HOP4_PAGE_SIZE_MASK \
	REG_FIELD_MASK(DCORE0_HMMU0_MMU_STATIC_MULTI_PAGE_SIZE, HOP4_PAGE_SIZE)
#define STLB_HOP_CONFIGURATION_ONLY_LARGE_PAGE_MASK \
	REG_FIELD_MASK(DCORE0_HMMU0_STLB_HOP_CONFIGURATION, ONLY_LARGE_PAGE)

#define AXUSER_HB_SEC_ASID_MASK                0x3FF
#define AXUSER_HB_SEC_MMBP_MASK                0x400

#define MMUBP_ASID_MASK	(AXUSER_HB_SEC_ASID_MASK | AXUSER_HB_SEC_MMBP_MASK)

#define ROT_MSS_HALT_WBC_MASK	BIT(0)
#define ROT_MSS_HALT_RSB_MASK	BIT(1)
#define ROT_MSS_HALT_MRSB_MASK	BIT(2)

#define PCIE_DBI_MSIX_ADDRESS_MATCH_LOW_OFF_MSIX_ADDRESS_MATCH_EN_SHIFT	0
#define PCIE_DBI_MSIX_ADDRESS_MATCH_LOW_OFF_MSIX_ADDRESS_MATCH_EN_MASK	0x1

#define DCORE0_SYNC_MNGR_OBJS_SOB_OBJ_SIGN_SHIFT	15
#define DCORE0_SYNC_MNGR_OBJS_SOB_OBJ_SIGN_MASK		0x8000

#define PCIE_WRAP_PCIE_IC_SEI_INTR_IND_AXI_ERR_INTR_SHIFT		0
#define PCIE_WRAP_PCIE_IC_SEI_INTR_IND_AXI_ERR_INTR_MASK		0x1
#define PCIE_WRAP_PCIE_IC_SEI_INTR_IND_AXI_LBW_ERR_INTR_SHIFT		1
#define PCIE_WRAP_PCIE_IC_SEI_INTR_IND_AXI_LBW_ERR_INTR_MASK		0x2
#define PCIE_WRAP_PCIE_IC_SEI_INTR_IND_BAD_ACCESS_INTR_SHIFT		2
#define PCIE_WRAP_PCIE_IC_SEI_INTR_IND_BAD_ACCESS_INTR_MASK		0x4
#define PCIE_WRAP_PCIE_IC_SEI_INTR_IND_AXI_ERR_INTR_MASK_SHIFT		3
#define PCIE_WRAP_PCIE_IC_SEI_INTR_IND_AXI_ERR_INTR_MASK_MASK		0x8
#define PCIE_WRAP_PCIE_IC_SEI_INTR_IND_AXI_LBW_ERR_INTR_MASK_SHIFT	4
#define PCIE_WRAP_PCIE_IC_SEI_INTR_IND_AXI_LBW_ERR_INTR_MASK_MASK	0x10
#define PCIE_WRAP_PCIE_IC_SEI_INTR_IND_BAD_ACCESS_INTR_MASK_SHIFT	5
#define PCIE_WRAP_PCIE_IC_SEI_INTR_IND_BAD_ACCESS_INTR_MASK_MASK	0x20

#endif /* GAUDI2_MASKS_H_ */
